/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerCockroachDB;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class PostgreRoleManager
extends SQLObjectEditor<PostgreRole, PostgreDatabase> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreRole> getObjectsCache(PostgreRole object) {
        return null;
    }

    protected PostgreRole createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        return new PostgreRole((PostgreDatabase)container, "NewRole", "", true);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        PostgreRole role = (PostgreRole)command.getObject();
        StringBuilder script = new StringBuilder("CREATE ROLE " + DBUtils.getQuotedIdentifier((DBSObject)role));
        this.addRoleOptions(script, role, true);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create role", script.toString()));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        PostgreRole role = (PostgreRole)command.getObject();
        StringBuilder script = new StringBuilder("ALTER ROLE " + DBUtils.getQuotedIdentifier((DBSObject)role));
        this.addRoleOptions(script, role, false);
        actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Alter role", script.toString()));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop role", "DROP ROLE " + DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject()))));
    }

    private void addRoleOptions(StringBuilder script, PostgreRole role, boolean create) {
        PostgreServerExtension extension = role.getDataSource().getServerType();
        StringBuilder options = new StringBuilder();
        if (extension.supportsSuperusers()) {
            if (role.isSuperUser()) {
                options.append(" SUPERUSER");
            } else {
                options.append(" NOSUPERUSER");
            }
        }
        if (extension.supportsRolesWithCreateDBAbility()) {
            if (role.isCreateDatabase()) {
                options.append(" CREATEDB");
            } else {
                options.append(" NOCREATEDB");
            }
        }
        if (role.isCreateRole()) {
            options.append(" CREATEROLE");
        } else {
            options.append(" NOCREATEROLE");
        }
        if (extension.supportsInheritance()) {
            if (role.isInherit()) {
                options.append(" INHERIT");
            } else {
                options.append(" NOINHERIT");
            }
        }
        if (role.isCanLogin()) {
            options.append(" LOGIN");
        } else {
            options.append(" NOLOGIN");
        }
        if (create && role.isUser() && !CommonUtils.isEmpty((String)role.getPassword())) {
            options.append(" PASSWORD ").append("'").append(role.getDataSource().getSQLDialect().escapeString(role.getPassword())).append("'");
        }
        if (options.length() != 0 && extension instanceof PostgreServerCockroachDB) {
            script.append(" WITH");
        }
        script.append((CharSequence)options);
    }
}

