/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraint;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class GreenplumTable
extends PostgreTableRegular {
    private static final Log log = Log.getLog(GreenplumTable.class);
    private int[] distributionColumns;
    private boolean supportsReplicatedDistribution = false;

    public GreenplumTable(PostgreSchema catalog) {
        super(catalog);
    }

    public GreenplumTable(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
        if (catalog.getDataSource().isServerVersionAtLeast(9, 1)) {
            this.supportsReplicatedDistribution = true;
        }
    }

    private List<PostgreTableColumn> getDistributionPolicy(DBRProgressMonitor monitor) throws DBException {
        if (this.distributionColumns == null) {
            try {
                this.distributionColumns = this.readDistributedColumns(monitor);
            }
            catch (Throwable e) {
                log.error((Object)"Error reading distribution policy", e);
            }
            if (this.distributionColumns == null) {
                this.distributionColumns = new int[0];
            }
        }
        if (this.distributionColumns.length == 0) {
            return null;
        }
        ArrayList<PostgreTableColumn> columns = new ArrayList<PostgreTableColumn>(this.distributionColumns.length);
        int i = 0;
        while (i < this.distributionColumns.length) {
            PostgreTableColumn attr = this.getAttributeByPos(monitor, this.distributionColumns[i]);
            if (attr == null) {
                log.debug((Object)("Bad policy attribute position: " + this.distributionColumns[i]));
            } else {
                columns.add(attr);
            }
            ++i;
        }
        return columns;
    }

    private List<PostgreTableColumn> getDistributionTableColumns(DBRProgressMonitor monitor, List<PostgreTableColumn> distributionColumns) throws DBException {
        List pkAttrs;
        PostgreTableConstraint pk = null;
        for (PostgreTableConstraint tc : this.getConstraints(monitor)) {
            if (tc.getConstraintType() != DBSEntityConstraintType.PRIMARY_KEY) continue;
            pk = tc;
            break;
        }
        if (pk != null && !CommonUtils.isEmpty((Collection)(pkAttrs = DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, pk)))) {
            distributionColumns = new ArrayList<PostgreTableColumn>(pkAttrs.size());
            for (DBSEntityAttribute attr : pkAttrs) {
                distributionColumns.add((PostgreTableColumn)attr);
            }
        }
        return distributionColumns;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private int[] readDistributedColumns(DBRProgressMonitor monitor) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean isDistributedByReplicated(DBRProgressMonitor monitor) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void appendTableModifiers(DBRProgressMonitor monitor, StringBuilder ddl) {
        try {
            String partitionData;
            List<PostgreTableColumn> distributionColumns = this.getDistributionPolicy(monitor);
            if (CommonUtils.isEmpty(distributionColumns)) {
                distributionColumns = this.getDistributionTableColumns(monitor, distributionColumns);
            }
            ddl.append("\nDISTRIBUTED ");
            if (CommonUtils.isEmpty(distributionColumns)) {
                ddl.append(this.supportsReplicatedDistribution && this.isPersisted() && this.isDistributedByReplicated(monitor) ? "REPLICATED" : "RANDOMLY");
            } else {
                ddl.append("BY (");
                int i = 0;
                while (i < distributionColumns.size()) {
                    if (i > 0) {
                        ddl.append(", ");
                    }
                    ddl.append(DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)distributionColumns.get(i))));
                    ++i;
                }
                ddl.append(")");
            }
            String string = partitionData = this.isPersisted() ? this.getPartitionData(monitor) : null;
            if (partitionData != null) {
                ddl.append("\n");
                ddl.append(partitionData);
            }
        }
        catch (DBException e) {
            log.error((Object)"Error reading Greenplum table properties", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private String getPartitionData(DBRProgressMonitor monitor) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

