/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.plugins;

import info.dolezel.fatrat.plugins.Plugin;
import info.dolezel.fatrat.plugins.util.FormatUtils;

public abstract class AccountStatusPlugin
extends Plugin {
    public abstract boolean queryAccountBalance();

    protected final native void reportAccountBalance(AccountState var1, String var2);

    protected static long parseSize(String str) {
        return FormatUtils.parseSize(str);
    }

    protected static AccountState adviseState(long bytesLeft) {
        if (bytesLeft < 0L) {
            return AccountState.AccountGood;
        }
        if (bytesLeft < 0x20000000L) {
            return AccountState.AccountBad;
        }
        if (bytesLeft < 0x80000000L) {
            return AccountState.AccountWarning;
        }
        return AccountState.AccountGood;
    }

    protected final void setFailed(String error) {
        this.reportAccountBalance(AccountState.AccountBad, error);
    }

    public static enum AccountState {
        AccountGood,
        AccountWarning,
        AccountBad,
        AccountError;

    }
}

