/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.plugins.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FormatUtils {
    private static final Pattern reFileSize = Pattern.compile("(\\d+[\\d\\.,]+)\\s*(b|ki?b|mi?b|gi?b|ti?b|pi?b)", 2);

    private FormatUtils() {
    }

    public static String formatSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return FormatUtils.singleDecimalDigit((double)bytes / 1024.0) + " KB";
        }
        if (bytes < 0x40000000L) {
            return FormatUtils.singleDecimalDigit((double)bytes / 1024.0 / 1024.0) + " MB";
        }
        return FormatUtils.singleDecimalDigit((double)bytes / 1024.0 / 1024.0 / 1024.0) + " GB";
    }

    public static String singleDecimalDigit(double d) {
        return new DecimalFormat("#.#").format(d);
    }

    public static String formatTime(int seconds) {
        StringBuilder result = new StringBuilder();
        int days = seconds / 86400;
        int hrs = (seconds %= 86400) / 3600;
        int mins = (seconds %= 3600) / 60;
        int secs = seconds % 60;
        if (days > 0) {
            result.append(days).append("d ");
        }
        if (hrs > 0) {
            result.append(hrs).append("h ");
        }
        if (mins > 0) {
            result.append(mins).append("m ");
        }
        if (secs > 0) {
            result.append(secs).append("s ");
        }
        return result.toString();
    }

    public static long parseSize(String str) {
        Matcher m = reFileSize.matcher(str);
        if (!m.find()) {
            return -1L;
        }
        String number = m.group(1).replace(',', '.');
        String unit = m.group(2).toLowerCase().replace("i", "");
        double result = Double.parseDouble(number);
        if (!unit.equals("b")) {
            result = unit.equals("kb") ? (result *= 1024.0) : (unit.equals("mb") ? (result *= 1048576.0) : (unit.equals("gb") ? (result *= 1.073741824E9) : (unit.equals("tb") ? (result *= 1.099511627776E12) : (unit.equals("pb") ? (result *= 1.125899906842624E15) : -1.0))));
        }
        return (long)result;
    }

    public static Pattern getFileSizePattern() {
        return reFileSize;
    }

    public static Map<String, String> parseQueryString(String input) {
        try {
            String[] parts;
            HashMap<String, String> rv = new HashMap<String, String>();
            for (String part : parts = input.split("&")) {
                String[] pair = part.split("=", 2);
                if (pair.length != 2) continue;
                String name = URLDecoder.decode(pair[0], "UTF-8");
                String value = URLDecoder.decode(pair[1], "UTF-8");
                rv.put(name, value);
            }
            return rv;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

