.TH Fotocx 1 2024-06-05 "Linux" "Fotocx man page"

.B NAME
   Fotocx - photo/image editor and collection manager

.B DESCRIPTION
   Organize and manage a large image collection. Edit and optimize photos and 
   other images, edit metadata, search images, and perform batch operations. 
   Fotocx is a GTK GUI application. The included user manual explains Fotocx
   operation in great detail. The following is a summary of capabilities.

.B CAPABILITIES 
 • Organize and manage a very large photo/image collection. 
 • Comprehensive user guide and popup context help via F1 key.
 • Thumbnail browser/navigator with variable thumb size and metadata view.
 • Click thumbnail for full-size view, image zoom in/out and pan/scroll.
 • RAW file conversion, single or batch, output with 8 or 16 bits per color.
 • Large set of functions to edit, repair, refine, and transform images.
 • Internal processing in 24 bits per color (float), output in 8 or 16 bits.
 • Edited files have a version number, originals are retained by default.
 • Fast edit visual feedback using the full image or selected zoom-in area.
 • Undo/Redo button - compare original/edited versions (instant replace). 
 • Conventional edit functions: rotate, upright, crop, rescale, add margins,
   retouch: brightness/color/contrast/saturation/temperature/white balance,
   markup: text (decorative features)/lines/arrows/boxes/circles/ellipses,
   edit colors using RGB or HSL, convert B&W/color/negative/positive/sepia.
 • Repair functions: sharpen, blur selected areas, denoise, defog, red eyes,
   smart erase (remove spoilers), remove halos, suppress JPEG artifacts,
   anti-alias (suppress jaggies), remove dust spots, fix color fringes.
 • Refine functions: edit or flatten brightness distribution (enhance detail),
   increase local contrast (enhance detail), match colors to master image, 
   add soft focus, steepen brightness gradients, global and local retinex,
   add brightness ramp in any direction, add/remove vignette (via curve edit).
 • Special effect conversions: sketch, outlines, cartoon, emboss, painting,
   tiles, texture, pattern, dither (5 modes), engrave, mosaic, shift colors,
   add noise (hide color bands), set no. of colors (per RGB), alien colors.
 • Warp image: unbend (wide-angle photos, panoramas), warp selected area,
   fix perspective (photo from an angle), warp image (linear/curved/affine),
   unwarp closeup (fix baloon face), add waves, twist image, make sphere, 
   turn inside-out, tiny planet, escher spiral, flatten curved horizon,
   flatten photo of curved surface (thick book page, poster on a column).
 • Edit functions can be 'painted' locally and gradually, using the mouse.
 • Copy areas within and across images by mouse painting and blending.
 • Create or maintain transparent image areas while editing.
 • Combine images: HDR (combine bright/dark images, adjust contributions), 
   HDF (combine different focus depths), stack/layer combinations by area,
   panorama (2-6 images), make an array or matrix of many images.
 • Mashup: arrange images and text in an arbitrary layout using the mouse.
   (objects can be resized, rotated, overlapped with transparent areas ...)
 • Custom user menu: collect frequently used functions into one menu.
 • Plugins: use Gimp, Imagemagic ... as embedded Fotocx edit functions.
 • Scripts: record image edits, package as an edit function to re-use.
 • Select image objects or areas to edit separately from the background:
   outline by hand, follow feature edges, 'flood' into matching colors ...
 • Complex feature edges can be accurately selected (e.g. hair, foliage).
 • Batch tools: rename, resize, convert, export, add/revise/report metadata,
   convert RAW files, add overlay text, apply custom edit script.
 • Metadata edit and report (tags, dates, titles, geotags ... any metadata).
 • Search images using any metadata and folder/file names or partial names:
   dates, tags, locations, ratings, titles, descriptions, exposure data ...
 • Show a list of images by location and date range, click for image gallery.
 • Show an image calendar, click on year or month for a gallery of images.
 • Scalable internet map, click on marker for gallery of images at location.
 • Add location names and geocoordinates to an image by clicking on the map.
 • View 360 degree panorama image (Google Street View format).
 • Show video files as thumbnails (using any video frame), play video.
 • Show animated GIF files as thumbnails (first frame), play animation.
 • Bookmarks: assign names to folder/file locations, go to name (gallery).
 • Create albums with chosen images arranged by drag & drop. No duplication.
 • Slide show: show album images with animated transitions and pan/zoom.
 • Print an image at any scale. Printer color calibration tool is available.
 • Custom keyboard shortcuts can be assigned to chosen functions.
 • Cycle wallpaper images from a Fotocx album or any folder of image files.
 • Source and binary packages are installable on most recent Linux flavors.
 • Gnu GPL3 license (everything is free to use as you please). 

.B SEE ALSO
   The User Guide is available from the menu Help > User Guide 
   The home page for Fotocx is at https://kornelix.net

.B AUTHORS
   Written by Mike Cornelison <mkornelix@gmail.com>

