.TH FOTOXX 1 2023-01-01 "Linux" "Fotoxx man page"

.B NAME
   Fotoxx - photo/image editor and collection manager

.B DESCRIPTION
   Organize and manage a large image collection. Edit and optimize photos and 
   other images, edit metadata, search images, and perform batch operations. 
   Fotoxx is a GTK GUI application. The included user manual explains Fotoxx
   operation in great detail. The following is a summary of capabilities.

.B CAPABILITIES 
   • Organize and manage a very large photo/image collection.
   • Thumbnail browser/navigator with variable thumb size and metadata view.
   • Click thumbnail for full-size view, image zoom in/out and pan/scroll.
   • RAW file conversion, single or batch, save with 8 or 16 bits/color.
   • Edit RAW files directly using RawTherapee, Darktable, or Fotoxx.
   • Large set of functions to edit, repair, refine, and transform images. 
   • Internal processing in 24 bits per color (float), output in 8 or 16 bits.
   • Edited files have a version number, originals are retained by default.
   • Fast edit visual feedback using the full image or selected zoom-in area.
   • Undo/Redo edits, go back and forth to compare original and edited versions.
   • Conventional edit functions include: brightness, contrast, color, rotate,
     saturation, crop, resize, sharpen, denoise, blur, paint, fix perspective,
     fix red eyes, markup (text/line/arrow/box/oval), warp/unwarp, panorama, 
     smart erase (remove spoilers), HDR, stack/layer edit, photo montage ...
   • Advanced edit functions to bring out details and add flair to an image:
     Local Contrast, Defog, Retinex, Edit Brightness Dist, Gradients ...
   • A large set of creative special effects and arty transforms:
     sketch, cartoon, drawing, emboss, soft focus, tiles, dither, painting, 
     mosaic, sphere, tiny planet, Escher spiral, custom convolution kernels ...
   • Edit functions can be 'painted' locally and gradually using the mouse.
   • Select image objects or areas to edit separately from the background:
     outline by hand, follow feature edges, 'flood' into matching colors ...
   • Complex feature edges can be accurately selected (e.g. hair, foliage).
   • Copy areas within and across images by mouse painting and blending.
   • Create or maintain transparent image areas while editing. 
   • Mashup: arrange images and text in an arbitrary layout using the mouse.
   • Custom scripts: record a series of edits and use as a new edit function.
   • Custom user menu: collect frequently used functions into one menu.
   • Plugins: use other edit apps (e.g. Gimp) as a plug-in edit function.
   • Batch tools for renaming, resizing, converting, processing RAW files,
     adding/revising/reporting metadata, and executing custom edit scripts.
   • Metadata edit and report (tags, dates, titles, geotags ... any metadata).
   • Search images using any metadata and folder/file names or partial names:
     dates, tags, locations, ratings, titles, descriptions, exposure data ... 
   • Show a table of image locations and date groups, click for image gallery.
   • Show an image calendar, click on year or month for a gallery of images.
   • Click markers on a zoomable internet map for a gallery of images.
   • Use locally stored maps: world, continents, nations, cities, custom maps.
   • View 360 degree panorama image (Google Street View format).
   • Show video files as thumbnails (using desired frame), click to play.
   • Show animated GIF files (first frame) in thumbnails, click to play.
   • Bookmarks: assign names to file locations, list names, click for gallery.
   • Create album gallery with chosen images. Arrange by drag & drop.
   • Slide show: show album images with animated transitions and pan/zoom.
   • Print an image at any scale. Printer color calibration is available.
   • Custom keyboard shortcuts can be assigned to most functions.
   • Cycle wallpaper images from a Fotoxx album or any folder with images.
   • Comprehensive user guide and popup context help via F1 key.

.B SEE ALSO
   The User Guide is available from the menu Help > User Guide 
   The home page for Fotoxx is at https://kornelix.net

.B AUTHORS
   Written by Mike Cornelison <mkornelix@gmail.com>

