.TH FOTOXX 1 2023-08-01 "Linux" "Fotoxx man page"

.B NAME
   Fotoxx - photo/image editor and collection manager

.B DESCRIPTION
   Organize and manage a large image collection. Edit and optimize photos and 
   other images, edit metadata, search images, and perform batch operations. 
   Fotoxx is a GTK GUI application. The included user manual explains Fotoxx
   operation in great detail. The following is a summary of capabilities.

.B CAPABILITIES 
   • Organize and manage a very large photo/image collection.
   • Comprehensive user guide and popup context help via F1 key.
   • Thumbnail browser/navigator with variable thumb size and metadata view.
   • Click thumbnail for full-size view, image zoom in/out and pan/scroll.
   • RAW file conversion, single or batch, save with 8 or 16 bits/color.
   • Large set of functions to edit, repair, refine, and transform images.
   • Internal processing in 24 bits per color (float), output in 8 or 16 bits.
   • Edited files have a version number, originals are retained by default.
   • Fast edit visual feedback using the full image or selected zoom-in area.
   • Undo/Redo button - go back and forth to compare original/edited versions.
   • Conventional edit functions include: brightness, contrast, color, rotate,
     saturation, crop, rescale, sharpen, denoise, blur, paint, fix red eyes,
     markup (text/line/arrow/box/oval), fix perspective, fix lens distortion,
     remove chromatic aberration, warp/unwarp, smart erase (remove spoilers),
     soft focus, match colors, vignette (add/remove), 
     suppress JPEG artifacts, HDR (combine dark/light images), stack/layer edit, 
     panorama (2-6 images), photo montage, convert color profile ...
   • Advanced edit functions to bring out details and add flair to an image:
     Local Contrast, Remove Fog/Haze, Retinex, Edit Distribution, Gradients ...
   • A large set of creative special effects and arty transforms is available:
     sketch, cartoon, drawing, emboss, soft focus, tiles, dither, painting,
     mosaic, engrave, sphere, tiny planet, Escher spiral, custom kernels ...
   • Edit functions can be 'painted' locally and gradually using the mouse.
   • Select image objects or areas to edit separately from the background:
     outline by hand, follow feature edges, 'flood' into matching colors ...
   • Complex feature edges can be accurately selected (e.g. hair, foliage).
   • Copy areas within and across images by mouse painting and blending.
   • Create or maintain transparent image areas while editing.
   • Mashup: arrange images and text in an arbitrary layout using the mouse.
   • Custom scripts: record a series of edits and use as a new edit function.
   • Custom user menu: collect frequently used functions into one menu.
   • Plugins: use plugin apps (e.g. Gimp) like other Fotoxx edit functions.
   • Batch tools for renaming, resizing, converting, processing RAW files,
     adding/revising/reporting metadata, and executing custom edit scripts.
   • Metadata edit and report (tags, dates, titles, geotags ... any metadata).
   • Search images using any metadata and folder/file names or partial names:
     dates, tags, locations, ratings, titles, descriptions, exposure data ...
   • Show a table of image locations and date groups, click for image gallery.
   • Show an image calendar, click on year or month for a gallery of images.
   • Click markers on a scalable internet map for gallery of images at location.
   • Also use local file maps: world, continents, nations, cities, custom maps.
   • View 360 degree panorama image (Google Street View format).
   • Show video files as thumbnails (using desired frame), play video.
   • Show animated GIF files (first frame) in thumbnails, play animation.
   • Bookmarks: assign names to folder/file locations, go to name (gallery).
   • Create albums with chosen images arranged by drag & drop. No duplication.
   • Slide show: show album images with animated transitions and pan/zooms.
   • Print an image at any scale. Printer color calibration tool available.
   • Custom keyboard shortcuts can be assigned to chosen functions.
   • Cycle wallpaper images from a Fotoxx album or any folder of image files.
   • Source and binary packages available, independent of Linux flavor.
   • Gnu GPL3 license (everything is free to use as you please). 

.B SEE ALSO
   The User Guide is available from the menu Help > User Guide 
   The home page for Fotoxx is at https://kornelix.net

.B AUTHORS
   Written by Mike Cornelison <mkornelix@gmail.com>

