%define version 3.1
%define __libtoolize /bin/true

Name:      	gnucash-docs
Summary:   	This is the documentation module for GnuCash
Version:   	%{version}
Release:  	1
License: 	GNU Free Documentation License
Group:     	Applications/Finance
URL:            http://www.gnucash.org
Source:    	http://www.gnucash.org/pub/gnucash/sources/stable/gnucash-docs-%{version}.tar.gz
BuildRoot: 	%{_tmppath}/%{name}-%{version}-root
Requires:  	gnucash >= 1.8.0, scrollkeeper >= 0.3.4
BuildPrereq: 	docbook-style-xsl

%description
GnuCash is a personal finance manager. A check-book like
register GUI allows you to enter and track bank accounts,
stocks, income and even currency trades. The interface is
designed to be simple and easy to use, but is backed with
double-entry accounting principles to ensure balanced books.
This is the documentation module for GnuCash.


%prep
%setup -q

%build
%configure --localstatedir=/var/lib

make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

LIBRARY_PATH=$RPM_BUILD_ROOT%{_libdir}:$RPM_BUILD_ROOT%{_libdir}/gnucash make DESTDIR=$RPM_BUILD_ROOT install

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
if which scrollkeeper-update>/dev/null 2>&1; then scrollkeeper-update -o %{_datadir}/omf/gnucash-docs; fi

%postun
if which scrollkeeper-update>/dev/null 2>&1; then scrollkeeper-update; fi

%files
%defattr(444,root,root,755)
%{_datadir}/gnome/help/gnucash
%{_datadir}/omf/gnucash-docs
%doc AUTHORS COPYING-DOCS ChangeLog NEWS README HACKING
