#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXArray.h"
#include "FXHash.h"
#include "FXStream.h"
#include "FXTextCodec.h"
#include "FXCP852Codec.h"

namespace FX {

FXIMPLEMENT(FXCP852Codec,FXTextCodec,NULL,0)


//// Created by codec tool on 03/25/2005 from: CP852.TXT ////
static const unsigned short forward_data[256]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   199,  252,  233,  226,  228,  367,  263,  231,  322,  235,  336,  337,  238,  377,  196,  262,
   201,  313,  314,  244,  246,  317,  318,  346,  347,  214,  220,  356,  357,  321,  215,  269,
   225,  237,  243,  250,  260,  261,  381,  382,  280,  281,  172,  378,  268,  351,  171,  187,
   9617, 9618, 9619, 9474, 9508, 193,  194,  282,  350,  9571, 9553, 9559, 9565, 379,  380,  9488,
   9492, 9524, 9516, 9500, 9472, 9532, 258,  259,  9562, 9556, 9577, 9574, 9568, 9552, 9580, 164,
   273,  272,  270,  203,  271,  327,  205,  206,  283,  9496, 9484, 9608, 9604, 354,  366,  9600,
   211,  223,  212,  323,  324,  328,  352,  353,  340,  218,  341,  368,  253,  221,  355,  180,
   173,  733,  731,  711,  728,  167,  247,  184,  176,  168,  729,  369,  344,  345,  9632, 160,
  };


static const unsigned char reverse_plane[17]={
  0, 10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
  };

static const unsigned char reverse_pages[74]={
  0,  46, 46, 46, 46, 46, 46, 46, 46, 94, 46, 46, 46, 46, 46, 46,
  46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  46, 46, 46, 46, 46, 46, 46, 46, 46, 46,
  };

static const unsigned short reverse_block[158]={
  0,   16,  32,  48,  64,  80,  96,  112, 128, 128, 144, 160, 175, 190, 206, 221,
  235, 251, 128, 263, 278, 294, 310, 326, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 341, 349, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 365, 381,
  394, 407, 128, 423, 439, 128, 455, 470, 486, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  };

static const unsigned char reverse_data[502]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   255,  26,   26,   26,   207,  26,   26,   245,  249,  26,   26,   174,  170,  240,  26,   26,
   248,  26,   26,   26,   239,  26,   26,   26,   247,  26,   26,   175,  26,   26,   26,   26,
   181,  182,  26,   142,  26,   26,   128,  26,   144,  26,   211,  26,   214,  215,  26,   26,
   26,   224,  226,  26,   153,  158,  26,   26,   233,  26,   154,  237,  26,   225,  26,   160,
   131,  26,   132,  26,   26,   135,  26,   130,  26,   137,  26,   161,  140,  26,   26,   26,
   162,  147,  26,   148,  246,  26,   26,   163,  26,   129,  236,  26,   26,   198,  199,  164,
   165,  143,  134,  26,   26,   26,   26,   172,  159,  210,  212,  209,  208,  26,   26,   26,
   26,   26,   26,   168,  169,  183,  216,  26,   26,   26,   26,   26,   26,   26,   26,   26,
   145,  146,  26,   26,   149,  150,  26,   157,  136,  227,  228,  26,   26,   213,  229,  26,
   26,   26,   26,   26,   26,   26,   138,  139,  26,   26,   232,  234,  26,   26,   252,  253,
   151,  152,  26,   26,   184,  173,  230,  231,  221,  238,  155,  156,  26,   26,   26,   26,
   26,   26,   26,   26,   222,  133,  235,  251,  26,   26,   26,   26,   26,   26,   26,   141,
   171,  189,  190,  166,  167,  26,   26,   26,   26,   26,   26,   26,   243,  26,   26,   26,
   26,   26,   26,   26,   26,   244,  250,  26,   242,  26,   241,  26,   26,   196,  26,   179,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   218,  26,   26,   26,   191,  26,   26,
   26,   192,  26,   26,   26,   217,  26,   26,   26,   195,  26,   26,   26,   26,   180,  26,
   26,   26,   26,   26,   26,   26,   194,  26,   26,   26,   26,   193,  26,   26,   26,   26,
   26,   26,   26,   197,  26,   26,   26,   205,  186,  26,   26,   201,  26,   26,   187,  26,
   26,   200,  26,   26,   188,  26,   26,   204,  26,   26,   185,  26,   26,   203,  26,   26,
   202,  26,   26,   206,  26,   26,   26,   223,  26,   26,   26,   220,  26,   26,   26,   219,
   26,   26,   26,   26,   26,   26,   26,   176,  177,  178,  26,   26,   26,   26,   26,   26,
   26,   26,   26,   26,   26,   26,   254,  26,   26,   26,   26,   26,   26,   26,   26,   26,
   26,   26,   26,   26,   26,   26,
  };


FXint FXCP852Codec::mb2wc(FXwchar& wc,const FXchar* src,FXint nsrc) const {
  if(nsrc<1) return -1;
  wc=forward_data[(FXuchar)src[0]];
  return 1;
  }


FXint FXCP852Codec::wc2mb(FXchar* dst,FXint ndst,FXwchar wc) const {
  if(ndst<1) return -1;
  dst[0]=reverse_data[reverse_block[reverse_pages[reverse_plane[wc>>16]+((wc>>10)&63)]+((wc>>4)&63)]+(wc&15)];
  return 1;
  }

FXint FXCP852Codec::mibEnum() const {
  return 2010;
  }


const FXchar* FXCP852Codec::name() const {
  return "IBM852";
  }


const FXchar* FXCP852Codec::mimeName() const {
  return "IBM852";
  }


const FXchar* const* FXCP852Codec::aliases() const {
  static const FXchar *const list[]={"microsoft-cp852","IBM852","cp852","852","csPCp852","microsoft-cp852",NULL};
  return list;
  }

}

