/* Generated automatically with "cito". Do not edit. */
#include <stdlib.h>
#include <string.h>
#include "recoil.h"
typedef struct A4rStream A4rStream;
typedef struct AmstradStream AmstradStream;

typedef enum {
	AnticMode_BLANK,
	AnticMode_FOUR_COLOR,
	AnticMode_FIVE_COLOR,
	AnticMode_HI_RES
}
AnticMode;
typedef struct BbgStream BbgStream;
typedef struct BitStream BitStream;
typedef struct BlazingPaddlesBoundingBox BlazingPaddlesBoundingBox;
typedef struct BldStream BldStream;
typedef struct C64KoalaStream C64KoalaStream;
typedef struct CaStream CaStream;
typedef struct CciStream CciStream;
typedef struct CmpStream CmpStream;
typedef struct CpiStream CpiStream;
typedef struct CtblPalette CtblPalette;
typedef struct DaliStream DaliStream;
typedef struct DeepStream DeepStream;
typedef struct DrpStream DrpStream;
typedef struct EndianStream EndianStream;
typedef struct FanoTree FanoTree;
typedef struct G2fRenderer G2fRenderer;
typedef struct GedRenderer GedRenderer;
typedef struct GoDotStream GoDotStream;
typedef struct GtiaRenderer GtiaRenderer;
typedef struct HcmRenderer HcmRenderer;
typedef struct HimStream HimStream;
typedef struct HpmStream HpmStream;
typedef struct IcStream IcStream;
typedef struct Ice21Stream Ice21Stream;

typedef enum {
	IceFrameMode_GR0,
	IceFrameMode_GR0_GTIA9,
	IceFrameMode_GR0_GTIA10,
	IceFrameMode_GR0_GTIA11,
	IceFrameMode_GR12,
	IceFrameMode_GR12_GTIA9,
	IceFrameMode_GR12_GTIA10,
	IceFrameMode_GR12_GTIA11,
	IceFrameMode_GR13_GTIA9,
	IceFrameMode_GR13_GTIA10,
	IceFrameMode_GR13_GTIA11
}
IceFrameMode;
typedef struct IcnParser IcnParser;

typedef enum {
	IffType_ILBM,
	IffType_PBM,
	IffType_ACBM,
	IffType_RGB8,
	IffType_RGBN
}
IffType;
typedef struct ImgStream ImgStream;
typedef struct InflateStream InflateStream;
typedef struct Lz4Stream Lz4Stream;
typedef struct MchRenderer MchRenderer;
typedef struct MppPaletteStream MppPaletteStream;
typedef struct MspStream MspStream;
typedef struct MultiPalette MultiPalette;
typedef struct PInterpreter PInterpreter;
typedef struct PacStream PacStream;
typedef struct PackBitsStream PackBitsStream;
typedef struct PchgPalette PchgPalette;
typedef struct PcsStream PcsStream;
typedef struct PgcStream PgcStream;
typedef struct PgrRenderer PgrRenderer;
typedef struct Q4Stream Q4Stream;

/**
 * Platform and pixel ratio.
 */
typedef enum {
	RECOILResolution_AMIGA1X1,
	RECOILResolution_AMIGA2X1,
	RECOILResolution_AMIGA4X1,
	RECOILResolution_AMIGA8X1,
	RECOILResolution_AMIGA1X2,
	RECOILResolution_AMIGA1X4,
	RECOILResolution_AMSTRAD1X1,
	RECOILResolution_AMSTRAD2X1,
	RECOILResolution_AMSTRAD1X2,
	RECOILResolution_APPLE_I_I1X1,
	RECOILResolution_APPLE_I_IE1X2,
	RECOILResolution_APPLE_I_I_G_S1X1,
	RECOILResolution_MACINTOSH1X1,
	RECOILResolution_XE1X1,
	RECOILResolution_XE2X1,
	RECOILResolution_XE4X1,
	RECOILResolution_XE2X2,
	RECOILResolution_XE4X2,
	RECOILResolution_XE4X4,
	RECOILResolution_XE8X8,
	RECOILResolution_PORTFOLIO1X1,
	RECOILResolution_ST1X1,
	RECOILResolution_ST1X2,
	RECOILResolution_STE1X1,
	RECOILResolution_STE1X2,
	RECOILResolution_TT1X1,
	RECOILResolution_TT2X1,
	RECOILResolution_FALCON1X1,
	RECOILResolution_FALCON2X1,
	RECOILResolution_BBC1X1,
	RECOILResolution_BBC2X1,
	RECOILResolution_BBC1X2,
	RECOILResolution_C161X1,
	RECOILResolution_C162X1,
	RECOILResolution_C641X1,
	RECOILResolution_C642X1,
	RECOILResolution_C1281X1,
	RECOILResolution_MSX11X1,
	RECOILResolution_MSX14X4,
	RECOILResolution_MSX21X1,
	RECOILResolution_MSX22X1,
	RECOILResolution_MSX21X2,
	RECOILResolution_MSX2_PLUS1X1,
	RECOILResolution_MSX2_PLUS2X1,
	RECOILResolution_ORIC1X1,
	RECOILResolution_PC1X1,
	RECOILResolution_PC881X2,
	RECOILResolution_PC981X1,
	RECOILResolution_PLAY_STATION1X1,
	RECOILResolution_SAM_COUPE1X1,
	RECOILResolution_X68_K1X1,
	RECOILResolution_SPECTRUM1X1,
	RECOILResolution_TIMEX1X1,
	RECOILResolution_TIMEX1X2,
	RECOILResolution_TRS1X1,
	RECOILResolution_TRS1X2,
	RECOILResolution_COCO1X1,
	RECOILResolution_COCO2X2,
	RECOILResolution_ZX811X1
}
RECOILResolution;
typedef struct RastPalette RastPalette;
typedef struct RecentInts RecentInts;
typedef struct RgbStream RgbStream;
typedef struct RleStream RleStream;
typedef struct ScStream ScStream;
typedef struct ShamLacePalette ShamLacePalette;
typedef struct SpcStream SpcStream;
typedef struct SprStream SprStream;
typedef struct SpsStream SpsStream;
typedef struct SpxStream SpxStream;
typedef struct SrStream SrStream;
typedef struct Stream Stream;
typedef struct TnyPcsStream TnyPcsStream;
typedef struct TnyStream TnyStream;
typedef struct Tre1Stream Tre1Stream;
typedef struct VdatStream VdatStream;
typedef struct X68KPicStream X68KPicStream;
typedef struct XeKoalaStream XeKoalaStream;
typedef struct XlpStream XlpStream;
typedef struct ZxpStream ZxpStream;

struct Stream {
	int contentLength;
	int contentOffset;
	unsigned char const *content;
};
static int Stream_ParseInt(Stream *self);
static int Stream_ReadByte(Stream *self);
static cibool Stream_ReadBytes(Stream *self, unsigned char *dest, int destOffset, int count);
static int Stream_ReadHexDigit(Stream *self);

struct A4rStream {
	Stream base;
	int innerFlags;
	int outerFlags;
	int unpackedOffset;
	unsigned char unpacked[11248];
};
static void A4rStream_Construct(A4rStream *self);
static cibool A4rStream_CopyBlock(A4rStream *self, int distance, int count);
static cibool A4rStream_CopyByte(A4rStream *self);
static int A4rStream_ReadFlag(A4rStream *self);
static cibool A4rStream_UnpackA4r(A4rStream *self);

struct BitStream {
	Stream base;
	int bits;
};
static void BitStream_Construct(BitStream *self);
static int BitStream_ReadBit(BitStream *self);
static int BitStream_ReadBits(BitStream *self, int count);

typedef struct {
	cibool (*readCommand)(RleStream *self);
	int (*readValue)(RleStream *self);
}
RleStreamVtbl;
struct RleStream {
	BitStream base;
	const RleStreamVtbl *vtbl;
	/**
	 * Block length.
	 */
	int repeatCount;
	/**
	 * Value for an RLE block, -1 for a block of literals.
	 */
	int repeatValue;
};
static void RleStream_Construct(RleStream *self, const RleStreamVtbl *vtbl);
static int RleStream_ReadRle(RleStream *self);
static int RleStream_ReadValue(RleStream *self);
static cibool RleStream_Unpack(RleStream *self, unsigned char *unpacked, int unpackedOffset, int unpackedStride, int unpackedEnd);
static cibool RleStream_UnpackC64(RleStream *self, unsigned char *unpacked, int unpackedLength);
static cibool RleStream_UnpackColumns(RleStream *self, unsigned char *unpacked, int unpackedOffset, int unpackedStride, int unpackedEnd);
static cibool RleStream_UnpackWords(RleStream *self, unsigned char *unpacked, int unpackedOffset, int unpackedStride, int unpackedEnd);

struct AmstradStream {
	RleStream base;
	int blockLength;
};
static void AmstradStream_Construct(AmstradStream *self, const RleStreamVtbl *vtbl);
static cibool AmstradStream_ReadCommand(AmstradStream *self);
static cibool AmstradStream_UnpackFile(unsigned char const *content, int contentOffset, int contentLength, unsigned char *unpacked, int unpackedLength);
static const RleStreamVtbl CiVtbl_AmstradStream = {
	(cibool (*)(RleStream *self)) AmstradStream_ReadCommand,
	RleStream_ReadValue
};

struct BbgStream {
	RleStream base;
	int countBits;
	int valueBits;
};
static void BbgStream_Construct(BbgStream *self, const RleStreamVtbl *vtbl);
static int BbgStream_ReadBitsReverse(BbgStream *self, int count);
static cibool BbgStream_ReadCommand(BbgStream *self);
static const RleStreamVtbl CiVtbl_BbgStream = {
	(cibool (*)(RleStream *self)) BbgStream_ReadCommand,
	RleStream_ReadValue
};

struct BlazingPaddlesBoundingBox {
	int bottom;
	int left;
	int right;
	int top;
};
static cibool BlazingPaddlesBoundingBox_Calculate(BlazingPaddlesBoundingBox *self, unsigned char const *content, int contentLength, int index, int startAddress);

struct BldStream {
	RleStream base;
};
static void BldStream_Construct(BldStream *self, const RleStreamVtbl *vtbl);
static cibool BldStream_ReadCommand(BldStream *self);
static const RleStreamVtbl CiVtbl_BldStream = {
	(cibool (*)(RleStream *self)) BldStream_ReadCommand,
	RleStream_ReadValue
};

struct C64KoalaStream {
	RleStream base;
};
static void C64KoalaStream_Construct(C64KoalaStream *self, const RleStreamVtbl *vtbl);
static cibool C64KoalaStream_ReadCommand(C64KoalaStream *self);
static const RleStreamVtbl CiVtbl_C64KoalaStream = {
	(cibool (*)(RleStream *self)) C64KoalaStream_ReadCommand,
	RleStream_ReadValue
};

struct CaStream {
	RleStream base;
	int defaultValue;
	int escapeByte;
};
static void CaStream_Construct(CaStream *self, const RleStreamVtbl *vtbl);
static cibool CaStream_ReadCommand(CaStream *self);
static cibool CaStream_UnpackCa(CaStream *self, unsigned char *unpacked, int unpackedOffset);
static cibool CaStream_UnpackDel(unsigned char const *content, int contentLength, unsigned char *unpacked, int blocks);
static const RleStreamVtbl CiVtbl_CaStream = {
	(cibool (*)(RleStream *self)) CaStream_ReadCommand,
	RleStream_ReadValue
};

struct CciStream {
	RleStream base;
};
static void CciStream_Construct(CciStream *self, const RleStreamVtbl *vtbl);
static cibool CciStream_ReadCommand(CciStream *self);
static cibool CciStream_UnpackGr15(CciStream *self, unsigned char *unpacked, int unpackedOffset);
static const RleStreamVtbl CiVtbl_CciStream = {
	(cibool (*)(RleStream *self)) CciStream_ReadCommand,
	RleStream_ReadValue
};

struct CmpStream {
	RleStream base;
};
static void CmpStream_Construct(CmpStream *self, const RleStreamVtbl *vtbl);
static cibool CmpStream_ReadCommand(CmpStream *self);
static const RleStreamVtbl CiVtbl_CmpStream = {
	(cibool (*)(RleStream *self)) CmpStream_ReadCommand,
	RleStream_ReadValue
};

struct CpiStream {
	RleStream base;
};
static void CpiStream_Construct(CpiStream *self, const RleStreamVtbl *vtbl);
static cibool CpiStream_ReadCommand(CpiStream *self);
static const RleStreamVtbl CiVtbl_CpiStream = {
	(cibool (*)(RleStream *self)) CpiStream_ReadCommand,
	RleStream_ReadValue
};

typedef struct {
	void (*setLinePalette)(MultiPalette *self, RECOIL const *recoil, int y);
}
MultiPaletteVtbl;
struct MultiPalette {
	BitStream base;
	const MultiPaletteVtbl *vtbl;
};
static void MultiPalette_Construct(MultiPalette *self, const MultiPaletteVtbl *vtbl);
static int MultiPalette_GetOcsColor(int r, int gb);
static void MultiPalette_SetLinePalette(MultiPalette *self, RECOIL const *recoil, int y);
static void MultiPalette_SetOcsPalette(MultiPalette const *self, RECOIL *recoil, int contentOffset, int colors);
static const MultiPaletteVtbl CiVtbl_MultiPalette = {
	MultiPalette_SetLinePalette
};

struct CtblPalette {
	MultiPalette base;
	int colors;
};
static void CtblPalette_Construct(CtblPalette *self, const MultiPaletteVtbl *vtbl);
static void CtblPalette_SetLinePalette(CtblPalette const *self, RECOIL *recoil, int y);
static const MultiPaletteVtbl CiVtbl_CtblPalette = {
	(void (*)(MultiPalette *self, RECOIL const *recoil, int y)) CtblPalette_SetLinePalette
};

struct DaliStream {
	Stream base;
};
static cibool DaliStream_Decode(DaliStream *self, int countLength, RECOIL *recoil, int paletteOffset, int mode);

struct PackBitsStream {
	RleStream base;
};
static void PackBitsStream_Construct(PackBitsStream *self, const RleStreamVtbl *vtbl);
static cibool PackBitsStream_ReadCommand(PackBitsStream *self);
static cibool PackBitsStream_UnpackBitplaneLines(PackBitsStream *self, unsigned char *unpacked, int width, int height, int bitplanes, cibool compressed, cibool hasMask);
static const RleStreamVtbl CiVtbl_PackBitsStream = {
	(cibool (*)(RleStream *self)) PackBitsStream_ReadCommand,
	RleStream_ReadValue
};

struct DeepStream {
	PackBitsStream base;
	int components;
	int currentByte;
	int componentShift[6];
	int line[2048];
};
static void DeepStream_Construct(DeepStream *self, const RleStreamVtbl *vtbl);
static cibool DeepStream_ReadDeltaLine(DeepStream *self, int width, int tvdcOffset);
static int DeepStream_ReadNibble(DeepStream *self);
static int DeepStream_ReadValue(DeepStream *self);
static cibool DeepStream_SetDpel(DeepStream *self, int chunkOffset, int chunkLength);
static const RleStreamVtbl CiVtbl_DeepStream = {
	(cibool (*)(RleStream *self)) PackBitsStream_ReadCommand,
	(int (*)(RleStream *self)) DeepStream_ReadValue
};

struct DrpStream {
	RleStream base;
	int escape;
};
static void DrpStream_Construct(DrpStream *self, const RleStreamVtbl *vtbl);
static cibool DrpStream_ReadCommand(DrpStream *self);
static unsigned char const *DrpStream_UnpackFile(unsigned char const *content, int contentLength, const char *signature, unsigned char *unpacked, int unpackedLength);
static const RleStreamVtbl CiVtbl_DrpStream = {
	(cibool (*)(RleStream *self)) DrpStream_ReadCommand,
	RleStream_ReadValue
};

struct EndianStream {
	Stream base;
	cibool bigEndian;
};
static int EndianStream_ReadInt(EndianStream *self);
static int EndianStream_ReadWord(EndianStream *self);

struct FanoTree {
	/**
	 * Count[n] == number of codes of bit length n.
	 */
	int count[16];
	/**
	 * Values sorted by code length.
	 */
	unsigned char values[256];
};
static void FanoTree_Create(FanoTree *self, unsigned char const *content, int contentOffset, int codeCount);
static int FanoTree_ReadCode(FanoTree const *self, BitStream *bitStream);

typedef struct {
	int (*getPlayfieldByte)(GtiaRenderer *self, int y, int column);
}
GtiaRendererVtbl;
struct GtiaRenderer {
	const GtiaRendererVtbl *vtbl;
	int missileGraphics;
	unsigned char missileHpos[4];
	int missileShiftRegister;
	unsigned char missileSize[4];
	unsigned char playerGraphics[4];
	unsigned char playerHpos[4];
	unsigned char playerShiftRegister[4];
	unsigned char playerSize[4];
	int playfieldColumns;
	int prior;
	unsigned char const *content;
	unsigned char colors[9];
	int missileSizeCounter[4];
	int playerSizeCounter[4];
};
static void GtiaRenderer_Construct(GtiaRenderer *self, const GtiaRendererVtbl *vtbl);
static int GtiaRenderer_DrawSpan(GtiaRenderer *self, int y, int hpos, int untilHpos, AnticMode anticMode, unsigned char *frame, int width);
static int GtiaRenderer_GetColor(GtiaRenderer const *self, int objects);
static int GtiaRenderer_GetPmg(GtiaRenderer *self, int hpos, int objects);
static void GtiaRenderer_Poke(GtiaRenderer *self, int addr, int value);
static void GtiaRenderer_ProcessSpriteDma(GtiaRenderer *self, unsigned char const *content, int missileOffset);
static void GtiaRenderer_SetG2fColors(GtiaRenderer *self, int contentOffset, int contentStride, int count, int gtiaMode);
static void GtiaRenderer_SetPlayerSize(GtiaRenderer *self, int i, int size);
static void GtiaRenderer_SetSpriteSizes(unsigned char *sizes, int value);
static void GtiaRenderer_StartLine(GtiaRenderer *self, int startHpos);

struct G2fRenderer {
	GtiaRenderer base;
	int fontOffset;
	int inverse2Offset;
};
static void G2fRenderer_Construct(G2fRenderer *self, const GtiaRendererVtbl *vtbl);
static int G2fRenderer_GetPlayfieldByte(G2fRenderer const *self, int y, int column);
static cibool G2fRenderer_SetSprite(unsigned char *hpos, unsigned char *sizes, int i, unsigned char const *content, int spriteOffset);
static const GtiaRendererVtbl CiVtbl_G2fRenderer = {
	(int (*)(GtiaRenderer *self, int y, int column)) G2fRenderer_GetPlayfieldByte
};

struct GedRenderer {
	GtiaRenderer base;
};
static void GedRenderer_Construct(GedRenderer *self, const GtiaRendererVtbl *vtbl);
static int GedRenderer_GetPlayfieldByte(GedRenderer const *self, int y, int column);
static const GtiaRendererVtbl CiVtbl_GedRenderer = {
	(int (*)(GtiaRenderer *self, int y, int column)) GedRenderer_GetPlayfieldByte
};

struct GoDotStream {
	RleStream base;
};
static void GoDotStream_Construct(GoDotStream *self, const RleStreamVtbl *vtbl);
static cibool GoDotStream_ReadCommand(GoDotStream *self);
static const RleStreamVtbl CiVtbl_GoDotStream = {
	(cibool (*)(RleStream *self)) GoDotStream_ReadCommand,
	RleStream_ReadValue
};

struct HcmRenderer {
	GtiaRenderer base;
};
static void HcmRenderer_Construct(HcmRenderer *self, const GtiaRendererVtbl *vtbl);
static int HcmRenderer_GetPlayfieldByte(HcmRenderer const *self, int y, int column);
static const GtiaRendererVtbl CiVtbl_HcmRenderer = {
	(int (*)(GtiaRenderer *self, int y, int column)) HcmRenderer_GetPlayfieldByte
};

struct HimStream {
	RleStream base;
};
static void HimStream_Construct(HimStream *self, const RleStreamVtbl *vtbl);
static cibool HimStream_ReadCommand(HimStream *self);
static int HimStream_ReadValue(HimStream *self);
static const RleStreamVtbl CiVtbl_HimStream = {
	(cibool (*)(RleStream *self)) HimStream_ReadCommand,
	(int (*)(RleStream *self)) HimStream_ReadValue
};

struct HpmStream {
	RleStream base;
};
static void HpmStream_Construct(HpmStream *self, const RleStreamVtbl *vtbl);
static cibool HpmStream_ReadCommand(HpmStream *self);
static const RleStreamVtbl CiVtbl_HpmStream = {
	(cibool (*)(RleStream *self)) HpmStream_ReadCommand,
	RleStream_ReadValue
};

struct IcStream {
	RleStream base;
};
static void IcStream_Construct(IcStream *self, const RleStreamVtbl *vtbl);
static cibool IcStream_ReadCommand(IcStream *self);
static cibool IcStream_ReadCount(IcStream *self);
static const RleStreamVtbl CiVtbl_IcStream = {
	(cibool (*)(RleStream *self)) IcStream_ReadCommand,
	RleStream_ReadValue
};

struct Ice21Stream {
	int bits;
	int contentOffset;
	int contentStart;
	unsigned char const *content;
};
static int Ice21Stream_CountOnes(Ice21Stream *self, int max);
static int Ice21Stream_GetUnpackedLength(Ice21Stream const *self);
static int Ice21Stream_ReadBit(Ice21Stream *self);
static int Ice21Stream_ReadBits(Ice21Stream *self, int count);
static int Ice21Stream_ReadEncoded(Ice21Stream *self, int maxCount, unsigned char const *extraBits, int const *offsets);
static int Ice21Stream_ReadLiteralLength(Ice21Stream *self);
static cibool Ice21Stream_Unpack(Ice21Stream *self, unsigned char *unpacked, int unpackedStart, int unpackedEnd);

struct IcnParser {
	Stream base;
};
static cibool IcnParser_Expect(IcnParser *self, const char *s);
static int IcnParser_ParseDefine(IcnParser *self, const char *s);
static int IcnParser_ParseHex(IcnParser *self);
static cibool IcnParser_SkipWhitespace(IcnParser *self);

struct ImgStream {
	RleStream base;
	int patternRepeatCount;
};
static void ImgStream_Construct(ImgStream *self, const RleStreamVtbl *vtbl);
static int ImgStream_GetLineRepeatCount(ImgStream *self);
static cibool ImgStream_ReadCommand(ImgStream *self);
static const RleStreamVtbl CiVtbl_ImgStream = {
	(cibool (*)(RleStream *self)) ImgStream_ReadCommand,
	RleStream_ReadValue
};

struct InflateStream {
	Stream base;
	int bits;
	int nBitCodeCount[32];
	int nBitCodeOffset[32];
	unsigned char symbolCodeLength[318];
	int codeToSymbol[318];
};
static void InflateStream_BuildHuffmanTrees(InflateStream *self);
static int InflateStream_FetchCode(InflateStream *self, int tree);
static int InflateStream_Inflate(InflateStream *self, unsigned char *unpacked, int unpackedLength);
static int InflateStream_ReadBit(InflateStream *self);
static int InflateStream_ReadBits(InflateStream *self, int count);
static int InflateStream_Uncompress(InflateStream *self, unsigned char *unpacked, int unpackedLength);

struct Lz4Stream {
	Stream base;
	int unpackedLength;
	int unpackedOffset;
	unsigned char *unpacked;
};
static cibool Lz4Stream_Copy(Lz4Stream *self, int count);
static int Lz4Stream_ReadCount(Lz4Stream *self, int count);

struct MchRenderer {
	GtiaRenderer base;
	cibool dliPlus;
};
static void MchRenderer_Construct(MchRenderer *self, const GtiaRendererVtbl *vtbl);
static int MchRenderer_GetPlayfieldByte(MchRenderer const *self, int y, int column);
static const GtiaRendererVtbl CiVtbl_MchRenderer = {
	(int (*)(GtiaRenderer *self, int y, int column)) MchRenderer_GetPlayfieldByte
};

struct MppPaletteStream {
	BitStream base;
};
static void MppPaletteStream_Construct(MppPaletteStream *self);
static int MppPaletteStream_Read(MppPaletteStream *self);

struct MspStream {
	RleStream base;
};
static void MspStream_Construct(MspStream *self, const RleStreamVtbl *vtbl);
static cibool MspStream_ReadCommand(MspStream *self);
static const RleStreamVtbl CiVtbl_MspStream = {
	(cibool (*)(RleStream *self)) MspStream_ReadCommand,
	RleStream_ReadValue
};

struct PInterpreter {
	Stream base;
	int bottomCode;
	int bottomOffset;
	cibool newLineWorks;
	int screenOffset;
	unsigned char screen[768];
};
static cibool PInterpreter_DPeek(PInterpreter *self, int expectedX, int expectedAddress);
static cibool PInterpreter_DoFor(PInterpreter *self);
static cibool PInterpreter_DoIf(PInterpreter *self);
static cibool PInterpreter_Let(PInterpreter *self);
static cibool PInterpreter_Next(PInterpreter *self);
static cibool PInterpreter_Poke(PInterpreter *self);
static cibool PInterpreter_Print(PInterpreter *self);
static int PInterpreter_PrintString(PInterpreter *self, int offset);
static int PInterpreter_ReadNumber(PInterpreter *self);
static cibool PInterpreter_Run(PInterpreter *self);

struct PacStream {
	RleStream base;
};
static void PacStream_Construct(PacStream *self, const RleStreamVtbl *vtbl);
static cibool PacStream_ReadCommand(PacStream *self);
static const RleStreamVtbl CiVtbl_PacStream = {
	(cibool (*)(RleStream *self)) PacStream_ReadCommand,
	RleStream_ReadValue
};

struct PchgPalette {
	MultiPalette base;
	cibool compressed;
	int lineCount;
	cibool ocs;
	int startLine;
	int treeLastOffset;
	int treeOffset;
	unsigned char havePaletteChange[232];
};
static void PchgPalette_Construct(PchgPalette *self, const MultiPaletteVtbl *vtbl);
static cibool PchgPalette_Init(PchgPalette *self);
static int PchgPalette_ReadHuffman(PchgPalette *self);
static void PchgPalette_SetLinePalette(PchgPalette *self, RECOIL *recoil, int y);
static void PchgPalette_SetOcsColors(PchgPalette *self, RECOIL *recoil, int paletteOffset, int count);
static int PchgPalette_UnpackByte(PchgPalette *self);
static const MultiPaletteVtbl CiVtbl_PchgPalette = {
	(void (*)(MultiPalette *self, RECOIL const *recoil, int y)) PchgPalette_SetLinePalette
};

struct TnyPcsStream {
	RleStream base;
};
static void TnyPcsStream_Construct(TnyPcsStream *self, const RleStreamVtbl *vtbl);
static cibool TnyPcsStream_ReadCommand(TnyPcsStream *self);
static const RleStreamVtbl CiVtbl_TnyPcsStream = {
	(cibool (*)(RleStream *self)) TnyPcsStream_ReadCommand,
	RleStream_ReadValue
};

struct PcsStream {
	TnyPcsStream base;
	cibool palette;
};
static void PcsStream_Construct(PcsStream *self, const RleStreamVtbl *vtbl);
static int PcsStream_ReadValue(PcsStream *self);
static cibool PcsStream_UnpackPcs(PcsStream *self, unsigned char *unpacked);
static const RleStreamVtbl CiVtbl_PcsStream = {
	(cibool (*)(RleStream *self)) TnyPcsStream_ReadCommand,
	(int (*)(RleStream *self)) PcsStream_ReadValue
};

struct PgcStream {
	RleStream base;
};
static void PgcStream_Construct(PgcStream *self, const RleStreamVtbl *vtbl);
static cibool PgcStream_ReadCommand(PgcStream *self);
static const RleStreamVtbl CiVtbl_PgcStream = {
	(cibool (*)(RleStream *self)) PgcStream_ReadCommand,
	RleStream_ReadValue
};

struct PgrRenderer {
	GtiaRenderer base;
	int screenOffset;
};
static void PgrRenderer_Construct(PgrRenderer *self, const GtiaRendererVtbl *vtbl);
static int PgrRenderer_GetPlayfieldByte(PgrRenderer const *self, int y, int column);
static const GtiaRendererVtbl CiVtbl_PgrRenderer = {
	(int (*)(GtiaRenderer *self, int y, int column)) PgrRenderer_GetPlayfieldByte
};

struct Q4Stream {
	RleStream base;
	int codeBits;
	int lastRepeatValue;
	unsigned char unpacked[65536];
};
static void Q4Stream_Construct(Q4Stream *self, const RleStreamVtbl *vtbl);
static int Q4Stream_ReadCode(Q4Stream *self);
static cibool Q4Stream_ReadCommand(Q4Stream *self);
static int Q4Stream_StartChunk(Q4Stream *self);
static cibool Q4Stream_Unpack(Q4Stream *self);
static const RleStreamVtbl CiVtbl_Q4Stream = {
	(cibool (*)(RleStream *self)) Q4Stream_ReadCommand,
	RleStream_ReadValue
};

typedef struct {
	int (*readFile)(RECOIL *self, const char *filename, unsigned char *content, int contentLength);
}
RECOILVtbl;
struct RECOIL {
	const RECOILVtbl *vtbl;
	int colors;
	/**
	 * Number of frames (normally 1; 2 or 3 for flickering pictures).
	 */
	int frames;
	/**
	 * Decoded image height.
	 */
	int height;
	int leftSkip;
	/**
	 * Platform and pixel ratio.
	 */
	RECOILResolution resolution;
	/**
	 * Decoded image width.
	 */
	int width;
	unsigned char gtiaColors[16];
	int atari8Palette[256];
	/**
	 * RGB palette decoded from the image file.
	 */
	int contentPalette[256];
	int palette[256];
	unsigned char colorInUse[2097152];
	/**
	 * Decoded image pixels as 0xRRGGBB.
	 */
	int pixels[2854278];
};
static void RECOIL_Construct(RECOIL *self, const RECOILVtbl *vtbl);
static cibool RECOIL_ApplyAtari8Palette(RECOIL *self, unsigned char const *frame);
static cibool RECOIL_ApplyAtari8PaletteBlend(RECOIL *self, unsigned char const *frame1, unsigned char const *frame2);
static cibool RECOIL_ApplyAtari8PaletteBlend3(RECOIL *self, unsigned char const *frame1, unsigned char const *frame2, unsigned char const *frame3);
static cibool RECOIL_ApplyBlend(RECOIL *self);
static void RECOIL_CalculatePalette(RECOIL *self);
static cibool RECOIL_CopyPrevious(unsigned char *unpacked, int unpackedOffset, int distance, int count);
static int RECOIL_CopyPscLines(unsigned char *unpacked, int unpackedOffset, int count);
static cibool RECOIL_Decode16x16x16(RECOIL *self, unsigned char const *content, int contentOffset, int colbak);
static cibool RECOIL_Decode256(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_Decode3(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_Decode4bt(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_Decode4mi(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_Decode4pl(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_Decode4pm(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_Decode64c(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeA(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeA4r(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAcs(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAfl(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAgp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAll(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAmi(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAmstradFnt(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeAmstradMode0Line(RECOIL *self, unsigned char const *content, int lineOffset, int y);
static void RECOIL_DecodeAmstradMode1Line(RECOIL *self, unsigned char const *content, int lineOffset, int y);
static cibool RECOIL_DecodeAmstradMode2(RECOIL *self, unsigned char const *content, int contentOffset, int width, int height);
static cibool RECOIL_DecodeAmstradScr(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAp3(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeApc(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeApl(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeApp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAppleIIDhr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAppleIIShr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeArtDirector(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAsciiArtEditor(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeAt800Missiles(RECOIL const *self, unsigned char const *content, int contentOffset, unsigned char *frame, int frameOffset);
static void RECOIL_DecodeAt800Players(RECOIL const *self, unsigned char const *content, unsigned char *frame);
static cibool RECOIL_DecodeAtari8Artist(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAtari8Fnt(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAtari8Font(RECOIL *self, unsigned char const *characters, unsigned char const *font, int fontOffset);
static void RECOIL_DecodeAtari8Gr0(RECOIL *self, unsigned char const *characters, int charactersStride, unsigned char const *font, int fontOffset, unsigned char *frame);
static void RECOIL_DecodeAtari8Gr0Line(RECOIL const *self, unsigned char const *characters, int charactersOffset, unsigned char const *font, int fontOffset, unsigned char *frame, int frameOffset, int lines);
static void RECOIL_DecodeAtari8Gr10(RECOIL const *self, unsigned char const *content, int contentOffset, unsigned char *frame, int frameOffset, int frameStride, int height);
static void RECOIL_DecodeAtari8Gr11(RECOIL const *self, unsigned char const *content, int contentOffset, unsigned char *frame, int frameOffset, int frameStride, int height);
static void RECOIL_DecodeAtari8Gr11PalBlend(RECOIL const *self, unsigned char const *content, int contentOffset, int contentStride, unsigned char *frame, int y);
static void RECOIL_DecodeAtari8Gr12Line(RECOIL const *self, unsigned char const *characters, int charactersOffset, unsigned char const *font, int fontOffset, unsigned char *frame, int frameOffset, int doubleLine);
static void RECOIL_DecodeAtari8Gr15(RECOIL const *self, unsigned char const *content, int contentOffset, int contentStride, unsigned char *frame, int frameOffset, int frameStride, int height);
static void RECOIL_DecodeAtari8Gr1Line(RECOIL const *self, unsigned char const *content, int charactersOffset, unsigned char const *font, int fontOffset, unsigned char *frame, int frameOffset, int doubleLine);
static void RECOIL_DecodeAtari8Gr3(RECOIL const *self, unsigned char const *content, unsigned char *frame);
static void RECOIL_DecodeAtari8Gr7(RECOIL const *self, unsigned char const *content, int contentOffset, unsigned char *frame, int frameOffset, int height);
static void RECOIL_DecodeAtari8Gr8(RECOIL const *self, unsigned char const *content, int contentOffset, unsigned char *frame, int frameOffset, int height);
static void RECOIL_DecodeAtari8Gr9(RECOIL const *self, unsigned char const *content, int contentOffset, int contentStride, unsigned char *frame, int frameOffset, int frameStride, int width, int height);
static cibool RECOIL_DecodeAtari8Hr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAtari8Ice(RECOIL *self, unsigned char const *content, int contentLength, cibool font, int mode);
static cibool RECOIL_DecodeAtari8Max(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeAtari8Player(RECOIL const *self, unsigned char const *content, int contentOffset, int color, unsigned char *frame, int frameOffset, int height);
static cibool RECOIL_DecodeAtari8Raw(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAtari8Rgb(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeAtari8RgbScreen(RECOIL *self, unsigned char const *screens, int screensOffset, int color, unsigned char *frame);
static cibool RECOIL_DecodeAtari8Spc(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAtr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAwbm(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeAwbmPalette(RECOIL *self, unsigned char const *content, int contentLength, int paletteOffset, int colors);
static cibool RECOIL_DecodeBb0(RECOIL *self, unsigned char const *content, int contentLength, int const *palette);
static cibool RECOIL_DecodeBb1(RECOIL *self, unsigned char const *content, int contentLength, int const *palette);
static cibool RECOIL_DecodeBb2(RECOIL *self, unsigned char const *content, int contentLength, int const *palette);
static cibool RECOIL_DecodeBb4(RECOIL *self, unsigned char const *content, int contentLength, int const *palette);
static cibool RECOIL_DecodeBb5(RECOIL *self, unsigned char const *content, int contentLength, int const *palette);
static cibool RECOIL_DecodeBbg(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeBfli(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeBgp(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeBitplanes(RECOIL *self, unsigned char const *content, int contentOffset, int contentStride, int bitplanes, int pixelsOffset, int width, int height);
static cibool RECOIL_DecodeBkg(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeBlackAndWhite(RECOIL *self, unsigned char const *content, int contentOffset, int contentLength, cibool wordAlign, int backgroundColor);
static void RECOIL_DecodeBlackAndWhiteFont(RECOIL *self, unsigned char const *content, int contentOffset, int contentLength, int fontHeight);
static cibool RECOIL_DecodeBlazingPaddlesVectors(RECOIL *self, unsigned char const *content, int contentLength, int startAddress);
static cibool RECOIL_DecodeBld(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeBml(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeBru(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeBrus(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeBsc(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeBw(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeBytes(RECOIL *self, unsigned char const *content, int contentOffset);
static cibool RECOIL_DecodeC64Fun(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeC64Hir(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeC64HiresFrame(RECOIL *self, unsigned char const *content, int bitmapOffset, int videoMatrixOffset, int pixelsOffset);
static cibool RECOIL_DecodeC64Multicolor(RECOIL *self, int width, unsigned char const *content, int bitmapOffset, int videoMatrixOffset, int colorOffset, int background);
static void RECOIL_DecodeC64MulticolorFrame(RECOIL *self, unsigned char const *content, int bitmapOffset, int videoMatrixOffset, int colorOffset, int background, int pixelsOffset);
static cibool RECOIL_DecodeCa(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCci(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCe(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCel(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCh8(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeChr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeChrd(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeChs(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCin(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeClp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCm5(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCmp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCocoMax(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCp3(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCpi(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCpr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCpt(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeCrg(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDa4(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDaliCompressed(RECOIL *self, unsigned char const *content, int contentLength, int mode);
static cibool RECOIL_DecodeDap(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDc1(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDd(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDeep(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDel(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDg1(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDit(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDlm(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDol(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDoo(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDph(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDrg(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDrl(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDrz(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDu2(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeDuo(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeEci(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeEcp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeEnvision(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeEnvisionCommon(RECOIL *self, unsigned char const *content, int mode, int columns, int rows, int charactersOffset, int const *fontId2Offset);
static cibool RECOIL_DecodeEnvisionPC(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeEpa(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeEsm(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeEza(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeFalconFun(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeFalconGrayscale(RECOIL *self, unsigned char const *content, int contentOffset, int contentLength, int width, int height);
static cibool RECOIL_DecodeFalconHir(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeFalconPalette(RECOIL *self, unsigned char const *content, int bitplanesOffset, int paletteOffset, int width, int height);
static cibool RECOIL_DecodeFalconPix(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeFalconTrueColor(RECOIL *self, unsigned char const *content, int contentOffset, int width, int height, RECOILResolution resolution);
static cibool RECOIL_DecodeFalconTrueColorVariable(RECOIL *self, unsigned char const *content, int contentLength, int widthOffset, int dataOffset);
static cibool RECOIL_DecodeFfli(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeFge(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeFli(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeFtc(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeFuckpaint(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeFunUnpacked(RECOIL *self, unsigned char const *content);
static cibool RECOIL_DecodeFwa(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeG(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeG09(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeG10(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeG11(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeG2f(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeG2fUnpacked(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGad(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGdosFnt(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGed(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGfaArtist(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGfb(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGg(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGhg(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGl16(RECOIL *self, const char *filename, unsigned char const *content, int contentLength, RECOILResolution resolution, const char *upperExt, const char *lowerExt);
static cibool RECOIL_DecodeGl5(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGl6(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGl7(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGl8(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGlYjk(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGod(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGr1(RECOIL *self, unsigned char const *content, int contentLength, int doubleHeight);
static cibool RECOIL_DecodeGr15Blend(RECOIL *self, unsigned char const *content, int bitmapOffset, int colorsOffset, int height);
static cibool RECOIL_DecodeGr3(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGr7(RECOIL *self, unsigned char const *content, int contentOffset, int contentSize);
static cibool RECOIL_DecodeGr8(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGr8Raw(RECOIL *self, unsigned char const *content, int contentLength, int width, int height);
static cibool RECOIL_DecodeGr9(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGraphicsProcessor(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeGun(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeHam(RECOIL *self, unsigned char const *unpacked, int width, int height, int bitplanes, MultiPalette *multiPalette);
static cibool RECOIL_DecodeHcm(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeHed(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeHfc(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeHgb(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeHgr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeHim(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeHimUnpacked(RECOIL *self, unsigned char const *content);
static cibool RECOIL_DecodeHip(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeHlf(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeHlr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeHpm(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeHr2(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeHrm(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeHrs(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeIbi(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeIc(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeIce20Frame(RECOIL const *self, unsigned char const *content, cibool second, int fontOffset, unsigned char *frame, int mode);
static void RECOIL_DecodeIceFrame(RECOIL const *self, unsigned char const *content, int charactersOffset, int fontOffset, unsigned char *frame, IceFrameMode mode);
static cibool RECOIL_DecodeIff(RECOIL *self, unsigned char const *content, int contentLength, RECOILResolution resolution);
static cibool RECOIL_DecodeIffUnpacked(RECOIL *self, unsigned char *unpacked, int width, int height, RECOILResolution resolution, int bitplanes, int colors, int camg, MultiPalette *multiPalette);
static cibool RECOIL_DecodeIge(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeIhe(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeIim(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeIld(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeImage72Fnt(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeInfo(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeInp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeInt(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeIp2(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeIph(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeIst(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeJgp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeJj(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeKid(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeKoa(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeKpr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeKss(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeLdm(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeLeo(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeLp3(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeLum(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMac(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMag(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMaki1(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMcMlt(RECOIL *self, unsigned char const *content, int contentLength, int bitmapOffset);
static cibool RECOIL_DecodeMch(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMci(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMcp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMcpp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMcs(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMg(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMgp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMic(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMis(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeMle(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeMleFrame(RECOIL *self, unsigned char const *content, int contentOffset, int pixelsOffset);
static cibool RECOIL_DecodeMono(RECOIL *self, unsigned char const *content, int contentOffset, int contentLength, cibool wordAlign);
static cibool RECOIL_DecodeMpp(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeMppScreen(RECOIL *self, unsigned char const *content, int paletteOffset, int paletteLength, int pixelsOffset);
static cibool RECOIL_DecodeMsp(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeMsx5(RECOIL *self, unsigned char const *content);
static cibool RECOIL_DecodeMsx6(RECOIL *self, unsigned char const *content, int contentOffset);
static void RECOIL_DecodeMsx7(RECOIL *self, unsigned char const *content);
static void RECOIL_DecodeMsxSprites(RECOIL *self, unsigned char const *content, int mode, int attributesOffset, int patternsOffset);
static int RECOIL_DecodeMsxYjk(RECOIL const *self, unsigned char const *content, int contentOffset, int x, cibool usePalette);
static void RECOIL_DecodeMsxYjkScreen(RECOIL *self, unsigned char const *content, int contentOffset, cibool usePalette);
static cibool RECOIL_DecodeMur(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeNeo(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static void RECOIL_DecodeNibbles(RECOIL *self, unsigned char const *content, int contentOffset, int contentStride);
static cibool RECOIL_DecodeNlq(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeOcp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeP(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeP11(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeP3c(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeP4i(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePac(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePbx(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePbx01(RECOIL *self, unsigned char const *content, int contentLength, int bitplanes, int lineHeight);
static void RECOIL_DecodePbx8(RECOIL *self, unsigned char const *content, int paletteOffset, int bitmapOffset, int pixelsOffset);
static cibool RECOIL_DecodePc(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePci(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePcs(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodePcsScreen(RECOIL *self, unsigned char const *unpacked, int pixelsOffset);
static cibool RECOIL_DecodePct(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePet(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePgc(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePgf(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePgr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePic(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePl4(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePla(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodePlayStation(unsigned char const *content, int contentOffset, int *pixels, int pixelsLength);
static cibool RECOIL_DecodePmd(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePmg(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePnt(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePntUnpacked(RECOIL *self, unsigned char const *content, unsigned char const *bitmap, int bitmapOffset, int width, int height);
static cibool RECOIL_DecodePph(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePphFrame(RECOIL *self, const char *filename, const char *upperExt, const char *lowerExt, unsigned char *bitmap, unsigned char const *pph, int yOffset);
static cibool RECOIL_DecodePpp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodePsc(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeQ4(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeR8G8B8Colors(unsigned char const *content, int contentOffset, int count, int *destination);
static void RECOIL_DecodeR8G8G8X8Colors(RECOIL *self, unsigned char const *content, int contentOffset, int count);
static cibool RECOIL_DecodeRag(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeRap(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeRgbn(RECOIL *self, unsigned char const *content, int contentOffset, int contentLength, int width, int height, cibool rgb8);
static cibool RECOIL_DecodeRgh(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeRip(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeRle(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeRleBlackAndWhite(RECOIL *self, RleStream *rle, int backgroundColor);
static cibool RECOIL_DecodeRm(RECOIL *self, unsigned char const *content, int contentLength, int mode, RECOILResolution resolution);
static cibool RECOIL_DecodeRw(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeRys(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSc(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSc2(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeSc2Sc4(RECOIL *self, unsigned char const *content, RECOILResolution resolution);
static cibool RECOIL_DecodeSc3(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSc4(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSc5(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSc6(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSc7(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSc8(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSca(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static void RECOIL_DecodeScaledBitplanes(RECOIL *self, unsigned char const *content, int contentOffset, int width, int height, int bitplanes, cibool ehb, MultiPalette *multiPalette);
static cibool RECOIL_DecodeScc(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static void RECOIL_DecodeSccSca(RECOIL *self, const char *filename, unsigned char const *content, int contentLength, int height, cibool usePalette);
static cibool RECOIL_DecodeScr(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeScrCol(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeScs4(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSd(RECOIL *self, unsigned char const *content, int contentLength, int mode);
static cibool RECOIL_DecodeSg3(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSge(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSh3(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeShc(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeShp(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeShrLine(RECOIL *self, unsigned char const *content, int y, int paletteOffset);
static cibool RECOIL_DecodeSif(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSkp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSpd(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSpr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSps(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSpu(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSpuScreen(RECOIL *self, unsigned char const *content, int bitmapOffset, int height, cibool enhanced);
static cibool RECOIL_DecodeSpx(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSr5(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSr6(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSr7(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSri(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSrt(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSsb(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSt(RECOIL *self, unsigned char const *bitmap, int bitmapOffset, unsigned char const *palette, int paletteOffset, int mode, int doubleHeight);
static cibool RECOIL_DecodeStFnt(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeStIcn(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeStImg(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeStLow(RECOIL *self, unsigned char const *bitmap, int bitmapOffset, unsigned char const *palette, int paletteOffset, int width, int height);
static cibool RECOIL_DecodeStLowBlend(RECOIL *self, unsigned char const *bitmap, int bitmapOffset, unsigned char const *palette, int paletteOffset, int width, int height);
static cibool RECOIL_DecodeStLowWithStride(RECOIL *self, unsigned char const *bitmap, int bitmapOffset, int bitmapStride, unsigned char const *palette, int paletteOffset, int width, int height);
static void RECOIL_DecodeStMedium(RECOIL *self, unsigned char const *bitmap, int bitmapOffset, unsigned char const *palette, int paletteOffset, int width, int height, int blend);
static cibool RECOIL_DecodeStPi(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeStRgb(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeStSpc(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeStp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSxg(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeSxs(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeTcp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeTg1(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeTim(RECOIL *self, unsigned char const *content, int contentLength);
static int RECOIL_DecodeTimPalette(RECOIL *self, unsigned char const *content, int contentLength, int colors);
static void RECOIL_DecodeTimexHires(RECOIL *self, unsigned char const *content);
static cibool RECOIL_DecodeTip(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeTny(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeTre(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeTrp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeTrsHr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeTrsShr(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeTru(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeTx0(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeTxe(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeTxs(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeVbm(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeVic(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeVzi(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeWin(RECOIL *self, const char *filename, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeWnd(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeX68KPic(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeX68KPicChain(RECOIL *self, BitStream *stream, int pixelsOffset, int color);
static cibool RECOIL_DecodeXga(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeXlp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeZp1(RECOIL *self, unsigned char const *content, int contentLength);
static void RECOIL_DecodeZx(RECOIL *self, unsigned char const *content, int bitmapOffset, int attributesOffset, int attributesMode, int pixelsOffset);
static cibool RECOIL_DecodeZx81(RECOIL *self, unsigned char const *screen);
static cibool RECOIL_DecodeZx81Raw(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeZxIfl(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeZxImg(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeZxRgb(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DecodeZxRgb3(RECOIL *self, unsigned char const *content, int contentLength, unsigned char const *frameComponents);
static cibool RECOIL_DecodeZxp(RECOIL *self, unsigned char const *content, int contentLength);
static cibool RECOIL_DrawBlazingPaddlesVector(RECOIL const *self, unsigned char const *content, int contentLength, unsigned char *frame, int frameOffset, int index, int startAddress);
static void RECOIL_DrawSpcBrush(unsigned char *pixels, int x1, int y1, int brush, int pattern);
static void RECOIL_DrawSpcChar(unsigned char *pixels, int x1, int y1, int ch);
static void RECOIL_DrawSpcLine(unsigned char *pixels, int x1, int y1, int x2, int y2, int color);
static void RECOIL_DrawSprByte(RECOIL *self, int x1, int y, int b);
static int RECOIL_FillPscLine(unsigned char *unpacked, int unpackedOffset, int value);
static cibool RECOIL_FillSpc(unsigned char *pixels, int x, int y, int pattern);
static int RECOIL_FindInSortedPalette(RECOIL const *self, int rgb);
static cibool RECOIL_G2fHasRaster(unsigned char const *content, int contentOffset);
static int RECOIL_Get32BigEndian(unsigned char const *content, int contentOffset);
static int RECOIL_Get32LittleEndian(unsigned char const *content, int contentOffset);
static RECOILResolution RECOIL_GetAmigaAspectRatio(int xRatio, int yRatio, RECOILResolution resolution);
static int RECOIL_GetAmstradHeader(unsigned char const *content, int contentLength);
static int RECOIL_GetAtari8ExecutableOffset(unsigned char const *content, int contentLength);
static int RECOIL_GetB5G5R5Color(int c);
static RECOILResolution RECOIL_GetCamgAspectRatio(int camg, RECOILResolution resolution);
static int RECOIL_GetFalconTrueColor(unsigned char const *content, int contentOffset);
static int RECOIL_GetG3R3B2Color(int c);
static int RECOIL_GetMsxHeader(unsigned char const *content);
static int RECOIL_GetNibble(unsigned char const *content, int contentOffset, int index);
static int RECOIL_GetOricHeader(unsigned char const *content, int contentLength);
static int RECOIL_GetPackedExt(const char *filename);
static int RECOIL_GetR5G5B5Color(int c);
static int RECOIL_GetR8G8B8Color(unsigned char const *content, int contentOffset);
static int RECOIL_GetStColor(RECOIL const *self, unsigned char const *content, int contentOffset);
static int RECOIL_GetStLowColor(unsigned char const *bitmap, int bitmapOffset, int x);
static int RECOIL_GetStLowSeparateBitplanes(unsigned char const *content, int contentOffset, int bitplaneLength, int x);
static int RECOIL_GetStVdiColor(unsigned char const *content, int contentOffset);
static int RECOIL_GetSteInterlacedColor(int rgb);
static int RECOIL_GetX68KColor(int color);
static int RECOIL_GetZxColor(int c);
static unsigned char RECOIL_Gr12GtiaByteToGr8(int b, int ch, cibool gtia10);
static int RECOIL_Gr12GtiaNibbleToGr8(int nibble, int ch, cibool gtia10);
static cibool RECOIL_HasG2fRaster(unsigned char const *content, int contentOffset, int count, int hitClr);
static cibool RECOIL_IsMsxPalette(unsigned char const *content, int contentOffset);
static cibool RECOIL_IsStePalette(unsigned char const *content, int contentOffset, int colors);
static cibool RECOIL_IsStringAt(unsigned char const *content, int contentOffset, const char *s);
static cibool RECOIL_IsSttt(unsigned char const *content, int bitplanes);
static cibool RECOIL_IsTimg(unsigned char const *content);
static cibool RECOIL_IsXimg(unsigned char const *content);
static int RECOIL_ParseAtari8ExecutableHeader(unsigned char const *content, int contentOffset);
static void RECOIL_PlotSpcPattern(unsigned char *pixels, int x, int y, int pattern);
static int RECOIL_ReadCompanionFile(RECOIL *self, const char *baseFilename, const char *upperExt, const char *lowerExt, unsigned char *content, int contentLength);
static int RECOIL_ReadFile(RECOIL *self, const char *filename, unsigned char *content, int contentLength);
static cibool RECOIL_SetAmstradFirmwarePalette(RECOIL *self, unsigned char const *content, int contentOffset, int count);
static cibool RECOIL_SetAmstradFirmwarePalette16(RECOIL *self, unsigned char const *content);
static int RECOIL_SetAmstradPalette(RECOIL *self, const char *filename);
static cibool RECOIL_SetAtari8RawSize(RECOIL *self, unsigned char const *content, int contentLength, RECOILResolution resolution);
static void RECOIL_SetBakPF012(RECOIL *self, unsigned char const *content, int contentOffset, int contentStride);
static void RECOIL_SetBakPF0123(RECOIL *self, unsigned char const *content, int contentOffset);
static void RECOIL_SetC16Palette(RECOIL *self);
static void RECOIL_SetDefaultStPalette(RECOIL *self, int bitplanes);
static void RECOIL_SetFalconPalette(RECOIL *self, unsigned char const *content, int contentOffset);
static void RECOIL_SetGr15DefaultColors(RECOIL *self);
static void RECOIL_SetGtiaColor(RECOIL *self, int reg, int value);
static void RECOIL_SetGtiaColors(RECOIL *self, unsigned char const *content, int contentOffset);
static void RECOIL_SetMagPalette(RECOIL *self, unsigned char const *content, int paletteOffset, int colors);
static void RECOIL_SetMsx6Palette(RECOIL *self, const char *filename);
static void RECOIL_SetMsxCompanionPalette(RECOIL *self, const char *filename, const char *upperExt, const char *lowerExt);
static void RECOIL_SetMsxPalette(RECOIL *self, unsigned char const *content, int contentOffset, int colors);
static void RECOIL_SetPF0123Bak(RECOIL *self, unsigned char const *content, int contentOffset);
static void RECOIL_SetPF0123Even(RECOIL *self, unsigned char const *content, int contentOffset);
static void RECOIL_SetPF012Bak(RECOIL *self, unsigned char const *content, int contentOffset);
static void RECOIL_SetPF21(RECOIL *self, unsigned char const *content, int contentOffset);
static void RECOIL_SetPM123PF0123Bak(RECOIL *self, unsigned char const *content, int contentOffset);
static void RECOIL_SetSc8Palette(RECOIL *self);
static void RECOIL_SetScaledPixel(RECOIL *self, int x, int y, int rgb);
static cibool RECOIL_SetScaledSize(RECOIL *self, int width, int height, RECOILResolution resolution);
static cibool RECOIL_SetSize(RECOIL *self, int width, int height, RECOILResolution resolution);
static cibool RECOIL_SetSizeStOrFalcon(RECOIL *self, int width, int height, int bitplanes, cibool squarePixels);
static void RECOIL_SetStPalette(RECOIL *self, unsigned char const *content, int contentOffset, int colors);
static void RECOIL_SetStVdiPalette(RECOIL *self, unsigned char const *content, int contentOffset, int colors, int bitplanes);
static void RECOIL_SetUlaPlus(RECOIL *self, unsigned char const *content, int paletteOffset);
static void RECOIL_SetXeOsDefaultColors(RECOIL *self);
static void RECOIL_SetZx(RECOIL *self, RECOILResolution resolution);
static void RECOIL_SortPalette(RECOIL *self, int start, int end);
static int RECOIL_ToAtari8Char(int ascii);
static cibool RECOIL_UnpackAndDecodeSpx(RECOIL *self, SpxStream *stream, int contentLength, int height, unsigned char *unpacked);
static cibool RECOIL_UnpackLz4(RECOIL const *self, unsigned char const *content, int contentLength, unsigned char *unpacked, int unpackedLength);
static cibool RECOIL_UnpackMag(unsigned char const *content, int headerOffset, int contentLength, int bytesPerLine, int height, unsigned char *unpacked);
static unsigned char const *RECOIL_UnpackPbx(RECOIL const *self, unsigned char const *content, int contentLength, unsigned char *unpacked, int bitmapOffset, int bytesPer16Pixels, int unpackedLength);
static cibool RECOIL_UnpackRip(RECOIL const *self, unsigned char const *content, int contentOffset, int contentLength, unsigned char *unpacked, int unpackedLength);
static cibool RECOIL_UnpackSpc(RleStream *rle, unsigned char *unpacked);
static unsigned char const *RECOIL_UnpackSr(unsigned char const *content, int contentLength, unsigned char *unpacked);
static cibool RECOIL_VerifyIce(RECOIL *self, unsigned char const *content, int contentLength, cibool font, int fontLength, int imageLength, RECOILResolution resolution);
static const RECOILVtbl CiVtbl_RECOIL = {
	RECOIL_ReadFile
};
static const int RECOIL_BbcPalette[16] = { 0, 16711680, 65280, 16776960, 255, 16711935, 65535, 16777215, 0, 16711680, 65280, 16776960, 255, 16711935, 65535, 16777215 };
static const int RECOIL_BbcPalette2Bit[4] = { 0, 16711680, 16776960, 16777215 };
static const int RECOIL_BbcPalette1Bit[2] = { 0, 16777215 };
static const int RECOIL_AmstradPalette[32] = { 8421504, 8421504, 65408, 16777088, 128, 16711808, 32896, 16744576, 16711808, 16777088, 16776960, 16777215, 16711680, 16711935, 16744448, 16744703,
	128, 65408, 65280, 65535, 0, 255, 32768, 33023, 8388736, 8454016, 8453888, 8454143, 8388608, 8388863, 8421376, 8421631 };
static const unsigned char RECOIL_Msx1Palette[32] = { 0, 0, 0, 0, 17, 6, 51, 7, 23, 1, 39, 3, 81, 1, 39, 6,
	113, 1, 115, 3, 97, 6, 100, 6, 17, 4, 101, 2, 85, 5, 119, 7 };
static const int RECOIL_C64Palette[16] = { 0, 16777215, 6829867, 7382194, 7290246, 5803331, 3483769, 12109679, 7294757, 4405504, 10119001, 4473924, 7105644, 10146436, 7102133, 9803157 };
static const unsigned char CiBinaryResource_altirrapal_pal[768] = { 0, 0, 0, 17, 17, 17, 34, 34, 34, 51, 51, 51, 68, 68, 68, 85,
	85, 85, 102, 102, 102, 119, 119, 119, 136, 136, 136, 153, 153, 153, 170, 170,
	170, 187, 187, 187, 204, 204, 204, 221, 221, 221, 238, 238, 238, 255, 255, 255,
	63, 0, 0, 80, 5, 0, 97, 22, 0, 114, 39, 0, 131, 56, 0, 148,
	73, 0, 165, 90, 1, 182, 107, 18, 199, 124, 35, 216, 141, 52, 233, 158,
	69, 250, 175, 86, 255, 192, 103, 255, 209, 120, 255, 226, 137, 255, 243, 154,
	80, 0, 0, 97, 0, 0, 114, 3, 0, 131, 20, 3, 148, 37, 20, 165,
	54, 37, 182, 71, 54, 199, 88, 71, 216, 105, 88, 233, 122, 105, 250, 139,
	122, 255, 156, 139, 255, 173, 156, 255, 190, 173, 255, 207, 190, 255, 224, 207,
	84, 0, 3, 101, 0, 20, 118, 0, 37, 135, 8, 54, 152, 25, 71, 169,
	42, 88, 186, 59, 105, 203, 76, 122, 220, 93, 139, 237, 110, 156, 254, 127,
	173, 255, 144, 190, 255, 161, 207, 255, 178, 224, 255, 195, 241, 255, 212, 255,
	79, 0, 53, 96, 0, 70, 113, 0, 87, 130, 1, 104, 147, 18, 121, 164,
	35, 138, 181, 52, 155, 198, 69, 172, 215, 86, 189, 232, 103, 206, 249, 120,
	223, 255, 137, 240, 255, 154, 255, 255, 171, 255, 255, 188, 255, 255, 205, 255,
	61, 0, 104, 78, 0, 121, 95, 0, 138, 112, 0, 155, 129, 17, 172, 146,
	34, 189, 163, 51, 206, 180, 68, 223, 197, 85, 240, 214, 102, 255, 231, 119,
	255, 248, 136, 255, 255, 153, 255, 255, 170, 255, 255, 187, 255, 255, 204, 255,
	32, 0, 139, 49, 0, 156, 66, 0, 173, 83, 8, 190, 100, 25, 207, 117,
	42, 224, 134, 59, 241, 151, 76, 255, 168, 93, 255, 185, 110, 255, 202, 127,
	255, 219, 144, 255, 236, 161, 255, 253, 178, 255, 255, 195, 255, 255, 212, 255,
	0, 0, 137, 0, 8, 154, 0, 25, 171, 16, 42, 188, 33, 59, 205, 50,
	76, 222, 67, 93, 239, 84, 110, 255, 101, 127, 255, 118, 144, 255, 135, 161,
	255, 152, 178, 255, 169, 195, 255, 186, 212, 255, 203, 229, 255, 220, 246, 255,
	0, 12, 101, 0, 29, 118, 0, 46, 135, 0, 63, 152, 5, 80, 169, 22,
	97, 186, 39, 114, 203, 56, 131, 220, 73, 148, 237, 90, 165, 254, 107, 182,
	255, 124, 199, 255, 141, 216, 255, 158, 233, 255, 175, 250, 255, 192, 255, 255,
	0, 31, 48, 0, 48, 65, 0, 65, 82, 0, 82, 99, 0, 99, 116, 5,
	116, 133, 22, 133, 150, 39, 150, 167, 56, 167, 184, 73, 184, 201, 90, 201,
	218, 107, 218, 235, 124, 235, 252, 141, 252, 255, 158, 255, 255, 175, 255, 255,
	0, 43, 0, 0, 60, 14, 0, 77, 31, 0, 94, 48, 0, 111, 65, 1,
	128, 82, 18, 145, 99, 35, 162, 116, 52, 179, 133, 69, 196, 150, 86, 213,
	167, 103, 230, 184, 120, 247, 201, 137, 255, 218, 154, 255, 235, 171, 255, 252,
	0, 51, 0, 0, 68, 0, 0, 85, 0, 0, 102, 0, 7, 119, 0, 24,
	136, 0, 41, 153, 0, 58, 170, 15, 75, 187, 32, 92, 204, 49, 109, 221,
	66, 126, 238, 83, 143, 255, 100, 160, 255, 117, 177, 255, 134, 194, 255, 151,
	0, 43, 0, 0, 60, 0, 2, 77, 0, 19, 94, 0, 36, 111, 0, 53,
	128, 0, 70, 145, 0, 87, 162, 0, 104, 179, 0, 121, 196, 14, 138, 213,
	31, 155, 230, 48, 172, 247, 65, 189, 255, 82, 206, 255, 99, 223, 255, 116,
	1, 28, 0, 18, 45, 0, 35, 62, 0, 52, 79, 0, 69, 96, 0, 86,
	113, 0, 103, 130, 0, 120, 147, 0, 137, 164, 0, 154, 181, 3, 171, 198,
	20, 188, 215, 37, 205, 232, 54, 222, 249, 71, 239, 255, 88, 255, 255, 105,
	35, 9, 0, 52, 26, 0, 69, 43, 0, 86, 60, 0, 103, 77, 0, 120,
	94, 0, 137, 111, 0, 154, 128, 0, 171, 145, 0, 188, 162, 16, 205, 179,
	33, 222, 196, 50, 239, 213, 67, 255, 230, 84, 255, 247, 101, 255, 255, 118,
	63, 0, 0, 80, 5, 0, 97, 22, 0, 114, 39, 0, 131, 56, 0, 148,
	73, 0, 165, 90, 1, 182, 107, 18, 199, 124, 35, 216, 141, 52, 233, 158,
	69, 250, 175, 86, 255, 192, 103, 255, 209, 120, 255, 226, 137, 255, 243, 154 };
static const unsigned char CiBinaryResource_atari8_fnt[1024] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 24, 24, 24, 0, 24, 0,
	0, 102, 102, 102, 0, 0, 0, 0, 0, 102, 255, 102, 102, 255, 102, 0,
	24, 62, 96, 60, 6, 124, 24, 0, 0, 102, 108, 24, 48, 102, 70, 0,
	28, 54, 28, 56, 111, 102, 59, 0, 0, 24, 24, 24, 0, 0, 0, 0,
	0, 14, 28, 24, 24, 28, 14, 0, 0, 112, 56, 24, 24, 56, 112, 0,
	0, 102, 60, 255, 60, 102, 0, 0, 0, 24, 24, 126, 24, 24, 0, 0,
	0, 0, 0, 0, 0, 24, 24, 48, 0, 0, 0, 126, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 24, 24, 0, 0, 6, 12, 24, 48, 96, 64, 0,
	0, 60, 102, 110, 118, 102, 60, 0, 0, 24, 56, 24, 24, 24, 126, 0,
	0, 60, 102, 12, 24, 48, 126, 0, 0, 126, 12, 24, 12, 102, 60, 0,
	0, 12, 28, 60, 108, 126, 12, 0, 0, 126, 96, 124, 6, 102, 60, 0,
	0, 60, 96, 124, 102, 102, 60, 0, 0, 126, 6, 12, 24, 48, 48, 0,
	0, 60, 102, 60, 102, 102, 60, 0, 0, 60, 102, 62, 6, 12, 56, 0,
	0, 0, 24, 24, 0, 24, 24, 0, 0, 0, 24, 24, 0, 24, 24, 48,
	6, 12, 24, 48, 24, 12, 6, 0, 0, 0, 126, 0, 0, 126, 0, 0,
	96, 48, 24, 12, 24, 48, 96, 0, 0, 60, 102, 12, 24, 0, 24, 0,
	0, 60, 102, 110, 110, 96, 62, 0, 0, 24, 60, 102, 102, 126, 102, 0,
	0, 124, 102, 124, 102, 102, 124, 0, 0, 60, 102, 96, 96, 102, 60, 0,
	0, 120, 108, 102, 102, 108, 120, 0, 0, 126, 96, 124, 96, 96, 126, 0,
	0, 126, 96, 124, 96, 96, 96, 0, 0, 62, 96, 96, 110, 102, 62, 0,
	0, 102, 102, 126, 102, 102, 102, 0, 0, 126, 24, 24, 24, 24, 126, 0,
	0, 6, 6, 6, 6, 102, 60, 0, 0, 102, 108, 120, 120, 108, 102, 0,
	0, 96, 96, 96, 96, 96, 126, 0, 0, 99, 119, 127, 107, 99, 99, 0,
	0, 102, 118, 126, 126, 110, 102, 0, 0, 60, 102, 102, 102, 102, 60, 0,
	0, 124, 102, 102, 124, 96, 96, 0, 0, 60, 102, 102, 102, 108, 54, 0,
	0, 124, 102, 102, 124, 108, 102, 0, 0, 60, 96, 60, 6, 6, 60, 0,
	0, 126, 24, 24, 24, 24, 24, 0, 0, 102, 102, 102, 102, 102, 126, 0,
	0, 102, 102, 102, 102, 60, 24, 0, 0, 99, 99, 107, 127, 119, 99, 0,
	0, 102, 102, 60, 60, 102, 102, 0, 0, 102, 102, 60, 24, 24, 24, 0,
	0, 126, 12, 24, 48, 96, 126, 0, 0, 30, 24, 24, 24, 24, 30, 0,
	0, 64, 96, 48, 24, 12, 6, 0, 0, 120, 24, 24, 24, 24, 120, 0,
	0, 8, 28, 54, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0,
	0, 54, 127, 127, 62, 28, 8, 0, 24, 24, 24, 31, 31, 24, 24, 24,
	3, 3, 3, 3, 3, 3, 3, 3, 24, 24, 24, 248, 248, 0, 0, 0,
	24, 24, 24, 248, 248, 24, 24, 24, 0, 0, 0, 248, 248, 24, 24, 24,
	3, 7, 14, 28, 56, 112, 224, 192, 192, 224, 112, 56, 28, 14, 7, 3,
	1, 3, 7, 15, 31, 63, 127, 255, 0, 0, 0, 0, 15, 15, 15, 15,
	128, 192, 224, 240, 248, 252, 254, 255, 15, 15, 15, 15, 0, 0, 0, 0,
	240, 240, 240, 240, 0, 0, 0, 0, 255, 255, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0, 0, 240, 240, 240, 240,
	0, 28, 28, 119, 119, 8, 28, 0, 0, 0, 0, 31, 31, 24, 24, 24,
	0, 0, 0, 255, 255, 0, 0, 0, 24, 24, 24, 255, 255, 24, 24, 24,
	0, 0, 60, 126, 126, 126, 60, 0, 0, 0, 0, 0, 255, 255, 255, 255,
	192, 192, 192, 192, 192, 192, 192, 192, 0, 0, 0, 255, 255, 24, 24, 24,
	24, 24, 24, 255, 255, 0, 0, 0, 240, 240, 240, 240, 240, 240, 240, 240,
	24, 24, 24, 31, 31, 0, 0, 0, 120, 96, 120, 96, 126, 24, 30, 0,
	0, 24, 60, 126, 24, 24, 24, 0, 0, 24, 24, 24, 126, 60, 24, 0,
	0, 24, 48, 126, 48, 24, 0, 0, 0, 24, 12, 126, 12, 24, 0, 0,
	0, 24, 60, 126, 126, 60, 24, 0, 0, 0, 60, 6, 62, 102, 62, 0,
	0, 96, 96, 124, 102, 102, 124, 0, 0, 0, 60, 96, 96, 96, 60, 0,
	0, 6, 6, 62, 102, 102, 62, 0, 0, 0, 60, 102, 126, 96, 60, 0,
	0, 14, 24, 62, 24, 24, 24, 0, 0, 0, 62, 102, 102, 62, 6, 124,
	0, 96, 96, 124, 102, 102, 102, 0, 0, 24, 0, 56, 24, 24, 60, 0,
	0, 6, 0, 6, 6, 6, 6, 60, 0, 96, 96, 108, 120, 108, 102, 0,
	0, 56, 24, 24, 24, 24, 60, 0, 0, 0, 102, 127, 127, 107, 99, 0,
	0, 0, 124, 102, 102, 102, 102, 0, 0, 0, 60, 102, 102, 102, 60, 0,
	0, 0, 124, 102, 102, 124, 96, 96, 0, 0, 62, 102, 102, 62, 6, 6,
	0, 0, 124, 102, 96, 96, 96, 0, 0, 0, 62, 96, 60, 6, 124, 0,
	0, 24, 126, 24, 24, 24, 14, 0, 0, 0, 102, 102, 102, 102, 62, 0,
	0, 0, 102, 102, 102, 60, 24, 0, 0, 0, 99, 107, 127, 62, 54, 0,
	0, 0, 102, 60, 24, 60, 102, 0, 0, 0, 102, 102, 102, 62, 12, 120,
	0, 0, 126, 12, 24, 48, 126, 0, 0, 24, 60, 126, 126, 24, 60, 0,
	24, 24, 24, 24, 24, 24, 24, 24, 0, 126, 120, 124, 110, 102, 6, 0,
	8, 24, 56, 120, 56, 24, 8, 0, 16, 24, 28, 30, 28, 24, 16, 0 };
static const unsigned char CiBinaryResource_c16_pal[768] = { 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	47, 47, 47, 61, 61, 61, 66, 66, 66, 86, 85, 90, 132, 126, 133, 178,
	172, 179, 202, 202, 202, 249, 249, 249, 47, 47, 47, 61, 61, 61, 66, 66,
	66, 86, 85, 90, 132, 126, 133, 178, 172, 179, 202, 202, 202, 249, 249, 249,
	104, 16, 16, 117, 30, 32, 123, 40, 32, 144, 60, 59, 187, 103, 104, 233,
	146, 146, 255, 172, 172, 255, 246, 242, 104, 16, 16, 117, 30, 32, 123, 40,
	32, 144, 60, 59, 187, 103, 104, 233, 146, 146, 255, 172, 172, 255, 246, 242,
	0, 66, 66, 0, 80, 79, 2, 86, 89, 23, 109, 114, 69, 150, 150, 108,
	195, 193, 133, 216, 224, 209, 255, 255, 0, 66, 66, 0, 80, 79, 2, 86,
	89, 23, 109, 114, 69, 150, 150, 108, 195, 193, 133, 216, 224, 209, 255, 255,
	88, 0, 109, 106, 16, 120, 111, 26, 130, 135, 45, 153, 175, 88, 195, 217,
	134, 240, 243, 156, 255, 255, 233, 255, 88, 0, 109, 106, 16, 120, 111, 26,
	130, 135, 45, 153, 175, 88, 195, 217, 134, 240, 243, 156, 255, 255, 233, 255,
	0, 78, 0, 4, 92, 0, 10, 101, 9, 31, 123, 21, 74, 167, 62, 121,
	209, 118, 146, 234, 138, 219, 255, 211, 0, 78, 0, 4, 92, 0, 10, 101,
	9, 31, 123, 21, 74, 167, 62, 121, 209, 118, 146, 234, 138, 219, 255, 211,
	25, 28, 148, 42, 42, 163, 48, 52, 167, 70, 73, 193, 115, 115, 236, 157,
	161, 255, 183, 186, 255, 240, 255, 255, 25, 28, 148, 42, 42, 163, 48, 52,
	167, 70, 73, 193, 115, 115, 236, 157, 161, 255, 183, 186, 255, 240, 255, 255,
	56, 56, 0, 76, 71, 0, 80, 81, 0, 102, 99, 0, 146, 141, 17, 189,
	190, 64, 214, 211, 91, 255, 255, 163, 56, 56, 0, 76, 71, 0, 80, 81,
	0, 102, 99, 0, 146, 141, 17, 189, 190, 64, 214, 211, 91, 255, 255, 163,
	86, 32, 0, 105, 47, 0, 110, 54, 0, 132, 76, 13, 175, 120, 50, 220,
	162, 97, 243, 190, 121, 255, 255, 193, 86, 32, 0, 105, 47, 0, 110, 54,
	0, 132, 76, 13, 175, 120, 50, 220, 162, 97, 243, 190, 121, 255, 255, 193,
	75, 40, 0, 89, 56, 0, 101, 64, 0, 115, 85, 0, 161, 128, 32, 209,
	169, 76, 230, 197, 101, 255, 255, 178, 75, 40, 0, 89, 56, 0, 101, 64,
	0, 115, 85, 0, 161, 128, 32, 209, 169, 76, 230, 197, 101, 255, 255, 178,
	22, 72, 0, 38, 86, 0, 44, 92, 0, 64, 114, 0, 108, 158, 18, 147,
	200, 61, 176, 224, 87, 252, 255, 162, 22, 72, 0, 38, 86, 0, 44, 92,
	0, 64, 114, 0, 108, 158, 18, 147, 200, 61, 176, 224, 87, 252, 255, 162,
	105, 7, 47, 117, 21, 65, 125, 30, 69, 145, 51, 94, 186, 95, 137, 233,
	138, 177, 255, 164, 207, 255, 238, 255, 105, 7, 47, 117, 21, 65, 125, 30,
	69, 145, 51, 94, 186, 95, 137, 233, 138, 177, 255, 164, 207, 255, 238, 255,
	0, 70, 38, 0, 88, 61, 1, 97, 69, 25, 116, 92, 70, 159, 131, 111,
	205, 171, 137, 229, 200, 209, 255, 255, 0, 70, 38, 0, 88, 61, 1, 97,
	69, 25, 116, 92, 70, 159, 131, 111, 205, 171, 137, 229, 200, 209, 255, 255,
	6, 42, 128, 21, 61, 143, 28, 69, 153, 50, 89, 174, 97, 133, 221, 138,
	180, 255, 164, 202, 255, 235, 255, 255, 6, 42, 128, 21, 61, 143, 28, 69,
	153, 50, 89, 174, 97, 133, 221, 138, 180, 255, 164, 202, 255, 235, 255, 255,
	42, 20, 155, 57, 34, 174, 66, 45, 173, 89, 63, 195, 132, 108, 239, 178,
	154, 255, 200, 184, 255, 255, 248, 255, 42, 20, 155, 57, 34, 174, 66, 45,
	173, 89, 63, 195, 132, 108, 239, 178, 154, 255, 200, 184, 255, 255, 248, 255,
	11, 73, 0, 25, 89, 0, 29, 98, 0, 50, 118, 0, 93, 163, 41, 136,
	203, 89, 162, 229, 122, 237, 255, 188, 11, 73, 0, 25, 89, 0, 29, 98,
	0, 50, 118, 0, 93, 163, 41, 136, 203, 89, 162, 229, 122, 237, 255, 188 };
static const unsigned char CiBinaryResource_c64_fnt[2048] = { 60, 102, 110, 110, 96, 98, 60, 0, 24, 60, 102, 126, 102, 102, 102, 0,
	124, 102, 102, 124, 102, 102, 124, 0, 60, 102, 96, 96, 96, 102, 60, 0,
	120, 108, 102, 102, 102, 108, 120, 0, 126, 96, 96, 120, 96, 96, 126, 0,
	126, 96, 96, 120, 96, 96, 96, 0, 60, 102, 96, 110, 102, 102, 60, 0,
	102, 102, 102, 126, 102, 102, 102, 0, 60, 24, 24, 24, 24, 24, 60, 0,
	30, 12, 12, 12, 12, 108, 56, 0, 102, 108, 120, 112, 120, 108, 102, 0,
	96, 96, 96, 96, 96, 96, 126, 0, 99, 119, 127, 107, 99, 99, 99, 0,
	102, 118, 126, 126, 110, 102, 102, 0, 60, 102, 102, 102, 102, 102, 60, 0,
	124, 102, 102, 124, 96, 96, 96, 0, 60, 102, 102, 102, 102, 60, 14, 0,
	124, 102, 102, 124, 120, 108, 102, 0, 60, 102, 96, 60, 6, 102, 60, 0,
	126, 24, 24, 24, 24, 24, 24, 0, 102, 102, 102, 102, 102, 102, 60, 0,
	102, 102, 102, 102, 102, 60, 24, 0, 99, 99, 99, 107, 127, 119, 99, 0,
	102, 102, 60, 24, 60, 102, 102, 0, 102, 102, 102, 60, 24, 24, 24, 0,
	126, 6, 12, 24, 48, 96, 126, 0, 60, 48, 48, 48, 48, 48, 60, 0,
	12, 18, 48, 124, 48, 98, 252, 0, 60, 12, 12, 12, 12, 12, 60, 0,
	0, 24, 60, 126, 24, 24, 24, 24, 0, 16, 48, 127, 127, 48, 16, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 24, 24, 24, 24, 0, 0, 24, 0,
	102, 102, 102, 0, 0, 0, 0, 0, 102, 102, 255, 102, 255, 102, 102, 0,
	24, 62, 96, 60, 6, 124, 24, 0, 98, 102, 12, 24, 48, 102, 70, 0,
	60, 102, 60, 56, 103, 102, 63, 0, 6, 12, 24, 0, 0, 0, 0, 0,
	12, 24, 48, 48, 48, 24, 12, 0, 48, 24, 12, 12, 12, 24, 48, 0,
	0, 102, 60, 255, 60, 102, 0, 0, 0, 24, 24, 126, 24, 24, 0, 0,
	0, 0, 0, 0, 0, 24, 24, 48, 0, 0, 0, 126, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 24, 24, 0, 0, 3, 6, 12, 24, 48, 96, 0,
	60, 102, 110, 118, 102, 102, 60, 0, 24, 24, 56, 24, 24, 24, 126, 0,
	60, 102, 6, 12, 48, 96, 126, 0, 60, 102, 6, 28, 6, 102, 60, 0,
	6, 14, 30, 102, 127, 6, 6, 0, 126, 96, 124, 6, 6, 102, 60, 0,
	60, 102, 96, 124, 102, 102, 60, 0, 126, 102, 12, 24, 24, 24, 24, 0,
	60, 102, 102, 60, 102, 102, 60, 0, 60, 102, 102, 62, 6, 102, 60, 0,
	0, 0, 24, 0, 0, 24, 0, 0, 0, 0, 24, 0, 0, 24, 24, 48,
	14, 24, 48, 96, 48, 24, 14, 0, 0, 0, 126, 0, 126, 0, 0, 0,
	112, 24, 12, 6, 12, 24, 112, 0, 60, 102, 6, 12, 24, 0, 24, 0,
	0, 0, 0, 255, 255, 0, 0, 0, 8, 28, 62, 127, 127, 28, 62, 0,
	24, 24, 24, 24, 24, 24, 24, 24, 0, 0, 0, 255, 255, 0, 0, 0,
	0, 0, 255, 255, 0, 0, 0, 0, 0, 255, 255, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 255, 255, 0, 0, 48, 48, 48, 48, 48, 48, 48, 48,
	12, 12, 12, 12, 12, 12, 12, 12, 0, 0, 0, 224, 240, 56, 24, 24,
	24, 24, 28, 15, 7, 0, 0, 0, 24, 24, 56, 240, 224, 0, 0, 0,
	192, 192, 192, 192, 192, 192, 255, 255, 192, 224, 112, 56, 28, 14, 7, 3,
	3, 7, 14, 28, 56, 112, 224, 192, 255, 255, 192, 192, 192, 192, 192, 192,
	255, 255, 3, 3, 3, 3, 3, 3, 0, 60, 126, 126, 126, 126, 60, 0,
	0, 0, 0, 0, 0, 255, 255, 0, 54, 127, 127, 127, 62, 28, 8, 0,
	96, 96, 96, 96, 96, 96, 96, 96, 0, 0, 0, 7, 15, 28, 24, 24,
	195, 231, 126, 60, 60, 126, 231, 195, 0, 60, 126, 102, 102, 126, 60, 0,
	24, 24, 102, 102, 24, 24, 60, 0, 6, 6, 6, 6, 6, 6, 6, 6,
	8, 28, 62, 127, 62, 28, 8, 0, 24, 24, 24, 255, 255, 24, 24, 24,
	192, 192, 48, 48, 192, 192, 48, 48, 24, 24, 24, 24, 24, 24, 24, 24,
	0, 0, 3, 62, 118, 54, 54, 0, 255, 127, 63, 31, 15, 7, 3, 1,
	0, 0, 0, 0, 0, 0, 0, 0, 240, 240, 240, 240, 240, 240, 240, 240,
	0, 0, 0, 0, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 255, 192, 192, 192, 192, 192, 192, 192, 192,
	204, 204, 51, 51, 204, 204, 51, 51, 3, 3, 3, 3, 3, 3, 3, 3,
	0, 0, 0, 0, 204, 204, 51, 51, 255, 254, 252, 248, 240, 224, 192, 128,
	3, 3, 3, 3, 3, 3, 3, 3, 24, 24, 24, 31, 31, 24, 24, 24,
	0, 0, 0, 0, 15, 15, 15, 15, 24, 24, 24, 31, 31, 0, 0, 0,
	0, 0, 0, 248, 248, 24, 24, 24, 0, 0, 0, 0, 0, 0, 255, 255,
	0, 0, 0, 31, 31, 24, 24, 24, 24, 24, 24, 255, 255, 0, 0, 0,
	0, 0, 0, 255, 255, 24, 24, 24, 24, 24, 24, 248, 248, 24, 24, 24,
	192, 192, 192, 192, 192, 192, 192, 192, 224, 224, 224, 224, 224, 224, 224, 224,
	7, 7, 7, 7, 7, 7, 7, 7, 255, 255, 0, 0, 0, 0, 0, 0,
	255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255,
	3, 3, 3, 3, 3, 3, 255, 255, 0, 0, 0, 0, 240, 240, 240, 240,
	15, 15, 15, 15, 0, 0, 0, 0, 24, 24, 24, 248, 248, 0, 0, 0,
	240, 240, 240, 240, 0, 0, 0, 0, 240, 240, 240, 240, 15, 15, 15, 15,
	195, 153, 145, 145, 159, 153, 195, 255, 231, 195, 153, 129, 153, 153, 153, 255,
	131, 153, 153, 131, 153, 153, 131, 255, 195, 153, 159, 159, 159, 153, 195, 255,
	135, 147, 153, 153, 153, 147, 135, 255, 129, 159, 159, 135, 159, 159, 129, 255,
	129, 159, 159, 135, 159, 159, 159, 255, 195, 153, 159, 145, 153, 153, 195, 255,
	153, 153, 153, 129, 153, 153, 153, 255, 195, 231, 231, 231, 231, 231, 195, 255,
	225, 243, 243, 243, 243, 147, 199, 255, 153, 147, 135, 143, 135, 147, 153, 255,
	159, 159, 159, 159, 159, 159, 129, 255, 156, 136, 128, 148, 156, 156, 156, 255,
	153, 137, 129, 129, 145, 153, 153, 255, 195, 153, 153, 153, 153, 153, 195, 255,
	131, 153, 153, 131, 159, 159, 159, 255, 195, 153, 153, 153, 153, 195, 241, 255,
	131, 153, 153, 131, 135, 147, 153, 255, 195, 153, 159, 195, 249, 153, 195, 255,
	129, 231, 231, 231, 231, 231, 231, 255, 153, 153, 153, 153, 153, 153, 195, 255,
	153, 153, 153, 153, 153, 195, 231, 255, 156, 156, 156, 148, 128, 136, 156, 255,
	153, 153, 195, 231, 195, 153, 153, 255, 153, 153, 153, 195, 231, 231, 231, 255,
	129, 249, 243, 231, 207, 159, 129, 255, 195, 207, 207, 207, 207, 207, 195, 255,
	243, 237, 207, 131, 207, 157, 3, 255, 195, 243, 243, 243, 243, 243, 195, 255,
	255, 231, 195, 129, 231, 231, 231, 231, 255, 239, 207, 128, 128, 207, 239, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 231, 231, 231, 231, 255, 255, 231, 255,
	153, 153, 153, 255, 255, 255, 255, 255, 153, 153, 0, 153, 0, 153, 153, 255,
	231, 193, 159, 195, 249, 131, 231, 255, 157, 153, 243, 231, 207, 153, 185, 255,
	195, 153, 195, 199, 152, 153, 192, 255, 249, 243, 231, 255, 255, 255, 255, 255,
	243, 231, 207, 207, 207, 231, 243, 255, 207, 231, 243, 243, 243, 231, 207, 255,
	255, 153, 195, 0, 195, 153, 255, 255, 255, 231, 231, 129, 231, 231, 255, 255,
	255, 255, 255, 255, 255, 231, 231, 207, 255, 255, 255, 129, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 231, 231, 255, 255, 252, 249, 243, 231, 207, 159, 255,
	195, 153, 145, 137, 153, 153, 195, 255, 231, 231, 199, 231, 231, 231, 129, 255,
	195, 153, 249, 243, 207, 159, 129, 255, 195, 153, 249, 227, 249, 153, 195, 255,
	249, 241, 225, 153, 128, 249, 249, 255, 129, 159, 131, 249, 249, 153, 195, 255,
	195, 153, 159, 131, 153, 153, 195, 255, 129, 153, 243, 231, 231, 231, 231, 255,
	195, 153, 153, 195, 153, 153, 195, 255, 195, 153, 153, 193, 249, 153, 195, 255,
	255, 255, 231, 255, 255, 231, 255, 255, 255, 255, 231, 255, 255, 231, 231, 207,
	241, 231, 207, 159, 207, 231, 241, 255, 255, 255, 129, 255, 129, 255, 255, 255,
	143, 231, 243, 249, 243, 231, 143, 255, 195, 153, 249, 243, 231, 255, 231, 255,
	255, 255, 255, 0, 0, 255, 255, 255, 247, 227, 193, 128, 128, 227, 193, 255,
	231, 231, 231, 231, 231, 231, 231, 231, 255, 255, 255, 0, 0, 255, 255, 255,
	255, 255, 0, 0, 255, 255, 255, 255, 255, 0, 0, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 0, 0, 255, 255, 207, 207, 207, 207, 207, 207, 207, 207,
	243, 243, 243, 243, 243, 243, 243, 243, 255, 255, 255, 31, 15, 199, 231, 231,
	231, 231, 227, 240, 248, 255, 255, 255, 231, 231, 199, 15, 31, 255, 255, 255,
	63, 63, 63, 63, 63, 63, 0, 0, 63, 31, 143, 199, 227, 241, 248, 252,
	252, 248, 241, 227, 199, 143, 31, 63, 0, 0, 63, 63, 63, 63, 63, 63,
	0, 0, 252, 252, 252, 252, 252, 252, 255, 195, 129, 129, 129, 129, 195, 255,
	255, 255, 255, 255, 255, 0, 0, 255, 201, 128, 128, 128, 193, 227, 247, 255,
	159, 159, 159, 159, 159, 159, 159, 159, 255, 255, 255, 248, 240, 227, 231, 231,
	60, 24, 129, 195, 195, 129, 24, 60, 255, 195, 129, 153, 153, 129, 195, 255,
	231, 231, 153, 153, 231, 231, 195, 255, 249, 249, 249, 249, 249, 249, 249, 249,
	247, 227, 193, 128, 193, 227, 247, 255, 231, 231, 231, 0, 0, 231, 231, 231,
	63, 63, 207, 207, 63, 63, 207, 207, 231, 231, 231, 231, 231, 231, 231, 231,
	255, 255, 252, 193, 137, 201, 201, 255, 0, 128, 192, 224, 240, 248, 252, 254,
	255, 255, 255, 255, 255, 255, 255, 255, 15, 15, 15, 15, 15, 15, 15, 15,
	255, 255, 255, 255, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 0, 63, 63, 63, 63, 63, 63, 63, 63,
	51, 51, 204, 204, 51, 51, 204, 204, 252, 252, 252, 252, 252, 252, 252, 252,
	255, 255, 255, 255, 51, 51, 204, 204, 0, 1, 3, 7, 15, 31, 63, 127,
	252, 252, 252, 252, 252, 252, 252, 252, 231, 231, 231, 224, 224, 231, 231, 231,
	255, 255, 255, 255, 240, 240, 240, 240, 231, 231, 231, 224, 224, 255, 255, 255,
	255, 255, 255, 7, 7, 231, 231, 231, 255, 255, 255, 255, 255, 255, 0, 0,
	255, 255, 255, 224, 224, 231, 231, 231, 231, 231, 231, 0, 0, 255, 255, 255,
	255, 255, 255, 0, 0, 231, 231, 231, 231, 231, 231, 7, 7, 231, 231, 231,
	63, 63, 63, 63, 63, 63, 63, 63, 31, 31, 31, 31, 31, 31, 31, 31,
	248, 248, 248, 248, 248, 248, 248, 248, 0, 0, 255, 255, 255, 255, 255, 255,
	0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0,
	252, 252, 252, 252, 252, 252, 0, 0, 255, 255, 255, 255, 15, 15, 15, 15,
	240, 240, 240, 240, 255, 255, 255, 255, 231, 231, 231, 7, 7, 255, 255, 255,
	15, 15, 15, 15, 255, 255, 255, 255, 15, 15, 15, 15, 240, 240, 240, 240 };
static const unsigned char CiBinaryResource_zx81_fnt[512] = { 0, 0, 0, 0, 0, 0, 0, 0, 240, 240, 240, 240, 0, 0, 0, 0,
	15, 15, 15, 15, 0, 0, 0, 0, 255, 255, 255, 255, 0, 0, 0, 0,
	0, 0, 0, 0, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240,
	15, 15, 15, 15, 240, 240, 240, 240, 255, 255, 255, 255, 240, 240, 240, 240,
	170, 85, 170, 85, 170, 85, 170, 85, 0, 0, 0, 0, 170, 85, 170, 85,
	170, 85, 170, 85, 0, 0, 0, 0, 0, 36, 36, 0, 0, 0, 0, 0,
	0, 28, 34, 120, 32, 32, 126, 0, 0, 8, 62, 40, 62, 10, 62, 8,
	0, 0, 0, 16, 0, 0, 16, 0, 0, 60, 66, 4, 8, 0, 8, 0,
	0, 4, 8, 8, 8, 8, 4, 0, 0, 32, 16, 16, 16, 16, 32, 0,
	0, 0, 16, 8, 4, 8, 16, 0, 0, 0, 4, 8, 16, 8, 4, 0,
	0, 0, 0, 62, 0, 62, 0, 0, 0, 0, 8, 8, 62, 8, 8, 0,
	0, 0, 0, 0, 62, 0, 0, 0, 0, 0, 20, 8, 62, 8, 20, 0,
	0, 0, 2, 4, 8, 16, 32, 0, 0, 0, 16, 0, 0, 16, 16, 32,
	0, 0, 0, 0, 0, 8, 8, 16, 0, 0, 0, 0, 0, 24, 24, 0,
	0, 60, 70, 74, 82, 98, 60, 0, 0, 24, 40, 8, 8, 8, 62, 0,
	0, 60, 66, 2, 60, 64, 126, 0, 0, 60, 66, 12, 2, 66, 60, 0,
	0, 8, 24, 40, 72, 126, 8, 0, 0, 126, 64, 124, 2, 66, 60, 0,
	0, 60, 64, 124, 66, 66, 60, 0, 0, 126, 2, 4, 8, 16, 16, 0,
	0, 60, 66, 60, 66, 66, 60, 0, 0, 60, 66, 66, 62, 2, 60, 0,
	0, 60, 66, 66, 126, 66, 66, 0, 0, 124, 66, 124, 66, 66, 124, 0,
	0, 60, 66, 64, 64, 66, 60, 0, 0, 120, 68, 66, 66, 68, 120, 0,
	0, 126, 64, 124, 64, 64, 126, 0, 0, 126, 64, 124, 64, 64, 64, 0,
	0, 60, 66, 64, 78, 66, 60, 0, 0, 66, 66, 126, 66, 66, 66, 0,
	0, 62, 8, 8, 8, 8, 62, 0, 0, 2, 2, 2, 66, 66, 60, 0,
	0, 68, 72, 112, 72, 68, 66, 0, 0, 64, 64, 64, 64, 64, 126, 0,
	0, 66, 102, 90, 66, 66, 66, 0, 0, 66, 98, 82, 74, 70, 66, 0,
	0, 60, 66, 66, 66, 66, 60, 0, 0, 124, 66, 66, 124, 64, 64, 0,
	0, 60, 66, 66, 82, 74, 60, 0, 0, 124, 66, 66, 124, 68, 66, 0,
	0, 60, 64, 60, 2, 66, 60, 0, 0, 254, 16, 16, 16, 16, 16, 0,
	0, 66, 66, 66, 66, 66, 60, 0, 0, 66, 66, 66, 66, 36, 24, 0,
	0, 66, 66, 66, 66, 90, 36, 0, 0, 66, 36, 24, 24, 36, 66, 0,
	0, 130, 68, 40, 16, 16, 16, 0, 0, 126, 4, 8, 16, 32, 126, 0 };

struct RastPalette {
	MultiPalette base;
};
static void RastPalette_Construct(RastPalette *self, const MultiPaletteVtbl *vtbl);
static void RastPalette_SetLinePalette(RastPalette const *self, RECOIL *recoil, int y);
static const MultiPaletteVtbl CiVtbl_RastPalette = {
	(void (*)(MultiPalette *self, RECOIL const *recoil, int y)) RastPalette_SetLinePalette
};

struct RecentInts {
	unsigned char head;
	unsigned char next[128];
	unsigned char prev[128];
	int value[128];
};
static void RecentInts_Construct(RecentInts *self);
static void RecentInts_Add(RecentInts *self, int value);
static int RecentInts_Get(RecentInts *self, int key);

struct RgbStream {
	RleStream base;
};
static void RgbStream_Construct(RgbStream *self, const RleStreamVtbl *vtbl);
static cibool RgbStream_ReadCommand(RgbStream *self);
static int RgbStream_ReadValue(RgbStream *self);
static const RleStreamVtbl CiVtbl_RgbStream = {
	(cibool (*)(RleStream *self)) RgbStream_ReadCommand,
	(int (*)(RleStream *self)) RgbStream_ReadValue
};

struct ScStream {
	RleStream base;
};
static void ScStream_Construct(ScStream *self, const RleStreamVtbl *vtbl);
static cibool ScStream_ReadCommand(ScStream *self);
static const RleStreamVtbl CiVtbl_ScStream = {
	(cibool (*)(RleStream *self)) ScStream_ReadCommand,
	RleStream_ReadValue
};

struct ShamLacePalette {
	MultiPalette base;
};
static void ShamLacePalette_Construct(ShamLacePalette *self, const MultiPaletteVtbl *vtbl);
static void ShamLacePalette_SetLinePalette(ShamLacePalette const *self, RECOIL *recoil, int y);
static const MultiPaletteVtbl CiVtbl_ShamLacePalette = {
	(void (*)(MultiPalette *self, RECOIL const *recoil, int y)) ShamLacePalette_SetLinePalette
};

struct SpcStream {
	RleStream base;
};
static void SpcStream_Construct(SpcStream *self, const RleStreamVtbl *vtbl);
static cibool SpcStream_ReadCommand(SpcStream *self);
static const RleStreamVtbl CiVtbl_SpcStream = {
	(cibool (*)(RleStream *self)) SpcStream_ReadCommand,
	RleStream_ReadValue
};

struct SprStream {
	Stream base;
};
static int SprStream_ReadBase(SprStream *self, int b);
static int SprStream_ReadInt(SprStream *self);

struct SpsStream {
	RleStream base;
};
static void SpsStream_Construct(SpsStream *self, const RleStreamVtbl *vtbl);
static cibool SpsStream_ReadCommand(SpsStream *self);
static const RleStreamVtbl CiVtbl_SpsStream = {
	(cibool (*)(RleStream *self)) SpsStream_ReadCommand,
	RleStream_ReadValue
};

struct SpxStream {
	Ice21Stream base;
};
static int SpxStream_ReadCount(SpxStream *self);
static cibool SpxStream_UnpackV2(SpxStream *self, unsigned char *unpacked, int unpackedLength);

struct SrStream {
	RleStream base;
};
static void SrStream_Construct(SrStream *self, const RleStreamVtbl *vtbl);
static cibool SrStream_ReadCommand(SrStream *self);
static const RleStreamVtbl CiVtbl_SrStream = {
	(cibool (*)(RleStream *self)) SrStream_ReadCommand,
	RleStream_ReadValue
};

struct TnyStream {
	TnyPcsStream base;
	int valueLength;
	int valueOffset;
};
static void TnyStream_Construct(TnyStream *self, const RleStreamVtbl *vtbl);
static int TnyStream_ReadValue(TnyStream *self);
static const RleStreamVtbl CiVtbl_TnyStream = {
	(cibool (*)(RleStream *self)) TnyPcsStream_ReadCommand,
	(int (*)(RleStream *self)) TnyStream_ReadValue
};

struct Tre1Stream {
	RleStream base;
	int lastRgb;
};
static void Tre1Stream_Construct(Tre1Stream *self, const RleStreamVtbl *vtbl);
static cibool Tre1Stream_ReadCommand(Tre1Stream *self);
static int Tre1Stream_ReadValue(Tre1Stream *self);
static const RleStreamVtbl CiVtbl_Tre1Stream = {
	(cibool (*)(RleStream *self)) Tre1Stream_ReadCommand,
	(int (*)(RleStream *self)) Tre1Stream_ReadValue
};

struct VdatStream {
	TnyStream base;
};
static void VdatStream_Construct(VdatStream *self, const RleStreamVtbl *vtbl);
static cibool VdatStream_ReadCommand(VdatStream *self);
static const RleStreamVtbl CiVtbl_VdatStream = {
	(cibool (*)(RleStream *self)) VdatStream_ReadCommand,
	(int (*)(RleStream *self)) TnyStream_ReadValue
};

struct X68KPicStream {
	BitStream base;
};
static void X68KPicStream_Construct(X68KPicStream *self);
static int X68KPicStream_ReadLength(X68KPicStream *self);
static cibool X68KPicStream_SkipUntilByte(X68KPicStream *self, int expected);

struct XeKoalaStream {
	RleStream base;
};
static void XeKoalaStream_Construct(XeKoalaStream *self, const RleStreamVtbl *vtbl);
static cibool XeKoalaStream_ReadCommand(XeKoalaStream *self);
static cibool XeKoalaStream_UnpackRaw(int type, unsigned char const *content, int contentOffset, int contentLength, unsigned char *unpacked, int unpackedLength);
static cibool XeKoalaStream_UnpackWrapped(unsigned char const *content, int contentLength, unsigned char *unpacked, int unpackedLength);
static const RleStreamVtbl CiVtbl_XeKoalaStream = {
	(cibool (*)(RleStream *self)) XeKoalaStream_ReadCommand,
	RleStream_ReadValue
};

struct XlpStream {
	RleStream base;
};
static void XlpStream_Construct(XlpStream *self, const RleStreamVtbl *vtbl);
static cibool XlpStream_ReadCommand(XlpStream *self);
static const RleStreamVtbl CiVtbl_XlpStream = {
	(cibool (*)(RleStream *self)) XlpStream_ReadCommand,
	RleStream_ReadValue
};

struct ZxpStream {
	Stream base;
};
static cibool ZxpStream_IsEof(ZxpStream const *self);
static int ZxpStream_ReadChar(ZxpStream *self);

static void A4rStream_Construct(A4rStream *self)
{
	self->outerFlags = self->innerFlags = 0;
}

static cibool A4rStream_CopyBlock(A4rStream *self, int distance, int count)
{
	int nextOffset;
	if (self->unpackedOffset < 0)
		return FALSE;
	nextOffset = self->unpackedOffset + count;
	if (nextOffset > 11248 || !RECOIL_CopyPrevious(self->unpacked, self->unpackedOffset, distance, count))
		return FALSE;
	self->unpackedOffset = nextOffset;
	return TRUE;
}

static cibool A4rStream_CopyByte(A4rStream *self)
{
	int b = Stream_ReadByte(&self->base);
	if (b < 0 || self->unpackedOffset < 0 || self->unpackedOffset >= 11248)
		return FALSE;
	self->unpacked[self->unpackedOffset++] = b;
	return TRUE;
}

static int A4rStream_ReadFlag(A4rStream *self)
{
	if ((self->innerFlags & 127) == 0) {
		if ((self->outerFlags & 127) == 0) {
			if (self->base.contentOffset >= self->base.contentLength)
				return -1;
			self->outerFlags = (self->base.content[self->base.contentOffset++] << 1) | 1;
		}
		else
			self->outerFlags <<= 1;
		if ((self->outerFlags & 256) == 0)
			self->innerFlags = 1;
		else {
			if (self->base.contentOffset >= self->base.contentLength)
				return -1;
			self->innerFlags = (self->base.content[self->base.contentOffset++] << 1) | 1;
		}
	}
	else
		self->innerFlags <<= 1;
	return (self->innerFlags >> 8) & 1;
}

static cibool A4rStream_UnpackA4r(A4rStream *self)
{
	memset(self->unpacked, 0, sizeof(self->unpacked));
	self->unpackedOffset = -1;
	for (;;) {
		switch (A4rStream_ReadFlag(self)) {
			int b;
		case -1:
			return FALSE;
		case 0:
			if (!A4rStream_CopyByte(self))
				return FALSE;
			break;
		case 1:
			b = Stream_ReadByte(&self->base);
			switch (b) {
			case -1:
				return FALSE;
			case 0:
				if (self->base.contentOffset >= self->base.contentLength - 2)
					return FALSE;
				b = Stream_ReadByte(&self->base);
				self->unpackedOffset = b + (Stream_ReadByte(&self->base) << 8) + 128 - 19984;
				if (!A4rStream_CopyByte(self))
					return FALSE;
				break;
			case 1:
				b = Stream_ReadByte(&self->base);
				switch (b) {
				case -1:
					return FALSE;
				case 0:
					return TRUE;
				default:
					if (!A4rStream_CopyBlock(self, 1, b + 2))
						return FALSE;
					break;
				}
				break;
			default:
				if (!A4rStream_CopyBlock(self, 128 - (b >> 1), 2 + (b & 1)))
					return FALSE;
				break;
			}
			break;
		}
	}
}

static void AmstradStream_Construct(AmstradStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_AmstradStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool AmstradStream_ReadCommand(AmstradStream *self)
{
	int b;
	while (self->blockLength <= 0) {
		int lo;
		int hi;
		if (Stream_ReadByte(&self->base.base.base) != 77 || Stream_ReadByte(&self->base.base.base) != 74 || Stream_ReadByte(&self->base.base.base) != 72)
			return FALSE;
		lo = Stream_ReadByte(&self->base.base.base);
		if (lo < 0)
			return FALSE;
		hi = Stream_ReadByte(&self->base.base.base);
		if (hi < 0)
			return FALSE;
		self->blockLength = (hi << 8) | lo;
	}
	b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b == 1) {
		self->base.repeatCount = Stream_ReadByte(&self->base.base.base);
		if (self->base.repeatCount == 0)
			self->base.repeatCount = 256;
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
	}
	else {
		self->base.repeatCount = 1;
		self->base.repeatValue = b;
	}
	self->blockLength -= self->base.repeatCount;
	return TRUE;
}

static cibool AmstradStream_UnpackFile(unsigned char const *content, int contentOffset, int contentLength, unsigned char *unpacked, int unpackedLength)
{
	AmstradStream rle;
	AmstradStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = contentOffset;
	rle.base.base.base.contentLength = contentLength;
	rle.blockLength = 0;
	return RleStream_Unpack(&rle.base, unpacked, 0, 1, unpackedLength);
}

static void BbgStream_Construct(BbgStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_BbgStream;
	RleStream_Construct(&self->base, vtbl);
}

static int BbgStream_ReadBitsReverse(BbgStream *self, int count)
{
	int result = 0;
	{
		int i;
		for (i = 0; i < count; i++) {
			switch (BitStream_ReadBit(&self->base.base)) {
			case -1:
				return -1;
			case 1:
				result |= 1 << i;
				break;
			case 0:
				break;
			}
		}
	}
	return result;
}

static cibool BbgStream_ReadCommand(BbgStream *self)
{
	switch (BitStream_ReadBit(&self->base.base)) {
	case -1:
		return FALSE;
	case 0:
		self->base.repeatCount = 1;
		break;
	case 1:
		self->base.repeatCount = BbgStream_ReadBitsReverse(self, self->countBits);
		if (self->base.repeatCount <= 0)
			return FALSE;
		break;
	}
	self->base.repeatValue = BbgStream_ReadBitsReverse(self, self->valueBits);
	return TRUE;
}

static void BitStream_Construct(BitStream *self)
{
	self->bits = 0;
}

static int BitStream_ReadBit(BitStream *self)
{
	if ((self->bits & 127) == 0) {
		if (self->base.contentOffset >= self->base.contentLength)
			return -1;
		self->bits = (self->base.content[self->base.contentOffset++] << 1) | 1;
	}
	else
		self->bits <<= 1;
	return (self->bits >> 8) & 1;
}

static int BitStream_ReadBits(BitStream *self, int count)
{
	int result = 0;
	while (--count >= 0) {
		int bit = BitStream_ReadBit(self);
		if (bit < 0)
			return -1;
		result = (result << 1) | bit;
	}
	return result;
}

static cibool BlazingPaddlesBoundingBox_Calculate(BlazingPaddlesBoundingBox *self, unsigned char const *content, int contentLength, int index, int startAddress)
{
	int contentOffset;
	int x;
	int y;
	index <<= 1;
	if (index + 1 >= contentLength)
		return FALSE;
	contentOffset = content[index] + (content[index + 1] << 8) - startAddress;
	if (contentOffset < 0)
		return FALSE;
	self->left = self->top = self->right = self->bottom = 0;
	x = 0;
	y = 0;
	while (contentOffset < contentLength) {
		int control = content[contentOffset++];
		int len;
		if (control == 8)
			return TRUE;
		len = (control >> 4) + 1;
		switch (control & 3) {
		case 0:
			x += len;
			if (self->right < x)
				self->right = x;
			break;
		case 1:
			x -= len;
			if (self->left > x)
				self->left = x;
			break;
		case 2:
			y -= len;
			if (self->top > y)
				self->top = y;
			break;
		case 3:
			y += len;
			if (self->bottom < y)
				self->bottom = y;
			break;
		}
	}
	return FALSE;
}

static void BldStream_Construct(BldStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_BldStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool BldStream_ReadCommand(BldStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	self->base.repeatValue = b;
	if (b == 0 || b == 255) {
		b = Stream_ReadByte(&self->base.base.base);
		if (b < 0)
			return FALSE;
		self->base.repeatCount = b + 1;
	}
	else
		self->base.repeatCount = 1;
	return TRUE;
}

static void C64KoalaStream_Construct(C64KoalaStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_C64KoalaStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool C64KoalaStream_ReadCommand(C64KoalaStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b == 254) {
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
		self->base.repeatCount = Stream_ReadByte(&self->base.base.base);
	}
	else {
		self->base.repeatValue = b;
		self->base.repeatCount = 1;
	}
	return TRUE;
}

static void CaStream_Construct(CaStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_CaStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool CaStream_ReadCommand(CaStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	int c;
	if (b < 0)
		return FALSE;
	if (b != self->escapeByte) {
		self->base.repeatCount = 1;
		self->base.repeatValue = b;
		return TRUE;
	}
	c = Stream_ReadByte(&self->base.base.base);
	if (c < 0)
		return FALSE;
	if (c == self->escapeByte) {
		self->base.repeatCount = 1;
		self->base.repeatValue = c;
		return TRUE;
	}
	b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	switch (c) {
	case 0:
		self->base.repeatCount = b + 1;
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
		break;
	case 1:
		c = Stream_ReadByte(&self->base.base.base);
		if (c < 0)
			return FALSE;
		self->base.repeatCount = (b << 8) + c + 1;
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
		break;
	case 2:
		if (b == 0)
			self->base.repeatCount = 32000;
		else {
			c = Stream_ReadByte(&self->base.base.base);
			if (c < 0)
				return FALSE;
			self->base.repeatCount = (b << 8) + c + 1;
		}
		self->base.repeatValue = self->defaultValue;
		break;
	default:
		self->base.repeatCount = c + 1;
		self->base.repeatValue = b;
		break;
	}
	return TRUE;
}

static cibool CaStream_UnpackCa(CaStream *self, unsigned char *unpacked, int unpackedOffset)
{
	int unpackedStep;
	if (self->base.base.base.contentOffset > self->base.base.base.contentLength - 4)
		return FALSE;
	self->escapeByte = self->base.base.base.content[self->base.base.base.contentOffset];
	self->defaultValue = self->base.base.base.content[self->base.base.base.contentOffset + 1];
	unpackedStep = (self->base.base.base.content[self->base.base.base.contentOffset + 2] << 8) | self->base.base.base.content[self->base.base.base.contentOffset + 3];
	if (unpackedStep >= 32000)
		return FALSE;
	self->base.repeatCount = 0;
	if (unpackedStep == 0) {
		self->base.repeatCount = 32000;
		self->base.repeatValue = self->defaultValue;
		unpackedStep = 1;
	}
	self->base.base.base.contentOffset += 4;
	return RleStream_UnpackColumns(&self->base, unpacked, unpackedOffset, unpackedStep, unpackedOffset + 32000);
}

static cibool CaStream_UnpackDel(unsigned char const *content, int contentLength, unsigned char *unpacked, int blocks)
{
	CaStream rle;
	CaStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = blocks << 2;
	if (rle.base.base.base.contentOffset >= contentLength)
		return FALSE;
	{
		int block;
		for (block = 0; block < blocks; block++) {
			rle.base.base.base.contentLength = rle.base.base.base.contentOffset + RECOIL_Get32BigEndian(content, block << 2);
			if (rle.base.base.base.contentLength > contentLength || rle.base.base.base.contentLength < rle.base.base.base.contentOffset || !CaStream_UnpackCa(&rle, unpacked, block * 32000))
				return FALSE;
			rle.base.base.base.contentOffset = rle.base.base.base.contentLength;
		}
	}
	if (blocks == 2) {
		rle.base.base.base.contentLength = contentLength;
		return CaStream_UnpackCa(&rle, unpacked, 64000);
	}
	return TRUE;
}

static void CciStream_Construct(CciStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_CciStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool CciStream_ReadCommand(CciStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b < 128) {
		self->base.repeatCount = b + 1;
		self->base.repeatValue = -1;
	}
	else {
		self->base.repeatCount = b - 127;
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
	}
	return TRUE;
}

static cibool CciStream_UnpackGr15(CciStream *self, unsigned char *unpacked, int unpackedOffset)
{
	self->base.base.base.contentOffset += 4;
	self->base.repeatCount = 0;
	{
		int x;
		for (x = 0; x < 40; x++) {
			if (!RleStream_Unpack(&self->base, unpacked, unpackedOffset + x, 80, 7680))
				return FALSE;
		}
	}
	return TRUE;
}

static void CmpStream_Construct(CmpStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_CmpStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool CmpStream_ReadCommand(CmpStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b == self->base.base.base.content[0]) {
		b = Stream_ReadByte(&self->base.base.base);
		if (b < 0)
			return FALSE;
		self->base.repeatCount = 1 + b;
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
	}
	else {
		self->base.repeatCount = 1;
		self->base.repeatValue = b;
	}
	return TRUE;
}

static void CpiStream_Construct(CpiStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_CpiStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool CpiStream_ReadCommand(CpiStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (self->base.base.base.contentOffset + 1 < self->base.base.base.contentLength && self->base.base.base.content[self->base.base.base.contentOffset] == b) {
		self->base.base.base.contentOffset++;
		self->base.repeatCount = 1 + self->base.base.base.content[self->base.base.base.contentOffset++];
	}
	else
		self->base.repeatCount = 1;
	self->base.repeatValue = b;
	return TRUE;
}

static void CtblPalette_Construct(CtblPalette *self, const MultiPaletteVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_CtblPalette;
	MultiPalette_Construct(&self->base, vtbl);
}

static void CtblPalette_SetLinePalette(CtblPalette const *self, RECOIL *recoil, int y)
{
	MultiPalette_SetOcsPalette(&self->base, recoil, self->base.base.base.contentOffset + (y * self->colors << 1), self->colors);
}

static cibool DaliStream_Decode(DaliStream *self, int countLength, RECOIL *recoil, int paletteOffset, int mode)
{
	unsigned char unpacked[32000];
	int valueOffset = self->base.contentOffset + countLength - 4;
	int count = 1;
	{
		int x;
		for (x = 0; x < 160; x += 4) {
			{
				int unpackedOffset;
				for (unpackedOffset = x; unpackedOffset < 32000; unpackedOffset += 160) {
					if (--count <= 0) {
						if (valueOffset + 7 >= self->base.contentLength)
							return FALSE;
						count = self->base.content[self->base.contentOffset++];
						if (count == 0)
							return FALSE;
						valueOffset += 4;
					}
					memcpy(unpacked + unpackedOffset, self->base.content + valueOffset, 4);
				}
			}
		}
	}
	return RECOIL_DecodeSt(recoil, unpacked, 0, self->base.content, paletteOffset, mode, 0);
}

static void DeepStream_Construct(DeepStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_DeepStream;
	PackBitsStream_Construct(&self->base, vtbl);
	self->components = 0;
}

static cibool DeepStream_ReadDeltaLine(DeepStream *self, int width, int tvdcOffset)
{
	{
		int c;
		for (c = 0; c < self->components; c++) {
			int count = 0;
			int value = 0;
			self->currentByte = -1;
			{
				int x;
				for (x = 0; x < width; x++) {
					int rgb;
					int shift;
					if (count == 0) {
						int i = DeepStream_ReadNibble(self);
						int delta;
						if (i < 0)
							return FALSE;
						delta = self->base.base.base.base.content[tvdcOffset + i * 2 + 1];
						if (delta == 0) {
							if (self->base.base.base.base.content[tvdcOffset + i * 2] == 0) {
								count = DeepStream_ReadNibble(self);
								if (count < 0)
									return FALSE;
							}
						}
						else
							value = (value + delta) & 255;
					}
					else
						count--;
					rgb = c == 0 ? 0 : self->line[x];
					shift = self->componentShift[c];
					if (shift >= 0)
						rgb |= value << shift;
					self->line[x] = rgb;
				}
			}
		}
	}
	return TRUE;
}

static int DeepStream_ReadNibble(DeepStream *self)
{
	int result;
	if (self->currentByte < 0) {
		self->currentByte = Stream_ReadByte(&self->base.base.base.base);
		if (self->currentByte < 0)
			return -1;
		return self->currentByte >> 4;
	}
	result = self->currentByte & 15;
	self->currentByte = -1;
	return result;
}

static int DeepStream_ReadValue(DeepStream *self)
{
	int rgb = 0;
	{
		int c;
		for (c = 0; c < self->components; c++) {
			int b = Stream_ReadByte(&self->base.base.base.base);
			int shift;
			if (b < 0)
				return -1;
			shift = self->componentShift[c];
			if (shift >= 0)
				rgb |= b << shift;
		}
	}
	return rgb;
}

static cibool DeepStream_SetDpel(DeepStream *self, int chunkOffset, int chunkLength)
{
	if (chunkLength < 8 || self->base.base.base.base.content[chunkOffset + 8] != 0 || self->base.base.base.base.content[chunkOffset + 9] != 0 || self->base.base.base.base.content[chunkOffset + 10] != 0)
		return FALSE;
	self->components = self->base.base.base.base.content[chunkOffset + 11];
	if (self->components > 6 || chunkLength != (self->components + 1) << 2)
		return FALSE;
	{
		int c;
		for (c = 0; c < self->components; c++) {
			int offset = chunkOffset + 12 + c * 4;
			int shift;
			if (self->base.base.base.base.content[offset] != 0 || self->base.base.base.base.content[offset + 2] != 0 || self->base.base.base.base.content[offset + 3] != 8)
				return FALSE;
			switch (self->base.base.base.base.content[offset + 1]) {
			case 1:
				shift = 16;
				break;
			case 2:
				shift = 8;
				break;
			case 3:
				shift = 0;
				break;
			case 4:
			case 9:
			case 10:
			case 11:
			case 17:
				shift = -1;
				break;
			default:
				return FALSE;
			}
			self->componentShift[c] = shift;
		}
	}
	return TRUE;
}

static void DrpStream_Construct(DrpStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_DrpStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool DrpStream_ReadCommand(DrpStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b == self->escape) {
		self->base.repeatCount = Stream_ReadByte(&self->base.base.base);
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
	}
	else {
		self->base.repeatCount = 1;
		self->base.repeatValue = b;
	}
	return TRUE;
}

static unsigned char const *DrpStream_UnpackFile(unsigned char const *content, int contentLength, const char *signature, unsigned char *unpacked, int unpackedLength)
{
	if (contentLength > 16 && RECOIL_IsStringAt(content, 2, signature)) {
		DrpStream rle;
		DrpStream_Construct(&rle, NULL);
		rle.base.base.base.content = content;
		rle.base.base.base.contentOffset = 16;
		rle.base.base.base.contentLength = contentLength;
		rle.escape = content[15];
		if (!RleStream_UnpackC64(&rle.base, unpacked, unpackedLength))
			return NULL;
		return unpacked;
	}
	if (contentLength != unpackedLength)
		return NULL;
	return content;
}

static int EndianStream_ReadInt(EndianStream *self)
{
	int value = self->bigEndian ? RECOIL_Get32BigEndian(self->base.content, self->base.contentOffset) : RECOIL_Get32LittleEndian(self->base.content, self->base.contentOffset);
	self->base.contentOffset += 4;
	return value;
}

static int EndianStream_ReadWord(EndianStream *self)
{
	int first;
	int second;
	if (self->base.contentOffset + 1 >= self->base.contentLength)
		return -1;
	first = self->base.content[self->base.contentOffset];
	second = self->base.content[self->base.contentOffset + 1];
	self->base.contentOffset += 2;
	return self->bigEndian ? (first << 8) | second : first | (second << 8);
}

static void FanoTree_Create(FanoTree *self, unsigned char const *content, int contentOffset, int codeCount)
{
	int positions[16];
	int position;
	memset(self->count, 0, sizeof(self->count));
	{
		int code;
		for (code = 0; code < codeCount; code++)
			self->count[RECOIL_GetNibble(content, contentOffset, code)]++;
	}
	position = 0;
	{
		int bits;
		for (bits = 0; bits < 16; bits++) {
			positions[bits] = position;
			position += self->count[bits];
		}
	}
	{
		int code;
		for (code = 0; code < codeCount; code++)
			self->values[positions[RECOIL_GetNibble(content, contentOffset, code)]++] = code;
	}
}

static int FanoTree_ReadCode(FanoTree const *self, BitStream *bitStream)
{
	int code = 0;
	int valuesOffset = self->count[0];
	{
		int bits;
		for (bits = 1; bits < 16; bits++) {
			int bit = BitStream_ReadBit(bitStream);
			int count;
			if (bit < 0)
				return -1;
			code = (code << 1) | bit;
			count = self->count[bits];
			if (code < count)
				return self->values[valuesOffset + code];
			code -= count;
			valuesOffset += count;
		}
	}
	return -1;
}

static void G2fRenderer_Construct(G2fRenderer *self, const GtiaRendererVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_G2fRenderer;
	GtiaRenderer_Construct(&self->base, vtbl);
}

static int G2fRenderer_GetPlayfieldByte(G2fRenderer const *self, int y, int column)
{
	int charOffset = (y >> 3) * self->base.playfieldColumns + column;
	int ch = self->base.content[3 + charOffset];
	int inverse = self->inverse2Offset >= 0 && (y & 4) != 0 ? self->base.content[self->inverse2Offset + charOffset] : ch;
	return ((inverse & 128) << 1) | self->base.content[self->fontOffset + ((ch & 127) << 3) + (y & 7)];
}

static cibool G2fRenderer_SetSprite(unsigned char *hpos, unsigned char *sizes, int i, unsigned char const *content, int spriteOffset)
{
	int value;
	spriteOffset += i << 10;
	value = content[spriteOffset + 1];
	if (value >= 128) {
		hpos[i] = 0;
		return TRUE;
	}
	value &= 15;
	switch (value) {
	case 0:
		value = 1;
		break;
	case 1:
	case 2:
	case 4:
		break;
	default:
		return FALSE;
	}
	sizes[i] = value;
	hpos[i] = (unsigned char) (32 + content[spriteOffset]);
	return TRUE;
}

static void GedRenderer_Construct(GedRenderer *self, const GtiaRendererVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_GedRenderer;
	GtiaRenderer_Construct(&self->base, vtbl);
}

static int GedRenderer_GetPlayfieldByte(GedRenderer const *self, int y, int column)
{
	return self->base.content[3302 + y * 40 + column];
}

static void GoDotStream_Construct(GoDotStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_GoDotStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool GoDotStream_ReadCommand(GoDotStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b == 173) {
		self->base.repeatCount = Stream_ReadByte(&self->base.base.base);
		if (self->base.repeatCount == 0)
			self->base.repeatCount = 256;
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
	}
	else {
		self->base.repeatCount = 1;
		self->base.repeatValue = b;
	}
	return TRUE;
}

static void GtiaRenderer_Construct(GtiaRenderer *self, const GtiaRendererVtbl *vtbl)
{
	self->vtbl = vtbl;
}

static int GtiaRenderer_DrawSpan(GtiaRenderer *self, int y, int hpos, int untilHpos, AnticMode anticMode, unsigned char *frame, int width)
{
	int gtiaMode = self->prior >> 6;
	for (; hpos < untilHpos; hpos++) {
		int x = hpos;
		int objects = 0;
		int playfield = 0;
		int c;
		int frameOffset;
		if (gtiaMode == 2) {
			x--;
			objects = 1;
		}
		if (anticMode != AnticMode_BLANK) {
			int column = (x >> 2) + (self->playfieldColumns >> 1) - 32;
			if (column >= 0 && column < self->playfieldColumns) {
				cibool inverseChar;
				playfield = self->vtbl->getPlayfieldByte(self, y, column);
				inverseChar = playfield >= 256;
				if (inverseChar && anticMode == AnticMode_HI_RES)
					playfield = 511 - playfield;
				if (gtiaMode == 0) {
					playfield = (playfield >> ((~x & 3) << 1)) & 3;
					objects = anticMode == AnticMode_HI_RES ? 64 : anticMode == AnticMode_FIVE_COLOR && playfield == 3 && inverseChar ? 128 : (8 << playfield) & 112;
				}
				else {
					if ((x & 2) == 0)
						playfield >>= 4;
					playfield &= 15;
					if (gtiaMode == 2) {
						static const unsigned char gtia10Objects[16] = { 1, 2, 4, 8, 16, 32, 64, 128, 0, 0, 0, 0, 16, 32, 64, 128 };
						objects = gtia10Objects[playfield];
					}
				}
			}
		}
		objects = GtiaRenderer_GetPmg(self, hpos, objects);
		c = GtiaRenderer_GetColor(self, objects);
		frameOffset = y * width + ((hpos + (width >> 2) - 128) << 1);
		switch (gtiaMode) {
		case 0:
			if (anticMode != AnticMode_HI_RES)
				break;
			frame[frameOffset] = (playfield & 2) == 0 ? c : (c & 240) + (self->colors[5] & 14);
			frame[frameOffset + 1] = (playfield & 1) == 0 ? c : (c & 240) + (self->colors[5] & 14);
			continue;
		case 2:
			break;
		default:
			if ((objects & 15) != 0)
				break;
			if (gtiaMode == 1)
				c |= playfield;
			else if (playfield == 0)
				c &= 240;
			else
				c |= playfield << 4;
			break;
		}
		frame[frameOffset + 1] = frame[frameOffset] = c;
	}
	return hpos;
}

static int GtiaRenderer_GetColor(GtiaRenderer const *self, int objects)
{
	int prior;
	int color;
	if (objects == 0)
		return self->colors[8];
	prior = self->prior;
	color = 0;
	if ((objects & 3) != 0) {
		if (((objects & 48) == 0 || (prior & 12) == 0) && ((objects & 192) == 0 || (prior & 4) == 0)) {
			if ((objects & 1) != 0) {
				color = self->colors[0];
				if ((objects & 2) != 0 && (prior & 32) != 0)
					color |= self->colors[1];
			}
			else
				color = self->colors[1];
		}
	}
	else if ((objects & 12) != 0) {
		if (((objects & 192) == 0 || (prior & 6) == 0) && ((objects & 48) == 0 || (prior & 1) != 0)) {
			if ((objects & 4) != 0) {
				color = self->colors[2];
				if ((objects & 8) != 0 && (prior & 32) != 0)
					color |= self->colors[3];
			}
			else
				color = self->colors[3];
		}
	}
	if ((objects & 192) != 0 && ((objects & 12) == 0 || (prior & 9) == 0) && ((objects & 3) == 0 || (prior & 4) != 0)) {
		return color | self->colors[(objects & 128) != 0 ? 7 : 6];
	}
	if ((objects & 48) != 0 && ((objects & 12) == 0 || (prior & 1) == 0) && ((objects & 3) == 0 || (prior & 3) == 0)) {
		return color | self->colors[(objects & 16) != 0 ? 4 : 5];
	}
	return color;
}

static int GtiaRenderer_GetPmg(GtiaRenderer *self, int hpos, int objects)
{
	{
		int i;
		for (i = 0; i < 4; i++) {
			if (self->playerHpos[i] == hpos) {
				self->playerShiftRegister[i] |= self->playerGraphics[i];
				self->playerSizeCounter[i] = self->playerSize[i];
			}
			if (self->missileHpos[i] == hpos) {
				self->missileShiftRegister |= self->missileGraphics & (3 << (i << 1));
				self->missileSizeCounter[i] = self->missileSize[i];
			}
		}
	}
	if ((self->prior & 16) != 0 && (self->missileShiftRegister & 170) != 0)
		objects |= 128;
	{
		int i;
		for (i = 0; i < 4; i++) {
			if ((self->playerShiftRegister[i] & 128) != 0 || ((self->prior & 16) == 0 && (self->missileShiftRegister & (2 << (i << 1))) != 0))
				objects |= 1 << i;
			if (--self->playerSizeCounter[i] == 0) {
				self->playerShiftRegister[i] = (unsigned char) (self->playerShiftRegister[i] << 1);
				self->playerSizeCounter[i] = self->playerSize[i];
			}
			if (--self->missileSizeCounter[i] == 0) {
				int mask = 1 << (i << 1);
				self->missileShiftRegister = (self->missileShiftRegister & ~(mask * 3)) | ((self->missileShiftRegister & mask) << 1);
				self->missileSizeCounter[i] = self->missileSize[i];
			}
		}
	}
	return objects;
}

static void GtiaRenderer_Poke(GtiaRenderer *self, int addr, int value)
{
	switch (addr) {
	case 0:
	case 1:
	case 2:
	case 3:
		self->playerHpos[addr] = value;
		break;
	case 4:
	case 5:
	case 6:
	case 7:
		self->missileHpos[addr - 4] = value;
		break;
	case 8:
	case 9:
	case 10:
	case 11:
		GtiaRenderer_SetPlayerSize(self, addr - 8, value);
		break;
	case 12:
		GtiaRenderer_SetSpriteSizes(self->missileSize, value);
		break;
	case 13:
	case 14:
	case 15:
	case 16:
		self->playerGraphics[addr - 13] = value;
		break;
	case 17:
		self->missileGraphics = value;
		break;
	case 18:
	case 19:
	case 20:
	case 21:
	case 22:
	case 23:
	case 24:
	case 25:
	case 26:
		self->colors[addr - 18] = value & 254;
		break;
	case 27:
		self->prior = value;
		break;
	default:
		break;
	}
}

static void GtiaRenderer_ProcessSpriteDma(GtiaRenderer *self, unsigned char const *content, int missileOffset)
{
	self->missileGraphics = content[missileOffset];
	{
		int i;
		for (i = 0; i < 4; i++)
			self->playerGraphics[i] = content[missileOffset + ((1 + i) << 8)];
	}
}

static void GtiaRenderer_SetG2fColors(GtiaRenderer *self, int contentOffset, int contentStride, int count, int gtiaMode)
{
	static const unsigned char normalRegisters[9] = { 8, 4, 5, 6, 7, 0, 1, 2, 3 };
	{
		int i;
		for (i = 0; i < count; i++)
			self->colors[(gtiaMode & 192) == 128 ? i : normalRegisters[i]] = self->content[contentOffset + i * contentStride] & 254;
	}
}

static void GtiaRenderer_SetPlayerSize(GtiaRenderer *self, int i, int size)
{
	size &= 3;
	self->playerSize[i] = size == 2 ? 1 : size + 1;
}

static void GtiaRenderer_SetSpriteSizes(unsigned char *sizes, int value)
{
	{
		int i;
		for (i = 0; i < 4; i++) {
			int size = (value >> (i << 1)) & 3;
			sizes[i] = size == 2 ? 1 : size + 1;
		}
	}
}

static void GtiaRenderer_StartLine(GtiaRenderer *self, int startHpos)
{
	memset(self->playerShiftRegister, 0, sizeof(self->playerShiftRegister));
	self->missileShiftRegister = 0;
	{
		int hpos;
		for (hpos = startHpos - 31; hpos < startHpos; hpos++)
			GtiaRenderer_GetPmg(self, hpos, 0);
	}
}

static void HcmRenderer_Construct(HcmRenderer *self, const GtiaRendererVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_HcmRenderer;
	GtiaRenderer_Construct(&self->base, vtbl);
}

static int HcmRenderer_GetPlayfieldByte(HcmRenderer const *self, int y, int column)
{
	return self->base.content[2064 + (y << 5) + column];
}

static void HimStream_Construct(HimStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_HimStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool HimStream_ReadCommand(HimStream *self)
{
	int b = self->base.vtbl->readValue(&self->base);
	switch (b) {
	case -1:
		return FALSE;
	case 0:
		self->base.repeatCount = self->base.vtbl->readValue(&self->base);
		if (self->base.repeatCount <= 0)
			return FALSE;
		self->base.repeatValue = self->base.vtbl->readValue(&self->base);
		return TRUE;
	default:
		self->base.repeatCount = b - 1;
		self->base.repeatValue = -1;
		return TRUE;
	}
}

static int HimStream_ReadValue(HimStream *self)
{
	if (self->base.base.base.contentOffset < 18)
		return -1;
	return self->base.base.base.content[self->base.base.base.contentOffset--];
}

static void HpmStream_Construct(HpmStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_HpmStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool HpmStream_ReadCommand(HpmStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b == 0) {
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
		self->base.repeatCount = Stream_ReadByte(&self->base.base.base);
	}
	else {
		self->base.repeatCount = b;
		self->base.repeatValue = -1;
	}
	return TRUE;
}

static void IcStream_Construct(IcStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_IcStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool IcStream_ReadCommand(IcStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	int escape = self->base.base.base.content[66];
	if (b != escape) {
		self->base.repeatCount = 1;
		self->base.repeatValue = b;
		return TRUE;
	}
	b = Stream_ReadByte(&self->base.base.base);
	if (b == escape) {
		self->base.repeatCount = 1;
		self->base.repeatValue = b;
		return TRUE;
	}
	switch (b) {
	case -1:
		return FALSE;
	case 0:
		b = Stream_ReadByte(&self->base.base.base);
		if (b < 0)
			return FALSE;
		self->base.repeatCount = b + 1;
		break;
	case 1:
		if (!IcStream_ReadCount(self))
			return FALSE;
		break;
	case 2:
		b = Stream_ReadByte(&self->base.base.base);
		switch (b) {
		case -1:
			return FALSE;
		case 0:
			self->base.repeatCount = 32000;
			break;
		case 1:
			if (!IcStream_ReadCount(self))
				return FALSE;
			break;
		case 2:
			while (Stream_ReadByte(&self->base.base.base) > 0) {
			}
			self->base.repeatCount = 0;
			break;
		default:
			self->base.repeatCount = b + 1;
			break;
		}
		self->base.repeatValue = 0;
		return TRUE;
	default:
		self->base.repeatCount = b + 1;
		break;
	}
	self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
	return TRUE;
}

static cibool IcStream_ReadCount(IcStream *self)
{
	int b;
	self->base.repeatCount = 257;
	while (Stream_ReadByte(&self->base.base.base) == 1)
		self->base.repeatCount += 256;
	b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	self->base.repeatCount += b;
	return TRUE;
}

static int Ice21Stream_CountOnes(Ice21Stream *self, int max)
{
	{
		int result;
		for (result = 0; result < max; result++) {
			switch (Ice21Stream_ReadBit(self)) {
			case -1:
				return -1;
			case 0:
				return result;
			default:
				break;
			}
		}
	}
	return max;
}

static int Ice21Stream_GetUnpackedLength(Ice21Stream const *self)
{
	if (self->contentStart + 16 > self->contentOffset || !RECOIL_IsStringAt(self->content, self->contentStart, "Ice!") || RECOIL_Get32BigEndian(self->content, self->contentStart + 4) != self->contentOffset - self->contentStart)
		return -1;
	return RECOIL_Get32BigEndian(self->content, self->contentStart + 8);
}

static int Ice21Stream_ReadBit(Ice21Stream *self)
{
	int b = self->bits;
	int next = b & 2147483647;
	if (next == 0) {
		self->contentOffset -= 4;
		if (self->contentOffset < self->contentStart)
			return -1;
		b = RECOIL_Get32BigEndian(self->content, self->contentOffset);
		self->bits = ((b & 2147483647) << 1) | 1;
	}
	else
		self->bits = next << 1;
	return (b >> 31) & 1;
}

static int Ice21Stream_ReadBits(Ice21Stream *self, int count)
{
	int result = 0;
	while (--count >= 0) {
		int bit = Ice21Stream_ReadBit(self);
		if (bit < 0)
			return -1;
		result = (result << 1) | bit;
	}
	return result;
}

static int Ice21Stream_ReadEncoded(Ice21Stream *self, int maxCount, unsigned char const *extraBits, int const *offsets)
{
	int n = Ice21Stream_CountOnes(self, maxCount);
	int b;
	if (n < 0)
		return -1;
	b = Ice21Stream_ReadBits(self, extraBits[n]);
	if (b < 0)
		return -1;
	return offsets[n] + b;
}

static int Ice21Stream_ReadLiteralLength(Ice21Stream *self)
{
	int o = 1;
	{
		int n;
		for (n = 0;; n++) {
			static const unsigned char bits[6] = { 1, 2, 2, 3, 8, 15 };
			int c = bits[n];
			int b = Ice21Stream_ReadBits(self, c);
			if (b < 0)
				return -1;
			c = (1 << c) - 1;
			if (b < c || n == 5)
				return o + b;
			o += c;
		}
	}
}

static cibool Ice21Stream_Unpack(Ice21Stream *self, unsigned char *unpacked, int unpackedStart, int unpackedEnd)
{
	self->contentStart += 12;
	self->contentOffset -= 4;
	self->bits = RECOIL_Get32BigEndian(self->content, self->contentOffset);
	{
		int unpackedOffset;
		for (unpackedOffset = unpackedEnd; unpackedOffset > unpackedStart;) {
			int length;
			static const unsigned char lengthExtraBits[5] = { 0, 0, 1, 2, 10 };
			static const int lengthOffsets[5] = { 0, 1, 2, 4, 8 };
			int offset;
			switch (Ice21Stream_ReadBit(self)) {
			case -1:
				return FALSE;
			case 1:
				length = Ice21Stream_ReadLiteralLength(self);
				if (length > unpackedOffset - unpackedStart)
					length = unpackedOffset - unpackedStart;
				self->contentOffset -= length;
				if (self->contentOffset < self->contentStart)
					return FALSE;
				unpackedOffset -= length;
				memcpy(unpacked + unpackedOffset, self->content + self->contentOffset, length);
				if (unpackedOffset == unpackedStart)
					return TRUE;
				break;
			default:
				break;
			}
			length = Ice21Stream_ReadEncoded(self, 4, lengthExtraBits, lengthOffsets);
			switch (length) {
				static const unsigned char offsetExtraBits[3] = { 8, 5, 12 };
				static const int offsetOffsets[3] = { 32, 0, 288 };
			case -1:
				return FALSE;
			case 0:
				switch (Ice21Stream_ReadBit(self)) {
				case -1:
					return FALSE;
				case 0:
					offset = Ice21Stream_ReadBits(self, 6);
					if (offset < 0)
						return FALSE;
					break;
				default:
					offset = Ice21Stream_ReadBits(self, 9);
					if (offset < 0)
						return FALSE;
					offset += 64;
					break;
				}
				break;
			default:
				offset = Ice21Stream_ReadEncoded(self, 2, offsetExtraBits, offsetOffsets);
				if (offset < 0)
					return FALSE;
				break;
			}
			length += 2;
			offset += length;
			if (unpackedOffset + offset > unpackedEnd)
				return FALSE;
			if (length > unpackedOffset - unpackedStart)
				length = unpackedOffset - unpackedStart;
			unpackedOffset -= length;
			memcpy(unpacked + unpackedOffset, unpacked + unpackedOffset + offset, length);
		}
	}
	return TRUE;
}

static cibool IcnParser_Expect(IcnParser *self, const char *s)
{
	int length;
	if (!IcnParser_SkipWhitespace(self))
		return FALSE;
	length = (int) strlen(s);
	{
		int i;
		for (i = 0; i < length; i++)
			if (Stream_ReadByte(&self->base) != s[i])
				return FALSE;
	}
	return TRUE;
}

static int IcnParser_ParseDefine(IcnParser *self, const char *s)
{
	if (!IcnParser_Expect(self, "#define") || !IcnParser_Expect(self, s))
		return -1;
	return IcnParser_ParseHex(self);
}

static int IcnParser_ParseHex(IcnParser *self)
{
	int r;
	if (!IcnParser_Expect(self, "0x"))
		return -1;
	r = 0;
	for (;;) {
		int d = Stream_ReadHexDigit(&self->base);
		if (d < 0)
			return r;
		if (r >> 12 != 0)
			return -1;
		r = (r << 4) | d;
	}
}

static cibool IcnParser_SkipWhitespace(IcnParser *self)
{
	cibool got = FALSE;
	while (self->base.contentOffset < self->base.contentLength) {
		switch (self->base.content[self->base.contentOffset]) {
		case 32:
		case 9:
		case 13:
		case 10:
			self->base.contentOffset++;
			got = TRUE;
			break;
		case 47:
			if (self->base.contentOffset >= self->base.contentLength - 3 || self->base.content[self->base.contentOffset + 1] != 42)
				return FALSE;
			self->base.contentOffset += 3;
			do {
				if (++self->base.contentOffset > self->base.contentLength)
					return FALSE;
			}
			while (self->base.content[self->base.contentOffset - 2] != 42 || self->base.content[self->base.contentOffset - 1] != 47);
			got = TRUE;
			break;
		default:
			return got;
		}
	}
	return TRUE;
}

static void ImgStream_Construct(ImgStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_ImgStream;
	RleStream_Construct(&self->base, vtbl);
	self->patternRepeatCount = 0;
}

static int ImgStream_GetLineRepeatCount(ImgStream *self)
{
	if (self->base.repeatCount == 0 && self->base.base.base.contentOffset < self->base.base.base.contentLength - 4 && self->base.base.base.content[self->base.base.base.contentOffset] == 0 && self->base.base.base.content[self->base.base.base.contentOffset + 1] == 0 && self->base.base.base.content[self->base.base.base.contentOffset + 2] == 255) {
		self->base.base.base.contentOffset += 4;
		return self->base.base.base.content[self->base.base.base.contentOffset - 1] + 1;
	}
	return 1;
}

static cibool ImgStream_ReadCommand(ImgStream *self)
{
	int b;
	if (self->patternRepeatCount > 1) {
		self->patternRepeatCount--;
		self->base.repeatCount = (self->base.base.base.content[6] << 8) | self->base.base.base.content[7];
		self->base.base.base.contentOffset -= self->base.repeatCount;
		return TRUE;
	}
	b = Stream_ReadByte(&self->base.base.base);
	switch (b) {
	case -1:
		return FALSE;
	case 0:
		b = Stream_ReadByte(&self->base.base.base);
		if (b < 0)
			return FALSE;
		if (b == 0) {
			b = Stream_ReadByte(&self->base.base.base);
			if (b < 0)
				return FALSE;
			self->base.repeatCount = b + 1;
			self->base.repeatValue = 256;
			return TRUE;
		}
		self->patternRepeatCount = b;
		self->base.repeatCount = (self->base.base.base.content[6] << 8) | self->base.base.base.content[7];
		self->base.repeatValue = -1;
		return TRUE;
	case 128:
		self->base.repeatCount = Stream_ReadByte(&self->base.base.base);
		if (self->base.repeatCount < 0)
			return FALSE;
		if (self->base.repeatCount == 0)
			self->base.repeatCount = 256;
		self->base.repeatValue = -1;
		return TRUE;
	default:
		self->base.repeatCount = b & 127;
		self->base.repeatValue = b >= 128 ? 255 : 0;
		return TRUE;
	}
}

static void InflateStream_BuildHuffmanTrees(InflateStream *self)
{
	int offset;
	memset(self->nBitCodeCount, 0, sizeof(self->nBitCodeCount));
	{
		int i;
		for (i = 0; i < 318; i++)
			self->nBitCodeCount[self->symbolCodeLength[i]]++;
	}
	offset = 0;
	{
		int i;
		for (i = 0; i < 32; i++) {
			self->nBitCodeOffset[i] = offset;
			offset += self->nBitCodeCount[i];
		}
	}
	{
		int i;
		for (i = 0; i < 318; i++)
			self->codeToSymbol[self->nBitCodeOffset[self->symbolCodeLength[i]]++] = i;
	}
}

static int InflateStream_FetchCode(InflateStream *self, int tree)
{
	int code = 0;
	do {
		int bit = InflateStream_ReadBit(self);
		if (bit < 0)
			return -1;
		code = (code << 1) + bit - self->nBitCodeCount[++tree];
		if (code < 0)
			return self->codeToSymbol[self->nBitCodeOffset[tree] + code];
	}
	while ((tree & 15) != 15);
	return -1;
}

static int InflateStream_Inflate(InflateStream *self, unsigned char *unpacked, int unpackedLength)
{
	int unpackedOffset = 0;
	int lastBlock;
	self->bits = 0;
	do {
		int count;
		lastBlock = InflateStream_ReadBit(self);
		switch (InflateStream_ReadBits(self, 2)) {
			int primaryCodes;
			int codes;
			int temporaryCodes;
			int length;
		case 0:
			self->bits = 0;
			count = InflateStream_ReadBits(self, 16);
			if (InflateStream_ReadBits(self, 16) != (count ^ 65535))
				return -1;
			if (count > unpackedLength - unpackedOffset)
				count = unpackedLength - unpackedOffset;
			if (!Stream_ReadBytes(&self->base, unpacked, unpackedOffset, count))
				return -1;
			unpackedOffset += count;
			if (unpackedOffset == unpackedLength)
				return unpackedOffset;
			continue;
		case 1:
			{
				int i;
				for (i = 0; i < 144; i++)
					self->symbolCodeLength[i] = 8;
			}
			{
				int i;
				for (i = 144; i < 256; i++)
					self->symbolCodeLength[i] = 9;
			}
			{
				int i;
				for (i = 256; i < 280; i++)
					self->symbolCodeLength[i] = 7;
			}
			{
				int i;
				for (i = 280; i < 288; i++)
					self->symbolCodeLength[i] = 8;
			}
			{
				int i;
				for (i = 288; i < 318; i++)
					self->symbolCodeLength[i] = 21;
			}
			break;
		case 2:
			primaryCodes = 257 + InflateStream_ReadBits(self, 5);
			codes = 289 + InflateStream_ReadBits(self, 5);
			if (codes > 318)
				return -1;
			temporaryCodes = InflateStream_ReadBits(self, 4);
			if (temporaryCodes < 0)
				return -1;
			temporaryCodes += 4;
			memset(self->symbolCodeLength, 0, sizeof(self->symbolCodeLength));
			{
				int i;
				for (i = 0; i < temporaryCodes; i++) {
					int bits = InflateStream_ReadBits(self, 3);
					static const unsigned char tempSymbols[19] = { 16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2,
						14, 1, 15 };
					if (bits < 0)
						return -1;
					self->symbolCodeLength[tempSymbols[i]] = bits;
				}
			}
			InflateStream_BuildHuffmanTrees(self);
			length = 0;
			count = 1;
			{
				int i;
				for (i = 0; i < codes; i++) {
					if (--count == 0) {
						int symbol = InflateStream_FetchCode(self, 0);
						switch (symbol) {
						case -1:
							return -1;
						case 16:
							count = InflateStream_ReadBits(self, 2);
							if (count < 0)
								return -1;
							count += 3;
							break;
						case 17:
							length = 0;
							count = InflateStream_ReadBits(self, 3);
							if (count < 0)
								return -1;
							count += 3;
							break;
						case 18:
							length = 0;
							count = InflateStream_ReadBits(self, 7);
							if (count < 0)
								return -1;
							count += 11;
							break;
						default:
							length = symbol;
							count = 1;
							break;
						}
					}
					if (i == primaryCodes)
						i = 288;
					self->symbolCodeLength[i] = i < 288 ? length : 16 + length;
				}
			}
			break;
		default:
			return -1;
		}
		InflateStream_BuildHuffmanTrees(self);
		for (;;) {
			int symbol = InflateStream_FetchCode(self, 0);
			if (symbol < 0)
				return -1;
			else if (symbol < 256)
				unpacked[unpackedOffset++] = symbol;
			else if (symbol == 256)
				break;
			else {
				int distance;
				switch (symbol) {
				case 257:
				case 258:
				case 259:
				case 260:
				case 261:
				case 262:
				case 263:
				case 264:
					count = symbol - 254;
					break;
				case 285:
					count = 258;
					break;
				case 286:
				case 287:
					return -1;
				default:
					symbol -= 261;
					count = InflateStream_ReadBits(self, symbol >> 2);
					if (count < 0)
						return -1;
					count += ((4 + (symbol & 3)) << (symbol >> 2)) + 3;
					break;
				}
				symbol = InflateStream_FetchCode(self, 16);
				switch (symbol) {
				case -1:
					return -1;
				case 288:
				case 289:
				case 290:
				case 291:
					distance = symbol - 287;
					break;
				default:
					symbol -= 290;
					distance = InflateStream_ReadBits(self, symbol >> 1);
					if (distance < 0)
						return -1;
					distance += ((2 + (symbol & 1)) << (symbol >> 1)) + 1;
					break;
				}
				if (count > unpackedLength - unpackedOffset)
					count = unpackedLength - unpackedOffset;
				if (!RECOIL_CopyPrevious(unpacked, unpackedOffset, distance, count))
					return -1;
				unpackedOffset += count;
			}
			if (unpackedOffset == unpackedLength)
				return unpackedOffset;
		}
	}
	while (lastBlock == 0);
	return unpackedOffset;
}

static int InflateStream_ReadBit(InflateStream *self)
{
	int result;
	if (self->bits <= 1) {
		if (self->base.contentOffset >= self->base.contentLength)
			return -1;
		self->bits = self->base.content[self->base.contentOffset++] | 256;
	}
	result = self->bits & 1;
	self->bits >>= 1;
	return result;
}

static int InflateStream_ReadBits(InflateStream *self, int count)
{
	int result = 0;
	{
		int rank;
		for (rank = 0; rank < count; rank++) {
			switch (InflateStream_ReadBit(self)) {
			case -1:
				return -1;
			case 1:
				result |= 1 << rank;
				break;
			default:
				break;
			}
		}
	}
	return result;
}

static int InflateStream_Uncompress(InflateStream *self, unsigned char *unpacked, int unpackedLength)
{
	int b0 = Stream_ReadByte(&self->base);
	int b1;
	if ((b0 & 143) != 8)
		return -1;
	b1 = Stream_ReadByte(&self->base);
	if ((b1 & 32) != 0 || ((b0 << 8) | b1) % 31 != 0)
		return -1;
	return InflateStream_Inflate(self, unpacked, unpackedLength);
}

static cibool Lz4Stream_Copy(Lz4Stream *self, int count)
{
	if (self->unpackedOffset + count > self->unpackedLength || !Stream_ReadBytes(&self->base, self->unpacked, self->unpackedOffset, count))
		return FALSE;
	self->unpackedOffset += count;
	return TRUE;
}

static int Lz4Stream_ReadCount(Lz4Stream *self, int count)
{
	if (count == 15) {
		int b;
		do {
			b = Stream_ReadByte(&self->base);
			if (b < 0)
				return -1;
			count += b;
		}
		while (b == 255);
	}
	return count;
}

static void MchRenderer_Construct(MchRenderer *self, const GtiaRendererVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_MchRenderer;
	GtiaRenderer_Construct(&self->base, vtbl);
}

static int MchRenderer_GetPlayfieldByte(MchRenderer const *self, int y, int column)
{
	int offset = ((y >> 3) * self->base.playfieldColumns + column) * 9;
	int shift = self->dliPlus && (y & 4) != 0 ? 2 : 1;
	return ((self->base.content[offset] << shift) & 256) | self->base.content[offset + 1 + (y & 7)];
}

static void MppPaletteStream_Construct(MppPaletteStream *self)
{
	BitStream_Construct(&self->base);
}

static int MppPaletteStream_Read(MppPaletteStream *self)
{
	int rgb;
	switch (self->base.base.content[4] & 3) {
	case 0:
		rgb = BitStream_ReadBits(&self->base, 9);
		rgb = ((rgb & 448) << 10) | ((rgb & 56) << 5) | (rgb & 7);
		return (rgb << 5) | (rgb << 2) | ((rgb >> 1) & 197379);
	case 1:
		rgb = BitStream_ReadBits(&self->base, 12);
		rgb = ((rgb & 1792) << 9) | ((rgb & 2160) << 5) | ((rgb & 135) << 1) | ((rgb & 8) >> 3);
		return (rgb << 4) | rgb;
	case 3:
		return RECOIL_GetSteInterlacedColor(BitStream_ReadBits(&self->base, 15));
	default:
		return 0;
	}
}

static void MspStream_Construct(MspStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_MspStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool MspStream_ReadCommand(MspStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b == 0) {
		self->base.repeatCount = Stream_ReadByte(&self->base.base.base);
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
	}
	else {
		self->base.repeatCount = b;
		self->base.repeatValue = -1;
	}
	return TRUE;
}

static void MultiPalette_Construct(MultiPalette *self, const MultiPaletteVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_MultiPalette;
	self->vtbl = vtbl;
	BitStream_Construct(&self->base);
}

static int MultiPalette_GetOcsColor(int r, int gb)
{
	int rgb = ((r & 15) << 16) | ((gb & 240) << 4) | (gb & 15);
	return rgb * 17;
}

static void MultiPalette_SetLinePalette(MultiPalette *self, RECOIL const *recoil, int y)
{
	self->base.base.contentOffset = 0;
}

static void MultiPalette_SetOcsPalette(MultiPalette const *self, RECOIL *recoil, int contentOffset, int colors)
{
	{
		int c;
		for (c = 0; c < colors; c++) {
			int r = self->base.base.content[contentOffset++];
			int gb = self->base.base.content[contentOffset++];
			recoil->contentPalette[c] = MultiPalette_GetOcsColor(r, gb);
		}
	}
}

static cibool PInterpreter_DPeek(PInterpreter *self, int expectedX, int expectedAddress)
{
	return Stream_ReadByte(&self->base) == 20 && PInterpreter_ReadNumber(self) == expectedX && Stream_ReadByte(&self->base) == 21 && Stream_ReadByte(&self->base) == 211 && PInterpreter_ReadNumber(self) == expectedAddress && Stream_ReadByte(&self->base) == 21 && PInterpreter_ReadNumber(self) == 256 && Stream_ReadByte(&self->base) == 23 && Stream_ReadByte(&self->base) == 211 && PInterpreter_ReadNumber(self) == expectedAddress + 1;
}

static cibool PInterpreter_DoFor(PInterpreter *self)
{
	self->bottomCode |= 4;
	return Stream_ReadByte(&self->base) == 43 && Stream_ReadByte(&self->base) == 20 && PInterpreter_ReadNumber(self) == 0 && Stream_ReadByte(&self->base) == 223 && PInterpreter_ReadNumber(self) == 63;
}

static cibool PInterpreter_DoIf(PInterpreter *self)
{
	return Stream_ReadByte(&self->base) == 198 && Stream_ReadByte(&self->base) == 38 && Stream_ReadByte(&self->base) == 13 && Stream_ReadByte(&self->base) == 221 && PInterpreter_ReadNumber(self) == 64 && Stream_ReadByte(&self->base) == 222 && Stream_ReadByte(&self->base) == 227;
}

static cibool PInterpreter_Let(PInterpreter *self)
{
	switch (Stream_ReadByte(&self->base)) {
	case 38:
		if (Stream_ReadByte(&self->base) != 13 || Stream_ReadByte(&self->base) != 20 || Stream_ReadByte(&self->base) != 11)
			return FALSE;
		self->bottomOffset = self->base.contentOffset;
		for (;;) {
			switch (Stream_ReadByte(&self->base)) {
			case -1:
				return FALSE;
			case 11:
				return TRUE;
			default:
				break;
			}
		}
	case 56:
		self->bottomCode |= 1;
		return PInterpreter_DPeek(self, 3, 16400);
	case 41:
		self->bottomCode |= 2;
		return PInterpreter_DPeek(self, 727, 16396);
	default:
		return FALSE;
	}
}

static cibool PInterpreter_Next(PInterpreter *self)
{
	if (Stream_ReadByte(&self->base) == 43 && self->bottomOffset > 0 && self->bottomCode == 15) {
		self->screenOffset = 704;
		return PInterpreter_PrintString(self, self->bottomOffset) >= 0;
	}
	return FALSE;
}

static cibool PInterpreter_Poke(PInterpreter *self)
{
	self->bottomCode |= 8;
	return Stream_ReadByte(&self->base) == 41 && Stream_ReadByte(&self->base) == 21 && Stream_ReadByte(&self->base) == 43 && Stream_ReadByte(&self->base) == 21 && Stream_ReadByte(&self->base) == 16 && Stream_ReadByte(&self->base) == 43 && Stream_ReadByte(&self->base) == 18 && PInterpreter_ReadNumber(self) == 31 && Stream_ReadByte(&self->base) == 17 && Stream_ReadByte(&self->base) == 26 && Stream_ReadByte(&self->base) == 211 && Stream_ReadByte(&self->base) == 16 && Stream_ReadByte(&self->base) == 56 && Stream_ReadByte(&self->base) == 21 && Stream_ReadByte(&self->base) == 43 && Stream_ReadByte(&self->base) == 17;
}

static cibool PInterpreter_Print(PInterpreter *self)
{
	for (;;) {
		switch (Stream_ReadByte(&self->base)) {
			int row;
			int column;
		case 11:
			self->base.contentOffset = PInterpreter_PrintString(self, self->base.contentOffset);
			if (self->base.contentOffset < 0)
				return FALSE;
			break;
		case 193:
			row = PInterpreter_ReadNumber(self);
			if (row < 0 || row > 21 || Stream_ReadByte(&self->base) != 26)
				return FALSE;
			column = PInterpreter_ReadNumber(self);
			if (column < 0 || column > 31)
				return FALSE;
			self->screenOffset = (row << 5) | column;
			self->newLineWorks = TRUE;
			break;
		case 0:
		case 25:
			break;
		case 118:
			self->base.contentOffset--;
			if (self->base.content[self->base.contentOffset - 1] != 25) {
				if (self->newLineWorks)
					self->screenOffset = (self->screenOffset & ~31) + 32;
				self->newLineWorks = TRUE;
			}
			return TRUE;
		default:
			return FALSE;
		}
	}
}

static int PInterpreter_PrintString(PInterpreter *self, int offset)
{
	for (;;) {
		int c;
		if (offset >= self->base.contentLength)
			return -1;
		c = self->base.content[offset++];
		if (c == 11)
			break;
		if (self->screenOffset >= 768)
			return -1;
		if (c == 192)
			c = 11;
		else if ((c & 127) >= 64)
			return -1;
		self->screen[self->screenOffset++] = c;
		self->newLineWorks = (self->screenOffset & 31) != 0;
	}
	return offset;
}

static int PInterpreter_ReadNumber(PInterpreter *self)
{
	for (;;) {
		switch (Stream_ReadByte(&self->base)) {
			int exp;
			int m0;
			int m1;
		case 21:
		case 22:
		case 27:
		case 28:
		case 29:
		case 30:
		case 31:
		case 32:
		case 33:
		case 34:
		case 35:
		case 36:
		case 37:
		case 42:
			break;
		case 126:
			if (self->base.contentOffset > self->base.contentLength - 5)
				return -1;
			exp = Stream_ReadByte(&self->base);
			m0 = Stream_ReadByte(&self->base);
			m1 = Stream_ReadByte(&self->base);
			self->base.contentOffset += 2;
			if (exp > 144 || m0 >= 128)
				return -1;
			if (exp <= 128)
				return 0;
			return (((m0 | 128) << 8) | m1) >> (144 - exp);
		default:
			return -1;
		}
	}
}

static cibool PInterpreter_Run(PInterpreter *self)
{
	self->base.contentOffset = 116;
	memset(self->screen, 0, sizeof(self->screen));
	self->screenOffset = 0;
	self->newLineWorks = TRUE;
	self->bottomOffset = -1;
	self->bottomCode = 0;
	for (;;) {
		if (self->base.contentOffset > self->base.contentLength - 8)
			return FALSE;
		if (Stream_ReadByte(&self->base) == 118)
			return TRUE;
		self->base.contentOffset += 3;
		switch (Stream_ReadByte(&self->base)) {
		case 228:
		case 229:
		case 251:
		case 253:
			break;
		case 227:
		case 236:
		case 242:
			return TRUE;
		case 245:
			if (!PInterpreter_Print(self))
				return FALSE;
			break;
		case 241:
			if (!PInterpreter_Let(self))
				return FALSE;
			break;
		case 250:
			if (!PInterpreter_DoIf(self))
				return FALSE;
			break;
		case 235:
			if (!PInterpreter_DoFor(self))
				return FALSE;
			break;
		case 244:
			if (!PInterpreter_Poke(self))
				return FALSE;
			break;
		case 243:
			if (!PInterpreter_Next(self))
				return FALSE;
			break;
		default:
			return FALSE;
		}
		if (Stream_ReadByte(&self->base) != 118)
			return FALSE;
	}
}

static void PacStream_Construct(PacStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_PacStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool PacStream_ReadCommand(PacStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b == self->base.base.base.content[4]) {
		b = Stream_ReadByte(&self->base.base.base);
		if (b < 0)
			return FALSE;
		self->base.repeatCount = b + 1;
		self->base.repeatValue = self->base.base.base.content[5];
	}
	else if (b == self->base.base.base.content[6]) {
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
		if (self->base.repeatValue < 0)
			return FALSE;
		b = Stream_ReadByte(&self->base.base.base);
		if (b < 0)
			return FALSE;
		self->base.repeatCount = b + 1;
	}
	else {
		self->base.repeatCount = 1;
		self->base.repeatValue = b;
	}
	return TRUE;
}

static void PackBitsStream_Construct(PackBitsStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_PackBitsStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool PackBitsStream_ReadCommand(PackBitsStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b < 128) {
		self->base.repeatCount = b + 1;
		self->base.repeatValue = -1;
	}
	else {
		self->base.repeatCount = 257 - b;
		self->base.repeatValue = (&self->base)->vtbl->readValue(&self->base);
	}
	return TRUE;
}

static cibool PackBitsStream_UnpackBitplaneLines(PackBitsStream *self, unsigned char *unpacked, int width, int height, int bitplanes, cibool compressed, cibool hasMask)
{
	int bytesPerBitplane = (width + 15) >> 4 << 1;
	int bytesPerLine = bitplanes * bytesPerBitplane;
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int bitplane;
				for (bitplane = 0; bitplane < bitplanes; bitplane++) {
					{
						int w;
						for (w = bitplane << 1; w < bytesPerLine; w += bitplanes << 1) {
							{
								int x;
								for (x = 0; x < 2; x++) {
									int b = compressed ? RleStream_ReadRle(&self->base) : Stream_ReadByte(&self->base.base.base);
									if (b < 0)
										return FALSE;
									unpacked[y * bytesPerLine + w + x] = b;
								}
							}
						}
					}
				}
			}
			if (hasMask) {
				{
					int x;
					for (x = 0; x < bytesPerBitplane; x++) {
						int b = compressed ? RleStream_ReadRle(&self->base) : Stream_ReadByte(&self->base.base.base);
						if (b < 0)
							return FALSE;
					}
				}
			}
		}
	}
	return TRUE;
}

static void PchgPalette_Construct(PchgPalette *self, const MultiPaletteVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_PchgPalette;
	MultiPalette_Construct(&self->base, vtbl);
}

static cibool PchgPalette_Init(PchgPalette *self)
{
	int havePaletteChangeLength;
	if (self->base.base.base.contentOffset + 20 > self->base.base.base.contentLength || self->base.base.base.content[self->base.base.base.contentOffset] != 0)
		return FALSE;
	switch (self->base.base.base.content[self->base.base.base.contentOffset + 3] & 3) {
	case 1:
		self->ocs = TRUE;
		break;
	case 2:
		self->ocs = FALSE;
		break;
	default:
		return FALSE;
	}
	self->startLine = (self->base.base.base.content[self->base.base.base.contentOffset + 4] << 8) | self->base.base.base.content[self->base.base.base.contentOffset + 5];
	self->lineCount = (self->base.base.base.content[self->base.base.base.contentOffset + 6] << 8) | self->base.base.base.content[self->base.base.base.contentOffset + 7];
	havePaletteChangeLength = (self->lineCount + 31) >> 5 << 2;
	if (havePaletteChangeLength > 232)
		return FALSE;
	switch (self->base.base.base.content[self->base.base.base.contentOffset + 1]) {
		int treeLength;
	case 0:
		self->base.base.base.contentOffset += 20;
		if (!Stream_ReadBytes(&self->base.base.base, self->havePaletteChange, 0, havePaletteChangeLength))
			return FALSE;
		self->compressed = FALSE;
		break;
	case 1:
		self->treeOffset = self->base.base.base.contentOffset + 28;
		if (self->treeOffset > self->base.base.base.contentLength)
			return FALSE;
		treeLength = RECOIL_Get32BigEndian(self->base.base.base.content, self->base.base.base.contentOffset + 20);
		if (treeLength < 2 || treeLength > 1022)
			return FALSE;
		self->base.base.base.contentOffset = self->treeOffset + treeLength;
		self->treeLastOffset = self->base.base.base.contentOffset - 2;
		{
			int i;
			for (i = 0; i < havePaletteChangeLength; i++) {
				int b = PchgPalette_ReadHuffman(self);
				if (b < 0)
					return FALSE;
				self->havePaletteChange[i] = b;
			}
		}
		self->compressed = TRUE;
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

static int PchgPalette_ReadHuffman(PchgPalette *self)
{
	int offset = self->treeLastOffset;
	for (;;) {
		switch (BitStream_ReadBit(&self->base.base)) {
			int hi;
			int lo;
		case 0:
			offset -= 2;
			if (offset < self->treeOffset)
				return -1;
			if ((self->base.base.base.content[offset] & 129) == 1)
				return self->base.base.base.content[offset + 1];
			break;
		case 1:
			hi = self->base.base.base.content[offset];
			lo = self->base.base.base.content[offset + 1];
			if (hi < 128)
				return lo;
			offset += ((hi - 256) << 8) | lo;
			if (offset < self->treeOffset)
				return -1;
			break;
		default:
			return -1;
		}
	}
}

static void PchgPalette_SetLinePalette(PchgPalette *self, RECOIL *recoil, int y)
{
	int count;
	int count2;
	y -= self->startLine;
	if (y < 0 || y >= self->lineCount)
		return;
	if (((self->havePaletteChange[y >> 3] >> (~y & 7)) & 1) == 0)
		return;
	count = PchgPalette_UnpackByte(self);
	if (count < 0)
		return;
	count2 = PchgPalette_UnpackByte(self);
	if (count2 < 0)
		return;
	if (self->ocs) {
		PchgPalette_SetOcsColors(self, recoil, 0, count);
		PchgPalette_SetOcsColors(self, recoil, 16, count2);
	}
	else {
		count = (count << 8) | count2;
		while (--count >= 0) {
			int c;
			int r;
			int b;
			int g;
			if (PchgPalette_UnpackByte(self) != 0)
				return;
			c = PchgPalette_UnpackByte(self);
			if (c < 0 || PchgPalette_UnpackByte(self) < 0)
				return;
			r = PchgPalette_UnpackByte(self);
			if (r < 0)
				return;
			b = PchgPalette_UnpackByte(self);
			if (b < 0)
				return;
			g = PchgPalette_UnpackByte(self);
			if (g < 0)
				return;
			recoil->contentPalette[c] = (r << 16) | (g << 8) | b;
		}
	}
}

static void PchgPalette_SetOcsColors(PchgPalette *self, RECOIL *recoil, int paletteOffset, int count)
{
	while (--count >= 0) {
		int rr = PchgPalette_UnpackByte(self);
		int gb;
		if (rr < 0)
			return;
		gb = PchgPalette_UnpackByte(self);
		if (gb < 0)
			return;
		recoil->contentPalette[paletteOffset + (rr >> 4)] = MultiPalette_GetOcsColor(rr, gb);
	}
}

static int PchgPalette_UnpackByte(PchgPalette *self)
{
	return self->compressed ? PchgPalette_ReadHuffman(self) : Stream_ReadByte(&self->base.base.base);
}

static void PcsStream_Construct(PcsStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_PcsStream;
	TnyPcsStream_Construct(&self->base, vtbl);
}

static int PcsStream_ReadValue(PcsStream *self)
{
	int value;
	if (!self->palette)
		return Stream_ReadByte(&self->base.base.base.base);
	if (self->base.base.base.base.contentOffset >= self->base.base.base.base.contentLength - 1)
		return -1;
	value = (self->base.base.base.base.content[self->base.base.base.base.contentOffset] << 8) | self->base.base.base.base.content[self->base.base.base.base.contentOffset + 1];
	self->base.base.base.base.contentOffset += 2;
	return value;
}

static cibool PcsStream_UnpackPcs(PcsStream *self, unsigned char *unpacked)
{
	self->base.base.base.base.contentOffset += 2;
	self->palette = FALSE;
	if (!RleStream_Unpack(&self->base.base, unpacked, 0, 1, 32000) || self->base.base.repeatCount != 0)
		return FALSE;
	self->base.base.base.base.contentOffset += 2;
	self->palette = TRUE;
	{
		int unpackedOffset;
		for (unpackedOffset = 32000; unpackedOffset < 51232; unpackedOffset += 2) {
			int b = RleStream_ReadRle(&self->base.base);
			if (b < 0)
				return FALSE;
			unpacked[unpackedOffset] = b >> 8;
			unpacked[unpackedOffset + 1] = (unsigned char) b;
		}
	}
	return TRUE;
}

static void PgcStream_Construct(PgcStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_PgcStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool PgcStream_ReadCommand(PgcStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b < 128) {
		self->base.repeatCount = b;
		self->base.repeatValue = -1;
	}
	else {
		self->base.repeatCount = b - 128;
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
	}
	return TRUE;
}

static void PgrRenderer_Construct(PgrRenderer *self, const GtiaRendererVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_PgrRenderer;
	GtiaRenderer_Construct(&self->base, vtbl);
}

static int PgrRenderer_GetPlayfieldByte(PgrRenderer const *self, int y, int column)
{
	return self->base.content[self->screenOffset + column];
}

static void Q4Stream_Construct(Q4Stream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_Q4Stream;
	RleStream_Construct(&self->base, vtbl);
}

static int Q4Stream_ReadCode(Q4Stream *self)
{
	for (;;) {
		int value = BitStream_ReadBits(&self->base.base, self->codeBits);
		if (value >= 2)
			return value - 2;
		if (value <= 0 || ++self->codeBits > 15)
			return -1;
	}
}

static cibool Q4Stream_ReadCommand(Q4Stream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b < 16) {
		self->base.repeatCount = 1;
		self->base.repeatValue = b;
		return TRUE;
	}
	b = Stream_ReadByte(&self->base.base.base);
	if (b == 0) {
		self->lastRepeatValue = Stream_ReadByte(&self->base.base.base);
		if (self->lastRepeatValue < 0 || self->lastRepeatValue >= 16)
			return FALSE;
		b = Stream_ReadByte(&self->base.base.base);
	}
	if (b < 0)
		return FALSE;
	self->base.repeatCount = b * 17;
	b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	self->base.repeatCount += b;
	self->base.repeatValue = self->lastRepeatValue;
	return TRUE;
}

static int Q4Stream_StartChunk(Q4Stream *self)
{
	int chunkLength;
	if (self->base.base.base.contentOffset + 6 > self->base.base.base.contentLength)
		return -1;
	chunkLength = self->base.base.base.content[self->base.base.base.contentOffset] | (self->base.base.base.content[self->base.base.base.contentOffset + 1] << 8);
	self->base.base.base.contentOffset += 6;
	self->base.base.base.contentLength = self->base.base.base.contentOffset + chunkLength;
	return self->base.base.base.contentLength;
}

static cibool Q4Stream_Unpack(Q4Stream *self)
{
	int unpackedLength;
	int offsets[16384];
	self->base.base.bits = 0;
	self->codeBits = 3;
	unpackedLength = 0;
	{
		int codes;
		for (codes = 17; codes < 16384; codes++) {
			int code = Q4Stream_ReadCode(self);
			if (code < 0 || code >= codes) {
				self->base.base.base.content = self->unpacked;
				self->base.base.base.contentOffset = 0;
				self->base.base.base.contentLength = unpackedLength;
				self->lastRepeatValue = 0;
				return TRUE;
			}
			offsets[codes] = unpackedLength;
			if (code <= 16) {
				if (unpackedLength >= 65536)
					return FALSE;
				self->unpacked[unpackedLength++] = code;
			}
			else {
				int sourceOffset = offsets[code];
				int endOffset = offsets[code + 1];
				if (unpackedLength + endOffset - sourceOffset >= 65536)
					return FALSE;
				do
					self->unpacked[unpackedLength++] = self->unpacked[sourceOffset++];
				while (sourceOffset <= endOffset);
			}
		}
	}
	return FALSE;
}

static void RECOIL_Construct(RECOIL *self, const RECOILVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_RECOIL;
	self->vtbl = vtbl;
	RECOIL_SetAtari8Palette(self, NULL);
}

RECOIL *RECOIL_New(void)
{
	RECOIL *self = (RECOIL *) malloc(sizeof(RECOIL));
	if (self != NULL)
		RECOIL_Construct(self, NULL);
	return self;
}

void RECOIL_Delete(RECOIL *self)
{
	free(self);
}

static cibool RECOIL_ApplyAtari8Palette(RECOIL *self, unsigned char const *frame)
{
	int pixelsLength = self->width * self->height;
	{
		int i;
		for (i = 0; i < pixelsLength; i++)
			self->pixels[i] = self->atari8Palette[frame[i]];
	}
	return TRUE;
}

static cibool RECOIL_ApplyAtari8PaletteBlend(RECOIL *self, unsigned char const *frame1, unsigned char const *frame2)
{
	int pixelsLength = self->width * self->height;
	self->frames = 2;
	{
		int i;
		for (i = 0; i < pixelsLength; i++) {
			int rgb1 = self->atari8Palette[frame1[i]];
			int rgb2 = self->atari8Palette[frame2[i]];
			self->pixels[i] = (rgb1 & rgb2) + (((rgb1 ^ rgb2) >> 1) & 8355711);
		}
	}
	return TRUE;
}

static cibool RECOIL_ApplyAtari8PaletteBlend3(RECOIL *self, unsigned char const *frame1, unsigned char const *frame2, unsigned char const *frame3)
{
	int pixelsLength = self->width * self->height;
	self->frames = 3;
	{
		int i;
		for (i = 0; i < pixelsLength; i++) {
			int rgb1 = self->atari8Palette[frame1[i]];
			int rgb2 = self->atari8Palette[frame2[i]];
			int rgb3 = self->atari8Palette[frame3[i]];
			self->pixels[i] = (((rgb1 >> 16) + (rgb2 >> 16) + (rgb3 >> 16)) / 3 << 16) | ((((rgb1 >> 8) & 255) + ((rgb2 >> 8) & 255) + ((rgb3 >> 8) & 255)) / 3 << 8) | ((rgb1 & 255) + (rgb2 & 255) + (rgb3 & 255)) / 3;
		}
	}
	return TRUE;
}

static cibool RECOIL_ApplyBlend(RECOIL *self)
{
	int pixelsLength = self->width * self->height;
	self->frames = 2;
	{
		int i;
		for (i = 0; i < pixelsLength; i++) {
			int rgb1 = self->pixels[i];
			int rgb2 = self->pixels[pixelsLength + i];
			self->pixels[i] = (rgb1 & rgb2) + (((rgb1 ^ rgb2) >> 1) & 8355711);
		}
	}
	return TRUE;
}

static void RECOIL_CalculatePalette(RECOIL *self)
{
	int pixelsCount;
	memset(self->colorInUse, 0, sizeof(self->colorInUse));
	self->colors = 0;
	memset(self->palette, 0, sizeof(self->palette));
	pixelsCount = self->width * self->height;
	{
		int pixelsOffset;
		for (pixelsOffset = 0; pixelsOffset < pixelsCount; pixelsOffset++) {
			int rgb = self->pixels[pixelsOffset];
			int i = rgb >> 3;
			int mask = 1 << (rgb & 7);
			if ((self->colorInUse[i] & mask) == 0) {
				self->colorInUse[i] |= mask;
				if (self->colors < 256)
					self->palette[self->colors] = rgb;
				self->colors++;
			}
		}
	}
}

static cibool RECOIL_CopyPrevious(unsigned char *unpacked, int unpackedOffset, int distance, int count)
{
	if (distance > unpackedOffset)
		return FALSE;
	do {
		unpacked[unpackedOffset] = unpacked[unpackedOffset - distance];
		unpackedOffset++;
	}
	while (--count > 0);
	return TRUE;
}

static int RECOIL_CopyPscLines(unsigned char *unpacked, int unpackedOffset, int count)
{
	if (unpackedOffset < 80 || unpackedOffset + count * 80 > 32000)
		return -1;
	do {
		memcpy(unpacked + unpackedOffset, unpacked + unpackedOffset - 80, 80);
		unpackedOffset += 80;
	}
	while (--count > 0);
	return unpackedOffset;
}

cibool RECOIL_Decode(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	switch (RECOIL_GetPackedExt(filename)) {
	case 540423474:
		return RECOIL_Decode256(self, content, contentLength);
	case 538976307:
		return RECOIL_Decode3(self, content, contentLength);
	case 544498228:
		return RECOIL_Decode4bt(self, content, contentLength);
	case 543780148:
		return RECOIL_Decode4mi(self, content, contentLength);
	case 543977524:
		return RECOIL_Decode4pl(self, content, contentLength);
	case 544043060:
		return RECOIL_Decode4pm(self, content, contentLength);
	case 543372342:
		return RECOIL_Decode64c(self, content, contentLength);
	case 538976353:
		return RECOIL_DecodeA(self, content, contentLength);
	case 544355425:
		return RECOIL_DecodeA4r(self, content, contentLength);
	case 540292705:
	case 543648119:
		return contentLength == 10242 && RECOIL_DecodeC64Multicolor(self, 320, content, 2, 8194, 9218, content[10241]);
	case 544432481:
	case 543715433:
		return RECOIL_DecodeIph(self, content, contentLength);
	case 544432993:
		return RECOIL_DecodeAcs(self, content, contentLength);
	case 543975009:
		return RECOIL_DecodeAfl(self, content, contentLength);
	case 544237409:
		return RECOIL_DecodeAgp(self, content, contentLength);
	case 543976545:
		return RECOIL_DecodeAll(self, content, contentLength);
	case 543780193:
		return RECOIL_DecodeAmi(self, content, contentLength);
	case 540176481:
		return RECOIL_Decode256(self, content, contentLength);
	case 540242017:
	case 544632929:
	case 543778660:
	case 544237412:
	case 543388517:
	case 543386729:
	case 544045680:
		return RECOIL_DecodeAp3(self, content, contentLength);
	case 543387745:
		return RECOIL_DecodeApc(self, content, contentLength);
	case 543977569:
		return RECOIL_DecodeApl(self, content, contentLength);
	case 544239713:
		return RECOIL_DecodeApp(self, content, contentLength);
	case 544502369:
		return RECOIL_DecodeIph(self, content, contentLength) || RECOIL_DecodeArtDirector(self, content, contentLength) || RECOIL_DecodeGfaArtist(self, content, contentLength) || RECOIL_DecodeAtari8Artist(self, content, contentLength) || RECOIL_DecodeAsciiArtEditor(self, content, contentLength);
	case 544371809:
		return RECOIL_DecodeAtr(self, content, contentLength);
	case 544679522:
	case 544702306:
		return RECOIL_DecodeBw(self, content, contentLength);
	case 540041826:
		return RECOIL_DecodeBb0(self, content, contentLength, RECOIL_BbcPalette1Bit);
	case 540107362:
		return RECOIL_DecodeBb1(self, content, contentLength, RECOIL_BbcPalette2Bit);
	case 540172898:
		return RECOIL_DecodeBb2(self, content, contentLength, RECOIL_BbcPalette);
	case 540303970:
		return RECOIL_DecodeBb4(self, content, contentLength, RECOIL_BbcPalette1Bit);
	case 540369506:
		return RECOIL_DecodeBb5(self, content, contentLength, RECOIL_BbcPalette2Bit);
	case 543646306:
		return RECOIL_DecodeBbg(self, content, contentLength);
	case 1768711778:
		return RECOIL_DecodeBfli(self, content, contentLength);
	case 540632930:
	case 540618855:
		return RECOIL_DecodeG09(self, content, contentLength);
	case 544237410:
		return RECOIL_DecodeBgp(self, content, contentLength);
	case 543648610:
		return RECOIL_DecodeBkg(self, content, contentLength);
	case 1937076834:
	case 538996841:
	case 1952672112:
		return RECOIL_DecodeBrus(self, content, contentLength);
	case 540109922:
	case 540175458:
	case 540240994:
		return RECOIL_DecodeIff(self, content, contentLength, RECOILResolution_ST1X1);
	case 543452258:
		return RECOIL_DecodeBld(self, content, contentLength);
	case 543976802:
		return RECOIL_DecodeBml(self, content, contentLength);
	case 544567906:
		return RECOIL_DecodeBru(self, content, contentLength);
	case 543388514:
	case 878931298:
		return RECOIL_DecodeBsc(self, content, contentLength);
	case 540107107:
	case 540172643:
	case 540238179:
		return RECOIL_DecodeCa(self, content, contentLength);
	case 543777635:
		return RECOIL_DecodeCci(self, content, contentLength);
	case 544564323:
		return contentLength == 10277 && RECOIL_DecodeC64Multicolor(self, 320, content, 275, 8275, 9275, content[10275]);
	case 540108131:
	case 540173667:
	case 540239203:
		return RECOIL_DecodeCe(self, content, contentLength);
	case 543974755:
		return RECOIL_DecodeCel(self, content, contentLength);
	case 539256931:
		return RECOIL_DecodeChrd(self, content, contentLength);
	case 540305507:
	case 540436579:
	case 540567651:
		return RECOIL_DecodeCh8(self, content, contentLength);
	case 543516771:
		return contentLength == 20482 && RECOIL_DecodeC64Multicolor(self, 320, content, 2, 16898, 18434, 0);
	case 544368739:
		return RECOIL_DecodeChr(self, content, contentLength);
	case 544434275:
		return RECOIL_DecodeChs(self, content, contentLength);
	case 544106851:
		return RECOIL_DecodeCin(self, content, contentLength);
	case 544238691:
		return RECOIL_DecodeClp(self, content, contentLength);
	case 540372323:
		return RECOIL_DecodeCm5(self, filename, content, contentLength);
	case 544238947:
		return RECOIL_DecodeCmp(self, content, contentLength);
	case 540242019:
		return RECOIL_DecodeCp3(self, content, contentLength);
	case 543780963:
		return RECOIL_DecodeCpi(self, content, contentLength);
	case 544370787:
		return RECOIL_DecodeCpr(self, content, contentLength);
	case 544501859:
		return RECOIL_DecodeCpt(self, content, contentLength);
	case 543650403:
		return RECOIL_DecodeCrg(self, content, contentLength);
	case 544503139:
		return RECOIL_DecodeGr8Raw(self, content, contentLength, 96, 99);
	case 543651683:
		return contentLength == 10007 && RECOIL_DecodeC64Multicolor(self, 320, content, 2, 8002, 9002, content[10003]);
	case 540303716:
		return RECOIL_DecodeDa4(self, content, contentLength);
	case 544235876:
		return RECOIL_DecodeDap(self, content, contentLength);
	case 540107620:
		return RECOIL_DecodeDc1(self, content, contentLength);
	case 538993764:
		return RECOIL_DecodeDd(self, content, contentLength);
	case 543974756:
		return RECOIL_DecodeDel(self, content, contentLength);
	case 540108644:
		return RECOIL_DecodeDg1(self, content, contentLength);
	case 544368740:
		return RECOIL_DecodeIff(self, content, contentLength, RECOILResolution_AMIGA1X1) || RECOIL_DecodeAppleIIDhr(self, content, contentLength);
	case 544106852:
		return RECOIL_DecodeAtari8Ice(self, content, contentLength, FALSE, 3);
	case 544500068:
		return RECOIL_DecodeDit(self, content, contentLength);
	case 544042084:
		return RECOIL_DecodeDlm(self, content, contentLength);
	case 543977316:
	case 543451510:
		return RECOIL_DecodeDol(self, content, contentLength);
	case 544173924:
		return RECOIL_DecodeDoo(self, content, contentLength);
	case 543715428:
		return RECOIL_DecodeDph(self, content, contentLength);
	case 543650404:
		return RECOIL_DecodeDrg(self, content, contentLength);
	case 543978084:
	case 544238692:
		return RECOIL_DecodeDrl(self, content, contentLength);
	case 544895588:
	case 544240228:
		return RECOIL_DecodeDrz(self, content, contentLength);
	case 540112228:
	case 544175460:
		return RECOIL_DecodeDuo(self, content, contentLength);
	case 540177764:
		return RECOIL_DecodeDu2(self, content, contentLength);
	case 543777637:
		return RECOIL_DecodeEci(self, content, contentLength);
	case 544236389:
		return RECOIL_DecodeEcp(self, content, contentLength);
	case 543256677:
		return RECOIL_DecodeEpa(self, content, contentLength);
	case 544043877:
		return RECOIL_DecodeEsm(self, content, contentLength);
	case 543259237:
		return RECOIL_DecodeEza(self, content, contentLength);
	case 540173414:
		return RECOIL_DecodeFli(self, content, contentLength);
	case 1768711782:
		return RECOIL_DecodeFfli(self, content, contentLength);
	case 543516518:
		return RECOIL_DecodeFge(self, content, contentLength);
	case 543779942:
		return RECOIL_DecodeFli(self, content, contentLength) || RECOIL_DecodeBml(self, content, contentLength);
	case 544501350:
		return RECOIL_DecodePct(self, content, contentLength) || RECOIL_DecodeGdosFnt(self, content, contentLength) || RECOIL_DecodeAtari8Fnt(self, content, contentLength) || RECOIL_DecodeStFnt(self, content, contentLength) || RECOIL_DecodeAmstradFnt(self, content, contentLength) || RECOIL_DecodeImage72Fnt(self, content, contentLength);
	case 540176486:
		return RECOIL_DecodeC64Fun(self, content, contentLength);
	case 544501862:
		return contentLength == 10004 && RECOIL_DecodeC64Multicolor(self, 320, content, 2, 8002, 9002, content[10002]);
	case 543388774:
		return RECOIL_DecodeFtc(self, content, contentLength);
	case 544109926:
		return RECOIL_DecodeC64Fun(self, content, contentLength) || RECOIL_DecodeFalconFun(self, content, contentLength);
	case 543258470:
		return RECOIL_DecodeFwa(self, content, contentLength);
	case 538976359:
		return RECOIL_DecodeG(self, content, contentLength);
	case 540029287:
		return RECOIL_DecodeG10(self, content, contentLength);
	case 540094823:
		return RECOIL_DecodeG11(self, content, contentLength);
	case 543568487:
		return RECOIL_DecodeG2f(self, content, contentLength);
	case 543450471:
		return RECOIL_DecodeGed(self, content, contentLength);
	case 543319655:
		return RECOIL_DecodeGfb(self, content, contentLength);
	case 538994535:
		return RECOIL_DecodeGg(self, content, contentLength);
	case 543647847:
		return RECOIL_DecodeGhg(self, content, contentLength);
	case 540372071:
		return RECOIL_DecodeGl5(self, filename, content, contentLength);
	case 540437607:
		return RECOIL_DecodeGl6(self, filename, content, contentLength);
	case 540503143:
		return RECOIL_DecodeGl7(self, filename, content, contentLength);
	case 540568679:
		return RECOIL_DecodeGl8(self, content, contentLength);
	case 543255655:
		return RECOIL_DecodeGlYjk(self, filename, content, contentLength);
	case 543386727:
	case 544435303:
		return RECOIL_DecodeGlYjk(self, NULL, content, contentLength);
	case 543453031:
		return RECOIL_DecodeGod(self, content, contentLength);
	case 540111463:
		return RECOIL_DecodeGr1(self, content, contentLength, 0);
	case 540176999:
		return RECOIL_DecodeGr1(self, content, contentLength, 1);
	case 540242535:
		return RECOIL_DecodeGr3(self, content, contentLength);
	case 540504679:
		return RECOIL_DecodeGr7(self, content, 0, contentLength);
	case 540570215:
		return RECOIL_DecodeGr8(self, content, contentLength);
	case 540635751:
		return RECOIL_DecodeGr9(self, content, contentLength);
	case 544240231:
		return RECOIL_DecodeSc2(self, content, contentLength);
	case 544109927:
		return RECOIL_DecodeGun(self, content, contentLength);
	case 544039784:
		return RECOIL_DecodeHcm(self, content, contentLength);
	case 543450472:
		return RECOIL_DecodeHed(self, content, contentLength);
	case 543385192:
		return RECOIL_DecodeHfc(self, content, contentLength);
	case 543319912:
		return RECOIL_DecodeHgb(self, content, contentLength);
	case 544368488:
		return RECOIL_DecodeHgr(self, content, contentLength);
	case 544041320:
		return RECOIL_DecodeHim(self, content, contentLength);
	case 544237928:
		return RECOIL_DecodeHip(self, content, contentLength);
	case 544369000:
		return RECOIL_DecodeFalconHir(self, content, contentLength) || RECOIL_DecodeC64Hir(self, content, contentLength) || RECOIL_DecodeHrs(self, content, contentLength);
	case 544039528:
	case 543713639:
	case 544434022:
	case 544108397:
	case 543449959:
		return RECOIL_DecodeC64Hir(self, content, contentLength);
	case 543583336:
		return RECOIL_DecodeHlf(self, content, contentLength);
	case 544369768:
		return RECOIL_DecodeHlr(self, content, contentLength);
	case 543387752:
		return RECOIL_DecodeIph(self, content, contentLength);
	case 544043112:
		return RECOIL_DecodeHpm(self, content, contentLength);
	case 538997352:
		return RECOIL_DecodeTrsHr(self, content, contentLength) || RECOIL_DecodeAtari8Hr(self, content, contentLength);
	case 540177000:
	case 543777640:
		return RECOIL_DecodeHr2(self, content, contentLength);
	case 544043624:
		return RECOIL_DecodeHrm(self, content, contentLength);
	case 544436840:
		return RECOIL_DecodeHrs(self, content, contentLength);
	case 540238441:
	case 543777385:
		return RECOIL_DecodeIbi(self, content, contentLength);
	case 540107625:
	case 540173161:
	case 540238697:
		return RECOIL_DecodeIc(self, content, contentLength);
	case 543515497:
		return contentLength > 1024 && RECOIL_DecodeAtari8Ice(self, content, contentLength, TRUE, content[0]);
	case 544105321:
		return RECOIL_DecodeStIcn(self, content, contentLength) || RECOIL_DecodeAtari8Ice(self, content, contentLength, FALSE, 17);
	case 543581801:
	case 1835164513:
	case 1835099490:
	case 1885693284:
	case 538997348:
	case 913138024:
	case 946692456:
	case 544039532:
	case 1835166825:
	case 538996845:
	case 945973106:
	case 1851942770:
	case 1835100275:
		return RECOIL_DecodeIff(self, content, contentLength, RECOILResolution_AMIGA1X1);
	case 543975017:
		return RECOIL_DecodeGun(self, content, contentLength) || RECOIL_DecodeZxIfl(self, content, contentLength);
	case 543516521:
		return RECOIL_DecodeIge(self, content, contentLength);
	case 543516777:
		return RECOIL_DecodeIhe(self, content, contentLength);
	case 544041321:
		return RECOIL_DecodeIim(self, content, contentLength);
	case 543452265:
		return RECOIL_DecodeIld(self, content, contentLength);
	case 543649129:
		return RECOIL_DecodeStImg(self, content, contentLength) || RECOIL_DecodeZxImg(self, content, contentLength);
	case 1735223668:
	case 1735223672:
		return RECOIL_DecodeStImg(self, content, contentLength);
	case 544107881:
		return RECOIL_DecodeAtari8Ice(self, content, contentLength, FALSE, 18);
	case 1868983913:
		return RECOIL_DecodeInfo(self, content, contentLength);
	case 543649385:
	case 544239209:
		return RECOIL_DecodeInp(self, content, contentLength);
	case 544501353:
		return RECOIL_DecodeInt(self, content, contentLength) || RECOIL_DecodeInp(self, content, contentLength);
	case 540176489:
		return RECOIL_DecodeIp2(self, content, contentLength);
	case 543387753:
		return RECOIL_DecodeAtari8Ice(self, content, contentLength, FALSE, 19);
	case 544501865:
		return contentLength == 10003 && RECOIL_DecodeC64Multicolor(self, 320, content, 2, 8002, 9002, content[10002]);
	case 540177001:
		return RECOIL_DecodeAtari8Ice(self, content, contentLength, FALSE, 2);
	case 543650409:
		return RECOIL_DecodeAtari8Ice(self, content, contentLength, FALSE, 1);
	case 544043881:
		return contentLength == 10218 && RECOIL_DecodeC64Multicolor(self, 320, content, 1026, 9218, 2, content[9217]);
	case 544502633:
		return RECOIL_DecodeIst(self, content, contentLength);
	case 544237418:
		return RECOIL_DecodeJgp(self, content, contentLength);
	case 538995306:
		return RECOIL_DecodeJj(self, content, contentLength);
	case 544761451:
		return RECOIL_DecodeGr8Raw(self, content, contentLength, 56, 60);
	case 543451499:
		return RECOIL_DecodeKid(self, content, contentLength);
	case 543255659:
	case 543256427:
	case 543648103:
	case 544043122:
		return RECOIL_DecodeKoa(self, content, contentLength);
	case 544370795:
		return RECOIL_DecodeKpr(self, content, contentLength);
	case 544437099:
		return RECOIL_DecodeKss(self, content, contentLength);
	case 544040044:
		return RECOIL_DecodeLdm(self, content, contentLength);
	case 544171372:
		return RECOIL_DecodeLeo(self, content, contentLength);
	case 540242028:
		return RECOIL_DecodeLp3(self, content, contentLength);
	case 543912044:
		return RECOIL_DecodeDaliCompressed(self, content, contentLength, 0);
	case 543912045:
		return RECOIL_DecodeDaliCompressed(self, content, contentLength, 1);
	case 543912040:
		return RECOIL_DecodeDaliCompressed(self, content, contentLength, 2);
	case 544044396:
		return RECOIL_DecodeLum(self, filename, content, contentLength);
	case 543383917:
	case 1735683696:
		return RECOIL_DecodeMac(self, content, contentLength);
	case 543646061:
	case 543779693:
		return RECOIL_DecodeMag(self, content, contentLength);
	case 544235885:
		return RECOIL_DecodeEnvision(self, content, contentLength) || RECOIL_DecodeEnvisionPC(self, content, contentLength);
	case 544760173:
		return RECOIL_DecodeMag(self, content, contentLength) || RECOIL_DecodeAtari8Max(self, content, contentLength) || RECOIL_DecodeCocoMax(self, content, contentLength);
	case 543646317:
		return RECOIL_DecodeGr8Raw(self, content, contentLength, 512, 256);
	case 538993517:
		return RECOIL_DecodeMcMlt(self, content, contentLength, -1);
	case 543712109:
		return RECOIL_DecodeMch(self, content, contentLength);
	case 543777645:
		return RECOIL_DecodeMci(self, content, contentLength);
	case 544236397:
		return RECOIL_DecodeMcp(self, content, contentLength);
	case 1886413677:
		return RECOIL_DecodeMcpp(self, content, contentLength);
	case 544433005:
		return RECOIL_DecodeMcs(self, content, contentLength);
	case 540108653:
	case 540174189:
	case 540305261:
	case 540567405:
		return RECOIL_DecodeMg(self, content, contentLength);
	case 544237421:
		return RECOIL_DecodeMgp(self, content, contentLength);
	case 543385965:
		return RECOIL_DecodeMic(self, content, contentLength);
	case 543975789:
		return contentLength == 10022 && RECOIL_DecodeC64Multicolor(self, 320, content, 2022, 22, 1022, 0);
	case 544434541:
		return RECOIL_DecodeMis(self, content, contentLength);
	case 543517805:
		return RECOIL_DecodeMle(self, content, contentLength);
	case 544500845:
		return RECOIL_DecodeMcMlt(self, content, contentLength, 0);
	case 544239725:
		return RECOIL_DecodeMpp(self, content, contentLength);
	case 544240493:
		return RECOIL_DecodeMsp(self, content, contentLength);
	case 544372077:
		return RECOIL_DecodeMur(self, filename, content, contentLength);
	case 544171374:
		return RECOIL_DecodeNeo(self, filename, content, contentLength) || RECOIL_DecodeIff(self, content, contentLength, RECOILResolution_STE1X1);
	case 544304238:
		return RECOIL_DecodeNlq(self, content, contentLength);
	case 544236399:
		return RECOIL_DecodeOcp(self, content, contentLength);
	case 538976368:
		return RECOIL_DecodeP(self, content, contentLength);
	case 540094832:
		return RECOIL_DecodeP11(self, content, contentLength);
	case 543372144:
		return RECOIL_DecodeP3c(self, content, contentLength);
	case 540095600:
	case 543584871:
		return RECOIL_DecodeCocoMax(self, content, contentLength);
	case 543765616:
		return RECOIL_DecodeP4i(self, content, contentLength);
	case 540292720:
		return contentLength == 10050 && RECOIL_DecodeC64Multicolor(self, 320, content, 2050, 1026, 2, content[2049]);
	case 543383920:
		return RECOIL_DecodePac(self, content, contentLength);
	case 544760432:
		return RECOIL_DecodePbx(self, content, contentLength);
	case 540107632:
	case 540173168:
	case 540238704:
		return RECOIL_DecodePc(self, content, contentLength);
	case 543777648:
		return RECOIL_DecodePci(self, content, contentLength);
	case 544433008:
		return RECOIL_DecodePcs(self, content, contentLength);
	case 544498544:
		return RECOIL_DecodePct(self, content, contentLength);
	case 544499056:
		return RECOIL_DecodePet(self, content, contentLength);
	case 540108656:
	case 540174192:
		return RECOIL_DecodeSc(self, content, contentLength) || RECOIL_DecodeGraphicsProcessor(self, content, contentLength);
	case 540239728:
		return RECOIL_DecodeGraphicsProcessor(self, content, contentLength);
	case 543385456:
		return RECOIL_DecodePgc(self, content, contentLength);
	case 543582064:
		return RECOIL_DecodePgf(self, content, contentLength);
	case 544368496:
		return RECOIL_DecodePgr(self, content, contentLength);
	case 538995056:
		return contentLength == 10242 && RECOIL_DecodeC64Multicolor(self, 320, content, 2, 8194, 9218, content[8066]);
	case 540109168:
	case 540174704:
	case 540240240:
	case 540371312:
	case 540436848:
	case 543716723:
		return RECOIL_DecodeStPi(self, content, contentLength);
	case 540305776:
		return RECOIL_DecodeFuckpaint(self, content, contentLength) || RECOIL_DecodeStPi(self, content, contentLength);
	case 540502384:
	case 540633456:
		return RECOIL_DecodeFuckpaint(self, content, contentLength);
	case 543385968:
		return RECOIL_DecodePic(self, content, contentLength);
	case 544762224:
		return RECOIL_DecodeFalconPix(self, content, contentLength) || RECOIL_DecodeCocoMax(self, content, contentLength);
	case 540306544:
		return RECOIL_DecodePl4(self, content, contentLength);
	case 543255664:
		return RECOIL_DecodePla(self, content, contentLength);
	case 544042096:
		return RECOIL_DecodeApc(self, content, contentLength);
	case 543452528:
		return RECOIL_DecodePmd(self, content, contentLength);
	case 543649136:
		return RECOIL_DecodePmg(self, content, contentLength);
	case 544501360:
		return RECOIL_DecodePnt(self, content, contentLength) || RECOIL_DecodeMac(self, content, contentLength);
	case 543715440:
		return RECOIL_DecodePph(self, filename, content, contentLength);
	case 544239728:
	case 540238192:
		return RECOIL_DecodePpp(self, content, contentLength);
	case 543388528:
		return RECOIL_DecodePsc(self, content, contentLength);
	case 538981489:
		return RECOIL_DecodeQ4(self, content, contentLength);
	case 543646066:
		return RECOIL_DecodeRag(self, content, contentLength);
	case 544235890:
		return RECOIL_DecodeRap(self, content, contentLength);
	case 544694642:
		return RECOIL_DecodeZx81Raw(self, content, contentLength) || RECOIL_DecodeAtari8Raw(self, content, contentLength) || RECOIL_DecodeRw(self, content, contentLength);
	case 543319922:
		return RECOIL_DecodeStRgb(self, content, contentLength) || RECOIL_DecodeAtari8Rgb(self, content, contentLength) || RECOIL_DecodeZxRgb(self, content, contentLength);
	case 543713138:
		return RECOIL_DecodeRgh(self, content, contentLength);
	case 544237938:
		return RECOIL_DecodeRip(self, content, contentLength);
	case 543517810:
		return RECOIL_DecodeRle(self, content, contentLength);
	case 540044658:
		return RECOIL_DecodeRm(self, content, contentLength, 0, RECOILResolution_XE2X2);
	case 540110194:
		return RECOIL_DecodeRm(self, content, contentLength, 1, RECOILResolution_XE4X1);
	case 540175730:
		return RECOIL_DecodeRm(self, content, contentLength, 2, RECOILResolution_XE4X1);
	case 540241266:
		return RECOIL_DecodeRm(self, content, contentLength, 3, RECOILResolution_XE4X1);
	case 540306802:
		return RECOIL_DecodeRm(self, content, contentLength, 4, RECOILResolution_XE2X1);
	case 538996850:
		return contentLength == 10242 && RECOIL_DecodeC64Multicolor(self, 320, content, 1026, 2, 9218, 0);
	case 543717234:
	case 543979378:
		return RECOIL_DecodeRw(self, content, contentLength);
	case 544438642:
		return RECOIL_DecodeRys(self, content, contentLength);
	case 544366963:
		return contentLength == 10219 && RECOIL_DecodeC64Multicolor(self, 320, content, 1026, 2, 9218, content[1010]);
	case 540044387:
	case 540109923:
	case 540175459:
	case 540043120:
	case 540042099:
	case 540107635:
		return RECOIL_DecodeSc(self, content, contentLength);
	case 540173171:
		return RECOIL_DecodeSc(self, content, contentLength) || RECOIL_DecodeSc2(self, content, contentLength);
	case 540238707:
		return RECOIL_DecodeSc3(self, content, contentLength);
	case 540304243:
		return RECOIL_DecodeSc4(self, content, contentLength);
	case 540369779:
	case 540370279:
		return RECOIL_DecodeSc5(self, filename, content, contentLength);
	case 540435315:
		return RECOIL_DecodeSc6(self, filename, content, contentLength);
	case 540500851:
	case 540501351:
		return RECOIL_DecodeSc7(self, filename, content, contentLength);
	case 540566387:
	case 540566887:
	case 540570227:
		return RECOIL_DecodeSc8(self, filename, content, contentLength);
	case 543253363:
		return RECOIL_DecodeSca(self, filename, content, contentLength);
	case 543384435:
	case 544436851:
	case 543910521:
		return RECOIL_DecodeScc(self, filename, content, contentLength);
	case 544367475:
		return RECOIL_DecodeScr(self, filename, content, contentLength);
	case 879977331:
	case 540308339:
		return RECOIL_DecodeScs4(self, content, contentLength);
	case 540042355:
		return RECOIL_DecodeSd(self, content, contentLength, 0);
	case 540107891:
		return RECOIL_DecodeSd(self, content, contentLength, 1);
	case 540173427:
		return RECOIL_DecodeSd(self, content, contentLength, 2);
	case 540239731:
		return RECOIL_DecodeSg3(self, content, contentLength);
	case 543516531:
		return RECOIL_DecodeSge(self, content, contentLength);
	case 540239987:
		return RECOIL_DecodeSh3(self, content, contentLength);
	case 543385715:
		return RECOIL_DecodeShc(self, content, contentLength);
	case 544237683:
		return RECOIL_DecodeShp(self, content, contentLength);
	case 544368755:
		return RECOIL_DecodeAppleIIShr(self, content, contentLength) || RECOIL_DecodeSh3(self, content, contentLength) || RECOIL_DecodeTrsShr(self, content, contentLength);
	case 543582579:
		return RECOIL_DecodeSif(self, content, contentLength);
	case 544238451:
		return RECOIL_DecodeSkp(self, content, contentLength);
	case 543387763:
		return RECOIL_DecodeStSpc(self, content, contentLength) || RECOIL_DecodeAtari8Spc(self, content, contentLength);
	case 543453299:
		return RECOIL_DecodeSpd(self, content, contentLength);
	case 544370803:
		return RECOIL_DecodeSpr(self, content, contentLength);
	case 544436339:
		return RECOIL_DecodeSps(self, content, contentLength);
	case 544567411:
		return RECOIL_DecodeSpu(self, content, contentLength);
	case 544764019:
		return RECOIL_DecodeSpx(self, content, contentLength);
	case 540373619:
		return RECOIL_DecodeSr5(self, filename, content, contentLength);
	case 540439155:
		return RECOIL_DecodeSr6(self, filename, content, contentLength);
	case 540504691:
		return RECOIL_DecodeSr7(self, filename, content, contentLength);
	case 543781491:
		return RECOIL_DecodeSri(self, filename, content, contentLength);
	case 544502387:
		return RECOIL_DecodeSrt(self, content, contentLength);
	case 543322995:
		return RECOIL_DecodeSsb(self, content, contentLength);
	case 544240755:
		return RECOIL_DecodeStp(self, content, contentLength);
	case 543651955:
		return RECOIL_DecodeSxg(self, content, contentLength);
	case 544438387:
		return RECOIL_DecodeSxs(self, content, contentLength);
	case 544236404:
		return RECOIL_DecodeTcp(self, content, contentLength);
	case 540108660:
		return RECOIL_DecodeTg1(self, content, contentLength);
	case 544041332:
		return RECOIL_DecodeTim(self, content, contentLength);
	case 544237940:
		return RECOIL_DecodeTip(self, content, contentLength);
	case 540110452:
	case 540175988:
	case 540241524:
	case 540307060:
	case 540372596:
	case 540438132:
	case 544829044:
		return RECOIL_DecodeTny(self, content, contentLength);
	case 543780980:
		return RECOIL_DecodePnt(self, content, contentLength);
	case 543519348:
		return RECOIL_DecodeTre(self, content, contentLength);
	case 544240244:
		return RECOIL_DecodeTrp(self, content, contentLength);
	case 544567924:
		return RECOIL_DecodeTru(self, content, contentLength);
	case 540047476:
		return RECOIL_DecodeTx0(self, content, contentLength);
	case 543520884:
		return RECOIL_DecodeTxe(self, content, contentLength);
	case 544438388:
		return RECOIL_DecodeTxs(self, content, contentLength);
	case 544039542:
	case 538996066:
		return RECOIL_DecodeVbm(self, content, contentLength);
	case 543385974:
		return RECOIL_DecodeVic(self, content, contentLength);
	case 543783542:
		return RECOIL_DecodeVzi(self, content, contentLength);
	case 544106871:
		return RECOIL_DecodeWin(self, filename, content, contentLength);
	case 543452791:
		return RECOIL_DecodeWnd(self, content, contentLength);
	case 543254392:
		return RECOIL_DecodeXga(self, content, contentLength);
	case 544238712:
		return RECOIL_DecodeXlp(self, content, contentLength);
	case 540110970:
		return RECOIL_DecodeZp1(self, content, contentLength);
	case 544241786:
		return RECOIL_DecodeZxp(self, content, contentLength);
	default:
		return FALSE;
	}
}

static cibool RECOIL_Decode16x16x16(RECOIL *self, unsigned char const *content, int contentOffset, int colbak)
{
	RECOIL_SetSize(self, 64, 64, RECOILResolution_XE4X4);
	{
		int y;
		for (y = 0; y < 64; y++) {
			{
				int x;
				for (x = 0; x < 64; x++) {
					int c = content[contentOffset + ((y & ~3) << 2) + (x >> 2)];
					if (c > 15)
						return FALSE;
					self->pixels[(y << 6) + x] = self->atari8Palette[colbak | c];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_Decode256(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if (contentLength != 7680 && contentLength != 7684)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE4X2);
	self->gtiaColors[8] = 0;
	RECOIL_DecodeAtari8Gr9(self, content, 3840, 40, frame, 320, 640, 320, 96);
	RECOIL_DecodeAtari8Gr11PalBlend(self, content, 0, 40, frame, 0);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_Decode3(RECOIL *self, unsigned char const *content, int contentLength)
{
	static const unsigned char frameComponents[3] = { 0, 16, 8 };
	return RECOIL_DecodeZxRgb3(self, content, contentLength, frameComponents);
}

static cibool RECOIL_Decode4bt(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[32000];
	GoDotStream rle;
	if (contentLength < 5 || !RECOIL_IsStringAt(content, 0, "GOD0") || content[contentLength - 1] != 173)
		return FALSE;
	GoDotStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 4;
	rle.base.base.base.contentLength = contentLength - 1;
	if (!RleStream_Unpack(&rle.base, unpacked, 0, 1, 32000))
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_C641X1);
	{
		int y;
		for (y = 0; y < 200; y++) {
			{
				int x;
				for (x = 0; x < 320; x++) {
					static const unsigned char byBrightness[16] = { 0, 6, 9, 11, 2, 4, 8, 12, 14, 10, 5, 15, 3, 7, 13, 1 };
					int c = unpacked[(y & ~7) * 160 + (((x & ~7) + (y & 7)) << 2) + ((x >> 1) & 3)];
					self->pixels[y * 320 + x] = RECOIL_C64Palette[byBrightness[(x & 1) == 0 ? c >> 4 : c & 15]];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_Decode4mi(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[7680];
	if (contentLength != 244)
		return FALSE;
	RECOIL_SetSize(self, 32, 240, RECOILResolution_XE2X1);
	memset(frame, 0, sizeof(frame));
	RECOIL_DecodeAt800Missiles(self, content, 4, frame, 0);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_Decode4pl(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[19200];
	if (contentLength != 964)
		return FALSE;
	RECOIL_SetSize(self, 80, 240, RECOILResolution_XE2X1);
	memset(frame, 0, sizeof(frame));
	RECOIL_DecodeAt800Players(self, content, frame);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_Decode4pm(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[26880];
	if (contentLength != 1204)
		return FALSE;
	RECOIL_SetSize(self, 112, 240, RECOILResolution_XE2X1);
	memset(frame, 0, sizeof(frame));
	RECOIL_DecodeAt800Players(self, content, frame);
	RECOIL_DecodeAt800Missiles(self, content, 964, frame, 80);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_Decode64c(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength < 10 || contentLength > 2050 || content[0] != 0)
		return FALSE;
	RECOIL_SetSize(self, 256, (contentLength + 253) >> 8 << 3, RECOILResolution_C641X1);
	RECOIL_DecodeBlackAndWhiteFont(self, content, 2, contentLength, 8);
	return TRUE;
}

static cibool RECOIL_DecodeA(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 8130 || content[0] != 66 || content[1] != 0)
		return FALSE;
	RECOIL_SetSize(self, 416, 182, RECOILResolution_C642X1);
	{
		int y;
		for (y = 0; y < 182; y++) {
			{
				int x;
				for (x = 0; x < 416; x++) {
					int c = 11;
					int row = y % 23;
					if (row < 21) {
						int column = x % 26;
						if (column < 24) {
							int spriteNo = x / 26 + (y / 23 << 4);
							if (spriteNo < 127) {
								int spriteOffset = 2 + (spriteNo << 6);
								switch ((content[spriteOffset + row * 3 + (column >> 3)] >> (~column & 6)) & 3) {
								case 1:
									c = 0;
									break;
								case 2:
									c = content[spriteOffset + 63] & 15;
									break;
								case 3:
									c = 1;
									break;
								default:
									break;
								}
							}
						}
					}
					self->pixels[y * 416 + x] = RECOIL_C64Palette[c];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeA4r(RECOIL *self, unsigned char const *content, int contentLength)
{
	A4rStream a4r;
	unsigned char frame[81920];
	A4rStream_Construct(&a4r);
	a4r.base.content = content;
	a4r.base.contentOffset = 0;
	a4r.base.contentLength = contentLength;
	if (!A4rStream_UnpackA4r(&a4r))
		return FALSE;
	RECOIL_SetSize(self, 320, 256, RECOILResolution_XE4X1);
	self->gtiaColors[8] = 0;
	RECOIL_DecodeAtari8Gr9(self, a4r.unpacked, 512, 40, frame, 0, 320, 320, 256);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeAcs(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[8192];
	if (contentLength != 1028)
		return FALSE;
	RECOIL_SetBakPF012(self, content, 0, 1);
	RECOIL_SetSize(self, 128, 64, RECOILResolution_XE2X1);
	{
		int y;
		for (y = 0; y < 8; y++)
			RECOIL_DecodeAtari8Gr12Line(self, NULL, 0, content, 4 + (y << 7), frame, y << 10, 0);
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeAfl(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 16385)
		return FALSE;
	RECOIL_SetSize(self, 296, 200, RECOILResolution_C641X1);
	RECOIL_DecodeC64HiresFrame(self, content, 8218, 5, 0);
	return TRUE;
}

static cibool RECOIL_DecodeAgp(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if (contentLength != 7690)
		return FALSE;
	RECOIL_SetGtiaColors(self, content, 1);
	switch (content[0]) {
	case 8:
		RECOIL_SetSize(self, 320, 192, RECOILResolution_XE1X1);
		RECOIL_DecodeAtari8Gr8(self, content, 10, frame, 0, 192);
		break;
	case 9:
		RECOIL_SetSize(self, 320, 192, RECOILResolution_XE4X1);
		RECOIL_DecodeAtari8Gr9(self, content, 10, 40, frame, 0, 320, 320, 192);
		break;
	case 10:
		RECOIL_SetSize(self, 320, 192, RECOILResolution_XE4X1);
		self->leftSkip = 2;
		RECOIL_DecodeAtari8Gr10(self, content, 10, frame, 0, 320, 192);
		break;
	case 11:
		RECOIL_SetSize(self, 320, 192, RECOILResolution_XE4X1);
		RECOIL_DecodeAtari8Gr11(self, content, 10, frame, 0, 320, 192);
		break;
	case 15:
		RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X1);
		RECOIL_DecodeAtari8Gr15(self, content, 10, 40, frame, 0, 320, 192);
		break;
	default:
		return FALSE;
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeAll(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if ((contentLength & 1023) != 989)
		return FALSE;
	RECOIL_SetPF0123Bak(self, content, contentLength - 5);
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X1);
	{
		int y;
		for (y = 0; y < 24; y++) {
			int fontOffset = 24 + (content[y] << 10);
			if (fontOffset >= contentLength - 965)
				return FALSE;
			RECOIL_DecodeAtari8Gr12Line(self, content, contentLength - 965 + y * 40, content, fontOffset, frame, y * 2560, 0);
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeAmi(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[10259];
	DrpStream rle;
	if (contentLength < 2)
		return FALSE;
	DrpStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 2;
	rle.base.base.base.contentLength = contentLength;
	rle.escape = 194;
	return RleStream_UnpackC64(&rle.base, unpacked, 10259) && RECOIL_DecodeKoa(self, unpacked, 10003);
}

static cibool RECOIL_DecodeAmstradFnt(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset = RECOIL_GetAmstradHeader(content, contentLength);
	if (contentLength != contentOffset + 768 && (contentLength != 896 || contentOffset != 0))
		return FALSE;
	RECOIL_SetSize(self, 256, 24, RECOILResolution_AMSTRAD1X1);
	RECOIL_DecodeBlackAndWhiteFont(self, content, contentOffset, contentLength, 8);
	return TRUE;
}

static void RECOIL_DecodeAmstradMode0Line(RECOIL *self, unsigned char const *content, int lineOffset, int y)
{
	int skip = self->resolution == RECOILResolution_AMSTRAD1X1 ? (y ^ (y >= self->height ? 1 : 0)) & 1 : 0;
	{
		int x;
		for (x = 0; x < self->width; x++) {
			int i = x + skip;
			int b = i >= self->width ? 0 : content[lineOffset + (i >> 2)];
			if ((i & 2) == 0)
				b >>= 1;
			self->pixels[y * self->width + x] = self->contentPalette[((b & 1) << 3) + ((b >> 2) & 4) + ((b >> 1) & 2) + ((b >> 6) & 1)];
		}
	}
}

static void RECOIL_DecodeAmstradMode1Line(RECOIL *self, unsigned char const *content, int lineOffset, int y)
{
	{
		int x;
		for (x = 0; x < self->width; x++) {
			int b = content[lineOffset + (x >> 2)] >> (~x & 3);
			self->pixels[y * self->width + x] = self->contentPalette[((b >> 3) & 2) + (b & 1)];
		}
	}
}

static cibool RECOIL_DecodeAmstradMode2(RECOIL *self, unsigned char const *content, int contentOffset, int width, int height)
{
	RECOIL_SetSize(self, width, height << 1, RECOILResolution_AMSTRAD1X2);
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int x;
				for (x = 0; x < width; x++) {
					int offset = (y * width << 1) + x;
					int c = (content[contentOffset + ((y & 7) << 11) + (((y >> 3) * width + x) >> 3)] >> (~x & 7)) & 1;
					self->pixels[offset + width] = self->pixels[offset] = self->contentPalette[c];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeAmstradScr(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[16384];
	int contentOffset = RECOIL_GetAmstradHeader(content, contentLength);
	switch (contentLength - contentOffset) {
	case 16336:
	case 16384:
		break;
	default:
		if (!AmstradStream_UnpackFile(content, contentOffset, contentLength, unpacked, 16384))
			return FALSE;
		content = unpacked;
		contentOffset = 0;
		break;
	}
	switch (RECOIL_SetAmstradPalette(self, filename)) {
	case 0:
		RECOIL_SetSize(self, 320, 200, RECOILResolution_AMSTRAD2X1);
		{
			int y;
			for (y = 0; y < 200; y++)
				RECOIL_DecodeAmstradMode0Line(self, content, contentOffset + ((y & 7) << 11) + (y >> 3) * 80, y);
		}
		return TRUE;
	case 1:
		RECOIL_SetSize(self, 320, 200, RECOILResolution_AMSTRAD1X1);
		{
			int y;
			for (y = 0; y < 200; y++)
				RECOIL_DecodeAmstradMode1Line(self, content, contentOffset + ((y & 7) << 11) + (y >> 3) * 80, y);
		}
		return TRUE;
	case 2:
		return RECOIL_DecodeAmstradMode2(self, content, contentOffset, 640, 200);
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeAp3(RECOIL *self, unsigned char const *content, int contentLength)
{
	int gr11Offset;
	unsigned char frame1[61440];
	unsigned char frame2[61440];
	switch (contentLength) {
	case 15360:
	case 15362:
		gr11Offset = 7680;
		break;
	case 15872:
		gr11Offset = 8192;
		break;
	default:
		return FALSE;
	}
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE4X1);
	self->gtiaColors[8] = 0;
	RECOIL_DecodeAtari8Gr9(self, content, 0, 80, frame1, 0, 640, 320, 96);
	RECOIL_DecodeAtari8Gr11PalBlend(self, content, gr11Offset + 40, 80, frame1, 1);
	RECOIL_DecodeAtari8Gr9(self, content, 40, 80, frame2, 320, 640, 320, 96);
	RECOIL_DecodeAtari8Gr11PalBlend(self, content, gr11Offset, 80, frame2, 0);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeApc(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if (contentLength != 7680 && contentLength != 7720)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE4X2);
	self->gtiaColors[8] = 0;
	RECOIL_DecodeAtari8Gr9(self, content, 40, 80, frame, 320, 640, 320, 96);
	RECOIL_DecodeAtari8Gr11PalBlend(self, content, 0, 80, frame, 0);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeApl(RECOIL *self, unsigned char const *content, int contentLength)
{
	int frames;
	int height;
	int gap;
	int frameWidth;
	unsigned char frame[27648];
	if (contentLength != 1677 || content[0] != 154 || content[1] != 248 || content[2] != 57 || content[3] != 33)
		return FALSE;
	frames = content[4];
	height = content[5];
	gap = content[6];
	if (frames == 0 || frames > 16 || height == 0 || height > 48 || gap > 8)
		return FALSE;
	frameWidth = (8 + gap + 2) << 1;
	RECOIL_SetSize(self, frames * frameWidth, height, RECOILResolution_XE2X1);
	memset(frame, 0, sizeof(frame));
	{
		int f;
		for (f = 0; f < frames; f++) {
			RECOIL_DecodeAtari8Player(self, content, 42 + f * 48, content[7 + f], frame, f * frameWidth, height);
			RECOIL_DecodeAtari8Player(self, content, 858 + f * 48, content[24 + f], frame, f * frameWidth + gap * 2, height);
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeApp(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[15872];
	int unpackedOffset;
	BitStream bitStream;
	int current;
	int hi;
	if (contentLength < 7958 || !RECOIL_IsStringAt(content, 0, "S101") || content[4] != 0 || content[5] != 62)
		return FALSE;
	unpackedOffset = 0;
	BitStream_Construct(&bitStream);
	bitStream.base.content = content;
	bitStream.base.contentOffset = 22;
	bitStream.base.contentLength = contentLength;
	current = BitStream_ReadBits(&bitStream, 4);
	hi = -1;
	for (;;) {
		int code;
		int bit;
		if (hi < 0)
			hi = current;
		else {
			unpacked[unpackedOffset++] = (hi << 4) | current;
			if (unpackedOffset >= 15872)
				break;
			hi = -1;
		}
		for (code = 0;; code += 2) {
			bit = BitStream_ReadBit(&bitStream);
			if (bit == 0)
				break;
			if (bit < 0 || code >= 14)
				return FALSE;
		}
		bit = BitStream_ReadBit(&bitStream);
		if (bit < 0)
			return FALSE;
		code += bit;
		current = (current - content[6 + code]) & 15;
	}
	return RECOIL_DecodeAp3(self, unpacked, 15872);
}

static cibool RECOIL_DecodeAppleIIDhr(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 16384)
		return FALSE;
	RECOIL_SetSize(self, 560, 384, RECOILResolution_APPLE_I_IE1X2);
	{
		int y;
		for (y = 0; y < 192; y++) {
			int lineOffset = ((y & 7) << 10) | ((y & 56) << 4) | (y >> 6) * 40;
			{
				int x;
				for (x = 0; x < 560; x++) {
					int b = x / 7;
					int c = (content[((b & 1) << 13) + lineOffset + (b >> 1)] >> x % 7) & 1;
					int pixelsOffset;
					if (c != 0)
						c = 16777215;
					pixelsOffset = y * 1120 + x;
					self->pixels[pixelsOffset + 560] = self->pixels[pixelsOffset] = c;
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeAppleIIShr(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 32768)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_APPLE_I_I_G_S1X1);
	{
		int y;
		for (y = 0; y < 200; y++)
			RECOIL_DecodeShrLine(self, content, y, 32256 + ((content[32000 + y] & 15) << 5));
	}
	return TRUE;
}

static cibool RECOIL_DecodeArtDirector(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 32512 && RECOIL_DecodeStLow(self, content, 0, content, 32000, 320, 200);
}

static cibool RECOIL_DecodeAsciiArtEditor(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char characters[1536];
	int columns;
	int x;
	int y;
	unsigned char frame[98304];
	if (contentLength <= 0 || content[contentLength - 1] != 155)
		return FALSE;
	columns = 1;
	x = 0;
	y = 0;
	{
		int contentOffset;
		for (contentOffset = 0; contentOffset < contentLength; contentOffset++) {
			int ch = content[contentOffset];
			if (y >= 24)
				return FALSE;
			if (ch == 155) {
				if (columns < x)
					columns = x;
				while (x < 64)
					characters[y * 64 + x++] = 0;
				x = 0;
				y++;
			}
			else {
				if (x >= 64)
					return FALSE;
				characters[y * 64 + x++] = RECOIL_ToAtari8Char(ch);
			}
		}
	}
	RECOIL_SetSize(self, columns << 3, y << 3, RECOILResolution_XE1X1);
	RECOIL_DecodeAtari8Gr0(self, characters, 64, CiBinaryResource_atari8_fnt, 0, frame);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static void RECOIL_DecodeAt800Missiles(RECOIL const *self, unsigned char const *content, int contentOffset, unsigned char *frame, int frameOffset)
{
	{
		int y;
		for (y = 0; y < 240; y++) {
			{
				int i;
				for (i = 0; i < 4; i++) {
					int b = content[contentOffset + y] >> (i << 1);
					int offset = frameOffset + i * 4 * 2;
					frame[offset + 1] = frame[offset] = (b & 2) == 0 ? 0 : content[i];
					frame[offset + 3] = frame[offset + 2] = (b & 1) == 0 ? 0 : content[i];
				}
			}
			frameOffset += self->width;
		}
	}
}

static void RECOIL_DecodeAt800Players(RECOIL const *self, unsigned char const *content, unsigned char *frame)
{
	{
		int i;
		for (i = 0; i < 4; i++)
			RECOIL_DecodeAtari8Player(self, content, 4 + i * 240, content[i], frame, i * 10 * 2, 240);
	}
}

static cibool RECOIL_DecodeAtari8Artist(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[51200];
	if (contentLength != 3206 || content[0] != 7)
		return FALSE;
	RECOIL_SetSize(self, 320, 160, RECOILResolution_XE2X2);
	RECOIL_SetPF0123Bak(self, content, 1);
	RECOIL_DecodeAtari8Gr7(self, content, 6, frame, 0, 80);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeAtari8Fnt(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset;
	unsigned char characters[128];
	switch (contentLength) {
	case 1024:
	case 1025:
	case 1026:
		contentOffset = 0;
		break;
	case 1030:
		if (RECOIL_ParseAtari8ExecutableHeader(content, 0) != 1024)
			return FALSE;
		contentOffset = 6;
		break;
	default:
		return FALSE;
	}
	{
		int i;
		for (i = 0; i < 128; i++)
			characters[i] = i;
	}
	return RECOIL_DecodeAtari8Font(self, characters, content, contentOffset);
}

static cibool RECOIL_DecodeAtari8Font(RECOIL *self, unsigned char const *characters, unsigned char const *font, int fontOffset)
{
	unsigned char frame[8192];
	RECOIL_SetSize(self, 256, 32, RECOILResolution_XE1X1);
	RECOIL_DecodeAtari8Gr0(self, characters, 32, font, fontOffset, frame);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static void RECOIL_DecodeAtari8Gr0(RECOIL *self, unsigned char const *characters, int charactersStride, unsigned char const *font, int fontOffset, unsigned char *frame)
{
	self->gtiaColors[6] = 0;
	self->gtiaColors[5] = 14;
	{
		int y;
		for (y = 0; y < self->height; y += 8)
			RECOIL_DecodeAtari8Gr0Line(self, characters, (y >> 3) * charactersStride, font, fontOffset, frame, y * self->width, 8);
	}
}

static void RECOIL_DecodeAtari8Gr0Line(RECOIL const *self, unsigned char const *characters, int charactersOffset, unsigned char const *font, int fontOffset, unsigned char *frame, int frameOffset, int lines)
{
	unsigned char colors[2];
	colors[0] = self->gtiaColors[6];
	colors[1] = (self->gtiaColors[6] & 240) | (self->gtiaColors[5] & 14);
	{
		int y;
		for (y = 0; y < lines; y++) {
			{
				int x;
				for (x = 0; x < self->width; x++) {
					int ch = characters[charactersOffset + (x >> 3)];
					int b = font[fontOffset + ((ch & 127) << 3) + (y & 7)];
					if (lines == 10) {
						switch (((ch & 96) + y) >> 1) {
						case 4:
						case 20:
						case 36:
						case 48:
							b = 0;
							break;
						default:
							break;
						}
					}
					if (ch >= 128)
						b ^= 255;
					frame[frameOffset + x] = colors[(b >> (~x & 7)) & 1];
				}
			}
			frameOffset += self->width;
		}
	}
}

static void RECOIL_DecodeAtari8Gr10(RECOIL const *self, unsigned char const *content, int contentOffset, unsigned char *frame, int frameOffset, int frameStride, int height)
{
	frameOffset += 2 - self->leftSkip;
	{
		int y;
		for (y = 0; y < height; y++) {
			int x;
			for (x = self->leftSkip - 2; x < 0; x++)
				frame[frameOffset + x] = self->gtiaColors[0];
			for (; x < self->width + self->leftSkip - 2; x++) {
				int c = (content[contentOffset + (x >> 3)] >> (~x & 4)) & 15;
				frame[frameOffset + x] = self->gtiaColors[c];
			}
			contentOffset += self->width >> 3;
			frameOffset += frameStride;
		}
	}
}

static void RECOIL_DecodeAtari8Gr11(RECOIL const *self, unsigned char const *content, int contentOffset, unsigned char *frame, int frameOffset, int frameStride, int height)
{
	frameOffset -= self->leftSkip;
	{
		int y;
		for (y = 0; y < height; y++) {
			int x;
			for (x = self->leftSkip; x < self->width; x++) {
				int c = (content[contentOffset + (x >> 3)] << (x & 4)) & 240;
				c = c == 0 ? self->gtiaColors[8] & 240 : self->gtiaColors[8] | c;
				frame[frameOffset + x] = c;
			}
			for (; x < self->width + self->leftSkip; x++)
				frame[frameOffset + x] = self->gtiaColors[8] & 240;
			contentOffset += self->width >> 3;
			frameOffset += frameStride;
		}
	}
}

static void RECOIL_DecodeAtari8Gr11PalBlend(RECOIL const *self, unsigned char const *content, int contentOffset, int contentStride, unsigned char *frame, int y)
{
	for (; y < self->height; y += 2) {
		int frameOffset = y * self->width - self->leftSkip;
		int x;
		for (x = self->leftSkip; x < self->width; x++) {
			int c = (content[contentOffset + (x >> 3)] << (x & 4)) & 240;
			int i = ((y == 0 ? 0 : frame[frameOffset - self->width + x] & 15) + (y == self->height - 1 ? 0 : frame[frameOffset + self->width + x] & 15)) >> 1;
			frame[frameOffset + x] = c | i;
			if (y < self->height - 1)
				frame[frameOffset + self->width + x] = c | (frame[frameOffset + self->width + x] & 15);
		}
		for (; x < self->width + self->leftSkip; x++)
			frame[frameOffset + x] = 0;
		contentOffset += contentStride;
	}
}

static void RECOIL_DecodeAtari8Gr12Line(RECOIL const *self, unsigned char const *characters, int charactersOffset, unsigned char const *font, int fontOffset, unsigned char *frame, int frameOffset, int doubleLine)
{
	{
		int y;
		for (y = 0; y < 8 << doubleLine; y++) {
			{
				int x;
				for (x = 0; x < self->width; x++) {
					int ch = x >> 3;
					int c;
					int gr12Registers;
					if (characters != NULL)
						ch = characters[charactersOffset + ch];
					c = (font[fontOffset + ((ch & 127) << 3) + (y >> doubleLine)] >> (~x & 6)) & 3;
					gr12Registers = ch >= 128 ? 30024 : 25928;
					frame[frameOffset + x] = self->gtiaColors[(gr12Registers >> (c << 2)) & 15];
				}
			}
			frameOffset += self->width;
		}
	}
}

static void RECOIL_DecodeAtari8Gr15(RECOIL const *self, unsigned char const *content, int contentOffset, int contentStride, unsigned char *frame, int frameOffset, int frameStride, int height)
{
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int x;
				for (x = 0; x < self->width; x++) {
					int c = (content[contentOffset + (x >> 3)] >> (~x & 6)) & 3;
					frame[frameOffset + x] = self->gtiaColors[c == 0 ? 8 : c + 3];
				}
			}
			contentOffset += contentStride;
			frameOffset += frameStride;
		}
	}
}

static void RECOIL_DecodeAtari8Gr1Line(RECOIL const *self, unsigned char const *content, int charactersOffset, unsigned char const *font, int fontOffset, unsigned char *frame, int frameOffset, int doubleLine)
{
	{
		int y;
		for (y = 0; y < 8 << doubleLine; y++) {
			{
				int x;
				for (x = 0; x < self->width; x++) {
					int ch = content[charactersOffset + (x >> 4)];
					int b = (font[fontOffset + ((ch & 63) << 3) + (y >> doubleLine)] >> (~(x >> 1) & 7)) & 1;
					frame[frameOffset + x] = self->gtiaColors[b == 0 ? 8 : 4 + (ch >> 6)];
				}
			}
			frameOffset += self->width;
		}
	}
}

static void RECOIL_DecodeAtari8Gr3(RECOIL const *self, unsigned char const *content, unsigned char *frame)
{
	{
		int y;
		for (y = 0; y < self->height; y++) {
			{
				int x;
				for (x = 0; x < self->width; x++) {
					int c = (content[(y >> 3) * (self->width >> 5) + (x >> 5)] >> (~(x >> 2) & 6)) & 3;
					frame[y * self->width + x] = self->gtiaColors[c == 0 ? 8 : c + 3];
				}
			}
		}
	}
}

static void RECOIL_DecodeAtari8Gr7(RECOIL const *self, unsigned char const *content, int contentOffset, unsigned char *frame, int frameOffset, int height)
{
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int x;
				for (x = 0; x < self->width; x++) {
					int c = (content[contentOffset + (x >> 3)] >> (~x & 6)) & 3;
					frame[frameOffset + x + self->width] = frame[frameOffset + x] = self->gtiaColors[c == 0 ? 8 : c + 3];
				}
			}
			contentOffset += self->width >> 3;
			frameOffset += self->width << 1;
		}
	}
}

static void RECOIL_DecodeAtari8Gr8(RECOIL const *self, unsigned char const *content, int contentOffset, unsigned char *frame, int frameOffset, int height)
{
	unsigned char colors[2];
	colors[0] = self->gtiaColors[6];
	colors[1] = (self->gtiaColors[6] & 240) | (self->gtiaColors[5] & 14);
	frameOffset -= self->leftSkip;
	{
		int y;
		for (y = 0; y < height; y++) {
			int x;
			for (x = self->leftSkip; x < self->width; x++) {
				int c = (content[contentOffset + (x >> 3)] >> (~x & 7)) & 1;
				frame[frameOffset + x] = colors[c];
			}
			for (; x < self->width + self->leftSkip; x++)
				frame[frameOffset + x] = self->gtiaColors[8];
			contentOffset += (self->width + 7) >> 3;
			frameOffset += self->width;
		}
	}
}

static void RECOIL_DecodeAtari8Gr9(RECOIL const *self, unsigned char const *content, int contentOffset, int contentStride, unsigned char *frame, int frameOffset, int frameStride, int width, int height)
{
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int x;
				for (x = 0; x < width; x++) {
					int i = x + self->leftSkip;
					int c = i < 0 || i >= width ? 0 : (content[contentOffset + (i >> 3)] >> (~i & 4)) & 15;
					frame[frameOffset + x] = self->gtiaColors[8] | c;
				}
			}
			contentOffset += contentStride;
			frameOffset += frameStride;
		}
	}
}

static cibool RECOIL_DecodeAtari8Hr(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame1[61184];
	unsigned char frame2[61184];
	if (contentLength != 16384)
		return FALSE;
	RECOIL_SetSize(self, 256, 239, RECOILResolution_XE1X1);
	self->gtiaColors[6] = 0;
	self->gtiaColors[5] = 14;
	RECOIL_DecodeAtari8Gr8(self, content, 0, frame1, 0, 239);
	RECOIL_DecodeAtari8Gr8(self, content, 8192, frame2, 0, 239);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeAtari8Ice(RECOIL *self, unsigned char const *content, int contentLength, cibool font, int mode)
{
	unsigned char frame1[73728];
	unsigned char frame2[73728];
	switch (mode) {
		static const unsigned char ice20Gtia11Colors[7] = { 0, 1, 2, 3, 5, 7, 8 };
	case 0:
		if (contentLength != 2053)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE1X1);
		self->gtiaColors[5] = content[1] & 254;
		self->gtiaColors[6] = content[3] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 5, frame1, IceFrameMode_GR0);
		self->gtiaColors[5] = content[2] & 254;
		self->gtiaColors[6] = content[4] & 254;
		RECOIL_DecodeIceFrame(self, content, -2, 1029, frame2, IceFrameMode_GR0);
		break;
	case 1:
		if (!RECOIL_VerifyIce(self, content, contentLength, font, 2054, 18310, RECOILResolution_XE2X1))
			return FALSE;
		RECOIL_SetBakPF0123(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, font ? -1 : 16390, 6, frame1, IceFrameMode_GR12);
		RECOIL_DecodeIceFrame(self, content, font ? -2 : 17350, 1030, frame2, IceFrameMode_GR12);
		break;
	case 2:
		if (!RECOIL_VerifyIce(self, content, contentLength, font, 2058, 18314, RECOILResolution_XE2X1))
			return FALSE;
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_SetPF0123Even(self, content, 2);
		RECOIL_DecodeIceFrame(self, content, font ? -1 : 16394, 10, frame1, IceFrameMode_GR12);
		RECOIL_SetPF0123Even(self, content, 3);
		RECOIL_DecodeIceFrame(self, content, font ? -2 : 17354, 1034, frame2, IceFrameMode_GR12);
		break;
	case 3:
		if (font) {
			if (contentLength != 2055)
				return FALSE;
			RECOIL_SetSize(self, 256, 128, RECOILResolution_XE1X1);
		}
		else {
			if (contentLength != 17351 || content[0] != 3)
				return FALSE;
			RECOIL_SetSize(self, 320, 192, RECOILResolution_XE1X1);
		}
		RECOIL_SetPF21(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, font ? -1 : 16391, 7, frame1, IceFrameMode_GR0);
		RECOIL_SetBakPF0123(self, content, 2);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, font ? -2 : 16391, 1031, frame2, IceFrameMode_GR12);
		break;
	case 4:
		if (contentLength != 2058)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE4X1);
		self->leftSkip = 2;
		RECOIL_SetGtiaColors(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, -1, 10, frame1, IceFrameMode_GR0_GTIA10);
		RECOIL_DecodeIceFrame(self, content, -2, 1034, frame2, IceFrameMode_GR0_GTIA10);
		break;
	case 5:
		if (contentLength != 2065 && contentLength != 2066)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE4X1);
		self->leftSkip = 2;
		self->gtiaColors[0] = content[1] & 254;
		{
			int i;
			for (i = 0; i < 8; i++)
				RECOIL_SetGtiaColor(self, i + 1, content[2 + i * 2]);
		}
		if (contentLength == 2065) {
			RECOIL_DecodeIceFrame(self, content, -1, 17, frame1, IceFrameMode_GR0_GTIA10);
			{
				int i;
				for (i = 0; i < 7; i++)
					RECOIL_SetGtiaColor(self, i + 1, content[3 + i * 2]);
			}
			RECOIL_DecodeIceFrame(self, content, -2, 1041, frame2, IceFrameMode_GR0_GTIA10);
		}
		else {
			RECOIL_DecodeIceFrame(self, content, -1, 18, frame1, IceFrameMode_GR0_GTIA10);
			{
				int i;
				for (i = 0; i < 8; i++)
					RECOIL_SetGtiaColor(self, i + 1, content[3 + i * 2]);
			}
			RECOIL_DecodeIceFrame(self, content, -2, 1042, frame2, IceFrameMode_GR0_GTIA10);
		}
		break;
	case 6:
		if (contentLength != 2051)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE4X1);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 3, frame1, IceFrameMode_GR0_GTIA9);
		self->gtiaColors[8] = content[2] & 254;
		RECOIL_DecodeIceFrame(self, content, -2, 1027, frame2, IceFrameMode_GR0_GTIA9);
		break;
	case 7:
		if (contentLength != 2051)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE4X1);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 3, frame1, IceFrameMode_GR0_GTIA11);
		self->gtiaColors[8] = content[2] & 254;
		RECOIL_DecodeIceFrame(self, content, -2, 1027, frame2, IceFrameMode_GR0_GTIA11);
		break;
	case 8:
		if (contentLength != 2058)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE2X1);
		self->leftSkip = 1;
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 10, frame1, IceFrameMode_GR0_GTIA9);
		RECOIL_SetGtiaColors(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, -2, 1034, frame2, IceFrameMode_GR0_GTIA10);
		break;
	case 9:
		if (contentLength != 2058)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE2X1);
		self->leftSkip = 1;
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 10, frame1, IceFrameMode_GR0_GTIA11);
		self->gtiaColors[0] = 0;
		RECOIL_SetPM123PF0123Bak(self, content, 2);
		RECOIL_DecodeIceFrame(self, content, -2, 1034, frame2, IceFrameMode_GR0_GTIA10);
		break;
	case 10:
		if (contentLength != 2051)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE4X1);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 3, frame1, IceFrameMode_GR0_GTIA9);
		self->gtiaColors[8] = content[2] & 254;
		RECOIL_DecodeIceFrame(self, content, -2, 1027, frame2, IceFrameMode_GR0_GTIA11);
		break;
	case 11:
		if (contentLength != 2051)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE1X1);
		self->gtiaColors[6] = 0;
		self->gtiaColors[5] = content[2] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 3, frame1, IceFrameMode_GR0);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -2, 1027, frame2, IceFrameMode_GR0_GTIA11);
		break;
	case 12:
		if (contentLength != 2051)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE1X1);
		RECOIL_SetPF21(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, -1, 3, frame1, IceFrameMode_GR0);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -2, 1027, frame2, IceFrameMode_GR0_GTIA9);
		break;
	case 13:
		if (contentLength != 2059)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE1X1);
		RECOIL_SetPF21(self, content, 1);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 11, frame1, IceFrameMode_GR0);
		self->leftSkip = 2;
		self->gtiaColors[0] = content[1] & 254;
		RECOIL_SetPM123PF0123Bak(self, content, 3);
		RECOIL_DecodeIceFrame(self, content, -2, 1035, frame2, IceFrameMode_GR0_GTIA10);
		break;
	case 14:
		if (contentLength != 2054)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE2X1);
		RECOIL_SetBakPF0123(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, -2, 1030, frame2, IceFrameMode_GR12_GTIA11);
		self->gtiaColors[8] = 0;
		RECOIL_DecodeIceFrame(self, content, -1, 6, frame1, IceFrameMode_GR12);
		break;
	case 15:
		if (contentLength != 2054)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE2X1);
		RECOIL_SetBakPF0123(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, -1, 6, frame1, IceFrameMode_GR12);
		RECOIL_DecodeIceFrame(self, content, -2, 1030, frame2, IceFrameMode_GR12_GTIA9);
		break;
	case 16:
		if (contentLength != 2058)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, RECOILResolution_XE2X1);
		self->leftSkip = 2;
		RECOIL_SetGtiaColors(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, -2, 1034, frame2, IceFrameMode_GR12_GTIA10);
		self->leftSkip = 0;
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 10, frame1, IceFrameMode_GR12);
		break;
	case 17:
		if (!RECOIL_VerifyIce(self, content, contentLength, font, 2054, 17350, RECOILResolution_XE2X1))
			return FALSE;
		RECOIL_SetBakPF0123(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, font ? -2 : 16390, 1030, frame2, IceFrameMode_GR0_GTIA11);
		self->gtiaColors[8] = 0;
		RECOIL_DecodeIceFrame(self, content, font ? -1 : 16390, 6, frame1, IceFrameMode_GR12);
		break;
	case 18:
		if (!RECOIL_VerifyIce(self, content, contentLength, font, 2054, 17350, RECOILResolution_XE2X1))
			return FALSE;
		RECOIL_SetBakPF0123(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, font ? -1 : 16390, 6, frame1, IceFrameMode_GR12);
		RECOIL_DecodeIceFrame(self, content, font ? -2 : 16390, 1030, frame2, IceFrameMode_GR0_GTIA9);
		break;
	case 19:
		if (!RECOIL_VerifyIce(self, content, contentLength, font, 2058, 17354, RECOILResolution_XE2X1))
			return FALSE;
		RECOIL_SetPF0123Bak(self, content, 5);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, font ? -1 : 16394, 10, frame1, IceFrameMode_GR12);
		self->leftSkip = 2;
		RECOIL_SetGtiaColors(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, font ? -2 : 16394, 1034, frame2, IceFrameMode_GR0_GTIA10);
		break;
	case 22:
		if (contentLength != 2058)
			return FALSE;
		RECOIL_SetSize(self, 256, 256, RECOILResolution_XE4X2);
		self->leftSkip = 2;
		RECOIL_SetGtiaColors(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, -1, 10, frame1, IceFrameMode_GR13_GTIA10);
		RECOIL_DecodeIceFrame(self, content, -2, 1034, frame2, IceFrameMode_GR13_GTIA10);
		break;
	case 23:
		if (contentLength != 2065)
			return FALSE;
		RECOIL_SetSize(self, 256, 256, RECOILResolution_XE4X2);
		self->leftSkip = 2;
		self->gtiaColors[0] = content[1] & 254;
		{
			int i;
			for (i = 0; i < 8; i++)
				RECOIL_SetGtiaColor(self, i + 1, content[2 + i * 2]);
		}
		RECOIL_DecodeIceFrame(self, content, -1, 17, frame1, IceFrameMode_GR13_GTIA10);
		{
			int i;
			for (i = 0; i < 7; i++)
				RECOIL_SetGtiaColor(self, i + 1, content[3 + i * 2]);
		}
		RECOIL_DecodeIceFrame(self, content, -2, 1041, frame2, IceFrameMode_GR13_GTIA10);
		break;
	case 24:
		if (contentLength != 2051)
			return FALSE;
		RECOIL_SetSize(self, 256, 256, RECOILResolution_XE4X2);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 3, frame1, IceFrameMode_GR13_GTIA9);
		self->gtiaColors[8] = content[2] & 254;
		RECOIL_DecodeIceFrame(self, content, -2, 1027, frame2, IceFrameMode_GR13_GTIA9);
		break;
	case 25:
		if (contentLength != 2051)
			return FALSE;
		RECOIL_SetSize(self, 256, 256, RECOILResolution_XE4X2);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 3, frame1, IceFrameMode_GR13_GTIA11);
		self->gtiaColors[8] = content[2] & 254;
		RECOIL_DecodeIceFrame(self, content, -2, 1027, frame2, IceFrameMode_GR13_GTIA11);
		break;
	case 26:
		if (contentLength != 2058)
			return FALSE;
		RECOIL_SetSize(self, 256, 256, RECOILResolution_XE2X2);
		self->leftSkip = 1;
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 10, frame1, IceFrameMode_GR13_GTIA9);
		RECOIL_SetGtiaColors(self, content, 1);
		RECOIL_DecodeIceFrame(self, content, -2, 1034, frame2, IceFrameMode_GR13_GTIA10);
		break;
	case 27:
		if (contentLength != 2058)
			return FALSE;
		RECOIL_SetSize(self, 256, 256, RECOILResolution_XE2X2);
		self->leftSkip = 1;
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 10, frame1, IceFrameMode_GR13_GTIA11);
		self->gtiaColors[0] = 0;
		RECOIL_SetPM123PF0123Bak(self, content, 2);
		RECOIL_DecodeIceFrame(self, content, -2, 1034, frame2, IceFrameMode_GR13_GTIA10);
		break;
	case 28:
		if (contentLength != 2051)
			return FALSE;
		RECOIL_SetSize(self, 256, 256, RECOILResolution_XE4X2);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIceFrame(self, content, -1, 3, frame1, IceFrameMode_GR13_GTIA9);
		self->gtiaColors[8] = content[2] & 254;
		RECOIL_DecodeIceFrame(self, content, -2, 1027, frame2, IceFrameMode_GR13_GTIA11);
		break;
	case 31:
		if (contentLength != 1032)
			return FALSE;
		RECOIL_SetSize(self, 256, 288, RECOILResolution_XE4X1);
		self->leftSkip = 2;
		{
			int i;
			for (i = 0; i < 7; i++)
				RECOIL_SetGtiaColor(self, ice20Gtia11Colors[i], content[1 + i]);
		}
		RECOIL_DecodeIce20Frame(self, content, FALSE, 8, frame1, 10);
		RECOIL_DecodeIce20Frame(self, content, TRUE, 520, frame2, 10);
		break;
	case 32:
		if (contentLength != 1038)
			return FALSE;
		RECOIL_SetSize(self, 256, 288, RECOILResolution_XE4X1);
		self->leftSkip = 2;
		self->gtiaColors[0] = content[1] & 254;
		{
			int i;
			for (i = 1; i < 7; i++)
				RECOIL_SetGtiaColor(self, ice20Gtia11Colors[i], content[i * 2]);
		}
		RECOIL_DecodeIce20Frame(self, content, FALSE, 14, frame1, 10);
		{
			int i;
			for (i = 1; i < 7; i++)
				RECOIL_SetGtiaColor(self, ice20Gtia11Colors[i], content[1 + i * 2]);
		}
		RECOIL_DecodeIce20Frame(self, content, TRUE, 526, frame2, 10);
		break;
	case 33:
		if (contentLength != 1027)
			return FALSE;
		RECOIL_SetSize(self, 256, 288, RECOILResolution_XE4X1);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIce20Frame(self, content, FALSE, 3, frame1, 9);
		self->gtiaColors[8] = content[2] & 254;
		RECOIL_DecodeIce20Frame(self, content, TRUE, 515, frame2, 9);
		break;
	case 34:
		if (contentLength != 1027)
			return FALSE;
		RECOIL_SetSize(self, 256, 288, RECOILResolution_XE4X1);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIce20Frame(self, content, FALSE, 3, frame1, 11);
		self->gtiaColors[8] = content[2] & 254;
		RECOIL_DecodeIce20Frame(self, content, TRUE, 515, frame2, 11);
		break;
	case 35:
		if (contentLength != 1032)
			return FALSE;
		RECOIL_SetSize(self, 256, 288, RECOILResolution_XE2X1);
		self->leftSkip = 1;
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIce20Frame(self, content, FALSE, 8, frame1, 9);
		{
			int i;
			for (i = 0; i < 7; i++)
				RECOIL_SetGtiaColor(self, ice20Gtia11Colors[i], content[1 + i]);
		}
		RECOIL_DecodeIce20Frame(self, content, TRUE, 520, frame2, 10);
		break;
	case 36:
		if (contentLength != 1032)
			return FALSE;
		RECOIL_SetSize(self, 256, 288, RECOILResolution_XE2X1);
		self->leftSkip = 1;
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIce20Frame(self, content, FALSE, 8, frame1, 11);
		self->gtiaColors[0] = 0;
		{
			int i;
			for (i = 1; i < 7; i++)
				RECOIL_SetGtiaColor(self, ice20Gtia11Colors[i], content[1 + i]);
		}
		RECOIL_DecodeIce20Frame(self, content, TRUE, 520, frame2, 10);
		break;
	case 37:
		if (contentLength != 1027)
			return FALSE;
		RECOIL_SetSize(self, 256, 288, RECOILResolution_XE4X1);
		self->gtiaColors[8] = content[1] & 254;
		RECOIL_DecodeIce20Frame(self, content, FALSE, 3, frame1, 9);
		self->gtiaColors[8] = content[2] & 254;
		RECOIL_DecodeIce20Frame(self, content, TRUE, 515, frame2, 11);
		break;
	default:
		return FALSE;
	}
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeAtari8Max(RECOIL *self, unsigned char const *content, int contentLength)
{
	XlpStream rle;
	unsigned char unpacked[15360];
	unsigned char frame1[61440];
	unsigned char frame2[61440];
	if (contentLength < 1732 || !RECOIL_IsStringAt(content, 0, "XLPM"))
		return FALSE;
	XlpStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 1732;
	rle.base.base.base.contentLength = contentLength;
	if (!RleStream_UnpackColumns(&rle.base, unpacked, 0, 40, 15360))
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X1);
	{
		int y;
		for (y = 0; y < 192; y++) {
			RECOIL_SetBakPF012(self, content, 772 + y, 192);
			RECOIL_DecodeAtari8Gr15(self, unpacked, y * 40, 40, frame1, y * 320, 320, 1);
			RECOIL_SetBakPF012(self, content, 4 + y, 192);
			RECOIL_DecodeAtari8Gr15(self, unpacked, 7680 + y * 40, 40, frame2, y * 320, 320, 1);
		}
	}
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static void RECOIL_DecodeAtari8Player(RECOIL const *self, unsigned char const *content, int contentOffset, int color, unsigned char *frame, int frameOffset, int height)
{
	color &= 254;
	{
		int y;
		for (y = 0; y < height; y++) {
			int b = content[contentOffset + y];
			{
				int x;
				for (x = 0; x < 8; x++) {
					int c = (b >> (7 - x)) & 1;
					if (c != 0)
						frame[frameOffset + x * 2 + 1] = frame[frameOffset + x * 2] |= color;
				}
			}
			frameOffset += self->width;
		}
	}
}

static cibool RECOIL_DecodeAtari8Raw(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 15372 && RECOIL_IsStringAt(content, 0, "XLPB") && RECOIL_DecodeGr15Blend(self, content, 4, 15364, 192);
}

static cibool RECOIL_DecodeAtari8Rgb(RECOIL *self, unsigned char const *content, int contentLength)
{
	int titleLength;
	int width;
	int height;
	int leftRgbs[192];
	unsigned char screens[23040];
	RgbStream rle;
	unsigned char frame1[61440];
	unsigned char frame2[61440];
	unsigned char frame3[61440];
	if (contentLength < 9 || !RECOIL_IsStringAt(content, 0, "RGB1"))
		return FALSE;
	titleLength = content[4];
	if (contentLength < 9 + titleLength)
		return FALSE;
	width = content[6 + titleLength];
	height = content[7 + titleLength];
	if (width == 0 || (width & 1) != 0 || width > 80 || height == 0 || height > 192 || content[8 + titleLength] != 1)
		return FALSE;
	switch (content[5 + titleLength]) {
	case 9:
		RECOIL_SetSize(self, width << 2, height, RECOILResolution_XE4X1);
		break;
	case 15:
		RECOIL_SetSize(self, width << 2, height, RECOILResolution_XE2X1);
		break;
	default:
		return FALSE;
	}
	RgbStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 9 + titleLength;
	rle.base.base.base.contentLength = contentLength;
	{
		int x;
		for (x = 0; x < width; x++) {
			{
				int y;
				for (y = 0; y < height; y++) {
					int rgb = RleStream_ReadRle(&rle.base);
					if (rgb < 0)
						return FALSE;
					if ((x & 1) == 0)
						leftRgbs[y] = rgb;
					else {
						int leftRgb = leftRgbs[y];
						int screenOffset = y * 40 + (x >> 1);
						screens[screenOffset] = ((leftRgb >> 4) & 240) | (rgb >> 8);
						screens[7680 + screenOffset] = (leftRgb & 240) | ((rgb >> 4) & 15);
						screens[15360 + screenOffset] = ((leftRgb << 4) & 240) | (rgb & 15);
					}
				}
			}
		}
	}
	RECOIL_DecodeAtari8RgbScreen(self, screens, 0, 48, frame1);
	RECOIL_DecodeAtari8RgbScreen(self, screens, 7680, 192, frame2);
	RECOIL_DecodeAtari8RgbScreen(self, screens, 15360, 112, frame3);
	return RECOIL_ApplyAtari8PaletteBlend3(self, frame1, frame2, frame3);
}

static void RECOIL_DecodeAtari8RgbScreen(RECOIL *self, unsigned char const *screens, int screensOffset, int color, unsigned char *frame)
{
	if (self->resolution == RECOILResolution_XE4X1) {
		self->gtiaColors[8] = color;
		RECOIL_DecodeAtari8Gr9(self, screens, screensOffset, 40, frame, 0, self->width, self->width, self->height);
	}
	else {
		self->gtiaColors[8] = 0;
		self->gtiaColors[4] = color | 4;
		self->gtiaColors[5] = color | 10;
		self->gtiaColors[6] = color | 14;
		RECOIL_DecodeAtari8Gr15(self, screens, screensOffset, 40, frame, 0, self->width, self->height);
	}
}

static cibool RECOIL_DecodeAtari8Spc(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char pixels[30720];
	int lineColors[96];
	int textX;
	int textY;
	int lineX;
	int lineY;
	int brush;
	int pattern;
	int lineColor;
	int x;
	int y;
	unsigned char frame[61440];
	if (contentLength < 3 || contentLength != content[0] + (content[1] << 8) + 3 || content[contentLength - 1] != 0)
		return FALSE;
	memset(pixels, 0, sizeof(pixels));
	memset(lineColors, 0, sizeof(lineColors));
	textX = 0;
	textY = 0;
	lineX = 0;
	lineY = 0;
	brush = 0;
	pattern = 8840;
	lineColor = 3;
	{
		int contentOffset;
		for (contentOffset = 2; content[contentOffset] != 0;) {
			switch (content[contentOffset]) {
				static const int patterns[71] = { 0, 21845, 43690, 65535, 4420, 8840, 13260, 26265, 30685, 48110, 5457, 10914, 16371, 16388, 27302, 32759,
					32776, 38233, 49147, 49164, 54621, 60078, 21896, 8908, 13124, 17561, 17629, 30617, 35054, 34918, 39406, 52343,
					52411, 56763, 7089, 5465, 5469, 38237, 16392, 16396, 32780, 27308, 10926, 27298, 32763, 16379, 49143, 21892,
					8900, 13128, 17553, 17617, 30609, 35042, 34914, 39393, 52339, 52403, 56755, 21900, 8904, 13132, 17565, 17625,
					30621, 35046, 34926, 39397, 52347, 52407, 56759 };
			case 16:
				if (contentOffset + 3 >= contentLength)
					return FALSE;
				textX = content[contentOffset + 1];
				textY = content[contentOffset + 2];
				contentOffset += 3;
				break;
			case 32:
			case 33:
			case 34:
			case 35:
				if (contentOffset + 1 >= contentLength)
					return FALSE;
				lineColor = content[contentOffset] & 3;
				contentOffset++;
				break;
			case 48:
			case 80:
				if (contentOffset + 2 >= contentLength)
					return FALSE;
				RECOIL_DrawSpcChar(pixels, textX, textY, content[contentOffset + 1]);
				textX += 4;
				contentOffset += 2;
				break;
			case 64:
			case 65:
			case 66:
			case 67:
			case 68:
			case 69:
			case 70:
			case 71:
				if (contentOffset + 1 >= contentLength)
					return FALSE;
				brush = content[contentOffset] & 7;
				contentOffset++;
				break;
			case 96:
				if (contentOffset + 2 >= contentLength)
					return FALSE;
				pattern = content[contentOffset + 1];
				if (pattern >= 71)
					return FALSE;
				pattern = patterns[pattern];
				contentOffset += 2;
				break;
			case 112:
				if (contentOffset + 7 >= contentLength)
					return FALSE;
				for (y = content[contentOffset + 1]; y <= content[contentOffset + 2]; y++) {
					if (y >= 96)
						return FALSE;
					lineColors[y] = contentOffset + 3;
				}
				contentOffset += 7;
				break;
			case 128:
				if (contentOffset + 3 >= contentLength)
					return FALSE;
				lineX = content[contentOffset + 1];
				lineY = content[contentOffset + 2];
				contentOffset += 3;
				break;
			case 160:
				if (contentOffset + 3 >= contentLength)
					return FALSE;
				x = content[contentOffset + 1];
				y = content[contentOffset + 2];
				RECOIL_DrawSpcLine(pixels, lineX, lineY, x, y, lineColor);
				lineX = x;
				lineY = y;
				contentOffset += 3;
				break;
			case 192:
				if (contentOffset + 3 >= contentLength)
					return FALSE;
				RECOIL_DrawSpcBrush(pixels, content[contentOffset + 1], content[contentOffset + 2], brush, pattern);
				contentOffset += 3;
				break;
			case 224:
				if (contentOffset + 3 >= contentLength)
					return FALSE;
				if (!RECOIL_FillSpc(pixels, content[contentOffset + 1], content[contentOffset + 2], pattern))
					return FALSE;
				contentOffset += 3;
				break;
			default:
				return FALSE;
			}
		}
	}
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X1);
	for (y = 0; y < 192; y++) {
		static const unsigned char defaultColors[4] = { 0, 21, 149, 54 };
		int colorsOffset = lineColors[y >> 1];
		unsigned char const *colors = colorsOffset == 0 ? defaultColors : content;
		for (x = 0; x < 160; x++) {
			int offset = y * 320 + x * 2;
			frame[offset + 1] = frame[offset] = colors[colorsOffset + pixels[y * 160 + x]] & 254;
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeAtr(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 768)
		return FALSE;
	RECOIL_SetZx(self, RECOILResolution_SPECTRUM1X1);
	RECOIL_DecodeZx(self, content, -3, 0, 3, 0);
	return TRUE;
}

static cibool RECOIL_DecodeAwbm(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width = content[4] | (content[5] << 8);
	int height = content[6] | (content[7] << 8);
	int planeStride = (width + 7) >> 3;
	cibool colors256;
	if (RECOIL_DecodeAwbmPalette(self, content, contentLength, 8 + width * height, 256))
		colors256 = TRUE;
	else if (RECOIL_DecodeAwbmPalette(self, content, contentLength, 8 + (height * planeStride << 2), 16))
		colors256 = FALSE;
	else
		return FALSE;
	if (!RECOIL_SetSize(self, width, height, RECOILResolution_PC1X1))
		return FALSE;
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int x;
				for (x = 0; x < width; x++) {
					int c;
					if (colors256)
						c = content[8 + y * width + x];
					else {
						int offset = 8 + (y * planeStride << 2) + (x >> 3);
						c = 0;
						{
							int bit;
							for (bit = 0; bit < 4; bit++) {
								c |= ((content[offset] >> (~x & 7)) & 1) << bit;
								offset += planeStride;
							}
						}
					}
					self->pixels[y * width + x] = self->contentPalette[c];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeAwbmPalette(RECOIL *self, unsigned char const *content, int contentLength, int paletteOffset, int colors)
{
	if (contentLength < paletteOffset + 4 + colors * 3 || !RECOIL_IsStringAt(content, paletteOffset, "RGB "))
		return FALSE;
	{
		int i;
		for (i = 0; i < colors; i++) {
			int rgb = RECOIL_GetR8G8B8Color(content, paletteOffset + 4 + i * 3);
			self->contentPalette[i] = ((rgb & 4144959) << 2) | ((rgb >> 4) & 197379);
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeBb0(RECOIL *self, unsigned char const *content, int contentLength, int const *palette)
{
	if (contentLength != 20480)
		return FALSE;
	RECOIL_SetSize(self, 640, 512, RECOILResolution_BBC1X2);
	{
		int y;
		for (y = 0; y < 256; y++) {
			{
				int x;
				for (x = 0; x < 640; x++) {
					int c = (content[(y & ~7) * 80 + (x & ~7) + (y & 7)] >> (~x & 7)) & 1;
					int pixelsOffset = y * 1280 + x;
					self->pixels[pixelsOffset + 640] = self->pixels[pixelsOffset] = palette[c];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeBb1(RECOIL *self, unsigned char const *content, int contentLength, int const *palette)
{
	if (contentLength != 20480)
		return FALSE;
	RECOIL_SetSize(self, 320, 256, RECOILResolution_BBC1X1);
	{
		int y;
		for (y = 0; y < 256; y++) {
			{
				int x;
				for (x = 0; x < 320; x++) {
					int c = content[(y & ~7) * 80 + ((x & ~3) << 1) + (y & 7)] >> (~x & 3);
					self->pixels[y * 320 + x] = palette[((c >> 3) & 2) + (c & 1)];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeBb2(RECOIL *self, unsigned char const *content, int contentLength, int const *palette)
{
	if (contentLength != 20480)
		return FALSE;
	RECOIL_SetSize(self, 320, 256, RECOILResolution_BBC2X1);
	{
		int y;
		for (y = 0; y < 256; y++) {
			{
				int x;
				for (x = 0; x < 160; x++) {
					int c = content[(y & ~7) * 80 + ((x & ~1) << 2) + (y & 7)] >> (~x & 1);
					int pixelsOffset = (y * 160 + x) << 1;
					self->pixels[pixelsOffset + 1] = self->pixels[pixelsOffset] = palette[((c >> 3) & 8) + ((c >> 2) & 4) + ((c >> 1) & 2) + (c & 1)];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeBb4(RECOIL *self, unsigned char const *content, int contentLength, int const *palette)
{
	if (contentLength != 10240)
		return FALSE;
	RECOIL_SetSize(self, 320, 256, RECOILResolution_BBC1X1);
	{
		int y;
		for (y = 0; y < 256; y++) {
			{
				int x;
				for (x = 0; x < 320; x++) {
					int c = (content[(y & ~7) * 40 + (x & ~7) + (y & 7)] >> (~x & 7)) & 1;
					self->pixels[y * 320 + x] = palette[c];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeBb5(RECOIL *self, unsigned char const *content, int contentLength, int const *palette)
{
	if (contentLength != 10240)
		return FALSE;
	RECOIL_SetSize(self, 320, 256, RECOILResolution_BBC2X1);
	{
		int y;
		for (y = 0; y < 256; y++) {
			{
				int x;
				for (x = 0; x < 160; x++) {
					int c = content[(y & ~7) * 40 + ((x & ~3) << 1) + (y & 7)] >> (~x & 3);
					int pixelsOffset = (y * 160 + x) << 1;
					self->pixels[pixelsOffset + 1] = self->pixels[pixelsOffset] = palette[((c >> 3) & 2) + (c & 1)];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeBbg(RECOIL *self, unsigned char const *content, int contentLength)
{
	BbgStream rle;
	int mode;
	int unpackedLength;
	int unpackedStep;
	unsigned char unpacked[20480];
	BbgStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 0;
	rle.base.base.base.contentLength = contentLength;
	rle.valueBits = BbgStream_ReadBitsReverse(&rle, 8);
	if (rle.valueBits < 1 || rle.valueBits > 8)
		return FALSE;
	mode = BbgStream_ReadBitsReverse(&rle, 8);
	switch (mode) {
	case 0:
	case 1:
	case 2:
		unpackedLength = 20480;
		break;
	case 4:
	case 5:
		unpackedLength = 10240;
		break;
	default:
		return FALSE;
	}
	{
		int i;
		for (i = 15; i >= 0; i--) {
			int c = BbgStream_ReadBitsReverse(&rle, 4);
			if (c < 0)
				return FALSE;
			self->contentPalette[i] = RECOIL_BbcPalette[c];
		}
	}
	unpackedStep = BbgStream_ReadBitsReverse(&rle, 8);
	if (unpackedStep <= 0)
		return FALSE;
	rle.countBits = BbgStream_ReadBitsReverse(&rle, 8);
	if (rle.countBits < 1 || rle.countBits > 8)
		return FALSE;
	{
		int x;
		for (x = unpackedStep - 1; x >= 0; x--) {
			if (!RleStream_Unpack(&rle.base, unpacked, x, unpackedStep, unpackedLength))
				return FALSE;
		}
	}
	switch (mode) {
	case 0:
		return RECOIL_DecodeBb0(self, unpacked, unpackedLength, self->contentPalette);
	case 1:
		return RECOIL_DecodeBb1(self, unpacked, unpackedLength, self->contentPalette);
	case 2:
		return RECOIL_DecodeBb2(self, unpacked, unpackedLength, self->contentPalette);
	case 4:
		return RECOIL_DecodeBb4(self, unpacked, unpackedLength, self->contentPalette);
	case 5:
		return RECOIL_DecodeBb5(self, unpacked, unpackedLength, self->contentPalette);
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeBfli(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 33795 || content[2] != 98)
		return FALSE;
	RECOIL_SetSize(self, 296, 400, RECOILResolution_C642X1);
	RECOIL_DecodeC64MulticolorFrame(self, content, 9243, 1030, 6, 0, 0);
	RECOIL_DecodeC64MulticolorFrame(self, content, 25603, 17411, 3, 0, 59200);
	return TRUE;
}

static cibool RECOIL_DecodeBgp(RECOIL *self, unsigned char const *content, int contentLength)
{
	int textLength;
	unsigned char frame1[76480];
	unsigned char frame2[76480];
	if (contentLength < 19163 || !RECOIL_IsStringAt(content, 0, "BUGBITER_APAC239I_PICTURE_V1.0") || content[30] != 255 || content[31] != 80 || content[32] != 239)
		return FALSE;
	textLength = content[37] + (content[38] << 8);
	if (contentLength != 19163 + textLength || content[39 + textLength] != 88 || content[40 + textLength] != 37 || content[9601 + textLength] != 88 || content[9602 + textLength] != 37)
		return FALSE;
	RECOIL_SetSize(self, 320, 239, RECOILResolution_XE4X1);
	self->gtiaColors[8] = 0;
	RECOIL_DecodeAtari8Gr9(self, content, 41 + textLength, 80, frame1, 0, 640, 320, 120);
	RECOIL_DecodeAtari8Gr11PalBlend(self, content, 9643 + textLength, 80, frame1, 1);
	RECOIL_DecodeAtari8Gr9(self, content, 81 + textLength, 80, frame2, 320, 640, 320, 119);
	RECOIL_DecodeAtari8Gr11PalBlend(self, content, 9603 + textLength, 80, frame2, 0);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static void RECOIL_DecodeBitplanes(RECOIL *self, unsigned char const *content, int contentOffset, int contentStride, int bitplanes, int pixelsOffset, int width, int height)
{
	while (--height >= 0) {
		{
			int x;
			for (x = 0; x < width; x++) {
				int offset = contentOffset + ((x >> 3) & ~1) * bitplanes + ((x >> 3) & 1);
				int bit = ~x & 7;
				int c = 0;
				{
					int bitplane;
					for (bitplane = bitplanes; --bitplane >= 0;)
						c = (c << 1) | ((content[offset + (bitplane << 1)] >> bit) & 1);
				}
				self->pixels[pixelsOffset + x] = self->contentPalette[c];
			}
		}
		contentOffset += contentStride;
		pixelsOffset += self->width;
	}
}

static cibool RECOIL_DecodeBkg(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 3856 && RECOIL_DecodeGr7(self, content, 0, 3844);
}

static cibool RECOIL_DecodeBlackAndWhite(RECOIL *self, unsigned char const *content, int contentOffset, int contentLength, cibool wordAlign, int backgroundColor)
{
	self->contentPalette[0] = backgroundColor;
	self->contentPalette[1] = backgroundColor ^ 16777215;
	return RECOIL_DecodeMono(self, content, contentOffset, contentLength, wordAlign);
}

static void RECOIL_DecodeBlackAndWhiteFont(RECOIL *self, unsigned char const *content, int contentOffset, int contentLength, int fontHeight)
{
	{
		int y;
		for (y = 0; y < self->height; y++) {
			{
				int x;
				for (x = 0; x < 256; x++) {
					int row = y % fontHeight;
					int offset = contentOffset + ((y - row) << 5) + (x >> 3) * fontHeight + row;
					int c;
					if (offset < contentLength) {
						c = (content[offset] >> (~x & 7)) & 1;
						if (c != 0)
							c = 16777215;
					}
					else
						c = 0;
					self->pixels[(y << 8) + x] = c;
				}
			}
		}
	}
}

static cibool RECOIL_DecodeBlazingPaddlesVectors(RECOIL *self, unsigned char const *content, int contentLength, int startAddress)
{
	int x = 0;
	int y = 0;
	int i;
	int lineI = 0;
	int lineTop = 0;
	int lineBottom = 0;
	int xs[256];
	int ys[256];
	int width = 0;
	BlazingPaddlesBoundingBox box;
	unsigned char frame[76800];
	for (i = 0; i < 256; i++) {
		int shapeWidth;
		if (!BlazingPaddlesBoundingBox_Calculate(&box, content, contentLength, i, startAddress))
			break;
		shapeWidth = box.right - box.left + 2;
		if (x + shapeWidth > 160) {
			y -= lineTop;
			while (lineI < i)
				ys[lineI++] = y;
			if (width < x)
				width = x;
			x = 0;
			y += lineBottom + 2;
			lineTop = box.top;
			lineBottom = box.bottom;
		}
		xs[i] = x - box.left;
		x += shapeWidth;
		if (lineTop > box.top)
			lineTop = box.top;
		if (lineBottom < box.bottom)
			lineBottom = box.bottom;
	}
	y -= lineTop;
	while (lineI < i)
		ys[lineI++] = y;
	if (width < x)
		width = x;
	y += lineBottom + 1;
	if (i == 0 || y > 240)
		return FALSE;
	RECOIL_SetSize(self, width << 1, y, RECOILResolution_XE2X1);
	memset(frame, 0, sizeof(frame));
	for (i = 0; i < 256; i++) {
		if (!RECOIL_DrawBlazingPaddlesVector(self, content, contentLength, frame, (ys[i] * width + xs[i]) * 2, i, startAddress))
			break;
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeBld(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	BldStream rle;
	if (contentLength < 5)
		return FALSE;
	width = (content[0] << 8) | content[1];
	height = (content[2] << 8) | content[3];
	if (content[0] < 128)
		return RECOIL_SetSize(self, width, height, RECOILResolution_ST1X1) && RECOIL_DecodeBlackAndWhite(self, content, 4, contentLength, FALSE, 16777215);
	if (!RECOIL_SetSize(self, 65536 - width, height, RECOILResolution_ST1X1))
		return FALSE;
	BldStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 4;
	rle.base.base.base.contentLength = contentLength;
	return RECOIL_DecodeRleBlackAndWhite(self, &rle.base, 16777215);
}

static cibool RECOIL_DecodeBml(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 17474:
	case 17665:
	case 17666:
		break;
	default:
		return FALSE;
	}
	RECOIL_DecodeC64Multicolor(self, 296, content, 9498, 1285, 261, -2);
	return TRUE;
}

static cibool RECOIL_DecodeBru(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 64)
		return FALSE;
	RECOIL_SetSize(self, 8, 8, RECOILResolution_ST1X1);
	{
		int i;
		for (i = 0; i < 64; i++) {
			switch (content[i]) {
			case 0:
				self->pixels[i] = 0;
				break;
			case 1:
				self->pixels[i] = 16777215;
				break;
			default:
				return FALSE;
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeBrus(RECOIL *self, unsigned char const *content, int contentLength)
{
	int columns;
	int height;
	int width;
	int bitmapLength;
	unsigned char bitmap[63000];
	PgcStream rle;
	int contentOffset;
	unsigned char colors[180];
	if (contentLength < 20 || !RECOIL_IsStringAt(content, 2, "BRUS") || content[6] != 4 || content[10] != 1 || content[11] != 2)
		return FALSE;
	columns = content[12];
	if (columns == 0 || columns > 90)
		return FALSE;
	height = content[13] | (content[14] << 8);
	if (height == 0 || height > 700)
		return FALSE;
	width = columns << 3;
	RECOIL_SetSize(self, width, height, RECOILResolution_C1281X1);
	bitmapLength = height * columns;
	PgcStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 18;
	rle.base.base.base.contentLength = contentLength;
	if (!RleStream_Unpack(&rle.base, bitmap, 0, 1, bitmapLength))
		return FALSE;
	contentOffset = rle.base.base.base.contentOffset;
	if (contentOffset + 4 >= contentLength || !RECOIL_IsStringAt(content, contentOffset, "COLR")) {
		return RECOIL_DecodeBlackAndWhite(self, bitmap, 0, bitmapLength, FALSE, 16777215);
	}
	rle.base.base.base.contentOffset = contentOffset + 4;
	{
		int y;
		for (y = 0; y < height; y++) {
			if ((y & 7) == 0 && !RleStream_Unpack(&rle.base, colors, 0, 1, columns << 1))
				return FALSE;
			{
				int x;
				for (x = 0; x < width; x++) {
					int column = x >> 3;
					int c = colors[(y & 1) * columns + column];
					static const int palette[16] = { 0, 5592405, 170, 5592575, 43520, 5635925, 43690, 5636095, 11141120, 16733525, 11141290, 16733695, 11162880, 16777045, 11184810, 16777215 };
					if (((bitmap[y * columns + column] >> (~x & 7)) & 1) == 0)
						c >>= 4;
					self->pixels[y * width + x] = palette[c & 15];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeBsc(RECOIL *self, unsigned char const *content, int contentLength)
{
	int borderOffset;
	switch (contentLength) {
	case 11136:
		borderOffset = 6912;
		break;
	case 11904:
		borderOffset = 7680;
		break;
	default:
		return FALSE;
	}
	RECOIL_SetSize(self, 384, 304, RECOILResolution_SPECTRUM1X1);
	{
		int y;
		for (y = 0; y < 304; y++) {
			int c = 0;
			{
				int x;
				for (x = 0; x < 384; x++) {
					if (y >= 64 && y < 256 && x >= 64 && x < 320) {
						int bY = y - 64;
						int col = (x >> 3) - 8;
						int a = 6144 + (bY >> 3 << 5) + col;
						if (contentLength == 11904 && (bY & 4) != 0)
							a += 768;
						a = content[a];
						c = a;
						if (((content[((bY & 192) << 5) + ((bY & 7) << 8) + ((bY & 56) << 2) + col] >> (~x & 7)) & 1) == 0)
							c >>= 3;
						c = RECOIL_GetZxColor(c);
						if ((a & 64) == 0)
							c &= 13487565;
					}
					else if ((x & 7) == 0) {
						c = content[borderOffset];
						if ((x & 8) != 0) {
							borderOffset++;
							c >>= 3;
						}
						c = RECOIL_GetZxColor(c) & 13487565;
					}
					self->pixels[y * 384 + x] = c;
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeBw(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	if (contentLength < 11 || !RECOIL_IsStringAt(content, 0, "B&W256"))
		return FALSE;
	width = (content[6] << 8) | content[7];
	height = (content[8] << 8) | content[9];
	return RECOIL_DecodeFalconGrayscale(self, content, 10, contentLength, width, height);
}

static void RECOIL_DecodeBytes(RECOIL *self, unsigned char const *content, int contentOffset)
{
	int pixelsLength = self->width * self->height;
	{
		int i;
		for (i = 0; i < pixelsLength; i++)
			self->pixels[i] = self->contentPalette[content[contentOffset + i]];
	}
}

static cibool RECOIL_DecodeC64Fun(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength < 18 || !RECOIL_IsStringAt(content, 2, "FUNPAINT (MT) "))
		return FALSE;
	if (content[16] != 0) {
		unsigned char unpacked[33694];
		DrpStream rle;
		DrpStream_Construct(&rle, NULL);
		rle.base.base.base.content = content;
		rle.base.base.base.contentOffset = 18;
		rle.base.base.base.contentLength = contentLength;
		rle.escape = content[17];
		return RleStream_Unpack(&rle.base, unpacked, 18, 1, 33694) && RleStream_ReadRle(&rle.base) < 0 && RECOIL_DecodeFunUnpacked(self, unpacked);
	}
	return contentLength == 33694 && RECOIL_DecodeFunUnpacked(self, content);
}

static cibool RECOIL_DecodeC64Hir(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 8002:
	case 8194:
		break;
	default:
		return FALSE;
	}
	RECOIL_SetSize(self, 320, 200, RECOILResolution_C641X1);
	RECOIL_DecodeC64HiresFrame(self, content, 2, -16, 0);
	return TRUE;
}

static void RECOIL_DecodeC64HiresFrame(RECOIL *self, unsigned char const *content, int bitmapOffset, int videoMatrixOffset, int pixelsOffset)
{
	cibool afli = self->width == 296;
	{
		int y;
		for (y = 0; y < self->height; y++) {
			{
				int x;
				for (x = 0; x < self->width; x++) {
					int offset = (y & ~7) * 40 + (x & ~7) + (y & 7);
					int c = (content[bitmapOffset + offset] >> (~x & 7)) & 1;
					int v;
					if (videoMatrixOffset >= 0) {
						offset >>= 3;
						if (afli)
							offset += (y & 7) << 10;
						v = content[videoMatrixOffset + offset];
					}
					else
						v = -videoMatrixOffset;
					c = c == 0 ? v & 15 : v >> 4;
					self->pixels[pixelsOffset + y * self->width + x] = RECOIL_C64Palette[c];
				}
			}
		}
	}
}

static cibool RECOIL_DecodeC64Multicolor(RECOIL *self, int width, unsigned char const *content, int bitmapOffset, int videoMatrixOffset, int colorOffset, int background)
{
	RECOIL_SetSize(self, width, 200, RECOILResolution_C642X1);
	RECOIL_DecodeC64MulticolorFrame(self, content, bitmapOffset, videoMatrixOffset, colorOffset, background, 0);
	return TRUE;
}

static void RECOIL_DecodeC64MulticolorFrame(RECOIL *self, unsigned char const *content, int bitmapOffset, int videoMatrixOffset, int colorOffset, int background, int pixelsOffset)
{
	cibool fli = self->width == 296;
	cibool bottomBfli = pixelsOffset != 0 && self->height == 400;
	{
		int y;
		for (y = 0; y < 200; y++) {
			int lineBackground;
			if (background >= 0)
				lineBackground = background;
			else if (background == -16209 && y >= 177)
				lineBackground = content[y < 197 ? 18233 + y : 18429];
			else
				lineBackground = content[y - background];
			{
				int x;
				for (x = 0; x < self->width; x++) {
					int c = lineBackground;
					int i = x + self->leftSkip;
					if (i >= 0) {
						int offset = (y & ~7) * 40 + (i & ~7) + (y & 7);
						if (bottomBfli)
							offset = (offset - 168) & 8191;
						switch ((content[bitmapOffset + offset] >> (~i & 6)) & 3) {
						case 1:
							offset >>= 3;
							if (fli)
								offset += (y & 7) << 10;
							c = content[videoMatrixOffset + offset] >> 4;
							break;
						case 2:
							offset >>= 3;
							if (fli)
								offset += (y & 7) << 10;
							c = content[videoMatrixOffset + offset];
							break;
						case 3:
							c = colorOffset < 0 ? content[-colorOffset] : content[colorOffset + (offset >> 3)];
							break;
						default:
							break;
						}
					}
					self->pixels[pixelsOffset + y * self->width + x] = RECOIL_C64Palette[c & 15];
				}
			}
		}
	}
}

static cibool RECOIL_DecodeCa(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset;
	if (contentLength < 8 || content[0] != 67 || content[1] != 65)
		return FALSE;
	switch (content[3]) {
	case 0:
		contentOffset = 36;
		break;
	case 1:
		contentOffset = 12;
		break;
	case 2:
		contentOffset = 4;
		break;
	default:
		return FALSE;
	}
	switch (content[2]) {
	case 0:
		return contentOffset + 32000 == contentLength && RECOIL_DecodeSt(self, content, contentOffset, content, 4, content[3], 0);
	case 1:
		{
			unsigned char unpacked[32000];
			CaStream rle;
			CaStream_Construct(&rle, NULL);
			rle.base.base.base.content = content;
			rle.base.base.base.contentOffset = contentOffset;
			rle.base.base.base.contentLength = contentLength;
			return CaStream_UnpackCa(&rle, unpacked, 0) && RECOIL_DecodeSt(self, unpacked, 0, content, 4, content[3], 0);
		}
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeCci(RECOIL *self, unsigned char const *content, int contentLength)
{
	CciStream rle;
	unsigned char unpacked[16384];
	if (contentLength < 24 || !RECOIL_IsStringAt(content, 0, "CIN 1.2 "))
		return FALSE;
	CciStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 8;
	rle.base.base.base.contentLength = contentLength;
	if (!CciStream_UnpackGr15(&rle, unpacked, 0) || !CciStream_UnpackGr15(&rle, unpacked, 40))
		return FALSE;
	rle.base.base.base.contentOffset += 4;
	rle.base.repeatCount = 0;
	if (!RleStream_UnpackColumns(&rle.base, unpacked, 7680, 40, 15360))
		return FALSE;
	rle.base.base.base.contentOffset += 4;
	rle.base.repeatCount = 0;
	return RleStream_Unpack(&rle.base, unpacked, 15360, 1, 16384) && RECOIL_DecodeCin(self, unpacked, 16384);
}

static cibool RECOIL_DecodeCe(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength < 192022 || !RECOIL_IsStringAt(content, 0, "EYES") || content[4] != 0)
		return FALSE;
	switch (content[5]) {
	case 0:
		if (contentLength != 192022)
			return FALSE;
		RECOIL_SetSize(self, 320, 200, RECOILResolution_ST1X1);
		{
			int y;
			for (y = 0; y < 200; y++) {
				{
					int x;
					for (x = 0; x < 320; x++) {
						int offset = 22 + x * 200 + y;
						int rgb = (content[offset] << 16) | (content[64000 + offset] << 8) | content[128000 + offset];
						if ((rgb & 12632256) != 0)
							return FALSE;
						self->pixels[y * 320 + x] = (rgb << 2) | ((rgb >> 4) & 197379);
					}
				}
			}
		}
		return TRUE;
	case 1:
		if (contentLength != 256022)
			return FALSE;
		RECOIL_SetSize(self, 640, 400, RECOILResolution_ST1X2);
		{
			int y;
			for (y = 0; y < 200; y++) {
				{
					int x;
					for (x = 0; x < 640; x++) {
						int offset = (11 + x * 200 + y) << 1;
						int c = (content[offset] << 8) | content[offset + 1];
						if (c >= 32768)
							return FALSE;
						offset = y * 1280 + x;
						self->pixels[offset + 640] = self->pixels[offset] = RECOIL_GetR5G5B5Color(c);
					}
				}
			}
		}
		return TRUE;
	case 2:
		if (contentLength != 256022)
			return FALSE;
		RECOIL_SetSize(self, 640, 400, RECOILResolution_ST1X1);
		{
			int y;
			for (y = 0; y < 400; y++) {
				{
					int x;
					for (x = 0; x < 640; x++) {
						int b = content[22 + x * 400 + (y & 1) * 200 + (y >> 1)];
						if (b > 191)
							return FALSE;
						self->pixels[y * 640 + x] = b * 4 / 3 * 65793;
					}
				}
			}
		}
		return TRUE;
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeCel(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	if (contentLength < 128 || content[0] != 255 || content[1] != 255 || content[2] != 0 || content[3] != 0)
		return FALSE;
	width = (content[58] << 8) | content[59];
	height = (content[60] << 8) | content[61];
	return contentLength == 128 + ((width + 15) >> 4 << 3) * height && RECOIL_DecodeStLow(self, content, 128, content, 4, width, height);
}

static cibool RECOIL_DecodeCh8(RECOIL *self, unsigned char const *content, int contentLength)
{
	int height;
	switch (contentLength) {
	case 768:
		height = 24;
		break;
	case 2048:
		height = 64;
		break;
	default:
		return FALSE;
	}
	RECOIL_SetSize(self, 256, height, RECOILResolution_SPECTRUM1X1);
	RECOIL_DecodeBlackAndWhiteFont(self, content, 0, contentLength, 8);
	return TRUE;
}

static cibool RECOIL_DecodeChr(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 3072 && RECOIL_DecodeBlazingPaddlesVectors(self, content, contentLength, 28672);
}

static cibool RECOIL_DecodeChrd(RECOIL *self, unsigned char const *content, int contentLength)
{
	int columns;
	int rows;
	int bytesPerCell;
	int cells;
	int frames;
	int contentOffset;
	if (contentLength < 15 || !RECOIL_IsStringAt(content, 0, "chr$"))
		return FALSE;
	columns = content[4];
	rows = content[5];
	bytesPerCell = content[6];
	cells = rows * columns;
	switch (bytesPerCell) {
	case 9:
		frames = 1;
		break;
	case 18:
		if (cells << 7 > 2854278)
			return FALSE;
		frames = 2;
		break;
	default:
		return FALSE;
	}
	if (contentLength != 7 + cells * bytesPerCell || !RECOIL_SetSize(self, columns << 3, rows << 3, RECOILResolution_SPECTRUM1X1))
		return FALSE;
	contentOffset = 7;
	{
		int row;
		for (row = 0; row < rows; row++) {
			{
				int column;
				for (column = 0; column < columns; column++) {
					{
						int frame;
						for (frame = 0; frame < frames; frame++) {
							int a = content[contentOffset + 8];
							{
								int y;
								for (y = 0; y < 8; y++) {
									{
										int x;
										for (x = 0; x < 8; x++) {
											int c = (content[contentOffset + y] >> (7 - x)) & 1;
											c = RECOIL_GetZxColor(c == 0 ? a >> 3 : a);
											if ((a & 64) == 0)
												c &= 13487565;
											self->pixels[(((((frame * rows + row) << 3) + y) * columns + column) << 3) + x] = c;
										}
									}
								}
							}
							contentOffset += 9;
						}
					}
				}
			}
		}
	}
	if (frames == 2)
		RECOIL_ApplyBlend(self);
	return TRUE;
}

static cibool RECOIL_DecodeChs(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset = RECOIL_GetOricHeader(content, contentLength);
	switch (contentLength - contentOffset) {
	case 768:
	case 769:
		break;
	default:
		return FALSE;
	}
	RECOIL_SetSize(self, 256, 24, RECOILResolution_ORIC1X1);
	RECOIL_DecodeBlackAndWhiteFont(self, content, contentOffset, contentLength, 8);
	return TRUE;
}

static cibool RECOIL_DecodeCin(RECOIL *self, unsigned char const *content, int contentLength)
{
	int height;
	unsigned char frame1[64000];
	unsigned char frame2[64000];
	switch (contentLength) {
	case 15360:
		RECOIL_SetGr15DefaultColors(self);
		height = 192;
		break;
	case 16004:
		RECOIL_SetBakPF012(self, content, 16000, 1);
		height = 200;
		break;
	case 16384:
		height = 192;
		break;
	default:
		return FALSE;
	}
	RECOIL_SetSize(self, 320, height, RECOILResolution_XE2X1);
	{
		int y;
		for (y = 0; y < height; y++) {
			if (contentLength == 16384)
				RECOIL_SetBakPF012(self, content, 15360 + y, 256);
			RECOIL_DecodeAtari8Gr15(self, content, y * 40, 40, (y & 1) == 0 ? frame1 : frame2, y * 320, 320, 1);
		}
	}
	RECOIL_DecodeAtari8Gr11PalBlend(self, content, 40 * height + 40, 80, frame1, 1);
	RECOIL_DecodeAtari8Gr11PalBlend(self, content, 40 * height, 80, frame2, 0);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeClp(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 306 || content[305] != 100)
		return FALSE;
	{
		int i;
		for (i = 0; i < 25; i++) {
			static const unsigned char header[25] = { 0, 0, 0, 3, 1, 94, 0, 0, 32, 0, 32, 1, 1, 44, 0, 10,
				0, 56, 0, 32, 0, 56, 0, 32, 5 };
			if (content[i] != header[i])
				return FALSE;
		}
	}
	RECOIL_SetSize(self, 40, 56, RECOILResolution_COCO1X1);
	return RECOIL_DecodeBlackAndWhite(self, content, 25, 305, FALSE, 16777215);
}

static cibool RECOIL_DecodeCm5(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	unsigned char gfx[18433];
	if (contentLength != 2049)
		return FALSE;
	if (RECOIL_ReadCompanionFile(self, filename, "GFX", "gfx", gfx, 18433) != 18432)
		return FALSE;
	RECOIL_SetSize(self, 288, 256, RECOILResolution_AMSTRAD1X1);
	{
		int y;
		for (y = 0; y < 256; y++) {
			{
				int x;
				for (x = 0; x < 288; x++) {
					int c;
					switch ((gfx[y * 72 + (x >> 2)] >> (~x & 3)) & 17) {
					case 0:
						c = 3 + (y << 3) + x / 48;
						break;
					case 1:
						c = 1 + (y << 3);
						break;
					case 16:
						c = 2 + (y << 3);
						break;
					default:
						c = 0;
						break;
					}
					c = content[c];
					if (c < 64 || c > 95)
						return FALSE;
					self->pixels[y * 288 + x] = RECOIL_AmstradPalette[c - 64];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeCmp(RECOIL *self, unsigned char const *content, int contentLength)
{
	CmpStream rle;
	if (contentLength < 5)
		return FALSE;
	switch (content[1]) {
	case 0:
		RECOIL_SetSize(self, 640, 400, RECOILResolution_ST1X1);
		break;
	case 200:
		RECOIL_SetSize(self, 640, 800, RECOILResolution_ST1X1);
		break;
	default:
		return FALSE;
	}
	CmpStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 2;
	rle.base.base.base.contentLength = contentLength;
	return RECOIL_DecodeRleBlackAndWhite(self, &rle.base, 16777215);
}

static cibool RECOIL_DecodeCocoMax(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 6154:
	case 6155:
	case 6272:
	case 7168:
		break;
	default:
		return FALSE;
	}
	if (content[0] != 0 || content[1] != 24 || content[2] > 1 || content[3] != 14 || content[4] != 0)
		return FALSE;
	RECOIL_SetSize(self, 256, 192, RECOILResolution_COCO1X1);
	return RECOIL_DecodeBlackAndWhite(self, content, 5, 6149, FALSE, 0);
}

static cibool RECOIL_DecodeCp3(RECOIL *self, unsigned char const *content, int contentLength)
{
	int countLength;
	int valueOffset;
	unsigned char unpacked[32000];
	int unpackedOffset;
	int count;
	if (contentLength < 4)
		return FALSE;
	countLength = (1 + (content[0] << 8) + content[1]) << 2;
	if (contentLength <= countLength)
		return FALSE;
	valueOffset = countLength;
	unpackedOffset = 0;
	{
		int countOffset;
		for (countOffset = 4; countOffset < countLength; countOffset += 4) {
			count = ((content[countOffset] << 8) | content[countOffset + 1]) << 3;
			if (valueOffset + count + 8 > contentLength || unpackedOffset + count > 32000)
				return FALSE;
			memcpy(unpacked + unpackedOffset, content + valueOffset, count);
			valueOffset += count;
			unpackedOffset += count;
			count = ((content[countOffset + 2] << 8) | content[countOffset + 3]) << 3;
			if (unpackedOffset + count > 32000)
				return FALSE;
			{
				int offset;
				for (offset = 0; offset < count; offset += 8)
					memcpy(unpacked + unpackedOffset + offset, content + valueOffset, 8);
			}
			valueOffset += 8;
			unpackedOffset += count;
		}
	}
	count = 32000 - unpackedOffset;
	if (valueOffset + count != contentLength)
		return FALSE;
	memcpy(unpacked + unpackedOffset, content + valueOffset, count);
	return RECOIL_DecodeDoo(self, unpacked, 32000);
}

static cibool RECOIL_DecodeCpi(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[7936];
	CpiStream rle;
	unsigned char frame[61440];
	CpiStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 0;
	rle.base.base.base.contentLength = contentLength;
	if (!RleStream_Unpack(&rle.base, unpacked, 0, 1, 7936))
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X1);
	self->gtiaColors[8] = 0;
	self->gtiaColors[4] = 12;
	self->gtiaColors[5] = 8;
	self->gtiaColors[6] = 4;
	RECOIL_DecodeAtari8Gr15(self, unpacked, 0, 40, frame, 0, 320, 192);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeCpr(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[7680];
	unsigned char frame[61440];
	if (contentLength < 2)
		return FALSE;
	if (!XeKoalaStream_UnpackRaw(content[0], content, 1, contentLength, unpacked, 7680))
		return FALSE;
	self->gtiaColors[6] = 12;
	self->gtiaColors[5] = 0;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE1X1);
	RECOIL_DecodeAtari8Gr8(self, unpacked, 0, frame, 0, 192);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeCpt(RECOIL *self, unsigned char const *content, int contentLength)
{
	int bitplanes;
	unsigned char unpacked[32000];
	unsigned char isFilled[16000];
	int contentOffset;
	if (contentLength < 40 || content[32] != 0 || content[33] > 2)
		return FALSE;
	bitplanes = 4 >> content[33];
	memset(isFilled, 0, sizeof(isFilled));
	contentOffset = 34;
	for (;;) {
		int nextContentOffset = contentOffset + 4 + bitplanes * 2;
		int repeatCount;
		int offset;
		if (nextContentOffset > contentLength)
			return FALSE;
		repeatCount = (content[contentOffset] << 8) | content[contentOffset + 1];
		if (repeatCount == 65535) {
			contentOffset = nextContentOffset;
			break;
		}
		offset = ((content[contentOffset + 2] << 8) | content[contentOffset + 3]) * bitplanes;
		do {
			if (offset >= 16000)
				return FALSE;
			memcpy(unpacked + (offset << 1), content + contentOffset + 4, bitplanes << 1);
			isFilled[offset] = 1;
			offset += bitplanes;
		}
		while (--repeatCount >= 0);
		contentOffset = nextContentOffset;
	}
	{
		int offset;
		for (offset = 0; offset < 16000; offset += bitplanes) {
			if (isFilled[offset] == 0) {
				int nextContentOffset = contentOffset + bitplanes * 2;
				if (nextContentOffset > contentLength)
					return FALSE;
				memcpy(unpacked + (offset << 1), content + contentOffset, bitplanes << 1);
				contentOffset = nextContentOffset;
			}
		}
	}
	return RECOIL_DecodeSt(self, unpacked, 0, content, 0, content[33], 0);
}

static cibool RECOIL_DecodeCrg(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	CciStream rle;
	if (contentLength < 43 || !RECOIL_IsStringAt(content, 0, "CALAMUSCRG") || content[10] != 3 || content[11] != 232 || content[12] != 0 || content[13] != 2)
		return FALSE;
	width = RECOIL_Get32BigEndian(content, 20);
	height = RECOIL_Get32BigEndian(content, 24);
	if (!RECOIL_SetSize(self, width, height, RECOILResolution_ST1X1))
		return FALSE;
	CciStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 42;
	rle.base.base.base.contentLength = contentLength;
	return RECOIL_DecodeRleBlackAndWhite(self, &rle.base, 16777215);
}

static cibool RECOIL_DecodeDa4(RECOIL *self, unsigned char const *content, int contentLength)
{
	RECOIL_SetSize(self, 640, 800, RECOILResolution_ST1X1);
	return RECOIL_DecodeBlackAndWhite(self, content, 0, contentLength, FALSE, 16777215);
}

static cibool RECOIL_DecodeDaliCompressed(RECOIL *self, unsigned char const *content, int contentLength, int mode)
{
	DaliStream stream;
	int countLength;
	stream.base.content = content;
	stream.base.contentOffset = 32;
	stream.base.contentLength = contentLength;
	countLength = Stream_ParseInt(&stream.base);
	return countLength > 0 && Stream_ParseInt(&stream.base) > 0 && DaliStream_Decode(&stream, countLength, self, 0, mode);
}

static cibool RECOIL_DecodeDap(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 77568)
		return FALSE;
	RECOIL_SetSize(self, 320, 240, RECOILResolution_XE1X1);
	{
		int i;
		for (i = 0; i < 256; i++)
			self->contentPalette[i] = (content[76800 + i] << 16) | (content[77056 + i] << 8) | content[77312 + i];
	}
	RECOIL_DecodeBytes(self, content, 0);
	return TRUE;
}

static cibool RECOIL_DecodeDc1(RECOIL *self, unsigned char const *content, int contentLength)
{
	int compression;
	unsigned char unpacked[64000];
	int contentOffset;
	int valueBytes;
	int repeatCount;
	if (contentLength < 1042 || content[0] != 68 || content[1] != 71 || content[2] != 67 || content[4] != 1 || content[5] != 64 || content[6] != 0 || content[7] != 200)
		return FALSE;
	compression = content[3];
	if (compression == 0) {
		if (contentLength != 65034)
			return FALSE;
		RECOIL_DecodeFalconPalette(self, content, 1034, 10, 320, 200);
		return TRUE;
	}
	if (compression > 3)
		return FALSE;
	contentOffset = 1038;
	valueBytes = 1 << (compression - 1);
	repeatCount = 0;
	{
		int bitplane;
		for (bitplane = 0; bitplane < 16; bitplane += 2) {
			{
				int unpackedOffset;
				for (unpackedOffset = bitplane; unpackedOffset < 64000; unpackedOffset += 16) {
					{
						int x;
						for (x = 0; x < 2; x++) {
							if (repeatCount == 0) {
								int nextContentOffset = contentOffset + compression * 2;
								if (nextContentOffset <= contentLength) {
									switch (compression) {
									case 1:
										repeatCount = content[contentOffset] + 1;
										break;
									case 2:
										repeatCount = ((content[contentOffset] << 8) + content[contentOffset + 1] + 1) << 1;
										break;
									case 3:
										repeatCount = ((content[contentOffset] << 8) + content[contentOffset + 1] + 1) << 2;
										break;
									}
									contentOffset = nextContentOffset;
								}
							}
							unpacked[unpackedOffset + x] = repeatCount > 0 ? content[contentOffset - (--repeatCount & (valueBytes - 1)) - 1] : 0;
						}
					}
				}
			}
		}
	}
	RECOIL_SetFalconPalette(self, content, 10);
	RECOIL_SetSize(self, 320, 200, RECOILResolution_FALCON1X1);
	RECOIL_DecodeBitplanes(self, unpacked, 0, 320, 8, 0, 320, 200);
	return TRUE;
}

static cibool RECOIL_DecodeDd(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 9026:
	case 9218:
	case 9346:
		break;
	default:
		return FALSE;
	}
	RECOIL_SetSize(self, 320, 200, RECOILResolution_C641X1);
	RECOIL_DecodeC64HiresFrame(self, content, 1026, 2, 0);
	return TRUE;
}

static cibool RECOIL_DecodeDeep(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width = 0;
	int height = 0;
	int compression = 0;
	RECOILResolution resolution = RECOILResolution_AMIGA1X1;
	DeepStream rle;
	int tvdcOffset;
	DeepStream_Construct(&rle, NULL);
	rle.base.base.base.base.content = content;
	tvdcOffset = -1;
	{
		int contentOffset;
		for (contentOffset = 12; contentOffset < contentLength - 7;) {
			int chunkLength = RECOIL_Get32BigEndian(content, contentOffset + 4);
			int chunkEndOffset = contentOffset + 8 + chunkLength;
			if (chunkEndOffset > contentLength || chunkEndOffset < contentOffset + 8)
				break;
			if (RECOIL_IsStringAt(content, contentOffset, "DGBL")) {
				if (chunkLength < 8 || content[contentOffset + 12] != 0)
					return FALSE;
				width = (content[contentOffset + 8] << 8) | content[contentOffset + 9];
				height = (content[contentOffset + 10] << 8) | content[contentOffset + 11];
				compression = content[contentOffset + 13];
				resolution = RECOIL_GetAmigaAspectRatio(content[contentOffset + 14], content[contentOffset + 15], resolution);
			}
			else if (RECOIL_IsStringAt(content, contentOffset, "DPEL")) {
				if (!DeepStream_SetDpel(&rle, contentOffset, chunkLength))
					return FALSE;
			}
			else if (RECOIL_IsStringAt(content, contentOffset, "DLOC")) {
				if (chunkLength < 4)
					return FALSE;
				width = (content[contentOffset + 8] << 8) | content[contentOffset + 9];
				height = (content[contentOffset + 10] << 8) | content[contentOffset + 11];
			}
			else if (RECOIL_IsStringAt(content, contentOffset, "TVDC")) {
				if (chunkLength != 32)
					return FALSE;
				tvdcOffset = contentOffset + 8;
			}
			else if (RECOIL_IsStringAt(content, contentOffset, "DBOD")) {
				if (chunkEndOffset + 8 < contentLength && RECOIL_IsStringAt(content, chunkEndOffset, "DBOD"))
					return FALSE;
				if (rle.components <= 0 || !RECOIL_SetScaledSize(self, width, height, resolution))
					return FALSE;
				rle.base.base.base.base.contentOffset = contentOffset + 8;
				rle.base.base.base.base.contentLength = chunkEndOffset;
				{
					int y;
					for (y = 0; y < height; y++) {
						if (compression == 5) {
							if (tvdcOffset < 0 || !DeepStream_ReadDeltaLine(&rle, width, tvdcOffset))
								return FALSE;
						}
						{
							int x;
							for (x = 0; x < width; x++) {
								int rgb;
								switch (compression) {
								case 0:
									rgb = (&rle)->base.base.vtbl->readValue(&(&rle)->base.base);
									break;
								case 1:
									rgb = RleStream_ReadRle(&rle.base.base);
									break;
								case 5:
									rgb = rle.line[x];
									break;
								default:
									return FALSE;
								}
								if (rgb < 0)
									return FALSE;
								RECOIL_SetScaledPixel(self, x, y, rgb);
							}
						}
					}
				}
				return TRUE;
			}
			contentOffset = (chunkEndOffset + 1) & ~1;
		}
	}
	return FALSE;
}

static cibool RECOIL_DecodeDel(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[96000];
	return CaStream_UnpackDel(content, contentLength, unpacked, 2) && RECOIL_DecodeFuckpaint(self, unpacked, 77824);
}

static cibool RECOIL_DecodeDg1(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 65032 || content[0] != 68 || content[1] != 71 || content[2] != 85 || content[3] != 1 || content[4] != 1 || content[5] != 64 || content[6] != 0 || content[7] != 200)
		return FALSE;
	RECOIL_DecodeFalconPalette(self, content, 1032, 8, 320, 200);
	return TRUE;
}

static cibool RECOIL_DecodeDit(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if (contentLength != 3845)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X2);
	RECOIL_SetPF0123Bak(self, content, 3840);
	RECOIL_DecodeAtari8Gr7(self, content, 0, frame, 0, 96);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeDlm(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char characters[176];
	unsigned char frame[11264];
	if (contentLength != 256)
		return FALSE;
	{
		int y;
		for (y = 0; y < 16; y++)
			{
				int x;
				for (x = 0; x < 11; x++)
					characters[y * 11 + x] = RECOIL_ToAtari8Char(content[y * 16 + 5 + x]);
			}
	}
	RECOIL_SetSize(self, 88, 128, RECOILResolution_XE1X1);
	RECOIL_DecodeAtari8Gr0(self, characters, 11, CiBinaryResource_atari8_fnt, 0, frame);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeDol(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 10241:
	case 10242:
	case 10050:
		break;
	default:
		return FALSE;
	}
	return RECOIL_DecodeC64Multicolor(self, 320, content, 2050, 1026, 2, content[2026]);
}

static cibool RECOIL_DecodeDoo(RECOIL *self, unsigned char const *content, int contentLength)
{
	RECOIL_SetSize(self, 640, 400, RECOILResolution_ST1X1);
	return RECOIL_DecodeBlackAndWhite(self, content, 0, contentLength, FALSE, 16777215);
}

static cibool RECOIL_DecodeDph(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char *unpacked = (unsigned char *) malloc(320000 * sizeof(unsigned char ));
	if (!CaStream_UnpackDel(content, contentLength, unpacked, 10)) {
		free(unpacked);
		return FALSE;
	}
	RECOIL_SetFalconPalette(self, unpacked, 0);
	RECOIL_SetSize(self, 640, 480, RECOILResolution_FALCON1X1);
	RECOIL_DecodeBitplanes(self, unpacked, 1024, 320, 8, 0, 320, 240);
	RECOIL_DecodeBitplanes(self, unpacked, 77824, 320, 8, 320, 320, 240);
	RECOIL_DecodeBitplanes(self, unpacked, 154624, 320, 8, 153600, 320, 240);
	RECOIL_DecodeBitplanes(self, unpacked, 231424, 320, 8, 153920, 320, 240);
	free(unpacked);
	return TRUE;
}

static cibool RECOIL_DecodeDrg(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 6400 && RECOIL_DecodeGr8(self, content, contentLength);
}

static cibool RECOIL_DecodeDrl(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[18242];
	int shift;
	content = DrpStream_UnpackFile(content, contentLength, "DRAZLACE! 1.0", unpacked, 18242);
	if (content == NULL)
		return FALSE;
	shift = content[10052];
	if (shift > 1)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, shift == 0 ? RECOILResolution_C642X1 : RECOILResolution_C641X1);
	RECOIL_DecodeC64MulticolorFrame(self, content, 2050, 1026, 2, content[10050], 0);
	self->leftSkip = -shift;
	RECOIL_DecodeC64MulticolorFrame(self, content, 10242, 1026, 2, content[10050], 64000);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodeDrz(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[10051];
	content = DrpStream_UnpackFile(content, contentLength, "DRAZPAINT 1.4", unpacked, 10051);
	return content != NULL && RECOIL_DecodeC64Multicolor(self, 320, content, 2050, 1026, 2, content[10050]);
}

static cibool RECOIL_DecodeDu2(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 113576 && contentLength != 113600)
		return FALSE;
	RECOIL_DecodeStMedium(self, content, 8, content, 0, 832, 273, 1);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodeDuo(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 113600 && RECOIL_DecodeStLowBlend(self, content, 32, content, 0, 416, 273);
}

static cibool RECOIL_DecodeEci(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 32770)
		return FALSE;
	RECOIL_SetSize(self, 296, 200, RECOILResolution_C641X1);
	RECOIL_DecodeC64HiresFrame(self, content, 26, 8197, 0);
	RECOIL_DecodeC64HiresFrame(self, content, 16410, 24581, 59200);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodeEcp(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[32770];
	DrpStream rle;
	if (contentLength < 6)
		return FALSE;
	DrpStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 3;
	rle.base.base.base.contentLength = contentLength;
	rle.escape = content[2];
	return RleStream_Unpack(&rle.base, unpacked, 2, 1, 32770) && RECOIL_DecodeEci(self, unpacked, 32770);
}

static cibool RECOIL_DecodeEnvision(RECOIL *self, unsigned char const *content, int contentLength)
{
	int columns;
	int rows;
	int fontOffset;
	int fontId2Offset[256];
	if (contentLength < 1505)
		return FALSE;
	columns = content[1] + 1;
	rows = content[2] + 1;
	if (rows > 204)
		return FALSE;
	fontOffset = 8 + columns * rows + 463;
	if (contentLength < fontOffset || contentLength != fontOffset + content[fontOffset - 1] * 1033)
		return FALSE;
	memset(fontId2Offset, 0, sizeof(fontId2Offset));
	for (; fontOffset < contentLength; fontOffset += 1033)
		fontId2Offset[content[fontOffset]] = fontOffset + 1 + 8;
	RECOIL_SetPF0123Bak(self, content, 3);
	return RECOIL_DecodeEnvisionCommon(self, content, content[0] & 127, columns, rows, 8, fontId2Offset);
}

static cibool RECOIL_DecodeEnvisionCommon(RECOIL *self, unsigned char const *content, int mode, int columns, int rows, int charactersOffset, int const *fontId2Offset)
{
	int charWidth;
	int charHeight;
	RECOILResolution resolution;
	unsigned char *frame;
	switch (mode) {
	case 2:
		charWidth = 8;
		charHeight = 8;
		resolution = RECOILResolution_XE1X1;
		break;
	case 3:
		charWidth = 8;
		charHeight = 10;
		resolution = RECOILResolution_XE1X1;
		break;
	case 4:
		charWidth = 8;
		charHeight = 8;
		resolution = RECOILResolution_XE2X1;
		break;
	case 5:
		charWidth = 8;
		charHeight = 16;
		resolution = RECOILResolution_XE2X2;
		break;
	case 6:
		charWidth = 16;
		charHeight = 8;
		resolution = RECOILResolution_XE2X1;
		break;
	case 7:
		charWidth = 16;
		charHeight = 16;
		resolution = RECOILResolution_XE2X2;
		break;
	default:
		return FALSE;
	}
	if (!RECOIL_SetSize(self, columns * charWidth, rows * charHeight, resolution))
		return FALSE;
	frame = (unsigned char *) malloc(self->width * self->height * sizeof(unsigned char ));
	{
		int row;
		for (row = 0; row < rows; row++) {
			int fontOffset;
			int frameOffset;
			if (fontId2Offset != NULL) {
				fontOffset = fontId2Offset[content[8 + columns * rows + 256 + row]];
				if (fontOffset == 0) {
					free(frame);
					return FALSE;
				}
			}
			else {
				fontOffset = 10 + columns * rows;
			}
			frameOffset = row * charHeight * self->width;
			switch (mode >> 1) {
			case 1:
				RECOIL_DecodeAtari8Gr0Line(self, content, charactersOffset, content, fontOffset, frame, frameOffset, charHeight);
				break;
			case 2:
				RECOIL_DecodeAtari8Gr12Line(self, content, charactersOffset, content, fontOffset, frame, frameOffset, mode & 1);
				break;
			case 3:
				RECOIL_DecodeAtari8Gr1Line(self, content, charactersOffset, content, fontOffset, frame, frameOffset, mode & 1);
				break;
			}
			charactersOffset += columns;
		}
	}
	RECOIL_ApplyAtari8Palette(self, frame);
	free(frame);
	return TRUE;
}

static cibool RECOIL_DecodeEnvisionPC(RECOIL *self, unsigned char const *content, int contentLength)
{
	int columns;
	int rows;
	int contentOffset;
	if (contentLength < 1035 || content[2] >= 128)
		return FALSE;
	columns = content[1] | (content[2] << 8);
	rows = content[3] | (content[4] << 8);
	contentOffset = 10 + columns * rows + 1024;
	while (contentOffset < contentLength) {
		switch (content[contentOffset++]) {
		case 0:
			break;
		case 1:
			if (contentOffset + 6 >= contentLength || content[contentOffset + 1] >= 5 || content[contentOffset + 3] >= 5 || content[contentOffset + 5] >= 5)
				return FALSE;
			contentOffset += (content[contentOffset] + (content[contentOffset + 1] << 8)) * (content[contentOffset + 2] + (content[contentOffset + 3] << 8)) * (content[contentOffset + 4] + (content[contentOffset + 5] << 8) + 1);
			break;
		case 2:
			contentOffset += columns * rows;
			break;
		case 3:
			contentOffset += 1027;
			break;
		default:
			return FALSE;
		}
	}
	if (contentOffset > contentLength)
		return FALSE;
	RECOIL_SetBakPF0123(self, content, 5);
	return RECOIL_DecodeEnvisionCommon(self, content, content[0], columns, rows, 10, NULL);
}

static cibool RECOIL_DecodeEpa(RECOIL *self, unsigned char const *content, int contentLength)
{
	int columns;
	int rows;
	int width;
	int height;
	int bitmapOffset;
	if (contentLength < 17)
		return FALSE;
	if (RECOIL_IsStringAt(content, 0, "AWBM"))
		return RECOIL_DecodeAwbm(self, content, contentLength);
	columns = content[0];
	rows = content[1];
	if (columns > 80 || rows > 25 || contentLength != 2 + columns * rows * 15 + 70)
		return FALSE;
	width = columns * 8;
	height = rows * 14;
	RECOIL_SetSize(self, width, height, RECOILResolution_PC1X1);
	bitmapOffset = 2 + columns * rows;
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int x;
				for (x = 0; x < width; x++) {
					int ch = y / 14 * columns + (x >> 3);
					int attribute = content[2 + ch];
					int b = (content[bitmapOffset + ch * 14 + y % 14] >> (~x & 7)) & 1;
					static const int palette[16] = { 0, 170, 43520, 43690, 11141120, 11141290, 11162880, 11184810, 5592405, 5592575, 5635925, 5636095, 16733525, 16733695, 16777045, 16777215 };
					self->pixels[y * width + x] = palette[b == 0 ? attribute >> 4 : attribute & 15];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeEsm(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	int pixelsLength;
	if (contentLength < 812 || content[0] != 84 || content[1] != 77 || content[2] != 83 || content[3] != 0 || content[4] != 3 || content[5] != 44 || content[10] != 0)
		return FALSE;
	width = (content[6] << 8) | content[7];
	height = (content[8] << 8) | content[9];
	if (!RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1))
		return FALSE;
	pixelsLength = width * height;
	switch (content[11]) {
	case 1:
		return RECOIL_DecodeBlackAndWhite(self, content, 812, contentLength, FALSE, 16777215);
	case 8:
		if (contentLength != 812 + pixelsLength)
			return FALSE;
		{
			int i;
			for (i = 0; i < 256; i++)
				self->contentPalette[i] = (content[36 + i] << 16) | (content[292 + i] << 8) | content[548 + i];
		}
		{
			int i;
			for (i = 0; i < pixelsLength; i++)
				self->pixels[i] = self->contentPalette[content[812 + i]];
		}
		return TRUE;
	case 24:
		if (contentLength != 812 + pixelsLength * 3)
			return FALSE;
		RECOIL_DecodeR8G8B8Colors(content, 812, pixelsLength, self->pixels);
		return TRUE;
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeEza(RECOIL *self, unsigned char const *content, int contentLength)
{
	PackBitsStream rle;
	unsigned char unpacked[32000];
	if (contentLength < 44 || content[0] != 69 || content[1] != 90 || content[2] != 0 || content[3] != 200)
		return FALSE;
	PackBitsStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 44;
	rle.base.base.base.contentLength = contentLength;
	return PackBitsStream_UnpackBitplaneLines(&rle, unpacked, 320, 200, 4, TRUE, FALSE) && RECOIL_DecodeStLow(self, unpacked, 0, content, 4, 320, 200);
}

static cibool RECOIL_DecodeFalconFun(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	int bitplanes;
	if (contentLength < 14 || content[0] != 0 || content[1] != 10 || content[2] != 207 || content[3] != 226 || content[8] != 0)
		return FALSE;
	width = (content[4] << 8) | content[5];
	if ((width & 15) != 0)
		return FALSE;
	height = (content[6] << 8) | content[7];
	bitplanes = content[9];
	switch (bitplanes) {
		int bytesPerLine;
		int paletteOffset;
		int colors;
	case 1:
	case 2:
	case 4:
	case 8:
		bytesPerLine = (width >> 3) * bitplanes;
		paletteOffset = 25 + height * bytesPerLine;
		colors = 1 << bitplanes;
		if (contentLength != paletteOffset + colors * 6 || !RECOIL_SetSizeStOrFalcon(self, width, height, bitplanes, FALSE))
			return FALSE;
		if (bitplanes == 1)
			RECOIL_SetDefaultStPalette(self, 1);
		else
			RECOIL_SetStVdiPalette(self, content, paletteOffset, colors, bitplanes);
		RECOIL_DecodeScaledBitplanes(self, content, 13, width, height, bitplanes, FALSE, NULL);
		return TRUE;
	case 16:
		return contentLength >= 13 + width * height * 2 && RECOIL_DecodeFalconTrueColor(self, content, 13, width, height, RECOILResolution_FALCON1X1);
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeFalconGrayscale(RECOIL *self, unsigned char const *content, int contentOffset, int contentLength, int width, int height)
{
	int pixelsLength = width * height;
	if (contentLength != contentOffset + pixelsLength || !RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1))
		return FALSE;
	{
		int i;
		for (i = 0; i < pixelsLength; i++)
			self->pixels[i] = content[contentOffset + i] * 65793;
	}
	return TRUE;
}

static cibool RECOIL_DecodeFalconHir(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	int pixelsLength;
	if (contentLength < 11 || content[0] != 15 || content[1] != 15 || content[2] != 0 || content[3] != 1 || content[8] != 0 || content[9] != 1)
		return FALSE;
	width = (content[4] << 8) | content[5];
	height = (content[6] << 8) | content[7];
	pixelsLength = width * height;
	if (contentLength != 10 + pixelsLength || !RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1))
		return FALSE;
	{
		int i;
		for (i = 0; i < pixelsLength; i++) {
			int b = content[10 + i];
			if (b >= 128)
				return FALSE;
			self->pixels[i] = b * 131586;
		}
	}
	return TRUE;
}

static void RECOIL_DecodeFalconPalette(RECOIL *self, unsigned char const *content, int bitplanesOffset, int paletteOffset, int width, int height)
{
	RECOIL_SetFalconPalette(self, content, paletteOffset);
	RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1);
	RECOIL_DecodeBitplanes(self, content, bitplanesOffset, width, 8, 0, width, height);
}

static cibool RECOIL_DecodeFalconPix(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset;
	int width;
	int bitplanes;
	int height;
	int pixelsLength;
	if (contentLength < 15 || !RECOIL_IsStringAt(content, 0, "PIXT") || content[4] != 0)
		return FALSE;
	switch (content[5]) {
	case 1:
		contentOffset = 14;
		break;
	case 2:
		contentOffset = 16;
		break;
	default:
		return FALSE;
	}
	width = (content[8] << 8) | content[9];
	if ((width & 15) != 0)
		return FALSE;
	bitplanes = content[7];
	height = (content[10] << 8) | content[11];
	switch (bitplanes) {
		int bitmapOffset;
	case 1:
		return content[6] == 1 && RECOIL_SetSizeStOrFalcon(self, width, height, 1, FALSE) && RECOIL_DecodeBlackAndWhite(self, content, contentOffset, contentLength, TRUE, 16777215);
	case 2:
	case 4:
		bitmapOffset = contentOffset + (3 << bitplanes);
		if (content[6] != 1 || contentLength != bitmapOffset + (width >> 3) * bitplanes * height || !RECOIL_SetSizeStOrFalcon(self, width, height, bitplanes, FALSE))
			return FALSE;
		RECOIL_DecodeR8G8B8Colors(content, contentOffset, 1 << bitplanes, self->contentPalette);
		RECOIL_DecodeScaledBitplanes(self, content, bitmapOffset, width, height, bitplanes, FALSE, NULL);
		return TRUE;
	case 8:
		if (content[6] != 0 || contentLength != contentOffset + 768 + width * height || !RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1))
			return FALSE;
		RECOIL_DecodeR8G8B8Colors(content, contentOffset, 256, self->contentPalette);
		RECOIL_DecodeBytes(self, content, contentOffset + 768);
		return TRUE;
	case 16:
		return content[6] == 1 && contentLength == contentOffset + width * height * 2 && RECOIL_DecodeFalconTrueColor(self, content, contentOffset, width, height, RECOILResolution_FALCON1X1);
	case 24:
		pixelsLength = width * height;
		if (content[6] != 1 || contentLength != contentOffset + pixelsLength * 3 || !RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1))
			return FALSE;
		RECOIL_DecodeR8G8B8Colors(content, contentOffset, pixelsLength, self->pixels);
		return TRUE;
	case 32:
		pixelsLength = width * height;
		if (contentLength != contentOffset + (pixelsLength << 2) || !RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1))
			return FALSE;
		RECOIL_DecodeR8G8G8X8Colors(self, content, contentOffset + 1, pixelsLength);
		return TRUE;
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeFalconTrueColor(RECOIL *self, unsigned char const *content, int contentOffset, int width, int height, RECOILResolution resolution)
{
	if (!RECOIL_SetScaledSize(self, width, height, resolution))
		return FALSE;
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int x;
				for (x = 0; x < width; x++) {
					RECOIL_SetScaledPixel(self, x, y, RECOIL_GetFalconTrueColor(content, contentOffset));
					contentOffset += 2;
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeFalconTrueColorVariable(RECOIL *self, unsigned char const *content, int contentLength, int widthOffset, int dataOffset)
{
	int width = (content[widthOffset] << 8) | content[widthOffset + 1];
	int height = (content[widthOffset + 2] << 8) | content[widthOffset + 3];
	return dataOffset + width * height * 2 == contentLength && RECOIL_DecodeFalconTrueColor(self, content, dataOffset, width, height, RECOILResolution_FALCON1X1);
}

static cibool RECOIL_DecodeFfli(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 26115 || content[2] != 102)
		return FALSE;
	RECOIL_DecodeC64Multicolor(self, 296, content, 9499, 1286, 262, -3);
	RECOIL_DecodeC64MulticolorFrame(self, content, 9499, 17670, 262, -25859, 59200);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodeFge(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[40960];
	if (contentLength != 1286)
		return FALSE;
	RECOIL_SetSize(self, 256, 160, RECOILResolution_XE4X4);
	self->gtiaColors[8] = 0;
	{
		int offset;
		for (offset = 0; offset < 1024; offset += 256)
			RECOIL_DecodeAtari8Gr9(self, content, 6, 32, frame, offset, 1024, 256, 40);
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeFli(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 17218:
	case 17409:
	case 17410:
		break;
	default:
		return FALSE;
	}
	RECOIL_DecodeC64Multicolor(self, 296, content, 9242, 1029, 5, 0);
	return TRUE;
}

static cibool RECOIL_DecodeFtc(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 184320 && RECOIL_DecodeFalconTrueColor(self, content, 0, 384, 240, RECOILResolution_FALCON1X1);
}

static cibool RECOIL_DecodeFuckpaint(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 65024:
		RECOIL_DecodeFalconPalette(self, content, 1024, 0, 320, 200);
		return TRUE;
	case 77824:
		RECOIL_DecodeFalconPalette(self, content, 1024, 0, 320, 240);
		return TRUE;
	case 308224:
		RECOIL_DecodeFalconPalette(self, content, 1024, 0, 640, 480);
		return TRUE;
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeFunUnpacked(RECOIL *self, unsigned char const *content)
{
	RECOIL_SetSize(self, 296, 200, RECOILResolution_C641X1);
	RECOIL_DecodeC64MulticolorFrame(self, content, 8234, 21, 16405, 0, 0);
	self->leftSkip = -1;
	RECOIL_DecodeC64MulticolorFrame(self, content, 25618, 17405, 16405, 0, 59200);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodeFwa(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	int dlOffset;
	int dliOffset;
	if (contentLength < 7960 || content[0] != 254 || content[1] != 254 || content[6] != 112 || content[7] != 112 || content[8] != 112 || content[11] != 80 || content[115] != 96 || content[205] != 65 || 7960 + content[7958] + (content[7959] << 8) != contentLength)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X1);
	RECOIL_SetBakPF012(self, content, 2, 1);
	dlOffset = 9;
	dliOffset = 7960;
	{
		int y;
		for (y = 0; y < 192; y++) {
			int dlInstr;
			RECOIL_DecodeAtari8Gr15(self, content, 262 + 40 * y + (y >= 102 ? 16 : 0), 40, frame, y * 320, 320, 1);
			dlInstr = content[dlOffset];
			if (dlOffset == 9 || dlOffset == 113) {
				if ((dlInstr & 127) != 78 || content[dlOffset + 1] != 0)
					return FALSE;
				dlOffset += 3;
			}
			else {
				if ((dlInstr & 127) != 14)
					return FALSE;
				dlOffset++;
			}
			if (dlInstr >= 128) {
				unsigned char a;
				if (dliOffset + 14 > contentLength || content[dliOffset] != 72 || content[dliOffset + 1] != 138 || content[dliOffset + 2] != 72 || content[dliOffset + 3] != 169 || content[dliOffset + 5] != 141 || content[dliOffset + 6] != 10 || content[dliOffset + 7] != 212)
					return FALSE;
				a = content[dliOffset + 4];
				dliOffset += 8;
				while (content[dliOffset] != 32) {
					switch (content[dliOffset]) {
						int lo;
					case 169:
						a = content[dliOffset + 1];
						dliOffset += 2;
						break;
					case 141:
						if (content[dliOffset + 2] != 208)
							return FALSE;
						lo = content[dliOffset + 1];
						switch (lo) {
						case 22:
						case 23:
						case 24:
						case 26:
							self->gtiaColors[lo - 18] = a & 254;
							break;
						default:
							return FALSE;
						}
						dliOffset += 3;
						break;
					default:
						return FALSE;
					}
					if (dliOffset + 3 > contentLength)
						return FALSE;
				}
				if (content[dliOffset + 1] != 202 || content[dliOffset + 2] != 6)
					return FALSE;
				dliOffset += 3;
			}
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeG(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 514 || content[0] != 66 || content[1] != 0)
		return FALSE;
	RECOIL_SetSize(self, 256, 16, RECOILResolution_C641X1);
	RECOIL_DecodeBlackAndWhiteFont(self, content, 2, 514, 8);
	return TRUE;
}

static cibool RECOIL_DecodeG09(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[122880];
	switch (contentLength) {
	case 7680:
		return RECOIL_DecodeGr9(self, content, contentLength);
	case 15360:
		break;
	default:
		return FALSE;
	}
	RECOIL_SetSize(self, 640, 192, RECOILResolution_XE4X1);
	self->gtiaColors[8] = 0;
	RECOIL_DecodeAtari8Gr9(self, content, 0, 40, frame, 0, 640, 320, 192);
	RECOIL_DecodeAtari8Gr9(self, content, 7680, 40, frame, 320, 640, 320, 192);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeG10(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset;
	unsigned char frame[76800];
	if (!RECOIL_SetAtari8RawSize(self, content, contentLength, RECOILResolution_XE4X1))
		return FALSE;
	contentOffset = RECOIL_GetAtari8ExecutableOffset(content, contentLength);
	if ((contentLength - contentOffset) % 40 != 9)
		return FALSE;
	self->leftSkip = 2;
	RECOIL_SetGtiaColors(self, content, contentLength - 9);
	RECOIL_DecodeAtari8Gr10(self, content, contentOffset, frame, 0, 320, self->height);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeG11(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset;
	unsigned char frame[76800];
	if (!RECOIL_SetAtari8RawSize(self, content, contentLength, RECOILResolution_XE4X1))
		return FALSE;
	self->gtiaColors[8] = 6;
	contentOffset = RECOIL_GetAtari8ExecutableOffset(content, contentLength);
	RECOIL_DecodeAtari8Gr11(self, content, contentOffset, frame, 0, 320, self->height);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeG2f(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength < 11)
		return FALSE;
	if (RECOIL_IsStringAt(content, 0, "G2FZLIB")) {
		unsigned char *unpacked = (unsigned char *) malloc(327078 * sizeof(unsigned char ));
		InflateStream stream;
		cibool ok;
		stream.base.content = content;
		stream.base.contentOffset = 7;
		stream.base.contentLength = contentLength;
		contentLength = InflateStream_Uncompress(&stream, unpacked, 327078);
		ok = RECOIL_DecodeG2fUnpacked(self, unpacked, contentLength);
		free(unpacked);
		return ok;
	}
	return RECOIL_DecodeG2fUnpacked(self, content, contentLength);
}

static cibool RECOIL_DecodeG2fUnpacked(RECOIL *self, unsigned char const *content, int contentLength)
{
	int columns;
	int fontsOffset;
	int fontNumberOffset;
	cibool charMode;
	int inverse2Offset;
	unsigned char frame[80640];
	RECOILResolution resolution;
	G2fRenderer gtia;
	if (contentLength < 155711)
		return FALSE;
	columns = content[0] & 127;
	switch (columns) {
	case 32:
	case 40:
	case 48:
		break;
	default:
		return FALSE;
	}
	fontsOffset = 3 + 30 * columns;
	fontNumberOffset = fontsOffset + (((content[2] & 127) + 1) << 10);
	if (contentLength < fontNumberOffset + 153724)
		return FALSE;
	inverse2Offset = -1;
	switch (content[fontNumberOffset + 147679] & 127) {
	case 1:
		if (RECOIL_G2fHasRaster(content, fontNumberOffset + 147934))
			return FALSE;
		charMode = TRUE;
		break;
	case 2:
		charMode = TRUE;
		break;
	case 3:
		if (RECOIL_G2fHasRaster(content, fontNumberOffset + 147934))
			return FALSE;
		charMode = FALSE;
		break;
	case 66:
		charMode = TRUE;
		inverse2Offset = fontNumberOffset + 293475;
		if (contentLength < inverse2Offset + 30 * columns)
			return FALSE;
		break;
	default:
		return FALSE;
	}
	resolution = RECOILResolution_XE4X1;
	G2fRenderer_Construct(&gtia, NULL);
	gtia.base.content = content;
	gtia.base.playfieldColumns = columns;
	gtia.inverse2Offset = inverse2Offset;
	{
		int y;
		for (y = 0; y < 240; y++) {
			int row = y >> 3;
			int spriteOffset;
			int prior;
			static const unsigned char priors[5] = { 4, 2, 1, 8, 0 };
			AnticMode anticMode;
			int colorsOffset;
			int missileGraphics;
			gtia.fontOffset = fontsOffset + ((content[fontNumberOffset + row] & 127) << 10);
			if (gtia.fontOffset >= fontNumberOffset)
				return FALSE;
			spriteOffset = fontNumberOffset + 2334 + (y << 1);
			prior = (content[spriteOffset + 1] >> 4) & 7;
			if (prior >= 5)
				return FALSE;
			prior = priors[prior] | (content[spriteOffset + 1025] & 48);
			switch (content[fontNumberOffset + 153694 + row]) {
				static const unsigned char gtiaModes[8] = { 64, 64, 64, 64, 64, 128, 192, 64 };
			case 1:
				resolution = RECOILResolution_XE1X1;
				anticMode = AnticMode_HI_RES;
				break;
			case 2:
				if (resolution == RECOILResolution_XE4X1)
					resolution = RECOILResolution_XE2X1;
				anticMode = charMode ? AnticMode_FIVE_COLOR : AnticMode_FOUR_COLOR;
				break;
			case 4:
				prior |= gtiaModes[content[1] & 7];
				anticMode = AnticMode_HI_RES;
				break;
			case 255:
				anticMode = AnticMode_BLANK;
				break;
			default:
				return FALSE;
			}
			colorsOffset = fontNumberOffset + 30 + y;
			GtiaRenderer_SetG2fColors(&gtia.base, colorsOffset, 256, 9, prior);
			missileGraphics = 0;
			{
				int i;
				for (i = 0; i < 4; i++) {
					if (!G2fRenderer_SetSprite(gtia.base.playerHpos, gtia.base.playerSize, i, content, spriteOffset) || !G2fRenderer_SetSprite(gtia.base.missileHpos, gtia.base.missileSize, i, content, spriteOffset + 512))
						return FALSE;
					gtia.base.playerGraphics[i] = content[colorsOffset + 6400 + (i << 9)];
					missileGraphics |= content[colorsOffset + 6656 + (i << 9)] >> 6 << (i << 1);
				}
			}
			gtia.base.missileGraphics = missileGraphics;
			gtia.base.prior = prior;
			GtiaRenderer_StartLine(&gtia.base, 44);
			GtiaRenderer_DrawSpan(&gtia.base, y, 44, 212, anticMode, frame, 336);
		}
	}
	RECOIL_SetSize(self, 336, 240, resolution);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeGad(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if (contentLength != 4325)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X2);
	RECOIL_SetPF0123Bak(self, content, 0);
	{
		int y;
		for (y = 0; y < 96; y++) {
			RECOIL_DecodeAtari8Gr7(self, content, 5 + y * 40, frame, y * 640, 1);
			if (content[3845 + y] < 128) {
				{
					int i;
					for (i = 0; i < 4; i++)
						self->gtiaColors[i == 3 ? 8 : 4 + i] = content[3941 + i * 96 + y] & 254;
				}
			}
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeGdosFnt(RECOIL *self, unsigned char const *content, int contentLength)
{
	EndianStream stream;
	int firstCharacter;
	int lastCharacter;
	int characterOffset;
	int bitmapOffset;
	int bytesPerLine;
	int height;
	int characterEndOffset;
	int width;
	int leftX;
	int nextX;
	int row;
	if (contentLength < 88 || content[62] != 85 || content[63] != 85)
		return FALSE;
	if (content[3] == 0) {
		if (content[2] == 0)
			return FALSE;
		stream.bigEndian = FALSE;
	}
	else if (content[2] == 0)
		stream.bigEndian = TRUE;
	else
		return FALSE;
	stream.base.content = content;
	stream.base.contentLength = contentLength;
	stream.base.contentOffset = 36;
	firstCharacter = EndianStream_ReadWord(&stream);
	lastCharacter = EndianStream_ReadWord(&stream);
	if (firstCharacter > lastCharacter)
		return FALSE;
	stream.base.contentOffset = 72;
	characterOffset = EndianStream_ReadInt(&stream);
	if (characterOffset <= 0 || characterOffset >= contentLength)
		return FALSE;
	bitmapOffset = EndianStream_ReadInt(&stream);
	if (bitmapOffset < 0 || bitmapOffset >= contentLength)
		return FALSE;
	bytesPerLine = EndianStream_ReadWord(&stream);
	if (bytesPerLine == 0)
		return FALSE;
	height = EndianStream_ReadWord(&stream);
	if (height == 0 || bitmapOffset + height * bytesPerLine > contentLength)
		return FALSE;
	characterEndOffset = characterOffset + ((lastCharacter - firstCharacter + 2) << 1);
	if (characterEndOffset > bitmapOffset)
		return FALSE;
	width = height << 4;
	if (width > 2048)
		width = 2048;
	stream.base.contentOffset = characterOffset;
	stream.base.contentLength = characterEndOffset;
	leftX = 0;
	nextX = 0;
	for (row = 0; nextX >= 0 && (row + height) * width <= 2854278; row += height) {
		int rightX;
		do {
			rightX = nextX;
			nextX = EndianStream_ReadWord(&stream);
			if (nextX < rightX) {
				if (nextX < 0)
					break;
				return FALSE;
			}
			if (nextX > bytesPerLine << 3) {
				nextX = -1;
				break;
			}
		}
		while (nextX - leftX <= width);
		{
			int y;
			for (y = 0; y < height; y++) {
				{
					int x;
					for (x = 0; x < width; x++) {
						int fontX = leftX + x;
						int c;
						if (fontX < rightX) {
							int offset = bitmapOffset + y * bytesPerLine + (fontX >> 3);
							c = ((content[offset] >> (~fontX & 7)) & 1) == 0 ? 16777215 : 0;
						}
						else
							c = 16777215;
						self->pixels[(row + y) * width + x] = c;
					}
				}
			}
		}
		leftX = rightX;
	}
	return RECOIL_SetSize(self, width, row, RECOILResolution_ST1X1);
}

static cibool RECOIL_DecodeGed(RECOIL *self, unsigned char const *content, int contentLength)
{
	int cycle;
	GedRenderer gtia;
	int prior;
	unsigned char frame[64000];
	if (contentLength != 11302 || content[0] != 255 || content[1] != 255 || content[2] != 48 || content[3] != 83 || content[4] != 79 || content[5] != 127)
		return FALSE;
	cycle = content[3300];
	if (cycle > 7)
		return FALSE;
	GedRenderer_Construct(&gtia, NULL);
	GtiaRenderer_SetSpriteSizes(gtia.base.missileSize, content[3291]);
	gtia.base.colors[7] = content[3293] & 254;
	gtia.base.colors[8] = content[3294] & 254;
	prior = content[3292];
	gtia.base.prior = prior;
	{
		int i;
		for (i = 0; i < 4; i++) {
			GtiaRenderer_SetPlayerSize(&gtia.base, i, content[3290] >> ((3 - i) << 1));
			gtia.base.playerHpos[i] = (unsigned char) (48 + content[3295 + i]);
			gtia.base.missileHpos[i] = (unsigned char) ((prior & 16) == 0 ? gtia.base.playerHpos[i] + (gtia.base.playerSize[i] << 3) : i == 0 ? 48 + content[3299] : gtia.base.missileHpos[i - 1] + (gtia.base.missileSize[i - 1] << 1));
			gtia.base.colors[i] = content[3286 + i] & 254;
		}
	}
	gtia.base.content = content;
	gtia.base.playfieldColumns = 40;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_XE2X1);
	{
		int y;
		for (y = 0; y < 200; y++) {
			int hpos;
			GtiaRenderer_ProcessSpriteDma(&gtia.base, content, 2034 + y);
			GtiaRenderer_Poke(&gtia.base, content[206 + y] & 31, content[6 + y]);
			gtia.base.colors[4] = content[406 + y] & 254;
			gtia.base.colors[5] = content[606 + y] & 254;
			gtia.base.colors[6] = content[806 + y] & 254;
			GtiaRenderer_StartLine(&gtia.base, 48);
			hpos = GtiaRenderer_DrawSpan(&gtia.base, y, 48, 63 + (cycle << 3), AnticMode_FOUR_COLOR, frame, 320);
			gtia.base.colors[4] = content[1006 + y] & 254;
			hpos = GtiaRenderer_DrawSpan(&gtia.base, y, hpos, cycle < 4 ? hpos + 32 : 107 + (cycle << 2), AnticMode_FOUR_COLOR, frame, 320);
			gtia.base.colors[5] = content[1206 + y] & 254;
			hpos = GtiaRenderer_DrawSpan(&gtia.base, y, hpos, 123 + (cycle << 2), AnticMode_FOUR_COLOR, frame, 320);
			gtia.base.colors[6] = content[1406 + y] & 254;
			hpos = GtiaRenderer_DrawSpan(&gtia.base, y, hpos, hpos + 24, AnticMode_FOUR_COLOR, frame, 320);
			gtia.base.colors[4] = content[1606 + y] & 254;
			hpos = GtiaRenderer_DrawSpan(&gtia.base, y, hpos, hpos + 24, AnticMode_FOUR_COLOR, frame, 320);
			gtia.base.colors[5] = content[1806 + y] & 254;
			hpos = GtiaRenderer_DrawSpan(&gtia.base, y, hpos, 208, AnticMode_FOUR_COLOR, frame, 320);
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeGfaArtist(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 32032:
		return RECOIL_DecodeStLow(self, content, 32, content, 0, 320, 200);
	case 34360:
		return RECOIL_DecodeStLow(self, content, 4, content, 32004, 320, 200);
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeGfb(RECOIL *self, unsigned char const *content, int contentLength)
{
	int bitplanes;
	int width;
	int height;
	int bitmapLength;
	if (contentLength < 20 || !RECOIL_IsStringAt(content, 0, "GF25"))
		return FALSE;
	switch (RECOIL_Get32BigEndian(content, 4)) {
	case 2:
		bitplanes = 1;
		break;
	case 4:
		bitplanes = 2;
		break;
	case 16:
		bitplanes = 4;
		break;
	case 256:
		bitplanes = 8;
		break;
	default:
		return FALSE;
	}
	width = RECOIL_Get32BigEndian(content, 8);
	if (width <= 0)
		return FALSE;
	height = RECOIL_Get32BigEndian(content, 12);
	if (height <= 0)
		return FALSE;
	bitmapLength = RECOIL_Get32BigEndian(content, 16);
	if (bitmapLength <= 0)
		return FALSE;
	if (1556 + bitmapLength != contentLength || bitmapLength != ((width + 15) >> 4 << 1) * bitplanes * height || !RECOIL_SetSizeStOrFalcon(self, width, height, bitplanes, FALSE))
		return FALSE;
	RECOIL_SetStVdiPalette(self, content, 20 + bitmapLength, 1 << bitplanes, bitplanes);
	RECOIL_DecodeScaledBitplanes(self, content, 20, width, height, bitplanes, FALSE, NULL);
	return TRUE;
}

static cibool RECOIL_DecodeGg(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[10003];
	C64KoalaStream rle;
	if (contentLength < 2)
		return FALSE;
	C64KoalaStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 2;
	rle.base.base.base.contentLength = contentLength;
	return RleStream_UnpackC64(&rle.base, unpacked, 10003) && RECOIL_DecodeKoa(self, unpacked, 10003);
}

static cibool RECOIL_DecodeGhg(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	unsigned char frame[64000];
	if (contentLength < 4)
		return FALSE;
	width = content[0] | (content[1] << 8);
	height = content[2];
	if (width == 0 || width > 320 || height == 0 || height > 200 || contentLength != 3 + ((width + 7) >> 3) * height)
		return FALSE;
	RECOIL_SetSize(self, width, height, RECOILResolution_XE1X1);
	self->gtiaColors[6] = 12;
	self->gtiaColors[5] = 2;
	RECOIL_DecodeAtari8Gr8(self, content, 3, frame, 0, height);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeGl16(RECOIL *self, const char *filename, unsigned char const *content, int contentLength, RECOILResolution resolution, const char *upperExt, const char *lowerExt)
{
	int width;
	int height;
	int contentStride;
	if (contentLength < 5)
		return FALSE;
	width = content[0] | (content[1] << 8);
	height = content[2] | (content[3] << 8);
	contentStride = (width + 1) >> 1;
	if (contentLength != 4 + contentStride * height || !RECOIL_SetScaledSize(self, width, height, resolution))
		return FALSE;
	RECOIL_SetMsxCompanionPalette(self, filename, upperExt, lowerExt);
	RECOIL_DecodeNibbles(self, content, 4, contentStride);
	return TRUE;
}

static cibool RECOIL_DecodeGl5(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	return RECOIL_DecodeGl16(self, filename, content, contentLength, RECOILResolution_MSX21X1, "PL5", "pl5");
}

static cibool RECOIL_DecodeGl6(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	if (contentLength < 5)
		return FALSE;
	width = content[0] | (content[1] << 8);
	height = content[2] | (content[3] << 8);
	if ((width & 3) != 0 || contentLength != 4 + (width >> 2) * height || !RECOIL_SetSize(self, width, height << 1, RECOILResolution_MSX21X2))
		return FALSE;
	RECOIL_SetMsx6Palette(self, filename);
	return RECOIL_DecodeMsx6(self, content, 4);
}

static cibool RECOIL_DecodeGl7(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	return RECOIL_DecodeGl16(self, filename, content, contentLength, RECOILResolution_MSX21X2, "PL7", "pl7");
}

static cibool RECOIL_DecodeGl8(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	if (contentLength < 5)
		return FALSE;
	width = content[0] | (content[1] << 8);
	height = content[2] | (content[3] << 8);
	if (contentLength != 4 + width * height || !RECOIL_SetSize(self, width, height, RECOILResolution_MSX21X1))
		return FALSE;
	RECOIL_SetSc8Palette(self);
	RECOIL_DecodeBytes(self, content, 4);
	return TRUE;
}

static cibool RECOIL_DecodeGlYjk(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	if (contentLength < 8)
		return FALSE;
	width = content[0] | (content[1] << 8);
	height = content[2] | (content[3] << 8);
	if (contentLength != 4 + width * height || !RECOIL_SetSize(self, width, height, RECOILResolution_MSX2_PLUS1X1))
		return FALSE;
	if (filename != NULL)
		RECOIL_SetMsxCompanionPalette(self, filename, "PLA", "pla");
	RECOIL_DecodeMsxYjkScreen(self, content, 4, filename != NULL);
	return TRUE;
}

static cibool RECOIL_DecodeGod(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength > 6 && RECOIL_DecodeFalconTrueColorVariable(self, content, contentLength, 2, 6);
}

static cibool RECOIL_DecodeGr1(RECOIL *self, unsigned char const *content, int contentLength, int doubleHeight)
{
	unsigned char frame[61440];
	unsigned char const *font;
	if (contentLength != 480 >> doubleHeight)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, doubleHeight == 0 ? RECOILResolution_XE2X1 : RECOILResolution_XE2X2);
	RECOIL_SetXeOsDefaultColors(self);
	font = CiBinaryResource_atari8_fnt;
	{
		int offset;
		for (offset = 0; offset < contentLength; offset += 20)
			RECOIL_DecodeAtari8Gr1Line(self, content, offset, font, 0, frame, offset << (7 + doubleHeight), doubleHeight);
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeGr15Blend(RECOIL *self, unsigned char const *content, int bitmapOffset, int colorsOffset, int height)
{
	unsigned char frame1[64000];
	unsigned char frame2[64000];
	RECOIL_SetSize(self, 320, height, RECOILResolution_XE2X1);
	RECOIL_SetPF012Bak(self, content, colorsOffset);
	RECOIL_DecodeAtari8Gr15(self, content, bitmapOffset, 80, frame1, 0, 640, height >> 1);
	RECOIL_SetPF012Bak(self, content, colorsOffset + 4);
	RECOIL_DecodeAtari8Gr15(self, content, bitmapOffset + 40, 80, frame1, 320, 640, height >> 1);
	RECOIL_DecodeAtari8Gr15(self, content, bitmapOffset + height * 40, 80, frame2, 0, 640, height >> 1);
	RECOIL_SetPF012Bak(self, content, colorsOffset);
	RECOIL_DecodeAtari8Gr15(self, content, bitmapOffset + height * 40 + 40, 80, frame2, 320, 640, height >> 1);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeGr3(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if (contentLength != 244)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE8X8);
	RECOIL_SetBakPF012(self, content, 240, 1);
	RECOIL_DecodeAtari8Gr3(self, content, frame);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeGr7(RECOIL *self, unsigned char const *content, int contentOffset, int contentSize)
{
	int height;
	unsigned char frame[76800];
	if (contentSize > 4804 || contentSize % 40 != 4)
		return FALSE;
	height = contentSize / 40;
	RECOIL_SetSize(self, 320, height * 2, RECOILResolution_XE2X2);
	RECOIL_SetBakPF012(self, content, contentOffset + contentSize - 4, 1);
	RECOIL_DecodeAtari8Gr7(self, content, contentOffset, frame, 0, height);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeGr8(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset;
	unsigned char frame[76800];
	if (!RECOIL_SetAtari8RawSize(self, content, contentLength, RECOILResolution_XE1X1))
		return FALSE;
	self->gtiaColors[6] = 0;
	self->gtiaColors[5] = 14;
	contentOffset = RECOIL_GetAtari8ExecutableOffset(content, contentLength);
	RECOIL_DecodeAtari8Gr8(self, content, contentOffset, frame, 0, self->height);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeGr8Raw(RECOIL *self, unsigned char const *content, int contentLength, int width, int height)
{
	RECOIL_SetSize(self, width, height, RECOILResolution_XE1X1);
	self->contentPalette[0] = self->atari8Palette[0];
	self->contentPalette[1] = self->atari8Palette[14];
	return RECOIL_DecodeMono(self, content, 0, contentLength, FALSE);
}

static cibool RECOIL_DecodeGr9(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset;
	unsigned char frame[76800];
	if (!RECOIL_SetAtari8RawSize(self, content, contentLength, RECOILResolution_XE4X1))
		return FALSE;
	self->gtiaColors[8] = 0;
	contentOffset = RECOIL_GetAtari8ExecutableOffset(content, contentLength);
	RECOIL_DecodeAtari8Gr9(self, content, contentOffset, 40, frame, 0, 320, 320, self->height);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeGraphicsProcessor(RECOIL *self, unsigned char const *content, int contentLength)
{
	int mode;
	int bitplanes;
	unsigned char unpacked[32000];
	int contentOffset;
	int count;
	if (contentLength < 493 || content[0] != 0)
		return FALSE;
	mode = content[1];
	switch (mode) {
	case 0:
	case 1:
	case 2:
		return contentLength == 32331 && RECOIL_DecodeSt(self, content, 331, content, 2, mode, 0);
	case 10:
	case 11:
	case 12:
		break;
	default:
		return FALSE;
	}
	mode -= 10;
	bitplanes = 4 >> mode;
	contentOffset = 333;
	count = 0;
	{
		int unpackedOffset;
		for (unpackedOffset = 0; unpackedOffset < 32000; unpackedOffset += bitplanes) {
			if (count == 0) {
				if (contentOffset + bitplanes >= contentLength)
					return FALSE;
				count = content[contentOffset];
				if (count == 0)
					return FALSE;
				contentOffset += 1 + bitplanes;
			}
			memcpy(unpacked + unpackedOffset, content + contentOffset - bitplanes, bitplanes);
			count--;
		}
	}
	return RECOIL_DecodeSt(self, unpacked, 0, content, 2, mode, 0);
}

static cibool RECOIL_DecodeGun(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 33602 && contentLength != 33603)
		return FALSE;
	RECOIL_SetSize(self, 296, 200, RECOILResolution_C641X1);
	RECOIL_DecodeC64MulticolorFrame(self, content, 8218, 5, 16389, -16209, 0);
	self->leftSkip = -1;
	RECOIL_DecodeC64MulticolorFrame(self, content, 25626, 17413, 16389, -16209, 59200);
	return RECOIL_ApplyBlend(self);
}

static void RECOIL_DecodeHam(RECOIL *self, unsigned char const *unpacked, int width, int height, int bitplanes, MultiPalette *multiPalette)
{
	int bytesPerBitplane = (width + 15) >> 4 << 1;
	int holdBits = bitplanes > 6 ? 6 : 4;
	{
		int y;
		for (y = 0; y < height; y++) {
			int rgb;
			if (multiPalette != NULL)
				multiPalette->vtbl->setLinePalette(multiPalette, self, y);
			rgb = self->contentPalette[0];
			{
				int x;
				for (x = 0; x < width; x++) {
					int offset = (y * bytesPerBitplane + ((x >> 3) & ~1)) * bitplanes + ((x >> 3) & 1);
					int bit = ~x & 7;
					int c = 0;
					{
						int bitplane;
						for (bitplane = bitplanes; --bitplane >= 0;)
							c = (c << 1) | ((unpacked[offset + (bitplane << 1)] >> bit) & 1);
					}
					switch (c >> holdBits) {
					case 0:
						rgb = self->contentPalette[c];
						break;
					case 1:
						c = (c << (8 - holdBits)) & 255;
						c |= c >> holdBits;
						rgb = (rgb & 16776960) | c;
						break;
					case 2:
						c = (c << (8 - holdBits)) & 255;
						c |= c >> holdBits;
						rgb = (rgb & 65535) | (c << 16);
						break;
					case 3:
						c = (c << (8 - holdBits)) & 255;
						c |= c >> holdBits;
						rgb = (rgb & 16711935) | (c << 8);
						break;
					}
					RECOIL_SetScaledPixel(self, x, y, rgb);
				}
			}
		}
	}
}

static cibool RECOIL_DecodeHcm(RECOIL *self, unsigned char const *content, int contentLength)
{
	HcmRenderer gtia;
	int leftSprite;
	unsigned char frame[49152];
	if (contentLength != 8208 || !RECOIL_IsStringAt(content, 0, "HCMA8") || content[5] != 1)
		return FALSE;
	HcmRenderer_Construct(&gtia, NULL);
	switch (content[6]) {
	case 0:
		leftSprite = 2;
		gtia.base.prior = 0;
		break;
	case 2:
		leftSprite = 1;
		gtia.base.prior = 36;
		break;
	default:
		return FALSE;
	}
	gtia.base.playerHpos[3] = gtia.base.playerHpos[3 - leftSprite] = 104;
	gtia.base.missileHpos[leftSprite] = gtia.base.missileHpos[0] = 136;
	gtia.base.missileHpos[3] = gtia.base.missileHpos[3 - leftSprite] = 144;
	{
		int i;
		for (i = 0; i < 4; i++)
			gtia.base.missileSize[i] = gtia.base.playerSize[i] = 4;
	}
	gtia.base.colors[8] = content[7] & 254;
	gtia.base.colors[3 - leftSprite] = gtia.base.colors[0] = content[8] & 254;
	gtia.base.colors[3] = gtia.base.colors[leftSprite] = content[9] & 254;
	gtia.base.colors[4] = content[10] & 254;
	gtia.base.colors[5] = content[11] & 254;
	gtia.base.colors[6] = content[12] & 254;
	gtia.base.content = content;
	gtia.base.playfieldColumns = 32;
	RECOIL_SetSize(self, 256, 192, RECOILResolution_XE2X1);
	{
		int y;
		for (y = 0; y < 192; y++) {
			gtia.base.playerHpos[leftSprite] = gtia.base.playerHpos[0] = 72;
			GtiaRenderer_ProcessSpriteDma(&gtia.base, content, 816 + y);
			GtiaRenderer_StartLine(&gtia.base, 64);
			GtiaRenderer_DrawSpan(&gtia.base, y, 64, 128, AnticMode_FOUR_COLOR, frame, 256);
			gtia.base.playerHpos[leftSprite] = gtia.base.playerHpos[0] = 152;
			gtia.base.playerGraphics[0] = content[48 + y];
			gtia.base.playerGraphics[leftSprite] = content[304 + y];
			GtiaRenderer_DrawSpan(&gtia.base, y, 128, 192, AnticMode_FOUR_COLOR, frame, 256);
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeHed(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 9218)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_C641X1);
	RECOIL_DecodeC64HiresFrame(self, content, 2, 8194, 0);
	return TRUE;
}

static cibool RECOIL_DecodeHfc(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 16386)
		return FALSE;
	RECOIL_SetSize(self, 296, 112, RECOILResolution_C641X1);
	RECOIL_DecodeC64HiresFrame(self, content, 26, 8197, 0);
	return TRUE;
}

static cibool RECOIL_DecodeHgb(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset = RECOIL_GetAmstradHeader(content, contentLength);
	if (contentLength != contentOffset + 16384)
		return FALSE;
	self->contentPalette[0] = 0;
	self->contentPalette[1] = 16777215;
	return RECOIL_DecodeAmstradMode2(self, content, contentOffset, 512, 256);
}

static cibool RECOIL_DecodeHgr(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength < 8184)
		return FALSE;
	RECOIL_SetSize(self, 280, 192, RECOILResolution_APPLE_I_I1X1);
	{
		int y;
		for (y = 0; y < 192; y++) {
			int lineOffset = ((y & 7) << 10) | ((y & 56) << 4) | (y >> 6) * 40;
			{
				int x;
				for (x = 0; x < 280; x++) {
					int c = (content[lineOffset + x / 7] >> x % 7) & 1;
					if (c != 0)
						c = 16777215;
					self->pixels[y * 280 + x] = c;
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeHim(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[16372];
	HimStream rle;
	if (contentLength < 18 || content[0] != 0 || content[1] != 64)
		return FALSE;
	if (content[3] == 255)
		return contentLength == 16385 && RECOIL_DecodeHimUnpacked(self, content);
	if (content[2] + (content[3] << 8) != 16381 + contentLength || content[4] != 242 || content[5] != 127)
		return FALSE;
	HimStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = contentLength - 1;
	{
		int unpackedOffset;
		for (unpackedOffset = 16371; unpackedOffset >= 322; unpackedOffset--) {
			int b = RleStream_ReadRle(&rle.base);
			if (b < 0)
				return FALSE;
			unpacked[unpackedOffset] = b;
		}
	}
	return RECOIL_DecodeHimUnpacked(self, unpacked);
}

static cibool RECOIL_DecodeHimUnpacked(RECOIL *self, unsigned char const *content)
{
	RECOIL_SetSize(self, 296, 192, RECOILResolution_C641X1);
	RECOIL_DecodeC64HiresFrame(self, content, 346, 8237, 0);
	return TRUE;
}

static cibool RECOIL_DecodeHip(RECOIL *self, unsigned char const *content, int contentLength)
{
	static const unsigned char gr10Colors[9] = { 0, 0, 2, 4, 6, 8, 10, 12, 14 };
	unsigned char frame1[76800];
	unsigned char frame2[76800];
	int frameLength;
	if (contentLength < 80)
		return FALSE;
	frameLength = RECOIL_ParseAtari8ExecutableHeader(content, 0);
	if (frameLength > 0 && frameLength % 40 == 0 && 12 + frameLength * 2 == contentLength && RECOIL_ParseAtari8ExecutableHeader(content, 6 + frameLength) == frameLength) {
		int height = frameLength / 40;
		if (height > 240)
			return FALSE;
		RECOIL_SetSize(self, 320, height, RECOILResolution_XE2X1);
		self->leftSkip = 1;
		RECOIL_SetGtiaColors(self, gr10Colors, 0);
		RECOIL_DecodeAtari8Gr10(self, content, 6, frame1, 0, 320, height);
		self->gtiaColors[8] = 0;
		RECOIL_DecodeAtari8Gr9(self, content, 12 + frameLength, 40, frame2, 0, 320, 320, height);
	}
	else {
		int height = contentLength / 80;
		if (height > 240)
			return FALSE;
		RECOIL_SetSize(self, 320, height, RECOILResolution_XE2X1);
		self->leftSkip = 1;
		self->gtiaColors[8] = 0;
		RECOIL_DecodeAtari8Gr9(self, content, 0, 40, frame1, 0, 320, 320, height);
		if (contentLength % 80 == 9)
			RECOIL_SetGtiaColors(self, content, contentLength - 9);
		else
			RECOIL_SetGtiaColors(self, gr10Colors, 0);
		RECOIL_DecodeAtari8Gr10(self, content, height * 40, frame2, 0, 320, height);
	}
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeHlf(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 24578)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_C641X1);
	RECOIL_DecodeC64HiresFrame(self, content, 2, 9218, 0);
	RECOIL_DecodeC64HiresFrame(self, content, 16386, 10242, 64000);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodeHlr(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 1628 || content[0] != 118 || content[1] != 175 || content[2] != 211 || content[3] != 254 || content[4] != 33 || content[5] != 0 || content[6] != 88)
		return FALSE;
	RECOIL_SetZx(self, RECOILResolution_SPECTRUM1X1);
	RECOIL_DecodeZx(self, content, -2, 92, 3, 0);
	RECOIL_DecodeZx(self, content, -2, 860, 3, 49152);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodeHpm(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[7684];
	HpmStream rle;
	HpmStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 0;
	rle.base.base.base.contentLength = contentLength;
	if (!RleStream_Unpack(&rle.base, unpacked, 0, 1, 7680))
		return FALSE;
	switch (Stream_ReadByte(&rle.base.base.base)) {
	case 52:
	case 53:
		unpacked[7680] = 0;
		unpacked[7681] = 52;
		unpacked[7682] = contentLength == 3494 ? 56 : 200;
		unpacked[7683] = contentLength == 3494 ? 60 : 124;
		break;
	case 81:
		unpacked[7680] = 164;
		unpacked[7681] = 81;
		unpacked[7682] = 185;
		unpacked[7683] = 124;
		break;
	case 228:
		unpacked[7680] = 0;
		unpacked[7681] = 228;
		unpacked[7682] = 200;
		unpacked[7683] = 190;
		break;
	case 4:
		unpacked[7680] = 6;
		unpacked[7681] = 4;
		unpacked[7682] = 0;
		unpacked[7683] = 10;
		break;
	case 48:
		unpacked[7680] = 14;
		unpacked[7681] = 48;
		unpacked[7682] = 199;
		unpacked[7683] = 123;
		break;
	case 116:
		unpacked[7680] = 0;
		unpacked[7681] = 116;
		unpacked[7682] = 88;
		unpacked[7683] = 126;
		break;
	default:
		unpacked[7680] = 0;
		unpacked[7681] = 4;
		unpacked[7682] = 8;
		unpacked[7683] = 12;
		break;
	}
	return RECOIL_DecodeMic(self, unpacked, 7684);
}

static cibool RECOIL_DecodeHr2(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame1[64000];
	unsigned char frame2[64000];
	if (contentLength != 16006)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_XE1X1);
	RECOIL_SetPF21(self, content, 16000);
	RECOIL_DecodeAtari8Gr8(self, content, 0, frame1, 0, 200);
	RECOIL_SetBakPF012(self, content, 16002, 1);
	RECOIL_DecodeAtari8Gr15(self, content, 8000, 40, frame2, 0, 320, 200);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeHrm(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 92000)
		return FALSE;
	RECOIL_SetSize(self, 640, 400, RECOILResolution_STE1X2);
	self->frames = 2;
	{
		int y;
		for (y = 0; y < 400; y++) {
			{
				int x;
				for (x = 0; x < 640; x++) {
					int offset = y * 160 + ((x >> 2) & ~3) + ((x >> 3) & 1);
					int bit = ~x & 7;
					int c = ((content[offset] >> bit) & 1) | (((content[offset + 2] >> bit) & 1) << 1);
					static const unsigned char colorOffsets[4] = { 80, 72, 40, 32 };
					int rgb;
					int pixelsOffset;
					c += ((x + colorOffsets[c]) / 80 << 2) - 1;
					rgb = RECOIL_GetStColor(self, content, 64000 + y * 70 + (c << 1));
					pixelsOffset = y * 640 + x;
					if ((y & 1) == 0)
						self->pixels[pixelsOffset] = rgb;
					else {
						int rgb1 = self->pixels[pixelsOffset - 640];
						self->pixels[pixelsOffset] = self->pixels[pixelsOffset - 640] = (rgb1 & rgb) + (((rgb1 ^ rgb) >> 1) & 8355711);
					}
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeHrs(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset = RECOIL_GetOricHeader(content, contentLength);
	if (contentOffset + 8000 != contentLength)
		return FALSE;
	RECOIL_SetSize(self, 240, 200, RECOILResolution_ORIC1X1);
	{
		int y;
		for (y = 0; y < 200; y++) {
			int paper = 0;
			int ink = 7;
			{
				int col;
				for (col = 0; col < 40; col++) {
					int offset = y * 40 + col;
					int b = content[contentOffset + offset];
					int inverse = b >= 128 ? 7 : 0;
					switch (b & 120) {
					case 0:
						ink = b & 7;
						b = 0;
						break;
					case 8:
					case 24:
						b = 0;
						break;
					case 16:
						paper = b & 7;
						b = 0;
						break;
					default:
						break;
					}
					{
						int x;
						for (x = 0; x < 6; x++)
							self->pixels[offset * 6 + x] = RECOIL_BbcPalette[(((b >> (5 - x)) & 1) == 0 ? paper : ink) ^ inverse];
					}
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeIbi(RECOIL *self, unsigned char const *content, int contentLength)
{
	if ((contentLength != 704 && contentLength != 1600) || content[0] != 73 || content[1] != 67 || content[2] != 66 || (content[3] != 73 && content[3] != 51) || content[8] != 0 || content[9] != 32 || content[10] != 0 || content[11] != 32)
		return FALSE;
	RECOIL_SetSize(self, 32, 32, RECOILResolution_FALCON1X1);
	RECOIL_SetDefaultStPalette(self, 4);
	RECOIL_DecodeBitplanes(self, content, 64, 16, 4, 0, 32, 32);
	return TRUE;
}

static cibool RECOIL_DecodeIc(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[32000];
	IcStream rle;
	if (contentLength < 68 || !RECOIL_IsStringAt(content, 0, "IMDC") || content[4] != 0 || content[64] != 200 || content[65] != 2)
		return FALSE;
	IcStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 67;
	rle.base.base.base.contentLength = contentLength;
	return RleStream_UnpackColumns(&rle.base, unpacked, 0, 160, 32000) && RECOIL_DecodeSt(self, unpacked, 0, content, 6, content[5], 0);
}

static void RECOIL_DecodeIce20Frame(RECOIL const *self, unsigned char const *content, cibool second, int fontOffset, unsigned char *frame, int mode)
{
	unsigned char bitmap[32];
	{
		int y;
		for (y = 0; y < 288; y++) {
			int row = y >> 3;
			int c = (second ? row / 3 : row % 3) + 1;
			{
				int col;
				for (col = 0; col < 32; col++) {
					int ch = ((y & 24) << 1) + (col >> 1);
					int b = content[fontOffset + (ch << 3) + (y & 7)];
					b = (col & 1) == 0 ? b >> 4 : b & 15;
					b = (((b & 8) << 3) | ((b & 4) << 2) | ((b & 2) << 1) | (b & 1)) * c;
					if (mode == 10) {
						if ((b & 112) == 64)
							b = 128 + (b & 15);
						if ((b & 7) == 4)
							b = (b & 240) + 8;
					}
					bitmap[col] = b;
				}
			}
			switch (mode) {
			case 9:
				RECOIL_DecodeAtari8Gr9(self, bitmap, 0, 0, frame, y << 8, 0, 256, 1);
				break;
			case 10:
				RECOIL_DecodeAtari8Gr10(self, bitmap, 0, frame, y << 8, 0, 1);
				break;
			case 11:
				RECOIL_DecodeAtari8Gr11(self, bitmap, 0, frame, y << 8, 0, 1);
				break;
			}
		}
	}
}

static void RECOIL_DecodeIceFrame(RECOIL const *self, unsigned char const *content, int charactersOffset, int fontOffset, unsigned char *frame, IceFrameMode mode)
{
	int doubleLine;
	int frameOffset;
	unsigned char bitmap[40];
	switch (mode) {
	case IceFrameMode_GR13_GTIA9:
	case IceFrameMode_GR13_GTIA10:
	case IceFrameMode_GR13_GTIA11:
		doubleLine = 1;
		break;
	default:
		doubleLine = 0;
		break;
	}
	frameOffset = 0;
	{
		int y;
		for (y = 0; y < self->height; y++) {
			{
				int col;
				for (col = 0; col < self->width >> 3; col++) {
					int ch;
					int b;
					switch (charactersOffset) {
						static const unsigned char row2char1[16] = { 64, 0, 32, 96, 192, 128, 160, 224, 64, 0, 32, 96, 192, 128, 160, 224 };
						static const unsigned char row2char2[16] = { 64, 0, 32, 96, 192, 128, 160, 224, 192, 128, 160, 224, 64, 0, 32, 96 };
					case -1:
						ch = row2char1[y >> (3 + doubleLine)] + col;
						break;
					case -2:
						ch = row2char2[y >> (3 + doubleLine)] + col;
						break;
					default:
						ch = (y / 24 << 8) + content[charactersOffset + (y >> 3) * 40 + col];
						break;
					}
					b = content[fontOffset + ((ch & ~128) << 3) + ((y >> doubleLine) & 7)];
					switch (mode) {
					case IceFrameMode_GR0:
					case IceFrameMode_GR0_GTIA9:
					case IceFrameMode_GR0_GTIA10:
					case IceFrameMode_GR0_GTIA11:
						if (charactersOffset < 0 && (ch & 128) != 0)
							b ^= 255;
						bitmap[col] = b;
						break;
					case IceFrameMode_GR12:
						{
							int x;
							for (x = col == 0 ? self->leftSkip : 0; x < 8; x++) {
								int c = (b >> (~x & 6)) & 3;
								int gr12Registers = (ch & 128) == 0 ? 25928 : 30024;
								frame[frameOffset + (col << 3) + x - self->leftSkip] = self->gtiaColors[(gr12Registers >> (c << 2)) & 15];
							}
						}
						break;
					case IceFrameMode_GR12_GTIA9:
					case IceFrameMode_GR12_GTIA11:
					case IceFrameMode_GR13_GTIA9:
					case IceFrameMode_GR13_GTIA11:
						bitmap[col] = RECOIL_Gr12GtiaByteToGr8(b, ch, FALSE);
						break;
					case IceFrameMode_GR12_GTIA10:
					case IceFrameMode_GR13_GTIA10:
						bitmap[col] = RECOIL_Gr12GtiaByteToGr8(b, ch, TRUE);
						break;
					}
				}
			}
			switch (mode) {
			case IceFrameMode_GR0:
				RECOIL_DecodeAtari8Gr8(self, bitmap, 0, frame, frameOffset, 1);
				break;
			case IceFrameMode_GR12:
				{
					int x;
					for (x = self->width; x < self->width + self->leftSkip; x++)
						frame[frameOffset + x] = self->gtiaColors[8];
				}
				break;
			case IceFrameMode_GR0_GTIA9:
			case IceFrameMode_GR12_GTIA9:
			case IceFrameMode_GR13_GTIA9:
				RECOIL_DecodeAtari8Gr9(self, bitmap, 0, 0, frame, frameOffset, 0, self->width, 1);
				break;
			case IceFrameMode_GR0_GTIA10:
			case IceFrameMode_GR12_GTIA10:
			case IceFrameMode_GR13_GTIA10:
				RECOIL_DecodeAtari8Gr10(self, bitmap, 0, frame, frameOffset, 0, 1);
				break;
			case IceFrameMode_GR0_GTIA11:
			case IceFrameMode_GR12_GTIA11:
			case IceFrameMode_GR13_GTIA11:
				RECOIL_DecodeAtari8Gr11(self, bitmap, 0, frame, frameOffset, 0, 1);
				break;
			}
			frameOffset += self->width;
		}
	}
}

static cibool RECOIL_DecodeIff(RECOIL *self, unsigned char const *content, int contentLength, RECOILResolution resolution)
{
	int contentOffset;
	IffType type;
	int width;
	int height;
	int bitplanes;
	cibool hasMask;
	int compression;
	cibool ocsPalette;
	int colors;
	int camg;
	CtblPalette ctbl;
	ShamLacePalette sham;
	PchgPalette pchg;
	MultiPalette *multiPalette;
	if (contentLength < 56 || !RECOIL_IsStringAt(content, 0, "FORM"))
		return FALSE;
	if (RECOIL_IsStringAt(content, 8, "DEEP") || RECOIL_IsStringAt(content, 8, "TVPP"))
		return RECOIL_DecodeDeep(self, content, contentLength);
	contentOffset = 8;
	if (RECOIL_IsStringAt(content, 8, "DPSTDPAH") && RECOIL_Get32BigEndian(content, 16) == 24 && RECOIL_IsStringAt(content, 44, "FORM"))
		contentOffset = 52;
	else if (RECOIL_IsStringAt(content, 8, "ANIMFORM"))
		contentOffset = 20;
	if (RECOIL_IsStringAt(content, contentOffset, "ILBM"))
		type = IffType_ILBM;
	else if (RECOIL_IsStringAt(content, contentOffset, "PBM "))
		type = IffType_PBM;
	else if (RECOIL_IsStringAt(content, contentOffset, "ACBM"))
		type = IffType_ACBM;
	else if (RECOIL_IsStringAt(content, contentOffset, "RGB8"))
		type = IffType_RGB8;
	else if (RECOIL_IsStringAt(content, contentOffset, "RGBN"))
		type = IffType_RGBN;
	else
		return FALSE;
	contentOffset += 4;
	width = 0;
	height = 0;
	bitplanes = 0;
	hasMask = FALSE;
	compression = 0;
	ocsPalette = FALSE;
	colors = 0;
	camg = 0;
	CtblPalette_Construct(&ctbl, NULL);
	ShamLacePalette_Construct(&sham, NULL);
	PchgPalette_Construct(&pchg, NULL);
	multiPalette = NULL;
	while (contentOffset < contentLength - 7) {
		int chunkLength = RECOIL_Get32BigEndian(content, contentOffset + 4);
		int chunkEndOffset = contentOffset + 8 + chunkLength;
		if (chunkEndOffset > contentLength || chunkEndOffset < contentOffset + 8) {
			chunkEndOffset = contentLength;
			chunkLength = contentLength - contentOffset - 8;
		}
		if (RECOIL_IsStringAt(content, contentOffset, "BMHD") && chunkLength >= 16) {
			int pixelsCount;
			width = (content[contentOffset + 8] << 8) | content[contentOffset + 9];
			height = (content[contentOffset + 10] << 8) | content[contentOffset + 11];
			bitplanes = content[contentOffset + 16];
			hasMask = content[contentOffset + 17] == 1;
			compression = content[contentOffset + 18];
			switch (type) {
			case IffType_PBM:
				if (bitplanes != 8 || compression > 1)
					return FALSE;
				break;
			case IffType_RGB8:
				if (bitplanes != 25 || compression != 4)
					return FALSE;
				break;
			case IffType_RGBN:
				if (bitplanes != 13 || compression != 4)
					return FALSE;
				break;
			default:
				if (bitplanes == 0 || (bitplanes > 8 && bitplanes != 24 && bitplanes != 32) || compression > 2)
					return FALSE;
				break;
			}
			pixelsCount = width * height;
			if (pixelsCount <= 0 || pixelsCount > 2854278)
				return FALSE;
			ocsPalette = content[contentOffset + 19] != 128;
			resolution = RECOIL_GetAmigaAspectRatio(content[contentOffset + 22], content[contentOffset + 23], resolution);
		}
		else if (RECOIL_IsStringAt(content, contentOffset, "CMAP")) {
			int c;
			colors = chunkLength / 3;
			if (colors > 256)
				return FALSE;
			if (colors > 32)
				ocsPalette = FALSE;
			for (c = 0; c < colors; c++) {
				self->contentPalette[c] = RECOIL_GetR8G8B8Color(content, contentOffset + 8 + c * 3);
				if ((self->contentPalette[c] & 986895) != 0)
					ocsPalette = FALSE;
			}
			for (; c < 256; c++)
				self->contentPalette[c] = 0;
			if (ocsPalette) {
				for (c = 0; c < colors; c++)
					self->contentPalette[c] |= self->contentPalette[c] >> 4;
			}
		}
		else if (RECOIL_IsStringAt(content, contentOffset, "CAMG") && chunkLength >= 4) {
			camg = RECOIL_Get32BigEndian(content, contentOffset + 8);
			resolution = RECOIL_GetCamgAspectRatio(camg, resolution);
		}
		else if ((RECOIL_IsStringAt(content, contentOffset, "CTBL") || RECOIL_IsStringAt(content, contentOffset, "BEAM")) && height > 0) {
			ctbl.colors = (chunkLength >> 1) / height;
			if (ctbl.colors <= 32) {
				ctbl.base.base.base.content = content;
				ctbl.base.base.base.contentOffset = contentOffset + 8;
				multiPalette = &ctbl.base;
			}
		}
		else if (RECOIL_IsStringAt(content, contentOffset, "SHAM") && chunkLength >= 2 && content[contentOffset + 8] == 0 && content[contentOffset + 9] == 0) {
			if (chunkLength == 2 + (height << 5)) {
				ctbl.base.base.base.content = content;
				ctbl.base.base.base.contentOffset = contentOffset + 10;
				ctbl.colors = 16;
				multiPalette = &ctbl.base;
			}
			else if (chunkLength == 2 + (height >> 1 << 5)) {
				sham.base.base.base.content = content;
				sham.base.base.base.contentOffset = contentOffset + 10;
				multiPalette = &sham.base;
			}
		}
		else if (RECOIL_IsStringAt(content, contentOffset, "PCHG")) {
			pchg.base.base.base.content = content;
			pchg.base.base.base.contentOffset = contentOffset + 8;
			pchg.base.base.base.contentLength = chunkEndOffset;
			if (!PchgPalette_Init(&pchg))
				return FALSE;
			multiPalette = &pchg.base;
		}
		else if (RECOIL_IsStringAt(content, contentOffset, "BODY")) {
			int bytesPerLine;
			unsigned char *unpacked;
			RastPalette rast;
			if (width == 0)
				return FALSE;
			if (compression == 4)
				return RECOIL_SetScaledSize(self, width, height, resolution) && RECOIL_DecodeRgbn(self, content, contentOffset + 8, chunkEndOffset, width, height, type == IffType_RGB8);
			bytesPerLine = ((width + 15) >> 4 << 1) * bitplanes;
			if (compression == 2) {
				VdatStream rle;
				unpacked = (unsigned char *) malloc(bytesPerLine * height * sizeof(unsigned char ));
				VdatStream_Construct(&rle, NULL);
				rle.base.base.base.base.base.content = content;
				rle.base.base.base.base.base.contentOffset = contentOffset + 8;
				{
					int bitplane;
					for (bitplane = 0; bitplane < bitplanes; bitplane++) {
						int nextContentOffset;
						if (rle.base.base.base.base.base.contentOffset + 14 > chunkEndOffset || !RECOIL_IsStringAt(content, rle.base.base.base.base.base.contentOffset, "VDAT"))
							return FALSE;
						nextContentOffset = rle.base.base.base.base.base.contentOffset + 8 + RECOIL_Get32BigEndian(content, rle.base.base.base.base.base.contentOffset + 4);
						if (nextContentOffset > chunkEndOffset)
							return FALSE;
						rle.base.valueOffset = rle.base.base.base.base.base.contentLength = rle.base.base.base.base.base.contentOffset + 8 + (content[rle.base.base.base.base.base.contentOffset + 8] << 8) + content[rle.base.base.base.base.base.contentOffset + 9];
						rle.base.valueLength = nextContentOffset;
						rle.base.base.base.base.base.contentOffset += 10;
						{
							int x;
							for (x = bitplane << 1; x < bytesPerLine; x += bitplanes << 1) {
								int unpackedOffset = x;
								{
									int y;
									for (y = 0; y < height; y++) {
										int b = RleStream_ReadRle(&rle.base.base.base);
										if (b < 0)
											return FALSE;
										unpacked[unpackedOffset] = b >> 8;
										unpacked[unpackedOffset + 1] = (unsigned char) b;
										unpackedOffset += bytesPerLine;
									}
								}
							}
						}
						rle.base.base.base.base.base.contentOffset = nextContentOffset;
					}
				}
				resolution = resolution == RECOILResolution_AMIGA1X2 ? RECOILResolution_ST1X2 : RECOILResolution_ST1X1;
			}
			else {
				PackBitsStream rle;
				PackBitsStream_Construct(&rle, NULL);
				rle.base.base.base.content = content;
				rle.base.base.base.contentOffset = contentOffset + 8;
				rle.base.base.base.contentLength = chunkEndOffset;
				if (type == IffType_PBM) {
					if (colors == 0 || !RECOIL_SetScaledSize(self, width, height, resolution))
						return FALSE;
					{
						int y;
						for (y = 0; y < height; y++) {
							{
								int x;
								for (x = 0; x < width; x++) {
									int b = compression == 0 ? Stream_ReadByte(&rle.base.base.base) : RleStream_ReadRle(&rle.base);
									if (b < 0)
										return FALSE;
									RECOIL_SetScaledPixel(self, x, y, self->contentPalette[b]);
								}
							}
							if ((width & 1) != 0 && (compression == 0 ? Stream_ReadByte(&rle.base.base.base) : RleStream_ReadRle(&rle.base)) < 0)
								return FALSE;
						}
					}
					return TRUE;
				}
				unpacked = (unsigned char *) malloc(bytesPerLine * height * sizeof(unsigned char ));
				if (!PackBitsStream_UnpackBitplaneLines(&rle, unpacked, width, height, bitplanes, compression == 1, hasMask))
					return FALSE;
			}
			RastPalette_Construct(&rast, NULL);
			if (chunkEndOffset < contentLength - 8) {
				int nextChunkOffset = (chunkEndOffset + 1) & ~1;
				if (RECOIL_IsStringAt(content, nextChunkOffset, "RAST")) {
					rast.base.base.base.content = content;
					rast.base.base.base.contentOffset = nextChunkOffset + 8;
					rast.base.base.base.contentLength = contentLength;
					multiPalette = &rast.base;
					resolution = RECOILResolution_STE1X1;
				}
				else if (RECOIL_IsStringAt(content, chunkEndOffset, "RAST")) {
					rast.base.base.base.content = content;
					rast.base.base.base.contentOffset = chunkEndOffset + 8;
					rast.base.base.base.contentLength = contentLength;
					multiPalette = &rast.base;
					resolution = RECOILResolution_STE1X1;
				}
			}
			return RECOIL_DecodeIffUnpacked(self, unpacked, width, height, resolution, bitplanes, colors, camg, multiPalette);
		}
		else if (RECOIL_IsStringAt(content, contentOffset, "ABIT")) {
			unsigned char *unpacked;
			if (width == 0 || chunkLength != ((width + 15) >> 4 << 1) * height * bitplanes)
				return FALSE;
			contentOffset += 8;
			unpacked = (unsigned char *) malloc(chunkLength * sizeof(unsigned char ));
			{
				int bitplane;
				for (bitplane = 0; bitplane < bitplanes; bitplane++) {
					{
						int unpackedOffset;
						for (unpackedOffset = bitplane << 1; unpackedOffset < chunkLength; unpackedOffset += bitplanes << 1) {
							unpacked[unpackedOffset] = content[contentOffset++];
							unpacked[unpackedOffset + 1] = content[contentOffset++];
						}
					}
				}
			}
			return RECOIL_DecodeIffUnpacked(self, unpacked, width, height, resolution, bitplanes, colors, camg, multiPalette);
		}
		contentOffset = (chunkEndOffset + 1) & ~1;
	}
	return FALSE;
}

static cibool RECOIL_DecodeIffUnpacked(RECOIL *self, unsigned char *unpacked, int width, int height, RECOILResolution resolution, int bitplanes, int colors, int camg, MultiPalette *multiPalette)
{
	if (!RECOIL_SetScaledSize(self, width, height, resolution)) {
		free(unpacked);
		return FALSE;
	}
	if (bitplanes <= 8) {
		if (colors == 0) {
			colors = 1 << bitplanes;
			{
				int c;
				for (c = 0; c < colors; c++)
					self->contentPalette[c] = c * 255 / colors * 65793;
			}
		}
		if ((camg & 2048) != 0 || (bitplanes == 6 && colors == 16)) {
			RECOIL_DecodeHam(self, unpacked, width, height, bitplanes, multiPalette);
		}
		else {
			RECOIL_DecodeScaledBitplanes(self, unpacked, 0, width, height, bitplanes, bitplanes == 6 && ((camg & 128) != 0 || colors == 32), multiPalette);
		}
	}
	else {
		int bytesPerBitplane = (width + 15) >> 4 << 1;
		{
			int y;
			for (y = 0; y < height; y++) {
				{
					int x;
					for (x = 0; x < width; x++) {
						int offset = (y * bytesPerBitplane + ((x >> 3) & ~1)) * bitplanes + ((x >> 3) & 1);
						int bit = ~x & 7;
						int c = 0;
						{
							int bitplane;
							for (bitplane = 24; --bitplane >= 0;)
								c = (c << 1) | ((unpacked[offset + (bitplane << 1)] >> bit) & 1);
						}
						RECOIL_SetScaledPixel(self, x, y, ((c & 255) << 16) | (c & 65280) | (c >> 16));
					}
				}
			}
		}
	}
	free(unpacked);
	return TRUE;
}

static cibool RECOIL_DecodeIge(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame1[24576];
	unsigned char frame2[24576];
	if (contentLength != 6160 || content[0] != 255 || content[1] != 255 || content[2] != 246 || content[3] != 163 || content[4] != 255 || content[5] != 187 || content[6] != 255 || content[7] != 95)
		return FALSE;
	RECOIL_SetSize(self, 256, 96, RECOILResolution_XE2X1);
	RECOIL_SetBakPF012(self, content, 8, 1);
	RECOIL_DecodeAtari8Gr15(self, content, 16, 32, frame1, 0, 256, 96);
	RECOIL_SetBakPF012(self, content, 12, 1);
	RECOIL_DecodeAtari8Gr15(self, content, 3088, 32, frame2, 0, 256, 96);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeIhe(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 16194)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_C641X1);
	RECOIL_DecodeC64HiresFrame(self, content, 2, -12, 0);
	RECOIL_DecodeC64HiresFrame(self, content, 8194, -12, 64000);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodeIim(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	int pixelsLength;
	if (contentLength < 17 || !RECOIL_IsStringAt(content, 0, "IS_IMAGE") || content[8] != 0)
		return FALSE;
	width = (content[12] << 8) | content[13];
	height = (content[14] << 8) | content[15];
	pixelsLength = width * height;
	switch (content[9]) {
	case 0:
		return RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1) && RECOIL_DecodeBlackAndWhite(self, content, 16, contentLength, FALSE, 16777215);
	case 1:
		return RECOIL_DecodeFalconGrayscale(self, content, 16, contentLength, width, height);
	case 4:
		if (contentLength != 16 + pixelsLength * 3 || !RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1))
			return FALSE;
		RECOIL_DecodeR8G8B8Colors(content, 16, pixelsLength, self->pixels);
		return TRUE;
	case 5:
		if (contentLength != 16 + (pixelsLength << 2) || !RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1))
			return FALSE;
		RECOIL_DecodeR8G8G8X8Colors(self, content, 17, pixelsLength);
		return TRUE;
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeIld(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame1[32768];
	unsigned char frame2[32768];
	if (contentLength != 8195)
		return FALSE;
	RECOIL_SetSize(self, 256, 128, RECOILResolution_XE2X1);
	self->gtiaColors[8] = 0;
	self->gtiaColors[4] = 6;
	self->gtiaColors[5] = 2;
	self->gtiaColors[6] = 10;
	RECOIL_DecodeAtari8Gr15(self, content, 0, 32, frame1, 0, 256, 128);
	RECOIL_DecodeAtari8Gr15(self, content, 4096, 32, frame2, 0, 256, 128);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeImage72Fnt(RECOIL *self, unsigned char const *content, int contentLength)
{
	int fontHeight;
	if (contentLength < 4 || content[0] != 0 || content[1] != 8)
		return FALSE;
	fontHeight = content[2];
	if (contentLength != 3 + (fontHeight << 8))
		return FALSE;
	RECOIL_SetSize(self, 256, fontHeight << 3, RECOILResolution_PC1X1);
	RECOIL_DecodeBlackAndWhiteFont(self, content, 3, contentLength, fontHeight);
	return TRUE;
}

static cibool RECOIL_DecodeInfo(RECOIL *self, unsigned char const *content, int contentLength)
{
	static const int os1Palette[4] = { 5614335, 16777215, 0, 16746496 };
	static const int os2Palette[8] = { 9803157, 0, 16777215, 3893154, 8092539, 11513775, 11178108, 16755095 };
	int const *palette;
	int contentOffset;
	int width;
	int height;
	int bitplanes;
	int bytesPerLine;
	if (contentLength < 98 || content[0] != 227 || content[1] != 16 || content[2] != 0 || content[3] != 1)
		return FALSE;
	switch (RECOIL_Get32BigEndian(content, 44)) {
	case 0:
		palette = os1Palette;
		break;
	case 1:
		palette = os2Palette;
		break;
	default:
		return FALSE;
	}
	contentOffset = RECOIL_Get32BigEndian(content, 66) == 0 ? 78 : 134;
	width = (content[contentOffset + 4] << 8) | content[contentOffset + 5];
	height = (content[contentOffset + 6] << 8) | content[contentOffset + 7];
	bitplanes = (content[contentOffset + 8] << 8) | content[contentOffset + 9];
	switch (bitplanes) {
	case 2:
		break;
	case 3:
		if (palette == os1Palette)
			return FALSE;
		break;
	default:
		return FALSE;
	}
	bytesPerLine = (width + 15) >> 4 << 1;
	contentOffset += 20;
	if (contentLength < contentOffset + bitplanes * height * bytesPerLine || !RECOIL_SetSize(self, width, height, RECOILResolution_AMIGA1X1))
		return FALSE;
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int x;
				for (x = 0; x < width; x++) {
					int bit = ~x & 7;
					int offset = contentOffset + y * bytesPerLine + (x >> 3);
					int c = 0;
					{
						int bitplane;
						for (bitplane = bitplanes; --bitplane >= 0;)
							c = (c << 1) | ((content[offset + bitplane * height * bytesPerLine] >> bit) & 1);
					}
					self->pixels[y * width + x] = palette[c];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeInp(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame1[64000];
	unsigned char frame2[64000];
	if (contentLength < 16004)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_XE2X1);
	RECOIL_SetBakPF012(self, content, 16000, 1);
	RECOIL_DecodeAtari8Gr15(self, content, 0, 40, frame1, 0, 320, 200);
	RECOIL_DecodeAtari8Gr15(self, content, 8000, 40, frame2, 0, 320, 200);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeInt(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentStride;
	int height;
	int width;
	unsigned char frame1[76480];
	unsigned char frame2[76480];
	if (contentLength < 18 || !RECOIL_IsStringAt(content, 0, "INT95a") || content[8] != 15 || content[9] != 43)
		return FALSE;
	contentStride = content[6];
	height = content[7];
	if (contentStride == 0 || contentStride > 320 || height == 0 || height > 239 || 18 + contentStride * height * 2 != contentLength)
		return FALSE;
	width = contentStride << 3;
	RECOIL_SetSize(self, width, height, RECOILResolution_XE2X1);
	RECOIL_SetBakPF012(self, content, 10, 1);
	RECOIL_DecodeAtari8Gr15(self, content, 18, contentStride, frame1, 0, width, height);
	RECOIL_SetBakPF012(self, content, 14, 1);
	RECOIL_DecodeAtari8Gr15(self, content, 18 + contentStride * height, contentStride, frame2, 0, width, height);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeIp2(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame1[61440];
	unsigned char frame2[61440];
	if (contentLength != 17358 || content[0] != 1)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X1);
	self->gtiaColors[8] = content[1] & 254;
	self->gtiaColors[4] = content[5] & 254;
	self->gtiaColors[5] = content[7] & 254;
	self->gtiaColors[6] = content[9] & 254;
	self->gtiaColors[7] = content[11] & 254;
	RECOIL_DecodeIceFrame(self, content, 16398, 14, frame1, IceFrameMode_GR12);
	self->leftSkip = 2;
	{
		int i;
		for (i = 0; i < 4; i++) {
			self->gtiaColors[i] = content[1 + i] & 254;
			RECOIL_SetGtiaColor(self, 4 + i, content[6 + i * 2]);
		}
	}
	RECOIL_SetGtiaColor(self, 8, content[13]);
	RECOIL_DecodeIceFrame(self, content, 16398, 1038, frame2, IceFrameMode_GR0_GTIA10);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeIph(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 9002:
	case 9003:
	case 9009:
		break;
	default:
		return FALSE;
	}
	RECOIL_SetSize(self, 320, 200, RECOILResolution_C641X1);
	RECOIL_DecodeC64HiresFrame(self, content, 2, 8002, 0);
	return TRUE;
}

static cibool RECOIL_DecodeIst(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame1[64000];
	unsigned char frame2[64000];
	if (contentLength != 17184)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_XE2X1);
	{
		int y;
		for (y = 0; y < 200; y++) {
			RECOIL_SetBakPF012(self, content, 16384 + y, 200);
			RECOIL_DecodeAtari8Gr15(self, content, 16 + y * 40, 0, frame1, y * 320, 320, 1);
			RECOIL_DecodeAtari8Gr15(self, content, 8208 + y * 40, 0, frame2, y * 320, 320, 1);
		}
	}
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeJgp(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[16384];
	if (contentLength != 2054 || RECOIL_ParseAtari8ExecutableHeader(content, 0) != 2048)
		return FALSE;
	RECOIL_SetGr15DefaultColors(self);
	RECOIL_SetSize(self, 256, 64, RECOILResolution_XE2X1);
	{
		int y;
		for (y = 0; y < 8; y++)
			RECOIL_DecodeAtari8Gr12Line(self, NULL, 0, content, 6 + ((y & 6) << 7) + ((y & 1) << 10), frame, y << 11, 0);
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeJj(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[9026];
	C64KoalaStream rle;
	if (contentLength < 2)
		return FALSE;
	C64KoalaStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 2;
	rle.base.base.base.contentLength = contentLength;
	return RleStream_UnpackC64(&rle.base, unpacked, 9026) && RECOIL_DecodeDd(self, unpacked, 9026);
}

static cibool RECOIL_DecodeKid(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 63054 && content[0] == 75 && content[1] == 68 && RECOIL_DecodeStLowWithStride(self, content, 34, 230, content, 2, 448, 274);
}

static cibool RECOIL_DecodeKoa(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 10001:
		return RECOIL_DecodeC64Multicolor(self, 320, content, 0, 8000, 9000, content[10000]);
	case 10003:
	case 10006:
		return RECOIL_DecodeC64Multicolor(self, 320, content, 2, 8002, 9002, content[10002]);
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeKpr(RECOIL *self, unsigned char const *content, int contentLength)
{
	int frames;
	int cols;
	int rows;
	int tiles;
	int pixelsOffset;
	if (contentLength < 11 || RECOIL_GetAtari8ExecutableOffset(content, contentLength) != 6)
		return FALSE;
	frames = content[8];
	cols = content[9];
	rows = content[10];
	tiles = frames * cols * rows;
	if (contentLength < 11 + tiles || !RECOIL_SetSize(self, frames * cols << 3, rows << 3, RECOILResolution_XE2X1))
		return FALSE;
	pixelsOffset = 0;
	{
		int y;
		for (y = 0; y < rows << 3; y++) {
			{
				int f;
				for (f = 0; f < frames; f++) {
					{
						int x;
						for (x = 0; x < cols << 3; x++) {
							int c = content[11 + (f * rows + (y >> 3)) * cols + (x >> 3)];
							c = 11 + tiles + (c << 3) + (y & 7);
							if (c >= contentLength)
								return FALSE;
							c = (content[c] >> (~x & 6)) & 3;
							self->pixels[pixelsOffset++] = self->atari8Palette[c << 2];
						}
					}
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeKss(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[51200];
	if (contentLength != 6404)
		return FALSE;
	RECOIL_SetSize(self, 320, 160, RECOILResolution_XE2X1);
	RECOIL_SetBakPF012(self, content, 6400, 1);
	RECOIL_DecodeAtari8Gr15(self, content, 0, 40, frame, 0, 320, 160);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeLdm(RECOIL *self, unsigned char const *content, int contentLength)
{
	int shapes;
	int rows;
	unsigned char frame[132480];
	if (contentLength < 281)
		return FALSE;
	{
		int i;
		for (i = 0; i < 21; i++)
			if (content[i] != "Ludek Maker data file"[i] + 128)
				return FALSE;
	}
	shapes = content[24] - content[23];
	if (shapes <= 0 || shapes > 100 || contentLength < 281 + shapes * 120)
		return FALSE;
	rows = (shapes + 7) >> 3;
	if (rows == 1)
		RECOIL_SetSize(self, shapes * 40, 30, RECOILResolution_XE2X1);
	else
		RECOIL_SetSize(self, 320, rows * 32 - 2, RECOILResolution_XE2X1);
	memset(frame, 0, sizeof(frame));
	{
		int shape;
		for (shape = 0; shape < shapes; shape++) {
			int contentOffset = 281 + shape * 120;
			int frameOffset = (shape >> 3) * 32 * 320 + (shape & 7) * 40;
			RECOIL_DecodeAtari8Player(self, content, contentOffset, content[21], frame, frameOffset, 30);
			RECOIL_DecodeAtari8Player(self, content, contentOffset + 30, content[22], frame, frameOffset, 30);
			RECOIL_DecodeAtari8Player(self, content, contentOffset + 60, content[21], frame, frameOffset + 16, 30);
			RECOIL_DecodeAtari8Player(self, content, contentOffset + 90, content[22], frame, frameOffset + 16, 30);
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeLeo(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[16384];
	unsigned char characters[32];
	if (contentLength != 2580)
		return FALSE;
	RECOIL_SetSize(self, 256, 64, RECOILResolution_XE2X1);
	RECOIL_SetPF0123Bak(self, content, 2560);
	{
		int y;
		for (y = 0; y < 8; y++) {
			{
				int x;
				for (x = 0; x < 32; x++)
					characters[x] = content[2048 + ((x & 1) << 7) + ((y & 1) << 6) + ((y & 6) << 3) + (x >> 1)];
			}
			RECOIL_DecodeAtari8Gr12Line(self, characters, 0, content, (y & 1) << 10, frame, y << 11, 0);
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeLp3(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char colors[4];
	switch (contentLength) {
	case 4098:
	case 4174:
		break;
	default:
		return FALSE;
	}
	if (content[0] != 0 || content[1] != 24)
		return FALSE;
	RECOIL_SetSize(self, 320, 400, RECOILResolution_C642X1);
	if (contentLength == 4174) {
		colors[0] = content[2045] & 15;
		colors[1] = content[2047] & 15;
		colors[2] = content[2048] & 15;
		colors[3] = content[2046] & 7;
	}
	else {
		colors[0] = 0;
		colors[1] = 10;
		colors[2] = 2;
		colors[3] = 1;
	}
	{
		int y;
		for (y = 0; y < 400; y++) {
			{
				int x;
				for (x = 0; x < 320; x++) {
					int c = content[2 + (y >> 3) * 40 + (x >> 3)];
					c = (content[2050 + (c << 3) + (y & 7)] >> (~x & 6)) & 3;
					self->pixels[y * 320 + x] = RECOIL_C64Palette[colors[c]];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeLum(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	unsigned char frame[76160];
	unsigned char col[4767];
	if (contentLength != 4766)
		return FALSE;
	RECOIL_SetSize(self, 320, 238, RECOILResolution_XE4X2);
	self->gtiaColors[8] = 0;
	RECOIL_DecodeAtari8Gr9(self, content, 6, 40, frame, 320, 640, 320, 119);
	if (RECOIL_ReadCompanionFile(self, filename, "COL", "col", col, 4767) == 4766) {
		RECOIL_DecodeAtari8Gr11PalBlend(self, col, 6, 40, frame, 0);
	}
	else {
		RECOIL_DecodeAtari8Gr9(self, content, 6, 40, frame, 0, 640, 320, 119);
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeMac(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset;
	PackBitsStream rle;
	if (contentLength < 512)
		return FALSE;
	contentOffset = RECOIL_IsStringAt(content, 65, "PNTG") ? 128 : 0;
	if (content[contentOffset] != 0 || content[contentOffset + 1] != 0 || content[contentOffset + 2] != 0 || content[contentOffset + 3] > 3)
		return FALSE;
	RECOIL_SetSize(self, 576, 720, RECOILResolution_MACINTOSH1X1);
	PackBitsStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = contentOffset + 512;
	rle.base.base.base.contentLength = contentLength;
	return RECOIL_DecodeRleBlackAndWhite(self, &rle.base, 16777215);
}

static cibool RECOIL_DecodeMag(RECOIL *self, unsigned char const *content, int contentLength)
{
	int headerOffset;
	int width;
	int height;
	int bytesPerLine;
	int colors;
	RECOILResolution resolution;
	int msxMode;
	unsigned char *unpacked;
	if (contentLength < 8)
		return FALSE;
	if (RECOIL_IsStringAt(content, 0, "MAKI01A ") || RECOIL_IsStringAt(content, 0, "MAKI01B "))
		return RECOIL_DecodeMaki1(self, content, contentLength);
	if (!RECOIL_IsStringAt(content, 0, "MAKI02  "))
		return FALSE;
	headerOffset = 0;
	do {
		if (headerOffset >= contentLength)
			return FALSE;
	}
	while (content[headerOffset++] != 26);
	if (headerOffset + 80 > contentLength || content[headerOffset] != 0)
		return FALSE;
	width = content[headerOffset + 8] - content[headerOffset + 4] + ((content[headerOffset + 9] - content[headerOffset + 5]) << 8) + 1;
	height = content[headerOffset + 10] - content[headerOffset + 6] + ((content[headerOffset + 11] - content[headerOffset + 7]) << 8) + 1;
	if (content[headerOffset + 3] < 128) {
		bytesPerLine = (width + 1) >> 1;
		colors = 16;
	}
	else {
		if (headerOffset + 800 >= contentLength)
			return FALSE;
		bytesPerLine = width;
		colors = 256;
	}
	msxMode = 0;
	switch (content[headerOffset + 1]) {
	case 0:
		resolution = (content[headerOffset + 3] & 1) == 0 ? RECOILResolution_PC981X1 : RECOILResolution_PC881X2;
		break;
	case 3:
		msxMode = content[headerOffset + 2];
		switch (msxMode) {
		case 0:
		case 20:
		case 84:
			resolution = RECOILResolution_MSX21X1;
			break;
		case 4:
			resolution = RECOILResolution_MSX21X2;
			break;
		case 36:
		case 68:
			if (colors == 16)
				width >>= 1;
			resolution = RECOILResolution_MSX2_PLUS1X1;
			break;
		default:
			return FALSE;
		}
		break;
	case 98:
	case 112:
		resolution = RECOILResolution_PC981X1;
		break;
	case 104:
		resolution = RECOILResolution_X68_K1X1;
		break;
	case 136:
		resolution = RECOILResolution_PC881X2;
		break;
	case 153:
		resolution = RECOILResolution_MACINTOSH1X1;
		break;
	default:
		resolution = RECOILResolution_MSX21X1;
		break;
	}
	if (!RECOIL_SetScaledSize(self, width, height, resolution))
		return FALSE;
	unpacked = (unsigned char *) malloc(bytesPerLine * height * sizeof(unsigned char ));
	if (!RECOIL_UnpackMag(content, headerOffset, contentLength, bytesPerLine, height, unpacked)) {
		free(unpacked);
		return FALSE;
	}
	RECOIL_SetMagPalette(self, content, headerOffset + 32, colors);
	switch (msxMode) {
	case 36:
		RECOIL_DecodeMsxYjkScreen(self, unpacked, 0, TRUE);
		break;
	case 68:
		RECOIL_DecodeMsxYjkScreen(self, unpacked, 0, FALSE);
		break;
	default:
		if (colors == 16)
			RECOIL_DecodeNibbles(self, unpacked, 0, bytesPerLine);
		else
			RECOIL_DecodeBytes(self, unpacked, 0);
		break;
	}
	free(unpacked);
	return TRUE;
}

static cibool RECOIL_DecodeMaki1(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset;
	int haveBuffer[8000];
	BitStream haveBlock;
	int xorYOffset;
	unsigned char indexBuffer[1280];
	if (contentLength < 1096 || content[40] != 0 || content[41] != 0 || content[42] != 0 || content[43] != 0 || content[44] != 2 || content[45] != 128 || content[46] != 1 || content[47] != 144)
		return FALSE;
	RECOIL_SetSize(self, 640, 400, RECOILResolution_PC981X1);
	RECOIL_SetMagPalette(self, content, 48, 16);
	contentOffset = 1096;
	BitStream_Construct(&haveBlock);
	haveBlock.base.content = content;
	haveBlock.base.contentOffset = 96;
	haveBlock.base.contentLength = 1096;
	{
		int i;
		for (i = 0; i < 8000; i++) {
			int have = 0;
			if (BitStream_ReadBit(&haveBlock) == 1) {
				if (contentOffset + 1 >= contentLength)
					return FALSE;
				have = (content[contentOffset] << 8) | content[contentOffset + 1];
				contentOffset += 2;
			}
			haveBuffer[i] = have;
		}
	}
	xorYOffset = content[6] == 65 ? 2 : 0;
	memset(indexBuffer, 0, sizeof(indexBuffer));
	{
		int y;
		for (y = 0; y < 400; y++) {
			{
				int x;
				for (x = 0; x < 320; x++) {
					int row = y & 3;
					int index = indexBuffer[(row ^ xorYOffset) * 320 + x];
					int pixelsOffset;
					if (((haveBuffer[(y & ~3) * 20 + (x >> 2)] >> (15 - (row << 2) - (x & 3))) & 1) != 0) {
						if (contentOffset >= contentLength)
							return FALSE;
						index ^= content[contentOffset++];
					}
					indexBuffer[row * 320 + x] = index;
					pixelsOffset = (y * 320 + x) << 1;
					self->pixels[pixelsOffset] = self->contentPalette[index >> 4];
					self->pixels[pixelsOffset + 1] = self->contentPalette[index & 15];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeMcMlt(RECOIL *self, unsigned char const *content, int contentLength, int bitmapOffset)
{
	if (contentLength != 12288)
		return FALSE;
	RECOIL_SetZx(self, RECOILResolution_SPECTRUM1X1);
	RECOIL_DecodeZx(self, content, bitmapOffset, 6144, 0, 0);
	return TRUE;
}

static cibool RECOIL_DecodeMch(RECOIL *self, unsigned char const *content, int contentLength)
{
	int columns;
	int bitmapLength;
	cibool sprites;
	AnticMode anticMode;
	RECOILResolution resolution;
	int gtiaMode;
	unsigned char frame[80640];
	MchRenderer gtia;
	switch (contentLength) {
	case 9840:
	case 28673:
		columns = 32;
		break;
	case 12000:
	case 30833:
		columns = 40;
		break;
	case 14160:
	case 32993:
		columns = 48;
		break;
	default:
		return FALSE;
	}
	bitmapLength = columns * 270;
	sprites = contentLength > bitmapLength + 1200;
	switch (content[0] & 3) {
	case 0:
		if (sprites && RECOIL_HasG2fRaster(content, bitmapLength + 6080, 6960, 30))
			return FALSE;
		anticMode = AnticMode_FIVE_COLOR;
		break;
	case 1:
		anticMode = AnticMode_FIVE_COLOR;
		break;
	case 2:
		if (sprites && RECOIL_HasG2fRaster(content, bitmapLength + 6080, 6960, 30))
			return FALSE;
		anticMode = AnticMode_FOUR_COLOR;
		break;
	default:
		return FALSE;
	}
	gtiaMode = 0;
	switch (content[0] & 60) {
	case 0:
		anticMode = AnticMode_HI_RES;
		resolution = RECOILResolution_XE1X1;
		break;
	case 4:
		resolution = RECOILResolution_XE2X1;
		break;
	case 8:
		anticMode = AnticMode_HI_RES;
		resolution = RECOILResolution_XE4X1;
		gtiaMode = 64;
		break;
	case 24:
		anticMode = AnticMode_HI_RES;
		resolution = RECOILResolution_XE4X1;
		gtiaMode = 128;
		break;
	case 40:
		anticMode = AnticMode_HI_RES;
		resolution = RECOILResolution_XE4X1;
		gtiaMode = 192;
		break;
	default:
		return FALSE;
	}
	RECOIL_SetSize(self, 336, 240, resolution);
	MchRenderer_Construct(&gtia, NULL);
	memset(gtia.base.playerHpos, 0, sizeof(gtia.base.playerHpos));
	memset(gtia.base.missileHpos, 0, sizeof(gtia.base.missileHpos));
	memset(gtia.base.colors, 0, sizeof(gtia.base.colors));
	gtia.base.prior = gtiaMode;
	gtia.base.content = content;
	gtia.base.playfieldColumns = columns;
	gtia.dliPlus = FALSE;
	{
		int i;
		for (i = 0; i < bitmapLength; i += 9) {
			if ((content[i] & 64) != 0) {
				gtia.dliPlus = TRUE;
				break;
			}
		}
	}
	{
		int y;
		for (y = 0; y < 240; y++) {
			int colorsOffset = bitmapLength + y;
			GtiaRenderer_SetG2fColors(&gtia.base, colorsOffset, 240, sprites ? 9 : 5, gtiaMode);
			if (sprites) {
				{
					int i;
					for (i = 0; i < 4; i++) {
						gtia.base.playerHpos[i] = content[colorsOffset + (9 + i) * 240];
						gtia.base.missileHpos[i] = content[colorsOffset + (13 + i) * 240];
					}
				}
				GtiaRenderer_SetSpriteSizes(gtia.base.playerSize, content[colorsOffset + 4080]);
				GtiaRenderer_SetSpriteSizes(gtia.base.missileSize, content[colorsOffset + 4320]);
				gtia.base.prior = gtiaMode | content[colorsOffset + 4560];
				GtiaRenderer_ProcessSpriteDma(&gtia.base, content, colorsOffset + 4800);
			}
			GtiaRenderer_StartLine(&gtia.base, 44);
			GtiaRenderer_DrawSpan(&gtia.base, y, 44, 212, anticMode, frame, 336);
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeMci(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 19434)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_C641X1);
	RECOIL_DecodeC64MulticolorFrame(self, content, 1026, 2, 18434, content[1002], 0);
	self->leftSkip = -1;
	RECOIL_DecodeC64MulticolorFrame(self, content, 9218, 17410, 18434, content[1002], 64000);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodeMcp(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 16008 && RECOIL_DecodeGr15Blend(self, content, 0, 16000, 200);
}

static cibool RECOIL_DecodeMcpp(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[64000];
	if (contentLength != 8008)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_XE2X2);
	RECOIL_SetPF012Bak(self, content, 8000);
	RECOIL_DecodeAtari8Gr15(self, content, 0, 40, frame, 0, 640, 100);
	RECOIL_SetPF012Bak(self, content, 8004);
	RECOIL_DecodeAtari8Gr15(self, content, 4000, 40, frame, 320, 640, 100);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeMcs(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if (contentLength != 10185)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X1);
	{
		int y;
		for (y = 0; y < 192; y++) {
			int fontOffset = 9 + (y / 24 << 10);
			{
				int x;
				for (x = 0; x < 320; x++) {
					int ch = content[8201 + (y >> 3) * 40 + (x >> 3)];
					int c;
					switch ((content[fontOffset + ((ch & 127) << 3) + (y & 7)] >> (~x & 6)) & 3) {
						int pmgBit;
						int pmgOffset;
					case 0:
						c = x / 80;
						pmgBit = (x >> 3) % 10;
						if (pmgBit < 8) {
							pmgBit = 7 - pmgBit;
							pmgOffset = 9305 + (c << 7);
						}
						else {
							pmgBit = (c << 1) | (pmgBit ^ 9);
							pmgOffset = 9177;
						}
						if (((content[pmgOffset + (y >> 1)] >> pmgBit) & 1) == 0)
							c = 8;
						break;
					case 1:
						c = 4;
						break;
					case 2:
						c = 5;
						break;
					default:
						c = 6 + (ch >> 7);
						break;
					}
					frame[y * 320 + x] = content[c] & 254;
				}
			}
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeMg(RECOIL *self, unsigned char const *content, int contentLength)
{
	int attributesMode;
	if (contentLength < 14080 || content[0] != 77 || content[1] != 71 || content[2] != 72 || content[3] != 1)
		return FALSE;
	switch (content[4]) {
	case 1:
		if (contentLength != 19456)
			return FALSE;
		RECOIL_SetZx(self, RECOILResolution_SPECTRUM1X1);
		RECOIL_DecodeZx(self, content, 256, 18688, -2, 0);
		RECOIL_DecodeZx(self, content, 6400, 19072, -2, 49152);
		return RECOIL_ApplyBlend(self);
	case 2:
		attributesMode = 1;
		break;
	case 4:
		attributesMode = 2;
		break;
	case 8:
		attributesMode = 3;
		break;
	default:
		return FALSE;
	}
	if (contentLength != 12544 + (12288 >> attributesMode))
		return FALSE;
	RECOIL_SetZx(self, RECOILResolution_SPECTRUM1X1);
	RECOIL_DecodeZx(self, content, 256, 12544, attributesMode, 0);
	RECOIL_DecodeZx(self, content, 6400, 12544 + (6144 >> attributesMode), attributesMode, 49152);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodeMgp(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	int rainbow;
	unsigned char bitmap[3840];
	if (contentLength != 3845)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X2);
	RECOIL_SetPF0123Bak(self, content, 0);
	rainbow = content[5];
	memcpy(bitmap + 0, content + 6, 3839);
	bitmap[3839] = 0;
	{
		int y;
		for (y = 0; y < 96; y++) {
			if (rainbow < 4) {
				self->gtiaColors[rainbow == 0 ? 8 : 3 + rainbow] = (16 + y) & 254;
			}
			RECOIL_DecodeAtari8Gr7(self, bitmap, y * 40, frame, y * 640, 1);
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeMic(RECOIL *self, unsigned char const *content, int contentLength)
{
	int height;
	unsigned char frame[76800];
	if (contentLength == 15872) {
		contentLength = 7680;
		RECOIL_SetPF012Bak(self, content, 7680);
	}
	else {
		switch (contentLength % 40) {
		case 0:
		case 3:
			RECOIL_SetGr15DefaultColors(self);
			break;
		case 4:
			RECOIL_SetBakPF012(self, content, contentLength - 4, 1);
			break;
		case 5:
			RECOIL_SetPF012Bak(self, content, contentLength - 5);
			break;
		default:
			return FALSE;
		}
	}
	height = contentLength / 40;
	if (height == 0 || height > 240)
		return FALSE;
	RECOIL_SetSize(self, 320, height, RECOILResolution_XE2X1);
	RECOIL_DecodeAtari8Gr15(self, content, 0, 40, frame, 0, 320, height);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeMis(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[960];
	if (contentLength != 61 && contentLength != 241)
		return FALSE;
	RECOIL_SetSize(self, 4, 240, RECOILResolution_XE2X1);
	{
		int y;
		for (y = 0; y < 240; y++) {
			int b = content[1 + (y >> 2)] >> ((~y & 3) << 1);
			frame[y * 4 + 1] = frame[y * 4] = (b & 2) == 0 ? 0 : content[0];
			frame[y * 4 + 3] = frame[y * 4 + 2] = (b & 1) == 0 ? 0 : content[0];
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeMle(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 4098)
		return FALSE;
	RECOIL_SetSize(self, 320, 56, RECOILResolution_C641X1);
	RECOIL_DecodeMleFrame(self, content, 2050, 0);
	self->leftSkip = -1;
	RECOIL_DecodeMleFrame(self, content, 2, 17920);
	return RECOIL_ApplyBlend(self);
}

static void RECOIL_DecodeMleFrame(RECOIL *self, unsigned char const *content, int contentOffset, int pixelsOffset)
{
	{
		int y;
		for (y = 0; y < 56; y++) {
			{
				int x;
				for (x = 0; x < 320; x++) {
					int c = 0;
					int i = x + self->leftSkip;
					if (i >= 0) {
						int ch = (y >> 3) * 40 + (i >> 3);
						if (ch < 256) {
							static const unsigned char colors[4] = { 0, 9, 8, 5 };
							c = colors[(content[contentOffset + (ch << 3) + (y & 7)] >> (~i & 6)) & 3];
						}
					}
					self->pixels[pixelsOffset + y * self->width + x] = RECOIL_C64Palette[c];
				}
			}
		}
	}
}

static cibool RECOIL_DecodeMono(RECOIL *self, unsigned char const *content, int contentOffset, int contentLength, cibool wordAlign)
{
	int contentStride = (self->width + 7) >> 3;
	if (wordAlign)
		contentStride += contentStride & 1;
	if (contentLength != contentOffset + contentStride * self->height)
		return FALSE;
	RECOIL_DecodeBitplanes(self, content, contentOffset, contentStride, 1, 0, self->width, self->height);
	return TRUE;
}

static cibool RECOIL_DecodeMpp(RECOIL *self, unsigned char const *content, int contentLength)
{
	int mode;
	int width;
	int height;
	static const unsigned char modeColorsPerLine[4] = { 52, 46, 54, 48 };
	int paletteLength;
	int paletteOffset;
	int pixelsLength;
	if (contentLength < 12 || content[0] != 77 || content[1] != 80 || content[2] != 80)
		return FALSE;
	mode = content[3];
	if (mode > 3)
		return FALSE;
	width = mode < 3 ? 320 : 416;
	height = mode < 3 ? 199 : 273;
	paletteLength = modeColorsPerLine[mode] * height;
	switch (content[4] & 3) {
	case 0:
		RECOIL_SetSize(self, width, height, RECOILResolution_ST1X1);
		paletteLength *= 9;
		break;
	case 1:
		RECOIL_SetSize(self, width, height, RECOILResolution_STE1X1);
		paletteLength *= 12;
		break;
	case 3:
		RECOIL_SetSize(self, width, height, RECOILResolution_STE1X1);
		self->frames = 2;
		paletteLength *= 15;
		break;
	default:
		return FALSE;
	}
	paletteLength = (paletteLength + 15) >> 4 << 1;
	paletteOffset = 12 + RECOIL_Get32BigEndian(content, 8);
	if (paletteOffset < 12)
		return FALSE;
	pixelsLength = width * height;
	if (contentLength != paletteOffset + ((paletteLength + (pixelsLength >> 1)) << ((content[4] >> 2) & 1)))
		return FALSE;
	RECOIL_DecodeMppScreen(self, content, paletteOffset, paletteLength, 0);
	if ((content[4] & 4) == 0)
		return TRUE;
	RECOIL_DecodeMppScreen(self, content, paletteOffset + paletteLength + (pixelsLength >> 1), paletteLength, pixelsLength);
	return RECOIL_ApplyBlend(self);
}

static void RECOIL_DecodeMppScreen(RECOIL *self, unsigned char const *content, int paletteOffset, int paletteLength, int pixelsOffset)
{
	int mode = content[3];
	int bitmapOffset = paletteOffset + paletteLength;
	int palette[16];
	MppPaletteStream paletteStream;
	memset(palette, 0, sizeof(palette));
	MppPaletteStream_Construct(&paletteStream);
	paletteStream.base.base.content = content;
	paletteStream.base.base.contentOffset = paletteOffset;
	paletteStream.base.base.contentLength = bitmapOffset;
	{
		int y;
		for (y = 0; y < self->height; y++) {
			static const unsigned char firstChangeX[4] = { 33, 9, 4, 69 };
			int changeX;
			int changeColor;
			{
				int c;
				for (c = mode == 3 ? 6 : 1; c < 16; c++)
					palette[c] = MppPaletteStream_Read(&paletteStream);
			}
			changeX = firstChangeX[mode];
			changeColor = 0;
			{
				int x;
				for (x = 0; x < self->width; x++) {
					if (x == changeX) {
						static const unsigned char rightBorderColor[4] = { 32, 16, 32, 127 };
						palette[changeColor & 15] = changeColor == rightBorderColor[mode] ? 0 : MppPaletteStream_Read(&paletteStream);
						switch (mode) {
						case 0:
						case 3:
							switch (changeColor) {
							case 15:
								changeX += mode == 0 ? 88 : 112;
								break;
							case 31:
								changeX += 12;
								break;
							case 37:
								changeX += 100;
								break;
							default:
								changeX += 4;
								break;
							}
							break;
						case 1:
							changeX += (changeColor & 1) == 0 ? 4 : 16;
							break;
						case 2:
							changeX += 8;
							break;
						}
						changeColor++;
					}
					self->pixels[pixelsOffset + x] = palette[RECOIL_GetStLowColor(content, bitmapOffset, x)];
				}
			}
			bitmapOffset += self->width >> 1;
			pixelsOffset += self->width;
		}
	}
}

static cibool RECOIL_DecodeMsp(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	if (contentLength < 32)
		return FALSE;
	width = content[4] | (content[5] << 8);
	height = content[6] | (content[7] << 8);
	if (RECOIL_IsStringAt(content, 0, "DanM"))
		return RECOIL_SetSize(self, width, height, RECOILResolution_PC1X1) && RECOIL_DecodeBlackAndWhite(self, content, 32, contentLength, FALSE, 0);
	if (RECOIL_IsStringAt(content, 0, "LinS") && RECOIL_SetSize(self, width, height, RECOILResolution_PC1X1)) {
		MspStream rle;
		MspStream_Construct(&rle, NULL);
		rle.base.base.base.content = content;
		rle.base.base.base.contentOffset = 32 + (height << 1);
		rle.base.base.base.contentLength = contentLength;
		return RECOIL_DecodeRleBlackAndWhite(self, &rle.base, 0);
	}
	return FALSE;
}

static void RECOIL_DecodeMsx5(RECOIL *self, unsigned char const *content)
{
	RECOIL_SetSize(self, 256, 212, RECOILResolution_MSX21X1);
	RECOIL_DecodeNibbles(self, content, 7, 128);
}

static cibool RECOIL_DecodeMsx6(RECOIL *self, unsigned char const *content, int contentOffset)
{
	{
		int y;
		for (y = 0; y < self->height; y++) {
			{
				int x;
				for (x = 0; x < self->width; x++) {
					int offset = (y >> 1) * self->width + x;
					int b = content[contentOffset + (offset >> 2)];
					self->pixels[y * self->width + x] = self->contentPalette[(b >> ((~offset & 3) << 1)) & 3];
				}
			}
		}
	}
	return TRUE;
}

static void RECOIL_DecodeMsx7(RECOIL *self, unsigned char const *content)
{
	RECOIL_SetSize(self, 512, 424, RECOILResolution_MSX21X2);
	RECOIL_DecodeNibbles(self, content, 7, 256);
}

static void RECOIL_DecodeMsxSprites(RECOIL *self, unsigned char const *content, int mode, int attributesOffset, int patternsOffset)
{
	int height = mode <= 4 ? 192 : 212;
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int x;
				for (x = 0; x < 256; x++) {
					int color = 0;
					cibool enableOr = FALSE;
					int spritesPerLine = mode >= 4 ? 8 : 4;
					{
						int sprite;
						for (sprite = 0; sprite < 32; sprite++) {
							int attributeOffset = attributesOffset + (sprite << 2);
							int spriteY = content[attributeOffset];
							int row;
							int c;
							int column;
							int pattern;
							if (spriteY == (mode >= 4 ? 216 : 208))
								break;
							row = (y - spriteY - 1) & 255;
							if (row >= 16)
								continue;
							if (--spritesPerLine < 0)
								break;
							c = content[mode >= 4 ? attributesOffset - 512 + (sprite << 4) + row : attributeOffset + 3];
							if (mode < 4 || (c & 64) == 0) {
								if (color != 0)
									break;
								enableOr = TRUE;
							}
							else if (!enableOr)
								continue;
							column = x - content[attributeOffset + 1];
							if (c >= 128)
								column += 32;
							if (column < 0 || column >= 16)
								continue;
							pattern = patternsOffset + ((content[attributeOffset + 2] & 252) << 3) + row;
							if (((content[pattern + ((column & 8) << 1)] >> (~column & 7)) & 1) == 0)
								continue;
							color |= c;
							if (mode >= 4)
								color |= 16;
						}
					}
					if (color != 0) {
						int offset;
						switch (mode) {
						case 6:
							offset = (y << 10) + (x << 1);
							self->pixels[offset + 512] = self->pixels[offset] = self->contentPalette[(color >> 2) & 3];
							self->pixels[offset + 513] = self->pixels[offset + 1] = self->contentPalette[color & 3];
							break;
						case 7:
							offset = (y << 10) + (x << 1);
							self->pixels[offset + 513] = self->pixels[offset + 512] = self->pixels[offset + 1] = self->pixels[offset] = self->contentPalette[color & 15];
							break;
						default:
							self->pixels[(y << 8) + x] = self->contentPalette[color & 15];
							break;
						}
					}
				}
			}
		}
	}
}

static int RECOIL_DecodeMsxYjk(RECOIL const *self, unsigned char const *content, int contentOffset, int x, cibool usePalette)
{
	int y = content[contentOffset + x] >> 3;
	int rgb;
	if (usePalette && (y & 1) != 0)
		return self->contentPalette[y >> 1];
	if ((x | 3) >= self->width) {
		rgb = y * 65793;
	}
	else {
		int k;
		int j;
		int r;
		int g;
		int b;
		x = contentOffset + (x & ~3);
		k = (content[x] & 7) | ((content[x + 1] & 7) << 3);
		j = (content[x + 2] & 7) | ((content[x + 3] & 7) << 3);
		k -= (k & 32) << 1;
		j -= (j & 32) << 1;
		r = y + j;
		if (r < 0)
			r = 0;
		else if (r > 31)
			r = 31;
		g = y + k;
		if (g < 0)
			g = 0;
		else if (g > 31)
			g = 31;
		b = (((5 * y - k) >> 1) - j) >> 1;
		if (b < 0)
			b = 0;
		else if (b > 31)
			b = 31;
		rgb = (r << 16) | (g << 8) | b;
	}
	return (rgb << 3) | ((rgb >> 2) & 460551);
}

static void RECOIL_DecodeMsxYjkScreen(RECOIL *self, unsigned char const *content, int contentOffset, cibool usePalette)
{
	{
		int y;
		for (y = 0; y < self->height; y++)
			{
				int x;
				for (x = 0; x < self->width; x++)
					self->pixels[y * self->width + x] = RECOIL_DecodeMsxYjk(self, content, contentOffset + y * self->width, x, usePalette);
			}
	}
}

static cibool RECOIL_DecodeMur(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	unsigned char pal[97];
	if (contentLength != 32000)
		return FALSE;
	if (RECOIL_ReadCompanionFile(self, filename, "PAL", "pal", pal, 97) != 96)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_STE1X1);
	RECOIL_SetStVdiPalette(self, pal, 0, 16, 4);
	RECOIL_DecodeBitplanes(self, content, 0, 160, 4, 0, 320, 200);
	return TRUE;
}

static cibool RECOIL_DecodeNeo(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 32128:
		if (content[0] != 0 || content[1] != 0 || content[2] != 0)
			return FALSE;
		if (content[3] == 0) {
			unsigned char rst[6801];
			if (RECOIL_ReadCompanionFile(self, filename, "RST", "rst", rst, 6801) == 6800) {
				RastPalette palette;
				RECOIL_SetSize(self, 320, 200, RECOILResolution_ST1X1);
				RECOIL_SetStPalette(self, content, 4, 16);
				RastPalette_Construct(&palette, NULL);
				palette.base.base.base.content = rst;
				palette.base.base.base.contentOffset = 0;
				palette.base.base.base.contentLength = 6800;
				RECOIL_DecodeScaledBitplanes(self, content, 128, 320, 200, 4, FALSE, &palette.base);
				return TRUE;
			}
		}
		return RECOIL_DecodeSt(self, content, 128, content, 4, content[3], 0);
	case 128128:
		return content[0] == 186 && content[1] == 190 && content[2] == 0 && content[3] == 0 && RECOIL_DecodeStLow(self, content, 128, content, 4, 640, 400);
	default:
		return FALSE;
	}
}

static void RECOIL_DecodeNibbles(RECOIL *self, unsigned char const *content, int contentOffset, int contentStride)
{
	int doubleHeight = self->resolution == RECOILResolution_MSX21X2 || self->resolution == RECOILResolution_PC881X2 ? 1 : 0;
	{
		int y;
		for (y = 0; y < self->height;) {
			{
				int x;
				for (x = 0; x < self->width; x++)
					self->pixels[y * self->width + x] = self->contentPalette[RECOIL_GetNibble(content, contentOffset, x)];
			}
			if ((++y & doubleHeight) == 0)
				contentOffset += contentStride;
		}
	}
}

static cibool RECOIL_DecodeNlq(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[30720];
	int contentOffset;
	if (contentLength < 379 || !RECOIL_IsStringAt(content, 0, "DAISY-DOT NLQ FONT") || content[18] != 155)
		return FALSE;
	RECOIL_SetSize(self, 320, 96, RECOILResolution_XE1X1);
	memset(frame, 0, sizeof(frame));
	contentOffset = 19;
	{
		int i;
		for (i = 0; i < 91; i++) {
			int width;
			int nextContentOffset;
			int c;
			if (contentOffset >= contentLength)
				return FALSE;
			width = content[contentOffset];
			if (width == 0 || width > 19)
				return FALSE;
			nextContentOffset = contentOffset + (width + 1) * 2;
			if (nextContentOffset > contentLength || content[nextContentOffset - 1] != 155)
				return FALSE;
			c = i < 64 ? i : i < 90 ? i + 1 : 92;
			{
				int y;
				for (y = 0; y < 16; y++) {
					{
						int x;
						for (x = 0; x < width; x++) {
							int b = (content[contentOffset + 1 + (y & 1) * width + x] >> (7 - (y >> 1))) & 1;
							frame[((c & 240) | y) * 320 + (c & 15) * 20 + x] = b == 0 ? 0 : 14;
						}
					}
				}
			}
			contentOffset = nextContentOffset;
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeOcp(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 10018 && RECOIL_DecodeC64Multicolor(self, 320, content, 2, 8002, 9018, content[9003]);
}

static cibool RECOIL_DecodeP(RECOIL *self, unsigned char const *content, int contentLength)
{
	PInterpreter interp;
	interp.base.content = content;
	interp.base.contentLength = contentLength;
	return PInterpreter_Run(&interp) && RECOIL_DecodeZx81(self, interp.screen);
}

static cibool RECOIL_DecodeP11(RECOIL *self, unsigned char const *content, int contentLength)
{
	if ((contentLength != 3083 && contentLength != 3243) || content[0] != 0 || content[1] != 12 || content[3] != 14 || content[4] != 0)
		return FALSE;
	RECOIL_SetSize(self, 256, 192, RECOILResolution_COCO2X2);
	{
		int y;
		for (y = 0; y < 192; y++) {
			{
				int x;
				for (x = 0; x < 256; x++) {
					static const int palette[4] = { 524032, 16776960, 3868927, 13369403 };
					int c = (content[5 + ((y & ~1) << 4) + (x >> 3)] >> (~x & 6)) & 3;
					self->pixels[(y << 8) + x] = palette[c];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeP3c(RECOIL *self, unsigned char const *content, int contentLength)
{
	CaStream rle;
	int compressedLength;
	int paletteOffset;
	unsigned char unpacked[64000];
	CaStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 0;
	rle.base.base.base.contentLength = contentLength;
	compressedLength = Stream_ParseInt(&rle.base.base.base);
	if (compressedLength < 0)
		return FALSE;
	paletteOffset = rle.base.base.base.contentOffset;
	rle.base.base.base.contentLength = paletteOffset + 32 + compressedLength;
	if (rle.base.base.base.contentLength >= contentLength)
		return FALSE;
	rle.base.base.base.contentOffset = paletteOffset + 32;
	if (!CaStream_UnpackCa(&rle, unpacked, 0))
		return FALSE;
	rle.base.base.base.contentLength = contentLength;
	compressedLength = Stream_ParseInt(&rle.base.base.base);
	if (compressedLength < 0 || rle.base.base.base.contentOffset + compressedLength != contentLength)
		return FALSE;
	rle.base.base.base.contentLength = contentLength;
	return CaStream_UnpackCa(&rle, unpacked, 32000) && RECOIL_DecodeStLowBlend(self, unpacked, 0, content, paletteOffset, 320, 200);
}

static cibool RECOIL_DecodeP4i(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 10050:
		if (RECOIL_IsStringAt(content, 1020, "MULT")) {
			RECOIL_SetSize(self, 320, 200, RECOILResolution_C162X1);
			RECOIL_SetC16Palette(self);
			{
				int y;
				for (y = 0; y < 200; y++) {
					{
						int x;
						for (x = 0; x < 320; x++) {
							int offset = (y & ~7) * 40 + (x & ~7) + (y & 7);
							int c = (content[2050 + offset] >> (~x & 6)) & 3;
							switch (c) {
							case 0:
								c = content[1025];
								break;
							case 1:
								offset >>= 3;
								c = (content[1026 + offset] & 240) | (content[2 + offset] & 7);
								break;
							case 2:
								offset >>= 3;
								c = ((content[1026 + offset] & 15) << 4) | (content[2 + offset] >> 4);
								break;
							default:
								c = content[1024];
								break;
							}
							self->pixels[y * 320 + x] = self->contentPalette[c];
						}
					}
				}
			}
		}
		else {
			RECOIL_SetSize(self, 320, 200, RECOILResolution_C161X1);
			RECOIL_SetC16Palette(self);
			{
				int y;
				for (y = 0; y < 200; y++) {
					{
						int x;
						for (x = 0; x < 320; x++) {
							int offset = (y & ~7) * 40 + (x & ~7) + (y & 7);
							int c = (content[2050 + offset] >> (~x & 7)) & 1;
							offset >>= 3;
							if (c == 0)
								c = ((content[1026 + offset] & 15) << 4) | (content[2 + offset] >> 4);
							else
								c = (content[1026 + offset] & 240) | (content[2 + offset] & 7);
							self->pixels[y * 320 + x] = self->contentPalette[c];
						}
					}
				}
			}
		}
		break;
	case 2050:
		RECOIL_SetSize(self, 256, 64, RECOILResolution_C162X1);
		RECOIL_SetC16Palette(self);
		{
			int y;
			for (y = 0; y < 64; y++) {
				{
					int x;
					for (x = 0; x < 256; x++) {
						static const unsigned char logoColors[4] = { 0, 19, 21, 23 };
						int c = logoColors[(content[2 + ((x & ~7) << 3) + y] >> (~x & 6)) & 3];
						self->pixels[(y << 8) + x] = self->contentPalette[c];
					}
				}
			}
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

static cibool RECOIL_DecodePac(RECOIL *self, unsigned char const *content, int contentLength)
{
	int unpackedStride;
	PacStream rle;
	unsigned char unpacked[32000];
	if (contentLength < 8 || content[0] != 112 || content[1] != 77 || content[2] != 56)
		return FALSE;
	switch (content[3]) {
	case 53:
		unpackedStride = 1;
		break;
	case 54:
		unpackedStride = 80;
		break;
	default:
		return FALSE;
	}
	PacStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 7;
	rle.base.base.base.contentLength = contentLength;
	return RleStream_UnpackColumns(&rle.base, unpacked, 0, unpackedStride, 32000) && RECOIL_DecodeDoo(self, unpacked, 32000);
}

static cibool RECOIL_DecodePbx(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength < 128 || content[0] != 0 || content[1] != 0 || content[2] != 0)
		return FALSE;
	switch (content[3]) {
	case 0:
		RECOIL_SetSize(self, 320, 200, RECOILResolution_ST1X1);
		return RECOIL_DecodePbx01(self, content, contentLength, 4, 1);
	case 1:
		RECOIL_SetSize(self, 640, 400, RECOILResolution_ST1X2);
		return RECOIL_DecodePbx01(self, content, contentLength, 2, 2);
	case 128:
		{
			unsigned char unpacked[44928];
			content = RECOIL_UnpackPbx(self, content, contentLength, unpacked, 12928, 8, 44928);
			if (content == NULL)
				return FALSE;
			RECOIL_SetSize(self, 320, 200, RECOILResolution_ST1X1);
			RECOIL_DecodePbx8(self, content, 128, 12928, 0);
			return TRUE;
		}
	case 129:
		{
			unsigned char unpacked[57728];
			content = RECOIL_UnpackPbx(self, content, contentLength, unpacked, 25728, 8, 57728);
			if (content == NULL)
				return FALSE;
			RECOIL_SetSize(self, 320, 200, RECOILResolution_ST1X1);
			RECOIL_DecodePbx8(self, content, 128, 25728, 0);
			RECOIL_DecodePbx8(self, content, 12928, 25728, 64000);
			return RECOIL_ApplyBlend(self);
		}
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodePbx01(RECOIL *self, unsigned char const *content, int contentLength, int bitplanes, int lineHeight)
{
	unsigned char unpacked[32512];
	int paletteOffset;
	content = RECOIL_UnpackPbx(self, content, contentLength, unpacked, 512, bitplanes << 1, 32512);
	if (content == NULL || content[161] != 0)
		return FALSE;
	paletteOffset = 128;
	{
		int y;
		for (y = 0; y < 200; y++) {
			if (paletteOffset < 512 && y == content[paletteOffset + 33]) {
				RECOIL_SetStPalette(self, content, paletteOffset, 16);
				do
					paletteOffset += 48;
				while (paletteOffset < 512 && content[paletteOffset + 34] == 0 && content[paletteOffset + 35] == 0);
			}
			RECOIL_DecodeBitplanes(self, content, 512 + y * 160, 0, bitplanes, y * lineHeight * self->width, self->width, lineHeight);
		}
	}
	return TRUE;
}

static void RECOIL_DecodePbx8(RECOIL *self, unsigned char const *content, int paletteOffset, int bitmapOffset, int pixelsOffset)
{
	{
		int y;
		for (y = 0; y < 200; y++) {
			{
				int x;
				for (x = 0; x < 320; x++) {
					int c = RECOIL_GetStLowColor(content, bitmapOffset + y * 160, x);
					if (x >= (c > 7 ? 88 : 76) + c * 10 - (c & 1) * 6)
						c += 16;
					self->pixels[pixelsOffset + x] = RECOIL_GetStColor(self, content, paletteOffset + (y << 6) + (c << 1));
				}
			}
			pixelsOffset += 320;
		}
	}
}

static cibool RECOIL_DecodePc(RECOIL *self, unsigned char const *content, int contentLength)
{
	int bitplanes;
	PackBitsStream rle;
	unsigned char unpacked[32000];
	if (contentLength < 68 || content[0] != 128 || content[1] > 2)
		return FALSE;
	bitplanes = 4 >> content[1];
	PackBitsStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 34;
	rle.base.base.base.contentLength = contentLength;
	return PackBitsStream_UnpackBitplaneLines(&rle, unpacked, 320 << content[1], 200, bitplanes, TRUE, FALSE) && RECOIL_DecodeSt(self, unpacked, 0, content, 2, content[1], 0);
}

static cibool RECOIL_DecodePci(RECOIL *self, unsigned char const *content, int contentLength)
{
	int bitmapOffset;
	if (contentLength != 115648)
		return FALSE;
	RECOIL_SetSize(self, 352, 278, RECOIL_IsStePalette(content, 97856, 8896) ? RECOILResolution_STE1X1 : RECOILResolution_ST1X1);
	bitmapOffset = 0;
	{
		int y;
		for (y = 0; y < 556; y++) {
			if (y == 278)
				bitmapOffset = 48928;
			RECOIL_SetStPalette(self, content, 97856 + (y << 5), 16);
			{
				int x;
				for (x = 0; x < 352; x++)
					self->pixels[y * 352 + x] = self->contentPalette[RECOIL_GetStLowSeparateBitplanes(content, bitmapOffset, 12232, x)];
			}
			bitmapOffset += 44;
		}
	}
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodePcs(RECOIL *self, unsigned char const *content, int contentLength)
{
	PcsStream rle;
	unsigned char unpacked1[51232];
	unsigned char unpacked2[51232];
	if (contentLength < 18 || content[0] != 1 || content[1] != 64 || content[2] != 0 || content[3] != 200)
		return FALSE;
	PcsStream_Construct(&rle, NULL);
	rle.base.base.base.base.content = content;
	rle.base.base.base.base.contentOffset = 6;
	rle.base.base.base.base.contentLength = contentLength;
	if (!PcsStream_UnpackPcs(&rle, unpacked1))
		return FALSE;
	RECOIL_SetSize(self, 320, 199, RECOIL_IsStePalette(unpacked1, 32000, 9616) ? RECOILResolution_STE1X1 : RECOILResolution_ST1X1);
	RECOIL_DecodePcsScreen(self, unpacked1, 0);
	if (content[4] == 0)
		return TRUE;
	rle.base.base.repeatCount = 0;
	if (!PcsStream_UnpackPcs(&rle, unpacked2))
		return FALSE;
	if ((content[4] & 1) == 0) {
		{
			int i;
			for (i = 0; i < 32000; i++)
				unpacked2[i] ^= unpacked1[i];
		}
	}
	if ((content[4] & 2) == 0) {
		{
			int i;
			for (i = 32000; i < 51232; i++)
				unpacked2[i] ^= unpacked1[i];
		}
	}
	RECOIL_DecodePcsScreen(self, unpacked2, 63680);
	return RECOIL_ApplyBlend(self);
}

static void RECOIL_DecodePcsScreen(RECOIL *self, unsigned char const *unpacked, int pixelsOffset)
{
	{
		int y;
		for (y = 0; y < 199; y++) {
			{
				int x;
				for (x = 0; x < 320; x++) {
					int c = RECOIL_GetStLowSeparateBitplanes(unpacked, 40 + y * 40, 8000, x) << 1;
					if (x >= c * 2) {
						if (c < 28) {
							if (x >= c * 2 + 76) {
								if (x >= 176 + c * 5 - (c & 2) * 3)
									c += 32;
								c += 32;
							}
						}
						else if (x >= c * 2 + 92)
							c += 32;
						c += 32;
					}
					self->pixels[pixelsOffset++] = RECOIL_GetStColor(self, unpacked, 32000 + y * 96 + c);
				}
			}
		}
	}
}

static cibool RECOIL_DecodePct(RECOIL *self, unsigned char const *content, int contentLength)
{
	int height;
	int contentOffset;
	CciStream rle;
	if (contentLength < 384 || (!RECOIL_IsStringAt(content, 0, "DYNAMIC") && !RECOIL_IsStringAt(content, 0, "E U R O")) || !RECOIL_IsStringAt(content, 7, " PUBLISHER "))
		return FALSE;
	if (RECOIL_IsStringAt(content, 18, "SCREEN")) {
		height = 704;
		contentOffset = 384;
	}
	else if (RECOIL_IsStringAt(content, 18, "FONT")) {
		height = 160;
		contentOffset = 512;
	}
	else
		return FALSE;
	RECOIL_SetSize(self, 512, height << 1, RECOILResolution_MSX21X2);
	CciStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = contentOffset;
	rle.base.base.base.contentLength = contentLength;
	{
		int y;
		for (y = 0; y < height; y++) {
			int b = 0;
			{
				int x;
				for (x = 0; x < 512; x++) {
					int offset;
					if ((x & 7) == 0) {
						b = RleStream_ReadRle(&rle.base);
						if (b < 0)
							return FALSE;
					}
					offset = (y << 10) + x;
					self->pixels[offset + 512] = self->pixels[offset] = ((b >> ((x ^ 3) & 7)) & 1) == 0 ? 16777215 : 0;
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodePet(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char const *font;
	if (contentLength != 2026)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_C641X1);
	font = CiBinaryResource_c64_fnt;
	{
		int y;
		for (y = 0; y < 200; y++) {
			{
				int x;
				for (x = 0; x < 320; x++) {
					int offset = (y & ~7) * 5 + (x >> 3);
					if (((font[(content[2 + offset] << 3) | (y & 7)] >> (~x & 7)) & 1) == 0)
						offset = 1003;
					else
						offset += 1026;
					self->pixels[y * 320 + x] = RECOIL_C64Palette[content[offset] & 15];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodePgc(RECOIL *self, unsigned char const *content, int contentLength)
{
	PgcStream rle;
	if (contentLength < 33 || content[0] != 80 || content[1] != 71 || content[2] != 1)
		return FALSE;
	RECOIL_SetSize(self, 240, 64, RECOILResolution_PORTFOLIO1X1);
	PgcStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 3;
	rle.base.base.base.contentLength = contentLength;
	return RECOIL_DecodeRleBlackAndWhite(self, &rle.base, 16777215);
}

static cibool RECOIL_DecodePgf(RECOIL *self, unsigned char const *content, int contentLength)
{
	RECOIL_SetSize(self, 240, 64, RECOILResolution_PORTFOLIO1X1);
	return RECOIL_DecodeBlackAndWhite(self, content, 0, contentLength, FALSE, 16777215);
}

static cibool RECOIL_DecodePgr(RECOIL *self, unsigned char const *content, int contentLength)
{
	PgrRenderer gtia;
	int dmaCtl;
	int dlOffset;
	int rasterOffset;
	int a;
	unsigned char frame[80640];
	RECOILResolution resolution;
	if (contentLength < 1776 || 6 + RECOIL_ParseAtari8ExecutableHeader(content, 0) != contentLength || content[2] != 6 || content[3] != 130 || !RECOIL_IsStringAt(content, 8, "PowerGFX"))
		return FALSE;
	PgrRenderer_Construct(&gtia, NULL);
	{
		int i;
		for (i = 0; i < 14; i++) {
			GtiaRenderer_Poke(&gtia.base, i, content[504 + i]);
			GtiaRenderer_Poke(&gtia.base, 14 + i, content[760 + i]);
		}
	}
	gtia.base.content = content;
	dmaCtl = content[774];
	switch (dmaCtl & 243) {
	case 49:
		gtia.base.playfieldColumns = 32;
		break;
	case 50:
		gtia.base.playfieldColumns = 40;
		break;
	default:
		return FALSE;
	}
	dlOffset = 16;
	rasterOffset = content[6] + (content[7] << 8) - 33280;
	if (rasterOffset < 1536)
		return FALSE;
	gtia.screenOffset = -1;
	a = 0;
	resolution = RECOILResolution_XE4X1;
	{
		int y;
		for (y = 0; y < 240; y++) {
			int dlOp = content[dlOffset++];
			AnticMode anticMode;
			switch (dlOp) {
			case 0:
			case 14:
			case 15:
				break;
			case 65:
				dlOffset--;
				break;
			case 78:
			case 79:
				gtia.screenOffset = content[dlOffset] + (content[dlOffset + 1] << 8) - 33280;
				dlOffset += 2;
				break;
			default:
				return FALSE;
			}
			switch (dlOp & 15) {
			case 14:
				anticMode = AnticMode_FOUR_COLOR;
				if (resolution == RECOILResolution_XE4X1 && gtia.base.prior < 64)
					resolution = RECOILResolution_XE2X1;
				break;
			case 15:
				anticMode = AnticMode_HI_RES;
				if (gtia.base.prior < 64)
					resolution = RECOILResolution_XE1X1;
				break;
			default:
				anticMode = AnticMode_BLANK;
				break;
			}
			if (anticMode != AnticMode_BLANK && (gtia.screenOffset < 1536 || gtia.screenOffset + 40 > contentLength))
				return FALSE;
			GtiaRenderer_StartLine(&gtia.base, 44);
			if ((dmaCtl & 4) != 0)
				gtia.base.missileGraphics = content[264 + y];
			if ((dmaCtl & 8) != 0) {
				{
					int i;
					for (i = 0; i < 4; i++)
						gtia.base.playerGraphics[i] = content[520 + (i << 8) + y];
				}
			}
			for (;;) {
				int rasterOp;
				int addr;
				if (rasterOffset >= contentLength)
					return FALSE;
				rasterOp = content[rasterOffset++];
				if ((rasterOp & 32) != 0) {
					if (rasterOffset >= contentLength)
						return FALSE;
					a = content[rasterOffset++];
				}
				addr = rasterOp & 31;
				if (addr <= 27) {
					GtiaRenderer_Poke(&gtia.base, addr, a);
					if (rasterOp >= 128)
						break;
				}
				else {
					int nops = ((rasterOp >> 6) & 3) | ((rasterOp & 3) << 2);
					if (nops == 0)
						break;
				}
			}
			GtiaRenderer_DrawSpan(&gtia.base, y, 44, 212, anticMode, frame, 336);
			if (anticMode != AnticMode_BLANK)
				gtia.screenOffset += gtia.base.playfieldColumns;
		}
	}
	RECOIL_SetSize(self, 336, 240, resolution);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodePic(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[7680];
	if (RECOIL_DecodeX68KPic(self, content, contentLength))
		return TRUE;
	if (XeKoalaStream_UnpackWrapped(content, contentLength, unpacked, 7680)) {
		unsigned char frame[61440];
		RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X1);
		RECOIL_SetPF0123Bak(self, content, 13);
		RECOIL_DecodeAtari8Gr15(self, unpacked, 0, 40, frame, 0, 320, 192);
		return RECOIL_ApplyAtari8Palette(self, frame);
	}
	if (contentLength == 7680)
		return RECOIL_DecodeGr8(self, content, contentLength);
	if (contentLength >= 7681 && contentLength <= 7685)
		return RECOIL_DecodeMic(self, content, contentLength);
	return RECOIL_DecodeDoo(self, content, contentLength) || RECOIL_DecodeStPi(self, content, contentLength) || RECOIL_DecodeSc8(self, NULL, content, contentLength) || RECOIL_DecodeGad(self, content, contentLength);
}

static cibool RECOIL_DecodePl4(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[64070];
	if (!RECOIL_UnpackLz4(self, content, contentLength, unpacked, 64070) || unpacked[0] != 0 || unpacked[1] != 0 || unpacked[32036] != 0 || unpacked[32037] != 0)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOIL_IsStePalette(unpacked, 2, 16) || RECOIL_IsStePalette(unpacked, 32038, 16) ? RECOILResolution_STE1X1 : RECOILResolution_ST1X1);
	RECOIL_SetStPalette(self, unpacked, 2, 16);
	RECOIL_DecodeBitplanes(self, unpacked, 34, 160, 4, 0, 320, 200);
	RECOIL_SetStPalette(self, unpacked, 32038, 16);
	RECOIL_DecodeBitplanes(self, unpacked, 32070, 160, 4, 64000, 320, 200);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodePla(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[3840];
	if (contentLength != 241)
		return FALSE;
	RECOIL_SetSize(self, 16, 240, RECOILResolution_XE2X1);
	memset(frame, 0, sizeof(frame));
	RECOIL_DecodeAtari8Player(self, content, 1, content[0], frame, 0, 240);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static void RECOIL_DecodePlayStation(unsigned char const *content, int contentOffset, int *pixels, int pixelsLength)
{
	{
		int i;
		for (i = 0; i < pixelsLength; i++)
			pixels[i] = RECOIL_GetB5G5R5Color(content[contentOffset + (i << 1)] | (content[contentOffset + (i << 1) + 1] << 8));
	}
}

static cibool RECOIL_DecodePmd(RECOIL *self, unsigned char const *content, int contentLength)
{
	int sprites;
	int shapes;
	int totalShapes;
	int height;
	int rows;
	unsigned char frame[179200];
	if (contentLength < 12 || content[0] != 240 || content[1] != 237 || content[2] != 228)
		return FALSE;
	sprites = content[7];
	shapes = content[8] * content[9];
	totalShapes = sprites * shapes;
	height = content[10];
	if (sprites == 0 || sprites > 4 || shapes == 0 || shapes > 160 || height == 0 || height > 48 || 11 + totalShapes * height != contentLength)
		return FALSE;
	if (TRUE)
		totalShapes >>= 1;
	rows = (totalShapes + 15) >> 4;
	if (rows == 1)
		RECOIL_SetSize(self, totalShapes * 20, height, RECOILResolution_XE2X1);
	else {
		int totalHeight = rows * (height + 2) - 2;
		if (totalHeight > 560)
			return FALSE;
		RECOIL_SetSize(self, 320, totalHeight, RECOILResolution_XE2X1);
	}
	memset(frame, 0, sizeof(frame));
	{
		int shape;
		for (shape = 0; shape < totalShapes; shape++) {
			int frameOffset = (shape >> 4) * (height + 2) * 320 + (shape & 15) * 20;
			if (TRUE) {
				int spritePair = shape / shapes;
				int contentOffset = 11 + (spritePair * shapes + shape) * height;
				RECOIL_DecodeAtari8Player(self, content, contentOffset, content[3 + spritePair * 2], frame, frameOffset, height);
				RECOIL_DecodeAtari8Player(self, content, contentOffset + shapes * height, content[4 + spritePair * 2], frame, frameOffset, height);
			}
			else
				RECOIL_DecodeAtari8Player(self, content, 11 + shape * height, content[3 + shape / shapes], frame, frameOffset, height);
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodePmg(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 9332 && RECOIL_DecodeC64Multicolor(self, 320, content, 116, 8308, -8119, content[8116]);
}

static cibool RECOIL_DecodePnt(RECOIL *self, unsigned char const *content, int contentLength)
{
	int paletteLength;
	int bitmapOffset;
	int bitmapLength;
	int width;
	int height;
	int bitplanes;
	int unpackedLength;
	if (contentLength < 128 || content[0] != 80 || content[1] != 78 || content[2] != 84 || content[3] != 0 || content[4] != 1 || content[5] != 0 || content[12] != 0 || content[14] != 0)
		return FALSE;
	paletteLength = (content[6] << 8) | content[7];
	bitmapOffset = 128 + paletteLength * 6;
	bitmapLength = RECOIL_Get32BigEndian(content, 16);
	if (bitmapLength <= 0 || contentLength < bitmapOffset + bitmapLength)
		return FALSE;
	width = (content[8] << 8) | content[9];
	height = (content[10] << 8) | content[11];
	bitplanes = content[13];
	unpackedLength = ((width + 15) >> 4 << 1) * height * bitplanes;
	switch (content[15]) {
		unsigned char *unpacked;
		PackBitsStream rle;
		cibool ok;
	case 0:
		return bitmapLength == unpackedLength && RECOIL_DecodePntUnpacked(self, content, content, bitmapOffset, width, height);
	case 1:
		unpacked = (unsigned char *) malloc(unpackedLength * sizeof(unsigned char ));
		PackBitsStream_Construct(&rle, NULL);
		rle.base.base.base.content = content;
		rle.base.base.base.contentOffset = bitmapOffset;
		rle.base.base.base.contentLength = contentLength;
		ok = PackBitsStream_UnpackBitplaneLines(&rle, unpacked, width, height, bitplanes, TRUE, FALSE) && RECOIL_DecodePntUnpacked(self, content, unpacked, 0, width, height);
		free(unpacked);
		return ok;
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodePntUnpacked(RECOIL *self, unsigned char const *content, unsigned char const *bitmap, int bitmapOffset, int width, int height)
{
	int bitplanes = content[13];
	switch (bitplanes) {
		int paletteLength;
	case 1:
	case 2:
	case 4:
	case 8:
		if (!RECOIL_SetSizeStOrFalcon(self, width, height, bitplanes, FALSE))
			return FALSE;
		paletteLength = (content[6] << 8) | content[7];
		RECOIL_SetStVdiPalette(self, content, 128, paletteLength, bitplanes);
		RECOIL_DecodeScaledBitplanes(self, bitmap, bitmapOffset, width, height, bitplanes, FALSE, NULL);
		return TRUE;
	case 16:
		return RECOIL_DecodeFalconTrueColor(self, bitmap, bitmapOffset, width, height, RECOILResolution_FALCON1X1);
	case 24:
		if (!RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1))
			return FALSE;
		{
			int y;
			for (y = 0; y < height; y++) {
				{
					int x;
					for (x = 0; x < width; x++)
						self->pixels[y * width + x] = RECOIL_GetR8G8B8Color(bitmap, bitmapOffset + x * 3);
				}
				bitmapOffset += ((width + 15) & ~15) * 3;
			}
		}
		return TRUE;
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodePph(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	RECOILResolution resolution;
	int width;
	int height;
	unsigned char bitmap[26113];
	if (contentLength < 10)
		return FALSE;
	switch (content[0]) {
	case 3:
		if (contentLength != 22 || !RECOIL_SetAmstradFirmwarePalette16(self, content))
			return FALSE;
		resolution = RECOILResolution_AMSTRAD1X1;
		break;
	case 4:
		if (contentLength != 22 || !RECOIL_SetAmstradFirmwarePalette16(self, content))
			return FALSE;
		resolution = RECOILResolution_AMSTRAD2X1;
		break;
	case 5:
		if (contentLength != (1 + content[5]) * 5)
			return FALSE;
		resolution = RECOILResolution_AMSTRAD1X1;
		break;
	default:
		return FALSE;
	}
	width = content[1] | (content[2] << 8);
	if (width == 0 || width > 384 || (width & 3) != 0)
		return FALSE;
	height = content[3] | (content[4] << 8);
	if (height == 0 || height > 272)
		return FALSE;
	RECOIL_SetSize(self, width, height, resolution);
	return RECOIL_DecodePphFrame(self, filename, "ODD", "odd", bitmap, content, 0) && RECOIL_DecodePphFrame(self, filename, "EVE", "eve", bitmap, content, height) && RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodePphFrame(RECOIL *self, const char *filename, const char *upperExt, const char *lowerExt, unsigned char *bitmap, unsigned char const *pph, int yOffset)
{
	int bitmapStride = self->width >> 2;
	int bitmapLength = self->height * bitmapStride;
	if (RECOIL_ReadCompanionFile(self, filename, upperExt, lowerExt, bitmap, bitmapLength + 1) != bitmapLength)
		return FALSE;
	if (pph[0] == 5) {
		int paletteOffset = 6;
		int paletteLines = 0;
		{
			int y;
			for (y = 0; y < self->height; y++) {
				if (paletteLines == 0) {
					if (!RECOIL_SetAmstradFirmwarePalette(self, pph, paletteOffset, 4))
						return FALSE;
					paletteOffset += 4;
					if (paletteOffset < (1 + pph[5]) * 5) {
						paletteLines = pph[paletteOffset++];
						if (paletteLines == 0)
							return FALSE;
					}
					else
						paletteLines = 272;
				}
				RECOIL_DecodeAmstradMode1Line(self, bitmap, y * bitmapStride, yOffset + y);
				paletteLines--;
			}
		}
	}
	else {
		{
			int y;
			for (y = 0; y < self->height; y++)
				RECOIL_DecodeAmstradMode0Line(self, bitmap, y * bitmapStride, yOffset + y);
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodePpp(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 32079 && RECOIL_IsStringAt(content, 0, "PABLO PACKED PICTURE: Groupe CDND \r\n32036\r\n") && content[44] == 0 && content[45] == 125 && content[46] == 36 && RECOIL_DecodeSt(self, content, 79, content, 47, content[43], 0);
}

static cibool RECOIL_DecodePsc(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[32000];
	if (contentLength < 18 || !RECOIL_IsStringAt(content, 0, "tm89PS") || content[6] != 0 || content[7] != 203 || content[8] != 2 || content[9] != 1 || content[10] != 2 || content[11] != 127 || content[12] != 1 || content[13] != 143)
		return FALSE;
	if (content[14] == 99 && contentLength == 32016 && content[32015] == 255)
		memcpy(unpacked + 0, content + 15, 32000);
	else {
		int contentOffset = 14;
		{
			int unpackedOffset;
			for (unpackedOffset = 0; unpackedOffset < 32000;) {
				if (contentOffset + 1 >= contentLength)
					return FALSE;
				switch (content[contentOffset++]) {
				case 0:
					unpackedOffset = RECOIL_FillPscLine(unpacked, unpackedOffset, 0);
					break;
				case 10:
					unpackedOffset = RECOIL_CopyPscLines(unpacked, unpackedOffset, 1 + content[contentOffset++]);
					if (unpackedOffset < 0)
						return FALSE;
					break;
				case 12:
					unpackedOffset = RECOIL_CopyPscLines(unpacked, unpackedOffset, 257 + content[contentOffset++]);
					if (unpackedOffset < 0)
						return FALSE;
					break;
				case 100:
					unpackedOffset = RECOIL_FillPscLine(unpacked, unpackedOffset, content[contentOffset++]);
					break;
				case 102:
					if (contentOffset + 2 >= contentLength)
						return FALSE;
					{
						int i;
						for (i = 0; i < 80; i += 2)
							memcpy(unpacked + unpackedOffset + i, content + contentOffset, 2);
					}
					contentOffset += 2;
					unpackedOffset += 80;
					break;
				case 110:
					if (contentOffset + 80 >= contentLength)
						return FALSE;
					memcpy(unpacked + unpackedOffset, content + contentOffset, 80);
					contentOffset += 80;
					unpackedOffset += 80;
					break;
				case 200:
					unpackedOffset = RECOIL_FillPscLine(unpacked, unpackedOffset, 255);
					break;
				default:
					return FALSE;
				}
			}
		}
		if (contentOffset >= contentLength || content[contentOffset] != 255)
			return FALSE;
	}
	return RECOIL_DecodeDoo(self, unpacked, 32000);
}

static cibool RECOIL_DecodeQ4(RECOIL *self, unsigned char const *content, int contentLength)
{
	Q4Stream rle;
	int nextChunkOffset;
	int chunkPixels;
	if (contentLength < 22 || (content[2] != 2 && (content[1] > 1 || content[3] > 1)) || content[8] + (content[9] << 8) != contentLength || !RECOIL_IsStringAt(content, 11, "MAJYO"))
		return FALSE;
	Q4Stream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 16;
	rle.base.base.base.contentLength = contentLength;
	nextChunkOffset = Q4Stream_StartChunk(&rle);
	if (nextChunkOffset < 0 || !Q4Stream_Unpack(&rle))
		return FALSE;
	{
		int i;
		for (i = 0; i < 16; i++) {
			int rgb = 0;
			{
				int c;
				for (c = 0; c < 3; c++) {
					int b;
					if (RleStream_ReadRle(&rle.base) < 0)
						return FALSE;
					b = RleStream_ReadRle(&rle.base);
					if (b < 0)
						return FALSE;
					rgb = (rgb << 8) | b * 17;
				}
			}
			self->contentPalette[(i & 8) | ((i & 1) << 2) | ((i >> 1) & 3)] = rgb;
		}
	}
	RECOIL_SetSize(self, 640, 400, RECOILResolution_PC981X1);
	chunkPixels = 0;
	{
		int i;
		for (i = 0; i < 256000; i++) {
			int b;
			if (--chunkPixels <= 0) {
				chunkPixels = (content[nextChunkOffset + 4] | (content[nextChunkOffset + 5] << 8)) << 1;
				rle.base.base.base.content = content;
				rle.base.base.base.contentOffset = nextChunkOffset;
				rle.base.base.base.contentLength = contentLength;
				nextChunkOffset = Q4Stream_StartChunk(&rle);
				if (nextChunkOffset < 0 || !Q4Stream_Unpack(&rle))
					return FALSE;
			}
			b = RleStream_ReadRle(&rle.base);
			if (b < 0)
				b = 0;
			self->pixels[i] = self->contentPalette[b];
		}
	}
	return TRUE;
}

static void RECOIL_DecodeR8G8B8Colors(unsigned char const *content, int contentOffset, int count, int *destination)
{
	{
		int i;
		for (i = 0; i < count; i++)
			destination[i] = RECOIL_GetR8G8B8Color(content, contentOffset + i * 3);
	}
}

static void RECOIL_DecodeR8G8G8X8Colors(RECOIL *self, unsigned char const *content, int contentOffset, int count)
{
	{
		int i;
		for (i = 0; i < count; i++)
			self->pixels[i] = RECOIL_GetR8G8B8Color(content, contentOffset + (i << 2));
	}
}

static cibool RECOIL_DecodeRag(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	int bitplanes;
	int paletteLength;
	if (contentLength < 55 || !RECOIL_IsStringAt(content, 0, "RAG-D!") || content[6] != 0 || content[7] != 0 || content[16] != 0)
		return FALSE;
	width = (content[12] << 8) | content[13];
	if ((width & 15) != 0)
		return FALSE;
	height = (content[14] << 8) + content[15] + 1;
	bitplanes = content[17];
	paletteLength = RECOIL_Get32BigEndian(content, 18);
	switch (bitplanes) {
		int bytesPerLine;
	case 1:
	case 2:
	case 4:
	case 8:
		switch (paletteLength) {
		case 32:
			if (bitplanes > 4)
				return FALSE;
			break;
		case 1024:
			break;
		default:
			return FALSE;
		}
		bytesPerLine = (width >> 3) * bitplanes;
		if (30 + paletteLength + height * bytesPerLine > contentLength || !RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1))
			return FALSE;
		if (paletteLength == 32)
			RECOIL_SetStPalette(self, content, 30, 16);
		else
			RECOIL_SetFalconPalette(self, content, 30);
		RECOIL_DecodeBitplanes(self, content, 30 + paletteLength, bytesPerLine, bitplanes, 0, width, height);
		return TRUE;
	case 16:
		return paletteLength == 1024 && contentLength >= 1054 + width * height * 2 && RECOIL_DecodeFalconTrueColor(self, content, 1054, width, height, RECOILResolution_FALCON1X1);
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeRap(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if (contentLength != 7681)
		return FALSE;
	self->gtiaColors[8] = content[7680] & 254;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE4X1);
	RECOIL_DecodeAtari8Gr9(self, content, 0, 40, frame, 0, 320, 320, 192);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeRgbn(RECOIL *self, unsigned char const *content, int contentOffset, int contentLength, int width, int height, cibool rgb8)
{
	int rgb = 0;
	int count = 0;
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int x;
				for (x = 0; x < width; x++) {
					if (count == 0) {
						if (rgb8) {
							if (contentOffset > contentLength - 4)
								return FALSE;
							rgb = RECOIL_GetR8G8B8Color(content, contentOffset);
							count = content[contentOffset + 3] & 127;
							contentOffset += 4;
						}
						else {
							if (contentOffset > contentLength - 2)
								return FALSE;
							rgb = content[contentOffset];
							count = content[contentOffset + 1];
							rgb = (((((rgb & 240) << 4) | (rgb & 15)) << 8) | (count >> 4)) * 17;
							count &= 7;
							contentOffset += 2;
						}
						if (count == 0) {
							if (contentOffset >= contentLength)
								return FALSE;
							count = content[contentOffset++];
							if (count == 0) {
								if (contentOffset > contentLength - 2)
									return FALSE;
								count = (content[contentOffset] << 8) | content[contentOffset + 1];
								contentOffset += 2;
							}
						}
					}
					RECOIL_SetScaledPixel(self, x, y, rgb);
					count--;
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeRgh(RECOIL *self, unsigned char const *content, int contentLength)
{
	DaliStream stream;
	int countLength;
	int paletteOffset;
	if (contentLength < 14 || !RECOIL_IsStringAt(content, 0, "(c)F.MARCHAL"))
		return FALSE;
	stream.base.content = content;
	stream.base.contentOffset = 12;
	stream.base.contentLength = contentLength;
	countLength = Stream_ParseInt(&stream.base);
	paletteOffset = stream.base.contentOffset;
	stream.base.contentOffset = paletteOffset + 32;
	return DaliStream_Decode(&stream, countLength, self, paletteOffset, 0);
}

static cibool RECOIL_DecodeRip(RECOIL *self, unsigned char const *content, int contentLength)
{
	int headerLength;
	int contentStride;
	int height;
	int textLength;
	int unpackedLength;
	unsigned char unpacked[20076];
	int width;
	unsigned char frame1[76480];
	unsigned char frame2[76480];
	if (contentLength < 34 || content[0] != 82 || content[1] != 73 || content[2] != 80 || content[18] != 84 || content[19] != 58)
		return FALSE;
	headerLength = content[11] | (content[12] << 8);
	contentStride = content[13];
	height = content[15];
	textLength = content[17];
	if (headerLength >= contentLength || contentStride == 0 || contentStride > 80 || (contentStride & 1) != 0 || height == 0 || height > 239 || 33 + textLength >= contentLength || content[20 + textLength] != 9 || !RECOIL_IsStringAt(content, 21 + textLength, "CM:"))
		return FALSE;
	if (content[7] < 16)
		contentStride >>= 1;
	unpackedLength = contentStride * height;
	if (content[7] == 48)
		unpackedLength += (height + 1) >> 1 << 3;
	memset(unpacked, 0, sizeof(unpacked));
	switch (content[9]) {
	case 0:
		if (headerLength + unpackedLength > contentLength)
			return FALSE;
		memcpy(unpacked + 0, content + headerLength, unpackedLength);
		break;
	case 1:
		RECOIL_UnpackRip(self, content, headerLength, contentLength, unpacked, unpackedLength);
		break;
	default:
		return FALSE;
	}
	RECOIL_SetGtiaColors(self, content, 24 + textLength);
	contentStride = content[13] >> 1;
	width = contentStride << 3;
	switch (content[7]) {
		int colorsOffset;
	case 14:
		RECOIL_SetSize(self, width, height, RECOILResolution_XE2X1);
		RECOIL_DecodeAtari8Gr15(self, unpacked, 0, contentStride, frame1, 0, width, height);
		return RECOIL_ApplyAtari8Palette(self, frame1);
	case 15:
		RECOIL_SetSize(self, width, height, RECOILResolution_XE1X1);
		RECOIL_DecodeAtari8Gr8(self, unpacked, 0, frame1, 0, height);
		return RECOIL_ApplyAtari8Palette(self, frame1);
	case 79:
		RECOIL_SetSize(self, width, height, RECOILResolution_XE4X1);
		RECOIL_DecodeAtari8Gr9(self, unpacked, 0, contentStride, frame1, 0, width, width, height);
		return RECOIL_ApplyAtari8Palette(self, frame1);
	case 143:
		RECOIL_SetSize(self, width, height, RECOILResolution_XE4X1);
		self->leftSkip = 2;
		RECOIL_DecodeAtari8Gr10(self, unpacked, 0, frame1, 0, width, height);
		return RECOIL_ApplyAtari8Palette(self, frame1);
	case 207:
		RECOIL_SetSize(self, width, height, RECOILResolution_XE4X1);
		RECOIL_DecodeAtari8Gr11(self, content, 0, frame1, 0, width, height);
		return RECOIL_ApplyAtari8Palette(self, frame1);
	case 30:
		RECOIL_SetSize(self, width, height, RECOILResolution_XE2X1);
		RECOIL_DecodeAtari8Gr15(self, unpacked, 0, contentStride, frame1, 0, width, height);
		RECOIL_DecodeAtari8Gr15(self, unpacked, height * contentStride, contentStride, frame2, 0, width, height);
		return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
	case 16:
		RECOIL_SetSize(self, width, height, RECOILResolution_XE2X1);
		RECOIL_SetBakPF012(self, content, 28 + textLength, 1);
		RECOIL_DecodeAtari8Gr15(self, unpacked, 0, contentStride << 1, frame1, 0, width << 1, height >> 1);
		RECOIL_SetBakPF012(self, content, 24 + textLength, 1);
		RECOIL_DecodeAtari8Gr15(self, unpacked, contentStride, contentStride << 1, frame1, width, width << 1, height >> 1);
		RECOIL_DecodeAtari8Gr15(self, unpacked, height * contentStride, contentStride << 1, frame2, 0, width << 1, height >> 1);
		RECOIL_SetBakPF012(self, content, 28 + textLength, 1);
		RECOIL_DecodeAtari8Gr15(self, unpacked, (height + 1) * contentStride, contentStride << 1, frame2, width, width << 1, height >> 1);
		return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
	case 32:
		RECOIL_SetSize(self, width, height, RECOILResolution_XE2X1);
		self->leftSkip = 1;
		RECOIL_DecodeAtari8Gr10(self, unpacked, 0, frame1, 0, width, height);
		self->gtiaColors[8] = 0;
		RECOIL_DecodeAtari8Gr9(self, unpacked, height * contentStride, contentStride, frame2, 0, width, width, height);
		return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
	case 48:
		RECOIL_SetSize(self, width, height, RECOILResolution_XE2X1);
		self->leftSkip = 1;
		self->gtiaColors[0] = 0;
		colorsOffset = height * contentStride << 1;
		{
			int y;
			for (y = 0; y < height; y += 2) {
				RECOIL_SetPM123PF0123Bak(self, unpacked, colorsOffset + (y << 2));
				RECOIL_DecodeAtari8Gr10(self, unpacked, y * contentStride, frame1, y * width, width, y + 1 < height ? 2 : 1);
			}
		}
		self->gtiaColors[8] = 0;
		RECOIL_DecodeAtari8Gr9(self, unpacked, height * contentStride, contentStride, frame2, 0, width, width, height);
		return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeRle(RECOIL *self, unsigned char const *content, int contentLength)
{
	int count;
	int contentOffset;
	int c;
	if (contentLength < 520 || content[0] != 27 || content[1] != 71 || content[2] != 72)
		return FALSE;
	RECOIL_SetSize(self, 256, 192, RECOILResolution_TRS1X1);
	count = 0;
	contentOffset = 3;
	c = 16777215;
	{
		int pixelsOffset;
		for (pixelsOffset = 0; pixelsOffset < 49152; pixelsOffset++) {
			while (count == 0) {
				if (contentOffset >= contentLength)
					return FALSE;
				count = content[contentOffset++];
				if (count < 32 || count > 127) {
					if (pixelsOffset == 49151) {
						self->pixels[pixelsOffset] = c;
						return TRUE;
					}
					return FALSE;
				}
				c ^= 16777215;
				count -= 32;
			}
			self->pixels[pixelsOffset] = c;
			count--;
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeRleBlackAndWhite(RECOIL *self, RleStream *rle, int backgroundColor)
{
	int width = RECOIL_GetOriginalWidth(self);
	int height = RECOIL_GetOriginalHeight(self);
	{
		int y;
		for (y = 0; y < height; y++) {
			int b = 0;
			{
				int x;
				for (x = 0; x < width; x++) {
					if ((x & 7) == 0) {
						b = RleStream_ReadRle(rle);
						if (b < 0)
							return FALSE;
					}
					RECOIL_SetScaledPixel(self, x, y, ((b >> (~x & 7)) & 1) == 0 ? backgroundColor : backgroundColor ^ 16777215);
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeRm(RECOIL *self, unsigned char const *content, int contentLength, int mode, RECOILResolution resolution)
{
	unsigned char unpacked[7680];
	int colorsOffset;
	int dliOffset;
	cibool dliPresent[192];
	int height;
	unsigned char frame[61440];
	if (XeKoalaStream_UnpackWrapped(content, contentLength - 464, unpacked, mode == 0 ? 3840 : 7680)) {
		colorsOffset = contentLength - 464;
		dliOffset = contentLength - 384;
	}
	else if (contentLength == 8192) {
		memcpy(unpacked + 0, content + 0, 7680);
		colorsOffset = 7680;
		dliOffset = 7808;
	}
	else
		return FALSE;
	memset(dliPresent, 0, sizeof(dliPresent));
	{
		int i;
		for (i = 0; i < 128; i++) {
			int y = content[dliOffset + i];
			switch (y) {
			case 0:
				break;
			case 1:
			case 2:
			case 4:
			case 5:
				return FALSE;
			default:
				if (mode == 0) {
					if (y >= 101)
						return FALSE;
					if (y == 3)
						y = 0;
					else
						y -= 5;
				}
				else {
					if (y == 100 || y == 101 || y >= 198)
						return FALSE;
					if (y == 3)
						y = 1;
					else if (y < 100)
						y -= 4;
					else
						y -= 6;
				}
				dliPresent[y] = TRUE;
				break;
			}
		}
	}
	RECOIL_SetSize(self, 320, 192, resolution);
	if (mode == 2)
		self->leftSkip = 2;
	if (mode == 1)
		self->gtiaColors[8] = content[colorsOffset + 8] & 240;
	else
		RECOIL_SetGtiaColors(self, content, colorsOffset);
	height = mode == 0 ? 96 : 192;
	{
		int y;
		for (y = 0; y < height; y++) {
			switch (mode) {
			case 0:
				RECOIL_DecodeAtari8Gr7(self, unpacked, y * 40, frame, y * 640, 1);
				break;
			case 1:
				RECOIL_DecodeAtari8Gr9(self, unpacked, y * 40, 40, frame, y * 320, 320, 320, 1);
				break;
			case 2:
				RECOIL_DecodeAtari8Gr10(self, unpacked, y * 40, frame, y * 320, 320, 1);
				break;
			case 3:
				RECOIL_DecodeAtari8Gr11(self, unpacked, y * 40, frame, y * 320, 320, 1);
				break;
			case 4:
				RECOIL_DecodeAtari8Gr15(self, unpacked, y * 40, 40, frame, y * 320, 320, 1);
				break;
			}
			if (dliPresent[y]) {
				int vcount = mode == 0 ? 16 + y : 16 + ((y - 1) >> 1);
				int reg = content[dliOffset + 128 + vcount];
				if (reg < 9)
					RECOIL_SetGtiaColor(self, reg, content[dliOffset + 256 + vcount]);
				else if (reg != 128)
					return FALSE;
			}
		}
	}
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeRw(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 64000:
		RECOIL_SetSize(self, 320, 200, RECOILResolution_FALCON1X1);
		break;
	case 128000:
		RECOIL_SetSize(self, 640, 200, RECOILResolution_FALCON1X1);
		break;
	case 256000:
		RECOIL_SetSize(self, 640, 400, RECOILResolution_FALCON1X1);
		break;
	default:
		return FALSE;
	}
	{
		int i;
		for (i = 0; i < contentLength; i++)
			self->pixels[i] = (255 - content[i]) * 65793;
	}
	return TRUE;
}

static cibool RECOIL_DecodeRys(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if (contentLength != 3840)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X2);
	RECOIL_SetXeOsDefaultColors(self);
	RECOIL_DecodeAtari8Gr7(self, content, 0, frame, 0, 96);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeSc(RECOIL *self, unsigned char const *content, int contentLength)
{
	int flags;
	int doubleHeight;
	int bitmapLength;
	int mode;
	if (contentLength < 128 || !RECOIL_IsStringAt(content, 54, "ANvisionA"))
		return FALSE;
	flags = content[63];
	switch (flags & 15) {
	case 0:
		doubleHeight = 1;
		break;
	case 1:
	case 2:
		doubleHeight = 0;
		break;
	default:
		return FALSE;
	}
	bitmapLength = 32000 << doubleHeight;
	mode = (flags >> 4) & 3;
	if (flags >= 128) {
		unsigned char unpacked[64000];
		ScStream rle;
		int bytesPer16Pixels;
		ScStream_Construct(&rle, NULL);
		rle.base.base.base.content = content;
		rle.base.base.base.contentOffset = 128;
		rle.base.base.base.contentLength = contentLength;
		bytesPer16Pixels = 8 >> mode;
		{
			int bitplane;
			for (bitplane = 0; bitplane < bytesPer16Pixels; bitplane += 2) {
				if (!RleStream_UnpackWords(&rle.base, unpacked, bitplane, bytesPer16Pixels, bitmapLength))
					return FALSE;
			}
		}
		return RECOIL_DecodeSt(self, unpacked, 0, content, 4, mode, doubleHeight);
	}
	return contentLength >= 128 + bitmapLength && RECOIL_DecodeSt(self, content, 128, content, 4, mode, doubleHeight);
}

static cibool RECOIL_DecodeSc2(RECOIL *self, unsigned char const *content, int contentLength)
{
	RECOILResolution resolution;
	if (contentLength < 14343 || content[0] != 254 || RECOIL_GetMsxHeader(content) < 14335)
		return FALSE;
	if (RECOIL_IsMsxPalette(content, 7047)) {
		RECOIL_SetMsxPalette(self, content, 7047, 16);
		resolution = RECOILResolution_MSX21X1;
	}
	else {
		RECOIL_SetMsxPalette(self, RECOIL_Msx1Palette, 0, 16);
		resolution = RECOILResolution_MSX11X1;
	}
	RECOIL_DecodeSc2Sc4(self, content, resolution);
	if (contentLength == 16391)
		RECOIL_DecodeMsxSprites(self, content, 2, 6919, 14343);
	return TRUE;
}

static void RECOIL_DecodeSc2Sc4(RECOIL *self, unsigned char const *content, RECOILResolution resolution)
{
	RECOIL_SetSize(self, 256, 192, resolution);
	{
		int y;
		for (y = 0; y < 192; y++) {
			int fontOffset = 7 + ((y & 192) << 5) + (y & 7);
			{
				int x;
				for (x = 0; x < 256; x++) {
					int b = fontOffset + (content[6151 + ((y & ~7) << 2) + (x >> 3)] << 3);
					int c = content[8192 + b];
					self->pixels[(y << 8) + x] = self->contentPalette[((content[b] >> (~x & 7)) & 1) == 0 ? c & 15 : c >> 4];
				}
			}
		}
	}
}

static cibool RECOIL_DecodeSc3(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength < 1543 || content[0] != 254 || RECOIL_GetMsxHeader(content) < 1535)
		return FALSE;
	if (contentLength >= 8263 && RECOIL_IsMsxPalette(content, 8231))
		RECOIL_SetMsxPalette(self, content, 8231, 16);
	else
		RECOIL_SetMsxPalette(self, RECOIL_Msx1Palette, 0, 16);
	RECOIL_SetSize(self, 256, 192, RECOILResolution_MSX14X4);
	{
		int y;
		for (y = 0; y < 192; y++) {
			{
				int x;
				for (x = 0; x < 256; x++) {
					int c = contentLength >= 2823 ? content[2055 + ((y & ~7) << 2) + (x >> 3)] : (y & 224) + (x >> 3);
					c = (content[7 + (c << 3) + ((y >> 2) & 7)] >> (~x & 4)) & 15;
					self->pixels[(y << 8) + x] = self->contentPalette[c];
				}
			}
		}
	}
	if (contentLength == 16391)
		RECOIL_DecodeMsxSprites(self, content, 3, 6919, 14343);
	return TRUE;
}

static cibool RECOIL_DecodeSc4(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength < 16391 || content[0] != 254 || RECOIL_GetMsxHeader(content) < 16383)
		return FALSE;
	RECOIL_SetMsxPalette(self, content, 7047, 16);
	RECOIL_DecodeSc2Sc4(self, content, RECOILResolution_MSX21X1);
	RECOIL_DecodeMsxSprites(self, content, 4, 7687, 14343);
	return TRUE;
}

static cibool RECOIL_DecodeSc5(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	unsigned char interlace[27143];
	if (contentLength < 30375 || content[0] != 254 || RECOIL_GetMsxHeader(content) < 30367)
		return FALSE;
	RECOIL_SetMsxPalette(self, content, 30343, 16);
	if (RECOIL_ReadCompanionFile(self, filename, "S15", "s15", interlace, 27143) != 27143 || interlace[0] != 254 || RECOIL_GetMsxHeader(interlace) < 27135) {
		RECOIL_DecodeMsx5(self, content);
		if (contentLength == 32775)
			RECOIL_DecodeMsxSprites(self, content, 5, 30215, 30727);
		return TRUE;
	}
	RECOIL_SetSize(self, 512, 424, RECOILResolution_MSX22X1);
	self->frames = 2;
	{
		int y;
		for (y = 0; y < 424; y++) {
			int lineOffset = 7 + (y >> 1 << 7);
			{
				int x;
				for (x = 0; x < 512; x++)
					self->pixels[(y << 9) + x] = self->contentPalette[RECOIL_GetNibble((y & 1) == 0 ? content : interlace, lineOffset, x >> 1)];
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeSc6(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	unsigned char interlace[27143];
	if (contentLength < 30351 || content[0] != 254 || RECOIL_GetMsxHeader(content) < 30367)
		return FALSE;
	RECOIL_SetMsxPalette(self, content, 30343, 4);
	if (RECOIL_ReadCompanionFile(self, filename, "S16", "s16", interlace, 27143) != 27143 || interlace[0] != 254 || RECOIL_GetMsxHeader(interlace) < 27135) {
		RECOIL_SetSize(self, 512, 424, RECOILResolution_MSX21X2);
		RECOIL_DecodeMsx6(self, content, 7);
		if (contentLength == 32775)
			RECOIL_DecodeMsxSprites(self, content, 6, 30215, 30727);
		return TRUE;
	}
	RECOIL_SetSize(self, 512, 424, RECOILResolution_MSX21X1);
	self->frames = 2;
	{
		int y;
		for (y = 0; y < 424; y++) {
			{
				int x;
				for (x = 0; x < 512; x++) {
					int b = ((y & 1) == 0 ? content : interlace)[7 + (y >> 1 << 7) + (x >> 2)];
					self->pixels[(y << 9) + x] = self->contentPalette[(b >> ((~x & 3) << 1)) & 3];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeSc7(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	unsigned char interlace[54279];
	if (contentLength < 54279 || content[0] != 254 || RECOIL_GetMsxHeader(content) < 54271)
		return FALSE;
	if (contentLength >= 64167)
		RECOIL_SetMsxPalette(self, content, 64135, 16);
	else
		RECOIL_SetMsxPalette(self, RECOIL_Msx1Palette, 0, 16);
	if (RECOIL_ReadCompanionFile(self, filename, "S17", "s17", interlace, 54279) != 54279 || interlace[0] != 254 || RECOIL_GetMsxHeader(interlace) < 54271) {
		RECOIL_DecodeMsx7(self, content);
		if (contentLength == 64167)
			RECOIL_DecodeMsxSprites(self, content, 7, 64007, 61447);
		return TRUE;
	}
	RECOIL_SetSize(self, 512, 424, RECOILResolution_MSX21X1);
	self->frames = 2;
	{
		int y;
		for (y = 0; y < 424; y++)
			{
				int x;
				for (x = 0; x < 512; x++)
					self->pixels[(y << 9) + x] = self->contentPalette[RECOIL_GetNibble((y & 1) == 0 ? content : interlace, 7 + (y >> 1 << 8), x)];
			}
	}
	return TRUE;
}

static cibool RECOIL_DecodeSc8(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[54279];
	memset(unpacked, 0, sizeof(unpacked));
	content = RECOIL_UnpackSr(content, contentLength, unpacked);
	if (content == NULL)
		return FALSE;
	RECOIL_SetSc8Palette(self);
	if (filename != NULL) {
		unsigned char interlace[54279];
		if (RECOIL_ReadCompanionFile(self, filename, "S18", "s18", interlace, 54279) == 54279 && interlace[0] == 254 && RECOIL_GetMsxHeader(interlace) >= 54271) {
			RECOIL_SetSize(self, 512, 424, RECOILResolution_MSX22X1);
			self->frames = 2;
			{
				int y;
				for (y = 0; y < 424; y++) {
					{
						int x;
						for (x = 0; x < 512; x++) {
							int c = ((y & 1) == 0 ? content : interlace)[7 + (y >> 1 << 8) + (x >> 1)];
							self->pixels[(y << 9) + x] = self->contentPalette[c];
						}
					}
				}
			}
			return TRUE;
		}
	}
	RECOIL_SetSize(self, 256, 212, RECOILResolution_MSX21X1);
	RECOIL_DecodeBytes(self, content, 7);
	if (contentLength == 64167) {
		static const unsigned char spritePalette[32] = { 0, 0, 2, 0, 48, 0, 50, 0, 0, 3, 2, 3, 48, 3, 50, 3,
			114, 4, 7, 0, 112, 0, 119, 0, 0, 7, 7, 7, 112, 7, 119, 7 };
		RECOIL_SetMsxPalette(self, spritePalette, 0, 16);
		RECOIL_DecodeMsxSprites(self, content, 8, 64007, 61447);
	}
	return TRUE;
}

static cibool RECOIL_DecodeSca(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	if (contentLength < 64167 || content[0] != 254 || RECOIL_GetMsxHeader(content) < 54271)
		return FALSE;
	RECOIL_SetMsxPalette(self, content, 64135, 16);
	RECOIL_DecodeSccSca(self, filename, content, contentLength, 212, TRUE);
	return TRUE;
}

static void RECOIL_DecodeScaledBitplanes(RECOIL *self, unsigned char const *content, int contentOffset, int width, int height, int bitplanes, cibool ehb, MultiPalette *multiPalette)
{
	int contentStride = ((width + 15) >> 4 << 1) * bitplanes;
	{
		int y;
		for (y = 0; y < height; y++) {
			if (multiPalette != NULL)
				multiPalette->vtbl->setLinePalette(multiPalette, self, y);
			if (ehb) {
				{
					int c;
					for (c = 0; c < 32; c++)
						self->contentPalette[32 + c] = (self->contentPalette[c] >> 1) & 8355711;
				}
			}
			{
				int x;
				for (x = 0; x < width; x++) {
					int offset = contentOffset + ((x >> 3) & ~1) * bitplanes + ((x >> 3) & 1);
					int bit = ~x & 7;
					int c = 0;
					{
						int bitplane;
						for (bitplane = bitplanes; --bitplane >= 0;)
							c = (c << 1) | ((content[offset + (bitplane << 1)] >> bit) & 1);
					}
					RECOIL_SetScaledPixel(self, x, y, self->contentPalette[c]);
				}
			}
			contentOffset += contentStride;
		}
	}
}

static cibool RECOIL_DecodeScc(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	int height;
	if (contentLength == 49159 && content[0] == 254 && RECOIL_GetMsxHeader(content) == 49151)
		height = 192;
	else {
		unsigned char unpacked[54279];
		memset(unpacked, 0, sizeof(unpacked));
		content = RECOIL_UnpackSr(content, contentLength, unpacked);
		if (content == NULL)
			return FALSE;
		height = 212;
	}
	RECOIL_DecodeSccSca(self, filename, content, contentLength, height, FALSE);
	return TRUE;
}

static void RECOIL_DecodeSccSca(RECOIL *self, const char *filename, unsigned char const *content, int contentLength, int height, cibool usePalette)
{
	unsigned char interlace[54279];
	if (RECOIL_ReadCompanionFile(self, filename, usePalette ? "S1A" : "S1C", usePalette ? "s1a" : "s1c", interlace, (height << 8) + 7) == (height << 8) + 7 && interlace[0] == 254 && RECOIL_GetMsxHeader(interlace) >= (height << 8) - 1) {
		RECOIL_SetSize(self, 512, height << 1, RECOILResolution_MSX2_PLUS2X1);
		self->frames = 2;
		{
			int y;
			for (y = 0; y < height << 1; y++) {
				{
					int x;
					for (x = 0; x < 512; x++) {
						self->pixels[(y << 9) + x] = RECOIL_DecodeMsxYjk(self, (y & 1) == 0 ? content : interlace, 7 + (y >> 1 << 8), x >> 1, usePalette);
					}
				}
			}
		}
	}
	else {
		RECOIL_SetSize(self, 256, height, RECOILResolution_MSX2_PLUS1X1);
		RECOIL_DecodeMsxYjkScreen(self, content, 7, usePalette);
		if (contentLength == 64167 && content[0] == 254) {
			RECOIL_SetMsxPalette(self, content, 64135, 16);
			RECOIL_DecodeMsxSprites(self, content, 12, 64007, 61447);
		}
	}
}

static cibool RECOIL_DecodeScr(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 1002:
		return RECOIL_DecodeScrCol(self, filename, content, contentLength);
	case 6144:
		RECOIL_SetZx(self, RECOILResolution_SPECTRUM1X1);
		RECOIL_DecodeZx(self, content, 0, -1, -3, 0);
		return TRUE;
	case 6912:
	case 6913:
		RECOIL_SetZx(self, RECOILResolution_SPECTRUM1X1);
		RECOIL_DecodeZx(self, content, 0, 6144, 3, 0);
		return TRUE;
	case 6976:
		RECOIL_SetUlaPlus(self, content, 6912);
		RECOIL_DecodeZx(self, content, 0, 6144, 3, 0);
		return TRUE;
	case 12288:
		RECOIL_SetZx(self, RECOILResolution_TIMEX1X1);
		RECOIL_DecodeZx(self, content, 0, 6144, -1, 0);
		return TRUE;
	case 12289:
		RECOIL_DecodeTimexHires(self, content);
		return TRUE;
	case 12352:
		RECOIL_SetUlaPlus(self, content, 12288);
		RECOIL_DecodeZx(self, content, 0, 6144, -1, 0);
		return TRUE;
	default:
		return RECOIL_DecodeAmstradScr(self, filename, content, contentLength);
	}
}

static cibool RECOIL_DecodeScrCol(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	unsigned char colors[1003];
	unsigned char const *font;
	if (contentLength != 1002)
		return FALSE;
	if (RECOIL_ReadCompanionFile(self, filename, "COL", "col", colors, 1003) != 1002)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_C641X1);
	font = CiBinaryResource_c64_fnt;
	{
		int y;
		for (y = 0; y < 200; y++) {
			{
				int x;
				for (x = 0; x < 320; x++) {
					int offset = 2 + (y & ~7) * 5 + (x >> 3);
					int c;
					if (((font[(content[offset] << 3) | (y & 7)] >> (~x & 7)) & 1) == 0)
						c = 0;
					else
						c = colors[offset] & 15;
					self->pixels[y * 320 + x] = RECOIL_C64Palette[c];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeScs4(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 24617 || content[24616] != 255)
		return FALSE;
	{
		int i;
		for (i = 0; i < 16; i++) {
			int c = content[24576 + i];
			int rgb = 0;
			if ((c & 1) != 0)
				rgb |= 73;
			if ((c & 2) != 0)
				rgb |= 4784128;
			if ((c & 4) != 0)
				rgb |= 18688;
			if ((c & 8) != 0)
				rgb |= 2368548;
			if ((c & 16) != 0)
				rgb |= 146;
			if ((c & 32) != 0)
				rgb |= 9568256;
			if ((c & 64) != 0)
				rgb |= 37376;
			self->contentPalette[i] = rgb;
		}
	}
	RECOIL_SetSize(self, 256, 192, RECOILResolution_SAM_COUPE1X1);
	RECOIL_DecodeNibbles(self, content, 0, 128);
	return TRUE;
}

static cibool RECOIL_DecodeSd(RECOIL *self, unsigned char const *content, int contentLength, int mode)
{
	return contentLength == 32128 && RECOIL_DecodeSt(self, content, 128, content, 4, mode, 0);
}

static cibool RECOIL_DecodeSg3(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if (contentLength != 240)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE8X8);
	RECOIL_SetXeOsDefaultColors(self);
	RECOIL_DecodeAtari8Gr3(self, content, frame);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeSge(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char font[1024];
	unsigned char frame[61440];
	if (contentLength != 960)
		return FALSE;
	memcpy(font + 0, CiBinaryResource_atari8_fnt + 0, 1024);
	{
		int i;
		for (i = 0; i < 4; i++) {
			font[1004 + i] = font[728 + i] = 15;
			font[1000 + i] = font[732 + i] = 240;
		}
	}
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE1X1);
	RECOIL_DecodeAtari8Gr0(self, content, 40, font, 0, frame);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeSh3(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 38400)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_APPLE_I_I_G_S1X1);
	{
		int y;
		for (y = 0; y < 200; y++)
			RECOIL_DecodeShrLine(self, content, y, 32030 + (y << 5));
	}
	return TRUE;
}

static cibool RECOIL_DecodeShc(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame1[61440];
	unsigned char frame2[61440];
	int col1;
	int col2;
	if (contentLength != 17920)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE1X1);
	col1 = 15360;
	col2 = 16640;
	{
		int y;
		for (y = 0; y < 192; y++) {
			{
				int x;
				for (x = 0; x < 320; x++) {
					int i = 320 * y + x;
					int bit = ~x & 7;
					switch (x) {
					case 94:
					case 166:
					case 214:
					case 262:
					case 306:
						col1++;
						break;
					case 46:
					case 142:
					case 190:
					case 238:
					case 286:
						col2++;
						break;
					default:
						break;
					}
					frame1[i] = content[col1] & (((content[i >> 3] >> bit) & 1) != 0 ? 240 : 254);
					frame2[i] = content[col2] & (((content[7680 + (i >> 3)] >> bit) & 1) != 0 ? 240 : 254);
				}
			}
			col1++;
			col2++;
		}
	}
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeShp(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 1024:
		return RECOIL_DecodeBlazingPaddlesVectors(self, content, contentLength, 31744);
	case 4384:
		return RECOIL_DecodeGr7(self, content, 528, 3844);
	default:
		return FALSE;
	}
}

static void RECOIL_DecodeShrLine(RECOIL *self, unsigned char const *content, int y, int paletteOffset)
{
	{
		int c;
		for (c = 0; c < 16; c++) {
			int offset = paletteOffset ^ (c << 1);
			int gb = content[offset];
			int r = content[offset + 1] & 15;
			int g = gb >> 4;
			int b = gb & 15;
			int rgb = (r << 16) | (g << 8) | b;
			rgb |= rgb << 4;
			self->contentPalette[c] = rgb;
		}
	}
	{
		int x;
		for (x = 0; x < 320; x++)
			self->pixels[y * 320 + x] = self->contentPalette[RECOIL_GetNibble(content, y * 160, x)];
	}
}

static cibool RECOIL_DecodeSif(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame1[8192];
	unsigned char frame2[8192];
	if (contentLength != 2048)
		return FALSE;
	RECOIL_SetSize(self, 256, 32, RECOILResolution_XE2X1);
	self->gtiaColors[4] = 76;
	self->gtiaColors[5] = 204;
	self->gtiaColors[6] = 140;
	self->gtiaColors[8] = 0;
	{
		int y;
		for (y = 0; y < 4; y++) {
			RECOIL_DecodeAtari8Gr12Line(self, NULL, 0, content, y << 8, frame1, y << 11, 0);
			RECOIL_DecodeAtari8Gr12Line(self, NULL, 0, content, 1024 + (y << 8), frame2, y << 11, 0);
		}
	}
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeSkp(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if (contentLength != 7680)
		return FALSE;
	self->gtiaColors[8] = 38;
	self->gtiaColors[4] = 40;
	self->gtiaColors[5] = 0;
	self->gtiaColors[6] = 12;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE2X1);
	RECOIL_DecodeAtari8Gr15(self, content, 0, 40, frame, 0, 320, 192);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeSpd(RECOIL *self, unsigned char const *content, int contentLength)
{
	int headerLength;
	int spriteCount;
	RECOILResolution resolution;
	int width;
	int height;
	if (contentLength < 67)
		return FALSE;
	if (content[0] == 83 && content[1] == 80 && content[2] == 68 && content[3] == 1) {
		headerLength = 6;
		spriteCount = content[4] + 1;
		if (contentLength < 9 + (spriteCount << 6))
			return FALSE;
	}
	else {
		if ((contentLength & 63) != 3 || content[0] > 15 || content[1] > 15 || content[2] > 15)
			return FALSE;
		headerLength = 0;
		spriteCount = contentLength >> 6;
	}
	resolution = RECOILResolution_C642X1;
	{
		int spriteNo;
		for (spriteNo = 0; spriteNo < spriteCount; spriteNo++) {
			if (content[headerLength + 66 + (spriteNo << 6)] < 128) {
				resolution = RECOILResolution_C641X1;
				break;
			}
		}
	}
	if (spriteCount <= 16) {
		width = spriteCount * 26 - 2;
		height = 21;
	}
	else {
		width = 414;
		height = ((spriteCount + 15) >> 4) * 23 - 2;
	}
	if (!RECOIL_SetSize(self, width, height, resolution))
		return FALSE;
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int x;
				for (x = 0; x < width; x++) {
					int c = 0;
					int row = y % 23;
					if (row < 21) {
						int column = x % 26;
						if (column < 24) {
							int spriteNo = x / 26 + (y / 23 << 4);
							if (spriteNo < spriteCount) {
								int spriteOffset = 3 + (spriteNo << 6);
								int b = content[headerLength + spriteOffset + row * 3 + (column >> 3)];
								if (content[headerLength + spriteOffset + 63] < 128) {
									if (((b >> (~column & 7)) & 1) != 0)
										c = spriteOffset + 63;
								}
								else {
									switch ((b >> (~column & 6)) & 3) {
									case 1:
										c = 1;
										break;
									case 2:
										c = spriteOffset + 63;
										break;
									case 3:
										c = 2;
										break;
									default:
										break;
									}
								}
							}
						}
					}
					self->pixels[y * width + x] = RECOIL_C64Palette[content[headerLength + c] & 15];
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeSpr(RECOIL *self, unsigned char const *content, int contentLength)
{
	SprStream s;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_APPLE_I_I1X1);
	{
		int i;
		for (i = 0; i < 64000; i++)
			self->pixels[i] = 0;
	}
	s.base.content = content;
	s.base.contentOffset = 0;
	s.base.contentLength = contentLength;
	for (;;) {
		int cols = SprStream_ReadInt(&s);
		int rows;
		int order;
		int x;
		int y;
		if (cols < 0)
			return FALSE;
		rows = SprStream_ReadInt(&s);
		if (rows < 0)
			return FALSE;
		order = SprStream_ReadInt(&s);
		if (order < 0)
			return FALSE;
		x = SprStream_ReadInt(&s);
		if (x < 0)
			return FALSE;
		y = SprStream_ReadInt(&s);
		if (y < 0)
			return FALSE;
		if (rows == 0)
			break;
		if (cols == 0 || x + (cols << 3) > 320 || y + rows > 200)
			return FALSE;
		if (order == 2) {
			{
				int col;
				for (col = 0; col < cols; col++) {
					{
						int row;
						for (row = 0; row < rows; row++) {
							int b = SprStream_ReadInt(&s);
							if (b < 0)
								return FALSE;
							RECOIL_DrawSprByte(self, x + (col << 3), y + row, b);
						}
					}
				}
			}
		}
		else {
			{
				int row;
				for (row = 0; row < rows; row++) {
					{
						int col;
						for (col = 0; col < cols; col++) {
							int b = SprStream_ReadInt(&s);
							if (b < 0)
								return FALSE;
							RECOIL_DrawSprByte(self, x + (col << 3), y + row, b);
						}
					}
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeSps(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[51104];
	SpsStream rle;
	BitStream bitStream;
	if (contentLength < 13 || content[0] != 83 || content[1] != 80 || content[2] != 0 || content[3] != 0)
		return FALSE;
	SpsStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 12;
	rle.base.base.base.contentLength = contentLength;
	if ((content[contentLength - 1] & 1) == 0) {
		{
			int bitplane;
			for (bitplane = 0; bitplane < 8; bitplane += 2) {
				{
					int x;
					for (x = 0; x < 40; x++) {
						if (!RleStream_Unpack(&rle.base, unpacked, 160 + ((x & ~1) << 2) + bitplane + (x & 1), 160, 32000))
							return FALSE;
					}
				}
			}
		}
	}
	else if (!RECOIL_UnpackSpc(&rle.base, unpacked))
		return FALSE;
	BitStream_Construct(&bitStream);
	bitStream.base.content = content;
	bitStream.base.contentOffset = 12 + RECOIL_Get32BigEndian(content, 4);
	if (bitStream.base.contentOffset < 12)
		return FALSE;
	bitStream.base.contentLength = contentLength;
	{
		int unpackedOffset;
		for (unpackedOffset = 32000; unpackedOffset < 51104;) {
			int got = BitStream_ReadBits(&bitStream, 14);
			if (got < 0)
				return FALSE;
			got <<= 1;
			{
				int i;
				for (i = 15; i >= 0; i--) {
					int rgb;
					if (((got >> i) & 1) == 0)
						rgb = 0;
					else {
						rgb = BitStream_ReadBits(&bitStream, 9);
						if (rgb < 0)
							return FALSE;
					}
					unpacked[unpackedOffset] = rgb >> 6;
					unpacked[unpackedOffset + 1] = (rgb & 63) + (rgb & 56);
					unpackedOffset += 2;
				}
			}
		}
	}
	return RECOIL_DecodeSpuScreen(self, unpacked, 160, 199, FALSE);
}

static cibool RECOIL_DecodeSpu(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 51104 && RECOIL_DecodeSpuScreen(self, content, 160, 199, RECOIL_IsStringAt(content, 0, "5BIT"));
}

static cibool RECOIL_DecodeSpuScreen(RECOIL *self, unsigned char const *content, int bitmapOffset, int height, cibool enhanced)
{
	int paletteOffset = bitmapOffset + height * 160;
	int pixelsOffset;
	if (!RECOIL_SetSize(self, 320, height, enhanced || RECOIL_IsStePalette(content, paletteOffset, height * 48) ? RECOILResolution_STE1X1 : RECOILResolution_ST1X1))
		return FALSE;
	if (enhanced)
		self->frames = 2;
	pixelsOffset = 0;
	{
		int y;
		for (y = 0; y < height; y++) {
			{
				int x;
				for (x = 0; x < 320; x++) {
					int c = RECOIL_GetStLowColor(content, bitmapOffset, pixelsOffset);
					int x1 = c * 10 + 1 - (c & 1) * 6;
					int colorOffset;
					if (x >= x1 + 160)
						c += 32;
					else if (x >= x1)
						c += 16;
					colorOffset = paletteOffset + y * 96 + (c << 1);
					self->pixels[pixelsOffset++] = enhanced ? RECOIL_GetSteInterlacedColor((content[colorOffset] << 8) | content[colorOffset + 1]) : RECOIL_GetStColor(self, content, colorOffset);
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeSpx(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset;
	int zerosToSkip;
	int bitmapLength;
	SpxStream stream;
	int height;
	unsigned char *unpacked;
	cibool ok;
	if (contentLength < 12 || content[0] != 83 || content[1] != 80 || content[2] != 88)
		return FALSE;
	contentOffset = 10;
	zerosToSkip = 2;
	do {
		if (contentOffset + 16 >= contentLength)
			return FALSE;
	}
	while (content[contentOffset++] != 0 || --zerosToSkip > 0);
	bitmapLength = RECOIL_Get32BigEndian(content, contentOffset);
	stream.base.content = content;
	stream.base.contentStart = contentOffset + 8;
	stream.base.contentOffset = contentOffset + 8 + bitmapLength;
	if (stream.base.contentOffset > contentLength)
		return FALSE;
	switch (content[4]) {
	case 0:
		bitmapLength -= 160;
		break;
	case 1:
		switch (content[3]) {
		case 1:
			bitmapLength = Ice21Stream_GetUnpackedLength(&stream.base) - 160;
			break;
		case 2:
			bitmapLength = RECOIL_Get32BigEndian(content, contentOffset + 4) - 320;
			break;
		default:
			return FALSE;
		}
		break;
	default:
		return FALSE;
	}
	if (bitmapLength <= 0 || bitmapLength % 160 != 0)
		return FALSE;
	height = bitmapLength / 160;
	unpacked = (unsigned char *) malloc((height << 8) * sizeof(unsigned char ));
	ok = RECOIL_UnpackAndDecodeSpx(self, &stream, contentLength, height, unpacked);
	free(unpacked);
	return ok;
}

static cibool RECOIL_DecodeSr5(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	if (contentLength < 27143 || content[0] != 254 || RECOIL_GetMsxHeader(content) < 27135)
		return FALSE;
	RECOIL_SetMsxCompanionPalette(self, filename, "PL5", "pl5");
	RECOIL_DecodeMsx5(self, content);
	return TRUE;
}

static cibool RECOIL_DecodeSr6(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	if (contentLength < 27143 || content[0] != 254 || RECOIL_GetMsxHeader(content) < 27135)
		return FALSE;
	RECOIL_SetSize(self, 512, 424, RECOILResolution_MSX21X2);
	RECOIL_SetMsx6Palette(self, filename);
	return RECOIL_DecodeMsx6(self, content, 7);
}

static cibool RECOIL_DecodeSr7(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[54279];
	memset(unpacked, 0, sizeof(unpacked));
	content = RECOIL_UnpackSr(content, contentLength, unpacked);
	if (content == NULL)
		return FALSE;
	RECOIL_SetMsxCompanionPalette(self, filename, "PL7", "pl7");
	RECOIL_DecodeMsx7(self, content);
	return TRUE;
}

static cibool RECOIL_DecodeSri(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	if (contentLength != 108544)
		return FALSE;
	RECOIL_SetMsxCompanionPalette(self, filename, "PL7", "pl7");
	RECOIL_SetSize(self, 512, 424, RECOILResolution_MSX21X1);
	self->frames = 2;
	RECOIL_DecodeNibbles(self, content, 0, 256);
	return TRUE;
}

static cibool RECOIL_DecodeSrt(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 32038)
		return FALSE;
	RECOIL_DecodeStMedium(self, content, 0, content, 32006, 640, 200, 0);
	return TRUE;
}

static cibool RECOIL_DecodeSsb(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 32768 && RECOIL_DecodeStLow(self, content, 0, content, 32000, 320, 200);
}

static cibool RECOIL_DecodeSt(RECOIL *self, unsigned char const *bitmap, int bitmapOffset, unsigned char const *palette, int paletteOffset, int mode, int doubleHeight)
{
	switch (mode) {
	case 0:
		return RECOIL_DecodeStLow(self, bitmap, bitmapOffset, palette, paletteOffset, 320, 200 << doubleHeight);
	case 1:
		RECOIL_DecodeStMedium(self, bitmap, bitmapOffset, palette, paletteOffset, 640, 200 << doubleHeight, 0);
		return TRUE;
	case 2:
		RECOIL_SetSize(self, 640, 400 << doubleHeight, RECOILResolution_ST1X1);
		return RECOIL_DecodeBlackAndWhite(self, bitmap, bitmapOffset, bitmapOffset + (32000 << doubleHeight), FALSE, 16777215);
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeStFnt(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 2050:
		RECOIL_SetSize(self, 256, 64, RECOILResolution_ST1X1);
		break;
	case 4096:
	case 4098:
		RECOIL_SetSize(self, 256, 128, RECOILResolution_ST1X1);
		break;
	default:
		return FALSE;
	}
	if ((contentLength & 2) != 0) {
		if (content[contentLength - 2] != 0 || content[contentLength - 2] > 1)
			return FALSE;
		contentLength -= 2;
	}
	RECOIL_DecodeBlackAndWhiteFont(self, content, 0, contentLength, 16);
	return TRUE;
}

static cibool RECOIL_DecodeStIcn(RECOIL *self, unsigned char const *content, int contentLength)
{
	IcnParser parser;
	int width;
	int height;
	int size;
	unsigned char bitmap[8192];
	parser.base.content = content;
	parser.base.contentOffset = 0;
	parser.base.contentLength = contentLength;
	width = IcnParser_ParseDefine(&parser, "ICON_W");
	if (width <= 0 || width >= 256)
		return FALSE;
	height = IcnParser_ParseDefine(&parser, "ICON_H");
	if (height <= 0 || height >= 256)
		return FALSE;
	size = IcnParser_ParseDefine(&parser, "ICONSIZE");
	if (size != ((width + 15) >> 4) * height)
		return FALSE;
	if (!IcnParser_Expect(&parser, "int") || !IcnParser_Expect(&parser, "image[ICONSIZE]") || !IcnParser_Expect(&parser, "=") || !IcnParser_Expect(&parser, "{"))
		return FALSE;
	{
		int i;
		for (i = 0;;) {
			int value = IcnParser_ParseHex(&parser);
			if (value < 0)
				return FALSE;
			bitmap[i * 2] = value >> 8;
			bitmap[i * 2 + 1] = (unsigned char) value;
			if (++i >= size)
				break;
			if (parser.base.contentOffset >= contentLength || content[parser.base.contentOffset++] != 44)
				return FALSE;
		}
	}
	if (!IcnParser_Expect(&parser, "};"))
		return FALSE;
	RECOIL_SetSize(self, width, height, RECOILResolution_ST1X1);
	return RECOIL_DecodeBlackAndWhite(self, bitmap, 0, size << 1, TRUE, 16777215);
}

static cibool RECOIL_DecodeStImg(RECOIL *self, unsigned char const *content, int contentLength)
{
	int headerLength;
	int bitplanes;
	int width;
	int height;
	int xRatio;
	int yRatio;
	ImgStream rle;
	int bytesPerBitplane;
	int bytesPerLine;
	unsigned char unpacked[8192];
	if (contentLength < 17 || content[0] != 0 || content[1] == 0 || content[1] > 3 || content[4] != 0)
		return FALSE;
	headerLength = ((content[2] << 8) | content[3]) << 1;
	if (headerLength < 16 || headerLength >= contentLength)
		return FALSE;
	bitplanes = content[5];
	width = (content[12] << 8) | content[13];
	height = (content[14] << 8) | content[15];
	if (headerLength == 18 && content[16] == 0 && content[17] == 3) {
		int contentOffset;
		int pixelsLength;
		int count;
		RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1);
		contentOffset = 18;
		pixelsLength = width * height;
		count = 0;
		{
			int i;
			for (i = 0; i < pixelsLength; i++) {
				if (count == 0) {
					if (contentOffset + 1 >= contentLength || content[contentOffset++] != 128)
						return FALSE;
					count = content[contentOffset++];
					if (count == 0)
						return FALSE;
				}
				if (contentOffset + 2 >= contentLength)
					return FALSE;
				self->pixels[i] = (content[contentOffset + 2] << 16) | (content[contentOffset + 1] << 8) | content[contentOffset];
				contentOffset += 3;
				count--;
			}
		}
		return TRUE;
	}
	switch (bitplanes) {
	case 1:
	case 2:
	case 4:
	case 8:
		if (headerLength == 22 + (6 << bitplanes) && RECOIL_IsXimg(content)) {
			{
				int i;
				for (i = 0; i < 1 << bitplanes; i++)
					self->contentPalette[i] = RECOIL_GetStVdiColor(content, 22 + i * 6);
			}
		}
		else if (headerLength == 22 + (2 << bitplanes) && RECOIL_IsSttt(content, bitplanes))
			RECOIL_SetStPalette(self, content, 22, 1 << bitplanes);
		else if (bitplanes == 8) {
			int rgb = 16777215;
			{
				int c;
				for (c = 0; c < 256; c++) {
					self->contentPalette[c] = rgb;
					{
						int mask;
						for (mask = 8421504;; mask >>= 1) {
							rgb ^= mask;
							if ((rgb & mask) == 0)
								break;
						}
					}
				}
			}
		}
		else if (headerLength == 50 && content[16] == 0 && content[17] == 128)
			RECOIL_SetStPalette(self, content, 18, 16);
		else
			RECOIL_SetDefaultStPalette(self, bitplanes);
		break;
	case 15:
		if (headerLength != 28 || !RECOIL_IsTimg(content))
			return FALSE;
		break;
	case 16:
	case 24:
	case 32:
		break;
	default:
		return FALSE;
	}
	xRatio = (content[8] << 8) | content[9];
	yRatio = (content[10] << 8) | content[11];
	if (bitplanes <= 2 && width <= 640 && height <= 200 && yRatio * 2 > xRatio * 3)
		RECOIL_SetSize(self, width, height << 1, RECOILResolution_ST1X2);
	else if (bitplanes <= 8 && width <= 320 && height <= 480 && xRatio * 2 > yRatio * 3)
		RECOIL_SetSize(self, width << 1, height, RECOILResolution_TT2X1);
	else if (!RECOIL_SetSizeStOrFalcon(self, width, height, bitplanes, TRUE))
		return FALSE;
	ImgStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = headerLength;
	rle.base.base.base.contentLength = contentLength;
	bytesPerBitplane = (width + 7) >> 3;
	if (bitplanes == 24)
		bytesPerBitplane = (bytesPerBitplane + 1) & ~1;
	bytesPerLine = bitplanes * bytesPerBitplane;
	memset(unpacked, 0, sizeof(unpacked));
	{
		int y;
		for (y = 0; y < height;) {
			int lineRepeatCount = ImgStream_GetLineRepeatCount(&rle);
			if (lineRepeatCount > height - y)
				lineRepeatCount = height - y;
			{
				int x;
				for (x = 0; x < bytesPerLine; x++) {
					int b = RleStream_ReadRle(&rle.base);
					if (b < 0)
						return FALSE;
					if (b != 256)
						unpacked[x] = b;
				}
			}
			{
				int x;
				for (x = 0; x < width; x++) {
					int c;
					switch (bitplanes) {
						int bit;
					case 16:
						c = RECOIL_GetFalconTrueColor(unpacked, x << 1);
						break;
					case 24:
						c = RECOIL_GetR8G8B8Color(unpacked, x * 3);
						break;
					case 32:
						c = RECOIL_GetR8G8B8Color(unpacked, (x << 2) + 1);
						break;
					default:
						bit = ~x & 7;
						c = 0;
						{
							int bitplane;
							for (bitplane = 0; bitplane < bitplanes; bitplane++)
								c |= ((unpacked[bitplane * bytesPerBitplane + (x >> 3)] >> bit) & 1) << bitplane;
						}
						c = bitplanes == 15 ? RECOIL_GetB5G5R5Color(c) : self->contentPalette[c];
						break;
					}
					{
						int i;
						for (i = 0; i < lineRepeatCount; i++)
							RECOIL_SetScaledPixel(self, x, y + i, c);
					}
				}
			}
			y += lineRepeatCount;
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeStLow(RECOIL *self, unsigned char const *bitmap, int bitmapOffset, unsigned char const *palette, int paletteOffset, int width, int height)
{
	return RECOIL_DecodeStLowWithStride(self, bitmap, bitmapOffset, (width + 15) >> 4 << 3, palette, paletteOffset, width, height);
}

static cibool RECOIL_DecodeStLowBlend(RECOIL *self, unsigned char const *bitmap, int bitmapOffset, unsigned char const *palette, int paletteOffset, int width, int height)
{
	RECOIL_DecodeStLow(self, bitmap, bitmapOffset, palette, paletteOffset, width, height);
	RECOIL_DecodeBitplanes(self, bitmap, bitmapOffset + (width >> 1) * height, width >> 1, 4, width * height, width, height);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodeStLowWithStride(RECOIL *self, unsigned char const *bitmap, int bitmapOffset, int bitmapStride, unsigned char const *palette, int paletteOffset, int width, int height)
{
	RECOIL_SetSize(self, width, height, RECOIL_IsStePalette(palette, paletteOffset, 16) ? RECOILResolution_STE1X1 : RECOILResolution_ST1X1);
	RECOIL_SetStPalette(self, palette, paletteOffset, 16);
	RECOIL_DecodeBitplanes(self, bitmap, bitmapOffset, bitmapStride, 4, 0, width, height);
	return TRUE;
}

static void RECOIL_DecodeStMedium(RECOIL *self, unsigned char const *bitmap, int bitmapOffset, unsigned char const *palette, int paletteOffset, int width, int height, int blend)
{
	RECOIL_SetSize(self, width, height << 1, RECOIL_IsStePalette(palette, paletteOffset, 4) ? RECOILResolution_STE1X2 : RECOILResolution_ST1X2);
	RECOIL_SetStPalette(self, palette, paletteOffset, 4);
	RECOIL_DecodeScaledBitplanes(self, bitmap, bitmapOffset, width, height << blend, 2, FALSE, NULL);
}

static cibool RECOIL_DecodeStPi(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength < 32034 || content[0] != 0)
		return FALSE;
	switch (contentLength) {
	case 32034:
	case 32066:
	case 32128:
		return RECOIL_DecodeSt(self, content, 34, content, 2, content[1], 0);
	case 38434:
		return content[1] == 4 && RECOIL_DecodeStLow(self, content, 34, content, 2, 320, 240);
	case 44834:
		return content[1] == 0 && RECOIL_DecodeStLow(self, content, 34, content, 2, 320, 280);
	case 64034:
		return RECOIL_DecodeSt(self, content, 34, content, 2, content[1], 1);
	case 116514:
		return content[1] == 0 && RECOIL_DecodeStLow(self, content, 34, content, 2, 416, 560);
	case 153606:
		if (content[1] != 6)
			return FALSE;
		RECOIL_SetSize(self, 1280, 960, RECOILResolution_TT1X1);
		return RECOIL_DecodeBlackAndWhite(self, content, 6, contentLength, FALSE, 16777215);
	case 153634:
		if (content[1] != 4)
			return FALSE;
		RECOIL_SetSize(self, 640, 480, RECOILResolution_TT1X1);
		RECOIL_SetStPalette(self, content, 2, 16);
		RECOIL_DecodeBitplanes(self, content, 34, 320, 4, 0, 640, 480);
		return TRUE;
	case 154114:
		if (content[1] != 7)
			return FALSE;
		RECOIL_SetSize(self, 640, 480, RECOILResolution_TT2X1);
		RECOIL_SetStPalette(self, content, 2, 256);
		RECOIL_DecodeScaledBitplanes(self, content, 514, 320, 480, 8, FALSE, NULL);
		return TRUE;
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeStRgb(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 96102)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_STE1X1);
	self->frames = 3;
	{
		int i;
		for (i = 0; i < 64000; i++) {
			int rgb = (RECOIL_GetStLowColor(content, 34, i) << 16) | (RECOIL_GetStLowColor(content, 32068, i) << 8) | RECOIL_GetStLowColor(content, 64102, i);
			self->pixels[i] = rgb * 17;
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeStSpc(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char unpacked[51104];
	SpcStream rle;
	int contentOffset;
	if (contentLength < 12 || content[0] != 83 || content[1] != 80)
		return FALSE;
	SpcStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 12;
	rle.base.base.base.contentLength = contentLength;
	if (!RECOIL_UnpackSpc(&rle.base, unpacked))
		return FALSE;
	contentOffset = 12 + RECOIL_Get32BigEndian(content, 4);
	if (contentOffset < 12)
		return FALSE;
	{
		int unpackedOffset;
		for (unpackedOffset = 32000; unpackedOffset < 51104;) {
			int got;
			if (contentOffset >= contentLength - 1)
				return FALSE;
			got = ((content[contentOffset] & 127) << 8) | content[contentOffset + 1];
			contentOffset += 2;
			{
				int i;
				for (i = 0; i < 16; i++) {
					if (((got >> i) & 1) == 0) {
						unpacked[unpackedOffset] = 0;
						unpacked[unpackedOffset + 1] = 0;
					}
					else {
						if (contentOffset >= contentLength - 1)
							return FALSE;
						unpacked[unpackedOffset] = content[contentOffset];
						unpacked[unpackedOffset + 1] = content[contentOffset + 1];
						contentOffset += 2;
					}
					unpackedOffset += 2;
				}
			}
		}
	}
	return RECOIL_DecodeSpuScreen(self, unpacked, 160, 199, FALSE);
}

static cibool RECOIL_DecodeStp(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	if (contentLength < 5)
		return FALSE;
	width = content[0] | (content[1] << 8);
	height = content[2] | (content[3] << 8);
	if (contentLength < 4 + ((width * height + 3) >> 2) || !RECOIL_SetSize(self, width, height << 1, RECOILResolution_MSX21X2))
		return FALSE;
	self->contentPalette[0] = 16777215;
	self->contentPalette[1] = 0;
	self->contentPalette[3] = self->contentPalette[2] = 0;
	return RECOIL_DecodeMsx6(self, content, 4);
}

static cibool RECOIL_DecodeSxg(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	int paletteOffset;
	int bitmapOffset;
	int paletteLength;
	int colors;
	if (contentLength < 19 || content[0] != 127 || content[1] != 83 || content[2] != 88 || content[3] != 71 || content[6] != 0)
		return FALSE;
	width = content[8] | (content[9] << 8);
	height = content[10] | (content[11] << 8);
	if (!RECOIL_SetSize(self, width, height, RECOILResolution_SPECTRUM1X1))
		return FALSE;
	paletteOffset = 14 + content[12] + (content[13] << 8);
	bitmapOffset = 16 + content[14] + (content[15] << 8);
	paletteLength = bitmapOffset - paletteOffset;
	if ((paletteLength & 1) != 0 || paletteLength > 512)
		return FALSE;
	memset(self->contentPalette, 0, sizeof(self->contentPalette));
	colors = paletteLength >> 1;
	{
		int i;
		for (i = 0; i < colors; i++) {
			int offset = paletteOffset + (i << 1);
			int c = content[offset] | (content[offset + 1] << 8);
			if (c < 32768) {
				int r = c >> 10;
				int g = (c >> 5) & 31;
				int b = c & 31;
				if (r > 24 || g > 24 || b > 24)
					return FALSE;
				c = (r * 255 / 24 << 16) | (g * 255 / 24 << 8) | b * 255 / 24;
			}
			else
				c = RECOIL_GetR5G5B5Color(c);
			self->contentPalette[i] = c;
		}
	}
	switch (content[7]) {
	case 1:
		if ((width & 1) != 0 || contentLength != bitmapOffset + (width >> 1) * height)
			return FALSE;
		RECOIL_DecodeNibbles(self, content, bitmapOffset, width >> 1);
		return TRUE;
	case 2:
		if (contentLength != bitmapOffset + width * height)
			return FALSE;
		RECOIL_DecodeBytes(self, content, bitmapOffset);
		return TRUE;
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeSxs(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char characters[128];
	if (contentLength != 1030 || RECOIL_ParseAtari8ExecutableHeader(content, 0) != 1024)
		return FALSE;
	{
		int i;
		for (i = 0; i < 128; i++)
			characters[i] = (i & 65) | ((i >> 4) & 2) | ((i & 30) << 1);
	}
	return RECOIL_DecodeAtari8Font(self, characters, content, 6);
}

static cibool RECOIL_DecodeTcp(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength >= 218 && RECOIL_IsStringAt(content, 0, "TRUECOLR") && content[12] == 0 && content[13] == 18 && content[14] == 0 && content[15] == 1 && content[16] == 0 && content[17] == 1 && RECOIL_IsStringAt(content, 18, "PICT") && RECOIL_DecodeFalconTrueColorVariable(self, content, contentLength, 28, 216);
}

static cibool RECOIL_DecodeTg1(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength >= 20 && RECOIL_IsStringAt(content, 0, "COKE format.") && content[16] == 0 && content[17] == 18 && RECOIL_DecodeFalconTrueColorVariable(self, content, contentLength, 12, 18);
}

static cibool RECOIL_DecodeTim(RECOIL *self, unsigned char const *content, int contentLength)
{
	int pixelsLength;
	int bitmapOffset;
	if (contentLength < 20 || RECOIL_Get32LittleEndian(content, 0) != 16)
		return FALSE;
	switch (content[4] & 15) {
		int width;
		int height;
	case 2:
		width = content[16] | (content[17] << 8);
		height = content[18] | (content[19] << 8);
		pixelsLength = width * height;
		if (contentLength < 20 + (pixelsLength << 1) || !RECOIL_SetSize(self, width, height, RECOILResolution_PLAY_STATION1X1))
			return FALSE;
		RECOIL_DecodePlayStation(content, 20, self->pixels, pixelsLength);
		return TRUE;
	case 8:
		bitmapOffset = RECOIL_DecodeTimPalette(self, content, contentLength, 16);
		if (bitmapOffset < 0)
			return FALSE;
		pixelsLength = self->width * self->height;
		{
			int i;
			for (i = 0; i < pixelsLength; i++) {
				int b = content[bitmapOffset + (i >> 1)];
				self->pixels[i] = self->contentPalette[(i & 1) == 0 ? b & 15 : b >> 4];
			}
		}
		return TRUE;
	case 9:
		bitmapOffset = RECOIL_DecodeTimPalette(self, content, contentLength, 256);
		if (bitmapOffset < 0)
			return FALSE;
		RECOIL_DecodeBytes(self, content, bitmapOffset);
		return TRUE;
	default:
		return FALSE;
	}
}

static int RECOIL_DecodeTimPalette(RECOIL *self, unsigned char const *content, int contentLength, int colors)
{
	int paletteCount;
	int bitmapOffset;
	int width;
	int height;
	if ((content[16] | (content[17] << 8)) != colors)
		return -1;
	paletteCount = content[18] | (content[19] << 8);
	if (paletteCount == 0)
		return -1;
	bitmapOffset = 20 + (paletteCount * colors << 1);
	if (RECOIL_Get32LittleEndian(content, 8) != bitmapOffset - 8 || contentLength < bitmapOffset + 12)
		return -1;
	width = (content[bitmapOffset + 8] | (content[bitmapOffset + 9] << 8)) << 1;
	height = content[bitmapOffset + 10] | (content[bitmapOffset + 11] << 8);
	if (contentLength < bitmapOffset + 12 + width * height)
		return -1;
	if (colors == 16)
		width <<= 1;
	if (!RECOIL_SetSize(self, width, height, RECOILResolution_PLAY_STATION1X1))
		return -1;
	RECOIL_DecodePlayStation(content, 20, self->contentPalette, colors);
	return bitmapOffset + 12;
}

static void RECOIL_DecodeTimexHires(RECOIL *self, unsigned char const *content)
{
	int inkColor;
	RECOIL_SetSize(self, 512, 384, RECOILResolution_TIMEX1X2);
	inkColor = RECOIL_GetZxColor(content[12288] >> 3);
	{
		int y;
		for (y = 0; y < 192; y++) {
			{
				int x;
				for (x = 0; x < 512; x++) {
					int c = (content[(x & 8) * 768 + ((y & 192) << 5) + ((y & 7) << 8) + ((y & 56) << 2) + (x >> 4)] >> (~x & 7)) & 1;
					int offset = (y << 10) + x;
					self->pixels[offset + 512] = self->pixels[offset] = c == 0 ? inkColor ^ 16777215 : inkColor;
				}
			}
		}
	}
}

static cibool RECOIL_DecodeTip(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	int contentStride;
	int frameLength;
	static const unsigned char colors[9] = { 0, 2, 4, 6, 8, 10, 12, 14, 0 };
	unsigned char frame1[76160];
	unsigned char frame2[76160];
	if (contentLength < 129 || content[0] != 84 || content[1] != 73 || content[2] != 80 || content[3] != 1 || content[4] != 0)
		return FALSE;
	width = content[5];
	height = content[6];
	if (width > 160 || (width & 3) != 0 || height > 119)
		return FALSE;
	contentStride = width >> 2;
	frameLength = content[7] | (content[8] << 8);
	if (frameLength != contentStride * height || contentLength != 9 + 3 * frameLength)
		return FALSE;
	RECOIL_SetSize(self, width << 1, height << 1, RECOILResolution_XE2X2);
	self->leftSkip = 1;
	RECOIL_SetGtiaColors(self, colors, 0);
	RECOIL_DecodeAtari8Gr9(self, content, 9, contentStride, frame1, width << 1, width << 2, width << 1, height);
	RECOIL_DecodeAtari8Gr11PalBlend(self, content, 9 + 2 * frameLength, contentStride, frame1, 0);
	RECOIL_DecodeAtari8Gr10(self, content, 9 + frameLength, frame2, width << 1, width << 2, height);
	RECOIL_DecodeAtari8Gr11PalBlend(self, content, 9 + 2 * frameLength, contentStride, frame2, 0);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeTny(RECOIL *self, unsigned char const *content, int contentLength)
{
	int mode;
	int contentOffset;
	int controlLength;
	int valueLength;
	TnyStream rle;
	unsigned char unpacked[32000];
	if (contentLength < 42)
		return FALSE;
	mode = content[0];
	if (mode > 2) {
		if (mode > 5)
			return FALSE;
		mode -= 3;
		contentOffset = 4;
	}
	else
		contentOffset = 0;
	controlLength = (content[contentOffset + 33] << 8) | content[contentOffset + 34];
	valueLength = ((content[contentOffset + 35] << 8) | content[contentOffset + 36]) << 1;
	if (contentOffset + 37 + controlLength + valueLength > contentLength)
		return FALSE;
	TnyStream_Construct(&rle, NULL);
	rle.base.base.base.base.content = content;
	rle.base.base.base.base.contentOffset = contentOffset + 37;
	rle.valueOffset = rle.base.base.base.base.contentLength = contentOffset + 37 + controlLength;
	rle.valueLength = contentOffset + 37 + controlLength + valueLength;
	{
		int bitplane;
		for (bitplane = 0; bitplane < 8; bitplane += 2) {
			{
				int x;
				for (x = bitplane; x < 160; x += 8) {
					{
						int unpackedOffset;
						for (unpackedOffset = x; unpackedOffset < 32000; unpackedOffset += 160) {
							int b = RleStream_ReadRle(&rle.base.base);
							if (b < 0)
								return FALSE;
							unpacked[unpackedOffset] = b >> 8;
							unpacked[unpackedOffset + 1] = (unsigned char) b;
						}
					}
				}
			}
		}
	}
	return RECOIL_DecodeSt(self, unpacked, 0, content, contentOffset + 1, mode, 0);
}

static cibool RECOIL_DecodeTre(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	Tre1Stream rle;
	int pixelsLength;
	if (contentLength < 13 || !RECOIL_IsStringAt(content, 0, "tre1"))
		return FALSE;
	width = (content[4] << 8) | content[5];
	height = (content[6] << 8) | content[7];
	if (!RECOIL_SetSize(self, width, height, RECOILResolution_FALCON1X1))
		return FALSE;
	Tre1Stream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 12;
	rle.base.base.base.contentLength = contentLength;
	pixelsLength = width * height;
	{
		int i;
		for (i = 0; i < pixelsLength; i++) {
			int rgb = RleStream_ReadRle(&rle.base);
			if (rgb < 0)
				return FALSE;
			self->pixels[i] = rgb;
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeTrp(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength >= 9 && (RECOIL_IsStringAt(content, 0, "TRUP") || RECOIL_IsStringAt(content, 0, "tru?")) && RECOIL_DecodeFalconTrueColorVariable(self, content, contentLength, 4, 8);
}

static cibool RECOIL_DecodeTrsHr(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 19200:
	case 19328:
	case 19456:
		break;
	default:
		return FALSE;
	}
	RECOIL_SetSize(self, 640, 480, RECOILResolution_TRS1X2);
	{
		int y;
		for (y = 0; y < 240; y++) {
			{
				int x;
				for (x = 0; x < 640; x++) {
					int c = (content[y * 80 + (x >> 3)] >> (~x & 7)) & 1;
					int pixelsOffset;
					if (c != 0)
						c = 16777215;
					pixelsOffset = y * 1280 + x;
					self->pixels[pixelsOffset + 640] = self->pixels[pixelsOffset] = c;
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeTrsShr(RECOIL *self, unsigned char const *content, int contentLength)
{
	PgcStream rle;
	RECOIL_SetSize(self, 640, 480, RECOILResolution_TRS1X2);
	PgcStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 0;
	rle.base.base.base.contentLength = contentLength;
	return RECOIL_DecodeRleBlackAndWhite(self, &rle.base, 0);
}

static cibool RECOIL_DecodeTru(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength >= 256 && RECOIL_IsStringAt(content, 0, "Indy") && RECOIL_DecodeFalconTrueColorVariable(self, content, contentLength, 4, 256);
}

static cibool RECOIL_DecodeTx0(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 257 && RECOIL_Decode16x16x16(self, content, 0, content[256] & 254);
}

static cibool RECOIL_DecodeTxe(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame[61440];
	if (contentLength != 3840)
		return FALSE;
	RECOIL_SetSize(self, 320, 192, RECOILResolution_XE4X2);
	self->gtiaColors[8] = 0;
	RECOIL_DecodeAtari8Gr9(self, content, 0, 40, frame, 320, 640, 320, 96);
	RECOIL_DecodeAtari8Gr9(self, content, 0, 40, frame, 0, 640, 320, 96);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeTxs(RECOIL *self, unsigned char const *content, int contentLength)
{
	return contentLength == 262 && content[0] == 255 && content[1] == 255 && content[2] == 0 && content[3] == 6 && content[4] == 255 && content[5] == 6 && RECOIL_Decode16x16x16(self, content, 6, 0);
}

static cibool RECOIL_DecodeVbm(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	if (contentLength < 9 || content[0] != 66 || content[1] != 77 || content[2] != 203 || content[3] != 2)
		return FALSE;
	width = (content[4] << 8) | content[5];
	height = (content[6] << 8) | content[7];
	return RECOIL_SetSize(self, width, height, RECOILResolution_C1281X1) && RECOIL_DecodeBlackAndWhite(self, content, 8, contentLength, FALSE, 16777215);
}

static cibool RECOIL_DecodeVic(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 9002:
	case 9003:
	case 9009:
		return RECOIL_DecodeIph(self, content, contentLength);
	case 10018:
		return RECOIL_DecodeOcp(self, content, contentLength);
	case 10241:
	case 10242:
		return RECOIL_DecodeDol(self, content, contentLength);
	case 17218:
	case 17409:
	case 17410:
		return RECOIL_DecodeFli(self, content, contentLength);
	case 17474:
	case 17665:
	case 17666:
		return RECOIL_DecodeBml(self, content, contentLength);
	case 18242:
		return RECOIL_DecodeDrl(self, content, contentLength);
	case 33602:
	case 33603:
		return RECOIL_DecodeGun(self, content, contentLength);
	case 33694:
		return RECOIL_DecodeC64Fun(self, content, contentLength);
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeVzi(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char frame1[64000];
	unsigned char frame2[64000];
	if (contentLength != 16000)
		return FALSE;
	RECOIL_SetSize(self, 320, 200, RECOILResolution_XE2X1);
	self->leftSkip = -1;
	RECOIL_DecodeAtari8Gr9(self, content, 0, 40, frame1, 0, 320, 320, 200);
	self->leftSkip = 1;
	RECOIL_DecodeAtari8Gr9(self, content, 8000, 40, frame2, 0, 320, 320, 200);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeWin(RECOIL *self, const char *filename, unsigned char const *content, int contentLength)
{
	int width;
	int height;
	int bytesPerLine;
	unsigned char unpacked[16000];
	int contentOffset;
	if (contentLength < 6)
		return FALSE;
	width = content[contentLength - 4] | (content[contentLength - 3] << 8);
	if (width == 0 || width > 640)
		return FALSE;
	height = content[contentLength - 2];
	if (height == 0 || height > 200)
		return FALSE;
	bytesPerLine = (width + 7) >> 3;
	contentOffset = RECOIL_GetAmstradHeader(content, contentLength);
	if (contentLength != contentOffset + bytesPerLine * height + 5) {
		if (!AmstradStream_UnpackFile(content, contentOffset, contentLength, unpacked, bytesPerLine * height))
			return FALSE;
		content = unpacked;
		contentOffset = 0;
	}
	if (RECOIL_SetAmstradPalette(self, filename) != 0)
		return FALSE;
	width >>= 1;
	RECOIL_SetSize(self, width, height, RECOILResolution_AMSTRAD2X1);
	{
		int y;
		for (y = 0; y < height; y++)
			RECOIL_DecodeAmstradMode0Line(self, content, contentOffset + y * bytesPerLine, y);
	}
	return TRUE;
}

static cibool RECOIL_DecodeWnd(RECOIL *self, unsigned char const *content, int contentLength)
{
	int width;
	int contentStride;
	int height;
	unsigned char frame[61440];
	if (contentLength != 3072)
		return FALSE;
	width = content[0] + 1;
	contentStride = (width + 3) >> 2;
	height = content[1];
	if (contentStride > 40 || height == 0 || height > 192 || contentStride * height > 3070)
		return FALSE;
	RECOIL_SetSize(self, width << 1, height, RECOILResolution_XE2X1);
	self->gtiaColors[8] = 0;
	self->gtiaColors[4] = 70;
	self->gtiaColors[5] = 136;
	self->gtiaColors[6] = 14;
	RECOIL_DecodeAtari8Gr15(self, content, 2, contentStride, frame, 0, width << 1, height);
	return RECOIL_ApplyAtari8Palette(self, frame);
}

static cibool RECOIL_DecodeX68KPic(RECOIL *self, unsigned char const *content, int contentLength)
{
	X68KPicStream stream;
	int depth;
	int width;
	int height;
	int color;
	int pixelsLength;
	RecentInts colors;
	if (contentLength < 14 || content[0] != 80 || content[1] != 73 || content[2] != 67)
		return FALSE;
	X68KPicStream_Construct(&stream);
	stream.base.base.content = content;
	stream.base.base.contentOffset = 3;
	stream.base.base.contentLength = contentLength;
	if (!X68KPicStream_SkipUntilByte(&stream, 26) || !X68KPicStream_SkipUntilByte(&stream, 0) || BitStream_ReadBits(&stream.base, 16) != 0)
		return FALSE;
	depth = BitStream_ReadBits(&stream.base, 16);
	switch (depth) {
	case 4:
	case 8:
	case 15:
	case 16:
		break;
	default:
		return FALSE;
	}
	width = BitStream_ReadBits(&stream.base, 16);
	height = BitStream_ReadBits(&stream.base, 16);
	if (!RECOIL_SetSize(self, width, height, RECOILResolution_X68_K1X1))
		return FALSE;
	if (depth <= 8) {
		{
			int c;
			for (c = 0; c < 1 << depth; c++) {
				color = BitStream_ReadBits(&stream.base, 16);
				if (color < 0)
					return FALSE;
				self->contentPalette[c] = RECOIL_GetX68KColor(color);
			}
		}
	}
	pixelsLength = width * height;
	{
		int pixelsOffset;
		for (pixelsOffset = 0; pixelsOffset < pixelsLength; pixelsOffset++)
			self->pixels[pixelsOffset] = -1;
	}
	RecentInts_Construct(&colors);
	color = 0;
	{
		int pixelsOffset;
		for (pixelsOffset = -1;;) {
			int length = X68KPicStream_ReadLength(&stream);
			if (length < 0)
				return FALSE;
			while (--length > 0) {
				int got = self->pixels[++pixelsOffset];
				if (got < 0)
					self->pixels[pixelsOffset] = color;
				else
					color = got;
				if (pixelsOffset >= pixelsLength - 1)
					return TRUE;
			}
			if (depth <= 8) {
				color = BitStream_ReadBits(&stream.base, depth);
				if (color < 0)
					return FALSE;
				color = self->contentPalette[color];
			}
			else {
				switch (BitStream_ReadBit(&stream.base)) {
				case 0:
					color = BitStream_ReadBits(&stream.base, depth);
					if (color < 0)
						return FALSE;
					if (depth == 15)
						color <<= 1;
					color = RECOIL_GetX68KColor(color);
					RecentInts_Add(&colors, color);
					break;
				case 1:
					color = BitStream_ReadBits(&stream.base, 7);
					if (color < 0)
						return FALSE;
					color = RecentInts_Get(&colors, color);
					break;
				default:
					return FALSE;
				}
			}
			self->pixels[++pixelsOffset] = color;
			if (pixelsOffset >= pixelsLength - 1)
				return TRUE;
			switch (BitStream_ReadBit(&stream.base)) {
			case 0:
				break;
			case 1:
				if (!RECOIL_DecodeX68KPicChain(self, &stream.base, pixelsOffset, color))
					return FALSE;
				break;
			default:
				return FALSE;
			}
		}
	}
}

static cibool RECOIL_DecodeX68KPicChain(RECOIL *self, BitStream *stream, int pixelsOffset, int color)
{
	for (;;) {
		switch (BitStream_ReadBits(stream, 2)) {
		case 0:
			switch (BitStream_ReadBit(stream)) {
			case 0:
				return TRUE;
			case 1:
				break;
			default:
				return FALSE;
			}
			switch (BitStream_ReadBit(stream)) {
			case 0:
				pixelsOffset -= 2;
				break;
			case 1:
				pixelsOffset += 2;
				break;
			default:
				return FALSE;
			}
			break;
		case 1:
			pixelsOffset--;
			break;
		case 2:
			break;
		case 3:
			pixelsOffset++;
			break;
		default:
			return FALSE;
		}
		pixelsOffset += self->width;
		if (pixelsOffset >= self->width * self->height)
			return FALSE;
		self->pixels[pixelsOffset] = color;
	}
}

static cibool RECOIL_DecodeXga(RECOIL *self, unsigned char const *content, int contentLength)
{
	switch (contentLength) {
	case 153600:
		return RECOIL_DecodeFalconTrueColor(self, content, 0, 320, 240, RECOILResolution_FALCON1X1);
	case 368640:
		return RECOIL_DecodeFalconTrueColor(self, content, 0, 384, 480, RECOILResolution_FALCON2X1);
	default:
		return FALSE;
	}
}

static cibool RECOIL_DecodeXlp(RECOIL *self, unsigned char const *content, int contentLength)
{
	XlpStream rle;
	unsigned char unpacked[16000];
	int height;
	int colorsOffset;
	unsigned char frame1[64000];
	unsigned char frame2[64000];
	XlpStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentLength = contentLength;
	if (contentLength >= 10 && RECOIL_IsStringAt(content, 0, "XLPC")) {
		memset(unpacked, 0, sizeof(unpacked));
		rle.base.base.base.contentOffset = 8;
		RleStream_UnpackColumns(&rle.base, unpacked, 0, 40, 15360);
		height = 192;
		colorsOffset = 4;
	}
	else {
		rle.base.base.base.contentOffset = 4;
		if (RleStream_UnpackColumns(&rle.base, unpacked, 0, 40, 16000))
			height = 200;
		else {
			rle.base.base.base.contentOffset = 4;
			if (RleStream_UnpackColumns(&rle.base, unpacked, 0, 40, 15360))
				height = 192;
			else
				return FALSE;
		}
		colorsOffset = 0;
	}
	RECOIL_SetSize(self, 320, height, RECOILResolution_XE2X1);
	RECOIL_SetPF012Bak(self, content, colorsOffset);
	RECOIL_DecodeAtari8Gr15(self, unpacked, 0, 40, frame1, 0, 320, height);
	RECOIL_DecodeAtari8Gr15(self, unpacked, height * 40, 40, frame2, 0, 320, height);
	return RECOIL_ApplyAtari8PaletteBlend(self, frame1, frame2);
}

static cibool RECOIL_DecodeZp1(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char screen[768];
	Stream s;
	s.content = content;
	s.contentOffset = 0;
	s.contentLength = contentLength;
	{
		int i;
		for (i = 0; i < 768; i++) {
			int hi = Stream_ReadHexDigit(&s);
			int lo;
			if (hi < 0)
				return FALSE;
			lo = Stream_ReadHexDigit(&s);
			if (lo < 0)
				return FALSE;
			screen[i] = (hi << 4) | lo;
		}
	}
	return RECOIL_DecodeZx81(self, screen);
}

static void RECOIL_DecodeZx(RECOIL *self, unsigned char const *content, int bitmapOffset, int attributesOffset, int attributesMode, int pixelsOffset)
{
	{
		int y;
		for (y = 0; y < 192; y++) {
			{
				int x;
				for (x = 0; x < 256; x++) {
					int col = x >> 3;
					int c;
					switch (bitmapOffset) {
					case -3:
						c = x ^ y;
						break;
					case -2:
						c = content[84 + (y & 7)] >> (~x & 7);
						break;
					case -1:
						c = content[(y << 5) | col] >> (~x & 7);
						break;
					default:
						c = content[bitmapOffset + ((y & 192) << 5) + ((y & 7) << 8) + ((y & 56) << 2) + col] >> (~x & 7);
						break;
					}
					c &= 1;
					if (attributesMode == -3) {
						if (c != 0)
							c = 16777215;
					}
					else {
						int a;
						switch (attributesMode) {
						case -2:
							if (col < 8)
								a = attributesOffset + (y >> 3 << 4);
							else if (col < 24)
								a = (attributesOffset == 18688 ? 12536 : 15608) + (y << 4);
							else
								a = attributesOffset + (y >> 3 << 4) - 16;
							break;
						case -1:
							a = attributesOffset + ((y & 192) << 5) + ((y & 7) << 8) + ((y & 56) << 2);
							break;
						default:
							a = attributesOffset + (y >> attributesMode << 5);
							break;
						}
						a = content[a + col];
						c = self->contentPalette[((a >> 2) & 48) | (c == 0 ? 8 | ((a >> 3) & 7) : a & 7)];
					}
					self->pixels[pixelsOffset + (y << 8) + x] = c;
				}
			}
		}
	}
}

static cibool RECOIL_DecodeZx81(RECOIL *self, unsigned char const *screen)
{
	unsigned char const *font;
	RECOIL_SetSize(self, 256, 192, RECOILResolution_ZX811X1);
	font = CiBinaryResource_zx81_fnt;
	{
		int y;
		for (y = 0; y < 192; y++) {
			{
				int x;
				for (x = 0; x < 256; x++) {
					int c = screen[(y >> 3 << 5) | (x >> 3)];
					int b = (font[((c & 63) << 3) | (y & 7)] >> (~x & 7)) & 1;
					self->pixels[(y << 8) | x] = b == c >> 7 ? 16777215 : 0;
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeZx81Raw(RECOIL *self, unsigned char const *content, int contentLength)
{
	unsigned char screen[768];
	if (contentLength != 792)
		return FALSE;
	{
		int y;
		for (y = 0; y < 24; y++) {
			if (content[y * 33 + 32] != 118)
				return FALSE;
			memcpy(screen + y * 32, content + y * 33, 32);
		}
	}
	return RECOIL_DecodeZx81(self, screen);
}

static cibool RECOIL_DecodeZxIfl(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 9216)
		return FALSE;
	RECOIL_SetZx(self, RECOILResolution_SPECTRUM1X1);
	RECOIL_DecodeZx(self, content, 0, 6144, 1, 0);
	return TRUE;
}

static cibool RECOIL_DecodeZxImg(RECOIL *self, unsigned char const *content, int contentLength)
{
	if (contentLength != 13824)
		return FALSE;
	RECOIL_SetZx(self, RECOILResolution_SPECTRUM1X1);
	RECOIL_DecodeZx(self, content, 0, 6144, 3, 0);
	RECOIL_DecodeZx(self, content, 6912, 13056, 3, 49152);
	return RECOIL_ApplyBlend(self);
}

static cibool RECOIL_DecodeZxRgb(RECOIL *self, unsigned char const *content, int contentLength)
{
	static const unsigned char frameComponents[3] = { 16, 8, 0 };
	return RECOIL_DecodeZxRgb3(self, content, contentLength, frameComponents);
}

static cibool RECOIL_DecodeZxRgb3(RECOIL *self, unsigned char const *content, int contentLength, unsigned char const *frameComponents)
{
	if (contentLength != 18432)
		return FALSE;
	RECOIL_SetSize(self, 256, 192, RECOILResolution_SPECTRUM1X1);
	self->frames = 3;
	{
		int y;
		for (y = 0; y < 192; y++) {
			{
				int x;
				for (x = 0; x < 256; x++) {
					int offset = ((y & 192) << 5) | ((y & 7) << 8) | ((y & 56) << 2) | (x >> 3);
					int c = 0;
					{
						int frame;
						for (frame = 0; frame < 3; frame++) {
							if (((content[frame * 6144 + offset] >> (~x & 7)) & 1) != 0)
								c |= 255 << frameComponents[frame];
						}
					}
					self->pixels[(y << 8) + x] = c;
				}
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_DecodeZxp(RECOIL *self, unsigned char const *content, int contentLength)
{
	int contentOffset;
	ZxpStream s;
	unsigned char scr[12288];
	if (contentLength < 51670 || !RECOIL_IsStringAt(content, 0, "ZX-Paintbrush "))
		return FALSE;
	contentOffset = 14;
	if (RECOIL_IsStringAt(content, 14, "extended "))
		contentOffset = 23;
	if (!RECOIL_IsStringAt(content, contentOffset, "image"))
		return FALSE;
	s.base.content = content;
	s.base.contentOffset = contentOffset + 5;
	s.base.contentLength = contentLength;
	if (ZxpStream_ReadChar(&s) != 10 || ZxpStream_ReadChar(&s) != 10)
		return FALSE;
	{
		int y;
		for (y = 0; y < 192; y++) {
			int b = 0;
			{
				int x;
				for (x = 0; x < 256; x++) {
					int bit = ~x & 7;
					switch (ZxpStream_ReadChar(&s)) {
					case 42:
					case 48:
						break;
					case 49:
						b |= 1 << bit;
						break;
					default:
						return FALSE;
					}
					if (bit == 0) {
						scr[(y << 5) | (x >> 3)] = b;
						b = 0;
					}
				}
			}
			if (ZxpStream_ReadChar(&s) != 10)
				return FALSE;
		}
	}
	if (ZxpStream_ReadChar(&s) != 10)
		return FALSE;
	{
		int y;
		for (y = 0; y < 192; y++) {
			if (y == 24 && ZxpStream_IsEof(&s)) {
				RECOIL_SetZx(self, RECOILResolution_SPECTRUM1X1);
				RECOIL_DecodeZx(self, scr, -1, 6144, 3, 0);
				return TRUE;
			}
			{
				int x;
				for (x = 0; x < 32; x++) {
					int hi = Stream_ReadHexDigit(&s.base);
					int lo;
					if (hi < 0)
						return FALSE;
					lo = Stream_ReadHexDigit(&s.base);
					if (lo < 0)
						return FALSE;
					scr[6144 + (y << 5) + x] = (hi << 4) + lo;
					if (ZxpStream_ReadChar(&s) != (x < 31 ? 32 : 10))
						return FALSE;
				}
			}
		}
	}
	if (!ZxpStream_IsEof(&s))
		return FALSE;
	RECOIL_SetZx(self, RECOILResolution_SPECTRUM1X1);
	RECOIL_DecodeZx(self, scr, -1, 6144, 0, 0);
	return TRUE;
}

static cibool RECOIL_DrawBlazingPaddlesVector(RECOIL const *self, unsigned char const *content, int contentLength, unsigned char *frame, int frameOffset, int index, int startAddress)
{
	int contentOffset;
	if (index * 2 + 1 >= contentLength)
		return FALSE;
	contentOffset = content[index * 2] + (content[index * 2 + 1] << 8) - startAddress;
	if (contentOffset < 0)
		return FALSE;
	while (contentOffset < contentLength) {
		int control = content[contentOffset++];
		if (control == 8)
			return TRUE;
		for (; control >= 0; control -= 16) {
			if ((control & 4) == 0)
				frame[frameOffset + 1] = frame[frameOffset] = 14;
			switch (control & 3) {
			case 0:
				frameOffset += 2;
				break;
			case 1:
				frameOffset -= 2;
				break;
			case 2:
				frameOffset -= self->width;
				break;
			case 3:
				frameOffset += self->width;
				break;
			}
		}
	}
	return FALSE;
}

static void RECOIL_DrawSpcBrush(unsigned char *pixels, int x1, int y1, int brush, int pattern)
{
	static const unsigned char brushes[128] = { 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 48, 48, 48, 48, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 16, 56, 56, 56, 56, 16, 0, 0, 0, 0, 0, 0,
		0, 0, 16, 56, 56, 124, 124, 124, 124, 56, 56, 16, 0, 0, 0, 0,
		0, 24, 24, 60, 60, 126, 126, 126, 126, 60, 60, 24, 24, 0, 0, 0,
		16, 56, 124, 124, 124, 254, 254, 254, 254, 124, 124, 124, 56, 16, 0, 0,
		0, 0, 16, 40, 40, 80, 60, 120, 20, 40, 40, 16, 0, 0, 0, 0,
		16, 40, 84, 40, 84, 186, 124, 124, 186, 84, 40, 84, 40, 16, 0, 0 };
	{
		int y;
		for (y = 0; y < 16 && y1 + y < 192; y++) {
			int brushShape = brushes[brush * 16 + y];
			{
				int x;
				for (x = 0; x < 8 && x1 + x < 160; x++) {
					if (((brushShape >> (7 - x)) & 1) != 0)
						RECOIL_PlotSpcPattern(pixels, x, y, pattern);
				}
			}
		}
	}
}

static void RECOIL_DrawSpcChar(unsigned char *pixels, int x1, int y1, int ch)
{
	unsigned char const *font;
	int fontOffset;
	if (ch < 32 || ch > 95)
		return;
	font = CiBinaryResource_atari8_fnt;
	fontOffset = (ch - 32) << 3;
	{
		int y;
		for (y = 0; y < 8 && y1 + y < 192; y++) {
			{
				int x;
				for (x = 0; x < 4 && x1 + x < 160; x++)
					pixels[(y1 + y) * 160 + x1 + x] = (font[fontOffset + y] >> (6 - x * 2)) & 3;
			}
		}
	}
}

static void RECOIL_DrawSpcLine(unsigned char *pixels, int x1, int y1, int x2, int y2, int color)
{
	int dx = x2 - x1;
	int dy = y2 - y1;
	if (dx < 0)
		dx = -dx;
	if (dy < 0)
		dy = -dy;
	if (dx >= dy) {
		int e = dx;
		if (x2 < x1) {
			int ty = y1;
			x1 = x2;
			x2 += dx;
			y1 = y2;
			y2 = ty;
		}
		for (; x1 <= x2; x1++) {
			if (x1 < 160 && y1 < 192)
				pixels[160 * y1 + x1] = color;
			e -= dy * 2;
			if (e < 0) {
				e += dx * 2;
				y1 += y1 < y2 ? 1 : -1;
			}
		}
	}
	else {
		int e = dy;
		if (y2 < y1) {
			int tx = x1;
			x1 = x2;
			x2 = tx;
			y1 = y2;
			y2 += dy;
		}
		for (; y1 <= y2; y1++) {
			if (x1 < 160 && y1 < 192)
				pixels[160 * y1 + x1] = color;
			e -= dx * 2;
			if (e < 0) {
				e += dy * 2;
				x1 += x1 < x2 ? 1 : -1;
			}
		}
	}
}

static void RECOIL_DrawSprByte(RECOIL *self, int x1, int y, int b)
{
	{
		int x;
		for (x = 0; x < 8; x++) {
			if (((b >> (7 - x)) & 1) != 0)
				self->pixels[y * 320 + x1 + x] = 16777215;
		}
	}
}

static int RECOIL_FillPscLine(unsigned char *unpacked, int unpackedOffset, int value)
{
	{
		int i;
		for (i = 0; i < 80; i++)
			unpacked[unpackedOffset + i] = value;
	}
	return unpackedOffset + 80;
}

static cibool RECOIL_FillSpc(unsigned char *pixels, int x, int y, int pattern)
{
	if (x >= 160 || y >= 192)
		return FALSE;
	while (y >= 0 && pixels[y * 160 + x] == 0)
		y--;
	while (++y < 192 && pixels[y * 160 + x] == 0) {
		int x1;
		do
			x--;
		while (x >= 0 && pixels[y * 160 + x] == 0);
		x1 = x;
		while (x < 159 && pixels[y * 160 + ++x] == 0)
			RECOIL_PlotSpcPattern(pixels, x, y, pattern);
		x = x1 + ((x - x1 + 1) >> 1);
	}
	return TRUE;
}

static int RECOIL_FindInSortedPalette(RECOIL const *self, int rgb)
{
	int left = 0;
	int right = self->colors;
	while (left < right) {
		int index = (left + right) >> 1;
		int paletteRgb = self->palette[index];
		if (rgb == paletteRgb)
			return index;
		if (rgb < paletteRgb)
			right = index;
		else
			left = index + 1;
	}
	return -1;
}

static cibool RECOIL_G2fHasRaster(unsigned char const *content, int contentOffset)
{
	return RECOIL_HasG2fRaster(content, contentOffset, 2880, content[0] < 128 ? 22 : 30);
}

static int RECOIL_Get32BigEndian(unsigned char const *content, int contentOffset)
{
	return (content[contentOffset] << 24) | (content[contentOffset + 1] << 16) | (content[contentOffset + 2] << 8) | content[contentOffset + 3];
}

static int RECOIL_Get32LittleEndian(unsigned char const *content, int contentOffset)
{
	return content[contentOffset] | (content[contentOffset + 1] << 8) | (content[contentOffset + 2] << 16) | (content[contentOffset + 3] << 24);
}

static RECOILResolution RECOIL_GetAmigaAspectRatio(int xRatio, int yRatio, RECOILResolution resolution)
{
	if (xRatio <= 0 || yRatio <= 0)
		return resolution;
	if (xRatio > yRatio * 6)
		return RECOILResolution_AMIGA8X1;
	if (xRatio > yRatio * 3)
		return RECOILResolution_AMIGA4X1;
	if (xRatio * 2 > yRatio * 3)
		return RECOILResolution_AMIGA2X1;
	if (yRatio > xRatio * 3)
		return RECOILResolution_AMIGA1X4;
	if (yRatio * 2 > xRatio * 3)
		return resolution == RECOILResolution_AMIGA1X1 ? RECOILResolution_AMIGA1X2 : RECOILResolution_ST1X2;
	return resolution;
}

static int RECOIL_GetAmstradHeader(unsigned char const *content, int contentLength)
{
	int sum;
	if (contentLength < 128 || (content[24] | (content[25] << 8)) != contentLength - 128 || content[64] != content[24] || content[65] != content[25] || content[66] != 0)
		return 0;
	sum = 0;
	{
		int i;
		for (i = 0; i < 67; i++)
			sum += content[i];
	}
	if ((content[67] | (content[68] << 8)) != sum)
		return 0;
	return 128;
}

static int RECOIL_GetAtari8ExecutableOffset(unsigned char const *content, int contentLength)
{
	if (contentLength >= 7) {
		int blockLength = RECOIL_ParseAtari8ExecutableHeader(content, 0);
		if (blockLength > 0 && 6 + blockLength == contentLength)
			return 6;
	}
	return 0;
}

static int RECOIL_GetB5G5R5Color(int c)
{
	c = ((c & 31) << 19) | ((c & 992) << 6) | ((c >> 7) & 248);
	return c | ((c >> 5) & 460551);
}

static RECOILResolution RECOIL_GetCamgAspectRatio(int camg, RECOILResolution resolution)
{
	int log;
	switch (camg & ~61439) {
	case 0:
	case 69632:
	case 135168:
	case 462848:
	case 790528:
	case 856064:
		camg &= 32812;
		log = 0;
		break;
	case 266240:
		return RECOILResolution_AMIGA1X1;
	case 331776:
	case 528384:
	case 724992:
	case 921600:
		camg &= 32812;
		log = -1;
		break;
	case 200704:
	case 397312:
		camg &= 32805;
		log = -1;
		break;
	case 593920:
	case 659456:
		camg &= 33285;
		log = 0;
		break;
	default:
		return resolution;
	}
	switch (camg & 33312) {
	case 0:
		break;
	case 32768:
		log++;
		break;
	case 32800:
		log += 2;
		break;
	case 512:
		log--;
		break;
	default:
		return resolution;
	}
	switch (camg & 13) {
	case 0:
		break;
	case 4:
		log--;
		break;
	case 5:
		log -= 2;
		break;
	case 8:
		log++;
		break;
	default:
		return resolution;
	}
	switch (log) {
	case 0:
		return RECOILResolution_AMIGA1X1;
	case -1:
		return RECOILResolution_AMIGA2X1;
	case -2:
		return RECOILResolution_AMIGA4X1;
	case -3:
		return RECOILResolution_AMIGA8X1;
	case 1:
		return RECOILResolution_AMIGA1X2;
	case 2:
		return RECOILResolution_AMIGA1X4;
	default:
		return resolution;
	}
}

int RECOIL_GetColors(RECOIL *self)
{
	if (self->colors == -1)
		RECOIL_CalculatePalette(self);
	return self->colors;
}

static int RECOIL_GetFalconTrueColor(unsigned char const *content, int contentOffset)
{
	int rg = content[contentOffset];
	int gb = content[contentOffset + 1];
	int rgb = ((rg & 248) << 16) | ((rg & 7) << 13) | ((gb & 224) << 5) | ((gb & 31) << 3);
	rgb |= ((rgb >> 5) & 458759) | ((rgb >> 6) & 768);
	return rgb;
}

int RECOIL_GetFrames(RECOIL const *self)
{
	return self->frames;
}

static int RECOIL_GetG3R3B2Color(int c)
{
	return ((c & 28) * 73 >> 3 << 16) | ((c >> 5) * 73 >> 1 << 8) | (c & 3) * 85;
}

int RECOIL_GetHeight(RECOIL const *self)
{
	return self->height;
}

static int RECOIL_GetMsxHeader(unsigned char const *content)
{
	if (content[1] != 0 || content[2] != 0 || content[5] != 0 || content[6] != 0)
		return -1;
	return content[3] | (content[4] << 8);
}

static int RECOIL_GetNibble(unsigned char const *content, int contentOffset, int index)
{
	int b = content[contentOffset + (index >> 1)];
	return (index & 1) == 0 ? b >> 4 : b & 15;
}

static int RECOIL_GetOricHeader(unsigned char const *content, int contentLength)
{
	int contentOffset;
	if (contentLength < 26 || content[0] != 22 || content[1] != 22 || content[2] != 22 || content[3] != 36 || content[4] != 0 || content[5] != 0 || content[6] != 128 || content[7] != 0 || content[12] != 0)
		return 0;
	contentOffset = 13;
	while (content[contentOffset++] != 0) {
		if (contentOffset >= 26)
			return 0;
	}
	return contentOffset;
}

int RECOIL_GetOriginalHeight(RECOIL const *self)
{
	switch (self->resolution) {
	case RECOILResolution_AMIGA1X2:
	case RECOILResolution_AMSTRAD1X2:
	case RECOILResolution_APPLE_I_IE1X2:
	case RECOILResolution_XE2X2:
	case RECOILResolution_XE4X2:
	case RECOILResolution_ST1X2:
	case RECOILResolution_STE1X2:
	case RECOILResolution_BBC1X2:
	case RECOILResolution_MSX21X2:
	case RECOILResolution_PC881X2:
	case RECOILResolution_TIMEX1X2:
	case RECOILResolution_TRS1X2:
	case RECOILResolution_COCO2X2:
		return self->height >> 1;
	case RECOILResolution_AMIGA1X4:
	case RECOILResolution_MSX14X4:
	case RECOILResolution_XE4X4:
		return self->height >> 2;
	case RECOILResolution_XE8X8:
		return self->height >> 3;
	default:
		return self->height;
	}
}

int RECOIL_GetOriginalWidth(RECOIL const *self)
{
	switch (self->resolution) {
	case RECOILResolution_AMIGA2X1:
	case RECOILResolution_AMSTRAD2X1:
	case RECOILResolution_XE2X1:
	case RECOILResolution_XE2X2:
	case RECOILResolution_TT2X1:
	case RECOILResolution_FALCON2X1:
	case RECOILResolution_BBC2X1:
	case RECOILResolution_C162X1:
	case RECOILResolution_C642X1:
	case RECOILResolution_COCO2X2:
	case RECOILResolution_MSX22X1:
	case RECOILResolution_MSX2_PLUS2X1:
		return self->width >> 1;
	case RECOILResolution_AMIGA4X1:
	case RECOILResolution_MSX14X4:
	case RECOILResolution_XE4X1:
	case RECOILResolution_XE4X2:
	case RECOILResolution_XE4X4:
		return self->width >> 2;
	case RECOILResolution_AMIGA8X1:
	case RECOILResolution_XE8X8:
		return self->width >> 3;
	default:
		return self->width;
	}
}

static int RECOIL_GetPackedExt(const char *filename)
{
	int ext = 0;
	{
		int i;
		for (i = (int) strlen(filename); --i >= 0;) {
			int c = filename[i];
			if (c == 46)
				return ext | 538976288;
			if (c <= 32 || c > 122 || ext >= 16777216)
				return 0;
			ext = (ext << 8) + c;
		}
	}
	return 0;
}

int const *RECOIL_GetPixels(RECOIL const *self)
{
	return self->pixels;
}

const char *RECOIL_GetPlatform(RECOIL const *self)
{
	switch (self->resolution) {
	case RECOILResolution_AMIGA1X1:
	case RECOILResolution_AMIGA2X1:
	case RECOILResolution_AMIGA4X1:
	case RECOILResolution_AMIGA8X1:
	case RECOILResolution_AMIGA1X2:
	case RECOILResolution_AMIGA1X4:
		return "Amiga";
	case RECOILResolution_AMSTRAD1X1:
	case RECOILResolution_AMSTRAD2X1:
	case RECOILResolution_AMSTRAD1X2:
		return "Amstrad CPC";
	case RECOILResolution_APPLE_I_I1X1:
		return "Apple II";
	case RECOILResolution_APPLE_I_IE1X2:
		return "Apple IIe";
	case RECOILResolution_APPLE_I_I_G_S1X1:
		return "Apple IIGS";
	case RECOILResolution_MACINTOSH1X1:
		return "Apple Macintosh";
	case RECOILResolution_XE1X1:
	case RECOILResolution_XE2X1:
	case RECOILResolution_XE4X1:
	case RECOILResolution_XE2X2:
	case RECOILResolution_XE4X2:
	case RECOILResolution_XE4X4:
	case RECOILResolution_XE8X8:
		return "Atari 8-bit";
	case RECOILResolution_PORTFOLIO1X1:
		return "Atari Portfolio";
	case RECOILResolution_ST1X1:
	case RECOILResolution_ST1X2:
		return "Atari ST";
	case RECOILResolution_STE1X1:
	case RECOILResolution_STE1X2:
		return "Atari STE";
	case RECOILResolution_TT1X1:
	case RECOILResolution_TT2X1:
		return "Atari TT";
	case RECOILResolution_FALCON1X1:
	case RECOILResolution_FALCON2X1:
		return "Atari Falcon";
	case RECOILResolution_BBC1X1:
	case RECOILResolution_BBC2X1:
	case RECOILResolution_BBC1X2:
		return "BBC Micro";
	case RECOILResolution_C161X1:
	case RECOILResolution_C162X1:
		return "Commodore 16";
	case RECOILResolution_C641X1:
	case RECOILResolution_C642X1:
		return "Commodore 64";
	case RECOILResolution_C1281X1:
		return "Commodore 128";
	case RECOILResolution_MSX11X1:
	case RECOILResolution_MSX14X4:
		return "MSX";
	case RECOILResolution_MSX21X1:
	case RECOILResolution_MSX22X1:
	case RECOILResolution_MSX21X2:
		return "MSX2";
	case RECOILResolution_MSX2_PLUS1X1:
	case RECOILResolution_MSX2_PLUS2X1:
		return "MSX2+";
	case RECOILResolution_ORIC1X1:
		return "Oric";
	case RECOILResolution_PC1X1:
		return "PC";
	case RECOILResolution_PC881X2:
		return "NEC PC-88";
	case RECOILResolution_PC981X1:
		return "NEC PC-98";
	case RECOILResolution_PLAY_STATION1X1:
		return "PlayStation";
	case RECOILResolution_SAM_COUPE1X1:
		return "SAM Coupe";
	case RECOILResolution_X68_K1X1:
		return "Sharp X68000";
	case RECOILResolution_SPECTRUM1X1:
		return "ZX Spectrum";
	case RECOILResolution_TIMEX1X1:
	case RECOILResolution_TIMEX1X2:
		return "Timex 2048";
	case RECOILResolution_TRS1X1:
	case RECOILResolution_TRS1X2:
		return "TRS-80";
	case RECOILResolution_COCO1X1:
	case RECOILResolution_COCO2X2:
		return "TRS-80 Color Computer";
	case RECOILResolution_ZX811X1:
		return "ZX81";
	default:
		return "Unknown";
	}
}

static int RECOIL_GetR5G5B5Color(int c)
{
	c = ((c & 31744) << 9) | ((c & 992) << 6) | ((c & 31) << 3);
	return c | ((c >> 5) & 460551);
}

static int RECOIL_GetR8G8B8Color(unsigned char const *content, int contentOffset)
{
	return (content[contentOffset] << 16) | (content[contentOffset + 1] << 8) | content[contentOffset + 2];
}

static int RECOIL_GetStColor(RECOIL const *self, unsigned char const *content, int contentOffset)
{
	int r = content[contentOffset];
	int gb = content[contentOffset + 1];
	int rgb;
	switch (self->resolution) {
	case RECOILResolution_STE1X1:
	case RECOILResolution_STE1X2:
	case RECOILResolution_TT1X1:
		rgb = ((r & 7) << 17) | ((r & 8) << 13) | ((gb & 112) << 5) | ((gb & 135) << 1) | ((gb & 8) >> 3);
		return (rgb << 4) | rgb;
	default:
		rgb = ((r & 7) << 16) | ((gb & 112) << 4) | (gb & 7);
		return (rgb << 5) | (rgb << 2) | ((rgb >> 1) & 197379);
	}
}

static int RECOIL_GetStLowColor(unsigned char const *bitmap, int bitmapOffset, int x)
{
	int bit;
	bitmapOffset += ((x >> 1) & ~7) + ((x >> 3) & 1);
	bit = ~x & 7;
	return ((bitmap[bitmapOffset] >> bit) & 1) | (((bitmap[bitmapOffset + 2] >> bit) & 1) << 1) | (((bitmap[bitmapOffset + 4] >> bit) & 1) << 2) | (((bitmap[bitmapOffset + 6] >> bit) & 1) << 3);
}

static int RECOIL_GetStLowSeparateBitplanes(unsigned char const *content, int contentOffset, int bitplaneLength, int x)
{
	int bit;
	contentOffset += x >> 3;
	bit = ~x & 7;
	return ((content[contentOffset] >> bit) & 1) | (((content[contentOffset + bitplaneLength] >> bit) & 1) << 1) | (((content[contentOffset + 2 * bitplaneLength] >> bit) & 1) << 2) | (((content[contentOffset + 3 * bitplaneLength] >> bit) & 1) << 3);
}

static int RECOIL_GetStVdiColor(unsigned char const *content, int contentOffset)
{
	int rgb = 0;
	{
		int i;
		for (i = 0; i < 6; i += 2) {
			int c = (content[contentOffset + i] << 8) | content[contentOffset + i + 1];
			c = c < 1000 ? c * 255 / 1000 : 255;
			rgb = (rgb << 8) | c;
		}
	}
	return rgb;
}

static int RECOIL_GetSteInterlacedColor(int rgb)
{
	rgb = ((rgb & 1792) << 10) | ((rgb & 2160) << 6) | ((rgb & 16519) << 2) | ((rgb & 8192) >> 5) | ((rgb & 8) >> 2) | ((rgb & 4096) >> 12);
	return (rgb << 3) | ((rgb >> 2) & 460551);
}

int RECOIL_GetWidth(RECOIL const *self)
{
	return self->width;
}

static int RECOIL_GetX68KColor(int color)
{
	int rgb = ((color & 1984) << 13) | (color & 63488) | ((color & 62) << 2);
	if ((color & 1) != 0)
		rgb |= 263172;
	return rgb | ((rgb >> 6) & 197379);
}

static int RECOIL_GetZxColor(int c)
{
	return ((c >> 1) & 1) * 16711680 | ((c >> 2) & 1) * 65280 | (c & 1) * 255;
}

static unsigned char RECOIL_Gr12GtiaByteToGr8(int b, int ch, cibool gtia10)
{
	return (RECOIL_Gr12GtiaNibbleToGr8(b >> 4, ch, gtia10) << 4) | RECOIL_Gr12GtiaNibbleToGr8(b & 15, ch, gtia10);
}

static int RECOIL_Gr12GtiaNibbleToGr8(int nibble, int ch, cibool gtia10)
{
	switch (nibble) {
	case 0:
	case 1:
	case 4:
	case 5:
		return 0;
	case 2:
	case 6:
		return 1;
	case 3:
	case 7:
		return (ch & 128) == 0 ? 2 : 3;
	case 8:
		return gtia10 ? 8 : 4;
	case 9:
		return 4;
	case 10:
		return 5;
	case 11:
		return (ch & 128) == 0 ? 6 : 7;
	case 12:
		return gtia10 || (ch & 128) == 0 ? 8 : 12;
	case 13:
		return (ch & 128) == 0 ? 8 : 12;
	case 14:
		return (ch & 128) == 0 ? 9 : 13;
	case 15:
		return (ch & 128) == 0 ? 10 : 15;
	default:
		return 0;
	}
}

static cibool RECOIL_HasG2fRaster(unsigned char const *content, int contentOffset, int count, int hitClr)
{
	do {
		switch (content[contentOffset]) {
		case 0:
		case 1:
		case 2:
		case 3:
		case 65:
		case 66:
		case 67:
		case 97:
		case 98:
		case 99:
			break;
		case 129:
		case 130:
		case 131:
			if (content[contentOffset + 1] != hitClr)
				return TRUE;
			break;
		default:
			return TRUE;
		}
		contentOffset += 2;
	}
	while (--count > 0);
	return FALSE;
}

static cibool RECOIL_IsMsxPalette(unsigned char const *content, int contentOffset)
{
	int ored = 0;
	{
		int i;
		for (i = 0; i < 16; i++) {
			int rb = content[contentOffset + (i << 1)];
			int g = content[contentOffset + (i << 1) + 1];
			if ((rb & 136) != 0 || (g & 248) != 0)
				return FALSE;
			ored |= rb | g;
		}
	}
	return ored != 0;
}

cibool RECOIL_IsOurFile(const char *filename)
{
	switch (RECOIL_GetPackedExt(filename)) {
	case 540423474:
	case 538976307:
	case 544498228:
	case 543780148:
	case 543977524:
	case 544043060:
	case 543372342:
	case 538976353:
	case 544355425:
	case 540292705:
	case 543648119:
	case 544432481:
	case 543715433:
	case 544432993:
	case 543975009:
	case 544237409:
	case 543976545:
	case 543780193:
	case 540176481:
	case 540242017:
	case 544632929:
	case 543778660:
	case 544237412:
	case 543388517:
	case 543386729:
	case 544045680:
	case 543387745:
	case 543977569:
	case 544239713:
	case 544502369:
	case 544371809:
	case 544679522:
	case 544702306:
	case 540041826:
	case 540107362:
	case 540172898:
	case 540303970:
	case 540369506:
	case 543646306:
	case 1768711778:
	case 540632930:
	case 1937076834:
	case 538996841:
	case 1952672112:
	case 540618855:
	case 544237410:
	case 543648610:
	case 540109922:
	case 540175458:
	case 540240994:
	case 543452258:
	case 543976802:
	case 544567906:
	case 543388514:
	case 878931298:
	case 540107107:
	case 540172643:
	case 540238179:
	case 543777635:
	case 544564323:
	case 540108131:
	case 540173667:
	case 540239203:
	case 543974755:
	case 539256931:
	case 540305507:
	case 540436579:
	case 540567651:
	case 543516771:
	case 544368739:
	case 544434275:
	case 544106851:
	case 544238691:
	case 540372323:
	case 544238947:
	case 540242019:
	case 543780963:
	case 544370787:
	case 544501859:
	case 543650403:
	case 544503139:
	case 543651683:
	case 540303716:
	case 544235876:
	case 540107620:
	case 538993764:
	case 543974756:
	case 540108644:
	case 544368740:
	case 544106852:
	case 544500068:
	case 544042084:
	case 543977316:
	case 543451510:
	case 544173924:
	case 543715428:
	case 543650404:
	case 543978084:
	case 544238692:
	case 544895588:
	case 544240228:
	case 540112228:
	case 544175460:
	case 540177764:
	case 543777637:
	case 544236389:
	case 543256677:
	case 544043877:
	case 543259237:
	case 540173414:
	case 1768711782:
	case 543516518:
	case 543779942:
	case 544501350:
	case 540176486:
	case 544501862:
	case 543388774:
	case 544109926:
	case 543258470:
	case 538976359:
	case 540029287:
	case 540094823:
	case 543568487:
	case 543450471:
	case 543319655:
	case 538994535:
	case 543647847:
	case 540372071:
	case 540437607:
	case 540503143:
	case 540568679:
	case 543255655:
	case 543386727:
	case 544435303:
	case 543453031:
	case 540111463:
	case 540176999:
	case 540242535:
	case 540504679:
	case 540570215:
	case 540635751:
	case 544240231:
	case 544109927:
	case 544039784:
	case 543450472:
	case 543385192:
	case 543319912:
	case 544368488:
	case 544041320:
	case 544237928:
	case 544369000:
	case 544039528:
	case 543713639:
	case 544434022:
	case 544108397:
	case 543449959:
	case 543583336:
	case 544369768:
	case 543387752:
	case 544043112:
	case 538997352:
	case 540177000:
	case 543777640:
	case 544043624:
	case 544436840:
	case 540238441:
	case 543777385:
	case 540107625:
	case 540173161:
	case 540238697:
	case 543515497:
	case 544105321:
	case 543581801:
	case 1835164513:
	case 1835099490:
	case 1885693284:
	case 538997348:
	case 913138024:
	case 946692456:
	case 544039532:
	case 1835166825:
	case 538996845:
	case 945973106:
	case 1851942770:
	case 1835100275:
	case 543975017:
	case 543516521:
	case 543516777:
	case 544041321:
	case 543452265:
	case 543649129:
	case 1735223668:
	case 1735223672:
	case 544107881:
	case 1868983913:
	case 543649385:
	case 544239209:
	case 544501353:
	case 540176489:
	case 543387753:
	case 544501865:
	case 540177001:
	case 543650409:
	case 544043881:
	case 544502633:
	case 544237418:
	case 538995306:
	case 544761451:
	case 543451499:
	case 543255659:
	case 543256427:
	case 543648103:
	case 544043122:
	case 544370795:
	case 544437099:
	case 544040044:
	case 544171372:
	case 540242028:
	case 543912044:
	case 543912045:
	case 543912040:
	case 544044396:
	case 543383917:
	case 1735683696:
	case 543646061:
	case 543779693:
	case 544235885:
	case 544760173:
	case 543646317:
	case 538993517:
	case 543712109:
	case 543777645:
	case 544236397:
	case 1886413677:
	case 544433005:
	case 540108653:
	case 540174189:
	case 540305261:
	case 540567405:
	case 544237421:
	case 543385965:
	case 543975789:
	case 544434541:
	case 543517805:
	case 544500845:
	case 544239725:
	case 544240493:
	case 544372077:
	case 544171374:
	case 544304238:
	case 544236399:
	case 538976368:
	case 540094832:
	case 543372144:
	case 540095600:
	case 543584871:
	case 543765616:
	case 540292720:
	case 543383920:
	case 544760432:
	case 540107632:
	case 540173168:
	case 540238704:
	case 543777648:
	case 544433008:
	case 544498544:
	case 544499056:
	case 540108656:
	case 540174192:
	case 540239728:
	case 543385456:
	case 543582064:
	case 544368496:
	case 538995056:
	case 540109168:
	case 540174704:
	case 540240240:
	case 540371312:
	case 540436848:
	case 543716723:
	case 540305776:
	case 540502384:
	case 540633456:
	case 543385968:
	case 544762224:
	case 540306544:
	case 543255664:
	case 544042096:
	case 543452528:
	case 543649136:
	case 544501360:
	case 543715440:
	case 544239728:
	case 540238192:
	case 543388528:
	case 538981489:
	case 543646066:
	case 544235890:
	case 544694642:
	case 543319922:
	case 543713138:
	case 544237938:
	case 543517810:
	case 540044658:
	case 540110194:
	case 540175730:
	case 540241266:
	case 540306802:
	case 538996850:
	case 543717234:
	case 543979378:
	case 544438642:
	case 544366963:
	case 540044387:
	case 540109923:
	case 540175459:
	case 540043120:
	case 540042099:
	case 540107635:
	case 540173171:
	case 540238707:
	case 540304243:
	case 540369779:
	case 540370279:
	case 540435315:
	case 540500851:
	case 540501351:
	case 540566387:
	case 540566887:
	case 540570227:
	case 543253363:
	case 543384435:
	case 540042355:
	case 540107891:
	case 540173427:
	case 544436851:
	case 543910521:
	case 544367475:
	case 879977331:
	case 540308339:
	case 540239731:
	case 543516531:
	case 540239987:
	case 543385715:
	case 544237683:
	case 544368755:
	case 543582579:
	case 544238451:
	case 543387763:
	case 543453299:
	case 544370803:
	case 544436339:
	case 544567411:
	case 544764019:
	case 540373619:
	case 540439155:
	case 540504691:
	case 543781491:
	case 544502387:
	case 543322995:
	case 544240755:
	case 543651955:
	case 544438387:
	case 544236404:
	case 540108660:
	case 544041332:
	case 544237940:
	case 540110452:
	case 540175988:
	case 540241524:
	case 540307060:
	case 540372596:
	case 540438132:
	case 544829044:
	case 543780980:
	case 543519348:
	case 544240244:
	case 544567924:
	case 540047476:
	case 543520884:
	case 544438388:
	case 544039542:
	case 538996066:
	case 543385974:
	case 543783542:
	case 544106871:
	case 543452791:
	case 543254392:
	case 544238712:
	case 540110970:
	case 544241786:
		return TRUE;
	default:
		return FALSE;
	}
}

static cibool RECOIL_IsStePalette(unsigned char const *content, int contentOffset, int colors)
{
	while (--colors >= 0) {
		if ((content[contentOffset] & 8) != 0 || (content[contentOffset + 1] & 136) != 0)
			return TRUE;
		contentOffset += 2;
	}
	return FALSE;
}

static cibool RECOIL_IsStringAt(unsigned char const *content, int contentOffset, const char *s)
{
	int length = (int) strlen(s);
	{
		int i;
		for (i = 0; i < length; i++)
			if (content[contentOffset + i] != s[i])
				return FALSE;
	}
	return TRUE;
}

static cibool RECOIL_IsSttt(unsigned char const *content, int bitplanes)
{
	int colors = (content[20] << 8) | content[21];
	return RECOIL_IsStringAt(content, 16, "STTT") && colors == 1 << bitplanes;
}

static cibool RECOIL_IsTimg(unsigned char const *content)
{
	if (!RECOIL_IsStringAt(content, 16, "TIMG") || content[20] != 0 || content[21] != 3)
		return FALSE;
	{
		int i;
		for (i = 22; i < 28; i += 2) {
			if (content[i] != 0 || content[i + 1] != 5)
				return FALSE;
		}
	}
	return TRUE;
}

static cibool RECOIL_IsXimg(unsigned char const *content)
{
	return RECOIL_IsStringAt(content, 16, "XIMG") && content[20] == 0 && content[21] == 0;
}

static int RECOIL_ParseAtari8ExecutableHeader(unsigned char const *content, int contentOffset)
{
	int startAddress;
	int endAddress;
	if (content[contentOffset] != 255 || content[contentOffset + 1] != 255)
		return -1;
	startAddress = content[contentOffset + 2] | (content[contentOffset + 3] << 8);
	endAddress = content[contentOffset + 4] | (content[contentOffset + 5] << 8);
	return endAddress - startAddress + 1;
}

static void RECOIL_PlotSpcPattern(unsigned char *pixels, int x, int y, int pattern)
{
	pixels[y * 160 + x] = (pattern >> ((~y & 1) * 8 + (~x & 3) * 2)) & 3;
}

static int RECOIL_ReadCompanionFile(RECOIL *self, const char *baseFilename, const char *upperExt, const char *lowerExt, unsigned char *content, int contentLength)
{
	int i = (int) strlen(baseFilename);
	cibool lower;
	char filename[1025];
	if (i > 1020)
		return -1;
	lower = FALSE;
	for (;;) {
		int c = baseFilename[--i];
		if (c >= 97)
			lower = TRUE;
		else if (c == 46)
			break;
	}
	((char *) memcpy(filename, baseFilename + 0, i + 1))[i + 1] = '\0';
	strcat(filename, lower ? lowerExt : upperExt);
	return self->vtbl->readFile(self, filename, content, contentLength);
}

static int RECOIL_ReadFile(RECOIL *self, const char *filename, unsigned char *content, int contentLength)
{
	self->leftSkip = 0;
	content[0] = 0;
	return -1;
}

static cibool RECOIL_SetAmstradFirmwarePalette(RECOIL *self, unsigned char const *content, int contentOffset, int count)
{
	{
		int i;
		for (i = 0; i < count; i++) {
			int c = content[contentOffset + i];
			static const unsigned char triLevel[3] = { 0, 128, 255 };
			if (c > 26)
				return FALSE;
			self->contentPalette[i] = (triLevel[c / 3 % 3] << 16) | (triLevel[c / 9] << 8) | triLevel[c % 3];
		}
	}
	return TRUE;
}

static cibool RECOIL_SetAmstradFirmwarePalette16(RECOIL *self, unsigned char const *content)
{
	return content[5] == 1 && RECOIL_SetAmstradFirmwarePalette(self, content, 6, 16);
}

static int RECOIL_SetAmstradPalette(RECOIL *self, const char *filename)
{
	unsigned char pal[368];
	int palLength = RECOIL_ReadCompanionFile(self, filename, "PAL", "pal", pal, 368);
	int palOffset = RECOIL_GetAmstradHeader(pal, palLength);
	if (palLength != palOffset + 239)
		return -1;
	{
		int i;
		for (i = 0; i < 16; i++) {
			int c = pal[palOffset + 3 + i * 12];
			if (c < 64 || c > 95)
				return -1;
			self->contentPalette[i] = RECOIL_AmstradPalette[c - 64];
		}
	}
	return pal[palOffset];
}

void RECOIL_SetAtari8Palette(RECOIL *self, unsigned char const *content)
{
	if (content == NULL)
		content = CiBinaryResource_altirrapal_pal;
	RECOIL_DecodeR8G8B8Colors(content, 0, 256, self->atari8Palette);
}

static cibool RECOIL_SetAtari8RawSize(RECOIL *self, unsigned char const *content, int contentLength, RECOILResolution resolution)
{
	int contentOffset = RECOIL_GetAtari8ExecutableOffset(content, contentLength);
	int height = (contentLength - contentOffset) / 40;
	if (height == 0 || height > 240)
		return FALSE;
	RECOIL_SetSize(self, 320, height, resolution);
	return TRUE;
}

static void RECOIL_SetBakPF012(RECOIL *self, unsigned char const *content, int contentOffset, int contentStride)
{
	{
		int i;
		for (i = 0; i < 4; i++)
			self->gtiaColors[i == 0 ? 8 : 3 + i] = content[contentOffset + i * contentStride] & 254;
	}
}

static void RECOIL_SetBakPF0123(RECOIL *self, unsigned char const *content, int contentOffset)
{
	{
		int i;
		for (i = 0; i < 5; i++)
			self->gtiaColors[i == 0 ? 8 : 3 + i] = content[contentOffset + i] & 254;
	}
}

static void RECOIL_SetC16Palette(RECOIL *self)
{
	unsigned char const *pal = CiBinaryResource_c16_pal;
	{
		int i;
		for (i = 0; i < 256; i++)
			self->contentPalette[i] = (pal[i * 3] << 16) | (pal[i * 3 + 1] << 8) | pal[i * 3 + 2];
	}
}

static void RECOIL_SetDefaultStPalette(RECOIL *self, int bitplanes)
{
	self->contentPalette[0] = 16777215;
	if (bitplanes >= 2) {
		self->contentPalette[1] = 16711680;
		self->contentPalette[2] = 65280;
		if (bitplanes == 4) {
			self->contentPalette[3] = 16776960;
			self->contentPalette[4] = 255;
			self->contentPalette[5] = 16711935;
			self->contentPalette[6] = 65535;
			self->contentPalette[7] = 11184810;
			self->contentPalette[8] = 5592405;
			self->contentPalette[9] = 11141120;
			self->contentPalette[10] = 43520;
			self->contentPalette[11] = 11184640;
			self->contentPalette[12] = 170;
			self->contentPalette[13] = 11141290;
			self->contentPalette[14] = 43690;
		}
	}
	self->contentPalette[(1 << bitplanes) - 1] = 0;
}

static void RECOIL_SetFalconPalette(RECOIL *self, unsigned char const *content, int contentOffset)
{
	{
		int i;
		for (i = 0; i < 256; i++) {
			int offset = contentOffset + (i << 2);
			self->contentPalette[i] = (content[offset] << 16) | (content[offset + 1] << 8) | content[offset + 3];
		}
	}
}

static void RECOIL_SetGr15DefaultColors(RECOIL *self)
{
	self->gtiaColors[8] = 0;
	self->gtiaColors[4] = 4;
	self->gtiaColors[5] = 8;
	self->gtiaColors[6] = 12;
}

static void RECOIL_SetGtiaColor(RECOIL *self, int reg, int value)
{
	value &= 254;
	switch (reg) {
	case 0:
	case 1:
	case 2:
	case 3:
		self->gtiaColors[reg] = value;
		break;
	case 4:
	case 5:
	case 6:
	case 7:
		self->gtiaColors[8 + reg] = self->gtiaColors[reg] = value;
		break;
	case 8:
		self->gtiaColors[11] = self->gtiaColors[10] = self->gtiaColors[9] = self->gtiaColors[8] = value;
		break;
	}
}

static void RECOIL_SetGtiaColors(RECOIL *self, unsigned char const *content, int contentOffset)
{
	self->gtiaColors[0] = content[contentOffset] & 254;
	RECOIL_SetPM123PF0123Bak(self, content, contentOffset + 1);
}

static void RECOIL_SetMagPalette(RECOIL *self, unsigned char const *content, int paletteOffset, int colors)
{
	{
		int c;
		for (c = 0; c < colors; c++) {
			int offset = paletteOffset + c * 3;
			self->contentPalette[c] = (content[offset + 1] << 16) | (content[offset] << 8) | content[offset + 2];
		}
	}
}

static void RECOIL_SetMsx6Palette(RECOIL *self, const char *filename)
{
	unsigned char palette[8];
	if (RECOIL_ReadCompanionFile(self, filename, "PL6", "pl6", palette, 8) == 8)
		RECOIL_SetMsxPalette(self, palette, 0, 4);
	else {
		self->contentPalette[0] = 0;
		self->contentPalette[1] = 2396708;
		self->contentPalette[2] = 2415396;
		self->contentPalette[3] = 7208813;
	}
}

static void RECOIL_SetMsxCompanionPalette(RECOIL *self, const char *filename, const char *upperExt, const char *lowerExt)
{
	unsigned char palette[32];
	RECOIL_SetMsxPalette(self, RECOIL_ReadCompanionFile(self, filename, upperExt, lowerExt, palette, 32) == 32 ? palette : RECOIL_Msx1Palette, 0, 16);
}

static void RECOIL_SetMsxPalette(RECOIL *self, unsigned char const *content, int contentOffset, int colors)
{
	{
		int i;
		for (i = 0; i < colors; i++) {
			int rb = content[contentOffset + (i << 1)];
			int g = content[contentOffset + (i << 1) + 1];
			int rgb = ((rb & 112) << 12) | (rb & 7) | ((g & 7) << 8);
			self->contentPalette[i] = (rgb << 5) | (rgb << 2) | ((rgb >> 1) & 197379);
		}
	}
}

static void RECOIL_SetPF0123Bak(RECOIL *self, unsigned char const *content, int contentOffset)
{
	{
		int i;
		for (i = 0; i < 5; i++)
			self->gtiaColors[4 + i] = content[contentOffset + i] & 254;
	}
}

static void RECOIL_SetPF0123Even(RECOIL *self, unsigned char const *content, int contentOffset)
{
	{
		int i;
		for (i = 0; i < 4; i++)
			self->gtiaColors[4 + i] = content[contentOffset + i * 2] & 254;
	}
}

static void RECOIL_SetPF012Bak(RECOIL *self, unsigned char const *content, int contentOffset)
{
	{
		int i;
		for (i = 0; i < 4; i++)
			self->gtiaColors[i == 3 ? 8 : 4 + i] = content[contentOffset + i] & 254;
	}
}

static void RECOIL_SetPF21(RECOIL *self, unsigned char const *content, int contentOffset)
{
	self->gtiaColors[6] = content[contentOffset] & 254;
	self->gtiaColors[5] = content[contentOffset + 1] & 254;
}

static void RECOIL_SetPM123PF0123Bak(RECOIL *self, unsigned char const *content, int contentOffset)
{
	{
		int i;
		for (i = 0; i < 8; i++)
			RECOIL_SetGtiaColor(self, 1 + i, content[contentOffset + i]);
	}
}

static void RECOIL_SetSc8Palette(RECOIL *self)
{
	{
		int c;
		for (c = 0; c < 256; c++)
			self->contentPalette[c] = RECOIL_GetG3R3B2Color(c);
	}
}

static void RECOIL_SetScaledPixel(RECOIL *self, int x, int y, int rgb)
{
	int offset = y * self->width;
	switch (self->resolution) {
	case RECOILResolution_AMIGA2X1:
	case RECOILResolution_TT2X1:
	case RECOILResolution_FALCON2X1:
		offset += x << 1;
		self->pixels[offset + 1] = self->pixels[offset] = rgb;
		break;
	case RECOILResolution_AMIGA4X1:
		offset += x << 2;
		self->pixels[offset + 3] = self->pixels[offset + 2] = self->pixels[offset + 1] = self->pixels[offset] = rgb;
		break;
	case RECOILResolution_AMIGA8X1:
		offset += x << 3;
		for (x = 0; x < 8; x++)
			self->pixels[offset + x] = rgb;
		break;
	case RECOILResolution_AMIGA1X2:
	case RECOILResolution_ST1X2:
	case RECOILResolution_STE1X2:
	case RECOILResolution_TRS1X2:
		offset = (offset << 1) + x;
		self->pixels[offset + self->width] = self->pixels[offset] = rgb;
		break;
	case RECOILResolution_AMIGA1X4:
		offset = (offset << 2) + x;
		self->pixels[offset + self->width * 3] = self->pixels[offset + self->width * 2] = self->pixels[offset + self->width] = self->pixels[offset] = rgb;
		break;
	default:
		self->pixels[offset + x] = rgb;
		break;
	}
}

static cibool RECOIL_SetScaledSize(RECOIL *self, int width, int height, RECOILResolution resolution)
{
	switch (resolution) {
	case RECOILResolution_AMIGA2X1:
	case RECOILResolution_FALCON2X1:
		width <<= 1;
		break;
	case RECOILResolution_AMIGA4X1:
		width <<= 2;
		break;
	case RECOILResolution_AMIGA8X1:
		width <<= 3;
		break;
	case RECOILResolution_AMIGA1X2:
	case RECOILResolution_ST1X2:
	case RECOILResolution_STE1X2:
	case RECOILResolution_MSX21X2:
	case RECOILResolution_PC881X2:
		height <<= 1;
		break;
	case RECOILResolution_AMIGA1X4:
		height <<= 2;
		break;
	default:
		break;
	}
	return RECOIL_SetSize(self, width, height, resolution);
}

static cibool RECOIL_SetSize(RECOIL *self, int width, int height, RECOILResolution resolution)
{
	if (width <= 0 || width > 2048 || height <= 0 || height > 1856 || width * height > 2854278)
		return FALSE;
	self->width = width;
	self->height = height;
	self->resolution = resolution;
	self->frames = 1;
	self->colors = -1;
	self->leftSkip = 0;
	return TRUE;
}

static cibool RECOIL_SetSizeStOrFalcon(RECOIL *self, int width, int height, int bitplanes, cibool squarePixels)
{
	RECOILResolution resolution = RECOILResolution_FALCON1X1;
	switch (bitplanes) {
	case 1:
		if (width <= 640 && height <= 400)
			resolution = RECOILResolution_ST1X1;
		break;
	case 2:
		if (!squarePixels && width == 640 && height == 200) {
			height <<= 1;
			resolution = RECOILResolution_ST1X2;
		}
		break;
	case 4:
		if (width <= 320 && height <= 200)
			resolution = RECOILResolution_ST1X1;
		break;
	case 8:
		if (!squarePixels && width == 320 && height == 480) {
			width <<= 1;
			resolution = RECOILResolution_TT2X1;
		}
		break;
	default:
		break;
	}
	return RECOIL_SetSize(self, width, height, resolution);
}

static void RECOIL_SetStPalette(RECOIL *self, unsigned char const *content, int contentOffset, int colors)
{
	{
		int c;
		for (c = 0; c < colors; c++)
			self->contentPalette[c] = RECOIL_GetStColor(self, content, contentOffset + c * 2);
	}
}

static void RECOIL_SetStVdiPalette(RECOIL *self, unsigned char const *content, int contentOffset, int colors, int bitplanes)
{
	{
		int i;
		for (i = 0; i < colors; i++) {
			int j;
			switch (i) {
			case 1:
				j = (1 << bitplanes) - 1;
				break;
			case 2:
				j = 1;
				break;
			case 3:
				j = 2;
				break;
			case 5:
				j = 6;
				break;
			case 6:
				j = 3;
				break;
			case 7:
				j = 5;
				break;
			case 8:
				j = 7;
				break;
			case 9:
				j = 8;
				break;
			case 10:
				j = 9;
				break;
			case 11:
				j = 10;
				break;
			case 13:
				j = 14;
				break;
			case 14:
				j = 11;
				break;
			case 15:
				j = 13;
				break;
			case 255:
				j = 15;
				break;
			default:
				j = i;
				break;
			}
			self->contentPalette[j] = RECOIL_GetStVdiColor(content, contentOffset + i * 6);
		}
	}
}

static void RECOIL_SetUlaPlus(RECOIL *self, unsigned char const *content, int paletteOffset)
{
	RECOIL_SetSize(self, 256, 192, RECOILResolution_SPECTRUM1X1);
	{
		int i;
		for (i = 0; i < 64; i++)
			self->contentPalette[i] = RECOIL_GetG3R3B2Color(content[paletteOffset + i]);
	}
}

static void RECOIL_SetXeOsDefaultColors(RECOIL *self)
{
	self->gtiaColors[8] = 0;
	self->gtiaColors[4] = 40;
	self->gtiaColors[5] = 202;
	self->gtiaColors[6] = 148;
}

static void RECOIL_SetZx(RECOIL *self, RECOILResolution resolution)
{
	RECOIL_SetSize(self, 256, 192, resolution);
	{
		int i;
		for (i = 0; i < 64; i++) {
			int rgb = RECOIL_GetZxColor(i);
			if ((i & 16) == 0)
				rgb &= 13487565;
			self->contentPalette[i] = rgb;
		}
	}
}

static void RECOIL_SortPalette(RECOIL *self, int start, int end)
{
	while (start + 1 < end) {
		int left = start + 1;
		int right = end;
		int pivot = self->palette[start];
		int rgb;
		while (left < right) {
			rgb = self->palette[left];
			if (rgb <= pivot)
				left++;
			else {
				self->palette[left] = self->palette[--right];
				self->palette[right] = rgb;
			}
		}
		rgb = self->palette[--left];
		self->palette[left] = self->palette[start];
		self->palette[start] = rgb;
		RECOIL_SortPalette(self, start, left);
		start = right;
	}
}

static int RECOIL_ToAtari8Char(int ascii)
{
	switch (ascii & 96) {
	case 0:
		return ascii + 64;
	case 32:
	case 64:
		return ascii - 32;
	default:
		return ascii;
	}
}

int const *RECOIL_ToPalette(RECOIL *self, unsigned char *indexes)
{
	int pixelsCount;
	if (self->colors == -1)
		RECOIL_CalculatePalette(self);
	if (self->colors > 256)
		return NULL;
	RECOIL_SortPalette(self, 0, self->colors);
	pixelsCount = self->width * self->height;
	{
		int i;
		for (i = 0; i < pixelsCount; i++)
			indexes[i] = RECOIL_FindInSortedPalette(self, self->pixels[i]);
	}
	return self->palette;
}

static cibool RECOIL_UnpackAndDecodeSpx(RECOIL *self, SpxStream *stream, int contentLength, int height, unsigned char *unpacked)
{
	unsigned char const *content = stream->base.content;
	int bitmapLength = height * 160;
	int paletteOffset = stream->base.contentOffset;
	int paletteLength = RECOIL_Get32BigEndian(content, stream->base.contentStart - 4);
	if (content[4] == 0)
		memcpy(unpacked + 0, content + stream->base.contentStart + 160, bitmapLength);
	else if (content[3] == 1) {
		if (!Ice21Stream_Unpack(&stream->base, unpacked, 0, bitmapLength))
			return FALSE;
	}
	else if (content[5] != 1)
		return FALSE;
	else {
		int packedLength = RECOIL_Get32BigEndian(content, stream->base.contentStart + 4);
		int packedEnd = stream->base.contentStart + 8 + packedLength;
		if (RECOIL_Get32BigEndian(content, stream->base.contentStart - 8) != 8 + packedLength || packedEnd > contentLength || packedEnd < 0)
			return FALSE;
		stream->base.contentStart += 8;
		stream->base.contentOffset = packedEnd;
		if (!SpxStream_UnpackV2(stream, unpacked, height << 8))
			return FALSE;
	}
	if (content[5] == 0) {
		if (paletteLength != height * 96)
			return FALSE;
		memcpy(unpacked + bitmapLength, content + paletteOffset, paletteLength);
	}
	else if (content[3] == 1) {
		stream->base.contentStart = paletteOffset;
		stream->base.contentOffset = paletteOffset + paletteLength;
		if (stream->base.contentOffset > contentLength || Ice21Stream_GetUnpackedLength(&stream->base) != height * 96 || !Ice21Stream_Unpack(&stream->base, unpacked, bitmapLength, height << 8))
			return FALSE;
	}
	return RECOIL_DecodeSpuScreen(self, unpacked, 0, height, FALSE);
}

static cibool RECOIL_UnpackLz4(RECOIL const *self, unsigned char const *content, int contentLength, unsigned char *unpacked, int unpackedLength)
{
	Lz4Stream stream;
	if (contentLength < 11 || content[0] != 4 || content[1] != 34 || content[2] != 77 || content[3] != 24 || (content[4] & 195) != 64)
		return FALSE;
	stream.base.content = content;
	stream.base.contentOffset = 7;
	if ((content[4] & 8) != 0)
		stream.base.contentOffset += 8;
	stream.unpacked = unpacked;
	stream.unpackedOffset = 0;
	stream.unpackedLength = unpackedLength;
	for (;;) {
		int blockSize;
		if (stream.base.contentOffset + 4 > contentLength)
			return FALSE;
		blockSize = RECOIL_Get32LittleEndian(content, stream.base.contentOffset);
		stream.base.contentOffset += 4;
		stream.base.contentLength = contentLength;
		if (blockSize == 0)
			break;
		if (blockSize >> 31 != 0) {
			if (!Lz4Stream_Copy(&stream, blockSize & 2147483647))
				return FALSE;
			continue;
		}
		stream.base.contentLength = stream.base.contentOffset + blockSize;
		if (stream.base.contentLength > contentLength)
			return FALSE;
		for (;;) {
			int token = Stream_ReadByte(&stream.base);
			int count;
			int distance;
			int nextOffset;
			if (token < 0)
				return FALSE;
			count = Lz4Stream_ReadCount(&stream, token >> 4);
			if (count < 0 || !Lz4Stream_Copy(&stream, count))
				return FALSE;
			if (stream.base.contentOffset == stream.base.contentLength)
				break;
			if (stream.base.contentOffset > stream.base.contentLength - 2)
				return FALSE;
			distance = Stream_ReadByte(&stream.base);
			distance += Stream_ReadByte(&stream.base) << 8;
			if (distance == 0)
				return FALSE;
			count = Lz4Stream_ReadCount(&stream, token & 15);
			if (count < 0)
				return FALSE;
			count += 4;
			nextOffset = stream.unpackedOffset + count;
			if (nextOffset > unpackedLength || !RECOIL_CopyPrevious(unpacked, stream.unpackedOffset, distance, count))
				return FALSE;
			stream.unpackedOffset = nextOffset;
		}
		if ((content[4] & 16) != 0)
			stream.base.contentOffset += 4;
	}
	if ((content[4] & 4) != 0)
		stream.base.contentOffset += 4;
	return stream.base.contentOffset == contentLength && stream.unpackedOffset == unpackedLength;
}

static cibool RECOIL_UnpackMag(unsigned char const *content, int headerOffset, int contentLength, int bytesPerLine, int height, unsigned char *unpacked)
{
	BitStream haveDelta;
	int deltaOffset;
	int colorOffset;
	unsigned char deltas[512];
	BitStream_Construct(&haveDelta);
	haveDelta.base.content = content;
	haveDelta.base.contentOffset = headerOffset + RECOIL_Get32LittleEndian(content, headerOffset + 12);
	haveDelta.base.contentLength = contentLength;
	deltaOffset = headerOffset + RECOIL_Get32LittleEndian(content, headerOffset + 16);
	colorOffset = headerOffset + RECOIL_Get32LittleEndian(content, headerOffset + 24);
	if (haveDelta.base.contentOffset < 0 || deltaOffset < 0 || colorOffset < 0)
		return FALSE;
	memset(deltas, 0, sizeof(deltas));
	{
		int y;
		for (y = 0; y < height; y++) {
			int delta = 0;
			{
				int x;
				for (x = 0; x < bytesPerLine; x++) {
					if ((x & 1) == 0) {
						delta = deltas[x >> 2];
						if ((x & 2) == 0) {
							switch (BitStream_ReadBit(&haveDelta)) {
							case 0:
								break;
							case 1:
								if (deltaOffset >= contentLength)
									return FALSE;
								delta ^= content[deltaOffset++];
								deltas[x >> 2] = delta;
								break;
							default:
								return FALSE;
							}
							delta >>= 4;
						}
						else
							delta &= 15;
					}
					if (delta == 0) {
						if (colorOffset >= contentLength)
							return FALSE;
						unpacked[y * bytesPerLine + x] = content[colorOffset++];
					}
					else {
						static const unsigned char deltaX[16] = { 0, 2, 4, 8, 0, 2, 0, 2, 4, 0, 2, 4, 0, 2, 4, 0 };
						static const unsigned char deltaY[16] = { 0, 0, 0, 0, 1, 1, 2, 2, 2, 4, 4, 4, 8, 8, 8, 16 };
						int sourceX = x - deltaX[delta];
						int sourceY = y - deltaY[delta];
						if (sourceX < 0 || sourceY < 0)
							return FALSE;
						unpacked[y * bytesPerLine + x] = unpacked[sourceY * bytesPerLine + sourceX];
					}
				}
			}
			if ((bytesPerLine & 1) != 0 && delta == 0)
				colorOffset++;
			if (((bytesPerLine + 1) & 2) != 0 && (deltas[bytesPerLine >> 2] & 15) == 0)
				colorOffset += 2;
		}
	}
	return TRUE;
}

static unsigned char const *RECOIL_UnpackPbx(RECOIL const *self, unsigned char const *content, int contentLength, unsigned char *unpacked, int bitmapOffset, int bytesPer16Pixels, int unpackedLength)
{
	PackBitsStream rle;
	if (content[4] != 128 || content[5] != 1)
		return contentLength == unpackedLength ? content : NULL;
	PackBitsStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = 128;
	rle.base.base.base.contentLength = contentLength;
	if (!RleStream_Unpack(&rle.base, unpacked, 128, 1, bitmapOffset))
		return NULL;
	{
		int bitplane;
		for (bitplane = 0; bitplane < bytesPer16Pixels; bitplane += 2) {
			{
				int x;
				for (x = bitplane; x < 160; x += bytesPer16Pixels) {
					if (!RleStream_UnpackWords(&rle.base, unpacked, bitmapOffset + x, 160, unpackedLength))
						return NULL;
				}
			}
		}
	}
	return unpacked;
}

static cibool RECOIL_UnpackRip(RECOIL const *self, unsigned char const *content, int contentOffset, int contentLength, unsigned char *unpacked, int unpackedLength)
{
	FanoTree lengthTree;
	FanoTree distanceTree;
	FanoTree literalTree;
	BitStream bitStream;
	if (contentOffset + 304 > contentLength || !RECOIL_IsStringAt(content, contentOffset, "PCK"))
		return FALSE;
	FanoTree_Create(&lengthTree, content, contentOffset + 16, 64);
	FanoTree_Create(&distanceTree, content, contentOffset + 16 + 32, 256);
	FanoTree_Create(&literalTree, content, contentOffset + 16 + 32 + 128, 256);
	BitStream_Construct(&bitStream);
	bitStream.base.content = content;
	bitStream.base.contentOffset = contentOffset + 16 + 288;
	bitStream.base.contentLength = contentLength;
	{
		int unpackedOffset;
		for (unpackedOffset = 0; unpackedOffset < unpackedLength;) {
			switch (BitStream_ReadBit(&bitStream)) {
				int literal;
				int distance;
				int count;
			case -1:
				return FALSE;
			case 0:
				literal = FanoTree_ReadCode(&literalTree, &bitStream);
				if (literal < 0)
					return FALSE;
				unpacked[unpackedOffset++] = literal;
				break;
			case 1:
				distance = FanoTree_ReadCode(&distanceTree, &bitStream);
				if (distance < 0)
					return FALSE;
				distance += 2;
				count = FanoTree_ReadCode(&lengthTree, &bitStream);
				if (count < 0)
					return FALSE;
				count += 2;
				if (count > unpackedLength - unpackedOffset)
					count = unpackedLength - unpackedOffset;
				if (!RECOIL_CopyPrevious(unpacked, unpackedOffset, distance, count))
					return FALSE;
				unpackedOffset += count;
				if (unpackedOffset >= unpackedLength)
					return TRUE;
				break;
			}
		}
	}
	return TRUE;
}

static cibool RECOIL_UnpackSpc(RleStream *rle, unsigned char *unpacked)
{
	{
		int bitplane;
		for (bitplane = 0; bitplane < 8; bitplane += 2) {
			if (!RleStream_UnpackWords(rle, unpacked, 160 + bitplane, 8, 32000))
				return FALSE;
		}
	}
	return TRUE;
}

static unsigned char const *RECOIL_UnpackSr(unsigned char const *content, int contentLength, unsigned char *unpacked)
{
	if (contentLength < 7)
		return NULL;
	switch (content[0]) {
		SrStream rle;
	case 254:
		if (contentLength < 54279 || RECOIL_GetMsxHeader(content) < 54271)
			return NULL;
		return content;
	case 253:
		if (7 + RECOIL_GetMsxHeader(content) != contentLength)
			return NULL;
		SrStream_Construct(&rle, NULL);
		rle.base.base.base.content = content;
		rle.base.base.base.contentOffset = 7;
		rle.base.base.base.contentLength = contentLength;
		RleStream_Unpack(&rle.base, unpacked, 7, 1, 54279);
		return unpacked;
	default:
		return NULL;
	}
}

static cibool RECOIL_VerifyIce(RECOIL *self, unsigned char const *content, int contentLength, cibool font, int fontLength, int imageLength, RECOILResolution resolution)
{
	if (font) {
		if (contentLength != fontLength)
			return FALSE;
		RECOIL_SetSize(self, 256, 128, resolution);
	}
	else {
		if (contentLength != imageLength || content[0] != 1)
			return FALSE;
		RECOIL_SetSize(self, 320, 192, resolution);
	}
	return TRUE;
}

static void RastPalette_Construct(RastPalette *self, const MultiPaletteVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_RastPalette;
	MultiPalette_Construct(&self->base, vtbl);
}

static void RastPalette_SetLinePalette(RastPalette const *self, RECOIL *recoil, int y)
{
	{
		int offset;
		for (offset = self->base.base.base.contentOffset; offset <= self->base.base.base.contentLength - 34; offset += 34) {
			if (y == ((self->base.base.base.content[offset] << 8) | self->base.base.base.content[offset + 1])) {
				RECOIL_SetStPalette(recoil, self->base.base.base.content, offset + 2, 16);
				break;
			}
		}
	}
}

static void RecentInts_Construct(RecentInts *self)
{
	{
		int i;
		for (i = 0; i < 128; i++) {
			self->value[i] = 0;
			self->prev[i] = i + 1;
			self->next[i] = i - 1;
		}
	}
	self->prev[127] = 0;
	self->next[0] = 127;
	self->head = 0;
}

static void RecentInts_Add(RecentInts *self, int value)
{
	self->head = self->prev[self->head];
	self->value[self->head] = value;
}

static int RecentInts_Get(RecentInts *self, int key)
{
	if (key != self->head) {
		unsigned char prev = self->prev[key];
		unsigned char next = self->next[key];
		unsigned char tail;
		self->next[prev] = next;
		self->prev[next] = prev;
		tail = self->prev[self->head];
		self->next[tail] = key;
		self->prev[key] = tail;
		self->prev[self->head] = key;
		self->next[key] = self->head;
		self->head = key;
	}
	return self->value[key];
}

static void RgbStream_Construct(RgbStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_RgbStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool RgbStream_ReadCommand(RgbStream *self)
{
	int b = BitStream_ReadBits(&self->base.base, 4);
	cibool rle;
	if (b < 0)
		return FALSE;
	if (b < 8)
		rle = TRUE;
	else {
		b -= 8;
		rle = FALSE;
	}
	if (b == 0) {
		b = BitStream_ReadBits(&self->base.base, 4);
		if (b < 0)
			return FALSE;
		b += 7;
	}
	if (rle) {
		self->base.repeatValue = self->base.vtbl->readValue(&self->base);
		b++;
	}
	else
		self->base.repeatValue = -1;
	self->base.repeatCount = b;
	return TRUE;
}

static int RgbStream_ReadValue(RgbStream *self)
{
	return BitStream_ReadBits(&self->base.base, 12);
}

static void RleStream_Construct(RleStream *self, const RleStreamVtbl *vtbl)
{
	self->vtbl = vtbl;
	BitStream_Construct(&self->base);
	self->repeatCount = 0;
}

static int RleStream_ReadRle(RleStream *self)
{
	while (self->repeatCount == 0) {
		if (!self->vtbl->readCommand(self))
			return -1;
	}
	self->repeatCount--;
	if (self->repeatValue >= 0)
		return self->repeatValue;
	return self->vtbl->readValue(self);
}

static int RleStream_ReadValue(RleStream *self)
{
	return Stream_ReadByte(&self->base.base);
}

static cibool RleStream_Unpack(RleStream *self, unsigned char *unpacked, int unpackedOffset, int unpackedStride, int unpackedEnd)
{
	for (; unpackedOffset < unpackedEnd; unpackedOffset += unpackedStride) {
		int b = RleStream_ReadRle(self);
		if (b < 0)
			return FALSE;
		unpacked[unpackedOffset] = b;
	}
	return TRUE;
}

static cibool RleStream_UnpackC64(RleStream *self, unsigned char *unpacked, int unpackedLength)
{
	unpacked[0] = self->base.base.content[0];
	unpacked[1] = self->base.base.content[1];
	return RleStream_Unpack(self, unpacked, 2, 1, unpackedLength);
}

static cibool RleStream_UnpackColumns(RleStream *self, unsigned char *unpacked, int unpackedOffset, int unpackedStride, int unpackedEnd)
{
	{
		int x;
		for (x = 0; x < unpackedStride; x++) {
			if (!RleStream_Unpack(self, unpacked, unpackedOffset + x, unpackedStride, unpackedEnd))
				return FALSE;
		}
	}
	return TRUE;
}

static cibool RleStream_UnpackWords(RleStream *self, unsigned char *unpacked, int unpackedOffset, int unpackedStride, int unpackedEnd)
{
	for (; unpackedOffset < unpackedEnd; unpackedOffset += unpackedStride) {
		int b = RleStream_ReadRle(self);
		if (b < 0)
			return FALSE;
		unpacked[unpackedOffset] = b;
		b = RleStream_ReadRle(self);
		if (b < 0)
			return FALSE;
		unpacked[unpackedOffset + 1] = b;
	}
	return TRUE;
}

static void ScStream_Construct(ScStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_ScStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool ScStream_ReadCommand(ScStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b < 128) {
		self->base.repeatCount = b;
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
	}
	else {
		self->base.repeatCount = b - 128;
		self->base.repeatValue = -1;
	}
	return TRUE;
}

static void ShamLacePalette_Construct(ShamLacePalette *self, const MultiPaletteVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_ShamLacePalette;
	MultiPalette_Construct(&self->base, vtbl);
}

static void ShamLacePalette_SetLinePalette(ShamLacePalette const *self, RECOIL *recoil, int y)
{
	MultiPalette_SetOcsPalette(&self->base, recoil, self->base.base.base.contentOffset + (y >> 1 << 5), 16);
}

static void SpcStream_Construct(SpcStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_SpcStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool SpcStream_ReadCommand(SpcStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b < 128) {
		self->base.repeatCount = b + 1;
		self->base.repeatValue = -1;
	}
	else {
		self->base.repeatCount = 258 - b;
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
	}
	return TRUE;
}

static int SprStream_ReadBase(SprStream *self, int b)
{
	int r = Stream_ReadHexDigit(&self->base);
	if (r < 0 || r >= b)
		return -1;
	do {
		int d = Stream_ReadHexDigit(&self->base);
		if (d < 0)
			return r;
		if (d >= b)
			return -1;
		r = r * b + d;
	}
	while (r < 320);
	return -1;
}

static int SprStream_ReadInt(SprStream *self)
{
	while (self->base.contentOffset < self->base.contentLength) {
		int c = self->base.content[self->base.contentOffset];
		switch (c) {
		case 32:
		case 9:
		case 13:
		case 10:
			self->base.contentOffset++;
			break;
		case 36:
			self->base.contentOffset++;
			return SprStream_ReadBase(self, 16);
		case 37:
			self->base.contentOffset++;
			return SprStream_ReadBase(self, 2);
		default:
			return SprStream_ReadBase(self, 10);
		}
	}
	return -1;
}

static void SpsStream_Construct(SpsStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_SpsStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool SpsStream_ReadCommand(SpsStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b < 128) {
		self->base.repeatCount = b + 3;
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
	}
	else {
		self->base.repeatCount = b - 127;
		self->base.repeatValue = -1;
	}
	return TRUE;
}

static int SpxStream_ReadCount(SpxStream *self)
{
	int b = Ice21Stream_ReadBits(&self->base, 2);
	if (b < 0)
		return -1;
	return Ice21Stream_ReadBits(&self->base, (b + 1) << 2);
}

static cibool SpxStream_UnpackV2(SpxStream *self, unsigned char *unpacked, int unpackedLength)
{
	self->base.bits = 0;
	{
		int unpackedOffset;
		for (unpackedOffset = unpackedLength; unpackedOffset > 0;) {
			int count;
			int distance;
			switch (Ice21Stream_ReadBit(&self->base)) {
			case -1:
				return FALSE;
			case 0:
				count = SpxStream_ReadCount(self);
				if (count <= 0)
					return FALSE;
				if (count > unpackedOffset)
					count = unpackedOffset;
				{
					int i;
					for (i = 0; i < count; i++) {
						int b = Ice21Stream_ReadBits(&self->base, 8);
						if (b < 0)
							return FALSE;
						unpacked[--unpackedOffset] = b;
					}
				}
				if (unpackedOffset == 0)
					return TRUE;
				if (count == 65535)
					continue;
				break;
			default:
				break;
			}
			distance = SpxStream_ReadCount(self);
			if (distance <= 0 || unpackedOffset + distance > unpackedLength)
				return FALSE;
			count = SpxStream_ReadCount(self);
			if (count < 0)
				return FALSE;
			count += 3;
			if (count > unpackedOffset)
				count = unpackedOffset;
			do {
				unpackedOffset--;
				unpacked[unpackedOffset] = unpacked[unpackedOffset + distance];
			}
			while (--count > 0);
		}
	}
	return TRUE;
}

static void SrStream_Construct(SrStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_SrStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool SrStream_ReadCommand(SrStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	switch (b) {
	case -1:
		return FALSE;
	case 0:
		self->base.repeatCount = Stream_ReadByte(&self->base.base.base);
		if (self->base.repeatCount == 0)
			self->base.repeatCount = 256;
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
		return TRUE;
	case 1:
	case 2:
	case 3:
	case 4:
	case 5:
	case 6:
	case 7:
	case 8:
	case 9:
	case 10:
	case 11:
	case 12:
	case 13:
	case 14:
	case 15:
		self->base.repeatCount = b;
		self->base.repeatValue = Stream_ReadByte(&self->base.base.base);
		return TRUE;
	default:
		self->base.repeatCount = 1;
		self->base.repeatValue = b;
		return TRUE;
	}
}

static int Stream_ParseInt(Stream *self)
{
	{
		int r;
		for (r = 0;;) {
			int c = Stream_ReadByte(self);
			if (c < 48 || c > 57) {
				if (c != 13 || Stream_ReadByte(self) != 10)
					return -1;
				return r;
			}
			if (r > 3200)
				return -1;
			r = r * 10 + c - 48;
		}
	}
}

static int Stream_ReadByte(Stream *self)
{
	if (self->contentOffset >= self->contentLength)
		return -1;
	return self->content[self->contentOffset++];
}

static cibool Stream_ReadBytes(Stream *self, unsigned char *dest, int destOffset, int count)
{
	int nextOffset = self->contentOffset + count;
	if (nextOffset > self->contentLength)
		return FALSE;
	memcpy(dest + destOffset, self->content + self->contentOffset, count);
	self->contentOffset = nextOffset;
	return TRUE;
}

static int Stream_ReadHexDigit(Stream *self)
{
	int c;
	if (self->contentOffset >= self->contentLength)
		return -1;
	c = self->content[self->contentOffset++];
	if (c >= 48 && c <= 57)
		return c - 48;
	if (c >= 65 && c <= 70)
		return c - 55;
	if (c >= 97 && c <= 102)
		return c - 87;
	self->contentOffset--;
	return -1;
}

static void TnyPcsStream_Construct(TnyPcsStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_TnyPcsStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool TnyPcsStream_ReadCommand(TnyPcsStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	if (b < 0)
		return FALSE;
	if (b < 128) {
		if (b == 0 || b == 1) {
			if (self->base.base.base.contentOffset >= self->base.base.base.contentLength - 1)
				return FALSE;
			self->base.repeatCount = (self->base.base.base.content[self->base.base.base.contentOffset] << 8) | self->base.base.base.content[self->base.base.base.contentOffset + 1];
			self->base.base.base.contentOffset += 2;
		}
		else
			self->base.repeatCount = b;
		self->base.repeatValue = b == 1 ? -1 : (&self->base)->vtbl->readValue(&self->base);
	}
	else {
		self->base.repeatCount = 256 - b;
		self->base.repeatValue = -1;
	}
	return TRUE;
}

static void TnyStream_Construct(TnyStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_TnyStream;
	TnyPcsStream_Construct(&self->base, vtbl);
}

static int TnyStream_ReadValue(TnyStream *self)
{
	int value;
	if (self->valueOffset + 1 >= self->valueLength)
		return -1;
	value = (self->base.base.base.base.content[self->valueOffset] << 8) | self->base.base.base.base.content[self->valueOffset + 1];
	self->valueOffset += 2;
	return value;
}

static void Tre1Stream_Construct(Tre1Stream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_Tre1Stream;
	RleStream_Construct(&self->base, vtbl);
	self->lastRgb = -1;
}

static cibool Tre1Stream_ReadCommand(Tre1Stream *self)
{
	self->base.repeatCount = Stream_ReadByte(&self->base.base.base);
	if (self->base.repeatCount <= 0)
		return FALSE;
	if (self->base.repeatCount == 255) {
		if (self->base.base.base.contentOffset + 1 >= self->base.base.base.contentLength)
			return FALSE;
		self->base.repeatCount = 255 + (self->base.base.base.content[self->base.base.base.contentOffset] << 8) + self->base.base.base.content[self->base.base.base.contentOffset + 1];
		self->base.base.base.contentOffset += 2;
	}
	self->base.repeatValue = self->lastRgb;
	self->lastRgb = -1;
	return TRUE;
}

static int Tre1Stream_ReadValue(Tre1Stream *self)
{
	if (self->base.base.base.contentOffset + 1 >= self->base.base.base.contentLength)
		return -1;
	self->lastRgb = RECOIL_GetFalconTrueColor(self->base.base.base.content, self->base.base.base.contentOffset);
	self->base.base.base.contentOffset += 2;
	return self->lastRgb;
}

static void VdatStream_Construct(VdatStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_VdatStream;
	TnyStream_Construct(&self->base, vtbl);
}

static cibool VdatStream_ReadCommand(VdatStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base.base.base);
	if (b < 0)
		return FALSE;
	if (b < 128) {
		if (b == 0 || b == 1) {
			self->base.base.base.repeatCount = (&self->base)->base.base.vtbl->readValue(&(&self->base)->base.base);
			if (self->base.base.base.repeatCount < 0)
				return FALSE;
		}
		else
			self->base.base.base.repeatCount = b;
		self->base.base.base.repeatValue = b == 0 ? -1 : (&self->base)->base.base.vtbl->readValue(&(&self->base)->base.base);
	}
	else {
		self->base.base.base.repeatCount = 256 - b;
		self->base.base.base.repeatValue = -1;
	}
	return TRUE;
}

static void X68KPicStream_Construct(X68KPicStream *self)
{
	BitStream_Construct(&self->base);
}

static int X68KPicStream_ReadLength(X68KPicStream *self)
{
	{
		int bits;
		for (bits = 1; bits < 21; bits++) {
			switch (BitStream_ReadBit(&self->base)) {
				int length;
			case 0:
				length = BitStream_ReadBits(&self->base, bits);
				if (length < 0)
					return -1;
				return length + (1 << bits) - 1;
			case 1:
				break;
			default:
				return -1;
			}
		}
	}
	return -1;
}

static cibool X68KPicStream_SkipUntilByte(X68KPicStream *self, int expected)
{
	for (;;) {
		int b = Stream_ReadByte(&self->base.base);
		if (b < 0)
			return FALSE;
		if (b == expected)
			return TRUE;
	}
}

static void XeKoalaStream_Construct(XeKoalaStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_XeKoalaStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool XeKoalaStream_ReadCommand(XeKoalaStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	cibool rle;
	if (b < 0)
		return FALSE;
	if (b < 128)
		rle = TRUE;
	else {
		b -= 128;
		rle = FALSE;
	}
	if (b == 0) {
		int hi = Stream_ReadByte(&self->base.base.base);
		if (hi < 0)
			return FALSE;
		b = Stream_ReadByte(&self->base.base.base);
		if (b < 0)
			return FALSE;
		b |= hi << 8;
	}
	self->base.repeatCount = b;
	self->base.repeatValue = rle ? Stream_ReadByte(&self->base.base.base) : -1;
	return TRUE;
}

static cibool XeKoalaStream_UnpackRaw(int type, unsigned char const *content, int contentOffset, int contentLength, unsigned char *unpacked, int unpackedLength)
{
	XeKoalaStream rle;
	XeKoalaStream_Construct(&rle, NULL);
	rle.base.base.base.content = content;
	rle.base.base.base.contentOffset = contentOffset;
	rle.base.base.base.contentLength = contentLength;
	switch (type) {
	case 0:
		if (contentLength - contentOffset != unpackedLength)
			return FALSE;
		memcpy(unpacked + 0, content + contentOffset, unpackedLength);
		return TRUE;
	case 1:
		{
			int x;
			for (x = 0; x < 40; x++) {
				{
					int unpackedOffset;
					for (unpackedOffset = x; unpackedOffset < 80; unpackedOffset += 40) {
						if (!RleStream_Unpack(&rle.base, unpacked, unpackedOffset, 80, unpackedLength))
							return FALSE;
					}
				}
			}
		}
		return TRUE;
	case 2:
		return RleStream_Unpack(&rle.base, unpacked, 0, 1, unpackedLength);
	default:
		return FALSE;
	}
}

static cibool XeKoalaStream_UnpackWrapped(unsigned char const *content, int contentLength, unsigned char *unpacked, int unpackedLength)
{
	return contentLength >= 26 && content[0] == 255 && content[1] == 128 && content[2] == 201 && content[3] == 199 && content[4] >= 26 && content[4] < contentLength && content[5] == 0 && content[6] == 1 && content[8] == 14 && content[9] == 0 && content[10] == 40 && content[11] == 0 && content[12] == 192 && content[20] == 0 && content[21] == 0 && XeKoalaStream_UnpackRaw(content[7], content, content[4] + 1, contentLength, unpacked, unpackedLength);
}

static void XlpStream_Construct(XlpStream *self, const RleStreamVtbl *vtbl)
{
	if (vtbl == NULL)
		vtbl = &CiVtbl_XlpStream;
	RleStream_Construct(&self->base, vtbl);
}

static cibool XlpStream_ReadCommand(XlpStream *self)
{
	int b = Stream_ReadByte(&self->base.base.base);
	cibool rle;
	if (b < 0)
		return FALSE;
	if (b < 128)
		rle = FALSE;
	else {
		b -= 128;
		rle = TRUE;
	}
	self->base.repeatCount = b;
	if (b >= 64) {
		b = Stream_ReadByte(&self->base.base.base);
		if (b < 0)
			return FALSE;
		self->base.repeatCount = ((self->base.repeatCount - 64) << 8) | b;
	}
	self->base.repeatValue = rle ? Stream_ReadByte(&self->base.base.base) : -1;
	return TRUE;
}

static cibool ZxpStream_IsEof(ZxpStream const *self)
{
	return self->base.contentOffset >= self->base.contentLength;
}

static int ZxpStream_ReadChar(ZxpStream *self)
{
	int c;
	if (self->base.contentOffset >= self->base.contentLength)
		return -1;
	c = self->base.content[self->base.contentOffset++];
	if (c == 13 && self->base.contentOffset < self->base.contentLength && self->base.content[self->base.contentOffset] == 10) {
		self->base.contentOffset++;
		return 10;
	}
	return c;
}
