#ifndef RMIX_SLIDERBOX_H
#define RMIX_SLIDERBOX_H

#include "mixerhandle.h"
#include <QFormLayout>
#include <QGroupBox>

class rmixSliderBox: public QGroupBox {
	Q_OBJECT
private:
	mixerHandle *m_mixer;
	inline QString chNumName(ushort ch);

public:
	enum ctrlType_t {
		NORMAL,
		GAIN,
		MONITOR,
		MONGAIN,
		FOOTER
	};
	ushort m_numCh[4]= { 0, 0, 0, 0 };
	QFormLayout *m_layout;
	rmixSliderBox(QWidget *parent, mixerHandle *mh, QString name);
	inline ushort newRowPos(ctrlType_t type);
	QGridLayout *ensureRow(ushort ch, ushort numCh, ctrlType_t type);
	void addSlider(snd_hctl_elem_t *elem, ushort numCh, ctrlType_t type);
	void addSwitch(snd_hctl_elem_t *elem, ushort numCh, ctrlType_t type);
	void addSrcSel(snd_hctl_elem_t *elem, ushort numCh);
	void cleanup();
};

#endif
