# Examples

Sometimes the best way to learn how to use a new package is to look for
examples of what others have already built with it.

The following packages use Documenter to build their documentation and so
should give a good overview of what this package is currently able to do.

!!! note

    Packages are listed alphabetically. If you have a package that uses Documenter then
    please open a PR that adds it to the appropriate list below; a simple way to do so
    is to navigate to
    https://github.com/JuliaDocs/Documenter.jl/edit/master/docs/src/man/examples.md.

    The `make.jl` file for all listed packages will be tested to check for potential
    regressions prior to tagging new Documenter releases whenever possible.

## Registered

Packages that have tagged versions available in `METADATA.jl`.

- [Augmentor.jl](https://evizero.github.io/Augmentor.jl/)
- [BanditOpt.jl](https://v-i-s-h.github.io/BanditOpt.jl/stable/)
- [BeaData.jl](https://stephenbnicar.github.io/BeaData.jl/stable/)
- [Bio.jl](https://biojulia.net/Bio.jl/stable/)
- [ControlSystems.jl](http://juliacontrol.github.io/ControlSystems.jl/stable/)
- [Currencies.jl](https://juliafinance.github.io/Currencies.jl/stable/)
- [DiscretePredictors.jl](https://github.com/v-i-s-h/DiscretePredictors.jl)
- [Documenter.jl](https://juliadocs.github.io/Documenter.jl/stable/)
- [EvolvingGraphs.jl](https://etymoio.github.io/EvolvingGraphs.jl/stable/)
- [ExtractMacro.jl](https://carlobaldassi.github.io/ExtractMacro.jl/stable/)
- [EzXML.jl](https://bicycle1885.github.io/EzXML.jl/stable/)
- [FourierFlows.jl](https://FourierFlows.github.io/FourierFlows.jl/stable/)
- [Gadfly.jl](http://gadflyjl.org/stable/)
- [GeoStats.jl](http://juliohm.github.io/GeoStats.jl/stable/)
- [Highlights.jl](https://juliadocs.github.io/Highlights.jl/stable/)
- [IntervalConstraintProgramming.jl](https://juliaintervals.github.io/IntervalConstraintProgramming.jl/stable/)
- [Luxor.jl](https://juliagraphics.github.io/Luxor.jl/stable/)
- [MergedMethods.jl](https://michaelhatherly.github.io/MergedMethods.jl/stable/)
- [Mimi.jl](http://anthofflab.berkeley.edu/Mimi.jl/stable/)
- [NumericSuffixes.jl](https://michaelhatherly.github.io/NumericSuffixes.jl/stable/)
- [NLOptControl.jl](https://huckl3b3rry87.github.io/MPCDocs.jl/stable/)
- [OhMyREPL.jl](https://github.com/KristofferC/OhMyREPL.jl)
- [OnlineStats.jl](https://joshday.github.io/OnlineStats.jl/stable/)
- [POMDPs.jl](http://juliapomdp.github.io/POMDPs.jl/stable/)
- [PhyloNetworks.jl](http://crsl4.github.io/PhyloNetworks.jl/stable/)
- [PrivateModules.jl](https://michaelhatherly.github.io/PrivateModules.jl/stable/)
- [Query.jl](http://www.queryverse.org/Query.jl/stable/)
- [TaylorSeries.jl](http://www.juliadiff.org/TaylorSeries.jl/stable/)
- [Weave.jl](http://weavejl.mpastell.com/stable/)

## Documentation repositories

Some projects or organizations maintain dedicated documentation repositories that are
separate from specific packages.

- [DifferentialEquations.jl](http://docs.juliadiffeq.org/latest/)
- [JuliaDocs landing page](https://juliadocs.github.io/latest/)
- [JuliaMusic](https://juliamusic.github.io/JuliaMusic_documentation.jl/latest/)
- [Plots.jl](https://docs.juliaplots.org/latest/)
