
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractSocket.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractSocket>
#include <QAuthenticator>
#include <QChildEvent>
#include <QEvent>
#include <QHostAddress>
#include <QNetworkProxy>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractSocket

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractSocket::staticMetaObject);
}


//  Constructor QAbstractSocket::QAbstractSocket(QAbstractSocket::SocketType socketType, QObject *parent)


static void _init_ctor_QAbstractSocket_4299 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socketType");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QAbstractSocket> ();
}

static void _call_ctor_QAbstractSocket_4299 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractSocket::SocketType>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractSocket::SocketType>::target_type & > (heap);
  QObject *arg2 = args.read<QObject * > (heap);
  ret.write<QAbstractSocket *> (new QAbstractSocket (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketType>(arg1).cref(), arg2));
}


// void QAbstractSocket::abort()


static void _init_f_abort_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_abort_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->abort ();
}


// () const


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->atEnd ());
}


// () const


static void _init_f_bytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractSocket *)cls)->bytesAvailable ());
}


// () const


static void _init_f_bytesToWrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesToWrite_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractSocket *)cls)->bytesToWrite ());
}


// () const


static void _init_f_canReadLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canReadLine_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->canReadLine ());
}


// ()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->close ();
}


// void QAbstractSocket::connectToHost(const QString &hostName, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_connectToHost_6151 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hostName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_connectToHost_6151 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  quint16 arg2 = args.read<quint16 > (heap);
  QFlags<QIODevice::OpenModeFlag> arg3 = args ? args.read<QFlags<QIODevice::OpenModeFlag> > (heap) : (QFlags<QIODevice::OpenModeFlag>)(QIODevice::ReadWrite);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->connectToHost (arg1, arg2, arg3);
}


// void QAbstractSocket::connectToHost(const QHostAddress &address, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_connectToHost_6644 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address");
  decl->add_arg<const QHostAddress & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_connectToHost_6644 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QHostAddress &arg1 = args.read<const QHostAddress & > (heap);
  quint16 arg2 = args.read<quint16 > (heap);
  QFlags<QIODevice::OpenModeFlag> arg3 = args ? args.read<QFlags<QIODevice::OpenModeFlag> > (heap) : (QFlags<QIODevice::OpenModeFlag>)(QIODevice::ReadWrite);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->connectToHost (arg1, arg2, arg3);
}


// void QAbstractSocket::disconnectFromHost()


static void _init_f_disconnectFromHost_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_disconnectFromHost_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->disconnectFromHost ();
}


// QAbstractSocket::SocketError QAbstractSocket::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSocket::SocketError>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractSocket::SocketError>::target_type > ((qt_gsi::Converter<QAbstractSocket::SocketError>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketError>(((QAbstractSocket *)cls)->error ()));
}


// bool QAbstractSocket::flush()


static void _init_f_flush_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_flush_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->flush ());
}


// () const


static void _init_f_isSequential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSequential_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->isSequential ());
}


// bool QAbstractSocket::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->isValid ());
}


// QHostAddress QAbstractSocket::localAddress()


static void _init_f_localAddress_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHostAddress > ();
}

static void _call_f_localAddress_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHostAddress > ((QHostAddress)((QAbstractSocket *)cls)->localAddress ());
}


// quint16 QAbstractSocket::localPort()


static void _init_f_localPort_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint16 > ();
}

static void _call_f_localPort_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint16 > ((quint16)((QAbstractSocket *)cls)->localPort ());
}


// QHostAddress QAbstractSocket::peerAddress()


static void _init_f_peerAddress_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHostAddress > ();
}

static void _call_f_peerAddress_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHostAddress > ((QHostAddress)((QAbstractSocket *)cls)->peerAddress ());
}


// QString QAbstractSocket::peerName()


static void _init_f_peerName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_peerName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QAbstractSocket *)cls)->peerName ());
}


// quint16 QAbstractSocket::peerPort()


static void _init_f_peerPort_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint16 > ();
}

static void _call_f_peerPort_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint16 > ((quint16)((QAbstractSocket *)cls)->peerPort ());
}


// QNetworkProxy QAbstractSocket::proxy()


static void _init_f_proxy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkProxy > ();
}

static void _call_f_proxy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNetworkProxy > ((QNetworkProxy)((QAbstractSocket *)cls)->proxy ());
}


// qint64 QAbstractSocket::readBufferSize()


static void _init_f_readBufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_readBufferSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractSocket *)cls)->readBufferSize ());
}


// void QAbstractSocket::setProxy(const QNetworkProxy &networkProxy)


static void _init_f_setProxy_2686 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("networkProxy");
  decl->add_arg<const QNetworkProxy & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProxy_2686 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkProxy &arg1 = args.read<const QNetworkProxy & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->setProxy (arg1);
}


// void QAbstractSocket::setReadBufferSize(qint64 size)


static void _init_f_setReadBufferSize_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadBufferSize_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = args.read<qint64 > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->setReadBufferSize (arg1);
}


// bool QAbstractSocket::setSocketDescriptor(int socketDescriptor, QAbstractSocket::SocketState state, QFlags<QIODevice::OpenModeFlag> openMode)


static void _init_f_setSocketDescriptor_6993 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socketDescriptor");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("state", true, "QAbstractSocket::ConnectedState");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("openMode", true, "QIODevice::ReadWrite");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setSocketDescriptor_6993 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & > (heap) : (const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type &)(qt_gsi::CppToQtReadAdaptor<QAbstractSocket::SocketState>(heap, QAbstractSocket::ConnectedState));
  QFlags<QIODevice::OpenModeFlag> arg3 = args ? args.read<QFlags<QIODevice::OpenModeFlag> > (heap) : (QFlags<QIODevice::OpenModeFlag>)(QIODevice::ReadWrite);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->setSocketDescriptor (arg1, qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketState>(arg2).cref(), arg3));
}


// void QAbstractSocket::setSocketOption(QAbstractSocket::SocketOption option, const QVariant &value)


static void _init_f_setSocketOption_5331 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSocketOption_5331 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractSocket *)cls)->setSocketOption (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketOption>(arg1).cref(), arg2);
}


// int QAbstractSocket::socketDescriptor()


static void _init_f_socketDescriptor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_socketDescriptor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractSocket *)cls)->socketDescriptor ());
}


// QVariant QAbstractSocket::socketOption(QAbstractSocket::SocketOption option)


static void _init_f_socketOption_3320 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_socketOption_3320 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QAbstractSocket *)cls)->socketOption (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketOption>(arg1).cref()));
}


// QAbstractSocket::SocketType QAbstractSocket::socketType()


static void _init_f_socketType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSocket::SocketType>::target_type > ();
}

static void _call_f_socketType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractSocket::SocketType>::target_type > ((qt_gsi::Converter<QAbstractSocket::SocketType>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketType>(((QAbstractSocket *)cls)->socketType ()));
}


// QAbstractSocket::SocketState QAbstractSocket::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSocket::SocketState>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractSocket::SocketState>::target_type > ((qt_gsi::Converter<QAbstractSocket::SocketState>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketState>(((QAbstractSocket *)cls)->state ()));
}


// (int)


static void _init_f_waitForBytesWritten_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForBytesWritten_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? args.read<int > (heap) : (int)(30000);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->waitForBytesWritten (arg1));
}


// bool QAbstractSocket::waitForConnected(int msecs)


static void _init_f_waitForConnected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForConnected_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? args.read<int > (heap) : (int)(30000);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->waitForConnected (arg1));
}


// bool QAbstractSocket::waitForDisconnected(int msecs)


static void _init_f_waitForDisconnected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForDisconnected_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? args.read<int > (heap) : (int)(30000);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->waitForDisconnected (arg1));
}


// (int)


static void _init_f_waitForReadyRead_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForReadyRead_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? args.read<int > (heap) : (int)(30000);
  ret.write<bool > ((bool)((QAbstractSocket *)cls)->waitForReadyRead (arg1));
}


// static QString QAbstractSocket::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(0);
  ret.write<QString > ((QString)QAbstractSocket::tr (arg1, arg2));
}


// static QString QAbstractSocket::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args.read<const char * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QString > ((QString)QAbstractSocket::tr (arg1, arg2, arg3));
}


// static QString QAbstractSocket::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(0);
  ret.write<QString > ((QString)QAbstractSocket::trUtf8 (arg1, arg2));
}


// static QString QAbstractSocket::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args.read<const char * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QString > ((QString)QAbstractSocket::trUtf8 (arg1, arg2, arg3));
}



namespace gsi
{

static gsi::Methods methods_QAbstractSocket () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractSocket::QAbstractSocket(QAbstractSocket::SocketType socketType, QObject *parent)\nThis method creates an object of class QAbstractSocket.", &_init_ctor_QAbstractSocket_4299, &_call_ctor_QAbstractSocket_4299);
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("abort", "@brief Method void QAbstractSocket::abort()\n", false, &_init_f_abort_0, &_call_f_abort_0);
  methods += new qt_gsi::GenericMethod ("atEnd", "@brief Method () const\nThis is a reimplementation of QIODevice::atEnd", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
  methods += new qt_gsi::GenericMethod ("bytesAvailable", "@brief Method () const\nThis is a reimplementation of QIODevice::bytesAvailable", true, &_init_f_bytesAvailable_c0, &_call_f_bytesAvailable_c0);
  methods += new qt_gsi::GenericMethod ("bytesToWrite", "@brief Method () const\nThis is a reimplementation of QIODevice::bytesToWrite", true, &_init_f_bytesToWrite_c0, &_call_f_bytesToWrite_c0);
  methods += new qt_gsi::GenericMethod ("canReadLine", "@brief Method () const\nThis is a reimplementation of QIODevice::canReadLine", true, &_init_f_canReadLine_c0, &_call_f_canReadLine_c0);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method ()\nThis is a reimplementation of QIODevice::close", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod ("connectToHost", "@brief Method void QAbstractSocket::connectToHost(const QString &hostName, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_connectToHost_6151, &_call_f_connectToHost_6151);
  methods += new qt_gsi::GenericMethod ("connectToHost", "@brief Method void QAbstractSocket::connectToHost(const QHostAddress &address, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_connectToHost_6644, &_call_f_connectToHost_6644);
  methods += new qt_gsi::GenericMethod ("disconnectFromHost", "@brief Method void QAbstractSocket::disconnectFromHost()\n", false, &_init_f_disconnectFromHost_0, &_call_f_disconnectFromHost_0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QAbstractSocket::SocketError QAbstractSocket::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("flush", "@brief Method bool QAbstractSocket::flush()\n", false, &_init_f_flush_0, &_call_f_flush_0);
  methods += new qt_gsi::GenericMethod ("isSequential?", "@brief Method () const\nThis is a reimplementation of QIODevice::isSequential", true, &_init_f_isSequential_c0, &_call_f_isSequential_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QAbstractSocket::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("localAddress", "@brief Method QHostAddress QAbstractSocket::localAddress()\n", true, &_init_f_localAddress_c0, &_call_f_localAddress_c0);
  methods += new qt_gsi::GenericMethod ("localPort", "@brief Method quint16 QAbstractSocket::localPort()\n", true, &_init_f_localPort_c0, &_call_f_localPort_c0);
  methods += new qt_gsi::GenericMethod ("peerAddress", "@brief Method QHostAddress QAbstractSocket::peerAddress()\n", true, &_init_f_peerAddress_c0, &_call_f_peerAddress_c0);
  methods += new qt_gsi::GenericMethod ("peerName", "@brief Method QString QAbstractSocket::peerName()\n", true, &_init_f_peerName_c0, &_call_f_peerName_c0);
  methods += new qt_gsi::GenericMethod ("peerPort", "@brief Method quint16 QAbstractSocket::peerPort()\n", true, &_init_f_peerPort_c0, &_call_f_peerPort_c0);
  methods += new qt_gsi::GenericMethod (":proxy", "@brief Method QNetworkProxy QAbstractSocket::proxy()\n", true, &_init_f_proxy_c0, &_call_f_proxy_c0);
  methods += new qt_gsi::GenericMethod (":readBufferSize", "@brief Method qint64 QAbstractSocket::readBufferSize()\n", true, &_init_f_readBufferSize_c0, &_call_f_readBufferSize_c0);
  methods += new qt_gsi::GenericMethod ("setProxy|proxy=", "@brief Method void QAbstractSocket::setProxy(const QNetworkProxy &networkProxy)\n", false, &_init_f_setProxy_2686, &_call_f_setProxy_2686);
  methods += new qt_gsi::GenericMethod ("setReadBufferSize|readBufferSize=", "@brief Method void QAbstractSocket::setReadBufferSize(qint64 size)\n", false, &_init_f_setReadBufferSize_986, &_call_f_setReadBufferSize_986);
  methods += new qt_gsi::GenericMethod ("setSocketDescriptor", "@brief Method bool QAbstractSocket::setSocketDescriptor(int socketDescriptor, QAbstractSocket::SocketState state, QFlags<QIODevice::OpenModeFlag> openMode)\n", false, &_init_f_setSocketDescriptor_6993, &_call_f_setSocketDescriptor_6993);
  methods += new qt_gsi::GenericMethod ("setSocketOption", "@brief Method void QAbstractSocket::setSocketOption(QAbstractSocket::SocketOption option, const QVariant &value)\n", false, &_init_f_setSocketOption_5331, &_call_f_setSocketOption_5331);
  methods += new qt_gsi::GenericMethod ("socketDescriptor", "@brief Method int QAbstractSocket::socketDescriptor()\n", true, &_init_f_socketDescriptor_c0, &_call_f_socketDescriptor_c0);
  methods += new qt_gsi::GenericMethod ("socketOption", "@brief Method QVariant QAbstractSocket::socketOption(QAbstractSocket::SocketOption option)\n", false, &_init_f_socketOption_3320, &_call_f_socketOption_3320);
  methods += new qt_gsi::GenericMethod ("socketType", "@brief Method QAbstractSocket::SocketType QAbstractSocket::socketType()\n", true, &_init_f_socketType_c0, &_call_f_socketType_c0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QAbstractSocket::SocketState QAbstractSocket::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("waitForBytesWritten", "@brief Method (int)\nThis is a reimplementation of QIODevice::waitForBytesWritten", false, &_init_f_waitForBytesWritten_767, &_call_f_waitForBytesWritten_767);
  methods += new qt_gsi::GenericMethod ("waitForConnected", "@brief Method bool QAbstractSocket::waitForConnected(int msecs)\n", false, &_init_f_waitForConnected_767, &_call_f_waitForConnected_767);
  methods += new qt_gsi::GenericMethod ("waitForDisconnected", "@brief Method bool QAbstractSocket::waitForDisconnected(int msecs)\n", false, &_init_f_waitForDisconnected_767, &_call_f_waitForDisconnected_767);
  methods += new qt_gsi::GenericMethod ("waitForReadyRead", "@brief Method (int)\nThis is a reimplementation of QIODevice::waitForReadyRead", false, &_init_f_waitForReadyRead_767, &_call_f_waitForReadyRead_767);
  methods += gsi::qt_signal ("aboutToClose()", "aboutToClose", "@brief Signal declaration for QAbstractSocket::aboutToClose()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("bytesWritten(qint64)", "bytesWritten", gsi::arg("bytes"), "@brief Signal declaration for QAbstractSocket::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("connected()", "connected", "@brief Signal declaration for QAbstractSocket::connected()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QAbstractSocket::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("disconnected()", "disconnected", "@brief Signal declaration for QAbstractSocket::disconnected()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractSocket::SocketError>::target_type & > ("error(QAbstractSocket::SocketError)", "error_sig", gsi::arg("arg1"), "@brief Signal declaration for QAbstractSocket::error(QAbstractSocket::SocketError)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("hostFound()", "hostFound", "@brief Signal declaration for QAbstractSocket::hostFound()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QNetworkProxy &, QAuthenticator * > ("proxyAuthenticationRequired(const QNetworkProxy &, QAuthenticator *)", "proxyAuthenticationRequired", gsi::arg("proxy"), gsi::arg("authenticator"), "@brief Signal declaration for QAbstractSocket::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readChannelFinished()", "readChannelFinished", "@brief Signal declaration for QAbstractSocket::readChannelFinished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("readyRead()", "readyRead", "@brief Signal declaration for QAbstractSocket::readyRead()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & > ("stateChanged(QAbstractSocket::SocketState)", "stateChanged", gsi::arg("arg1"), "@brief Signal declaration for QAbstractSocket::stateChanged(QAbstractSocket::SocketState)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractSocket::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractSocket::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractSocket::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractSocket::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QIODevice> &qtdecl_QIODevice ();

qt_gsi::QtNativeClass<QAbstractSocket> decl_QAbstractSocket (qtdecl_QIODevice (), "QAbstractSocket",
  methods_QAbstractSocket (),
  "@qt\n@brief Binding of QAbstractSocket");


GSIQT_PUBLIC gsi::Class<QAbstractSocket> &qtdecl_QAbstractSocket () { return decl_QAbstractSocket; }

}


//  Implementation of the enum wrapper class for QAbstractSocket::NetworkLayerProtocol
namespace qt_gsi
{

static gsi::Enum<QAbstractSocket::NetworkLayerProtocol> decl_QAbstractSocket_NetworkLayerProtocol_Enum ("QAbstractSocket_NetworkLayerProtocol",
    gsi::enum_const ("IPv4Protocol", QAbstractSocket::IPv4Protocol, "@brief Enum constant QAbstractSocket::IPv4Protocol") +
    gsi::enum_const ("IPv6Protocol", QAbstractSocket::IPv6Protocol, "@brief Enum constant QAbstractSocket::IPv6Protocol") +
    gsi::enum_const ("UnknownNetworkLayerProtocol", QAbstractSocket::UnknownNetworkLayerProtocol, "@brief Enum constant QAbstractSocket::UnknownNetworkLayerProtocol"),
  "@qt\n@brief This class represents the QAbstractSocket::NetworkLayerProtocol enum");

static gsi::QFlagsClass<QAbstractSocket::NetworkLayerProtocol > decl_QAbstractSocket_NetworkLayerProtocol_Enums ("QAbstractSocket_QFlags_NetworkLayerProtocol",
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::NetworkLayerProtocol> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_NetworkLayerProtocol_Enum_in_parent (decl_QAbstractSocket_NetworkLayerProtocol_Enum.defs ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_NetworkLayerProtocol_Enum_as_child (decl_QAbstractSocket_NetworkLayerProtocol_Enum, "NetworkLayerProtocol");
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_NetworkLayerProtocol_Enums_as_child (decl_QAbstractSocket_NetworkLayerProtocol_Enums, "QFlags_NetworkLayerProtocol");

}


//  Implementation of the enum wrapper class for QAbstractSocket::SocketError
namespace qt_gsi
{

static gsi::Enum<QAbstractSocket::SocketError> decl_QAbstractSocket_SocketError_Enum ("QAbstractSocket_SocketError",
    gsi::enum_const ("ConnectionRefusedError", QAbstractSocket::ConnectionRefusedError, "@brief Enum constant QAbstractSocket::ConnectionRefusedError") +
    gsi::enum_const ("RemoteHostClosedError", QAbstractSocket::RemoteHostClosedError, "@brief Enum constant QAbstractSocket::RemoteHostClosedError") +
    gsi::enum_const ("HostNotFoundError", QAbstractSocket::HostNotFoundError, "@brief Enum constant QAbstractSocket::HostNotFoundError") +
    gsi::enum_const ("SocketAccessError", QAbstractSocket::SocketAccessError, "@brief Enum constant QAbstractSocket::SocketAccessError") +
    gsi::enum_const ("SocketResourceError", QAbstractSocket::SocketResourceError, "@brief Enum constant QAbstractSocket::SocketResourceError") +
    gsi::enum_const ("SocketTimeoutError", QAbstractSocket::SocketTimeoutError, "@brief Enum constant QAbstractSocket::SocketTimeoutError") +
    gsi::enum_const ("DatagramTooLargeError", QAbstractSocket::DatagramTooLargeError, "@brief Enum constant QAbstractSocket::DatagramTooLargeError") +
    gsi::enum_const ("NetworkError", QAbstractSocket::NetworkError, "@brief Enum constant QAbstractSocket::NetworkError") +
    gsi::enum_const ("AddressInUseError", QAbstractSocket::AddressInUseError, "@brief Enum constant QAbstractSocket::AddressInUseError") +
    gsi::enum_const ("SocketAddressNotAvailableError", QAbstractSocket::SocketAddressNotAvailableError, "@brief Enum constant QAbstractSocket::SocketAddressNotAvailableError") +
    gsi::enum_const ("UnsupportedSocketOperationError", QAbstractSocket::UnsupportedSocketOperationError, "@brief Enum constant QAbstractSocket::UnsupportedSocketOperationError") +
    gsi::enum_const ("UnfinishedSocketOperationError", QAbstractSocket::UnfinishedSocketOperationError, "@brief Enum constant QAbstractSocket::UnfinishedSocketOperationError") +
    gsi::enum_const ("ProxyAuthenticationRequiredError", QAbstractSocket::ProxyAuthenticationRequiredError, "@brief Enum constant QAbstractSocket::ProxyAuthenticationRequiredError") +
    gsi::enum_const ("SslHandshakeFailedError", QAbstractSocket::SslHandshakeFailedError, "@brief Enum constant QAbstractSocket::SslHandshakeFailedError") +
    gsi::enum_const ("ProxyConnectionRefusedError", QAbstractSocket::ProxyConnectionRefusedError, "@brief Enum constant QAbstractSocket::ProxyConnectionRefusedError") +
    gsi::enum_const ("ProxyConnectionClosedError", QAbstractSocket::ProxyConnectionClosedError, "@brief Enum constant QAbstractSocket::ProxyConnectionClosedError") +
    gsi::enum_const ("ProxyConnectionTimeoutError", QAbstractSocket::ProxyConnectionTimeoutError, "@brief Enum constant QAbstractSocket::ProxyConnectionTimeoutError") +
    gsi::enum_const ("ProxyNotFoundError", QAbstractSocket::ProxyNotFoundError, "@brief Enum constant QAbstractSocket::ProxyNotFoundError") +
    gsi::enum_const ("ProxyProtocolError", QAbstractSocket::ProxyProtocolError, "@brief Enum constant QAbstractSocket::ProxyProtocolError") +
    gsi::enum_const ("UnknownSocketError", QAbstractSocket::UnknownSocketError, "@brief Enum constant QAbstractSocket::UnknownSocketError"),
  "@qt\n@brief This class represents the QAbstractSocket::SocketError enum");

static gsi::QFlagsClass<QAbstractSocket::SocketError > decl_QAbstractSocket_SocketError_Enums ("QAbstractSocket_QFlags_SocketError",
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::SocketError> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_SocketError_Enum_in_parent (decl_QAbstractSocket_SocketError_Enum.defs ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketError_Enum_as_child (decl_QAbstractSocket_SocketError_Enum, "SocketError");
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketError_Enums_as_child (decl_QAbstractSocket_SocketError_Enums, "QFlags_SocketError");

}


//  Implementation of the enum wrapper class for QAbstractSocket::SocketOption
namespace qt_gsi
{

static gsi::Enum<QAbstractSocket::SocketOption> decl_QAbstractSocket_SocketOption_Enum ("QAbstractSocket_SocketOption",
    gsi::enum_const ("LowDelayOption", QAbstractSocket::LowDelayOption, "@brief Enum constant QAbstractSocket::LowDelayOption") +
    gsi::enum_const ("KeepAliveOption", QAbstractSocket::KeepAliveOption, "@brief Enum constant QAbstractSocket::KeepAliveOption"),
  "@qt\n@brief This class represents the QAbstractSocket::SocketOption enum");

static gsi::QFlagsClass<QAbstractSocket::SocketOption > decl_QAbstractSocket_SocketOption_Enums ("QAbstractSocket_QFlags_SocketOption",
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::SocketOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_SocketOption_Enum_in_parent (decl_QAbstractSocket_SocketOption_Enum.defs ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketOption_Enum_as_child (decl_QAbstractSocket_SocketOption_Enum, "SocketOption");
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketOption_Enums_as_child (decl_QAbstractSocket_SocketOption_Enums, "QFlags_SocketOption");

}


//  Implementation of the enum wrapper class for QAbstractSocket::SocketState
namespace qt_gsi
{

static gsi::Enum<QAbstractSocket::SocketState> decl_QAbstractSocket_SocketState_Enum ("QAbstractSocket_SocketState",
    gsi::enum_const ("UnconnectedState", QAbstractSocket::UnconnectedState, "@brief Enum constant QAbstractSocket::UnconnectedState") +
    gsi::enum_const ("HostLookupState", QAbstractSocket::HostLookupState, "@brief Enum constant QAbstractSocket::HostLookupState") +
    gsi::enum_const ("ConnectingState", QAbstractSocket::ConnectingState, "@brief Enum constant QAbstractSocket::ConnectingState") +
    gsi::enum_const ("ConnectedState", QAbstractSocket::ConnectedState, "@brief Enum constant QAbstractSocket::ConnectedState") +
    gsi::enum_const ("BoundState", QAbstractSocket::BoundState, "@brief Enum constant QAbstractSocket::BoundState") +
    gsi::enum_const ("ListeningState", QAbstractSocket::ListeningState, "@brief Enum constant QAbstractSocket::ListeningState") +
    gsi::enum_const ("ClosingState", QAbstractSocket::ClosingState, "@brief Enum constant QAbstractSocket::ClosingState"),
  "@qt\n@brief This class represents the QAbstractSocket::SocketState enum");

static gsi::QFlagsClass<QAbstractSocket::SocketState > decl_QAbstractSocket_SocketState_Enums ("QAbstractSocket_QFlags_SocketState",
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::SocketState> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_SocketState_Enum_in_parent (decl_QAbstractSocket_SocketState_Enum.defs ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketState_Enum_as_child (decl_QAbstractSocket_SocketState_Enum, "SocketState");
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketState_Enums_as_child (decl_QAbstractSocket_SocketState_Enums, "QFlags_SocketState");

}


//  Implementation of the enum wrapper class for QAbstractSocket::SocketType
namespace qt_gsi
{

static gsi::Enum<QAbstractSocket::SocketType> decl_QAbstractSocket_SocketType_Enum ("QAbstractSocket_SocketType",
    gsi::enum_const ("TcpSocket", QAbstractSocket::TcpSocket, "@brief Enum constant QAbstractSocket::TcpSocket") +
    gsi::enum_const ("UdpSocket", QAbstractSocket::UdpSocket, "@brief Enum constant QAbstractSocket::UdpSocket") +
    gsi::enum_const ("UnknownSocketType", QAbstractSocket::UnknownSocketType, "@brief Enum constant QAbstractSocket::UnknownSocketType"),
  "@qt\n@brief This class represents the QAbstractSocket::SocketType enum");

static gsi::QFlagsClass<QAbstractSocket::SocketType > decl_QAbstractSocket_SocketType_Enums ("QAbstractSocket_QFlags_SocketType",
  "@qt\n@brief This class represents the QFlags<QAbstractSocket::SocketType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAbstractSocket> inject_QAbstractSocket_SocketType_Enum_in_parent (decl_QAbstractSocket_SocketType_Enum.defs ());
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketType_Enum_as_child (decl_QAbstractSocket_SocketType_Enum, "SocketType");
static gsi::ClassExt<QAbstractSocket> decl_QAbstractSocket_SocketType_Enums_as_child (decl_QAbstractSocket_SocketType_Enums, "QFlags_SocketType");

}

