
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDialogButtonBox.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QDialogButtonBox>
#include <QAbstractButton>
#include <QAction>
#include <QActionEvent>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputContext>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPoint>
#include <QPushButton>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDialogButtonBox

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QDialogButtonBox::staticMetaObject);
}


// void QDialogButtonBox::addButton(QAbstractButton *button, QDialogButtonBox::ButtonRole role)


static void _init_f_addButton_5247 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addButton_5247 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractButton *arg1 = args.read<QAbstractButton * > (heap);
  const qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox *)cls)->addButton (arg1, qt_gsi::QtToCppAdaptor<QDialogButtonBox::ButtonRole>(arg2).cref());
}


// QPushButton *QDialogButtonBox::addButton(const QString &text, QDialogButtonBox::ButtonRole role)


static void _init_f_addButton_5113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type & > (argspec_1);
  decl->set_return<QPushButton * > ();
}

static void _call_f_addButton_5113 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type & > (heap);
  ret.write<QPushButton * > ((QPushButton *)((QDialogButtonBox *)cls)->addButton (arg1, qt_gsi::QtToCppAdaptor<QDialogButtonBox::ButtonRole>(arg2).cref()));
}


// QPushButton *QDialogButtonBox::addButton(QDialogButtonBox::StandardButton button)


static void _init_f_addButton_3611 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type & > (argspec_0);
  decl->set_return<QPushButton * > ();
}

static void _call_f_addButton_3611 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type & arg1 = args.read<const qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type & > (heap);
  ret.write<QPushButton * > ((QPushButton *)((QDialogButtonBox *)cls)->addButton (qt_gsi::QtToCppAdaptor<QDialogButtonBox::StandardButton>(arg1).cref()));
}


// QPushButton *QDialogButtonBox::button(QDialogButtonBox::StandardButton which)


static void _init_f_button_c3611 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type & > (argspec_0);
  decl->set_return<QPushButton * > ();
}

static void _call_f_button_c3611 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type & arg1 = args.read<const qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type & > (heap);
  ret.write<QPushButton * > ((QPushButton *)((QDialogButtonBox *)cls)->button (qt_gsi::QtToCppAdaptor<QDialogButtonBox::StandardButton>(arg1).cref()));
}


// QDialogButtonBox::ButtonRole QDialogButtonBox::buttonRole(QAbstractButton *button)


static void _init_f_buttonRole_c2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type > ();
}

static void _call_f_buttonRole_c2159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractButton *arg1 = args.read<QAbstractButton * > (heap);
  ret.write<qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type > ((qt_gsi::Converter<QDialogButtonBox::ButtonRole>::target_type)qt_gsi::CppToQtAdaptor<QDialogButtonBox::ButtonRole>(((QDialogButtonBox *)cls)->buttonRole (arg1)));
}


// QList<QAbstractButton *> QDialogButtonBox::buttons()


static void _init_f_buttons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAbstractButton *> > ();
}

static void _call_f_buttons_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAbstractButton *> > ((QList<QAbstractButton *>)((QDialogButtonBox *)cls)->buttons ());
}


// bool QDialogButtonBox::centerButtons()


static void _init_f_centerButtons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_centerButtons_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDialogButtonBox *)cls)->centerButtons ());
}


// void QDialogButtonBox::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox *)cls)->clear ();
}


// Qt::Orientation QDialogButtonBox::orientation()


static void _init_f_orientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::Orientation>::target_type > ();
}

static void _call_f_orientation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::Orientation>::target_type > ((qt_gsi::Converter<Qt::Orientation>::target_type)qt_gsi::CppToQtAdaptor<Qt::Orientation>(((QDialogButtonBox *)cls)->orientation ()));
}


// void QDialogButtonBox::removeButton(QAbstractButton *button)


static void _init_f_removeButton_2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeButton_2159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractButton *arg1 = args.read<QAbstractButton * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox *)cls)->removeButton (arg1);
}


// void QDialogButtonBox::setCenterButtons(bool center)


static void _init_f_setCenterButtons_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("center");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCenterButtons_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox *)cls)->setCenterButtons (arg1);
}


// void QDialogButtonBox::setOrientation(Qt::Orientation orientation)


static void _init_f_setOrientation_1913 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrientation_1913 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox *)cls)->setOrientation (qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg1).cref());
}


// void QDialogButtonBox::setStandardButtons(QFlags<QDialogButtonBox::StandardButton> buttons)


static void _init_f_setStandardButtons_4307 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buttons");
  decl->add_arg<QFlags<QDialogButtonBox::StandardButton> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStandardButtons_4307 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QDialogButtonBox::StandardButton> arg1 = args.read<QFlags<QDialogButtonBox::StandardButton> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox *)cls)->setStandardButtons (arg1);
}


// QDialogButtonBox::StandardButton QDialogButtonBox::standardButton(QAbstractButton *button)


static void _init_f_standardButton_c2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type > ();
}

static void _call_f_standardButton_c2159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractButton *arg1 = args.read<QAbstractButton * > (heap);
  ret.write<qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type > ((qt_gsi::Converter<QDialogButtonBox::StandardButton>::target_type)qt_gsi::CppToQtAdaptor<QDialogButtonBox::StandardButton>(((QDialogButtonBox *)cls)->standardButton (arg1)));
}


// QFlags<QDialogButtonBox::StandardButton> QDialogButtonBox::standardButtons()


static void _init_f_standardButtons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QDialogButtonBox::StandardButton> > ();
}

static void _call_f_standardButtons_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QDialogButtonBox::StandardButton> > ((QFlags<QDialogButtonBox::StandardButton>)((QDialogButtonBox *)cls)->standardButtons ());
}


// static QString QDialogButtonBox::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(0);
  ret.write<QString > ((QString)QDialogButtonBox::tr (arg1, arg2));
}


// static QString QDialogButtonBox::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args.read<const char * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QString > ((QString)QDialogButtonBox::tr (arg1, arg2, arg3));
}


// static QString QDialogButtonBox::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(0);
  ret.write<QString > ((QString)QDialogButtonBox::trUtf8 (arg1, arg2));
}


// static QString QDialogButtonBox::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args.read<const char * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QString > ((QString)QDialogButtonBox::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QDialogButtonBox () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addButton", "@brief Method void QDialogButtonBox::addButton(QAbstractButton *button, QDialogButtonBox::ButtonRole role)\n", false, &_init_f_addButton_5247, &_call_f_addButton_5247);
  methods += new qt_gsi::GenericMethod ("addButton", "@brief Method QPushButton *QDialogButtonBox::addButton(const QString &text, QDialogButtonBox::ButtonRole role)\n", false, &_init_f_addButton_5113, &_call_f_addButton_5113);
  methods += new qt_gsi::GenericMethod ("addButton", "@brief Method QPushButton *QDialogButtonBox::addButton(QDialogButtonBox::StandardButton button)\n", false, &_init_f_addButton_3611, &_call_f_addButton_3611);
  methods += new qt_gsi::GenericMethod ("button", "@brief Method QPushButton *QDialogButtonBox::button(QDialogButtonBox::StandardButton which)\n", true, &_init_f_button_c3611, &_call_f_button_c3611);
  methods += new qt_gsi::GenericMethod ("buttonRole", "@brief Method QDialogButtonBox::ButtonRole QDialogButtonBox::buttonRole(QAbstractButton *button)\n", true, &_init_f_buttonRole_c2159, &_call_f_buttonRole_c2159);
  methods += new qt_gsi::GenericMethod ("buttons", "@brief Method QList<QAbstractButton *> QDialogButtonBox::buttons()\n", true, &_init_f_buttons_c0, &_call_f_buttons_c0);
  methods += new qt_gsi::GenericMethod (":centerButtons", "@brief Method bool QDialogButtonBox::centerButtons()\n", true, &_init_f_centerButtons_c0, &_call_f_centerButtons_c0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QDialogButtonBox::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod (":orientation", "@brief Method Qt::Orientation QDialogButtonBox::orientation()\n", true, &_init_f_orientation_c0, &_call_f_orientation_c0);
  methods += new qt_gsi::GenericMethod ("removeButton", "@brief Method void QDialogButtonBox::removeButton(QAbstractButton *button)\n", false, &_init_f_removeButton_2159, &_call_f_removeButton_2159);
  methods += new qt_gsi::GenericMethod ("setCenterButtons|centerButtons=", "@brief Method void QDialogButtonBox::setCenterButtons(bool center)\n", false, &_init_f_setCenterButtons_864, &_call_f_setCenterButtons_864);
  methods += new qt_gsi::GenericMethod ("setOrientation|orientation=", "@brief Method void QDialogButtonBox::setOrientation(Qt::Orientation orientation)\n", false, &_init_f_setOrientation_1913, &_call_f_setOrientation_1913);
  methods += new qt_gsi::GenericMethod ("setStandardButtons|standardButtons=", "@brief Method void QDialogButtonBox::setStandardButtons(QFlags<QDialogButtonBox::StandardButton> buttons)\n", false, &_init_f_setStandardButtons_4307, &_call_f_setStandardButtons_4307);
  methods += new qt_gsi::GenericMethod ("standardButton", "@brief Method QDialogButtonBox::StandardButton QDialogButtonBox::standardButton(QAbstractButton *button)\n", true, &_init_f_standardButton_c2159, &_call_f_standardButton_c2159);
  methods += new qt_gsi::GenericMethod (":standardButtons", "@brief Method QFlags<QDialogButtonBox::StandardButton> QDialogButtonBox::standardButtons()\n", true, &_init_f_standardButtons_c0, &_call_f_standardButtons_c0);
  methods += gsi::qt_signal ("accepted()", "accepted", "@brief Signal declaration for QDialogButtonBox::accepted()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QAbstractButton * > ("clicked(QAbstractButton *)", "clicked", gsi::arg("button"), "@brief Signal declaration for QDialogButtonBox::clicked(QAbstractButton *button)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QDialogButtonBox::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QDialogButtonBox::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("helpRequested()", "helpRequested", "@brief Signal declaration for QDialogButtonBox::helpRequested()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("rejected()", "rejected", "@brief Signal declaration for QDialogButtonBox::rejected()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QDialogButtonBox::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QDialogButtonBox::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QDialogButtonBox::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QDialogButtonBox::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QWidget> &qtdecl_QWidget ();

qt_gsi::QtNativeClass<QDialogButtonBox> decl_QDialogButtonBox (qtdecl_QWidget (), "QDialogButtonBox_Native",
  methods_QDialogButtonBox (),
  "@hide\n@alias QDialogButtonBox");

GSIQT_PUBLIC gsi::Class<QDialogButtonBox> &qtdecl_QDialogButtonBox () { return decl_QDialogButtonBox; }

}


class QDialogButtonBox_Adaptor : public QDialogButtonBox, public qt_gsi::QtObjectBase
{
public:

  virtual ~QDialogButtonBox_Adaptor();

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(QWidget *parent)
  QDialogButtonBox_Adaptor() : QDialogButtonBox()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(QWidget *parent)
  QDialogButtonBox_Adaptor(QWidget *parent) : QDialogButtonBox(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(Qt::Orientation orientation, QWidget *parent)
  QDialogButtonBox_Adaptor(Qt::Orientation orientation) : QDialogButtonBox(orientation)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(Qt::Orientation orientation, QWidget *parent)
  QDialogButtonBox_Adaptor(Qt::Orientation orientation, QWidget *parent) : QDialogButtonBox(orientation, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget *parent)
  QDialogButtonBox_Adaptor(QFlags<QDialogButtonBox::StandardButton> buttons) : QDialogButtonBox(buttons)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget *parent)
  QDialogButtonBox_Adaptor(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation) : QDialogButtonBox(buttons, orientation)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDialogButtonBox::QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget *parent)
  QDialogButtonBox_Adaptor(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget *parent) : QDialogButtonBox(buttons, orientation, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QDialogButtonBox::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QDialogButtonBox_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QDialogButtonBox::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QDialogButtonBox::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QDialogButtonBox_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QDialogButtonBox::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QDialogButtonBox::focusNextChild()
  bool fp_QDialogButtonBox_focusNextChild_0 () {
    return QDialogButtonBox::focusNextChild();
  }

  //  [expose] bool QDialogButtonBox::focusPreviousChild()
  bool fp_QDialogButtonBox_focusPreviousChild_0 () {
    return QDialogButtonBox::focusPreviousChild();
  }

  //  [expose] int QDialogButtonBox::receivers(const char *signal)
  int fp_QDialogButtonBox_receivers_c1731 (const char *signal) const {
    return QDialogButtonBox::receivers(signal);
  }

  //  [expose] void QDialogButtonBox::resetInputContext()
  void fp_QDialogButtonBox_resetInputContext_0 () {
    QDialogButtonBox::resetInputContext();
  }

  //  [expose] QObject *QDialogButtonBox::sender()
  QObject * fp_QDialogButtonBox_sender_c0 () const {
    return QDialogButtonBox::sender();
  }

  //  [expose] void QDialogButtonBox::updateMicroFocus()
  void fp_QDialogButtonBox_updateMicroFocus_0 () {
    QDialogButtonBox::updateMicroFocus();
  }

  //  [adaptor impl] bool QDialogButtonBox::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QDialogButtonBox::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QDialogButtonBox_Adaptor, bool, QObject *, QEvent *>(&QDialogButtonBox_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QDialogButtonBox::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QDialogButtonBox::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QDialogButtonBox::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QDialogButtonBox_Adaptor, int, int>(&QDialogButtonBox_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QDialogButtonBox::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QDialogButtonBox::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QDialogButtonBox::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QDialogButtonBox_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QDialogButtonBox_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QDialogButtonBox::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QDialogButtonBox::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QDialogButtonBox::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QDialogButtonBox_Adaptor, QSize>(&QDialogButtonBox_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QDialogButtonBox::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QDialogButtonBox::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QDialogButtonBox::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QDialogButtonBox_Adaptor, QPaintEngine *>(&QDialogButtonBox_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QDialogButtonBox::paintEngine();
    }
  }

  //  [adaptor impl] void QDialogButtonBox::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QDialogButtonBox::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QDialogButtonBox_Adaptor, bool>(&QDialogButtonBox_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QDialogButtonBox::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QDialogButtonBox::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QDialogButtonBox::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QDialogButtonBox_Adaptor, QSize>(&QDialogButtonBox_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QDialogButtonBox::sizeHint();
    }
  }

  //  [emitter impl] void QDialogButtonBox::accepted()
  void emitter_QDialogButtonBox_accepted_0()
  {
    emit QDialogButtonBox::accepted();
  }

  //  [adaptor impl] void QDialogButtonBox::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QDialogButtonBox::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QDialogButtonBox_Adaptor, QActionEvent *>(&QDialogButtonBox_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QDialogButtonBox::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::changeEvent(QEvent *event)
  void cbs_changeEvent_1217_0(QEvent *event)
  {
    QDialogButtonBox::changeEvent(event);
  }

  virtual void changeEvent(QEvent *event)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QDialogButtonBox_Adaptor, QEvent *>(&QDialogButtonBox_Adaptor::cbs_changeEvent_1217_0, event);
    } else {
      QDialogButtonBox::changeEvent(event);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QDialogButtonBox::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QDialogButtonBox_Adaptor, QChildEvent *>(&QDialogButtonBox_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QDialogButtonBox::childEvent(arg1);
    }
  }

  //  [emitter impl] void QDialogButtonBox::clicked(QAbstractButton *button)
  void emitter_QDialogButtonBox_clicked_2159(QAbstractButton *button)
  {
    emit QDialogButtonBox::clicked(button);
  }

  //  [adaptor impl] void QDialogButtonBox::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QDialogButtonBox::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QDialogButtonBox_Adaptor, QCloseEvent *>(&QDialogButtonBox_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QDialogButtonBox::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QDialogButtonBox::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QDialogButtonBox_Adaptor, QContextMenuEvent *>(&QDialogButtonBox_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QDialogButtonBox::contextMenuEvent(arg1);
    }
  }

  //  [emitter impl] void QDialogButtonBox::customContextMenuRequested(const QPoint &pos)
  void emitter_QDialogButtonBox_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QDialogButtonBox::customContextMenuRequested(pos);
  }

  //  [adaptor impl] void QDialogButtonBox::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QDialogButtonBox::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QDialogButtonBox_Adaptor, QEvent *>(&QDialogButtonBox_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QDialogButtonBox::customEvent(arg1);
    }
  }

  //  [emitter impl] void QDialogButtonBox::destroyed(QObject *)
  void emitter_QDialogButtonBox_destroyed_1302(QObject *arg1)
  {
    emit QDialogButtonBox::destroyed(arg1);
  }

  //  [adaptor impl] void QDialogButtonBox::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QDialogButtonBox::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QDialogButtonBox_Adaptor, const char *>(&QDialogButtonBox_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QDialogButtonBox::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QDialogButtonBox::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QDialogButtonBox_Adaptor, QDragEnterEvent *>(&QDialogButtonBox_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QDialogButtonBox::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QDialogButtonBox::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QDialogButtonBox_Adaptor, QDragLeaveEvent *>(&QDialogButtonBox_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QDialogButtonBox::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QDialogButtonBox::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QDialogButtonBox_Adaptor, QDragMoveEvent *>(&QDialogButtonBox_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QDialogButtonBox::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QDialogButtonBox::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QDialogButtonBox_Adaptor, QDropEvent *>(&QDialogButtonBox_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QDialogButtonBox::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QDialogButtonBox::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QDialogButtonBox_Adaptor, bool>(&QDialogButtonBox_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QDialogButtonBox::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QDialogButtonBox::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QDialogButtonBox_Adaptor, QEvent *>(&QDialogButtonBox_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QDialogButtonBox::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QDialogButtonBox::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QDialogButtonBox::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QDialogButtonBox_Adaptor, bool, QEvent *>(&QDialogButtonBox_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QDialogButtonBox::event(_event);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QDialogButtonBox::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QDialogButtonBox_Adaptor, QFocusEvent *>(&QDialogButtonBox_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QDialogButtonBox::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QDialogButtonBox::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QDialogButtonBox::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QDialogButtonBox_Adaptor, bool, bool>(&QDialogButtonBox_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QDialogButtonBox::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QDialogButtonBox::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QDialogButtonBox_Adaptor, QFocusEvent *>(&QDialogButtonBox_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QDialogButtonBox::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QDialogButtonBox::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QDialogButtonBox_Adaptor, const QFont &>(&QDialogButtonBox_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QDialogButtonBox::fontChange(arg1);
    }
  }

  //  [emitter impl] void QDialogButtonBox::helpRequested()
  void emitter_QDialogButtonBox_helpRequested_0()
  {
    emit QDialogButtonBox::helpRequested();
  }

  //  [adaptor impl] void QDialogButtonBox::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QDialogButtonBox::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QDialogButtonBox_Adaptor, QHideEvent *>(&QDialogButtonBox_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QDialogButtonBox::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QDialogButtonBox::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QDialogButtonBox_Adaptor, QInputMethodEvent *>(&QDialogButtonBox_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QDialogButtonBox::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QDialogButtonBox::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QDialogButtonBox_Adaptor, QKeyEvent *>(&QDialogButtonBox_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QDialogButtonBox::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QDialogButtonBox::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QDialogButtonBox_Adaptor, QKeyEvent *>(&QDialogButtonBox_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QDialogButtonBox::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::languageChange()
  void cbs_languageChange_0_0()
  {
    QDialogButtonBox::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QDialogButtonBox_Adaptor>(&QDialogButtonBox_Adaptor::cbs_languageChange_0_0);
    } else {
      QDialogButtonBox::languageChange();
    }
  }

  //  [adaptor impl] void QDialogButtonBox::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QDialogButtonBox::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QDialogButtonBox_Adaptor, QEvent *>(&QDialogButtonBox_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QDialogButtonBox::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QDialogButtonBox::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QDialogButtonBox::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QDialogButtonBox_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QDialogButtonBox_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QDialogButtonBox::metric(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QDialogButtonBox::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QDialogButtonBox_Adaptor, QMouseEvent *>(&QDialogButtonBox_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QDialogButtonBox::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QDialogButtonBox::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QDialogButtonBox_Adaptor, QMouseEvent *>(&QDialogButtonBox_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QDialogButtonBox::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QDialogButtonBox::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QDialogButtonBox_Adaptor, QMouseEvent *>(&QDialogButtonBox_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QDialogButtonBox::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QDialogButtonBox::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QDialogButtonBox_Adaptor, QMouseEvent *>(&QDialogButtonBox_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QDialogButtonBox::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QDialogButtonBox::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QDialogButtonBox_Adaptor, QMoveEvent *>(&QDialogButtonBox_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QDialogButtonBox::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QDialogButtonBox::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QDialogButtonBox_Adaptor, QPaintEvent *>(&QDialogButtonBox_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QDialogButtonBox::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QDialogButtonBox::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QDialogButtonBox_Adaptor, const QPalette &>(&QDialogButtonBox_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QDialogButtonBox::paletteChange(arg1);
    }
  }

  //  [emitter impl] void QDialogButtonBox::rejected()
  void emitter_QDialogButtonBox_rejected_0()
  {
    emit QDialogButtonBox::rejected();
  }

  //  [adaptor impl] void QDialogButtonBox::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QDialogButtonBox::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QDialogButtonBox_Adaptor, QResizeEvent *>(&QDialogButtonBox_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QDialogButtonBox::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QDialogButtonBox::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QDialogButtonBox_Adaptor, QShowEvent *>(&QDialogButtonBox_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QDialogButtonBox::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QDialogButtonBox::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QDialogButtonBox_Adaptor, QStyle &>(&QDialogButtonBox_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QDialogButtonBox::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QDialogButtonBox::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QDialogButtonBox_Adaptor, QTabletEvent *>(&QDialogButtonBox_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QDialogButtonBox::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QDialogButtonBox::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QDialogButtonBox_Adaptor, QTimerEvent *>(&QDialogButtonBox_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QDialogButtonBox::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QDialogButtonBox::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QDialogButtonBox_Adaptor, QWheelEvent *>(&QDialogButtonBox_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QDialogButtonBox::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QDialogButtonBox::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QDialogButtonBox::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QDialogButtonBox_Adaptor, bool>(&QDialogButtonBox_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QDialogButtonBox::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QDialogButtonBox_Adaptor::~QDialogButtonBox_Adaptor() { }

//  Constructor QDialogButtonBox::QDialogButtonBox(QWidget *parent) (adaptor class)

static void _init_ctor_QDialogButtonBox_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QDialogButtonBox_Adaptor> ();
}

static void _call_ctor_QDialogButtonBox_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? args.read<QWidget * > (heap) : (QWidget *)(0);
  ret.write<QDialogButtonBox_Adaptor *> (new QDialogButtonBox_Adaptor (arg1));
}


//  Constructor QDialogButtonBox::QDialogButtonBox(Qt::Orientation orientation, QWidget *parent) (adaptor class)

static void _init_ctor_QDialogButtonBox_Adaptor_3120 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QDialogButtonBox_Adaptor> ();
}

static void _call_ctor_QDialogButtonBox_Adaptor_3120 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  QWidget *arg2 = args ? args.read<QWidget * > (heap) : (QWidget *)(0);
  ret.write<QDialogButtonBox_Adaptor *> (new QDialogButtonBox_Adaptor (qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg1).cref(), arg2));
}


//  Constructor QDialogButtonBox::QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget *parent) (adaptor class)

static void _init_ctor_QDialogButtonBox_Adaptor_7319 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buttons");
  decl->add_arg<QFlags<QDialogButtonBox::StandardButton> > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation", true, "Qt::Horizontal");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return_new<QDialogButtonBox_Adaptor> ();
}

static void _call_ctor_QDialogButtonBox_Adaptor_7319 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QDialogButtonBox::StandardButton> arg1 = args.read<QFlags<QDialogButtonBox::StandardButton> > (heap);
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap) : (const qt_gsi::Converter<Qt::Orientation>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::Orientation>(heap, Qt::Horizontal));
  QWidget *arg3 = args ? args.read<QWidget * > (heap) : (QWidget *)(0);
  ret.write<QDialogButtonBox_Adaptor *> (new QDialogButtonBox_Adaptor (arg1, qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg2).cref(), arg3));
}


// emitter void QDialogButtonBox::accepted()

static void _init_emitter_accepted_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_accepted_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QDialogButtonBox_Adaptor *)cls)->emitter_QDialogButtonBox_accepted_0 ();
}


// void QDialogButtonBox::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QDialogButtonBox::changeEvent(QEvent *event)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QDialogButtonBox::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QDialogButtonBox::clicked(QAbstractButton *button)

static void _init_emitter_clicked_2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_clicked_2159 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractButton *arg1 = args.read<QAbstractButton * > (heap);
  ((QDialogButtonBox_Adaptor *)cls)->emitter_QDialogButtonBox_clicked_2159 (arg1);
}


// void QDialogButtonBox::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QDialogButtonBox::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QDialogButtonBox::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > (heap) : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > (heap) : (bool)(true);
  bool arg3 = args ? args.read<bool > (heap) : (bool)(true);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_create_2208 (arg1, arg2, arg3);
}


// emitter void QDialogButtonBox::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  ((QDialogButtonBox_Adaptor *)cls)->emitter_QDialogButtonBox_customContextMenuRequested_1916 (arg1);
}


// void QDialogButtonBox::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QDialogButtonBox::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? args.read<bool > (heap) : (bool)(true);
  bool arg2 = args ? args.read<bool > (heap) : (bool)(true);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_destroy_1620 (arg1, arg2);
}


// emitter void QDialogButtonBox::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ((QDialogButtonBox_Adaptor *)cls)->emitter_QDialogButtonBox_destroyed_1302 (arg1);
}


// void QDialogButtonBox::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// void QDialogButtonBox::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QDialogButtonBox::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QDialogButtonBox::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QDialogButtonBox::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QDialogButtonBox::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}


// void QDialogButtonBox::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QDialogButtonBox::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QDialogButtonBox_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QDialogButtonBox::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QDialogButtonBox_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QDialogButtonBox::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QDialogButtonBox::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_focusNextChild_0 ());
}


// bool QDialogButtonBox::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QDialogButtonBox_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QDialogButtonBox::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QDialogButtonBox::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_focusPreviousChild_0 ());
}


// void QDialogButtonBox::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}


// int QDialogButtonBox::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QDialogButtonBox_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// emitter void QDialogButtonBox::helpRequested()

static void _init_emitter_helpRequested_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_helpRequested_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QDialogButtonBox_Adaptor *)cls)->emitter_QDialogButtonBox_helpRequested_0 ();
}


// void QDialogButtonBox::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QDialogButtonBox::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QDialogButtonBox::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QDialogButtonBox_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// void QDialogButtonBox::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QDialogButtonBox::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QDialogButtonBox::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}


// void QDialogButtonBox::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QDialogButtonBox::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QDialogButtonBox_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QDialogButtonBox::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QDialogButtonBox_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QDialogButtonBox::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QDialogButtonBox::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QDialogButtonBox::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QDialogButtonBox::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QDialogButtonBox::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// QPaintEngine *QDialogButtonBox::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QDialogButtonBox_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QDialogButtonBox::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// void QDialogButtonBox::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPalette &arg1 = args.read<const QPalette & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}


// exposed int QDialogButtonBox::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<int > ((int)((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_receivers_c1731 (arg1));
}


// emitter void QDialogButtonBox::rejected()

static void _init_emitter_rejected_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_rejected_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QDialogButtonBox_Adaptor *)cls)->emitter_QDialogButtonBox_rejected_0 ();
}


// exposed void QDialogButtonBox::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_resetInputContext_0 ();
}


// void QDialogButtonBox::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QDialogButtonBox::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_sender_c0 ());
}


// void QDialogButtonBox::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QDialogButtonBox::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QDialogButtonBox::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QDialogButtonBox_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QDialogButtonBox::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyle &arg1 = args.read<QStyle & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}


// void QDialogButtonBox::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QDialogButtonBox::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QDialogButtonBox::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->fp_QDialogButtonBox_updateMicroFocus_0 ();
}


// void QDialogButtonBox::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// void QDialogButtonBox::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDialogButtonBox_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QDialogButtonBox_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}


namespace gsi
{

gsi::Class<QDialogButtonBox> &qtdecl_QDialogButtonBox ();

static gsi::Methods methods_QDialogButtonBox_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDialogButtonBox::QDialogButtonBox(QWidget *parent)\nThis method creates an object of class QDialogButtonBox.", &_init_ctor_QDialogButtonBox_Adaptor_1315, &_call_ctor_QDialogButtonBox_Adaptor_1315);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDialogButtonBox::QDialogButtonBox(Qt::Orientation orientation, QWidget *parent)\nThis method creates an object of class QDialogButtonBox.", &_init_ctor_QDialogButtonBox_Adaptor_3120, &_call_ctor_QDialogButtonBox_Adaptor_3120);
  methods += new qt_gsi::GenericStaticMethod ("new_buttons", "@brief Constructor QDialogButtonBox::QDialogButtonBox(QFlags<QDialogButtonBox::StandardButton> buttons, Qt::Orientation orientation, QWidget *parent)\nThis method creates an object of class QDialogButtonBox.", &_init_ctor_QDialogButtonBox_Adaptor_7319, &_call_ctor_QDialogButtonBox_Adaptor_7319);
  methods += new qt_gsi::GenericMethod ("emit_accepted", "@brief Emitter for signal void QDialogButtonBox::accepted()\nCall this method to emit this signal.", false, &_init_emitter_accepted_0, &_call_emitter_accepted_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QDialogButtonBox::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QDialogButtonBox::changeEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QDialogButtonBox::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_clicked", "@brief Emitter for signal void QDialogButtonBox::clicked(QAbstractButton *button)\nCall this method to emit this signal.", false, &_init_emitter_clicked_2159, &_call_emitter_clicked_2159);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QDialogButtonBox::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QDialogButtonBox::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QDialogButtonBox::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QDialogButtonBox::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QDialogButtonBox::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QDialogButtonBox::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QDialogButtonBox::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QDialogButtonBox::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QDialogButtonBox::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QDialogButtonBox::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QDialogButtonBox::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QDialogButtonBox::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QDialogButtonBox::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QDialogButtonBox::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QDialogButtonBox::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QDialogButtonBox::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QDialogButtonBox::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QDialogButtonBox::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QDialogButtonBox::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QDialogButtonBox::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QDialogButtonBox::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QDialogButtonBox::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QDialogButtonBox::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("emit_helpRequested", "@brief Emitter for signal void QDialogButtonBox::helpRequested()\nCall this method to emit this signal.", false, &_init_emitter_helpRequested_0, &_call_emitter_helpRequested_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QDialogButtonBox::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QDialogButtonBox::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QDialogButtonBox::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QDialogButtonBox::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QDialogButtonBox::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QDialogButtonBox::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QDialogButtonBox::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QDialogButtonBox::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QDialogButtonBox::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QDialogButtonBox::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QDialogButtonBox::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QDialogButtonBox::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QDialogButtonBox::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QDialogButtonBox::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QDialogButtonBox::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QDialogButtonBox::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QDialogButtonBox::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QDialogButtonBox::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_rejected", "@brief Emitter for signal void QDialogButtonBox::rejected()\nCall this method to emit this signal.", false, &_init_emitter_rejected_0, &_call_emitter_rejected_0);
  methods += new qt_gsi::GenericMethod ("*resetInputContext", "@brief Method void QDialogButtonBox::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QDialogButtonBox::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QDialogButtonBox::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QDialogButtonBox::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QDialogButtonBox::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QDialogButtonBox::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QDialogButtonBox::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QDialogButtonBox::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QDialogButtonBox::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QDialogButtonBox::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QDialogButtonBox::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
  methods += new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QDialogButtonBox::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
  return methods;
}

gsi::Class<QDialogButtonBox_Adaptor> decl_QDialogButtonBox_Adaptor (qtdecl_QDialogButtonBox (), "QDialogButtonBox",
  methods_QDialogButtonBox_Adaptor (),
  "@qt\n@brief Binding of QDialogButtonBox");

}


//  Implementation of the enum wrapper class for QDialogButtonBox::ButtonRole
namespace qt_gsi
{

static gsi::Enum<QDialogButtonBox::ButtonRole> decl_QDialogButtonBox_ButtonRole_Enum ("QDialogButtonBox_ButtonRole",
    gsi::enum_const ("InvalidRole", QDialogButtonBox::InvalidRole, "@brief Enum constant QDialogButtonBox::InvalidRole") +
    gsi::enum_const ("AcceptRole", QDialogButtonBox::AcceptRole, "@brief Enum constant QDialogButtonBox::AcceptRole") +
    gsi::enum_const ("RejectRole", QDialogButtonBox::RejectRole, "@brief Enum constant QDialogButtonBox::RejectRole") +
    gsi::enum_const ("DestructiveRole", QDialogButtonBox::DestructiveRole, "@brief Enum constant QDialogButtonBox::DestructiveRole") +
    gsi::enum_const ("ActionRole", QDialogButtonBox::ActionRole, "@brief Enum constant QDialogButtonBox::ActionRole") +
    gsi::enum_const ("HelpRole", QDialogButtonBox::HelpRole, "@brief Enum constant QDialogButtonBox::HelpRole") +
    gsi::enum_const ("YesRole", QDialogButtonBox::YesRole, "@brief Enum constant QDialogButtonBox::YesRole") +
    gsi::enum_const ("NoRole", QDialogButtonBox::NoRole, "@brief Enum constant QDialogButtonBox::NoRole") +
    gsi::enum_const ("ResetRole", QDialogButtonBox::ResetRole, "@brief Enum constant QDialogButtonBox::ResetRole") +
    gsi::enum_const ("ApplyRole", QDialogButtonBox::ApplyRole, "@brief Enum constant QDialogButtonBox::ApplyRole") +
    gsi::enum_const ("NRoles", QDialogButtonBox::NRoles, "@brief Enum constant QDialogButtonBox::NRoles"),
  "@qt\n@brief This class represents the QDialogButtonBox::ButtonRole enum");

static gsi::QFlagsClass<QDialogButtonBox::ButtonRole > decl_QDialogButtonBox_ButtonRole_Enums ("QDialogButtonBox_QFlags_ButtonRole",
  "@qt\n@brief This class represents the QFlags<QDialogButtonBox::ButtonRole> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QDialogButtonBox> inject_QDialogButtonBox_ButtonRole_Enum_in_parent (decl_QDialogButtonBox_ButtonRole_Enum.defs ());
static gsi::ClassExt<QDialogButtonBox> decl_QDialogButtonBox_ButtonRole_Enum_as_child (decl_QDialogButtonBox_ButtonRole_Enum, "ButtonRole");
static gsi::ClassExt<QDialogButtonBox> decl_QDialogButtonBox_ButtonRole_Enums_as_child (decl_QDialogButtonBox_ButtonRole_Enums, "QFlags_ButtonRole");

}


//  Implementation of the enum wrapper class for QDialogButtonBox::StandardButton
namespace qt_gsi
{

static gsi::Enum<QDialogButtonBox::StandardButton> decl_QDialogButtonBox_StandardButton_Enum ("QDialogButtonBox_StandardButton",
    gsi::enum_const ("NoButton", QDialogButtonBox::NoButton, "@brief Enum constant QDialogButtonBox::NoButton") +
    gsi::enum_const ("Ok", QDialogButtonBox::Ok, "@brief Enum constant QDialogButtonBox::Ok") +
    gsi::enum_const ("Save", QDialogButtonBox::Save, "@brief Enum constant QDialogButtonBox::Save") +
    gsi::enum_const ("SaveAll", QDialogButtonBox::SaveAll, "@brief Enum constant QDialogButtonBox::SaveAll") +
    gsi::enum_const ("Open", QDialogButtonBox::Open, "@brief Enum constant QDialogButtonBox::Open") +
    gsi::enum_const ("Yes", QDialogButtonBox::Yes, "@brief Enum constant QDialogButtonBox::Yes") +
    gsi::enum_const ("YesToAll", QDialogButtonBox::YesToAll, "@brief Enum constant QDialogButtonBox::YesToAll") +
    gsi::enum_const ("No", QDialogButtonBox::No, "@brief Enum constant QDialogButtonBox::No") +
    gsi::enum_const ("NoToAll", QDialogButtonBox::NoToAll, "@brief Enum constant QDialogButtonBox::NoToAll") +
    gsi::enum_const ("Abort", QDialogButtonBox::Abort, "@brief Enum constant QDialogButtonBox::Abort") +
    gsi::enum_const ("Retry", QDialogButtonBox::Retry, "@brief Enum constant QDialogButtonBox::Retry") +
    gsi::enum_const ("Ignore", QDialogButtonBox::Ignore, "@brief Enum constant QDialogButtonBox::Ignore") +
    gsi::enum_const ("Close", QDialogButtonBox::Close, "@brief Enum constant QDialogButtonBox::Close") +
    gsi::enum_const ("Cancel", QDialogButtonBox::Cancel, "@brief Enum constant QDialogButtonBox::Cancel") +
    gsi::enum_const ("Discard", QDialogButtonBox::Discard, "@brief Enum constant QDialogButtonBox::Discard") +
    gsi::enum_const ("Help", QDialogButtonBox::Help, "@brief Enum constant QDialogButtonBox::Help") +
    gsi::enum_const ("Apply", QDialogButtonBox::Apply, "@brief Enum constant QDialogButtonBox::Apply") +
    gsi::enum_const ("Reset", QDialogButtonBox::Reset, "@brief Enum constant QDialogButtonBox::Reset") +
    gsi::enum_const ("RestoreDefaults", QDialogButtonBox::RestoreDefaults, "@brief Enum constant QDialogButtonBox::RestoreDefaults") +
    gsi::enum_const ("FirstButton", QDialogButtonBox::FirstButton, "@brief Enum constant QDialogButtonBox::FirstButton") +
    gsi::enum_const ("LastButton", QDialogButtonBox::LastButton, "@brief Enum constant QDialogButtonBox::LastButton"),
  "@qt\n@brief This class represents the QDialogButtonBox::StandardButton enum");

static gsi::QFlagsClass<QDialogButtonBox::StandardButton > decl_QDialogButtonBox_StandardButton_Enums ("QDialogButtonBox_QFlags_StandardButton",
  "@qt\n@brief This class represents the QFlags<QDialogButtonBox::StandardButton> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QDialogButtonBox> inject_QDialogButtonBox_StandardButton_Enum_in_parent (decl_QDialogButtonBox_StandardButton_Enum.defs ());
static gsi::ClassExt<QDialogButtonBox> decl_QDialogButtonBox_StandardButton_Enum_as_child (decl_QDialogButtonBox_StandardButton_Enum, "StandardButton");
static gsi::ClassExt<QDialogButtonBox> decl_QDialogButtonBox_StandardButton_Enums_as_child (decl_QDialogButtonBox_StandardButton_Enums, "QFlags_StandardButton");

}

