
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsProxyWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsProxyWidget>
#include <QAction>
#include <QChildEvent>
#include <QCloseEvent>
#include <QCursor>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QGraphicsEffect>
#include <QGraphicsItem>
#include <QGraphicsItemGroup>
#include <QGraphicsLayout>
#include <QGraphicsLayoutItem>
#include <QGraphicsObject>
#include <QGraphicsScene>
#include <QGraphicsSceneContextMenuEvent>
#include <QGraphicsSceneDragDropEvent>
#include <QGraphicsSceneHoverEvent>
#include <QGraphicsSceneMouseEvent>
#include <QGraphicsSceneMoveEvent>
#include <QGraphicsSceneResizeEvent>
#include <QGraphicsSceneWheelEvent>
#include <QGraphicsWidget>
#include <QHideEvent>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QMatrix>
#include <QObject>
#include <QPainter>
#include <QPainterPath>
#include <QPalette>
#include <QPointF>
#include <QPolygonF>
#include <QRectF>
#include <QRegion>
#include <QShowEvent>
#include <QSize>
#include <QSizeF>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOption>
#include <QStyleOptionGraphicsItem>
#include <QThread>
#include <QTimerEvent>
#include <QTransform>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsProxyWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsProxyWidget::staticMetaObject);
}


// QGraphicsProxyWidget *QGraphicsProxyWidget::createProxyForChildWidget(QWidget *child)


static void _init_f_createProxyForChildWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("child");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<QGraphicsProxyWidget * > ();
}

static void _call_f_createProxyForChildWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  ret.write<QGraphicsProxyWidget * > ((QGraphicsProxyWidget *)((QGraphicsProxyWidget *)cls)->createProxyForChildWidget (arg1));
}


// (QPainter *, const QStyleOptionGraphicsItem *, QWidget *)


static void _init_f_paint_6301 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paint_6301 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > (heap);
  QWidget *arg3 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget *)cls)->paint (arg1, arg2, arg3);
}


// (const QRectF &)


static void _init_f_setGeometry_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget *)cls)->setGeometry (arg1);
}


// void QGraphicsProxyWidget::setWidget(QWidget *widget)


static void _init_f_setWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget *)cls)->setWidget (arg1);
}


// QRectF QGraphicsProxyWidget::subWidgetRect(const QWidget *widget)


static void _init_f_subWidgetRect_c2010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_subWidgetRect_c2010 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = args.read<const QWidget * > (heap);
  ret.write<QRectF > ((QRectF)((QGraphicsProxyWidget *)cls)->subWidgetRect (arg1));
}


// () const


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsProxyWidget *)cls)->type ());
}


// QWidget *QGraphicsProxyWidget::widget()


static void _init_f_widget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_widget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QGraphicsProxyWidget *)cls)->widget ());
}


// static QString QGraphicsProxyWidget::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsProxyWidget::tr (arg1, arg2));
}


// static QString QGraphicsProxyWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args.read<const char * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QString > ((QString)QGraphicsProxyWidget::tr (arg1, arg2, arg3));
}


// static QString QGraphicsProxyWidget::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsProxyWidget::trUtf8 (arg1, arg2));
}


// static QString QGraphicsProxyWidget::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args.read<const char * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QString > ((QString)QGraphicsProxyWidget::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QGraphicsProxyWidget () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("createProxyForChildWidget", "@brief Method QGraphicsProxyWidget *QGraphicsProxyWidget::createProxyForChildWidget(QWidget *child)\n", false, &_init_f_createProxyForChildWidget_1315, &_call_f_createProxyForChildWidget_1315);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Method (QPainter *, const QStyleOptionGraphicsItem *, QWidget *)\nThis is a reimplementation of QGraphicsWidget::paint", false, &_init_f_paint_6301, &_call_f_paint_6301);
  methods += new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method (const QRectF &)\nThis is a reimplementation of QGraphicsWidget::setGeometry", false, &_init_f_setGeometry_1862, &_call_f_setGeometry_1862);
  methods += new qt_gsi::GenericMethod ("setWidget|widget=", "@brief Method void QGraphicsProxyWidget::setWidget(QWidget *widget)\n", false, &_init_f_setWidget_1315, &_call_f_setWidget_1315);
  methods += new qt_gsi::GenericMethod ("subWidgetRect", "@brief Method QRectF QGraphicsProxyWidget::subWidgetRect(const QWidget *widget)\n", true, &_init_f_subWidgetRect_c2010, &_call_f_subWidgetRect_c2010);
  methods += new qt_gsi::GenericMethod ("type", "@brief Method () const\nThis is a reimplementation of QGraphicsWidget::type", true, &_init_f_type_c0, &_call_f_type_c0);
  methods += new qt_gsi::GenericMethod (":widget", "@brief Method QWidget *QGraphicsProxyWidget::widget()\n", true, &_init_f_widget_c0, &_call_f_widget_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QGraphicsProxyWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("enabledChanged()", "enabledChanged", "@brief Signal declaration for QGraphicsProxyWidget::enabledChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("opacityChanged()", "opacityChanged", "@brief Signal declaration for QGraphicsProxyWidget::opacityChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("parentChanged()", "parentChanged", "@brief Signal declaration for QGraphicsProxyWidget::parentChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("rotationChanged()", "rotationChanged", "@brief Signal declaration for QGraphicsProxyWidget::rotationChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("scaleChanged()", "scaleChanged", "@brief Signal declaration for QGraphicsProxyWidget::scaleChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("visibleChanged()", "visibleChanged", "@brief Signal declaration for QGraphicsProxyWidget::visibleChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("xChanged()", "xChanged", "@brief Signal declaration for QGraphicsProxyWidget::xChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("yChanged()", "yChanged", "@brief Signal declaration for QGraphicsProxyWidget::yChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("zChanged()", "zChanged", "@brief Signal declaration for QGraphicsProxyWidget::zChanged()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsProxyWidget::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsProxyWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsProxyWidget::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsProxyWidget::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QGraphicsWidget> &qtdecl_QGraphicsWidget ();

qt_gsi::QtNativeClass<QGraphicsProxyWidget> decl_QGraphicsProxyWidget (qtdecl_QGraphicsWidget (), "QGraphicsProxyWidget_Native",
  methods_QGraphicsProxyWidget (),
  "@hide\n@alias QGraphicsProxyWidget");

GSIQT_PUBLIC gsi::Class<QGraphicsProxyWidget> &qtdecl_QGraphicsProxyWidget () { return decl_QGraphicsProxyWidget; }

}


class QGraphicsProxyWidget_Adaptor : public QGraphicsProxyWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsProxyWidget_Adaptor();

  //  [adaptor ctor] QGraphicsProxyWidget::QGraphicsProxyWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags)
  QGraphicsProxyWidget_Adaptor() : QGraphicsProxyWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsProxyWidget::QGraphicsProxyWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags)
  QGraphicsProxyWidget_Adaptor(QGraphicsItem *parent) : QGraphicsProxyWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsProxyWidget::QGraphicsProxyWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags)
  QGraphicsProxyWidget_Adaptor(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags) : QGraphicsProxyWidget(parent, wFlags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGraphicsProxyWidget::addToIndex()
  void fp_QGraphicsProxyWidget_addToIndex_0 () {
    QGraphicsProxyWidget::addToIndex();
  }

  //  [expose] QGraphicsProxyWidget *QGraphicsProxyWidget::newProxyWidget(const QWidget *)
  QGraphicsProxyWidget * fp_QGraphicsProxyWidget_newProxyWidget_2010 (const QWidget *arg1) {
    return QGraphicsProxyWidget::newProxyWidget(arg1);
  }

  //  [expose] void QGraphicsProxyWidget::prepareGeometryChange()
  void fp_QGraphicsProxyWidget_prepareGeometryChange_0 () {
    QGraphicsProxyWidget::prepareGeometryChange();
  }

  //  [expose] int QGraphicsProxyWidget::receivers(const char *signal)
  int fp_QGraphicsProxyWidget_receivers_c1731 (const char *signal) const {
    return QGraphicsProxyWidget::receivers(signal);
  }

  //  [expose] void QGraphicsProxyWidget::removeFromIndex()
  void fp_QGraphicsProxyWidget_removeFromIndex_0 () {
    QGraphicsProxyWidget::removeFromIndex();
  }

  //  [expose] QObject *QGraphicsProxyWidget::sender()
  QObject * fp_QGraphicsProxyWidget_sender_c0 () const {
    return QGraphicsProxyWidget::sender();
  }

  //  [expose] void QGraphicsProxyWidget::setGraphicsItem(QGraphicsItem *item)
  void fp_QGraphicsProxyWidget_setGraphicsItem_1919 (QGraphicsItem *item) {
    QGraphicsProxyWidget::setGraphicsItem(item);
  }

  //  [expose] void QGraphicsProxyWidget::setOwnedByLayout(bool ownedByLayout)
  void fp_QGraphicsProxyWidget_setOwnedByLayout_864 (bool ownedByLayout) {
    QGraphicsProxyWidget::setOwnedByLayout(ownedByLayout);
  }

  //  [adaptor impl] void QGraphicsProxyWidget::advance(int phase)
  void cbs_advance_767_0(int phase)
  {
    QGraphicsProxyWidget::advance(phase);
  }

  virtual void advance(int phase)
  {
    if (cb_advance_767_0.can_issue()) {
      cb_advance_767_0.issue<QGraphicsProxyWidget_Adaptor, int>(&QGraphicsProxyWidget_Adaptor::cbs_advance_767_0, phase);
    } else {
      QGraphicsProxyWidget::advance(phase);
    }
  }

  //  [adaptor impl] QRectF QGraphicsProxyWidget::boundingRect()
  QRectF cbs_boundingRect_c0_0() const
  {
    return QGraphicsProxyWidget::boundingRect();
  }

  virtual QRectF boundingRect() const
  {
    if (cb_boundingRect_c0_0.can_issue()) {
      return cb_boundingRect_c0_0.issue<QGraphicsProxyWidget_Adaptor, QRectF>(&QGraphicsProxyWidget_Adaptor::cbs_boundingRect_c0_0);
    } else {
      return QGraphicsProxyWidget::boundingRect();
    }
  }

  //  [adaptor impl] bool QGraphicsProxyWidget::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithItem_c4977_1(const QGraphicsItem *other, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsProxyWidget::collidesWithItem(other, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithItem_c4977_1.can_issue()) {
      return cb_collidesWithItem_c4977_1.issue<QGraphicsProxyWidget_Adaptor, bool, const QGraphicsItem *, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsProxyWidget_Adaptor::cbs_collidesWithItem_c4977_1, other, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsProxyWidget::collidesWithItem(other, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsProxyWidget::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithPath_c4877_1(const QPainterPath &path, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsProxyWidget::collidesWithPath(path, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithPath_c4877_1.can_issue()) {
      return cb_collidesWithPath_c4877_1.issue<QGraphicsProxyWidget_Adaptor, bool, const QPainterPath &, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsProxyWidget_Adaptor::cbs_collidesWithPath_c4877_1, path, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsProxyWidget::collidesWithPath(path, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsProxyWidget::contains(const QPointF &point)
  bool cbs_contains_c1986_0(const QPointF &point) const
  {
    return QGraphicsProxyWidget::contains(point);
  }

  virtual bool contains(const QPointF &point) const
  {
    if (cb_contains_c1986_0.can_issue()) {
      return cb_contains_c1986_0.issue<QGraphicsProxyWidget_Adaptor, bool, const QPointF &>(&QGraphicsProxyWidget_Adaptor::cbs_contains_c1986_0, point);
    } else {
      return QGraphicsProxyWidget::contains(point);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)
  void cbs_getContentsMargins_c4704_0(double *left, double *top, double *right, double *bottom) const
  {
    QGraphicsProxyWidget::getContentsMargins(left, top, right, bottom);
  }

  virtual void getContentsMargins(double *left, double *top, double *right, double *bottom) const
  {
    if (cb_getContentsMargins_c4704_0.can_issue()) {
      cb_getContentsMargins_c4704_0.issue<QGraphicsProxyWidget_Adaptor, double *, double *, double *, double *>(&QGraphicsProxyWidget_Adaptor::cbs_getContentsMargins_c4704_0, left, top, right, bottom);
    } else {
      QGraphicsProxyWidget::getContentsMargins(left, top, right, bottom);
    }
  }

  //  [adaptor impl] bool QGraphicsProxyWidget::isObscuredBy(const QGraphicsItem *item)
  bool cbs_isObscuredBy_c2614_0(const QGraphicsItem *item) const
  {
    return QGraphicsProxyWidget::isObscuredBy(item);
  }

  virtual bool isObscuredBy(const QGraphicsItem *item) const
  {
    if (cb_isObscuredBy_c2614_0.can_issue()) {
      return cb_isObscuredBy_c2614_0.issue<QGraphicsProxyWidget_Adaptor, bool, const QGraphicsItem *>(&QGraphicsProxyWidget_Adaptor::cbs_isObscuredBy_c2614_0, item);
    } else {
      return QGraphicsProxyWidget::isObscuredBy(item);
    }
  }

  //  [adaptor impl] QPainterPath QGraphicsProxyWidget::opaqueArea()
  QPainterPath cbs_opaqueArea_c0_0() const
  {
    return QGraphicsProxyWidget::opaqueArea();
  }

  virtual QPainterPath opaqueArea() const
  {
    if (cb_opaqueArea_c0_0.can_issue()) {
      return cb_opaqueArea_c0_0.issue<QGraphicsProxyWidget_Adaptor, QPainterPath>(&QGraphicsProxyWidget_Adaptor::cbs_opaqueArea_c0_0);
    } else {
      return QGraphicsProxyWidget::opaqueArea();
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  void cbs_paint_6301_0(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    QGraphicsProxyWidget::paint(painter, option, widget);
  }

  virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    if (cb_paint_6301_0.can_issue()) {
      cb_paint_6301_0.issue<QGraphicsProxyWidget_Adaptor, QPainter *, const QStyleOptionGraphicsItem *, QWidget *>(&QGraphicsProxyWidget_Adaptor::cbs_paint_6301_0, painter, option, widget);
    } else {
      QGraphicsProxyWidget::paint(painter, option, widget);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  void cbs_paintWindowFrame_6301_1(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    QGraphicsProxyWidget::paintWindowFrame(painter, option, widget);
  }

  virtual void paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    if (cb_paintWindowFrame_6301_1.can_issue()) {
      cb_paintWindowFrame_6301_1.issue<QGraphicsProxyWidget_Adaptor, QPainter *, const QStyleOptionGraphicsItem *, QWidget *>(&QGraphicsProxyWidget_Adaptor::cbs_paintWindowFrame_6301_1, painter, option, widget);
    } else {
      QGraphicsProxyWidget::paintWindowFrame(painter, option, widget);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::setGeometry(const QRectF &rect)
  void cbs_setGeometry_1862_0(const QRectF &rect)
  {
    QGraphicsProxyWidget::setGeometry(rect);
  }

  virtual void setGeometry(const QRectF &rect)
  {
    if (cb_setGeometry_1862_0.can_issue()) {
      cb_setGeometry_1862_0.issue<QGraphicsProxyWidget_Adaptor, const QRectF &>(&QGraphicsProxyWidget_Adaptor::cbs_setGeometry_1862_0, rect);
    } else {
      QGraphicsProxyWidget::setGeometry(rect);
    }
  }

  //  [adaptor impl] QPainterPath QGraphicsProxyWidget::shape()
  QPainterPath cbs_shape_c0_0() const
  {
    return QGraphicsProxyWidget::shape();
  }

  virtual QPainterPath shape() const
  {
    if (cb_shape_c0_0.can_issue()) {
      return cb_shape_c0_0.issue<QGraphicsProxyWidget_Adaptor, QPainterPath>(&QGraphicsProxyWidget_Adaptor::cbs_shape_c0_0);
    } else {
      return QGraphicsProxyWidget::shape();
    }
  }

  //  [adaptor impl] int QGraphicsProxyWidget::type()
  int cbs_type_c0_0() const
  {
    return QGraphicsProxyWidget::type();
  }

  virtual int type() const
  {
    if (cb_type_c0_0.can_issue()) {
      return cb_type_c0_0.issue<QGraphicsProxyWidget_Adaptor, int>(&QGraphicsProxyWidget_Adaptor::cbs_type_c0_0);
    } else {
      return QGraphicsProxyWidget::type();
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::changeEvent(QEvent *event)
  void cbs_changeEvent_1217_0(QEvent *event)
  {
    QGraphicsProxyWidget::changeEvent(event);
  }

  virtual void changeEvent(QEvent *event)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QGraphicsProxyWidget_Adaptor, QEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_changeEvent_1217_0, event);
    } else {
      QGraphicsProxyWidget::changeEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QGraphicsProxyWidget::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsProxyWidget_Adaptor, QChildEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QGraphicsProxyWidget::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QGraphicsProxyWidget::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QGraphicsProxyWidget_Adaptor, QCloseEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QGraphicsProxyWidget::closeEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  void cbs_contextMenuEvent_3674_0(QGraphicsSceneContextMenuEvent *event)
  {
    QGraphicsProxyWidget::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_3674_0.can_issue()) {
      cb_contextMenuEvent_3674_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneContextMenuEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_contextMenuEvent_3674_0, event);
    } else {
      QGraphicsProxyWidget::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QGraphicsProxyWidget::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsProxyWidget_Adaptor, QEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QGraphicsProxyWidget::customEvent(arg1);
    }
  }

  //  [emitter impl] void QGraphicsProxyWidget::destroyed(QObject *)
  void emitter_QGraphicsProxyWidget_destroyed_1302(QObject *arg1)
  {
    emit QGraphicsProxyWidget::destroyed(arg1);
  }

  //  [adaptor impl] void QGraphicsProxyWidget::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QGraphicsProxyWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QGraphicsProxyWidget_Adaptor, const char *>(&QGraphicsProxyWidget_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QGraphicsProxyWidget::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragEnterEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsProxyWidget::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragEnterEvent_3315_0.can_issue()) {
      cb_dragEnterEvent_3315_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_dragEnterEvent_3315_0, event);
    } else {
      QGraphicsProxyWidget::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragLeaveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsProxyWidget::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragLeaveEvent_3315_0.can_issue()) {
      cb_dragLeaveEvent_3315_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_dragLeaveEvent_3315_0, event);
    } else {
      QGraphicsProxyWidget::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragMoveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsProxyWidget::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragMoveEvent_3315_0.can_issue()) {
      cb_dragMoveEvent_3315_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_dragMoveEvent_3315_0, event);
    } else {
      QGraphicsProxyWidget::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::dropEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dropEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsProxyWidget::dropEvent(event);
  }

  virtual void dropEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dropEvent_3315_0.can_issue()) {
      cb_dropEvent_3315_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_dropEvent_3315_0, event);
    } else {
      QGraphicsProxyWidget::dropEvent(event);
    }
  }

  //  [emitter impl] void QGraphicsProxyWidget::enabledChanged()
  void emitter_QGraphicsProxyWidget_enabledChanged_0()
  {
    emit QGraphicsProxyWidget::enabledChanged();
  }

  //  [adaptor impl] bool QGraphicsProxyWidget::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGraphicsProxyWidget::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsProxyWidget_Adaptor, bool, QEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGraphicsProxyWidget::event(_event);
    }
  }

  //  [adaptor impl] bool QGraphicsProxyWidget::eventFilter(QObject *object, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *object, QEvent *event)
  {
    return QGraphicsProxyWidget::eventFilter(object, event);
  }

  virtual bool eventFilter(QObject *object, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsProxyWidget_Adaptor, bool, QObject *, QEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_eventFilter_2411_0, object, event);
    } else {
      return QGraphicsProxyWidget::eventFilter(object, event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsProxyWidget::extension(const QVariant &variant)
  QVariant cbs_extension_c2119_0(const QVariant &variant) const
  {
    return QGraphicsProxyWidget::extension(variant);
  }

  virtual QVariant extension(const QVariant &variant) const
  {
    if (cb_extension_c2119_0.can_issue()) {
      return cb_extension_c2119_0.issue<QGraphicsProxyWidget_Adaptor, QVariant, const QVariant &>(&QGraphicsProxyWidget_Adaptor::cbs_extension_c2119_0, variant);
    } else {
      return QGraphicsProxyWidget::extension(variant);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsProxyWidget::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QGraphicsProxyWidget_Adaptor, QFocusEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QGraphicsProxyWidget::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsProxyWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QGraphicsProxyWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QGraphicsProxyWidget_Adaptor, bool, bool>(&QGraphicsProxyWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QGraphicsProxyWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsProxyWidget::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QGraphicsProxyWidget_Adaptor, QFocusEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QGraphicsProxyWidget::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::grabKeyboardEvent(QEvent *event)
  void cbs_grabKeyboardEvent_1217_0(QEvent *event)
  {
    QGraphicsProxyWidget::grabKeyboardEvent(event);
  }

  virtual void grabKeyboardEvent(QEvent *event)
  {
    if (cb_grabKeyboardEvent_1217_0.can_issue()) {
      cb_grabKeyboardEvent_1217_0.issue<QGraphicsProxyWidget_Adaptor, QEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_grabKeyboardEvent_1217_0, event);
    } else {
      QGraphicsProxyWidget::grabKeyboardEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::grabMouseEvent(QEvent *event)
  void cbs_grabMouseEvent_1217_0(QEvent *event)
  {
    QGraphicsProxyWidget::grabMouseEvent(event);
  }

  virtual void grabMouseEvent(QEvent *event)
  {
    if (cb_grabMouseEvent_1217_0.can_issue()) {
      cb_grabMouseEvent_1217_0.issue<QGraphicsProxyWidget_Adaptor, QEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_grabMouseEvent_1217_0, event);
    } else {
      QGraphicsProxyWidget::grabMouseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QGraphicsProxyWidget::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QGraphicsProxyWidget_Adaptor, QHideEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QGraphicsProxyWidget::hideEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverEnterEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsProxyWidget::hoverEnterEvent(event);
  }

  virtual void hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverEnterEvent_3044_0.can_issue()) {
      cb_hoverEnterEvent_3044_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_hoverEnterEvent_3044_0, event);
    } else {
      QGraphicsProxyWidget::hoverEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverLeaveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsProxyWidget::hoverLeaveEvent(event);
  }

  virtual void hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverLeaveEvent_3044_0.can_issue()) {
      cb_hoverLeaveEvent_3044_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_hoverLeaveEvent_3044_0, event);
    } else {
      QGraphicsProxyWidget::hoverLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverMoveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsProxyWidget::hoverMoveEvent(event);
  }

  virtual void hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverMoveEvent_3044_0.can_issue()) {
      cb_hoverMoveEvent_3044_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_hoverMoveEvent_3044_0, event);
    } else {
      QGraphicsProxyWidget::hoverMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::initStyleOption(QStyleOption *option)
  void cbs_initStyleOption_c1865_0(QStyleOption *option) const
  {
    QGraphicsProxyWidget::initStyleOption(option);
  }

  virtual void initStyleOption(QStyleOption *option) const
  {
    if (cb_initStyleOption_c1865_0.can_issue()) {
      cb_initStyleOption_c1865_0.issue<QGraphicsProxyWidget_Adaptor, QStyleOption *>(&QGraphicsProxyWidget_Adaptor::cbs_initStyleOption_c1865_0, option);
    } else {
      QGraphicsProxyWidget::initStyleOption(option);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QGraphicsProxyWidget::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QGraphicsProxyWidget_Adaptor, QInputMethodEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QGraphicsProxyWidget::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsProxyWidget::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QGraphicsProxyWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QGraphicsProxyWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QGraphicsProxyWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QGraphicsProxyWidget::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] QVariant QGraphicsProxyWidget::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  QVariant cbs_itemChange_5658_0(const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & change, const QVariant &value)
  {
    return QGraphicsProxyWidget::itemChange(qt_gsi::QtToCppAdaptor<QGraphicsItem::GraphicsItemChange>(change).cref(), value);
  }

  virtual QVariant itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  {
    if (cb_itemChange_5658_0.can_issue()) {
      return cb_itemChange_5658_0.issue<QGraphicsProxyWidget_Adaptor, QVariant, const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type &, const QVariant &>(&QGraphicsProxyWidget_Adaptor::cbs_itemChange_5658_0, qt_gsi::CppToQtAdaptor<QGraphicsItem::GraphicsItemChange>(change), value);
    } else {
      return QGraphicsProxyWidget::itemChange(change, value);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsProxyWidget::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QGraphicsProxyWidget_Adaptor, QKeyEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QGraphicsProxyWidget::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsProxyWidget::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QGraphicsProxyWidget_Adaptor, QKeyEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QGraphicsProxyWidget::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseDoubleClickEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsProxyWidget::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_3049_0.can_issue()) {
      cb_mouseDoubleClickEvent_3049_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_mouseDoubleClickEvent_3049_0, event);
    } else {
      QGraphicsProxyWidget::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseMoveEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsProxyWidget::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseMoveEvent_3049_0.can_issue()) {
      cb_mouseMoveEvent_3049_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_mouseMoveEvent_3049_0, event);
    } else {
      QGraphicsProxyWidget::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::mousePressEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mousePressEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsProxyWidget::mousePressEvent(event);
  }

  virtual void mousePressEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mousePressEvent_3049_0.can_issue()) {
      cb_mousePressEvent_3049_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_mousePressEvent_3049_0, event);
    } else {
      QGraphicsProxyWidget::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseReleaseEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsProxyWidget::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_3049_0.can_issue()) {
      cb_mouseReleaseEvent_3049_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_mouseReleaseEvent_3049_0, event);
    } else {
      QGraphicsProxyWidget::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::moveEvent(QGraphicsSceneMoveEvent *event)
  void cbs_moveEvent_2935_0(QGraphicsSceneMoveEvent *event)
  {
    QGraphicsProxyWidget::moveEvent(event);
  }

  virtual void moveEvent(QGraphicsSceneMoveEvent *event)
  {
    if (cb_moveEvent_2935_0.can_issue()) {
      cb_moveEvent_2935_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneMoveEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_moveEvent_2935_0, event);
    } else {
      QGraphicsProxyWidget::moveEvent(event);
    }
  }

  //  [emitter impl] void QGraphicsProxyWidget::opacityChanged()
  void emitter_QGraphicsProxyWidget_opacityChanged_0()
  {
    emit QGraphicsProxyWidget::opacityChanged();
  }

  //  [emitter impl] void QGraphicsProxyWidget::parentChanged()
  void emitter_QGraphicsProxyWidget_parentChanged_0()
  {
    emit QGraphicsProxyWidget::parentChanged();
  }

  //  [adaptor impl] void QGraphicsProxyWidget::polishEvent()
  void cbs_polishEvent_0_0()
  {
    QGraphicsProxyWidget::polishEvent();
  }

  virtual void polishEvent()
  {
    if (cb_polishEvent_0_0.can_issue()) {
      cb_polishEvent_0_0.issue<QGraphicsProxyWidget_Adaptor>(&QGraphicsProxyWidget_Adaptor::cbs_polishEvent_0_0);
    } else {
      QGraphicsProxyWidget::polishEvent();
    }
  }

  //  [adaptor impl] QVariant QGraphicsProxyWidget::propertyChange(const QString &propertyName, const QVariant &value)
  QVariant cbs_propertyChange_4036_0(const QString &propertyName, const QVariant &value)
  {
    return QGraphicsProxyWidget::propertyChange(propertyName, value);
  }

  virtual QVariant propertyChange(const QString &propertyName, const QVariant &value)
  {
    if (cb_propertyChange_4036_0.can_issue()) {
      return cb_propertyChange_4036_0.issue<QGraphicsProxyWidget_Adaptor, QVariant, const QString &, const QVariant &>(&QGraphicsProxyWidget_Adaptor::cbs_propertyChange_4036_0, propertyName, value);
    } else {
      return QGraphicsProxyWidget::propertyChange(propertyName, value);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::resizeEvent(QGraphicsSceneResizeEvent *event)
  void cbs_resizeEvent_3154_0(QGraphicsSceneResizeEvent *event)
  {
    QGraphicsProxyWidget::resizeEvent(event);
  }

  virtual void resizeEvent(QGraphicsSceneResizeEvent *event)
  {
    if (cb_resizeEvent_3154_0.can_issue()) {
      cb_resizeEvent_3154_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneResizeEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_resizeEvent_3154_0, event);
    } else {
      QGraphicsProxyWidget::resizeEvent(event);
    }
  }

  //  [emitter impl] void QGraphicsProxyWidget::rotationChanged()
  void emitter_QGraphicsProxyWidget_rotationChanged_0()
  {
    emit QGraphicsProxyWidget::rotationChanged();
  }

  //  [emitter impl] void QGraphicsProxyWidget::scaleChanged()
  void emitter_QGraphicsProxyWidget_scaleChanged_0()
  {
    emit QGraphicsProxyWidget::scaleChanged();
  }

  //  [adaptor impl] bool QGraphicsProxyWidget::sceneEvent(QEvent *event)
  bool cbs_sceneEvent_1217_0(QEvent *event)
  {
    return QGraphicsProxyWidget::sceneEvent(event);
  }

  virtual bool sceneEvent(QEvent *event)
  {
    if (cb_sceneEvent_1217_0.can_issue()) {
      return cb_sceneEvent_1217_0.issue<QGraphicsProxyWidget_Adaptor, bool, QEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_sceneEvent_1217_0, event);
    } else {
      return QGraphicsProxyWidget::sceneEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsProxyWidget::sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  bool cbs_sceneEventFilter_3028_0(QGraphicsItem *watched, QEvent *event)
  {
    return QGraphicsProxyWidget::sceneEventFilter(watched, event);
  }

  virtual bool sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  {
    if (cb_sceneEventFilter_3028_0.can_issue()) {
      return cb_sceneEventFilter_3028_0.issue<QGraphicsProxyWidget_Adaptor, bool, QGraphicsItem *, QEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_sceneEventFilter_3028_0, watched, event);
    } else {
      return QGraphicsProxyWidget::sceneEventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  void cbs_setExtension_4817_0(unsigned int extension, const QVariant &variant)
  {
    QGraphicsProxyWidget::setExtension(QGraphicsItem::Extension(extension), variant);
  }

  virtual void setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  {
    if (cb_setExtension_4817_0.can_issue()) {
      cb_setExtension_4817_0.issue<QGraphicsProxyWidget_Adaptor, unsigned int, const QVariant &>(&QGraphicsProxyWidget_Adaptor::cbs_setExtension_4817_0, (unsigned int)(extension), variant);
    } else {
      QGraphicsProxyWidget::setExtension(extension, variant);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QGraphicsProxyWidget::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QGraphicsProxyWidget_Adaptor, QShowEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QGraphicsProxyWidget::showEvent(event);
    }
  }

  //  [adaptor impl] QSizeF QGraphicsProxyWidget::sizeHint(Qt::SizeHint which, const QSizeF &constraint)
  QSizeF cbs_sizeHint_c3330_1(const qt_gsi::Converter<Qt::SizeHint>::target_type & which, const QSizeF &constraint) const
  {
    return QGraphicsProxyWidget::sizeHint(qt_gsi::QtToCppAdaptor<Qt::SizeHint>(which).cref(), constraint);
  }

  virtual QSizeF sizeHint(Qt::SizeHint which, const QSizeF &constraint) const
  {
    if (cb_sizeHint_c3330_1.can_issue()) {
      return cb_sizeHint_c3330_1.issue<QGraphicsProxyWidget_Adaptor, QSizeF, const qt_gsi::Converter<Qt::SizeHint>::target_type &, const QSizeF &>(&QGraphicsProxyWidget_Adaptor::cbs_sizeHint_c3330_1, qt_gsi::CppToQtAdaptor<Qt::SizeHint>(which), constraint);
    } else {
      return QGraphicsProxyWidget::sizeHint(which, constraint);
    }
  }

  //  [adaptor impl] bool QGraphicsProxyWidget::supportsExtension(QGraphicsItem::Extension extension)
  bool cbs_supportsExtension_c2806_0(unsigned int extension) const
  {
    return QGraphicsProxyWidget::supportsExtension(QGraphicsItem::Extension(extension));
  }

  virtual bool supportsExtension(QGraphicsItem::Extension extension) const
  {
    if (cb_supportsExtension_c2806_0.can_issue()) {
      return cb_supportsExtension_c2806_0.issue<QGraphicsProxyWidget_Adaptor, bool, unsigned int>(&QGraphicsProxyWidget_Adaptor::cbs_supportsExtension_c2806_0, (unsigned int)(extension));
    } else {
      return QGraphicsProxyWidget::supportsExtension(extension);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QGraphicsProxyWidget::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsProxyWidget_Adaptor, QTimerEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QGraphicsProxyWidget::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::ungrabKeyboardEvent(QEvent *event)
  void cbs_ungrabKeyboardEvent_1217_0(QEvent *event)
  {
    QGraphicsProxyWidget::ungrabKeyboardEvent(event);
  }

  virtual void ungrabKeyboardEvent(QEvent *event)
  {
    if (cb_ungrabKeyboardEvent_1217_0.can_issue()) {
      cb_ungrabKeyboardEvent_1217_0.issue<QGraphicsProxyWidget_Adaptor, QEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_ungrabKeyboardEvent_1217_0, event);
    } else {
      QGraphicsProxyWidget::ungrabKeyboardEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::ungrabMouseEvent(QEvent *event)
  void cbs_ungrabMouseEvent_1217_0(QEvent *event)
  {
    QGraphicsProxyWidget::ungrabMouseEvent(event);
  }

  virtual void ungrabMouseEvent(QEvent *event)
  {
    if (cb_ungrabMouseEvent_1217_0.can_issue()) {
      cb_ungrabMouseEvent_1217_0.issue<QGraphicsProxyWidget_Adaptor, QEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_ungrabMouseEvent_1217_0, event);
    } else {
      QGraphicsProxyWidget::ungrabMouseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsProxyWidget::updateGeometry()
  void cbs_updateGeometry_0_0()
  {
    QGraphicsProxyWidget::updateGeometry();
  }

  virtual void updateGeometry()
  {
    if (cb_updateGeometry_0_0.can_issue()) {
      cb_updateGeometry_0_0.issue<QGraphicsProxyWidget_Adaptor>(&QGraphicsProxyWidget_Adaptor::cbs_updateGeometry_0_0);
    } else {
      QGraphicsProxyWidget::updateGeometry();
    }
  }

  //  [emitter impl] void QGraphicsProxyWidget::visibleChanged()
  void emitter_QGraphicsProxyWidget_visibleChanged_0()
  {
    emit QGraphicsProxyWidget::visibleChanged();
  }

  //  [adaptor impl] void QGraphicsProxyWidget::wheelEvent(QGraphicsSceneWheelEvent *event)
  void cbs_wheelEvent_3029_0(QGraphicsSceneWheelEvent *event)
  {
    QGraphicsProxyWidget::wheelEvent(event);
  }

  virtual void wheelEvent(QGraphicsSceneWheelEvent *event)
  {
    if (cb_wheelEvent_3029_0.can_issue()) {
      cb_wheelEvent_3029_0.issue<QGraphicsProxyWidget_Adaptor, QGraphicsSceneWheelEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_wheelEvent_3029_0, event);
    } else {
      QGraphicsProxyWidget::wheelEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsProxyWidget::windowFrameEvent(QEvent *e)
  bool cbs_windowFrameEvent_1217_0(QEvent *e)
  {
    return QGraphicsProxyWidget::windowFrameEvent(e);
  }

  virtual bool windowFrameEvent(QEvent *e)
  {
    if (cb_windowFrameEvent_1217_0.can_issue()) {
      return cb_windowFrameEvent_1217_0.issue<QGraphicsProxyWidget_Adaptor, bool, QEvent *>(&QGraphicsProxyWidget_Adaptor::cbs_windowFrameEvent_1217_0, e);
    } else {
      return QGraphicsProxyWidget::windowFrameEvent(e);
    }
  }

  //  [adaptor impl] Qt::WindowFrameSection QGraphicsProxyWidget::windowFrameSectionAt(const QPointF &pos)
  qt_gsi::Converter<Qt::WindowFrameSection>::target_type cbs_windowFrameSectionAt_c1986_0(const QPointF &pos) const
  {
    return qt_gsi::CppToQtAdaptor<Qt::WindowFrameSection>(QGraphicsProxyWidget::windowFrameSectionAt(pos));
  }

  virtual Qt::WindowFrameSection windowFrameSectionAt(const QPointF &pos) const
  {
    if (cb_windowFrameSectionAt_c1986_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<Qt::WindowFrameSection>(cb_windowFrameSectionAt_c1986_0.issue<QGraphicsProxyWidget_Adaptor, qt_gsi::Converter<Qt::WindowFrameSection>::target_type, const QPointF &>(&QGraphicsProxyWidget_Adaptor::cbs_windowFrameSectionAt_c1986_0, pos)).cref();
    } else {
      return QGraphicsProxyWidget::windowFrameSectionAt(pos);
    }
  }

  //  [emitter impl] void QGraphicsProxyWidget::xChanged()
  void emitter_QGraphicsProxyWidget_xChanged_0()
  {
    emit QGraphicsProxyWidget::xChanged();
  }

  //  [emitter impl] void QGraphicsProxyWidget::yChanged()
  void emitter_QGraphicsProxyWidget_yChanged_0()
  {
    emit QGraphicsProxyWidget::yChanged();
  }

  //  [emitter impl] void QGraphicsProxyWidget::zChanged()
  void emitter_QGraphicsProxyWidget_zChanged_0()
  {
    emit QGraphicsProxyWidget::zChanged();
  }

  gsi::Callback cb_advance_767_0;
  gsi::Callback cb_boundingRect_c0_0;
  gsi::Callback cb_collidesWithItem_c4977_1;
  gsi::Callback cb_collidesWithPath_c4877_1;
  gsi::Callback cb_contains_c1986_0;
  gsi::Callback cb_getContentsMargins_c4704_0;
  gsi::Callback cb_isObscuredBy_c2614_0;
  gsi::Callback cb_opaqueArea_c0_0;
  gsi::Callback cb_paint_6301_0;
  gsi::Callback cb_paintWindowFrame_6301_1;
  gsi::Callback cb_setGeometry_1862_0;
  gsi::Callback cb_shape_c0_0;
  gsi::Callback cb_type_c0_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_3674_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_3315_0;
  gsi::Callback cb_dragLeaveEvent_3315_0;
  gsi::Callback cb_dragMoveEvent_3315_0;
  gsi::Callback cb_dropEvent_3315_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_extension_c2119_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_grabKeyboardEvent_1217_0;
  gsi::Callback cb_grabMouseEvent_1217_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_hoverEnterEvent_3044_0;
  gsi::Callback cb_hoverLeaveEvent_3044_0;
  gsi::Callback cb_hoverMoveEvent_3044_0;
  gsi::Callback cb_initStyleOption_c1865_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_itemChange_5658_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_mouseDoubleClickEvent_3049_0;
  gsi::Callback cb_mouseMoveEvent_3049_0;
  gsi::Callback cb_mousePressEvent_3049_0;
  gsi::Callback cb_mouseReleaseEvent_3049_0;
  gsi::Callback cb_moveEvent_2935_0;
  gsi::Callback cb_polishEvent_0_0;
  gsi::Callback cb_propertyChange_4036_0;
  gsi::Callback cb_resizeEvent_3154_0;
  gsi::Callback cb_sceneEvent_1217_0;
  gsi::Callback cb_sceneEventFilter_3028_0;
  gsi::Callback cb_setExtension_4817_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_sizeHint_c3330_1;
  gsi::Callback cb_supportsExtension_c2806_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_ungrabKeyboardEvent_1217_0;
  gsi::Callback cb_ungrabMouseEvent_1217_0;
  gsi::Callback cb_updateGeometry_0_0;
  gsi::Callback cb_wheelEvent_3029_0;
  gsi::Callback cb_windowFrameEvent_1217_0;
  gsi::Callback cb_windowFrameSectionAt_c1986_0;
};

QGraphicsProxyWidget_Adaptor::~QGraphicsProxyWidget_Adaptor() { }

//  Constructor QGraphicsProxyWidget::QGraphicsProxyWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags) (adaptor class)

static void _init_ctor_QGraphicsProxyWidget_Adaptor_4306 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("wFlags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return_new<QGraphicsProxyWidget_Adaptor> ();
}

static void _call_ctor_QGraphicsProxyWidget_Adaptor_4306 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = args ? args.read<QGraphicsItem * > (heap) : (QGraphicsItem *)(0);
  QFlags<Qt::WindowType> arg2 = args ? args.read<QFlags<Qt::WindowType> > (heap) : (QFlags<Qt::WindowType>)(0);
  ret.write<QGraphicsProxyWidget_Adaptor *> (new QGraphicsProxyWidget_Adaptor (arg1, arg2));
}


// exposed void QGraphicsProxyWidget::addToIndex()

static void _init_fp_addToIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_addToIndex_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->fp_QGraphicsProxyWidget_addToIndex_0 ();
}


// void QGraphicsProxyWidget::advance(int phase)

static void _init_cbs_advance_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("phase");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_advance_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_advance_767_0 (arg1);
}

static void _set_callback_cbs_advance_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_advance_767_0 = cb;
}


// QRectF QGraphicsProxyWidget::boundingRect()

static void _init_cbs_boundingRect_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRect_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_boundingRect_c0_0 ());
}

static void _set_callback_cbs_boundingRect_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_boundingRect_c0_0 = cb;
}


// void QGraphicsProxyWidget::changeEvent(QEvent *event)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QGraphicsProxyWidget::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QGraphicsProxyWidget::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// bool QGraphicsProxyWidget::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithItem_c4977_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithItem_c4977_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > (heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (heap);
  ret.write<bool > ((bool)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_collidesWithItem_c4977_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithItem_c4977_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_collidesWithItem_c4977_1 = cb;
}


// bool QGraphicsProxyWidget::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithPath_c4877_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithPath_c4877_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPainterPath &arg1 = args.read<const QPainterPath & > (heap);
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (heap);
  ret.write<bool > ((bool)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_collidesWithPath_c4877_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithPath_c4877_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_collidesWithPath_c4877_1 = cb;
}


// bool QGraphicsProxyWidget::contains(const QPointF &point)

static void _init_cbs_contains_c1986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_contains_c1986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = args.read<const QPointF & > (heap);
  ret.write<bool > ((bool)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_contains_c1986_0 (arg1));
}

static void _set_callback_cbs_contains_c1986_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_contains_c1986_0 = cb;
}


// void QGraphicsProxyWidget::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_3674_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_3674_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneContextMenuEvent *arg1 = args.read<QGraphicsSceneContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_contextMenuEvent_3674_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_3674_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_contextMenuEvent_3674_0 = cb;
}


// void QGraphicsProxyWidget::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QGraphicsProxyWidget::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ((QGraphicsProxyWidget_Adaptor *)cls)->emitter_QGraphicsProxyWidget_destroyed_1302 (arg1);
}


// void QGraphicsProxyWidget::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// void QGraphicsProxyWidget::dragEnterEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragEnterEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_dragEnterEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_dragEnterEvent_3315_0 = cb;
}


// void QGraphicsProxyWidget::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragLeaveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_dragLeaveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_dragLeaveEvent_3315_0 = cb;
}


// void QGraphicsProxyWidget::dragMoveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragMoveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_dragMoveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_dragMoveEvent_3315_0 = cb;
}


// void QGraphicsProxyWidget::dropEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dropEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_3315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_dropEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dropEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_dropEvent_3315_0 = cb;
}


// emitter void QGraphicsProxyWidget::enabledChanged()

static void _init_emitter_enabledChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_enabledChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsProxyWidget_Adaptor *)cls)->emitter_QGraphicsProxyWidget_enabledChanged_0 ();
}


// bool QGraphicsProxyWidget::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QGraphicsProxyWidget::eventFilter(QObject *object, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QVariant QGraphicsProxyWidget::extension(const QVariant &variant)

static void _init_cbs_extension_c2119_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("variant");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_extension_c2119_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = args.read<const QVariant & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_extension_c2119_0 (arg1));
}

static void _set_callback_cbs_extension_c2119_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_extension_c2119_0 = cb;
}


// void QGraphicsProxyWidget::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// bool QGraphicsProxyWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QGraphicsProxyWidget::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// void QGraphicsProxyWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)

static void _init_cbs_getContentsMargins_c4704_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_getContentsMargins_c4704_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = args.read<double * > (heap);
  double *arg2 = args.read<double * > (heap);
  double *arg3 = args.read<double * > (heap);
  double *arg4 = args.read<double * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_getContentsMargins_c4704_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_getContentsMargins_c4704_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_getContentsMargins_c4704_0 = cb;
}


// void QGraphicsProxyWidget::grabKeyboardEvent(QEvent *event)

static void _init_cbs_grabKeyboardEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_grabKeyboardEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_grabKeyboardEvent_1217_0 (arg1);
}

static void _set_callback_cbs_grabKeyboardEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_grabKeyboardEvent_1217_0 = cb;
}


// void QGraphicsProxyWidget::grabMouseEvent(QEvent *event)

static void _init_cbs_grabMouseEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_grabMouseEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_grabMouseEvent_1217_0 (arg1);
}

static void _set_callback_cbs_grabMouseEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_grabMouseEvent_1217_0 = cb;
}


// void QGraphicsProxyWidget::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QGraphicsProxyWidget::hoverEnterEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverEnterEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverEnterEvent_3044_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_hoverEnterEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverEnterEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_hoverEnterEvent_3044_0 = cb;
}


// void QGraphicsProxyWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverLeaveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverLeaveEvent_3044_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_hoverLeaveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverLeaveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_hoverLeaveEvent_3044_0 = cb;
}


// void QGraphicsProxyWidget::hoverMoveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverMoveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverMoveEvent_3044_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_hoverMoveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverMoveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_hoverMoveEvent_3044_0 = cb;
}


// void QGraphicsProxyWidget::initStyleOption(QStyleOption *option)

static void _init_cbs_initStyleOption_c1865_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOption * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c1865_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOption *arg1 = args.read<QStyleOption * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_initStyleOption_c1865_0 (arg1);
}

static void _set_callback_cbs_initStyleOption_c1865_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_initStyleOption_c1865_0 = cb;
}


// void QGraphicsProxyWidget::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QGraphicsProxyWidget::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// bool QGraphicsProxyWidget::isObscuredBy(const QGraphicsItem *item)

static void _init_cbs_isObscuredBy_c2614_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isObscuredBy_c2614_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > (heap);
  ret.write<bool > ((bool)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_isObscuredBy_c2614_0 (arg1));
}

static void _set_callback_cbs_isObscuredBy_c2614_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_isObscuredBy_c2614_0 = cb;
}


// QVariant QGraphicsProxyWidget::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)

static void _init_cbs_itemChange_5658_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("change");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_itemChange_5658_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_itemChange_5658_0 (arg1, arg2));
}

static void _set_callback_cbs_itemChange_5658_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_itemChange_5658_0 = cb;
}


// void QGraphicsProxyWidget::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QGraphicsProxyWidget::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QGraphicsProxyWidget::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_3049_0 = cb;
}


// void QGraphicsProxyWidget::mouseMoveEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseMoveEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_mouseMoveEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_mouseMoveEvent_3049_0 = cb;
}


// void QGraphicsProxyWidget::mousePressEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mousePressEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_mousePressEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_mousePressEvent_3049_0 = cb;
}


// void QGraphicsProxyWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_3049_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_mouseReleaseEvent_3049_0 = cb;
}


// void QGraphicsProxyWidget::moveEvent(QGraphicsSceneMoveEvent *event)

static void _init_cbs_moveEvent_2935_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_2935_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneMoveEvent *arg1 = args.read<QGraphicsSceneMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_moveEvent_2935_0 (arg1);
}

static void _set_callback_cbs_moveEvent_2935_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_moveEvent_2935_0 = cb;
}


// exposed QGraphicsProxyWidget *QGraphicsProxyWidget::newProxyWidget(const QWidget *)

static void _init_fp_newProxyWidget_2010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<QGraphicsProxyWidget * > ();
}

static void _call_fp_newProxyWidget_2010 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = args.read<const QWidget * > (heap);
  ret.write<QGraphicsProxyWidget * > ((QGraphicsProxyWidget *)((QGraphicsProxyWidget_Adaptor *)cls)->fp_QGraphicsProxyWidget_newProxyWidget_2010 (arg1));
}


// emitter void QGraphicsProxyWidget::opacityChanged()

static void _init_emitter_opacityChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_opacityChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsProxyWidget_Adaptor *)cls)->emitter_QGraphicsProxyWidget_opacityChanged_0 ();
}


// QPainterPath QGraphicsProxyWidget::opaqueArea()

static void _init_cbs_opaqueArea_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_opaqueArea_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_opaqueArea_c0_0 ());
}

static void _set_callback_cbs_opaqueArea_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_opaqueArea_c0_0 = cb;
}


// void QGraphicsProxyWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)

static void _init_cbs_paint_6301_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_6301_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > (heap);
  QWidget *arg3 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_paint_6301_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_6301_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_paint_6301_0 = cb;
}


// void QGraphicsProxyWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)

static void _init_cbs_paintWindowFrame_6301_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paintWindowFrame_6301_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > (heap);
  QWidget *arg3 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_paintWindowFrame_6301_1 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paintWindowFrame_6301_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_paintWindowFrame_6301_1 = cb;
}


// emitter void QGraphicsProxyWidget::parentChanged()

static void _init_emitter_parentChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_parentChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsProxyWidget_Adaptor *)cls)->emitter_QGraphicsProxyWidget_parentChanged_0 ();
}


// void QGraphicsProxyWidget::polishEvent()

static void _init_cbs_polishEvent_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_polishEvent_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_polishEvent_0_0 ();
}

static void _set_callback_cbs_polishEvent_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_polishEvent_0_0 = cb;
}


// exposed void QGraphicsProxyWidget::prepareGeometryChange()

static void _init_fp_prepareGeometryChange_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_prepareGeometryChange_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->fp_QGraphicsProxyWidget_prepareGeometryChange_0 ();
}


// QVariant QGraphicsProxyWidget::propertyChange(const QString &propertyName, const QVariant &value)

static void _init_cbs_propertyChange_4036_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_propertyChange_4036_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  ret.write<QVariant > ((QVariant)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_propertyChange_4036_0 (arg1, arg2));
}

static void _set_callback_cbs_propertyChange_4036_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_propertyChange_4036_0 = cb;
}


// exposed int QGraphicsProxyWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<int > ((int)((QGraphicsProxyWidget_Adaptor *)cls)->fp_QGraphicsProxyWidget_receivers_c1731 (arg1));
}


// exposed void QGraphicsProxyWidget::removeFromIndex()

static void _init_fp_removeFromIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_removeFromIndex_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->fp_QGraphicsProxyWidget_removeFromIndex_0 ();
}


// void QGraphicsProxyWidget::resizeEvent(QGraphicsSceneResizeEvent *event)

static void _init_cbs_resizeEvent_3154_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_3154_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneResizeEvent *arg1 = args.read<QGraphicsSceneResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_resizeEvent_3154_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_3154_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_resizeEvent_3154_0 = cb;
}


// emitter void QGraphicsProxyWidget::rotationChanged()

static void _init_emitter_rotationChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_rotationChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsProxyWidget_Adaptor *)cls)->emitter_QGraphicsProxyWidget_rotationChanged_0 ();
}


// emitter void QGraphicsProxyWidget::scaleChanged()

static void _init_emitter_scaleChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_scaleChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsProxyWidget_Adaptor *)cls)->emitter_QGraphicsProxyWidget_scaleChanged_0 ();
}


// bool QGraphicsProxyWidget::sceneEvent(QEvent *event)

static void _init_cbs_sceneEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_sceneEvent_1217_0 (arg1));
}

static void _set_callback_cbs_sceneEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_sceneEvent_1217_0 = cb;
}


// bool QGraphicsProxyWidget::sceneEventFilter(QGraphicsItem *watched, QEvent *event)

static void _init_cbs_sceneEventFilter_3028_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEventFilter_3028_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_sceneEventFilter_3028_0 (arg1, arg2));
}

static void _set_callback_cbs_sceneEventFilter_3028_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_sceneEventFilter_3028_0 = cb;
}


// exposed QObject *QGraphicsProxyWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QGraphicsProxyWidget_Adaptor *)cls)->fp_QGraphicsProxyWidget_sender_c0 ());
}


// void QGraphicsProxyWidget::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)

static void _init_cbs_setExtension_4817_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("variant");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setExtension_4817_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_setExtension_4817_0 (arg1, arg2);
}

static void _set_callback_cbs_setExtension_4817_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_setExtension_4817_0 = cb;
}


// void QGraphicsProxyWidget::setGeometry(const QRectF &rect)

static void _init_cbs_setGeometry_1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1862_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_setGeometry_1862_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_setGeometry_1862_0 = cb;
}


// exposed void QGraphicsProxyWidget::setGraphicsItem(QGraphicsItem *item)

static void _init_fp_setGraphicsItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setGraphicsItem_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->fp_QGraphicsProxyWidget_setGraphicsItem_1919 (arg1);
}


// exposed void QGraphicsProxyWidget::setOwnedByLayout(bool ownedByLayout)

static void _init_fp_setOwnedByLayout_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ownedByLayout");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setOwnedByLayout_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->fp_QGraphicsProxyWidget_setOwnedByLayout_864 (arg1);
}


// QPainterPath QGraphicsProxyWidget::shape()

static void _init_cbs_shape_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_shape_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_shape_c0_0 ());
}

static void _set_callback_cbs_shape_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_shape_c0_0 = cb;
}


// void QGraphicsProxyWidget::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSizeF QGraphicsProxyWidget::sizeHint(Qt::SizeHint which, const QSizeF &constraint)

static void _init_cbs_sizeHint_c3330_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("constraint");
  decl->add_arg<const QSizeF & > (argspec_1);
  decl->set_return<QSizeF > ();
}

static void _call_cbs_sizeHint_c3330_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeHint>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (heap);
  const QSizeF &arg2 = args.read<const QSizeF & > (heap);
  ret.write<QSizeF > ((QSizeF)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_sizeHint_c3330_1 (arg1, arg2));
}

static void _set_callback_cbs_sizeHint_c3330_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_sizeHint_c3330_1 = cb;
}


// bool QGraphicsProxyWidget::supportsExtension(QGraphicsItem::Extension extension)

static void _init_cbs_supportsExtension_c2806_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_supportsExtension_c2806_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  ret.write<bool > ((bool)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_supportsExtension_c2806_0 (arg1));
}

static void _set_callback_cbs_supportsExtension_c2806_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_supportsExtension_c2806_0 = cb;
}


// void QGraphicsProxyWidget::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// int QGraphicsProxyWidget::type()

static void _init_cbs_type_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_type_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_type_c0_0 ());
}

static void _set_callback_cbs_type_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_type_c0_0 = cb;
}


// void QGraphicsProxyWidget::ungrabKeyboardEvent(QEvent *event)

static void _init_cbs_ungrabKeyboardEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_ungrabKeyboardEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_ungrabKeyboardEvent_1217_0 (arg1);
}

static void _set_callback_cbs_ungrabKeyboardEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_ungrabKeyboardEvent_1217_0 = cb;
}


// void QGraphicsProxyWidget::ungrabMouseEvent(QEvent *event)

static void _init_cbs_ungrabMouseEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_ungrabMouseEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_ungrabMouseEvent_1217_0 (arg1);
}

static void _set_callback_cbs_ungrabMouseEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_ungrabMouseEvent_1217_0 = cb;
}


// void QGraphicsProxyWidget::updateGeometry()

static void _init_cbs_updateGeometry_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometry_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_updateGeometry_0_0 ();
}

static void _set_callback_cbs_updateGeometry_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_updateGeometry_0_0 = cb;
}


// emitter void QGraphicsProxyWidget::visibleChanged()

static void _init_emitter_visibleChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_visibleChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsProxyWidget_Adaptor *)cls)->emitter_QGraphicsProxyWidget_visibleChanged_0 ();
}


// void QGraphicsProxyWidget::wheelEvent(QGraphicsSceneWheelEvent *event)

static void _init_cbs_wheelEvent_3029_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_3029_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsSceneWheelEvent *arg1 = args.read<QGraphicsSceneWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsProxyWidget_Adaptor *)cls)->cbs_wheelEvent_3029_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_3029_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_wheelEvent_3029_0 = cb;
}


// bool QGraphicsProxyWidget::windowFrameEvent(QEvent *e)

static void _init_cbs_windowFrameEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_windowFrameEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_windowFrameEvent_1217_0 (arg1));
}

static void _set_callback_cbs_windowFrameEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_windowFrameEvent_1217_0 = cb;
}


// Qt::WindowFrameSection QGraphicsProxyWidget::windowFrameSectionAt(const QPointF &pos)

static void _init_cbs_windowFrameSectionAt_c1986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<qt_gsi::Converter<Qt::WindowFrameSection>::target_type > ();
}

static void _call_cbs_windowFrameSectionAt_c1986_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPointF &arg1 = args.read<const QPointF & > (heap);
  ret.write<qt_gsi::Converter<Qt::WindowFrameSection>::target_type > ((qt_gsi::Converter<Qt::WindowFrameSection>::target_type)((QGraphicsProxyWidget_Adaptor *)cls)->cbs_windowFrameSectionAt_c1986_0 (arg1));
}

static void _set_callback_cbs_windowFrameSectionAt_c1986_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsProxyWidget_Adaptor *)cls)->cb_windowFrameSectionAt_c1986_0 = cb;
}


// emitter void QGraphicsProxyWidget::xChanged()

static void _init_emitter_xChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_xChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsProxyWidget_Adaptor *)cls)->emitter_QGraphicsProxyWidget_xChanged_0 ();
}


// emitter void QGraphicsProxyWidget::yChanged()

static void _init_emitter_yChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_yChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsProxyWidget_Adaptor *)cls)->emitter_QGraphicsProxyWidget_yChanged_0 ();
}


// emitter void QGraphicsProxyWidget::zChanged()

static void _init_emitter_zChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_zChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QGraphicsProxyWidget_Adaptor *)cls)->emitter_QGraphicsProxyWidget_zChanged_0 ();
}


namespace gsi
{

gsi::Class<QGraphicsProxyWidget> &qtdecl_QGraphicsProxyWidget ();

static gsi::Methods methods_QGraphicsProxyWidget_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsProxyWidget::QGraphicsProxyWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags)\nThis method creates an object of class QGraphicsProxyWidget.", &_init_ctor_QGraphicsProxyWidget_Adaptor_4306, &_call_ctor_QGraphicsProxyWidget_Adaptor_4306);
  methods += new qt_gsi::GenericMethod ("*addToIndex", "@brief Method void QGraphicsProxyWidget::addToIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addToIndex_0, &_call_fp_addToIndex_0);
  methods += new qt_gsi::GenericMethod ("advance", "@hide", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0);
  methods += new qt_gsi::GenericMethod ("advance", "@brief Virtual method void QGraphicsProxyWidget::advance(int phase)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0, &_set_callback_cbs_advance_767_0);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@hide", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Virtual method QRectF QGraphicsProxyWidget::boundingRect()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0, &_set_callback_cbs_boundingRect_c0_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QGraphicsProxyWidget::changeEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsProxyWidget::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QGraphicsProxyWidget::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("collidesWithItem", "@hide", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1);
  methods += new qt_gsi::GenericMethod ("collidesWithItem", "@brief Virtual method bool QGraphicsProxyWidget::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1, &_set_callback_cbs_collidesWithItem_c4977_1);
  methods += new qt_gsi::GenericMethod ("collidesWithPath", "@hide", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1);
  methods += new qt_gsi::GenericMethod ("collidesWithPath", "@brief Virtual method bool QGraphicsProxyWidget::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1, &_set_callback_cbs_collidesWithPath_c4877_1);
  methods += new qt_gsi::GenericMethod ("contains", "@hide", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Virtual method bool QGraphicsProxyWidget::contains(const QPointF &point)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0, &_set_callback_cbs_contains_c1986_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QGraphicsProxyWidget::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0, &_set_callback_cbs_contextMenuEvent_3674_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsProxyWidget::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QGraphicsProxyWidget::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsProxyWidget::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QGraphicsProxyWidget::dragEnterEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0, &_set_callback_cbs_dragEnterEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QGraphicsProxyWidget::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0, &_set_callback_cbs_dragLeaveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QGraphicsProxyWidget::dragMoveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0, &_set_callback_cbs_dragMoveEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QGraphicsProxyWidget::dropEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0, &_set_callback_cbs_dropEvent_3315_0);
  methods += new qt_gsi::GenericMethod ("emit_enabledChanged", "@brief Emitter for signal void QGraphicsProxyWidget::enabledChanged()\nCall this method to emit this signal.", false, &_init_emitter_enabledChanged_0, &_call_emitter_enabledChanged_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QGraphicsProxyWidget::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QGraphicsProxyWidget::eventFilter(QObject *object, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*extension", "@hide", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0);
  methods += new qt_gsi::GenericMethod ("*extension", "@brief Virtual method QVariant QGraphicsProxyWidget::extension(const QVariant &variant)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0, &_set_callback_cbs_extension_c2119_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QGraphicsProxyWidget::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QGraphicsProxyWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QGraphicsProxyWidget::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("getContentsMargins", "@hide", true, &_init_cbs_getContentsMargins_c4704_0, &_call_cbs_getContentsMargins_c4704_0);
  methods += new qt_gsi::GenericMethod ("getContentsMargins", "@brief Virtual method void QGraphicsProxyWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_getContentsMargins_c4704_0, &_call_cbs_getContentsMargins_c4704_0, &_set_callback_cbs_getContentsMargins_c4704_0);
  methods += new qt_gsi::GenericMethod ("*grabKeyboardEvent", "@hide", false, &_init_cbs_grabKeyboardEvent_1217_0, &_call_cbs_grabKeyboardEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*grabKeyboardEvent", "@brief Virtual method void QGraphicsProxyWidget::grabKeyboardEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_grabKeyboardEvent_1217_0, &_call_cbs_grabKeyboardEvent_1217_0, &_set_callback_cbs_grabKeyboardEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*grabMouseEvent", "@hide", false, &_init_cbs_grabMouseEvent_1217_0, &_call_cbs_grabMouseEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*grabMouseEvent", "@brief Virtual method void QGraphicsProxyWidget::grabMouseEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_grabMouseEvent_1217_0, &_call_cbs_grabMouseEvent_1217_0, &_set_callback_cbs_grabMouseEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QGraphicsProxyWidget::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hoverEnterEvent", "@hide", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverEnterEvent", "@brief Virtual method void QGraphicsProxyWidget::hoverEnterEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0, &_set_callback_cbs_hoverEnterEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@hide", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@brief Virtual method void QGraphicsProxyWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0, &_set_callback_cbs_hoverLeaveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverMoveEvent", "@hide", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*hoverMoveEvent", "@brief Virtual method void QGraphicsProxyWidget::hoverMoveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0, &_set_callback_cbs_hoverMoveEvent_3044_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c1865_0, &_call_cbs_initStyleOption_c1865_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QGraphicsProxyWidget::initStyleOption(QStyleOption *option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c1865_0, &_call_cbs_initStyleOption_c1865_0, &_set_callback_cbs_initStyleOption_c1865_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QGraphicsProxyWidget::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodQuery", "@brief Virtual method QVariant QGraphicsProxyWidget::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("isObscuredBy", "@hide", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0);
  methods += new qt_gsi::GenericMethod ("isObscuredBy", "@brief Virtual method bool QGraphicsProxyWidget::isObscuredBy(const QGraphicsItem *item)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0, &_set_callback_cbs_isObscuredBy_c2614_0);
  methods += new qt_gsi::GenericMethod ("*itemChange", "@hide", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0);
  methods += new qt_gsi::GenericMethod ("*itemChange", "@brief Virtual method QVariant QGraphicsProxyWidget::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0, &_set_callback_cbs_itemChange_5658_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QGraphicsProxyWidget::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QGraphicsProxyWidget::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QGraphicsProxyWidget::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0, &_set_callback_cbs_mouseDoubleClickEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QGraphicsProxyWidget::mouseMoveEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0, &_set_callback_cbs_mouseMoveEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QGraphicsProxyWidget::mousePressEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0, &_set_callback_cbs_mousePressEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QGraphicsProxyWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0, &_set_callback_cbs_mouseReleaseEvent_3049_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_2935_0, &_call_cbs_moveEvent_2935_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QGraphicsProxyWidget::moveEvent(QGraphicsSceneMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_2935_0, &_call_cbs_moveEvent_2935_0, &_set_callback_cbs_moveEvent_2935_0);
  methods += new qt_gsi::GenericMethod ("*newProxyWidget", "@brief Method QGraphicsProxyWidget *QGraphicsProxyWidget::newProxyWidget(const QWidget *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_newProxyWidget_2010, &_call_fp_newProxyWidget_2010);
  methods += new qt_gsi::GenericMethod ("emit_opacityChanged", "@brief Emitter for signal void QGraphicsProxyWidget::opacityChanged()\nCall this method to emit this signal.", false, &_init_emitter_opacityChanged_0, &_call_emitter_opacityChanged_0);
  methods += new qt_gsi::GenericMethod ("opaqueArea", "@hide", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0);
  methods += new qt_gsi::GenericMethod ("opaqueArea", "@brief Virtual method QPainterPath QGraphicsProxyWidget::opaqueArea()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0, &_set_callback_cbs_opaqueArea_c0_0);
  methods += new qt_gsi::GenericMethod ("paint", "@hide", false, &_init_cbs_paint_6301_0, &_call_cbs_paint_6301_0);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QGraphicsProxyWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paint_6301_0, &_call_cbs_paint_6301_0, &_set_callback_cbs_paint_6301_0);
  methods += new qt_gsi::GenericMethod ("paintWindowFrame", "@hide", false, &_init_cbs_paintWindowFrame_6301_1, &_call_cbs_paintWindowFrame_6301_1);
  methods += new qt_gsi::GenericMethod ("paintWindowFrame", "@brief Virtual method void QGraphicsProxyWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintWindowFrame_6301_1, &_call_cbs_paintWindowFrame_6301_1, &_set_callback_cbs_paintWindowFrame_6301_1);
  methods += new qt_gsi::GenericMethod ("emit_parentChanged", "@brief Emitter for signal void QGraphicsProxyWidget::parentChanged()\nCall this method to emit this signal.", false, &_init_emitter_parentChanged_0, &_call_emitter_parentChanged_0);
  methods += new qt_gsi::GenericMethod ("*polishEvent", "@hide", false, &_init_cbs_polishEvent_0_0, &_call_cbs_polishEvent_0_0);
  methods += new qt_gsi::GenericMethod ("*polishEvent", "@brief Virtual method void QGraphicsProxyWidget::polishEvent()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polishEvent_0_0, &_call_cbs_polishEvent_0_0, &_set_callback_cbs_polishEvent_0_0);
  methods += new qt_gsi::GenericMethod ("*prepareGeometryChange", "@brief Method void QGraphicsProxyWidget::prepareGeometryChange()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_prepareGeometryChange_0, &_call_fp_prepareGeometryChange_0);
  methods += new qt_gsi::GenericMethod ("*propertyChange", "@hide", false, &_init_cbs_propertyChange_4036_0, &_call_cbs_propertyChange_4036_0);
  methods += new qt_gsi::GenericMethod ("*propertyChange", "@brief Virtual method QVariant QGraphicsProxyWidget::propertyChange(const QString &propertyName, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_propertyChange_4036_0, &_call_cbs_propertyChange_4036_0, &_set_callback_cbs_propertyChange_4036_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QGraphicsProxyWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*removeFromIndex", "@brief Method void QGraphicsProxyWidget::removeFromIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removeFromIndex_0, &_call_fp_removeFromIndex_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_3154_0, &_call_cbs_resizeEvent_3154_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QGraphicsProxyWidget::resizeEvent(QGraphicsSceneResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_3154_0, &_call_cbs_resizeEvent_3154_0, &_set_callback_cbs_resizeEvent_3154_0);
  methods += new qt_gsi::GenericMethod ("emit_rotationChanged", "@brief Emitter for signal void QGraphicsProxyWidget::rotationChanged()\nCall this method to emit this signal.", false, &_init_emitter_rotationChanged_0, &_call_emitter_rotationChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_scaleChanged", "@brief Emitter for signal void QGraphicsProxyWidget::scaleChanged()\nCall this method to emit this signal.", false, &_init_emitter_scaleChanged_0, &_call_emitter_scaleChanged_0);
  methods += new qt_gsi::GenericMethod ("*sceneEvent", "@hide", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*sceneEvent", "@brief Virtual method bool QGraphicsProxyWidget::sceneEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0, &_set_callback_cbs_sceneEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*sceneEventFilter", "@hide", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0);
  methods += new qt_gsi::GenericMethod ("*sceneEventFilter", "@brief Virtual method bool QGraphicsProxyWidget::sceneEventFilter(QGraphicsItem *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0, &_set_callback_cbs_sceneEventFilter_3028_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QGraphicsProxyWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*setExtension", "@hide", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0);
  methods += new qt_gsi::GenericMethod ("*setExtension", "@brief Virtual method void QGraphicsProxyWidget::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0, &_set_callback_cbs_setExtension_4817_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1862_0, &_call_cbs_setGeometry_1862_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QGraphicsProxyWidget::setGeometry(const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1862_0, &_call_cbs_setGeometry_1862_0, &_set_callback_cbs_setGeometry_1862_0);
  methods += new qt_gsi::GenericMethod ("*setGraphicsItem", "@brief Method void QGraphicsProxyWidget::setGraphicsItem(QGraphicsItem *item)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setGraphicsItem_1919, &_call_fp_setGraphicsItem_1919);
  methods += new qt_gsi::GenericMethod ("*setOwnedByLayout", "@brief Method void QGraphicsProxyWidget::setOwnedByLayout(bool ownedByLayout)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setOwnedByLayout_864, &_call_fp_setOwnedByLayout_864);
  methods += new qt_gsi::GenericMethod ("shape", "@hide", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0);
  methods += new qt_gsi::GenericMethod ("shape", "@brief Virtual method QPainterPath QGraphicsProxyWidget::shape()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0, &_set_callback_cbs_shape_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QGraphicsProxyWidget::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*sizeHint", "@hide", true, &_init_cbs_sizeHint_c3330_1, &_call_cbs_sizeHint_c3330_1);
  methods += new qt_gsi::GenericMethod ("*sizeHint", "@brief Virtual method QSizeF QGraphicsProxyWidget::sizeHint(Qt::SizeHint which, const QSizeF &constraint)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c3330_1, &_call_cbs_sizeHint_c3330_1, &_set_callback_cbs_sizeHint_c3330_1);
  methods += new qt_gsi::GenericMethod ("*supportsExtension", "@hide", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0);
  methods += new qt_gsi::GenericMethod ("*supportsExtension", "@brief Virtual method bool QGraphicsProxyWidget::supportsExtension(QGraphicsItem::Extension extension)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0, &_set_callback_cbs_supportsExtension_c2806_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsProxyWidget::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("type", "@hide", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0);
  methods += new qt_gsi::GenericMethod ("type", "@brief Virtual method int QGraphicsProxyWidget::type()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0, &_set_callback_cbs_type_c0_0);
  methods += new qt_gsi::GenericMethod ("*ungrabKeyboardEvent", "@hide", false, &_init_cbs_ungrabKeyboardEvent_1217_0, &_call_cbs_ungrabKeyboardEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*ungrabKeyboardEvent", "@brief Virtual method void QGraphicsProxyWidget::ungrabKeyboardEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_ungrabKeyboardEvent_1217_0, &_call_cbs_ungrabKeyboardEvent_1217_0, &_set_callback_cbs_ungrabKeyboardEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*ungrabMouseEvent", "@hide", false, &_init_cbs_ungrabMouseEvent_1217_0, &_call_cbs_ungrabMouseEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*ungrabMouseEvent", "@brief Virtual method void QGraphicsProxyWidget::ungrabMouseEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_ungrabMouseEvent_1217_0, &_call_cbs_ungrabMouseEvent_1217_0, &_set_callback_cbs_ungrabMouseEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*updateGeometry", "@hide", false, &_init_cbs_updateGeometry_0_0, &_call_cbs_updateGeometry_0_0);
  methods += new qt_gsi::GenericMethod ("*updateGeometry", "@brief Virtual method void QGraphicsProxyWidget::updateGeometry()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometry_0_0, &_call_cbs_updateGeometry_0_0, &_set_callback_cbs_updateGeometry_0_0);
  methods += new qt_gsi::GenericMethod ("emit_visibleChanged", "@brief Emitter for signal void QGraphicsProxyWidget::visibleChanged()\nCall this method to emit this signal.", false, &_init_emitter_visibleChanged_0, &_call_emitter_visibleChanged_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QGraphicsProxyWidget::wheelEvent(QGraphicsSceneWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0, &_set_callback_cbs_wheelEvent_3029_0);
  methods += new qt_gsi::GenericMethod ("*windowFrameEvent", "@hide", false, &_init_cbs_windowFrameEvent_1217_0, &_call_cbs_windowFrameEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*windowFrameEvent", "@brief Virtual method bool QGraphicsProxyWidget::windowFrameEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowFrameEvent_1217_0, &_call_cbs_windowFrameEvent_1217_0, &_set_callback_cbs_windowFrameEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*windowFrameSectionAt", "@hide", true, &_init_cbs_windowFrameSectionAt_c1986_0, &_call_cbs_windowFrameSectionAt_c1986_0);
  methods += new qt_gsi::GenericMethod ("*windowFrameSectionAt", "@brief Virtual method Qt::WindowFrameSection QGraphicsProxyWidget::windowFrameSectionAt(const QPointF &pos)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_windowFrameSectionAt_c1986_0, &_call_cbs_windowFrameSectionAt_c1986_0, &_set_callback_cbs_windowFrameSectionAt_c1986_0);
  methods += new qt_gsi::GenericMethod ("emit_xChanged", "@brief Emitter for signal void QGraphicsProxyWidget::xChanged()\nCall this method to emit this signal.", false, &_init_emitter_xChanged_0, &_call_emitter_xChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_yChanged", "@brief Emitter for signal void QGraphicsProxyWidget::yChanged()\nCall this method to emit this signal.", false, &_init_emitter_yChanged_0, &_call_emitter_yChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_zChanged", "@brief Emitter for signal void QGraphicsProxyWidget::zChanged()\nCall this method to emit this signal.", false, &_init_emitter_zChanged_0, &_call_emitter_zChanged_0);
  return methods;
}

gsi::Class<QGraphicsProxyWidget_Adaptor> decl_QGraphicsProxyWidget_Adaptor (qtdecl_QGraphicsProxyWidget (), "QGraphicsProxyWidget",
  methods_QGraphicsProxyWidget_Adaptor (),
  "@qt\n@brief Binding of QGraphicsProxyWidget");

}

