
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQInputContext.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QInputContext>
#include <QChildEvent>
#include <QEvent>
#include <QFont>
#include <QInputMethodEvent>
#include <QMouseEvent>
#include <QObject>
#include <QTextFormat>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QInputContext

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QInputContext::staticMetaObject);
}


// QList<QAction *> QInputContext::actions()


static void _init_f_actions_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAction *> > ();
}

static void _call_f_actions_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAction *> > ((QList<QAction *>)((QInputContext *)cls)->actions ());
}


// bool QInputContext::filterEvent(const QEvent *event)


static void _init_f_filterEvent_1912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<const QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_filterEvent_1912 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QEvent *arg1 = args.read<const QEvent * > (heap);
  ret.write<bool > ((bool)((QInputContext *)cls)->filterEvent (arg1));
}


// QWidget *QInputContext::focusWidget()


static void _init_f_focusWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_focusWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QInputContext *)cls)->focusWidget ());
}


// QFont QInputContext::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)((QInputContext *)cls)->font ());
}


// QString QInputContext::identifierName()


static void _init_f_identifierName_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_identifierName_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QInputContext *)cls)->identifierName ());
}


// bool QInputContext::isComposing()


static void _init_f_isComposing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isComposing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QInputContext *)cls)->isComposing ());
}


// QString QInputContext::language()


static void _init_f_language_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_language_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QInputContext *)cls)->language ());
}


// void QInputContext::mouseHandler(int x, QMouseEvent *event)


static void _init_f_mouseHandler_2397 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QMouseEvent * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_mouseHandler_2397 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  QMouseEvent *arg2 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext *)cls)->mouseHandler (arg1, arg2);
}


// void QInputContext::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext *)cls)->reset ();
}


// void QInputContext::sendEvent(const QInputMethodEvent &event)


static void _init_f_sendEvent_3045 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<const QInputMethodEvent & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_sendEvent_3045 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QInputMethodEvent &arg1 = args.read<const QInputMethodEvent & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext *)cls)->sendEvent (arg1);
}


// void QInputContext::setFocusWidget(QWidget *w)


static void _init_f_setFocusWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext *)cls)->setFocusWidget (arg1);
}


// QTextFormat QInputContext::standardFormat(QInputContext::StandardFormat s)


static void _init_f_standardFormat_c3336 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const qt_gsi::Converter<QInputContext::StandardFormat>::target_type & > (argspec_0);
  decl->set_return<QTextFormat > ();
}

static void _call_f_standardFormat_c3336 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QInputContext::StandardFormat>::target_type & arg1 = args.read<const qt_gsi::Converter<QInputContext::StandardFormat>::target_type & > (heap);
  ret.write<QTextFormat > ((QTextFormat)((QInputContext *)cls)->standardFormat (qt_gsi::QtToCppAdaptor<QInputContext::StandardFormat>(arg1).cref()));
}


// void QInputContext::update()


static void _init_f_update_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_update_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext *)cls)->update ();
}


// void QInputContext::widgetDestroyed(QWidget *w)


static void _init_f_widgetDestroyed_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_widgetDestroyed_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext *)cls)->widgetDestroyed (arg1);
}


// static QString QInputContext::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(0);
  ret.write<QString > ((QString)QInputContext::tr (arg1, arg2));
}


// static QString QInputContext::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args.read<const char * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QString > ((QString)QInputContext::tr (arg1, arg2, arg3));
}


// static QString QInputContext::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(0);
  ret.write<QString > ((QString)QInputContext::trUtf8 (arg1, arg2));
}


// static QString QInputContext::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args.read<const char * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QString > ((QString)QInputContext::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QInputContext () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("actions", "@brief Method QList<QAction *> QInputContext::actions()\n", false, &_init_f_actions_0, &_call_f_actions_0);
  methods += new qt_gsi::GenericMethod ("filterEvent", "@brief Method bool QInputContext::filterEvent(const QEvent *event)\n", false, &_init_f_filterEvent_1912, &_call_f_filterEvent_1912);
  methods += new qt_gsi::GenericMethod (":focusWidget", "@brief Method QWidget *QInputContext::focusWidget()\n", true, &_init_f_focusWidget_c0, &_call_f_focusWidget_c0);
  methods += new qt_gsi::GenericMethod ("font", "@brief Method QFont QInputContext::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
  methods += new qt_gsi::GenericMethod ("identifierName", "@brief Method QString QInputContext::identifierName()\n", false, &_init_f_identifierName_0, &_call_f_identifierName_0);
  methods += new qt_gsi::GenericMethod ("isComposing?", "@brief Method bool QInputContext::isComposing()\n", true, &_init_f_isComposing_c0, &_call_f_isComposing_c0);
  methods += new qt_gsi::GenericMethod ("language", "@brief Method QString QInputContext::language()\n", false, &_init_f_language_0, &_call_f_language_0);
  methods += new qt_gsi::GenericMethod ("mouseHandler", "@brief Method void QInputContext::mouseHandler(int x, QMouseEvent *event)\n", false, &_init_f_mouseHandler_2397, &_call_f_mouseHandler_2397);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Method void QInputContext::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
  methods += new qt_gsi::GenericMethod ("sendEvent", "@brief Method void QInputContext::sendEvent(const QInputMethodEvent &event)\n", false, &_init_f_sendEvent_3045, &_call_f_sendEvent_3045);
  methods += new qt_gsi::GenericMethod ("setFocusWidget|focusWidget=", "@brief Method void QInputContext::setFocusWidget(QWidget *w)\n", false, &_init_f_setFocusWidget_1315, &_call_f_setFocusWidget_1315);
  methods += new qt_gsi::GenericMethod ("standardFormat", "@brief Method QTextFormat QInputContext::standardFormat(QInputContext::StandardFormat s)\n", true, &_init_f_standardFormat_c3336, &_call_f_standardFormat_c3336);
  methods += new qt_gsi::GenericMethod ("update", "@brief Method void QInputContext::update()\n", false, &_init_f_update_0, &_call_f_update_0);
  methods += new qt_gsi::GenericMethod ("widgetDestroyed", "@brief Method void QInputContext::widgetDestroyed(QWidget *w)\n", false, &_init_f_widgetDestroyed_1315, &_call_f_widgetDestroyed_1315);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QInputContext::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QInputContext::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QInputContext::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QInputContext::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QInputContext::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QInputContext> decl_QInputContext (qtdecl_QObject (), "QInputContext_Native",
  methods_QInputContext (),
  "@hide\n@alias QInputContext");

GSIQT_PUBLIC gsi::Class<QInputContext> &qtdecl_QInputContext () { return decl_QInputContext; }

}


class QInputContext_Adaptor : public QInputContext, public qt_gsi::QtObjectBase
{
public:

  virtual ~QInputContext_Adaptor();

  //  [adaptor ctor] QInputContext::QInputContext(QObject *parent)
  QInputContext_Adaptor() : QInputContext()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QInputContext::QInputContext(QObject *parent)
  QInputContext_Adaptor(QObject *parent) : QInputContext(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QInputContext::receivers(const char *signal)
  int fp_QInputContext_receivers_c1731 (const char *signal) const {
    return QInputContext::receivers(signal);
  }

  //  [expose] QObject *QInputContext::sender()
  QObject * fp_QInputContext_sender_c0 () const {
    return QInputContext::sender();
  }

  //  [adaptor impl] QList<QAction *> QInputContext::actions()
  QList<QAction *> cbs_actions_0_0()
  {
    return QInputContext::actions();
  }

  virtual QList<QAction *> actions()
  {
    if (cb_actions_0_0.can_issue()) {
      return cb_actions_0_0.issue<QInputContext_Adaptor, QList<QAction *> >(&QInputContext_Adaptor::cbs_actions_0_0);
    } else {
      return QInputContext::actions();
    }
  }

  //  [adaptor impl] bool QInputContext::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QInputContext::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QInputContext_Adaptor, bool, QEvent *>(&QInputContext_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QInputContext::event(arg1);
    }
  }

  //  [adaptor impl] bool QInputContext::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QInputContext::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QInputContext_Adaptor, bool, QObject *, QEvent *>(&QInputContext_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QInputContext::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QInputContext::filterEvent(const QEvent *event)
  bool cbs_filterEvent_1912_0(const QEvent *event)
  {
    return QInputContext::filterEvent(event);
  }

  virtual bool filterEvent(const QEvent *event)
  {
    if (cb_filterEvent_1912_0.can_issue()) {
      return cb_filterEvent_1912_0.issue<QInputContext_Adaptor, bool, const QEvent *>(&QInputContext_Adaptor::cbs_filterEvent_1912_0, event);
    } else {
      return QInputContext::filterEvent(event);
    }
  }

  //  [adaptor impl] QFont QInputContext::font()
  QFont cbs_font_c0_0() const
  {
    return QInputContext::font();
  }

  virtual QFont font() const
  {
    if (cb_font_c0_0.can_issue()) {
      return cb_font_c0_0.issue<QInputContext_Adaptor, QFont>(&QInputContext_Adaptor::cbs_font_c0_0);
    } else {
      return QInputContext::font();
    }
  }

  //  [adaptor impl] QString QInputContext::identifierName()
  QString cbs_identifierName_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("identifierName");
  }

  virtual QString identifierName()
  {
    if (cb_identifierName_0_0.can_issue()) {
      return cb_identifierName_0_0.issue<QInputContext_Adaptor, QString>(&QInputContext_Adaptor::cbs_identifierName_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("identifierName");
    }
  }

  //  [adaptor impl] bool QInputContext::isComposing()
  bool cbs_isComposing_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("isComposing");
  }

  virtual bool isComposing() const
  {
    if (cb_isComposing_c0_0.can_issue()) {
      return cb_isComposing_c0_0.issue<QInputContext_Adaptor, bool>(&QInputContext_Adaptor::cbs_isComposing_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isComposing");
    }
  }

  //  [adaptor impl] QString QInputContext::language()
  QString cbs_language_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("language");
  }

  virtual QString language()
  {
    if (cb_language_0_0.can_issue()) {
      return cb_language_0_0.issue<QInputContext_Adaptor, QString>(&QInputContext_Adaptor::cbs_language_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("language");
    }
  }

  //  [adaptor impl] void QInputContext::mouseHandler(int x, QMouseEvent *event)
  void cbs_mouseHandler_2397_0(int x, QMouseEvent *event)
  {
    QInputContext::mouseHandler(x, event);
  }

  virtual void mouseHandler(int x, QMouseEvent *event)
  {
    if (cb_mouseHandler_2397_0.can_issue()) {
      cb_mouseHandler_2397_0.issue<QInputContext_Adaptor, int, QMouseEvent *>(&QInputContext_Adaptor::cbs_mouseHandler_2397_0, x, event);
    } else {
      QInputContext::mouseHandler(x, event);
    }
  }

  //  [adaptor impl] void QInputContext::reset()
  void cbs_reset_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("reset");
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QInputContext_Adaptor>(&QInputContext_Adaptor::cbs_reset_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("reset");
    }
  }

  //  [adaptor impl] void QInputContext::setFocusWidget(QWidget *w)
  void cbs_setFocusWidget_1315_0(QWidget *w)
  {
    QInputContext::setFocusWidget(w);
  }

  virtual void setFocusWidget(QWidget *w)
  {
    if (cb_setFocusWidget_1315_0.can_issue()) {
      cb_setFocusWidget_1315_0.issue<QInputContext_Adaptor, QWidget *>(&QInputContext_Adaptor::cbs_setFocusWidget_1315_0, w);
    } else {
      QInputContext::setFocusWidget(w);
    }
  }

  //  [adaptor impl] void QInputContext::update()
  void cbs_update_0_0()
  {
    QInputContext::update();
  }

  virtual void update()
  {
    if (cb_update_0_0.can_issue()) {
      cb_update_0_0.issue<QInputContext_Adaptor>(&QInputContext_Adaptor::cbs_update_0_0);
    } else {
      QInputContext::update();
    }
  }

  //  [adaptor impl] void QInputContext::widgetDestroyed(QWidget *w)
  void cbs_widgetDestroyed_1315_0(QWidget *w)
  {
    QInputContext::widgetDestroyed(w);
  }

  virtual void widgetDestroyed(QWidget *w)
  {
    if (cb_widgetDestroyed_1315_0.can_issue()) {
      cb_widgetDestroyed_1315_0.issue<QInputContext_Adaptor, QWidget *>(&QInputContext_Adaptor::cbs_widgetDestroyed_1315_0, w);
    } else {
      QInputContext::widgetDestroyed(w);
    }
  }

  //  [adaptor impl] void QInputContext::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QInputContext::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QInputContext_Adaptor, QChildEvent *>(&QInputContext_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QInputContext::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputContext::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QInputContext::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QInputContext_Adaptor, QEvent *>(&QInputContext_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QInputContext::customEvent(arg1);
    }
  }

  //  [emitter impl] void QInputContext::destroyed(QObject *)
  void emitter_QInputContext_destroyed_1302(QObject *arg1)
  {
    emit QInputContext::destroyed(arg1);
  }

  //  [adaptor impl] void QInputContext::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QInputContext::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QInputContext_Adaptor, const char *>(&QInputContext_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QInputContext::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QInputContext::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QInputContext::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QInputContext_Adaptor, QTimerEvent *>(&QInputContext_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QInputContext::timerEvent(arg1);
    }
  }

  gsi::Callback cb_actions_0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_filterEvent_1912_0;
  gsi::Callback cb_font_c0_0;
  gsi::Callback cb_identifierName_0_0;
  gsi::Callback cb_isComposing_c0_0;
  gsi::Callback cb_language_0_0;
  gsi::Callback cb_mouseHandler_2397_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_setFocusWidget_1315_0;
  gsi::Callback cb_update_0_0;
  gsi::Callback cb_widgetDestroyed_1315_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QInputContext_Adaptor::~QInputContext_Adaptor() { }

//  Constructor QInputContext::QInputContext(QObject *parent) (adaptor class)

static void _init_ctor_QInputContext_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QInputContext_Adaptor> ();
}

static void _call_ctor_QInputContext_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ret.write<QInputContext_Adaptor *> (new QInputContext_Adaptor (arg1));
}


// QList<QAction *> QInputContext::actions()

static void _init_cbs_actions_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAction *> > ();
}

static void _call_cbs_actions_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAction *> > ((QList<QAction *>)((QInputContext_Adaptor *)cls)->cbs_actions_0_0 ());
}

static void _set_callback_cbs_actions_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_actions_0_0 = cb;
}


// void QInputContext::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QInputContext::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QInputContext::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ((QInputContext_Adaptor *)cls)->emitter_QInputContext_destroyed_1302 (arg1);
}


// void QInputContext::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// bool QInputContext::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QInputContext_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QInputContext::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QInputContext_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QInputContext::filterEvent(const QEvent *event)

static void _init_cbs_filterEvent_1912_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<const QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_filterEvent_1912_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QEvent *arg1 = args.read<const QEvent * > (heap);
  ret.write<bool > ((bool)((QInputContext_Adaptor *)cls)->cbs_filterEvent_1912_0 (arg1));
}

static void _set_callback_cbs_filterEvent_1912_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_filterEvent_1912_0 = cb;
}


// QFont QInputContext::font()

static void _init_cbs_font_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_cbs_font_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)((QInputContext_Adaptor *)cls)->cbs_font_c0_0 ());
}

static void _set_callback_cbs_font_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_font_c0_0 = cb;
}


// QString QInputContext::identifierName()

static void _init_cbs_identifierName_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_identifierName_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QInputContext_Adaptor *)cls)->cbs_identifierName_0_0 ());
}

static void _set_callback_cbs_identifierName_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_identifierName_0_0 = cb;
}


// bool QInputContext::isComposing()

static void _init_cbs_isComposing_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isComposing_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QInputContext_Adaptor *)cls)->cbs_isComposing_c0_0 ());
}

static void _set_callback_cbs_isComposing_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_isComposing_c0_0 = cb;
}


// QString QInputContext::language()

static void _init_cbs_language_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_cbs_language_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QInputContext_Adaptor *)cls)->cbs_language_0_0 ());
}

static void _set_callback_cbs_language_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_language_0_0 = cb;
}


// void QInputContext::mouseHandler(int x, QMouseEvent *event)

static void _init_cbs_mouseHandler_2397_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QMouseEvent * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_mouseHandler_2397_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  QMouseEvent *arg2 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext_Adaptor *)cls)->cbs_mouseHandler_2397_0 (arg1, arg2);
}

static void _set_callback_cbs_mouseHandler_2397_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_mouseHandler_2397_0 = cb;
}


// exposed int QInputContext::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<int > ((int)((QInputContext_Adaptor *)cls)->fp_QInputContext_receivers_c1731 (arg1));
}


// void QInputContext::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_reset_0_0 = cb;
}


// exposed QObject *QInputContext::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QInputContext_Adaptor *)cls)->fp_QInputContext_sender_c0 ());
}


// void QInputContext::setFocusWidget(QWidget *w)

static void _init_cbs_setFocusWidget_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setFocusWidget_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext_Adaptor *)cls)->cbs_setFocusWidget_1315_0 (arg1);
}

static void _set_callback_cbs_setFocusWidget_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_setFocusWidget_1315_0 = cb;
}


// void QInputContext::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QInputContext::update()

static void _init_cbs_update_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_update_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext_Adaptor *)cls)->cbs_update_0_0 ();
}

static void _set_callback_cbs_update_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_update_0_0 = cb;
}


// void QInputContext::widgetDestroyed(QWidget *w)

static void _init_cbs_widgetDestroyed_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_widgetDestroyed_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QInputContext_Adaptor *)cls)->cbs_widgetDestroyed_1315_0 (arg1);
}

static void _set_callback_cbs_widgetDestroyed_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputContext_Adaptor *)cls)->cb_widgetDestroyed_1315_0 = cb;
}


namespace gsi
{

gsi::Class<QInputContext> &qtdecl_QInputContext ();

static gsi::Methods methods_QInputContext_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QInputContext::QInputContext(QObject *parent)\nThis method creates an object of class QInputContext.", &_init_ctor_QInputContext_Adaptor_1302, &_call_ctor_QInputContext_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("actions", "@hide", false, &_init_cbs_actions_0_0, &_call_cbs_actions_0_0);
  methods += new qt_gsi::GenericMethod ("actions", "@brief Virtual method QList<QAction *> QInputContext::actions()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actions_0_0, &_call_cbs_actions_0_0, &_set_callback_cbs_actions_0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QInputContext::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QInputContext::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QInputContext::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QInputContext::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QInputContext::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QInputContext::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("filterEvent", "@hide", false, &_init_cbs_filterEvent_1912_0, &_call_cbs_filterEvent_1912_0);
  methods += new qt_gsi::GenericMethod ("filterEvent", "@brief Virtual method bool QInputContext::filterEvent(const QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_filterEvent_1912_0, &_call_cbs_filterEvent_1912_0, &_set_callback_cbs_filterEvent_1912_0);
  methods += new qt_gsi::GenericMethod ("font", "@hide", true, &_init_cbs_font_c0_0, &_call_cbs_font_c0_0);
  methods += new qt_gsi::GenericMethod ("font", "@brief Virtual method QFont QInputContext::font()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_font_c0_0, &_call_cbs_font_c0_0, &_set_callback_cbs_font_c0_0);
  methods += new qt_gsi::GenericMethod ("identifierName", "@hide", false, &_init_cbs_identifierName_0_0, &_call_cbs_identifierName_0_0);
  methods += new qt_gsi::GenericMethod ("identifierName", "@brief Virtual method QString QInputContext::identifierName()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_identifierName_0_0, &_call_cbs_identifierName_0_0, &_set_callback_cbs_identifierName_0_0);
  methods += new qt_gsi::GenericMethod ("isComposing", "@hide", true, &_init_cbs_isComposing_c0_0, &_call_cbs_isComposing_c0_0);
  methods += new qt_gsi::GenericMethod ("isComposing", "@brief Virtual method bool QInputContext::isComposing()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isComposing_c0_0, &_call_cbs_isComposing_c0_0, &_set_callback_cbs_isComposing_c0_0);
  methods += new qt_gsi::GenericMethod ("language", "@hide", false, &_init_cbs_language_0_0, &_call_cbs_language_0_0);
  methods += new qt_gsi::GenericMethod ("language", "@brief Virtual method QString QInputContext::language()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_language_0_0, &_call_cbs_language_0_0, &_set_callback_cbs_language_0_0);
  methods += new qt_gsi::GenericMethod ("mouseHandler", "@hide", false, &_init_cbs_mouseHandler_2397_0, &_call_cbs_mouseHandler_2397_0);
  methods += new qt_gsi::GenericMethod ("mouseHandler", "@brief Virtual method void QInputContext::mouseHandler(int x, QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseHandler_2397_0, &_call_cbs_mouseHandler_2397_0, &_set_callback_cbs_mouseHandler_2397_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QInputContext::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QInputContext::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QInputContext::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("setFocusWidget", "@hide", false, &_init_cbs_setFocusWidget_1315_0, &_call_cbs_setFocusWidget_1315_0);
  methods += new qt_gsi::GenericMethod ("setFocusWidget", "@brief Virtual method void QInputContext::setFocusWidget(QWidget *w)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFocusWidget_1315_0, &_call_cbs_setFocusWidget_1315_0, &_set_callback_cbs_setFocusWidget_1315_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QInputContext::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("update", "@hide", false, &_init_cbs_update_0_0, &_call_cbs_update_0_0);
  methods += new qt_gsi::GenericMethod ("update", "@brief Virtual method void QInputContext::update()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_update_0_0, &_call_cbs_update_0_0, &_set_callback_cbs_update_0_0);
  methods += new qt_gsi::GenericMethod ("widgetDestroyed", "@hide", false, &_init_cbs_widgetDestroyed_1315_0, &_call_cbs_widgetDestroyed_1315_0);
  methods += new qt_gsi::GenericMethod ("widgetDestroyed", "@brief Virtual method void QInputContext::widgetDestroyed(QWidget *w)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_widgetDestroyed_1315_0, &_call_cbs_widgetDestroyed_1315_0, &_set_callback_cbs_widgetDestroyed_1315_0);
  return methods;
}

gsi::Class<QInputContext_Adaptor> decl_QInputContext_Adaptor (qtdecl_QInputContext (), "QInputContext",
  methods_QInputContext_Adaptor (),
  "@qt\n@brief Binding of QInputContext");

}


//  Implementation of the enum wrapper class for QInputContext::StandardFormat
namespace qt_gsi
{

static gsi::Enum<QInputContext::StandardFormat> decl_QInputContext_StandardFormat_Enum ("QInputContext_StandardFormat",
    gsi::enum_const ("PreeditFormat", QInputContext::PreeditFormat, "@brief Enum constant QInputContext::PreeditFormat") +
    gsi::enum_const ("SelectionFormat", QInputContext::SelectionFormat, "@brief Enum constant QInputContext::SelectionFormat"),
  "@qt\n@brief This class represents the QInputContext::StandardFormat enum");

static gsi::QFlagsClass<QInputContext::StandardFormat > decl_QInputContext_StandardFormat_Enums ("QInputContext_QFlags_StandardFormat",
  "@qt\n@brief This class represents the QFlags<QInputContext::StandardFormat> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QInputContext> inject_QInputContext_StandardFormat_Enum_in_parent (decl_QInputContext_StandardFormat_Enum.defs ());
static gsi::ClassExt<QInputContext> decl_QInputContext_StandardFormat_Enum_as_child (decl_QInputContext_StandardFormat_Enum, "StandardFormat");
static gsi::ClassExt<QInputContext> decl_QInputContext_StandardFormat_Enums_as_child (decl_QInputContext_StandardFormat_Enums, "QFlags_StandardFormat");

}

