
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMimeSource.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMimeSource>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMimeSource

// QByteArray QMimeSource::encodedData(const char *)


static void _init_f_encodedData_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedData_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<QByteArray > ((QByteArray)((QMimeSource *)cls)->encodedData (arg1));
}


// const char *QMimeSource::format(int n)


static void _init_f_format_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("n", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<const char * > ();
}

static void _call_f_format_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? args.read<int > (heap) : (int)(0);
  ret.write<const char * > ((const char *)((QMimeSource *)cls)->format (arg1));
}


// bool QMimeSource::provides(const char *)


static void _init_f_provides_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_provides_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<bool > ((bool)((QMimeSource *)cls)->provides (arg1));
}


namespace gsi
{

static gsi::Methods methods_QMimeSource () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("encodedData", "@brief Method QByteArray QMimeSource::encodedData(const char *)\n", true, &_init_f_encodedData_c1731, &_call_f_encodedData_c1731);
  methods += new qt_gsi::GenericMethod ("format", "@brief Method const char *QMimeSource::format(int n)\n", true, &_init_f_format_c767, &_call_f_format_c767);
  methods += new qt_gsi::GenericMethod ("provides", "@brief Method bool QMimeSource::provides(const char *)\n", true, &_init_f_provides_c1731, &_call_f_provides_c1731);
  return methods;
}

gsi::Class<QMimeSource> decl_QMimeSource ("QMimeSource_Native",
  methods_QMimeSource (),
  "@hide\n@alias QMimeSource");

GSIQT_PUBLIC gsi::Class<QMimeSource> &qtdecl_QMimeSource () { return decl_QMimeSource; }

}


class QMimeSource_Adaptor : public QMimeSource, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMimeSource_Adaptor();

  //  [adaptor ctor] QMimeSource::QMimeSource()
  QMimeSource_Adaptor() : QMimeSource()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] QByteArray QMimeSource::encodedData(const char *)
  QByteArray cbs_encodedData_c1731_0(const char *arg1) const
  {
    __SUPPRESS_UNUSED_WARNING (arg1);
    throw qt_gsi::AbstractMethodCalledException("encodedData");
  }

  virtual QByteArray encodedData(const char *arg1) const
  {
    if (cb_encodedData_c1731_0.can_issue()) {
      return cb_encodedData_c1731_0.issue<QMimeSource_Adaptor, QByteArray, const char *>(&QMimeSource_Adaptor::cbs_encodedData_c1731_0, arg1);
    } else {
      throw qt_gsi::AbstractMethodCalledException("encodedData");
    }
  }

  //  [adaptor impl] const char *QMimeSource::format(int n)
  const char * cbs_format_c767_1(int n) const
  {
    __SUPPRESS_UNUSED_WARNING (n);
    throw qt_gsi::AbstractMethodCalledException("format");
  }

  virtual const char * format(int n) const
  {
    if (cb_format_c767_1.can_issue()) {
      return cb_format_c767_1.issue<QMimeSource_Adaptor, const char *, int>(&QMimeSource_Adaptor::cbs_format_c767_1, n);
    } else {
      throw qt_gsi::AbstractMethodCalledException("format");
    }
  }

  //  [adaptor impl] bool QMimeSource::provides(const char *)
  bool cbs_provides_c1731_0(const char *arg1) const
  {
    return QMimeSource::provides(arg1);
  }

  virtual bool provides(const char *arg1) const
  {
    if (cb_provides_c1731_0.can_issue()) {
      return cb_provides_c1731_0.issue<QMimeSource_Adaptor, bool, const char *>(&QMimeSource_Adaptor::cbs_provides_c1731_0, arg1);
    } else {
      return QMimeSource::provides(arg1);
    }
  }

  gsi::Callback cb_encodedData_c1731_0;
  gsi::Callback cb_format_c767_1;
  gsi::Callback cb_provides_c1731_0;
};

QMimeSource_Adaptor::~QMimeSource_Adaptor() { }

//  Constructor QMimeSource::QMimeSource() (adaptor class)

static void _init_ctor_QMimeSource_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QMimeSource_Adaptor> ();
}

static void _call_ctor_QMimeSource_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMimeSource_Adaptor *> (new QMimeSource_Adaptor ());
}


// QByteArray QMimeSource::encodedData(const char *)

static void _init_cbs_encodedData_c1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_cbs_encodedData_c1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<QByteArray > ((QByteArray)((QMimeSource_Adaptor *)cls)->cbs_encodedData_c1731_0 (arg1));
}

static void _set_callback_cbs_encodedData_c1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QMimeSource_Adaptor *)cls)->cb_encodedData_c1731_0 = cb;
}


// const char *QMimeSource::format(int n)

static void _init_cbs_format_c767_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("n");
  decl->add_arg<int > (argspec_0);
  decl->set_return<const char * > ();
}

static void _call_cbs_format_c767_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<const char * > ((const char *)((QMimeSource_Adaptor *)cls)->cbs_format_c767_1 (arg1));
}

static void _set_callback_cbs_format_c767_1 (void *cls, const gsi::Callback &cb)
{
  ((QMimeSource_Adaptor *)cls)->cb_format_c767_1 = cb;
}


// bool QMimeSource::provides(const char *)

static void _init_cbs_provides_c1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_provides_c1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<bool > ((bool)((QMimeSource_Adaptor *)cls)->cbs_provides_c1731_0 (arg1));
}

static void _set_callback_cbs_provides_c1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QMimeSource_Adaptor *)cls)->cb_provides_c1731_0 = cb;
}


namespace gsi
{

gsi::Class<QMimeSource> &qtdecl_QMimeSource ();

static gsi::Methods methods_QMimeSource_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMimeSource::QMimeSource()\nThis method creates an object of class QMimeSource.", &_init_ctor_QMimeSource_Adaptor_0, &_call_ctor_QMimeSource_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("encodedData", "@hide", true, &_init_cbs_encodedData_c1731_0, &_call_cbs_encodedData_c1731_0);
  methods += new qt_gsi::GenericMethod ("encodedData", "@brief Virtual method QByteArray QMimeSource::encodedData(const char *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_encodedData_c1731_0, &_call_cbs_encodedData_c1731_0, &_set_callback_cbs_encodedData_c1731_0);
  methods += new qt_gsi::GenericMethod ("format", "@hide", true, &_init_cbs_format_c767_1, &_call_cbs_format_c767_1);
  methods += new qt_gsi::GenericMethod ("format", "@brief Virtual method const char *QMimeSource::format(int n)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_format_c767_1, &_call_cbs_format_c767_1, &_set_callback_cbs_format_c767_1);
  methods += new qt_gsi::GenericMethod ("provides", "@hide", true, &_init_cbs_provides_c1731_0, &_call_cbs_provides_c1731_0);
  methods += new qt_gsi::GenericMethod ("provides", "@brief Virtual method bool QMimeSource::provides(const char *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_provides_c1731_0, &_call_cbs_provides_c1731_0, &_set_callback_cbs_provides_c1731_0);
  return methods;
}

gsi::Class<QMimeSource_Adaptor> decl_QMimeSource_Adaptor (qtdecl_QMimeSource (), "QMimeSource",
  methods_QMimeSource_Adaptor (),
  "@qt\n@brief Binding of QMimeSource");

}

