
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTcpServer.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTcpServer>
#include <QChildEvent>
#include <QEvent>
#include <QHostAddress>
#include <QNetworkProxy>
#include <QObject>
#include <QTcpSocket>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTcpServer

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTcpServer::staticMetaObject);
}


// void QTcpServer::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTcpServer *)cls)->close ();
}


// QString QTcpServer::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTcpServer *)cls)->errorString ());
}


// bool QTcpServer::hasPendingConnections()


static void _init_f_hasPendingConnections_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasPendingConnections_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTcpServer *)cls)->hasPendingConnections ());
}


// bool QTcpServer::isListening()


static void _init_f_isListening_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isListening_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTcpServer *)cls)->isListening ());
}


// bool QTcpServer::listen(const QHostAddress &address, quint16 port)


static void _init_f_listen_3510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("address", true, "QHostAddress::Any");
  decl->add_arg<const QHostAddress & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port", true, "0");
  decl->add_arg<quint16 > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_listen_3510 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QHostAddress &arg1 = args ? args.read<const QHostAddress & > (heap) : (const QHostAddress &)(QHostAddress::Any);
  quint16 arg2 = args ? args.read<quint16 > (heap) : (quint16)(0);
  ret.write<bool > ((bool)((QTcpServer *)cls)->listen (arg1, arg2));
}


// int QTcpServer::maxPendingConnections()


static void _init_f_maxPendingConnections_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maxPendingConnections_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTcpServer *)cls)->maxPendingConnections ());
}


// QTcpSocket *QTcpServer::nextPendingConnection()


static void _init_f_nextPendingConnection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTcpSocket * > ();
}

static void _call_f_nextPendingConnection_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTcpSocket * > ((QTcpSocket *)((QTcpServer *)cls)->nextPendingConnection ());
}


// QNetworkProxy QTcpServer::proxy()


static void _init_f_proxy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkProxy > ();
}

static void _call_f_proxy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QNetworkProxy > ((QNetworkProxy)((QTcpServer *)cls)->proxy ());
}


// QHostAddress QTcpServer::serverAddress()


static void _init_f_serverAddress_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QHostAddress > ();
}

static void _call_f_serverAddress_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QHostAddress > ((QHostAddress)((QTcpServer *)cls)->serverAddress ());
}


// QAbstractSocket::SocketError QTcpServer::serverError()


static void _init_f_serverError_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSocket::SocketError>::target_type > ();
}

static void _call_f_serverError_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractSocket::SocketError>::target_type > ((qt_gsi::Converter<QAbstractSocket::SocketError>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketError>(((QTcpServer *)cls)->serverError ()));
}


// quint16 QTcpServer::serverPort()


static void _init_f_serverPort_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<quint16 > ();
}

static void _call_f_serverPort_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<quint16 > ((quint16)((QTcpServer *)cls)->serverPort ());
}


// void QTcpServer::setMaxPendingConnections(int numConnections)


static void _init_f_setMaxPendingConnections_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("numConnections");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaxPendingConnections_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTcpServer *)cls)->setMaxPendingConnections (arg1);
}


// void QTcpServer::setProxy(const QNetworkProxy &networkProxy)


static void _init_f_setProxy_2686 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("networkProxy");
  decl->add_arg<const QNetworkProxy & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProxy_2686 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QNetworkProxy &arg1 = args.read<const QNetworkProxy & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTcpServer *)cls)->setProxy (arg1);
}


// bool QTcpServer::setSocketDescriptor(int socketDescriptor)


static void _init_f_setSocketDescriptor_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socketDescriptor");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setSocketDescriptor_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<bool > ((bool)((QTcpServer *)cls)->setSocketDescriptor (arg1));
}


// int QTcpServer::socketDescriptor()


static void _init_f_socketDescriptor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_socketDescriptor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTcpServer *)cls)->socketDescriptor ());
}


// bool QTcpServer::waitForNewConnection(int msec, bool *timedOut)


static void _init_f_waitForNewConnection_1709 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msec", true, "0");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("timedOut", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_waitForNewConnection_1709 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? args.read<int > (heap) : (int)(0);
  bool *arg2 = args ? args.read<bool * > (heap) : (bool *)(0);
  ret.write<bool > ((bool)((QTcpServer *)cls)->waitForNewConnection (arg1, arg2));
}


// static QString QTcpServer::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(0);
  ret.write<QString > ((QString)QTcpServer::tr (arg1, arg2));
}


// static QString QTcpServer::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args.read<const char * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QString > ((QString)QTcpServer::tr (arg1, arg2, arg3));
}


// static QString QTcpServer::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(0);
  ret.write<QString > ((QString)QTcpServer::trUtf8 (arg1, arg2));
}


// static QString QTcpServer::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args.read<const char * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QString > ((QString)QTcpServer::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QTcpServer () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method void QTcpServer::close()\n", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QTcpServer::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("hasPendingConnections", "@brief Method bool QTcpServer::hasPendingConnections()\n", true, &_init_f_hasPendingConnections_c0, &_call_f_hasPendingConnections_c0);
  methods += new qt_gsi::GenericMethod ("isListening?", "@brief Method bool QTcpServer::isListening()\n", true, &_init_f_isListening_c0, &_call_f_isListening_c0);
  methods += new qt_gsi::GenericMethod ("listen", "@brief Method bool QTcpServer::listen(const QHostAddress &address, quint16 port)\n", false, &_init_f_listen_3510, &_call_f_listen_3510);
  methods += new qt_gsi::GenericMethod (":maxPendingConnections", "@brief Method int QTcpServer::maxPendingConnections()\n", true, &_init_f_maxPendingConnections_c0, &_call_f_maxPendingConnections_c0);
  methods += new qt_gsi::GenericMethod ("nextPendingConnection", "@brief Method QTcpSocket *QTcpServer::nextPendingConnection()\n", false, &_init_f_nextPendingConnection_0, &_call_f_nextPendingConnection_0);
  methods += new qt_gsi::GenericMethod (":proxy", "@brief Method QNetworkProxy QTcpServer::proxy()\n", true, &_init_f_proxy_c0, &_call_f_proxy_c0);
  methods += new qt_gsi::GenericMethod ("serverAddress", "@brief Method QHostAddress QTcpServer::serverAddress()\n", true, &_init_f_serverAddress_c0, &_call_f_serverAddress_c0);
  methods += new qt_gsi::GenericMethod ("serverError", "@brief Method QAbstractSocket::SocketError QTcpServer::serverError()\n", true, &_init_f_serverError_c0, &_call_f_serverError_c0);
  methods += new qt_gsi::GenericMethod ("serverPort", "@brief Method quint16 QTcpServer::serverPort()\n", true, &_init_f_serverPort_c0, &_call_f_serverPort_c0);
  methods += new qt_gsi::GenericMethod ("setMaxPendingConnections|maxPendingConnections=", "@brief Method void QTcpServer::setMaxPendingConnections(int numConnections)\n", false, &_init_f_setMaxPendingConnections_767, &_call_f_setMaxPendingConnections_767);
  methods += new qt_gsi::GenericMethod ("setProxy|proxy=", "@brief Method void QTcpServer::setProxy(const QNetworkProxy &networkProxy)\n", false, &_init_f_setProxy_2686, &_call_f_setProxy_2686);
  methods += new qt_gsi::GenericMethod ("setSocketDescriptor", "@brief Method bool QTcpServer::setSocketDescriptor(int socketDescriptor)\n", false, &_init_f_setSocketDescriptor_767, &_call_f_setSocketDescriptor_767);
  methods += new qt_gsi::GenericMethod ("socketDescriptor", "@brief Method int QTcpServer::socketDescriptor()\n", true, &_init_f_socketDescriptor_c0, &_call_f_socketDescriptor_c0);
  methods += new qt_gsi::GenericMethod ("waitForNewConnection", "@brief Method bool QTcpServer::waitForNewConnection(int msec, bool *timedOut)\n", false, &_init_f_waitForNewConnection_1709, &_call_f_waitForNewConnection_1709);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QTcpServer::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("newConnection()", "newConnection", "@brief Signal declaration for QTcpServer::newConnection()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTcpServer::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTcpServer::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTcpServer::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTcpServer::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QTcpServer> decl_QTcpServer (qtdecl_QObject (), "QTcpServer_Native",
  methods_QTcpServer (),
  "@hide\n@alias QTcpServer");

GSIQT_PUBLIC gsi::Class<QTcpServer> &qtdecl_QTcpServer () { return decl_QTcpServer; }

}


class QTcpServer_Adaptor : public QTcpServer, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTcpServer_Adaptor();

  //  [adaptor ctor] QTcpServer::QTcpServer(QObject *parent)
  QTcpServer_Adaptor() : QTcpServer()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTcpServer::QTcpServer(QObject *parent)
  QTcpServer_Adaptor(QObject *parent) : QTcpServer(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QTcpServer::receivers(const char *signal)
  int fp_QTcpServer_receivers_c1731 (const char *signal) const {
    return QTcpServer::receivers(signal);
  }

  //  [expose] QObject *QTcpServer::sender()
  QObject * fp_QTcpServer_sender_c0 () const {
    return QTcpServer::sender();
  }

  //  [adaptor impl] bool QTcpServer::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QTcpServer::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTcpServer_Adaptor, bool, QEvent *>(&QTcpServer_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QTcpServer::event(arg1);
    }
  }

  //  [adaptor impl] bool QTcpServer::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QTcpServer::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTcpServer_Adaptor, bool, QObject *, QEvent *>(&QTcpServer_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QTcpServer::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QTcpServer::hasPendingConnections()
  bool cbs_hasPendingConnections_c0_0() const
  {
    return QTcpServer::hasPendingConnections();
  }

  virtual bool hasPendingConnections() const
  {
    if (cb_hasPendingConnections_c0_0.can_issue()) {
      return cb_hasPendingConnections_c0_0.issue<QTcpServer_Adaptor, bool>(&QTcpServer_Adaptor::cbs_hasPendingConnections_c0_0);
    } else {
      return QTcpServer::hasPendingConnections();
    }
  }

  //  [adaptor impl] QTcpSocket *QTcpServer::nextPendingConnection()
  QTcpSocket * cbs_nextPendingConnection_0_0()
  {
    return QTcpServer::nextPendingConnection();
  }

  virtual QTcpSocket * nextPendingConnection()
  {
    if (cb_nextPendingConnection_0_0.can_issue()) {
      return cb_nextPendingConnection_0_0.issue<QTcpServer_Adaptor, QTcpSocket *>(&QTcpServer_Adaptor::cbs_nextPendingConnection_0_0);
    } else {
      return QTcpServer::nextPendingConnection();
    }
  }

  //  [adaptor impl] void QTcpServer::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QTcpServer::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTcpServer_Adaptor, QChildEvent *>(&QTcpServer_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QTcpServer::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QTcpServer::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QTcpServer::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTcpServer_Adaptor, QEvent *>(&QTcpServer_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QTcpServer::customEvent(arg1);
    }
  }

  //  [emitter impl] void QTcpServer::destroyed(QObject *)
  void emitter_QTcpServer_destroyed_1302(QObject *arg1)
  {
    emit QTcpServer::destroyed(arg1);
  }

  //  [adaptor impl] void QTcpServer::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QTcpServer::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QTcpServer_Adaptor, const char *>(&QTcpServer_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QTcpServer::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QTcpServer::incomingConnection(int handle)
  void cbs_incomingConnection_767_0(int handle)
  {
    QTcpServer::incomingConnection(handle);
  }

  virtual void incomingConnection(int handle)
  {
    if (cb_incomingConnection_767_0.can_issue()) {
      cb_incomingConnection_767_0.issue<QTcpServer_Adaptor, int>(&QTcpServer_Adaptor::cbs_incomingConnection_767_0, handle);
    } else {
      QTcpServer::incomingConnection(handle);
    }
  }

  //  [emitter impl] void QTcpServer::newConnection()
  void emitter_QTcpServer_newConnection_0()
  {
    emit QTcpServer::newConnection();
  }

  //  [adaptor impl] void QTcpServer::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QTcpServer::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTcpServer_Adaptor, QTimerEvent *>(&QTcpServer_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QTcpServer::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_hasPendingConnections_c0_0;
  gsi::Callback cb_nextPendingConnection_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_incomingConnection_767_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QTcpServer_Adaptor::~QTcpServer_Adaptor() { }

//  Constructor QTcpServer::QTcpServer(QObject *parent) (adaptor class)

static void _init_ctor_QTcpServer_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QTcpServer_Adaptor> ();
}

static void _call_ctor_QTcpServer_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ret.write<QTcpServer_Adaptor *> (new QTcpServer_Adaptor (arg1));
}


// void QTcpServer::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTcpServer_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTcpServer_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QTcpServer::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTcpServer_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTcpServer_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QTcpServer::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ((QTcpServer_Adaptor *)cls)->emitter_QTcpServer_destroyed_1302 (arg1);
}


// void QTcpServer::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTcpServer_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QTcpServer_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// bool QTcpServer::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTcpServer_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTcpServer_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QTcpServer::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTcpServer_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTcpServer_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QTcpServer::hasPendingConnections()

static void _init_cbs_hasPendingConnections_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasPendingConnections_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTcpServer_Adaptor *)cls)->cbs_hasPendingConnections_c0_0 ());
}

static void _set_callback_cbs_hasPendingConnections_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTcpServer_Adaptor *)cls)->cb_hasPendingConnections_c0_0 = cb;
}


// void QTcpServer::incomingConnection(int handle)

static void _init_cbs_incomingConnection_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handle");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_incomingConnection_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTcpServer_Adaptor *)cls)->cbs_incomingConnection_767_0 (arg1);
}

static void _set_callback_cbs_incomingConnection_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTcpServer_Adaptor *)cls)->cb_incomingConnection_767_0 = cb;
}


// emitter void QTcpServer::newConnection()

static void _init_emitter_newConnection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_newConnection_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTcpServer_Adaptor *)cls)->emitter_QTcpServer_newConnection_0 ();
}


// QTcpSocket *QTcpServer::nextPendingConnection()

static void _init_cbs_nextPendingConnection_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTcpSocket * > ();
}

static void _call_cbs_nextPendingConnection_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTcpSocket * > ((QTcpSocket *)((QTcpServer_Adaptor *)cls)->cbs_nextPendingConnection_0_0 ());
}

static void _set_callback_cbs_nextPendingConnection_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTcpServer_Adaptor *)cls)->cb_nextPendingConnection_0_0 = cb;
}


// exposed int QTcpServer::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<int > ((int)((QTcpServer_Adaptor *)cls)->fp_QTcpServer_receivers_c1731 (arg1));
}


// exposed QObject *QTcpServer::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QTcpServer_Adaptor *)cls)->fp_QTcpServer_sender_c0 ());
}


// void QTcpServer::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTcpServer_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTcpServer_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QTcpServer> &qtdecl_QTcpServer ();

static gsi::Methods methods_QTcpServer_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTcpServer::QTcpServer(QObject *parent)\nThis method creates an object of class QTcpServer.", &_init_ctor_QTcpServer_Adaptor_1302, &_call_ctor_QTcpServer_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTcpServer::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTcpServer::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QTcpServer::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTcpServer::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QTcpServer::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTcpServer::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("hasPendingConnections", "@hide", true, &_init_cbs_hasPendingConnections_c0_0, &_call_cbs_hasPendingConnections_c0_0);
  methods += new qt_gsi::GenericMethod ("hasPendingConnections", "@brief Virtual method bool QTcpServer::hasPendingConnections()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasPendingConnections_c0_0, &_call_cbs_hasPendingConnections_c0_0, &_set_callback_cbs_hasPendingConnections_c0_0);
  methods += new qt_gsi::GenericMethod ("*incomingConnection", "@hide", false, &_init_cbs_incomingConnection_767_0, &_call_cbs_incomingConnection_767_0);
  methods += new qt_gsi::GenericMethod ("*incomingConnection", "@brief Virtual method void QTcpServer::incomingConnection(int handle)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_incomingConnection_767_0, &_call_cbs_incomingConnection_767_0, &_set_callback_cbs_incomingConnection_767_0);
  methods += new qt_gsi::GenericMethod ("emit_newConnection", "@brief Emitter for signal void QTcpServer::newConnection()\nCall this method to emit this signal.", false, &_init_emitter_newConnection_0, &_call_emitter_newConnection_0);
  methods += new qt_gsi::GenericMethod ("nextPendingConnection", "@hide", false, &_init_cbs_nextPendingConnection_0_0, &_call_cbs_nextPendingConnection_0_0);
  methods += new qt_gsi::GenericMethod ("nextPendingConnection", "@brief Virtual method QTcpSocket *QTcpServer::nextPendingConnection()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nextPendingConnection_0_0, &_call_cbs_nextPendingConnection_0_0, &_set_callback_cbs_nextPendingConnection_0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QTcpServer::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QTcpServer::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTcpServer::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QTcpServer_Adaptor> decl_QTcpServer_Adaptor (qtdecl_QTcpServer (), "QTcpServer",
  methods_QTcpServer_Adaptor (),
  "@qt\n@brief Binding of QTcpServer");

}

