
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextDocument.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTextDocument>
#include <QAbstractTextDocumentLayout>
#include <QChildEvent>
#include <QEvent>
#include <QFont>
#include <QObject>
#include <QPainter>
#include <QPrinter>
#include <QRectF>
#include <QRegExp>
#include <QSizeF>
#include <QTextBlock>
#include <QTextCursor>
#include <QTextFormat>
#include <QTextFrame>
#include <QTextObject>
#include <QTextOption>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextDocument

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTextDocument::staticMetaObject);
}


// void QTextDocument::addResource(int type, const QUrl &name, const QVariant &resource)


static void _init_f_addResource_4371 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QUrl & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("resource");
  decl->add_arg<const QVariant & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addResource_4371 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QUrl &arg2 = args.read<const QUrl & > (heap);
  const QVariant &arg3 = args.read<const QVariant & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->addResource (arg1, arg2, arg3);
}


// void QTextDocument::adjustSize()


static void _init_f_adjustSize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_adjustSize_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->adjustSize ();
}


// QVector<QTextFormat> QTextDocument::allFormats()


static void _init_f_allFormats_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVector<QTextFormat> > ();
}

static void _call_f_allFormats_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVector<QTextFormat> > ((QVector<QTextFormat>)((QTextDocument *)cls)->allFormats ());
}


// int QTextDocument::availableRedoSteps()


static void _init_f_availableRedoSteps_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_availableRedoSteps_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextDocument *)cls)->availableRedoSteps ());
}


// int QTextDocument::availableUndoSteps()


static void _init_f_availableUndoSteps_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_availableUndoSteps_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextDocument *)cls)->availableUndoSteps ());
}


// QTextBlock QTextDocument::begin()


static void _init_f_begin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlock > ();
}

static void _call_f_begin_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->begin ());
}


// int QTextDocument::blockCount()


static void _init_f_blockCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_blockCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextDocument *)cls)->blockCount ());
}


// QChar QTextDocument::characterAt(int pos)


static void _init_f_characterAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_characterAt_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QTextDocument *)cls)->characterAt (arg1)));
}


// int QTextDocument::characterCount()


static void _init_f_characterCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_characterCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextDocument *)cls)->characterCount ());
}


// void QTextDocument::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->clear ();
}


// QTextDocument *QTextDocument::clone(QObject *parent)


static void _init_f_clone_c1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<QTextDocument * > ();
}

static void _call_f_clone_c1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ret.write<QTextDocument * > ((QTextDocument *)((QTextDocument *)cls)->clone (arg1));
}


// QFont QTextDocument::defaultFont()


static void _init_f_defaultFont_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_defaultFont_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)((QTextDocument *)cls)->defaultFont ());
}


// QString QTextDocument::defaultStyleSheet()


static void _init_f_defaultStyleSheet_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_defaultStyleSheet_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextDocument *)cls)->defaultStyleSheet ());
}


// QTextOption QTextDocument::defaultTextOption()


static void _init_f_defaultTextOption_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextOption > ();
}

static void _call_f_defaultTextOption_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextOption > ((QTextOption)((QTextDocument *)cls)->defaultTextOption ());
}


// QAbstractTextDocumentLayout *QTextDocument::documentLayout()


static void _init_f_documentLayout_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractTextDocumentLayout * > ();
}

static void _call_f_documentLayout_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractTextDocumentLayout * > ((QAbstractTextDocumentLayout *)((QTextDocument *)cls)->documentLayout ());
}


// double QTextDocument::documentMargin()


static void _init_f_documentMargin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_documentMargin_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTextDocument *)cls)->documentMargin ());
}


// void QTextDocument::drawContents(QPainter *painter, const QRectF &rect)


static void _init_f_drawContents_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawContents_3180 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRectF &arg2 = args ? args.read<const QRectF & > (heap) : (const QRectF &)(QRectF());
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->drawContents (arg1, arg2);
}


// QTextBlock QTextDocument::end()


static void _init_f_end_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlock > ();
}

static void _call_f_end_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->end ());
}


// QTextCursor QTextDocument::find(const QString &subString, int from, QFlags<QTextDocument::FindFlag> options)


static void _init_f_find_c5920 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("subString");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("from", true, "0");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("options", true, "0");
  decl->add_arg<QFlags<QTextDocument::FindFlag> > (argspec_2);
  decl->set_return<QTextCursor > ();
}

static void _call_f_find_c5920 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  int arg2 = args ? args.read<int > (heap) : (int)(0);
  QFlags<QTextDocument::FindFlag> arg3 = args ? args.read<QFlags<QTextDocument::FindFlag> > (heap) : (QFlags<QTextDocument::FindFlag>)(0);
  ret.write<QTextCursor > ((QTextCursor)((QTextDocument *)cls)->find (arg1, arg2, arg3));
}


// QTextCursor QTextDocument::find(const QString &subString, const QTextCursor &from, QFlags<QTextDocument::FindFlag> options)


static void _init_f_find_c7606 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("subString");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("from");
  decl->add_arg<const QTextCursor & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("options", true, "0");
  decl->add_arg<QFlags<QTextDocument::FindFlag> > (argspec_2);
  decl->set_return<QTextCursor > ();
}

static void _call_f_find_c7606 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const QTextCursor &arg2 = args.read<const QTextCursor & > (heap);
  QFlags<QTextDocument::FindFlag> arg3 = args ? args.read<QFlags<QTextDocument::FindFlag> > (heap) : (QFlags<QTextDocument::FindFlag>)(0);
  ret.write<QTextCursor > ((QTextCursor)((QTextDocument *)cls)->find (arg1, arg2, arg3));
}


// QTextCursor QTextDocument::find(const QRegExp &expr, int from, QFlags<QTextDocument::FindFlag> options)


static void _init_f_find_c5876 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("expr");
  decl->add_arg<const QRegExp & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("from", true, "0");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("options", true, "0");
  decl->add_arg<QFlags<QTextDocument::FindFlag> > (argspec_2);
  decl->set_return<QTextCursor > ();
}

static void _call_f_find_c5876 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegExp &arg1 = args.read<const QRegExp & > (heap);
  int arg2 = args ? args.read<int > (heap) : (int)(0);
  QFlags<QTextDocument::FindFlag> arg3 = args ? args.read<QFlags<QTextDocument::FindFlag> > (heap) : (QFlags<QTextDocument::FindFlag>)(0);
  ret.write<QTextCursor > ((QTextCursor)((QTextDocument *)cls)->find (arg1, arg2, arg3));
}


// QTextCursor QTextDocument::find(const QRegExp &expr, const QTextCursor &from, QFlags<QTextDocument::FindFlag> options)


static void _init_f_find_c7562 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("expr");
  decl->add_arg<const QRegExp & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("from");
  decl->add_arg<const QTextCursor & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("options", true, "0");
  decl->add_arg<QFlags<QTextDocument::FindFlag> > (argspec_2);
  decl->set_return<QTextCursor > ();
}

static void _call_f_find_c7562 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegExp &arg1 = args.read<const QRegExp & > (heap);
  const QTextCursor &arg2 = args.read<const QTextCursor & > (heap);
  QFlags<QTextDocument::FindFlag> arg3 = args ? args.read<QFlags<QTextDocument::FindFlag> > (heap) : (QFlags<QTextDocument::FindFlag>)(0);
  ret.write<QTextCursor > ((QTextCursor)((QTextDocument *)cls)->find (arg1, arg2, arg3));
}


// QTextBlock QTextDocument::findBlock(int pos)


static void _init_f_findBlock_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextBlock > ();
}

static void _call_f_findBlock_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->findBlock (arg1));
}


// QTextBlock QTextDocument::findBlockByLineNumber(int blockNumber)


static void _init_f_findBlockByLineNumber_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("blockNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextBlock > ();
}

static void _call_f_findBlockByLineNumber_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->findBlockByLineNumber (arg1));
}


// QTextBlock QTextDocument::findBlockByNumber(int blockNumber)


static void _init_f_findBlockByNumber_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("blockNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextBlock > ();
}

static void _call_f_findBlockByNumber_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->findBlockByNumber (arg1));
}


// QTextBlock QTextDocument::firstBlock()


static void _init_f_firstBlock_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlock > ();
}

static void _call_f_firstBlock_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->firstBlock ());
}


// QTextFrame *QTextDocument::frameAt(int pos)


static void _init_f_frameAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextFrame * > ();
}

static void _call_f_frameAt_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QTextFrame * > ((QTextFrame *)((QTextDocument *)cls)->frameAt (arg1));
}


// double QTextDocument::idealWidth()


static void _init_f_idealWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_idealWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTextDocument *)cls)->idealWidth ());
}


// double QTextDocument::indentWidth()


static void _init_f_indentWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_indentWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTextDocument *)cls)->indentWidth ());
}


// bool QTextDocument::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextDocument *)cls)->isEmpty ());
}


// bool QTextDocument::isModified()


static void _init_f_isModified_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isModified_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextDocument *)cls)->isModified ());
}


// bool QTextDocument::isRedoAvailable()


static void _init_f_isRedoAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRedoAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextDocument *)cls)->isRedoAvailable ());
}


// bool QTextDocument::isUndoAvailable()


static void _init_f_isUndoAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isUndoAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextDocument *)cls)->isUndoAvailable ());
}


// bool QTextDocument::isUndoRedoEnabled()


static void _init_f_isUndoRedoEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isUndoRedoEnabled_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextDocument *)cls)->isUndoRedoEnabled ());
}


// QTextBlock QTextDocument::lastBlock()


static void _init_f_lastBlock_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlock > ();
}

static void _call_f_lastBlock_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->lastBlock ());
}


// int QTextDocument::lineCount()


static void _init_f_lineCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_lineCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextDocument *)cls)->lineCount ());
}


// void QTextDocument::markContentsDirty(int from, int length)


static void _init_f_markContentsDirty_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("length");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_markContentsDirty_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->markContentsDirty (arg1, arg2);
}


// int QTextDocument::maximumBlockCount()


static void _init_f_maximumBlockCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumBlockCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextDocument *)cls)->maximumBlockCount ());
}


// QString QTextDocument::metaInformation(QTextDocument::MetaInformation info)


static void _init_f_metaInformation_c3434 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("info");
  decl->add_arg<const qt_gsi::Converter<QTextDocument::MetaInformation>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_metaInformation_c3434 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextDocument::MetaInformation>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextDocument::MetaInformation>::target_type & > (heap);
  ret.write<QString > ((QString)((QTextDocument *)cls)->metaInformation (qt_gsi::QtToCppAdaptor<QTextDocument::MetaInformation>(arg1).cref()));
}


// QTextObject *QTextDocument::object(int objectIndex)


static void _init_f_object_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextObject * > ();
}

static void _call_f_object_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QTextObject * > ((QTextObject *)((QTextDocument *)cls)->object (arg1));
}


// QTextObject *QTextDocument::objectForFormat(const QTextFormat &)


static void _init_f_objectForFormat_c2432 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTextFormat & > (argspec_0);
  decl->set_return<QTextObject * > ();
}

static void _call_f_objectForFormat_c2432 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextFormat &arg1 = args.read<const QTextFormat & > (heap);
  ret.write<QTextObject * > ((QTextObject *)((QTextDocument *)cls)->objectForFormat (arg1));
}


// int QTextDocument::pageCount()


static void _init_f_pageCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_pageCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextDocument *)cls)->pageCount ());
}


// QSizeF QTextDocument::pageSize()


static void _init_f_pageSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_pageSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QTextDocument *)cls)->pageSize ());
}


// void QTextDocument::print(QPrinter *printer)


static void _init_f_print_c1443 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("printer");
  decl->add_arg<QPrinter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_print_c1443 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPrinter *arg1 = args.read<QPrinter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->print (arg1);
}


// void QTextDocument::redo(QTextCursor *cursor)


static void _init_f_redo_1762 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<QTextCursor * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_redo_1762 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextCursor *arg1 = args.read<QTextCursor * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->redo (arg1);
}


// void QTextDocument::redo()


static void _init_f_redo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_redo_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->redo ();
}


// QVariant QTextDocument::resource(int type, const QUrl &name)


static void _init_f_resource_c2360 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_resource_c2360 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QUrl &arg2 = args.read<const QUrl & > (heap);
  ret.write<QVariant > ((QVariant)((QTextDocument *)cls)->resource (arg1, arg2));
}


// int QTextDocument::revision()


static void _init_f_revision_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_revision_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextDocument *)cls)->revision ());
}


// QTextFrame *QTextDocument::rootFrame()


static void _init_f_rootFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextFrame * > ();
}

static void _call_f_rootFrame_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextFrame * > ((QTextFrame *)((QTextDocument *)cls)->rootFrame ());
}


// void QTextDocument::setDefaultFont(const QFont &font)


static void _init_f_setDefaultFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultFont_1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setDefaultFont (arg1);
}


// void QTextDocument::setDefaultStyleSheet(const QString &sheet)


static void _init_f_setDefaultStyleSheet_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sheet");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultStyleSheet_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setDefaultStyleSheet (arg1);
}


// void QTextDocument::setDefaultTextOption(const QTextOption &option)


static void _init_f_setDefaultTextOption_2448 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QTextOption & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultTextOption_2448 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextOption &arg1 = args.read<const QTextOption & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setDefaultTextOption (arg1);
}


// void QTextDocument::setDocumentLayout(QAbstractTextDocumentLayout *layout)


static void _init_f_setDocumentLayout_3413 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QAbstractTextDocumentLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocumentLayout_3413 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractTextDocumentLayout *arg1 = args.read<QAbstractTextDocumentLayout * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setDocumentLayout (arg1);
}


// void QTextDocument::setDocumentMargin(double margin)


static void _init_f_setDocumentMargin_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margin");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocumentMargin_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setDocumentMargin (arg1);
}


// void QTextDocument::setHtml(const QString &html)


static void _init_f_setHtml_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("html");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHtml_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setHtml (arg1);
}


// void QTextDocument::setIndentWidth(double width)


static void _init_f_setIndentWidth_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIndentWidth_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setIndentWidth (arg1);
}


// void QTextDocument::setMaximumBlockCount(int maximum)


static void _init_f_setMaximumBlockCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maximum");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumBlockCount_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setMaximumBlockCount (arg1);
}


// void QTextDocument::setMetaInformation(QTextDocument::MetaInformation info, const QString &)


static void _init_f_setMetaInformation_5351 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("info");
  decl->add_arg<const qt_gsi::Converter<QTextDocument::MetaInformation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMetaInformation_5351 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextDocument::MetaInformation>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextDocument::MetaInformation>::target_type & > (heap);
  const QString &arg2 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setMetaInformation (qt_gsi::QtToCppAdaptor<QTextDocument::MetaInformation>(arg1).cref(), arg2);
}


// void QTextDocument::setModified(bool m)


static void _init_f_setModified_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModified_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? args.read<bool > (heap) : (bool)(true);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setModified (arg1);
}


// void QTextDocument::setPageSize(const QSizeF &size)


static void _init_f_setPageSize_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPageSize_1875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = args.read<const QSizeF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setPageSize (arg1);
}


// void QTextDocument::setPlainText(const QString &text)


static void _init_f_setPlainText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlainText_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setPlainText (arg1);
}


// void QTextDocument::setTextWidth(double width)


static void _init_f_setTextWidth_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextWidth_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setTextWidth (arg1);
}


// void QTextDocument::setUndoRedoEnabled(bool enable)


static void _init_f_setUndoRedoEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUndoRedoEnabled_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setUndoRedoEnabled (arg1);
}


// void QTextDocument::setUseDesignMetrics(bool b)


static void _init_f_setUseDesignMetrics_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUseDesignMetrics_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->setUseDesignMetrics (arg1);
}


// QSizeF QTextDocument::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QTextDocument *)cls)->size ());
}


// double QTextDocument::textWidth()


static void _init_f_textWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_textWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTextDocument *)cls)->textWidth ());
}


// QString QTextDocument::toHtml(const QByteArray &encoding)


static void _init_f_toHtml_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("encoding", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toHtml_c2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args ? args.read<const QByteArray & > (heap) : (const QByteArray &)(QByteArray());
  ret.write<QString > ((QString)((QTextDocument *)cls)->toHtml (arg1));
}


// QString QTextDocument::toPlainText()


static void _init_f_toPlainText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toPlainText_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextDocument *)cls)->toPlainText ());
}


// void QTextDocument::undo(QTextCursor *cursor)


static void _init_f_undo_1762 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<QTextCursor * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_undo_1762 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextCursor *arg1 = args.read<QTextCursor * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->undo (arg1);
}


// void QTextDocument::undo()


static void _init_f_undo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_undo_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument *)cls)->undo ();
}


// bool QTextDocument::useDesignMetrics()


static void _init_f_useDesignMetrics_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_useDesignMetrics_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextDocument *)cls)->useDesignMetrics ());
}


// static QString QTextDocument::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(0);
  ret.write<QString > ((QString)QTextDocument::tr (arg1, arg2));
}


// static QString QTextDocument::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args.read<const char * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QString > ((QString)QTextDocument::tr (arg1, arg2, arg3));
}


// static QString QTextDocument::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(0);
  ret.write<QString > ((QString)QTextDocument::trUtf8 (arg1, arg2));
}


// static QString QTextDocument::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args.read<const char * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<QString > ((QString)QTextDocument::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QTextDocument () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addResource", "@brief Method void QTextDocument::addResource(int type, const QUrl &name, const QVariant &resource)\n", false, &_init_f_addResource_4371, &_call_f_addResource_4371);
  methods += new qt_gsi::GenericMethod ("adjustSize", "@brief Method void QTextDocument::adjustSize()\n", false, &_init_f_adjustSize_0, &_call_f_adjustSize_0);
  methods += new qt_gsi::GenericMethod ("allFormats", "@brief Method QVector<QTextFormat> QTextDocument::allFormats()\n", true, &_init_f_allFormats_c0, &_call_f_allFormats_c0);
  methods += new qt_gsi::GenericMethod ("availableRedoSteps", "@brief Method int QTextDocument::availableRedoSteps()\n", true, &_init_f_availableRedoSteps_c0, &_call_f_availableRedoSteps_c0);
  methods += new qt_gsi::GenericMethod ("availableUndoSteps", "@brief Method int QTextDocument::availableUndoSteps()\n", true, &_init_f_availableUndoSteps_c0, &_call_f_availableUndoSteps_c0);
  methods += new qt_gsi::GenericMethod ("begin", "@brief Method QTextBlock QTextDocument::begin()\n", true, &_init_f_begin_c0, &_call_f_begin_c0);
  methods += new qt_gsi::GenericMethod (":blockCount", "@brief Method int QTextDocument::blockCount()\n", true, &_init_f_blockCount_c0, &_call_f_blockCount_c0);
  methods += new qt_gsi::GenericMethod ("characterAt", "@brief Method QChar QTextDocument::characterAt(int pos)\n", true, &_init_f_characterAt_c767, &_call_f_characterAt_c767);
  methods += new qt_gsi::GenericMethod ("characterCount", "@brief Method int QTextDocument::characterCount()\n", true, &_init_f_characterCount_c0, &_call_f_characterCount_c0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QTextDocument::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("clone", "@brief Method QTextDocument *QTextDocument::clone(QObject *parent)\n", true, &_init_f_clone_c1302, &_call_f_clone_c1302);
  methods += new qt_gsi::GenericMethod (":defaultFont", "@brief Method QFont QTextDocument::defaultFont()\n", true, &_init_f_defaultFont_c0, &_call_f_defaultFont_c0);
  methods += new qt_gsi::GenericMethod (":defaultStyleSheet", "@brief Method QString QTextDocument::defaultStyleSheet()\n", true, &_init_f_defaultStyleSheet_c0, &_call_f_defaultStyleSheet_c0);
  methods += new qt_gsi::GenericMethod (":defaultTextOption", "@brief Method QTextOption QTextDocument::defaultTextOption()\n", true, &_init_f_defaultTextOption_c0, &_call_f_defaultTextOption_c0);
  methods += new qt_gsi::GenericMethod (":documentLayout", "@brief Method QAbstractTextDocumentLayout *QTextDocument::documentLayout()\n", true, &_init_f_documentLayout_c0, &_call_f_documentLayout_c0);
  methods += new qt_gsi::GenericMethod (":documentMargin", "@brief Method double QTextDocument::documentMargin()\n", true, &_init_f_documentMargin_c0, &_call_f_documentMargin_c0);
  methods += new qt_gsi::GenericMethod ("drawContents", "@brief Method void QTextDocument::drawContents(QPainter *painter, const QRectF &rect)\n", false, &_init_f_drawContents_3180, &_call_f_drawContents_3180);
  methods += new qt_gsi::GenericMethod ("end", "@brief Method QTextBlock QTextDocument::end()\n", true, &_init_f_end_c0, &_call_f_end_c0);
  methods += new qt_gsi::GenericMethod ("find", "@brief Method QTextCursor QTextDocument::find(const QString &subString, int from, QFlags<QTextDocument::FindFlag> options)\n", true, &_init_f_find_c5920, &_call_f_find_c5920);
  methods += new qt_gsi::GenericMethod ("find", "@brief Method QTextCursor QTextDocument::find(const QString &subString, const QTextCursor &from, QFlags<QTextDocument::FindFlag> options)\n", true, &_init_f_find_c7606, &_call_f_find_c7606);
  methods += new qt_gsi::GenericMethod ("find", "@brief Method QTextCursor QTextDocument::find(const QRegExp &expr, int from, QFlags<QTextDocument::FindFlag> options)\n", true, &_init_f_find_c5876, &_call_f_find_c5876);
  methods += new qt_gsi::GenericMethod ("find", "@brief Method QTextCursor QTextDocument::find(const QRegExp &expr, const QTextCursor &from, QFlags<QTextDocument::FindFlag> options)\n", true, &_init_f_find_c7562, &_call_f_find_c7562);
  methods += new qt_gsi::GenericMethod ("findBlock", "@brief Method QTextBlock QTextDocument::findBlock(int pos)\n", true, &_init_f_findBlock_c767, &_call_f_findBlock_c767);
  methods += new qt_gsi::GenericMethod ("findBlockByLineNumber", "@brief Method QTextBlock QTextDocument::findBlockByLineNumber(int blockNumber)\n", true, &_init_f_findBlockByLineNumber_c767, &_call_f_findBlockByLineNumber_c767);
  methods += new qt_gsi::GenericMethod ("findBlockByNumber", "@brief Method QTextBlock QTextDocument::findBlockByNumber(int blockNumber)\n", true, &_init_f_findBlockByNumber_c767, &_call_f_findBlockByNumber_c767);
  methods += new qt_gsi::GenericMethod ("firstBlock", "@brief Method QTextBlock QTextDocument::firstBlock()\n", true, &_init_f_firstBlock_c0, &_call_f_firstBlock_c0);
  methods += new qt_gsi::GenericMethod ("frameAt", "@brief Method QTextFrame *QTextDocument::frameAt(int pos)\n", true, &_init_f_frameAt_c767, &_call_f_frameAt_c767);
  methods += new qt_gsi::GenericMethod ("idealWidth", "@brief Method double QTextDocument::idealWidth()\n", true, &_init_f_idealWidth_c0, &_call_f_idealWidth_c0);
  methods += new qt_gsi::GenericMethod (":indentWidth", "@brief Method double QTextDocument::indentWidth()\n", true, &_init_f_indentWidth_c0, &_call_f_indentWidth_c0);
  methods += new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QTextDocument::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
  methods += new qt_gsi::GenericMethod ("isModified?|:modified", "@brief Method bool QTextDocument::isModified()\n", true, &_init_f_isModified_c0, &_call_f_isModified_c0);
  methods += new qt_gsi::GenericMethod ("isRedoAvailable?", "@brief Method bool QTextDocument::isRedoAvailable()\n", true, &_init_f_isRedoAvailable_c0, &_call_f_isRedoAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isUndoAvailable?", "@brief Method bool QTextDocument::isUndoAvailable()\n", true, &_init_f_isUndoAvailable_c0, &_call_f_isUndoAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isUndoRedoEnabled?|:undoRedoEnabled", "@brief Method bool QTextDocument::isUndoRedoEnabled()\n", true, &_init_f_isUndoRedoEnabled_c0, &_call_f_isUndoRedoEnabled_c0);
  methods += new qt_gsi::GenericMethod ("lastBlock", "@brief Method QTextBlock QTextDocument::lastBlock()\n", true, &_init_f_lastBlock_c0, &_call_f_lastBlock_c0);
  methods += new qt_gsi::GenericMethod ("lineCount", "@brief Method int QTextDocument::lineCount()\n", true, &_init_f_lineCount_c0, &_call_f_lineCount_c0);
  methods += new qt_gsi::GenericMethod ("markContentsDirty", "@brief Method void QTextDocument::markContentsDirty(int from, int length)\n", false, &_init_f_markContentsDirty_1426, &_call_f_markContentsDirty_1426);
  methods += new qt_gsi::GenericMethod (":maximumBlockCount", "@brief Method int QTextDocument::maximumBlockCount()\n", true, &_init_f_maximumBlockCount_c0, &_call_f_maximumBlockCount_c0);
  methods += new qt_gsi::GenericMethod ("metaInformation", "@brief Method QString QTextDocument::metaInformation(QTextDocument::MetaInformation info)\n", true, &_init_f_metaInformation_c3434, &_call_f_metaInformation_c3434);
  methods += new qt_gsi::GenericMethod ("object", "@brief Method QTextObject *QTextDocument::object(int objectIndex)\n", true, &_init_f_object_c767, &_call_f_object_c767);
  methods += new qt_gsi::GenericMethod ("objectForFormat", "@brief Method QTextObject *QTextDocument::objectForFormat(const QTextFormat &)\n", true, &_init_f_objectForFormat_c2432, &_call_f_objectForFormat_c2432);
  methods += new qt_gsi::GenericMethod ("pageCount", "@brief Method int QTextDocument::pageCount()\n", true, &_init_f_pageCount_c0, &_call_f_pageCount_c0);
  methods += new qt_gsi::GenericMethod (":pageSize", "@brief Method QSizeF QTextDocument::pageSize()\n", true, &_init_f_pageSize_c0, &_call_f_pageSize_c0);
  methods += new qt_gsi::GenericMethod ("print", "@brief Method void QTextDocument::print(QPrinter *printer)\n", true, &_init_f_print_c1443, &_call_f_print_c1443);
  methods += new qt_gsi::GenericMethod ("redo", "@brief Method void QTextDocument::redo(QTextCursor *cursor)\n", false, &_init_f_redo_1762, &_call_f_redo_1762);
  methods += new qt_gsi::GenericMethod ("redo", "@brief Method void QTextDocument::redo()\n", false, &_init_f_redo_0, &_call_f_redo_0);
  methods += new qt_gsi::GenericMethod ("resource", "@brief Method QVariant QTextDocument::resource(int type, const QUrl &name)\n", true, &_init_f_resource_c2360, &_call_f_resource_c2360);
  methods += new qt_gsi::GenericMethod ("revision", "@brief Method int QTextDocument::revision()\n", true, &_init_f_revision_c0, &_call_f_revision_c0);
  methods += new qt_gsi::GenericMethod ("rootFrame", "@brief Method QTextFrame *QTextDocument::rootFrame()\n", true, &_init_f_rootFrame_c0, &_call_f_rootFrame_c0);
  methods += new qt_gsi::GenericMethod ("setDefaultFont|defaultFont=", "@brief Method void QTextDocument::setDefaultFont(const QFont &font)\n", false, &_init_f_setDefaultFont_1801, &_call_f_setDefaultFont_1801);
  methods += new qt_gsi::GenericMethod ("setDefaultStyleSheet|defaultStyleSheet=", "@brief Method void QTextDocument::setDefaultStyleSheet(const QString &sheet)\n", false, &_init_f_setDefaultStyleSheet_2025, &_call_f_setDefaultStyleSheet_2025);
  methods += new qt_gsi::GenericMethod ("setDefaultTextOption|defaultTextOption=", "@brief Method void QTextDocument::setDefaultTextOption(const QTextOption &option)\n", false, &_init_f_setDefaultTextOption_2448, &_call_f_setDefaultTextOption_2448);
  methods += new qt_gsi::GenericMethod ("setDocumentLayout|documentLayout=", "@brief Method void QTextDocument::setDocumentLayout(QAbstractTextDocumentLayout *layout)\n", false, &_init_f_setDocumentLayout_3413, &_call_f_setDocumentLayout_3413);
  methods += new qt_gsi::GenericMethod ("setDocumentMargin|documentMargin=", "@brief Method void QTextDocument::setDocumentMargin(double margin)\n", false, &_init_f_setDocumentMargin_1071, &_call_f_setDocumentMargin_1071);
  methods += new qt_gsi::GenericMethod ("setHtml", "@brief Method void QTextDocument::setHtml(const QString &html)\n", false, &_init_f_setHtml_2025, &_call_f_setHtml_2025);
  methods += new qt_gsi::GenericMethod ("setIndentWidth|indentWidth=", "@brief Method void QTextDocument::setIndentWidth(double width)\n", false, &_init_f_setIndentWidth_1071, &_call_f_setIndentWidth_1071);
  methods += new qt_gsi::GenericMethod ("setMaximumBlockCount|maximumBlockCount=", "@brief Method void QTextDocument::setMaximumBlockCount(int maximum)\n", false, &_init_f_setMaximumBlockCount_767, &_call_f_setMaximumBlockCount_767);
  methods += new qt_gsi::GenericMethod ("setMetaInformation", "@brief Method void QTextDocument::setMetaInformation(QTextDocument::MetaInformation info, const QString &)\n", false, &_init_f_setMetaInformation_5351, &_call_f_setMetaInformation_5351);
  methods += new qt_gsi::GenericMethod ("setModified|modified=", "@brief Method void QTextDocument::setModified(bool m)\n", false, &_init_f_setModified_864, &_call_f_setModified_864);
  methods += new qt_gsi::GenericMethod ("setPageSize|pageSize=", "@brief Method void QTextDocument::setPageSize(const QSizeF &size)\n", false, &_init_f_setPageSize_1875, &_call_f_setPageSize_1875);
  methods += new qt_gsi::GenericMethod ("setPlainText", "@brief Method void QTextDocument::setPlainText(const QString &text)\n", false, &_init_f_setPlainText_2025, &_call_f_setPlainText_2025);
  methods += new qt_gsi::GenericMethod ("setTextWidth|textWidth=", "@brief Method void QTextDocument::setTextWidth(double width)\n", false, &_init_f_setTextWidth_1071, &_call_f_setTextWidth_1071);
  methods += new qt_gsi::GenericMethod ("setUndoRedoEnabled|undoRedoEnabled=", "@brief Method void QTextDocument::setUndoRedoEnabled(bool enable)\n", false, &_init_f_setUndoRedoEnabled_864, &_call_f_setUndoRedoEnabled_864);
  methods += new qt_gsi::GenericMethod ("setUseDesignMetrics|useDesignMetrics=", "@brief Method void QTextDocument::setUseDesignMetrics(bool b)\n", false, &_init_f_setUseDesignMetrics_864, &_call_f_setUseDesignMetrics_864);
  methods += new qt_gsi::GenericMethod (":size", "@brief Method QSizeF QTextDocument::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
  methods += new qt_gsi::GenericMethod (":textWidth", "@brief Method double QTextDocument::textWidth()\n", true, &_init_f_textWidth_c0, &_call_f_textWidth_c0);
  methods += new qt_gsi::GenericMethod ("toHtml", "@brief Method QString QTextDocument::toHtml(const QByteArray &encoding)\n", true, &_init_f_toHtml_c2309, &_call_f_toHtml_c2309);
  methods += new qt_gsi::GenericMethod ("toPlainText", "@brief Method QString QTextDocument::toPlainText()\n", true, &_init_f_toPlainText_c0, &_call_f_toPlainText_c0);
  methods += new qt_gsi::GenericMethod ("undo", "@brief Method void QTextDocument::undo(QTextCursor *cursor)\n", false, &_init_f_undo_1762, &_call_f_undo_1762);
  methods += new qt_gsi::GenericMethod ("undo", "@brief Method void QTextDocument::undo()\n", false, &_init_f_undo_0, &_call_f_undo_0);
  methods += new qt_gsi::GenericMethod (":useDesignMetrics", "@brief Method bool QTextDocument::useDesignMetrics()\n", true, &_init_f_useDesignMetrics_c0, &_call_f_useDesignMetrics_c0);
  methods += gsi::qt_signal<int > ("blockCountChanged(int)", "blockCountChanged", gsi::arg("newBlockCount"), "@brief Signal declaration for QTextDocument::blockCountChanged(int newBlockCount)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, int, int > ("contentsChange(int, int, int)", "contentsChange", gsi::arg("from"), gsi::arg("charsRemoves"), gsi::arg("charsAdded"), "@brief Signal declaration for QTextDocument::contentsChange(int from, int charsRemoves, int charsAdded)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("contentsChanged()", "contentsChanged", "@brief Signal declaration for QTextDocument::contentsChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QTextCursor & > ("cursorPositionChanged(const QTextCursor &)", "cursorPositionChanged", gsi::arg("cursor"), "@brief Signal declaration for QTextDocument::cursorPositionChanged(const QTextCursor &cursor)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QTextDocument::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("documentLayoutChanged()", "documentLayoutChanged", "@brief Signal declaration for QTextDocument::documentLayoutChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("modificationChanged(bool)", "modificationChanged", gsi::arg("m"), "@brief Signal declaration for QTextDocument::modificationChanged(bool m)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("redoAvailable(bool)", "redoAvailable", gsi::arg("arg1"), "@brief Signal declaration for QTextDocument::redoAvailable(bool)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("undoAvailable(bool)", "undoAvailable", gsi::arg("arg1"), "@brief Signal declaration for QTextDocument::undoAvailable(bool)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("undoCommandAdded()", "undoCommandAdded", "@brief Signal declaration for QTextDocument::undoCommandAdded()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTextDocument::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTextDocument::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTextDocument::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTextDocument::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QTextDocument> decl_QTextDocument (qtdecl_QObject (), "QTextDocument_Native",
  methods_QTextDocument (),
  "@hide\n@alias QTextDocument");

GSIQT_PUBLIC gsi::Class<QTextDocument> &qtdecl_QTextDocument () { return decl_QTextDocument; }

}


class QTextDocument_Adaptor : public QTextDocument, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTextDocument_Adaptor();

  //  [adaptor ctor] QTextDocument::QTextDocument(QObject *parent)
  QTextDocument_Adaptor() : QTextDocument()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextDocument::QTextDocument(QObject *parent)
  QTextDocument_Adaptor(QObject *parent) : QTextDocument(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextDocument::QTextDocument(const QString &text, QObject *parent)
  QTextDocument_Adaptor(const QString &text) : QTextDocument(text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextDocument::QTextDocument(const QString &text, QObject *parent)
  QTextDocument_Adaptor(const QString &text, QObject *parent) : QTextDocument(text, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QTextDocument::receivers(const char *signal)
  int fp_QTextDocument_receivers_c1731 (const char *signal) const {
    return QTextDocument::receivers(signal);
  }

  //  [expose] QObject *QTextDocument::sender()
  QObject * fp_QTextDocument_sender_c0 () const {
    return QTextDocument::sender();
  }

  //  [adaptor impl] void QTextDocument::clear()
  void cbs_clear_0_0()
  {
    QTextDocument::clear();
  }

  virtual void clear()
  {
    if (cb_clear_0_0.can_issue()) {
      cb_clear_0_0.issue<QTextDocument_Adaptor>(&QTextDocument_Adaptor::cbs_clear_0_0);
    } else {
      QTextDocument::clear();
    }
  }

  //  [adaptor impl] bool QTextDocument::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QTextDocument::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTextDocument_Adaptor, bool, QEvent *>(&QTextDocument_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QTextDocument::event(arg1);
    }
  }

  //  [adaptor impl] bool QTextDocument::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QTextDocument::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTextDocument_Adaptor, bool, QObject *, QEvent *>(&QTextDocument_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QTextDocument::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QTextDocument::blockCountChanged(int newBlockCount)
  void emitter_QTextDocument_blockCountChanged_767(int newBlockCount)
  {
    emit QTextDocument::blockCountChanged(newBlockCount);
  }

  //  [adaptor impl] void QTextDocument::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QTextDocument::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTextDocument_Adaptor, QChildEvent *>(&QTextDocument_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QTextDocument::childEvent(arg1);
    }
  }

  //  [emitter impl] void QTextDocument::contentsChange(int from, int charsRemoves, int charsAdded)
  void emitter_QTextDocument_contentsChange_2085(int from, int charsRemoves, int charsAdded)
  {
    emit QTextDocument::contentsChange(from, charsRemoves, charsAdded);
  }

  //  [emitter impl] void QTextDocument::contentsChanged()
  void emitter_QTextDocument_contentsChanged_0()
  {
    emit QTextDocument::contentsChanged();
  }

  //  [adaptor impl] QTextObject *QTextDocument::createObject(const QTextFormat &f)
  QTextObject * cbs_createObject_2432_0(const QTextFormat &f)
  {
    return QTextDocument::createObject(f);
  }

  virtual QTextObject * createObject(const QTextFormat &f)
  {
    if (cb_createObject_2432_0.can_issue()) {
      return cb_createObject_2432_0.issue<QTextDocument_Adaptor, QTextObject *, const QTextFormat &>(&QTextDocument_Adaptor::cbs_createObject_2432_0, f);
    } else {
      return QTextDocument::createObject(f);
    }
  }

  //  [emitter impl] void QTextDocument::cursorPositionChanged(const QTextCursor &cursor)
  void emitter_QTextDocument_cursorPositionChanged_2453(const QTextCursor &cursor)
  {
    emit QTextDocument::cursorPositionChanged(cursor);
  }

  //  [adaptor impl] void QTextDocument::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QTextDocument::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTextDocument_Adaptor, QEvent *>(&QTextDocument_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QTextDocument::customEvent(arg1);
    }
  }

  //  [emitter impl] void QTextDocument::destroyed(QObject *)
  void emitter_QTextDocument_destroyed_1302(QObject *arg1)
  {
    emit QTextDocument::destroyed(arg1);
  }

  //  [adaptor impl] void QTextDocument::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QTextDocument::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QTextDocument_Adaptor, const char *>(&QTextDocument_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QTextDocument::disconnectNotify(signal);
    }
  }

  //  [emitter impl] void QTextDocument::documentLayoutChanged()
  void emitter_QTextDocument_documentLayoutChanged_0()
  {
    emit QTextDocument::documentLayoutChanged();
  }

  //  [adaptor impl] QVariant QTextDocument::loadResource(int type, const QUrl &name)
  QVariant cbs_loadResource_2360_0(int type, const QUrl &name)
  {
    return QTextDocument::loadResource(type, name);
  }

  virtual QVariant loadResource(int type, const QUrl &name)
  {
    if (cb_loadResource_2360_0.can_issue()) {
      return cb_loadResource_2360_0.issue<QTextDocument_Adaptor, QVariant, int, const QUrl &>(&QTextDocument_Adaptor::cbs_loadResource_2360_0, type, name);
    } else {
      return QTextDocument::loadResource(type, name);
    }
  }

  //  [emitter impl] void QTextDocument::modificationChanged(bool m)
  void emitter_QTextDocument_modificationChanged_864(bool m)
  {
    emit QTextDocument::modificationChanged(m);
  }

  //  [emitter impl] void QTextDocument::redoAvailable(bool)
  void emitter_QTextDocument_redoAvailable_864(bool arg1)
  {
    emit QTextDocument::redoAvailable(arg1);
  }

  //  [adaptor impl] void QTextDocument::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QTextDocument::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTextDocument_Adaptor, QTimerEvent *>(&QTextDocument_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QTextDocument::timerEvent(arg1);
    }
  }

  //  [emitter impl] void QTextDocument::undoAvailable(bool)
  void emitter_QTextDocument_undoAvailable_864(bool arg1)
  {
    emit QTextDocument::undoAvailable(arg1);
  }

  //  [emitter impl] void QTextDocument::undoCommandAdded()
  void emitter_QTextDocument_undoCommandAdded_0()
  {
    emit QTextDocument::undoCommandAdded();
  }

  gsi::Callback cb_clear_0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_createObject_2432_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_loadResource_2360_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QTextDocument_Adaptor::~QTextDocument_Adaptor() { }

//  Constructor QTextDocument::QTextDocument(QObject *parent) (adaptor class)

static void _init_ctor_QTextDocument_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QTextDocument_Adaptor> ();
}

static void _call_ctor_QTextDocument_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ret.write<QTextDocument_Adaptor *> (new QTextDocument_Adaptor (arg1));
}


//  Constructor QTextDocument::QTextDocument(const QString &text, QObject *parent) (adaptor class)

static void _init_ctor_QTextDocument_Adaptor_3219 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QTextDocument_Adaptor> ();
}

static void _call_ctor_QTextDocument_Adaptor_3219 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  QObject *arg2 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ret.write<QTextDocument_Adaptor *> (new QTextDocument_Adaptor (arg1, arg2));
}


// emitter void QTextDocument::blockCountChanged(int newBlockCount)

static void _init_emitter_blockCountChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newBlockCount");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_blockCountChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ((QTextDocument_Adaptor *)cls)->emitter_QTextDocument_blockCountChanged_767 (arg1);
}


// void QTextDocument::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QTextDocument::clear()

static void _init_cbs_clear_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_clear_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument_Adaptor *)cls)->cbs_clear_0_0 ();
}

static void _set_callback_cbs_clear_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_clear_0_0 = cb;
}


// emitter void QTextDocument::contentsChange(int from, int charsRemoves, int charsAdded)

static void _init_emitter_contentsChange_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("charsRemoves");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("charsAdded");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_emitter_contentsChange_2085 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  ((QTextDocument_Adaptor *)cls)->emitter_QTextDocument_contentsChange_2085 (arg1, arg2, arg3);
}


// emitter void QTextDocument::contentsChanged()

static void _init_emitter_contentsChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_contentsChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTextDocument_Adaptor *)cls)->emitter_QTextDocument_contentsChanged_0 ();
}


// QTextObject *QTextDocument::createObject(const QTextFormat &f)

static void _init_cbs_createObject_2432_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const QTextFormat & > (argspec_0);
  decl->set_return<QTextObject * > ();
}

static void _call_cbs_createObject_2432_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextFormat &arg1 = args.read<const QTextFormat & > (heap);
  ret.write<QTextObject * > ((QTextObject *)((QTextDocument_Adaptor *)cls)->cbs_createObject_2432_0 (arg1));
}

static void _set_callback_cbs_createObject_2432_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_createObject_2432_0 = cb;
}


// emitter void QTextDocument::cursorPositionChanged(const QTextCursor &cursor)

static void _init_emitter_cursorPositionChanged_2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_cursorPositionChanged_2453 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = args.read<const QTextCursor & > (heap);
  ((QTextDocument_Adaptor *)cls)->emitter_QTextDocument_cursorPositionChanged_2453 (arg1);
}


// void QTextDocument::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QTextDocument::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ((QTextDocument_Adaptor *)cls)->emitter_QTextDocument_destroyed_1302 (arg1);
}


// void QTextDocument::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// emitter void QTextDocument::documentLayoutChanged()

static void _init_emitter_documentLayoutChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_documentLayoutChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTextDocument_Adaptor *)cls)->emitter_QTextDocument_documentLayoutChanged_0 ();
}


// bool QTextDocument::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTextDocument_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QTextDocument::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTextDocument_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QVariant QTextDocument::loadResource(int type, const QUrl &name)

static void _init_cbs_loadResource_2360_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_loadResource_2360_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const QUrl &arg2 = args.read<const QUrl & > (heap);
  ret.write<QVariant > ((QVariant)((QTextDocument_Adaptor *)cls)->cbs_loadResource_2360_0 (arg1, arg2));
}

static void _set_callback_cbs_loadResource_2360_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_loadResource_2360_0 = cb;
}


// emitter void QTextDocument::modificationChanged(bool m)

static void _init_emitter_modificationChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_modificationChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ((QTextDocument_Adaptor *)cls)->emitter_QTextDocument_modificationChanged_864 (arg1);
}


// exposed int QTextDocument::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<int > ((int)((QTextDocument_Adaptor *)cls)->fp_QTextDocument_receivers_c1731 (arg1));
}


// emitter void QTextDocument::redoAvailable(bool)

static void _init_emitter_redoAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_redoAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ((QTextDocument_Adaptor *)cls)->emitter_QTextDocument_redoAvailable_864 (arg1);
}


// exposed QObject *QTextDocument::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QTextDocument_Adaptor *)cls)->fp_QTextDocument_sender_c0 ());
}


// void QTextDocument::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextDocument_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QTextDocument::undoAvailable(bool)

static void _init_emitter_undoAvailable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_undoAvailable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ((QTextDocument_Adaptor *)cls)->emitter_QTextDocument_undoAvailable_864 (arg1);
}


// emitter void QTextDocument::undoCommandAdded()

static void _init_emitter_undoCommandAdded_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_undoCommandAdded_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QTextDocument_Adaptor *)cls)->emitter_QTextDocument_undoCommandAdded_0 ();
}


namespace gsi
{

gsi::Class<QTextDocument> &qtdecl_QTextDocument ();

static gsi::Methods methods_QTextDocument_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextDocument::QTextDocument(QObject *parent)\nThis method creates an object of class QTextDocument.", &_init_ctor_QTextDocument_Adaptor_1302, &_call_ctor_QTextDocument_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextDocument::QTextDocument(const QString &text, QObject *parent)\nThis method creates an object of class QTextDocument.", &_init_ctor_QTextDocument_Adaptor_3219, &_call_ctor_QTextDocument_Adaptor_3219);
  methods += new qt_gsi::GenericMethod ("emit_blockCountChanged", "@brief Emitter for signal void QTextDocument::blockCountChanged(int newBlockCount)\nCall this method to emit this signal.", false, &_init_emitter_blockCountChanged_767, &_call_emitter_blockCountChanged_767);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTextDocument::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("clear", "@hide", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Virtual method void QTextDocument::clear()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0, &_set_callback_cbs_clear_0_0);
  methods += new qt_gsi::GenericMethod ("emit_contentsChange", "@brief Emitter for signal void QTextDocument::contentsChange(int from, int charsRemoves, int charsAdded)\nCall this method to emit this signal.", false, &_init_emitter_contentsChange_2085, &_call_emitter_contentsChange_2085);
  methods += new qt_gsi::GenericMethod ("emit_contentsChanged", "@brief Emitter for signal void QTextDocument::contentsChanged()\nCall this method to emit this signal.", false, &_init_emitter_contentsChanged_0, &_call_emitter_contentsChanged_0);
  methods += new qt_gsi::GenericMethod ("*createObject", "@hide", false, &_init_cbs_createObject_2432_0, &_call_cbs_createObject_2432_0);
  methods += new qt_gsi::GenericMethod ("*createObject", "@brief Virtual method QTextObject *QTextDocument::createObject(const QTextFormat &f)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_createObject_2432_0, &_call_cbs_createObject_2432_0, &_set_callback_cbs_createObject_2432_0);
  methods += new qt_gsi::GenericMethod ("emit_cursorPositionChanged", "@brief Emitter for signal void QTextDocument::cursorPositionChanged(const QTextCursor &cursor)\nCall this method to emit this signal.", false, &_init_emitter_cursorPositionChanged_2453, &_call_emitter_cursorPositionChanged_2453);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTextDocument::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QTextDocument::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTextDocument::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("emit_documentLayoutChanged", "@brief Emitter for signal void QTextDocument::documentLayoutChanged()\nCall this method to emit this signal.", false, &_init_emitter_documentLayoutChanged_0, &_call_emitter_documentLayoutChanged_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QTextDocument::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTextDocument::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*loadResource", "@hide", false, &_init_cbs_loadResource_2360_0, &_call_cbs_loadResource_2360_0);
  methods += new qt_gsi::GenericMethod ("*loadResource", "@brief Virtual method QVariant QTextDocument::loadResource(int type, const QUrl &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_loadResource_2360_0, &_call_cbs_loadResource_2360_0, &_set_callback_cbs_loadResource_2360_0);
  methods += new qt_gsi::GenericMethod ("emit_modificationChanged", "@brief Emitter for signal void QTextDocument::modificationChanged(bool m)\nCall this method to emit this signal.", false, &_init_emitter_modificationChanged_864, &_call_emitter_modificationChanged_864);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QTextDocument::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_redoAvailable", "@brief Emitter for signal void QTextDocument::redoAvailable(bool)\nCall this method to emit this signal.", false, &_init_emitter_redoAvailable_864, &_call_emitter_redoAvailable_864);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QTextDocument::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTextDocument::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_undoAvailable", "@brief Emitter for signal void QTextDocument::undoAvailable(bool)\nCall this method to emit this signal.", false, &_init_emitter_undoAvailable_864, &_call_emitter_undoAvailable_864);
  methods += new qt_gsi::GenericMethod ("emit_undoCommandAdded", "@brief Emitter for signal void QTextDocument::undoCommandAdded()\nCall this method to emit this signal.", false, &_init_emitter_undoCommandAdded_0, &_call_emitter_undoCommandAdded_0);
  return methods;
}

gsi::Class<QTextDocument_Adaptor> decl_QTextDocument_Adaptor (qtdecl_QTextDocument (), "QTextDocument",
  methods_QTextDocument_Adaptor (),
  "@qt\n@brief Binding of QTextDocument");

}


//  Implementation of the enum wrapper class for QTextDocument::FindFlag
namespace qt_gsi
{

static gsi::Enum<QTextDocument::FindFlag> decl_QTextDocument_FindFlag_Enum ("QTextDocument_FindFlag",
    gsi::enum_const ("FindBackward", QTextDocument::FindBackward, "@brief Enum constant QTextDocument::FindBackward") +
    gsi::enum_const ("FindCaseSensitively", QTextDocument::FindCaseSensitively, "@brief Enum constant QTextDocument::FindCaseSensitively") +
    gsi::enum_const ("FindWholeWords", QTextDocument::FindWholeWords, "@brief Enum constant QTextDocument::FindWholeWords"),
  "@qt\n@brief This class represents the QTextDocument::FindFlag enum");

static gsi::QFlagsClass<QTextDocument::FindFlag > decl_QTextDocument_FindFlag_Enums ("QTextDocument_QFlags_FindFlag",
  "@qt\n@brief This class represents the QFlags<QTextDocument::FindFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextDocument> inject_QTextDocument_FindFlag_Enum_in_parent (decl_QTextDocument_FindFlag_Enum.defs ());
static gsi::ClassExt<QTextDocument> decl_QTextDocument_FindFlag_Enum_as_child (decl_QTextDocument_FindFlag_Enum, "FindFlag");
static gsi::ClassExt<QTextDocument> decl_QTextDocument_FindFlag_Enums_as_child (decl_QTextDocument_FindFlag_Enums, "QFlags_FindFlag");

}


//  Implementation of the enum wrapper class for QTextDocument::MetaInformation
namespace qt_gsi
{

static gsi::Enum<QTextDocument::MetaInformation> decl_QTextDocument_MetaInformation_Enum ("QTextDocument_MetaInformation",
    gsi::enum_const ("DocumentTitle", QTextDocument::DocumentTitle, "@brief Enum constant QTextDocument::DocumentTitle") +
    gsi::enum_const ("DocumentUrl", QTextDocument::DocumentUrl, "@brief Enum constant QTextDocument::DocumentUrl"),
  "@qt\n@brief This class represents the QTextDocument::MetaInformation enum");

static gsi::QFlagsClass<QTextDocument::MetaInformation > decl_QTextDocument_MetaInformation_Enums ("QTextDocument_QFlags_MetaInformation",
  "@qt\n@brief This class represents the QFlags<QTextDocument::MetaInformation> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextDocument> inject_QTextDocument_MetaInformation_Enum_in_parent (decl_QTextDocument_MetaInformation_Enum.defs ());
static gsi::ClassExt<QTextDocument> decl_QTextDocument_MetaInformation_Enum_as_child (decl_QTextDocument_MetaInformation_Enum, "MetaInformation");
static gsi::ClassExt<QTextDocument> decl_QTextDocument_MetaInformation_Enums_as_child (decl_QTextDocument_MetaInformation_Enums, "QFlags_MetaInformation");

}

