
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQUrl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QUrl>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QUrl

//  Constructor QUrl::QUrl()


static void _init_ctor_QUrl_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QUrl> ();
}

static void _call_ctor_QUrl_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl *> (new QUrl ());
}


//  Constructor QUrl::QUrl(const QString &url)


static void _init_ctor_QUrl_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QUrl> ();
}

static void _call_ctor_QUrl_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QUrl *> (new QUrl (arg1));
}


//  Constructor QUrl::QUrl(const QString &url, QUrl::ParsingMode mode)


static void _init_ctor_QUrl_3970 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return_new<QUrl> ();
}

static void _call_ctor_QUrl_3970 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args.read<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (heap);
  ret.write<QUrl *> (new QUrl (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref()));
}


//  Constructor QUrl::QUrl(const QUrl &copy)


static void _init_ctor_QUrl_1701 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("copy");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return_new<QUrl> ();
}

static void _call_ctor_QUrl_1701 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<QUrl *> (new QUrl (arg1));
}


// void QUrl::addEncodedQueryItem(const QByteArray &key, const QByteArray &value)


static void _init_f_addEncodedQueryItem_4510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addEncodedQueryItem_4510 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  const QByteArray &arg2 = args.read<const QByteArray & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->addEncodedQueryItem (arg1, arg2);
}


// void QUrl::addQueryItem(const QString &key, const QString &value)


static void _init_f_addQueryItem_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addQueryItem_3942 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const QString &arg2 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->addQueryItem (arg1, arg2);
}


// QList<QByteArray> QUrl::allEncodedQueryItemValues(const QByteArray &key)


static void _init_f_allEncodedQueryItemValues_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QList<QByteArray> > ();
}

static void _call_f_allEncodedQueryItemValues_c2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  ret.write<QList<QByteArray> > ((QList<QByteArray>)((QUrl *)cls)->allEncodedQueryItemValues (arg1));
}


// QStringList QUrl::allQueryItemValues(const QString &key)


static void _init_f_allQueryItemValues_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QStringList > ();
}

static void _call_f_allQueryItemValues_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QStringList > ((QStringList)((QUrl *)cls)->allQueryItemValues (arg1));
}


// QString QUrl::authority()


static void _init_f_authority_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_authority_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->authority ());
}


// void QUrl::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->clear ();
}


// void QUrl::detach()


static void _init_f_detach_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_detach_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->detach ();
}


// QByteArray QUrl::encodedFragment()


static void _init_f_encodedFragment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedFragment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedFragment ());
}


// QByteArray QUrl::encodedHost()


static void _init_f_encodedHost_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedHost_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedHost ());
}


// QByteArray QUrl::encodedPassword()


static void _init_f_encodedPassword_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedPassword_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedPassword ());
}


// QByteArray QUrl::encodedPath()


static void _init_f_encodedPath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedPath_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedPath ());
}


// QByteArray QUrl::encodedQuery()


static void _init_f_encodedQuery_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedQuery_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedQuery ());
}


// QByteArray QUrl::encodedQueryItemValue(const QByteArray &key)


static void _init_f_encodedQueryItemValue_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedQueryItemValue_c2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedQueryItemValue (arg1));
}


// QList<QPair<QByteArray, QByteArray> > QUrl::encodedQueryItems()


static void _init_f_encodedQueryItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QPair<QByteArray, QByteArray> > > ();
}

static void _call_f_encodedQueryItems_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QPair<QByteArray, QByteArray> > > ((QList<QPair<QByteArray, QByteArray> >)((QUrl *)cls)->encodedQueryItems ());
}


// QByteArray QUrl::encodedUserName()


static void _init_f_encodedUserName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_encodedUserName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->encodedUserName ());
}


// QString QUrl::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->errorString ());
}


// QString QUrl::fragment()


static void _init_f_fragment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fragment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->fragment ());
}


// bool QUrl::hasEncodedQueryItem(const QByteArray &key)


static void _init_f_hasEncodedQueryItem_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasEncodedQueryItem_c2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  ret.write<bool > ((bool)((QUrl *)cls)->hasEncodedQueryItem (arg1));
}


// bool QUrl::hasFragment()


static void _init_f_hasFragment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasFragment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->hasFragment ());
}


// bool QUrl::hasQuery()


static void _init_f_hasQuery_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasQuery_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->hasQuery ());
}


// bool QUrl::hasQueryItem(const QString &key)


static void _init_f_hasQueryItem_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasQueryItem_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QUrl *)cls)->hasQueryItem (arg1));
}


// QString QUrl::host()


static void _init_f_host_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_host_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->host ());
}


// bool QUrl::isDetached()


static void _init_f_isDetached_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDetached_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->isDetached ());
}


// bool QUrl::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->isEmpty ());
}


// bool QUrl::isParentOf(const QUrl &url)


static void _init_f_isParentOf_c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isParentOf_c1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<bool > ((bool)((QUrl *)cls)->isParentOf (arg1));
}


// bool QUrl::isRelative()


static void _init_f_isRelative_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRelative_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->isRelative ());
}


// bool QUrl::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QUrl *)cls)->isValid ());
}


// bool QUrl::operator !=(const QUrl &url)


static void _init_f_operator_excl__eq__c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<bool > ((bool)((QUrl *)cls)->operator != (arg1));
}


// bool QUrl::operator <(const QUrl &url)


static void _init_f_operator_lt__c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__c1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<bool > ((bool)((QUrl *)cls)->operator < (arg1));
}


// QUrl &QUrl::operator =(const QUrl &copy)


static void _init_f_operator_eq__1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("copy");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QUrl & > ();
}

static void _call_f_operator_eq__1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<QUrl & > ((QUrl &)((QUrl *)cls)->operator = (arg1));
}


// QUrl &QUrl::operator =(const QString &url)


static void _init_f_operator_eq__2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QUrl & > ();
}

static void _call_f_operator_eq__2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QUrl & > ((QUrl &)((QUrl *)cls)->operator = (arg1));
}


// bool QUrl::operator ==(const QUrl &url)


static void _init_f_operator_eq__eq__c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<bool > ((bool)((QUrl *)cls)->operator == (arg1));
}


// QString QUrl::password()


static void _init_f_password_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_password_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->password ());
}


// QString QUrl::path()


static void _init_f_path_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_path_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->path ());
}


// int QUrl::port()


static void _init_f_port_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_port_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QUrl *)cls)->port ());
}


// int QUrl::port(int defaultPort)


static void _init_f_port_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("defaultPort");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_port_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QUrl *)cls)->port (arg1));
}


// QString QUrl::queryItemValue(const QString &key)


static void _init_f_queryItemValue_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_queryItemValue_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QString > ((QString)((QUrl *)cls)->queryItemValue (arg1));
}


// QList<QPair<QString, QString> > QUrl::queryItems()


static void _init_f_queryItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QPair<QString, QString> > > ();
}

static void _call_f_queryItems_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QPair<QString, QString> > > ((QList<QPair<QString, QString> >)((QUrl *)cls)->queryItems ());
}


// char QUrl::queryPairDelimiter()


static void _init_f_queryPairDelimiter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<char > ();
}

static void _call_f_queryPairDelimiter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<char > ((char)((QUrl *)cls)->queryPairDelimiter ());
}


// char QUrl::queryValueDelimiter()


static void _init_f_queryValueDelimiter_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<char > ();
}

static void _call_f_queryValueDelimiter_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<char > ((char)((QUrl *)cls)->queryValueDelimiter ());
}


// void QUrl::removeAllEncodedQueryItems(const QByteArray &key)


static void _init_f_removeAllEncodedQueryItems_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeAllEncodedQueryItems_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->removeAllEncodedQueryItems (arg1);
}


// void QUrl::removeAllQueryItems(const QString &key)


static void _init_f_removeAllQueryItems_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeAllQueryItems_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->removeAllQueryItems (arg1);
}


// void QUrl::removeEncodedQueryItem(const QByteArray &key)


static void _init_f_removeEncodedQueryItem_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeEncodedQueryItem_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->removeEncodedQueryItem (arg1);
}


// void QUrl::removeQueryItem(const QString &key)


static void _init_f_removeQueryItem_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeQueryItem_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->removeQueryItem (arg1);
}


// QUrl QUrl::resolved(const QUrl &relative)


static void _init_f_resolved_c1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("relative");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<QUrl > ();
}

static void _call_f_resolved_c1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = args.read<const QUrl & > (heap);
  ret.write<QUrl > ((QUrl)((QUrl *)cls)->resolved (arg1));
}


// QString QUrl::scheme()


static void _init_f_scheme_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_scheme_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->scheme ());
}


// void QUrl::setAuthority(const QString &authority)


static void _init_f_setAuthority_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("authority");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAuthority_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setAuthority (arg1);
}


// void QUrl::setEncodedFragment(const QByteArray &fragment)


static void _init_f_setEncodedFragment_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fragment");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedFragment_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setEncodedFragment (arg1);
}


// void QUrl::setEncodedHost(const QByteArray &host)


static void _init_f_setEncodedHost_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("host");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedHost_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setEncodedHost (arg1);
}


// void QUrl::setEncodedPassword(const QByteArray &password)


static void _init_f_setEncodedPassword_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("password");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedPassword_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setEncodedPassword (arg1);
}


// void QUrl::setEncodedPath(const QByteArray &path)


static void _init_f_setEncodedPath_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedPath_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setEncodedPath (arg1);
}


// void QUrl::setEncodedQuery(const QByteArray &query)


static void _init_f_setEncodedQuery_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedQuery_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setEncodedQuery (arg1);
}


// void QUrl::setEncodedQueryItems(const QList<QPair<QByteArray, QByteArray> > &query)


static void _init_f_setEncodedQueryItems_4851 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QList<QPair<QByteArray, QByteArray> > & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedQueryItems_4851 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPair<QByteArray, QByteArray> > &arg1 = args.read<const QList<QPair<QByteArray, QByteArray> > & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setEncodedQueryItems (arg1);
}


// void QUrl::setEncodedUrl(const QByteArray &url)


static void _init_f_setEncodedUrl_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedUrl_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setEncodedUrl (arg1);
}


// void QUrl::setEncodedUrl(const QByteArray &url, QUrl::ParsingMode mode)


static void _init_f_setEncodedUrl_4254 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setEncodedUrl_4254 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args.read<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setEncodedUrl (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}


// void QUrl::setEncodedUserName(const QByteArray &userName)


static void _init_f_setEncodedUserName_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("userName");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodedUserName_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setEncodedUserName (arg1);
}


// void QUrl::setFragment(const QString &fragment)


static void _init_f_setFragment_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fragment");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFragment_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setFragment (arg1);
}


// void QUrl::setHost(const QString &host)


static void _init_f_setHost_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("host");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHost_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setHost (arg1);
}


// void QUrl::setPassword(const QString &password)


static void _init_f_setPassword_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("password");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPassword_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setPassword (arg1);
}


// void QUrl::setPath(const QString &path)


static void _init_f_setPath_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPath_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setPath (arg1);
}


// void QUrl::setPort(int port)


static void _init_f_setPort_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("port");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPort_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setPort (arg1);
}


// void QUrl::setQueryDelimiters(char valueDelimiter, char pairDelimiter)


static void _init_f_setQueryDelimiters_1592 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("valueDelimiter");
  decl->add_arg<char > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pairDelimiter");
  decl->add_arg<char > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setQueryDelimiters_1592 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  char arg1 = args.read<char > (heap);
  char arg2 = args.read<char > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setQueryDelimiters (arg1, arg2);
}


// void QUrl::setQueryItems(const QList<QPair<QString, QString> > &query)


static void _init_f_setQueryItems_4283 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const QList<QPair<QString, QString> > & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setQueryItems_4283 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QPair<QString, QString> > &arg1 = args.read<const QList<QPair<QString, QString> > & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setQueryItems (arg1);
}


// void QUrl::setScheme(const QString &scheme)


static void _init_f_setScheme_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scheme");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScheme_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setScheme (arg1);
}


// void QUrl::setUrl(const QString &url)


static void _init_f_setUrl_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUrl_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setUrl (arg1);
}


// void QUrl::setUrl(const QString &url, QUrl::ParsingMode mode)


static void _init_f_setUrl_3970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setUrl_3970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args.read<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setUrl (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref());
}


// void QUrl::setUserInfo(const QString &userInfo)


static void _init_f_setUserInfo_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("userInfo");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUserInfo_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setUserInfo (arg1);
}


// void QUrl::setUserName(const QString &userName)


static void _init_f_setUserName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("userName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUserName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QUrl *)cls)->setUserName (arg1);
}


// QByteArray QUrl::toEncoded(QFlags<QUrl::FormattingOption> options)


static void _init_f_toEncoded_c3320 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::None");
  decl->add_arg<QFlags<QUrl::FormattingOption> > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_toEncoded_c3320 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QUrl::FormattingOption> arg1 = args ? args.read<QFlags<QUrl::FormattingOption> > (heap) : (QFlags<QUrl::FormattingOption>)(QUrl::None);
  ret.write<QByteArray > ((QByteArray)((QUrl *)cls)->toEncoded (arg1));
}


// QString QUrl::toLocalFile()


static void _init_f_toLocalFile_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toLocalFile_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->toLocalFile ());
}


// QString QUrl::toString(QFlags<QUrl::FormattingOption> options)


static void _init_f_toString_c3320 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options", true, "QUrl::None");
  decl->add_arg<QFlags<QUrl::FormattingOption> > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3320 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QUrl::FormattingOption> arg1 = args ? args.read<QFlags<QUrl::FormattingOption> > (heap) : (QFlags<QUrl::FormattingOption>)(QUrl::None);
  ret.write<QString > ((QString)((QUrl *)cls)->toString (arg1));
}


// QString QUrl::userInfo()


static void _init_f_userInfo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_userInfo_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->userInfo ());
}


// QString QUrl::userName()


static void _init_f_userName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_userName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QUrl *)cls)->userName ());
}


// static QString QUrl::fromAce(const QByteArray &)


static void _init_f_fromAce_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fromAce_2309 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  ret.write<QString > ((QString)QUrl::fromAce (arg1));
}


// static QUrl QUrl::fromEncoded(const QByteArray &url)


static void _init_f_fromEncoded_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QUrl > ();
}

static void _call_f_fromEncoded_2309 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  ret.write<QUrl > ((QUrl)QUrl::fromEncoded (arg1));
}


// static QUrl QUrl::fromEncoded(const QByteArray &url, QUrl::ParsingMode mode)


static void _init_f_fromEncoded_4254 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("url");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (argspec_1);
  decl->set_return<QUrl > ();
}

static void _call_f_fromEncoded_4254 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  const qt_gsi::Converter<QUrl::ParsingMode>::target_type & arg2 = args.read<const qt_gsi::Converter<QUrl::ParsingMode>::target_type & > (heap);
  ret.write<QUrl > ((QUrl)QUrl::fromEncoded (arg1, qt_gsi::QtToCppAdaptor<QUrl::ParsingMode>(arg2).cref()));
}


// static QUrl QUrl::fromLocalFile(const QString &localfile)


static void _init_f_fromLocalFile_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("localfile");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QUrl > ();
}

static void _call_f_fromLocalFile_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QUrl > ((QUrl)QUrl::fromLocalFile (arg1));
}


// static QString QUrl::fromPercentEncoding(const QByteArray &)


static void _init_f_fromPercentEncoding_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fromPercentEncoding_2309 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  ret.write<QString > ((QString)QUrl::fromPercentEncoding (arg1));
}


// static QString QUrl::fromPunycode(const QByteArray &)


static void _init_f_fromPunycode_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fromPunycode_2309 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  ret.write<QString > ((QString)QUrl::fromPunycode (arg1));
}


// static QUrl QUrl::fromUserInput(const QString &userInput)


static void _init_f_fromUserInput_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("userInput");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QUrl > ();
}

static void _call_f_fromUserInput_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QUrl > ((QUrl)QUrl::fromUserInput (arg1));
}


// static QStringList QUrl::idnWhitelist()


static void _init_f_idnWhitelist_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_idnWhitelist_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)QUrl::idnWhitelist ());
}


// static void QUrl::setIdnWhitelist(const QStringList &)


static void _init_f_setIdnWhitelist_2437 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIdnWhitelist_2437 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = args.read<const QStringList & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QUrl::setIdnWhitelist (arg1);
}


// static QByteArray QUrl::toAce(const QString &)


static void _init_f_toAce_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_toAce_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QByteArray > ((QByteArray)QUrl::toAce (arg1));
}


// static QByteArray QUrl::toPercentEncoding(const QString &, const QByteArray &exclude, const QByteArray &include)


static void _init_f_toPercentEncoding_6427 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("exclude", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("include", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_2);
  decl->set_return<QByteArray > ();
}

static void _call_f_toPercentEncoding_6427 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  const QByteArray &arg2 = args ? args.read<const QByteArray & > (heap) : (const QByteArray &)(QByteArray());
  const QByteArray &arg3 = args ? args.read<const QByteArray & > (heap) : (const QByteArray &)(QByteArray());
  ret.write<QByteArray > ((QByteArray)QUrl::toPercentEncoding (arg1, arg2, arg3));
}


// static QByteArray QUrl::toPunycode(const QString &)


static void _init_f_toPunycode_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_toPunycode_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QByteArray > ((QByteArray)QUrl::toPunycode (arg1));
}



namespace gsi
{

static gsi::Methods methods_QUrl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrl::QUrl()\nThis method creates an object of class QUrl.", &_init_ctor_QUrl_0, &_call_ctor_QUrl_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrl::QUrl(const QString &url)\nThis method creates an object of class QUrl.", &_init_ctor_QUrl_2025, &_call_ctor_QUrl_2025);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrl::QUrl(const QString &url, QUrl::ParsingMode mode)\nThis method creates an object of class QUrl.", &_init_ctor_QUrl_3970, &_call_ctor_QUrl_3970);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrl::QUrl(const QUrl &copy)\nThis method creates an object of class QUrl.", &_init_ctor_QUrl_1701, &_call_ctor_QUrl_1701);
  methods += new qt_gsi::GenericMethod ("addEncodedQueryItem", "@brief Method void QUrl::addEncodedQueryItem(const QByteArray &key, const QByteArray &value)\n", false, &_init_f_addEncodedQueryItem_4510, &_call_f_addEncodedQueryItem_4510);
  methods += new qt_gsi::GenericMethod ("addQueryItem", "@brief Method void QUrl::addQueryItem(const QString &key, const QString &value)\n", false, &_init_f_addQueryItem_3942, &_call_f_addQueryItem_3942);
  methods += new qt_gsi::GenericMethod ("allEncodedQueryItemValues", "@brief Method QList<QByteArray> QUrl::allEncodedQueryItemValues(const QByteArray &key)\n", true, &_init_f_allEncodedQueryItemValues_c2309, &_call_f_allEncodedQueryItemValues_c2309);
  methods += new qt_gsi::GenericMethod ("allQueryItemValues", "@brief Method QStringList QUrl::allQueryItemValues(const QString &key)\n", true, &_init_f_allQueryItemValues_c2025, &_call_f_allQueryItemValues_c2025);
  methods += new qt_gsi::GenericMethod (":authority", "@brief Method QString QUrl::authority()\n", true, &_init_f_authority_c0, &_call_f_authority_c0);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QUrl::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("detach", "@brief Method void QUrl::detach()\n", false, &_init_f_detach_0, &_call_f_detach_0);
  methods += new qt_gsi::GenericMethod (":encodedFragment", "@brief Method QByteArray QUrl::encodedFragment()\n", true, &_init_f_encodedFragment_c0, &_call_f_encodedFragment_c0);
  methods += new qt_gsi::GenericMethod (":encodedHost", "@brief Method QByteArray QUrl::encodedHost()\n", true, &_init_f_encodedHost_c0, &_call_f_encodedHost_c0);
  methods += new qt_gsi::GenericMethod (":encodedPassword", "@brief Method QByteArray QUrl::encodedPassword()\n", true, &_init_f_encodedPassword_c0, &_call_f_encodedPassword_c0);
  methods += new qt_gsi::GenericMethod (":encodedPath", "@brief Method QByteArray QUrl::encodedPath()\n", true, &_init_f_encodedPath_c0, &_call_f_encodedPath_c0);
  methods += new qt_gsi::GenericMethod (":encodedQuery", "@brief Method QByteArray QUrl::encodedQuery()\n", true, &_init_f_encodedQuery_c0, &_call_f_encodedQuery_c0);
  methods += new qt_gsi::GenericMethod ("encodedQueryItemValue", "@brief Method QByteArray QUrl::encodedQueryItemValue(const QByteArray &key)\n", true, &_init_f_encodedQueryItemValue_c2309, &_call_f_encodedQueryItemValue_c2309);
  methods += new qt_gsi::GenericMethod (":encodedQueryItems", "@brief Method QList<QPair<QByteArray, QByteArray> > QUrl::encodedQueryItems()\n", true, &_init_f_encodedQueryItems_c0, &_call_f_encodedQueryItems_c0);
  methods += new qt_gsi::GenericMethod (":encodedUserName", "@brief Method QByteArray QUrl::encodedUserName()\n", true, &_init_f_encodedUserName_c0, &_call_f_encodedUserName_c0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QUrl::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod (":fragment", "@brief Method QString QUrl::fragment()\n", true, &_init_f_fragment_c0, &_call_f_fragment_c0);
  methods += new qt_gsi::GenericMethod ("hasEncodedQueryItem", "@brief Method bool QUrl::hasEncodedQueryItem(const QByteArray &key)\n", true, &_init_f_hasEncodedQueryItem_c2309, &_call_f_hasEncodedQueryItem_c2309);
  methods += new qt_gsi::GenericMethod ("hasFragment", "@brief Method bool QUrl::hasFragment()\n", true, &_init_f_hasFragment_c0, &_call_f_hasFragment_c0);
  methods += new qt_gsi::GenericMethod ("hasQuery", "@brief Method bool QUrl::hasQuery()\n", true, &_init_f_hasQuery_c0, &_call_f_hasQuery_c0);
  methods += new qt_gsi::GenericMethod ("hasQueryItem", "@brief Method bool QUrl::hasQueryItem(const QString &key)\n", true, &_init_f_hasQueryItem_c2025, &_call_f_hasQueryItem_c2025);
  methods += new qt_gsi::GenericMethod (":host", "@brief Method QString QUrl::host()\n", true, &_init_f_host_c0, &_call_f_host_c0);
  methods += new qt_gsi::GenericMethod ("isDetached?", "@brief Method bool QUrl::isDetached()\n", true, &_init_f_isDetached_c0, &_call_f_isDetached_c0);
  methods += new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QUrl::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
  methods += new qt_gsi::GenericMethod ("isParentOf?", "@brief Method bool QUrl::isParentOf(const QUrl &url)\n", true, &_init_f_isParentOf_c1701, &_call_f_isParentOf_c1701);
  methods += new qt_gsi::GenericMethod ("isRelative?", "@brief Method bool QUrl::isRelative()\n", true, &_init_f_isRelative_c0, &_call_f_isRelative_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QUrl::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QUrl::operator !=(const QUrl &url)\n", true, &_init_f_operator_excl__eq__c1701, &_call_f_operator_excl__eq__c1701);
  methods += new qt_gsi::GenericMethod ("<", "@brief Method bool QUrl::operator <(const QUrl &url)\n", true, &_init_f_operator_lt__c1701, &_call_f_operator_lt__c1701);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QUrl &QUrl::operator =(const QUrl &copy)\n", false, &_init_f_operator_eq__1701, &_call_f_operator_eq__1701);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QUrl &QUrl::operator =(const QString &url)\n", false, &_init_f_operator_eq__2025, &_call_f_operator_eq__2025);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QUrl::operator ==(const QUrl &url)\n", true, &_init_f_operator_eq__eq__c1701, &_call_f_operator_eq__eq__c1701);
  methods += new qt_gsi::GenericMethod (":password", "@brief Method QString QUrl::password()\n", true, &_init_f_password_c0, &_call_f_password_c0);
  methods += new qt_gsi::GenericMethod (":path", "@brief Method QString QUrl::path()\n", true, &_init_f_path_c0, &_call_f_path_c0);
  methods += new qt_gsi::GenericMethod (":port", "@brief Method int QUrl::port()\n", true, &_init_f_port_c0, &_call_f_port_c0);
  methods += new qt_gsi::GenericMethod ("port", "@brief Method int QUrl::port(int defaultPort)\n", true, &_init_f_port_c767, &_call_f_port_c767);
  methods += new qt_gsi::GenericMethod ("queryItemValue", "@brief Method QString QUrl::queryItemValue(const QString &key)\n", true, &_init_f_queryItemValue_c2025, &_call_f_queryItemValue_c2025);
  methods += new qt_gsi::GenericMethod (":queryItems", "@brief Method QList<QPair<QString, QString> > QUrl::queryItems()\n", true, &_init_f_queryItems_c0, &_call_f_queryItems_c0);
  methods += new qt_gsi::GenericMethod ("queryPairDelimiter", "@brief Method char QUrl::queryPairDelimiter()\n", true, &_init_f_queryPairDelimiter_c0, &_call_f_queryPairDelimiter_c0);
  methods += new qt_gsi::GenericMethod ("queryValueDelimiter", "@brief Method char QUrl::queryValueDelimiter()\n", true, &_init_f_queryValueDelimiter_c0, &_call_f_queryValueDelimiter_c0);
  methods += new qt_gsi::GenericMethod ("removeAllEncodedQueryItems", "@brief Method void QUrl::removeAllEncodedQueryItems(const QByteArray &key)\n", false, &_init_f_removeAllEncodedQueryItems_2309, &_call_f_removeAllEncodedQueryItems_2309);
  methods += new qt_gsi::GenericMethod ("removeAllQueryItems", "@brief Method void QUrl::removeAllQueryItems(const QString &key)\n", false, &_init_f_removeAllQueryItems_2025, &_call_f_removeAllQueryItems_2025);
  methods += new qt_gsi::GenericMethod ("removeEncodedQueryItem", "@brief Method void QUrl::removeEncodedQueryItem(const QByteArray &key)\n", false, &_init_f_removeEncodedQueryItem_2309, &_call_f_removeEncodedQueryItem_2309);
  methods += new qt_gsi::GenericMethod ("removeQueryItem", "@brief Method void QUrl::removeQueryItem(const QString &key)\n", false, &_init_f_removeQueryItem_2025, &_call_f_removeQueryItem_2025);
  methods += new qt_gsi::GenericMethod ("resolved", "@brief Method QUrl QUrl::resolved(const QUrl &relative)\n", true, &_init_f_resolved_c1701, &_call_f_resolved_c1701);
  methods += new qt_gsi::GenericMethod (":scheme", "@brief Method QString QUrl::scheme()\n", true, &_init_f_scheme_c0, &_call_f_scheme_c0);
  methods += new qt_gsi::GenericMethod ("setAuthority|authority=", "@brief Method void QUrl::setAuthority(const QString &authority)\n", false, &_init_f_setAuthority_2025, &_call_f_setAuthority_2025);
  methods += new qt_gsi::GenericMethod ("setEncodedFragment|encodedFragment=", "@brief Method void QUrl::setEncodedFragment(const QByteArray &fragment)\n", false, &_init_f_setEncodedFragment_2309, &_call_f_setEncodedFragment_2309);
  methods += new qt_gsi::GenericMethod ("setEncodedHost|encodedHost=", "@brief Method void QUrl::setEncodedHost(const QByteArray &host)\n", false, &_init_f_setEncodedHost_2309, &_call_f_setEncodedHost_2309);
  methods += new qt_gsi::GenericMethod ("setEncodedPassword|encodedPassword=", "@brief Method void QUrl::setEncodedPassword(const QByteArray &password)\n", false, &_init_f_setEncodedPassword_2309, &_call_f_setEncodedPassword_2309);
  methods += new qt_gsi::GenericMethod ("setEncodedPath|encodedPath=", "@brief Method void QUrl::setEncodedPath(const QByteArray &path)\n", false, &_init_f_setEncodedPath_2309, &_call_f_setEncodedPath_2309);
  methods += new qt_gsi::GenericMethod ("setEncodedQuery|encodedQuery=", "@brief Method void QUrl::setEncodedQuery(const QByteArray &query)\n", false, &_init_f_setEncodedQuery_2309, &_call_f_setEncodedQuery_2309);
  methods += new qt_gsi::GenericMethod ("setEncodedQueryItems|encodedQueryItems=", "@brief Method void QUrl::setEncodedQueryItems(const QList<QPair<QByteArray, QByteArray> > &query)\n", false, &_init_f_setEncodedQueryItems_4851, &_call_f_setEncodedQueryItems_4851);
  methods += new qt_gsi::GenericMethod ("setEncodedUrl", "@brief Method void QUrl::setEncodedUrl(const QByteArray &url)\n", false, &_init_f_setEncodedUrl_2309, &_call_f_setEncodedUrl_2309);
  methods += new qt_gsi::GenericMethod ("setEncodedUrl", "@brief Method void QUrl::setEncodedUrl(const QByteArray &url, QUrl::ParsingMode mode)\n", false, &_init_f_setEncodedUrl_4254, &_call_f_setEncodedUrl_4254);
  methods += new qt_gsi::GenericMethod ("setEncodedUserName|encodedUserName=", "@brief Method void QUrl::setEncodedUserName(const QByteArray &userName)\n", false, &_init_f_setEncodedUserName_2309, &_call_f_setEncodedUserName_2309);
  methods += new qt_gsi::GenericMethod ("setFragment|fragment=", "@brief Method void QUrl::setFragment(const QString &fragment)\n", false, &_init_f_setFragment_2025, &_call_f_setFragment_2025);
  methods += new qt_gsi::GenericMethod ("setHost|host=", "@brief Method void QUrl::setHost(const QString &host)\n", false, &_init_f_setHost_2025, &_call_f_setHost_2025);
  methods += new qt_gsi::GenericMethod ("setPassword|password=", "@brief Method void QUrl::setPassword(const QString &password)\n", false, &_init_f_setPassword_2025, &_call_f_setPassword_2025);
  methods += new qt_gsi::GenericMethod ("setPath|path=", "@brief Method void QUrl::setPath(const QString &path)\n", false, &_init_f_setPath_2025, &_call_f_setPath_2025);
  methods += new qt_gsi::GenericMethod ("setPort|port=", "@brief Method void QUrl::setPort(int port)\n", false, &_init_f_setPort_767, &_call_f_setPort_767);
  methods += new qt_gsi::GenericMethod ("setQueryDelimiters", "@brief Method void QUrl::setQueryDelimiters(char valueDelimiter, char pairDelimiter)\n", false, &_init_f_setQueryDelimiters_1592, &_call_f_setQueryDelimiters_1592);
  methods += new qt_gsi::GenericMethod ("setQueryItems|queryItems=", "@brief Method void QUrl::setQueryItems(const QList<QPair<QString, QString> > &query)\n", false, &_init_f_setQueryItems_4283, &_call_f_setQueryItems_4283);
  methods += new qt_gsi::GenericMethod ("setScheme|scheme=", "@brief Method void QUrl::setScheme(const QString &scheme)\n", false, &_init_f_setScheme_2025, &_call_f_setScheme_2025);
  methods += new qt_gsi::GenericMethod ("setUrl", "@brief Method void QUrl::setUrl(const QString &url)\n", false, &_init_f_setUrl_2025, &_call_f_setUrl_2025);
  methods += new qt_gsi::GenericMethod ("setUrl", "@brief Method void QUrl::setUrl(const QString &url, QUrl::ParsingMode mode)\n", false, &_init_f_setUrl_3970, &_call_f_setUrl_3970);
  methods += new qt_gsi::GenericMethod ("setUserInfo|userInfo=", "@brief Method void QUrl::setUserInfo(const QString &userInfo)\n", false, &_init_f_setUserInfo_2025, &_call_f_setUserInfo_2025);
  methods += new qt_gsi::GenericMethod ("setUserName|userName=", "@brief Method void QUrl::setUserName(const QString &userName)\n", false, &_init_f_setUserName_2025, &_call_f_setUserName_2025);
  methods += new qt_gsi::GenericMethod ("toEncoded", "@brief Method QByteArray QUrl::toEncoded(QFlags<QUrl::FormattingOption> options)\n", true, &_init_f_toEncoded_c3320, &_call_f_toEncoded_c3320);
  methods += new qt_gsi::GenericMethod ("toLocalFile", "@brief Method QString QUrl::toLocalFile()\n", true, &_init_f_toLocalFile_c0, &_call_f_toLocalFile_c0);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QUrl::toString(QFlags<QUrl::FormattingOption> options)\n", true, &_init_f_toString_c3320, &_call_f_toString_c3320);
  methods += new qt_gsi::GenericMethod (":userInfo", "@brief Method QString QUrl::userInfo()\n", true, &_init_f_userInfo_c0, &_call_f_userInfo_c0);
  methods += new qt_gsi::GenericMethod (":userName", "@brief Method QString QUrl::userName()\n", true, &_init_f_userName_c0, &_call_f_userName_c0);
  methods += new qt_gsi::GenericStaticMethod ("fromAce", "@brief Static method QString QUrl::fromAce(const QByteArray &)\nThis method is static and can be called without an instance.", &_init_f_fromAce_2309, &_call_f_fromAce_2309);
  methods += new qt_gsi::GenericStaticMethod ("fromEncoded", "@brief Static method QUrl QUrl::fromEncoded(const QByteArray &url)\nThis method is static and can be called without an instance.", &_init_f_fromEncoded_2309, &_call_f_fromEncoded_2309);
  methods += new qt_gsi::GenericStaticMethod ("fromEncoded", "@brief Static method QUrl QUrl::fromEncoded(const QByteArray &url, QUrl::ParsingMode mode)\nThis method is static and can be called without an instance.", &_init_f_fromEncoded_4254, &_call_f_fromEncoded_4254);
  methods += new qt_gsi::GenericStaticMethod ("fromLocalFile", "@brief Static method QUrl QUrl::fromLocalFile(const QString &localfile)\nThis method is static and can be called without an instance.", &_init_f_fromLocalFile_2025, &_call_f_fromLocalFile_2025);
  methods += new qt_gsi::GenericStaticMethod ("fromPercentEncoding", "@brief Static method QString QUrl::fromPercentEncoding(const QByteArray &)\nThis method is static and can be called without an instance.", &_init_f_fromPercentEncoding_2309, &_call_f_fromPercentEncoding_2309);
  methods += new qt_gsi::GenericStaticMethod ("fromPunycode", "@brief Static method QString QUrl::fromPunycode(const QByteArray &)\nThis method is static and can be called without an instance.", &_init_f_fromPunycode_2309, &_call_f_fromPunycode_2309);
  methods += new qt_gsi::GenericStaticMethod ("fromUserInput", "@brief Static method QUrl QUrl::fromUserInput(const QString &userInput)\nThis method is static and can be called without an instance.", &_init_f_fromUserInput_2025, &_call_f_fromUserInput_2025);
  methods += new qt_gsi::GenericStaticMethod (":idnWhitelist", "@brief Static method QStringList QUrl::idnWhitelist()\nThis method is static and can be called without an instance.", &_init_f_idnWhitelist_0, &_call_f_idnWhitelist_0);
  methods += new qt_gsi::GenericStaticMethod ("setIdnWhitelist|idnWhitelist=", "@brief Static method void QUrl::setIdnWhitelist(const QStringList &)\nThis method is static and can be called without an instance.", &_init_f_setIdnWhitelist_2437, &_call_f_setIdnWhitelist_2437);
  methods += new qt_gsi::GenericStaticMethod ("toAce", "@brief Static method QByteArray QUrl::toAce(const QString &)\nThis method is static and can be called without an instance.", &_init_f_toAce_2025, &_call_f_toAce_2025);
  methods += new qt_gsi::GenericStaticMethod ("toPercentEncoding", "@brief Static method QByteArray QUrl::toPercentEncoding(const QString &, const QByteArray &exclude, const QByteArray &include)\nThis method is static and can be called without an instance.", &_init_f_toPercentEncoding_6427, &_call_f_toPercentEncoding_6427);
  methods += new qt_gsi::GenericStaticMethod ("toPunycode", "@brief Static method QByteArray QUrl::toPunycode(const QString &)\nThis method is static and can be called without an instance.", &_init_f_toPunycode_2025, &_call_f_toPunycode_2025);
  return methods;
}

gsi::Class<QUrl> decl_QUrl ("QUrl",
  methods_QUrl (),
  "@qt\n@brief Binding of QUrl");


GSIQT_PUBLIC gsi::Class<QUrl> &qtdecl_QUrl () { return decl_QUrl; }

}


//  Implementation of the enum wrapper class for QUrl::FormattingOption
namespace qt_gsi
{

static gsi::Enum<QUrl::FormattingOption> decl_QUrl_FormattingOption_Enum ("QUrl_FormattingOption",
    gsi::enum_const ("None", QUrl::None, "@brief Enum constant QUrl::None") +
    gsi::enum_const ("RemoveScheme", QUrl::RemoveScheme, "@brief Enum constant QUrl::RemoveScheme") +
    gsi::enum_const ("RemovePassword", QUrl::RemovePassword, "@brief Enum constant QUrl::RemovePassword") +
    gsi::enum_const ("RemoveUserInfo", QUrl::RemoveUserInfo, "@brief Enum constant QUrl::RemoveUserInfo") +
    gsi::enum_const ("RemovePort", QUrl::RemovePort, "@brief Enum constant QUrl::RemovePort") +
    gsi::enum_const ("RemoveAuthority", QUrl::RemoveAuthority, "@brief Enum constant QUrl::RemoveAuthority") +
    gsi::enum_const ("RemovePath", QUrl::RemovePath, "@brief Enum constant QUrl::RemovePath") +
    gsi::enum_const ("RemoveQuery", QUrl::RemoveQuery, "@brief Enum constant QUrl::RemoveQuery") +
    gsi::enum_const ("RemoveFragment", QUrl::RemoveFragment, "@brief Enum constant QUrl::RemoveFragment") +
    gsi::enum_const ("StripTrailingSlash", QUrl::StripTrailingSlash, "@brief Enum constant QUrl::StripTrailingSlash"),
  "@qt\n@brief This class represents the QUrl::FormattingOption enum");

static gsi::QFlagsClass<QUrl::FormattingOption > decl_QUrl_FormattingOption_Enums ("QUrl_QFlags_FormattingOption",
  "@qt\n@brief This class represents the QFlags<QUrl::FormattingOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QUrl> inject_QUrl_FormattingOption_Enum_in_parent (decl_QUrl_FormattingOption_Enum.defs ());
static gsi::ClassExt<QUrl> decl_QUrl_FormattingOption_Enum_as_child (decl_QUrl_FormattingOption_Enum, "FormattingOption");
static gsi::ClassExt<QUrl> decl_QUrl_FormattingOption_Enums_as_child (decl_QUrl_FormattingOption_Enums, "QFlags_FormattingOption");

}


//  Implementation of the enum wrapper class for QUrl::ParsingMode
namespace qt_gsi
{

static gsi::Enum<QUrl::ParsingMode> decl_QUrl_ParsingMode_Enum ("QUrl_ParsingMode",
    gsi::enum_const ("TolerantMode", QUrl::TolerantMode, "@brief Enum constant QUrl::TolerantMode") +
    gsi::enum_const ("StrictMode", QUrl::StrictMode, "@brief Enum constant QUrl::StrictMode"),
  "@qt\n@brief This class represents the QUrl::ParsingMode enum");

static gsi::QFlagsClass<QUrl::ParsingMode > decl_QUrl_ParsingMode_Enums ("QUrl_QFlags_ParsingMode",
  "@qt\n@brief This class represents the QFlags<QUrl::ParsingMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QUrl> inject_QUrl_ParsingMode_Enum_in_parent (decl_QUrl_ParsingMode_Enum.defs ());
static gsi::ClassExt<QUrl> decl_QUrl_ParsingMode_Enum_as_child (decl_QUrl_ParsingMode_Enum, "ParsingMode");
static gsi::ClassExt<QUrl> decl_QUrl_ParsingMode_Enums_as_child (decl_QUrl_ParsingMode_Enums, "QFlags_ParsingMode");

}

