
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQXmlReader.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QXmlReader>
#include <QXmlContentHandler>
#include <QXmlDTDHandler>
#include <QXmlDeclHandler>
#include <QXmlEntityResolver>
#include <QXmlErrorHandler>
#include <QXmlInputSource>
#include <QXmlLexicalHandler>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QXmlReader

// QXmlDTDHandler *QXmlReader::DTDHandler()


static void _init_f_DTDHandler_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlDTDHandler * > ();
}

static void _call_f_DTDHandler_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlDTDHandler * > ((QXmlDTDHandler *)((QXmlReader *)cls)->DTDHandler ());
}


// QXmlContentHandler *QXmlReader::contentHandler()


static void _init_f_contentHandler_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlContentHandler * > ();
}

static void _call_f_contentHandler_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlContentHandler * > ((QXmlContentHandler *)((QXmlReader *)cls)->contentHandler ());
}


// QXmlDeclHandler *QXmlReader::declHandler()


static void _init_f_declHandler_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlDeclHandler * > ();
}

static void _call_f_declHandler_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlDeclHandler * > ((QXmlDeclHandler *)((QXmlReader *)cls)->declHandler ());
}


// QXmlEntityResolver *QXmlReader::entityResolver()


static void _init_f_entityResolver_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlEntityResolver * > ();
}

static void _call_f_entityResolver_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlEntityResolver * > ((QXmlEntityResolver *)((QXmlReader *)cls)->entityResolver ());
}


// QXmlErrorHandler *QXmlReader::errorHandler()


static void _init_f_errorHandler_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlErrorHandler * > ();
}

static void _call_f_errorHandler_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlErrorHandler * > ((QXmlErrorHandler *)((QXmlReader *)cls)->errorHandler ());
}


// bool QXmlReader::feature(const QString &name, bool *ok)


static void _init_f_feature_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_feature_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  bool *arg2 = args ? args.read<bool * > (heap) : (bool *)(0);
  ret.write<bool > ((bool)((QXmlReader *)cls)->feature (arg1, arg2));
}


// bool QXmlReader::hasFeature(const QString &name)


static void _init_f_hasFeature_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasFeature_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QXmlReader *)cls)->hasFeature (arg1));
}


// bool QXmlReader::hasProperty(const QString &name)


static void _init_f_hasProperty_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasProperty_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QXmlReader *)cls)->hasProperty (arg1));
}


// QXmlLexicalHandler *QXmlReader::lexicalHandler()


static void _init_f_lexicalHandler_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlLexicalHandler * > ();
}

static void _call_f_lexicalHandler_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlLexicalHandler * > ((QXmlLexicalHandler *)((QXmlReader *)cls)->lexicalHandler ());
}


// bool QXmlReader::parse(const QXmlInputSource &input)


static void _init_f_parse_2852 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<const QXmlInputSource & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_parse_2852 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlInputSource &arg1 = args.read<const QXmlInputSource & > (heap);
  ret.write<bool > ((bool)((QXmlReader *)cls)->parse (arg1));
}


// bool QXmlReader::parse(const QXmlInputSource *input)


static void _init_f_parse_2856 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<const QXmlInputSource * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_parse_2856 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlInputSource *arg1 = args.read<const QXmlInputSource * > (heap);
  ret.write<bool > ((bool)((QXmlReader *)cls)->parse (arg1));
}


// void *QXmlReader::property(const QString &name, bool *ok)


static void _init_f_property_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<void * > ();
}

static void _call_f_property_c2967 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  bool *arg2 = args ? args.read<bool * > (heap) : (bool *)(0);
  ret.write<void * > ((void *)((QXmlReader *)cls)->property (arg1, arg2));
}


// void QXmlReader::setContentHandler(QXmlContentHandler *handler)


static void _init_f_setContentHandler_2441 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlContentHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setContentHandler_2441 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlContentHandler *arg1 = args.read<QXmlContentHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader *)cls)->setContentHandler (arg1);
}


// void QXmlReader::setDTDHandler(QXmlDTDHandler *handler)


static void _init_f_setDTDHandler_1930 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlDTDHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDTDHandler_1930 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlDTDHandler *arg1 = args.read<QXmlDTDHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader *)cls)->setDTDHandler (arg1);
}


// void QXmlReader::setDeclHandler(QXmlDeclHandler *handler)


static void _init_f_setDeclHandler_2086 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlDeclHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDeclHandler_2086 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlDeclHandler *arg1 = args.read<QXmlDeclHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader *)cls)->setDeclHandler (arg1);
}


// void QXmlReader::setEntityResolver(QXmlEntityResolver *handler)


static void _init_f_setEntityResolver_2495 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlEntityResolver * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEntityResolver_2495 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlEntityResolver *arg1 = args.read<QXmlEntityResolver * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader *)cls)->setEntityResolver (arg1);
}


// void QXmlReader::setErrorHandler(QXmlErrorHandler *handler)


static void _init_f_setErrorHandler_2232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlErrorHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setErrorHandler_2232 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlErrorHandler *arg1 = args.read<QXmlErrorHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader *)cls)->setErrorHandler (arg1);
}


// void QXmlReader::setFeature(const QString &name, bool value)


static void _init_f_setFeature_2781 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFeature_2781 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  bool arg2 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader *)cls)->setFeature (arg1, arg2);
}


// void QXmlReader::setLexicalHandler(QXmlLexicalHandler *handler)


static void _init_f_setLexicalHandler_2416 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlLexicalHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLexicalHandler_2416 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlLexicalHandler *arg1 = args.read<QXmlLexicalHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader *)cls)->setLexicalHandler (arg1);
}


// void QXmlReader::setProperty(const QString &name, void *value)


static void _init_f_setProperty_2973 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<void * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setProperty_2973 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  void *arg2 = args.read<void * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader *)cls)->setProperty (arg1, arg2);
}


namespace gsi
{

static gsi::Methods methods_QXmlReader () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("DTDHandler", "@brief Method QXmlDTDHandler *QXmlReader::DTDHandler()\n", true, &_init_f_DTDHandler_c0, &_call_f_DTDHandler_c0);
  methods += new qt_gsi::GenericMethod (":contentHandler", "@brief Method QXmlContentHandler *QXmlReader::contentHandler()\n", true, &_init_f_contentHandler_c0, &_call_f_contentHandler_c0);
  methods += new qt_gsi::GenericMethod (":declHandler", "@brief Method QXmlDeclHandler *QXmlReader::declHandler()\n", true, &_init_f_declHandler_c0, &_call_f_declHandler_c0);
  methods += new qt_gsi::GenericMethod (":entityResolver", "@brief Method QXmlEntityResolver *QXmlReader::entityResolver()\n", true, &_init_f_entityResolver_c0, &_call_f_entityResolver_c0);
  methods += new qt_gsi::GenericMethod (":errorHandler", "@brief Method QXmlErrorHandler *QXmlReader::errorHandler()\n", true, &_init_f_errorHandler_c0, &_call_f_errorHandler_c0);
  methods += new qt_gsi::GenericMethod ("feature", "@brief Method bool QXmlReader::feature(const QString &name, bool *ok)\n", true, &_init_f_feature_c2967, &_call_f_feature_c2967);
  methods += new qt_gsi::GenericMethod ("hasFeature", "@brief Method bool QXmlReader::hasFeature(const QString &name)\n", true, &_init_f_hasFeature_c2025, &_call_f_hasFeature_c2025);
  methods += new qt_gsi::GenericMethod ("hasProperty", "@brief Method bool QXmlReader::hasProperty(const QString &name)\n", true, &_init_f_hasProperty_c2025, &_call_f_hasProperty_c2025);
  methods += new qt_gsi::GenericMethod (":lexicalHandler", "@brief Method QXmlLexicalHandler *QXmlReader::lexicalHandler()\n", true, &_init_f_lexicalHandler_c0, &_call_f_lexicalHandler_c0);
  methods += new qt_gsi::GenericMethod ("parse", "@brief Method bool QXmlReader::parse(const QXmlInputSource &input)\n", false, &_init_f_parse_2852, &_call_f_parse_2852);
  methods += new qt_gsi::GenericMethod ("parse", "@brief Method bool QXmlReader::parse(const QXmlInputSource *input)\n", false, &_init_f_parse_2856, &_call_f_parse_2856);
  methods += new qt_gsi::GenericMethod ("property", "@brief Method void *QXmlReader::property(const QString &name, bool *ok)\n", true, &_init_f_property_c2967, &_call_f_property_c2967);
  methods += new qt_gsi::GenericMethod ("setContentHandler|contentHandler=", "@brief Method void QXmlReader::setContentHandler(QXmlContentHandler *handler)\n", false, &_init_f_setContentHandler_2441, &_call_f_setContentHandler_2441);
  methods += new qt_gsi::GenericMethod ("setDTDHandler", "@brief Method void QXmlReader::setDTDHandler(QXmlDTDHandler *handler)\n", false, &_init_f_setDTDHandler_1930, &_call_f_setDTDHandler_1930);
  methods += new qt_gsi::GenericMethod ("setDeclHandler|declHandler=", "@brief Method void QXmlReader::setDeclHandler(QXmlDeclHandler *handler)\n", false, &_init_f_setDeclHandler_2086, &_call_f_setDeclHandler_2086);
  methods += new qt_gsi::GenericMethod ("setEntityResolver|entityResolver=", "@brief Method void QXmlReader::setEntityResolver(QXmlEntityResolver *handler)\n", false, &_init_f_setEntityResolver_2495, &_call_f_setEntityResolver_2495);
  methods += new qt_gsi::GenericMethod ("setErrorHandler|errorHandler=", "@brief Method void QXmlReader::setErrorHandler(QXmlErrorHandler *handler)\n", false, &_init_f_setErrorHandler_2232, &_call_f_setErrorHandler_2232);
  methods += new qt_gsi::GenericMethod ("setFeature", "@brief Method void QXmlReader::setFeature(const QString &name, bool value)\n", false, &_init_f_setFeature_2781, &_call_f_setFeature_2781);
  methods += new qt_gsi::GenericMethod ("setLexicalHandler|lexicalHandler=", "@brief Method void QXmlReader::setLexicalHandler(QXmlLexicalHandler *handler)\n", false, &_init_f_setLexicalHandler_2416, &_call_f_setLexicalHandler_2416);
  methods += new qt_gsi::GenericMethod ("setProperty", "@brief Method void QXmlReader::setProperty(const QString &name, void *value)\n", false, &_init_f_setProperty_2973, &_call_f_setProperty_2973);
  return methods;
}

gsi::Class<QXmlReader> decl_QXmlReader ("QXmlReader_Native",
  methods_QXmlReader (),
  "@hide\n@alias QXmlReader");

GSIQT_PUBLIC gsi::Class<QXmlReader> &qtdecl_QXmlReader () { return decl_QXmlReader; }

}


class QXmlReader_Adaptor : public QXmlReader, public qt_gsi::QtObjectBase
{
public:

  virtual ~QXmlReader_Adaptor();

  //  [adaptor ctor] QXmlReader::QXmlReader()
  QXmlReader_Adaptor() : QXmlReader()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] QXmlDTDHandler *QXmlReader::DTDHandler()
  QXmlDTDHandler * cbs_DTDHandler_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("DTDHandler");
  }

  virtual QXmlDTDHandler * DTDHandler() const
  {
    if (cb_DTDHandler_c0_0.can_issue()) {
      return cb_DTDHandler_c0_0.issue<QXmlReader_Adaptor, QXmlDTDHandler *>(&QXmlReader_Adaptor::cbs_DTDHandler_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("DTDHandler");
    }
  }

  //  [adaptor impl] QXmlContentHandler *QXmlReader::contentHandler()
  QXmlContentHandler * cbs_contentHandler_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("contentHandler");
  }

  virtual QXmlContentHandler * contentHandler() const
  {
    if (cb_contentHandler_c0_0.can_issue()) {
      return cb_contentHandler_c0_0.issue<QXmlReader_Adaptor, QXmlContentHandler *>(&QXmlReader_Adaptor::cbs_contentHandler_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("contentHandler");
    }
  }

  //  [adaptor impl] QXmlDeclHandler *QXmlReader::declHandler()
  QXmlDeclHandler * cbs_declHandler_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("declHandler");
  }

  virtual QXmlDeclHandler * declHandler() const
  {
    if (cb_declHandler_c0_0.can_issue()) {
      return cb_declHandler_c0_0.issue<QXmlReader_Adaptor, QXmlDeclHandler *>(&QXmlReader_Adaptor::cbs_declHandler_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("declHandler");
    }
  }

  //  [adaptor impl] QXmlEntityResolver *QXmlReader::entityResolver()
  QXmlEntityResolver * cbs_entityResolver_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("entityResolver");
  }

  virtual QXmlEntityResolver * entityResolver() const
  {
    if (cb_entityResolver_c0_0.can_issue()) {
      return cb_entityResolver_c0_0.issue<QXmlReader_Adaptor, QXmlEntityResolver *>(&QXmlReader_Adaptor::cbs_entityResolver_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("entityResolver");
    }
  }

  //  [adaptor impl] QXmlErrorHandler *QXmlReader::errorHandler()
  QXmlErrorHandler * cbs_errorHandler_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("errorHandler");
  }

  virtual QXmlErrorHandler * errorHandler() const
  {
    if (cb_errorHandler_c0_0.can_issue()) {
      return cb_errorHandler_c0_0.issue<QXmlReader_Adaptor, QXmlErrorHandler *>(&QXmlReader_Adaptor::cbs_errorHandler_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("errorHandler");
    }
  }

  //  [adaptor impl] bool QXmlReader::feature(const QString &name, bool *ok)
  bool cbs_feature_c2967_1(const QString &name, bool *ok) const
  {
    __SUPPRESS_UNUSED_WARNING (name);
    __SUPPRESS_UNUSED_WARNING (ok);
    throw qt_gsi::AbstractMethodCalledException("feature");
  }

  virtual bool feature(const QString &name, bool *ok) const
  {
    if (cb_feature_c2967_1.can_issue()) {
      return cb_feature_c2967_1.issue<QXmlReader_Adaptor, bool, const QString &, bool *>(&QXmlReader_Adaptor::cbs_feature_c2967_1, name, ok);
    } else {
      throw qt_gsi::AbstractMethodCalledException("feature");
    }
  }

  //  [adaptor impl] bool QXmlReader::hasFeature(const QString &name)
  bool cbs_hasFeature_c2025_0(const QString &name) const
  {
    __SUPPRESS_UNUSED_WARNING (name);
    throw qt_gsi::AbstractMethodCalledException("hasFeature");
  }

  virtual bool hasFeature(const QString &name) const
  {
    if (cb_hasFeature_c2025_0.can_issue()) {
      return cb_hasFeature_c2025_0.issue<QXmlReader_Adaptor, bool, const QString &>(&QXmlReader_Adaptor::cbs_hasFeature_c2025_0, name);
    } else {
      throw qt_gsi::AbstractMethodCalledException("hasFeature");
    }
  }

  //  [adaptor impl] bool QXmlReader::hasProperty(const QString &name)
  bool cbs_hasProperty_c2025_0(const QString &name) const
  {
    __SUPPRESS_UNUSED_WARNING (name);
    throw qt_gsi::AbstractMethodCalledException("hasProperty");
  }

  virtual bool hasProperty(const QString &name) const
  {
    if (cb_hasProperty_c2025_0.can_issue()) {
      return cb_hasProperty_c2025_0.issue<QXmlReader_Adaptor, bool, const QString &>(&QXmlReader_Adaptor::cbs_hasProperty_c2025_0, name);
    } else {
      throw qt_gsi::AbstractMethodCalledException("hasProperty");
    }
  }

  //  [adaptor impl] QXmlLexicalHandler *QXmlReader::lexicalHandler()
  QXmlLexicalHandler * cbs_lexicalHandler_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("lexicalHandler");
  }

  virtual QXmlLexicalHandler * lexicalHandler() const
  {
    if (cb_lexicalHandler_c0_0.can_issue()) {
      return cb_lexicalHandler_c0_0.issue<QXmlReader_Adaptor, QXmlLexicalHandler *>(&QXmlReader_Adaptor::cbs_lexicalHandler_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("lexicalHandler");
    }
  }

  //  [adaptor impl] bool QXmlReader::parse(const QXmlInputSource &input)
  bool cbs_parse_2852_0(const QXmlInputSource &input)
  {
    __SUPPRESS_UNUSED_WARNING (input);
    throw qt_gsi::AbstractMethodCalledException("parse");
  }

  virtual bool parse(const QXmlInputSource &input)
  {
    if (cb_parse_2852_0.can_issue()) {
      return cb_parse_2852_0.issue<QXmlReader_Adaptor, bool, const QXmlInputSource &>(&QXmlReader_Adaptor::cbs_parse_2852_0, input);
    } else {
      throw qt_gsi::AbstractMethodCalledException("parse");
    }
  }

  //  [adaptor impl] bool QXmlReader::parse(const QXmlInputSource *input)
  bool cbs_parse_2856_0(const QXmlInputSource *input)
  {
    __SUPPRESS_UNUSED_WARNING (input);
    throw qt_gsi::AbstractMethodCalledException("parse");
  }

  virtual bool parse(const QXmlInputSource *input)
  {
    if (cb_parse_2856_0.can_issue()) {
      return cb_parse_2856_0.issue<QXmlReader_Adaptor, bool, const QXmlInputSource *>(&QXmlReader_Adaptor::cbs_parse_2856_0, input);
    } else {
      throw qt_gsi::AbstractMethodCalledException("parse");
    }
  }

  //  [adaptor impl] void *QXmlReader::property(const QString &name, bool *ok)
  void * cbs_property_c2967_1(const QString &name, bool *ok) const
  {
    __SUPPRESS_UNUSED_WARNING (name);
    __SUPPRESS_UNUSED_WARNING (ok);
    throw qt_gsi::AbstractMethodCalledException("property");
  }

  virtual void * property(const QString &name, bool *ok) const
  {
    if (cb_property_c2967_1.can_issue()) {
      return cb_property_c2967_1.issue<QXmlReader_Adaptor, void *, const QString &, bool *>(&QXmlReader_Adaptor::cbs_property_c2967_1, name, ok);
    } else {
      throw qt_gsi::AbstractMethodCalledException("property");
    }
  }

  //  [adaptor impl] void QXmlReader::setContentHandler(QXmlContentHandler *handler)
  void cbs_setContentHandler_2441_0(QXmlContentHandler *handler)
  {
    __SUPPRESS_UNUSED_WARNING (handler);
    throw qt_gsi::AbstractMethodCalledException("setContentHandler");
  }

  virtual void setContentHandler(QXmlContentHandler *handler)
  {
    if (cb_setContentHandler_2441_0.can_issue()) {
      cb_setContentHandler_2441_0.issue<QXmlReader_Adaptor, QXmlContentHandler *>(&QXmlReader_Adaptor::cbs_setContentHandler_2441_0, handler);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setContentHandler");
    }
  }

  //  [adaptor impl] void QXmlReader::setDTDHandler(QXmlDTDHandler *handler)
  void cbs_setDTDHandler_1930_0(QXmlDTDHandler *handler)
  {
    __SUPPRESS_UNUSED_WARNING (handler);
    throw qt_gsi::AbstractMethodCalledException("setDTDHandler");
  }

  virtual void setDTDHandler(QXmlDTDHandler *handler)
  {
    if (cb_setDTDHandler_1930_0.can_issue()) {
      cb_setDTDHandler_1930_0.issue<QXmlReader_Adaptor, QXmlDTDHandler *>(&QXmlReader_Adaptor::cbs_setDTDHandler_1930_0, handler);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setDTDHandler");
    }
  }

  //  [adaptor impl] void QXmlReader::setDeclHandler(QXmlDeclHandler *handler)
  void cbs_setDeclHandler_2086_0(QXmlDeclHandler *handler)
  {
    __SUPPRESS_UNUSED_WARNING (handler);
    throw qt_gsi::AbstractMethodCalledException("setDeclHandler");
  }

  virtual void setDeclHandler(QXmlDeclHandler *handler)
  {
    if (cb_setDeclHandler_2086_0.can_issue()) {
      cb_setDeclHandler_2086_0.issue<QXmlReader_Adaptor, QXmlDeclHandler *>(&QXmlReader_Adaptor::cbs_setDeclHandler_2086_0, handler);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setDeclHandler");
    }
  }

  //  [adaptor impl] void QXmlReader::setEntityResolver(QXmlEntityResolver *handler)
  void cbs_setEntityResolver_2495_0(QXmlEntityResolver *handler)
  {
    __SUPPRESS_UNUSED_WARNING (handler);
    throw qt_gsi::AbstractMethodCalledException("setEntityResolver");
  }

  virtual void setEntityResolver(QXmlEntityResolver *handler)
  {
    if (cb_setEntityResolver_2495_0.can_issue()) {
      cb_setEntityResolver_2495_0.issue<QXmlReader_Adaptor, QXmlEntityResolver *>(&QXmlReader_Adaptor::cbs_setEntityResolver_2495_0, handler);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setEntityResolver");
    }
  }

  //  [adaptor impl] void QXmlReader::setErrorHandler(QXmlErrorHandler *handler)
  void cbs_setErrorHandler_2232_0(QXmlErrorHandler *handler)
  {
    __SUPPRESS_UNUSED_WARNING (handler);
    throw qt_gsi::AbstractMethodCalledException("setErrorHandler");
  }

  virtual void setErrorHandler(QXmlErrorHandler *handler)
  {
    if (cb_setErrorHandler_2232_0.can_issue()) {
      cb_setErrorHandler_2232_0.issue<QXmlReader_Adaptor, QXmlErrorHandler *>(&QXmlReader_Adaptor::cbs_setErrorHandler_2232_0, handler);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setErrorHandler");
    }
  }

  //  [adaptor impl] void QXmlReader::setFeature(const QString &name, bool value)
  void cbs_setFeature_2781_0(const QString &name, bool value)
  {
    __SUPPRESS_UNUSED_WARNING (name);
    __SUPPRESS_UNUSED_WARNING (value);
    throw qt_gsi::AbstractMethodCalledException("setFeature");
  }

  virtual void setFeature(const QString &name, bool value)
  {
    if (cb_setFeature_2781_0.can_issue()) {
      cb_setFeature_2781_0.issue<QXmlReader_Adaptor, const QString &, bool>(&QXmlReader_Adaptor::cbs_setFeature_2781_0, name, value);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setFeature");
    }
  }

  //  [adaptor impl] void QXmlReader::setLexicalHandler(QXmlLexicalHandler *handler)
  void cbs_setLexicalHandler_2416_0(QXmlLexicalHandler *handler)
  {
    __SUPPRESS_UNUSED_WARNING (handler);
    throw qt_gsi::AbstractMethodCalledException("setLexicalHandler");
  }

  virtual void setLexicalHandler(QXmlLexicalHandler *handler)
  {
    if (cb_setLexicalHandler_2416_0.can_issue()) {
      cb_setLexicalHandler_2416_0.issue<QXmlReader_Adaptor, QXmlLexicalHandler *>(&QXmlReader_Adaptor::cbs_setLexicalHandler_2416_0, handler);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setLexicalHandler");
    }
  }

  //  [adaptor impl] void QXmlReader::setProperty(const QString &name, void *value)
  void cbs_setProperty_2973_0(const QString &name, void *value)
  {
    __SUPPRESS_UNUSED_WARNING (name);
    __SUPPRESS_UNUSED_WARNING (value);
    throw qt_gsi::AbstractMethodCalledException("setProperty");
  }

  virtual void setProperty(const QString &name, void *value)
  {
    if (cb_setProperty_2973_0.can_issue()) {
      cb_setProperty_2973_0.issue<QXmlReader_Adaptor, const QString &, void *>(&QXmlReader_Adaptor::cbs_setProperty_2973_0, name, value);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setProperty");
    }
  }

  gsi::Callback cb_DTDHandler_c0_0;
  gsi::Callback cb_contentHandler_c0_0;
  gsi::Callback cb_declHandler_c0_0;
  gsi::Callback cb_entityResolver_c0_0;
  gsi::Callback cb_errorHandler_c0_0;
  gsi::Callback cb_feature_c2967_1;
  gsi::Callback cb_hasFeature_c2025_0;
  gsi::Callback cb_hasProperty_c2025_0;
  gsi::Callback cb_lexicalHandler_c0_0;
  gsi::Callback cb_parse_2852_0;
  gsi::Callback cb_parse_2856_0;
  gsi::Callback cb_property_c2967_1;
  gsi::Callback cb_setContentHandler_2441_0;
  gsi::Callback cb_setDTDHandler_1930_0;
  gsi::Callback cb_setDeclHandler_2086_0;
  gsi::Callback cb_setEntityResolver_2495_0;
  gsi::Callback cb_setErrorHandler_2232_0;
  gsi::Callback cb_setFeature_2781_0;
  gsi::Callback cb_setLexicalHandler_2416_0;
  gsi::Callback cb_setProperty_2973_0;
};

QXmlReader_Adaptor::~QXmlReader_Adaptor() { }

//  Constructor QXmlReader::QXmlReader() (adaptor class)

static void _init_ctor_QXmlReader_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QXmlReader_Adaptor> ();
}

static void _call_ctor_QXmlReader_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlReader_Adaptor *> (new QXmlReader_Adaptor ());
}


// QXmlDTDHandler *QXmlReader::DTDHandler()

static void _init_cbs_DTDHandler_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlDTDHandler * > ();
}

static void _call_cbs_DTDHandler_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlDTDHandler * > ((QXmlDTDHandler *)((QXmlReader_Adaptor *)cls)->cbs_DTDHandler_c0_0 ());
}

static void _set_callback_cbs_DTDHandler_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_DTDHandler_c0_0 = cb;
}


// QXmlContentHandler *QXmlReader::contentHandler()

static void _init_cbs_contentHandler_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlContentHandler * > ();
}

static void _call_cbs_contentHandler_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlContentHandler * > ((QXmlContentHandler *)((QXmlReader_Adaptor *)cls)->cbs_contentHandler_c0_0 ());
}

static void _set_callback_cbs_contentHandler_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_contentHandler_c0_0 = cb;
}


// QXmlDeclHandler *QXmlReader::declHandler()

static void _init_cbs_declHandler_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlDeclHandler * > ();
}

static void _call_cbs_declHandler_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlDeclHandler * > ((QXmlDeclHandler *)((QXmlReader_Adaptor *)cls)->cbs_declHandler_c0_0 ());
}

static void _set_callback_cbs_declHandler_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_declHandler_c0_0 = cb;
}


// QXmlEntityResolver *QXmlReader::entityResolver()

static void _init_cbs_entityResolver_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlEntityResolver * > ();
}

static void _call_cbs_entityResolver_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlEntityResolver * > ((QXmlEntityResolver *)((QXmlReader_Adaptor *)cls)->cbs_entityResolver_c0_0 ());
}

static void _set_callback_cbs_entityResolver_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_entityResolver_c0_0 = cb;
}


// QXmlErrorHandler *QXmlReader::errorHandler()

static void _init_cbs_errorHandler_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlErrorHandler * > ();
}

static void _call_cbs_errorHandler_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlErrorHandler * > ((QXmlErrorHandler *)((QXmlReader_Adaptor *)cls)->cbs_errorHandler_c0_0 ());
}

static void _set_callback_cbs_errorHandler_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_errorHandler_c0_0 = cb;
}


// bool QXmlReader::feature(const QString &name, bool *ok)

static void _init_cbs_feature_c2967_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_feature_c2967_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  bool *arg2 = args.read<bool * > (heap);
  ret.write<bool > ((bool)((QXmlReader_Adaptor *)cls)->cbs_feature_c2967_1 (arg1, arg2));
}

static void _set_callback_cbs_feature_c2967_1 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_feature_c2967_1 = cb;
}


// bool QXmlReader::hasFeature(const QString &name)

static void _init_cbs_hasFeature_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasFeature_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QXmlReader_Adaptor *)cls)->cbs_hasFeature_c2025_0 (arg1));
}

static void _set_callback_cbs_hasFeature_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_hasFeature_c2025_0 = cb;
}


// bool QXmlReader::hasProperty(const QString &name)

static void _init_cbs_hasProperty_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasProperty_c2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QXmlReader_Adaptor *)cls)->cbs_hasProperty_c2025_0 (arg1));
}

static void _set_callback_cbs_hasProperty_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_hasProperty_c2025_0 = cb;
}


// QXmlLexicalHandler *QXmlReader::lexicalHandler()

static void _init_cbs_lexicalHandler_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QXmlLexicalHandler * > ();
}

static void _call_cbs_lexicalHandler_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QXmlLexicalHandler * > ((QXmlLexicalHandler *)((QXmlReader_Adaptor *)cls)->cbs_lexicalHandler_c0_0 ());
}

static void _set_callback_cbs_lexicalHandler_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_lexicalHandler_c0_0 = cb;
}


// bool QXmlReader::parse(const QXmlInputSource &input)

static void _init_cbs_parse_2852_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<const QXmlInputSource & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_parse_2852_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlInputSource &arg1 = args.read<const QXmlInputSource & > (heap);
  ret.write<bool > ((bool)((QXmlReader_Adaptor *)cls)->cbs_parse_2852_0 (arg1));
}

static void _set_callback_cbs_parse_2852_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_parse_2852_0 = cb;
}


// bool QXmlReader::parse(const QXmlInputSource *input)

static void _init_cbs_parse_2856_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("input");
  decl->add_arg<const QXmlInputSource * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_parse_2856_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QXmlInputSource *arg1 = args.read<const QXmlInputSource * > (heap);
  ret.write<bool > ((bool)((QXmlReader_Adaptor *)cls)->cbs_parse_2856_0 (arg1));
}

static void _set_callback_cbs_parse_2856_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_parse_2856_0 = cb;
}


// void *QXmlReader::property(const QString &name, bool *ok)

static void _init_cbs_property_c2967_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<void * > ();
}

static void _call_cbs_property_c2967_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  bool *arg2 = args.read<bool * > (heap);
  ret.write<void * > ((void *)((QXmlReader_Adaptor *)cls)->cbs_property_c2967_1 (arg1, arg2));
}

static void _set_callback_cbs_property_c2967_1 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_property_c2967_1 = cb;
}


// void QXmlReader::setContentHandler(QXmlContentHandler *handler)

static void _init_cbs_setContentHandler_2441_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlContentHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setContentHandler_2441_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlContentHandler *arg1 = args.read<QXmlContentHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader_Adaptor *)cls)->cbs_setContentHandler_2441_0 (arg1);
}

static void _set_callback_cbs_setContentHandler_2441_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_setContentHandler_2441_0 = cb;
}


// void QXmlReader::setDTDHandler(QXmlDTDHandler *handler)

static void _init_cbs_setDTDHandler_1930_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlDTDHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setDTDHandler_1930_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlDTDHandler *arg1 = args.read<QXmlDTDHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader_Adaptor *)cls)->cbs_setDTDHandler_1930_0 (arg1);
}

static void _set_callback_cbs_setDTDHandler_1930_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_setDTDHandler_1930_0 = cb;
}


// void QXmlReader::setDeclHandler(QXmlDeclHandler *handler)

static void _init_cbs_setDeclHandler_2086_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlDeclHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setDeclHandler_2086_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlDeclHandler *arg1 = args.read<QXmlDeclHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader_Adaptor *)cls)->cbs_setDeclHandler_2086_0 (arg1);
}

static void _set_callback_cbs_setDeclHandler_2086_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_setDeclHandler_2086_0 = cb;
}


// void QXmlReader::setEntityResolver(QXmlEntityResolver *handler)

static void _init_cbs_setEntityResolver_2495_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlEntityResolver * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setEntityResolver_2495_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlEntityResolver *arg1 = args.read<QXmlEntityResolver * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader_Adaptor *)cls)->cbs_setEntityResolver_2495_0 (arg1);
}

static void _set_callback_cbs_setEntityResolver_2495_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_setEntityResolver_2495_0 = cb;
}


// void QXmlReader::setErrorHandler(QXmlErrorHandler *handler)

static void _init_cbs_setErrorHandler_2232_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlErrorHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setErrorHandler_2232_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlErrorHandler *arg1 = args.read<QXmlErrorHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader_Adaptor *)cls)->cbs_setErrorHandler_2232_0 (arg1);
}

static void _set_callback_cbs_setErrorHandler_2232_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_setErrorHandler_2232_0 = cb;
}


// void QXmlReader::setFeature(const QString &name, bool value)

static void _init_cbs_setFeature_2781_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setFeature_2781_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  bool arg2 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader_Adaptor *)cls)->cbs_setFeature_2781_0 (arg1, arg2);
}

static void _set_callback_cbs_setFeature_2781_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_setFeature_2781_0 = cb;
}


// void QXmlReader::setLexicalHandler(QXmlLexicalHandler *handler)

static void _init_cbs_setLexicalHandler_2416_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("handler");
  decl->add_arg<QXmlLexicalHandler * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setLexicalHandler_2416_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlLexicalHandler *arg1 = args.read<QXmlLexicalHandler * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader_Adaptor *)cls)->cbs_setLexicalHandler_2416_0 (arg1);
}

static void _set_callback_cbs_setLexicalHandler_2416_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_setLexicalHandler_2416_0 = cb;
}


// void QXmlReader::setProperty(const QString &name, void *value)

static void _init_cbs_setProperty_2973_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<void * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setProperty_2973_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  void *arg2 = args.read<void * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QXmlReader_Adaptor *)cls)->cbs_setProperty_2973_0 (arg1, arg2);
}

static void _set_callback_cbs_setProperty_2973_0 (void *cls, const gsi::Callback &cb)
{
  ((QXmlReader_Adaptor *)cls)->cb_setProperty_2973_0 = cb;
}


namespace gsi
{

gsi::Class<QXmlReader> &qtdecl_QXmlReader ();

static gsi::Methods methods_QXmlReader_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QXmlReader::QXmlReader()\nThis method creates an object of class QXmlReader.", &_init_ctor_QXmlReader_Adaptor_0, &_call_ctor_QXmlReader_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("DTDHandler", "@hide", true, &_init_cbs_DTDHandler_c0_0, &_call_cbs_DTDHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("DTDHandler", "@brief Virtual method QXmlDTDHandler *QXmlReader::DTDHandler()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_DTDHandler_c0_0, &_call_cbs_DTDHandler_c0_0, &_set_callback_cbs_DTDHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("contentHandler", "@hide", true, &_init_cbs_contentHandler_c0_0, &_call_cbs_contentHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("contentHandler", "@brief Virtual method QXmlContentHandler *QXmlReader::contentHandler()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_contentHandler_c0_0, &_call_cbs_contentHandler_c0_0, &_set_callback_cbs_contentHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("declHandler", "@hide", true, &_init_cbs_declHandler_c0_0, &_call_cbs_declHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("declHandler", "@brief Virtual method QXmlDeclHandler *QXmlReader::declHandler()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_declHandler_c0_0, &_call_cbs_declHandler_c0_0, &_set_callback_cbs_declHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("entityResolver", "@hide", true, &_init_cbs_entityResolver_c0_0, &_call_cbs_entityResolver_c0_0);
  methods += new qt_gsi::GenericMethod ("entityResolver", "@brief Virtual method QXmlEntityResolver *QXmlReader::entityResolver()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_entityResolver_c0_0, &_call_cbs_entityResolver_c0_0, &_set_callback_cbs_entityResolver_c0_0);
  methods += new qt_gsi::GenericMethod ("errorHandler", "@hide", true, &_init_cbs_errorHandler_c0_0, &_call_cbs_errorHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("errorHandler", "@brief Virtual method QXmlErrorHandler *QXmlReader::errorHandler()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_errorHandler_c0_0, &_call_cbs_errorHandler_c0_0, &_set_callback_cbs_errorHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("feature", "@hide", true, &_init_cbs_feature_c2967_1, &_call_cbs_feature_c2967_1);
  methods += new qt_gsi::GenericMethod ("feature", "@brief Virtual method bool QXmlReader::feature(const QString &name, bool *ok)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_feature_c2967_1, &_call_cbs_feature_c2967_1, &_set_callback_cbs_feature_c2967_1);
  methods += new qt_gsi::GenericMethod ("hasFeature", "@hide", true, &_init_cbs_hasFeature_c2025_0, &_call_cbs_hasFeature_c2025_0);
  methods += new qt_gsi::GenericMethod ("hasFeature", "@brief Virtual method bool QXmlReader::hasFeature(const QString &name)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasFeature_c2025_0, &_call_cbs_hasFeature_c2025_0, &_set_callback_cbs_hasFeature_c2025_0);
  methods += new qt_gsi::GenericMethod ("hasProperty", "@hide", true, &_init_cbs_hasProperty_c2025_0, &_call_cbs_hasProperty_c2025_0);
  methods += new qt_gsi::GenericMethod ("hasProperty", "@brief Virtual method bool QXmlReader::hasProperty(const QString &name)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasProperty_c2025_0, &_call_cbs_hasProperty_c2025_0, &_set_callback_cbs_hasProperty_c2025_0);
  methods += new qt_gsi::GenericMethod ("lexicalHandler", "@hide", true, &_init_cbs_lexicalHandler_c0_0, &_call_cbs_lexicalHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("lexicalHandler", "@brief Virtual method QXmlLexicalHandler *QXmlReader::lexicalHandler()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_lexicalHandler_c0_0, &_call_cbs_lexicalHandler_c0_0, &_set_callback_cbs_lexicalHandler_c0_0);
  methods += new qt_gsi::GenericMethod ("parse", "@hide", false, &_init_cbs_parse_2852_0, &_call_cbs_parse_2852_0);
  methods += new qt_gsi::GenericMethod ("parse", "@brief Virtual method bool QXmlReader::parse(const QXmlInputSource &input)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_parse_2852_0, &_call_cbs_parse_2852_0, &_set_callback_cbs_parse_2852_0);
  methods += new qt_gsi::GenericMethod ("parse", "@hide", false, &_init_cbs_parse_2856_0, &_call_cbs_parse_2856_0);
  methods += new qt_gsi::GenericMethod ("parse", "@brief Virtual method bool QXmlReader::parse(const QXmlInputSource *input)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_parse_2856_0, &_call_cbs_parse_2856_0, &_set_callback_cbs_parse_2856_0);
  methods += new qt_gsi::GenericMethod ("property", "@hide", true, &_init_cbs_property_c2967_1, &_call_cbs_property_c2967_1);
  methods += new qt_gsi::GenericMethod ("property", "@brief Virtual method void *QXmlReader::property(const QString &name, bool *ok)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_property_c2967_1, &_call_cbs_property_c2967_1, &_set_callback_cbs_property_c2967_1);
  methods += new qt_gsi::GenericMethod ("setContentHandler", "@hide", false, &_init_cbs_setContentHandler_2441_0, &_call_cbs_setContentHandler_2441_0);
  methods += new qt_gsi::GenericMethod ("setContentHandler", "@brief Virtual method void QXmlReader::setContentHandler(QXmlContentHandler *handler)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setContentHandler_2441_0, &_call_cbs_setContentHandler_2441_0, &_set_callback_cbs_setContentHandler_2441_0);
  methods += new qt_gsi::GenericMethod ("setDTDHandler", "@hide", false, &_init_cbs_setDTDHandler_1930_0, &_call_cbs_setDTDHandler_1930_0);
  methods += new qt_gsi::GenericMethod ("setDTDHandler", "@brief Virtual method void QXmlReader::setDTDHandler(QXmlDTDHandler *handler)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setDTDHandler_1930_0, &_call_cbs_setDTDHandler_1930_0, &_set_callback_cbs_setDTDHandler_1930_0);
  methods += new qt_gsi::GenericMethod ("setDeclHandler", "@hide", false, &_init_cbs_setDeclHandler_2086_0, &_call_cbs_setDeclHandler_2086_0);
  methods += new qt_gsi::GenericMethod ("setDeclHandler", "@brief Virtual method void QXmlReader::setDeclHandler(QXmlDeclHandler *handler)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setDeclHandler_2086_0, &_call_cbs_setDeclHandler_2086_0, &_set_callback_cbs_setDeclHandler_2086_0);
  methods += new qt_gsi::GenericMethod ("setEntityResolver", "@hide", false, &_init_cbs_setEntityResolver_2495_0, &_call_cbs_setEntityResolver_2495_0);
  methods += new qt_gsi::GenericMethod ("setEntityResolver", "@brief Virtual method void QXmlReader::setEntityResolver(QXmlEntityResolver *handler)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setEntityResolver_2495_0, &_call_cbs_setEntityResolver_2495_0, &_set_callback_cbs_setEntityResolver_2495_0);
  methods += new qt_gsi::GenericMethod ("setErrorHandler", "@hide", false, &_init_cbs_setErrorHandler_2232_0, &_call_cbs_setErrorHandler_2232_0);
  methods += new qt_gsi::GenericMethod ("setErrorHandler", "@brief Virtual method void QXmlReader::setErrorHandler(QXmlErrorHandler *handler)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setErrorHandler_2232_0, &_call_cbs_setErrorHandler_2232_0, &_set_callback_cbs_setErrorHandler_2232_0);
  methods += new qt_gsi::GenericMethod ("setFeature", "@hide", false, &_init_cbs_setFeature_2781_0, &_call_cbs_setFeature_2781_0);
  methods += new qt_gsi::GenericMethod ("setFeature", "@brief Virtual method void QXmlReader::setFeature(const QString &name, bool value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFeature_2781_0, &_call_cbs_setFeature_2781_0, &_set_callback_cbs_setFeature_2781_0);
  methods += new qt_gsi::GenericMethod ("setLexicalHandler", "@hide", false, &_init_cbs_setLexicalHandler_2416_0, &_call_cbs_setLexicalHandler_2416_0);
  methods += new qt_gsi::GenericMethod ("setLexicalHandler", "@brief Virtual method void QXmlReader::setLexicalHandler(QXmlLexicalHandler *handler)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setLexicalHandler_2416_0, &_call_cbs_setLexicalHandler_2416_0, &_set_callback_cbs_setLexicalHandler_2416_0);
  methods += new qt_gsi::GenericMethod ("setProperty", "@hide", false, &_init_cbs_setProperty_2973_0, &_call_cbs_setProperty_2973_0);
  methods += new qt_gsi::GenericMethod ("setProperty", "@brief Virtual method void QXmlReader::setProperty(const QString &name, void *value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setProperty_2973_0, &_call_cbs_setProperty_2973_0, &_set_callback_cbs_setProperty_2973_0);
  return methods;
}

gsi::Class<QXmlReader_Adaptor> decl_QXmlReader_Adaptor (qtdecl_QXmlReader (), "QXmlReader",
  methods_QXmlReader_Adaptor (),
  "@qt\n@brief Binding of QXmlReader");

}

