
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAccessible.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAccessible>
#include <QAccessibleEvent>
#include <QAccessibleInterface>
#include <QObject>
#include <QTextCursor>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAccessible

// static QAccessibleInterface *QAccessible::accessibleInterface(unsigned int uniqueId)


static void _init_f_accessibleInterface_1772 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("uniqueId");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_f_accessibleInterface_1772 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)QAccessible::accessibleInterface (arg1));
}


// static void QAccessible::cleanup()


static void _init_f_cleanup_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cleanup_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  QAccessible::cleanup ();
}


// static void QAccessible::deleteAccessibleInterface(unsigned int uniqueId)


static void _init_f_deleteAccessibleInterface_1772 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("uniqueId");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_deleteAccessibleInterface_1772 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QAccessible::deleteAccessibleInterface (arg1);
}


// static void QAccessible::installActivationObserver(QAccessible::ActivationObserver *)


static void _init_f_installActivationObserver_3707 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QAccessible::ActivationObserver * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_installActivationObserver_3707 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAccessible::ActivationObserver *arg1 = args.read<QAccessible::ActivationObserver * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QAccessible::installActivationObserver (arg1);
}


// static bool QAccessible::isActive()


static void _init_f_isActive_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)QAccessible::isActive ());
}


// static QPair<int, int> QAccessible::qAccessibleTextBoundaryHelper(const QTextCursor &cursor, QAccessible::TextBoundaryType boundaryType)


static void _init_f_qAccessibleTextBoundaryHelper_5659 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("boundaryType");
  decl->add_arg<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (argspec_1);
  decl->set_return<QPair<int, int> > ();
}

static void _call_f_qAccessibleTextBoundaryHelper_5659 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTextCursor &arg1 = args.read<const QTextCursor & > (heap);
  const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & arg2 = args.read<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (heap);
  ret.write<QPair<int, int> > ((QPair<int, int>)QAccessible::qAccessibleTextBoundaryHelper (arg1, qt_gsi::QtToCppAdaptor<QAccessible::TextBoundaryType>(arg2).cref()));
}


// static QAccessibleInterface *QAccessible::queryAccessibleInterface(QObject *)


static void _init_f_queryAccessibleInterface_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_f_queryAccessibleInterface_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)QAccessible::queryAccessibleInterface (arg1));
}


// static unsigned int QAccessible::registerAccessibleInterface(QAccessibleInterface *iface)


static void _init_f_registerAccessibleInterface_2622 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iface");
  decl->add_arg<QAccessibleInterface * > (argspec_0);
  decl->set_return<unsigned int > ();
}

static void _call_f_registerAccessibleInterface_2622 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAccessibleInterface *arg1 = args.read<QAccessibleInterface * > (heap);
  ret.write<unsigned int > ((unsigned int)QAccessible::registerAccessibleInterface (arg1));
}


// static void QAccessible::removeActivationObserver(QAccessible::ActivationObserver *)


static void _init_f_removeActivationObserver_3707 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QAccessible::ActivationObserver * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeActivationObserver_3707 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAccessible::ActivationObserver *arg1 = args.read<QAccessible::ActivationObserver * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QAccessible::removeActivationObserver (arg1);
}


// static void QAccessible::setActive(bool active)


static void _init_f_setActive_864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("active");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActive_864 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QAccessible::setActive (arg1);
}


// static void QAccessible::setRootObject(QObject *object)


static void _init_f_setRootObject_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRootObject_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QAccessible::setRootObject (arg1);
}


// static unsigned int QAccessible::uniqueId(QAccessibleInterface *iface)


static void _init_f_uniqueId_2622 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iface");
  decl->add_arg<QAccessibleInterface * > (argspec_0);
  decl->set_return<unsigned int > ();
}

static void _call_f_uniqueId_2622 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAccessibleInterface *arg1 = args.read<QAccessibleInterface * > (heap);
  ret.write<unsigned int > ((unsigned int)QAccessible::uniqueId (arg1));
}


// static void QAccessible::updateAccessibility(QAccessibleEvent *event)


static void _init_f_updateAccessibility_2223 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QAccessibleEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_updateAccessibility_2223 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAccessibleEvent *arg1 = args.read<QAccessibleEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QAccessible::updateAccessibility (arg1);
}



namespace gsi
{

static gsi::Methods methods_QAccessible () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("accessibleInterface", "@brief Static method QAccessibleInterface *QAccessible::accessibleInterface(unsigned int uniqueId)\nThis method is static and can be called without an instance.", &_init_f_accessibleInterface_1772, &_call_f_accessibleInterface_1772);
  methods += new qt_gsi::GenericStaticMethod ("cleanup", "@brief Static method void QAccessible::cleanup()\nThis method is static and can be called without an instance.", &_init_f_cleanup_0, &_call_f_cleanup_0);
  methods += new qt_gsi::GenericStaticMethod ("deleteAccessibleInterface", "@brief Static method void QAccessible::deleteAccessibleInterface(unsigned int uniqueId)\nThis method is static and can be called without an instance.", &_init_f_deleteAccessibleInterface_1772, &_call_f_deleteAccessibleInterface_1772);
  methods += new qt_gsi::GenericStaticMethod ("installActivationObserver", "@brief Static method void QAccessible::installActivationObserver(QAccessible::ActivationObserver *)\nThis method is static and can be called without an instance.", &_init_f_installActivationObserver_3707, &_call_f_installActivationObserver_3707);
  methods += new qt_gsi::GenericStaticMethod ("isActive?|:active", "@brief Static method bool QAccessible::isActive()\nThis method is static and can be called without an instance.", &_init_f_isActive_0, &_call_f_isActive_0);
  methods += new qt_gsi::GenericStaticMethod ("qAccessibleTextBoundaryHelper", "@brief Static method QPair<int, int> QAccessible::qAccessibleTextBoundaryHelper(const QTextCursor &cursor, QAccessible::TextBoundaryType boundaryType)\nThis method is static and can be called without an instance.", &_init_f_qAccessibleTextBoundaryHelper_5659, &_call_f_qAccessibleTextBoundaryHelper_5659);
  methods += new qt_gsi::GenericStaticMethod ("queryAccessibleInterface", "@brief Static method QAccessibleInterface *QAccessible::queryAccessibleInterface(QObject *)\nThis method is static and can be called without an instance.", &_init_f_queryAccessibleInterface_1302, &_call_f_queryAccessibleInterface_1302);
  methods += new qt_gsi::GenericStaticMethod ("registerAccessibleInterface", "@brief Static method unsigned int QAccessible::registerAccessibleInterface(QAccessibleInterface *iface)\nThis method is static and can be called without an instance.", &_init_f_registerAccessibleInterface_2622, &_call_f_registerAccessibleInterface_2622);
  methods += new qt_gsi::GenericStaticMethod ("removeActivationObserver", "@brief Static method void QAccessible::removeActivationObserver(QAccessible::ActivationObserver *)\nThis method is static and can be called without an instance.", &_init_f_removeActivationObserver_3707, &_call_f_removeActivationObserver_3707);
  methods += new qt_gsi::GenericStaticMethod ("setActive|active=", "@brief Static method void QAccessible::setActive(bool active)\nThis method is static and can be called without an instance.", &_init_f_setActive_864, &_call_f_setActive_864);
  methods += new qt_gsi::GenericStaticMethod ("setRootObject", "@brief Static method void QAccessible::setRootObject(QObject *object)\nThis method is static and can be called without an instance.", &_init_f_setRootObject_1302, &_call_f_setRootObject_1302);
  methods += new qt_gsi::GenericStaticMethod ("uniqueId", "@brief Static method unsigned int QAccessible::uniqueId(QAccessibleInterface *iface)\nThis method is static and can be called without an instance.", &_init_f_uniqueId_2622, &_call_f_uniqueId_2622);
  methods += new qt_gsi::GenericStaticMethod ("updateAccessibility", "@brief Static method void QAccessible::updateAccessibility(QAccessibleEvent *event)\nThis method is static and can be called without an instance.", &_init_f_updateAccessibility_2223, &_call_f_updateAccessibility_2223);
  return methods;
}

gsi::Class<QAccessible> decl_QAccessible ("QAccessible",
  methods_QAccessible (),
  "@qt\n@brief Binding of QAccessible");


GSIQT_PUBLIC gsi::Class<QAccessible> &qtdecl_QAccessible () { return decl_QAccessible; }

}


//  Implementation of the enum wrapper class for QAccessible::Event
namespace qt_gsi
{

static gsi::Enum<QAccessible::Event> decl_QAccessible_Event_Enum ("QAccessible_Event",
    gsi::enum_const ("SoundPlayed", QAccessible::SoundPlayed, "@brief Enum constant QAccessible::SoundPlayed") +
    gsi::enum_const ("Alert", QAccessible::Alert, "@brief Enum constant QAccessible::Alert") +
    gsi::enum_const ("ForegroundChanged", QAccessible::ForegroundChanged, "@brief Enum constant QAccessible::ForegroundChanged") +
    gsi::enum_const ("MenuStart", QAccessible::MenuStart, "@brief Enum constant QAccessible::MenuStart") +
    gsi::enum_const ("MenuEnd", QAccessible::MenuEnd, "@brief Enum constant QAccessible::MenuEnd") +
    gsi::enum_const ("PopupMenuStart", QAccessible::PopupMenuStart, "@brief Enum constant QAccessible::PopupMenuStart") +
    gsi::enum_const ("PopupMenuEnd", QAccessible::PopupMenuEnd, "@brief Enum constant QAccessible::PopupMenuEnd") +
    gsi::enum_const ("ContextHelpStart", QAccessible::ContextHelpStart, "@brief Enum constant QAccessible::ContextHelpStart") +
    gsi::enum_const ("ContextHelpEnd", QAccessible::ContextHelpEnd, "@brief Enum constant QAccessible::ContextHelpEnd") +
    gsi::enum_const ("DragDropStart", QAccessible::DragDropStart, "@brief Enum constant QAccessible::DragDropStart") +
    gsi::enum_const ("DragDropEnd", QAccessible::DragDropEnd, "@brief Enum constant QAccessible::DragDropEnd") +
    gsi::enum_const ("DialogStart", QAccessible::DialogStart, "@brief Enum constant QAccessible::DialogStart") +
    gsi::enum_const ("DialogEnd", QAccessible::DialogEnd, "@brief Enum constant QAccessible::DialogEnd") +
    gsi::enum_const ("ScrollingStart", QAccessible::ScrollingStart, "@brief Enum constant QAccessible::ScrollingStart") +
    gsi::enum_const ("ScrollingEnd", QAccessible::ScrollingEnd, "@brief Enum constant QAccessible::ScrollingEnd") +
    gsi::enum_const ("MenuCommand", QAccessible::MenuCommand, "@brief Enum constant QAccessible::MenuCommand") +
    gsi::enum_const ("ActionChanged", QAccessible::ActionChanged, "@brief Enum constant QAccessible::ActionChanged") +
    gsi::enum_const ("ActiveDescendantChanged", QAccessible::ActiveDescendantChanged, "@brief Enum constant QAccessible::ActiveDescendantChanged") +
    gsi::enum_const ("AttributeChanged", QAccessible::AttributeChanged, "@brief Enum constant QAccessible::AttributeChanged") +
    gsi::enum_const ("DocumentContentChanged", QAccessible::DocumentContentChanged, "@brief Enum constant QAccessible::DocumentContentChanged") +
    gsi::enum_const ("DocumentLoadComplete", QAccessible::DocumentLoadComplete, "@brief Enum constant QAccessible::DocumentLoadComplete") +
    gsi::enum_const ("DocumentLoadStopped", QAccessible::DocumentLoadStopped, "@brief Enum constant QAccessible::DocumentLoadStopped") +
    gsi::enum_const ("DocumentReload", QAccessible::DocumentReload, "@brief Enum constant QAccessible::DocumentReload") +
    gsi::enum_const ("HyperlinkEndIndexChanged", QAccessible::HyperlinkEndIndexChanged, "@brief Enum constant QAccessible::HyperlinkEndIndexChanged") +
    gsi::enum_const ("HyperlinkNumberOfAnchorsChanged", QAccessible::HyperlinkNumberOfAnchorsChanged, "@brief Enum constant QAccessible::HyperlinkNumberOfAnchorsChanged") +
    gsi::enum_const ("HyperlinkSelectedLinkChanged", QAccessible::HyperlinkSelectedLinkChanged, "@brief Enum constant QAccessible::HyperlinkSelectedLinkChanged") +
    gsi::enum_const ("HypertextLinkActivated", QAccessible::HypertextLinkActivated, "@brief Enum constant QAccessible::HypertextLinkActivated") +
    gsi::enum_const ("HypertextLinkSelected", QAccessible::HypertextLinkSelected, "@brief Enum constant QAccessible::HypertextLinkSelected") +
    gsi::enum_const ("HyperlinkStartIndexChanged", QAccessible::HyperlinkStartIndexChanged, "@brief Enum constant QAccessible::HyperlinkStartIndexChanged") +
    gsi::enum_const ("HypertextChanged", QAccessible::HypertextChanged, "@brief Enum constant QAccessible::HypertextChanged") +
    gsi::enum_const ("HypertextNLinksChanged", QAccessible::HypertextNLinksChanged, "@brief Enum constant QAccessible::HypertextNLinksChanged") +
    gsi::enum_const ("ObjectAttributeChanged", QAccessible::ObjectAttributeChanged, "@brief Enum constant QAccessible::ObjectAttributeChanged") +
    gsi::enum_const ("PageChanged", QAccessible::PageChanged, "@brief Enum constant QAccessible::PageChanged") +
    gsi::enum_const ("SectionChanged", QAccessible::SectionChanged, "@brief Enum constant QAccessible::SectionChanged") +
    gsi::enum_const ("TableCaptionChanged", QAccessible::TableCaptionChanged, "@brief Enum constant QAccessible::TableCaptionChanged") +
    gsi::enum_const ("TableColumnDescriptionChanged", QAccessible::TableColumnDescriptionChanged, "@brief Enum constant QAccessible::TableColumnDescriptionChanged") +
    gsi::enum_const ("TableColumnHeaderChanged", QAccessible::TableColumnHeaderChanged, "@brief Enum constant QAccessible::TableColumnHeaderChanged") +
    gsi::enum_const ("TableModelChanged", QAccessible::TableModelChanged, "@brief Enum constant QAccessible::TableModelChanged") +
    gsi::enum_const ("TableRowDescriptionChanged", QAccessible::TableRowDescriptionChanged, "@brief Enum constant QAccessible::TableRowDescriptionChanged") +
    gsi::enum_const ("TableRowHeaderChanged", QAccessible::TableRowHeaderChanged, "@brief Enum constant QAccessible::TableRowHeaderChanged") +
    gsi::enum_const ("TableSummaryChanged", QAccessible::TableSummaryChanged, "@brief Enum constant QAccessible::TableSummaryChanged") +
    gsi::enum_const ("TextAttributeChanged", QAccessible::TextAttributeChanged, "@brief Enum constant QAccessible::TextAttributeChanged") +
    gsi::enum_const ("TextCaretMoved", QAccessible::TextCaretMoved, "@brief Enum constant QAccessible::TextCaretMoved") +
    gsi::enum_const ("TextColumnChanged", QAccessible::TextColumnChanged, "@brief Enum constant QAccessible::TextColumnChanged") +
    gsi::enum_const ("TextInserted", QAccessible::TextInserted, "@brief Enum constant QAccessible::TextInserted") +
    gsi::enum_const ("TextRemoved", QAccessible::TextRemoved, "@brief Enum constant QAccessible::TextRemoved") +
    gsi::enum_const ("TextUpdated", QAccessible::TextUpdated, "@brief Enum constant QAccessible::TextUpdated") +
    gsi::enum_const ("TextSelectionChanged", QAccessible::TextSelectionChanged, "@brief Enum constant QAccessible::TextSelectionChanged") +
    gsi::enum_const ("VisibleDataChanged", QAccessible::VisibleDataChanged, "@brief Enum constant QAccessible::VisibleDataChanged") +
    gsi::enum_const ("ObjectCreated", QAccessible::ObjectCreated, "@brief Enum constant QAccessible::ObjectCreated") +
    gsi::enum_const ("ObjectDestroyed", QAccessible::ObjectDestroyed, "@brief Enum constant QAccessible::ObjectDestroyed") +
    gsi::enum_const ("ObjectShow", QAccessible::ObjectShow, "@brief Enum constant QAccessible::ObjectShow") +
    gsi::enum_const ("ObjectHide", QAccessible::ObjectHide, "@brief Enum constant QAccessible::ObjectHide") +
    gsi::enum_const ("ObjectReorder", QAccessible::ObjectReorder, "@brief Enum constant QAccessible::ObjectReorder") +
    gsi::enum_const ("Focus", QAccessible::Focus, "@brief Enum constant QAccessible::Focus") +
    gsi::enum_const ("Selection", QAccessible::Selection, "@brief Enum constant QAccessible::Selection") +
    gsi::enum_const ("SelectionAdd", QAccessible::SelectionAdd, "@brief Enum constant QAccessible::SelectionAdd") +
    gsi::enum_const ("SelectionRemove", QAccessible::SelectionRemove, "@brief Enum constant QAccessible::SelectionRemove") +
    gsi::enum_const ("SelectionWithin", QAccessible::SelectionWithin, "@brief Enum constant QAccessible::SelectionWithin") +
    gsi::enum_const ("StateChanged", QAccessible::StateChanged, "@brief Enum constant QAccessible::StateChanged") +
    gsi::enum_const ("LocationChanged", QAccessible::LocationChanged, "@brief Enum constant QAccessible::LocationChanged") +
    gsi::enum_const ("NameChanged", QAccessible::NameChanged, "@brief Enum constant QAccessible::NameChanged") +
    gsi::enum_const ("DescriptionChanged", QAccessible::DescriptionChanged, "@brief Enum constant QAccessible::DescriptionChanged") +
    gsi::enum_const ("ValueChanged", QAccessible::ValueChanged, "@brief Enum constant QAccessible::ValueChanged") +
    gsi::enum_const ("ParentChanged", QAccessible::ParentChanged, "@brief Enum constant QAccessible::ParentChanged") +
    gsi::enum_const ("HelpChanged", QAccessible::HelpChanged, "@brief Enum constant QAccessible::HelpChanged") +
    gsi::enum_const ("DefaultActionChanged", QAccessible::DefaultActionChanged, "@brief Enum constant QAccessible::DefaultActionChanged") +
    gsi::enum_const ("AcceleratorChanged", QAccessible::AcceleratorChanged, "@brief Enum constant QAccessible::AcceleratorChanged") +
    gsi::enum_const ("InvalidEvent", QAccessible::InvalidEvent, "@brief Enum constant QAccessible::InvalidEvent"),
  "@qt\n@brief This class represents the QAccessible::Event enum");

static gsi::QFlagsClass<QAccessible::Event > decl_QAccessible_Event_Enums ("QAccessible_QFlags_Event",
  "@qt\n@brief This class represents the QFlags<QAccessible::Event> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAccessible> inject_QAccessible_Event_Enum_in_parent (decl_QAccessible_Event_Enum.defs ());
static gsi::ClassExt<QAccessible> decl_QAccessible_Event_Enum_as_child (decl_QAccessible_Event_Enum, "Event");
static gsi::ClassExt<QAccessible> decl_QAccessible_Event_Enums_as_child (decl_QAccessible_Event_Enums, "QFlags_Event");

}


//  Implementation of the enum wrapper class for QAccessible::InterfaceType
namespace qt_gsi
{

static gsi::Enum<QAccessible::InterfaceType> decl_QAccessible_InterfaceType_Enum ("QAccessible_InterfaceType",
    gsi::enum_const ("TextInterface", QAccessible::TextInterface, "@brief Enum constant QAccessible::TextInterface") +
    gsi::enum_const ("EditableTextInterface", QAccessible::EditableTextInterface, "@brief Enum constant QAccessible::EditableTextInterface") +
    gsi::enum_const ("ValueInterface", QAccessible::ValueInterface, "@brief Enum constant QAccessible::ValueInterface") +
    gsi::enum_const ("ActionInterface", QAccessible::ActionInterface, "@brief Enum constant QAccessible::ActionInterface") +
    gsi::enum_const ("ImageInterface", QAccessible::ImageInterface, "@brief Enum constant QAccessible::ImageInterface") +
    gsi::enum_const ("TableInterface", QAccessible::TableInterface, "@brief Enum constant QAccessible::TableInterface") +
    gsi::enum_const ("TableCellInterface", QAccessible::TableCellInterface, "@brief Enum constant QAccessible::TableCellInterface"),
  "@qt\n@brief This class represents the QAccessible::InterfaceType enum");

static gsi::QFlagsClass<QAccessible::InterfaceType > decl_QAccessible_InterfaceType_Enums ("QAccessible_QFlags_InterfaceType",
  "@qt\n@brief This class represents the QFlags<QAccessible::InterfaceType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAccessible> inject_QAccessible_InterfaceType_Enum_in_parent (decl_QAccessible_InterfaceType_Enum.defs ());
static gsi::ClassExt<QAccessible> decl_QAccessible_InterfaceType_Enum_as_child (decl_QAccessible_InterfaceType_Enum, "InterfaceType");
static gsi::ClassExt<QAccessible> decl_QAccessible_InterfaceType_Enums_as_child (decl_QAccessible_InterfaceType_Enums, "QFlags_InterfaceType");

}


//  Implementation of the enum wrapper class for QAccessible::RelationFlag
namespace qt_gsi
{

static gsi::Enum<QAccessible::RelationFlag> decl_QAccessible_RelationFlag_Enum ("QAccessible_RelationFlag",
    gsi::enum_const ("Label", QAccessible::Label, "@brief Enum constant QAccessible::Label") +
    gsi::enum_const ("Labelled", QAccessible::Labelled, "@brief Enum constant QAccessible::Labelled") +
    gsi::enum_const ("Controller", QAccessible::Controller, "@brief Enum constant QAccessible::Controller") +
    gsi::enum_const ("Controlled", QAccessible::Controlled, "@brief Enum constant QAccessible::Controlled") +
    gsi::enum_const ("AllRelations", QAccessible::AllRelations, "@brief Enum constant QAccessible::AllRelations"),
  "@qt\n@brief This class represents the QAccessible::RelationFlag enum");

static gsi::QFlagsClass<QAccessible::RelationFlag > decl_QAccessible_RelationFlag_Enums ("QAccessible_QFlags_RelationFlag",
  "@qt\n@brief This class represents the QFlags<QAccessible::RelationFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAccessible> inject_QAccessible_RelationFlag_Enum_in_parent (decl_QAccessible_RelationFlag_Enum.defs ());
static gsi::ClassExt<QAccessible> decl_QAccessible_RelationFlag_Enum_as_child (decl_QAccessible_RelationFlag_Enum, "RelationFlag");
static gsi::ClassExt<QAccessible> decl_QAccessible_RelationFlag_Enums_as_child (decl_QAccessible_RelationFlag_Enums, "QFlags_RelationFlag");

}


//  Implementation of the enum wrapper class for QAccessible::Role
namespace qt_gsi
{

static gsi::Enum<QAccessible::Role> decl_QAccessible_Role_Enum ("QAccessible_Role",
    gsi::enum_const ("NoRole", QAccessible::NoRole, "@brief Enum constant QAccessible::NoRole") +
    gsi::enum_const ("TitleBar", QAccessible::TitleBar, "@brief Enum constant QAccessible::TitleBar") +
    gsi::enum_const ("MenuBar", QAccessible::MenuBar, "@brief Enum constant QAccessible::MenuBar") +
    gsi::enum_const ("ScrollBar", QAccessible::ScrollBar, "@brief Enum constant QAccessible::ScrollBar") +
    gsi::enum_const ("Grip", QAccessible::Grip, "@brief Enum constant QAccessible::Grip") +
    gsi::enum_const ("Sound", QAccessible::Sound, "@brief Enum constant QAccessible::Sound") +
    gsi::enum_const ("Cursor", QAccessible::Cursor, "@brief Enum constant QAccessible::Cursor") +
    gsi::enum_const ("Caret", QAccessible::Caret, "@brief Enum constant QAccessible::Caret") +
    gsi::enum_const ("AlertMessage", QAccessible::AlertMessage, "@brief Enum constant QAccessible::AlertMessage") +
    gsi::enum_const ("Window", QAccessible::Window, "@brief Enum constant QAccessible::Window") +
    gsi::enum_const ("Client", QAccessible::Client, "@brief Enum constant QAccessible::Client") +
    gsi::enum_const ("PopupMenu", QAccessible::PopupMenu, "@brief Enum constant QAccessible::PopupMenu") +
    gsi::enum_const ("MenuItem", QAccessible::MenuItem, "@brief Enum constant QAccessible::MenuItem") +
    gsi::enum_const ("ToolTip", QAccessible::ToolTip, "@brief Enum constant QAccessible::ToolTip") +
    gsi::enum_const ("Application", QAccessible::Application, "@brief Enum constant QAccessible::Application") +
    gsi::enum_const ("Document", QAccessible::Document, "@brief Enum constant QAccessible::Document") +
    gsi::enum_const ("Pane", QAccessible::Pane, "@brief Enum constant QAccessible::Pane") +
    gsi::enum_const ("Chart", QAccessible::Chart, "@brief Enum constant QAccessible::Chart") +
    gsi::enum_const ("Dialog", QAccessible::Dialog, "@brief Enum constant QAccessible::Dialog") +
    gsi::enum_const ("Border", QAccessible::Border, "@brief Enum constant QAccessible::Border") +
    gsi::enum_const ("Grouping", QAccessible::Grouping, "@brief Enum constant QAccessible::Grouping") +
    gsi::enum_const ("Separator", QAccessible::Separator, "@brief Enum constant QAccessible::Separator") +
    gsi::enum_const ("ToolBar", QAccessible::ToolBar, "@brief Enum constant QAccessible::ToolBar") +
    gsi::enum_const ("StatusBar", QAccessible::StatusBar, "@brief Enum constant QAccessible::StatusBar") +
    gsi::enum_const ("Table", QAccessible::Table, "@brief Enum constant QAccessible::Table") +
    gsi::enum_const ("ColumnHeader", QAccessible::ColumnHeader, "@brief Enum constant QAccessible::ColumnHeader") +
    gsi::enum_const ("RowHeader", QAccessible::RowHeader, "@brief Enum constant QAccessible::RowHeader") +
    gsi::enum_const ("Column", QAccessible::Column, "@brief Enum constant QAccessible::Column") +
    gsi::enum_const ("Row", QAccessible::Row, "@brief Enum constant QAccessible::Row") +
    gsi::enum_const ("Cell", QAccessible::Cell, "@brief Enum constant QAccessible::Cell") +
    gsi::enum_const ("Link", QAccessible::Link, "@brief Enum constant QAccessible::Link") +
    gsi::enum_const ("HelpBalloon", QAccessible::HelpBalloon, "@brief Enum constant QAccessible::HelpBalloon") +
    gsi::enum_const ("Assistant", QAccessible::Assistant, "@brief Enum constant QAccessible::Assistant") +
    gsi::enum_const ("List", QAccessible::List, "@brief Enum constant QAccessible::List") +
    gsi::enum_const ("ListItem", QAccessible::ListItem, "@brief Enum constant QAccessible::ListItem") +
    gsi::enum_const ("Tree", QAccessible::Tree, "@brief Enum constant QAccessible::Tree") +
    gsi::enum_const ("TreeItem", QAccessible::TreeItem, "@brief Enum constant QAccessible::TreeItem") +
    gsi::enum_const ("PageTab", QAccessible::PageTab, "@brief Enum constant QAccessible::PageTab") +
    gsi::enum_const ("PropertyPage", QAccessible::PropertyPage, "@brief Enum constant QAccessible::PropertyPage") +
    gsi::enum_const ("Indicator", QAccessible::Indicator, "@brief Enum constant QAccessible::Indicator") +
    gsi::enum_const ("Graphic", QAccessible::Graphic, "@brief Enum constant QAccessible::Graphic") +
    gsi::enum_const ("StaticText", QAccessible::StaticText, "@brief Enum constant QAccessible::StaticText") +
    gsi::enum_const ("EditableText", QAccessible::EditableText, "@brief Enum constant QAccessible::EditableText") +
    gsi::enum_const ("Button", QAccessible::Button, "@brief Enum constant QAccessible::Button") +
    gsi::enum_const ("PushButton", QAccessible::PushButton, "@brief Enum constant QAccessible::PushButton") +
    gsi::enum_const ("CheckBox", QAccessible::CheckBox, "@brief Enum constant QAccessible::CheckBox") +
    gsi::enum_const ("RadioButton", QAccessible::RadioButton, "@brief Enum constant QAccessible::RadioButton") +
    gsi::enum_const ("ComboBox", QAccessible::ComboBox, "@brief Enum constant QAccessible::ComboBox") +
    gsi::enum_const ("ProgressBar", QAccessible::ProgressBar, "@brief Enum constant QAccessible::ProgressBar") +
    gsi::enum_const ("Dial", QAccessible::Dial, "@brief Enum constant QAccessible::Dial") +
    gsi::enum_const ("HotkeyField", QAccessible::HotkeyField, "@brief Enum constant QAccessible::HotkeyField") +
    gsi::enum_const ("Slider", QAccessible::Slider, "@brief Enum constant QAccessible::Slider") +
    gsi::enum_const ("SpinBox", QAccessible::SpinBox, "@brief Enum constant QAccessible::SpinBox") +
    gsi::enum_const ("Canvas", QAccessible::Canvas, "@brief Enum constant QAccessible::Canvas") +
    gsi::enum_const ("Animation", QAccessible::Animation, "@brief Enum constant QAccessible::Animation") +
    gsi::enum_const ("Equation", QAccessible::Equation, "@brief Enum constant QAccessible::Equation") +
    gsi::enum_const ("ButtonDropDown", QAccessible::ButtonDropDown, "@brief Enum constant QAccessible::ButtonDropDown") +
    gsi::enum_const ("ButtonMenu", QAccessible::ButtonMenu, "@brief Enum constant QAccessible::ButtonMenu") +
    gsi::enum_const ("ButtonDropGrid", QAccessible::ButtonDropGrid, "@brief Enum constant QAccessible::ButtonDropGrid") +
    gsi::enum_const ("Whitespace", QAccessible::Whitespace, "@brief Enum constant QAccessible::Whitespace") +
    gsi::enum_const ("PageTabList", QAccessible::PageTabList, "@brief Enum constant QAccessible::PageTabList") +
    gsi::enum_const ("Clock", QAccessible::Clock, "@brief Enum constant QAccessible::Clock") +
    gsi::enum_const ("Splitter", QAccessible::Splitter, "@brief Enum constant QAccessible::Splitter") +
    gsi::enum_const ("LayeredPane", QAccessible::LayeredPane, "@brief Enum constant QAccessible::LayeredPane") +
    gsi::enum_const ("Terminal", QAccessible::Terminal, "@brief Enum constant QAccessible::Terminal") +
    gsi::enum_const ("Desktop", QAccessible::Desktop, "@brief Enum constant QAccessible::Desktop") +
    gsi::enum_const ("Paragraph", QAccessible::Paragraph, "@brief Enum constant QAccessible::Paragraph") +
    gsi::enum_const ("WebDocument", QAccessible::WebDocument, "@brief Enum constant QAccessible::WebDocument") +
    gsi::enum_const ("Section", QAccessible::Section, "@brief Enum constant QAccessible::Section") +
    gsi::enum_const ("ColorChooser", QAccessible::ColorChooser, "@brief Enum constant QAccessible::ColorChooser") +
    gsi::enum_const ("Footer", QAccessible::Footer, "@brief Enum constant QAccessible::Footer") +
    gsi::enum_const ("Form", QAccessible::Form, "@brief Enum constant QAccessible::Form") +
    gsi::enum_const ("Heading", QAccessible::Heading, "@brief Enum constant QAccessible::Heading") +
    gsi::enum_const ("Note", QAccessible::Note, "@brief Enum constant QAccessible::Note") +
    gsi::enum_const ("ComplementaryContent", QAccessible::ComplementaryContent, "@brief Enum constant QAccessible::ComplementaryContent") +
    gsi::enum_const ("UserRole", QAccessible::UserRole, "@brief Enum constant QAccessible::UserRole"),
  "@qt\n@brief This class represents the QAccessible::Role enum");

static gsi::QFlagsClass<QAccessible::Role > decl_QAccessible_Role_Enums ("QAccessible_QFlags_Role",
  "@qt\n@brief This class represents the QFlags<QAccessible::Role> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAccessible> inject_QAccessible_Role_Enum_in_parent (decl_QAccessible_Role_Enum.defs ());
static gsi::ClassExt<QAccessible> decl_QAccessible_Role_Enum_as_child (decl_QAccessible_Role_Enum, "Role");
static gsi::ClassExt<QAccessible> decl_QAccessible_Role_Enums_as_child (decl_QAccessible_Role_Enums, "QFlags_Role");

}


//  Implementation of the enum wrapper class for QAccessible::Text
namespace qt_gsi
{

static gsi::Enum<QAccessible::Text> decl_QAccessible_Text_Enum ("QAccessible_Text",
    gsi::enum_const ("Name", QAccessible::Name, "@brief Enum constant QAccessible::Name") +
    gsi::enum_const ("Description", QAccessible::Description, "@brief Enum constant QAccessible::Description") +
    gsi::enum_const ("Value", QAccessible::Value, "@brief Enum constant QAccessible::Value") +
    gsi::enum_const ("Help", QAccessible::Help, "@brief Enum constant QAccessible::Help") +
    gsi::enum_const ("Accelerator", QAccessible::Accelerator, "@brief Enum constant QAccessible::Accelerator") +
    gsi::enum_const ("DebugDescription", QAccessible::DebugDescription, "@brief Enum constant QAccessible::DebugDescription") +
    gsi::enum_const ("UserText", QAccessible::UserText, "@brief Enum constant QAccessible::UserText"),
  "@qt\n@brief This class represents the QAccessible::Text enum");

static gsi::QFlagsClass<QAccessible::Text > decl_QAccessible_Text_Enums ("QAccessible_QFlags_Text",
  "@qt\n@brief This class represents the QFlags<QAccessible::Text> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAccessible> inject_QAccessible_Text_Enum_in_parent (decl_QAccessible_Text_Enum.defs ());
static gsi::ClassExt<QAccessible> decl_QAccessible_Text_Enum_as_child (decl_QAccessible_Text_Enum, "Text");
static gsi::ClassExt<QAccessible> decl_QAccessible_Text_Enums_as_child (decl_QAccessible_Text_Enums, "QFlags_Text");

}


//  Implementation of the enum wrapper class for QAccessible::TextBoundaryType
namespace qt_gsi
{

static gsi::Enum<QAccessible::TextBoundaryType> decl_QAccessible_TextBoundaryType_Enum ("QAccessible_TextBoundaryType",
    gsi::enum_const ("CharBoundary", QAccessible::CharBoundary, "@brief Enum constant QAccessible::CharBoundary") +
    gsi::enum_const ("WordBoundary", QAccessible::WordBoundary, "@brief Enum constant QAccessible::WordBoundary") +
    gsi::enum_const ("SentenceBoundary", QAccessible::SentenceBoundary, "@brief Enum constant QAccessible::SentenceBoundary") +
    gsi::enum_const ("ParagraphBoundary", QAccessible::ParagraphBoundary, "@brief Enum constant QAccessible::ParagraphBoundary") +
    gsi::enum_const ("LineBoundary", QAccessible::LineBoundary, "@brief Enum constant QAccessible::LineBoundary") +
    gsi::enum_const ("NoBoundary", QAccessible::NoBoundary, "@brief Enum constant QAccessible::NoBoundary"),
  "@qt\n@brief This class represents the QAccessible::TextBoundaryType enum");

static gsi::QFlagsClass<QAccessible::TextBoundaryType > decl_QAccessible_TextBoundaryType_Enums ("QAccessible_QFlags_TextBoundaryType",
  "@qt\n@brief This class represents the QFlags<QAccessible::TextBoundaryType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QAccessible> inject_QAccessible_TextBoundaryType_Enum_in_parent (decl_QAccessible_TextBoundaryType_Enum.defs ());
static gsi::ClassExt<QAccessible> decl_QAccessible_TextBoundaryType_Enum_as_child (decl_QAccessible_TextBoundaryType_Enum, "TextBoundaryType");
static gsi::ClassExt<QAccessible> decl_QAccessible_TextBoundaryType_Enums_as_child (decl_QAccessible_TextBoundaryType_Enums, "QFlags_TextBoundaryType");

}

