
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAccessibleApplication.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAccessibleApplication>
#include <QAccessibleInterface>
#include <QAccessibleTableCellInterface>
#include <QColor>
#include <QObject>
#include <QRect>
#include <QWindow>
#include "gsiQt.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAccessibleApplication

// QAccessibleInterface *QAccessibleApplication::child(int index)


static void _init_f_child_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_f_child_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleApplication *)cls)->child (arg1));
}

static qt_gsi::GenericMethod *_create_f_child_c767 ()
{
  return new qt_gsi::GenericMethod ("child", "@brief Method QAccessibleInterface *QAccessibleApplication::child(int index)\nThis is a reimplementation of QAccessibleInterface::child", true, &_init_f_child_c767, &_call_f_child_c767);
}

// int QAccessibleApplication::childCount()


static void _init_f_childCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_childCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleApplication *)cls)->childCount ());
}

static qt_gsi::GenericMethod *_create_f_childCount_c0 ()
{
  return new qt_gsi::GenericMethod ("childCount", "@brief Method int QAccessibleApplication::childCount()\nThis is a reimplementation of QAccessibleInterface::childCount", true, &_init_f_childCount_c0, &_call_f_childCount_c0);
}

// QAccessibleInterface *QAccessibleApplication::focusChild()


static void _init_f_focusChild_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_f_focusChild_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleApplication *)cls)->focusChild ());
}

static qt_gsi::GenericMethod *_create_f_focusChild_c0 ()
{
  return new qt_gsi::GenericMethod ("focusChild", "@brief Method QAccessibleInterface *QAccessibleApplication::focusChild()\nThis is a reimplementation of QAccessibleInterface::focusChild", true, &_init_f_focusChild_c0, &_call_f_focusChild_c0);
}

// int QAccessibleApplication::indexOfChild(const QAccessibleInterface *)


static void _init_f_indexOfChild_c3317 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QAccessibleInterface * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_indexOfChild_c3317 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAccessibleInterface *arg1 = args.read<const QAccessibleInterface * > (heap);
  ret.write<int > ((int)((QAccessibleApplication *)cls)->indexOfChild (arg1));
}

static qt_gsi::GenericMethod *_create_f_indexOfChild_c3317 ()
{
  return new qt_gsi::GenericMethod ("indexOfChild", "@brief Method int QAccessibleApplication::indexOfChild(const QAccessibleInterface *)\nThis is a reimplementation of QAccessibleInterface::indexOfChild", true, &_init_f_indexOfChild_c3317, &_call_f_indexOfChild_c3317);
}

// QAccessibleInterface *QAccessibleApplication::parent()


static void _init_f_parent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_f_parent_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleApplication *)cls)->parent ());
}

static qt_gsi::GenericMethod *_create_f_parent_c0 ()
{
  return new qt_gsi::GenericMethod ("parent", "@brief Method QAccessibleInterface *QAccessibleApplication::parent()\nThis is a reimplementation of QAccessibleInterface::parent", true, &_init_f_parent_c0, &_call_f_parent_c0);
}

// QAccessible::Role QAccessibleApplication::role()


static void _init_f_role_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAccessible::Role>::target_type > ();
}

static void _call_f_role_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAccessible::Role>::target_type > ((qt_gsi::Converter<QAccessible::Role>::target_type)qt_gsi::CppToQtAdaptor<QAccessible::Role>(((QAccessibleApplication *)cls)->role ()));
}

static qt_gsi::GenericMethod *_create_f_role_c0 ()
{
  return new qt_gsi::GenericMethod ("role", "@brief Method QAccessible::Role QAccessibleApplication::role()\nThis is a reimplementation of QAccessibleInterface::role", true, &_init_f_role_c0, &_call_f_role_c0);
}

// QAccessible::State QAccessibleApplication::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessible::State > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessible::State > ((QAccessible::State)((QAccessibleApplication *)cls)->state ());
}

static qt_gsi::GenericMethod *_create_f_state_c0 ()
{
  return new qt_gsi::GenericMethod ("state", "@brief Method QAccessible::State QAccessibleApplication::state()\nThis is a reimplementation of QAccessibleInterface::state", true, &_init_f_state_c0, &_call_f_state_c0);
}

// QString QAccessibleApplication::text(QAccessible::Text t)


static void _init_f_text_c2060 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("t");
  decl->add_arg<const qt_gsi::Converter<QAccessible::Text>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_text_c2060 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAccessible::Text>::target_type & arg1 = args.read<const qt_gsi::Converter<QAccessible::Text>::target_type & > (heap);
  ret.write<QString > ((QString)((QAccessibleApplication *)cls)->text (qt_gsi::QtToCppAdaptor<QAccessible::Text>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_text_c2060 ()
{
  return new qt_gsi::GenericMethod ("text", "@brief Method QString QAccessibleApplication::text(QAccessible::Text t)\nThis is a reimplementation of QAccessibleInterface::text", true, &_init_f_text_c2060, &_call_f_text_c2060);
}

// QWindow *QAccessibleApplication::window()


static void _init_f_window_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWindow * > ();
}

static void _call_f_window_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWindow * > ((QWindow *)((QAccessibleApplication *)cls)->window ());
}

static qt_gsi::GenericMethod *_create_f_window_c0 ()
{
  return new qt_gsi::GenericMethod ("window", "@brief Method QWindow *QAccessibleApplication::window()\nThis is a reimplementation of QAccessibleInterface::window", true, &_init_f_window_c0, &_call_f_window_c0);
}

namespace gsi
{
extern gsi::Class<QAccessibleObject> decl_QAccessibleObject;

gsi::Class<QAccessibleApplication> decl_QAccessibleApplication (decl_QAccessibleObject, "QAccessibleApplication_Native",
  gsi::Methods(_create_f_child_c767 ()) +
  gsi::Methods(_create_f_childCount_c0 ()) +
  gsi::Methods(_create_f_focusChild_c0 ()) +
  gsi::Methods(_create_f_indexOfChild_c3317 ()) +
  gsi::Methods(_create_f_parent_c0 ()) +
  gsi::Methods(_create_f_role_c0 ()) +
  gsi::Methods(_create_f_state_c0 ()) +
  gsi::Methods(_create_f_text_c2060 ()) +
  gsi::Methods(_create_f_window_c0 ()),
  "@hide\n@alias QAccessibleApplication");
}


class QAccessibleApplication_Adaptor : public QAccessibleApplication, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAccessibleApplication_Adaptor();

  //  [adaptor ctor] QAccessibleApplication::QAccessibleApplication()
  QAccessibleApplication_Adaptor() : QAccessibleApplication()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] QColor QAccessibleApplication::backgroundColor()
  QColor cbs_backgroundColor_c0_0() const
  {
    return QAccessibleApplication::backgroundColor();
  }

  virtual QColor backgroundColor() const
  {
    if (cb_backgroundColor_c0_0.can_issue()) {
      return cb_backgroundColor_c0_0.issue<QAccessibleApplication_Adaptor, QColor>(&QAccessibleApplication_Adaptor::cbs_backgroundColor_c0_0);
    } else {
      return QAccessibleApplication::backgroundColor();
    }
  }

  //  [adaptor impl] QAccessibleInterface *QAccessibleApplication::child(int index)
  QAccessibleInterface * cbs_child_c767_0(int index) const
  {
    return QAccessibleApplication::child(index);
  }

  virtual QAccessibleInterface * child(int index) const
  {
    if (cb_child_c767_0.can_issue()) {
      return cb_child_c767_0.issue<QAccessibleApplication_Adaptor, QAccessibleInterface *, int>(&QAccessibleApplication_Adaptor::cbs_child_c767_0, index);
    } else {
      return QAccessibleApplication::child(index);
    }
  }

  //  [adaptor impl] QAccessibleInterface *QAccessibleApplication::childAt(int x, int y)
  QAccessibleInterface * cbs_childAt_c1426_0(int x, int y) const
  {
    return QAccessibleApplication::childAt(x, y);
  }

  virtual QAccessibleInterface * childAt(int x, int y) const
  {
    if (cb_childAt_c1426_0.can_issue()) {
      return cb_childAt_c1426_0.issue<QAccessibleApplication_Adaptor, QAccessibleInterface *, int, int>(&QAccessibleApplication_Adaptor::cbs_childAt_c1426_0, x, y);
    } else {
      return QAccessibleApplication::childAt(x, y);
    }
  }

  //  [adaptor impl] int QAccessibleApplication::childCount()
  int cbs_childCount_c0_0() const
  {
    return QAccessibleApplication::childCount();
  }

  virtual int childCount() const
  {
    if (cb_childCount_c0_0.can_issue()) {
      return cb_childCount_c0_0.issue<QAccessibleApplication_Adaptor, int>(&QAccessibleApplication_Adaptor::cbs_childCount_c0_0);
    } else {
      return QAccessibleApplication::childCount();
    }
  }

  //  [adaptor impl] QAccessibleInterface *QAccessibleApplication::focusChild()
  QAccessibleInterface * cbs_focusChild_c0_0() const
  {
    return QAccessibleApplication::focusChild();
  }

  virtual QAccessibleInterface * focusChild() const
  {
    if (cb_focusChild_c0_0.can_issue()) {
      return cb_focusChild_c0_0.issue<QAccessibleApplication_Adaptor, QAccessibleInterface *>(&QAccessibleApplication_Adaptor::cbs_focusChild_c0_0);
    } else {
      return QAccessibleApplication::focusChild();
    }
  }

  //  [adaptor impl] QColor QAccessibleApplication::foregroundColor()
  QColor cbs_foregroundColor_c0_0() const
  {
    return QAccessibleApplication::foregroundColor();
  }

  virtual QColor foregroundColor() const
  {
    if (cb_foregroundColor_c0_0.can_issue()) {
      return cb_foregroundColor_c0_0.issue<QAccessibleApplication_Adaptor, QColor>(&QAccessibleApplication_Adaptor::cbs_foregroundColor_c0_0);
    } else {
      return QAccessibleApplication::foregroundColor();
    }
  }

  //  [adaptor impl] int QAccessibleApplication::indexOfChild(const QAccessibleInterface *)
  int cbs_indexOfChild_c3317_0(const QAccessibleInterface *arg1) const
  {
    return QAccessibleApplication::indexOfChild(arg1);
  }

  virtual int indexOfChild(const QAccessibleInterface *arg1) const
  {
    if (cb_indexOfChild_c3317_0.can_issue()) {
      return cb_indexOfChild_c3317_0.issue<QAccessibleApplication_Adaptor, int, const QAccessibleInterface *>(&QAccessibleApplication_Adaptor::cbs_indexOfChild_c3317_0, arg1);
    } else {
      return QAccessibleApplication::indexOfChild(arg1);
    }
  }

  //  [adaptor impl] void *QAccessibleApplication::interface_cast(QAccessible::InterfaceType)
  void * cbs_interface_cast_2970_0(const qt_gsi::Converter<QAccessible::InterfaceType>::target_type & arg1)
  {
    return QAccessibleApplication::interface_cast(qt_gsi::QtToCppAdaptor<QAccessible::InterfaceType>(arg1).cref());
  }

  virtual void * interface_cast(QAccessible::InterfaceType arg1)
  {
    if (cb_interface_cast_2970_0.can_issue()) {
      return cb_interface_cast_2970_0.issue<QAccessibleApplication_Adaptor, void *, const qt_gsi::Converter<QAccessible::InterfaceType>::target_type &>(&QAccessibleApplication_Adaptor::cbs_interface_cast_2970_0, qt_gsi::CppToQtAdaptor<QAccessible::InterfaceType>(arg1));
    } else {
      return QAccessibleApplication::interface_cast(arg1);
    }
  }

  //  [adaptor impl] bool QAccessibleApplication::isValid()
  bool cbs_isValid_c0_0() const
  {
    return QAccessibleApplication::isValid();
  }

  virtual bool isValid() const
  {
    if (cb_isValid_c0_0.can_issue()) {
      return cb_isValid_c0_0.issue<QAccessibleApplication_Adaptor, bool>(&QAccessibleApplication_Adaptor::cbs_isValid_c0_0);
    } else {
      return QAccessibleApplication::isValid();
    }
  }

  //  [adaptor impl] QObject *QAccessibleApplication::object()
  QObject * cbs_object_c0_0() const
  {
    return QAccessibleApplication::object();
  }

  virtual QObject * object() const
  {
    if (cb_object_c0_0.can_issue()) {
      return cb_object_c0_0.issue<QAccessibleApplication_Adaptor, QObject *>(&QAccessibleApplication_Adaptor::cbs_object_c0_0);
    } else {
      return QAccessibleApplication::object();
    }
  }

  //  [adaptor impl] QAccessibleInterface *QAccessibleApplication::parent()
  QAccessibleInterface * cbs_parent_c0_0() const
  {
    return QAccessibleApplication::parent();
  }

  virtual QAccessibleInterface * parent() const
  {
    if (cb_parent_c0_0.can_issue()) {
      return cb_parent_c0_0.issue<QAccessibleApplication_Adaptor, QAccessibleInterface *>(&QAccessibleApplication_Adaptor::cbs_parent_c0_0);
    } else {
      return QAccessibleApplication::parent();
    }
  }

  //  [adaptor impl] QRect QAccessibleApplication::rect()
  QRect cbs_rect_c0_0() const
  {
    return QAccessibleApplication::rect();
  }

  virtual QRect rect() const
  {
    if (cb_rect_c0_0.can_issue()) {
      return cb_rect_c0_0.issue<QAccessibleApplication_Adaptor, QRect>(&QAccessibleApplication_Adaptor::cbs_rect_c0_0);
    } else {
      return QAccessibleApplication::rect();
    }
  }

  //  [adaptor impl] QVector<QPair<QAccessibleInterface*, QAccessible::Relation> > QAccessibleApplication::relations(QFlags<QAccessible::RelationFlag> match)
  QVector<QPair<QAccessibleInterface*, QAccessible::Relation> > cbs_relations_c3543_1(QFlags<QAccessible::RelationFlag> match) const
  {
    return QAccessibleApplication::relations(match);
  }

  virtual QVector<QPair<QAccessibleInterface*, QAccessible::Relation> > relations(QFlags<QAccessible::RelationFlag> match) const
  {
    if (cb_relations_c3543_1.can_issue()) {
      return cb_relations_c3543_1.issue<QAccessibleApplication_Adaptor, QVector<QPair<QAccessibleInterface*, QAccessible::Relation> >, QFlags<QAccessible::RelationFlag> >(&QAccessibleApplication_Adaptor::cbs_relations_c3543_1, match);
    } else {
      return QAccessibleApplication::relations(match);
    }
  }

  //  [adaptor impl] QAccessible::Role QAccessibleApplication::role()
  qt_gsi::Converter<QAccessible::Role>::target_type cbs_role_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QAccessible::Role>(QAccessibleApplication::role());
  }

  virtual QAccessible::Role role() const
  {
    if (cb_role_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QAccessible::Role>(cb_role_c0_0.issue<QAccessibleApplication_Adaptor, qt_gsi::Converter<QAccessible::Role>::target_type>(&QAccessibleApplication_Adaptor::cbs_role_c0_0)).cref();
    } else {
      return QAccessibleApplication::role();
    }
  }

  //  [adaptor impl] void QAccessibleApplication::setText(QAccessible::Text t, const QString &text)
  void cbs_setText_3977_0(const qt_gsi::Converter<QAccessible::Text>::target_type & t, const QString &text)
  {
    QAccessibleApplication::setText(qt_gsi::QtToCppAdaptor<QAccessible::Text>(t).cref(), text);
  }

  virtual void setText(QAccessible::Text t, const QString &text)
  {
    if (cb_setText_3977_0.can_issue()) {
      cb_setText_3977_0.issue<QAccessibleApplication_Adaptor, const qt_gsi::Converter<QAccessible::Text>::target_type &, const QString &>(&QAccessibleApplication_Adaptor::cbs_setText_3977_0, qt_gsi::CppToQtAdaptor<QAccessible::Text>(t), text);
    } else {
      QAccessibleApplication::setText(t, text);
    }
  }

  //  [adaptor impl] QAccessible::State QAccessibleApplication::state()
  QAccessible::State cbs_state_c0_0() const
  {
    return QAccessibleApplication::state();
  }

  virtual QAccessible::State state() const
  {
    if (cb_state_c0_0.can_issue()) {
      return cb_state_c0_0.issue<QAccessibleApplication_Adaptor, QAccessible::State>(&QAccessibleApplication_Adaptor::cbs_state_c0_0);
    } else {
      return QAccessibleApplication::state();
    }
  }

  //  [adaptor impl] QString QAccessibleApplication::text(QAccessible::Text t)
  QString cbs_text_c2060_0(const qt_gsi::Converter<QAccessible::Text>::target_type & t) const
  {
    return QAccessibleApplication::text(qt_gsi::QtToCppAdaptor<QAccessible::Text>(t).cref());
  }

  virtual QString text(QAccessible::Text t) const
  {
    if (cb_text_c2060_0.can_issue()) {
      return cb_text_c2060_0.issue<QAccessibleApplication_Adaptor, QString, const qt_gsi::Converter<QAccessible::Text>::target_type &>(&QAccessibleApplication_Adaptor::cbs_text_c2060_0, qt_gsi::CppToQtAdaptor<QAccessible::Text>(t));
    } else {
      return QAccessibleApplication::text(t);
    }
  }

  //  [adaptor impl] void QAccessibleApplication::virtual_hook(int id, void *data)
  void cbs_virtual_hook_1715_0(int id, void *data)
  {
    QAccessibleApplication::virtual_hook(id, data);
  }

  virtual void virtual_hook(int id, void *data)
  {
    if (cb_virtual_hook_1715_0.can_issue()) {
      cb_virtual_hook_1715_0.issue<QAccessibleApplication_Adaptor, int, void *>(&QAccessibleApplication_Adaptor::cbs_virtual_hook_1715_0, id, data);
    } else {
      QAccessibleApplication::virtual_hook(id, data);
    }
  }

  //  [adaptor impl] QWindow *QAccessibleApplication::window()
  QWindow * cbs_window_c0_0() const
  {
    return QAccessibleApplication::window();
  }

  virtual QWindow * window() const
  {
    if (cb_window_c0_0.can_issue()) {
      return cb_window_c0_0.issue<QAccessibleApplication_Adaptor, QWindow *>(&QAccessibleApplication_Adaptor::cbs_window_c0_0);
    } else {
      return QAccessibleApplication::window();
    }
  }

  gsi::Callback cb_backgroundColor_c0_0;
  gsi::Callback cb_child_c767_0;
  gsi::Callback cb_childAt_c1426_0;
  gsi::Callback cb_childCount_c0_0;
  gsi::Callback cb_focusChild_c0_0;
  gsi::Callback cb_foregroundColor_c0_0;
  gsi::Callback cb_indexOfChild_c3317_0;
  gsi::Callback cb_interface_cast_2970_0;
  gsi::Callback cb_isValid_c0_0;
  gsi::Callback cb_object_c0_0;
  gsi::Callback cb_parent_c0_0;
  gsi::Callback cb_rect_c0_0;
  gsi::Callback cb_relations_c3543_1;
  gsi::Callback cb_role_c0_0;
  gsi::Callback cb_setText_3977_0;
  gsi::Callback cb_state_c0_0;
  gsi::Callback cb_text_c2060_0;
  gsi::Callback cb_virtual_hook_1715_0;
  gsi::Callback cb_window_c0_0;
};

QAccessibleApplication_Adaptor::~QAccessibleApplication_Adaptor() { }

//  Constructor QAccessibleApplication::QAccessibleApplication() (adaptor class)

static void _init_ctor_QAccessibleApplication_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QAccessibleApplication_Adaptor> ();
}

static void _call_ctor_QAccessibleApplication_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleApplication_Adaptor *> (new QAccessibleApplication_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QAccessibleApplication_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAccessibleApplication::QAccessibleApplication()\nThis method creates an object of class QAccessibleApplication.", &_init_ctor_QAccessibleApplication_Adaptor_0, &_call_ctor_QAccessibleApplication_Adaptor_0);
}

// QColor QAccessibleApplication::backgroundColor()

static void _init_cbs_backgroundColor_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_cbs_backgroundColor_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor > ((QColor)((QAccessibleApplication_Adaptor *)cls)->cbs_backgroundColor_c0_0 ());
}

static void _set_callback_cbs_backgroundColor_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_backgroundColor_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_backgroundColor_c0_0 ()
{
  return new qt_gsi::GenericMethod ("backgroundColor", "@hide", true, &_init_cbs_backgroundColor_c0_0, &_call_cbs_backgroundColor_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_backgroundColor_c0_0 ()
{
  return new qt_gsi::GenericMethod ("backgroundColor", "@brief Virtual method QColor QAccessibleApplication::backgroundColor()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_backgroundColor_c0_0, &_call_cbs_backgroundColor_c0_0, &_set_callback_cbs_backgroundColor_c0_0);
}


// QAccessibleInterface *QAccessibleApplication::child(int index)

static void _init_cbs_child_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_cbs_child_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleApplication_Adaptor *)cls)->cbs_child_c767_0 (arg1));
}

static void _set_callback_cbs_child_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_child_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_child_c767_0 ()
{
  return new qt_gsi::GenericMethod ("child", "@hide", true, &_init_cbs_child_c767_0, &_call_cbs_child_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_child_c767_0 ()
{
  return new qt_gsi::GenericMethod ("child", "@brief Virtual method QAccessibleInterface *QAccessibleApplication::child(int index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_child_c767_0, &_call_cbs_child_c767_0, &_set_callback_cbs_child_c767_0);
}


// QAccessibleInterface *QAccessibleApplication::childAt(int x, int y)

static void _init_cbs_childAt_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_cbs_childAt_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleApplication_Adaptor *)cls)->cbs_childAt_c1426_0 (arg1, arg2));
}

static void _set_callback_cbs_childAt_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_childAt_c1426_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childAt_c1426_0 ()
{
  return new qt_gsi::GenericMethod ("childAt", "@hide", true, &_init_cbs_childAt_c1426_0, &_call_cbs_childAt_c1426_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childAt_c1426_0 ()
{
  return new qt_gsi::GenericMethod ("childAt", "@brief Virtual method QAccessibleInterface *QAccessibleApplication::childAt(int x, int y)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_childAt_c1426_0, &_call_cbs_childAt_c1426_0, &_set_callback_cbs_childAt_c1426_0);
}


// int QAccessibleApplication::childCount()

static void _init_cbs_childCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_childCount_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleApplication_Adaptor *)cls)->cbs_childCount_c0_0 ());
}

static void _set_callback_cbs_childCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_childCount_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childCount_c0_0 ()
{
  return new qt_gsi::GenericMethod ("childCount", "@hide", true, &_init_cbs_childCount_c0_0, &_call_cbs_childCount_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childCount_c0_0 ()
{
  return new qt_gsi::GenericMethod ("childCount", "@brief Virtual method int QAccessibleApplication::childCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_childCount_c0_0, &_call_cbs_childCount_c0_0, &_set_callback_cbs_childCount_c0_0);
}


// QAccessibleInterface *QAccessibleApplication::focusChild()

static void _init_cbs_focusChild_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_cbs_focusChild_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleApplication_Adaptor *)cls)->cbs_focusChild_c0_0 ());
}

static void _set_callback_cbs_focusChild_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_focusChild_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusChild_c0_0 ()
{
  return new qt_gsi::GenericMethod ("focusChild", "@hide", true, &_init_cbs_focusChild_c0_0, &_call_cbs_focusChild_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusChild_c0_0 ()
{
  return new qt_gsi::GenericMethod ("focusChild", "@brief Virtual method QAccessibleInterface *QAccessibleApplication::focusChild()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_focusChild_c0_0, &_call_cbs_focusChild_c0_0, &_set_callback_cbs_focusChild_c0_0);
}


// QColor QAccessibleApplication::foregroundColor()

static void _init_cbs_foregroundColor_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_cbs_foregroundColor_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor > ((QColor)((QAccessibleApplication_Adaptor *)cls)->cbs_foregroundColor_c0_0 ());
}

static void _set_callback_cbs_foregroundColor_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_foregroundColor_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_foregroundColor_c0_0 ()
{
  return new qt_gsi::GenericMethod ("foregroundColor", "@hide", true, &_init_cbs_foregroundColor_c0_0, &_call_cbs_foregroundColor_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_foregroundColor_c0_0 ()
{
  return new qt_gsi::GenericMethod ("foregroundColor", "@brief Virtual method QColor QAccessibleApplication::foregroundColor()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_foregroundColor_c0_0, &_call_cbs_foregroundColor_c0_0, &_set_callback_cbs_foregroundColor_c0_0);
}


// int QAccessibleApplication::indexOfChild(const QAccessibleInterface *)

static void _init_cbs_indexOfChild_c3317_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QAccessibleInterface * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_indexOfChild_c3317_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAccessibleInterface *arg1 = args.read<const QAccessibleInterface * > (heap);
  ret.write<int > ((int)((QAccessibleApplication_Adaptor *)cls)->cbs_indexOfChild_c3317_0 (arg1));
}

static void _set_callback_cbs_indexOfChild_c3317_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_indexOfChild_c3317_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_indexOfChild_c3317_0 ()
{
  return new qt_gsi::GenericMethod ("indexOfChild", "@hide", true, &_init_cbs_indexOfChild_c3317_0, &_call_cbs_indexOfChild_c3317_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_indexOfChild_c3317_0 ()
{
  return new qt_gsi::GenericMethod ("indexOfChild", "@brief Virtual method int QAccessibleApplication::indexOfChild(const QAccessibleInterface *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexOfChild_c3317_0, &_call_cbs_indexOfChild_c3317_0, &_set_callback_cbs_indexOfChild_c3317_0);
}


// void *QAccessibleApplication::interface_cast(QAccessible::InterfaceType)

static void _init_cbs_interface_cast_2970_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QAccessible::InterfaceType>::target_type & > (argspec_0);
  decl->set_return<void * > ();
}

static void _call_cbs_interface_cast_2970_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAccessible::InterfaceType>::target_type & arg1 = args.read<const qt_gsi::Converter<QAccessible::InterfaceType>::target_type & > (heap);
  ret.write<void * > ((void *)((QAccessibleApplication_Adaptor *)cls)->cbs_interface_cast_2970_0 (arg1));
}

static void _set_callback_cbs_interface_cast_2970_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_interface_cast_2970_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_interface_cast_2970_0 ()
{
  return new qt_gsi::GenericMethod ("interface_cast", "@hide", false, &_init_cbs_interface_cast_2970_0, &_call_cbs_interface_cast_2970_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_interface_cast_2970_0 ()
{
  return new qt_gsi::GenericMethod ("interface_cast", "@brief Virtual method void *QAccessibleApplication::interface_cast(QAccessible::InterfaceType)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_interface_cast_2970_0, &_call_cbs_interface_cast_2970_0, &_set_callback_cbs_interface_cast_2970_0);
}


// bool QAccessibleApplication::isValid()

static void _init_cbs_isValid_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isValid_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QAccessibleApplication_Adaptor *)cls)->cbs_isValid_c0_0 ());
}

static void _set_callback_cbs_isValid_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_isValid_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isValid_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isValid", "@hide", true, &_init_cbs_isValid_c0_0, &_call_cbs_isValid_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isValid_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isValid", "@brief Virtual method bool QAccessibleApplication::isValid()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isValid_c0_0, &_call_cbs_isValid_c0_0, &_set_callback_cbs_isValid_c0_0);
}


// QObject *QAccessibleApplication::object()

static void _init_cbs_object_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_cbs_object_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAccessibleApplication_Adaptor *)cls)->cbs_object_c0_0 ());
}

static void _set_callback_cbs_object_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_object_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_object_c0_0 ()
{
  return new qt_gsi::GenericMethod ("object", "@hide", true, &_init_cbs_object_c0_0, &_call_cbs_object_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_object_c0_0 ()
{
  return new qt_gsi::GenericMethod ("object", "@brief Virtual method QObject *QAccessibleApplication::object()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_object_c0_0, &_call_cbs_object_c0_0, &_set_callback_cbs_object_c0_0);
}


// QAccessibleInterface *QAccessibleApplication::parent()

static void _init_cbs_parent_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_cbs_parent_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QAccessibleApplication_Adaptor *)cls)->cbs_parent_c0_0 ());
}

static void _set_callback_cbs_parent_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_parent_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_parent_c0_0 ()
{
  return new qt_gsi::GenericMethod ("parent", "@hide", true, &_init_cbs_parent_c0_0, &_call_cbs_parent_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_parent_c0_0 ()
{
  return new qt_gsi::GenericMethod ("parent", "@brief Virtual method QAccessibleInterface *QAccessibleApplication::parent()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_parent_c0_0, &_call_cbs_parent_c0_0, &_set_callback_cbs_parent_c0_0);
}


// QRect QAccessibleApplication::rect()

static void _init_cbs_rect_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_rect_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QAccessibleApplication_Adaptor *)cls)->cbs_rect_c0_0 ());
}

static void _set_callback_cbs_rect_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_rect_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rect_c0_0 ()
{
  return new qt_gsi::GenericMethod ("rect", "@hide", true, &_init_cbs_rect_c0_0, &_call_cbs_rect_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rect_c0_0 ()
{
  return new qt_gsi::GenericMethod ("rect", "@brief Virtual method QRect QAccessibleApplication::rect()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rect_c0_0, &_call_cbs_rect_c0_0, &_set_callback_cbs_rect_c0_0);
}


// QVector<QPair<QAccessibleInterface*, QAccessible::Relation> > QAccessibleApplication::relations(QFlags<QAccessible::RelationFlag> match)

static void _init_cbs_relations_c3543_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("match");
  decl->add_arg<QFlags<QAccessible::RelationFlag> > (argspec_0);
  decl->set_return<QVector<QPair<QAccessibleInterface*, QAccessible::Relation> > > ();
}

static void _call_cbs_relations_c3543_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QAccessible::RelationFlag> arg1 = args.read<QFlags<QAccessible::RelationFlag> > (heap);
  ret.write<QVector<QPair<QAccessibleInterface*, QAccessible::Relation> > > ((QVector<QPair<QAccessibleInterface*, QAccessible::Relation> >)((QAccessibleApplication_Adaptor *)cls)->cbs_relations_c3543_1 (arg1));
}

static void _set_callback_cbs_relations_c3543_1 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_relations_c3543_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_relations_c3543_1 ()
{
  return new qt_gsi::GenericMethod ("relations", "@hide", true, &_init_cbs_relations_c3543_1, &_call_cbs_relations_c3543_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_relations_c3543_1 ()
{
  return new qt_gsi::GenericMethod ("relations", "@brief Virtual method QVector<QPair<QAccessibleInterface*, QAccessible::Relation> > QAccessibleApplication::relations(QFlags<QAccessible::RelationFlag> match)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_relations_c3543_1, &_call_cbs_relations_c3543_1, &_set_callback_cbs_relations_c3543_1);
}


// QAccessible::Role QAccessibleApplication::role()

static void _init_cbs_role_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAccessible::Role>::target_type > ();
}

static void _call_cbs_role_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAccessible::Role>::target_type > ((qt_gsi::Converter<QAccessible::Role>::target_type)((QAccessibleApplication_Adaptor *)cls)->cbs_role_c0_0 ());
}

static void _set_callback_cbs_role_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_role_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_role_c0_0 ()
{
  return new qt_gsi::GenericMethod ("role", "@hide", true, &_init_cbs_role_c0_0, &_call_cbs_role_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_role_c0_0 ()
{
  return new qt_gsi::GenericMethod ("role", "@brief Virtual method QAccessible::Role QAccessibleApplication::role()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_role_c0_0, &_call_cbs_role_c0_0, &_set_callback_cbs_role_c0_0);
}


// void QAccessibleApplication::setText(QAccessible::Text t, const QString &text)

static void _init_cbs_setText_3977_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("t");
  decl->add_arg<const qt_gsi::Converter<QAccessible::Text>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setText_3977_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAccessible::Text>::target_type & arg1 = args.read<const qt_gsi::Converter<QAccessible::Text>::target_type & > (heap);
  const QString &arg2 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleApplication_Adaptor *)cls)->cbs_setText_3977_0 (arg1, arg2);
}

static void _set_callback_cbs_setText_3977_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_setText_3977_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setText_3977_0 ()
{
  return new qt_gsi::GenericMethod ("setText", "@hide", false, &_init_cbs_setText_3977_0, &_call_cbs_setText_3977_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setText_3977_0 ()
{
  return new qt_gsi::GenericMethod ("setText", "@brief Virtual method void QAccessibleApplication::setText(QAccessible::Text t, const QString &text)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setText_3977_0, &_call_cbs_setText_3977_0, &_set_callback_cbs_setText_3977_0);
}


// QAccessible::State QAccessibleApplication::state()

static void _init_cbs_state_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessible::State > ();
}

static void _call_cbs_state_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessible::State > ((QAccessible::State)((QAccessibleApplication_Adaptor *)cls)->cbs_state_c0_0 ());
}

static void _set_callback_cbs_state_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_state_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_state_c0_0 ()
{
  return new qt_gsi::GenericMethod ("state", "@hide", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_state_c0_0 ()
{
  return new qt_gsi::GenericMethod ("state", "@brief Virtual method QAccessible::State QAccessibleApplication::state()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0, &_set_callback_cbs_state_c0_0);
}


// QString QAccessibleApplication::text(QAccessible::Text t)

static void _init_cbs_text_c2060_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("t");
  decl->add_arg<const qt_gsi::Converter<QAccessible::Text>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_cbs_text_c2060_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAccessible::Text>::target_type & arg1 = args.read<const qt_gsi::Converter<QAccessible::Text>::target_type & > (heap);
  ret.write<QString > ((QString)((QAccessibleApplication_Adaptor *)cls)->cbs_text_c2060_0 (arg1));
}

static void _set_callback_cbs_text_c2060_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_text_c2060_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_text_c2060_0 ()
{
  return new qt_gsi::GenericMethod ("text", "@hide", true, &_init_cbs_text_c2060_0, &_call_cbs_text_c2060_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_text_c2060_0 ()
{
  return new qt_gsi::GenericMethod ("text", "@brief Virtual method QString QAccessibleApplication::text(QAccessible::Text t)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_text_c2060_0, &_call_cbs_text_c2060_0, &_set_callback_cbs_text_c2060_0);
}


// void QAccessibleApplication::virtual_hook(int id, void *data)

static void _init_cbs_virtual_hook_1715_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<void * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_virtual_hook_1715_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  void *arg2 = args.read<void * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleApplication_Adaptor *)cls)->cbs_virtual_hook_1715_0 (arg1, arg2);
}

static void _set_callback_cbs_virtual_hook_1715_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_virtual_hook_1715_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_virtual_hook_1715_0 ()
{
  return new qt_gsi::GenericMethod ("virtual_hook", "@hide", false, &_init_cbs_virtual_hook_1715_0, &_call_cbs_virtual_hook_1715_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_virtual_hook_1715_0 ()
{
  return new qt_gsi::GenericMethod ("virtual_hook", "@brief Virtual method void QAccessibleApplication::virtual_hook(int id, void *data)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_virtual_hook_1715_0, &_call_cbs_virtual_hook_1715_0, &_set_callback_cbs_virtual_hook_1715_0);
}


// QWindow *QAccessibleApplication::window()

static void _init_cbs_window_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWindow * > ();
}

static void _call_cbs_window_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWindow * > ((QWindow *)((QAccessibleApplication_Adaptor *)cls)->cbs_window_c0_0 ());
}

static void _set_callback_cbs_window_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleApplication_Adaptor *)cls)->cb_window_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_window_c0_0 ()
{
  return new qt_gsi::GenericMethod ("window", "@hide", true, &_init_cbs_window_c0_0, &_call_cbs_window_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_window_c0_0 ()
{
  return new qt_gsi::GenericMethod ("window", "@brief Virtual method QWindow *QAccessibleApplication::window()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_window_c0_0, &_call_cbs_window_c0_0, &_set_callback_cbs_window_c0_0);
}


namespace gsi
{

extern gsi::Class<QAccessibleApplication> decl_QAccessibleApplication;

gsi::Class<QAccessibleApplication_Adaptor> decl_QAccessibleApplication_Adaptor (decl_QAccessibleApplication, "QAccessibleApplication",
  gsi::Methods(_create_cbs_backgroundColor_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_backgroundColor_c0_0 ()) +
  gsi::Methods(_create_cbs_child_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_child_c767_0 ()) +
  gsi::Methods(_create_cbs_childAt_c1426_0 ()) +
  gsi::Methods(_create_callback_cbs_childAt_c1426_0 ()) +
  gsi::Methods(_create_cbs_childCount_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_childCount_c0_0 ()) +
  gsi::Methods(_create_cbs_focusChild_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_focusChild_c0_0 ()) +
  gsi::Methods(_create_cbs_foregroundColor_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_foregroundColor_c0_0 ()) +
  gsi::Methods(_create_cbs_indexOfChild_c3317_0 ()) +
  gsi::Methods(_create_callback_cbs_indexOfChild_c3317_0 ()) +
  gsi::Methods(_create_cbs_interface_cast_2970_0 ()) +
  gsi::Methods(_create_callback_cbs_interface_cast_2970_0 ()) +
  gsi::Methods(_create_cbs_isValid_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_isValid_c0_0 ()) +
  gsi::Methods(_create_cbs_object_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_object_c0_0 ()) +
  gsi::Methods(_create_cbs_parent_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_parent_c0_0 ()) +
  gsi::Methods(_create_cbs_rect_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_rect_c0_0 ()) +
  gsi::Methods(_create_cbs_relations_c3543_1 ()) +
  gsi::Methods(_create_callback_cbs_relations_c3543_1 ()) +
  gsi::Methods(_create_cbs_role_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_role_c0_0 ()) +
  gsi::Methods(_create_cbs_setText_3977_0 ()) +
  gsi::Methods(_create_callback_cbs_setText_3977_0 ()) +
  gsi::Methods(_create_cbs_state_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_state_c0_0 ()) +
  gsi::Methods(_create_cbs_text_c2060_0 ()) +
  gsi::Methods(_create_callback_cbs_text_c2060_0 ()) +
  gsi::Methods(_create_cbs_virtual_hook_1715_0 ()) +
  gsi::Methods(_create_callback_cbs_virtual_hook_1715_0 ()) +
  gsi::Methods(_create_cbs_window_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_window_c0_0 ()) +
  gsi::Methods(_create_ctor_QAccessibleApplication_Adaptor_0 ()),
  "@qt\n@brief Binding of QAccessibleApplication");

}

