
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAccessibleTextInterface.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAccessibleTextInterface>
#include <QPoint>
#include <QRect>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAccessibleTextInterface

// void QAccessibleTextInterface::addSelection(int startOffset, int endOffset)


static void _init_f_addSelection_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startOffset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endOffset");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addSelection_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTextInterface *)cls)->addSelection (arg1, arg2);
}


// QString QAccessibleTextInterface::attributes(int offset, int *startOffset, int *endOffset)


static void _init_f_attributes_c2457 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("startOffset");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("endOffset");
  decl->add_arg<int * > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_attributes_c2457 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int *arg2 = args.read<int * > (heap);
  int *arg3 = args.read<int * > (heap);
  ret.write<QString > ((QString)((QAccessibleTextInterface *)cls)->attributes (arg1, arg2, arg3));
}


// int QAccessibleTextInterface::characterCount()


static void _init_f_characterCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_characterCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTextInterface *)cls)->characterCount ());
}


// QRect QAccessibleTextInterface::characterRect(int offset)


static void _init_f_characterRect_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_characterRect_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QRect > ((QRect)((QAccessibleTextInterface *)cls)->characterRect (arg1));
}


// int QAccessibleTextInterface::cursorPosition()


static void _init_f_cursorPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_cursorPosition_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTextInterface *)cls)->cursorPosition ());
}


// int QAccessibleTextInterface::offsetAtPoint(const QPoint &point)


static void _init_f_offsetAtPoint_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_offsetAtPoint_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  ret.write<int > ((int)((QAccessibleTextInterface *)cls)->offsetAtPoint (arg1));
}


// void QAccessibleTextInterface::removeSelection(int selectionIndex)


static void _init_f_removeSelection_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeSelection_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTextInterface *)cls)->removeSelection (arg1);
}


// void QAccessibleTextInterface::scrollToSubstring(int startIndex, int endIndex)


static void _init_f_scrollToSubstring_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startIndex");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endIndex");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scrollToSubstring_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTextInterface *)cls)->scrollToSubstring (arg1, arg2);
}


// void QAccessibleTextInterface::selection(int selectionIndex, int *startOffset, int *endOffset)


static void _init_f_selection_c2457 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionIndex");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("startOffset");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("endOffset");
  decl->add_arg<int * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_selection_c2457 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int *arg2 = args.read<int * > (heap);
  int *arg3 = args.read<int * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTextInterface *)cls)->selection (arg1, arg2, arg3);
}


// int QAccessibleTextInterface::selectionCount()


static void _init_f_selectionCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_selectionCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTextInterface *)cls)->selectionCount ());
}


// void QAccessibleTextInterface::setCursorPosition(int position)


static void _init_f_setCursorPosition_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursorPosition_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTextInterface *)cls)->setCursorPosition (arg1);
}


// void QAccessibleTextInterface::setSelection(int selectionIndex, int startOffset, int endOffset)


static void _init_f_setSelection_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionIndex");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("startOffset");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("endOffset");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setSelection_2085 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTextInterface *)cls)->setSelection (arg1, arg2, arg3);
}


// QString QAccessibleTextInterface::text(int startOffset, int endOffset)


static void _init_f_text_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startOffset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endOffset");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_text_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QString > ((QString)((QAccessibleTextInterface *)cls)->text (arg1, arg2));
}


// QString QAccessibleTextInterface::textAfterOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)


static void _init_f_textAfterOffset_c5663 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("boundaryType");
  decl->add_arg<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("startOffset");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("endOffset");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_textAfterOffset_c5663 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & arg2 = args.read<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (heap);
  int *arg3 = args.read<int * > (heap);
  int *arg4 = args.read<int * > (heap);
  ret.write<QString > ((QString)((QAccessibleTextInterface *)cls)->textAfterOffset (arg1, qt_gsi::QtToCppAdaptor<QAccessible::TextBoundaryType>(arg2).cref(), arg3, arg4));
}


// QString QAccessibleTextInterface::textAtOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)


static void _init_f_textAtOffset_c5663 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("boundaryType");
  decl->add_arg<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("startOffset");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("endOffset");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_textAtOffset_c5663 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & arg2 = args.read<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (heap);
  int *arg3 = args.read<int * > (heap);
  int *arg4 = args.read<int * > (heap);
  ret.write<QString > ((QString)((QAccessibleTextInterface *)cls)->textAtOffset (arg1, qt_gsi::QtToCppAdaptor<QAccessible::TextBoundaryType>(arg2).cref(), arg3, arg4));
}


// QString QAccessibleTextInterface::textBeforeOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)


static void _init_f_textBeforeOffset_c5663 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("boundaryType");
  decl->add_arg<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("startOffset");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("endOffset");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_textBeforeOffset_c5663 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & arg2 = args.read<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (heap);
  int *arg3 = args.read<int * > (heap);
  int *arg4 = args.read<int * > (heap);
  ret.write<QString > ((QString)((QAccessibleTextInterface *)cls)->textBeforeOffset (arg1, qt_gsi::QtToCppAdaptor<QAccessible::TextBoundaryType>(arg2).cref(), arg3, arg4));
}


namespace gsi
{

static gsi::Methods methods_QAccessibleTextInterface () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("addSelection", "@brief Method void QAccessibleTextInterface::addSelection(int startOffset, int endOffset)\n", false, &_init_f_addSelection_1426, &_call_f_addSelection_1426);
  methods += new qt_gsi::GenericMethod ("attributes", "@brief Method QString QAccessibleTextInterface::attributes(int offset, int *startOffset, int *endOffset)\n", true, &_init_f_attributes_c2457, &_call_f_attributes_c2457);
  methods += new qt_gsi::GenericMethod ("characterCount", "@brief Method int QAccessibleTextInterface::characterCount()\n", true, &_init_f_characterCount_c0, &_call_f_characterCount_c0);
  methods += new qt_gsi::GenericMethod ("characterRect", "@brief Method QRect QAccessibleTextInterface::characterRect(int offset)\n", true, &_init_f_characterRect_c767, &_call_f_characterRect_c767);
  methods += new qt_gsi::GenericMethod (":cursorPosition", "@brief Method int QAccessibleTextInterface::cursorPosition()\n", true, &_init_f_cursorPosition_c0, &_call_f_cursorPosition_c0);
  methods += new qt_gsi::GenericMethod ("offsetAtPoint", "@brief Method int QAccessibleTextInterface::offsetAtPoint(const QPoint &point)\n", true, &_init_f_offsetAtPoint_c1916, &_call_f_offsetAtPoint_c1916);
  methods += new qt_gsi::GenericMethod ("removeSelection", "@brief Method void QAccessibleTextInterface::removeSelection(int selectionIndex)\n", false, &_init_f_removeSelection_767, &_call_f_removeSelection_767);
  methods += new qt_gsi::GenericMethod ("scrollToSubstring", "@brief Method void QAccessibleTextInterface::scrollToSubstring(int startIndex, int endIndex)\n", false, &_init_f_scrollToSubstring_1426, &_call_f_scrollToSubstring_1426);
  methods += new qt_gsi::GenericMethod ("selection", "@brief Method void QAccessibleTextInterface::selection(int selectionIndex, int *startOffset, int *endOffset)\n", true, &_init_f_selection_c2457, &_call_f_selection_c2457);
  methods += new qt_gsi::GenericMethod ("selectionCount", "@brief Method int QAccessibleTextInterface::selectionCount()\n", true, &_init_f_selectionCount_c0, &_call_f_selectionCount_c0);
  methods += new qt_gsi::GenericMethod ("setCursorPosition|cursorPosition=", "@brief Method void QAccessibleTextInterface::setCursorPosition(int position)\n", false, &_init_f_setCursorPosition_767, &_call_f_setCursorPosition_767);
  methods += new qt_gsi::GenericMethod ("setSelection", "@brief Method void QAccessibleTextInterface::setSelection(int selectionIndex, int startOffset, int endOffset)\n", false, &_init_f_setSelection_2085, &_call_f_setSelection_2085);
  methods += new qt_gsi::GenericMethod ("text", "@brief Method QString QAccessibleTextInterface::text(int startOffset, int endOffset)\n", true, &_init_f_text_c1426, &_call_f_text_c1426);
  methods += new qt_gsi::GenericMethod ("textAfterOffset", "@brief Method QString QAccessibleTextInterface::textAfterOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)\n", true, &_init_f_textAfterOffset_c5663, &_call_f_textAfterOffset_c5663);
  methods += new qt_gsi::GenericMethod ("textAtOffset", "@brief Method QString QAccessibleTextInterface::textAtOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)\n", true, &_init_f_textAtOffset_c5663, &_call_f_textAtOffset_c5663);
  methods += new qt_gsi::GenericMethod ("textBeforeOffset", "@brief Method QString QAccessibleTextInterface::textBeforeOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)\n", true, &_init_f_textBeforeOffset_c5663, &_call_f_textBeforeOffset_c5663);
  return methods;
}

gsi::Class<QAccessibleTextInterface> decl_QAccessibleTextInterface ("QAccessibleTextInterface_Native",
  methods_QAccessibleTextInterface (),
  "@hide\n@alias QAccessibleTextInterface");

GSIQT_PUBLIC gsi::Class<QAccessibleTextInterface> &qtdecl_QAccessibleTextInterface () { return decl_QAccessibleTextInterface; }

}


class QAccessibleTextInterface_Adaptor : public QAccessibleTextInterface, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAccessibleTextInterface_Adaptor();

  //  [adaptor ctor] QAccessibleTextInterface::QAccessibleTextInterface()
  QAccessibleTextInterface_Adaptor() : QAccessibleTextInterface()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] void QAccessibleTextInterface::addSelection(int startOffset, int endOffset)
  void cbs_addSelection_1426_0(int startOffset, int endOffset)
  {
    __SUPPRESS_UNUSED_WARNING (startOffset);
    __SUPPRESS_UNUSED_WARNING (endOffset);
    throw qt_gsi::AbstractMethodCalledException("addSelection");
  }

  virtual void addSelection(int startOffset, int endOffset)
  {
    if (cb_addSelection_1426_0.can_issue()) {
      cb_addSelection_1426_0.issue<QAccessibleTextInterface_Adaptor, int, int>(&QAccessibleTextInterface_Adaptor::cbs_addSelection_1426_0, startOffset, endOffset);
    } else {
      throw qt_gsi::AbstractMethodCalledException("addSelection");
    }
  }

  //  [adaptor impl] QString QAccessibleTextInterface::attributes(int offset, int *startOffset, int *endOffset)
  QString cbs_attributes_c2457_0(int offset, int *startOffset, int *endOffset) const
  {
    __SUPPRESS_UNUSED_WARNING (offset);
    __SUPPRESS_UNUSED_WARNING (startOffset);
    __SUPPRESS_UNUSED_WARNING (endOffset);
    throw qt_gsi::AbstractMethodCalledException("attributes");
  }

  virtual QString attributes(int offset, int *startOffset, int *endOffset) const
  {
    if (cb_attributes_c2457_0.can_issue()) {
      return cb_attributes_c2457_0.issue<QAccessibleTextInterface_Adaptor, QString, int, int *, int *>(&QAccessibleTextInterface_Adaptor::cbs_attributes_c2457_0, offset, startOffset, endOffset);
    } else {
      throw qt_gsi::AbstractMethodCalledException("attributes");
    }
  }

  //  [adaptor impl] int QAccessibleTextInterface::characterCount()
  int cbs_characterCount_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("characterCount");
  }

  virtual int characterCount() const
  {
    if (cb_characterCount_c0_0.can_issue()) {
      return cb_characterCount_c0_0.issue<QAccessibleTextInterface_Adaptor, int>(&QAccessibleTextInterface_Adaptor::cbs_characterCount_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("characterCount");
    }
  }

  //  [adaptor impl] QRect QAccessibleTextInterface::characterRect(int offset)
  QRect cbs_characterRect_c767_0(int offset) const
  {
    __SUPPRESS_UNUSED_WARNING (offset);
    throw qt_gsi::AbstractMethodCalledException("characterRect");
  }

  virtual QRect characterRect(int offset) const
  {
    if (cb_characterRect_c767_0.can_issue()) {
      return cb_characterRect_c767_0.issue<QAccessibleTextInterface_Adaptor, QRect, int>(&QAccessibleTextInterface_Adaptor::cbs_characterRect_c767_0, offset);
    } else {
      throw qt_gsi::AbstractMethodCalledException("characterRect");
    }
  }

  //  [adaptor impl] int QAccessibleTextInterface::cursorPosition()
  int cbs_cursorPosition_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("cursorPosition");
  }

  virtual int cursorPosition() const
  {
    if (cb_cursorPosition_c0_0.can_issue()) {
      return cb_cursorPosition_c0_0.issue<QAccessibleTextInterface_Adaptor, int>(&QAccessibleTextInterface_Adaptor::cbs_cursorPosition_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("cursorPosition");
    }
  }

  //  [adaptor impl] int QAccessibleTextInterface::offsetAtPoint(const QPoint &point)
  int cbs_offsetAtPoint_c1916_0(const QPoint &point) const
  {
    __SUPPRESS_UNUSED_WARNING (point);
    throw qt_gsi::AbstractMethodCalledException("offsetAtPoint");
  }

  virtual int offsetAtPoint(const QPoint &point) const
  {
    if (cb_offsetAtPoint_c1916_0.can_issue()) {
      return cb_offsetAtPoint_c1916_0.issue<QAccessibleTextInterface_Adaptor, int, const QPoint &>(&QAccessibleTextInterface_Adaptor::cbs_offsetAtPoint_c1916_0, point);
    } else {
      throw qt_gsi::AbstractMethodCalledException("offsetAtPoint");
    }
  }

  //  [adaptor impl] void QAccessibleTextInterface::removeSelection(int selectionIndex)
  void cbs_removeSelection_767_0(int selectionIndex)
  {
    __SUPPRESS_UNUSED_WARNING (selectionIndex);
    throw qt_gsi::AbstractMethodCalledException("removeSelection");
  }

  virtual void removeSelection(int selectionIndex)
  {
    if (cb_removeSelection_767_0.can_issue()) {
      cb_removeSelection_767_0.issue<QAccessibleTextInterface_Adaptor, int>(&QAccessibleTextInterface_Adaptor::cbs_removeSelection_767_0, selectionIndex);
    } else {
      throw qt_gsi::AbstractMethodCalledException("removeSelection");
    }
  }

  //  [adaptor impl] void QAccessibleTextInterface::scrollToSubstring(int startIndex, int endIndex)
  void cbs_scrollToSubstring_1426_0(int startIndex, int endIndex)
  {
    __SUPPRESS_UNUSED_WARNING (startIndex);
    __SUPPRESS_UNUSED_WARNING (endIndex);
    throw qt_gsi::AbstractMethodCalledException("scrollToSubstring");
  }

  virtual void scrollToSubstring(int startIndex, int endIndex)
  {
    if (cb_scrollToSubstring_1426_0.can_issue()) {
      cb_scrollToSubstring_1426_0.issue<QAccessibleTextInterface_Adaptor, int, int>(&QAccessibleTextInterface_Adaptor::cbs_scrollToSubstring_1426_0, startIndex, endIndex);
    } else {
      throw qt_gsi::AbstractMethodCalledException("scrollToSubstring");
    }
  }

  //  [adaptor impl] void QAccessibleTextInterface::selection(int selectionIndex, int *startOffset, int *endOffset)
  void cbs_selection_c2457_0(int selectionIndex, int *startOffset, int *endOffset) const
  {
    __SUPPRESS_UNUSED_WARNING (selectionIndex);
    __SUPPRESS_UNUSED_WARNING (startOffset);
    __SUPPRESS_UNUSED_WARNING (endOffset);
    throw qt_gsi::AbstractMethodCalledException("selection");
  }

  virtual void selection(int selectionIndex, int *startOffset, int *endOffset) const
  {
    if (cb_selection_c2457_0.can_issue()) {
      cb_selection_c2457_0.issue<QAccessibleTextInterface_Adaptor, int, int *, int *>(&QAccessibleTextInterface_Adaptor::cbs_selection_c2457_0, selectionIndex, startOffset, endOffset);
    } else {
      throw qt_gsi::AbstractMethodCalledException("selection");
    }
  }

  //  [adaptor impl] int QAccessibleTextInterface::selectionCount()
  int cbs_selectionCount_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("selectionCount");
  }

  virtual int selectionCount() const
  {
    if (cb_selectionCount_c0_0.can_issue()) {
      return cb_selectionCount_c0_0.issue<QAccessibleTextInterface_Adaptor, int>(&QAccessibleTextInterface_Adaptor::cbs_selectionCount_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("selectionCount");
    }
  }

  //  [adaptor impl] void QAccessibleTextInterface::setCursorPosition(int position)
  void cbs_setCursorPosition_767_0(int position)
  {
    __SUPPRESS_UNUSED_WARNING (position);
    throw qt_gsi::AbstractMethodCalledException("setCursorPosition");
  }

  virtual void setCursorPosition(int position)
  {
    if (cb_setCursorPosition_767_0.can_issue()) {
      cb_setCursorPosition_767_0.issue<QAccessibleTextInterface_Adaptor, int>(&QAccessibleTextInterface_Adaptor::cbs_setCursorPosition_767_0, position);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setCursorPosition");
    }
  }

  //  [adaptor impl] void QAccessibleTextInterface::setSelection(int selectionIndex, int startOffset, int endOffset)
  void cbs_setSelection_2085_0(int selectionIndex, int startOffset, int endOffset)
  {
    __SUPPRESS_UNUSED_WARNING (selectionIndex);
    __SUPPRESS_UNUSED_WARNING (startOffset);
    __SUPPRESS_UNUSED_WARNING (endOffset);
    throw qt_gsi::AbstractMethodCalledException("setSelection");
  }

  virtual void setSelection(int selectionIndex, int startOffset, int endOffset)
  {
    if (cb_setSelection_2085_0.can_issue()) {
      cb_setSelection_2085_0.issue<QAccessibleTextInterface_Adaptor, int, int, int>(&QAccessibleTextInterface_Adaptor::cbs_setSelection_2085_0, selectionIndex, startOffset, endOffset);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setSelection");
    }
  }

  //  [adaptor impl] QString QAccessibleTextInterface::text(int startOffset, int endOffset)
  QString cbs_text_c1426_0(int startOffset, int endOffset) const
  {
    __SUPPRESS_UNUSED_WARNING (startOffset);
    __SUPPRESS_UNUSED_WARNING (endOffset);
    throw qt_gsi::AbstractMethodCalledException("text");
  }

  virtual QString text(int startOffset, int endOffset) const
  {
    if (cb_text_c1426_0.can_issue()) {
      return cb_text_c1426_0.issue<QAccessibleTextInterface_Adaptor, QString, int, int>(&QAccessibleTextInterface_Adaptor::cbs_text_c1426_0, startOffset, endOffset);
    } else {
      throw qt_gsi::AbstractMethodCalledException("text");
    }
  }

  //  [adaptor impl] QString QAccessibleTextInterface::textAfterOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)
  QString cbs_textAfterOffset_c5663_0(int offset, const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & boundaryType, int *startOffset, int *endOffset) const
  {
    return QAccessibleTextInterface::textAfterOffset(offset, qt_gsi::QtToCppAdaptor<QAccessible::TextBoundaryType>(boundaryType).cref(), startOffset, endOffset);
  }

  virtual QString textAfterOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset) const
  {
    if (cb_textAfterOffset_c5663_0.can_issue()) {
      return cb_textAfterOffset_c5663_0.issue<QAccessibleTextInterface_Adaptor, QString, int, const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type &, int *, int *>(&QAccessibleTextInterface_Adaptor::cbs_textAfterOffset_c5663_0, offset, qt_gsi::CppToQtAdaptor<QAccessible::TextBoundaryType>(boundaryType), startOffset, endOffset);
    } else {
      return QAccessibleTextInterface::textAfterOffset(offset, boundaryType, startOffset, endOffset);
    }
  }

  //  [adaptor impl] QString QAccessibleTextInterface::textAtOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)
  QString cbs_textAtOffset_c5663_0(int offset, const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & boundaryType, int *startOffset, int *endOffset) const
  {
    return QAccessibleTextInterface::textAtOffset(offset, qt_gsi::QtToCppAdaptor<QAccessible::TextBoundaryType>(boundaryType).cref(), startOffset, endOffset);
  }

  virtual QString textAtOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset) const
  {
    if (cb_textAtOffset_c5663_0.can_issue()) {
      return cb_textAtOffset_c5663_0.issue<QAccessibleTextInterface_Adaptor, QString, int, const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type &, int *, int *>(&QAccessibleTextInterface_Adaptor::cbs_textAtOffset_c5663_0, offset, qt_gsi::CppToQtAdaptor<QAccessible::TextBoundaryType>(boundaryType), startOffset, endOffset);
    } else {
      return QAccessibleTextInterface::textAtOffset(offset, boundaryType, startOffset, endOffset);
    }
  }

  //  [adaptor impl] QString QAccessibleTextInterface::textBeforeOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)
  QString cbs_textBeforeOffset_c5663_0(int offset, const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & boundaryType, int *startOffset, int *endOffset) const
  {
    return QAccessibleTextInterface::textBeforeOffset(offset, qt_gsi::QtToCppAdaptor<QAccessible::TextBoundaryType>(boundaryType).cref(), startOffset, endOffset);
  }

  virtual QString textBeforeOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset) const
  {
    if (cb_textBeforeOffset_c5663_0.can_issue()) {
      return cb_textBeforeOffset_c5663_0.issue<QAccessibleTextInterface_Adaptor, QString, int, const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type &, int *, int *>(&QAccessibleTextInterface_Adaptor::cbs_textBeforeOffset_c5663_0, offset, qt_gsi::CppToQtAdaptor<QAccessible::TextBoundaryType>(boundaryType), startOffset, endOffset);
    } else {
      return QAccessibleTextInterface::textBeforeOffset(offset, boundaryType, startOffset, endOffset);
    }
  }

  gsi::Callback cb_addSelection_1426_0;
  gsi::Callback cb_attributes_c2457_0;
  gsi::Callback cb_characterCount_c0_0;
  gsi::Callback cb_characterRect_c767_0;
  gsi::Callback cb_cursorPosition_c0_0;
  gsi::Callback cb_offsetAtPoint_c1916_0;
  gsi::Callback cb_removeSelection_767_0;
  gsi::Callback cb_scrollToSubstring_1426_0;
  gsi::Callback cb_selection_c2457_0;
  gsi::Callback cb_selectionCount_c0_0;
  gsi::Callback cb_setCursorPosition_767_0;
  gsi::Callback cb_setSelection_2085_0;
  gsi::Callback cb_text_c1426_0;
  gsi::Callback cb_textAfterOffset_c5663_0;
  gsi::Callback cb_textAtOffset_c5663_0;
  gsi::Callback cb_textBeforeOffset_c5663_0;
};

QAccessibleTextInterface_Adaptor::~QAccessibleTextInterface_Adaptor() { }

//  Constructor QAccessibleTextInterface::QAccessibleTextInterface() (adaptor class)

static void _init_ctor_QAccessibleTextInterface_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QAccessibleTextInterface_Adaptor> ();
}

static void _call_ctor_QAccessibleTextInterface_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleTextInterface_Adaptor *> (new QAccessibleTextInterface_Adaptor ());
}


// void QAccessibleTextInterface::addSelection(int startOffset, int endOffset)

static void _init_cbs_addSelection_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startOffset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endOffset");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_addSelection_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTextInterface_Adaptor *)cls)->cbs_addSelection_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_addSelection_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_addSelection_1426_0 = cb;
}


// QString QAccessibleTextInterface::attributes(int offset, int *startOffset, int *endOffset)

static void _init_cbs_attributes_c2457_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("startOffset");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("endOffset");
  decl->add_arg<int * > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_cbs_attributes_c2457_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int *arg2 = args.read<int * > (heap);
  int *arg3 = args.read<int * > (heap);
  ret.write<QString > ((QString)((QAccessibleTextInterface_Adaptor *)cls)->cbs_attributes_c2457_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_attributes_c2457_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_attributes_c2457_0 = cb;
}


// int QAccessibleTextInterface::characterCount()

static void _init_cbs_characterCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_characterCount_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTextInterface_Adaptor *)cls)->cbs_characterCount_c0_0 ());
}

static void _set_callback_cbs_characterCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_characterCount_c0_0 = cb;
}


// QRect QAccessibleTextInterface::characterRect(int offset)

static void _init_cbs_characterRect_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_cbs_characterRect_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QRect > ((QRect)((QAccessibleTextInterface_Adaptor *)cls)->cbs_characterRect_c767_0 (arg1));
}

static void _set_callback_cbs_characterRect_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_characterRect_c767_0 = cb;
}


// int QAccessibleTextInterface::cursorPosition()

static void _init_cbs_cursorPosition_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_cursorPosition_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTextInterface_Adaptor *)cls)->cbs_cursorPosition_c0_0 ());
}

static void _set_callback_cbs_cursorPosition_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_cursorPosition_c0_0 = cb;
}


// int QAccessibleTextInterface::offsetAtPoint(const QPoint &point)

static void _init_cbs_offsetAtPoint_c1916_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_offsetAtPoint_c1916_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  ret.write<int > ((int)((QAccessibleTextInterface_Adaptor *)cls)->cbs_offsetAtPoint_c1916_0 (arg1));
}

static void _set_callback_cbs_offsetAtPoint_c1916_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_offsetAtPoint_c1916_0 = cb;
}


// void QAccessibleTextInterface::removeSelection(int selectionIndex)

static void _init_cbs_removeSelection_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_removeSelection_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTextInterface_Adaptor *)cls)->cbs_removeSelection_767_0 (arg1);
}

static void _set_callback_cbs_removeSelection_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_removeSelection_767_0 = cb;
}


// void QAccessibleTextInterface::scrollToSubstring(int startIndex, int endIndex)

static void _init_cbs_scrollToSubstring_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startIndex");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endIndex");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollToSubstring_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTextInterface_Adaptor *)cls)->cbs_scrollToSubstring_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollToSubstring_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_scrollToSubstring_1426_0 = cb;
}


// void QAccessibleTextInterface::selection(int selectionIndex, int *startOffset, int *endOffset)

static void _init_cbs_selection_c2457_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionIndex");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("startOffset");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("endOffset");
  decl->add_arg<int * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_selection_c2457_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int *arg2 = args.read<int * > (heap);
  int *arg3 = args.read<int * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTextInterface_Adaptor *)cls)->cbs_selection_c2457_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_selection_c2457_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_selection_c2457_0 = cb;
}


// int QAccessibleTextInterface::selectionCount()

static void _init_cbs_selectionCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_selectionCount_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAccessibleTextInterface_Adaptor *)cls)->cbs_selectionCount_c0_0 ());
}

static void _set_callback_cbs_selectionCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_selectionCount_c0_0 = cb;
}


// void QAccessibleTextInterface::setCursorPosition(int position)

static void _init_cbs_setCursorPosition_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setCursorPosition_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTextInterface_Adaptor *)cls)->cbs_setCursorPosition_767_0 (arg1);
}

static void _set_callback_cbs_setCursorPosition_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_setCursorPosition_767_0 = cb;
}


// void QAccessibleTextInterface::setSelection(int selectionIndex, int startOffset, int endOffset)

static void _init_cbs_setSelection_2085_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionIndex");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("startOffset");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("endOffset");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_setSelection_2085_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAccessibleTextInterface_Adaptor *)cls)->cbs_setSelection_2085_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_setSelection_2085_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_setSelection_2085_0 = cb;
}


// QString QAccessibleTextInterface::text(int startOffset, int endOffset)

static void _init_cbs_text_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("startOffset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("endOffset");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_cbs_text_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QString > ((QString)((QAccessibleTextInterface_Adaptor *)cls)->cbs_text_c1426_0 (arg1, arg2));
}

static void _set_callback_cbs_text_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_text_c1426_0 = cb;
}


// QString QAccessibleTextInterface::textAfterOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)

static void _init_cbs_textAfterOffset_c5663_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("boundaryType");
  decl->add_arg<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("startOffset");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("endOffset");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_cbs_textAfterOffset_c5663_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & arg2 = args.read<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (heap);
  int *arg3 = args.read<int * > (heap);
  int *arg4 = args.read<int * > (heap);
  ret.write<QString > ((QString)((QAccessibleTextInterface_Adaptor *)cls)->cbs_textAfterOffset_c5663_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_textAfterOffset_c5663_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_textAfterOffset_c5663_0 = cb;
}


// QString QAccessibleTextInterface::textAtOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)

static void _init_cbs_textAtOffset_c5663_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("boundaryType");
  decl->add_arg<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("startOffset");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("endOffset");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_cbs_textAtOffset_c5663_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & arg2 = args.read<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (heap);
  int *arg3 = args.read<int * > (heap);
  int *arg4 = args.read<int * > (heap);
  ret.write<QString > ((QString)((QAccessibleTextInterface_Adaptor *)cls)->cbs_textAtOffset_c5663_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_textAtOffset_c5663_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_textAtOffset_c5663_0 = cb;
}


// QString QAccessibleTextInterface::textBeforeOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)

static void _init_cbs_textBeforeOffset_c5663_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("boundaryType");
  decl->add_arg<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("startOffset");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("endOffset");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_cbs_textBeforeOffset_c5663_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & arg2 = args.read<const qt_gsi::Converter<QAccessible::TextBoundaryType>::target_type & > (heap);
  int *arg3 = args.read<int * > (heap);
  int *arg4 = args.read<int * > (heap);
  ret.write<QString > ((QString)((QAccessibleTextInterface_Adaptor *)cls)->cbs_textBeforeOffset_c5663_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_textBeforeOffset_c5663_0 (void *cls, const gsi::Callback &cb)
{
  ((QAccessibleTextInterface_Adaptor *)cls)->cb_textBeforeOffset_c5663_0 = cb;
}


namespace gsi
{

gsi::Class<QAccessibleTextInterface> &qtdecl_QAccessibleTextInterface ();

static gsi::Methods methods_QAccessibleTextInterface_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAccessibleTextInterface::QAccessibleTextInterface()\nThis method creates an object of class QAccessibleTextInterface.", &_init_ctor_QAccessibleTextInterface_Adaptor_0, &_call_ctor_QAccessibleTextInterface_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("addSelection", "@hide", false, &_init_cbs_addSelection_1426_0, &_call_cbs_addSelection_1426_0);
  methods += new qt_gsi::GenericMethod ("addSelection", "@brief Virtual method void QAccessibleTextInterface::addSelection(int startOffset, int endOffset)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_addSelection_1426_0, &_call_cbs_addSelection_1426_0, &_set_callback_cbs_addSelection_1426_0);
  methods += new qt_gsi::GenericMethod ("attributes", "@hide", true, &_init_cbs_attributes_c2457_0, &_call_cbs_attributes_c2457_0);
  methods += new qt_gsi::GenericMethod ("attributes", "@brief Virtual method QString QAccessibleTextInterface::attributes(int offset, int *startOffset, int *endOffset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_attributes_c2457_0, &_call_cbs_attributes_c2457_0, &_set_callback_cbs_attributes_c2457_0);
  methods += new qt_gsi::GenericMethod ("characterCount", "@hide", true, &_init_cbs_characterCount_c0_0, &_call_cbs_characterCount_c0_0);
  methods += new qt_gsi::GenericMethod ("characterCount", "@brief Virtual method int QAccessibleTextInterface::characterCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_characterCount_c0_0, &_call_cbs_characterCount_c0_0, &_set_callback_cbs_characterCount_c0_0);
  methods += new qt_gsi::GenericMethod ("characterRect", "@hide", true, &_init_cbs_characterRect_c767_0, &_call_cbs_characterRect_c767_0);
  methods += new qt_gsi::GenericMethod ("characterRect", "@brief Virtual method QRect QAccessibleTextInterface::characterRect(int offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_characterRect_c767_0, &_call_cbs_characterRect_c767_0, &_set_callback_cbs_characterRect_c767_0);
  methods += new qt_gsi::GenericMethod ("cursorPosition", "@hide", true, &_init_cbs_cursorPosition_c0_0, &_call_cbs_cursorPosition_c0_0);
  methods += new qt_gsi::GenericMethod ("cursorPosition", "@brief Virtual method int QAccessibleTextInterface::cursorPosition()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_cursorPosition_c0_0, &_call_cbs_cursorPosition_c0_0, &_set_callback_cbs_cursorPosition_c0_0);
  methods += new qt_gsi::GenericMethod ("offsetAtPoint", "@hide", true, &_init_cbs_offsetAtPoint_c1916_0, &_call_cbs_offsetAtPoint_c1916_0);
  methods += new qt_gsi::GenericMethod ("offsetAtPoint", "@brief Virtual method int QAccessibleTextInterface::offsetAtPoint(const QPoint &point)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_offsetAtPoint_c1916_0, &_call_cbs_offsetAtPoint_c1916_0, &_set_callback_cbs_offsetAtPoint_c1916_0);
  methods += new qt_gsi::GenericMethod ("removeSelection", "@hide", false, &_init_cbs_removeSelection_767_0, &_call_cbs_removeSelection_767_0);
  methods += new qt_gsi::GenericMethod ("removeSelection", "@brief Virtual method void QAccessibleTextInterface::removeSelection(int selectionIndex)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeSelection_767_0, &_call_cbs_removeSelection_767_0, &_set_callback_cbs_removeSelection_767_0);
  methods += new qt_gsi::GenericMethod ("scrollToSubstring", "@hide", false, &_init_cbs_scrollToSubstring_1426_0, &_call_cbs_scrollToSubstring_1426_0);
  methods += new qt_gsi::GenericMethod ("scrollToSubstring", "@brief Virtual method void QAccessibleTextInterface::scrollToSubstring(int startIndex, int endIndex)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollToSubstring_1426_0, &_call_cbs_scrollToSubstring_1426_0, &_set_callback_cbs_scrollToSubstring_1426_0);
  methods += new qt_gsi::GenericMethod ("selection", "@hide", true, &_init_cbs_selection_c2457_0, &_call_cbs_selection_c2457_0);
  methods += new qt_gsi::GenericMethod ("selection", "@brief Virtual method void QAccessibleTextInterface::selection(int selectionIndex, int *startOffset, int *endOffset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selection_c2457_0, &_call_cbs_selection_c2457_0, &_set_callback_cbs_selection_c2457_0);
  methods += new qt_gsi::GenericMethod ("selectionCount", "@hide", true, &_init_cbs_selectionCount_c0_0, &_call_cbs_selectionCount_c0_0);
  methods += new qt_gsi::GenericMethod ("selectionCount", "@brief Virtual method int QAccessibleTextInterface::selectionCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectionCount_c0_0, &_call_cbs_selectionCount_c0_0, &_set_callback_cbs_selectionCount_c0_0);
  methods += new qt_gsi::GenericMethod ("setCursorPosition", "@hide", false, &_init_cbs_setCursorPosition_767_0, &_call_cbs_setCursorPosition_767_0);
  methods += new qt_gsi::GenericMethod ("setCursorPosition", "@brief Virtual method void QAccessibleTextInterface::setCursorPosition(int position)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setCursorPosition_767_0, &_call_cbs_setCursorPosition_767_0, &_set_callback_cbs_setCursorPosition_767_0);
  methods += new qt_gsi::GenericMethod ("setSelection", "@hide", false, &_init_cbs_setSelection_2085_0, &_call_cbs_setSelection_2085_0);
  methods += new qt_gsi::GenericMethod ("setSelection", "@brief Virtual method void QAccessibleTextInterface::setSelection(int selectionIndex, int startOffset, int endOffset)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelection_2085_0, &_call_cbs_setSelection_2085_0, &_set_callback_cbs_setSelection_2085_0);
  methods += new qt_gsi::GenericMethod ("text", "@hide", true, &_init_cbs_text_c1426_0, &_call_cbs_text_c1426_0);
  methods += new qt_gsi::GenericMethod ("text", "@brief Virtual method QString QAccessibleTextInterface::text(int startOffset, int endOffset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_text_c1426_0, &_call_cbs_text_c1426_0, &_set_callback_cbs_text_c1426_0);
  methods += new qt_gsi::GenericMethod ("textAfterOffset", "@hide", true, &_init_cbs_textAfterOffset_c5663_0, &_call_cbs_textAfterOffset_c5663_0);
  methods += new qt_gsi::GenericMethod ("textAfterOffset", "@brief Virtual method QString QAccessibleTextInterface::textAfterOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_textAfterOffset_c5663_0, &_call_cbs_textAfterOffset_c5663_0, &_set_callback_cbs_textAfterOffset_c5663_0);
  methods += new qt_gsi::GenericMethod ("textAtOffset", "@hide", true, &_init_cbs_textAtOffset_c5663_0, &_call_cbs_textAtOffset_c5663_0);
  methods += new qt_gsi::GenericMethod ("textAtOffset", "@brief Virtual method QString QAccessibleTextInterface::textAtOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_textAtOffset_c5663_0, &_call_cbs_textAtOffset_c5663_0, &_set_callback_cbs_textAtOffset_c5663_0);
  methods += new qt_gsi::GenericMethod ("textBeforeOffset", "@hide", true, &_init_cbs_textBeforeOffset_c5663_0, &_call_cbs_textBeforeOffset_c5663_0);
  methods += new qt_gsi::GenericMethod ("textBeforeOffset", "@brief Virtual method QString QAccessibleTextInterface::textBeforeOffset(int offset, QAccessible::TextBoundaryType boundaryType, int *startOffset, int *endOffset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_textBeforeOffset_c5663_0, &_call_cbs_textBeforeOffset_c5663_0, &_set_callback_cbs_textBeforeOffset_c5663_0);
  return methods;
}

gsi::Class<QAccessibleTextInterface_Adaptor> decl_QAccessibleTextInterface_Adaptor (qtdecl_QAccessibleTextInterface (), "QAccessibleTextInterface",
  methods_QAccessibleTextInterface_Adaptor (),
  "@qt\n@brief Binding of QAccessibleTextInterface");

}

