
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCameraExposureControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCameraExposureControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCameraExposureControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCameraExposureControl::staticMetaObject);
}


// QVariant QCameraExposureControl::actualValue(QCameraExposureControl::ExposureParameter parameter)


static void _init_f_actualValue_c4602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_actualValue_c4602 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QCameraExposureControl *)cls)->actualValue (qt_gsi::QtToCppAdaptor<QCameraExposureControl::ExposureParameter>(arg1).cref()));
}


// bool QCameraExposureControl::isParameterSupported(QCameraExposureControl::ExposureParameter parameter)


static void _init_f_isParameterSupported_c4602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isParameterSupported_c4602 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (heap);
  ret.write<bool > ((bool)((QCameraExposureControl *)cls)->isParameterSupported (qt_gsi::QtToCppAdaptor<QCameraExposureControl::ExposureParameter>(arg1).cref()));
}


// QVariant QCameraExposureControl::requestedValue(QCameraExposureControl::ExposureParameter parameter)


static void _init_f_requestedValue_c4602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_requestedValue_c4602 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QCameraExposureControl *)cls)->requestedValue (qt_gsi::QtToCppAdaptor<QCameraExposureControl::ExposureParameter>(arg1).cref()));
}


// bool QCameraExposureControl::setValue(QCameraExposureControl::ExposureParameter parameter, const QVariant &value)


static void _init_f_setValue_6613 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setValue_6613 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  ret.write<bool > ((bool)((QCameraExposureControl *)cls)->setValue (qt_gsi::QtToCppAdaptor<QCameraExposureControl::ExposureParameter>(arg1).cref(), arg2));
}


// QList<QVariant> QCameraExposureControl::supportedParameterRange(QCameraExposureControl::ExposureParameter parameter, bool *continuous)


static void _init_f_supportedParameterRange_c5544 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("continuous");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QList<QVariant> > ();
}

static void _call_f_supportedParameterRange_c5544 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (heap);
  bool *arg2 = args.read<bool * > (heap);
  ret.write<QList<QVariant> > ((QList<QVariant>)((QCameraExposureControl *)cls)->supportedParameterRange (qt_gsi::QtToCppAdaptor<QCameraExposureControl::ExposureParameter>(arg1).cref(), arg2));
}


// static QString QCameraExposureControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(__null);
  int arg3 = args ? args.read<int > (heap) : (int)(-1);
  ret.write<QString > ((QString)QCameraExposureControl::tr (arg1, arg2, arg3));
}


// static QString QCameraExposureControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(__null);
  int arg3 = args ? args.read<int > (heap) : (int)(-1);
  ret.write<QString > ((QString)QCameraExposureControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCameraExposureControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("actualValue", "@brief Method QVariant QCameraExposureControl::actualValue(QCameraExposureControl::ExposureParameter parameter)\n", true, &_init_f_actualValue_c4602, &_call_f_actualValue_c4602);
  methods += new qt_gsi::GenericMethod ("isParameterSupported?", "@brief Method bool QCameraExposureControl::isParameterSupported(QCameraExposureControl::ExposureParameter parameter)\n", true, &_init_f_isParameterSupported_c4602, &_call_f_isParameterSupported_c4602);
  methods += new qt_gsi::GenericMethod ("requestedValue", "@brief Method QVariant QCameraExposureControl::requestedValue(QCameraExposureControl::ExposureParameter parameter)\n", true, &_init_f_requestedValue_c4602, &_call_f_requestedValue_c4602);
  methods += new qt_gsi::GenericMethod ("setValue", "@brief Method bool QCameraExposureControl::setValue(QCameraExposureControl::ExposureParameter parameter, const QVariant &value)\n", false, &_init_f_setValue_6613, &_call_f_setValue_6613);
  methods += new qt_gsi::GenericMethod ("supportedParameterRange", "@brief Method QList<QVariant> QCameraExposureControl::supportedParameterRange(QCameraExposureControl::ExposureParameter parameter, bool *continuous)\n", true, &_init_f_supportedParameterRange_c5544, &_call_f_supportedParameterRange_c5544);
  methods += gsi::qt_signal<int > ("actualValueChanged(int)", "actualValueChanged", gsi::arg("parameter"), "@brief Signal declaration for QCameraExposureControl::actualValueChanged(int parameter)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QCameraExposureControl::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("parameterRangeChanged(int)", "parameterRangeChanged", gsi::arg("parameter"), "@brief Signal declaration for QCameraExposureControl::parameterRangeChanged(int parameter)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("requestedValueChanged(int)", "requestedValueChanged", gsi::arg("parameter"), "@brief Signal declaration for QCameraExposureControl::requestedValueChanged(int parameter)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCameraExposureControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCameraExposureControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QCameraExposureControl> decl_QCameraExposureControl (qtdecl_QMediaControl (), "QCameraExposureControl_Native",
  methods_QCameraExposureControl (),
  "@hide\n@alias QCameraExposureControl");

GSIQT_PUBLIC gsi::Class<QCameraExposureControl> &qtdecl_QCameraExposureControl () { return decl_QCameraExposureControl; }

}


class QCameraExposureControl_Adaptor : public QCameraExposureControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCameraExposureControl_Adaptor();

  //  [expose] bool QCameraExposureControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCameraExposureControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCameraExposureControl::isSignalConnected(signal);
  }

  //  [expose] int QCameraExposureControl::receivers(const char *signal)
  int fp_QCameraExposureControl_receivers_c1731 (const char *signal) const {
    return QCameraExposureControl::receivers(signal);
  }

  //  [expose] QObject *QCameraExposureControl::sender()
  QObject * fp_QCameraExposureControl_sender_c0 () const {
    return QCameraExposureControl::sender();
  }

  //  [expose] int QCameraExposureControl::senderSignalIndex()
  int fp_QCameraExposureControl_senderSignalIndex_c0 () const {
    return QCameraExposureControl::senderSignalIndex();
  }

  //  [adaptor impl] QVariant QCameraExposureControl::actualValue(QCameraExposureControl::ExposureParameter parameter)
  QVariant cbs_actualValue_c4602_0(const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & parameter) const
  {
    __SUPPRESS_UNUSED_WARNING (parameter);
    throw qt_gsi::AbstractMethodCalledException("actualValue");
  }

  virtual QVariant actualValue(QCameraExposureControl::ExposureParameter parameter) const
  {
    if (cb_actualValue_c4602_0.can_issue()) {
      return cb_actualValue_c4602_0.issue<QCameraExposureControl_Adaptor, QVariant, const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type &>(&QCameraExposureControl_Adaptor::cbs_actualValue_c4602_0, qt_gsi::CppToQtAdaptor<QCameraExposureControl::ExposureParameter>(parameter));
    } else {
      throw qt_gsi::AbstractMethodCalledException("actualValue");
    }
  }

  //  [emitter impl] void QCameraExposureControl::actualValueChanged(int parameter)
  void emitter_QCameraExposureControl_actualValueChanged_767(int parameter)
  {
    emit QCameraExposureControl::actualValueChanged(parameter);
  }

  //  [emitter impl] void QCameraExposureControl::destroyed(QObject *)
  void emitter_QCameraExposureControl_destroyed_1302(QObject *arg1)
  {
    emit QCameraExposureControl::destroyed(arg1);
  }

  //  [adaptor impl] bool QCameraExposureControl::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCameraExposureControl::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCameraExposureControl_Adaptor, bool, QEvent *>(&QCameraExposureControl_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCameraExposureControl::event(arg1);
    }
  }

  //  [adaptor impl] bool QCameraExposureControl::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCameraExposureControl::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCameraExposureControl_Adaptor, bool, QObject *, QEvent *>(&QCameraExposureControl_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QCameraExposureControl::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QCameraExposureControl::isParameterSupported(QCameraExposureControl::ExposureParameter parameter)
  bool cbs_isParameterSupported_c4602_0(const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & parameter) const
  {
    __SUPPRESS_UNUSED_WARNING (parameter);
    throw qt_gsi::AbstractMethodCalledException("isParameterSupported");
  }

  virtual bool isParameterSupported(QCameraExposureControl::ExposureParameter parameter) const
  {
    if (cb_isParameterSupported_c4602_0.can_issue()) {
      return cb_isParameterSupported_c4602_0.issue<QCameraExposureControl_Adaptor, bool, const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type &>(&QCameraExposureControl_Adaptor::cbs_isParameterSupported_c4602_0, qt_gsi::CppToQtAdaptor<QCameraExposureControl::ExposureParameter>(parameter));
    } else {
      throw qt_gsi::AbstractMethodCalledException("isParameterSupported");
    }
  }

  //  [emitter impl] void QCameraExposureControl::parameterRangeChanged(int parameter)
  void emitter_QCameraExposureControl_parameterRangeChanged_767(int parameter)
  {
    emit QCameraExposureControl::parameterRangeChanged(parameter);
  }

  //  [adaptor impl] QVariant QCameraExposureControl::requestedValue(QCameraExposureControl::ExposureParameter parameter)
  QVariant cbs_requestedValue_c4602_0(const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & parameter) const
  {
    __SUPPRESS_UNUSED_WARNING (parameter);
    throw qt_gsi::AbstractMethodCalledException("requestedValue");
  }

  virtual QVariant requestedValue(QCameraExposureControl::ExposureParameter parameter) const
  {
    if (cb_requestedValue_c4602_0.can_issue()) {
      return cb_requestedValue_c4602_0.issue<QCameraExposureControl_Adaptor, QVariant, const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type &>(&QCameraExposureControl_Adaptor::cbs_requestedValue_c4602_0, qt_gsi::CppToQtAdaptor<QCameraExposureControl::ExposureParameter>(parameter));
    } else {
      throw qt_gsi::AbstractMethodCalledException("requestedValue");
    }
  }

  //  [emitter impl] void QCameraExposureControl::requestedValueChanged(int parameter)
  void emitter_QCameraExposureControl_requestedValueChanged_767(int parameter)
  {
    emit QCameraExposureControl::requestedValueChanged(parameter);
  }

  //  [adaptor impl] bool QCameraExposureControl::setValue(QCameraExposureControl::ExposureParameter parameter, const QVariant &value)
  bool cbs_setValue_6613_0(const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & parameter, const QVariant &value)
  {
    __SUPPRESS_UNUSED_WARNING (parameter);
    __SUPPRESS_UNUSED_WARNING (value);
    throw qt_gsi::AbstractMethodCalledException("setValue");
  }

  virtual bool setValue(QCameraExposureControl::ExposureParameter parameter, const QVariant &value)
  {
    if (cb_setValue_6613_0.can_issue()) {
      return cb_setValue_6613_0.issue<QCameraExposureControl_Adaptor, bool, const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type &, const QVariant &>(&QCameraExposureControl_Adaptor::cbs_setValue_6613_0, qt_gsi::CppToQtAdaptor<QCameraExposureControl::ExposureParameter>(parameter), value);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setValue");
    }
  }

  //  [adaptor impl] QList<QVariant> QCameraExposureControl::supportedParameterRange(QCameraExposureControl::ExposureParameter parameter, bool *continuous)
  QList<QVariant> cbs_supportedParameterRange_c5544_0(const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & parameter, bool *continuous) const
  {
    __SUPPRESS_UNUSED_WARNING (parameter);
    __SUPPRESS_UNUSED_WARNING (continuous);
    throw qt_gsi::AbstractMethodCalledException("supportedParameterRange");
  }

  virtual QList<QVariant> supportedParameterRange(QCameraExposureControl::ExposureParameter parameter, bool *continuous) const
  {
    if (cb_supportedParameterRange_c5544_0.can_issue()) {
      return cb_supportedParameterRange_c5544_0.issue<QCameraExposureControl_Adaptor, QList<QVariant>, const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type &, bool *>(&QCameraExposureControl_Adaptor::cbs_supportedParameterRange_c5544_0, qt_gsi::CppToQtAdaptor<QCameraExposureControl::ExposureParameter>(parameter), continuous);
    } else {
      throw qt_gsi::AbstractMethodCalledException("supportedParameterRange");
    }
  }

  //  [adaptor impl] void QCameraExposureControl::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCameraExposureControl::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCameraExposureControl_Adaptor, QChildEvent *>(&QCameraExposureControl_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCameraExposureControl::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraExposureControl::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCameraExposureControl::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCameraExposureControl_Adaptor, QEvent *>(&QCameraExposureControl_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCameraExposureControl::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraExposureControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCameraExposureControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCameraExposureControl_Adaptor, const QMetaMethod &>(&QCameraExposureControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCameraExposureControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCameraExposureControl::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCameraExposureControl::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCameraExposureControl_Adaptor, QTimerEvent *>(&QCameraExposureControl_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCameraExposureControl::timerEvent(arg1);
    }
  }

  gsi::Callback cb_actualValue_c4602_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isParameterSupported_c4602_0;
  gsi::Callback cb_requestedValue_c4602_0;
  gsi::Callback cb_setValue_6613_0;
  gsi::Callback cb_supportedParameterRange_c5544_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCameraExposureControl_Adaptor::~QCameraExposureControl_Adaptor() { }

// QVariant QCameraExposureControl::actualValue(QCameraExposureControl::ExposureParameter parameter)

static void _init_cbs_actualValue_c4602_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_actualValue_c4602_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QCameraExposureControl_Adaptor *)cls)->cbs_actualValue_c4602_0 (arg1));
}

static void _set_callback_cbs_actualValue_c4602_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraExposureControl_Adaptor *)cls)->cb_actualValue_c4602_0 = cb;
}


// emitter void QCameraExposureControl::actualValueChanged(int parameter)

static void _init_emitter_actualValueChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_actualValueChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ((QCameraExposureControl_Adaptor *)cls)->emitter_QCameraExposureControl_actualValueChanged_767 (arg1);
}


// void QCameraExposureControl::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposureControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraExposureControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCameraExposureControl::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposureControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraExposureControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QCameraExposureControl::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ((QCameraExposureControl_Adaptor *)cls)->emitter_QCameraExposureControl_destroyed_1302 (arg1);
}


// void QCameraExposureControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposureControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraExposureControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QCameraExposureControl::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraExposureControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraExposureControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCameraExposureControl::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraExposureControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraExposureControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QCameraExposureControl::isParameterSupported(QCameraExposureControl::ExposureParameter parameter)

static void _init_cbs_isParameterSupported_c4602_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isParameterSupported_c4602_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (heap);
  ret.write<bool > ((bool)((QCameraExposureControl_Adaptor *)cls)->cbs_isParameterSupported_c4602_0 (arg1));
}

static void _set_callback_cbs_isParameterSupported_c4602_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraExposureControl_Adaptor *)cls)->cb_isParameterSupported_c4602_0 = cb;
}


// exposed bool QCameraExposureControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  ret.write<bool > ((bool)((QCameraExposureControl_Adaptor *)cls)->fp_QCameraExposureControl_isSignalConnected_c2394 (arg1));
}


// emitter void QCameraExposureControl::parameterRangeChanged(int parameter)

static void _init_emitter_parameterRangeChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_parameterRangeChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ((QCameraExposureControl_Adaptor *)cls)->emitter_QCameraExposureControl_parameterRangeChanged_767 (arg1);
}


// exposed int QCameraExposureControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<int > ((int)((QCameraExposureControl_Adaptor *)cls)->fp_QCameraExposureControl_receivers_c1731 (arg1));
}


// QVariant QCameraExposureControl::requestedValue(QCameraExposureControl::ExposureParameter parameter)

static void _init_cbs_requestedValue_c4602_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_requestedValue_c4602_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QCameraExposureControl_Adaptor *)cls)->cbs_requestedValue_c4602_0 (arg1));
}

static void _set_callback_cbs_requestedValue_c4602_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraExposureControl_Adaptor *)cls)->cb_requestedValue_c4602_0 = cb;
}


// emitter void QCameraExposureControl::requestedValueChanged(int parameter)

static void _init_emitter_requestedValueChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_requestedValueChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ((QCameraExposureControl_Adaptor *)cls)->emitter_QCameraExposureControl_requestedValueChanged_767 (arg1);
}


// exposed QObject *QCameraExposureControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCameraExposureControl_Adaptor *)cls)->fp_QCameraExposureControl_sender_c0 ());
}


// exposed int QCameraExposureControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraExposureControl_Adaptor *)cls)->fp_QCameraExposureControl_senderSignalIndex_c0 ());
}


// bool QCameraExposureControl::setValue(QCameraExposureControl::ExposureParameter parameter, const QVariant &value)

static void _init_cbs_setValue_6613_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_setValue_6613_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  ret.write<bool > ((bool)((QCameraExposureControl_Adaptor *)cls)->cbs_setValue_6613_0 (arg1, arg2));
}

static void _set_callback_cbs_setValue_6613_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraExposureControl_Adaptor *)cls)->cb_setValue_6613_0 = cb;
}


// QList<QVariant> QCameraExposureControl::supportedParameterRange(QCameraExposureControl::ExposureParameter parameter, bool *continuous)

static void _init_cbs_supportedParameterRange_c5544_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parameter");
  decl->add_arg<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("continuous");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<QList<QVariant> > ();
}

static void _call_cbs_supportedParameterRange_c5544_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraExposureControl::ExposureParameter>::target_type & > (heap);
  bool *arg2 = args.read<bool * > (heap);
  ret.write<QList<QVariant> > ((QList<QVariant>)((QCameraExposureControl_Adaptor *)cls)->cbs_supportedParameterRange_c5544_0 (arg1, arg2));
}

static void _set_callback_cbs_supportedParameterRange_c5544_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraExposureControl_Adaptor *)cls)->cb_supportedParameterRange_c5544_0 = cb;
}


// void QCameraExposureControl::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraExposureControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraExposureControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QCameraExposureControl> &qtdecl_QCameraExposureControl ();

static gsi::Methods methods_QCameraExposureControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("actualValue", "@hide", true, &_init_cbs_actualValue_c4602_0, &_call_cbs_actualValue_c4602_0);
  methods += new qt_gsi::GenericMethod ("actualValue", "@brief Virtual method QVariant QCameraExposureControl::actualValue(QCameraExposureControl::ExposureParameter parameter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_actualValue_c4602_0, &_call_cbs_actualValue_c4602_0, &_set_callback_cbs_actualValue_c4602_0);
  methods += new qt_gsi::GenericMethod ("emit_actualValueChanged", "@brief Emitter for signal void QCameraExposureControl::actualValueChanged(int parameter)\nCall this method to emit this signal.", false, &_init_emitter_actualValueChanged_767, &_call_emitter_actualValueChanged_767);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCameraExposureControl::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCameraExposureControl::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QCameraExposureControl::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCameraExposureControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCameraExposureControl::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCameraExposureControl::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isParameterSupported", "@hide", true, &_init_cbs_isParameterSupported_c4602_0, &_call_cbs_isParameterSupported_c4602_0);
  methods += new qt_gsi::GenericMethod ("isParameterSupported", "@brief Virtual method bool QCameraExposureControl::isParameterSupported(QCameraExposureControl::ExposureParameter parameter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isParameterSupported_c4602_0, &_call_cbs_isParameterSupported_c4602_0, &_set_callback_cbs_isParameterSupported_c4602_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCameraExposureControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_parameterRangeChanged", "@brief Emitter for signal void QCameraExposureControl::parameterRangeChanged(int parameter)\nCall this method to emit this signal.", false, &_init_emitter_parameterRangeChanged_767, &_call_emitter_parameterRangeChanged_767);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCameraExposureControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("requestedValue", "@hide", true, &_init_cbs_requestedValue_c4602_0, &_call_cbs_requestedValue_c4602_0);
  methods += new qt_gsi::GenericMethod ("requestedValue", "@brief Virtual method QVariant QCameraExposureControl::requestedValue(QCameraExposureControl::ExposureParameter parameter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_requestedValue_c4602_0, &_call_cbs_requestedValue_c4602_0, &_set_callback_cbs_requestedValue_c4602_0);
  methods += new qt_gsi::GenericMethod ("emit_requestedValueChanged", "@brief Emitter for signal void QCameraExposureControl::requestedValueChanged(int parameter)\nCall this method to emit this signal.", false, &_init_emitter_requestedValueChanged_767, &_call_emitter_requestedValueChanged_767);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCameraExposureControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCameraExposureControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setValue", "@hide", false, &_init_cbs_setValue_6613_0, &_call_cbs_setValue_6613_0);
  methods += new qt_gsi::GenericMethod ("setValue", "@brief Virtual method bool QCameraExposureControl::setValue(QCameraExposureControl::ExposureParameter parameter, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setValue_6613_0, &_call_cbs_setValue_6613_0, &_set_callback_cbs_setValue_6613_0);
  methods += new qt_gsi::GenericMethod ("supportedParameterRange", "@hide", true, &_init_cbs_supportedParameterRange_c5544_0, &_call_cbs_supportedParameterRange_c5544_0);
  methods += new qt_gsi::GenericMethod ("supportedParameterRange", "@brief Virtual method QList<QVariant> QCameraExposureControl::supportedParameterRange(QCameraExposureControl::ExposureParameter parameter, bool *continuous)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedParameterRange_c5544_0, &_call_cbs_supportedParameterRange_c5544_0, &_set_callback_cbs_supportedParameterRange_c5544_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCameraExposureControl::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QCameraExposureControl_Adaptor> decl_QCameraExposureControl_Adaptor (qtdecl_QCameraExposureControl (), "QCameraExposureControl",
  methods_QCameraExposureControl_Adaptor (),
  "@qt\n@brief Binding of QCameraExposureControl");

}


//  Implementation of the enum wrapper class for QCameraExposureControl::ExposureParameter
namespace qt_gsi
{

static gsi::Enum<QCameraExposureControl::ExposureParameter> decl_QCameraExposureControl_ExposureParameter_Enum ("QCameraExposureControl_ExposureParameter",
    gsi::enum_const ("ISO", QCameraExposureControl::ISO, "@brief Enum constant QCameraExposureControl::ISO") +
    gsi::enum_const ("Aperture", QCameraExposureControl::Aperture, "@brief Enum constant QCameraExposureControl::Aperture") +
    gsi::enum_const ("ShutterSpeed", QCameraExposureControl::ShutterSpeed, "@brief Enum constant QCameraExposureControl::ShutterSpeed") +
    gsi::enum_const ("ExposureCompensation", QCameraExposureControl::ExposureCompensation, "@brief Enum constant QCameraExposureControl::ExposureCompensation") +
    gsi::enum_const ("FlashPower", QCameraExposureControl::FlashPower, "@brief Enum constant QCameraExposureControl::FlashPower") +
    gsi::enum_const ("FlashCompensation", QCameraExposureControl::FlashCompensation, "@brief Enum constant QCameraExposureControl::FlashCompensation") +
    gsi::enum_const ("TorchPower", QCameraExposureControl::TorchPower, "@brief Enum constant QCameraExposureControl::TorchPower") +
    gsi::enum_const ("SpotMeteringPoint", QCameraExposureControl::SpotMeteringPoint, "@brief Enum constant QCameraExposureControl::SpotMeteringPoint") +
    gsi::enum_const ("ExposureMode", QCameraExposureControl::ExposureMode, "@brief Enum constant QCameraExposureControl::ExposureMode") +
    gsi::enum_const ("MeteringMode", QCameraExposureControl::MeteringMode, "@brief Enum constant QCameraExposureControl::MeteringMode") +
    gsi::enum_const ("ExtendedExposureParameter", QCameraExposureControl::ExtendedExposureParameter, "@brief Enum constant QCameraExposureControl::ExtendedExposureParameter"),
  "@qt\n@brief This class represents the QCameraExposureControl::ExposureParameter enum");

static gsi::QFlagsClass<QCameraExposureControl::ExposureParameter > decl_QCameraExposureControl_ExposureParameter_Enums ("QCameraExposureControl_QFlags_ExposureParameter",
  "@qt\n@brief This class represents the QFlags<QCameraExposureControl::ExposureParameter> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraExposureControl> inject_QCameraExposureControl_ExposureParameter_Enum_in_parent (decl_QCameraExposureControl_ExposureParameter_Enum.defs ());
static gsi::ClassExt<QCameraExposureControl> decl_QCameraExposureControl_ExposureParameter_Enum_as_child (decl_QCameraExposureControl_ExposureParameter_Enum, "ExposureParameter");
static gsi::ClassExt<QCameraExposureControl> decl_QCameraExposureControl_ExposureParameter_Enums_as_child (decl_QCameraExposureControl_ExposureParameter_Enums, "QFlags_ExposureParameter");

}

