
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQColumnView.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QColumnView>
#include <QAbstractItemDelegate>
#include <QAbstractItemModel>
#include <QAbstractItemView>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QItemSelection>
#include <QItemSelectionModel>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QModelIndex>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScrollBar>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionFrame>
#include <QStyleOptionViewItem>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QColumnView

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QColumnView::staticMetaObject);
}


// QList<int> QColumnView::columnWidths()


static void _init_f_columnWidths_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_f_columnWidths_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QColumnView *)cls)->columnWidths ());
}


// (const QPoint &) const


static void _init_f_indexAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_f_indexAt_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QColumnView *)cls)->indexAt (arg1));
}


// QWidget *QColumnView::previewWidget()


static void _init_f_previewWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_previewWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QColumnView *)cls)->previewWidget ());
}


// bool QColumnView::resizeGripsVisible()


static void _init_f_resizeGripsVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_resizeGripsVisible_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QColumnView *)cls)->resizeGripsVisible ());
}


// (const QModelIndex &, QAbstractItemView::ScrollHint)


static void _init_f_scrollTo_5576 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemView::EnsureVisible");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scrollTo_5576 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (heap) : (const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type &)(qt_gsi::CppToQtReadAdaptor<QAbstractItemView::ScrollHint>(heap, QAbstractItemView::EnsureVisible));
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView *)cls)->scrollTo (arg1, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(arg2).cref());
}


// ()


static void _init_f_selectAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_selectAll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView *)cls)->selectAll ();
}


// void QColumnView::setColumnWidths(const QList<int> &list)


static void _init_f_setColumnWidths_2259 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("list");
  decl->add_arg<const QList<int> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColumnWidths_2259 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<int> &arg1 = args.read<const QList<int> & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView *)cls)->setColumnWidths (arg1);
}


// (QAbstractItemModel *)


static void _init_f_setModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModel_2419 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView *)cls)->setModel (arg1);
}


// void QColumnView::setPreviewWidget(QWidget *widget)


static void _init_f_setPreviewWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPreviewWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView *)cls)->setPreviewWidget (arg1);
}


// void QColumnView::setResizeGripsVisible(bool visible)


static void _init_f_setResizeGripsVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setResizeGripsVisible_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView *)cls)->setResizeGripsVisible (arg1);
}


// (const QModelIndex &)


static void _init_f_setRootIndex_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRootIndex_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView *)cls)->setRootIndex (arg1);
}


// (QItemSelectionModel *)


static void _init_f_setSelectionModel_2533 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionModel");
  decl->add_arg<QItemSelectionModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelectionModel_2533 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QItemSelectionModel *arg1 = args.read<QItemSelectionModel * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView *)cls)->setSelectionModel (arg1);
}


// () const


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QColumnView *)cls)->sizeHint ());
}


// (const QModelIndex &) const


static void _init_f_visualRect_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_visualRect_c2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QRect > ((QRect)((QColumnView *)cls)->visualRect (arg1));
}


// static QString QColumnView::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(__null);
  int arg3 = args ? args.read<int > (heap) : (int)(-1);
  ret.write<QString > ((QString)QColumnView::tr (arg1, arg2, arg3));
}


// static QString QColumnView::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(__null);
  int arg3 = args ? args.read<int > (heap) : (int)(-1);
  ret.write<QString > ((QString)QColumnView::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QColumnView () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":columnWidths", "@brief Method QList<int> QColumnView::columnWidths()\n", true, &_init_f_columnWidths_c0, &_call_f_columnWidths_c0);
  methods += new qt_gsi::GenericMethod ("indexAt", "@brief Method (const QPoint &) const\nThis is a reimplementation of QAbstractItemView::indexAt", true, &_init_f_indexAt_c1916, &_call_f_indexAt_c1916);
  methods += new qt_gsi::GenericMethod (":previewWidget", "@brief Method QWidget *QColumnView::previewWidget()\n", true, &_init_f_previewWidget_c0, &_call_f_previewWidget_c0);
  methods += new qt_gsi::GenericMethod (":resizeGripsVisible", "@brief Method bool QColumnView::resizeGripsVisible()\n", true, &_init_f_resizeGripsVisible_c0, &_call_f_resizeGripsVisible_c0);
  methods += new qt_gsi::GenericMethod ("scrollTo", "@brief Method (const QModelIndex &, QAbstractItemView::ScrollHint)\nThis is a reimplementation of QAbstractItemView::scrollTo", false, &_init_f_scrollTo_5576, &_call_f_scrollTo_5576);
  methods += new qt_gsi::GenericMethod ("selectAll", "@brief Method ()\nThis is a reimplementation of QAbstractItemView::selectAll", false, &_init_f_selectAll_0, &_call_f_selectAll_0);
  methods += new qt_gsi::GenericMethod ("setColumnWidths|columnWidths=", "@brief Method void QColumnView::setColumnWidths(const QList<int> &list)\n", false, &_init_f_setColumnWidths_2259, &_call_f_setColumnWidths_2259);
  methods += new qt_gsi::GenericMethod ("setModel|model=", "@brief Method (QAbstractItemModel *)\nThis is a reimplementation of QAbstractItemView::setModel", false, &_init_f_setModel_2419, &_call_f_setModel_2419);
  methods += new qt_gsi::GenericMethod ("setPreviewWidget|previewWidget=", "@brief Method void QColumnView::setPreviewWidget(QWidget *widget)\n", false, &_init_f_setPreviewWidget_1315, &_call_f_setPreviewWidget_1315);
  methods += new qt_gsi::GenericMethod ("setResizeGripsVisible|resizeGripsVisible=", "@brief Method void QColumnView::setResizeGripsVisible(bool visible)\n", false, &_init_f_setResizeGripsVisible_864, &_call_f_setResizeGripsVisible_864);
  methods += new qt_gsi::GenericMethod ("setRootIndex|rootIndex=", "@brief Method (const QModelIndex &)\nThis is a reimplementation of QAbstractItemView::setRootIndex", false, &_init_f_setRootIndex_2395, &_call_f_setRootIndex_2395);
  methods += new qt_gsi::GenericMethod ("setSelectionModel|selectionModel=", "@brief Method (QItemSelectionModel *)\nThis is a reimplementation of QAbstractItemView::setSelectionModel", false, &_init_f_setSelectionModel_2533, &_call_f_setSelectionModel_2533);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method () const\nThis is a reimplementation of QAbstractScrollArea::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod ("visualRect", "@brief Method (const QModelIndex &) const\nThis is a reimplementation of QAbstractItemView::visualRect", true, &_init_f_visualRect_c2395, &_call_f_visualRect_c2395);
  methods += gsi::qt_signal<const QModelIndex & > ("activated(const QModelIndex &)", "activated", gsi::arg("index"), "@brief Signal declaration for QColumnView::activated(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("clicked(const QModelIndex &)", "clicked", gsi::arg("index"), "@brief Signal declaration for QColumnView::clicked(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QColumnView::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QColumnView::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("doubleClicked(const QModelIndex &)", "doubleClicked", gsi::arg("index"), "@brief Signal declaration for QColumnView::doubleClicked(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("entered(const QModelIndex &)", "entered", gsi::arg("index"), "@brief Signal declaration for QColumnView::entered(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QSize & > ("iconSizeChanged(const QSize &)", "iconSizeChanged", gsi::arg("size"), "@brief Signal declaration for QColumnView::iconSizeChanged(const QSize &size)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("pressed(const QModelIndex &)", "pressed", gsi::arg("index"), "@brief Signal declaration for QColumnView::pressed(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("updatePreviewWidget(const QModelIndex &)", "updatePreviewWidget", gsi::arg("index"), "@brief Signal declaration for QColumnView::updatePreviewWidget(const QModelIndex &index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("viewportEntered()", "viewportEntered", "@brief Signal declaration for QColumnView::viewportEntered()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QColumnView::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QColumnView::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QColumnView::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QColumnView::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QColumnView::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QAbstractItemView> &qtdecl_QAbstractItemView ();

qt_gsi::QtNativeClass<QColumnView> decl_QColumnView (qtdecl_QAbstractItemView (), "QColumnView_Native",
  methods_QColumnView (),
  "@hide\n@alias QColumnView");

GSIQT_PUBLIC gsi::Class<QColumnView> &qtdecl_QColumnView () { return decl_QColumnView; }

}


class QColumnView_Adaptor : public QColumnView, public qt_gsi::QtObjectBase
{
public:

  virtual ~QColumnView_Adaptor();

  //  [adaptor ctor] QColumnView::QColumnView(QWidget *parent)
  QColumnView_Adaptor() : QColumnView()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QColumnView::QColumnView(QWidget *parent)
  QColumnView_Adaptor(QWidget *parent) : QColumnView(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QColumnView::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QColumnView_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QColumnView::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QColumnView::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QColumnView_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QColumnView::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] QPoint QColumnView::dirtyRegionOffset()
  QPoint fp_QColumnView_dirtyRegionOffset_c0 () const {
    return QColumnView::dirtyRegionOffset();
  }

  //  [expose] void QColumnView::doAutoScroll()
  void fp_QColumnView_doAutoScroll_0 () {
    QColumnView::doAutoScroll();
  }

  //  [expose] void QColumnView::drawFrame(QPainter *)
  void fp_QColumnView_drawFrame_1426 (QPainter *arg1) {
    QColumnView::drawFrame(arg1);
  }

  //  [expose] QAbstractItemView::DropIndicatorPosition QColumnView::dropIndicatorPosition()
  unsigned int fp_QColumnView_dropIndicatorPosition_c0 () const {
    return (unsigned int)(QColumnView::dropIndicatorPosition());
  }

  //  [expose] void QColumnView::executeDelayedItemsLayout()
  void fp_QColumnView_executeDelayedItemsLayout_0 () {
    QColumnView::executeDelayedItemsLayout();
  }

  //  [expose] bool QColumnView::focusNextChild()
  bool fp_QColumnView_focusNextChild_0 () {
    return QColumnView::focusNextChild();
  }

  //  [expose] bool QColumnView::focusPreviousChild()
  bool fp_QColumnView_focusPreviousChild_0 () {
    return QColumnView::focusPreviousChild();
  }

  //  [expose] int QColumnView::horizontalStepsPerItem()
  int fp_QColumnView_horizontalStepsPerItem_c0 () const {
    return QColumnView::horizontalStepsPerItem();
  }

  //  [expose] void QColumnView::initStyleOption(QStyleOptionFrame *option)
  void fp_QColumnView_initStyleOption_c2356 (QStyleOptionFrame *option) const {
    QColumnView::initStyleOption(option);
  }

  //  [expose] void QColumnView::initializeColumn(QAbstractItemView *column)
  void fp_QColumnView_initializeColumn_c2333 (QAbstractItemView *column) const {
    QColumnView::initializeColumn(column);
  }

  //  [expose] bool QColumnView::isSignalConnected(const QMetaMethod &signal)
  bool fp_QColumnView_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QColumnView::isSignalConnected(signal);
  }

  //  [expose] int QColumnView::receivers(const char *signal)
  int fp_QColumnView_receivers_c1731 (const char *signal) const {
    return QColumnView::receivers(signal);
  }

  //  [expose] void QColumnView::scheduleDelayedItemsLayout()
  void fp_QColumnView_scheduleDelayedItemsLayout_0 () {
    QColumnView::scheduleDelayedItemsLayout();
  }

  //  [expose] void QColumnView::scrollDirtyRegion(int dx, int dy)
  void fp_QColumnView_scrollDirtyRegion_1426 (int dx, int dy) {
    QColumnView::scrollDirtyRegion(dx, dy);
  }

  //  [expose] QObject *QColumnView::sender()
  QObject * fp_QColumnView_sender_c0 () const {
    return QColumnView::sender();
  }

  //  [expose] int QColumnView::senderSignalIndex()
  int fp_QColumnView_senderSignalIndex_c0 () const {
    return QColumnView::senderSignalIndex();
  }

  //  [expose] void QColumnView::setDirtyRegion(const QRegion &region)
  void fp_QColumnView_setDirtyRegion_2006 (const QRegion &region) {
    QColumnView::setDirtyRegion(region);
  }

  //  [expose] void QColumnView::setHorizontalStepsPerItem(int steps)
  void fp_QColumnView_setHorizontalStepsPerItem_767 (int steps) {
    QColumnView::setHorizontalStepsPerItem(steps);
  }

  //  [expose] void QColumnView::setState(QAbstractItemView::State state)
  void fp_QColumnView_setState_2776 (unsigned int state) {
    QColumnView::setState(QAbstractItemView::State(state));
  }

  //  [expose] void QColumnView::setVerticalStepsPerItem(int steps)
  void fp_QColumnView_setVerticalStepsPerItem_767 (int steps) {
    QColumnView::setVerticalStepsPerItem(steps);
  }

  //  [expose] void QColumnView::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QColumnView_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QColumnView::setViewportMargins(left, top, right, bottom);
  }

  //  [expose] void QColumnView::setViewportMargins(const QMargins &margins)
  void fp_QColumnView_setViewportMargins_2115 (const QMargins &margins) {
    QColumnView::setViewportMargins(margins);
  }

  //  [expose] void QColumnView::startAutoScroll()
  void fp_QColumnView_startAutoScroll_0 () {
    QColumnView::startAutoScroll();
  }

  //  [expose] QAbstractItemView::State QColumnView::state()
  unsigned int fp_QColumnView_state_c0 () const {
    return (unsigned int)(QColumnView::state());
  }

  //  [expose] void QColumnView::stopAutoScroll()
  void fp_QColumnView_stopAutoScroll_0 () {
    QColumnView::stopAutoScroll();
  }

  //  [expose] void QColumnView::updateMicroFocus()
  void fp_QColumnView_updateMicroFocus_0 () {
    QColumnView::updateMicroFocus();
  }

  //  [expose] int QColumnView::verticalStepsPerItem()
  int fp_QColumnView_verticalStepsPerItem_c0 () const {
    return QColumnView::verticalStepsPerItem();
  }

  //  [expose] QMargins QColumnView::viewportMargins()
  QMargins fp_QColumnView_viewportMargins_c0 () const {
    return QColumnView::viewportMargins();
  }

  //  [emitter impl] void QColumnView::activated(const QModelIndex &index)
  void emitter_QColumnView_activated_2395(const QModelIndex &index)
  {
    emit QColumnView::activated(index);
  }

  //  [emitter impl] void QColumnView::clicked(const QModelIndex &index)
  void emitter_QColumnView_clicked_2395(const QModelIndex &index)
  {
    emit QColumnView::clicked(index);
  }

  //  [emitter impl] void QColumnView::customContextMenuRequested(const QPoint &pos)
  void emitter_QColumnView_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QColumnView::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QColumnView::destroyed(QObject *)
  void emitter_QColumnView_destroyed_1302(QObject *arg1)
  {
    emit QColumnView::destroyed(arg1);
  }

  //  [adaptor impl] void QColumnView::doItemsLayout()
  void cbs_doItemsLayout_0_0()
  {
    QColumnView::doItemsLayout();
  }

  virtual void doItemsLayout()
  {
    if (cb_doItemsLayout_0_0.can_issue()) {
      cb_doItemsLayout_0_0.issue<QColumnView_Adaptor>(&QColumnView_Adaptor::cbs_doItemsLayout_0_0);
    } else {
      QColumnView::doItemsLayout();
    }
  }

  //  [emitter impl] void QColumnView::doubleClicked(const QModelIndex &index)
  void emitter_QColumnView_doubleClicked_2395(const QModelIndex &index)
  {
    emit QColumnView::doubleClicked(index);
  }

  //  [emitter impl] void QColumnView::entered(const QModelIndex &index)
  void emitter_QColumnView_entered_2395(const QModelIndex &index)
  {
    emit QColumnView::entered(index);
  }

  //  [adaptor impl] bool QColumnView::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QColumnView::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QColumnView_Adaptor, bool>(&QColumnView_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QColumnView::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QColumnView::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QColumnView::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QColumnView_Adaptor, int, int>(&QColumnView_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QColumnView::heightForWidth(arg1);
    }
  }

  //  [emitter impl] void QColumnView::iconSizeChanged(const QSize &size)
  void emitter_QColumnView_iconSizeChanged_1805(const QSize &size)
  {
    emit QColumnView::iconSizeChanged(size);
  }

  //  [adaptor impl] QModelIndex QColumnView::indexAt(const QPoint &point)
  QModelIndex cbs_indexAt_c1916_0(const QPoint &point) const
  {
    return QColumnView::indexAt(point);
  }

  virtual QModelIndex indexAt(const QPoint &point) const
  {
    if (cb_indexAt_c1916_0.can_issue()) {
      return cb_indexAt_c1916_0.issue<QColumnView_Adaptor, QModelIndex, const QPoint &>(&QColumnView_Adaptor::cbs_indexAt_c1916_0, point);
    } else {
      return QColumnView::indexAt(point);
    }
  }

  //  [adaptor impl] QVariant QColumnView::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QColumnView::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QColumnView_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QColumnView_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QColumnView::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] void QColumnView::keyboardSearch(const QString &search)
  void cbs_keyboardSearch_2025_0(const QString &search)
  {
    QColumnView::keyboardSearch(search);
  }

  virtual void keyboardSearch(const QString &search)
  {
    if (cb_keyboardSearch_2025_0.can_issue()) {
      cb_keyboardSearch_2025_0.issue<QColumnView_Adaptor, const QString &>(&QColumnView_Adaptor::cbs_keyboardSearch_2025_0, search);
    } else {
      QColumnView::keyboardSearch(search);
    }
  }

  //  [adaptor impl] QSize QColumnView::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QColumnView::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QColumnView_Adaptor, QSize>(&QColumnView_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QColumnView::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QColumnView::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QColumnView::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QColumnView_Adaptor, QPaintEngine *>(&QColumnView_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QColumnView::paintEngine();
    }
  }

  //  [emitter impl] void QColumnView::pressed(const QModelIndex &index)
  void emitter_QColumnView_pressed_2395(const QModelIndex &index)
  {
    emit QColumnView::pressed(index);
  }

  //  [adaptor impl] void QColumnView::reset()
  void cbs_reset_0_0()
  {
    QColumnView::reset();
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QColumnView_Adaptor>(&QColumnView_Adaptor::cbs_reset_0_0);
    } else {
      QColumnView::reset();
    }
  }

  //  [adaptor impl] void QColumnView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  void cbs_scrollTo_5576_1(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & hint)
  {
    QColumnView::scrollTo(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(hint).cref());
  }

  virtual void scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  {
    if (cb_scrollTo_5576_1.can_issue()) {
      cb_scrollTo_5576_1.issue<QColumnView_Adaptor, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type &>(&QColumnView_Adaptor::cbs_scrollTo_5576_1, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::ScrollHint>(hint));
    } else {
      QColumnView::scrollTo(index, hint);
    }
  }

  //  [adaptor impl] void QColumnView::selectAll()
  void cbs_selectAll_0_0()
  {
    QColumnView::selectAll();
  }

  virtual void selectAll()
  {
    if (cb_selectAll_0_0.can_issue()) {
      cb_selectAll_0_0.issue<QColumnView_Adaptor>(&QColumnView_Adaptor::cbs_selectAll_0_0);
    } else {
      QColumnView::selectAll();
    }
  }

  //  [adaptor impl] void QColumnView::setModel(QAbstractItemModel *model)
  void cbs_setModel_2419_0(QAbstractItemModel *model)
  {
    QColumnView::setModel(model);
  }

  virtual void setModel(QAbstractItemModel *model)
  {
    if (cb_setModel_2419_0.can_issue()) {
      cb_setModel_2419_0.issue<QColumnView_Adaptor, QAbstractItemModel *>(&QColumnView_Adaptor::cbs_setModel_2419_0, model);
    } else {
      QColumnView::setModel(model);
    }
  }

  //  [adaptor impl] void QColumnView::setRootIndex(const QModelIndex &index)
  void cbs_setRootIndex_2395_0(const QModelIndex &index)
  {
    QColumnView::setRootIndex(index);
  }

  virtual void setRootIndex(const QModelIndex &index)
  {
    if (cb_setRootIndex_2395_0.can_issue()) {
      cb_setRootIndex_2395_0.issue<QColumnView_Adaptor, const QModelIndex &>(&QColumnView_Adaptor::cbs_setRootIndex_2395_0, index);
    } else {
      QColumnView::setRootIndex(index);
    }
  }

  //  [adaptor impl] void QColumnView::setSelectionModel(QItemSelectionModel *selectionModel)
  void cbs_setSelectionModel_2533_0(QItemSelectionModel *selectionModel)
  {
    QColumnView::setSelectionModel(selectionModel);
  }

  virtual void setSelectionModel(QItemSelectionModel *selectionModel)
  {
    if (cb_setSelectionModel_2533_0.can_issue()) {
      cb_setSelectionModel_2533_0.issue<QColumnView_Adaptor, QItemSelectionModel *>(&QColumnView_Adaptor::cbs_setSelectionModel_2533_0, selectionModel);
    } else {
      QColumnView::setSelectionModel(selectionModel);
    }
  }

  //  [adaptor impl] void QColumnView::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QColumnView::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QColumnView_Adaptor, bool>(&QColumnView_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QColumnView::setVisible(visible);
    }
  }

  //  [adaptor impl] void QColumnView::setupViewport(QWidget *viewport)
  void cbs_setupViewport_1315_0(QWidget *viewport)
  {
    QColumnView::setupViewport(viewport);
  }

  virtual void setupViewport(QWidget *viewport)
  {
    if (cb_setupViewport_1315_0.can_issue()) {
      cb_setupViewport_1315_0.issue<QColumnView_Adaptor, QWidget *>(&QColumnView_Adaptor::cbs_setupViewport_1315_0, viewport);
    } else {
      QColumnView::setupViewport(viewport);
    }
  }

  //  [adaptor impl] QSize QColumnView::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QColumnView::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QColumnView_Adaptor, QSize>(&QColumnView_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QColumnView::sizeHint();
    }
  }

  //  [adaptor impl] int QColumnView::sizeHintForColumn(int column)
  int cbs_sizeHintForColumn_c767_0(int column) const
  {
    return QColumnView::sizeHintForColumn(column);
  }

  virtual int sizeHintForColumn(int column) const
  {
    if (cb_sizeHintForColumn_c767_0.can_issue()) {
      return cb_sizeHintForColumn_c767_0.issue<QColumnView_Adaptor, int, int>(&QColumnView_Adaptor::cbs_sizeHintForColumn_c767_0, column);
    } else {
      return QColumnView::sizeHintForColumn(column);
    }
  }

  //  [adaptor impl] int QColumnView::sizeHintForRow(int row)
  int cbs_sizeHintForRow_c767_0(int row) const
  {
    return QColumnView::sizeHintForRow(row);
  }

  virtual int sizeHintForRow(int row) const
  {
    if (cb_sizeHintForRow_c767_0.can_issue()) {
      return cb_sizeHintForRow_c767_0.issue<QColumnView_Adaptor, int, int>(&QColumnView_Adaptor::cbs_sizeHintForRow_c767_0, row);
    } else {
      return QColumnView::sizeHintForRow(row);
    }
  }

  //  [emitter impl] void QColumnView::updatePreviewWidget(const QModelIndex &index)
  void emitter_QColumnView_updatePreviewWidget_2395(const QModelIndex &index)
  {
    emit QColumnView::updatePreviewWidget(index);
  }

  //  [emitter impl] void QColumnView::viewportEntered()
  void emitter_QColumnView_viewportEntered_0()
  {
    emit QColumnView::viewportEntered();
  }

  //  [adaptor impl] QRect QColumnView::visualRect(const QModelIndex &index)
  QRect cbs_visualRect_c2395_0(const QModelIndex &index) const
  {
    return QColumnView::visualRect(index);
  }

  virtual QRect visualRect(const QModelIndex &index) const
  {
    if (cb_visualRect_c2395_0.can_issue()) {
      return cb_visualRect_c2395_0.issue<QColumnView_Adaptor, QRect, const QModelIndex &>(&QColumnView_Adaptor::cbs_visualRect_c2395_0, index);
    } else {
      return QColumnView::visualRect(index);
    }
  }

  //  [emitter impl] void QColumnView::windowIconChanged(const QIcon &icon)
  void emitter_QColumnView_windowIconChanged_1787(const QIcon &icon)
  {
    emit QColumnView::windowIconChanged(icon);
  }

  //  [emitter impl] void QColumnView::windowIconTextChanged(const QString &iconText)
  void emitter_QColumnView_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QColumnView::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QColumnView::windowTitleChanged(const QString &title)
  void emitter_QColumnView_windowTitleChanged_2025(const QString &title)
  {
    emit QColumnView::windowTitleChanged(title);
  }

  //  [adaptor impl] void QColumnView::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QColumnView::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QColumnView_Adaptor, QActionEvent *>(&QColumnView_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QColumnView::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QColumnView::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QColumnView::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QColumnView_Adaptor, QEvent *>(&QColumnView_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QColumnView::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QColumnView::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QColumnView::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QColumnView_Adaptor, QChildEvent *>(&QColumnView_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QColumnView::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QColumnView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  void cbs_closeEditor_4926_0(QWidget *editor, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & hint)
  {
    QColumnView::closeEditor(editor, qt_gsi::QtToCppAdaptor<QAbstractItemDelegate::EndEditHint>(hint).cref());
  }

  virtual void closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  {
    if (cb_closeEditor_4926_0.can_issue()) {
      cb_closeEditor_4926_0.issue<QColumnView_Adaptor, QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type &>(&QColumnView_Adaptor::cbs_closeEditor_4926_0, editor, qt_gsi::CppToQtAdaptor<QAbstractItemDelegate::EndEditHint>(hint));
    } else {
      QColumnView::closeEditor(editor, hint);
    }
  }

  //  [adaptor impl] void QColumnView::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QColumnView::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QColumnView_Adaptor, QCloseEvent *>(&QColumnView_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QColumnView::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QColumnView::commitData(QWidget *editor)
  void cbs_commitData_1315_0(QWidget *editor)
  {
    QColumnView::commitData(editor);
  }

  virtual void commitData(QWidget *editor)
  {
    if (cb_commitData_1315_0.can_issue()) {
      cb_commitData_1315_0.issue<QColumnView_Adaptor, QWidget *>(&QColumnView_Adaptor::cbs_commitData_1315_0, editor);
    } else {
      QColumnView::commitData(editor);
    }
  }

  //  [adaptor impl] void QColumnView::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QColumnView::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QColumnView_Adaptor, QContextMenuEvent *>(&QColumnView_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QColumnView::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] QAbstractItemView *QColumnView::createColumn(const QModelIndex &rootIndex)
  QAbstractItemView * cbs_createColumn_2395_0(const QModelIndex &rootIndex)
  {
    return QColumnView::createColumn(rootIndex);
  }

  virtual QAbstractItemView * createColumn(const QModelIndex &rootIndex)
  {
    if (cb_createColumn_2395_0.can_issue()) {
      return cb_createColumn_2395_0.issue<QColumnView_Adaptor, QAbstractItemView *, const QModelIndex &>(&QColumnView_Adaptor::cbs_createColumn_2395_0, rootIndex);
    } else {
      return QColumnView::createColumn(rootIndex);
    }
  }

  //  [adaptor impl] void QColumnView::currentChanged(const QModelIndex &current, const QModelIndex &previous)
  void cbs_currentChanged_4682_0(const QModelIndex &current, const QModelIndex &previous)
  {
    QColumnView::currentChanged(current, previous);
  }

  virtual void currentChanged(const QModelIndex &current, const QModelIndex &previous)
  {
    if (cb_currentChanged_4682_0.can_issue()) {
      cb_currentChanged_4682_0.issue<QColumnView_Adaptor, const QModelIndex &, const QModelIndex &>(&QColumnView_Adaptor::cbs_currentChanged_4682_0, current, previous);
    } else {
      QColumnView::currentChanged(current, previous);
    }
  }

  //  [adaptor impl] void QColumnView::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QColumnView::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QColumnView_Adaptor, QEvent *>(&QColumnView_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QColumnView::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QColumnView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)
  void cbs_dataChanged_7048_1(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)
  {
    QColumnView::dataChanged(topLeft, bottomRight, roles);
  }

  virtual void dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)
  {
    if (cb_dataChanged_7048_1.can_issue()) {
      cb_dataChanged_7048_1.issue<QColumnView_Adaptor, const QModelIndex &, const QModelIndex &, const QVector<int> &>(&QColumnView_Adaptor::cbs_dataChanged_7048_1, topLeft, bottomRight, roles);
    } else {
      QColumnView::dataChanged(topLeft, bottomRight, roles);
    }
  }

  //  [adaptor impl] void QColumnView::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QColumnView::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QColumnView_Adaptor, const QMetaMethod &>(&QColumnView_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QColumnView::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QColumnView::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QColumnView::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QColumnView_Adaptor, QDragEnterEvent *>(&QColumnView_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QColumnView::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QColumnView::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QColumnView::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QColumnView_Adaptor, QDragLeaveEvent *>(&QColumnView_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QColumnView::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QColumnView::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QColumnView::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QColumnView_Adaptor, QDragMoveEvent *>(&QColumnView_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QColumnView::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QColumnView::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QColumnView::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QColumnView_Adaptor, QDropEvent *>(&QColumnView_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QColumnView::dropEvent(event);
    }
  }

  //  [adaptor impl] bool QColumnView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  bool cbs_edit_6773_0(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & trigger, QEvent *event)
  {
    return QColumnView::edit(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::EditTrigger>(trigger).cref(), event);
  }

  virtual bool edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  {
    if (cb_edit_6773_0.can_issue()) {
      return cb_edit_6773_0.issue<QColumnView_Adaptor, bool, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type &, QEvent *>(&QColumnView_Adaptor::cbs_edit_6773_0, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::EditTrigger>(trigger), event);
    } else {
      return QColumnView::edit(index, trigger, event);
    }
  }

  //  [adaptor impl] void QColumnView::editorDestroyed(QObject *editor)
  void cbs_editorDestroyed_1302_0(QObject *editor)
  {
    QColumnView::editorDestroyed(editor);
  }

  virtual void editorDestroyed(QObject *editor)
  {
    if (cb_editorDestroyed_1302_0.can_issue()) {
      cb_editorDestroyed_1302_0.issue<QColumnView_Adaptor, QObject *>(&QColumnView_Adaptor::cbs_editorDestroyed_1302_0, editor);
    } else {
      QColumnView::editorDestroyed(editor);
    }
  }

  //  [adaptor impl] void QColumnView::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QColumnView::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QColumnView_Adaptor, QEvent *>(&QColumnView_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QColumnView::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QColumnView::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QColumnView::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QColumnView_Adaptor, bool, QEvent *>(&QColumnView_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QColumnView::event(_event);
    }
  }

  //  [adaptor impl] bool QColumnView::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QColumnView::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QColumnView_Adaptor, bool, QObject *, QEvent *>(&QColumnView_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QColumnView::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QColumnView::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QColumnView::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QColumnView_Adaptor, QFocusEvent *>(&QColumnView_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QColumnView::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QColumnView::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QColumnView::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QColumnView_Adaptor, bool, bool>(&QColumnView_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QColumnView::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QColumnView::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QColumnView::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QColumnView_Adaptor, QFocusEvent *>(&QColumnView_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QColumnView::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QColumnView::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QColumnView::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QColumnView_Adaptor, QHideEvent *>(&QColumnView_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QColumnView::hideEvent(arg1);
    }
  }

  //  [adaptor impl] int QColumnView::horizontalOffset()
  int cbs_horizontalOffset_c0_0() const
  {
    return QColumnView::horizontalOffset();
  }

  virtual int horizontalOffset() const
  {
    if (cb_horizontalOffset_c0_0.can_issue()) {
      return cb_horizontalOffset_c0_0.issue<QColumnView_Adaptor, int>(&QColumnView_Adaptor::cbs_horizontalOffset_c0_0);
    } else {
      return QColumnView::horizontalOffset();
    }
  }

  //  [adaptor impl] void QColumnView::horizontalScrollbarAction(int action)
  void cbs_horizontalScrollbarAction_767_0(int action)
  {
    QColumnView::horizontalScrollbarAction(action);
  }

  virtual void horizontalScrollbarAction(int action)
  {
    if (cb_horizontalScrollbarAction_767_0.can_issue()) {
      cb_horizontalScrollbarAction_767_0.issue<QColumnView_Adaptor, int>(&QColumnView_Adaptor::cbs_horizontalScrollbarAction_767_0, action);
    } else {
      QColumnView::horizontalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QColumnView::horizontalScrollbarValueChanged(int value)
  void cbs_horizontalScrollbarValueChanged_767_0(int value)
  {
    QColumnView::horizontalScrollbarValueChanged(value);
  }

  virtual void horizontalScrollbarValueChanged(int value)
  {
    if (cb_horizontalScrollbarValueChanged_767_0.can_issue()) {
      cb_horizontalScrollbarValueChanged_767_0.issue<QColumnView_Adaptor, int>(&QColumnView_Adaptor::cbs_horizontalScrollbarValueChanged_767_0, value);
    } else {
      QColumnView::horizontalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] void QColumnView::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QColumnView::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QColumnView_Adaptor, QPainter *>(&QColumnView_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QColumnView::initPainter(painter);
    }
  }

  //  [adaptor impl] void QColumnView::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QColumnView::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QColumnView_Adaptor, QInputMethodEvent *>(&QColumnView_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QColumnView::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] bool QColumnView::isIndexHidden(const QModelIndex &index)
  bool cbs_isIndexHidden_c2395_0(const QModelIndex &index) const
  {
    return QColumnView::isIndexHidden(index);
  }

  virtual bool isIndexHidden(const QModelIndex &index) const
  {
    if (cb_isIndexHidden_c2395_0.can_issue()) {
      return cb_isIndexHidden_c2395_0.issue<QColumnView_Adaptor, bool, const QModelIndex &>(&QColumnView_Adaptor::cbs_isIndexHidden_c2395_0, index);
    } else {
      return QColumnView::isIndexHidden(index);
    }
  }

  //  [adaptor impl] void QColumnView::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QColumnView::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QColumnView_Adaptor, QKeyEvent *>(&QColumnView_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QColumnView::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QColumnView::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QColumnView::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QColumnView_Adaptor, QKeyEvent *>(&QColumnView_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QColumnView::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QColumnView::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QColumnView::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QColumnView_Adaptor, QEvent *>(&QColumnView_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QColumnView::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QColumnView::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QColumnView::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QColumnView_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QColumnView_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QColumnView::metric(arg1);
    }
  }

  //  [adaptor impl] void QColumnView::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QColumnView::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QColumnView_Adaptor, QMouseEvent *>(&QColumnView_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QColumnView::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QColumnView::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QColumnView::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QColumnView_Adaptor, QMouseEvent *>(&QColumnView_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QColumnView::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QColumnView::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QColumnView::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QColumnView_Adaptor, QMouseEvent *>(&QColumnView_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QColumnView::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QColumnView::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QColumnView::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QColumnView_Adaptor, QMouseEvent *>(&QColumnView_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QColumnView::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] QModelIndex QColumnView::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  QModelIndex cbs_moveCursor_6476_0(unsigned int cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  {
    return QColumnView::moveCursor(QAbstractItemView::CursorAction(cursorAction), modifiers);
  }

  virtual QModelIndex moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  {
    if (cb_moveCursor_6476_0.can_issue()) {
      return cb_moveCursor_6476_0.issue<QColumnView_Adaptor, QModelIndex, unsigned int, QFlags<Qt::KeyboardModifier> >(&QColumnView_Adaptor::cbs_moveCursor_6476_0, (unsigned int)(cursorAction), modifiers);
    } else {
      return QColumnView::moveCursor(cursorAction, modifiers);
    }
  }

  //  [adaptor impl] void QColumnView::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QColumnView::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QColumnView_Adaptor, QMoveEvent *>(&QColumnView_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QColumnView::moveEvent(arg1);
    }
  }

  //  [adaptor impl] bool QColumnView::nativeEvent(const QByteArray &eventType, void *message, long int *result)
  bool cbs_nativeEvent_4678_0(const QByteArray &eventType, void *message, long int *result)
  {
    return QColumnView::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, long int *result)
  {
    if (cb_nativeEvent_4678_0.can_issue()) {
      return cb_nativeEvent_4678_0.issue<QColumnView_Adaptor, bool, const QByteArray &, void *, long int *>(&QColumnView_Adaptor::cbs_nativeEvent_4678_0, eventType, message, result);
    } else {
      return QColumnView::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QColumnView::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QColumnView::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QColumnView_Adaptor, QPaintEvent *>(&QColumnView_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QColumnView::paintEvent(arg1);
    }
  }

  //  [adaptor impl] QPaintDevice *QColumnView::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QColumnView::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QColumnView_Adaptor, QPaintDevice *, QPoint *>(&QColumnView_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QColumnView::redirected(offset);
    }
  }

  //  [adaptor impl] void QColumnView::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QColumnView::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QColumnView_Adaptor, QResizeEvent *>(&QColumnView_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QColumnView::resizeEvent(event);
    }
  }

  //  [adaptor impl] void QColumnView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  void cbs_rowsAboutToBeRemoved_3713_0(const QModelIndex &parent, int start, int end)
  {
    QColumnView::rowsAboutToBeRemoved(parent, start, end);
  }

  virtual void rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsAboutToBeRemoved_3713_0.can_issue()) {
      cb_rowsAboutToBeRemoved_3713_0.issue<QColumnView_Adaptor, const QModelIndex &, int, int>(&QColumnView_Adaptor::cbs_rowsAboutToBeRemoved_3713_0, parent, start, end);
    } else {
      QColumnView::rowsAboutToBeRemoved(parent, start, end);
    }
  }

  //  [adaptor impl] void QColumnView::rowsInserted(const QModelIndex &parent, int start, int end)
  void cbs_rowsInserted_3713_0(const QModelIndex &parent, int start, int end)
  {
    QColumnView::rowsInserted(parent, start, end);
  }

  virtual void rowsInserted(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsInserted_3713_0.can_issue()) {
      cb_rowsInserted_3713_0.issue<QColumnView_Adaptor, const QModelIndex &, int, int>(&QColumnView_Adaptor::cbs_rowsInserted_3713_0, parent, start, end);
    } else {
      QColumnView::rowsInserted(parent, start, end);
    }
  }

  //  [adaptor impl] void QColumnView::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QColumnView::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QColumnView_Adaptor, int, int>(&QColumnView_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QColumnView::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QColumnView::selectedIndexes()
  QList<QModelIndex> cbs_selectedIndexes_c0_0() const
  {
    return QColumnView::selectedIndexes();
  }

  virtual QList<QModelIndex> selectedIndexes() const
  {
    if (cb_selectedIndexes_c0_0.can_issue()) {
      return cb_selectedIndexes_c0_0.issue<QColumnView_Adaptor, QList<QModelIndex> >(&QColumnView_Adaptor::cbs_selectedIndexes_c0_0);
    } else {
      return QColumnView::selectedIndexes();
    }
  }

  //  [adaptor impl] void QColumnView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  void cbs_selectionChanged_5346_0(const QItemSelection &selected, const QItemSelection &deselected)
  {
    QColumnView::selectionChanged(selected, deselected);
  }

  virtual void selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  {
    if (cb_selectionChanged_5346_0.can_issue()) {
      cb_selectionChanged_5346_0.issue<QColumnView_Adaptor, const QItemSelection &, const QItemSelection &>(&QColumnView_Adaptor::cbs_selectionChanged_5346_0, selected, deselected);
    } else {
      QColumnView::selectionChanged(selected, deselected);
    }
  }

  //  [adaptor impl] QFlags<QItemSelectionModel::SelectionFlag> QColumnView::selectionCommand(const QModelIndex &index, const QEvent *event)
  QFlags<QItemSelectionModel::SelectionFlag> cbs_selectionCommand_c4199_1(const QModelIndex &index, const QEvent *event) const
  {
    return QColumnView::selectionCommand(index, event);
  }

  virtual QFlags<QItemSelectionModel::SelectionFlag> selectionCommand(const QModelIndex &index, const QEvent *event) const
  {
    if (cb_selectionCommand_c4199_1.can_issue()) {
      return cb_selectionCommand_c4199_1.issue<QColumnView_Adaptor, QFlags<QItemSelectionModel::SelectionFlag>, const QModelIndex &, const QEvent *>(&QColumnView_Adaptor::cbs_selectionCommand_c4199_1, index, event);
    } else {
      return QColumnView::selectionCommand(index, event);
    }
  }

  //  [adaptor impl] void QColumnView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  void cbs_setSelection_6155_0(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    QColumnView::setSelection(rect, command);
  }

  virtual void setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    if (cb_setSelection_6155_0.can_issue()) {
      cb_setSelection_6155_0.issue<QColumnView_Adaptor, const QRect &, QFlags<QItemSelectionModel::SelectionFlag> >(&QColumnView_Adaptor::cbs_setSelection_6155_0, rect, command);
    } else {
      QColumnView::setSelection(rect, command);
    }
  }

  //  [adaptor impl] QPainter *QColumnView::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QColumnView::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QColumnView_Adaptor, QPainter *>(&QColumnView_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QColumnView::sharedPainter();
    }
  }

  //  [adaptor impl] void QColumnView::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QColumnView::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QColumnView_Adaptor, QShowEvent *>(&QColumnView_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QColumnView::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QColumnView::startDrag(QFlags<Qt::DropAction> supportedActions)
  void cbs_startDrag_2456_0(QFlags<Qt::DropAction> supportedActions)
  {
    QColumnView::startDrag(supportedActions);
  }

  virtual void startDrag(QFlags<Qt::DropAction> supportedActions)
  {
    if (cb_startDrag_2456_0.can_issue()) {
      cb_startDrag_2456_0.issue<QColumnView_Adaptor, QFlags<Qt::DropAction> >(&QColumnView_Adaptor::cbs_startDrag_2456_0, supportedActions);
    } else {
      QColumnView::startDrag(supportedActions);
    }
  }

  //  [adaptor impl] void QColumnView::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QColumnView::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QColumnView_Adaptor, QTabletEvent *>(&QColumnView_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QColumnView::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QColumnView::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QColumnView::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QColumnView_Adaptor, QTimerEvent *>(&QColumnView_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QColumnView::timerEvent(event);
    }
  }

  //  [adaptor impl] void QColumnView::updateEditorData()
  void cbs_updateEditorData_0_0()
  {
    QColumnView::updateEditorData();
  }

  virtual void updateEditorData()
  {
    if (cb_updateEditorData_0_0.can_issue()) {
      cb_updateEditorData_0_0.issue<QColumnView_Adaptor>(&QColumnView_Adaptor::cbs_updateEditorData_0_0);
    } else {
      QColumnView::updateEditorData();
    }
  }

  //  [adaptor impl] void QColumnView::updateEditorGeometries()
  void cbs_updateEditorGeometries_0_0()
  {
    QColumnView::updateEditorGeometries();
  }

  virtual void updateEditorGeometries()
  {
    if (cb_updateEditorGeometries_0_0.can_issue()) {
      cb_updateEditorGeometries_0_0.issue<QColumnView_Adaptor>(&QColumnView_Adaptor::cbs_updateEditorGeometries_0_0);
    } else {
      QColumnView::updateEditorGeometries();
    }
  }

  //  [adaptor impl] void QColumnView::updateGeometries()
  void cbs_updateGeometries_0_0()
  {
    QColumnView::updateGeometries();
  }

  virtual void updateGeometries()
  {
    if (cb_updateGeometries_0_0.can_issue()) {
      cb_updateGeometries_0_0.issue<QColumnView_Adaptor>(&QColumnView_Adaptor::cbs_updateGeometries_0_0);
    } else {
      QColumnView::updateGeometries();
    }
  }

  //  [adaptor impl] int QColumnView::verticalOffset()
  int cbs_verticalOffset_c0_0() const
  {
    return QColumnView::verticalOffset();
  }

  virtual int verticalOffset() const
  {
    if (cb_verticalOffset_c0_0.can_issue()) {
      return cb_verticalOffset_c0_0.issue<QColumnView_Adaptor, int>(&QColumnView_Adaptor::cbs_verticalOffset_c0_0);
    } else {
      return QColumnView::verticalOffset();
    }
  }

  //  [adaptor impl] void QColumnView::verticalScrollbarAction(int action)
  void cbs_verticalScrollbarAction_767_0(int action)
  {
    QColumnView::verticalScrollbarAction(action);
  }

  virtual void verticalScrollbarAction(int action)
  {
    if (cb_verticalScrollbarAction_767_0.can_issue()) {
      cb_verticalScrollbarAction_767_0.issue<QColumnView_Adaptor, int>(&QColumnView_Adaptor::cbs_verticalScrollbarAction_767_0, action);
    } else {
      QColumnView::verticalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QColumnView::verticalScrollbarValueChanged(int value)
  void cbs_verticalScrollbarValueChanged_767_0(int value)
  {
    QColumnView::verticalScrollbarValueChanged(value);
  }

  virtual void verticalScrollbarValueChanged(int value)
  {
    if (cb_verticalScrollbarValueChanged_767_0.can_issue()) {
      cb_verticalScrollbarValueChanged_767_0.issue<QColumnView_Adaptor, int>(&QColumnView_Adaptor::cbs_verticalScrollbarValueChanged_767_0, value);
    } else {
      QColumnView::verticalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] QStyleOptionViewItem QColumnView::viewOptions()
  QStyleOptionViewItem cbs_viewOptions_c0_0() const
  {
    return QColumnView::viewOptions();
  }

  virtual QStyleOptionViewItem viewOptions() const
  {
    if (cb_viewOptions_c0_0.can_issue()) {
      return cb_viewOptions_c0_0.issue<QColumnView_Adaptor, QStyleOptionViewItem>(&QColumnView_Adaptor::cbs_viewOptions_c0_0);
    } else {
      return QColumnView::viewOptions();
    }
  }

  //  [adaptor impl] bool QColumnView::viewportEvent(QEvent *event)
  bool cbs_viewportEvent_1217_0(QEvent *event)
  {
    return QColumnView::viewportEvent(event);
  }

  virtual bool viewportEvent(QEvent *event)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QColumnView_Adaptor, bool, QEvent *>(&QColumnView_Adaptor::cbs_viewportEvent_1217_0, event);
    } else {
      return QColumnView::viewportEvent(event);
    }
  }

  //  [adaptor impl] QSize QColumnView::viewportSizeHint()
  QSize cbs_viewportSizeHint_c0_0() const
  {
    return QColumnView::viewportSizeHint();
  }

  virtual QSize viewportSizeHint() const
  {
    if (cb_viewportSizeHint_c0_0.can_issue()) {
      return cb_viewportSizeHint_c0_0.issue<QColumnView_Adaptor, QSize>(&QColumnView_Adaptor::cbs_viewportSizeHint_c0_0);
    } else {
      return QColumnView::viewportSizeHint();
    }
  }

  //  [adaptor impl] QRegion QColumnView::visualRegionForSelection(const QItemSelection &selection)
  QRegion cbs_visualRegionForSelection_c2727_0(const QItemSelection &selection) const
  {
    return QColumnView::visualRegionForSelection(selection);
  }

  virtual QRegion visualRegionForSelection(const QItemSelection &selection) const
  {
    if (cb_visualRegionForSelection_c2727_0.can_issue()) {
      return cb_visualRegionForSelection_c2727_0.issue<QColumnView_Adaptor, QRegion, const QItemSelection &>(&QColumnView_Adaptor::cbs_visualRegionForSelection_c2727_0, selection);
    } else {
      return QColumnView::visualRegionForSelection(selection);
    }
  }

  //  [adaptor impl] void QColumnView::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QColumnView::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QColumnView_Adaptor, QWheelEvent *>(&QColumnView_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QColumnView::wheelEvent(arg1);
    }
  }

  gsi::Callback cb_doItemsLayout_0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexAt_c1916_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_keyboardSearch_2025_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_scrollTo_5576_1;
  gsi::Callback cb_selectAll_0_0;
  gsi::Callback cb_setModel_2419_0;
  gsi::Callback cb_setRootIndex_2395_0;
  gsi::Callback cb_setSelectionModel_2533_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_setupViewport_1315_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_sizeHintForColumn_c767_0;
  gsi::Callback cb_sizeHintForRow_c767_0;
  gsi::Callback cb_visualRect_c2395_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEditor_4926_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_commitData_1315_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_createColumn_2395_0;
  gsi::Callback cb_currentChanged_4682_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_dataChanged_7048_1;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_edit_6773_0;
  gsi::Callback cb_editorDestroyed_1302_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_horizontalOffset_c0_0;
  gsi::Callback cb_horizontalScrollbarAction_767_0;
  gsi::Callback cb_horizontalScrollbarValueChanged_767_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_isIndexHidden_c2395_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveCursor_6476_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_4678_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_rowsAboutToBeRemoved_3713_0;
  gsi::Callback cb_rowsInserted_3713_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_selectedIndexes_c0_0;
  gsi::Callback cb_selectionChanged_5346_0;
  gsi::Callback cb_selectionCommand_c4199_1;
  gsi::Callback cb_setSelection_6155_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_startDrag_2456_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateEditorData_0_0;
  gsi::Callback cb_updateEditorGeometries_0_0;
  gsi::Callback cb_updateGeometries_0_0;
  gsi::Callback cb_verticalOffset_c0_0;
  gsi::Callback cb_verticalScrollbarAction_767_0;
  gsi::Callback cb_verticalScrollbarValueChanged_767_0;
  gsi::Callback cb_viewOptions_c0_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_viewportSizeHint_c0_0;
  gsi::Callback cb_visualRegionForSelection_c2727_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QColumnView_Adaptor::~QColumnView_Adaptor() { }

//  Constructor QColumnView::QColumnView(QWidget *parent) (adaptor class)

static void _init_ctor_QColumnView_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QColumnView_Adaptor> ();
}

static void _call_ctor_QColumnView_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? args.read<QWidget * > (heap) : (QWidget *)(0);
  ret.write<QColumnView_Adaptor *> (new QColumnView_Adaptor (arg1));
}


// void QColumnView::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// emitter void QColumnView::activated(const QModelIndex &index)

static void _init_emitter_activated_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_activated_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_activated_2395 (arg1);
}


// void QColumnView::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QColumnView::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QColumnView::clicked(const QModelIndex &index)

static void _init_emitter_clicked_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_clicked_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_clicked_2395 (arg1);
}


// void QColumnView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)

static void _init_cbs_closeEditor_4926_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_closeEditor_4926_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_closeEditor_4926_0 (arg1, arg2);
}

static void _set_callback_cbs_closeEditor_4926_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_closeEditor_4926_0 = cb;
}


// void QColumnView::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QColumnView::commitData(QWidget *editor)

static void _init_cbs_commitData_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_commitData_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_commitData_1315_0 (arg1);
}

static void _set_callback_cbs_commitData_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_commitData_1315_0 = cb;
}


// void QColumnView::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QColumnView::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > (heap) : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > (heap) : (bool)(true);
  bool arg3 = args ? args.read<bool > (heap) : (bool)(true);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_create_2208 (arg1, arg2, arg3);
}


// QAbstractItemView *QColumnView::createColumn(const QModelIndex &rootIndex)

static void _init_cbs_createColumn_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rootIndex");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QAbstractItemView * > ();
}

static void _call_cbs_createColumn_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QAbstractItemView * > ((QAbstractItemView *)((QColumnView_Adaptor *)cls)->cbs_createColumn_2395_0 (arg1));
}

static void _set_callback_cbs_createColumn_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_createColumn_2395_0 = cb;
}


// void QColumnView::currentChanged(const QModelIndex &current, const QModelIndex &previous)

static void _init_cbs_currentChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("previous");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_currentChanged_4682_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_currentChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_currentChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_currentChanged_4682_0 = cb;
}


// emitter void QColumnView::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_customContextMenuRequested_1916 (arg1);
}


// void QColumnView::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QColumnView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)

static void _init_cbs_dataChanged_7048_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("roles");
  decl->add_arg<const QVector<int> & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_dataChanged_7048_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  const QVector<int> &arg3 = args.read<const QVector<int> & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_dataChanged_7048_1 (arg1, arg2, arg3);
}

static void _set_callback_cbs_dataChanged_7048_1 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_dataChanged_7048_1 = cb;
}


// exposed void QColumnView::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? args.read<bool > (heap) : (bool)(true);
  bool arg2 = args ? args.read<bool > (heap) : (bool)(true);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_destroy_1620 (arg1, arg2);
}


// emitter void QColumnView::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_destroyed_1302 (arg1);
}


// exposed QPoint QColumnView::dirtyRegionOffset()

static void _init_fp_dirtyRegionOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_fp_dirtyRegionOffset_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QColumnView_Adaptor *)cls)->fp_QColumnView_dirtyRegionOffset_c0 ());
}


// void QColumnView::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// exposed void QColumnView::doAutoScroll()

static void _init_fp_doAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_doAutoScroll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_doAutoScroll_0 ();
}


// void QColumnView::doItemsLayout()

static void _init_cbs_doItemsLayout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_doItemsLayout_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_doItemsLayout_0_0 ();
}

static void _set_callback_cbs_doItemsLayout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_doItemsLayout_0_0 = cb;
}


// emitter void QColumnView::doubleClicked(const QModelIndex &index)

static void _init_emitter_doubleClicked_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_doubleClicked_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_doubleClicked_2395 (arg1);
}


// void QColumnView::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QColumnView::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QColumnView::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// exposed void QColumnView::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_drawFrame_1426 (arg1);
}


// void QColumnView::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// exposed QAbstractItemView::DropIndicatorPosition QColumnView::dropIndicatorPosition()

static void _init_fp_dropIndicatorPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_dropIndicatorPosition_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<unsigned int > ((unsigned int)((QColumnView_Adaptor *)cls)->fp_QColumnView_dropIndicatorPosition_c0 ());
}


// bool QColumnView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)

static void _init_cbs_edit_6773_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("trigger");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("event");
  decl->add_arg<QEvent * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_edit_6773_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > (heap);
  QEvent *arg3 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QColumnView_Adaptor *)cls)->cbs_edit_6773_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_edit_6773_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_edit_6773_0 = cb;
}


// void QColumnView::editorDestroyed(QObject *editor)

static void _init_cbs_editorDestroyed_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_editorDestroyed_1302_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_editorDestroyed_1302_0 (arg1);
}

static void _set_callback_cbs_editorDestroyed_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_editorDestroyed_1302_0 = cb;
}


// void QColumnView::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// emitter void QColumnView::entered(const QModelIndex &index)

static void _init_emitter_entered_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_entered_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_entered_2395 (arg1);
}


// bool QColumnView::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QColumnView_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QColumnView::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QColumnView_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed void QColumnView::executeDelayedItemsLayout()

static void _init_fp_executeDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_executeDelayedItemsLayout_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_executeDelayedItemsLayout_0 ();
}


// void QColumnView::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QColumnView::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QColumnView_Adaptor *)cls)->fp_QColumnView_focusNextChild_0 ());
}


// bool QColumnView::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QColumnView_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QColumnView::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QColumnView::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QColumnView_Adaptor *)cls)->fp_QColumnView_focusPreviousChild_0 ());
}


// bool QColumnView::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QColumnView_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QColumnView::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QColumnView_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QColumnView::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// int QColumnView::horizontalOffset()

static void _init_cbs_horizontalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_horizontalOffset_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColumnView_Adaptor *)cls)->cbs_horizontalOffset_c0_0 ());
}

static void _set_callback_cbs_horizontalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_horizontalOffset_c0_0 = cb;
}


// void QColumnView::horizontalScrollbarAction(int action)

static void _init_cbs_horizontalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarAction_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_horizontalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_horizontalScrollbarAction_767_0 = cb;
}


// void QColumnView::horizontalScrollbarValueChanged(int value)

static void _init_cbs_horizontalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_horizontalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_horizontalScrollbarValueChanged_767_0 = cb;
}


// exposed int QColumnView::horizontalStepsPerItem()

static void _init_fp_horizontalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_horizontalStepsPerItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColumnView_Adaptor *)cls)->fp_QColumnView_horizontalStepsPerItem_c0 ());
}


// emitter void QColumnView::iconSizeChanged(const QSize &size)

static void _init_emitter_iconSizeChanged_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_iconSizeChanged_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = args.read<const QSize & > (heap);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_iconSizeChanged_1805 (arg1);
}


// QModelIndex QColumnView::indexAt(const QPoint &point)

static void _init_cbs_indexAt_c1916_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_indexAt_c1916_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QColumnView_Adaptor *)cls)->cbs_indexAt_c1916_0 (arg1));
}

static void _set_callback_cbs_indexAt_c1916_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_indexAt_c1916_0 = cb;
}


// void QColumnView::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// exposed void QColumnView::initStyleOption(QStyleOptionFrame *option)

static void _init_fp_initStyleOption_c2356 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionFrame * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_initStyleOption_c2356 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionFrame *arg1 = args.read<QStyleOptionFrame * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_initStyleOption_c2356 (arg1);
}


// exposed void QColumnView::initializeColumn(QAbstractItemView *column)

static void _init_fp_initializeColumn_c2333 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<QAbstractItemView * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_initializeColumn_c2333 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemView *arg1 = args.read<QAbstractItemView * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_initializeColumn_c2333 (arg1);
}


// void QColumnView::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QColumnView::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QColumnView_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// bool QColumnView::isIndexHidden(const QModelIndex &index)

static void _init_cbs_isIndexHidden_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isIndexHidden_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QColumnView_Adaptor *)cls)->cbs_isIndexHidden_c2395_0 (arg1));
}

static void _set_callback_cbs_isIndexHidden_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_isIndexHidden_c2395_0 = cb;
}


// exposed bool QColumnView::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  ret.write<bool > ((bool)((QColumnView_Adaptor *)cls)->fp_QColumnView_isSignalConnected_c2394 (arg1));
}


// void QColumnView::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QColumnView::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QColumnView::keyboardSearch(const QString &search)

static void _init_cbs_keyboardSearch_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("search");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyboardSearch_2025_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_keyboardSearch_2025_0 (arg1);
}

static void _set_callback_cbs_keyboardSearch_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_keyboardSearch_2025_0 = cb;
}


// void QColumnView::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QColumnView::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QColumnView_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QColumnView::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QColumnView_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QColumnView::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QColumnView::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QColumnView::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QColumnView::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// QModelIndex QColumnView::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)

static void _init_cbs_moveCursor_6476_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursorAction");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("modifiers");
  decl->add_arg<QFlags<Qt::KeyboardModifier> > (argspec_1);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_moveCursor_6476_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  QFlags<Qt::KeyboardModifier> arg2 = args.read<QFlags<Qt::KeyboardModifier> > (heap);
  ret.write<QModelIndex > ((QModelIndex)((QColumnView_Adaptor *)cls)->cbs_moveCursor_6476_0 (arg1, arg2));
}

static void _set_callback_cbs_moveCursor_6476_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_moveCursor_6476_0 = cb;
}


// void QColumnView::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QColumnView::nativeEvent(const QByteArray &eventType, void *message, long int *result)

static void _init_cbs_nativeEvent_4678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<long int * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_4678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  long int *arg3 = args.read<long int * > (heap);
  ret.write<bool > ((bool)((QColumnView_Adaptor *)cls)->cbs_nativeEvent_4678_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_4678_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_nativeEvent_4678_0 = cb;
}


// QPaintEngine *QColumnView::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QColumnView_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QColumnView::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// emitter void QColumnView::pressed(const QModelIndex &index)

static void _init_emitter_pressed_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_pressed_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_pressed_2395 (arg1);
}


// exposed int QColumnView::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<int > ((int)((QColumnView_Adaptor *)cls)->fp_QColumnView_receivers_c1731 (arg1));
}


// QPaintDevice *QColumnView::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QColumnView_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QColumnView::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_reset_0_0 = cb;
}


// void QColumnView::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// void QColumnView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsAboutToBeRemoved_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsAboutToBeRemoved_3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_rowsAboutToBeRemoved_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsAboutToBeRemoved_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_rowsAboutToBeRemoved_3713_0 = cb;
}


// void QColumnView::rowsInserted(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsInserted_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsInserted_3713_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_rowsInserted_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsInserted_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_rowsInserted_3713_0 = cb;
}


// exposed void QColumnView::scheduleDelayedItemsLayout()

static void _init_fp_scheduleDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_scheduleDelayedItemsLayout_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_scheduleDelayedItemsLayout_0 ();
}


// void QColumnView::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}


// exposed void QColumnView::scrollDirtyRegion(int dx, int dy)

static void _init_fp_scrollDirtyRegion_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_scrollDirtyRegion_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_scrollDirtyRegion_1426 (arg1, arg2);
}


// void QColumnView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)

static void _init_cbs_scrollTo_5576_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollTo_5576_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_scrollTo_5576_1 (arg1, arg2);
}

static void _set_callback_cbs_scrollTo_5576_1 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_scrollTo_5576_1 = cb;
}


// void QColumnView::selectAll()

static void _init_cbs_selectAll_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_selectAll_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_selectAll_0_0 ();
}

static void _set_callback_cbs_selectAll_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_selectAll_0_0 = cb;
}


// QList<QModelIndex> QColumnView::selectedIndexes()

static void _init_cbs_selectedIndexes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QModelIndex> > ();
}

static void _call_cbs_selectedIndexes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QModelIndex> > ((QList<QModelIndex>)((QColumnView_Adaptor *)cls)->cbs_selectedIndexes_c0_0 ());
}

static void _set_callback_cbs_selectedIndexes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_selectedIndexes_c0_0 = cb;
}


// void QColumnView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)

static void _init_cbs_selectionChanged_5346_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selected");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deselected");
  decl->add_arg<const QItemSelection & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_selectionChanged_5346_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  const QItemSelection &arg2 = args.read<const QItemSelection & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_selectionChanged_5346_0 (arg1, arg2);
}

static void _set_callback_cbs_selectionChanged_5346_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_selectionChanged_5346_0 = cb;
}


// QFlags<QItemSelectionModel::SelectionFlag> QColumnView::selectionCommand(const QModelIndex &index, const QEvent *event)

static void _init_cbs_selectionCommand_c4199_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<const QEvent * > (argspec_1);
  decl->set_return<QFlags<QItemSelectionModel::SelectionFlag> > ();
}

static void _call_cbs_selectionCommand_c4199_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  const QEvent *arg2 = args.read<const QEvent * > (heap);
  ret.write<QFlags<QItemSelectionModel::SelectionFlag> > ((QFlags<QItemSelectionModel::SelectionFlag>)((QColumnView_Adaptor *)cls)->cbs_selectionCommand_c4199_1 (arg1, arg2));
}

static void _set_callback_cbs_selectionCommand_c4199_1 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_selectionCommand_c4199_1 = cb;
}


// exposed QObject *QColumnView::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QColumnView_Adaptor *)cls)->fp_QColumnView_sender_c0 ());
}


// exposed int QColumnView::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColumnView_Adaptor *)cls)->fp_QColumnView_senderSignalIndex_c0 ());
}


// exposed void QColumnView::setDirtyRegion(const QRegion &region)

static void _init_fp_setDirtyRegion_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setDirtyRegion_2006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRegion &arg1 = args.read<const QRegion & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_setDirtyRegion_2006 (arg1);
}


// exposed void QColumnView::setHorizontalStepsPerItem(int steps)

static void _init_fp_setHorizontalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setHorizontalStepsPerItem_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_setHorizontalStepsPerItem_767 (arg1);
}


// void QColumnView::setModel(QAbstractItemModel *model)

static void _init_cbs_setModel_2419_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setModel_2419_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_setModel_2419_0 (arg1);
}

static void _set_callback_cbs_setModel_2419_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_setModel_2419_0 = cb;
}


// void QColumnView::setRootIndex(const QModelIndex &index)

static void _init_cbs_setRootIndex_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setRootIndex_2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_setRootIndex_2395_0 (arg1);
}

static void _set_callback_cbs_setRootIndex_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_setRootIndex_2395_0 = cb;
}


// void QColumnView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)

static void _init_cbs_setSelection_6155_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<QFlags<QItemSelectionModel::SelectionFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setSelection_6155_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  QFlags<QItemSelectionModel::SelectionFlag> arg2 = args.read<QFlags<QItemSelectionModel::SelectionFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_setSelection_6155_0 (arg1, arg2);
}

static void _set_callback_cbs_setSelection_6155_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_setSelection_6155_0 = cb;
}


// void QColumnView::setSelectionModel(QItemSelectionModel *selectionModel)

static void _init_cbs_setSelectionModel_2533_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionModel");
  decl->add_arg<QItemSelectionModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSelectionModel_2533_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QItemSelectionModel *arg1 = args.read<QItemSelectionModel * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_setSelectionModel_2533_0 (arg1);
}

static void _set_callback_cbs_setSelectionModel_2533_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_setSelectionModel_2533_0 = cb;
}


// exposed void QColumnView::setState(QAbstractItemView::State state)

static void _init_fp_setState_2776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setState_2776 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_setState_2776 (arg1);
}


// exposed void QColumnView::setVerticalStepsPerItem(int steps)

static void _init_fp_setVerticalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setVerticalStepsPerItem_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_setVerticalStepsPerItem_767 (arg1);
}


// exposed void QColumnView::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}


// exposed void QColumnView::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = args.read<const QMargins & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_setViewportMargins_2115 (arg1);
}


// void QColumnView::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// void QColumnView::setupViewport(QWidget *viewport)

static void _init_cbs_setupViewport_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setupViewport_1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_setupViewport_1315_0 (arg1);
}

static void _set_callback_cbs_setupViewport_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_setupViewport_1315_0 = cb;
}


// QPainter *QColumnView::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QColumnView_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QColumnView::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QColumnView::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QColumnView_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// int QColumnView::sizeHintForColumn(int column)

static void _init_cbs_sizeHintForColumn_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForColumn_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QColumnView_Adaptor *)cls)->cbs_sizeHintForColumn_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForColumn_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_sizeHintForColumn_c767_0 = cb;
}


// int QColumnView::sizeHintForRow(int row)

static void _init_cbs_sizeHintForRow_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForRow_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QColumnView_Adaptor *)cls)->cbs_sizeHintForRow_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForRow_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_sizeHintForRow_c767_0 = cb;
}


// exposed void QColumnView::startAutoScroll()

static void _init_fp_startAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_startAutoScroll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_startAutoScroll_0 ();
}


// void QColumnView::startDrag(QFlags<Qt::DropAction> supportedActions)

static void _init_cbs_startDrag_2456_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("supportedActions");
  decl->add_arg<QFlags<Qt::DropAction> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_startDrag_2456_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::DropAction> arg1 = args.read<QFlags<Qt::DropAction> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_startDrag_2456_0 (arg1);
}

static void _set_callback_cbs_startDrag_2456_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_startDrag_2456_0 = cb;
}


// exposed QAbstractItemView::State QColumnView::state()

static void _init_fp_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<unsigned int > ((unsigned int)((QColumnView_Adaptor *)cls)->fp_QColumnView_state_c0 ());
}


// exposed void QColumnView::stopAutoScroll()

static void _init_fp_stopAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_stopAutoScroll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_stopAutoScroll_0 ();
}


// void QColumnView::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QColumnView::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QColumnView::updateEditorData()

static void _init_cbs_updateEditorData_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorData_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_updateEditorData_0_0 ();
}

static void _set_callback_cbs_updateEditorData_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_updateEditorData_0_0 = cb;
}


// void QColumnView::updateEditorGeometries()

static void _init_cbs_updateEditorGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometries_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_updateEditorGeometries_0_0 ();
}

static void _set_callback_cbs_updateEditorGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_updateEditorGeometries_0_0 = cb;
}


// void QColumnView::updateGeometries()

static void _init_cbs_updateGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometries_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_updateGeometries_0_0 ();
}

static void _set_callback_cbs_updateGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_updateGeometries_0_0 = cb;
}


// exposed void QColumnView::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->fp_QColumnView_updateMicroFocus_0 ();
}


// emitter void QColumnView::updatePreviewWidget(const QModelIndex &index)

static void _init_emitter_updatePreviewWidget_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_updatePreviewWidget_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_updatePreviewWidget_2395 (arg1);
}


// int QColumnView::verticalOffset()

static void _init_cbs_verticalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_verticalOffset_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColumnView_Adaptor *)cls)->cbs_verticalOffset_c0_0 ());
}

static void _set_callback_cbs_verticalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_verticalOffset_c0_0 = cb;
}


// void QColumnView::verticalScrollbarAction(int action)

static void _init_cbs_verticalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarAction_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_verticalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_verticalScrollbarAction_767_0 = cb;
}


// void QColumnView::verticalScrollbarValueChanged(int value)

static void _init_cbs_verticalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_verticalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_verticalScrollbarValueChanged_767_0 = cb;
}


// exposed int QColumnView::verticalStepsPerItem()

static void _init_fp_verticalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_verticalStepsPerItem_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QColumnView_Adaptor *)cls)->fp_QColumnView_verticalStepsPerItem_c0 ());
}


// QStyleOptionViewItem QColumnView::viewOptions()

static void _init_cbs_viewOptions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyleOptionViewItem > ();
}

static void _call_cbs_viewOptions_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStyleOptionViewItem > ((QStyleOptionViewItem)((QColumnView_Adaptor *)cls)->cbs_viewOptions_c0_0 ());
}

static void _set_callback_cbs_viewOptions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_viewOptions_c0_0 = cb;
}


// emitter void QColumnView::viewportEntered()

static void _init_emitter_viewportEntered_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_viewportEntered_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_viewportEntered_0 ();
}


// bool QColumnView::viewportEvent(QEvent *event)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QColumnView_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}


// exposed QMargins QColumnView::viewportMargins()

static void _init_fp_viewportMargins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMargins > ();
}

static void _call_fp_viewportMargins_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMargins > ((QMargins)((QColumnView_Adaptor *)cls)->fp_QColumnView_viewportMargins_c0 ());
}


// QSize QColumnView::viewportSizeHint()

static void _init_cbs_viewportSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_viewportSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QColumnView_Adaptor *)cls)->cbs_viewportSizeHint_c0_0 ());
}

static void _set_callback_cbs_viewportSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_viewportSizeHint_c0_0 = cb;
}


// QRect QColumnView::visualRect(const QModelIndex &index)

static void _init_cbs_visualRect_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_cbs_visualRect_c2395_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = args.read<const QModelIndex & > (heap);
  ret.write<QRect > ((QRect)((QColumnView_Adaptor *)cls)->cbs_visualRect_c2395_0 (arg1));
}

static void _set_callback_cbs_visualRect_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_visualRect_c2395_0 = cb;
}


// QRegion QColumnView::visualRegionForSelection(const QItemSelection &selection)

static void _init_cbs_visualRegionForSelection_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QRegion > ();
}

static void _call_cbs_visualRegionForSelection_c2727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QItemSelection &arg1 = args.read<const QItemSelection & > (heap);
  ret.write<QRegion > ((QRegion)((QColumnView_Adaptor *)cls)->cbs_visualRegionForSelection_c2727_0 (arg1));
}

static void _set_callback_cbs_visualRegionForSelection_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_visualRegionForSelection_c2727_0 = cb;
}


// void QColumnView::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QColumnView_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QColumnView_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QColumnView::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = args.read<const QIcon & > (heap);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_windowIconChanged_1787 (arg1);
}


// emitter void QColumnView::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_windowIconTextChanged_2025 (arg1);
}


// emitter void QColumnView::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ((QColumnView_Adaptor *)cls)->emitter_QColumnView_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QColumnView> &qtdecl_QColumnView ();

static gsi::Methods methods_QColumnView_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QColumnView::QColumnView(QWidget *parent)\nThis method creates an object of class QColumnView.", &_init_ctor_QColumnView_Adaptor_1315, &_call_ctor_QColumnView_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QColumnView::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("emit_activated", "@brief Emitter for signal void QColumnView::activated(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_activated_2395, &_call_emitter_activated_2395);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QColumnView::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QColumnView::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_clicked", "@brief Emitter for signal void QColumnView::clicked(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_clicked_2395, &_call_emitter_clicked_2395);
  methods += new qt_gsi::GenericMethod ("*closeEditor", "@hide", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0);
  methods += new qt_gsi::GenericMethod ("*closeEditor", "@brief Virtual method void QColumnView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0, &_set_callback_cbs_closeEditor_4926_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QColumnView::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*commitData", "@hide", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0);
  methods += new qt_gsi::GenericMethod ("*commitData", "@brief Virtual method void QColumnView::commitData(QWidget *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0, &_set_callback_cbs_commitData_1315_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QColumnView::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QColumnView::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("*createColumn", "@hide", false, &_init_cbs_createColumn_2395_0, &_call_cbs_createColumn_2395_0);
  methods += new qt_gsi::GenericMethod ("*createColumn", "@brief Virtual method QAbstractItemView *QColumnView::createColumn(const QModelIndex &rootIndex)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_createColumn_2395_0, &_call_cbs_createColumn_2395_0, &_set_callback_cbs_createColumn_2395_0);
  methods += new qt_gsi::GenericMethod ("*currentChanged", "@hide", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0);
  methods += new qt_gsi::GenericMethod ("*currentChanged", "@brief Virtual method void QColumnView::currentChanged(const QModelIndex &current, const QModelIndex &previous)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0, &_set_callback_cbs_currentChanged_4682_0);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QColumnView::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QColumnView::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*dataChanged", "@hide", false, &_init_cbs_dataChanged_7048_1, &_call_cbs_dataChanged_7048_1);
  methods += new qt_gsi::GenericMethod ("*dataChanged", "@brief Virtual method void QColumnView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dataChanged_7048_1, &_call_cbs_dataChanged_7048_1, &_set_callback_cbs_dataChanged_7048_1);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QColumnView::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QColumnView::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*dirtyRegionOffset", "@brief Method QPoint QColumnView::dirtyRegionOffset()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dirtyRegionOffset_c0, &_call_fp_dirtyRegionOffset_c0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QColumnView::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*doAutoScroll", "@brief Method void QColumnView::doAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_doAutoScroll_0, &_call_fp_doAutoScroll_0);
  methods += new qt_gsi::GenericMethod ("doItemsLayout", "@hide", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0);
  methods += new qt_gsi::GenericMethod ("doItemsLayout", "@brief Virtual method void QColumnView::doItemsLayout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0, &_set_callback_cbs_doItemsLayout_0_0);
  methods += new qt_gsi::GenericMethod ("emit_doubleClicked", "@brief Emitter for signal void QColumnView::doubleClicked(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_doubleClicked_2395, &_call_emitter_doubleClicked_2395);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QColumnView::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QColumnView::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QColumnView::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*drawFrame", "@brief Method void QColumnView::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QColumnView::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropIndicatorPosition", "@brief Method QAbstractItemView::DropIndicatorPosition QColumnView::dropIndicatorPosition()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dropIndicatorPosition_c0, &_call_fp_dropIndicatorPosition_c0);
  methods += new qt_gsi::GenericMethod ("*edit", "@hide", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0);
  methods += new qt_gsi::GenericMethod ("*edit", "@brief Virtual method bool QColumnView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0, &_set_callback_cbs_edit_6773_0);
  methods += new qt_gsi::GenericMethod ("*editorDestroyed", "@hide", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0);
  methods += new qt_gsi::GenericMethod ("*editorDestroyed", "@brief Virtual method void QColumnView::editorDestroyed(QObject *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0, &_set_callback_cbs_editorDestroyed_1302_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QColumnView::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_entered", "@brief Emitter for signal void QColumnView::entered(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_entered_2395, &_call_emitter_entered_2395);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QColumnView::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QColumnView::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*executeDelayedItemsLayout", "@brief Method void QColumnView::executeDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_executeDelayedItemsLayout_0, &_call_fp_executeDelayedItemsLayout_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QColumnView::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QColumnView::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QColumnView::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QColumnView::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QColumnView::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QColumnView::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QColumnView::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QColumnView::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*horizontalOffset", "@hide", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("*horizontalOffset", "@brief Virtual method int QColumnView::horizontalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0, &_set_callback_cbs_horizontalOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@hide", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0);
  methods += new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@brief Virtual method void QColumnView::horizontalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0, &_set_callback_cbs_horizontalScrollbarAction_767_0);
  methods += new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@hide", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0);
  methods += new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@brief Virtual method void QColumnView::horizontalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0, &_set_callback_cbs_horizontalScrollbarValueChanged_767_0);
  methods += new qt_gsi::GenericMethod ("*horizontalStepsPerItem", "@brief Method int QColumnView::horizontalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_horizontalStepsPerItem_c0, &_call_fp_horizontalStepsPerItem_c0);
  methods += new qt_gsi::GenericMethod ("emit_iconSizeChanged", "@brief Emitter for signal void QColumnView::iconSizeChanged(const QSize &size)\nCall this method to emit this signal.", false, &_init_emitter_iconSizeChanged_1805, &_call_emitter_iconSizeChanged_1805);
  methods += new qt_gsi::GenericMethod ("indexAt", "@hide", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0);
  methods += new qt_gsi::GenericMethod ("indexAt", "@brief Virtual method QModelIndex QColumnView::indexAt(const QPoint &point)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0, &_set_callback_cbs_indexAt_c1916_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QColumnView::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Method void QColumnView::initStyleOption(QStyleOptionFrame *option)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_initStyleOption_c2356, &_call_fp_initStyleOption_c2356);
  methods += new qt_gsi::GenericMethod ("*initializeColumn", "@brief Method void QColumnView::initializeColumn(QAbstractItemView *column)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_initializeColumn_c2333, &_call_fp_initializeColumn_c2333);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QColumnView::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QColumnView::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isIndexHidden", "@hide", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0);
  methods += new qt_gsi::GenericMethod ("*isIndexHidden", "@brief Virtual method bool QColumnView::isIndexHidden(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0, &_set_callback_cbs_isIndexHidden_c2395_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QColumnView::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QColumnView::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QColumnView::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("keyboardSearch", "@hide", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0);
  methods += new qt_gsi::GenericMethod ("keyboardSearch", "@brief Virtual method void QColumnView::keyboardSearch(const QString &search)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0, &_set_callback_cbs_keyboardSearch_2025_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QColumnView::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QColumnView::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QColumnView::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QColumnView::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QColumnView::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QColumnView::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QColumnView::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveCursor", "@hide", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0);
  methods += new qt_gsi::GenericMethod ("*moveCursor", "@brief Virtual method QModelIndex QColumnView::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0, &_set_callback_cbs_moveCursor_6476_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QColumnView::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QColumnView::nativeEvent(const QByteArray &eventType, void *message, long int *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0, &_set_callback_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QColumnView::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QColumnView::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("emit_pressed", "@brief Emitter for signal void QColumnView::pressed(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_pressed_2395, &_call_emitter_pressed_2395);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QColumnView::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QColumnView::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QColumnView::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QColumnView::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@hide", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0);
  methods += new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@brief Virtual method void QColumnView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0, &_set_callback_cbs_rowsAboutToBeRemoved_3713_0);
  methods += new qt_gsi::GenericMethod ("*rowsInserted", "@hide", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0);
  methods += new qt_gsi::GenericMethod ("*rowsInserted", "@brief Virtual method void QColumnView::rowsInserted(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0, &_set_callback_cbs_rowsInserted_3713_0);
  methods += new qt_gsi::GenericMethod ("*scheduleDelayedItemsLayout", "@brief Method void QColumnView::scheduleDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scheduleDelayedItemsLayout_0, &_call_fp_scheduleDelayedItemsLayout_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QColumnView::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
  methods += new qt_gsi::GenericMethod ("*scrollDirtyRegion", "@brief Method void QColumnView::scrollDirtyRegion(int dx, int dy)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scrollDirtyRegion_1426, &_call_fp_scrollDirtyRegion_1426);
  methods += new qt_gsi::GenericMethod ("scrollTo", "@hide", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1);
  methods += new qt_gsi::GenericMethod ("scrollTo", "@brief Virtual method void QColumnView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1, &_set_callback_cbs_scrollTo_5576_1);
  methods += new qt_gsi::GenericMethod ("selectAll", "@hide", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0);
  methods += new qt_gsi::GenericMethod ("selectAll", "@brief Virtual method void QColumnView::selectAll()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0, &_set_callback_cbs_selectAll_0_0);
  methods += new qt_gsi::GenericMethod ("*selectedIndexes", "@hide", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0);
  methods += new qt_gsi::GenericMethod ("*selectedIndexes", "@brief Virtual method QList<QModelIndex> QColumnView::selectedIndexes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0, &_set_callback_cbs_selectedIndexes_c0_0);
  methods += new qt_gsi::GenericMethod ("*selectionChanged", "@hide", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0);
  methods += new qt_gsi::GenericMethod ("*selectionChanged", "@brief Virtual method void QColumnView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0, &_set_callback_cbs_selectionChanged_5346_0);
  methods += new qt_gsi::GenericMethod ("*selectionCommand", "@hide", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1);
  methods += new qt_gsi::GenericMethod ("*selectionCommand", "@brief Virtual method QFlags<QItemSelectionModel::SelectionFlag> QColumnView::selectionCommand(const QModelIndex &index, const QEvent *event)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1, &_set_callback_cbs_selectionCommand_c4199_1);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QColumnView::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QColumnView::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setDirtyRegion", "@brief Method void QColumnView::setDirtyRegion(const QRegion &region)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setDirtyRegion_2006, &_call_fp_setDirtyRegion_2006);
  methods += new qt_gsi::GenericMethod ("*setHorizontalStepsPerItem", "@brief Method void QColumnView::setHorizontalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setHorizontalStepsPerItem_767, &_call_fp_setHorizontalStepsPerItem_767);
  methods += new qt_gsi::GenericMethod ("setModel", "@hide", false, &_init_cbs_setModel_2419_0, &_call_cbs_setModel_2419_0);
  methods += new qt_gsi::GenericMethod ("setModel", "@brief Virtual method void QColumnView::setModel(QAbstractItemModel *model)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setModel_2419_0, &_call_cbs_setModel_2419_0, &_set_callback_cbs_setModel_2419_0);
  methods += new qt_gsi::GenericMethod ("setRootIndex", "@hide", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0);
  methods += new qt_gsi::GenericMethod ("setRootIndex", "@brief Virtual method void QColumnView::setRootIndex(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0, &_set_callback_cbs_setRootIndex_2395_0);
  methods += new qt_gsi::GenericMethod ("*setSelection", "@hide", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0);
  methods += new qt_gsi::GenericMethod ("*setSelection", "@brief Virtual method void QColumnView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0, &_set_callback_cbs_setSelection_6155_0);
  methods += new qt_gsi::GenericMethod ("setSelectionModel", "@hide", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0);
  methods += new qt_gsi::GenericMethod ("setSelectionModel", "@brief Virtual method void QColumnView::setSelectionModel(QItemSelectionModel *selectionModel)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0, &_set_callback_cbs_setSelectionModel_2533_0);
  methods += new qt_gsi::GenericMethod ("*setState", "@brief Method void QColumnView::setState(QAbstractItemView::State state)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setState_2776, &_call_fp_setState_2776);
  methods += new qt_gsi::GenericMethod ("*setVerticalStepsPerItem", "@brief Method void QColumnView::setVerticalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setVerticalStepsPerItem_767, &_call_fp_setVerticalStepsPerItem_767);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QColumnView::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
  methods += new qt_gsi::GenericMethod ("*setViewportMargins", "@brief Method void QColumnView::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QColumnView::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@hide", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("setupViewport", "@brief Virtual method void QColumnView::setupViewport(QWidget *viewport)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setupViewport_1315_0, &_call_cbs_setupViewport_1315_0, &_set_callback_cbs_setupViewport_1315_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QColumnView::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QColumnView::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QColumnView::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHintForColumn", "@hide", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0);
  methods += new qt_gsi::GenericMethod ("sizeHintForColumn", "@brief Virtual method int QColumnView::sizeHintForColumn(int column)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0, &_set_callback_cbs_sizeHintForColumn_c767_0);
  methods += new qt_gsi::GenericMethod ("sizeHintForRow", "@hide", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0);
  methods += new qt_gsi::GenericMethod ("sizeHintForRow", "@brief Virtual method int QColumnView::sizeHintForRow(int row)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0, &_set_callback_cbs_sizeHintForRow_c767_0);
  methods += new qt_gsi::GenericMethod ("*startAutoScroll", "@brief Method void QColumnView::startAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_startAutoScroll_0, &_call_fp_startAutoScroll_0);
  methods += new qt_gsi::GenericMethod ("*startDrag", "@hide", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0);
  methods += new qt_gsi::GenericMethod ("*startDrag", "@brief Virtual method void QColumnView::startDrag(QFlags<Qt::DropAction> supportedActions)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0, &_set_callback_cbs_startDrag_2456_0);
  methods += new qt_gsi::GenericMethod ("*state", "@brief Method QAbstractItemView::State QColumnView::state()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_state_c0, &_call_fp_state_c0);
  methods += new qt_gsi::GenericMethod ("*stopAutoScroll", "@brief Method void QColumnView::stopAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_stopAutoScroll_0, &_call_fp_stopAutoScroll_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QColumnView::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QColumnView::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateEditorData", "@hide", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0);
  methods += new qt_gsi::GenericMethod ("*updateEditorData", "@brief Virtual method void QColumnView::updateEditorData()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0, &_set_callback_cbs_updateEditorData_0_0);
  methods += new qt_gsi::GenericMethod ("*updateEditorGeometries", "@hide", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0);
  methods += new qt_gsi::GenericMethod ("*updateEditorGeometries", "@brief Virtual method void QColumnView::updateEditorGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0, &_set_callback_cbs_updateEditorGeometries_0_0);
  methods += new qt_gsi::GenericMethod ("*updateGeometries", "@hide", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0);
  methods += new qt_gsi::GenericMethod ("*updateGeometries", "@brief Virtual method void QColumnView::updateGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0, &_set_callback_cbs_updateGeometries_0_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QColumnView::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("emit_updatePreviewWidget", "@brief Emitter for signal void QColumnView::updatePreviewWidget(const QModelIndex &index)\nCall this method to emit this signal.", false, &_init_emitter_updatePreviewWidget_2395, &_call_emitter_updatePreviewWidget_2395);
  methods += new qt_gsi::GenericMethod ("*verticalOffset", "@hide", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("*verticalOffset", "@brief Virtual method int QColumnView::verticalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0, &_set_callback_cbs_verticalOffset_c0_0);
  methods += new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@hide", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0);
  methods += new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@brief Virtual method void QColumnView::verticalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0, &_set_callback_cbs_verticalScrollbarAction_767_0);
  methods += new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@hide", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0);
  methods += new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@brief Virtual method void QColumnView::verticalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0, &_set_callback_cbs_verticalScrollbarValueChanged_767_0);
  methods += new qt_gsi::GenericMethod ("*verticalStepsPerItem", "@brief Method int QColumnView::verticalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_verticalStepsPerItem_c0, &_call_fp_verticalStepsPerItem_c0);
  methods += new qt_gsi::GenericMethod ("*viewOptions", "@hide", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0);
  methods += new qt_gsi::GenericMethod ("*viewOptions", "@brief Virtual method QStyleOptionViewItem QColumnView::viewOptions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0, &_set_callback_cbs_viewOptions_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_viewportEntered", "@brief Emitter for signal void QColumnView::viewportEntered()\nCall this method to emit this signal.", false, &_init_emitter_viewportEntered_0, &_call_emitter_viewportEntered_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QColumnView::viewportEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*viewportMargins", "@brief Method QMargins QColumnView::viewportMargins()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_viewportMargins_c0, &_call_fp_viewportMargins_c0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@hide", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*viewportSizeHint", "@brief Virtual method QSize QColumnView::viewportSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewportSizeHint_c0_0, &_call_cbs_viewportSizeHint_c0_0, &_set_callback_cbs_viewportSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("visualRect", "@hide", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0);
  methods += new qt_gsi::GenericMethod ("visualRect", "@brief Virtual method QRect QColumnView::visualRect(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0, &_set_callback_cbs_visualRect_c2395_0);
  methods += new qt_gsi::GenericMethod ("*visualRegionForSelection", "@hide", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0);
  methods += new qt_gsi::GenericMethod ("*visualRegionForSelection", "@brief Virtual method QRegion QColumnView::visualRegionForSelection(const QItemSelection &selection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0, &_set_callback_cbs_visualRegionForSelection_c2727_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QColumnView::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QColumnView::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QColumnView::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QColumnView::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QColumnView_Adaptor> decl_QColumnView_Adaptor (qtdecl_QColumnView (), "QColumnView",
  methods_QColumnView_Adaptor (),
  "@qt\n@brief Binding of QColumnView");

}

