
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsLinearLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QGraphicsLinearLayout>
#include <QEvent>
#include <QGraphicsItem>
#include <QGraphicsLayoutItem>
#include <QRectF>
#include <QSizeF>
#include <QSizePolicy>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsLinearLayout

// void QGraphicsLinearLayout::addItem(QGraphicsLayoutItem *item)


static void _init_f_addItem_2557 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItem_2557 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = args.read<QGraphicsLayoutItem * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->addItem (arg1);
}


// void QGraphicsLinearLayout::addStretch(int stretch)


static void _init_f_addStretch_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stretch", true, "1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addStretch_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? args.read<int > (heap) : (int)(1);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->addStretch (arg1);
}


// QFlags<Qt::AlignmentFlag> QGraphicsLinearLayout::alignment(QGraphicsLayoutItem *item)


static void _init_f_alignment_c2557 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  decl->set_return<QFlags<Qt::AlignmentFlag> > ();
}

static void _call_f_alignment_c2557 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = args.read<QGraphicsLayoutItem * > (heap);
  ret.write<QFlags<Qt::AlignmentFlag> > ((QFlags<Qt::AlignmentFlag>)((QGraphicsLinearLayout *)cls)->alignment (arg1));
}


// () const


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsLinearLayout *)cls)->count ());
}


// void QGraphicsLinearLayout::dump(int indent)


static void _init_f_dump_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indent", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_dump_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? args.read<int > (heap) : (int)(0);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->dump (arg1);
}


// void QGraphicsLinearLayout::insertItem(int index, QGraphicsLayoutItem *item)


static void _init_f_insertItem_3216 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("item");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertItem_3216 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  QGraphicsLayoutItem *arg2 = args.read<QGraphicsLayoutItem * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->insertItem (arg1, arg2);
}


// void QGraphicsLinearLayout::insertStretch(int index, int stretch)


static void _init_f_insertStretch_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stretch", true, "1");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertStretch_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args ? args.read<int > (heap) : (int)(1);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->insertStretch (arg1, arg2);
}


// ()


static void _init_f_invalidate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_invalidate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->invalidate ();
}


// (int) const


static void _init_f_itemAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QGraphicsLayoutItem * > ();
}

static void _call_f_itemAt_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QGraphicsLayoutItem * > ((QGraphicsLayoutItem *)((QGraphicsLinearLayout *)cls)->itemAt (arg1));
}


// double QGraphicsLinearLayout::itemSpacing(int index)


static void _init_f_itemSpacing_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_itemSpacing_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<double > ((double)((QGraphicsLinearLayout *)cls)->itemSpacing (arg1));
}


// Qt::Orientation QGraphicsLinearLayout::orientation()


static void _init_f_orientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::Orientation>::target_type > ();
}

static void _call_f_orientation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::Orientation>::target_type > ((qt_gsi::Converter<Qt::Orientation>::target_type)qt_gsi::CppToQtAdaptor<Qt::Orientation>(((QGraphicsLinearLayout *)cls)->orientation ()));
}


// (int)


static void _init_f_removeAt_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeAt_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->removeAt (arg1);
}


// void QGraphicsLinearLayout::removeItem(QGraphicsLayoutItem *item)


static void _init_f_removeItem_2557 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeItem_2557 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = args.read<QGraphicsLayoutItem * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->removeItem (arg1);
}


// void QGraphicsLinearLayout::setAlignment(QGraphicsLayoutItem *item, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setAlignment_5199 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setAlignment_5199 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = args.read<QGraphicsLayoutItem * > (heap);
  QFlags<Qt::AlignmentFlag> arg2 = args.read<QFlags<Qt::AlignmentFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->setAlignment (arg1, arg2);
}


// (const QRectF &)


static void _init_f_setGeometry_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->setGeometry (arg1);
}


// void QGraphicsLinearLayout::setItemSpacing(int index, double spacing)


static void _init_f_setItemSpacing_1730 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("spacing");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setItemSpacing_1730 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  double arg2 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->setItemSpacing (arg1, arg2);
}


// void QGraphicsLinearLayout::setOrientation(Qt::Orientation orientation)


static void _init_f_setOrientation_1913 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrientation_1913 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->setOrientation (qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg1).cref());
}


// void QGraphicsLinearLayout::setSpacing(double spacing)


static void _init_f_setSpacing_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSpacing_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->setSpacing (arg1);
}


// void QGraphicsLinearLayout::setStretchFactor(QGraphicsLayoutItem *item, int stretch)


static void _init_f_setStretchFactor_3216 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stretch");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setStretchFactor_3216 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = args.read<QGraphicsLayoutItem * > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout *)cls)->setStretchFactor (arg1, arg2);
}


// (Qt::SizeHint, const QSizeF &) const


static void _init_f_sizeHint_c3330 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("constraint", true, "QSizeF()");
  decl->add_arg<const QSizeF & > (argspec_1);
  decl->set_return<QSizeF > ();
}

static void _call_f_sizeHint_c3330 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeHint>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (heap);
  const QSizeF &arg2 = args ? args.read<const QSizeF & > (heap) : (const QSizeF &)(QSizeF());
  ret.write<QSizeF > ((QSizeF)((QGraphicsLinearLayout *)cls)->sizeHint (qt_gsi::QtToCppAdaptor<Qt::SizeHint>(arg1).cref(), arg2));
}


// double QGraphicsLinearLayout::spacing()


static void _init_f_spacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_spacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QGraphicsLinearLayout *)cls)->spacing ());
}


// int QGraphicsLinearLayout::stretchFactor(QGraphicsLayoutItem *item)


static void _init_f_stretchFactor_c2557 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_stretchFactor_c2557 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = args.read<QGraphicsLayoutItem * > (heap);
  ret.write<int > ((int)((QGraphicsLinearLayout *)cls)->stretchFactor (arg1));
}


namespace gsi
{

static gsi::Methods methods_QGraphicsLinearLayout () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("addItem", "@brief Method void QGraphicsLinearLayout::addItem(QGraphicsLayoutItem *item)\n", false, &_init_f_addItem_2557, &_call_f_addItem_2557);
  methods += new qt_gsi::GenericMethod ("addStretch", "@brief Method void QGraphicsLinearLayout::addStretch(int stretch)\n", false, &_init_f_addStretch_767, &_call_f_addStretch_767);
  methods += new qt_gsi::GenericMethod ("alignment", "@brief Method QFlags<Qt::AlignmentFlag> QGraphicsLinearLayout::alignment(QGraphicsLayoutItem *item)\n", true, &_init_f_alignment_c2557, &_call_f_alignment_c2557);
  methods += new qt_gsi::GenericMethod ("count", "@brief Method () const\nThis is a reimplementation of QGraphicsLayout::count", true, &_init_f_count_c0, &_call_f_count_c0);
  methods += new qt_gsi::GenericMethod ("dump", "@brief Method void QGraphicsLinearLayout::dump(int indent)\n", true, &_init_f_dump_c767, &_call_f_dump_c767);
  methods += new qt_gsi::GenericMethod ("insertItem", "@brief Method void QGraphicsLinearLayout::insertItem(int index, QGraphicsLayoutItem *item)\n", false, &_init_f_insertItem_3216, &_call_f_insertItem_3216);
  methods += new qt_gsi::GenericMethod ("insertStretch", "@brief Method void QGraphicsLinearLayout::insertStretch(int index, int stretch)\n", false, &_init_f_insertStretch_1426, &_call_f_insertStretch_1426);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Method ()\nThis is a reimplementation of QGraphicsLayout::invalidate", false, &_init_f_invalidate_0, &_call_f_invalidate_0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method (int) const\nThis is a reimplementation of QGraphicsLayout::itemAt", true, &_init_f_itemAt_c767, &_call_f_itemAt_c767);
  methods += new qt_gsi::GenericMethod ("itemSpacing", "@brief Method double QGraphicsLinearLayout::itemSpacing(int index)\n", true, &_init_f_itemSpacing_c767, &_call_f_itemSpacing_c767);
  methods += new qt_gsi::GenericMethod (":orientation", "@brief Method Qt::Orientation QGraphicsLinearLayout::orientation()\n", true, &_init_f_orientation_c0, &_call_f_orientation_c0);
  methods += new qt_gsi::GenericMethod ("removeAt", "@brief Method (int)\nThis is a reimplementation of QGraphicsLayout::removeAt", false, &_init_f_removeAt_767, &_call_f_removeAt_767);
  methods += new qt_gsi::GenericMethod ("removeItem", "@brief Method void QGraphicsLinearLayout::removeItem(QGraphicsLayoutItem *item)\n", false, &_init_f_removeItem_2557, &_call_f_removeItem_2557);
  methods += new qt_gsi::GenericMethod ("setAlignment", "@brief Method void QGraphicsLinearLayout::setAlignment(QGraphicsLayoutItem *item, QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setAlignment_5199, &_call_f_setAlignment_5199);
  methods += new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method (const QRectF &)\nThis is a reimplementation of QGraphicsLayoutItem::setGeometry", false, &_init_f_setGeometry_1862, &_call_f_setGeometry_1862);
  methods += new qt_gsi::GenericMethod ("setItemSpacing", "@brief Method void QGraphicsLinearLayout::setItemSpacing(int index, double spacing)\n", false, &_init_f_setItemSpacing_1730, &_call_f_setItemSpacing_1730);
  methods += new qt_gsi::GenericMethod ("setOrientation|orientation=", "@brief Method void QGraphicsLinearLayout::setOrientation(Qt::Orientation orientation)\n", false, &_init_f_setOrientation_1913, &_call_f_setOrientation_1913);
  methods += new qt_gsi::GenericMethod ("setSpacing|spacing=", "@brief Method void QGraphicsLinearLayout::setSpacing(double spacing)\n", false, &_init_f_setSpacing_1071, &_call_f_setSpacing_1071);
  methods += new qt_gsi::GenericMethod ("setStretchFactor", "@brief Method void QGraphicsLinearLayout::setStretchFactor(QGraphicsLayoutItem *item, int stretch)\n", false, &_init_f_setStretchFactor_3216, &_call_f_setStretchFactor_3216);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Method (Qt::SizeHint, const QSizeF &) const\nThis is a reimplementation of QGraphicsLayoutItem::sizeHint", true, &_init_f_sizeHint_c3330, &_call_f_sizeHint_c3330);
  methods += new qt_gsi::GenericMethod (":spacing", "@brief Method double QGraphicsLinearLayout::spacing()\n", true, &_init_f_spacing_c0, &_call_f_spacing_c0);
  methods += new qt_gsi::GenericMethod ("stretchFactor", "@brief Method int QGraphicsLinearLayout::stretchFactor(QGraphicsLayoutItem *item)\n", true, &_init_f_stretchFactor_c2557, &_call_f_stretchFactor_c2557);
  return methods;
}

gsi::Class<QGraphicsLayout> &qtdecl_QGraphicsLayout ();

gsi::Class<QGraphicsLinearLayout> decl_QGraphicsLinearLayout (qtdecl_QGraphicsLayout (), "QGraphicsLinearLayout_Native",
  methods_QGraphicsLinearLayout (),
  "@hide\n@alias QGraphicsLinearLayout");

GSIQT_PUBLIC gsi::Class<QGraphicsLinearLayout> &qtdecl_QGraphicsLinearLayout () { return decl_QGraphicsLinearLayout; }

}


class QGraphicsLinearLayout_Adaptor : public QGraphicsLinearLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsLinearLayout_Adaptor();

  //  [adaptor ctor] QGraphicsLinearLayout::QGraphicsLinearLayout(QGraphicsLayoutItem *parent)
  QGraphicsLinearLayout_Adaptor() : QGraphicsLinearLayout()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsLinearLayout::QGraphicsLinearLayout(QGraphicsLayoutItem *parent)
  QGraphicsLinearLayout_Adaptor(QGraphicsLayoutItem *parent) : QGraphicsLinearLayout(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsLinearLayout::QGraphicsLinearLayout(Qt::Orientation orientation, QGraphicsLayoutItem *parent)
  QGraphicsLinearLayout_Adaptor(Qt::Orientation orientation) : QGraphicsLinearLayout(orientation)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsLinearLayout::QGraphicsLinearLayout(Qt::Orientation orientation, QGraphicsLayoutItem *parent)
  QGraphicsLinearLayout_Adaptor(Qt::Orientation orientation, QGraphicsLayoutItem *parent) : QGraphicsLinearLayout(orientation, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QGraphicsLinearLayout::addChildLayoutItem(QGraphicsLayoutItem *layoutItem)
  void fp_QGraphicsLinearLayout_addChildLayoutItem_2557 (QGraphicsLayoutItem *layoutItem) {
    QGraphicsLinearLayout::addChildLayoutItem(layoutItem);
  }

  //  [expose] void QGraphicsLinearLayout::setGraphicsItem(QGraphicsItem *item)
  void fp_QGraphicsLinearLayout_setGraphicsItem_1919 (QGraphicsItem *item) {
    QGraphicsLinearLayout::setGraphicsItem(item);
  }

  //  [expose] void QGraphicsLinearLayout::setOwnedByLayout(bool ownedByLayout)
  void fp_QGraphicsLinearLayout_setOwnedByLayout_864 (bool ownedByLayout) {
    QGraphicsLinearLayout::setOwnedByLayout(ownedByLayout);
  }

  //  [adaptor impl] int QGraphicsLinearLayout::count()
  int cbs_count_c0_0() const
  {
    return QGraphicsLinearLayout::count();
  }

  virtual int count() const
  {
    if (cb_count_c0_0.can_issue()) {
      return cb_count_c0_0.issue<QGraphicsLinearLayout_Adaptor, int>(&QGraphicsLinearLayout_Adaptor::cbs_count_c0_0);
    } else {
      return QGraphicsLinearLayout::count();
    }
  }

  //  [adaptor impl] void QGraphicsLinearLayout::getContentsMargins(double *left, double *top, double *right, double *bottom)
  void cbs_getContentsMargins_c4704_0(double *left, double *top, double *right, double *bottom) const
  {
    QGraphicsLinearLayout::getContentsMargins(left, top, right, bottom);
  }

  virtual void getContentsMargins(double *left, double *top, double *right, double *bottom) const
  {
    if (cb_getContentsMargins_c4704_0.can_issue()) {
      cb_getContentsMargins_c4704_0.issue<QGraphicsLinearLayout_Adaptor, double *, double *, double *, double *>(&QGraphicsLinearLayout_Adaptor::cbs_getContentsMargins_c4704_0, left, top, right, bottom);
    } else {
      QGraphicsLinearLayout::getContentsMargins(left, top, right, bottom);
    }
  }

  //  [adaptor impl] void QGraphicsLinearLayout::invalidate()
  void cbs_invalidate_0_0()
  {
    QGraphicsLinearLayout::invalidate();
  }

  virtual void invalidate()
  {
    if (cb_invalidate_0_0.can_issue()) {
      cb_invalidate_0_0.issue<QGraphicsLinearLayout_Adaptor>(&QGraphicsLinearLayout_Adaptor::cbs_invalidate_0_0);
    } else {
      QGraphicsLinearLayout::invalidate();
    }
  }

  //  [adaptor impl] QGraphicsLayoutItem *QGraphicsLinearLayout::itemAt(int index)
  QGraphicsLayoutItem * cbs_itemAt_c767_0(int index) const
  {
    return QGraphicsLinearLayout::itemAt(index);
  }

  virtual QGraphicsLayoutItem * itemAt(int index) const
  {
    if (cb_itemAt_c767_0.can_issue()) {
      return cb_itemAt_c767_0.issue<QGraphicsLinearLayout_Adaptor, QGraphicsLayoutItem *, int>(&QGraphicsLinearLayout_Adaptor::cbs_itemAt_c767_0, index);
    } else {
      return QGraphicsLinearLayout::itemAt(index);
    }
  }

  //  [adaptor impl] void QGraphicsLinearLayout::removeAt(int index)
  void cbs_removeAt_767_0(int index)
  {
    QGraphicsLinearLayout::removeAt(index);
  }

  virtual void removeAt(int index)
  {
    if (cb_removeAt_767_0.can_issue()) {
      cb_removeAt_767_0.issue<QGraphicsLinearLayout_Adaptor, int>(&QGraphicsLinearLayout_Adaptor::cbs_removeAt_767_0, index);
    } else {
      QGraphicsLinearLayout::removeAt(index);
    }
  }

  //  [adaptor impl] void QGraphicsLinearLayout::setGeometry(const QRectF &rect)
  void cbs_setGeometry_1862_0(const QRectF &rect)
  {
    QGraphicsLinearLayout::setGeometry(rect);
  }

  virtual void setGeometry(const QRectF &rect)
  {
    if (cb_setGeometry_1862_0.can_issue()) {
      cb_setGeometry_1862_0.issue<QGraphicsLinearLayout_Adaptor, const QRectF &>(&QGraphicsLinearLayout_Adaptor::cbs_setGeometry_1862_0, rect);
    } else {
      QGraphicsLinearLayout::setGeometry(rect);
    }
  }

  //  [adaptor impl] QSizeF QGraphicsLinearLayout::sizeHint(Qt::SizeHint which, const QSizeF &constraint)
  QSizeF cbs_sizeHint_c3330_1(const qt_gsi::Converter<Qt::SizeHint>::target_type & which, const QSizeF &constraint) const
  {
    return QGraphicsLinearLayout::sizeHint(qt_gsi::QtToCppAdaptor<Qt::SizeHint>(which).cref(), constraint);
  }

  virtual QSizeF sizeHint(Qt::SizeHint which, const QSizeF &constraint) const
  {
    if (cb_sizeHint_c3330_1.can_issue()) {
      return cb_sizeHint_c3330_1.issue<QGraphicsLinearLayout_Adaptor, QSizeF, const qt_gsi::Converter<Qt::SizeHint>::target_type &, const QSizeF &>(&QGraphicsLinearLayout_Adaptor::cbs_sizeHint_c3330_1, qt_gsi::CppToQtAdaptor<Qt::SizeHint>(which), constraint);
    } else {
      return QGraphicsLinearLayout::sizeHint(which, constraint);
    }
  }

  //  [adaptor impl] void QGraphicsLinearLayout::updateGeometry()
  void cbs_updateGeometry_0_0()
  {
    QGraphicsLinearLayout::updateGeometry();
  }

  virtual void updateGeometry()
  {
    if (cb_updateGeometry_0_0.can_issue()) {
      cb_updateGeometry_0_0.issue<QGraphicsLinearLayout_Adaptor>(&QGraphicsLinearLayout_Adaptor::cbs_updateGeometry_0_0);
    } else {
      QGraphicsLinearLayout::updateGeometry();
    }
  }

  //  [adaptor impl] void QGraphicsLinearLayout::widgetEvent(QEvent *e)
  void cbs_widgetEvent_1217_0(QEvent *e)
  {
    QGraphicsLinearLayout::widgetEvent(e);
  }

  virtual void widgetEvent(QEvent *e)
  {
    if (cb_widgetEvent_1217_0.can_issue()) {
      cb_widgetEvent_1217_0.issue<QGraphicsLinearLayout_Adaptor, QEvent *>(&QGraphicsLinearLayout_Adaptor::cbs_widgetEvent_1217_0, e);
    } else {
      QGraphicsLinearLayout::widgetEvent(e);
    }
  }

  gsi::Callback cb_count_c0_0;
  gsi::Callback cb_getContentsMargins_c4704_0;
  gsi::Callback cb_invalidate_0_0;
  gsi::Callback cb_itemAt_c767_0;
  gsi::Callback cb_removeAt_767_0;
  gsi::Callback cb_setGeometry_1862_0;
  gsi::Callback cb_sizeHint_c3330_1;
  gsi::Callback cb_updateGeometry_0_0;
  gsi::Callback cb_widgetEvent_1217_0;
};

QGraphicsLinearLayout_Adaptor::~QGraphicsLinearLayout_Adaptor() { }

//  Constructor QGraphicsLinearLayout::QGraphicsLinearLayout(QGraphicsLayoutItem *parent) (adaptor class)

static void _init_ctor_QGraphicsLinearLayout_Adaptor_2557 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  decl->set_return_new<QGraphicsLinearLayout_Adaptor> ();
}

static void _call_ctor_QGraphicsLinearLayout_Adaptor_2557 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = args ? args.read<QGraphicsLayoutItem * > (heap) : (QGraphicsLayoutItem *)(0);
  ret.write<QGraphicsLinearLayout_Adaptor *> (new QGraphicsLinearLayout_Adaptor (arg1));
}


//  Constructor QGraphicsLinearLayout::QGraphicsLinearLayout(Qt::Orientation orientation, QGraphicsLayoutItem *parent) (adaptor class)

static void _init_ctor_QGraphicsLinearLayout_Adaptor_4362 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_1);
  decl->set_return_new<QGraphicsLinearLayout_Adaptor> ();
}

static void _call_ctor_QGraphicsLinearLayout_Adaptor_4362 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > (heap);
  QGraphicsLayoutItem *arg2 = args ? args.read<QGraphicsLayoutItem * > (heap) : (QGraphicsLayoutItem *)(0);
  ret.write<QGraphicsLinearLayout_Adaptor *> (new QGraphicsLinearLayout_Adaptor (qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg1).cref(), arg2));
}


// exposed void QGraphicsLinearLayout::addChildLayoutItem(QGraphicsLayoutItem *layoutItem)

static void _init_fp_addChildLayoutItem_2557 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layoutItem");
  decl->add_arg<QGraphicsLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildLayoutItem_2557 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsLayoutItem *arg1 = args.read<QGraphicsLayoutItem * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout_Adaptor *)cls)->fp_QGraphicsLinearLayout_addChildLayoutItem_2557 (arg1);
}


// int QGraphicsLinearLayout::count()

static void _init_cbs_count_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_count_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QGraphicsLinearLayout_Adaptor *)cls)->cbs_count_c0_0 ());
}

static void _set_callback_cbs_count_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLinearLayout_Adaptor *)cls)->cb_count_c0_0 = cb;
}


// void QGraphicsLinearLayout::getContentsMargins(double *left, double *top, double *right, double *bottom)

static void _init_cbs_getContentsMargins_c4704_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_getContentsMargins_c4704_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double *arg1 = args.read<double * > (heap);
  double *arg2 = args.read<double * > (heap);
  double *arg3 = args.read<double * > (heap);
  double *arg4 = args.read<double * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout_Adaptor *)cls)->cbs_getContentsMargins_c4704_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_getContentsMargins_c4704_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLinearLayout_Adaptor *)cls)->cb_getContentsMargins_c4704_0 = cb;
}


// void QGraphicsLinearLayout::invalidate()

static void _init_cbs_invalidate_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_invalidate_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout_Adaptor *)cls)->cbs_invalidate_0_0 ();
}

static void _set_callback_cbs_invalidate_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLinearLayout_Adaptor *)cls)->cb_invalidate_0_0 = cb;
}


// QGraphicsLayoutItem *QGraphicsLinearLayout::itemAt(int index)

static void _init_cbs_itemAt_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QGraphicsLayoutItem * > ();
}

static void _call_cbs_itemAt_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QGraphicsLayoutItem * > ((QGraphicsLayoutItem *)((QGraphicsLinearLayout_Adaptor *)cls)->cbs_itemAt_c767_0 (arg1));
}

static void _set_callback_cbs_itemAt_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLinearLayout_Adaptor *)cls)->cb_itemAt_c767_0 = cb;
}


// void QGraphicsLinearLayout::removeAt(int index)

static void _init_cbs_removeAt_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_removeAt_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout_Adaptor *)cls)->cbs_removeAt_767_0 (arg1);
}

static void _set_callback_cbs_removeAt_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLinearLayout_Adaptor *)cls)->cb_removeAt_767_0 = cb;
}


// void QGraphicsLinearLayout::setGeometry(const QRectF &rect)

static void _init_cbs_setGeometry_1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1862_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout_Adaptor *)cls)->cbs_setGeometry_1862_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLinearLayout_Adaptor *)cls)->cb_setGeometry_1862_0 = cb;
}


// exposed void QGraphicsLinearLayout::setGraphicsItem(QGraphicsItem *item)

static void _init_fp_setGraphicsItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setGraphicsItem_1919 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout_Adaptor *)cls)->fp_QGraphicsLinearLayout_setGraphicsItem_1919 (arg1);
}


// exposed void QGraphicsLinearLayout::setOwnedByLayout(bool ownedByLayout)

static void _init_fp_setOwnedByLayout_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ownedByLayout");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setOwnedByLayout_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout_Adaptor *)cls)->fp_QGraphicsLinearLayout_setOwnedByLayout_864 (arg1);
}


// QSizeF QGraphicsLinearLayout::sizeHint(Qt::SizeHint which, const QSizeF &constraint)

static void _init_cbs_sizeHint_c3330_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("constraint");
  decl->add_arg<const QSizeF & > (argspec_1);
  decl->set_return<QSizeF > ();
}

static void _call_cbs_sizeHint_c3330_1 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SizeHint>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (heap);
  const QSizeF &arg2 = args.read<const QSizeF & > (heap);
  ret.write<QSizeF > ((QSizeF)((QGraphicsLinearLayout_Adaptor *)cls)->cbs_sizeHint_c3330_1 (arg1, arg2));
}

static void _set_callback_cbs_sizeHint_c3330_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLinearLayout_Adaptor *)cls)->cb_sizeHint_c3330_1 = cb;
}


// void QGraphicsLinearLayout::updateGeometry()

static void _init_cbs_updateGeometry_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometry_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout_Adaptor *)cls)->cbs_updateGeometry_0_0 ();
}

static void _set_callback_cbs_updateGeometry_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLinearLayout_Adaptor *)cls)->cb_updateGeometry_0_0 = cb;
}


// void QGraphicsLinearLayout::widgetEvent(QEvent *e)

static void _init_cbs_widgetEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_widgetEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QGraphicsLinearLayout_Adaptor *)cls)->cbs_widgetEvent_1217_0 (arg1);
}

static void _set_callback_cbs_widgetEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsLinearLayout_Adaptor *)cls)->cb_widgetEvent_1217_0 = cb;
}


namespace gsi
{

gsi::Class<QGraphicsLinearLayout> &qtdecl_QGraphicsLinearLayout ();

static gsi::Methods methods_QGraphicsLinearLayout_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsLinearLayout::QGraphicsLinearLayout(QGraphicsLayoutItem *parent)\nThis method creates an object of class QGraphicsLinearLayout.", &_init_ctor_QGraphicsLinearLayout_Adaptor_2557, &_call_ctor_QGraphicsLinearLayout_Adaptor_2557);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsLinearLayout::QGraphicsLinearLayout(Qt::Orientation orientation, QGraphicsLayoutItem *parent)\nThis method creates an object of class QGraphicsLinearLayout.", &_init_ctor_QGraphicsLinearLayout_Adaptor_4362, &_call_ctor_QGraphicsLinearLayout_Adaptor_4362);
  methods += new qt_gsi::GenericMethod ("*addChildLayoutItem", "@brief Method void QGraphicsLinearLayout::addChildLayoutItem(QGraphicsLayoutItem *layoutItem)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildLayoutItem_2557, &_call_fp_addChildLayoutItem_2557);
  methods += new qt_gsi::GenericMethod ("count", "@hide", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0);
  methods += new qt_gsi::GenericMethod ("count", "@brief Virtual method int QGraphicsLinearLayout::count()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0, &_set_callback_cbs_count_c0_0);
  methods += new qt_gsi::GenericMethod ("getContentsMargins", "@hide", true, &_init_cbs_getContentsMargins_c4704_0, &_call_cbs_getContentsMargins_c4704_0);
  methods += new qt_gsi::GenericMethod ("getContentsMargins", "@brief Virtual method void QGraphicsLinearLayout::getContentsMargins(double *left, double *top, double *right, double *bottom)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_getContentsMargins_c4704_0, &_call_cbs_getContentsMargins_c4704_0, &_set_callback_cbs_getContentsMargins_c4704_0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@hide", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Virtual method void QGraphicsLinearLayout::invalidate()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0, &_set_callback_cbs_invalidate_0_0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@hide", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Virtual method QGraphicsLayoutItem *QGraphicsLinearLayout::itemAt(int index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0, &_set_callback_cbs_itemAt_c767_0);
  methods += new qt_gsi::GenericMethod ("removeAt", "@hide", false, &_init_cbs_removeAt_767_0, &_call_cbs_removeAt_767_0);
  methods += new qt_gsi::GenericMethod ("removeAt", "@brief Virtual method void QGraphicsLinearLayout::removeAt(int index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeAt_767_0, &_call_cbs_removeAt_767_0, &_set_callback_cbs_removeAt_767_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1862_0, &_call_cbs_setGeometry_1862_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QGraphicsLinearLayout::setGeometry(const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1862_0, &_call_cbs_setGeometry_1862_0, &_set_callback_cbs_setGeometry_1862_0);
  methods += new qt_gsi::GenericMethod ("*setGraphicsItem", "@brief Method void QGraphicsLinearLayout::setGraphicsItem(QGraphicsItem *item)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setGraphicsItem_1919, &_call_fp_setGraphicsItem_1919);
  methods += new qt_gsi::GenericMethod ("*setOwnedByLayout", "@brief Method void QGraphicsLinearLayout::setOwnedByLayout(bool ownedByLayout)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setOwnedByLayout_864, &_call_fp_setOwnedByLayout_864);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c3330_1, &_call_cbs_sizeHint_c3330_1);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSizeF QGraphicsLinearLayout::sizeHint(Qt::SizeHint which, const QSizeF &constraint)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c3330_1, &_call_cbs_sizeHint_c3330_1, &_set_callback_cbs_sizeHint_c3330_1);
  methods += new qt_gsi::GenericMethod ("updateGeometry", "@hide", false, &_init_cbs_updateGeometry_0_0, &_call_cbs_updateGeometry_0_0);
  methods += new qt_gsi::GenericMethod ("updateGeometry", "@brief Virtual method void QGraphicsLinearLayout::updateGeometry()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometry_0_0, &_call_cbs_updateGeometry_0_0, &_set_callback_cbs_updateGeometry_0_0);
  methods += new qt_gsi::GenericMethod ("widgetEvent", "@hide", false, &_init_cbs_widgetEvent_1217_0, &_call_cbs_widgetEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("widgetEvent", "@brief Virtual method void QGraphicsLinearLayout::widgetEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_widgetEvent_1217_0, &_call_cbs_widgetEvent_1217_0, &_set_callback_cbs_widgetEvent_1217_0);
  return methods;
}

gsi::Class<QGraphicsLinearLayout_Adaptor> decl_QGraphicsLinearLayout_Adaptor (qtdecl_QGraphicsLinearLayout (), "QGraphicsLinearLayout",
  methods_QGraphicsLinearLayout_Adaptor (),
  "@qt\n@brief Binding of QGraphicsLinearLayout");

}

