
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPagedPaintDevice.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPagedPaintDevice>
#include <QMarginsF>
#include <QPageLayout>
#include <QPageSize>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPainter>
#include <QPoint>
#include <QSizeF>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPagedPaintDevice

// QPagedPaintDevice::Margins QPagedPaintDevice::margins()


static void _init_f_margins_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPagedPaintDevice::Margins > ();
}

static void _call_f_margins_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPagedPaintDevice::Margins > ((QPagedPaintDevice::Margins)((QPagedPaintDevice *)cls)->margins ());
}


// bool QPagedPaintDevice::newPage()


static void _init_f_newPage_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_newPage_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPagedPaintDevice *)cls)->newPage ());
}


// QPageLayout QPagedPaintDevice::pageLayout()


static void _init_f_pageLayout_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPageLayout > ();
}

static void _call_f_pageLayout_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPageLayout > ((QPageLayout)((QPagedPaintDevice *)cls)->pageLayout ());
}


// QPagedPaintDevice::PageSize QPagedPaintDevice::pageSize()


static void _init_f_pageSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type > ();
}

static void _call_f_pageSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type > ((qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type)qt_gsi::CppToQtAdaptor<QPagedPaintDevice::PageSize>(((QPagedPaintDevice *)cls)->pageSize ()));
}


// QSizeF QPagedPaintDevice::pageSizeMM()


static void _init_f_pageSizeMM_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_pageSizeMM_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSizeF > ((QSizeF)((QPagedPaintDevice *)cls)->pageSizeMM ());
}


// void QPagedPaintDevice::setMargins(const QPagedPaintDevice::Margins &margins)


static void _init_f_setMargins_3812 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QPagedPaintDevice::Margins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMargins_3812 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPagedPaintDevice::Margins &arg1 = args.read<const QPagedPaintDevice::Margins & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPagedPaintDevice *)cls)->setMargins (arg1);
}


// bool QPagedPaintDevice::setPageLayout(const QPageLayout &pageLayout)


static void _init_f_setPageLayout_2413 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageLayout");
  decl->add_arg<const QPageLayout & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setPageLayout_2413 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPageLayout &arg1 = args.read<const QPageLayout & > (heap);
  ret.write<bool > ((bool)((QPagedPaintDevice *)cls)->setPageLayout (arg1));
}


// bool QPagedPaintDevice::setPageMargins(const QMarginsF &margins)


static void _init_f_setPageMargins_2185 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMarginsF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setPageMargins_2185 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMarginsF &arg1 = args.read<const QMarginsF & > (heap);
  ret.write<bool > ((bool)((QPagedPaintDevice *)cls)->setPageMargins (arg1));
}


// bool QPagedPaintDevice::setPageMargins(const QMarginsF &margins, QPageLayout::Unit units)


static void _init_f_setPageMargins_4145 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMarginsF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("units");
  decl->add_arg<const qt_gsi::Converter<QPageLayout::Unit>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setPageMargins_4145 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMarginsF &arg1 = args.read<const QMarginsF & > (heap);
  const qt_gsi::Converter<QPageLayout::Unit>::target_type & arg2 = args.read<const qt_gsi::Converter<QPageLayout::Unit>::target_type & > (heap);
  ret.write<bool > ((bool)((QPagedPaintDevice *)cls)->setPageMargins (arg1, qt_gsi::QtToCppAdaptor<QPageLayout::Unit>(arg2).cref()));
}


// bool QPagedPaintDevice::setPageOrientation(QPageLayout::Orientation orientation)


static void _init_f_setPageOrientation_2816 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<QPageLayout::Orientation>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setPageOrientation_2816 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPageLayout::Orientation>::target_type & arg1 = args.read<const qt_gsi::Converter<QPageLayout::Orientation>::target_type & > (heap);
  ret.write<bool > ((bool)((QPagedPaintDevice *)cls)->setPageOrientation (qt_gsi::QtToCppAdaptor<QPageLayout::Orientation>(arg1).cref()));
}


// bool QPagedPaintDevice::setPageSize(const QPageSize &pageSize)


static void _init_f_setPageSize_2186 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pageSize");
  decl->add_arg<const QPageSize & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_setPageSize_2186 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPageSize &arg1 = args.read<const QPageSize & > (heap);
  ret.write<bool > ((bool)((QPagedPaintDevice *)cls)->setPageSize (arg1));
}


// void QPagedPaintDevice::setPageSize(QPagedPaintDevice::PageSize size)


static void _init_f_setPageSize_3006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPageSize_3006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & arg1 = args.read<const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPagedPaintDevice *)cls)->setPageSize (qt_gsi::QtToCppAdaptor<QPagedPaintDevice::PageSize>(arg1).cref());
}


// void QPagedPaintDevice::setPageSizeMM(const QSizeF &size)


static void _init_f_setPageSizeMM_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPageSizeMM_1875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = args.read<const QSizeF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPagedPaintDevice *)cls)->setPageSizeMM (arg1);
}


namespace gsi
{

static gsi::Methods methods_QPagedPaintDevice () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod (":margins", "@brief Method QPagedPaintDevice::Margins QPagedPaintDevice::margins()\n", true, &_init_f_margins_c0, &_call_f_margins_c0);
  methods += new qt_gsi::GenericMethod ("newPage", "@brief Method bool QPagedPaintDevice::newPage()\n", false, &_init_f_newPage_0, &_call_f_newPage_0);
  methods += new qt_gsi::GenericMethod ("pageLayout", "@brief Method QPageLayout QPagedPaintDevice::pageLayout()\n", true, &_init_f_pageLayout_c0, &_call_f_pageLayout_c0);
  methods += new qt_gsi::GenericMethod (":pageSize", "@brief Method QPagedPaintDevice::PageSize QPagedPaintDevice::pageSize()\n", true, &_init_f_pageSize_c0, &_call_f_pageSize_c0);
  methods += new qt_gsi::GenericMethod (":pageSizeMM", "@brief Method QSizeF QPagedPaintDevice::pageSizeMM()\n", true, &_init_f_pageSizeMM_c0, &_call_f_pageSizeMM_c0);
  methods += new qt_gsi::GenericMethod ("setMargins|margins=", "@brief Method void QPagedPaintDevice::setMargins(const QPagedPaintDevice::Margins &margins)\n", false, &_init_f_setMargins_3812, &_call_f_setMargins_3812);
  methods += new qt_gsi::GenericMethod ("setPageLayout", "@brief Method bool QPagedPaintDevice::setPageLayout(const QPageLayout &pageLayout)\n", false, &_init_f_setPageLayout_2413, &_call_f_setPageLayout_2413);
  methods += new qt_gsi::GenericMethod ("setPageMargins", "@brief Method bool QPagedPaintDevice::setPageMargins(const QMarginsF &margins)\n", false, &_init_f_setPageMargins_2185, &_call_f_setPageMargins_2185);
  methods += new qt_gsi::GenericMethod ("setPageMargins", "@brief Method bool QPagedPaintDevice::setPageMargins(const QMarginsF &margins, QPageLayout::Unit units)\n", false, &_init_f_setPageMargins_4145, &_call_f_setPageMargins_4145);
  methods += new qt_gsi::GenericMethod ("setPageOrientation", "@brief Method bool QPagedPaintDevice::setPageOrientation(QPageLayout::Orientation orientation)\n", false, &_init_f_setPageOrientation_2816, &_call_f_setPageOrientation_2816);
  methods += new qt_gsi::GenericMethod ("setPageSize|pageSize=", "@brief Method bool QPagedPaintDevice::setPageSize(const QPageSize &pageSize)\n", false, &_init_f_setPageSize_2186, &_call_f_setPageSize_2186);
  methods += new qt_gsi::GenericMethod ("setPageSize|pageSize=", "@brief Method void QPagedPaintDevice::setPageSize(QPagedPaintDevice::PageSize size)\n", false, &_init_f_setPageSize_3006, &_call_f_setPageSize_3006);
  methods += new qt_gsi::GenericMethod ("setPageSizeMM|pageSizeMM=", "@brief Method void QPagedPaintDevice::setPageSizeMM(const QSizeF &size)\n", false, &_init_f_setPageSizeMM_1875, &_call_f_setPageSizeMM_1875);
  return methods;
}

gsi::Class<QPaintDevice> &qtdecl_QPaintDevice ();

gsi::Class<QPagedPaintDevice> decl_QPagedPaintDevice (qtdecl_QPaintDevice (), "QPagedPaintDevice_Native",
  methods_QPagedPaintDevice (),
  "@hide\n@alias QPagedPaintDevice");

GSIQT_PUBLIC gsi::Class<QPagedPaintDevice> &qtdecl_QPagedPaintDevice () { return decl_QPagedPaintDevice; }

}


class QPagedPaintDevice_Adaptor : public QPagedPaintDevice, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPagedPaintDevice_Adaptor();

  //  [adaptor ctor] QPagedPaintDevice::QPagedPaintDevice()
  QPagedPaintDevice_Adaptor() : QPagedPaintDevice()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] QPageLayout QPagedPaintDevice::devicePageLayout()
  QPageLayout fp_QPagedPaintDevice_devicePageLayout_c0 () const {
    return QPagedPaintDevice::devicePageLayout();
  }

  //  [expose] QPageLayout &QPagedPaintDevice::devicePageLayout()
  QPageLayout & fp_QPagedPaintDevice_devicePageLayout_0 () {
    return QPagedPaintDevice::devicePageLayout();
  }

  //  [adaptor impl] bool QPagedPaintDevice::newPage()
  bool cbs_newPage_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("newPage");
  }

  virtual bool newPage()
  {
    if (cb_newPage_0_0.can_issue()) {
      return cb_newPage_0_0.issue<QPagedPaintDevice_Adaptor, bool>(&QPagedPaintDevice_Adaptor::cbs_newPage_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("newPage");
    }
  }

  //  [adaptor impl] QPaintEngine *QPagedPaintDevice::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("paintEngine");
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QPagedPaintDevice_Adaptor, QPaintEngine *>(&QPagedPaintDevice_Adaptor::cbs_paintEngine_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("paintEngine");
    }
  }

  //  [adaptor impl] void QPagedPaintDevice::setMargins(const QPagedPaintDevice::Margins &margins)
  void cbs_setMargins_3812_0(const QPagedPaintDevice::Margins &margins)
  {
    QPagedPaintDevice::setMargins(margins);
  }

  virtual void setMargins(const QPagedPaintDevice::Margins &margins)
  {
    if (cb_setMargins_3812_0.can_issue()) {
      cb_setMargins_3812_0.issue<QPagedPaintDevice_Adaptor, const QPagedPaintDevice::Margins &>(&QPagedPaintDevice_Adaptor::cbs_setMargins_3812_0, margins);
    } else {
      QPagedPaintDevice::setMargins(margins);
    }
  }

  //  [adaptor impl] void QPagedPaintDevice::setPageSize(QPagedPaintDevice::PageSize size)
  void cbs_setPageSize_3006_0(const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & size)
  {
    QPagedPaintDevice::setPageSize(qt_gsi::QtToCppAdaptor<QPagedPaintDevice::PageSize>(size).cref());
  }

  virtual void setPageSize(QPagedPaintDevice::PageSize size)
  {
    if (cb_setPageSize_3006_0.can_issue()) {
      cb_setPageSize_3006_0.issue<QPagedPaintDevice_Adaptor, const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type &>(&QPagedPaintDevice_Adaptor::cbs_setPageSize_3006_0, qt_gsi::CppToQtAdaptor<QPagedPaintDevice::PageSize>(size));
    } else {
      QPagedPaintDevice::setPageSize(size);
    }
  }

  //  [adaptor impl] void QPagedPaintDevice::setPageSizeMM(const QSizeF &size)
  void cbs_setPageSizeMM_1875_0(const QSizeF &size)
  {
    QPagedPaintDevice::setPageSizeMM(size);
  }

  virtual void setPageSizeMM(const QSizeF &size)
  {
    if (cb_setPageSizeMM_1875_0.can_issue()) {
      cb_setPageSizeMM_1875_0.issue<QPagedPaintDevice_Adaptor, const QSizeF &>(&QPagedPaintDevice_Adaptor::cbs_setPageSizeMM_1875_0, size);
    } else {
      QPagedPaintDevice::setPageSizeMM(size);
    }
  }

  //  [adaptor impl] void QPagedPaintDevice::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QPagedPaintDevice::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QPagedPaintDevice_Adaptor, QPainter *>(&QPagedPaintDevice_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QPagedPaintDevice::initPainter(painter);
    }
  }

  //  [adaptor impl] int QPagedPaintDevice::metric(QPaintDevice::PaintDeviceMetric metric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & _metric) const
  {
    return QPagedPaintDevice::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(_metric).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric _metric) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPagedPaintDevice_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPagedPaintDevice_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(_metric));
    } else {
      return QPagedPaintDevice::metric(_metric);
    }
  }

  //  [adaptor impl] QPaintDevice *QPagedPaintDevice::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QPagedPaintDevice::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QPagedPaintDevice_Adaptor, QPaintDevice *, QPoint *>(&QPagedPaintDevice_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QPagedPaintDevice::redirected(offset);
    }
  }

  //  [adaptor impl] QPainter *QPagedPaintDevice::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QPagedPaintDevice::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QPagedPaintDevice_Adaptor, QPainter *>(&QPagedPaintDevice_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QPagedPaintDevice::sharedPainter();
    }
  }

  gsi::Callback cb_newPage_0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setMargins_3812_0;
  gsi::Callback cb_setPageSize_3006_0;
  gsi::Callback cb_setPageSizeMM_1875_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_sharedPainter_c0_0;
};

QPagedPaintDevice_Adaptor::~QPagedPaintDevice_Adaptor() { }

//  Constructor QPagedPaintDevice::QPagedPaintDevice() (adaptor class)

static void _init_ctor_QPagedPaintDevice_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QPagedPaintDevice_Adaptor> ();
}

static void _call_ctor_QPagedPaintDevice_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPagedPaintDevice_Adaptor *> (new QPagedPaintDevice_Adaptor ());
}


// exposed QPageLayout QPagedPaintDevice::devicePageLayout()

static void _init_fp_devicePageLayout_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPageLayout > ();
}

static void _call_fp_devicePageLayout_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPageLayout > ((QPageLayout)((QPagedPaintDevice_Adaptor *)cls)->fp_QPagedPaintDevice_devicePageLayout_c0 ());
}


// exposed QPageLayout &QPagedPaintDevice::devicePageLayout()

static void _init_fp_devicePageLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPageLayout & > ();
}

static void _call_fp_devicePageLayout_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPageLayout & > ((QPageLayout &)((QPagedPaintDevice_Adaptor *)cls)->fp_QPagedPaintDevice_devicePageLayout_0 ());
}


// void QPagedPaintDevice::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPagedPaintDevice_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QPagedPaintDevice_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// int QPagedPaintDevice::metric(QPaintDevice::PaintDeviceMetric metric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QPagedPaintDevice_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPagedPaintDevice_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// bool QPagedPaintDevice::newPage()

static void _init_cbs_newPage_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_newPage_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPagedPaintDevice_Adaptor *)cls)->cbs_newPage_0_0 ());
}

static void _set_callback_cbs_newPage_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPagedPaintDevice_Adaptor *)cls)->cb_newPage_0_0 = cb;
}


// QPaintEngine *QPagedPaintDevice::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPagedPaintDevice_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPagedPaintDevice_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// QPaintDevice *QPagedPaintDevice::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QPagedPaintDevice_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QPagedPaintDevice_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QPagedPaintDevice::setMargins(const QPagedPaintDevice::Margins &margins)

static void _init_cbs_setMargins_3812_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QPagedPaintDevice::Margins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setMargins_3812_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPagedPaintDevice::Margins &arg1 = args.read<const QPagedPaintDevice::Margins & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPagedPaintDevice_Adaptor *)cls)->cbs_setMargins_3812_0 (arg1);
}

static void _set_callback_cbs_setMargins_3812_0 (void *cls, const gsi::Callback &cb)
{
  ((QPagedPaintDevice_Adaptor *)cls)->cb_setMargins_3812_0 = cb;
}


// void QPagedPaintDevice::setPageSize(QPagedPaintDevice::PageSize size)

static void _init_cbs_setPageSize_3006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setPageSize_3006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & arg1 = args.read<const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPagedPaintDevice_Adaptor *)cls)->cbs_setPageSize_3006_0 (arg1);
}

static void _set_callback_cbs_setPageSize_3006_0 (void *cls, const gsi::Callback &cb)
{
  ((QPagedPaintDevice_Adaptor *)cls)->cb_setPageSize_3006_0 = cb;
}


// void QPagedPaintDevice::setPageSizeMM(const QSizeF &size)

static void _init_cbs_setPageSizeMM_1875_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setPageSizeMM_1875_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = args.read<const QSizeF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPagedPaintDevice_Adaptor *)cls)->cbs_setPageSizeMM_1875_0 (arg1);
}

static void _set_callback_cbs_setPageSizeMM_1875_0 (void *cls, const gsi::Callback &cb)
{
  ((QPagedPaintDevice_Adaptor *)cls)->cb_setPageSizeMM_1875_0 = cb;
}


// QPainter *QPagedPaintDevice::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QPagedPaintDevice_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPagedPaintDevice_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


namespace gsi
{

gsi::Class<QPagedPaintDevice> &qtdecl_QPagedPaintDevice ();

static gsi::Methods methods_QPagedPaintDevice_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPagedPaintDevice::QPagedPaintDevice()\nThis method creates an object of class QPagedPaintDevice.", &_init_ctor_QPagedPaintDevice_Adaptor_0, &_call_ctor_QPagedPaintDevice_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("*devicePageLayout", "@brief Method QPageLayout QPagedPaintDevice::devicePageLayout()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_devicePageLayout_c0, &_call_fp_devicePageLayout_c0);
  methods += new qt_gsi::GenericMethod ("*devicePageLayout", "@brief Method QPageLayout &QPagedPaintDevice::devicePageLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_devicePageLayout_0, &_call_fp_devicePageLayout_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QPagedPaintDevice::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QPagedPaintDevice::metric(QPaintDevice::PaintDeviceMetric metric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("newPage", "@hide", false, &_init_cbs_newPage_0_0, &_call_cbs_newPage_0_0);
  methods += new qt_gsi::GenericMethod ("newPage", "@brief Virtual method bool QPagedPaintDevice::newPage()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_newPage_0_0, &_call_cbs_newPage_0_0, &_set_callback_cbs_newPage_0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QPagedPaintDevice::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QPagedPaintDevice::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("setMargins", "@hide", false, &_init_cbs_setMargins_3812_0, &_call_cbs_setMargins_3812_0);
  methods += new qt_gsi::GenericMethod ("setMargins", "@brief Virtual method void QPagedPaintDevice::setMargins(const QPagedPaintDevice::Margins &margins)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMargins_3812_0, &_call_cbs_setMargins_3812_0, &_set_callback_cbs_setMargins_3812_0);
  methods += new qt_gsi::GenericMethod ("setPageSize", "@hide", false, &_init_cbs_setPageSize_3006_0, &_call_cbs_setPageSize_3006_0);
  methods += new qt_gsi::GenericMethod ("setPageSize", "@brief Virtual method void QPagedPaintDevice::setPageSize(QPagedPaintDevice::PageSize size)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPageSize_3006_0, &_call_cbs_setPageSize_3006_0, &_set_callback_cbs_setPageSize_3006_0);
  methods += new qt_gsi::GenericMethod ("setPageSizeMM", "@hide", false, &_init_cbs_setPageSizeMM_1875_0, &_call_cbs_setPageSizeMM_1875_0);
  methods += new qt_gsi::GenericMethod ("setPageSizeMM", "@brief Virtual method void QPagedPaintDevice::setPageSizeMM(const QSizeF &size)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPageSizeMM_1875_0, &_call_cbs_setPageSizeMM_1875_0, &_set_callback_cbs_setPageSizeMM_1875_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QPagedPaintDevice::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  return methods;
}

gsi::Class<QPagedPaintDevice_Adaptor> decl_QPagedPaintDevice_Adaptor (qtdecl_QPagedPaintDevice (), "QPagedPaintDevice",
  methods_QPagedPaintDevice_Adaptor (),
  "@qt\n@brief Binding of QPagedPaintDevice");

}


//  Implementation of the enum wrapper class for QPagedPaintDevice::PageSize
namespace qt_gsi
{

static gsi::Enum<QPagedPaintDevice::PageSize> decl_QPagedPaintDevice_PageSize_Enum ("QPagedPaintDevice_PageSize",
    gsi::enum_const ("A4", QPagedPaintDevice::A4, "@brief Enum constant QPagedPaintDevice::A4") +
    gsi::enum_const ("B5", QPagedPaintDevice::B5, "@brief Enum constant QPagedPaintDevice::B5") +
    gsi::enum_const ("Letter", QPagedPaintDevice::Letter, "@brief Enum constant QPagedPaintDevice::Letter") +
    gsi::enum_const ("Legal", QPagedPaintDevice::Legal, "@brief Enum constant QPagedPaintDevice::Legal") +
    gsi::enum_const ("Executive", QPagedPaintDevice::Executive, "@brief Enum constant QPagedPaintDevice::Executive") +
    gsi::enum_const ("A0", QPagedPaintDevice::A0, "@brief Enum constant QPagedPaintDevice::A0") +
    gsi::enum_const ("A1", QPagedPaintDevice::A1, "@brief Enum constant QPagedPaintDevice::A1") +
    gsi::enum_const ("A2", QPagedPaintDevice::A2, "@brief Enum constant QPagedPaintDevice::A2") +
    gsi::enum_const ("A3", QPagedPaintDevice::A3, "@brief Enum constant QPagedPaintDevice::A3") +
    gsi::enum_const ("A5", QPagedPaintDevice::A5, "@brief Enum constant QPagedPaintDevice::A5") +
    gsi::enum_const ("A6", QPagedPaintDevice::A6, "@brief Enum constant QPagedPaintDevice::A6") +
    gsi::enum_const ("A7", QPagedPaintDevice::A7, "@brief Enum constant QPagedPaintDevice::A7") +
    gsi::enum_const ("A8", QPagedPaintDevice::A8, "@brief Enum constant QPagedPaintDevice::A8") +
    gsi::enum_const ("A9", QPagedPaintDevice::A9, "@brief Enum constant QPagedPaintDevice::A9") +
    gsi::enum_const ("B0", QPagedPaintDevice::B0, "@brief Enum constant QPagedPaintDevice::B0") +
    gsi::enum_const ("B1", QPagedPaintDevice::B1, "@brief Enum constant QPagedPaintDevice::B1") +
    gsi::enum_const ("B10", QPagedPaintDevice::B10, "@brief Enum constant QPagedPaintDevice::B10") +
    gsi::enum_const ("B2", QPagedPaintDevice::B2, "@brief Enum constant QPagedPaintDevice::B2") +
    gsi::enum_const ("B3", QPagedPaintDevice::B3, "@brief Enum constant QPagedPaintDevice::B3") +
    gsi::enum_const ("B4", QPagedPaintDevice::B4, "@brief Enum constant QPagedPaintDevice::B4") +
    gsi::enum_const ("B6", QPagedPaintDevice::B6, "@brief Enum constant QPagedPaintDevice::B6") +
    gsi::enum_const ("B7", QPagedPaintDevice::B7, "@brief Enum constant QPagedPaintDevice::B7") +
    gsi::enum_const ("B8", QPagedPaintDevice::B8, "@brief Enum constant QPagedPaintDevice::B8") +
    gsi::enum_const ("B9", QPagedPaintDevice::B9, "@brief Enum constant QPagedPaintDevice::B9") +
    gsi::enum_const ("C5E", QPagedPaintDevice::C5E, "@brief Enum constant QPagedPaintDevice::C5E") +
    gsi::enum_const ("Comm10E", QPagedPaintDevice::Comm10E, "@brief Enum constant QPagedPaintDevice::Comm10E") +
    gsi::enum_const ("DLE", QPagedPaintDevice::DLE, "@brief Enum constant QPagedPaintDevice::DLE") +
    gsi::enum_const ("Folio", QPagedPaintDevice::Folio, "@brief Enum constant QPagedPaintDevice::Folio") +
    gsi::enum_const ("Ledger", QPagedPaintDevice::Ledger, "@brief Enum constant QPagedPaintDevice::Ledger") +
    gsi::enum_const ("Tabloid", QPagedPaintDevice::Tabloid, "@brief Enum constant QPagedPaintDevice::Tabloid") +
    gsi::enum_const ("Custom", QPagedPaintDevice::Custom, "@brief Enum constant QPagedPaintDevice::Custom") +
    gsi::enum_const ("A10", QPagedPaintDevice::A10, "@brief Enum constant QPagedPaintDevice::A10") +
    gsi::enum_const ("A3Extra", QPagedPaintDevice::A3Extra, "@brief Enum constant QPagedPaintDevice::A3Extra") +
    gsi::enum_const ("A4Extra", QPagedPaintDevice::A4Extra, "@brief Enum constant QPagedPaintDevice::A4Extra") +
    gsi::enum_const ("A4Plus", QPagedPaintDevice::A4Plus, "@brief Enum constant QPagedPaintDevice::A4Plus") +
    gsi::enum_const ("A4Small", QPagedPaintDevice::A4Small, "@brief Enum constant QPagedPaintDevice::A4Small") +
    gsi::enum_const ("A5Extra", QPagedPaintDevice::A5Extra, "@brief Enum constant QPagedPaintDevice::A5Extra") +
    gsi::enum_const ("B5Extra", QPagedPaintDevice::B5Extra, "@brief Enum constant QPagedPaintDevice::B5Extra") +
    gsi::enum_const ("JisB0", QPagedPaintDevice::JisB0, "@brief Enum constant QPagedPaintDevice::JisB0") +
    gsi::enum_const ("JisB1", QPagedPaintDevice::JisB1, "@brief Enum constant QPagedPaintDevice::JisB1") +
    gsi::enum_const ("JisB2", QPagedPaintDevice::JisB2, "@brief Enum constant QPagedPaintDevice::JisB2") +
    gsi::enum_const ("JisB3", QPagedPaintDevice::JisB3, "@brief Enum constant QPagedPaintDevice::JisB3") +
    gsi::enum_const ("JisB4", QPagedPaintDevice::JisB4, "@brief Enum constant QPagedPaintDevice::JisB4") +
    gsi::enum_const ("JisB5", QPagedPaintDevice::JisB5, "@brief Enum constant QPagedPaintDevice::JisB5") +
    gsi::enum_const ("JisB6", QPagedPaintDevice::JisB6, "@brief Enum constant QPagedPaintDevice::JisB6") +
    gsi::enum_const ("JisB7", QPagedPaintDevice::JisB7, "@brief Enum constant QPagedPaintDevice::JisB7") +
    gsi::enum_const ("JisB8", QPagedPaintDevice::JisB8, "@brief Enum constant QPagedPaintDevice::JisB8") +
    gsi::enum_const ("JisB9", QPagedPaintDevice::JisB9, "@brief Enum constant QPagedPaintDevice::JisB9") +
    gsi::enum_const ("JisB10", QPagedPaintDevice::JisB10, "@brief Enum constant QPagedPaintDevice::JisB10") +
    gsi::enum_const ("AnsiC", QPagedPaintDevice::AnsiC, "@brief Enum constant QPagedPaintDevice::AnsiC") +
    gsi::enum_const ("AnsiD", QPagedPaintDevice::AnsiD, "@brief Enum constant QPagedPaintDevice::AnsiD") +
    gsi::enum_const ("AnsiE", QPagedPaintDevice::AnsiE, "@brief Enum constant QPagedPaintDevice::AnsiE") +
    gsi::enum_const ("LegalExtra", QPagedPaintDevice::LegalExtra, "@brief Enum constant QPagedPaintDevice::LegalExtra") +
    gsi::enum_const ("LetterExtra", QPagedPaintDevice::LetterExtra, "@brief Enum constant QPagedPaintDevice::LetterExtra") +
    gsi::enum_const ("LetterPlus", QPagedPaintDevice::LetterPlus, "@brief Enum constant QPagedPaintDevice::LetterPlus") +
    gsi::enum_const ("LetterSmall", QPagedPaintDevice::LetterSmall, "@brief Enum constant QPagedPaintDevice::LetterSmall") +
    gsi::enum_const ("TabloidExtra", QPagedPaintDevice::TabloidExtra, "@brief Enum constant QPagedPaintDevice::TabloidExtra") +
    gsi::enum_const ("ArchA", QPagedPaintDevice::ArchA, "@brief Enum constant QPagedPaintDevice::ArchA") +
    gsi::enum_const ("ArchB", QPagedPaintDevice::ArchB, "@brief Enum constant QPagedPaintDevice::ArchB") +
    gsi::enum_const ("ArchC", QPagedPaintDevice::ArchC, "@brief Enum constant QPagedPaintDevice::ArchC") +
    gsi::enum_const ("ArchD", QPagedPaintDevice::ArchD, "@brief Enum constant QPagedPaintDevice::ArchD") +
    gsi::enum_const ("ArchE", QPagedPaintDevice::ArchE, "@brief Enum constant QPagedPaintDevice::ArchE") +
    gsi::enum_const ("Imperial7x9", QPagedPaintDevice::Imperial7x9, "@brief Enum constant QPagedPaintDevice::Imperial7x9") +
    gsi::enum_const ("Imperial8x10", QPagedPaintDevice::Imperial8x10, "@brief Enum constant QPagedPaintDevice::Imperial8x10") +
    gsi::enum_const ("Imperial9x11", QPagedPaintDevice::Imperial9x11, "@brief Enum constant QPagedPaintDevice::Imperial9x11") +
    gsi::enum_const ("Imperial9x12", QPagedPaintDevice::Imperial9x12, "@brief Enum constant QPagedPaintDevice::Imperial9x12") +
    gsi::enum_const ("Imperial10x11", QPagedPaintDevice::Imperial10x11, "@brief Enum constant QPagedPaintDevice::Imperial10x11") +
    gsi::enum_const ("Imperial10x13", QPagedPaintDevice::Imperial10x13, "@brief Enum constant QPagedPaintDevice::Imperial10x13") +
    gsi::enum_const ("Imperial10x14", QPagedPaintDevice::Imperial10x14, "@brief Enum constant QPagedPaintDevice::Imperial10x14") +
    gsi::enum_const ("Imperial12x11", QPagedPaintDevice::Imperial12x11, "@brief Enum constant QPagedPaintDevice::Imperial12x11") +
    gsi::enum_const ("Imperial15x11", QPagedPaintDevice::Imperial15x11, "@brief Enum constant QPagedPaintDevice::Imperial15x11") +
    gsi::enum_const ("ExecutiveStandard", QPagedPaintDevice::ExecutiveStandard, "@brief Enum constant QPagedPaintDevice::ExecutiveStandard") +
    gsi::enum_const ("Note", QPagedPaintDevice::Note, "@brief Enum constant QPagedPaintDevice::Note") +
    gsi::enum_const ("Quarto", QPagedPaintDevice::Quarto, "@brief Enum constant QPagedPaintDevice::Quarto") +
    gsi::enum_const ("Statement", QPagedPaintDevice::Statement, "@brief Enum constant QPagedPaintDevice::Statement") +
    gsi::enum_const ("SuperA", QPagedPaintDevice::SuperA, "@brief Enum constant QPagedPaintDevice::SuperA") +
    gsi::enum_const ("SuperB", QPagedPaintDevice::SuperB, "@brief Enum constant QPagedPaintDevice::SuperB") +
    gsi::enum_const ("Postcard", QPagedPaintDevice::Postcard, "@brief Enum constant QPagedPaintDevice::Postcard") +
    gsi::enum_const ("DoublePostcard", QPagedPaintDevice::DoublePostcard, "@brief Enum constant QPagedPaintDevice::DoublePostcard") +
    gsi::enum_const ("Prc16K", QPagedPaintDevice::Prc16K, "@brief Enum constant QPagedPaintDevice::Prc16K") +
    gsi::enum_const ("Prc32K", QPagedPaintDevice::Prc32K, "@brief Enum constant QPagedPaintDevice::Prc32K") +
    gsi::enum_const ("Prc32KBig", QPagedPaintDevice::Prc32KBig, "@brief Enum constant QPagedPaintDevice::Prc32KBig") +
    gsi::enum_const ("FanFoldUS", QPagedPaintDevice::FanFoldUS, "@brief Enum constant QPagedPaintDevice::FanFoldUS") +
    gsi::enum_const ("FanFoldGerman", QPagedPaintDevice::FanFoldGerman, "@brief Enum constant QPagedPaintDevice::FanFoldGerman") +
    gsi::enum_const ("FanFoldGermanLegal", QPagedPaintDevice::FanFoldGermanLegal, "@brief Enum constant QPagedPaintDevice::FanFoldGermanLegal") +
    gsi::enum_const ("EnvelopeB4", QPagedPaintDevice::EnvelopeB4, "@brief Enum constant QPagedPaintDevice::EnvelopeB4") +
    gsi::enum_const ("EnvelopeB5", QPagedPaintDevice::EnvelopeB5, "@brief Enum constant QPagedPaintDevice::EnvelopeB5") +
    gsi::enum_const ("EnvelopeB6", QPagedPaintDevice::EnvelopeB6, "@brief Enum constant QPagedPaintDevice::EnvelopeB6") +
    gsi::enum_const ("EnvelopeC0", QPagedPaintDevice::EnvelopeC0, "@brief Enum constant QPagedPaintDevice::EnvelopeC0") +
    gsi::enum_const ("EnvelopeC1", QPagedPaintDevice::EnvelopeC1, "@brief Enum constant QPagedPaintDevice::EnvelopeC1") +
    gsi::enum_const ("EnvelopeC2", QPagedPaintDevice::EnvelopeC2, "@brief Enum constant QPagedPaintDevice::EnvelopeC2") +
    gsi::enum_const ("EnvelopeC3", QPagedPaintDevice::EnvelopeC3, "@brief Enum constant QPagedPaintDevice::EnvelopeC3") +
    gsi::enum_const ("EnvelopeC4", QPagedPaintDevice::EnvelopeC4, "@brief Enum constant QPagedPaintDevice::EnvelopeC4") +
    gsi::enum_const ("EnvelopeC6", QPagedPaintDevice::EnvelopeC6, "@brief Enum constant QPagedPaintDevice::EnvelopeC6") +
    gsi::enum_const ("EnvelopeC65", QPagedPaintDevice::EnvelopeC65, "@brief Enum constant QPagedPaintDevice::EnvelopeC65") +
    gsi::enum_const ("EnvelopeC7", QPagedPaintDevice::EnvelopeC7, "@brief Enum constant QPagedPaintDevice::EnvelopeC7") +
    gsi::enum_const ("Envelope9", QPagedPaintDevice::Envelope9, "@brief Enum constant QPagedPaintDevice::Envelope9") +
    gsi::enum_const ("Envelope11", QPagedPaintDevice::Envelope11, "@brief Enum constant QPagedPaintDevice::Envelope11") +
    gsi::enum_const ("Envelope12", QPagedPaintDevice::Envelope12, "@brief Enum constant QPagedPaintDevice::Envelope12") +
    gsi::enum_const ("Envelope14", QPagedPaintDevice::Envelope14, "@brief Enum constant QPagedPaintDevice::Envelope14") +
    gsi::enum_const ("EnvelopeMonarch", QPagedPaintDevice::EnvelopeMonarch, "@brief Enum constant QPagedPaintDevice::EnvelopeMonarch") +
    gsi::enum_const ("EnvelopePersonal", QPagedPaintDevice::EnvelopePersonal, "@brief Enum constant QPagedPaintDevice::EnvelopePersonal") +
    gsi::enum_const ("EnvelopeChou3", QPagedPaintDevice::EnvelopeChou3, "@brief Enum constant QPagedPaintDevice::EnvelopeChou3") +
    gsi::enum_const ("EnvelopeChou4", QPagedPaintDevice::EnvelopeChou4, "@brief Enum constant QPagedPaintDevice::EnvelopeChou4") +
    gsi::enum_const ("EnvelopeInvite", QPagedPaintDevice::EnvelopeInvite, "@brief Enum constant QPagedPaintDevice::EnvelopeInvite") +
    gsi::enum_const ("EnvelopeItalian", QPagedPaintDevice::EnvelopeItalian, "@brief Enum constant QPagedPaintDevice::EnvelopeItalian") +
    gsi::enum_const ("EnvelopeKaku2", QPagedPaintDevice::EnvelopeKaku2, "@brief Enum constant QPagedPaintDevice::EnvelopeKaku2") +
    gsi::enum_const ("EnvelopeKaku3", QPagedPaintDevice::EnvelopeKaku3, "@brief Enum constant QPagedPaintDevice::EnvelopeKaku3") +
    gsi::enum_const ("EnvelopePrc1", QPagedPaintDevice::EnvelopePrc1, "@brief Enum constant QPagedPaintDevice::EnvelopePrc1") +
    gsi::enum_const ("EnvelopePrc2", QPagedPaintDevice::EnvelopePrc2, "@brief Enum constant QPagedPaintDevice::EnvelopePrc2") +
    gsi::enum_const ("EnvelopePrc3", QPagedPaintDevice::EnvelopePrc3, "@brief Enum constant QPagedPaintDevice::EnvelopePrc3") +
    gsi::enum_const ("EnvelopePrc4", QPagedPaintDevice::EnvelopePrc4, "@brief Enum constant QPagedPaintDevice::EnvelopePrc4") +
    gsi::enum_const ("EnvelopePrc5", QPagedPaintDevice::EnvelopePrc5, "@brief Enum constant QPagedPaintDevice::EnvelopePrc5") +
    gsi::enum_const ("EnvelopePrc6", QPagedPaintDevice::EnvelopePrc6, "@brief Enum constant QPagedPaintDevice::EnvelopePrc6") +
    gsi::enum_const ("EnvelopePrc7", QPagedPaintDevice::EnvelopePrc7, "@brief Enum constant QPagedPaintDevice::EnvelopePrc7") +
    gsi::enum_const ("EnvelopePrc8", QPagedPaintDevice::EnvelopePrc8, "@brief Enum constant QPagedPaintDevice::EnvelopePrc8") +
    gsi::enum_const ("EnvelopePrc9", QPagedPaintDevice::EnvelopePrc9, "@brief Enum constant QPagedPaintDevice::EnvelopePrc9") +
    gsi::enum_const ("EnvelopePrc10", QPagedPaintDevice::EnvelopePrc10, "@brief Enum constant QPagedPaintDevice::EnvelopePrc10") +
    gsi::enum_const ("EnvelopeYou4", QPagedPaintDevice::EnvelopeYou4, "@brief Enum constant QPagedPaintDevice::EnvelopeYou4") +
    gsi::enum_const ("LastPageSize", QPagedPaintDevice::LastPageSize, "@brief Enum constant QPagedPaintDevice::LastPageSize") +
    gsi::enum_const ("NPageSize", QPagedPaintDevice::NPageSize, "@brief Enum constant QPagedPaintDevice::NPageSize") +
    gsi::enum_const ("NPaperSize", QPagedPaintDevice::NPaperSize, "@brief Enum constant QPagedPaintDevice::NPaperSize") +
    gsi::enum_const ("AnsiA", QPagedPaintDevice::AnsiA, "@brief Enum constant QPagedPaintDevice::AnsiA") +
    gsi::enum_const ("AnsiB", QPagedPaintDevice::AnsiB, "@brief Enum constant QPagedPaintDevice::AnsiB") +
    gsi::enum_const ("EnvelopeC5", QPagedPaintDevice::EnvelopeC5, "@brief Enum constant QPagedPaintDevice::EnvelopeC5") +
    gsi::enum_const ("EnvelopeDL", QPagedPaintDevice::EnvelopeDL, "@brief Enum constant QPagedPaintDevice::EnvelopeDL") +
    gsi::enum_const ("Envelope10", QPagedPaintDevice::Envelope10, "@brief Enum constant QPagedPaintDevice::Envelope10"),
  "@qt\n@brief This class represents the QPagedPaintDevice::PageSize enum");

static gsi::QFlagsClass<QPagedPaintDevice::PageSize > decl_QPagedPaintDevice_PageSize_Enums ("QPagedPaintDevice_QFlags_PageSize",
  "@qt\n@brief This class represents the QFlags<QPagedPaintDevice::PageSize> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QPagedPaintDevice> inject_QPagedPaintDevice_PageSize_Enum_in_parent (decl_QPagedPaintDevice_PageSize_Enum.defs ());
static gsi::ClassExt<QPagedPaintDevice> decl_QPagedPaintDevice_PageSize_Enum_as_child (decl_QPagedPaintDevice_PageSize_Enum, "PageSize");
static gsi::ClassExt<QPagedPaintDevice> decl_QPagedPaintDevice_PageSize_Enums_as_child (decl_QPagedPaintDevice_PageSize_Enums, "QFlags_PageSize");

}

