
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQQuaternion.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QQuaternion>
#include <QVector3D>
#include <QVector4D>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QQuaternion

//  Constructor QQuaternion::QQuaternion()


static void _init_ctor_QQuaternion_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QQuaternion> ();
}

static void _call_ctor_QQuaternion_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QQuaternion *> (new QQuaternion ());
}


//  Constructor QQuaternion::QQuaternion(float scalar, float xpos, float ypos, float zpos)


static void _init_ctor_QQuaternion_3556 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scalar");
  decl->add_arg<float > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xpos");
  decl->add_arg<float > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ypos");
  decl->add_arg<float > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("zpos");
  decl->add_arg<float > (argspec_3);
  decl->set_return_new<QQuaternion> ();
}

static void _call_ctor_QQuaternion_3556 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = args.read<float > (heap);
  float arg2 = args.read<float > (heap);
  float arg3 = args.read<float > (heap);
  float arg4 = args.read<float > (heap);
  ret.write<QQuaternion *> (new QQuaternion (arg1, arg2, arg3, arg4));
}


//  Constructor QQuaternion::QQuaternion(float scalar, const QVector3D &vector)


static void _init_ctor_QQuaternion_3002 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scalar");
  decl->add_arg<float > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("vector");
  decl->add_arg<const QVector3D & > (argspec_1);
  decl->set_return_new<QQuaternion> ();
}

static void _call_ctor_QQuaternion_3002 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = args.read<float > (heap);
  const QVector3D &arg2 = args.read<const QVector3D & > (heap);
  ret.write<QQuaternion *> (new QQuaternion (arg1, arg2));
}


//  Constructor QQuaternion::QQuaternion(const QVector4D &vector)


static void _init_ctor_QQuaternion_2141 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("vector");
  decl->add_arg<const QVector4D & > (argspec_0);
  decl->set_return_new<QQuaternion> ();
}

static void _call_ctor_QQuaternion_2141 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector4D &arg1 = args.read<const QVector4D & > (heap);
  ret.write<QQuaternion *> (new QQuaternion (arg1));
}


// QQuaternion QQuaternion::conjugate()


static void _init_f_conjugate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QQuaternion > ();
}

static void _call_f_conjugate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QQuaternion > ((QQuaternion)((QQuaternion *)cls)->conjugate ());
}


// QQuaternion QQuaternion::conjugated()


static void _init_f_conjugated_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QQuaternion > ();
}

static void _call_f_conjugated_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QQuaternion > ((QQuaternion)((QQuaternion *)cls)->conjugated ());
}


// void QQuaternion::getAxes(QVector3D *xAxis, QVector3D *yAxis, QVector3D *zAxis)


static void _init_f_getAxes_c4131 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("xAxis");
  decl->add_arg<QVector3D * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("yAxis");
  decl->add_arg<QVector3D * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("zAxis");
  decl->add_arg<QVector3D * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_getAxes_c4131 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QVector3D *arg1 = args.read<QVector3D * > (heap);
  QVector3D *arg2 = args.read<QVector3D * > (heap);
  QVector3D *arg3 = args.read<QVector3D * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QQuaternion *)cls)->getAxes (arg1, arg2, arg3);
}


// void QQuaternion::getAxisAndAngle(QVector3D *axis, float *angle)


static void _init_f_getAxisAndAngle_c2497 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("axis");
  decl->add_arg<QVector3D * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("angle");
  decl->add_arg<float * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_getAxisAndAngle_c2497 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QVector3D *arg1 = args.read<QVector3D * > (heap);
  float *arg2 = args.read<float * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QQuaternion *)cls)->getAxisAndAngle (arg1, arg2);
}


// void QQuaternion::getAxisAndAngle(float *x, float *y, float *z, float *angle)


static void _init_f_getAxisAndAngle_c4300 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<float * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<float * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("z");
  decl->add_arg<float * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("angle");
  decl->add_arg<float * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getAxisAndAngle_c4300 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float *arg1 = args.read<float * > (heap);
  float *arg2 = args.read<float * > (heap);
  float *arg3 = args.read<float * > (heap);
  float *arg4 = args.read<float * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QQuaternion *)cls)->getAxisAndAngle (arg1, arg2, arg3, arg4);
}


// void QQuaternion::getEulerAngles(float *pitch, float *yaw, float *roll)


static void _init_f_getEulerAngles_c3252 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pitch");
  decl->add_arg<float * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("yaw");
  decl->add_arg<float * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("roll");
  decl->add_arg<float * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_getEulerAngles_c3252 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float *arg1 = args.read<float * > (heap);
  float *arg2 = args.read<float * > (heap);
  float *arg3 = args.read<float * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QQuaternion *)cls)->getEulerAngles (arg1, arg2, arg3);
}


// QQuaternion QQuaternion::inverted()


static void _init_f_inverted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QQuaternion > ();
}

static void _call_f_inverted_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QQuaternion > ((QQuaternion)((QQuaternion *)cls)->inverted ());
}


// bool QQuaternion::isIdentity()


static void _init_f_isIdentity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isIdentity_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QQuaternion *)cls)->isIdentity ());
}


// bool QQuaternion::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QQuaternion *)cls)->isNull ());
}


// float QQuaternion::length()


static void _init_f_length_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_length_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QQuaternion *)cls)->length ());
}


// float QQuaternion::lengthSquared()


static void _init_f_lengthSquared_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_lengthSquared_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QQuaternion *)cls)->lengthSquared ());
}


// void QQuaternion::normalize()


static void _init_f_normalize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_normalize_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QQuaternion *)cls)->normalize ();
}


// QQuaternion QQuaternion::normalized()


static void _init_f_normalized_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QQuaternion > ();
}

static void _call_f_normalized_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QQuaternion > ((QQuaternion)((QQuaternion *)cls)->normalized ());
}


// QQuaternion &QQuaternion::operator*=(float factor)


static void _init_f_operator_star__eq__970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("factor");
  decl->add_arg<float > (argspec_0);
  decl->set_return<QQuaternion & > ();
}

static void _call_f_operator_star__eq__970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = args.read<float > (heap);
  ret.write<QQuaternion & > ((QQuaternion &)((QQuaternion *)cls)->operator*= (arg1));
}


// QQuaternion &QQuaternion::operator*=(const QQuaternion &quaternion)


static void _init_f_operator_star__eq__2456 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quaternion");
  decl->add_arg<const QQuaternion & > (argspec_0);
  decl->set_return<QQuaternion & > ();
}

static void _call_f_operator_star__eq__2456 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QQuaternion &arg1 = args.read<const QQuaternion & > (heap);
  ret.write<QQuaternion & > ((QQuaternion &)((QQuaternion *)cls)->operator*= (arg1));
}


// QQuaternion &QQuaternion::operator+=(const QQuaternion &quaternion)


static void _init_f_operator_plus__eq__2456 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quaternion");
  decl->add_arg<const QQuaternion & > (argspec_0);
  decl->set_return<QQuaternion & > ();
}

static void _call_f_operator_plus__eq__2456 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QQuaternion &arg1 = args.read<const QQuaternion & > (heap);
  ret.write<QQuaternion & > ((QQuaternion &)((QQuaternion *)cls)->operator+= (arg1));
}


// QQuaternion &QQuaternion::operator-=(const QQuaternion &quaternion)


static void _init_f_operator_minus__eq__2456 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quaternion");
  decl->add_arg<const QQuaternion & > (argspec_0);
  decl->set_return<QQuaternion & > ();
}

static void _call_f_operator_minus__eq__2456 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QQuaternion &arg1 = args.read<const QQuaternion & > (heap);
  ret.write<QQuaternion & > ((QQuaternion &)((QQuaternion *)cls)->operator-= (arg1));
}


// QQuaternion &QQuaternion::operator/=(float divisor)


static void _init_f_operator_slash__eq__970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("divisor");
  decl->add_arg<float > (argspec_0);
  decl->set_return<QQuaternion & > ();
}

static void _call_f_operator_slash__eq__970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = args.read<float > (heap);
  ret.write<QQuaternion & > ((QQuaternion &)((QQuaternion *)cls)->operator/= (arg1));
}


// QVector3D QQuaternion::rotatedVector(const QVector3D &vector)


static void _init_f_rotatedVector_c2140 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("vector");
  decl->add_arg<const QVector3D & > (argspec_0);
  decl->set_return<QVector3D > ();
}

static void _call_f_rotatedVector_c2140 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector3D &arg1 = args.read<const QVector3D & > (heap);
  ret.write<QVector3D > ((QVector3D)((QQuaternion *)cls)->rotatedVector (arg1));
}


// float QQuaternion::scalar()


static void _init_f_scalar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_scalar_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QQuaternion *)cls)->scalar ());
}


// void QQuaternion::setScalar(float scalar)


static void _init_f_setScalar_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scalar");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScalar_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = args.read<float > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QQuaternion *)cls)->setScalar (arg1);
}


// void QQuaternion::setVector(const QVector3D &vector)


static void _init_f_setVector_2140 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("vector");
  decl->add_arg<const QVector3D & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVector_2140 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector3D &arg1 = args.read<const QVector3D & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QQuaternion *)cls)->setVector (arg1);
}


// void QQuaternion::setVector(float x, float y, float z)


static void _init_f_setVector_2694 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<float > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<float > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("z");
  decl->add_arg<float > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setVector_2694 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = args.read<float > (heap);
  float arg2 = args.read<float > (heap);
  float arg3 = args.read<float > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QQuaternion *)cls)->setVector (arg1, arg2, arg3);
}


// void QQuaternion::setX(float x)


static void _init_f_setX_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setX_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = args.read<float > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QQuaternion *)cls)->setX (arg1);
}


// void QQuaternion::setY(float y)


static void _init_f_setY_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setY_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = args.read<float > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QQuaternion *)cls)->setY (arg1);
}


// void QQuaternion::setZ(float z)


static void _init_f_setZ_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("z");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setZ_970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = args.read<float > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QQuaternion *)cls)->setZ (arg1);
}


// QVector3D QQuaternion::toEulerAngles()


static void _init_f_toEulerAngles_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVector3D > ();
}

static void _call_f_toEulerAngles_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVector3D > ((QVector3D)((QQuaternion *)cls)->toEulerAngles ());
}


// QVector4D QQuaternion::toVector4D()


static void _init_f_toVector4D_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVector4D > ();
}

static void _call_f_toVector4D_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVector4D > ((QVector4D)((QQuaternion *)cls)->toVector4D ());
}


// QVector3D QQuaternion::vector()


static void _init_f_vector_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVector3D > ();
}

static void _call_f_vector_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVector3D > ((QVector3D)((QQuaternion *)cls)->vector ());
}


// float QQuaternion::x()


static void _init_f_x_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_x_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QQuaternion *)cls)->x ());
}


// float QQuaternion::y()


static void _init_f_y_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_y_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QQuaternion *)cls)->y ());
}


// float QQuaternion::z()


static void _init_f_z_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_z_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<float > ((float)((QQuaternion *)cls)->z ());
}


// static float QQuaternion::dotProduct(const QQuaternion &q1, const QQuaternion &q2)


static void _init_f_dotProduct_4804 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("q1");
  decl->add_arg<const QQuaternion & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("q2");
  decl->add_arg<const QQuaternion & > (argspec_1);
  decl->set_return<float > ();
}

static void _call_f_dotProduct_4804 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QQuaternion &arg1 = args.read<const QQuaternion & > (heap);
  const QQuaternion &arg2 = args.read<const QQuaternion & > (heap);
  ret.write<float > ((float)QQuaternion::dotProduct (arg1, arg2));
}


// static QQuaternion QQuaternion::fromAxes(const QVector3D &xAxis, const QVector3D &yAxis, const QVector3D &zAxis)


static void _init_f_fromAxes_6204 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("xAxis");
  decl->add_arg<const QVector3D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("yAxis");
  decl->add_arg<const QVector3D & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("zAxis");
  decl->add_arg<const QVector3D & > (argspec_2);
  decl->set_return<QQuaternion > ();
}

static void _call_f_fromAxes_6204 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector3D &arg1 = args.read<const QVector3D & > (heap);
  const QVector3D &arg2 = args.read<const QVector3D & > (heap);
  const QVector3D &arg3 = args.read<const QVector3D & > (heap);
  ret.write<QQuaternion > ((QQuaternion)QQuaternion::fromAxes (arg1, arg2, arg3));
}


// static QQuaternion QQuaternion::fromAxisAndAngle(const QVector3D &axis, float angle)


static void _init_f_fromAxisAndAngle_3002 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("axis");
  decl->add_arg<const QVector3D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("angle");
  decl->add_arg<float > (argspec_1);
  decl->set_return<QQuaternion > ();
}

static void _call_f_fromAxisAndAngle_3002 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector3D &arg1 = args.read<const QVector3D & > (heap);
  float arg2 = args.read<float > (heap);
  ret.write<QQuaternion > ((QQuaternion)QQuaternion::fromAxisAndAngle (arg1, arg2));
}


// static QQuaternion QQuaternion::fromAxisAndAngle(float x, float y, float z, float angle)


static void _init_f_fromAxisAndAngle_3556 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<float > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<float > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("z");
  decl->add_arg<float > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("angle");
  decl->add_arg<float > (argspec_3);
  decl->set_return<QQuaternion > ();
}

static void _call_f_fromAxisAndAngle_3556 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = args.read<float > (heap);
  float arg2 = args.read<float > (heap);
  float arg3 = args.read<float > (heap);
  float arg4 = args.read<float > (heap);
  ret.write<QQuaternion > ((QQuaternion)QQuaternion::fromAxisAndAngle (arg1, arg2, arg3, arg4));
}


// static QQuaternion QQuaternion::fromDirection(const QVector3D &direction, const QVector3D &up)


static void _init_f_fromDirection_4172 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const QVector3D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("up");
  decl->add_arg<const QVector3D & > (argspec_1);
  decl->set_return<QQuaternion > ();
}

static void _call_f_fromDirection_4172 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector3D &arg1 = args.read<const QVector3D & > (heap);
  const QVector3D &arg2 = args.read<const QVector3D & > (heap);
  ret.write<QQuaternion > ((QQuaternion)QQuaternion::fromDirection (arg1, arg2));
}


// static QQuaternion QQuaternion::fromEulerAngles(const QVector3D &eulerAngles)


static void _init_f_fromEulerAngles_2140 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eulerAngles");
  decl->add_arg<const QVector3D & > (argspec_0);
  decl->set_return<QQuaternion > ();
}

static void _call_f_fromEulerAngles_2140 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector3D &arg1 = args.read<const QVector3D & > (heap);
  ret.write<QQuaternion > ((QQuaternion)QQuaternion::fromEulerAngles (arg1));
}


// static QQuaternion QQuaternion::fromEulerAngles(float pitch, float yaw, float roll)


static void _init_f_fromEulerAngles_2694 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pitch");
  decl->add_arg<float > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("yaw");
  decl->add_arg<float > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("roll");
  decl->add_arg<float > (argspec_2);
  decl->set_return<QQuaternion > ();
}

static void _call_f_fromEulerAngles_2694 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  float arg1 = args.read<float > (heap);
  float arg2 = args.read<float > (heap);
  float arg3 = args.read<float > (heap);
  ret.write<QQuaternion > ((QQuaternion)QQuaternion::fromEulerAngles (arg1, arg2, arg3));
}


// static QQuaternion QQuaternion::nlerp(const QQuaternion &q1, const QQuaternion &q2, float t)


static void _init_f_nlerp_5666 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("q1");
  decl->add_arg<const QQuaternion & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("q2");
  decl->add_arg<const QQuaternion & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("t");
  decl->add_arg<float > (argspec_2);
  decl->set_return<QQuaternion > ();
}

static void _call_f_nlerp_5666 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QQuaternion &arg1 = args.read<const QQuaternion & > (heap);
  const QQuaternion &arg2 = args.read<const QQuaternion & > (heap);
  float arg3 = args.read<float > (heap);
  ret.write<QQuaternion > ((QQuaternion)QQuaternion::nlerp (arg1, arg2, arg3));
}


// static QQuaternion QQuaternion::rotationTo(const QVector3D &from, const QVector3D &to)


static void _init_f_rotationTo_4172 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QVector3D & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QVector3D & > (argspec_1);
  decl->set_return<QQuaternion > ();
}

static void _call_f_rotationTo_4172 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector3D &arg1 = args.read<const QVector3D & > (heap);
  const QVector3D &arg2 = args.read<const QVector3D & > (heap);
  ret.write<QQuaternion > ((QQuaternion)QQuaternion::rotationTo (arg1, arg2));
}


// static QQuaternion QQuaternion::slerp(const QQuaternion &q1, const QQuaternion &q2, float t)


static void _init_f_slerp_5666 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("q1");
  decl->add_arg<const QQuaternion & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("q2");
  decl->add_arg<const QQuaternion & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("t");
  decl->add_arg<float > (argspec_2);
  decl->set_return<QQuaternion > ();
}

static void _call_f_slerp_5666 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QQuaternion &arg1 = args.read<const QQuaternion & > (heap);
  const QQuaternion &arg2 = args.read<const QQuaternion & > (heap);
  float arg3 = args.read<float > (heap);
  ret.write<QQuaternion > ((QQuaternion)QQuaternion::slerp (arg1, arg2, arg3));
}


//  const QQuaternion ::operator*(const QQuaternion &q1, const QQuaternion &q2)
static const QQuaternion op_QQuaternion_operator_star__4804(const QQuaternion *_self, const QQuaternion &q2) {
  return ::operator*(*_self, q2);
}

//  bool ::operator==(const QQuaternion &q1, const QQuaternion &q2)
static bool op_QQuaternion_operator_eq__eq__4804(const QQuaternion *_self, const QQuaternion &q2) {
  return ::operator==(*_self, q2);
}

//  bool ::operator!=(const QQuaternion &q1, const QQuaternion &q2)
static bool op_QQuaternion_operator_excl__eq__4804(const QQuaternion *_self, const QQuaternion &q2) {
  return ::operator!=(*_self, q2);
}

//  const QQuaternion ::operator+(const QQuaternion &q1, const QQuaternion &q2)
static const QQuaternion op_QQuaternion_operator_plus__4804(const QQuaternion *_self, const QQuaternion &q2) {
  return ::operator+(*_self, q2);
}

//  const QQuaternion ::operator-(const QQuaternion &q1, const QQuaternion &q2)
static const QQuaternion op_QQuaternion_operator_minus__4804(const QQuaternion *_self, const QQuaternion &q2) {
  return ::operator-(*_self, q2);
}

//  const QQuaternion ::operator*(const QQuaternion &quaternion, float factor)
static const QQuaternion op_QQuaternion_operator_star__3318(const QQuaternion *_self, float factor) {
  return ::operator*(*_self, factor);
}

//  const QQuaternion ::operator-(const QQuaternion &quaternion)
static const QQuaternion op_QQuaternion_operator_minus__2456(const QQuaternion *_self) {
  return ::operator-(*_self);
}

//  const QQuaternion ::operator/(const QQuaternion &quaternion, float divisor)
static const QQuaternion op_QQuaternion_operator_slash__3318(const QQuaternion *_self, float divisor) {
  return ::operator/(*_self, divisor);
}

//  QVector3D ::operator*(const QQuaternion &quaternion, const QVector3D &vec)
static QVector3D op_QQuaternion_operator_star__4488(const QQuaternion *_self, const QVector3D &vec) {
  return ::operator*(*_self, vec);
}


namespace gsi
{

static gsi::Methods methods_QQuaternion () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QQuaternion::QQuaternion()\nThis method creates an object of class QQuaternion.", &_init_ctor_QQuaternion_0, &_call_ctor_QQuaternion_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QQuaternion::QQuaternion(float scalar, float xpos, float ypos, float zpos)\nThis method creates an object of class QQuaternion.", &_init_ctor_QQuaternion_3556, &_call_ctor_QQuaternion_3556);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QQuaternion::QQuaternion(float scalar, const QVector3D &vector)\nThis method creates an object of class QQuaternion.", &_init_ctor_QQuaternion_3002, &_call_ctor_QQuaternion_3002);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QQuaternion::QQuaternion(const QVector4D &vector)\nThis method creates an object of class QQuaternion.", &_init_ctor_QQuaternion_2141, &_call_ctor_QQuaternion_2141);
  methods += new qt_gsi::GenericMethod ("conjugate", "@brief Method QQuaternion QQuaternion::conjugate()\n", true, &_init_f_conjugate_c0, &_call_f_conjugate_c0);
  methods += new qt_gsi::GenericMethod ("conjugated", "@brief Method QQuaternion QQuaternion::conjugated()\n", true, &_init_f_conjugated_c0, &_call_f_conjugated_c0);
  methods += new qt_gsi::GenericMethod ("getAxes", "@brief Method void QQuaternion::getAxes(QVector3D *xAxis, QVector3D *yAxis, QVector3D *zAxis)\n", true, &_init_f_getAxes_c4131, &_call_f_getAxes_c4131);
  methods += new qt_gsi::GenericMethod ("getAxisAndAngle", "@brief Method void QQuaternion::getAxisAndAngle(QVector3D *axis, float *angle)\n", true, &_init_f_getAxisAndAngle_c2497, &_call_f_getAxisAndAngle_c2497);
  methods += new qt_gsi::GenericMethod ("getAxisAndAngle", "@brief Method void QQuaternion::getAxisAndAngle(float *x, float *y, float *z, float *angle)\n", true, &_init_f_getAxisAndAngle_c4300, &_call_f_getAxisAndAngle_c4300);
  methods += new qt_gsi::GenericMethod ("getEulerAngles", "@brief Method void QQuaternion::getEulerAngles(float *pitch, float *yaw, float *roll)\n", true, &_init_f_getEulerAngles_c3252, &_call_f_getEulerAngles_c3252);
  methods += new qt_gsi::GenericMethod ("inverted", "@brief Method QQuaternion QQuaternion::inverted()\n", true, &_init_f_inverted_c0, &_call_f_inverted_c0);
  methods += new qt_gsi::GenericMethod ("isIdentity?", "@brief Method bool QQuaternion::isIdentity()\n", true, &_init_f_isIdentity_c0, &_call_f_isIdentity_c0);
  methods += new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QQuaternion::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
  methods += new qt_gsi::GenericMethod ("length", "@brief Method float QQuaternion::length()\n", true, &_init_f_length_c0, &_call_f_length_c0);
  methods += new qt_gsi::GenericMethod ("lengthSquared", "@brief Method float QQuaternion::lengthSquared()\n", true, &_init_f_lengthSquared_c0, &_call_f_lengthSquared_c0);
  methods += new qt_gsi::GenericMethod ("normalize", "@brief Method void QQuaternion::normalize()\n", false, &_init_f_normalize_0, &_call_f_normalize_0);
  methods += new qt_gsi::GenericMethod ("normalized", "@brief Method QQuaternion QQuaternion::normalized()\n", true, &_init_f_normalized_c0, &_call_f_normalized_c0);
  methods += new qt_gsi::GenericMethod ("*=", "@brief Method QQuaternion &QQuaternion::operator*=(float factor)\n", false, &_init_f_operator_star__eq__970, &_call_f_operator_star__eq__970);
  methods += new qt_gsi::GenericMethod ("*=", "@brief Method QQuaternion &QQuaternion::operator*=(const QQuaternion &quaternion)\n", false, &_init_f_operator_star__eq__2456, &_call_f_operator_star__eq__2456);
  methods += new qt_gsi::GenericMethod ("+=", "@brief Method QQuaternion &QQuaternion::operator+=(const QQuaternion &quaternion)\n", false, &_init_f_operator_plus__eq__2456, &_call_f_operator_plus__eq__2456);
  methods += new qt_gsi::GenericMethod ("-=", "@brief Method QQuaternion &QQuaternion::operator-=(const QQuaternion &quaternion)\n", false, &_init_f_operator_minus__eq__2456, &_call_f_operator_minus__eq__2456);
  methods += new qt_gsi::GenericMethod ("/=", "@brief Method QQuaternion &QQuaternion::operator/=(float divisor)\n", false, &_init_f_operator_slash__eq__970, &_call_f_operator_slash__eq__970);
  methods += new qt_gsi::GenericMethod ("rotatedVector", "@brief Method QVector3D QQuaternion::rotatedVector(const QVector3D &vector)\n", true, &_init_f_rotatedVector_c2140, &_call_f_rotatedVector_c2140);
  methods += new qt_gsi::GenericMethod (":scalar", "@brief Method float QQuaternion::scalar()\n", true, &_init_f_scalar_c0, &_call_f_scalar_c0);
  methods += new qt_gsi::GenericMethod ("setScalar|scalar=", "@brief Method void QQuaternion::setScalar(float scalar)\n", false, &_init_f_setScalar_970, &_call_f_setScalar_970);
  methods += new qt_gsi::GenericMethod ("setVector|vector=", "@brief Method void QQuaternion::setVector(const QVector3D &vector)\n", false, &_init_f_setVector_2140, &_call_f_setVector_2140);
  methods += new qt_gsi::GenericMethod ("setVector", "@brief Method void QQuaternion::setVector(float x, float y, float z)\n", false, &_init_f_setVector_2694, &_call_f_setVector_2694);
  methods += new qt_gsi::GenericMethod ("setX|x=", "@brief Method void QQuaternion::setX(float x)\n", false, &_init_f_setX_970, &_call_f_setX_970);
  methods += new qt_gsi::GenericMethod ("setY|y=", "@brief Method void QQuaternion::setY(float y)\n", false, &_init_f_setY_970, &_call_f_setY_970);
  methods += new qt_gsi::GenericMethod ("setZ|z=", "@brief Method void QQuaternion::setZ(float z)\n", false, &_init_f_setZ_970, &_call_f_setZ_970);
  methods += new qt_gsi::GenericMethod ("toEulerAngles", "@brief Method QVector3D QQuaternion::toEulerAngles()\n", true, &_init_f_toEulerAngles_c0, &_call_f_toEulerAngles_c0);
  methods += new qt_gsi::GenericMethod ("toVector4D", "@brief Method QVector4D QQuaternion::toVector4D()\n", true, &_init_f_toVector4D_c0, &_call_f_toVector4D_c0);
  methods += new qt_gsi::GenericMethod (":vector", "@brief Method QVector3D QQuaternion::vector()\n", true, &_init_f_vector_c0, &_call_f_vector_c0);
  methods += new qt_gsi::GenericMethod (":x", "@brief Method float QQuaternion::x()\n", true, &_init_f_x_c0, &_call_f_x_c0);
  methods += new qt_gsi::GenericMethod (":y", "@brief Method float QQuaternion::y()\n", true, &_init_f_y_c0, &_call_f_y_c0);
  methods += new qt_gsi::GenericMethod (":z", "@brief Method float QQuaternion::z()\n", true, &_init_f_z_c0, &_call_f_z_c0);
  methods += new qt_gsi::GenericStaticMethod ("dotProduct", "@brief Static method float QQuaternion::dotProduct(const QQuaternion &q1, const QQuaternion &q2)\nThis method is static and can be called without an instance.", &_init_f_dotProduct_4804, &_call_f_dotProduct_4804);
  methods += new qt_gsi::GenericStaticMethod ("fromAxes", "@brief Static method QQuaternion QQuaternion::fromAxes(const QVector3D &xAxis, const QVector3D &yAxis, const QVector3D &zAxis)\nThis method is static and can be called without an instance.", &_init_f_fromAxes_6204, &_call_f_fromAxes_6204);
  methods += new qt_gsi::GenericStaticMethod ("fromAxisAndAngle", "@brief Static method QQuaternion QQuaternion::fromAxisAndAngle(const QVector3D &axis, float angle)\nThis method is static and can be called without an instance.", &_init_f_fromAxisAndAngle_3002, &_call_f_fromAxisAndAngle_3002);
  methods += new qt_gsi::GenericStaticMethod ("fromAxisAndAngle", "@brief Static method QQuaternion QQuaternion::fromAxisAndAngle(float x, float y, float z, float angle)\nThis method is static and can be called without an instance.", &_init_f_fromAxisAndAngle_3556, &_call_f_fromAxisAndAngle_3556);
  methods += new qt_gsi::GenericStaticMethod ("fromDirection", "@brief Static method QQuaternion QQuaternion::fromDirection(const QVector3D &direction, const QVector3D &up)\nThis method is static and can be called without an instance.", &_init_f_fromDirection_4172, &_call_f_fromDirection_4172);
  methods += new qt_gsi::GenericStaticMethod ("fromEulerAngles", "@brief Static method QQuaternion QQuaternion::fromEulerAngles(const QVector3D &eulerAngles)\nThis method is static and can be called without an instance.", &_init_f_fromEulerAngles_2140, &_call_f_fromEulerAngles_2140);
  methods += new qt_gsi::GenericStaticMethod ("fromEulerAngles", "@brief Static method QQuaternion QQuaternion::fromEulerAngles(float pitch, float yaw, float roll)\nThis method is static and can be called without an instance.", &_init_f_fromEulerAngles_2694, &_call_f_fromEulerAngles_2694);
  methods += new qt_gsi::GenericStaticMethod ("nlerp", "@brief Static method QQuaternion QQuaternion::nlerp(const QQuaternion &q1, const QQuaternion &q2, float t)\nThis method is static and can be called without an instance.", &_init_f_nlerp_5666, &_call_f_nlerp_5666);
  methods += new qt_gsi::GenericStaticMethod ("rotationTo", "@brief Static method QQuaternion QQuaternion::rotationTo(const QVector3D &from, const QVector3D &to)\nThis method is static and can be called without an instance.", &_init_f_rotationTo_4172, &_call_f_rotationTo_4172);
  methods += new qt_gsi::GenericStaticMethod ("slerp", "@brief Static method QQuaternion QQuaternion::slerp(const QQuaternion &q1, const QQuaternion &q2, float t)\nThis method is static and can be called without an instance.", &_init_f_slerp_5666, &_call_f_slerp_5666);
  methods += gsi::method_ext("*", &::op_QQuaternion_operator_star__4804, gsi::arg ("q2"), "@brief Operator const QQuaternion ::operator*(const QQuaternion &q1, const QQuaternion &q2)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("==", &::op_QQuaternion_operator_eq__eq__4804, gsi::arg ("q2"), "@brief Operator bool ::operator==(const QQuaternion &q1, const QQuaternion &q2)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("!=", &::op_QQuaternion_operator_excl__eq__4804, gsi::arg ("q2"), "@brief Operator bool ::operator!=(const QQuaternion &q1, const QQuaternion &q2)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("+", &::op_QQuaternion_operator_plus__4804, gsi::arg ("q2"), "@brief Operator const QQuaternion ::operator+(const QQuaternion &q1, const QQuaternion &q2)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("-", &::op_QQuaternion_operator_minus__4804, gsi::arg ("q2"), "@brief Operator const QQuaternion ::operator-(const QQuaternion &q1, const QQuaternion &q2)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("*", &::op_QQuaternion_operator_star__3318, gsi::arg ("factor"), "@brief Operator const QQuaternion ::operator*(const QQuaternion &quaternion, float factor)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("-", &::op_QQuaternion_operator_minus__2456, "@brief Operator const QQuaternion ::operator-(const QQuaternion &quaternion)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("/", &::op_QQuaternion_operator_slash__3318, gsi::arg ("divisor"), "@brief Operator const QQuaternion ::operator/(const QQuaternion &quaternion, float divisor)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("*", &::op_QQuaternion_operator_star__4488, gsi::arg ("vec"), "@brief Operator QVector3D ::operator*(const QQuaternion &quaternion, const QVector3D &vec)\nThis is the mapping of the global operator to the instance method.");
  return methods;
}

gsi::Class<QQuaternion> decl_QQuaternion ("QQuaternion",
  methods_QQuaternion (),
  "@qt\n@brief Binding of QQuaternion");


GSIQT_PUBLIC gsi::Class<QQuaternion> &qtdecl_QQuaternion () { return decl_QQuaternion; }

}

