
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRasterWindow.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QRasterWindow>
#include <QAccessibleInterface>
#include <QChildEvent>
#include <QCursor>
#include <QEvent>
#include <QExposeEvent>
#include <QFocusEvent>
#include <QHideEvent>
#include <QIcon>
#include <QKeyEvent>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEvent>
#include <QPainter>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScreen>
#include <QShowEvent>
#include <QSize>
#include <QSurfaceFormat>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QTouchEvent>
#include <QWheelEvent>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRasterWindow

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QRasterWindow::staticMetaObject);
}


// static QString QRasterWindow::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(__null);
  int arg3 = args ? args.read<int > (heap) : (int)(-1);
  ret.write<QString > ((QString)QRasterWindow::tr (arg1, arg2, arg3));
}


// static QString QRasterWindow::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(__null);
  int arg3 = args ? args.read<int > (heap) : (int)(-1);
  ret.write<QString > ((QString)QRasterWindow::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QRasterWindow () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += gsi::qt_signal ("activeChanged()", "activeChanged", "@brief Signal declaration for QRasterWindow::activeChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > ("contentOrientationChanged(Qt::ScreenOrientation)", "contentOrientationChanged", gsi::arg("orientation"), "@brief Signal declaration for QRasterWindow::contentOrientationChanged(Qt::ScreenOrientation orientation)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QRasterWindow::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("focusObjectChanged(QObject *)", "focusObjectChanged", gsi::arg("object"), "@brief Signal declaration for QRasterWindow::focusObjectChanged(QObject *object)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("heightChanged(int)", "heightChanged", gsi::arg("arg"), "@brief Signal declaration for QRasterWindow::heightChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("maximumHeightChanged(int)", "maximumHeightChanged", gsi::arg("arg"), "@brief Signal declaration for QRasterWindow::maximumHeightChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("maximumWidthChanged(int)", "maximumWidthChanged", gsi::arg("arg"), "@brief Signal declaration for QRasterWindow::maximumWidthChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("minimumHeightChanged(int)", "minimumHeightChanged", gsi::arg("arg"), "@brief Signal declaration for QRasterWindow::minimumHeightChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("minimumWidthChanged(int)", "minimumWidthChanged", gsi::arg("arg"), "@brief Signal declaration for QRasterWindow::minimumWidthChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::WindowModality>::target_type & > ("modalityChanged(Qt::WindowModality)", "modalityChanged", gsi::arg("modality"), "@brief Signal declaration for QRasterWindow::modalityChanged(Qt::WindowModality modality)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<double > ("opacityChanged(double)", "opacityChanged", gsi::arg("opacity"), "@brief Signal declaration for QRasterWindow::opacityChanged(double opacity)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QScreen * > ("screenChanged(QScreen *)", "screenChanged", gsi::arg("screen"), "@brief Signal declaration for QRasterWindow::screenChanged(QScreen *screen)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QWindow::Visibility>::target_type & > ("visibilityChanged(QWindow::Visibility)", "visibilityChanged", gsi::arg("visibility"), "@brief Signal declaration for QRasterWindow::visibilityChanged(QWindow::Visibility visibility)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("visibleChanged(bool)", "visibleChanged", gsi::arg("arg"), "@brief Signal declaration for QRasterWindow::visibleChanged(bool arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("widthChanged(int)", "widthChanged", gsi::arg("arg"), "@brief Signal declaration for QRasterWindow::widthChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<Qt::WindowState>::target_type & > ("windowStateChanged(Qt::WindowState)", "windowStateChanged", gsi::arg("windowState"), "@brief Signal declaration for QRasterWindow::windowStateChanged(Qt::WindowState windowState)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QRasterWindow::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("xChanged(int)", "xChanged", gsi::arg("arg"), "@brief Signal declaration for QRasterWindow::xChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("yChanged(int)", "yChanged", gsi::arg("arg"), "@brief Signal declaration for QRasterWindow::yChanged(int arg)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QRasterWindow::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QRasterWindow::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QPaintDeviceWindow> &qtdecl_QPaintDeviceWindow ();

qt_gsi::QtNativeClass<QRasterWindow> decl_QRasterWindow (qtdecl_QPaintDeviceWindow (), "QRasterWindow_Native",
  methods_QRasterWindow (),
  "@hide\n@alias QRasterWindow");

GSIQT_PUBLIC gsi::Class<QRasterWindow> &qtdecl_QRasterWindow () { return decl_QRasterWindow; }

}


class QRasterWindow_Adaptor : public QRasterWindow, public qt_gsi::QtObjectBase
{
public:

  virtual ~QRasterWindow_Adaptor();

  //  [adaptor ctor] QRasterWindow::QRasterWindow(QWindow *parent)
  QRasterWindow_Adaptor() : QRasterWindow()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QRasterWindow::QRasterWindow(QWindow *parent)
  QRasterWindow_Adaptor(QWindow *parent) : QRasterWindow(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QRasterWindow::isSignalConnected(const QMetaMethod &signal)
  bool fp_QRasterWindow_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QRasterWindow::isSignalConnected(signal);
  }

  //  [expose] int QRasterWindow::receivers(const char *signal)
  int fp_QRasterWindow_receivers_c1731 (const char *signal) const {
    return QRasterWindow::receivers(signal);
  }

  //  [expose] QObject *QRasterWindow::sender()
  QObject * fp_QRasterWindow_sender_c0 () const {
    return QRasterWindow::sender();
  }

  //  [expose] int QRasterWindow::senderSignalIndex()
  int fp_QRasterWindow_senderSignalIndex_c0 () const {
    return QRasterWindow::senderSignalIndex();
  }

  //  [adaptor impl] QAccessibleInterface *QRasterWindow::accessibleRoot()
  QAccessibleInterface * cbs_accessibleRoot_c0_0() const
  {
    return QRasterWindow::accessibleRoot();
  }

  virtual QAccessibleInterface * accessibleRoot() const
  {
    if (cb_accessibleRoot_c0_0.can_issue()) {
      return cb_accessibleRoot_c0_0.issue<QRasterWindow_Adaptor, QAccessibleInterface *>(&QRasterWindow_Adaptor::cbs_accessibleRoot_c0_0);
    } else {
      return QRasterWindow::accessibleRoot();
    }
  }

  //  [emitter impl] void QRasterWindow::activeChanged()
  void emitter_QRasterWindow_activeChanged_0()
  {
    emit QRasterWindow::activeChanged();
  }

  //  [emitter impl] void QRasterWindow::contentOrientationChanged(Qt::ScreenOrientation orientation)
  void emitter_QRasterWindow_contentOrientationChanged_2521(Qt::ScreenOrientation orientation)
  {
    emit QRasterWindow::contentOrientationChanged(orientation);
  }

  //  [emitter impl] void QRasterWindow::destroyed(QObject *)
  void emitter_QRasterWindow_destroyed_1302(QObject *arg1)
  {
    emit QRasterWindow::destroyed(arg1);
  }

  //  [adaptor impl] bool QRasterWindow::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QRasterWindow::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QRasterWindow_Adaptor, bool, QObject *, QEvent *>(&QRasterWindow_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QRasterWindow::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QObject *QRasterWindow::focusObject()
  QObject * cbs_focusObject_c0_0() const
  {
    return QRasterWindow::focusObject();
  }

  virtual QObject * focusObject() const
  {
    if (cb_focusObject_c0_0.can_issue()) {
      return cb_focusObject_c0_0.issue<QRasterWindow_Adaptor, QObject *>(&QRasterWindow_Adaptor::cbs_focusObject_c0_0);
    } else {
      return QRasterWindow::focusObject();
    }
  }

  //  [emitter impl] void QRasterWindow::focusObjectChanged(QObject *object)
  void emitter_QRasterWindow_focusObjectChanged_1302(QObject *object)
  {
    emit QRasterWindow::focusObjectChanged(object);
  }

  //  [adaptor impl] QSurfaceFormat QRasterWindow::format()
  QSurfaceFormat cbs_format_c0_0() const
  {
    return QRasterWindow::format();
  }

  virtual QSurfaceFormat format() const
  {
    if (cb_format_c0_0.can_issue()) {
      return cb_format_c0_0.issue<QRasterWindow_Adaptor, QSurfaceFormat>(&QRasterWindow_Adaptor::cbs_format_c0_0);
    } else {
      return QRasterWindow::format();
    }
  }

  //  [emitter impl] void QRasterWindow::heightChanged(int arg)
  void emitter_QRasterWindow_heightChanged_767(int arg)
  {
    emit QRasterWindow::heightChanged(arg);
  }

  //  [emitter impl] void QRasterWindow::maximumHeightChanged(int arg)
  void emitter_QRasterWindow_maximumHeightChanged_767(int arg)
  {
    emit QRasterWindow::maximumHeightChanged(arg);
  }

  //  [emitter impl] void QRasterWindow::maximumWidthChanged(int arg)
  void emitter_QRasterWindow_maximumWidthChanged_767(int arg)
  {
    emit QRasterWindow::maximumWidthChanged(arg);
  }

  //  [emitter impl] void QRasterWindow::minimumHeightChanged(int arg)
  void emitter_QRasterWindow_minimumHeightChanged_767(int arg)
  {
    emit QRasterWindow::minimumHeightChanged(arg);
  }

  //  [emitter impl] void QRasterWindow::minimumWidthChanged(int arg)
  void emitter_QRasterWindow_minimumWidthChanged_767(int arg)
  {
    emit QRasterWindow::minimumWidthChanged(arg);
  }

  //  [emitter impl] void QRasterWindow::modalityChanged(Qt::WindowModality modality)
  void emitter_QRasterWindow_modalityChanged_2216(Qt::WindowModality modality)
  {
    emit QRasterWindow::modalityChanged(modality);
  }

  //  [emitter impl] void QRasterWindow::opacityChanged(double opacity)
  void emitter_QRasterWindow_opacityChanged_1071(double opacity)
  {
    emit QRasterWindow::opacityChanged(opacity);
  }

  //  [emitter impl] void QRasterWindow::screenChanged(QScreen *screen)
  void emitter_QRasterWindow_screenChanged_1311(QScreen *screen)
  {
    emit QRasterWindow::screenChanged(screen);
  }

  //  [adaptor impl] QSize QRasterWindow::size()
  QSize cbs_size_c0_0() const
  {
    return QRasterWindow::size();
  }

  virtual QSize size() const
  {
    if (cb_size_c0_0.can_issue()) {
      return cb_size_c0_0.issue<QRasterWindow_Adaptor, QSize>(&QRasterWindow_Adaptor::cbs_size_c0_0);
    } else {
      return QRasterWindow::size();
    }
  }

  //  [adaptor impl] QSurface::SurfaceType QRasterWindow::surfaceType()
  qt_gsi::Converter<QSurface::SurfaceType>::target_type cbs_surfaceType_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QSurface::SurfaceType>(QRasterWindow::surfaceType());
  }

  virtual QSurface::SurfaceType surfaceType() const
  {
    if (cb_surfaceType_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QSurface::SurfaceType>(cb_surfaceType_c0_0.issue<QRasterWindow_Adaptor, qt_gsi::Converter<QSurface::SurfaceType>::target_type>(&QRasterWindow_Adaptor::cbs_surfaceType_c0_0)).cref();
    } else {
      return QRasterWindow::surfaceType();
    }
  }

  //  [emitter impl] void QRasterWindow::visibilityChanged(QWindow::Visibility visibility)
  void emitter_QRasterWindow_visibilityChanged_2329(QWindow::Visibility visibility)
  {
    emit QRasterWindow::visibilityChanged(visibility);
  }

  //  [emitter impl] void QRasterWindow::visibleChanged(bool arg)
  void emitter_QRasterWindow_visibleChanged_864(bool arg)
  {
    emit QRasterWindow::visibleChanged(arg);
  }

  //  [emitter impl] void QRasterWindow::widthChanged(int arg)
  void emitter_QRasterWindow_widthChanged_767(int arg)
  {
    emit QRasterWindow::widthChanged(arg);
  }

  //  [emitter impl] void QRasterWindow::windowStateChanged(Qt::WindowState windowState)
  void emitter_QRasterWindow_windowStateChanged_1894(Qt::WindowState windowState)
  {
    emit QRasterWindow::windowStateChanged(windowState);
  }

  //  [emitter impl] void QRasterWindow::windowTitleChanged(const QString &title)
  void emitter_QRasterWindow_windowTitleChanged_2025(const QString &title)
  {
    emit QRasterWindow::windowTitleChanged(title);
  }

  //  [emitter impl] void QRasterWindow::xChanged(int arg)
  void emitter_QRasterWindow_xChanged_767(int arg)
  {
    emit QRasterWindow::xChanged(arg);
  }

  //  [emitter impl] void QRasterWindow::yChanged(int arg)
  void emitter_QRasterWindow_yChanged_767(int arg)
  {
    emit QRasterWindow::yChanged(arg);
  }

  //  [adaptor impl] void QRasterWindow::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QRasterWindow::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QRasterWindow_Adaptor, QChildEvent *>(&QRasterWindow_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QRasterWindow::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QRasterWindow::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QRasterWindow_Adaptor, QEvent *>(&QRasterWindow_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QRasterWindow::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QRasterWindow::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QRasterWindow_Adaptor, const QMetaMethod &>(&QRasterWindow_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QRasterWindow::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QRasterWindow::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QRasterWindow::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QRasterWindow_Adaptor, bool, QEvent *>(&QRasterWindow_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QRasterWindow::event(_event);
    }
  }

  //  [adaptor impl] void QRasterWindow::exposeEvent(QExposeEvent *)
  void cbs_exposeEvent_1845_0(QExposeEvent *arg1)
  {
    QRasterWindow::exposeEvent(arg1);
  }

  virtual void exposeEvent(QExposeEvent *arg1)
  {
    if (cb_exposeEvent_1845_0.can_issue()) {
      cb_exposeEvent_1845_0.issue<QRasterWindow_Adaptor, QExposeEvent *>(&QRasterWindow_Adaptor::cbs_exposeEvent_1845_0, arg1);
    } else {
      QRasterWindow::exposeEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QRasterWindow::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QRasterWindow_Adaptor, QFocusEvent *>(&QRasterWindow_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QRasterWindow::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QRasterWindow::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QRasterWindow_Adaptor, QFocusEvent *>(&QRasterWindow_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QRasterWindow::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QRasterWindow::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QRasterWindow_Adaptor, QHideEvent *>(&QRasterWindow_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QRasterWindow::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QRasterWindow::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QRasterWindow_Adaptor, QPainter *>(&QRasterWindow_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QRasterWindow::initPainter(painter);
    }
  }

  //  [adaptor impl] void QRasterWindow::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QRasterWindow::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QRasterWindow_Adaptor, QKeyEvent *>(&QRasterWindow_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QRasterWindow::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QRasterWindow::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QRasterWindow_Adaptor, QKeyEvent *>(&QRasterWindow_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QRasterWindow::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] int QRasterWindow::metric(QPaintDevice::PaintDeviceMetric metric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & _metric) const
  {
    return QRasterWindow::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(_metric).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric _metric) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QRasterWindow_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QRasterWindow_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(_metric));
    } else {
      return QRasterWindow::metric(_metric);
    }
  }

  //  [adaptor impl] void QRasterWindow::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QRasterWindow::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QRasterWindow_Adaptor, QMouseEvent *>(&QRasterWindow_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QRasterWindow::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QRasterWindow::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QRasterWindow_Adaptor, QMouseEvent *>(&QRasterWindow_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QRasterWindow::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QRasterWindow::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QRasterWindow_Adaptor, QMouseEvent *>(&QRasterWindow_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QRasterWindow::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QRasterWindow::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QRasterWindow_Adaptor, QMouseEvent *>(&QRasterWindow_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QRasterWindow::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QRasterWindow::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QRasterWindow_Adaptor, QMoveEvent *>(&QRasterWindow_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QRasterWindow::moveEvent(arg1);
    }
  }

  //  [adaptor impl] bool QRasterWindow::nativeEvent(const QByteArray &eventType, void *message, long int *result)
  bool cbs_nativeEvent_4678_0(const QByteArray &eventType, void *message, long int *result)
  {
    return QRasterWindow::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, long int *result)
  {
    if (cb_nativeEvent_4678_0.can_issue()) {
      return cb_nativeEvent_4678_0.issue<QRasterWindow_Adaptor, bool, const QByteArray &, void *, long int *>(&QRasterWindow_Adaptor::cbs_nativeEvent_4678_0, eventType, message, result);
    } else {
      return QRasterWindow::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QRasterWindow::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QRasterWindow::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QRasterWindow_Adaptor, QPaintEvent *>(&QRasterWindow_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QRasterWindow::paintEvent(event);
    }
  }

  //  [adaptor impl] QPaintDevice *QRasterWindow::redirected(QPoint *)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *arg1) const
  {
    return QRasterWindow::redirected(arg1);
  }

  virtual QPaintDevice * redirected(QPoint *arg1) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QRasterWindow_Adaptor, QPaintDevice *, QPoint *>(&QRasterWindow_Adaptor::cbs_redirected_c1225_0, arg1);
    } else {
      return QRasterWindow::redirected(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QRasterWindow::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QRasterWindow_Adaptor, QResizeEvent *>(&QRasterWindow_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QRasterWindow::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] QPainter *QRasterWindow::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QRasterWindow::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QRasterWindow_Adaptor, QPainter *>(&QRasterWindow_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QRasterWindow::sharedPainter();
    }
  }

  //  [adaptor impl] void QRasterWindow::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QRasterWindow::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QRasterWindow_Adaptor, QShowEvent *>(&QRasterWindow_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QRasterWindow::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QRasterWindow::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QRasterWindow_Adaptor, QTabletEvent *>(&QRasterWindow_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QRasterWindow::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QRasterWindow::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QRasterWindow_Adaptor, QTimerEvent *>(&QRasterWindow_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QRasterWindow::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::touchEvent(QTouchEvent *)
  void cbs_touchEvent_1732_0(QTouchEvent *arg1)
  {
    QRasterWindow::touchEvent(arg1);
  }

  virtual void touchEvent(QTouchEvent *arg1)
  {
    if (cb_touchEvent_1732_0.can_issue()) {
      cb_touchEvent_1732_0.issue<QRasterWindow_Adaptor, QTouchEvent *>(&QRasterWindow_Adaptor::cbs_touchEvent_1732_0, arg1);
    } else {
      QRasterWindow::touchEvent(arg1);
    }
  }

  //  [adaptor impl] void QRasterWindow::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QRasterWindow::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QRasterWindow_Adaptor, QWheelEvent *>(&QRasterWindow_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QRasterWindow::wheelEvent(arg1);
    }
  }

  gsi::Callback cb_accessibleRoot_c0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusObject_c0_0;
  gsi::Callback cb_format_c0_0;
  gsi::Callback cb_size_c0_0;
  gsi::Callback cb_surfaceType_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_exposeEvent_1845_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_4678_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_touchEvent_1732_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QRasterWindow_Adaptor::~QRasterWindow_Adaptor() { }

//  Constructor QRasterWindow::QRasterWindow(QWindow *parent) (adaptor class)

static void _init_ctor_QRasterWindow_Adaptor_1335 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWindow * > (argspec_0);
  decl->set_return_new<QRasterWindow_Adaptor> ();
}

static void _call_ctor_QRasterWindow_Adaptor_1335 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWindow *arg1 = args ? args.read<QWindow * > (heap) : (QWindow *)(0);
  ret.write<QRasterWindow_Adaptor *> (new QRasterWindow_Adaptor (arg1));
}


// QAccessibleInterface *QRasterWindow::accessibleRoot()

static void _init_cbs_accessibleRoot_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_cbs_accessibleRoot_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)((QRasterWindow_Adaptor *)cls)->cbs_accessibleRoot_c0_0 ());
}

static void _set_callback_cbs_accessibleRoot_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_accessibleRoot_c0_0 = cb;
}


// emitter void QRasterWindow::activeChanged()

static void _init_emitter_activeChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_activeChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_activeChanged_0 ();
}


// void QRasterWindow::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QRasterWindow::contentOrientationChanged(Qt::ScreenOrientation orientation)

static void _init_emitter_contentOrientationChanged_2521 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_contentOrientationChanged_2521 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::ScreenOrientation>::target_type & > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_contentOrientationChanged_2521 (arg1);
}


// void QRasterWindow::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QRasterWindow::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_destroyed_1302 (arg1);
}


// void QRasterWindow::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QRasterWindow::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRasterWindow_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QRasterWindow::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QRasterWindow_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QRasterWindow::exposeEvent(QExposeEvent *)

static void _init_cbs_exposeEvent_1845_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QExposeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_exposeEvent_1845_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QExposeEvent *arg1 = args.read<QExposeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_exposeEvent_1845_0 (arg1);
}

static void _set_callback_cbs_exposeEvent_1845_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_exposeEvent_1845_0 = cb;
}


// void QRasterWindow::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// QObject *QRasterWindow::focusObject()

static void _init_cbs_focusObject_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_cbs_focusObject_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QRasterWindow_Adaptor *)cls)->cbs_focusObject_c0_0 ());
}

static void _set_callback_cbs_focusObject_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_focusObject_c0_0 = cb;
}


// emitter void QRasterWindow::focusObjectChanged(QObject *object)

static void _init_emitter_focusObjectChanged_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_focusObjectChanged_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_focusObjectChanged_1302 (arg1);
}


// void QRasterWindow::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// QSurfaceFormat QRasterWindow::format()

static void _init_cbs_format_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSurfaceFormat > ();
}

static void _call_cbs_format_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSurfaceFormat > ((QSurfaceFormat)((QRasterWindow_Adaptor *)cls)->cbs_format_c0_0 ());
}

static void _set_callback_cbs_format_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_format_c0_0 = cb;
}


// emitter void QRasterWindow::heightChanged(int arg)

static void _init_emitter_heightChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_heightChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_heightChanged_767 (arg1);
}


// void QRasterWindow::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QRasterWindow::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// exposed bool QRasterWindow::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  ret.write<bool > ((bool)((QRasterWindow_Adaptor *)cls)->fp_QRasterWindow_isSignalConnected_c2394 (arg1));
}


// void QRasterWindow::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QRasterWindow::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// emitter void QRasterWindow::maximumHeightChanged(int arg)

static void _init_emitter_maximumHeightChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_maximumHeightChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_maximumHeightChanged_767 (arg1);
}


// emitter void QRasterWindow::maximumWidthChanged(int arg)

static void _init_emitter_maximumWidthChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_maximumWidthChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_maximumWidthChanged_767 (arg1);
}


// int QRasterWindow::metric(QPaintDevice::PaintDeviceMetric metric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QRasterWindow_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// emitter void QRasterWindow::minimumHeightChanged(int arg)

static void _init_emitter_minimumHeightChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_minimumHeightChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_minimumHeightChanged_767 (arg1);
}


// emitter void QRasterWindow::minimumWidthChanged(int arg)

static void _init_emitter_minimumWidthChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_minimumWidthChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_minimumWidthChanged_767 (arg1);
}


// emitter void QRasterWindow::modalityChanged(Qt::WindowModality modality)

static void _init_emitter_modalityChanged_2216 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("modality");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowModality>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_modalityChanged_2216 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WindowModality>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::WindowModality>::target_type & > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_modalityChanged_2216 (arg1);
}


// void QRasterWindow::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QRasterWindow::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QRasterWindow::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QRasterWindow::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QRasterWindow::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QRasterWindow::nativeEvent(const QByteArray &eventType, void *message, long int *result)

static void _init_cbs_nativeEvent_4678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<long int * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_4678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  long int *arg3 = args.read<long int * > (heap);
  ret.write<bool > ((bool)((QRasterWindow_Adaptor *)cls)->cbs_nativeEvent_4678_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_4678_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_nativeEvent_4678_0 = cb;
}


// emitter void QRasterWindow::opacityChanged(double opacity)

static void _init_emitter_opacityChanged_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opacity");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_opacityChanged_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_opacityChanged_1071 (arg1);
}


// void QRasterWindow::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QRasterWindow::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<int > ((int)((QRasterWindow_Adaptor *)cls)->fp_QRasterWindow_receivers_c1731 (arg1));
}


// QPaintDevice *QRasterWindow::redirected(QPoint *)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QRasterWindow_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QRasterWindow::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// emitter void QRasterWindow::screenChanged(QScreen *screen)

static void _init_emitter_screenChanged_1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("screen");
  decl->add_arg<QScreen * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_screenChanged_1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QScreen *arg1 = args.read<QScreen * > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_screenChanged_1311 (arg1);
}


// exposed QObject *QRasterWindow::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QRasterWindow_Adaptor *)cls)->fp_QRasterWindow_sender_c0 ());
}


// exposed int QRasterWindow::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRasterWindow_Adaptor *)cls)->fp_QRasterWindow_senderSignalIndex_c0 ());
}


// QPainter *QRasterWindow::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QRasterWindow_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QRasterWindow::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QRasterWindow::size()

static void _init_cbs_size_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_size_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QRasterWindow_Adaptor *)cls)->cbs_size_c0_0 ());
}

static void _set_callback_cbs_size_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_size_c0_0 = cb;
}


// QSurface::SurfaceType QRasterWindow::surfaceType()

static void _init_cbs_surfaceType_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSurface::SurfaceType>::target_type > ();
}

static void _call_cbs_surfaceType_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSurface::SurfaceType>::target_type > ((qt_gsi::Converter<QSurface::SurfaceType>::target_type)((QRasterWindow_Adaptor *)cls)->cbs_surfaceType_c0_0 ());
}

static void _set_callback_cbs_surfaceType_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_surfaceType_c0_0 = cb;
}


// void QRasterWindow::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QRasterWindow::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QRasterWindow::touchEvent(QTouchEvent *)

static void _init_cbs_touchEvent_1732_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTouchEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_touchEvent_1732_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTouchEvent *arg1 = args.read<QTouchEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_touchEvent_1732_0 (arg1);
}

static void _set_callback_cbs_touchEvent_1732_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_touchEvent_1732_0 = cb;
}


// emitter void QRasterWindow::visibilityChanged(QWindow::Visibility visibility)

static void _init_emitter_visibilityChanged_2329 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visibility");
  decl->add_arg<const qt_gsi::Converter<QWindow::Visibility>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_visibilityChanged_2329 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QWindow::Visibility>::target_type & arg1 = args.read<const qt_gsi::Converter<QWindow::Visibility>::target_type & > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_visibilityChanged_2329 (arg1);
}


// emitter void QRasterWindow::visibleChanged(bool arg)

static void _init_emitter_visibleChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_visibleChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_visibleChanged_864 (arg1);
}


// void QRasterWindow::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRasterWindow_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QRasterWindow_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QRasterWindow::widthChanged(int arg)

static void _init_emitter_widthChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_widthChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_widthChanged_767 (arg1);
}


// emitter void QRasterWindow::windowStateChanged(Qt::WindowState windowState)

static void _init_emitter_windowStateChanged_1894 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("windowState");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowState>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowStateChanged_1894 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::WindowState>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::WindowState>::target_type & > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_windowStateChanged_1894 (arg1);
}


// emitter void QRasterWindow::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_windowTitleChanged_2025 (arg1);
}


// emitter void QRasterWindow::xChanged(int arg)

static void _init_emitter_xChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_xChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_xChanged_767 (arg1);
}


// emitter void QRasterWindow::yChanged(int arg)

static void _init_emitter_yChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_yChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ((QRasterWindow_Adaptor *)cls)->emitter_QRasterWindow_yChanged_767 (arg1);
}


namespace gsi
{

gsi::Class<QRasterWindow> &qtdecl_QRasterWindow ();

static gsi::Methods methods_QRasterWindow_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRasterWindow::QRasterWindow(QWindow *parent)\nThis method creates an object of class QRasterWindow.", &_init_ctor_QRasterWindow_Adaptor_1335, &_call_ctor_QRasterWindow_Adaptor_1335);
  methods += new qt_gsi::GenericMethod ("accessibleRoot", "@hide", true, &_init_cbs_accessibleRoot_c0_0, &_call_cbs_accessibleRoot_c0_0);
  methods += new qt_gsi::GenericMethod ("accessibleRoot", "@brief Virtual method QAccessibleInterface *QRasterWindow::accessibleRoot()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_accessibleRoot_c0_0, &_call_cbs_accessibleRoot_c0_0, &_set_callback_cbs_accessibleRoot_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_activeChanged", "@brief Emitter for signal void QRasterWindow::activeChanged()\nCall this method to emit this signal.", false, &_init_emitter_activeChanged_0, &_call_emitter_activeChanged_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QRasterWindow::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_contentOrientationChanged", "@brief Emitter for signal void QRasterWindow::contentOrientationChanged(Qt::ScreenOrientation orientation)\nCall this method to emit this signal.", false, &_init_emitter_contentOrientationChanged_2521, &_call_emitter_contentOrientationChanged_2521);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QRasterWindow::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QRasterWindow::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QRasterWindow::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QRasterWindow::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QRasterWindow::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*exposeEvent", "@hide", false, &_init_cbs_exposeEvent_1845_0, &_call_cbs_exposeEvent_1845_0);
  methods += new qt_gsi::GenericMethod ("*exposeEvent", "@brief Virtual method void QRasterWindow::exposeEvent(QExposeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_exposeEvent_1845_0, &_call_cbs_exposeEvent_1845_0, &_set_callback_cbs_exposeEvent_1845_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QRasterWindow::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("focusObject", "@hide", true, &_init_cbs_focusObject_c0_0, &_call_cbs_focusObject_c0_0);
  methods += new qt_gsi::GenericMethod ("focusObject", "@brief Virtual method QObject *QRasterWindow::focusObject()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_focusObject_c0_0, &_call_cbs_focusObject_c0_0, &_set_callback_cbs_focusObject_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_focusObjectChanged", "@brief Emitter for signal void QRasterWindow::focusObjectChanged(QObject *object)\nCall this method to emit this signal.", false, &_init_emitter_focusObjectChanged_1302, &_call_emitter_focusObjectChanged_1302);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QRasterWindow::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("format", "@hide", true, &_init_cbs_format_c0_0, &_call_cbs_format_c0_0);
  methods += new qt_gsi::GenericMethod ("format", "@brief Virtual method QSurfaceFormat QRasterWindow::format()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_format_c0_0, &_call_cbs_format_c0_0, &_set_callback_cbs_format_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_heightChanged", "@brief Emitter for signal void QRasterWindow::heightChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_heightChanged_767, &_call_emitter_heightChanged_767);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QRasterWindow::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QRasterWindow::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QRasterWindow::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QRasterWindow::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QRasterWindow::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("emit_maximumHeightChanged", "@brief Emitter for signal void QRasterWindow::maximumHeightChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_maximumHeightChanged_767, &_call_emitter_maximumHeightChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_maximumWidthChanged", "@brief Emitter for signal void QRasterWindow::maximumWidthChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_maximumWidthChanged_767, &_call_emitter_maximumWidthChanged_767);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QRasterWindow::metric(QPaintDevice::PaintDeviceMetric metric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("emit_minimumHeightChanged", "@brief Emitter for signal void QRasterWindow::minimumHeightChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_minimumHeightChanged_767, &_call_emitter_minimumHeightChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_minimumWidthChanged", "@brief Emitter for signal void QRasterWindow::minimumWidthChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_minimumWidthChanged_767, &_call_emitter_minimumWidthChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_modalityChanged", "@brief Emitter for signal void QRasterWindow::modalityChanged(Qt::WindowModality modality)\nCall this method to emit this signal.", false, &_init_emitter_modalityChanged_2216, &_call_emitter_modalityChanged_2216);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QRasterWindow::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QRasterWindow::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QRasterWindow::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QRasterWindow::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QRasterWindow::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QRasterWindow::nativeEvent(const QByteArray &eventType, void *message, long int *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0, &_set_callback_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("emit_opacityChanged", "@brief Emitter for signal void QRasterWindow::opacityChanged(double opacity)\nCall this method to emit this signal.", false, &_init_emitter_opacityChanged_1071, &_call_emitter_opacityChanged_1071);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QRasterWindow::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QRasterWindow::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QRasterWindow::redirected(QPoint *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QRasterWindow::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("emit_screenChanged", "@brief Emitter for signal void QRasterWindow::screenChanged(QScreen *screen)\nCall this method to emit this signal.", false, &_init_emitter_screenChanged_1311, &_call_emitter_screenChanged_1311);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QRasterWindow::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QRasterWindow::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QRasterWindow::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QRasterWindow::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("size", "@hide", true, &_init_cbs_size_c0_0, &_call_cbs_size_c0_0);
  methods += new qt_gsi::GenericMethod ("size", "@brief Virtual method QSize QRasterWindow::size()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_size_c0_0, &_call_cbs_size_c0_0, &_set_callback_cbs_size_c0_0);
  methods += new qt_gsi::GenericMethod ("surfaceType", "@hide", true, &_init_cbs_surfaceType_c0_0, &_call_cbs_surfaceType_c0_0);
  methods += new qt_gsi::GenericMethod ("surfaceType", "@brief Virtual method QSurface::SurfaceType QRasterWindow::surfaceType()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_surfaceType_c0_0, &_call_cbs_surfaceType_c0_0, &_set_callback_cbs_surfaceType_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QRasterWindow::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QRasterWindow::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*touchEvent", "@hide", false, &_init_cbs_touchEvent_1732_0, &_call_cbs_touchEvent_1732_0);
  methods += new qt_gsi::GenericMethod ("*touchEvent", "@brief Virtual method void QRasterWindow::touchEvent(QTouchEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_touchEvent_1732_0, &_call_cbs_touchEvent_1732_0, &_set_callback_cbs_touchEvent_1732_0);
  methods += new qt_gsi::GenericMethod ("emit_visibilityChanged", "@brief Emitter for signal void QRasterWindow::visibilityChanged(QWindow::Visibility visibility)\nCall this method to emit this signal.", false, &_init_emitter_visibilityChanged_2329, &_call_emitter_visibilityChanged_2329);
  methods += new qt_gsi::GenericMethod ("emit_visibleChanged", "@brief Emitter for signal void QRasterWindow::visibleChanged(bool arg)\nCall this method to emit this signal.", false, &_init_emitter_visibleChanged_864, &_call_emitter_visibleChanged_864);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QRasterWindow::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_widthChanged", "@brief Emitter for signal void QRasterWindow::widthChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_widthChanged_767, &_call_emitter_widthChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_windowStateChanged", "@brief Emitter for signal void QRasterWindow::windowStateChanged(Qt::WindowState windowState)\nCall this method to emit this signal.", false, &_init_emitter_windowStateChanged_1894, &_call_emitter_windowStateChanged_1894);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QRasterWindow::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_xChanged", "@brief Emitter for signal void QRasterWindow::xChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_xChanged_767, &_call_emitter_xChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_yChanged", "@brief Emitter for signal void QRasterWindow::yChanged(int arg)\nCall this method to emit this signal.", false, &_init_emitter_yChanged_767, &_call_emitter_yChanged_767);
  return methods;
}

gsi::Class<QRasterWindow_Adaptor> decl_QRasterWindow_Adaptor (qtdecl_QRasterWindow (), "QRasterWindow",
  methods_QRasterWindow_Adaptor (),
  "@qt\n@brief Binding of QRasterWindow");

}

