
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRawFont.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QRawFont>
#include <QFont>
#include <QImage>
#include <QPainterPath>
#include <QPointF>
#include <QRectF>
#include <QTransform>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRawFont

//  Constructor QRawFont::QRawFont()


static void _init_ctor_QRawFont_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QRawFont> ();
}

static void _call_ctor_QRawFont_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRawFont *> (new QRawFont ());
}


//  Constructor QRawFont::QRawFont(const QString &fileName, double pixelSize, QFont::HintingPreference hintingPreference)


static void _init_ctor_QRawFont_5664 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixelSize");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("hintingPreference", true, "QFont::PreferDefaultHinting");
  decl->add_arg<const qt_gsi::Converter<QFont::HintingPreference>::target_type & > (argspec_2);
  decl->set_return_new<QRawFont> ();
}

static void _call_ctor_QRawFont_5664 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  double arg2 = args.read<double > (heap);
  const qt_gsi::Converter<QFont::HintingPreference>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFont::HintingPreference>::target_type & > (heap) : (const qt_gsi::Converter<QFont::HintingPreference>::target_type &)(qt_gsi::CppToQtReadAdaptor<QFont::HintingPreference>(heap, QFont::PreferDefaultHinting));
  ret.write<QRawFont *> (new QRawFont (arg1, arg2, qt_gsi::QtToCppAdaptor<QFont::HintingPreference>(arg3).cref()));
}


//  Constructor QRawFont::QRawFont(const QByteArray &fontData, double pixelSize, QFont::HintingPreference hintingPreference)


static void _init_ctor_QRawFont_5948 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fontData");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixelSize");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("hintingPreference", true, "QFont::PreferDefaultHinting");
  decl->add_arg<const qt_gsi::Converter<QFont::HintingPreference>::target_type & > (argspec_2);
  decl->set_return_new<QRawFont> ();
}

static void _call_ctor_QRawFont_5948 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  double arg2 = args.read<double > (heap);
  const qt_gsi::Converter<QFont::HintingPreference>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFont::HintingPreference>::target_type & > (heap) : (const qt_gsi::Converter<QFont::HintingPreference>::target_type &)(qt_gsi::CppToQtReadAdaptor<QFont::HintingPreference>(heap, QFont::PreferDefaultHinting));
  ret.write<QRawFont *> (new QRawFont (arg1, arg2, qt_gsi::QtToCppAdaptor<QFont::HintingPreference>(arg3).cref()));
}


//  Constructor QRawFont::QRawFont(const QRawFont &other)


static void _init_ctor_QRawFont_2099 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QRawFont & > (argspec_0);
  decl->set_return_new<QRawFont> ();
}

static void _call_ctor_QRawFont_2099 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRawFont &arg1 = args.read<const QRawFont & > (heap);
  ret.write<QRawFont *> (new QRawFont (arg1));
}


// QVector<QPointF> QRawFont::advancesForGlyphIndexes(const QVector<quint32> &glyphIndexes)


static void _init_f_advancesForGlyphIndexes_c2805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("glyphIndexes");
  decl->add_arg<const QVector<quint32> & > (argspec_0);
  decl->set_return<QVector<QPointF> > ();
}

static void _call_f_advancesForGlyphIndexes_c2805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector<quint32> &arg1 = args.read<const QVector<quint32> & > (heap);
  ret.write<QVector<QPointF> > ((QVector<QPointF>)((QRawFont *)cls)->advancesForGlyphIndexes (arg1));
}


// QVector<QPointF> QRawFont::advancesForGlyphIndexes(const QVector<quint32> &glyphIndexes, QFlags<QRawFont::LayoutFlag> layoutFlags)


static void _init_f_advancesForGlyphIndexes_c5747 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("glyphIndexes");
  decl->add_arg<const QVector<quint32> & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("layoutFlags");
  decl->add_arg<QFlags<QRawFont::LayoutFlag> > (argspec_1);
  decl->set_return<QVector<QPointF> > ();
}

static void _call_f_advancesForGlyphIndexes_c5747 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVector<quint32> &arg1 = args.read<const QVector<quint32> & > (heap);
  QFlags<QRawFont::LayoutFlag> arg2 = args.read<QFlags<QRawFont::LayoutFlag> > (heap);
  ret.write<QVector<QPointF> > ((QVector<QPointF>)((QRawFont *)cls)->advancesForGlyphIndexes (arg1, arg2));
}


// bool QRawFont::advancesForGlyphIndexes(const quint32 *glyphIndexes, QPointF *advances, int numGlyphs)


static void _init_f_advancesForGlyphIndexes_c3825 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("glyphIndexes");
  decl->add_arg<const quint32 * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("advances");
  decl->add_arg<QPointF * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("numGlyphs");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_advancesForGlyphIndexes_c3825 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const quint32 *arg1 = args.read<const quint32 * > (heap);
  QPointF *arg2 = args.read<QPointF * > (heap);
  int arg3 = args.read<int > (heap);
  ret.write<bool > ((bool)((QRawFont *)cls)->advancesForGlyphIndexes (arg1, arg2, arg3));
}


// bool QRawFont::advancesForGlyphIndexes(const quint32 *glyphIndexes, QPointF *advances, int numGlyphs, QFlags<QRawFont::LayoutFlag> layoutFlags)


static void _init_f_advancesForGlyphIndexes_c6767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("glyphIndexes");
  decl->add_arg<const quint32 * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("advances");
  decl->add_arg<QPointF * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("numGlyphs");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("layoutFlags");
  decl->add_arg<QFlags<QRawFont::LayoutFlag> > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_advancesForGlyphIndexes_c6767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const quint32 *arg1 = args.read<const quint32 * > (heap);
  QPointF *arg2 = args.read<QPointF * > (heap);
  int arg3 = args.read<int > (heap);
  QFlags<QRawFont::LayoutFlag> arg4 = args.read<QFlags<QRawFont::LayoutFlag> > (heap);
  ret.write<bool > ((bool)((QRawFont *)cls)->advancesForGlyphIndexes (arg1, arg2, arg3, arg4));
}


// QImage QRawFont::alphaMapForGlyph(quint32 glyphIndex, QRawFont::AntialiasingType antialiasingType, const QTransform &transform)


static void _init_f_alphaMapForGlyph_c6224 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("glyphIndex");
  decl->add_arg<quint32 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("antialiasingType", true, "QRawFont::SubPixelAntialiasing");
  decl->add_arg<const qt_gsi::Converter<QRawFont::AntialiasingType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("transform", true, "QTransform()");
  decl->add_arg<const QTransform & > (argspec_2);
  decl->set_return<QImage > ();
}

static void _call_f_alphaMapForGlyph_c6224 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint32 arg1 = args.read<quint32 > (heap);
  const qt_gsi::Converter<QRawFont::AntialiasingType>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QRawFont::AntialiasingType>::target_type & > (heap) : (const qt_gsi::Converter<QRawFont::AntialiasingType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QRawFont::AntialiasingType>(heap, QRawFont::SubPixelAntialiasing));
  const QTransform &arg3 = args ? args.read<const QTransform & > (heap) : (const QTransform &)(QTransform());
  ret.write<QImage > ((QImage)((QRawFont *)cls)->alphaMapForGlyph (arg1, qt_gsi::QtToCppAdaptor<QRawFont::AntialiasingType>(arg2).cref(), arg3));
}


// double QRawFont::ascent()


static void _init_f_ascent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_ascent_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRawFont *)cls)->ascent ());
}


// double QRawFont::averageCharWidth()


static void _init_f_averageCharWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_averageCharWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRawFont *)cls)->averageCharWidth ());
}


// QRectF QRawFont::boundingRect(quint32 glyphIndex)


static void _init_f_boundingRect_c1098 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("glyphIndex");
  decl->add_arg<quint32 > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_c1098 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint32 arg1 = args.read<quint32 > (heap);
  ret.write<QRectF > ((QRectF)((QRawFont *)cls)->boundingRect (arg1));
}


// double QRawFont::descent()


static void _init_f_descent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_descent_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRawFont *)cls)->descent ());
}


// QString QRawFont::familyName()


static void _init_f_familyName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_familyName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRawFont *)cls)->familyName ());
}


// QByteArray QRawFont::fontTable(const char *tagName)


static void _init_f_fontTable_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tagName");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QByteArray > ();
}

static void _call_f_fontTable_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<QByteArray > ((QByteArray)((QRawFont *)cls)->fontTable (arg1));
}


// bool QRawFont::glyphIndexesForChars(const QChar *chars, int numChars, quint32 *glyphIndexes, int *numGlyphs)


static void _init_f_glyphIndexesForChars_c4460 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("chars");
  decl->add_arg<const qt_gsi::Converter<QChar>::target_type * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("numChars");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("glyphIndexes");
  decl->add_arg<quint32 * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("numGlyphs");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_glyphIndexesForChars_c4460 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QChar>::target_type * arg1 = args.read<const qt_gsi::Converter<QChar>::target_type * > (heap);
  int arg2 = args.read<int > (heap);
  quint32 *arg3 = args.read<quint32 * > (heap);
  int *arg4 = args.read<int * > (heap);
  ret.write<bool > ((bool)((QRawFont *)cls)->glyphIndexesForChars (qt_gsi::QtToCppAdaptor<QChar>(arg1).cptr(), arg2, arg3, arg4));
}


// QVector<quint32> QRawFont::glyphIndexesForString(const QString &text)


static void _init_f_glyphIndexesForString_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QVector<quint32> > ();
}

static void _call_f_glyphIndexesForString_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QVector<quint32> > ((QVector<quint32>)((QRawFont *)cls)->glyphIndexesForString (arg1));
}


// QFont::HintingPreference QRawFont::hintingPreference()


static void _init_f_hintingPreference_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::HintingPreference>::target_type > ();
}

static void _call_f_hintingPreference_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFont::HintingPreference>::target_type > ((qt_gsi::Converter<QFont::HintingPreference>::target_type)qt_gsi::CppToQtAdaptor<QFont::HintingPreference>(((QRawFont *)cls)->hintingPreference ()));
}


// bool QRawFont::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRawFont *)cls)->isValid ());
}


// double QRawFont::leading()


static void _init_f_leading_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_leading_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRawFont *)cls)->leading ());
}


// double QRawFont::lineThickness()


static void _init_f_lineThickness_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_lineThickness_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRawFont *)cls)->lineThickness ());
}


// void QRawFont::loadFromData(const QByteArray &fontData, double pixelSize, QFont::HintingPreference hintingPreference)


static void _init_f_loadFromData_5948 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fontData");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixelSize");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("hintingPreference");
  decl->add_arg<const qt_gsi::Converter<QFont::HintingPreference>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_loadFromData_5948 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  double arg2 = args.read<double > (heap);
  const qt_gsi::Converter<QFont::HintingPreference>::target_type & arg3 = args.read<const qt_gsi::Converter<QFont::HintingPreference>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRawFont *)cls)->loadFromData (arg1, arg2, qt_gsi::QtToCppAdaptor<QFont::HintingPreference>(arg3).cref());
}


// void QRawFont::loadFromFile(const QString &fileName, double pixelSize, QFont::HintingPreference hintingPreference)


static void _init_f_loadFromFile_5664 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixelSize");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("hintingPreference");
  decl->add_arg<const qt_gsi::Converter<QFont::HintingPreference>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_loadFromFile_5664 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  double arg2 = args.read<double > (heap);
  const qt_gsi::Converter<QFont::HintingPreference>::target_type & arg3 = args.read<const qt_gsi::Converter<QFont::HintingPreference>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRawFont *)cls)->loadFromFile (arg1, arg2, qt_gsi::QtToCppAdaptor<QFont::HintingPreference>(arg3).cref());
}


// double QRawFont::maxCharWidth()


static void _init_f_maxCharWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_maxCharWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRawFont *)cls)->maxCharWidth ());
}


// bool QRawFont::operator!=(const QRawFont &other)


static void _init_f_operator_excl__eq__c2099 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QRawFont & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2099 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRawFont &arg1 = args.read<const QRawFont & > (heap);
  ret.write<bool > ((bool)((QRawFont *)cls)->operator!= (arg1));
}


// QRawFont &QRawFont::operator=(const QRawFont &other)


static void _init_f_operator_eq__2099 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QRawFont & > (argspec_0);
  decl->set_return<QRawFont & > ();
}

static void _call_f_operator_eq__2099 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRawFont &arg1 = args.read<const QRawFont & > (heap);
  ret.write<QRawFont & > ((QRawFont &)((QRawFont *)cls)->operator= (arg1));
}


// bool QRawFont::operator==(const QRawFont &other)


static void _init_f_operator_eq__eq__c2099 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QRawFont & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2099 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRawFont &arg1 = args.read<const QRawFont & > (heap);
  ret.write<bool > ((bool)((QRawFont *)cls)->operator== (arg1));
}


// QPainterPath QRawFont::pathForGlyph(quint32 glyphIndex)


static void _init_f_pathForGlyph_c1098 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("glyphIndex");
  decl->add_arg<quint32 > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_pathForGlyph_c1098 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quint32 arg1 = args.read<quint32 > (heap);
  ret.write<QPainterPath > ((QPainterPath)((QRawFont *)cls)->pathForGlyph (arg1));
}


// double QRawFont::pixelSize()


static void _init_f_pixelSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_pixelSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRawFont *)cls)->pixelSize ());
}


// void QRawFont::setPixelSize(double pixelSize)


static void _init_f_setPixelSize_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixelSize");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPixelSize_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRawFont *)cls)->setPixelSize (arg1);
}


// QFont::Style QRawFont::style()


static void _init_f_style_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::Style>::target_type > ();
}

static void _call_f_style_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFont::Style>::target_type > ((qt_gsi::Converter<QFont::Style>::target_type)qt_gsi::CppToQtAdaptor<QFont::Style>(((QRawFont *)cls)->style ()));
}


// QString QRawFont::styleName()


static void _init_f_styleName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_styleName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QRawFont *)cls)->styleName ());
}


// QList<QFontDatabase::WritingSystem> QRawFont::supportedWritingSystems()


static void _init_f_supportedWritingSystems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QFontDatabase::WritingSystem> > ();
}

static void _call_f_supportedWritingSystems_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QFontDatabase::WritingSystem> > ((QList<QFontDatabase::WritingSystem>)((QRawFont *)cls)->supportedWritingSystems ());
}


// bool QRawFont::supportsCharacter(unsigned int ucs4)


static void _init_f_supportsCharacter_c1772 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ucs4");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_supportsCharacter_c1772 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  unsigned int arg1 = args.read<unsigned int > (heap);
  ret.write<bool > ((bool)((QRawFont *)cls)->supportsCharacter (arg1));
}


// bool QRawFont::supportsCharacter(QChar character)


static void _init_f_supportsCharacter_c899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("character");
  decl->add_arg<const qt_gsi::Converter<QChar>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_supportsCharacter_c899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QChar>::target_type & arg1 = args.read<const qt_gsi::Converter<QChar>::target_type & > (heap);
  ret.write<bool > ((bool)((QRawFont *)cls)->supportsCharacter (qt_gsi::QtToCppAdaptor<QChar>(arg1).cref()));
}


// void QRawFont::swap(QRawFont &other)


static void _init_f_swap_1404 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<QRawFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_swap_1404 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QRawFont &arg1 = args.read<QRawFont & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRawFont *)cls)->swap (arg1);
}


// double QRawFont::underlinePosition()


static void _init_f_underlinePosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_underlinePosition_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRawFont *)cls)->underlinePosition ());
}


// double QRawFont::unitsPerEm()


static void _init_f_unitsPerEm_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_unitsPerEm_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRawFont *)cls)->unitsPerEm ());
}


// int QRawFont::weight()


static void _init_f_weight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_weight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRawFont *)cls)->weight ());
}


// double QRawFont::xHeight()


static void _init_f_xHeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_xHeight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QRawFont *)cls)->xHeight ());
}


// static QRawFont QRawFont::fromFont(const QFont &font, QFontDatabase::WritingSystem writingSystem)


static void _init_f_fromFont_4907 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("writingSystem", true, "QFontDatabase::Any");
  decl->add_arg<const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type & > (argspec_1);
  decl->set_return<QRawFont > ();
}

static void _call_f_fromFont_4907 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type & > (heap) : (const qt_gsi::Converter<QFontDatabase::WritingSystem>::target_type &)(qt_gsi::CppToQtReadAdaptor<QFontDatabase::WritingSystem>(heap, QFontDatabase::Any));
  ret.write<QRawFont > ((QRawFont)QRawFont::fromFont (arg1, qt_gsi::QtToCppAdaptor<QFontDatabase::WritingSystem>(arg2).cref()));
}



namespace gsi
{

static gsi::Methods methods_QRawFont () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRawFont::QRawFont()\nThis method creates an object of class QRawFont.", &_init_ctor_QRawFont_0, &_call_ctor_QRawFont_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRawFont::QRawFont(const QString &fileName, double pixelSize, QFont::HintingPreference hintingPreference)\nThis method creates an object of class QRawFont.", &_init_ctor_QRawFont_5664, &_call_ctor_QRawFont_5664);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRawFont::QRawFont(const QByteArray &fontData, double pixelSize, QFont::HintingPreference hintingPreference)\nThis method creates an object of class QRawFont.", &_init_ctor_QRawFont_5948, &_call_ctor_QRawFont_5948);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRawFont::QRawFont(const QRawFont &other)\nThis method creates an object of class QRawFont.", &_init_ctor_QRawFont_2099, &_call_ctor_QRawFont_2099);
  methods += new qt_gsi::GenericMethod ("advancesForGlyphIndexes", "@brief Method QVector<QPointF> QRawFont::advancesForGlyphIndexes(const QVector<quint32> &glyphIndexes)\n", true, &_init_f_advancesForGlyphIndexes_c2805, &_call_f_advancesForGlyphIndexes_c2805);
  methods += new qt_gsi::GenericMethod ("advancesForGlyphIndexes", "@brief Method QVector<QPointF> QRawFont::advancesForGlyphIndexes(const QVector<quint32> &glyphIndexes, QFlags<QRawFont::LayoutFlag> layoutFlags)\n", true, &_init_f_advancesForGlyphIndexes_c5747, &_call_f_advancesForGlyphIndexes_c5747);
  methods += new qt_gsi::GenericMethod ("advancesForGlyphIndexes", "@brief Method bool QRawFont::advancesForGlyphIndexes(const quint32 *glyphIndexes, QPointF *advances, int numGlyphs)\n", true, &_init_f_advancesForGlyphIndexes_c3825, &_call_f_advancesForGlyphIndexes_c3825);
  methods += new qt_gsi::GenericMethod ("advancesForGlyphIndexes", "@brief Method bool QRawFont::advancesForGlyphIndexes(const quint32 *glyphIndexes, QPointF *advances, int numGlyphs, QFlags<QRawFont::LayoutFlag> layoutFlags)\n", true, &_init_f_advancesForGlyphIndexes_c6767, &_call_f_advancesForGlyphIndexes_c6767);
  methods += new qt_gsi::GenericMethod ("alphaMapForGlyph", "@brief Method QImage QRawFont::alphaMapForGlyph(quint32 glyphIndex, QRawFont::AntialiasingType antialiasingType, const QTransform &transform)\n", true, &_init_f_alphaMapForGlyph_c6224, &_call_f_alphaMapForGlyph_c6224);
  methods += new qt_gsi::GenericMethod ("ascent", "@brief Method double QRawFont::ascent()\n", true, &_init_f_ascent_c0, &_call_f_ascent_c0);
  methods += new qt_gsi::GenericMethod ("averageCharWidth", "@brief Method double QRawFont::averageCharWidth()\n", true, &_init_f_averageCharWidth_c0, &_call_f_averageCharWidth_c0);
  methods += new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QRawFont::boundingRect(quint32 glyphIndex)\n", true, &_init_f_boundingRect_c1098, &_call_f_boundingRect_c1098);
  methods += new qt_gsi::GenericMethod ("descent", "@brief Method double QRawFont::descent()\n", true, &_init_f_descent_c0, &_call_f_descent_c0);
  methods += new qt_gsi::GenericMethod ("familyName", "@brief Method QString QRawFont::familyName()\n", true, &_init_f_familyName_c0, &_call_f_familyName_c0);
  methods += new qt_gsi::GenericMethod ("fontTable", "@brief Method QByteArray QRawFont::fontTable(const char *tagName)\n", true, &_init_f_fontTable_c1731, &_call_f_fontTable_c1731);
  methods += new qt_gsi::GenericMethod ("glyphIndexesForChars", "@brief Method bool QRawFont::glyphIndexesForChars(const QChar *chars, int numChars, quint32 *glyphIndexes, int *numGlyphs)\n", true, &_init_f_glyphIndexesForChars_c4460, &_call_f_glyphIndexesForChars_c4460);
  methods += new qt_gsi::GenericMethod ("glyphIndexesForString", "@brief Method QVector<quint32> QRawFont::glyphIndexesForString(const QString &text)\n", true, &_init_f_glyphIndexesForString_c2025, &_call_f_glyphIndexesForString_c2025);
  methods += new qt_gsi::GenericMethod ("hintingPreference", "@brief Method QFont::HintingPreference QRawFont::hintingPreference()\n", true, &_init_f_hintingPreference_c0, &_call_f_hintingPreference_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QRawFont::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("leading", "@brief Method double QRawFont::leading()\n", true, &_init_f_leading_c0, &_call_f_leading_c0);
  methods += new qt_gsi::GenericMethod ("lineThickness", "@brief Method double QRawFont::lineThickness()\n", true, &_init_f_lineThickness_c0, &_call_f_lineThickness_c0);
  methods += new qt_gsi::GenericMethod ("loadFromData", "@brief Method void QRawFont::loadFromData(const QByteArray &fontData, double pixelSize, QFont::HintingPreference hintingPreference)\n", false, &_init_f_loadFromData_5948, &_call_f_loadFromData_5948);
  methods += new qt_gsi::GenericMethod ("loadFromFile", "@brief Method void QRawFont::loadFromFile(const QString &fileName, double pixelSize, QFont::HintingPreference hintingPreference)\n", false, &_init_f_loadFromFile_5664, &_call_f_loadFromFile_5664);
  methods += new qt_gsi::GenericMethod ("maxCharWidth", "@brief Method double QRawFont::maxCharWidth()\n", true, &_init_f_maxCharWidth_c0, &_call_f_maxCharWidth_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QRawFont::operator!=(const QRawFont &other)\n", true, &_init_f_operator_excl__eq__c2099, &_call_f_operator_excl__eq__c2099);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QRawFont &QRawFont::operator=(const QRawFont &other)\n", false, &_init_f_operator_eq__2099, &_call_f_operator_eq__2099);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QRawFont::operator==(const QRawFont &other)\n", true, &_init_f_operator_eq__eq__c2099, &_call_f_operator_eq__eq__c2099);
  methods += new qt_gsi::GenericMethod ("pathForGlyph", "@brief Method QPainterPath QRawFont::pathForGlyph(quint32 glyphIndex)\n", true, &_init_f_pathForGlyph_c1098, &_call_f_pathForGlyph_c1098);
  methods += new qt_gsi::GenericMethod (":pixelSize", "@brief Method double QRawFont::pixelSize()\n", true, &_init_f_pixelSize_c0, &_call_f_pixelSize_c0);
  methods += new qt_gsi::GenericMethod ("setPixelSize|pixelSize=", "@brief Method void QRawFont::setPixelSize(double pixelSize)\n", false, &_init_f_setPixelSize_1071, &_call_f_setPixelSize_1071);
  methods += new qt_gsi::GenericMethod ("style", "@brief Method QFont::Style QRawFont::style()\n", true, &_init_f_style_c0, &_call_f_style_c0);
  methods += new qt_gsi::GenericMethod ("styleName", "@brief Method QString QRawFont::styleName()\n", true, &_init_f_styleName_c0, &_call_f_styleName_c0);
  methods += new qt_gsi::GenericMethod ("supportedWritingSystems", "@brief Method QList<QFontDatabase::WritingSystem> QRawFont::supportedWritingSystems()\n", true, &_init_f_supportedWritingSystems_c0, &_call_f_supportedWritingSystems_c0);
  methods += new qt_gsi::GenericMethod ("supportsCharacter", "@brief Method bool QRawFont::supportsCharacter(unsigned int ucs4)\n", true, &_init_f_supportsCharacter_c1772, &_call_f_supportsCharacter_c1772);
  methods += new qt_gsi::GenericMethod ("supportsCharacter", "@brief Method bool QRawFont::supportsCharacter(QChar character)\n", true, &_init_f_supportsCharacter_c899, &_call_f_supportsCharacter_c899);
  methods += new qt_gsi::GenericMethod ("swap", "@brief Method void QRawFont::swap(QRawFont &other)\n", false, &_init_f_swap_1404, &_call_f_swap_1404);
  methods += new qt_gsi::GenericMethod ("underlinePosition", "@brief Method double QRawFont::underlinePosition()\n", true, &_init_f_underlinePosition_c0, &_call_f_underlinePosition_c0);
  methods += new qt_gsi::GenericMethod ("unitsPerEm", "@brief Method double QRawFont::unitsPerEm()\n", true, &_init_f_unitsPerEm_c0, &_call_f_unitsPerEm_c0);
  methods += new qt_gsi::GenericMethod ("weight", "@brief Method int QRawFont::weight()\n", true, &_init_f_weight_c0, &_call_f_weight_c0);
  methods += new qt_gsi::GenericMethod ("xHeight", "@brief Method double QRawFont::xHeight()\n", true, &_init_f_xHeight_c0, &_call_f_xHeight_c0);
  methods += new qt_gsi::GenericStaticMethod ("fromFont", "@brief Static method QRawFont QRawFont::fromFont(const QFont &font, QFontDatabase::WritingSystem writingSystem)\nThis method is static and can be called without an instance.", &_init_f_fromFont_4907, &_call_f_fromFont_4907);
  return methods;
}

gsi::Class<QRawFont> decl_QRawFont ("QRawFont",
  methods_QRawFont (),
  "@qt\n@brief Binding of QRawFont");


GSIQT_PUBLIC gsi::Class<QRawFont> &qtdecl_QRawFont () { return decl_QRawFont; }

}


//  Implementation of the enum wrapper class for QRawFont::AntialiasingType
namespace qt_gsi
{

static gsi::Enum<QRawFont::AntialiasingType> decl_QRawFont_AntialiasingType_Enum ("QRawFont_AntialiasingType",
    gsi::enum_const ("PixelAntialiasing", QRawFont::PixelAntialiasing, "@brief Enum constant QRawFont::PixelAntialiasing") +
    gsi::enum_const ("SubPixelAntialiasing", QRawFont::SubPixelAntialiasing, "@brief Enum constant QRawFont::SubPixelAntialiasing"),
  "@qt\n@brief This class represents the QRawFont::AntialiasingType enum");

static gsi::QFlagsClass<QRawFont::AntialiasingType > decl_QRawFont_AntialiasingType_Enums ("QRawFont_QFlags_AntialiasingType",
  "@qt\n@brief This class represents the QFlags<QRawFont::AntialiasingType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QRawFont> inject_QRawFont_AntialiasingType_Enum_in_parent (decl_QRawFont_AntialiasingType_Enum.defs ());
static gsi::ClassExt<QRawFont> decl_QRawFont_AntialiasingType_Enum_as_child (decl_QRawFont_AntialiasingType_Enum, "AntialiasingType");
static gsi::ClassExt<QRawFont> decl_QRawFont_AntialiasingType_Enums_as_child (decl_QRawFont_AntialiasingType_Enums, "QFlags_AntialiasingType");

}


//  Implementation of the enum wrapper class for QRawFont::LayoutFlag
namespace qt_gsi
{

static gsi::Enum<QRawFont::LayoutFlag> decl_QRawFont_LayoutFlag_Enum ("QRawFont_LayoutFlag",
    gsi::enum_const ("SeparateAdvances", QRawFont::SeparateAdvances, "@brief Enum constant QRawFont::SeparateAdvances") +
    gsi::enum_const ("KernedAdvances", QRawFont::KernedAdvances, "@brief Enum constant QRawFont::KernedAdvances") +
    gsi::enum_const ("UseDesignMetrics", QRawFont::UseDesignMetrics, "@brief Enum constant QRawFont::UseDesignMetrics"),
  "@qt\n@brief This class represents the QRawFont::LayoutFlag enum");

static gsi::QFlagsClass<QRawFont::LayoutFlag > decl_QRawFont_LayoutFlag_Enums ("QRawFont_QFlags_LayoutFlag",
  "@qt\n@brief This class represents the QFlags<QRawFont::LayoutFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QRawFont> inject_QRawFont_LayoutFlag_Enum_in_parent (decl_QRawFont_LayoutFlag_Enum.defs ());
static gsi::ClassExt<QRawFont> decl_QRawFont_LayoutFlag_Enum_as_child (decl_QRawFont_LayoutFlag_Enum, "LayoutFlag");
static gsi::ClassExt<QRawFont> decl_QRawFont_LayoutFlag_Enums_as_child (decl_QRawFont_LayoutFlag_Enums, "QFlags_LayoutFlag");

}

