
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQRect.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QRect>
#include <QMargins>
#include <QPoint>
#include <QSize>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QRect

//  Constructor QRect::QRect()


static void _init_ctor_QRect_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QRect> ();
}

static void _call_ctor_QRect_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect *> (new QRect ());
}


//  Constructor QRect::QRect(const QPoint &topleft, const QPoint &bottomright)


static void _init_ctor_QRect_3724 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topleft");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomright");
  decl->add_arg<const QPoint & > (argspec_1);
  decl->set_return_new<QRect> ();
}

static void _call_ctor_QRect_3724 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  const QPoint &arg2 = args.read<const QPoint & > (heap);
  ret.write<QRect *> (new QRect (arg1, arg2));
}


//  Constructor QRect::QRect(const QPoint &topleft, const QSize &size)


static void _init_ctor_QRect_3613 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topleft");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("size");
  decl->add_arg<const QSize & > (argspec_1);
  decl->set_return_new<QRect> ();
}

static void _call_ctor_QRect_3613 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  const QSize &arg2 = args.read<const QSize & > (heap);
  ret.write<QRect *> (new QRect (arg1, arg2));
}


//  Constructor QRect::QRect(int left, int top, int width, int height)


static void _init_ctor_QRect_2744 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("width");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("height");
  decl->add_arg<int > (argspec_3);
  decl->set_return_new<QRect> ();
}

static void _call_ctor_QRect_2744 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  ret.write<QRect *> (new QRect (arg1, arg2, arg3, arg4));
}


// void QRect::adjust(int x1, int y1, int x2, int y2)


static void _init_f_adjust_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_adjust_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->adjust (arg1, arg2, arg3, arg4);
}


// QRect QRect::adjusted(int x1, int y1, int x2, int y2)


static void _init_f_adjusted_c2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<int > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_f_adjusted_c2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  ret.write<QRect > ((QRect)((QRect *)cls)->adjusted (arg1, arg2, arg3, arg4));
}


// int QRect::bottom()


static void _init_f_bottom_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bottom_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRect *)cls)->bottom ());
}


// QPoint QRect::bottomLeft()


static void _init_f_bottomLeft_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_bottomLeft_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QRect *)cls)->bottomLeft ());
}


// QPoint QRect::bottomRight()


static void _init_f_bottomRight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_bottomRight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QRect *)cls)->bottomRight ());
}


// QPoint QRect::center()


static void _init_f_center_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_center_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QRect *)cls)->center ());
}


// bool QRect::contains(const QRect &r, bool proper)


static void _init_f_contains_c2548 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("proper", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_contains_c2548 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  bool arg2 = args ? args.read<bool > (heap) : (bool)(false);
  ret.write<bool > ((bool)((QRect *)cls)->contains (arg1, arg2));
}


// bool QRect::contains(const QPoint &p, bool proper)


static void _init_f_contains_c2672 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("proper", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_contains_c2672 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  bool arg2 = args ? args.read<bool > (heap) : (bool)(false);
  ret.write<bool > ((bool)((QRect *)cls)->contains (arg1, arg2));
}


// bool QRect::contains(int x, int y)


static void _init_f_contains_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_contains_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<bool > ((bool)((QRect *)cls)->contains (arg1, arg2));
}


// bool QRect::contains(int x, int y, bool proper)


static void _init_f_contains_c2182 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("proper");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_contains_c2182 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  bool arg3 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QRect *)cls)->contains (arg1, arg2, arg3));
}


// void QRect::getCoords(int *x1, int *y1, int *x2, int *y2)


static void _init_f_getCoords_c3488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getCoords_c3488 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int *arg1 = args.read<int * > (heap);
  int *arg2 = args.read<int * > (heap);
  int *arg3 = args.read<int * > (heap);
  int *arg4 = args.read<int * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->getCoords (arg1, arg2, arg3, arg4);
}


// void QRect::getRect(int *x, int *y, int *w, int *h)


static void _init_f_getRect_c3488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getRect_c3488 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int *arg1 = args.read<int * > (heap);
  int *arg2 = args.read<int * > (heap);
  int *arg3 = args.read<int * > (heap);
  int *arg4 = args.read<int * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->getRect (arg1, arg2, arg3, arg4);
}


// int QRect::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRect *)cls)->height ());
}


// QRect QRect::intersected(const QRect &other)


static void _init_f_intersected_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_intersected_c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  ret.write<QRect > ((QRect)((QRect *)cls)->intersected (arg1));
}


// bool QRect::intersects(const QRect &r)


static void _init_f_intersects_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_intersects_c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  ret.write<bool > ((bool)((QRect *)cls)->intersects (arg1));
}


// bool QRect::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRect *)cls)->isEmpty ());
}


// bool QRect::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRect *)cls)->isNull ());
}


// bool QRect::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QRect *)cls)->isValid ());
}


// int QRect::left()


static void _init_f_left_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_left_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRect *)cls)->left ());
}


// QRect QRect::marginsAdded(const QMargins &margins)


static void _init_f_marginsAdded_c2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_marginsAdded_c2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = args.read<const QMargins & > (heap);
  ret.write<QRect > ((QRect)((QRect *)cls)->marginsAdded (arg1));
}


// QRect QRect::marginsRemoved(const QMargins &margins)


static void _init_f_marginsRemoved_c2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_marginsRemoved_c2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = args.read<const QMargins & > (heap);
  ret.write<QRect > ((QRect)((QRect *)cls)->marginsRemoved (arg1));
}


// void QRect::moveBottom(int pos)


static void _init_f_moveBottom_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveBottom_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->moveBottom (arg1);
}


// void QRect::moveBottomLeft(const QPoint &p)


static void _init_f_moveBottomLeft_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveBottomLeft_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->moveBottomLeft (arg1);
}


// void QRect::moveBottomRight(const QPoint &p)


static void _init_f_moveBottomRight_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveBottomRight_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->moveBottomRight (arg1);
}


// void QRect::moveCenter(const QPoint &p)


static void _init_f_moveCenter_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveCenter_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->moveCenter (arg1);
}


// void QRect::moveLeft(int pos)


static void _init_f_moveLeft_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveLeft_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->moveLeft (arg1);
}


// void QRect::moveRight(int pos)


static void _init_f_moveRight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveRight_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->moveRight (arg1);
}


// void QRect::moveTo(int x, int t)


static void _init_f_moveTo_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("t");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_moveTo_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->moveTo (arg1, arg2);
}


// void QRect::moveTo(const QPoint &p)


static void _init_f_moveTo_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveTo_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->moveTo (arg1);
}


// void QRect::moveTop(int pos)


static void _init_f_moveTop_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveTop_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->moveTop (arg1);
}


// void QRect::moveTopLeft(const QPoint &p)


static void _init_f_moveTopLeft_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveTopLeft_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->moveTopLeft (arg1);
}


// void QRect::moveTopRight(const QPoint &p)


static void _init_f_moveTopRight_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_moveTopRight_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->moveTopRight (arg1);
}


// QRect QRect::normalized()


static void _init_f_normalized_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_normalized_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QRect *)cls)->normalized ());
}


// QRect QRect::operator&(const QRect &r)


static void _init_f_operator_amp__c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_operator_amp__c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  ret.write<QRect > ((QRect)((QRect *)cls)->operator& (arg1));
}


// QRect &QRect::operator&=(const QRect &r)


static void _init_f_operator_amp__eq__1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect & > ();
}

static void _call_f_operator_amp__eq__1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  ret.write<QRect & > ((QRect &)((QRect *)cls)->operator&= (arg1));
}


// QRect &QRect::operator+=(const QMargins &margins)


static void _init_f_operator_plus__eq__2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<QRect & > ();
}

static void _call_f_operator_plus__eq__2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = args.read<const QMargins & > (heap);
  ret.write<QRect & > ((QRect &)((QRect *)cls)->operator+= (arg1));
}


// QRect &QRect::operator-=(const QMargins &margins)


static void _init_f_operator_minus__eq__2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<QRect & > ();
}

static void _call_f_operator_minus__eq__2115 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMargins &arg1 = args.read<const QMargins & > (heap);
  ret.write<QRect & > ((QRect &)((QRect *)cls)->operator-= (arg1));
}


// QRect QRect::operator|(const QRect &r)


static void _init_f_operator_pipe__c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_operator_pipe__c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  ret.write<QRect > ((QRect)((QRect *)cls)->operator| (arg1));
}


// QRect &QRect::operator|=(const QRect &r)


static void _init_f_operator_pipe__eq__1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect & > ();
}

static void _call_f_operator_pipe__eq__1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  ret.write<QRect & > ((QRect &)((QRect *)cls)->operator|= (arg1));
}


// int QRect::right()


static void _init_f_right_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_right_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRect *)cls)->right ());
}


// void QRect::setBottom(int pos)


static void _init_f_setBottom_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBottom_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setBottom (arg1);
}


// void QRect::setBottomLeft(const QPoint &p)


static void _init_f_setBottomLeft_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBottomLeft_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setBottomLeft (arg1);
}


// void QRect::setBottomRight(const QPoint &p)


static void _init_f_setBottomRight_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBottomRight_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setBottomRight (arg1);
}


// void QRect::setCoords(int x1, int y1, int x2, int y2)


static void _init_f_setCoords_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y1");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("x2");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("y2");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setCoords_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setCoords (arg1, arg2, arg3, arg4);
}


// void QRect::setHeight(int h)


static void _init_f_setHeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("h");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeight_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setHeight (arg1);
}


// void QRect::setLeft(int pos)


static void _init_f_setLeft_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLeft_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setLeft (arg1);
}


// void QRect::setRect(int x, int y, int w, int h)


static void _init_f_setRect_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setRect_2744 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  int arg3 = args.read<int > (heap);
  int arg4 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setRect (arg1, arg2, arg3, arg4);
}


// void QRect::setRight(int pos)


static void _init_f_setRight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRight_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setRight (arg1);
}


// void QRect::setSize(const QSize &s)


static void _init_f_setSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = args.read<const QSize & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setSize (arg1);
}


// void QRect::setTop(int pos)


static void _init_f_setTop_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTop_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setTop (arg1);
}


// void QRect::setTopLeft(const QPoint &p)


static void _init_f_setTopLeft_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTopLeft_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setTopLeft (arg1);
}


// void QRect::setTopRight(const QPoint &p)


static void _init_f_setTopRight_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTopRight_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setTopRight (arg1);
}


// void QRect::setWidth(int w)


static void _init_f_setWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setWidth (arg1);
}


// void QRect::setX(int x)


static void _init_f_setX_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setX_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setX (arg1);
}


// void QRect::setY(int y)


static void _init_f_setY_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setY_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->setY (arg1);
}


// QSize QRect::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QRect *)cls)->size ());
}


// int QRect::top()


static void _init_f_top_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_top_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRect *)cls)->top ());
}


// QPoint QRect::topLeft()


static void _init_f_topLeft_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_topLeft_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QRect *)cls)->topLeft ());
}


// QPoint QRect::topRight()


static void _init_f_topRight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_f_topRight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPoint > ((QPoint)((QRect *)cls)->topRight ());
}


// void QRect::translate(int dx, int dy)


static void _init_f_translate_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->translate (arg1, arg2);
}


// void QRect::translate(const QPoint &p)


static void _init_f_translate_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_translate_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QRect *)cls)->translate (arg1);
}


// QRect QRect::translated(int dx, int dy)


static void _init_f_translated_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QRect > ();
}

static void _call_f_translated_c1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  int arg2 = args.read<int > (heap);
  ret.write<QRect > ((QRect)((QRect *)cls)->translated (arg1, arg2));
}


// QRect QRect::translated(const QPoint &p)


static void _init_f_translated_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_translated_c1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = args.read<const QPoint & > (heap);
  ret.write<QRect > ((QRect)((QRect *)cls)->translated (arg1));
}


// QRect QRect::united(const QRect &other)


static void _init_f_united_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_f_united_c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  ret.write<QRect > ((QRect)((QRect *)cls)->united (arg1));
}


// int QRect::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRect *)cls)->width ());
}


// int QRect::x()


static void _init_f_x_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_x_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRect *)cls)->x ());
}


// int QRect::y()


static void _init_f_y_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_y_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QRect *)cls)->y ());
}


//  bool ::operator==(const QRect &, const QRect &)
static bool op_QRect_operator_eq__eq__3476(const QRect *_self, const QRect &arg2) {
  return ::operator==(*_self, arg2);
}

//  bool ::operator!=(const QRect &, const QRect &)
static bool op_QRect_operator_excl__eq__3476(const QRect *_self, const QRect &arg2) {
  return ::operator!=(*_self, arg2);
}

//  QRect ::operator+(const QRect &rectangle, const QMargins &margins)
static QRect op_QRect_operator_plus__3799u1(const QRect *_self, const QMargins &margins) {
  return ::operator+(*_self, margins);
}

//  QRect ::operator-(const QRect &lhs, const QMargins &rhs)
static QRect op_QRect_operator_minus__3799(const QRect *_self, const QMargins &rhs) {
  return ::operator-(*_self, rhs);
}


namespace gsi
{

static gsi::Methods methods_QRect () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRect::QRect()\nThis method creates an object of class QRect.", &_init_ctor_QRect_0, &_call_ctor_QRect_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRect::QRect(const QPoint &topleft, const QPoint &bottomright)\nThis method creates an object of class QRect.", &_init_ctor_QRect_3724, &_call_ctor_QRect_3724);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRect::QRect(const QPoint &topleft, const QSize &size)\nThis method creates an object of class QRect.", &_init_ctor_QRect_3613, &_call_ctor_QRect_3613);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QRect::QRect(int left, int top, int width, int height)\nThis method creates an object of class QRect.", &_init_ctor_QRect_2744, &_call_ctor_QRect_2744);
  methods += new qt_gsi::GenericMethod ("adjust", "@brief Method void QRect::adjust(int x1, int y1, int x2, int y2)\n", false, &_init_f_adjust_2744, &_call_f_adjust_2744);
  methods += new qt_gsi::GenericMethod ("adjusted", "@brief Method QRect QRect::adjusted(int x1, int y1, int x2, int y2)\n", true, &_init_f_adjusted_c2744, &_call_f_adjusted_c2744);
  methods += new qt_gsi::GenericMethod (":bottom", "@brief Method int QRect::bottom()\n", true, &_init_f_bottom_c0, &_call_f_bottom_c0);
  methods += new qt_gsi::GenericMethod (":bottomLeft", "@brief Method QPoint QRect::bottomLeft()\n", true, &_init_f_bottomLeft_c0, &_call_f_bottomLeft_c0);
  methods += new qt_gsi::GenericMethod (":bottomRight", "@brief Method QPoint QRect::bottomRight()\n", true, &_init_f_bottomRight_c0, &_call_f_bottomRight_c0);
  methods += new qt_gsi::GenericMethod ("center", "@brief Method QPoint QRect::center()\n", true, &_init_f_center_c0, &_call_f_center_c0);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Method bool QRect::contains(const QRect &r, bool proper)\n", true, &_init_f_contains_c2548, &_call_f_contains_c2548);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Method bool QRect::contains(const QPoint &p, bool proper)\n", true, &_init_f_contains_c2672, &_call_f_contains_c2672);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Method bool QRect::contains(int x, int y)\n", true, &_init_f_contains_c1426, &_call_f_contains_c1426);
  methods += new qt_gsi::GenericMethod ("contains", "@brief Method bool QRect::contains(int x, int y, bool proper)\n", true, &_init_f_contains_c2182, &_call_f_contains_c2182);
  methods += new qt_gsi::GenericMethod ("getCoords", "@brief Method void QRect::getCoords(int *x1, int *y1, int *x2, int *y2)\n", true, &_init_f_getCoords_c3488, &_call_f_getCoords_c3488);
  methods += new qt_gsi::GenericMethod ("getRect", "@brief Method void QRect::getRect(int *x, int *y, int *w, int *h)\n", true, &_init_f_getRect_c3488, &_call_f_getRect_c3488);
  methods += new qt_gsi::GenericMethod (":height", "@brief Method int QRect::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
  methods += new qt_gsi::GenericMethod ("intersected", "@brief Method QRect QRect::intersected(const QRect &other)\n", true, &_init_f_intersected_c1792, &_call_f_intersected_c1792);
  methods += new qt_gsi::GenericMethod ("intersects", "@brief Method bool QRect::intersects(const QRect &r)\n", true, &_init_f_intersects_c1792, &_call_f_intersects_c1792);
  methods += new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QRect::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
  methods += new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QRect::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QRect::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod (":left", "@brief Method int QRect::left()\n", true, &_init_f_left_c0, &_call_f_left_c0);
  methods += new qt_gsi::GenericMethod ("marginsAdded", "@brief Method QRect QRect::marginsAdded(const QMargins &margins)\n", true, &_init_f_marginsAdded_c2115, &_call_f_marginsAdded_c2115);
  methods += new qt_gsi::GenericMethod ("marginsRemoved", "@brief Method QRect QRect::marginsRemoved(const QMargins &margins)\n", true, &_init_f_marginsRemoved_c2115, &_call_f_marginsRemoved_c2115);
  methods += new qt_gsi::GenericMethod ("moveBottom", "@brief Method void QRect::moveBottom(int pos)\n", false, &_init_f_moveBottom_767, &_call_f_moveBottom_767);
  methods += new qt_gsi::GenericMethod ("moveBottomLeft", "@brief Method void QRect::moveBottomLeft(const QPoint &p)\n", false, &_init_f_moveBottomLeft_1916, &_call_f_moveBottomLeft_1916);
  methods += new qt_gsi::GenericMethod ("moveBottomRight", "@brief Method void QRect::moveBottomRight(const QPoint &p)\n", false, &_init_f_moveBottomRight_1916, &_call_f_moveBottomRight_1916);
  methods += new qt_gsi::GenericMethod ("moveCenter", "@brief Method void QRect::moveCenter(const QPoint &p)\n", false, &_init_f_moveCenter_1916, &_call_f_moveCenter_1916);
  methods += new qt_gsi::GenericMethod ("moveLeft", "@brief Method void QRect::moveLeft(int pos)\n", false, &_init_f_moveLeft_767, &_call_f_moveLeft_767);
  methods += new qt_gsi::GenericMethod ("moveRight", "@brief Method void QRect::moveRight(int pos)\n", false, &_init_f_moveRight_767, &_call_f_moveRight_767);
  methods += new qt_gsi::GenericMethod ("moveTo", "@brief Method void QRect::moveTo(int x, int t)\n", false, &_init_f_moveTo_1426, &_call_f_moveTo_1426);
  methods += new qt_gsi::GenericMethod ("moveTo", "@brief Method void QRect::moveTo(const QPoint &p)\n", false, &_init_f_moveTo_1916, &_call_f_moveTo_1916);
  methods += new qt_gsi::GenericMethod ("moveTop", "@brief Method void QRect::moveTop(int pos)\n", false, &_init_f_moveTop_767, &_call_f_moveTop_767);
  methods += new qt_gsi::GenericMethod ("moveTopLeft", "@brief Method void QRect::moveTopLeft(const QPoint &p)\n", false, &_init_f_moveTopLeft_1916, &_call_f_moveTopLeft_1916);
  methods += new qt_gsi::GenericMethod ("moveTopRight", "@brief Method void QRect::moveTopRight(const QPoint &p)\n", false, &_init_f_moveTopRight_1916, &_call_f_moveTopRight_1916);
  methods += new qt_gsi::GenericMethod ("normalized", "@brief Method QRect QRect::normalized()\n", true, &_init_f_normalized_c0, &_call_f_normalized_c0);
  methods += new qt_gsi::GenericMethod ("&", "@brief Method QRect QRect::operator&(const QRect &r)\n", true, &_init_f_operator_amp__c1792, &_call_f_operator_amp__c1792);
  methods += new qt_gsi::GenericMethod ("&=", "@brief Method QRect &QRect::operator&=(const QRect &r)\n", false, &_init_f_operator_amp__eq__1792, &_call_f_operator_amp__eq__1792);
  methods += new qt_gsi::GenericMethod ("+=", "@brief Method QRect &QRect::operator+=(const QMargins &margins)\n", false, &_init_f_operator_plus__eq__2115, &_call_f_operator_plus__eq__2115);
  methods += new qt_gsi::GenericMethod ("-=", "@brief Method QRect &QRect::operator-=(const QMargins &margins)\n", false, &_init_f_operator_minus__eq__2115, &_call_f_operator_minus__eq__2115);
  methods += new qt_gsi::GenericMethod ("|", "@brief Method QRect QRect::operator|(const QRect &r)\n", true, &_init_f_operator_pipe__c1792, &_call_f_operator_pipe__c1792);
  methods += new qt_gsi::GenericMethod ("|=", "@brief Method QRect &QRect::operator|=(const QRect &r)\n", false, &_init_f_operator_pipe__eq__1792, &_call_f_operator_pipe__eq__1792);
  methods += new qt_gsi::GenericMethod (":right", "@brief Method int QRect::right()\n", true, &_init_f_right_c0, &_call_f_right_c0);
  methods += new qt_gsi::GenericMethod ("setBottom|bottom=", "@brief Method void QRect::setBottom(int pos)\n", false, &_init_f_setBottom_767, &_call_f_setBottom_767);
  methods += new qt_gsi::GenericMethod ("setBottomLeft|bottomLeft=", "@brief Method void QRect::setBottomLeft(const QPoint &p)\n", false, &_init_f_setBottomLeft_1916, &_call_f_setBottomLeft_1916);
  methods += new qt_gsi::GenericMethod ("setBottomRight|bottomRight=", "@brief Method void QRect::setBottomRight(const QPoint &p)\n", false, &_init_f_setBottomRight_1916, &_call_f_setBottomRight_1916);
  methods += new qt_gsi::GenericMethod ("setCoords", "@brief Method void QRect::setCoords(int x1, int y1, int x2, int y2)\n", false, &_init_f_setCoords_2744, &_call_f_setCoords_2744);
  methods += new qt_gsi::GenericMethod ("setHeight|height=", "@brief Method void QRect::setHeight(int h)\n", false, &_init_f_setHeight_767, &_call_f_setHeight_767);
  methods += new qt_gsi::GenericMethod ("setLeft|left=", "@brief Method void QRect::setLeft(int pos)\n", false, &_init_f_setLeft_767, &_call_f_setLeft_767);
  methods += new qt_gsi::GenericMethod ("setRect", "@brief Method void QRect::setRect(int x, int y, int w, int h)\n", false, &_init_f_setRect_2744, &_call_f_setRect_2744);
  methods += new qt_gsi::GenericMethod ("setRight|right=", "@brief Method void QRect::setRight(int pos)\n", false, &_init_f_setRight_767, &_call_f_setRight_767);
  methods += new qt_gsi::GenericMethod ("setSize|size=", "@brief Method void QRect::setSize(const QSize &s)\n", false, &_init_f_setSize_1805, &_call_f_setSize_1805);
  methods += new qt_gsi::GenericMethod ("setTop|top=", "@brief Method void QRect::setTop(int pos)\n", false, &_init_f_setTop_767, &_call_f_setTop_767);
  methods += new qt_gsi::GenericMethod ("setTopLeft|topLeft=", "@brief Method void QRect::setTopLeft(const QPoint &p)\n", false, &_init_f_setTopLeft_1916, &_call_f_setTopLeft_1916);
  methods += new qt_gsi::GenericMethod ("setTopRight|topRight=", "@brief Method void QRect::setTopRight(const QPoint &p)\n", false, &_init_f_setTopRight_1916, &_call_f_setTopRight_1916);
  methods += new qt_gsi::GenericMethod ("setWidth|width=", "@brief Method void QRect::setWidth(int w)\n", false, &_init_f_setWidth_767, &_call_f_setWidth_767);
  methods += new qt_gsi::GenericMethod ("setX|x=", "@brief Method void QRect::setX(int x)\n", false, &_init_f_setX_767, &_call_f_setX_767);
  methods += new qt_gsi::GenericMethod ("setY|y=", "@brief Method void QRect::setY(int y)\n", false, &_init_f_setY_767, &_call_f_setY_767);
  methods += new qt_gsi::GenericMethod (":size", "@brief Method QSize QRect::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
  methods += new qt_gsi::GenericMethod (":top", "@brief Method int QRect::top()\n", true, &_init_f_top_c0, &_call_f_top_c0);
  methods += new qt_gsi::GenericMethod (":topLeft", "@brief Method QPoint QRect::topLeft()\n", true, &_init_f_topLeft_c0, &_call_f_topLeft_c0);
  methods += new qt_gsi::GenericMethod (":topRight", "@brief Method QPoint QRect::topRight()\n", true, &_init_f_topRight_c0, &_call_f_topRight_c0);
  methods += new qt_gsi::GenericMethod ("translate", "@brief Method void QRect::translate(int dx, int dy)\n", false, &_init_f_translate_1426, &_call_f_translate_1426);
  methods += new qt_gsi::GenericMethod ("translate", "@brief Method void QRect::translate(const QPoint &p)\n", false, &_init_f_translate_1916, &_call_f_translate_1916);
  methods += new qt_gsi::GenericMethod ("translated", "@brief Method QRect QRect::translated(int dx, int dy)\n", true, &_init_f_translated_c1426, &_call_f_translated_c1426);
  methods += new qt_gsi::GenericMethod ("translated", "@brief Method QRect QRect::translated(const QPoint &p)\n", true, &_init_f_translated_c1916, &_call_f_translated_c1916);
  methods += new qt_gsi::GenericMethod ("united", "@brief Method QRect QRect::united(const QRect &other)\n", true, &_init_f_united_c1792, &_call_f_united_c1792);
  methods += new qt_gsi::GenericMethod (":width", "@brief Method int QRect::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
  methods += new qt_gsi::GenericMethod (":x", "@brief Method int QRect::x()\n", true, &_init_f_x_c0, &_call_f_x_c0);
  methods += new qt_gsi::GenericMethod (":y", "@brief Method int QRect::y()\n", true, &_init_f_y_c0, &_call_f_y_c0);
  methods += gsi::method_ext("==", &::op_QRect_operator_eq__eq__3476, gsi::arg ("arg2"), "@brief Operator bool ::operator==(const QRect &, const QRect &)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("!=", &::op_QRect_operator_excl__eq__3476, gsi::arg ("arg2"), "@brief Operator bool ::operator!=(const QRect &, const QRect &)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("+", &::op_QRect_operator_plus__3799u1, gsi::arg ("margins"), "@brief Operator QRect ::operator+(const QRect &rectangle, const QMargins &margins)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("-", &::op_QRect_operator_minus__3799, gsi::arg ("rhs"), "@brief Operator QRect ::operator-(const QRect &lhs, const QMargins &rhs)\nThis is the mapping of the global operator to the instance method.");
  return methods;
}

gsi::Class<QRect> decl_QRect ("QRect",
  methods_QRect (),
  "@qt\n@brief Binding of QRect");


GSIQT_PUBLIC gsi::Class<QRect> &qtdecl_QRect () { return decl_QRect; }

}

