
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSvgRenderer.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSvgRenderer>
#include <QChildEvent>
#include <QEvent>
#include <QMatrix>
#include <QMetaMethod>
#include <QObject>
#include <QPainter>
#include <QRect>
#include <QRectF>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include <QXmlStreamReader>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSvgRenderer

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSvgRenderer::staticMetaObject);
}


// bool QSvgRenderer::animated()


static void _init_f_animated_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_animated_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSvgRenderer *)cls)->animated ());
}


// int QSvgRenderer::animationDuration()


static void _init_f_animationDuration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_animationDuration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSvgRenderer *)cls)->animationDuration ());
}


// QRectF QSvgRenderer::boundsOnElement(const QString &id)


static void _init_f_boundsOnElement_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_boundsOnElement_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QRectF > ((QRectF)((QSvgRenderer *)cls)->boundsOnElement (arg1));
}


// int QSvgRenderer::currentFrame()


static void _init_f_currentFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentFrame_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSvgRenderer *)cls)->currentFrame ());
}


// QSize QSvgRenderer::defaultSize()


static void _init_f_defaultSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_defaultSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QSvgRenderer *)cls)->defaultSize ());
}


// bool QSvgRenderer::elementExists(const QString &id)


static void _init_f_elementExists_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_elementExists_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QSvgRenderer *)cls)->elementExists (arg1));
}


// int QSvgRenderer::framesPerSecond()


static void _init_f_framesPerSecond_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_framesPerSecond_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSvgRenderer *)cls)->framesPerSecond ());
}


// bool QSvgRenderer::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSvgRenderer *)cls)->isValid ());
}


// bool QSvgRenderer::load(const QString &filename)


static void _init_f_load_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filename");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_load_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<bool > ((bool)((QSvgRenderer *)cls)->load (arg1));
}


// bool QSvgRenderer::load(const QByteArray &contents)


static void _init_f_load_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("contents");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_load_2309 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  ret.write<bool > ((bool)((QSvgRenderer *)cls)->load (arg1));
}


// bool QSvgRenderer::load(QXmlStreamReader *contents)


static void _init_f_load_2223 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("contents");
  decl->add_arg<QXmlStreamReader * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_load_2223 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlStreamReader *arg1 = args.read<QXmlStreamReader * > (heap);
  ret.write<bool > ((bool)((QSvgRenderer *)cls)->load (arg1));
}


// QMatrix QSvgRenderer::matrixForElement(const QString &id)


static void _init_f_matrixForElement_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QMatrix > ();
}

static void _call_f_matrixForElement_c2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  ret.write<QMatrix > ((QMatrix)((QSvgRenderer *)cls)->matrixForElement (arg1));
}


// void QSvgRenderer::render(QPainter *p)


static void _init_f_render_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_render_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSvgRenderer *)cls)->render (arg1);
}


// void QSvgRenderer::render(QPainter *p, const QRectF &bounds)


static void _init_f_render_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bounds");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_render_3180 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QRectF &arg2 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSvgRenderer *)cls)->render (arg1, arg2);
}


// void QSvgRenderer::render(QPainter *p, const QString &elementId, const QRectF &bounds)


static void _init_f_render_5097 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("elementId");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("bounds", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_render_5097 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QString &arg2 = args.read<const QString & > (heap);
  const QRectF &arg3 = args ? args.read<const QRectF & > (heap) : (const QRectF &)(QRectF());
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSvgRenderer *)cls)->render (arg1, arg2, arg3);
}


// void QSvgRenderer::setCurrentFrame(int)


static void _init_f_setCurrentFrame_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentFrame_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSvgRenderer *)cls)->setCurrentFrame (arg1);
}


// void QSvgRenderer::setFramesPerSecond(int num)


static void _init_f_setFramesPerSecond_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("num");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFramesPerSecond_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSvgRenderer *)cls)->setFramesPerSecond (arg1);
}


// void QSvgRenderer::setViewBox(const QRect &viewbox)


static void _init_f_setViewBox_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewbox");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewBox_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSvgRenderer *)cls)->setViewBox (arg1);
}


// void QSvgRenderer::setViewBox(const QRectF &viewbox)


static void _init_f_setViewBox_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewbox");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewBox_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRectF &arg1 = args.read<const QRectF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSvgRenderer *)cls)->setViewBox (arg1);
}


// QRect QSvgRenderer::viewBox()


static void _init_f_viewBox_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_viewBox_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QSvgRenderer *)cls)->viewBox ());
}


// QRectF QSvgRenderer::viewBoxF()


static void _init_f_viewBoxF_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_viewBoxF_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRectF > ((QRectF)((QSvgRenderer *)cls)->viewBoxF ());
}


// static QString QSvgRenderer::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(__null);
  int arg3 = args ? args.read<int > (heap) : (int)(-1);
  ret.write<QString > ((QString)QSvgRenderer::tr (arg1, arg2, arg3));
}


// static QString QSvgRenderer::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  const char *arg2 = args ? args.read<const char * > (heap) : (const char *)(__null);
  int arg3 = args ? args.read<int > (heap) : (int)(-1);
  ret.write<QString > ((QString)QSvgRenderer::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QSvgRenderer () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("animated", "@brief Method bool QSvgRenderer::animated()\n", true, &_init_f_animated_c0, &_call_f_animated_c0);
  methods += new qt_gsi::GenericMethod ("animationDuration", "@brief Method int QSvgRenderer::animationDuration()\n", true, &_init_f_animationDuration_c0, &_call_f_animationDuration_c0);
  methods += new qt_gsi::GenericMethod ("boundsOnElement", "@brief Method QRectF QSvgRenderer::boundsOnElement(const QString &id)\n", true, &_init_f_boundsOnElement_c2025, &_call_f_boundsOnElement_c2025);
  methods += new qt_gsi::GenericMethod (":currentFrame", "@brief Method int QSvgRenderer::currentFrame()\n", true, &_init_f_currentFrame_c0, &_call_f_currentFrame_c0);
  methods += new qt_gsi::GenericMethod ("defaultSize", "@brief Method QSize QSvgRenderer::defaultSize()\n", true, &_init_f_defaultSize_c0, &_call_f_defaultSize_c0);
  methods += new qt_gsi::GenericMethod ("elementExists", "@brief Method bool QSvgRenderer::elementExists(const QString &id)\n", true, &_init_f_elementExists_c2025, &_call_f_elementExists_c2025);
  methods += new qt_gsi::GenericMethod (":framesPerSecond", "@brief Method int QSvgRenderer::framesPerSecond()\n", true, &_init_f_framesPerSecond_c0, &_call_f_framesPerSecond_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QSvgRenderer::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("load", "@brief Method bool QSvgRenderer::load(const QString &filename)\n", false, &_init_f_load_2025, &_call_f_load_2025);
  methods += new qt_gsi::GenericMethod ("load", "@brief Method bool QSvgRenderer::load(const QByteArray &contents)\n", false, &_init_f_load_2309, &_call_f_load_2309);
  methods += new qt_gsi::GenericMethod ("load", "@brief Method bool QSvgRenderer::load(QXmlStreamReader *contents)\n", false, &_init_f_load_2223, &_call_f_load_2223);
  methods += new qt_gsi::GenericMethod ("matrixForElement", "@brief Method QMatrix QSvgRenderer::matrixForElement(const QString &id)\n", true, &_init_f_matrixForElement_c2025, &_call_f_matrixForElement_c2025);
  methods += new qt_gsi::GenericMethod ("render", "@brief Method void QSvgRenderer::render(QPainter *p)\n", false, &_init_f_render_1426, &_call_f_render_1426);
  methods += new qt_gsi::GenericMethod ("render", "@brief Method void QSvgRenderer::render(QPainter *p, const QRectF &bounds)\n", false, &_init_f_render_3180, &_call_f_render_3180);
  methods += new qt_gsi::GenericMethod ("render", "@brief Method void QSvgRenderer::render(QPainter *p, const QString &elementId, const QRectF &bounds)\n", false, &_init_f_render_5097, &_call_f_render_5097);
  methods += new qt_gsi::GenericMethod ("setCurrentFrame|currentFrame=", "@brief Method void QSvgRenderer::setCurrentFrame(int)\n", false, &_init_f_setCurrentFrame_767, &_call_f_setCurrentFrame_767);
  methods += new qt_gsi::GenericMethod ("setFramesPerSecond|framesPerSecond=", "@brief Method void QSvgRenderer::setFramesPerSecond(int num)\n", false, &_init_f_setFramesPerSecond_767, &_call_f_setFramesPerSecond_767);
  methods += new qt_gsi::GenericMethod ("setViewBox|viewBox=", "@brief Method void QSvgRenderer::setViewBox(const QRect &viewbox)\n", false, &_init_f_setViewBox_1792, &_call_f_setViewBox_1792);
  methods += new qt_gsi::GenericMethod ("setViewBox|viewBox=", "@brief Method void QSvgRenderer::setViewBox(const QRectF &viewbox)\n", false, &_init_f_setViewBox_1862, &_call_f_setViewBox_1862);
  methods += new qt_gsi::GenericMethod (":viewBox", "@brief Method QRect QSvgRenderer::viewBox()\n", true, &_init_f_viewBox_c0, &_call_f_viewBox_c0);
  methods += new qt_gsi::GenericMethod ("viewBoxF", "@brief Method QRectF QSvgRenderer::viewBoxF()\n", true, &_init_f_viewBoxF_c0, &_call_f_viewBoxF_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QSvgRenderer::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("repaintNeeded()", "repaintNeeded", "@brief Signal declaration for QSvgRenderer::repaintNeeded()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSvgRenderer::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSvgRenderer::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QSvgRenderer> decl_QSvgRenderer (qtdecl_QObject (), "QSvgRenderer_Native",
  methods_QSvgRenderer (),
  "@hide\n@alias QSvgRenderer");

GSIQT_PUBLIC gsi::Class<QSvgRenderer> &qtdecl_QSvgRenderer () { return decl_QSvgRenderer; }

}


class QSvgRenderer_Adaptor : public QSvgRenderer, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSvgRenderer_Adaptor();

  //  [adaptor ctor] QSvgRenderer::QSvgRenderer(QObject *parent)
  QSvgRenderer_Adaptor() : QSvgRenderer()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSvgRenderer::QSvgRenderer(QObject *parent)
  QSvgRenderer_Adaptor(QObject *parent) : QSvgRenderer(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSvgRenderer::QSvgRenderer(const QString &filename, QObject *parent)
  QSvgRenderer_Adaptor(const QString &filename) : QSvgRenderer(filename)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSvgRenderer::QSvgRenderer(const QString &filename, QObject *parent)
  QSvgRenderer_Adaptor(const QString &filename, QObject *parent) : QSvgRenderer(filename, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSvgRenderer::QSvgRenderer(const QByteArray &contents, QObject *parent)
  QSvgRenderer_Adaptor(const QByteArray &contents) : QSvgRenderer(contents)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSvgRenderer::QSvgRenderer(const QByteArray &contents, QObject *parent)
  QSvgRenderer_Adaptor(const QByteArray &contents, QObject *parent) : QSvgRenderer(contents, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSvgRenderer::QSvgRenderer(QXmlStreamReader *contents, QObject *parent)
  QSvgRenderer_Adaptor(QXmlStreamReader *contents) : QSvgRenderer(contents)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSvgRenderer::QSvgRenderer(QXmlStreamReader *contents, QObject *parent)
  QSvgRenderer_Adaptor(QXmlStreamReader *contents, QObject *parent) : QSvgRenderer(contents, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QSvgRenderer::isSignalConnected(const QMetaMethod &signal)
  bool fp_QSvgRenderer_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QSvgRenderer::isSignalConnected(signal);
  }

  //  [expose] int QSvgRenderer::receivers(const char *signal)
  int fp_QSvgRenderer_receivers_c1731 (const char *signal) const {
    return QSvgRenderer::receivers(signal);
  }

  //  [expose] QObject *QSvgRenderer::sender()
  QObject * fp_QSvgRenderer_sender_c0 () const {
    return QSvgRenderer::sender();
  }

  //  [expose] int QSvgRenderer::senderSignalIndex()
  int fp_QSvgRenderer_senderSignalIndex_c0 () const {
    return QSvgRenderer::senderSignalIndex();
  }

  //  [emitter impl] void QSvgRenderer::destroyed(QObject *)
  void emitter_QSvgRenderer_destroyed_1302(QObject *arg1)
  {
    emit QSvgRenderer::destroyed(arg1);
  }

  //  [adaptor impl] bool QSvgRenderer::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QSvgRenderer::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSvgRenderer_Adaptor, bool, QEvent *>(&QSvgRenderer_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QSvgRenderer::event(arg1);
    }
  }

  //  [adaptor impl] bool QSvgRenderer::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QSvgRenderer::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSvgRenderer_Adaptor, bool, QObject *, QEvent *>(&QSvgRenderer_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QSvgRenderer::eventFilter(arg1, arg2);
    }
  }

  //  [emitter impl] void QSvgRenderer::repaintNeeded()
  void emitter_QSvgRenderer_repaintNeeded_0()
  {
    emit QSvgRenderer::repaintNeeded();
  }

  //  [adaptor impl] void QSvgRenderer::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QSvgRenderer::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSvgRenderer_Adaptor, QChildEvent *>(&QSvgRenderer_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QSvgRenderer::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QSvgRenderer::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QSvgRenderer::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSvgRenderer_Adaptor, QEvent *>(&QSvgRenderer_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QSvgRenderer::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QSvgRenderer::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QSvgRenderer::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QSvgRenderer_Adaptor, const QMetaMethod &>(&QSvgRenderer_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QSvgRenderer::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QSvgRenderer::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QSvgRenderer::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSvgRenderer_Adaptor, QTimerEvent *>(&QSvgRenderer_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QSvgRenderer::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QSvgRenderer_Adaptor::~QSvgRenderer_Adaptor() { }

//  Constructor QSvgRenderer::QSvgRenderer(QObject *parent) (adaptor class)

static void _init_ctor_QSvgRenderer_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSvgRenderer_Adaptor> ();
}

static void _call_ctor_QSvgRenderer_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ret.write<QSvgRenderer_Adaptor *> (new QSvgRenderer_Adaptor (arg1));
}


//  Constructor QSvgRenderer::QSvgRenderer(const QString &filename, QObject *parent) (adaptor class)

static void _init_ctor_QSvgRenderer_Adaptor_3219 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filename");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QSvgRenderer_Adaptor> ();
}

static void _call_ctor_QSvgRenderer_Adaptor_3219 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  QObject *arg2 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ret.write<QSvgRenderer_Adaptor *> (new QSvgRenderer_Adaptor (arg1, arg2));
}


//  Constructor QSvgRenderer::QSvgRenderer(const QByteArray &contents, QObject *parent) (adaptor class)

static void _init_ctor_QSvgRenderer_Adaptor_3503 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("contents");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QSvgRenderer_Adaptor> ();
}

static void _call_ctor_QSvgRenderer_Adaptor_3503 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  QObject *arg2 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ret.write<QSvgRenderer_Adaptor *> (new QSvgRenderer_Adaptor (arg1, arg2));
}


//  Constructor QSvgRenderer::QSvgRenderer(QXmlStreamReader *contents, QObject *parent) (adaptor class)

static void _init_ctor_QSvgRenderer_Adaptor_3417 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("contents");
  decl->add_arg<QXmlStreamReader * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QSvgRenderer_Adaptor> ();
}

static void _call_ctor_QSvgRenderer_Adaptor_3417 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QXmlStreamReader *arg1 = args.read<QXmlStreamReader * > (heap);
  QObject *arg2 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ret.write<QSvgRenderer_Adaptor *> (new QSvgRenderer_Adaptor (arg1, arg2));
}


// void QSvgRenderer::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSvgRenderer_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSvgRenderer_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QSvgRenderer::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSvgRenderer_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSvgRenderer_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QSvgRenderer::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? args.read<QObject * > (heap) : (QObject *)(0);
  ((QSvgRenderer_Adaptor *)cls)->emitter_QSvgRenderer_destroyed_1302 (arg1);
}


// void QSvgRenderer::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSvgRenderer_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QSvgRenderer_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QSvgRenderer::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSvgRenderer_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSvgRenderer_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QSvgRenderer::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QSvgRenderer_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSvgRenderer_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QSvgRenderer::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  ret.write<bool > ((bool)((QSvgRenderer_Adaptor *)cls)->fp_QSvgRenderer_isSignalConnected_c2394 (arg1));
}


// exposed int QSvgRenderer::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  ret.write<int > ((int)((QSvgRenderer_Adaptor *)cls)->fp_QSvgRenderer_receivers_c1731 (arg1));
}


// emitter void QSvgRenderer::repaintNeeded()

static void _init_emitter_repaintNeeded_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_repaintNeeded_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QSvgRenderer_Adaptor *)cls)->emitter_QSvgRenderer_repaintNeeded_0 ();
}


// exposed QObject *QSvgRenderer::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QSvgRenderer_Adaptor *)cls)->fp_QSvgRenderer_sender_c0 ());
}


// exposed int QSvgRenderer::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSvgRenderer_Adaptor *)cls)->fp_QSvgRenderer_senderSignalIndex_c0 ());
}


// void QSvgRenderer::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSvgRenderer_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSvgRenderer_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QSvgRenderer> &qtdecl_QSvgRenderer ();

static gsi::Methods methods_QSvgRenderer_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSvgRenderer::QSvgRenderer(QObject *parent)\nThis method creates an object of class QSvgRenderer.", &_init_ctor_QSvgRenderer_Adaptor_1302, &_call_ctor_QSvgRenderer_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSvgRenderer::QSvgRenderer(const QString &filename, QObject *parent)\nThis method creates an object of class QSvgRenderer.", &_init_ctor_QSvgRenderer_Adaptor_3219, &_call_ctor_QSvgRenderer_Adaptor_3219);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSvgRenderer::QSvgRenderer(const QByteArray &contents, QObject *parent)\nThis method creates an object of class QSvgRenderer.", &_init_ctor_QSvgRenderer_Adaptor_3503, &_call_ctor_QSvgRenderer_Adaptor_3503);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSvgRenderer::QSvgRenderer(QXmlStreamReader *contents, QObject *parent)\nThis method creates an object of class QSvgRenderer.", &_init_ctor_QSvgRenderer_Adaptor_3417, &_call_ctor_QSvgRenderer_Adaptor_3417);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSvgRenderer::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSvgRenderer::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QSvgRenderer::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSvgRenderer::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QSvgRenderer::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSvgRenderer::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QSvgRenderer::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QSvgRenderer::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_repaintNeeded", "@brief Emitter for signal void QSvgRenderer::repaintNeeded()\nCall this method to emit this signal.", false, &_init_emitter_repaintNeeded_0, &_call_emitter_repaintNeeded_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QSvgRenderer::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QSvgRenderer::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSvgRenderer::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QSvgRenderer_Adaptor> decl_QSvgRenderer_Adaptor (qtdecl_QSvgRenderer (), "QSvgRenderer",
  methods_QSvgRenderer_Adaptor (),
  "@qt\n@brief Binding of QSvgRenderer");

}

