
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextCharFormat.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTextCharFormat>
#include <QBrush>
#include <QColor>
#include <QFont>
#include <QPen>
#include <QTextBlockFormat>
#include <QTextFormat>
#include <QTextFrameFormat>
#include <QTextImageFormat>
#include <QTextLength>
#include <QTextListFormat>
#include <QTextTableCellFormat>
#include <QTextTableFormat>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextCharFormat

//  Constructor QTextCharFormat::QTextCharFormat()


static void _init_ctor_QTextCharFormat_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTextCharFormat> ();
}

static void _call_ctor_QTextCharFormat_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextCharFormat *> (new QTextCharFormat ());
}


// QString QTextCharFormat::anchorHref()


static void _init_f_anchorHref_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_anchorHref_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextCharFormat *)cls)->anchorHref ());
}


// QString QTextCharFormat::anchorName()


static void _init_f_anchorName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_anchorName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextCharFormat *)cls)->anchorName ());
}


// QStringList QTextCharFormat::anchorNames()


static void _init_f_anchorNames_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStringList > ();
}

static void _call_f_anchorNames_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QStringList > ((QStringList)((QTextCharFormat *)cls)->anchorNames ());
}


// QFont QTextCharFormat::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFont > ((QFont)((QTextCharFormat *)cls)->font ());
}


// QFont::Capitalization QTextCharFormat::fontCapitalization()


static void _init_f_fontCapitalization_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::Capitalization>::target_type > ();
}

static void _call_f_fontCapitalization_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFont::Capitalization>::target_type > ((qt_gsi::Converter<QFont::Capitalization>::target_type)qt_gsi::CppToQtAdaptor<QFont::Capitalization>(((QTextCharFormat *)cls)->fontCapitalization ()));
}


// QString QTextCharFormat::fontFamily()


static void _init_f_fontFamily_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fontFamily_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextCharFormat *)cls)->fontFamily ());
}


// bool QTextCharFormat::fontFixedPitch()


static void _init_f_fontFixedPitch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fontFixedPitch_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCharFormat *)cls)->fontFixedPitch ());
}


// QFont::HintingPreference QTextCharFormat::fontHintingPreference()


static void _init_f_fontHintingPreference_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::HintingPreference>::target_type > ();
}

static void _call_f_fontHintingPreference_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFont::HintingPreference>::target_type > ((qt_gsi::Converter<QFont::HintingPreference>::target_type)qt_gsi::CppToQtAdaptor<QFont::HintingPreference>(((QTextCharFormat *)cls)->fontHintingPreference ()));
}


// bool QTextCharFormat::fontItalic()


static void _init_f_fontItalic_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fontItalic_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCharFormat *)cls)->fontItalic ());
}


// bool QTextCharFormat::fontKerning()


static void _init_f_fontKerning_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fontKerning_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCharFormat *)cls)->fontKerning ());
}


// double QTextCharFormat::fontLetterSpacing()


static void _init_f_fontLetterSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_fontLetterSpacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTextCharFormat *)cls)->fontLetterSpacing ());
}


// QFont::SpacingType QTextCharFormat::fontLetterSpacingType()


static void _init_f_fontLetterSpacingType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::SpacingType>::target_type > ();
}

static void _call_f_fontLetterSpacingType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFont::SpacingType>::target_type > ((qt_gsi::Converter<QFont::SpacingType>::target_type)qt_gsi::CppToQtAdaptor<QFont::SpacingType>(((QTextCharFormat *)cls)->fontLetterSpacingType ()));
}


// bool QTextCharFormat::fontOverline()


static void _init_f_fontOverline_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fontOverline_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCharFormat *)cls)->fontOverline ());
}


// double QTextCharFormat::fontPointSize()


static void _init_f_fontPointSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_fontPointSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTextCharFormat *)cls)->fontPointSize ());
}


// int QTextCharFormat::fontStretch()


static void _init_f_fontStretch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_fontStretch_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextCharFormat *)cls)->fontStretch ());
}


// bool QTextCharFormat::fontStrikeOut()


static void _init_f_fontStrikeOut_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fontStrikeOut_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCharFormat *)cls)->fontStrikeOut ());
}


// QFont::StyleHint QTextCharFormat::fontStyleHint()


static void _init_f_fontStyleHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::StyleHint>::target_type > ();
}

static void _call_f_fontStyleHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFont::StyleHint>::target_type > ((qt_gsi::Converter<QFont::StyleHint>::target_type)qt_gsi::CppToQtAdaptor<QFont::StyleHint>(((QTextCharFormat *)cls)->fontStyleHint ()));
}


// QFont::StyleStrategy QTextCharFormat::fontStyleStrategy()


static void _init_f_fontStyleStrategy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFont::StyleStrategy>::target_type > ();
}

static void _call_f_fontStyleStrategy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFont::StyleStrategy>::target_type > ((qt_gsi::Converter<QFont::StyleStrategy>::target_type)qt_gsi::CppToQtAdaptor<QFont::StyleStrategy>(((QTextCharFormat *)cls)->fontStyleStrategy ()));
}


// bool QTextCharFormat::fontUnderline()


static void _init_f_fontUnderline_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_fontUnderline_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCharFormat *)cls)->fontUnderline ());
}


// int QTextCharFormat::fontWeight()


static void _init_f_fontWeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_fontWeight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextCharFormat *)cls)->fontWeight ());
}


// double QTextCharFormat::fontWordSpacing()


static void _init_f_fontWordSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_fontWordSpacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QTextCharFormat *)cls)->fontWordSpacing ());
}


// bool QTextCharFormat::isAnchor()


static void _init_f_isAnchor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAnchor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCharFormat *)cls)->isAnchor ());
}


// () const


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextCharFormat *)cls)->isValid ());
}


// void QTextCharFormat::setAnchor(bool anchor)


static void _init_f_setAnchor_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("anchor");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAnchor_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setAnchor (arg1);
}


// void QTextCharFormat::setAnchorHref(const QString &value)


static void _init_f_setAnchorHref_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAnchorHref_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setAnchorHref (arg1);
}


// void QTextCharFormat::setAnchorName(const QString &name)


static void _init_f_setAnchorName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAnchorName_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setAnchorName (arg1);
}


// void QTextCharFormat::setAnchorNames(const QStringList &names)


static void _init_f_setAnchorNames_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("names");
  decl->add_arg<const QStringList & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAnchorNames_2437 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStringList &arg1 = args.read<const QStringList & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setAnchorNames (arg1);
}


// void QTextCharFormat::setFont(const QFont &font, QTextCharFormat::FontPropertiesInheritanceBehavior behavior)


static void _init_f_setFont_7168 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("behavior");
  decl->add_arg<const qt_gsi::Converter<QTextCharFormat::FontPropertiesInheritanceBehavior>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFont_7168 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  const qt_gsi::Converter<QTextCharFormat::FontPropertiesInheritanceBehavior>::target_type & arg2 = args.read<const qt_gsi::Converter<QTextCharFormat::FontPropertiesInheritanceBehavior>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFont (arg1, qt_gsi::QtToCppAdaptor<QTextCharFormat::FontPropertiesInheritanceBehavior>(arg2).cref());
}


// void QTextCharFormat::setFont(const QFont &font)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QFont &arg1 = args.read<const QFont & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFont (arg1);
}


// void QTextCharFormat::setFontCapitalization(QFont::Capitalization capitalization)


static void _init_f_setFontCapitalization_2508 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("capitalization");
  decl->add_arg<const qt_gsi::Converter<QFont::Capitalization>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontCapitalization_2508 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFont::Capitalization>::target_type & arg1 = args.read<const qt_gsi::Converter<QFont::Capitalization>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontCapitalization (qt_gsi::QtToCppAdaptor<QFont::Capitalization>(arg1).cref());
}


// void QTextCharFormat::setFontFamily(const QString &family)


static void _init_f_setFontFamily_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("family");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontFamily_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontFamily (arg1);
}


// void QTextCharFormat::setFontFixedPitch(bool fixedPitch)


static void _init_f_setFontFixedPitch_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fixedPitch");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontFixedPitch_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontFixedPitch (arg1);
}


// void QTextCharFormat::setFontHintingPreference(QFont::HintingPreference hintingPreference)


static void _init_f_setFontHintingPreference_2784 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hintingPreference");
  decl->add_arg<const qt_gsi::Converter<QFont::HintingPreference>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontHintingPreference_2784 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFont::HintingPreference>::target_type & arg1 = args.read<const qt_gsi::Converter<QFont::HintingPreference>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontHintingPreference (qt_gsi::QtToCppAdaptor<QFont::HintingPreference>(arg1).cref());
}


// void QTextCharFormat::setFontItalic(bool italic)


static void _init_f_setFontItalic_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("italic");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontItalic_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontItalic (arg1);
}


// void QTextCharFormat::setFontKerning(bool enable)


static void _init_f_setFontKerning_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontKerning_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontKerning (arg1);
}


// void QTextCharFormat::setFontLetterSpacing(double spacing)


static void _init_f_setFontLetterSpacing_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontLetterSpacing_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontLetterSpacing (arg1);
}


// void QTextCharFormat::setFontLetterSpacingType(QFont::SpacingType letterSpacingType)


static void _init_f_setFontLetterSpacingType_2167 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("letterSpacingType");
  decl->add_arg<const qt_gsi::Converter<QFont::SpacingType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontLetterSpacingType_2167 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFont::SpacingType>::target_type & arg1 = args.read<const qt_gsi::Converter<QFont::SpacingType>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontLetterSpacingType (qt_gsi::QtToCppAdaptor<QFont::SpacingType>(arg1).cref());
}


// void QTextCharFormat::setFontOverline(bool overline)


static void _init_f_setFontOverline_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("overline");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontOverline_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontOverline (arg1);
}


// void QTextCharFormat::setFontPointSize(double size)


static void _init_f_setFontPointSize_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontPointSize_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontPointSize (arg1);
}


// void QTextCharFormat::setFontStretch(int factor)


static void _init_f_setFontStretch_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("factor");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontStretch_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontStretch (arg1);
}


// void QTextCharFormat::setFontStrikeOut(bool strikeOut)


static void _init_f_setFontStrikeOut_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("strikeOut");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontStrikeOut_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontStrikeOut (arg1);
}


// void QTextCharFormat::setFontStyleHint(QFont::StyleHint hint, QFont::StyleStrategy strategy)


static void _init_f_setFontStyleHint_4284 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hint");
  decl->add_arg<const qt_gsi::Converter<QFont::StyleHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("strategy", true, "QFont::PreferDefault");
  decl->add_arg<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFontStyleHint_4284 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFont::StyleHint>::target_type & arg1 = args.read<const qt_gsi::Converter<QFont::StyleHint>::target_type & > (heap);
  const qt_gsi::Converter<QFont::StyleStrategy>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & > (heap) : (const qt_gsi::Converter<QFont::StyleStrategy>::target_type &)(qt_gsi::CppToQtReadAdaptor<QFont::StyleStrategy>(heap, QFont::PreferDefault));
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontStyleHint (qt_gsi::QtToCppAdaptor<QFont::StyleHint>(arg1).cref(), qt_gsi::QtToCppAdaptor<QFont::StyleStrategy>(arg2).cref());
}


// void QTextCharFormat::setFontStyleStrategy(QFont::StyleStrategy strategy)


static void _init_f_setFontStyleStrategy_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("strategy");
  decl->add_arg<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontStyleStrategy_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFont::StyleStrategy>::target_type & arg1 = args.read<const qt_gsi::Converter<QFont::StyleStrategy>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontStyleStrategy (qt_gsi::QtToCppAdaptor<QFont::StyleStrategy>(arg1).cref());
}


// void QTextCharFormat::setFontUnderline(bool underline)


static void _init_f_setFontUnderline_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("underline");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontUnderline_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontUnderline (arg1);
}


// void QTextCharFormat::setFontWeight(int weight)


static void _init_f_setFontWeight_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("weight");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontWeight_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontWeight (arg1);
}


// void QTextCharFormat::setFontWordSpacing(double spacing)


static void _init_f_setFontWordSpacing_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFontWordSpacing_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setFontWordSpacing (arg1);
}


// void QTextCharFormat::setTableCellColumnSpan(int tableCellColumnSpan)


static void _init_f_setTableCellColumnSpan_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableCellColumnSpan");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTableCellColumnSpan_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setTableCellColumnSpan (arg1);
}


// void QTextCharFormat::setTableCellRowSpan(int tableCellRowSpan)


static void _init_f_setTableCellRowSpan_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableCellRowSpan");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTableCellRowSpan_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setTableCellRowSpan (arg1);
}


// void QTextCharFormat::setTextOutline(const QPen &pen)


static void _init_f_setTextOutline_1685 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pen");
  decl->add_arg<const QPen & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextOutline_1685 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPen &arg1 = args.read<const QPen & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setTextOutline (arg1);
}


// void QTextCharFormat::setToolTip(const QString &tip)


static void _init_f_setToolTip_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tip");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setToolTip_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setToolTip (arg1);
}


// void QTextCharFormat::setUnderlineColor(const QColor &color)


static void _init_f_setUnderlineColor_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("color");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUnderlineColor_1905 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QColor &arg1 = args.read<const QColor & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setUnderlineColor (arg1);
}


// void QTextCharFormat::setUnderlineStyle(QTextCharFormat::UnderlineStyle style)


static void _init_f_setUnderlineStyle_3516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<QTextCharFormat::UnderlineStyle>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUnderlineStyle_3516 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextCharFormat::UnderlineStyle>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextCharFormat::UnderlineStyle>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setUnderlineStyle (qt_gsi::QtToCppAdaptor<QTextCharFormat::UnderlineStyle>(arg1).cref());
}


// void QTextCharFormat::setVerticalAlignment(QTextCharFormat::VerticalAlignment alignment)


static void _init_f_setVerticalAlignment_3806 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QTextCharFormat::VerticalAlignment>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVerticalAlignment_3806 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextCharFormat::VerticalAlignment>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextCharFormat::VerticalAlignment>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextCharFormat *)cls)->setVerticalAlignment (qt_gsi::QtToCppAdaptor<QTextCharFormat::VerticalAlignment>(arg1).cref());
}


// int QTextCharFormat::tableCellColumnSpan()


static void _init_f_tableCellColumnSpan_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_tableCellColumnSpan_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextCharFormat *)cls)->tableCellColumnSpan ());
}


// int QTextCharFormat::tableCellRowSpan()


static void _init_f_tableCellRowSpan_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_tableCellRowSpan_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextCharFormat *)cls)->tableCellRowSpan ());
}


// QPen QTextCharFormat::textOutline()


static void _init_f_textOutline_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPen > ();
}

static void _call_f_textOutline_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPen > ((QPen)((QTextCharFormat *)cls)->textOutline ());
}


// QString QTextCharFormat::toolTip()


static void _init_f_toolTip_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toolTip_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextCharFormat *)cls)->toolTip ());
}


// QColor QTextCharFormat::underlineColor()


static void _init_f_underlineColor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_underlineColor_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QColor > ((QColor)((QTextCharFormat *)cls)->underlineColor ());
}


// QTextCharFormat::UnderlineStyle QTextCharFormat::underlineStyle()


static void _init_f_underlineStyle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextCharFormat::UnderlineStyle>::target_type > ();
}

static void _call_f_underlineStyle_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTextCharFormat::UnderlineStyle>::target_type > ((qt_gsi::Converter<QTextCharFormat::UnderlineStyle>::target_type)qt_gsi::CppToQtAdaptor<QTextCharFormat::UnderlineStyle>(((QTextCharFormat *)cls)->underlineStyle ()));
}


// QTextCharFormat::VerticalAlignment QTextCharFormat::verticalAlignment()


static void _init_f_verticalAlignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextCharFormat::VerticalAlignment>::target_type > ();
}

static void _call_f_verticalAlignment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTextCharFormat::VerticalAlignment>::target_type > ((qt_gsi::Converter<QTextCharFormat::VerticalAlignment>::target_type)qt_gsi::CppToQtAdaptor<QTextCharFormat::VerticalAlignment>(((QTextCharFormat *)cls)->verticalAlignment ()));
}



namespace gsi
{

static gsi::Methods methods_QTextCharFormat () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextCharFormat::QTextCharFormat()\nThis method creates an object of class QTextCharFormat.", &_init_ctor_QTextCharFormat_0, &_call_ctor_QTextCharFormat_0);
  methods += new qt_gsi::GenericMethod (":anchorHref", "@brief Method QString QTextCharFormat::anchorHref()\n", true, &_init_f_anchorHref_c0, &_call_f_anchorHref_c0);
  methods += new qt_gsi::GenericMethod (":anchorName", "@brief Method QString QTextCharFormat::anchorName()\n", true, &_init_f_anchorName_c0, &_call_f_anchorName_c0);
  methods += new qt_gsi::GenericMethod (":anchorNames", "@brief Method QStringList QTextCharFormat::anchorNames()\n", true, &_init_f_anchorNames_c0, &_call_f_anchorNames_c0);
  methods += new qt_gsi::GenericMethod (":font", "@brief Method QFont QTextCharFormat::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
  methods += new qt_gsi::GenericMethod (":fontCapitalization", "@brief Method QFont::Capitalization QTextCharFormat::fontCapitalization()\n", true, &_init_f_fontCapitalization_c0, &_call_f_fontCapitalization_c0);
  methods += new qt_gsi::GenericMethod (":fontFamily", "@brief Method QString QTextCharFormat::fontFamily()\n", true, &_init_f_fontFamily_c0, &_call_f_fontFamily_c0);
  methods += new qt_gsi::GenericMethod (":fontFixedPitch", "@brief Method bool QTextCharFormat::fontFixedPitch()\n", true, &_init_f_fontFixedPitch_c0, &_call_f_fontFixedPitch_c0);
  methods += new qt_gsi::GenericMethod (":fontHintingPreference", "@brief Method QFont::HintingPreference QTextCharFormat::fontHintingPreference()\n", true, &_init_f_fontHintingPreference_c0, &_call_f_fontHintingPreference_c0);
  methods += new qt_gsi::GenericMethod (":fontItalic", "@brief Method bool QTextCharFormat::fontItalic()\n", true, &_init_f_fontItalic_c0, &_call_f_fontItalic_c0);
  methods += new qt_gsi::GenericMethod (":fontKerning", "@brief Method bool QTextCharFormat::fontKerning()\n", true, &_init_f_fontKerning_c0, &_call_f_fontKerning_c0);
  methods += new qt_gsi::GenericMethod (":fontLetterSpacing", "@brief Method double QTextCharFormat::fontLetterSpacing()\n", true, &_init_f_fontLetterSpacing_c0, &_call_f_fontLetterSpacing_c0);
  methods += new qt_gsi::GenericMethod (":fontLetterSpacingType", "@brief Method QFont::SpacingType QTextCharFormat::fontLetterSpacingType()\n", true, &_init_f_fontLetterSpacingType_c0, &_call_f_fontLetterSpacingType_c0);
  methods += new qt_gsi::GenericMethod (":fontOverline", "@brief Method bool QTextCharFormat::fontOverline()\n", true, &_init_f_fontOverline_c0, &_call_f_fontOverline_c0);
  methods += new qt_gsi::GenericMethod (":fontPointSize", "@brief Method double QTextCharFormat::fontPointSize()\n", true, &_init_f_fontPointSize_c0, &_call_f_fontPointSize_c0);
  methods += new qt_gsi::GenericMethod (":fontStretch", "@brief Method int QTextCharFormat::fontStretch()\n", true, &_init_f_fontStretch_c0, &_call_f_fontStretch_c0);
  methods += new qt_gsi::GenericMethod (":fontStrikeOut", "@brief Method bool QTextCharFormat::fontStrikeOut()\n", true, &_init_f_fontStrikeOut_c0, &_call_f_fontStrikeOut_c0);
  methods += new qt_gsi::GenericMethod (":fontStyleHint", "@brief Method QFont::StyleHint QTextCharFormat::fontStyleHint()\n", true, &_init_f_fontStyleHint_c0, &_call_f_fontStyleHint_c0);
  methods += new qt_gsi::GenericMethod (":fontStyleStrategy", "@brief Method QFont::StyleStrategy QTextCharFormat::fontStyleStrategy()\n", true, &_init_f_fontStyleStrategy_c0, &_call_f_fontStyleStrategy_c0);
  methods += new qt_gsi::GenericMethod (":fontUnderline", "@brief Method bool QTextCharFormat::fontUnderline()\n", true, &_init_f_fontUnderline_c0, &_call_f_fontUnderline_c0);
  methods += new qt_gsi::GenericMethod (":fontWeight", "@brief Method int QTextCharFormat::fontWeight()\n", true, &_init_f_fontWeight_c0, &_call_f_fontWeight_c0);
  methods += new qt_gsi::GenericMethod (":fontWordSpacing", "@brief Method double QTextCharFormat::fontWordSpacing()\n", true, &_init_f_fontWordSpacing_c0, &_call_f_fontWordSpacing_c0);
  methods += new qt_gsi::GenericMethod ("isAnchor?|:anchor", "@brief Method bool QTextCharFormat::isAnchor()\n", true, &_init_f_isAnchor_c0, &_call_f_isAnchor_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method () const\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("setAnchor|anchor=", "@brief Method void QTextCharFormat::setAnchor(bool anchor)\n", false, &_init_f_setAnchor_864, &_call_f_setAnchor_864);
  methods += new qt_gsi::GenericMethod ("setAnchorHref|anchorHref=", "@brief Method void QTextCharFormat::setAnchorHref(const QString &value)\n", false, &_init_f_setAnchorHref_2025, &_call_f_setAnchorHref_2025);
  methods += new qt_gsi::GenericMethod ("setAnchorName|anchorName=", "@brief Method void QTextCharFormat::setAnchorName(const QString &name)\n", false, &_init_f_setAnchorName_2025, &_call_f_setAnchorName_2025);
  methods += new qt_gsi::GenericMethod ("setAnchorNames|anchorNames=", "@brief Method void QTextCharFormat::setAnchorNames(const QStringList &names)\n", false, &_init_f_setAnchorNames_2437, &_call_f_setAnchorNames_2437);
  methods += new qt_gsi::GenericMethod ("setFont", "@brief Method void QTextCharFormat::setFont(const QFont &font, QTextCharFormat::FontPropertiesInheritanceBehavior behavior)\n", false, &_init_f_setFont_7168, &_call_f_setFont_7168);
  methods += new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QTextCharFormat::setFont(const QFont &font)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
  methods += new qt_gsi::GenericMethod ("setFontCapitalization|fontCapitalization=", "@brief Method void QTextCharFormat::setFontCapitalization(QFont::Capitalization capitalization)\n", false, &_init_f_setFontCapitalization_2508, &_call_f_setFontCapitalization_2508);
  methods += new qt_gsi::GenericMethod ("setFontFamily|fontFamily=", "@brief Method void QTextCharFormat::setFontFamily(const QString &family)\n", false, &_init_f_setFontFamily_2025, &_call_f_setFontFamily_2025);
  methods += new qt_gsi::GenericMethod ("setFontFixedPitch|fontFixedPitch=", "@brief Method void QTextCharFormat::setFontFixedPitch(bool fixedPitch)\n", false, &_init_f_setFontFixedPitch_864, &_call_f_setFontFixedPitch_864);
  methods += new qt_gsi::GenericMethod ("setFontHintingPreference|fontHintingPreference=", "@brief Method void QTextCharFormat::setFontHintingPreference(QFont::HintingPreference hintingPreference)\n", false, &_init_f_setFontHintingPreference_2784, &_call_f_setFontHintingPreference_2784);
  methods += new qt_gsi::GenericMethod ("setFontItalic|fontItalic=", "@brief Method void QTextCharFormat::setFontItalic(bool italic)\n", false, &_init_f_setFontItalic_864, &_call_f_setFontItalic_864);
  methods += new qt_gsi::GenericMethod ("setFontKerning|fontKerning=", "@brief Method void QTextCharFormat::setFontKerning(bool enable)\n", false, &_init_f_setFontKerning_864, &_call_f_setFontKerning_864);
  methods += new qt_gsi::GenericMethod ("setFontLetterSpacing|fontLetterSpacing=", "@brief Method void QTextCharFormat::setFontLetterSpacing(double spacing)\n", false, &_init_f_setFontLetterSpacing_1071, &_call_f_setFontLetterSpacing_1071);
  methods += new qt_gsi::GenericMethod ("setFontLetterSpacingType|fontLetterSpacingType=", "@brief Method void QTextCharFormat::setFontLetterSpacingType(QFont::SpacingType letterSpacingType)\n", false, &_init_f_setFontLetterSpacingType_2167, &_call_f_setFontLetterSpacingType_2167);
  methods += new qt_gsi::GenericMethod ("setFontOverline|fontOverline=", "@brief Method void QTextCharFormat::setFontOverline(bool overline)\n", false, &_init_f_setFontOverline_864, &_call_f_setFontOverline_864);
  methods += new qt_gsi::GenericMethod ("setFontPointSize|fontPointSize=", "@brief Method void QTextCharFormat::setFontPointSize(double size)\n", false, &_init_f_setFontPointSize_1071, &_call_f_setFontPointSize_1071);
  methods += new qt_gsi::GenericMethod ("setFontStretch|fontStretch=", "@brief Method void QTextCharFormat::setFontStretch(int factor)\n", false, &_init_f_setFontStretch_767, &_call_f_setFontStretch_767);
  methods += new qt_gsi::GenericMethod ("setFontStrikeOut|fontStrikeOut=", "@brief Method void QTextCharFormat::setFontStrikeOut(bool strikeOut)\n", false, &_init_f_setFontStrikeOut_864, &_call_f_setFontStrikeOut_864);
  methods += new qt_gsi::GenericMethod ("setFontStyleHint", "@brief Method void QTextCharFormat::setFontStyleHint(QFont::StyleHint hint, QFont::StyleStrategy strategy)\n", false, &_init_f_setFontStyleHint_4284, &_call_f_setFontStyleHint_4284);
  methods += new qt_gsi::GenericMethod ("setFontStyleStrategy|fontStyleStrategy=", "@brief Method void QTextCharFormat::setFontStyleStrategy(QFont::StyleStrategy strategy)\n", false, &_init_f_setFontStyleStrategy_2420, &_call_f_setFontStyleStrategy_2420);
  methods += new qt_gsi::GenericMethod ("setFontUnderline|fontUnderline=", "@brief Method void QTextCharFormat::setFontUnderline(bool underline)\n", false, &_init_f_setFontUnderline_864, &_call_f_setFontUnderline_864);
  methods += new qt_gsi::GenericMethod ("setFontWeight|fontWeight=", "@brief Method void QTextCharFormat::setFontWeight(int weight)\n", false, &_init_f_setFontWeight_767, &_call_f_setFontWeight_767);
  methods += new qt_gsi::GenericMethod ("setFontWordSpacing|fontWordSpacing=", "@brief Method void QTextCharFormat::setFontWordSpacing(double spacing)\n", false, &_init_f_setFontWordSpacing_1071, &_call_f_setFontWordSpacing_1071);
  methods += new qt_gsi::GenericMethod ("setTableCellColumnSpan|tableCellColumnSpan=", "@brief Method void QTextCharFormat::setTableCellColumnSpan(int tableCellColumnSpan)\n", false, &_init_f_setTableCellColumnSpan_767, &_call_f_setTableCellColumnSpan_767);
  methods += new qt_gsi::GenericMethod ("setTableCellRowSpan|tableCellRowSpan=", "@brief Method void QTextCharFormat::setTableCellRowSpan(int tableCellRowSpan)\n", false, &_init_f_setTableCellRowSpan_767, &_call_f_setTableCellRowSpan_767);
  methods += new qt_gsi::GenericMethod ("setTextOutline|textOutline=", "@brief Method void QTextCharFormat::setTextOutline(const QPen &pen)\n", false, &_init_f_setTextOutline_1685, &_call_f_setTextOutline_1685);
  methods += new qt_gsi::GenericMethod ("setToolTip|toolTip=", "@brief Method void QTextCharFormat::setToolTip(const QString &tip)\n", false, &_init_f_setToolTip_2025, &_call_f_setToolTip_2025);
  methods += new qt_gsi::GenericMethod ("setUnderlineColor|underlineColor=", "@brief Method void QTextCharFormat::setUnderlineColor(const QColor &color)\n", false, &_init_f_setUnderlineColor_1905, &_call_f_setUnderlineColor_1905);
  methods += new qt_gsi::GenericMethod ("setUnderlineStyle|underlineStyle=", "@brief Method void QTextCharFormat::setUnderlineStyle(QTextCharFormat::UnderlineStyle style)\n", false, &_init_f_setUnderlineStyle_3516, &_call_f_setUnderlineStyle_3516);
  methods += new qt_gsi::GenericMethod ("setVerticalAlignment|verticalAlignment=", "@brief Method void QTextCharFormat::setVerticalAlignment(QTextCharFormat::VerticalAlignment alignment)\n", false, &_init_f_setVerticalAlignment_3806, &_call_f_setVerticalAlignment_3806);
  methods += new qt_gsi::GenericMethod (":tableCellColumnSpan", "@brief Method int QTextCharFormat::tableCellColumnSpan()\n", true, &_init_f_tableCellColumnSpan_c0, &_call_f_tableCellColumnSpan_c0);
  methods += new qt_gsi::GenericMethod (":tableCellRowSpan", "@brief Method int QTextCharFormat::tableCellRowSpan()\n", true, &_init_f_tableCellRowSpan_c0, &_call_f_tableCellRowSpan_c0);
  methods += new qt_gsi::GenericMethod (":textOutline", "@brief Method QPen QTextCharFormat::textOutline()\n", true, &_init_f_textOutline_c0, &_call_f_textOutline_c0);
  methods += new qt_gsi::GenericMethod (":toolTip", "@brief Method QString QTextCharFormat::toolTip()\n", true, &_init_f_toolTip_c0, &_call_f_toolTip_c0);
  methods += new qt_gsi::GenericMethod (":underlineColor", "@brief Method QColor QTextCharFormat::underlineColor()\n", true, &_init_f_underlineColor_c0, &_call_f_underlineColor_c0);
  methods += new qt_gsi::GenericMethod (":underlineStyle", "@brief Method QTextCharFormat::UnderlineStyle QTextCharFormat::underlineStyle()\n", true, &_init_f_underlineStyle_c0, &_call_f_underlineStyle_c0);
  methods += new qt_gsi::GenericMethod (":verticalAlignment", "@brief Method QTextCharFormat::VerticalAlignment QTextCharFormat::verticalAlignment()\n", true, &_init_f_verticalAlignment_c0, &_call_f_verticalAlignment_c0);
  return methods;
}

gsi::Class<QTextFormat> &qtdecl_QTextFormat ();

gsi::Class<QTextCharFormat> decl_QTextCharFormat (qtdecl_QTextFormat (), "QTextCharFormat",
  methods_QTextCharFormat (),
  "@qt\n@brief Binding of QTextCharFormat");


GSIQT_PUBLIC gsi::Class<QTextCharFormat> &qtdecl_QTextCharFormat () { return decl_QTextCharFormat; }

}


//  Implementation of the enum wrapper class for QTextCharFormat::FontPropertiesInheritanceBehavior
namespace qt_gsi
{

static gsi::Enum<QTextCharFormat::FontPropertiesInheritanceBehavior> decl_QTextCharFormat_FontPropertiesInheritanceBehavior_Enum ("QTextCharFormat_FontPropertiesInheritanceBehavior",
    gsi::enum_const ("FontPropertiesSpecifiedOnly", QTextCharFormat::FontPropertiesSpecifiedOnly, "@brief Enum constant QTextCharFormat::FontPropertiesSpecifiedOnly") +
    gsi::enum_const ("FontPropertiesAll", QTextCharFormat::FontPropertiesAll, "@brief Enum constant QTextCharFormat::FontPropertiesAll"),
  "@qt\n@brief This class represents the QTextCharFormat::FontPropertiesInheritanceBehavior enum");

static gsi::QFlagsClass<QTextCharFormat::FontPropertiesInheritanceBehavior > decl_QTextCharFormat_FontPropertiesInheritanceBehavior_Enums ("QTextCharFormat_QFlags_FontPropertiesInheritanceBehavior",
  "@qt\n@brief This class represents the QFlags<QTextCharFormat::FontPropertiesInheritanceBehavior> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextCharFormat> inject_QTextCharFormat_FontPropertiesInheritanceBehavior_Enum_in_parent (decl_QTextCharFormat_FontPropertiesInheritanceBehavior_Enum.defs ());
static gsi::ClassExt<QTextCharFormat> decl_QTextCharFormat_FontPropertiesInheritanceBehavior_Enum_as_child (decl_QTextCharFormat_FontPropertiesInheritanceBehavior_Enum, "FontPropertiesInheritanceBehavior");
static gsi::ClassExt<QTextCharFormat> decl_QTextCharFormat_FontPropertiesInheritanceBehavior_Enums_as_child (decl_QTextCharFormat_FontPropertiesInheritanceBehavior_Enums, "QFlags_FontPropertiesInheritanceBehavior");

}


//  Implementation of the enum wrapper class for QTextCharFormat::UnderlineStyle
namespace qt_gsi
{

static gsi::Enum<QTextCharFormat::UnderlineStyle> decl_QTextCharFormat_UnderlineStyle_Enum ("QTextCharFormat_UnderlineStyle",
    gsi::enum_const ("NoUnderline", QTextCharFormat::NoUnderline, "@brief Enum constant QTextCharFormat::NoUnderline") +
    gsi::enum_const ("SingleUnderline", QTextCharFormat::SingleUnderline, "@brief Enum constant QTextCharFormat::SingleUnderline") +
    gsi::enum_const ("DashUnderline", QTextCharFormat::DashUnderline, "@brief Enum constant QTextCharFormat::DashUnderline") +
    gsi::enum_const ("DotLine", QTextCharFormat::DotLine, "@brief Enum constant QTextCharFormat::DotLine") +
    gsi::enum_const ("DashDotLine", QTextCharFormat::DashDotLine, "@brief Enum constant QTextCharFormat::DashDotLine") +
    gsi::enum_const ("DashDotDotLine", QTextCharFormat::DashDotDotLine, "@brief Enum constant QTextCharFormat::DashDotDotLine") +
    gsi::enum_const ("WaveUnderline", QTextCharFormat::WaveUnderline, "@brief Enum constant QTextCharFormat::WaveUnderline") +
    gsi::enum_const ("SpellCheckUnderline", QTextCharFormat::SpellCheckUnderline, "@brief Enum constant QTextCharFormat::SpellCheckUnderline"),
  "@qt\n@brief This class represents the QTextCharFormat::UnderlineStyle enum");

static gsi::QFlagsClass<QTextCharFormat::UnderlineStyle > decl_QTextCharFormat_UnderlineStyle_Enums ("QTextCharFormat_QFlags_UnderlineStyle",
  "@qt\n@brief This class represents the QFlags<QTextCharFormat::UnderlineStyle> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextCharFormat> inject_QTextCharFormat_UnderlineStyle_Enum_in_parent (decl_QTextCharFormat_UnderlineStyle_Enum.defs ());
static gsi::ClassExt<QTextCharFormat> decl_QTextCharFormat_UnderlineStyle_Enum_as_child (decl_QTextCharFormat_UnderlineStyle_Enum, "UnderlineStyle");
static gsi::ClassExt<QTextCharFormat> decl_QTextCharFormat_UnderlineStyle_Enums_as_child (decl_QTextCharFormat_UnderlineStyle_Enums, "QFlags_UnderlineStyle");

}


//  Implementation of the enum wrapper class for QTextCharFormat::VerticalAlignment
namespace qt_gsi
{

static gsi::Enum<QTextCharFormat::VerticalAlignment> decl_QTextCharFormat_VerticalAlignment_Enum ("QTextCharFormat_VerticalAlignment",
    gsi::enum_const ("AlignNormal", QTextCharFormat::AlignNormal, "@brief Enum constant QTextCharFormat::AlignNormal") +
    gsi::enum_const ("AlignSuperScript", QTextCharFormat::AlignSuperScript, "@brief Enum constant QTextCharFormat::AlignSuperScript") +
    gsi::enum_const ("AlignSubScript", QTextCharFormat::AlignSubScript, "@brief Enum constant QTextCharFormat::AlignSubScript") +
    gsi::enum_const ("AlignMiddle", QTextCharFormat::AlignMiddle, "@brief Enum constant QTextCharFormat::AlignMiddle") +
    gsi::enum_const ("AlignTop", QTextCharFormat::AlignTop, "@brief Enum constant QTextCharFormat::AlignTop") +
    gsi::enum_const ("AlignBottom", QTextCharFormat::AlignBottom, "@brief Enum constant QTextCharFormat::AlignBottom") +
    gsi::enum_const ("AlignBaseline", QTextCharFormat::AlignBaseline, "@brief Enum constant QTextCharFormat::AlignBaseline"),
  "@qt\n@brief This class represents the QTextCharFormat::VerticalAlignment enum");

static gsi::QFlagsClass<QTextCharFormat::VerticalAlignment > decl_QTextCharFormat_VerticalAlignment_Enums ("QTextCharFormat_QFlags_VerticalAlignment",
  "@qt\n@brief This class represents the QFlags<QTextCharFormat::VerticalAlignment> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextCharFormat> inject_QTextCharFormat_VerticalAlignment_Enum_in_parent (decl_QTextCharFormat_VerticalAlignment_Enum.defs ());
static gsi::ClassExt<QTextCharFormat> decl_QTextCharFormat_VerticalAlignment_Enum_as_child (decl_QTextCharFormat_VerticalAlignment_Enum, "VerticalAlignment");
static gsi::ClassExt<QTextCharFormat> decl_QTextCharFormat_VerticalAlignment_Enums_as_child (decl_QTextCharFormat_VerticalAlignment_Enums, "QFlags_VerticalAlignment");

}

