
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2018 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextStream.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTextStream>
#include <QIODevice>
#include <QLocale>
#include <QTextCodec>
#include "gsiQt.h"
#include "gsiQtCommon.h"
#include "gsiDeclQtTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextStream
  static short f_QTextStream_read_s(QTextStream *s)
  {
    short v = 0;
    *s >> v;
    return v;
  }

  static unsigned short f_QTextStream_read_us(QTextStream *s)
  {
    unsigned short v = 0;
    *s >> v;
    return v;
  }

  static int f_QTextStream_read_i(QTextStream *s)
  {
    int v = 0;
    *s >> v;
    return v;
  }

  static unsigned int f_QTextStream_read_ui(QTextStream *s)
  {
    unsigned int v = 0;
    *s >> v;
    return v;
  }

  static qulonglong f_QTextStream_read_ull(QTextStream *s)
  {
    qulonglong v = 0;
    *s >> v;
    return v;
  }

  static qlonglong f_QTextStream_read_ll(QTextStream *s)
  {
    qlonglong v = 0;
    *s >> v;
    return v;
  }

  static double f_QTextStream_read_double(QTextStream *s)
  {
    double v = 0;
    *s >> v;
    return v;
  }

  static float f_QTextStream_read_float(QTextStream *s)
  {
    float v = 0;
    *s >> v;
    return v;
  }

  static qt_gsi::Converter<QChar>::target_type f_QTextStream_read_qchar(QTextStream *s)
  {
    QChar v = 0;
    *s >> v;
    return qt_gsi::Converter<QChar>::toc (v);
  }

  static QString f_QTextStream_read_string(QTextStream *s)
  {
    QString v;
    *s >> v;
    return v;
  }

  static qt_gsi::Converter<QByteArray>::target_type f_QTextStream_read_bytearray(QTextStream *s)
  {
    QByteArray v;
    *s >> v;
    return qt_gsi::Converter<QByteArray>::toc (v);
  }

  static QTextStream *f_QTextStream_put_s(QTextStream *s, short v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_us(QTextStream *s, unsigned short v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_i(QTextStream *s, int v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_ui(QTextStream *s, unsigned int v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_ll(QTextStream *s, qlonglong v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_ull(QTextStream *s, qulonglong v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_float(QTextStream *s, float v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_double(QTextStream *s, double v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_qchar(QTextStream *s, const qt_gsi::Converter<class QChar>::target_type v)
  {
    *s << qt_gsi::Converter<class QChar>::toq (v);
    return s;
  }

  static QTextStream *f_QTextStream_put_string(QTextStream *s, const QString &v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_bytearray(QTextStream *s, const qt_gsi::Converter<class QByteArray>::target_type &v)
  {
    *s << qt_gsi::Converter<class QByteArray>::toq (v);
    return s;
  }


// bool QTextStream::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextStream *)cls)->atEnd ());
}


// bool QTextStream::autoDetectUnicode()


static void _init_f_autoDetectUnicode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoDetectUnicode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextStream *)cls)->autoDetectUnicode ());
}


// QTextCodec *QTextStream::codec()


static void _init_f_codec_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCodec * > ();
}

static void _call_f_codec_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextCodec * > ((QTextCodec *)((QTextStream *)cls)->codec ());
}


// QIODevice *QTextStream::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QTextStream *)cls)->device ());
}


// QTextStream::FieldAlignment QTextStream::fieldAlignment()


static void _init_f_fieldAlignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextStream::FieldAlignment>::target_type > ();
}

static void _call_f_fieldAlignment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTextStream::FieldAlignment>::target_type > ((qt_gsi::Converter<QTextStream::FieldAlignment>::target_type)qt_gsi::CppToQtAdaptor<QTextStream::FieldAlignment>(((QTextStream *)cls)->fieldAlignment ()));
}


// int QTextStream::fieldWidth()


static void _init_f_fieldWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_fieldWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextStream *)cls)->fieldWidth ());
}


// void QTextStream::flush()


static void _init_f_flush_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_flush_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->flush ();
}


// bool QTextStream::generateByteOrderMark()


static void _init_f_generateByteOrderMark_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_generateByteOrderMark_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTextStream *)cls)->generateByteOrderMark ());
}


// int QTextStream::integerBase()


static void _init_f_integerBase_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_integerBase_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextStream *)cls)->integerBase ());
}


// QLocale QTextStream::locale()


static void _init_f_locale_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_locale_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLocale > ((QLocale)((QTextStream *)cls)->locale ());
}


// QFlags<QTextStream::NumberFlag> QTextStream::numberFlags()


static void _init_f_numberFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QTextStream::NumberFlag> > ();
}

static void _call_f_numberFlags_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QTextStream::NumberFlag> > ((QFlags<QTextStream::NumberFlag>)((QTextStream *)cls)->numberFlags ());
}


// QChar QTextStream::padChar()


static void _init_f_padChar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_padChar_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QTextStream *)cls)->padChar ()));
}


// qint64 QTextStream::pos()


static void _init_f_pos_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_pos_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QTextStream *)cls)->pos ());
}


// QString QTextStream::read(qint64 maxlen)


static void _init_f_read_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxlen");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_read_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = args.read<qint64 > (heap);
  ret.write<QString > ((QString)((QTextStream *)cls)->read (arg1));
}


// QString QTextStream::readAll()


static void _init_f_readAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_readAll_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QTextStream *)cls)->readAll ());
}


// QString QTextStream::readLine(qint64 maxlen)


static void _init_f_readLine_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxlen", true, "0");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_readLine_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = args ? args.read<qint64 > (heap) : (qint64)(0);
  ret.write<QString > ((QString)((QTextStream *)cls)->readLine (arg1));
}


// bool QTextStream::readLineInto(QString *line, qint64 maxlen)


static void _init_f_readLineInto_2212 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("line");
  decl->add_arg<QString * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("maxlen", true, "0");
  decl->add_arg<qint64 > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_readLineInto_2212 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString *arg1 = args.read<QString * > (heap);
  qint64 arg2 = args ? args.read<qint64 > (heap) : (qint64)(0);
  ret.write<bool > ((bool)((QTextStream *)cls)->readLineInto (arg1, arg2));
}


// QTextStream::RealNumberNotation QTextStream::realNumberNotation()


static void _init_f_realNumberNotation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextStream::RealNumberNotation>::target_type > ();
}

static void _call_f_realNumberNotation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTextStream::RealNumberNotation>::target_type > ((qt_gsi::Converter<QTextStream::RealNumberNotation>::target_type)qt_gsi::CppToQtAdaptor<QTextStream::RealNumberNotation>(((QTextStream *)cls)->realNumberNotation ()));
}


// int QTextStream::realNumberPrecision()


static void _init_f_realNumberPrecision_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_realNumberPrecision_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTextStream *)cls)->realNumberPrecision ());
}


// void QTextStream::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->reset ();
}


// void QTextStream::resetStatus()


static void _init_f_resetStatus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetStatus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->resetStatus ();
}


// bool QTextStream::seek(qint64 pos)


static void _init_f_seek_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_seek_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = args.read<qint64 > (heap);
  ret.write<bool > ((bool)((QTextStream *)cls)->seek (arg1));
}


// void QTextStream::setAutoDetectUnicode(bool enabled)


static void _init_f_setAutoDetectUnicode_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoDetectUnicode_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setAutoDetectUnicode (arg1);
}


// void QTextStream::setCodec(QTextCodec *codec)


static void _init_f_setCodec_1602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codec");
  decl->add_arg<QTextCodec * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCodec_1602 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTextCodec *arg1 = args.read<QTextCodec * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setCodec (arg1);
}


// void QTextStream::setCodec(const char *codecName)


static void _init_f_setCodec_1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codecName");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCodec_1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setCodec (arg1);
}


// void QTextStream::setDevice(QIODevice *device)


static void _init_f_setDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevice_1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = args.read<QIODevice * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setDevice (arg1);
}


// void QTextStream::setFieldAlignment(QTextStream::FieldAlignment alignment)


static void _init_f_setFieldAlignment_3085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QTextStream::FieldAlignment>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFieldAlignment_3085 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextStream::FieldAlignment>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextStream::FieldAlignment>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setFieldAlignment (qt_gsi::QtToCppAdaptor<QTextStream::FieldAlignment>(arg1).cref());
}


// void QTextStream::setFieldWidth(int width)


static void _init_f_setFieldWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFieldWidth_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setFieldWidth (arg1);
}


// void QTextStream::setGenerateByteOrderMark(bool generate)


static void _init_f_setGenerateByteOrderMark_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("generate");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGenerateByteOrderMark_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setGenerateByteOrderMark (arg1);
}


// void QTextStream::setIntegerBase(int base)


static void _init_f_setIntegerBase_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("base");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIntegerBase_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setIntegerBase (arg1);
}


// void QTextStream::setLocale(const QLocale &locale)


static void _init_f_setLocale_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locale");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLocale_1986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QLocale &arg1 = args.read<const QLocale & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setLocale (arg1);
}


// void QTextStream::setNumberFlags(QFlags<QTextStream::NumberFlag> flags)


static void _init_f_setNumberFlags_3365 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<QFlags<QTextStream::NumberFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNumberFlags_3365 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QTextStream::NumberFlag> arg1 = args.read<QFlags<QTextStream::NumberFlag> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setNumberFlags (arg1);
}


// void QTextStream::setPadChar(QChar ch)


static void _init_f_setPadChar_899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ch");
  decl->add_arg<const qt_gsi::Converter<QChar>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPadChar_899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QChar>::target_type & arg1 = args.read<const qt_gsi::Converter<QChar>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setPadChar (qt_gsi::QtToCppAdaptor<QChar>(arg1).cref());
}


// void QTextStream::setRealNumberNotation(QTextStream::RealNumberNotation notation)


static void _init_f_setRealNumberNotation_3523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("notation");
  decl->add_arg<const qt_gsi::Converter<QTextStream::RealNumberNotation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRealNumberNotation_3523 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextStream::RealNumberNotation>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextStream::RealNumberNotation>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setRealNumberNotation (qt_gsi::QtToCppAdaptor<QTextStream::RealNumberNotation>(arg1).cref());
}


// void QTextStream::setRealNumberPrecision(int precision)


static void _init_f_setRealNumberPrecision_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("precision");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRealNumberPrecision_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setRealNumberPrecision (arg1);
}


// void QTextStream::setStatus(QTextStream::Status status)


static void _init_f_setStatus_2318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("status");
  decl->add_arg<const qt_gsi::Converter<QTextStream::Status>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStatus_2318 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTextStream::Status>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextStream::Status>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setStatus (qt_gsi::QtToCppAdaptor<QTextStream::Status>(arg1).cref());
}


// void QTextStream::setString(QString *string, QFlags<QIODevice::OpenModeFlag> openMode)


static void _init_f_setString_4468 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<QString * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("openMode", true, "QIODevice::ReadWrite");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setString_4468 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString *arg1 = args.read<QString * > (heap);
  QFlags<QIODevice::OpenModeFlag> arg2 = args ? args.read<QFlags<QIODevice::OpenModeFlag> > (heap) : (QFlags<QIODevice::OpenModeFlag>)(QIODevice::ReadWrite);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->setString (arg1, arg2);
}


// void QTextStream::skipWhiteSpace()


static void _init_f_skipWhiteSpace_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_skipWhiteSpace_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTextStream *)cls)->skipWhiteSpace ();
}


// QTextStream::Status QTextStream::status()


static void _init_f_status_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextStream::Status>::target_type > ();
}

static void _call_f_status_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTextStream::Status>::target_type > ((qt_gsi::Converter<QTextStream::Status>::target_type)qt_gsi::CppToQtAdaptor<QTextStream::Status>(((QTextStream *)cls)->status ()));
}


// QString *QTextStream::string()


static void _init_f_string_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString * > ();
}

static void _call_f_string_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString * > ((QString *)((QTextStream *)cls)->string ());
}


namespace gsi
{

static gsi::Methods methods_QTextStream () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QTextStream::atEnd()\n", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
  methods += new qt_gsi::GenericMethod (":autoDetectUnicode", "@brief Method bool QTextStream::autoDetectUnicode()\n", true, &_init_f_autoDetectUnicode_c0, &_call_f_autoDetectUnicode_c0);
  methods += new qt_gsi::GenericMethod (":codec", "@brief Method QTextCodec *QTextStream::codec()\n", true, &_init_f_codec_c0, &_call_f_codec_c0);
  methods += new qt_gsi::GenericMethod (":device", "@brief Method QIODevice *QTextStream::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
  methods += new qt_gsi::GenericMethod (":fieldAlignment", "@brief Method QTextStream::FieldAlignment QTextStream::fieldAlignment()\n", true, &_init_f_fieldAlignment_c0, &_call_f_fieldAlignment_c0);
  methods += new qt_gsi::GenericMethod (":fieldWidth", "@brief Method int QTextStream::fieldWidth()\n", true, &_init_f_fieldWidth_c0, &_call_f_fieldWidth_c0);
  methods += new qt_gsi::GenericMethod ("flush", "@brief Method void QTextStream::flush()\n", false, &_init_f_flush_0, &_call_f_flush_0);
  methods += new qt_gsi::GenericMethod (":generateByteOrderMark", "@brief Method bool QTextStream::generateByteOrderMark()\n", true, &_init_f_generateByteOrderMark_c0, &_call_f_generateByteOrderMark_c0);
  methods += new qt_gsi::GenericMethod (":integerBase", "@brief Method int QTextStream::integerBase()\n", true, &_init_f_integerBase_c0, &_call_f_integerBase_c0);
  methods += new qt_gsi::GenericMethod (":locale", "@brief Method QLocale QTextStream::locale()\n", true, &_init_f_locale_c0, &_call_f_locale_c0);
  methods += new qt_gsi::GenericMethod (":numberFlags", "@brief Method QFlags<QTextStream::NumberFlag> QTextStream::numberFlags()\n", true, &_init_f_numberFlags_c0, &_call_f_numberFlags_c0);
  methods += new qt_gsi::GenericMethod (":padChar", "@brief Method QChar QTextStream::padChar()\n", true, &_init_f_padChar_c0, &_call_f_padChar_c0);
  methods += new qt_gsi::GenericMethod ("pos", "@brief Method qint64 QTextStream::pos()\n", true, &_init_f_pos_c0, &_call_f_pos_c0);
  methods += new qt_gsi::GenericMethod ("read", "@brief Method QString QTextStream::read(qint64 maxlen)\n", false, &_init_f_read_986, &_call_f_read_986);
  methods += new qt_gsi::GenericMethod ("readAll", "@brief Method QString QTextStream::readAll()\n", false, &_init_f_readAll_0, &_call_f_readAll_0);
  methods += new qt_gsi::GenericMethod ("readLine", "@brief Method QString QTextStream::readLine(qint64 maxlen)\n", false, &_init_f_readLine_986, &_call_f_readLine_986);
  methods += new qt_gsi::GenericMethod ("readLineInto", "@brief Method bool QTextStream::readLineInto(QString *line, qint64 maxlen)\n", false, &_init_f_readLineInto_2212, &_call_f_readLineInto_2212);
  methods += new qt_gsi::GenericMethod (":realNumberNotation", "@brief Method QTextStream::RealNumberNotation QTextStream::realNumberNotation()\n", true, &_init_f_realNumberNotation_c0, &_call_f_realNumberNotation_c0);
  methods += new qt_gsi::GenericMethod (":realNumberPrecision", "@brief Method int QTextStream::realNumberPrecision()\n", true, &_init_f_realNumberPrecision_c0, &_call_f_realNumberPrecision_c0);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Method void QTextStream::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
  methods += new qt_gsi::GenericMethod ("resetStatus", "@brief Method void QTextStream::resetStatus()\n", false, &_init_f_resetStatus_0, &_call_f_resetStatus_0);
  methods += new qt_gsi::GenericMethod ("seek", "@brief Method bool QTextStream::seek(qint64 pos)\n", false, &_init_f_seek_986, &_call_f_seek_986);
  methods += new qt_gsi::GenericMethod ("setAutoDetectUnicode|autoDetectUnicode=", "@brief Method void QTextStream::setAutoDetectUnicode(bool enabled)\n", false, &_init_f_setAutoDetectUnicode_864, &_call_f_setAutoDetectUnicode_864);
  methods += new qt_gsi::GenericMethod ("setCodec|codec=", "@brief Method void QTextStream::setCodec(QTextCodec *codec)\n", false, &_init_f_setCodec_1602, &_call_f_setCodec_1602);
  methods += new qt_gsi::GenericMethod ("setCodec|codec=", "@brief Method void QTextStream::setCodec(const char *codecName)\n", false, &_init_f_setCodec_1731, &_call_f_setCodec_1731);
  methods += new qt_gsi::GenericMethod ("setDevice|device=", "@brief Method void QTextStream::setDevice(QIODevice *device)\n", false, &_init_f_setDevice_1447, &_call_f_setDevice_1447);
  methods += new qt_gsi::GenericMethod ("setFieldAlignment|fieldAlignment=", "@brief Method void QTextStream::setFieldAlignment(QTextStream::FieldAlignment alignment)\n", false, &_init_f_setFieldAlignment_3085, &_call_f_setFieldAlignment_3085);
  methods += new qt_gsi::GenericMethod ("setFieldWidth|fieldWidth=", "@brief Method void QTextStream::setFieldWidth(int width)\n", false, &_init_f_setFieldWidth_767, &_call_f_setFieldWidth_767);
  methods += new qt_gsi::GenericMethod ("setGenerateByteOrderMark|generateByteOrderMark=", "@brief Method void QTextStream::setGenerateByteOrderMark(bool generate)\n", false, &_init_f_setGenerateByteOrderMark_864, &_call_f_setGenerateByteOrderMark_864);
  methods += new qt_gsi::GenericMethod ("setIntegerBase|integerBase=", "@brief Method void QTextStream::setIntegerBase(int base)\n", false, &_init_f_setIntegerBase_767, &_call_f_setIntegerBase_767);
  methods += new qt_gsi::GenericMethod ("setLocale|locale=", "@brief Method void QTextStream::setLocale(const QLocale &locale)\n", false, &_init_f_setLocale_1986, &_call_f_setLocale_1986);
  methods += new qt_gsi::GenericMethod ("setNumberFlags|numberFlags=", "@brief Method void QTextStream::setNumberFlags(QFlags<QTextStream::NumberFlag> flags)\n", false, &_init_f_setNumberFlags_3365, &_call_f_setNumberFlags_3365);
  methods += new qt_gsi::GenericMethod ("setPadChar|padChar=", "@brief Method void QTextStream::setPadChar(QChar ch)\n", false, &_init_f_setPadChar_899, &_call_f_setPadChar_899);
  methods += new qt_gsi::GenericMethod ("setRealNumberNotation|realNumberNotation=", "@brief Method void QTextStream::setRealNumberNotation(QTextStream::RealNumberNotation notation)\n", false, &_init_f_setRealNumberNotation_3523, &_call_f_setRealNumberNotation_3523);
  methods += new qt_gsi::GenericMethod ("setRealNumberPrecision|realNumberPrecision=", "@brief Method void QTextStream::setRealNumberPrecision(int precision)\n", false, &_init_f_setRealNumberPrecision_767, &_call_f_setRealNumberPrecision_767);
  methods += new qt_gsi::GenericMethod ("setStatus|status=", "@brief Method void QTextStream::setStatus(QTextStream::Status status)\n", false, &_init_f_setStatus_2318, &_call_f_setStatus_2318);
  methods += new qt_gsi::GenericMethod ("setString", "@brief Method void QTextStream::setString(QString *string, QFlags<QIODevice::OpenModeFlag> openMode)\n", false, &_init_f_setString_4468, &_call_f_setString_4468);
  methods += new qt_gsi::GenericMethod ("skipWhiteSpace", "@brief Method void QTextStream::skipWhiteSpace()\n", false, &_init_f_skipWhiteSpace_0, &_call_f_skipWhiteSpace_0);
  methods += new qt_gsi::GenericMethod (":status", "@brief Method QTextStream::Status QTextStream::status()\n", true, &_init_f_status_c0, &_call_f_status_c0);
  methods += new qt_gsi::GenericMethod (":string", "@brief Method QString *QTextStream::string()\n", true, &_init_f_string_c0, &_call_f_string_c0);
  return methods;
}

gsi::Class<QTextStream> decl_QTextStream ("QTextStream_Native",
  gsi::method_ext("read_s", &f_QTextStream_read_s, "@brief Non-ambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_us", &f_QTextStream_read_us, "@brief Non-ambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_i", &f_QTextStream_read_i, "@brief Non-ambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ui", &f_QTextStream_read_ui, "@brief Non-ambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ull", &f_QTextStream_read_ull, "@brief Non-ambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ll", &f_QTextStream_read_ll, "@brief Non-ambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_d", &f_QTextStream_read_double, "@brief Non-ambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_f", &f_QTextStream_read_float, "@brief Non-ambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_qc", &f_QTextStream_read_qchar, "@brief Non-ambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_s", &f_QTextStream_read_string, "@brief Non-ambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ba", &f_QTextStream_read_bytearray, "@brief Non-ambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("put_s", &f_QTextStream_put_s, "@brief Non-ambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_us", &f_QTextStream_put_us, "@brief Non-ambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_i", &f_QTextStream_put_i, "@brief Non-ambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ui", &f_QTextStream_put_ui, "@brief Non-ambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ull", &f_QTextStream_put_ull, "@brief Non-ambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ll", &f_QTextStream_put_ll, "@brief Non-ambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_d", &f_QTextStream_put_double, "@brief Non-ambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_f", &f_QTextStream_put_float, "@brief Non-ambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_qc", &f_QTextStream_put_qchar, "@brief Non-ambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_s", &f_QTextStream_put_string, "@brief Non-ambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ba", &f_QTextStream_put_bytearray, "@brief Non-ambiguous adaptation of the corresponding operator<<") 
+
  methods_QTextStream (),
  "@hide\n@alias QTextStream");

GSIQT_PUBLIC gsi::Class<QTextStream> &qtdecl_QTextStream () { return decl_QTextStream; }

}


class QTextStream_Adaptor : public QTextStream, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTextStream_Adaptor();

  //  [adaptor ctor] QTextStream::QTextStream()
  QTextStream_Adaptor() : QTextStream()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextStream::QTextStream(QIODevice *device)
  QTextStream_Adaptor(QIODevice *device) : QTextStream(device)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextStream::QTextStream(QString *string, QFlags<QIODevice::OpenModeFlag> openMode)
  QTextStream_Adaptor(QString *string) : QTextStream(string)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextStream::QTextStream(QString *string, QFlags<QIODevice::OpenModeFlag> openMode)
  QTextStream_Adaptor(QString *string, QFlags<QIODevice::OpenModeFlag> openMode) : QTextStream(string, openMode)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  
};

QTextStream_Adaptor::~QTextStream_Adaptor() { }

//  Constructor QTextStream::QTextStream() (adaptor class)

static void _init_ctor_QTextStream_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTextStream_Adaptor> ();
}

static void _call_ctor_QTextStream_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTextStream_Adaptor *> (new QTextStream_Adaptor ());
}


//  Constructor QTextStream::QTextStream(QIODevice *device) (adaptor class)

static void _init_ctor_QTextStream_Adaptor_1447 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return_new<QTextStream_Adaptor> ();
}

static void _call_ctor_QTextStream_Adaptor_1447 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = args.read<QIODevice * > (heap);
  ret.write<QTextStream_Adaptor *> (new QTextStream_Adaptor (arg1));
}


//  Constructor QTextStream::QTextStream(QString *string, QFlags<QIODevice::OpenModeFlag> openMode) (adaptor class)

static void _init_ctor_QTextStream_Adaptor_4468 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<QString * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("openMode", true, "QIODevice::ReadWrite");
  decl->add_arg<QFlags<QIODevice::OpenModeFlag> > (argspec_1);
  decl->set_return_new<QTextStream_Adaptor> ();
}

static void _call_ctor_QTextStream_Adaptor_4468 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QString *arg1 = args.read<QString * > (heap);
  QFlags<QIODevice::OpenModeFlag> arg2 = args ? args.read<QFlags<QIODevice::OpenModeFlag> > (heap) : (QFlags<QIODevice::OpenModeFlag>)(QIODevice::ReadWrite);
  ret.write<QTextStream_Adaptor *> (new QTextStream_Adaptor (arg1, arg2));
}


namespace gsi
{

gsi::Class<QTextStream> &qtdecl_QTextStream ();

static gsi::Methods methods_QTextStream_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextStream::QTextStream()\nThis method creates an object of class QTextStream.", &_init_ctor_QTextStream_Adaptor_0, &_call_ctor_QTextStream_Adaptor_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextStream::QTextStream(QIODevice *device)\nThis method creates an object of class QTextStream.", &_init_ctor_QTextStream_Adaptor_1447, &_call_ctor_QTextStream_Adaptor_1447);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextStream::QTextStream(QString *string, QFlags<QIODevice::OpenModeFlag> openMode)\nThis method creates an object of class QTextStream.", &_init_ctor_QTextStream_Adaptor_4468, &_call_ctor_QTextStream_Adaptor_4468);
  return methods;
}

gsi::Class<QTextStream_Adaptor> decl_QTextStream_Adaptor (qtdecl_QTextStream (), "QTextStream",
  methods_QTextStream_Adaptor (),
  "@qt\n@brief Binding of QTextStream");

}


//  Implementation of the enum wrapper class for QTextStream::FieldAlignment
namespace qt_gsi
{

static gsi::Enum<QTextStream::FieldAlignment> decl_QTextStream_FieldAlignment_Enum ("QTextStream_FieldAlignment",
    gsi::enum_const ("AlignLeft", QTextStream::AlignLeft, "@brief Enum constant QTextStream::AlignLeft") +
    gsi::enum_const ("AlignRight", QTextStream::AlignRight, "@brief Enum constant QTextStream::AlignRight") +
    gsi::enum_const ("AlignCenter", QTextStream::AlignCenter, "@brief Enum constant QTextStream::AlignCenter") +
    gsi::enum_const ("AlignAccountingStyle", QTextStream::AlignAccountingStyle, "@brief Enum constant QTextStream::AlignAccountingStyle"),
  "@qt\n@brief This class represents the QTextStream::FieldAlignment enum");

static gsi::QFlagsClass<QTextStream::FieldAlignment > decl_QTextStream_FieldAlignment_Enums ("QTextStream_QFlags_FieldAlignment",
  "@qt\n@brief This class represents the QFlags<QTextStream::FieldAlignment> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextStream> inject_QTextStream_FieldAlignment_Enum_in_parent (decl_QTextStream_FieldAlignment_Enum.defs ());
static gsi::ClassExt<QTextStream> decl_QTextStream_FieldAlignment_Enum_as_child (decl_QTextStream_FieldAlignment_Enum, "FieldAlignment");
static gsi::ClassExt<QTextStream> decl_QTextStream_FieldAlignment_Enums_as_child (decl_QTextStream_FieldAlignment_Enums, "QFlags_FieldAlignment");

}


//  Implementation of the enum wrapper class for QTextStream::NumberFlag
namespace qt_gsi
{

static gsi::Enum<QTextStream::NumberFlag> decl_QTextStream_NumberFlag_Enum ("QTextStream_NumberFlag",
    gsi::enum_const ("ShowBase", QTextStream::ShowBase, "@brief Enum constant QTextStream::ShowBase") +
    gsi::enum_const ("ForcePoint", QTextStream::ForcePoint, "@brief Enum constant QTextStream::ForcePoint") +
    gsi::enum_const ("ForceSign", QTextStream::ForceSign, "@brief Enum constant QTextStream::ForceSign") +
    gsi::enum_const ("UppercaseBase", QTextStream::UppercaseBase, "@brief Enum constant QTextStream::UppercaseBase") +
    gsi::enum_const ("UppercaseDigits", QTextStream::UppercaseDigits, "@brief Enum constant QTextStream::UppercaseDigits"),
  "@qt\n@brief This class represents the QTextStream::NumberFlag enum");

static gsi::QFlagsClass<QTextStream::NumberFlag > decl_QTextStream_NumberFlag_Enums ("QTextStream_QFlags_NumberFlag",
  "@qt\n@brief This class represents the QFlags<QTextStream::NumberFlag> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextStream> inject_QTextStream_NumberFlag_Enum_in_parent (decl_QTextStream_NumberFlag_Enum.defs ());
static gsi::ClassExt<QTextStream> decl_QTextStream_NumberFlag_Enum_as_child (decl_QTextStream_NumberFlag_Enum, "NumberFlag");
static gsi::ClassExt<QTextStream> decl_QTextStream_NumberFlag_Enums_as_child (decl_QTextStream_NumberFlag_Enums, "QFlags_NumberFlag");

}


//  Implementation of the enum wrapper class for QTextStream::RealNumberNotation
namespace qt_gsi
{

static gsi::Enum<QTextStream::RealNumberNotation> decl_QTextStream_RealNumberNotation_Enum ("QTextStream_RealNumberNotation",
    gsi::enum_const ("SmartNotation", QTextStream::SmartNotation, "@brief Enum constant QTextStream::SmartNotation") +
    gsi::enum_const ("FixedNotation", QTextStream::FixedNotation, "@brief Enum constant QTextStream::FixedNotation") +
    gsi::enum_const ("ScientificNotation", QTextStream::ScientificNotation, "@brief Enum constant QTextStream::ScientificNotation"),
  "@qt\n@brief This class represents the QTextStream::RealNumberNotation enum");

static gsi::QFlagsClass<QTextStream::RealNumberNotation > decl_QTextStream_RealNumberNotation_Enums ("QTextStream_QFlags_RealNumberNotation",
  "@qt\n@brief This class represents the QFlags<QTextStream::RealNumberNotation> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextStream> inject_QTextStream_RealNumberNotation_Enum_in_parent (decl_QTextStream_RealNumberNotation_Enum.defs ());
static gsi::ClassExt<QTextStream> decl_QTextStream_RealNumberNotation_Enum_as_child (decl_QTextStream_RealNumberNotation_Enum, "RealNumberNotation");
static gsi::ClassExt<QTextStream> decl_QTextStream_RealNumberNotation_Enums_as_child (decl_QTextStream_RealNumberNotation_Enums, "QFlags_RealNumberNotation");

}


//  Implementation of the enum wrapper class for QTextStream::Status
namespace qt_gsi
{

static gsi::Enum<QTextStream::Status> decl_QTextStream_Status_Enum ("QTextStream_Status",
    gsi::enum_const ("Ok", QTextStream::Ok, "@brief Enum constant QTextStream::Ok") +
    gsi::enum_const ("ReadPastEnd", QTextStream::ReadPastEnd, "@brief Enum constant QTextStream::ReadPastEnd") +
    gsi::enum_const ("ReadCorruptData", QTextStream::ReadCorruptData, "@brief Enum constant QTextStream::ReadCorruptData") +
    gsi::enum_const ("WriteFailed", QTextStream::WriteFailed, "@brief Enum constant QTextStream::WriteFailed"),
  "@qt\n@brief This class represents the QTextStream::Status enum");

static gsi::QFlagsClass<QTextStream::Status > decl_QTextStream_Status_Enums ("QTextStream_QFlags_Status",
  "@qt\n@brief This class represents the QFlags<QTextStream::Status> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextStream> inject_QTextStream_Status_Enum_in_parent (decl_QTextStream_Status_Enum.defs ());
static gsi::ClassExt<QTextStream> decl_QTextStream_Status_Enum_as_child (decl_QTextStream_Status_Enum, "Status");
static gsi::ClassExt<QTextStream> decl_QTextStream_Status_Enums_as_child (decl_QTextStream_Status_Enums, "QFlags_Status");

}

