<!--- Title/subject of the issue created should be like the line below: -->
<!--- [Update] plugin.video.youtube -->

### Add-on details:
<!--- Provide some details about your add-on. -->
- **General**
  - Add-on name: 
  - Add-on ID:
  - Version number:
  - Kodi/repository version:
<!--- Provide the location from where we can get your add-on code. -->
<!--- This can either be a zip file or github reposity for which you also need to provide a revision or release tag -->
- **Code location**
  - URL:
  - Revision/tag: 
  - Branch:

<!--- EXAMPLE HOW TO FILL ADD-ON DETAILS:
- Add-on name: Global Search
  - Add-on ID: script.globalsearch
  - Version number: 8.0.0
  - Kodi/repository version: Krypton
- URL: https://github.com/ronie/script.globalsearch
  - Revision/tag: e3d61d
  - Branch: master
-->

### Description of changes:
<!--- Provide a short summary of submitted add-on in case it's a new addition. -->
<!--- If it's plugin update only highlight biggest changes if needed. -->
<!--- Make sure you follow the checklist below before finalizing your pull-request. -->


### Checklist:
<!--- Go over all the following points, and put an `x` in all the boxes that apply like this: [X] -->
<!--- If you're unsure about any of these, don't hesitate to ask. We're here to help! -->
- [ ] My code follows the [add-on rules](http://kodi.wiki/view/Add-on_rules) and [piracy stance](http://kodi.wiki/view/Official:Forum_rules#Piracy_Policy) of this project. 
- [ ] I have read the [CONTRIBUTING](https://github.com/xbmc/repo-resources/blob/master/CONTRIBUTING.md) document
- [ ] Each add-on submission should be a single commit with using the following style: [plugin.video.foo] v1.0.0

Additional information :
- Submitting your add-on to this specific branch makes it available to any Kodi version equal or higher than the branch name with the applicable Kodi dependencies limits.
- [add-on development](http://kodi.wiki/view/Add-on_development) wiki page.
- Kodi [pydocs](http://kodi.wiki/view/PyDocs) provide information about the Python API
- [PEP8](https://www.python.org/dev/peps/pep-0008/) codingstyle which is considered best practice but not mandatory.
- This add-on repository has automated code guideline check which could help you improve your coding. You can find the results of these check at [Codacy](https://www.codacy.com/app/Kodi/repo-plugins/dashboard). You can create your own account as well to continuously monitor your python coding before submitting to repo.
- Development questions can be asked in the [add-on development](http://forum.kodi.tv/forumdisplay.php?fid=26) section on the Kodi forum.
