# Change log

## Release 1.9.1
* Fixed: MacOS package damaged and not starting. ([#653](https://github.com/ksnip/ksnip/issues/653))
* Fixed: Deb CI build is frequently failing due to docker image pull limit. ([#655](https://github.com/ksnip/ksnip/issues/655))
* Fixed: Dropped temporary images appear in the open recent menu. ([#613](https://github.com/ksnip/ksnip/issues/613))
* Fixed: Resizing window to match content doesn't work on opening first image/screenshot. ([#664](https://github.com/ksnip/ksnip/issues/664))
* Fixed: HiDPI issue with multiple screen on Windows. ([#668](https://github.com/ksnip/ksnip/issues/668))
* Fixed: Cursor not captured in rectangle capture. ([#670](https://github.com/ksnip/ksnip/issues/670))
* Changed: Migrate CI from Travic-CI to GitHub Action. ([#676](https://github.com/ksnip/ksnip/issues/676))
* Fixed kImageAnnotator: Crashes on destruction. ([#242](https://github.com/ksnip/kImageAnnotator/issues/242))
* Fixed kImageAnnotator: Memory leaks caught by ASAN. ([#243](https://github.com/ksnip/kImageAnnotator/issues/243))
* Changed kImageAnnotator: Use system font provided by QGuiApplication as default for text tool. ([#247](https://github.com/ksnip/kImageAnnotator/issues/247))

## Release 1.9.0
* New: Add option to select the default action for tray icon left click. ([#502](https://github.com/ksnip/ksnip/issues/502))
* New: Open/Paste from clipboard via tray icon. ([#520](https://github.com/ksnip/ksnip/issues/520))
* New: Show/hide toolbar and annotation settings with TAB. ([#476](https://github.com/ksnip/ksnip/issues/476))
* New: Add setting for auto hiding toolbar and annotator settings. ([#527](https://github.com/ksnip/ksnip/issues/527))
* New: Allow setting transparency of not selected snipping area region. ([#517](https://github.com/ksnip/ksnip/issues/517))
* New: Resize selected rect area with arrow keys. ([#515](https://github.com/ksnip/ksnip/issues/515))
* New: Copy a screenshot to clipboard as data URI. ([#474](https://github.com/ksnip/ksnip/issues/474))
* New: Allow disabling tray icon notifications. ([#561](https://github.com/ksnip/ksnip/issues/561))
* New: Provide option to open recent files. ([#272](https://github.com/ksnip/ksnip/issues/272))
* New: Allow disabling auto resizing after first capture. ([#551](https://github.com/ksnip/ksnip/issues/551))
* New: Drag and Drop from ksnip to other applications. ([#377](https://github.com/ksnip/ksnip/issues/377))
* New: Add support for KDE Plasma notification service. ([#592](https://github.com/ksnip/ksnip/issues/592))
* New: ksnip as MSI Package for window. ([#546](https://github.com/ksnip/ksnip/issues/546))
* New: User-defined actions for taking screenshot and post-processing. ([#369](https://github.com/ksnip/ksnip/issues/369))
* New: Add 'hide main window' option to actions. ([#636](https://github.com/ksnip/ksnip/issues/636))
* New: Discord Invite in application. ([#638](https://github.com/ksnip/ksnip/issues/638))
* New kImageAnnotator: Add function for loading translations. ([#173](https://github.com/ksnip/kImageAnnotator/issues/173))
* New kImageAnnotator: Add a new tool for creating resizable movable duplicates of regions. ([#131](https://github.com/ksnip/kImageAnnotator/issues/131))
* New kImageAnnotator: Add support for hiding annotation settings panel. ([#182](https://github.com/ksnip/kImageAnnotator/issues/182))
* New kImageAnnotator: Add config option for numbering tool to only set next number. ([#42](https://github.com/ksnip/kImageAnnotator/issues/42))
* New kImageAnnotator: Allow manually changing canvas size. ([#92](https://github.com/ksnip/kImageAnnotator/issues/92))
* New kImageAnnotator: Canvas background color configurable. ([#91](https://github.com/ksnip/kImageAnnotator/issues/91))
* New kImageAnnotator: Zoom in and out with keyboard shortcuts. ([#192](https://github.com/ksnip/kImageAnnotator/issues/192))
* New kImageAnnotator: Zoom in and out via buttons from UI. ([#197](https://github.com/ksnip/kImageAnnotator/issues/197))
* New kImageAnnotator: Add reset zoom keyboard shortcut with tooltip. ([#209](https://github.com/ksnip/kImageAnnotator/issues/209))
* New kImageAnnotator: Add keyboard shortcut support for text tool. ([#183](https://github.com/ksnip/kImageAnnotator/issues/183))
* New kImageAnnotator: Allow rotating background image. ([#199](https://github.com/ksnip/kImageAnnotator/issues/199))
* New kImageAnnotator: Allow flipping background image horizontally and vertically. ([#221](https://github.com/ksnip/kImageAnnotator/issues/221))
* New kImageAnnotator: Configurable UI with dockable settings widgets. ([#102](https://github.com/ksnip/kImageAnnotator/issues/102))
* New kImageAnnotator: Add invert color image effect. ([#228](https://github.com/ksnip/kImageAnnotator/issues/228))
* New kImageAnnotator: Allow disabling item shadow per item from UI. ([#223](https://github.com/ksnip/kImageAnnotator/issues/223))
* New kImageAnnotator: Add a font selection to UI. ([#130](https://github.com/ksnip/kImageAnnotator/issues/130))
* New kImageAnnotator: Add zoom in/out capability to crop view. ([#212](https://github.com/ksnip/kImageAnnotator/issues/212))
* New kImageAnnotator: Allow to zoom in modify canvas view. ([#229](https://github.com/ksnip/kImageAnnotator/issues/229))
* New kImageAnnotator: Select item after drawing it and allow changing settings. ([#230](https://github.com/ksnip/kImageAnnotator/issues/230))
* Changed kImageAnnotator: Change drop shadow to cover all sites. ([#202](https://github.com/ksnip/kImageAnnotator/issues/202))
* Fixed: Not possible to change adorner color. ([#601](https://github.com/ksnip/ksnip/issues/601))
* Fixed: ksnip --version output printed to stderr. ([#617](https://github.com/ksnip/ksnip/issues/617))
* Fixed kImageAnnotator: Deleting item outside image doesn't decrease canvas size. ([#164](https://github.com/ksnip/kImageAnnotator/issues/164))
* Fixed kImageAnnotator: Duplicate region of grayscale image has color. ([#214](https://github.com/ksnip/kImageAnnotator/issues/214))
* Fixed kImageAnnotator: Marker shows fill and width config when modifying existing item. ([#225](https://github.com/ksnip/kImageAnnotator/issues/225))
* Fixed kImageAnnotator: Highlighter/Marker washed out color and overlapping. ([#227](https://github.com/ksnip/kImageAnnotator/issues/227))
* Fixed kImageAnnotator: Popup menus shown outside screen. ([#226](https://github.com/ksnip/kImageAnnotator/issues/226))
* Fixed kImageAnnotator: Not possible to enter value in the width tool. ([#233](https://github.com/ksnip/kImageAnnotator/issues/233))
* Fixed kImageAnnotator: Obfuscation tool shows fonts settings when switching from tool with font. ([#231](https://github.com/ksnip/kImageAnnotator/issues/231))
* Fixed kImageAnnotator: Annotation tools are not displayed if application starts with docks hidden. ([#237](https://github.com/ksnip/kImageAnnotator/issues/237))
* Fixed kImageAnnotator: Vertical scrollbar missing after using Paste embedded and moving the image. ([#232](https://github.com/ksnip/kImageAnnotator/issues/232))
* Fixed kImageAnnotator: Not possible to disable tool automatically deselected after drawn. ([#238](https://github.com/ksnip/kImageAnnotator/issues/238))
* Fixed kImageAnnotator: Annotation tool shortcuts do not work if the panel is hidden. ([#239](https://github.com/ksnip/kImageAnnotator/issues/239))

## Release 1.8.2
* Fixed: Add missing includes to build on UNIX. ([#581](https://github.com/ksnip/ksnip/issues/581))
* Fixed: Ksnip starts minimized. ([#593](https://github.com/ksnip/ksnip/issues/593))
* Fixed: Main window still show after screenshot when corresponding option disabled. ([#596](https://github.com/ksnip/ksnip/issues/596))
* Fixed: Cancel screenshot shows main window when window was hidden. ([#607](https://github.com/ksnip/ksnip/issues/607))
* Fixed: HiDPI scaling not handled correctly under windows. ([#590](https://github.com/ksnip/ksnip/issues/590))
* Fixed: Close button hidden after taking screenshot under kwin. ([#588](https://github.com/ksnip/ksnip/issues/588))
* Fixed kImageAnnotator: Fetching image from annotator with HiDPI enabled pixelates image. ([#218](https://github.com/ksnip/kImageAnnotator/issues/218))
* Fixed kImageAnnotator: Keep aspect ratio only work when pressing CTRL before moving resize handle. ([#219](https://github.com/ksnip/kImageAnnotator/issues/219))

## Release 1.8.1
* Changed: Allow changing adorner color for rect area selection. ([#519](https://github.com/ksnip/ksnip/issues/519))
* Changed: Notarize ksnip for macOS. ([#402](https://github.com/ksnip/ksnip/issues/402))
* Changed: Default font for numbering tool change to Arial. ([#200](https://github.com/ksnip/kImageAnnotator/issues/200))
* Changed kImageAnnotator: Horizontally align text inside spin box. ([#203](https://github.com/ksnip/kImageAnnotator/issues/203))
* Changed kImageAnnotator: Change zoom with mouse wheel to CTRL+Wheel. ([#210](https://github.com/ksnip/kImageAnnotator/issues/210))
* Fixed: If file selection is cancelled during ksnip's file open dialog via tray icon, ksnip closes. ([#503](https://github.com/ksnip/ksnip/issues/503))
* Fixed: Cancel on Quit not work when editor is hidden. ([#342](https://github.com/ksnip/ksnip/issues/342))
* Fixed: Canceling rect area selection activates main window. ([#521](https://github.com/ksnip/ksnip/issues/521))
* Fixed: Enter key doesn't finishes resizing. ([#523](https://github.com/ksnip/ksnip/issues/523))
* Fixed: Missing version number in mac binaries. ([#401](https://github.com/ksnip/ksnip/issues/401))
* Fixed: Canceling save dialog show the option save path in the header. ([#545](https://github.com/ksnip/ksnip/issues/545))
* Fixed: Save-as Window does not get focus when using snap. ([#543](https://github.com/ksnip/ksnip/issues/543))
* Fixed: Editor can not be shown again after click close icon. ([#400](https://github.com/ksnip/ksnip/issues/400))
* Fixed: Icons and text boxes not correctly scaled under gnome with hdpi. ([#549](https://github.com/ksnip/ksnip/issues/549))
* Fixed: Window captures include non-transparent border of background on Gnome. ([#460](https://github.com/ksnip/ksnip/issues/460))
* Fixed: Annotating hidpi image downscales the result after being saved. ([#172](https://github.com/ksnip/kImageAnnotator/issues/172))
* Fixed kImageAnnotator: Brazilian Portuguese translation not loaded. ([#176](https://github.com/ksnip/kImageAnnotator/issues/176))
* Fixed kImageAnnotator: error: control reaches end of non-void function. ([#177](https://github.com/ksnip/kImageAnnotator/issues/177))
* Fixed kImageAnnotator: Cursor in Text tool have too bad visibility. ([#184](https://github.com/ksnip/kImageAnnotator/issues/184))
* Fixed kImageAnnotator: bumped SONAME without name change. ([#185](https://github.com/ksnip/kImageAnnotator/issues/185))
* Fixed kImageAnnotator: Entering multiple characters at once moves the text cursor only for one character. ([#186](https://github.com/ksnip/kImageAnnotator/issues/186))
* Fixed kImageAnnotator: Activating context menu while drawing item leaves item in error state. ([#196](https://github.com/ksnip/kImageAnnotator/issues/196))
* Fixed kImageAnnotator: Icons not scaled on gnome with hdpi enabled. ([#201](https://github.com/ksnip/kImageAnnotator/issues/201))
* Fixed kImageAnnotator: Text/Number Pointer and Text/Number Arrow don't inherit Text/Number Font in Settings. ([#208](https://github.com/ksnip/kImageAnnotator/issues/208))

## Release 1.8.0
* New: Pin screenshots in frameless windows that stay in foreground. ([#365](https://github.com/ksnip/ksnip/issues/365))
* New: Support for unit tests. ([#80](https://github.com/ksnip/ksnip/issues/80))
* New: Add brew cask package for ksnip. ([#394](https://github.com/ksnip/ksnip/issues/394))
* New: Allow setting image quality when saving images. ([#382](https://github.com/ksnip/ksnip/issues/382))
* New: Add support for cross-platform wayland screenshots using xdg-desktop-portal. ([#243](https://github.com/ksnip/ksnip/issues/243))
* New: Add save and save as tab contextMenu items. ([#332](https://github.com/ksnip/ksnip/issues/332))
* New: Add open directory context menu item on capture tabs. ([#339](https://github.com/ksnip/ksnip/issues/339))
* New: Add copy path to clipboard context menu item on capture tabs. ([#331](https://github.com/ksnip/ksnip/issues/331))
* New: Add option to delete saved images. ([#378](https://github.com/ksnip/ksnip/issues/378))
* New: Add support for loading image from stdin. ([#414](https://github.com/ksnip/ksnip/issues/414))
* New: Add screenshot options as application actions to desktop file. ([#450](https://github.com/ksnip/ksnip/issues/450))
* New: Allow renaming existing images. ([#438](https://github.com/ksnip/ksnip/issues/438))
* New: Make hiding main window during screenshot optional. ([#386](https://github.com/ksnip/ksnip/issues/386))
* New: Open several files at once in tabs. ([#355](https://github.com/ksnip/ksnip/issues/355))
* New: Allow modifying selected rectangle before making screenshot. ([#197](https://github.com/ksnip/ksnip/issues/197))
* New: Option to keep main window hidden after a taking screenshot. ([#409](https://github.com/ksnip/ksnip/issues/409))
* New kImageAnnotator: Add Pixelate image area tool. ([#140](https://github.com/ksnip/kImageAnnotator/issues/140))
* New kImageAnnotator: Zoom in and out. ([#123](https://github.com/ksnip/kImageAnnotator/issues/123))
* New kImageAnnotator: Add interface for adding custom tab context menu actions. ([#96](https://github.com/ksnip/kImageAnnotator/issues/96))
* New kImageAnnotator: Add drop shadow to captured images. ([#133](https://github.com/ksnip/kImageAnnotator/issues/133))
* New kImageAnnotator: Add grayscale image effect. ([#151](https://github.com/ksnip/kImageAnnotator/issues/151))
* New kImageAnnotator: Add numeric pointer with arrow annotation item. ([#152](https://github.com/ksnip/kImageAnnotator/issues/152))
* New kImageAnnotator: Add text pointer annotation item. ([#154](https://github.com/ksnip/kImageAnnotator/issues/154))
* New kImageAnnotator: Add text pointer with arrow annotation item. ([#153](https://github.com/ksnip/kImageAnnotator/issues/153))
* New kImageAnnotator: Add option to automatically switching to select tool after drawing item. ([#161](https://github.com/ksnip/kImageAnnotator/issues/161))
* New kImageAnnotator: Edit Text box with double click. ([#60](https://github.com/ksnip/kImageAnnotator/issues/60))
* New kImageAnnotator: Resize elements while keeping aspect ratio. ([#170](https://github.com/ksnip/kImageAnnotator/issues/170))
* Changed: Show all Screenshot options in System Tray. ([#404](https://github.com/ksnip/ksnip/issues/404))
* Changed: Upload multiple stickers at once. ([#427](https://github.com/ksnip/ksnip/issues/427))
* Changed: Follow pattern for monochromatic systray icon. ([#352](https://github.com/ksnip/ksnip/issues/352))
* Changed: Pin window shows default cursor when mouse over it. ([#465](https://github.com/ksnip/ksnip/issues/465))
* Changed: Cancel snipping area if no selection made after 60 sec. ([#475](https://github.com/ksnip/ksnip/issues/475))
* Changed: Allow removing imgur account. ([#366](https://github.com/ksnip/ksnip/issues/366))
* Changed kImageAnnotator: Draw point when clicking and releasing without moving cursor. ([#136](https://github.com/ksnip/kImageAnnotator/issues/136))
* Changed kImageAnnotator: Zoom out less than 100%. ([#150](https://github.com/ksnip/kImageAnnotator/issues/150))
* Changed kImageAnnotator: Change to select tool after adding new annotation item. ([#155](https://github.com/ksnip/kImageAnnotator/issues/155))
* Changed kImageAnnotator: Move current zoom text to left side config panel. ([#157](https://github.com/ksnip/kImageAnnotator/issues/157))
* Fixed: Snap crashing when trying to take screenshot under Wayland. ([#389](https://github.com/ksnip/ksnip/issues/389))
* Fixed: zh_Hans translation won't load. ([#429](https://github.com/ksnip/ksnip/issues/429))
* Fixed: Ksnip only saves the upper right part of the screenshot with HiDPI. ([#439](https://github.com/ksnip/ksnip/issues/439))
* Fixed: Main window not resized with new captures. ([#446](https://github.com/ksnip/ksnip/issues/446))
* Fixed: Brazilian Portuguese translation not loaded. ([#493](https://github.com/ksnip/ksnip/issues/493))
* Fixed kImageAnnotator: Blur radius not updated when changing current items settings. ([#142](https://github.com/ksnip/kImageAnnotator/issues/142))
* Fixed kImageAnnotator: Text tool opens many unix sockets. ([#144](https://github.com/ksnip/kImageAnnotator/issues/144))
* Fixed kImageAnnotator: Text No Border and No Fill shows shadow beneath text. ([#148](https://github.com/ksnip/kImageAnnotator/issues/148))
* Fixed kImageAnnotator: Item properties remain displayed after item is removed or deselected. ([#168](https://github.com/ksnip/kImageAnnotator/issues/168))
* Fixed kImageAnnotator: Changing text box through editing text doesn't update resize handles. ([#171](https://github.com/ksnip/kImageAnnotator/issues/171))
* Fixed kColorPicker: Border around colors is not centered. ([#6](https://github.com/ksnip/kColorPicker/issues/6))

## Release 1.7.3
* New: Provide ksnip flatpak. ([#127](https://github.com/ksnip/ksnip/issues/127))
* Changed: Install svg icon file in hicolor theme dir instead of usr/share/pixmaps/. ([#297](https://github.com/ksnip/ksnip/issues/297))

## Release 1.7.2
* Changed: Stop upload script when process writes to stderr. ([#383](https://github.com/ksnip/ksnip/issues/383))
* Changed: Upload script uses regex to select output for clipboard. ([#384](https://github.com/ksnip/ksnip/issues/384))
* Fixed: Ksnip becomes unresponsive when file dropped into it. ([#373](https://github.com/ksnip/ksnip/issues/373))
* Fixed: Ksnip window always visible on screenshots on Gnome Wayland. ([#375](https://github.com/ksnip/ksnip/issues/375))
* Fixed: Selecting path in Snap via file-chooser sets home directory to /run/user/1000. ([#388](https://github.com/ksnip/ksnip/issues/388))
* Fixed: Snap not able to run custom upload script. ([#380](https://github.com/ksnip/ksnip/issues/380))
* Fixed: kImageAnnotator: Tests fail to build with shared library. ([#128](https://github.com/ksnip/kImageAnnotator/issues/128))

## Release 1.7.1
* Fixed: User not prompted to save when taking new screenshot without tabs. ([#357](https://github.com/ksnip/ksnip/issues/357))
* Fixed: kImageAnnotator not translated with AppImage. ([#358](https://github.com/ksnip/ksnip/issues/358))
* Fixed kImageAnnotator: Crashes after undoing a number annotation. ([#106](https://github.com/ksnip/kImageAnnotator/issues/114))
* Fixed kImageAnnotator: Text overlapping when resizing text box. ([#53](https://github.com/ksnip/kImageAnnotator/issues/53))
* Fixed kImageAnnotator: Snap lines to degrees not working when CTRL pressed before clicking annotation area. ([#113](https://github.com/ksnip/kImageAnnotator/issues/113))
* Fixed kImageAnnotator: "Border and Fill" submenu cutting off text under windows.. ([#117](https://github.com/ksnip/kImageAnnotator/issues/117))
* Fixed kImageAnnotator: Undo removes several or all items. ([#121](https://github.com/ksnip/kImageAnnotator/issues/121))
* Fixed kImageAnnotator: Marker Rect and Ellipse draw only border but no fill. ([#126](https://github.com/ksnip/kImageAnnotator/issues/126))

## Release 1.7.0
* New: Provide ksnip snap. ([#147](https://github.com/ksnip/ksnip/issues/147))
* New: Pasting image or path to image from clipboard. ([#275](https://github.com/ksnip/ksnip/issues/275))
* New: Save to same file when editing existing image. ([#271](https://github.com/ksnip/ksnip/issues/271))
* New: Support for PrtScrn hotkey. ([#239](https://github.com/ksnip/ksnip/issues/239))
* New: Auto save new screenshot. ([#291](https://github.com/ksnip/ksnip/issues/291))
* New: Remember file for already saved images. ([#292](https://github.com/ksnip/ksnip/issues/292))
* New: Add support for drag and drop images into ksnip. ([#282](https://github.com/ksnip/ksnip/issues/282))
* New: Insert embedded image into an existing screenshot. ([#293](https://github.com/ksnip/ksnip/issues/293))
* New: Show screenshots in tabs. ([#298](https://github.com/ksnip/ksnip/issues/298))
* New: Add Maximize Window Button in Print Preview. ([#190](https://github.com/ksnip/ksnip/issues/190))
* New: Click on toast message opens content. ([#303](https://github.com/ksnip/ksnip/issues/303))
* New: Remember last used folder in the save file dialog. ([#264](https://github.com/ksnip/ksnip/issues/264))
* New: Custom script for upload images. ([#268](https://github.com/ksnip/ksnip/issues/268))
* New: Disable single global hotkey by clearing the shortcut. ([#316](https://github.com/ksnip/ksnip/issues/316))
* New: Run ksnip as single instance. ([#238](https://github.com/ksnip/ksnip/issues/238))
* New: Add option for disabling tabs. ([#329](https://github.com/ksnip/ksnip/issues/329))
* New: Add count wildcard format for filename. ([#318](https://github.com/ksnip/ksnip/issues/318))
* New: Allow to change upload imgur URI. ([#159](https://github.com/ksnip/ksnip/issues/159))
* New: Support for adding custom stickers. ([#246](https://github.com/ksnip/ksnip/issues/246))
* New kImageAnnotator: Add option to translate UI. ([#54](https://github.com/ksnip/kImageAnnotator/issues/54))
* New kImageAnnotator: Saved image expand to include annotations out of border. ([#90](https://github.com/ksnip/kImageAnnotator/issues/90))
* New kImageAnnotator: Add support for stickers. ([#74](https://github.com/ksnip/kImageAnnotator/issues/74))
* New kImageAnnotator: Add tab context menu for close all tabs and close other tabs. ([#93](https://github.com/ksnip/kImageAnnotator/issues/93))
* New kImageAnnotator: Add Number with Arrow/pointer tool. ([#79](https://github.com/ksnip/kImageAnnotator/issues/79))
* Changed: Save As option was added and useInstantSave config was removed. ([#285](https://github.com/ksnip/ksnip/issues/285))
* Changed: Disable scroll down with zero value in timeout widget. ([#294](https://github.com/ksnip/ksnip/issues/294))
* Changed: Disable unsupported capture modes in settings. ([#322](https://github.com/ksnip/ksnip/issues/322))
* Changed kImageAnnotator: Make dropdown buttons show popup on click. ([#89](https://github.com/ksnip/kImageAnnotator/issues/89))
* Changed kImageAnnotator: Hide unavailable setting widgets. ([#101](https://github.com/ksnip/kImageAnnotator/issues/101))
* Changed kImageAnnotator: Make arrow size decrease with stroke size. ([#84](https://github.com/ksnip/kImageAnnotator/issues/84))
* Fixed: Compilation error with Qt 5.15. ([#279](https://github.com/ksnip/ksnip/issues/279))
* Fixed: Undo and redo translation reverts back to English. ([#209](https://github.com/ksnip/ksnip/issues/209))
* Fixed: When 'Capture Save Location' is not set, ksnip fails to save. ([#263](https://github.com/ksnip/ksnip/issues/263))
* Fixed: Connections that required ssl not working on AppImages. ([#320](https://github.com/ksnip/ksnip/issues/320))
* Fixed: Main window hangs when pressing `Esc` on selecting screenshot area state. ([#330](https://github.com/ksnip/ksnip/issues/330))
* Fixed: Unable to resize ksnip window. ([#335](https://github.com/ksnip/ksnip/issues/335))
* Fixed: Rectangle picker is not closed with -r -s switches when mouse button is released. ([#338](https://github.com/ksnip/ksnip/issues/338))
* Fixed: Not able to use ksnip if multiple screens are connected under windows. ([#261](https://github.com/ksnip/ksnip/issues/261))
* Fixed kImageAnnotator: Using select tool marks image as changed. ([#97](https://github.com/ksnip/kImageAnnotator/issues/97))
* Fixed kImageAnnotator: Emoticon selector shows a half of current emoticon. ([#104](https://github.com/ksnip/kImageAnnotator/issues/104))
* Fixed kImageAnnotator: FillPicker text or icon sometimes not visible. ([#105](https://github.com/ksnip/kImageAnnotator/issues/105))
* Fixed kImageAnnotator: Wrong image scaling on hdpi screen. ([#81](https://github.com/ksnip/kImageAnnotator/issues/81))
* Fixed kImageAnnotator: Copy area size differs from last capture. ([#107](https://github.com/ksnip/kImageAnnotator/issues/107))
* Fixed kImageAnnotator: Number Tool not reset when switching between tabs. ([#106](https://github.com/ksnip/kImageAnnotator/issues/106))

## Release 1.6.2
* Changed: Add missing plugs to silence snap socket warnings. ([#313](https://github.com/ksnip/ksnip/issues/313))
* Fixed: Window decoration and alt+tab menu show Wayland generic icon on KDE Plasma. ([#269](https://github.com/ksnip/kImageAnnotator/issues/269))
* Fixed: Logout canceled by 'ksnip' under KDE. ([#281](https://github.com/ksnip/kImageAnnotator/issues/281))
* Fixed: Ksnip not displayed on the monitor (off screen). ([#307](https://github.com/ksnip/kImageAnnotator/issues/307))
* Fixed: CTRL+Q to quit Ksnip not working. ([#308](https://github.com/ksnip/kImageAnnotator/issues/308))
* Fixed: Global Hotkeys not working with activatedDefaultAction Num and Caps Lock under X11. ([#310](https://github.com/ksnip/kImageAnnotator/issues/310))
* Fixed: Meta Global Hotkey under X11 not working. ([#311](https://github.com/ksnip/kImageAnnotator/issues/311))

## Release 1.6.1
* Changed: Allow opening link directly to image without opening in browser. ([#248](https://github.com/ksnip/kImageAnnotator/issues/248))
* Changed: Always use transparent snipping area background for Wayland. ([#176](https://github.com/ksnip/kImageAnnotator/issues/176))
* Changed: Disable unavailable config options. ([#254](https://github.com/ksnip/kImageAnnotator/issues/254))
* Fixed kImageAnnotator: Edit border around text box doesn't disappear when done with editing. ([#71](https://github.com/ksnip/kImageAnnotator/issues/71))
* Fixed kImageAnnotator: Edit border not shown under Windows when NoFillNoBorder selected for Text Tool. ([#72](https://github.com/ksnip/kImageAnnotator/issues/72))
* Fixed kImageAnnotator: When adding text with background under Windows a filled rect is show in top left corner. ([#73](https://github.com/ksnip/kImageAnnotator/issues/73))
* Fixed kImageAnnotator: Drawing text tool rect from right to left and bottom top create no rect. ([#76](https://github.com/ksnip/kImageAnnotator/issues/76))
* Fixed kImageAnnotator: Text Tool FillType selection not saved. ([#75](https://github.com/ksnip/kImageAnnotator/issues/75))
* Fixed kImageAnnotator: Icons not scaled with HiDPI. ([#77](https://github.com/ksnip/kImageAnnotator/issues/77))
* Fixed kImageAnnotator: Text Cursor not show on Linux. ([#70](https://github.com/ksnip/kImageAnnotator/issues/70))

## Release 1.6.0
* New: Make captured cursor an item which can be moved and deleted. ([#86](https://github.com/ksnip/ksnip/issues/86))
* New: Add watermarks to annotated image. ([#199](https://github.com/ksnip/ksnip/issues/199))
* New: Add crop button to toolbar. ([#90](https://github.com/ksnip/ksnip/issues/90))
* New: Add undo and redo button on toolbar. ([#124](https://github.com/ksnip/ksnip/issues/124))
* New: Make if watermark is rotated a config option. ([#206](https://github.com/ksnip/ksnip/issues/206))
* New: Do not open image uploaded to imgur in browser. ([#211](https://github.com/ksnip/ksnip/issues/211))
* New: Add shortcuts for taking screenshots. ([#161](https://github.com/ksnip/ksnip/issues/161))
* New: Add Global HotKeys for Windows. ([#161](https://github.com/ksnip/ksnip/issues/161))
* New: Add Global HotKeys for X11. ([#221](https://github.com/ksnip/ksnip/issues/221))
* New: Provide option to use previous capture area. ([#150](https://github.com/ksnip/ksnip/issues/150))
* New: Add System Tray Icon. ([#163](https://github.com/ksnip/ksnip/issues/163))
* New: Show tray icon notification after image was uploaded to imgur or saved. ([#220](https://github.com/ksnip/ksnip/issues/220))
* New: Add support for Open-with. ([#195](https://github.com/ksnip/ksnip/issues/195))
* New: Open ksnip minimized to tray. ([#240](https://github.com/ksnip/ksnip/issues/240))
* New kImageAnnotator: Edit text box content. ([#51](https://github.com/ksnip/kImageAnnotator/issues/51))
* New kImageAnnotator: Panning image by holding space or mouse middle button and dragging. ([#9](https://github.com/ksnip/kImageAnnotator/issues/9))
* New kImageAnnotator: Change annotation element config after drawing. ([#44](https://github.com/ksnip/kImageAnnotator/issues/44))
* Changed: Change copy icon. ([#157](https://github.com/ksnip/ksnip/issues/157))
* Changed: Before discarding ask if user want save or not or cancel. ([#215](https://github.com/ksnip/ksnip/issues/215))
* Changed: Shortcut for imgur upload was changed to Shift + i. ([#161](https://github.com/ksnip/ksnip/issues/161))
* Changed kImageAnnotator: Increase blur level so that large text is not visible. ([#62](https://github.com/ksnip/kImageAnnotator/issues/62))
* Changed kImageAnnotator: Crop widget updates shows via cursor if something is movable. ([#64](https://github.com/ksnip/kImageAnnotator/issues/64))
* Changed kImageAnnotator: Multi-tool buttons select current (last) tool on single click. ([#66](https://github.com/ksnip/kImageAnnotator/issues/66))
* Fixed: Translations not working for Windows and MacOS. ([#164](https://github.com/ksnip/ksnip/issues/164))
* Fixed: AppImage update fails with "None of the artifacts matched the pattern in the update information". ([#166](https://github.com/ksnip/ksnip/issues/166))
* Fixed: Wildcards in path are not resolved. ([#168](https://github.com/ksnip/ksnip/issues/168))
* Fixed: CLI arg --rectarea doesn't work. ([#170](https://github.com/ksnip/ksnip/issues/170))
* Fixed: Imgur Uploader on windows issue. ([#173](https://github.com/ksnip/ksnip/issues/173))
* Fixed: Add shortcut for File Menu in Main Menu. ([#192](https://github.com/ksnip/ksnip/issues/192))
* Fixed: Prompt to save before exit enabled now by default. ([#193](https://github.com/ksnip/ksnip/issues/193))
* Fixed: Configuration Window not translated. ([#186](https://github.com/ksnip/ksnip/issues/186))
* Fixed: ksnip opens anyway with -s option specified. ([#213](https://github.com/ksnip/ksnip/issues/213))
* Fixed: Open Image with full size window doesn't resize main window. ([#194](https://github.com/ksnip/ksnip/issues/194))
* Fixed: Can't work correctly when using scaled display. ([#174](https://github.com/ksnip/ksnip/issues/174))
* Fixed: Not able to restore window from tray under Windows 10. ([#227](https://github.com/ksnip/ksnip/issues/227))
* Fixed: ksnip opens outside desktop if last saved position was on no longer available monitor. ([#236](https://github.com/ksnip/ksnip/issues/236))
* Fixed: Window demaximize when taking a new screenshot. ([#223](https://github.com/ksnip/ksnip/issues/223))
* Fixed: Add support for Chinese Text Input. ([#208](https://github.com/ksnip/ksnip/issues/208))
* Fixed kImageAnnotator: Unable to select number annotation when clicking on the number without background. ([#46](https://github.com/ksnip/kImageAnnotator/issues/46))
* Fixed kImageAnnotator: Ctrl Modifier stuck on second or third screenshot with Ctrl-N. ([#58](https://github.com/ksnip/kImageAnnotator/issues/58))
* Fixed kImageAnnotator: Undo/Redo is now disabled during crop and scale operation. ([#56](https://github.com/ksnip/kImageAnnotator/issues/56))
* Fixed kImageAnnotator: Mess with russian letters in text tool when typing in Russian. ([#59](https://github.com/ksnip/kImageAnnotator/issues/59))
* Fixed kImageAnnotator: Text tool does not allow me to type accents. ([#57](https://github.com/ksnip/ksnip/issues/57))
* Fixed kImageAnnotator: Highlighter rect and ellipse have only border but no fill. ([#65](https://github.com/ksnip/kImageAnnotator/issues/65))
* Fixed kImageAnnotator: Saved tool selection not loaded on startup. ([#67](https://github.com/ksnip/ksnip/issues/67))
* Fixed kImageAnnotator: On startup does not highlight tool, when this tool not the first item in the list. ([#63](https://github.com/ksnip/kImageAnnotator/issues/63))
* Fixed kImageAnnotator: Cursor image cannot be grabbed for moving. ([#69](https://github.com/ksnip/kImageAnnotator/issues/69))
* Fixed kImageAnnotator: Accents still not work in text tool on Linux. ([#61](https://github.com/ksnip/kImageAnnotator/issues/61))

## Release 1.5.0
* New: Added Continues Build with Travis-CI that creates AppImages for every commit. ([#63](https://github.com/ksnip/ksnip/issues/63))
* New: Added option to open image from file via GUI. ([#60](https://github.com/ksnip/ksnip/issues/60))
* New: Added option to set next number for Numbering Paint Items via popup settings. ([#59](https://github.com/ksnip/ksnip/issues/59))
* New: Added experimental Wayland support for KDE and Gnome DEs. ([#56](https://github.com/ksnip/ksnip/issues/56))
* New: Metadata info for ksnip is now installed in the /usr/share/metainfo directory. ([#66](https://github.com/ksnip/ksnip/issues/66))
* New: Added option to open image from file via CLI. ([#71](https://github.com/ksnip/ksnip/issues/71))
* New: Instant saving captures without prompting for save location. ([#61](https://github.com/ksnip/ksnip/issues/61))
* New: Scaling/resizing screenshots and items. ([#79](https://github.com/ksnip/ksnip/issues/79))
* New: Added translation support. ([#94](https://github.com/ksnip/ksnip/issues/94))
* New: Added Spanish, German, Dutch Norwegian and Polish translation. ([#94](https://github.com/ksnip/ksnip/issues/94))
* New: Option to switch between dynamic and default painter cursor size. ([#77](https://github.com/ksnip/ksnip/issues/77))
* New: Added RPM and DEB binaries to continues build.
* New: Added blur annotation tool. ([#109](https://github.com/ksnip/ksnip/issues/109))
* New: Added Windows support. ([#113](https://github.com/ksnip/ksnip/issues/113))
* New: Added Continues build for Windows binaries. ([#114](https://github.com/ksnip/ksnip/issues/114))
* New: Place time delay settings on Toolbar. ([#91](https://github.com/ksnip/ksnip/issues/91))
* New: Add qt style switcher to configuration. ([#137](https://github.com/ksnip/ksnip/issues/137))
* New: Add icons for dark theme. ([#142](https://github.com/ksnip/ksnip/issues/142))
* New: Store imgur delete links. ([#74](https://github.com/ksnip/ksnip/issues/74))
* New: Freeze image while selecting rectangular area. ([#136](https://github.com/ksnip/ksnip/issues/136))
* New: Magnifying glass for snipping area. ([#62](https://github.com/ksnip/ksnip/issues/62))
* New: Add MacOS support. ([#125](https://github.com/ksnip/ksnip/issues/125))
* New: CI support for MacOS. ([#126](https://github.com/ksnip/ksnip/issues/126))
* New kImageAnnotator: Keep number tool sequence consecutive after deleting item. ([#7](https://github.com/ksnip/kImageAnnotator/issues/7))
* New kImageAnnotator: Added control for setting first number for numbering tool. ([#7](https://github.com/ksnip/kImageAnnotator/issues/7))
* New kImageAnnotator: Text and Number tool have now noBorderAndNoFill type. ([#22](https://github.com/ksnip/kImageAnnotator/issues/22))
* New kImageAnnotator: Double Arrow annotation tool. ([#23](https://github.com/ksnip/kImageAnnotator/issues/23))
* New kImageAnnotator: Marker Rectangle and Ellipse annotation tool. ([#26](https://github.com/ksnip/kImageAnnotator/issues/26))
* New kImageAnnotator: Add config option to setup blur radius. ([#25](https://github.com/ksnip/kImageAnnotator/issues/25))
* Changed: Move and select operation are now combined under single tool. ([#72](https://github.com/ksnip/ksnip/issues/72))
* Changed: Item selection is now based on item shape and not on item bounding rect. ([#83](https://github.com/ksnip/ksnip/issues/83))
* Changed: Imgur upload now asks for confirmation before uploading. This can be disabled in setting. ([#73](https://github.com/ksnip/ksnip/issues/73))
* Changed: CLI screenshots open now in editor when triggered without -s flag. ([#103](https://github.com/ksnip/ksnip/issues/103))
* Changed: Default filename features now a more fine-grained time placeholder. ([#110](https://github.com/ksnip/ksnip/issues/110))
* Changed: Console version output doesn't show build. ([#121](https://github.com/ksnip/ksnip/issues/121))
* Changed kImageAnnotator: Blur tool is now preciser and fits the rect. ([#28](https://github.com/ksnip/kImageAnnotator/issues/28))
* Changed kImageAnnotator: Enter finishes text input and shift-enter adds new line in Text Tool. ([#30](https://github.com/ksnip/kImageAnnotator/issues/30))
* Changed kImageAnnotator: Text item draws border around the text when in text edit mode. ([#34](https://github.com/ksnip/kImageAnnotator/issues/34))
* Fixed: Crash on Ubuntu 17.10 caused by null painterPath pointer in smoothOut method. ([#67](https://github.com/ksnip/ksnip/issues/67))
* Fixed: Default filename for screenshot had one $ sign too many. ([#68](https://github.com/ksnip/ksnip/issues/68))
* Fixed: Cancel on browse to save directory in settings dialog clears save path. ([#69](https://github.com/ksnip/ksnip/issues/69))
* Fixed: About dialog not closing when close button is clicked. ([#76](https://github.com/ksnip/ksnip/issues/76))
* Fixed: Undo move operation returns item to wrong location. ([#84](https://github.com/ksnip/ksnip/issues/84))
* Fixed: Crash when adding an item after another item was moved and undone ([#85](https://github.com/ksnip/ksnip/issues/85))
* Fixed: Crop tool not marking screenshot as unsaved after cropping ([#99](https://github.com/ksnip/ksnip/issues/99))
* Fixed: Scale tool not marking screenshot as unsaved after scaling ([#100](https://github.com/ksnip/ksnip/issues/100))
* Fixed: Running ksnip with -e flag and enabled capture screenshot on startup starts new screenshot. ([#105](https://github.com/ksnip/ksnip/issues/105))
* Fixed: Triggering new capture discards unsaved changes. ([#89](https://github.com/ksnip/ksnip/issues/89))
* Fixed: Text tool cannot be resized. ([#111](https://github.com/ksnip/ksnip/issues/111))
* Fixed: Exe file not showing icon on windows. ([#122](https://github.com/ksnip/ksnip/issues/122))
* Fixed: Buttons for text bold, italic and underlined are not correctly shown under windows. ([#118](https://github.com/ksnip/ksnip/issues/118))
* Fixed: ksnip not running on windows when qt not installed. ([#145](https://github.com/ksnip/ksnip/issues/145))
* Fixed: Imgur upload not working under windows. ([#144](https://github.com/ksnip/ksnip/issues/144))
* Fixed: Snipping area with freezed background image not working. ([#149](https://github.com/ksnip/ksnip/issues/149))
* Fixed: Snipping area cursor included in screenshot. ([#148](https://github.com/ksnip/ksnip/issues/148))
* Fixed kImageAnnotator: Double-click on annotation area causes SIGSEGV crash. ([#29](https://github.com/ksnip/kImageAnnotator/issues/29))
* Fixed kImageAnnotator: CAPS LOCK doesnt work on image editor. ([#27](https://github.com/ksnip/kImageAnnotator/issues/27))
* Fixed kImageAnnotator: Unable to select text item when clicking on text. ([#32](https://github.com/ksnip/kImageAnnotator/issues/32))
* Fixed kImageAnnotator: Some blurs get removed when losing focus. ([#35](https://github.com/ksnip/kImageAnnotator/issues/35))
* Fixed kImageAnnotator: Right click on annotation items selects item but doesn't switch tool. ([#40](https://github.com/ksnip/kImageAnnotator/issues/40))
* Fixed kImageAnnotator: Copy number annotation item doesn't increment number. ([#41](https://github.com/ksnip/kImageAnnotator/issues/41))
* Fixed kImageAnnotator: Crash on startup after adding Blur Radius Picker. ([#43](https://github.com/ksnip/kImageAnnotator/issues/43))

## Release 1.4.0
* New: Info text (cursor position and selection area size) for snipping area cursor, can be enabled and disabled via settings.([#49](https://github.com/ksnip/ksnip/issues/49))
* New: Horizontal vertical guiding lines for snipping area cursor, can be enabled and disabled via settings. ([#48](https://github.com/ksnip/ksnip/issues/48))
* New: Drop shadow for paint items, can be enabled and disabled via settings ([#47](https://github.com/ksnip/ksnip/issues/47))
* New: Copy/past paint items. ([#46](https://github.com/ksnip/ksnip/issues/46))
* New: Numbering paint item. ([#45](https://github.com/ksnip/ksnip/issues/45))
* New: Arrow paint item. ([#44](https://github.com/ksnip/ksnip/issues/44))
* New: Select multiple paint items and perform operation on all selected at once. ([#42](https://github.com/ksnip/ksnip/issues/42))
* New: Run last or default capture on startup. ([#40](https://github.com/ksnip/ksnip/issues/40))
* New: Run rect capture from command line. ([#39](https://github.com/ksnip/ksnip/issues/39))
* New: Select between default and custom filename for saving screenshots. ([#36](https://github.com/ksnip/ksnip/issues/36))
* New: Keyboard shortcuts for paint tools. ([#43](https://github.com/ksnip/ksnip/issues/43))
* New: Bring to front and send to back paint items. ([#31](https://github.com/ksnip/ksnip/issues/31))
* New: Configurable snipping cursor thickness and color. ([#54](https://github.com/ksnip/ksnip/issues/54))
* Changed: Moving Ksnip from Qt4 to Qt5. ([#22](https://github.com/ksnip/ksnip/issues/22))
* Fixed: Settings window left hand side menu is not correctly selected when opening first time. ([#37](https://github.com/ksnip/ksnip/issues/37))
* Fixed: Snipping area not correctly shown when started on non-primary screen. ([#52](https://github.com/ksnip/ksnip/issues/52))
* Fixed: Active window screenshot ignores delay. ([#53](https://github.com/ksnip/ksnip/issues/53))
* Fixed: Rectangular area screenshot is shifted to the right of actual selected area. ([#51](https://github.com/ksnip/ksnip/issues/51))
* Fixed: Snipping area not closing when pressing Esc on Ubuntu 16.04. ([#57](https://github.com/ksnip/ksnip/issues/57))

## Release 1.3.2
* Fixed: When compositor is disabled, rect are capture shows only black screen. Fix for Qt4 Ksnip version ([#35](https://github.com/ksnip/ksnip/issues/35))

## Release 1.3.1
* Fixed: Ksnip 1.3.0 fails to build - due to missing cmath library ([#29](https://github.com/ksnip/ksnip/issues/29))

## Release 1.3.0
* New: Drawing two shapes, ellipse and rectangle, with and without fill. ([#21](https://github.com/ksnip/ksnip/issues/21))
* New: Customizable color and size (thickness) for drawing tools via button on main tool bar. ([#25](https://github.com/ksnip/ksnip/issues/25))
* New: Writing text on screenshots, with customizable font, size, color etc. ([#8](https://github.com/ksnip/ksnip/issues/8))
* New: Undo/Redo for paint and crop operations. ([#5](https://github.com/ksnip/ksnip/issues/5))
* New: Smooth out free hand pen and marker lines (can be disabled in settings). ([#16](https://github.com/ksnip/ksnip/issues/16))
* New: Print screenshot or save is to prf/ps. ([#23](https://github.com/ksnip/ksnip/issues/23))
* Fixed: Second and subsequent crops don't move painter items correctly ([#27](https://github.com/ksnip/ksnip/issues/27))
* Fixed: Confirming crop via keyboard doesn't close crop panel ([28](https://github.com/ksnip/ksnip/issues/28))

## Release 1.2.1
* Fixed: Ksnip 1.2.0 binary segfaults when compiled in x86_64 with -fPIC in gcc-5.4.0 ([#20](https://github.com/ksnip/ksnip/issues/20))
* Fixed: Incorrect version number in "About" dialog.

## Release 1.2.0
* New: Added functionality to upload screenshots to Imgur.com in anonymous or account mode. ([#14](https://github.com/ksnip/ksnip/issues/14))
* New: Capture mouse cursor on screenshot (feature can be enabled or disabled in settings). ([#18](https://github.com/ksnip/ksnip/issues/18))
* New: In crop window the crop position, width and height can be entered in numeric values, to provide a more precise crop. ([#17](https://github.com/ksnip/ksnip/issues/17))
* Changed: Settings Window Layout was changed and reorganized.
* Fixed: Paint cursor was visible when capturing new screenshot.
* Fixed: Crop could leave scene area.

## Release 1.1.0
* New: Cropping captured image to desired size. ([#4](https://github.com/ksnip/ksnip/issues/4))
* New: Command line support, screenshotsa can be taken now from command line too. ([#11](https://github.com/ksnip/ksnip/issues/11))
* New: Moving drawn lines to desired position by dragging. ([#2](https://github.com/ksnip/ksnip/issues/2))
* New: Setting default save location, filename and format from settings window. ([#9](https://github.com/ksnip/ksnip/issues/9))
* Changed: Capturing current screen captures now the screen where the mouse cursor is located.

## Release 1.0.0
* New: Screenshots from a custom drawn rectangular area.
* New: Screenshots from the screen where ksnip is currently located (for multi monitor environments).
* New: Screenshots from the whole screen, including all monitors.
* New: Screenshot of currently active (on top) window.
* New: Delayed captures.
* New: Drawing on the captured screenshot with Pen or Marker with changeable color and size.
* New: Saving ksnip location and selected tool and loading on startup.
