/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.appbundler;

import com.oracle.appbundler.Architecture;
import com.oracle.appbundler.Argument;
import com.oracle.appbundler.BundleDocument;
import com.oracle.appbundler.Environment;
import com.oracle.appbundler.IconContainer;
import com.oracle.appbundler.Option;
import com.oracle.appbundler.PlistEntry;
import com.oracle.appbundler.Runtime;
import com.oracle.appbundler.TypeDeclaration;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.resources.FileResource;

public class AppBundlerTask
extends Task {
    private File outputDirectory = null;
    private String name = null;
    private String displayName = null;
    private String identifier = null;
    private File icon = null;
    private String executableName = "JavaAppLauncher";
    private String shortVersion = "1.0";
    private String version = "1.0";
    private String signature = "????";
    private String copyright = "";
    private String privileged = null;
    private String workingDirectory = null;
    private String minimumSystemVersion = null;
    private String jvmRequired = "1.7";
    private boolean jrePreferred = false;
    private boolean jdkPreferred = false;
    private String applicationCategory = null;
    private boolean highResolutionCapable = true;
    private boolean supportsAutomaticGraphicsSwitching = true;
    private boolean hideDockIcon = false;
    private boolean isDebug = false;
    private boolean ignorePSN = false;
    private String mainClassName = null;
    private Runtime runtime = null;
    private ArrayList<FileSet> classPath = new ArrayList();
    private ArrayList<FileSet> libraryPath = new ArrayList();
    private ArrayList<Option> options = new ArrayList();
    private ArrayList<String> arguments = new ArrayList();
    private ArrayList<String> architectures = new ArrayList();
    private ArrayList<String> registeredProtocols = new ArrayList();
    private ArrayList<BundleDocument> bundleDocuments = new ArrayList();
    private ArrayList<TypeDeclaration> exportedTypeDeclarations = new ArrayList();
    private ArrayList<TypeDeclaration> importedTypeDeclarations = new ArrayList();
    private ArrayList<PlistEntry> plistEntries = new ArrayList();
    private ArrayList<Environment> environments = new ArrayList();
    private Reference classPathRef;
    private ArrayList<String> plistClassPaths = new ArrayList();
    private static final String EXECUTABLE_NAME = "JavaAppLauncher";
    private static final String DEFAULT_ICON_NAME = "GenericApp.icns";
    private static final String OS_TYPE_CODE = "APPL";
    private static final String PLIST_DTD = "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">";
    private static final String PLIST_TAG = "plist";
    private static final String PLIST_VERSION_ATTRIBUTE = "version";
    private static final String DICT_TAG = "dict";
    private static final String KEY_TAG = "key";
    private static final String ARRAY_TAG = "array";
    private static final String STRING_TAG = "string";
    private static final int BUFFER_SIZE = 2048;

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setIcon(File icon) {
        this.icon = icon;
    }

    public void setExecutableName(String executable) {
        this.executableName = executable;
    }

    public void setShortVersion(String shortVersion) {
        this.shortVersion = shortVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setPrivileged(String privileged) {
        this.privileged = privileged;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setJVMRequired(String v) {
        this.jvmRequired = v;
    }

    public void setJREPreferred(boolean preferred) {
        this.jrePreferred = preferred;
    }

    public void setJDKPreferred(boolean preferred) {
        this.jdkPreferred = preferred;
    }

    public void setMinimumSystemVersion(String v) {
        this.minimumSystemVersion = v;
    }

    public void setApplicationCategory(String applicationCategory) {
        this.applicationCategory = applicationCategory;
    }

    public void setHighResolutionCapable(boolean highResolutionCapable) {
        this.highResolutionCapable = highResolutionCapable;
    }

    public void setHideDockIcon(boolean hideDock) {
        this.hideDockIcon = hideDock;
    }

    public void setDebug(boolean enabled) {
        this.isDebug = enabled;
    }

    public void setSupportsAutomaticGraphicsSwitching(boolean supportsAutomaticGraphicsSwitching) {
        this.supportsAutomaticGraphicsSwitching = supportsAutomaticGraphicsSwitching;
    }

    public void setIgnorePSN(boolean ignorePSN) {
        this.ignorePSN = ignorePSN;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public void addConfiguredRuntime(Runtime runtime) throws BuildException {
        if (this.runtime != null) {
            throw new BuildException("Runtime already specified.");
        }
        this.runtime = runtime;
    }

    public void setClasspathRef(Reference ref) {
        this.classPathRef = ref;
    }

    public void setPlistClassPaths(String plistClassPaths) {
        for (String tok : plistClassPaths.split("\\s*,\\s*")) {
            this.plistClassPaths.add(tok);
        }
    }

    public void addConfiguredClassPath(FileSet classPath) {
        this.classPath.add(classPath);
    }

    public void addConfiguredLibraryPath(FileSet libraryPath) {
        this.libraryPath.add(libraryPath);
    }

    public void addConfiguredBundleDocument(BundleDocument document) {
        if (document.getContentTypes() == null && document.getExtensions() == null) {
            throw new BuildException("Document content type or extension is required.");
        }
        this.bundleDocuments.add(document);
    }

    public void addConfiguredTypeDeclaration(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.getIdentifier() == null) {
            throw new BuildException("Type declarations must have an identifier.");
        }
        if (typeDeclaration.isImported()) {
            this.importedTypeDeclarations.add(typeDeclaration);
        } else {
            this.exportedTypeDeclarations.add(typeDeclaration);
        }
    }

    public void addConfiguredPlistEntry(PlistEntry plistEntry) {
        if (plistEntry.getKey() == null) {
            throw new BuildException("Name is required.");
        }
        if (plistEntry.getValue() == null) {
            throw new BuildException("Value is required.");
        }
        if (plistEntry.getType() == null) {
            plistEntry.setType(STRING_TAG);
        }
        this.plistEntries.add(plistEntry);
    }

    public void addConfiguredEnvironment(Environment environment) {
        if (environment.getName() == null) {
            throw new BuildException("Name is required.");
        }
        if (environment.getValue() == null) {
            throw new BuildException("Value is required.");
        }
        this.environments.add(environment);
    }

    public void addConfiguredOption(Option option) throws BuildException {
        String value = option.getValue();
        if (value == null) {
            throw new BuildException("Value is required.");
        }
        this.options.add(option);
    }

    public void addConfiguredArgument(Argument argument) throws BuildException {
        String value = argument.getValue();
        if (value == null) {
            throw new BuildException("Value is required.");
        }
        this.arguments.add(value);
    }

    public void addConfiguredScheme(Argument argument) throws BuildException {
        String value = argument.getValue();
        if (value == null) {
            throw new BuildException("Value is required.");
        }
        this.registeredProtocols.add(value);
    }

    public void addConfiguredArch(Architecture architecture) throws BuildException {
        String name = architecture.getName();
        if (name == null) {
            throw new BuildException("Name is required.");
        }
        this.architectures.add(name);
    }

    public void execute() throws BuildException {
        if (this.outputDirectory == null) {
            throw new IllegalStateException("Output directory is required.");
        }
        if (!this.outputDirectory.exists()) {
            throw new IllegalStateException("Output directory does not exist.");
        }
        if (!this.outputDirectory.isDirectory()) {
            throw new IllegalStateException("Invalid output directory.");
        }
        if (this.name == null) {
            throw new IllegalStateException("Name is required.");
        }
        if (this.displayName == null) {
            throw new IllegalStateException("Display name is required.");
        }
        if (this.identifier == null) {
            throw new IllegalStateException("Identifier is required.");
        }
        if (this.icon != null) {
            if (!this.icon.exists()) {
                throw new IllegalStateException("Icon does not exist.");
            }
            if (this.icon.isDirectory()) {
                throw new IllegalStateException("Invalid icon.");
            }
        }
        if (this.shortVersion == null) {
            throw new IllegalStateException("Short version is required.");
        }
        if (this.signature == null) {
            throw new IllegalStateException("Signature is required.");
        }
        if (this.signature.length() != 4) {
            throw new IllegalStateException("Invalid signature.");
        }
        if (this.copyright == null) {
            throw new IllegalStateException("Copyright is required.");
        }
        if (this.mainClassName == null) {
            throw new IllegalStateException("Main class name is required.");
        }
        try {
            System.out.println("Creating app bundle: " + this.name);
            File rootDirectory = new File(this.outputDirectory, this.name + ".app");
            AppBundlerTask.delete(rootDirectory);
            rootDirectory.mkdir();
            File contentsDirectory = new File(rootDirectory, "Contents");
            contentsDirectory.mkdir();
            File macOSDirectory = new File(contentsDirectory, "MacOS");
            macOSDirectory.mkdir();
            File javaDirectory = new File(contentsDirectory, "Java");
            javaDirectory.mkdir();
            File plugInsDirectory = new File(contentsDirectory, "PlugIns");
            plugInsDirectory.mkdir();
            File resourcesDirectory = new File(contentsDirectory, "Resources");
            resourcesDirectory.mkdir();
            File infoPlistFile = new File(contentsDirectory, "Info.plist");
            infoPlistFile.createNewFile();
            this.writeInfoPlist(infoPlistFile);
            File pkgInfoFile = new File(contentsDirectory, "PkgInfo");
            pkgInfoFile.createNewFile();
            this.writePkgInfo(pkgInfoFile);
            File executableFile = new File(macOSDirectory, this.executableName);
            AppBundlerTask.copy(((Object)((Object)this)).getClass().getResource(EXECUTABLE_NAME), executableFile);
            executableFile.setExecutable(true, false);
            this.copyResources(resourcesDirectory);
            this.copyRuntime(plugInsDirectory);
            this.copyClassPathEntries(javaDirectory);
            this.copyClassPathRefEntries(javaDirectory);
            this.copyLibraryPathEntries(macOSDirectory);
            this.copyIcon(resourcesDirectory);
            this.copyDocumentIcons(this.bundleDocuments, resourcesDirectory);
            this.copyDocumentIcons(this.exportedTypeDeclarations, resourcesDirectory);
            this.copyDocumentIcons(this.importedTypeDeclarations, resourcesDirectory);
        }
        catch (IOException exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResources(File resourcesDirectory) throws IOException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("res.zip");
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                File file = new File(resourcesDirectory, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file.mkdir();
                } else {
                    try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file), 2048);){
                        int b = zipInputStream.read();
                        while (b != -1) {
                            ((OutputStream)outputStream).write(b);
                            b = zipInputStream.read();
                        }
                        ((OutputStream)outputStream).flush();
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
    }

    private void copyRuntime(File plugInsDirectory) throws IOException {
        if (this.runtime != null) {
            this.runtime.copyTo(plugInsDirectory);
        }
    }

    private void copyClassPathRefEntries(File javaDirectory) throws IOException {
        if (this.classPathRef != null) {
            Path classpath = (Path)this.classPathRef.getReferencedObject(this.getProject());
            for (FileResource resource : classpath) {
                File source = resource.getFile();
                File destination = new File(javaDirectory, source.getName());
                AppBundlerTask.copy(source, destination);
            }
        }
    }

    private void copyClassPathEntries(File javaDirectory) throws IOException {
        for (FileSet fileSet : this.classPath) {
            File classPathDirectory = fileSet.getDir();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] includedFiles = directoryScanner.getIncludedFiles();
            for (int i = 0; i < includedFiles.length; ++i) {
                String includedFile = includedFiles[i];
                File source = new File(classPathDirectory, includedFile);
                File destination = new File(javaDirectory, new File(includedFile).getName());
                AppBundlerTask.copy(source, destination);
            }
        }
    }

    private void copyLibraryPathEntries(File macOSDirectory) throws IOException {
        for (FileSet fileSet : this.libraryPath) {
            File libraryPathDirectory = fileSet.getDir();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] includedFiles = directoryScanner.getIncludedFiles();
            for (int i = 0; i < includedFiles.length; ++i) {
                String includedFile = includedFiles[i];
                File source = new File(libraryPathDirectory, includedFile);
                File destination = new File(macOSDirectory, new File(includedFile).getName());
                AppBundlerTask.copy(source, destination);
            }
        }
    }

    private void copyIcon(File resourcesDirectory) throws IOException {
        if (this.icon == null) {
            AppBundlerTask.copy(((Object)((Object)this)).getClass().getResource(DEFAULT_ICON_NAME), new File(resourcesDirectory, DEFAULT_ICON_NAME));
        } else {
            AppBundlerTask.copy(this.icon, new File(resourcesDirectory, this.icon.getName()));
        }
    }

    public void copyDocumentIcons(ArrayList<? extends IconContainer> iconContainers, File resourcesDirectory) throws IOException {
        for (IconContainer iconContainer : iconContainers) {
            File ifile;
            if (!iconContainer.hasIcon() || (ifile = iconContainer.getIconFile()) == null) continue;
            this.copyDocumentIcon(ifile, resourcesDirectory);
        }
    }

    private void copyDocumentIcon(File ifile, File resourcesDirectory) throws IOException {
        if (ifile == null) {
            return;
        }
        AppBundlerTask.copy(ifile, new File(resourcesDirectory, ifile.getName()));
    }

    private void writeInfoPlist(File file) throws IOException {
        XMLOutputFactory output = XMLOutputFactory.newInstance();
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
            XMLStreamWriter xout = output.createXMLStreamWriter(out);
            xout.writeStartDocument();
            xout.writeCharacters("\n");
            xout.writeDTD(PLIST_DTD);
            xout.writeCharacters("\n");
            xout.writeStartElement(PLIST_TAG);
            xout.writeAttribute(PLIST_VERSION_ATTRIBUTE, "1.0");
            xout.writeCharacters("\n");
            xout.writeStartElement(DICT_TAG);
            xout.writeCharacters("\n");
            this.writeProperty(xout, "CFBundleDevelopmentRegion", "English");
            this.writeProperty(xout, "CFBundleExecutable", this.executableName);
            this.writeProperty(xout, "CFBundleIconFile", this.icon == null ? DEFAULT_ICON_NAME : this.icon.getName());
            this.writeProperty(xout, "CFBundleIdentifier", this.identifier);
            this.writeProperty(xout, "CFBundleDisplayName", this.displayName);
            this.writeProperty(xout, "CFBundleInfoDictionaryVersion", "6.0");
            this.writeProperty(xout, "CFBundleName", this.name);
            this.writeProperty(xout, "CFBundlePackageType", OS_TYPE_CODE);
            this.writeProperty(xout, "CFBundleShortVersionString", this.shortVersion);
            this.writeProperty(xout, "CFBundleVersion", this.version);
            this.writeProperty(xout, "CFBundleSignature", this.signature);
            this.writeProperty(xout, "NSHumanReadableCopyright", this.copyright);
            this.writeProperty(xout, "LSMinimumSystemVersion", this.minimumSystemVersion);
            this.writeProperty(xout, "LSApplicationCategoryType", this.applicationCategory);
            this.writeProperty(xout, "LSUIElement", this.hideDockIcon);
            this.writeProperty(xout, "NSHighResolutionCapable", this.highResolutionCapable);
            this.writeProperty(xout, "NSSupportsAutomaticGraphicsSwitching", this.supportsAutomaticGraphicsSwitching);
            this.writeProperty(xout, "IgnorePSN", this.ignorePSN);
            if (this.registeredProtocols.size() > 0) {
                this.writeKey(xout, "CFBundleURLTypes");
                xout.writeStartElement(ARRAY_TAG);
                xout.writeCharacters("\n");
                xout.writeStartElement(DICT_TAG);
                xout.writeCharacters("\n");
                this.writeProperty(xout, "CFBundleURLName", this.identifier);
                this.writeStringArray(xout, "CFBundleURLSchemes", this.registeredProtocols);
                xout.writeEndElement();
                xout.writeCharacters("\n");
                xout.writeEndElement();
                xout.writeCharacters("\n");
            }
            if (this.runtime != null) {
                this.writeProperty(xout, "JVMRuntime", this.runtime.getDir().getParentFile().getParentFile().getName());
            }
            this.writeProperty(xout, "JVMVersion", this.jvmRequired);
            this.writeProperty(xout, "JVMRunPrivileged", this.privileged);
            this.writeProperty(xout, "JREPreferred", this.jrePreferred);
            this.writeProperty(xout, "JDKPreferred", this.jdkPreferred);
            this.writeProperty(xout, "WorkingDirectory", this.workingDirectory);
            this.writeProperty(xout, "JVMMainClassName", this.mainClassName);
            if (!this.plistClassPaths.isEmpty()) {
                this.writeStringArray(xout, "JVMClassPath", this.plistClassPaths);
            }
            this.writeProperty(xout, "JVMDebug", this.isDebug);
            this.writeKey(xout, "CFBundleDocumentTypes");
            this.writeBundleDocuments(xout, this.bundleDocuments);
            if (!this.exportedTypeDeclarations.isEmpty()) {
                this.writeKey(xout, "UTExportedTypeDeclarations");
                this.writeTypeDeclarations(xout, this.exportedTypeDeclarations);
            }
            if (!this.importedTypeDeclarations.isEmpty()) {
                this.writeKey(xout, "UTImportedTypeDeclarations");
                this.writeTypeDeclarations(xout, this.importedTypeDeclarations);
            }
            this.writeStringArray(xout, "LSArchitecturePriority", this.architectures);
            this.writeKey(xout, "LSEnvironment");
            xout.writeStartElement(DICT_TAG);
            xout.writeCharacters("\n");
            this.writeKey(xout, "LC_CTYPE");
            this.writeString(xout, "UTF-8");
            for (Environment environment : this.environments) {
                this.writeProperty(xout, environment.getName(), environment.getValue());
            }
            xout.writeEndElement();
            xout.writeCharacters("\n");
            this.writeKey(xout, "JVMOptions");
            xout.writeStartElement(ARRAY_TAG);
            xout.writeCharacters("\n");
            for (Option option : this.options) {
                if (option.getName() != null) continue;
                this.writeString(xout, option.getValue());
            }
            xout.writeEndElement();
            xout.writeCharacters("\n");
            this.writeKey(xout, "JVMDefaultOptions");
            xout.writeStartElement(DICT_TAG);
            xout.writeCharacters("\n");
            for (Option option : this.options) {
                if (option.getName() == null) continue;
                this.writeProperty(xout, option.getName(), option.getValue());
            }
            xout.writeEndElement();
            xout.writeCharacters("\n");
            this.writeStringArray(xout, "JVMArguments", this.arguments);
            for (PlistEntry item : this.plistEntries) {
                this.writeKey(xout, item.getKey());
                this.writeValue(xout, item.getType(), item.getValue());
            }
            xout.writeEndElement();
            xout.writeCharacters("\n");
            xout.writeEndElement();
            xout.writeCharacters("\n");
            xout.writeEndDocument();
            xout.writeCharacters("\n");
            ((Writer)out).flush();
        }
    }

    private void writeKey(XMLStreamWriter xout, String key) throws XMLStreamException {
        xout.writeStartElement(KEY_TAG);
        xout.writeCharacters(key);
        xout.writeEndElement();
        xout.writeCharacters("\n");
    }

    private void writeValue(XMLStreamWriter xout, String type, String value) throws XMLStreamException {
        if (type == null) {
            type = STRING_TAG;
        }
        if ("boolean".equals(type)) {
            this.writeBoolean(xout, "true".equals(value));
        } else {
            xout.writeStartElement(type);
            xout.writeCharacters(value);
            xout.writeEndElement();
            xout.writeCharacters("\n");
        }
    }

    private void writeString(XMLStreamWriter xout, String value) throws XMLStreamException {
        xout.writeStartElement(STRING_TAG);
        xout.writeCharacters(value);
        xout.writeEndElement();
        xout.writeCharacters("\n");
    }

    private void writeBoolean(XMLStreamWriter xout, boolean value) throws XMLStreamException {
        xout.writeEmptyElement(value ? "true" : "false");
        xout.writeCharacters("\n");
    }

    private void writeProperty(XMLStreamWriter xout, String key, Boolean value) throws XMLStreamException {
        if (value != null && value.booleanValue()) {
            this.writeKey(xout, key);
            this.writeBoolean(xout, true);
        }
    }

    private void writeProperty(XMLStreamWriter xout, String key, Object value) throws XMLStreamException {
        if (value != null) {
            this.writeKey(xout, key);
            this.writeString(xout, value.toString());
        }
    }

    public void writeStringArray(XMLStreamWriter xout, String key, Iterable<String> values) throws XMLStreamException {
        if (values != null) {
            this.writeKey(xout, key);
            xout.writeStartElement(ARRAY_TAG);
            xout.writeCharacters("\n");
            for (String singleValue : values) {
                this.writeString(xout, singleValue);
            }
            xout.writeEndElement();
            xout.writeCharacters("\n");
        }
    }

    public void writeBundleDocuments(XMLStreamWriter xout, ArrayList<BundleDocument> bundleDocuments) throws XMLStreamException {
        xout.writeStartElement(ARRAY_TAG);
        xout.writeCharacters("\n");
        for (BundleDocument bundleDocument : bundleDocuments) {
            xout.writeStartElement(DICT_TAG);
            xout.writeCharacters("\n");
            List<String> contentTypes = bundleDocument.getContentTypes();
            if (contentTypes != null) {
                this.writeStringArray(xout, "LSItemContentTypes", contentTypes);
            } else {
                this.writeStringArray(xout, "CFBundleTypeExtensions", bundleDocument.getExtensions());
                this.writeProperty(xout, "LSTypeIsPackage", bundleDocument.isPackage());
            }
            this.writeStringArray(xout, "NSExportableTypes", bundleDocument.getExportableTypes());
            File ifile = bundleDocument.getIconFile();
            this.writeProperty(xout, "CFBundleTypeIconFile", ifile != null ? ifile.getName() : bundleDocument.getIcon());
            this.writeProperty(xout, "CFBundleTypeName", bundleDocument.getName());
            this.writeProperty(xout, "CFBundleTypeRole", bundleDocument.getRole());
            this.writeProperty(xout, "LSHandlerRank", bundleDocument.getHandlerRank());
            xout.writeEndElement();
            xout.writeCharacters("\n");
        }
        xout.writeEndElement();
        xout.writeCharacters("\n");
    }

    public void writeTypeDeclarations(XMLStreamWriter xout, ArrayList<TypeDeclaration> typeDeclarations) throws XMLStreamException {
        xout.writeStartElement(ARRAY_TAG);
        xout.writeCharacters("\n");
        for (TypeDeclaration typeDeclaration : typeDeclarations) {
            xout.writeStartElement(DICT_TAG);
            xout.writeCharacters("\n");
            this.writeProperty(xout, "UTTypeIdentifier", typeDeclaration.getIdentifier());
            this.writeProperty(xout, "UTTypeReferenceURL", typeDeclaration.getReferenceUrl());
            this.writeProperty(xout, "UTTypeDescription", typeDeclaration.getDescription());
            File ifile = typeDeclaration.getIconFile();
            this.writeProperty(xout, "UTTypeIconFile", ifile != null ? ifile.getName() : typeDeclaration.getIcon());
            this.writeStringArray(xout, "UTTypeConformsTo", typeDeclaration.getConformsTo());
            this.writeKey(xout, "UTTypeTagSpecification");
            xout.writeStartElement(DICT_TAG);
            xout.writeCharacters("\n");
            this.writeStringArray(xout, "com.apple.ostype", typeDeclaration.getOsTypes());
            this.writeStringArray(xout, "public.filename-extension", typeDeclaration.getExtensions());
            this.writeStringArray(xout, "public.mime-type", typeDeclaration.getMimeTypes());
            xout.writeEndElement();
            xout.writeCharacters("\n");
            xout.writeEndElement();
            xout.writeCharacters("\n");
        }
        xout.writeEndElement();
        xout.writeCharacters("\n");
    }

    private void writePkgInfo(File file) throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
            out.write(OS_TYPE_CODE + this.signature);
            ((Writer)out).flush();
        }
    }

    private static void delete(File file) throws IOException {
        java.nio.file.Path filePath = file.toPath();
        if (Files.exists(filePath, LinkOption.NOFOLLOW_LINKS)) {
            if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    AppBundlerTask.delete(files[i]);
                }
            }
            Files.delete(filePath);
        }
    }

    private static void copy(URL location, File file) throws IOException {
        try (InputStream in = location.openStream();){
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exc) {
            System.err.println("Trying to copy " + location + " to " + file);
            throw exc;
        }
    }

    static void copy(File source, File destination) throws IOException {
        java.nio.file.Path sourcePath = source.toPath();
        java.nio.file.Path destinationPath = destination.toPath();
        destination.getParentFile().mkdirs();
        Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING, LinkOption.NOFOLLOW_LINKS);
        if (Files.isDirectory(sourcePath, LinkOption.NOFOLLOW_LINKS)) {
            String[] files = source.list();
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                AppBundlerTask.copy(new File(source, file), new File(destination, file));
            }
        }
    }
}

