/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetSupport;
import org.jvnet.lafwidget.utils.FadeIgnoreManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LafWidgetRepository {
    protected Map<Class<?>, Set<ClassInfo>> widgets = new HashMap();
    protected LafWidgetSupport lafSupport = new LafWidgetSupport();
    protected boolean isCustomLafSupportSet = false;
    protected FadeIgnoreManager fadeIgnoreManager = new FadeIgnoreManager();
    protected static LafWidgetRepository repository;
    private static ResourceBundle LABEL_BUNDLE;
    private static ClassLoader labelBundleClassLoader;

    private LafWidgetRepository() {
    }

    public static synchronized LafWidgetRepository getRepository() {
        if (repository == null) {
            repository = new LafWidgetRepository();
            repository.populate();
            LafWidgetRepository.repository.fadeIgnoreManager.populate();
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateFrom(URL url) {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = url.openStream();
            props.load(is);
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = props.getProperty(name);
                String[] values = value.split(";");
                for (int i = 0; i < values.length; ++i) {
                    String className = values[i].trim();
                    boolean isExact = className.startsWith("%");
                    if (isExact) {
                        className = className.substring(1);
                    }
                    try {
                        this.registerWidget(name, Class.forName(className), isExact);
                        continue;
                    }
                    catch (ClassNotFoundException cnfe) {
                        // empty catch block
                    }
                }
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void populate() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> rs = cl.getResources("META-INF/lafwidget.properties");
            while (rs.hasMoreElements()) {
                URL rUrl = rs.nextElement();
                this.populateFrom(rUrl);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void registerWidget(String widgetClassName, List<Class<?>> supportedClasses) {
        for (Class<?> clazz : supportedClasses) {
            this.registerWidget(widgetClassName, clazz, false);
        }
    }

    public synchronized void registerWidget(String widgetClassName, Class<?> supportedClass, boolean isExact) {
        if (JComponent.class.isAssignableFrom(supportedClass) && !this.widgets.containsKey(supportedClass)) {
            this.widgets.put(supportedClass, new HashSet());
        }
        this.widgets.get(supportedClass).add(new ClassInfo(widgetClassName, isExact));
    }

    public synchronized Set<LafWidget> getMatchingWidgets(JComponent jcomp) {
        HashSet<LafWidget> result = new HashSet<LafWidget>();
        boolean isOriginator = true;
        for (Class<?> clazz = jcomp.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Set<ClassInfo> registered = this.widgets.get(clazz);
            if (registered != null) {
                for (ClassInfo widgetClassInfo : registered) {
                    if (widgetClassInfo.isExact && !isOriginator) continue;
                    try {
                        LafWidget widget;
                        String widgetClassName = widgetClassInfo.className;
                        Object widgetObj = Class.forName(widgetClassName).newInstance();
                        if (!(widgetObj instanceof LafWidget) || (widget = (LafWidget)widgetObj).requiresCustomLafSupport() && !this.isCustomLafSupportSet) continue;
                        widget.setComponent(jcomp);
                        result.add(widget);
                    }
                    catch (InstantiationException ie) {
                    }
                    catch (IllegalAccessException iae) {
                    }
                    catch (ClassNotFoundException cnfe) {}
                }
            }
            isOriginator = false;
        }
        return result;
    }

    public void setLafSupport(LafWidgetSupport lafSupport) {
        if (lafSupport == null) {
            throw new IllegalArgumentException("LAF support can't be null");
        }
        this.lafSupport = lafSupport;
        this.isCustomLafSupportSet = this.lafSupport.getClass() != LafWidgetSupport.class;
    }

    public void unsetLafSupport() {
        this.lafSupport = new LafWidgetSupport();
        this.isCustomLafSupportSet = false;
    }

    public LafWidgetSupport getLafSupport() {
        return this.lafSupport;
    }

    public static synchronized ResourceBundle getLabelBundle() {
        LABEL_BUNDLE = labelBundleClassLoader == null ? ResourceBundle.getBundle("org.jvnet.lafwidget.resources.Labels", Locale.getDefault()) : ResourceBundle.getBundle("org.jvnet.lafwidget.resources.Labels", Locale.getDefault(), labelBundleClassLoader);
        return LABEL_BUNDLE;
    }

    public static synchronized void resetLabelBundle() {
        LABEL_BUNDLE = null;
    }

    public static void setLabelBundleClassLoader(ClassLoader labelBundleClassLoader) {
        LafWidgetRepository.labelBundleClassLoader = labelBundleClassLoader;
    }

    public FadeIgnoreManager getFadeIgnoreManager() {
        return this.fadeIgnoreManager;
    }

    static {
        LABEL_BUNDLE = null;
    }

    protected static class ClassInfo {
        public String className;
        public boolean isExact;

        public ClassInfo(String className, boolean isExact) {
            this.className = className;
            this.isExact = isExact;
        }
    }
}

