/*
 * Decompiled with CFR 0.152.
 */
package de.dimaki.refuel;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;

public class Bootstrap {
    private ClassLoader defaultClassLoader;
    private URLClassLoader appClassLoader;
    private Class<?> appClazz;
    private Object appInstance;

    public static Path update(Path applicationFile, Path updateDir, boolean removeUpdateFiles) throws IOException {
        Path newApplicationJar = null;
        String applicationName = applicationFile.getFileName().toString();
        applicationName = applicationName.substring(0, applicationName.lastIndexOf("."));
        ArrayList<Path> updateFiles = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(updateDir, applicationName + "*.{jar,JAR,war,WAR,rar,RAR,ear,EAR}");){
            for (Path entry : stream) {
                updateFiles.add(entry);
            }
        }
        catch (DirectoryIteratorException ex) {
            throw ex.getCause();
        }
        if (!updateFiles.isEmpty()) {
            Path updateFile = (Path)updateFiles.get(0);
            newApplicationJar = Files.copy(updateFile, applicationFile, StandardCopyOption.REPLACE_EXISTING);
            if (removeUpdateFiles) {
                Files.delete(updateFile);
            }
        }
        return newApplicationJar;
    }

    public void startApp(Path applicationFile, String applicationClass, String methodName) throws IOException {
        try {
            System.out.println("Loading : " + applicationFile.toAbsolutePath().toString());
            this.defaultClassLoader = Thread.currentThread().getContextClassLoader();
            this.appClassLoader = URLClassLoader.newInstance(new URL[]{applicationFile.toUri().toURL()}, this.defaultClassLoader);
            Thread.currentThread().setContextClassLoader(this.appClassLoader);
            Thread.getAllStackTraces().keySet().stream().forEach(thread -> thread.setContextClassLoader(this.appClassLoader));
            this.appClazz = this.appClassLoader.loadClass(applicationClass);
            Method method = this.appClazz.getMethod(methodName, new Class[0]);
            this.appInstance = this.appClazz.newInstance();
            method.invoke(this.appInstance, new Object[0]);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }
}

