/*
 * Decompiled with CFR 0.152.
 */
package de.dimaki.refuel.updater.boundary;

import de.dimaki.refuel.appcast.boundary.AppcastManager;
import de.dimaki.refuel.appcast.control.AppcastException;
import de.dimaki.refuel.appcast.entity.Appcast;
import de.dimaki.refuel.updater.control.VersionComparator;
import de.dimaki.refuel.updater.control.ZipHandler;
import de.dimaki.refuel.updater.entity.ApplicationStatus;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Updater {
    private static final Logger LOG = LoggerFactory.getLogger(Updater.class);
    private static final String UPDATE_SCRIPT_SUFFIX = "-update.js";
    AppcastManager appcastManager;

    public Updater() {
        try {
            this.appcastManager = new AppcastManager();
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Could not initialize Appcast Manager!", ex);
        }
    }

    public ApplicationStatus getApplicationStatus(String localVersion, URL updateUrl) {
        return this.getApplicationStatus(localVersion, updateUrl, null, 8000, 8000);
    }

    public ApplicationStatus getApplicationStatus(String localVersion, URL updateUrl, Proxy proxy, int connectTimeout, int readTimeout) {
        return this.getApplicationStatus(localVersion, updateUrl, proxy, connectTimeout, readTimeout, null);
    }

    public ApplicationStatus getApplicationStatus(String localVersion, URL updateUrl, Proxy proxy, int connectTimeout, int readTimeout, Map<String, String> requestProperties) {
        ApplicationStatus status = ApplicationStatus.UNKNOWN;
        if (localVersion != null) {
            if (!localVersion.isEmpty() && updateUrl != null) {
                String remoteVersion = null;
                try {
                    LOG.debug("Fetching appcast from update URL ''{}''...", (Object)updateUrl);
                    Appcast appcast = this.appcastManager.fetch(updateUrl, proxy, connectTimeout, readTimeout, requestProperties);
                    if (appcast != null) {
                        remoteVersion = appcast.getLatestVersion();
                    }
                    if (remoteVersion == null) {
                        status = ApplicationStatus.FAILURE;
                        status.setInfo("No version information found");
                    } else {
                        VersionComparator vc = new VersionComparator();
                        int compare = vc.compare(localVersion, remoteVersion);
                        if (compare == 0) {
                            status = ApplicationStatus.OK;
                            status.setInfo("No update available");
                        } else if (compare < 0) {
                            status = ApplicationStatus.UPDATE_AVAILABLE;
                            String shortVersionString = appcast.getLatestEnclosure().getShortVersionString();
                            if (shortVersionString != null && !shortVersionString.isEmpty()) {
                                status.setInfo(shortVersionString);
                            } else {
                                status.setInfo(remoteVersion);
                            }
                            status.setAppcast(appcast);
                        } else if (compare > 0) {
                            status = ApplicationStatus.OK;
                        }
                    }
                }
                catch (AppcastException aex) {
                    LOG.warn("{} ''{}'': {} {}", new Object[]{aex.getMessage(), aex.getUrl(), aex.getStatus(), aex.getStatusInfo()});
                    status = ApplicationStatus.FAILURE;
                    status.setInfo(aex.getMessage() + " '" + aex.getUrl() + "': " + aex.getStatus() + " " + aex.getStatusInfo());
                }
                catch (Exception ex) {
                    status.setInfo(ex.getMessage());
                    LOG.warn("Could not connect to update server: {}", (Object)ex.getMessage());
                }
                status.setUpdateTime(new Date());
            }
        } else {
            status = ApplicationStatus.NOT_INSTALLED;
        }
        return status;
    }

    public Set<Path> update(Appcast appcast, Path targetDir) throws Exception {
        if (appcast == null) {
            throw new IllegalArgumentException("Appcast cannot be null!");
        }
        LOG.debug("Updating application ''{}''...", (Object)appcast.getTitle());
        Path downloaded = this.appcastManager.download(appcast, targetDir);
        if (downloaded == null) {
            throw new Exception("Could not download update package for application '" + appcast.getTitle() + "'!");
        }
        LOG.debug("Downloaded update package ''{}''", (Object)downloaded);
        Set<Path> files = ZipHandler.unzip(downloaded, targetDir, true);
        LOG.debug("Extracted files: {}", files);
        HashMap<String, Path> bindings = new HashMap<String, Path>();
        bindings.put("targetDir", targetDir);
        files.stream().filter(filePath -> filePath.getFileName().toString().endsWith(UPDATE_SCRIPT_SUFFIX)).forEach(filePath -> this.executeUpdateScript((Path)filePath, (Map<String, Object>)bindings));
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeUpdateScript(Path filePath, Map<String, Object> bindings) {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        if (engine == null) {
            engine = new ScriptEngineManager().getEngineByExtension("js");
        }
        if (engine != null) {
            LOG.info("Executing update script ''{}''...", (Object)filePath);
            Bindings b = engine.createBindings();
            b.putAll((Map<? extends String, ? extends Object>)bindings);
            engine.setBindings(b, 100);
            FileReader fr = null;
            try {
                fr = new FileReader(filePath.toFile());
                engine.eval(fr);
            }
            catch (FileNotFoundException | ScriptException ex) {
                LOG.error("Could not evaluate update script file ''{}''!", (Object)filePath, (Object)ex);
            }
            finally {
                try {
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

