/*
 * Decompiled with CFR 0.152.
 */
package de.dimaki.refuel.updater.control;

import java.util.Comparator;

public class VersionComparator
implements Comparator<String> {
    private static final String VERSION_SEPARATOR = "\\.";
    private static final String QUALIFIER_SEPARATOR = "-";

    @Override
    public int compare(String localVersion, String remoteVersion) {
        String local = null;
        String qualifierLocal = null;
        String remote = null;
        String qualifierRemote = null;
        int qualifierIndexLocal = localVersion.indexOf(QUALIFIER_SEPARATOR);
        int qualifierIndexRemote = remoteVersion.indexOf(QUALIFIER_SEPARATOR);
        if (qualifierIndexLocal > 0) {
            qualifierLocal = localVersion.substring(qualifierIndexLocal + 1);
            local = localVersion.substring(0, qualifierIndexLocal);
        } else {
            local = localVersion;
        }
        if (qualifierIndexRemote > 0) {
            qualifierRemote = remoteVersion.substring(qualifierIndexRemote + 1);
            remote = remoteVersion.substring(0, qualifierIndexRemote);
        } else {
            remote = remoteVersion;
        }
        String[] p1 = local.split(VERSION_SEPARATOR);
        String[] p2 = remote.split(VERSION_SEPARATOR);
        int n = Math.min(p1.length, p2.length);
        for (int i = 0; i < n; ++i) {
            try {
                int a1 = Integer.parseInt(p1[i]);
                int a2 = Integer.parseInt(p2[i]);
                if (a1 < a2) {
                    return -1;
                }
                if (a1 <= a2) continue;
                return 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (Math.max(p1.length, p2.length) > n) {
            if (p1.length > p2.length) {
                return 1;
            }
            if (p1.length < p2.length) {
                return -1;
            }
        }
        if (qualifierLocal != null) {
            if (qualifierRemote == null || qualifierRemote.isEmpty()) {
                return -1;
            }
        } else if (qualifierRemote != null) {
            return 1;
        }
        return 0;
    }
}

