// Instruction handlers for the m68000 (direct, full, mcu)
//
// Generated by m68000gen.py sdfm m68000.lst m68000mcu-sdfm.cpp

#include "emu.h"
#include "m68000mcu.h"

void m68000_mcu_device::state_reset_dfm()
{
	// 002 rstp3
	m_icount -= 2;
	// 296 rstp4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_ftu_const();
	m_icount -= 2;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 27e rstp5
	debugger_exception_hook(0x00);
	m_ftu = 0x0000;
	m_icount -= 2;
	// 27f rstp6
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_sr |= 0x0700;
	update_interrupt();
	m_au = ext32(m_ftu);
	m_icount -= 2;
	// 2fb rstp7
	m_aob = m_au;
	set_16h(m_da[16], m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2ff rstp8
	m_aob = m_au;
	set_16h(m_da[16], m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 300 rstp9
	m_aob = m_au;
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	set_16l(m_da[16], m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 11e rstpa
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::state_bus_error_dfm()
{
	// 003 bser1
	m_ssw = m_base_ssw | (m_sr & SR_S ? SSW_S : 0);
	m_at = m_aob;
	m_ftu = m_sr;
	m_au = m_pc;
	m_icount -= 2;
	// 3a7 bser2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3ca bser3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 0a2 bser4
	m_aob = m_au;
	m_dbout = m_aluo;
	m_ftu = m_ird;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3c6 bser5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 088 bser6
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_pc = m_at;
	m_ftu = (m_ftu & ~0x1f) | m_ssw;
	m_au = m_au - 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=11:m_at d=-1
	alu_and(m_at, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x02);
	m_da[16] = m_au;
	m_ftu = 0x0008;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N | SSW_CRITICAL;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N | SSW_CRITICAL;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::state_address_error_dfm()
{
	// 003 bser1
	m_ssw = m_base_ssw | (m_sr & SR_S ? SSW_S : 0);
	m_at = m_aob;
	m_ftu = m_sr;
	m_au = m_pc;
	m_icount -= 2;
	// 3a7 bser2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3ca bser3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 0a2 bser4
	m_aob = m_au;
	m_dbout = m_aluo;
	m_ftu = m_ird;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3c6 bser5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 088 bser6
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_pc = m_at;
	m_ftu = (m_ftu & ~0x1f) | m_ssw;
	m_au = m_au - 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=11:m_at d=-1
	alu_and(m_at, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x03);
	m_da[16] = m_au;
	m_ftu = 0x000c;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N | SSW_CRITICAL;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N | SSW_CRITICAL;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N | SSW_CRITICAL;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N | SSW_CRITICAL;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 19;
		} else
			m_inst_substate = 20;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 21;
		} else
			m_inst_substate = 22;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::state_double_fault_dfm()
{
	// 001 halt1
	m_icount = m_bcount;
}

void m68000_mcu_device::state_interrupt_dfm()
{
	// 1c4 itlx1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 234 itlx2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_alub = m_ftu;
	m_pc = m_au;
	m_sr = (m_sr & ~SR_I) | ((m_next_state >> 16) & SR_I);
	update_interrupt();
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_icount -= 2;
	// 235 itlx3
	m_ftu = 0xfff0 | ((m_next_state >> 23) & 0xe);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	// 0eb itlx4
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 236 itlx5
	m_aob = m_at;
	m_base_ssw = SSW_CPU | SSW_R | SSW_N;
	start_interrupt_vector_lookup();
	m_edb = m_cpu_space.read_interruptible(m_aob);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	end_interrupt_vector_lookup();
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 118 itlx6
	m_ir = m_irc;
	m_icount -= 2;
	// 292 itlx7
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_ftu_const();
	m_icount -= 2;
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook((m_int_vector) >> 2);
	m_da[16] = m_au;
	m_ftu = m_int_vector;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::state_trace_dfm()
{
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x09);
	m_da[16] = m_au;
	m_ftu = 0x0024;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::state_illegal_dfm()
{
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x04);
	m_da[16] = m_au;
	m_ftu = 0x0010;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::state_priviledge_dfm()
{
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x08);
	m_da[16] = m_au;
	m_ftu = 0x0020;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::state_linea_dfm()
{
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x0a);
	m_da[16] = m_au;
	m_ftu = 0x0028;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::state_linef_dfm()
{
	// 1c0 trac1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	m_icount -= 2;
	// 3a3 trac2
	m_sr = (m_sr & ~SR_T) | SR_S;
	update_user_super();
	update_interrupt();
	m_pc = m_au;
	// alu r=0 c=1 m=.....  i=....... 1 a=10:m_au d=-1
	alu_and(m_au, 0xffff);
	m_au = m_da[16] - 2;
	m_icount -= 2;
	if(m_next_state == S_TRACE)
		m_next_state = 0;
	// 3c2 trap3
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=37:m_ftu d=-1
	alu_and(m_ftu, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 360 trap4
	m_aob = m_au;
	m_dbout = m_aluo;
	debugger_exception_hook(0x0b);
	m_da[16] = m_au;
	m_ftu = 0x002c;
	m_au = m_au + 2;
	// alu r=0 c=1 m=.....  i=....... 1 a=26:m_pc d=-1
	alu_and(high16(m_pc), 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 0ef trap5
	m_aob = m_au;
	m_dbout = m_aluo;
	m_at = ext32(m_ftu);
	m_au = m_au - 4;
	// alu r=0 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_N;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 367 trap6
	m_aob = m_at;
	m_pc = m_at;
	m_au = m_at + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 11a trap7
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R | SSW_N;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b7 trap8
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin) + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 11c trap9
	m_icount -= 2;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R | SSW_N;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_b_imm8_ds_dfm() // 0000 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=4:m_da[ry]
	alu_or8(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_b_imm8_ais_dfm() // 0010 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_b_imm8_aips_dfm() // 0018 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_b_imm8_pais_dfm() // 0020 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_b_imm8_das_dfm() // 0028 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_b_imm8_dais_dfm() // 0030 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=b...... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_b_imm8_adr16_dfm() // 0038 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_b_imm8_adr32_dfm() // 0039 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=b....i. 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_imm8_ccr_dfm() // 003c ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=14 c=2 m=.....  i=b...... 8 a=37:m_ftu d=9:m_dt
	alu_or8(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=33:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = (m_ftu & SR_CCR) | (m_sr & SR_SR);
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_w_imm16_ds_dfm() // 0040 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=4:m_da[ry]
	alu_or(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_w_imm16_ais_dfm() // 0050 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_w_imm16_aips_dfm() // 0058 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_w_imm16_pais_dfm() // 0060 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_w_imm16_das_dfm() // 0068 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_w_imm16_dais_dfm() // 0070 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=....... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_w_imm16_adr16_dfm() // 0078 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_w_imm16_adr32_dfm() // 0079 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.....i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_i16u_sr_dfm() // 007c ffff
{
	if(!(m_sr & SR_S)) {
		m_inst_state = S_PRIVILEDGE;
		return;
	}
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=14 c=2 m=.....  i=....... 8 a=37:m_ftu d=9:m_dt
	alu_or(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=33:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = m_ftu & (SR_CCR|SR_SR);
	update_user_super();
	update_interrupt();
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_l_imm32_ds_dfm() // 0080 fff8
{
	int ry = m_irdi & 7;
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=4:m_da[ry]
	alu_or(m_dt, m_da[ry]);
	sr_nzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=0 m=.....  i=.l..... 8 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=18:m_da[ry]
	alu_or(high16(m_dt), high16(m_da[ry]));
	sr_nzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=33:m_aluo d=none
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_l_imm32_ais_dfm() // 0090 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_l_imm32_aips_dfm() // 0098 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_l_imm32_pais_dfm() // 00a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_l_imm32_das_dfm() // 00a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_l_imm32_dais_dfm() // 00b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=14 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=.l..... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_l_imm32_adr16_dfm() // 00b8 ffff
{
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=.l..... 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::ori_l_imm32_adr32_dfm() // 00b9 ffff
{
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=.l..... 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=14 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=14 c=2 m=.nzvc  i=.l...i. 8 a=9:m_dt d=31:m_dbin
	alu_or(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=14 c=3 m=.nzvc  i=.l....f 8 a=23:m_dt d=29:m_alue
	alu_or(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_dd_ds_dfm() // 0100 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	// 3e7 btsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = m_da[rx];
	m_au = m_da[ry];
	// alu r=13 c=0 m=.....  i=....... 9 a=2:m_da[rx] d=4:m_da[ry]
	alu_eor(m_da[rx], m_da[ry]);
	// 0e7 btsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... 1 a=4:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto btsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
btsr3:
	// 044 btsr3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=18:m_da[ry] d=35:m_dcro
	alu_and(high16(m_da[ry]), 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movep_w_das_dd_dfm() // 0108 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1d2 mpiw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 29a mpiw2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	set_8h(m_dbin, m_edb);
	// 368 mpiw3
	m_aob = m_au;
	m_ir = m_irc;
	m_au = m_pc + 4;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_8(m_dbin, m_edb);
	// 36a mpiw4
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_dd_ais_dfm() // 0110 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_dd_aips_dfm() // 0118 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_dd_pais_dfm() // 0120 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_dd_das_dfm() // 0128 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_dd_dais_dfm() // 0130 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_dd_adr16_dfm() // 0138 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_dd_adr32_dfm() // 0139 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_dd_dpc_dfm() // 013a f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_dd_dpci_dfm() // 013b f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_dd_imm_dfm() // 013c f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 0ab btsi1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16h(m_dt, high16(m_at));
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	// 0e7 btsr2
	m_t = m_dcr & 0x10;
	m_alub = m_dt;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=9:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto btsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_dt, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
btsr3:
	// 044 btsr3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=23:m_dt d=36:m_dcro8
	alu_and8(high16(m_dt), 1 << (m_dcr & 7));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_dd_ds_dfm() // 0140 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	// 3ef bcsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = m_da[rx];
	m_au = m_da[ry];
	// alu r=13 c=0 m=.....  i=....... 9 a=2:m_da[rx] d=4:m_da[ry]
	alu_eor(m_da[rx], m_da[ry]);
	// 06a bcsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=13 c=2 m=.....  i=....... 9 a=4:m_da[ry] d=35:m_dcro
	alu_eor(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bcsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bcsr3:
	// 084 bcsr3
	m_alub = high16(m_da[ry]);
	// alu r=13 c=2 m=.....  i=....... 9 a=18:m_da[ry] d=35:m_dcro
	alu_eor(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movep_l_das_dd_dfm() // 0148 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1d6 mpil1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 29e mpil2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	set_8h(m_dbin, m_edb);
	// 34e mpil3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_8(m_dbin, m_edb);
	// 34f mpil4
	m_aob = m_au;
	set_16h(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_8h(m_dbin, m_edb);
	// 368 mpiw3
	m_aob = m_au;
	m_ir = m_irc;
	m_au = m_pc + 4;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_8(m_dbin, m_edb);
	// 36a mpiw4
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_dd_ais_dfm() // 0150 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_dd_aips_dfm() // 0158 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_dd_pais_dfm() // 0160 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_dd_das_dfm() // 0168 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_dd_dais_dfm() // 0170 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_dd_adr16_dfm() // 0178 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_dd_adr32_dfm() // 0179 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=2:m_da[rx] d=31:m_dbin
	alu_eor8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_dd_ds_dfm() // 0180 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	// 3eb bclr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = m_da[rx];
	m_au = m_da[ry];
	// alu r=14 c=0 m=.....  i=.l..... 8 a=2:m_da[rx] d=4:m_da[ry]
	alu_or(m_da[rx], m_da[ry]);
	// 06e bclr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=14 c=2 m=.....  i=.l..... 8 a=4:m_da[ry] d=35:m_dcro
	alu_or(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bclr3;
	else
		goto bclr4;
bclr4:
	// 0cc bclr4
	// alu r=14 c=4 m=.....  i=.l..... 9 a=33:m_aluo d=35:m_dcro
	alu_eor(m_aluo, 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.l...i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bclr3:
	// 08c bclr3
	m_alub = high16(m_da[ry]);
	// alu r=14 c=2 m=.....  i=.l..... 8 a=18:m_da[ry] d=35:m_dcro
	alu_or(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0c8 bclr5
	// alu r=14 c=4 m=.....  i=.l..... 9 a=33:m_aluo d=35:m_dcro
	alu_eor(m_aluo, 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.l...i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movep_w_dd_das_dfm() // 0188 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1ca mpow1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 36d mpow2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xh(m_dbout, m_da[rx]);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=2:m_da[rx]
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	// 36e mpow3
	m_aob = m_au;
	set_8xl(m_dbout, m_da[rx]);
	m_au = m_pc + 4;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_dd_ais_dfm() // 0190 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_dd_aips_dfm() // 0198 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_dd_pais_dfm() // 01a0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_dd_das_dfm() // 01a8 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=bl..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_dd_dais_dfm() // 01b0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=bl..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_dd_adr16_dfm() // 01b8 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_dd_adr32_dfm() // 01b9 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_dd_ds_dfm() // 01c0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	// 3ef bcsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = m_da[rx];
	m_au = m_da[ry];
	// alu r=14 c=0 m=.....  i=....... 8 a=2:m_da[rx] d=4:m_da[ry]
	alu_or(m_da[rx], m_da[ry]);
	// 06a bcsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=14 c=2 m=.....  i=....... 8 a=4:m_da[ry] d=35:m_dcro
	alu_or(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bcsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bcsr3:
	// 084 bcsr3
	m_alub = high16(m_da[ry]);
	// alu r=14 c=2 m=.....  i=....... 8 a=18:m_da[ry] d=35:m_dcro
	alu_or(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movep_l_dd_das_dfm() // 01c8 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1ce mpol1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 36b mpol2
	m_aob = m_au;
	set_8xh(m_dbout, high16(m_da[rx]));
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=16:m_da[rx] d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	// 36c mpol3
	m_aob = m_au;
	set_8xl(m_dbout, high16(m_da[rx]));
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=16:m_da[rx] d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 36d mpow2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xh(m_dbout, m_da[rx]);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=2:m_da[rx]
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	// 36e mpow3
	m_aob = m_au;
	set_8xl(m_dbout, m_da[rx]);
	m_au = m_pc + 4;
	// alu r=14 c=0 m=.....  i=....... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=14 c=0 m=.....  i=....... 8 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_dd_ais_dfm() // 01d0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_dd_aips_dfm() // 01d8 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_dd_pais_dfm() // 01e0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_dd_das_dfm() // 01e8 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_dd_dais_dfm() // 01f0 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=b...... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_dd_adr16_dfm() // 01f8 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_dd_adr32_dfm() // 01f9 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=b...... 8 a=2:m_da[rx] d=31:m_dbin
	alu_or8(m_da[rx], m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_b_imm8_ds_dfm() // 0200 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=4:m_da[ry]
	alu_and8(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_b_imm8_ais_dfm() // 0210 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=4 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_b_imm8_aips_dfm() // 0218 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_b_imm8_pais_dfm() // 0220 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=4 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_b_imm8_das_dfm() // 0228 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_b_imm8_dais_dfm() // 0230 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=4 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=4 c=0 m=.....  i=b...... 1 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_b_imm8_adr16_dfm() // 0238 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_b_imm8_adr32_dfm() // 0239 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=4 c=0 m=.....  i=b...... 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=b....i. 1 a=9:m_dt d=31:m_dbin
	alu_and8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_imm8_ccr_dfm() // 023c ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=4 c=2 m=.....  i=b...... 1 a=37:m_ftu d=9:m_dt
	alu_and8(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=33:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = (m_ftu & SR_CCR) | (m_sr & SR_SR);
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=4 c=0 m=.....  i=b...... 1 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_w_imm16_ds_dfm() // 0240 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=4:m_da[ry]
	alu_and(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_w_imm16_ais_dfm() // 0250 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=4 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_w_imm16_aips_dfm() // 0258 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_w_imm16_pais_dfm() // 0260 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=4 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_w_imm16_das_dfm() // 0268 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_w_imm16_dais_dfm() // 0270 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=4 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=4 c=0 m=.....  i=....... 1 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_w_imm16_adr16_dfm() // 0278 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_w_imm16_adr32_dfm() // 0279 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=4 c=0 m=.....  i=....... 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=4 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.....i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_i16u_sr_dfm() // 027c ffff
{
	if(!(m_sr & SR_S)) {
		m_inst_state = S_PRIVILEDGE;
		return;
	}
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=4 c=2 m=.....  i=....... 1 a=37:m_ftu d=9:m_dt
	alu_and(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=33:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = m_ftu & (SR_CCR|SR_SR);
	update_user_super();
	update_interrupt();
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=4 c=0 m=.....  i=....... 1 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_l_imm32_ds_dfm() // 0280 fff8
{
	int ry = m_irdi & 7;
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=4:m_da[ry]
	alu_and(m_dt, m_da[ry]);
	sr_nzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	// alu r=4 c=0 m=.....  i=.l..... 1 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=18:m_da[ry]
	alu_and(high16(m_dt), high16(m_da[ry]));
	sr_nzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=33:m_aluo d=none
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_l_imm32_ais_dfm() // 0290 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_l_imm32_aips_dfm() // 0298 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_l_imm32_pais_dfm() // 02a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_l_imm32_das_dfm() // 02a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_l_imm32_dais_dfm() // 02b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=4 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=4 c=0 m=.....  i=.l..... 1 a=33:m_aluo d=none
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_l_imm32_adr16_dfm() // 02b8 ffff
{
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=4 c=0 m=.....  i=.l..... 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::andi_l_imm32_adr32_dfm() // 02b9 ffff
{
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=4 c=0 m=.....  i=.l..... 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=4 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=4 c=2 m=.nzvc  i=.l...i. 1 a=9:m_dt d=31:m_dbin
	alu_and(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=4 c=3 m=.nzvc  i=.l....f 1 a=23:m_dt d=29:m_alue
	alu_and(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=4 c=0 m=.....  i=.l..... 1 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_b_imm8_ds_dfm() // 0400 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=4:m_da[ry]
	alu_sub8(m_dt, m_da[ry]);
	sr_xnzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_b_imm8_ais_dfm() // 0410 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=5 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_b_imm8_aips_dfm() // 0418 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_b_imm8_pais_dfm() // 0420 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=5 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_b_imm8_das_dfm() // 0428 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=5 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_b_imm8_dais_dfm() // 0430 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=5 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=5 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_b_imm8_adr16_dfm() // 0438 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_b_imm8_adr32_dfm() // 0439 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_w_imm16_ds_dfm() // 0440 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=4:m_da[ry]
	alu_sub(m_dt, m_da[ry]);
	sr_xnzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_w_imm16_ais_dfm() // 0450 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=5 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_w_imm16_aips_dfm() // 0458 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_w_imm16_pais_dfm() // 0460 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=5 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_w_imm16_das_dfm() // 0468 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=5 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_w_imm16_dais_dfm() // 0470 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=5 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=5 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_w_imm16_adr16_dfm() // 0478 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_w_imm16_adr32_dfm() // 0479 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=5 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_l_imm32_ds_dfm() // 0480 fff8
{
	int ry = m_irdi & 7;
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=4:m_da[ry]
	alu_sub(m_dt, m_da[ry]);
	sr_xnzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=18:m_da[ry]
	alu_subc(high16(m_dt), high16(m_da[ry]));
	sr_xnzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_l_imm32_ais_dfm() // 0490 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_l_imm32_aips_dfm() // 0498 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_l_imm32_pais_dfm() // 04a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_l_imm32_das_dfm() // 04a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_l_imm32_dais_dfm() // 04b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=5 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_l_imm32_adr16_dfm() // 04b8 ffff
{
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::subi_l_imm32_adr32_dfm() // 04b9 ffff
{
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=5 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=5 c=2 m=xnzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=5 c=3 m=xnzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_b_imm8_ds_dfm() // 0600 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=4:m_da[ry]
	alu_add8(m_dt, m_da[ry]);
	sr_xnzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_b_imm8_ais_dfm() // 0610 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_b_imm8_aips_dfm() // 0618 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_b_imm8_pais_dfm() // 0620 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_b_imm8_das_dfm() // 0628 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_b_imm8_dais_dfm() // 0630 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_b_imm8_adr16_dfm() // 0638 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_b_imm8_adr32_dfm() // 0639 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=b....i. 4 a=9:m_dt d=31:m_dbin
	alu_add8(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_w_imm16_ds_dfm() // 0640 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=4:m_da[ry]
	alu_add(m_dt, m_da[ry]);
	sr_xnzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_w_imm16_ais_dfm() // 0650 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_w_imm16_aips_dfm() // 0658 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_w_imm16_pais_dfm() // 0660 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_w_imm16_das_dfm() // 0668 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_w_imm16_dais_dfm() // 0670 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_w_imm16_adr16_dfm() // 0678 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_w_imm16_adr32_dfm() // 0679 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.....i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_l_imm32_ds_dfm() // 0680 fff8
{
	int ry = m_irdi & 7;
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=4:m_da[ry]
	alu_add(m_dt, m_da[ry]);
	sr_xnzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=18:m_da[ry]
	alu_addc(high16(m_dt), high16(m_da[ry]));
	sr_xnzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_l_imm32_ais_dfm() // 0690 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_l_imm32_aips_dfm() // 0698 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_l_imm32_pais_dfm() // 06a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_l_imm32_das_dfm() // 06a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_l_imm32_dais_dfm() // 06b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=2 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_l_imm32_adr16_dfm() // 06b8 ffff
{
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::addi_l_imm32_adr32_dfm() // 06b9 ffff
{
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=2 c=2 m=xnzvc  i=.l...i. 4 a=9:m_dt d=31:m_dbin
	alu_add(m_dt, m_dbin);
	sr_xnzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=3 m=xnzvc  i=.l....f 11 a=23:m_dt d=29:m_alue
	alu_addc(high16(m_dt), m_alue);
	sr_xnzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_imm8_ds_dfm() // 0800 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 3e7 btsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = m_dt;
	m_au = m_da[ry];
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=4:m_da[ry]
	alu_eor(m_dt, m_da[ry]);
	// 0e7 btsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... 1 a=4:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto btsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
btsr3:
	// 044 btsr3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=18:m_da[ry] d=35:m_dcro
	alu_and(high16(m_da[ry]), 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_imm8_ais_dfm() // 0810 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_imm8_aips_dfm() // 0818 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_imm8_pais_dfm() // 0820 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_imm8_das_dfm() // 0828 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_imm8_dais_dfm() // 0830 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_imm8_adr16_dfm() // 0838 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_imm8_adr32_dfm() // 0839 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_imm8_dpc_dfm() // 083a ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::btst_imm8_dpci_dfm() // 083b ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 215 btsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=31:m_dbin d=36:m_dcro8
	alu_and8(m_dbin, 1 << (m_dcr & 7));
	sr_z();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_imm8_ds_dfm() // 0840 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 3ef bcsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = m_dt;
	m_au = m_da[ry];
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=4:m_da[ry]
	alu_eor(m_dt, m_da[ry]);
	// 06a bcsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=13 c=2 m=.....  i=....... 9 a=4:m_da[ry] d=35:m_dcro
	alu_eor(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bcsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bcsr3:
	// 084 bcsr3
	m_alub = high16(m_da[ry]);
	// alu r=13 c=2 m=.....  i=....... 9 a=18:m_da[ry] d=35:m_dcro
	alu_eor(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=13 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_imm8_ais_dfm() // 0850 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_imm8_aips_dfm() // 0858 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_imm8_pais_dfm() // 0860 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_imm8_das_dfm() // 0868 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_imm8_dais_dfm() // 0870 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_imm8_adr16_dfm() // 0878 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bchg_imm8_adr32_dfm() // 0879 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=2 m=.....  i=b...... 9 a=31:m_dbin d=36:m_dcro8
	alu_eor8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=13 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_imm8_ds_dfm() // 0880 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=.l..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 3eb bclr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = m_dt;
	m_au = m_da[ry];
	// alu r=14 c=0 m=.....  i=.l..... 8 a=9:m_dt d=4:m_da[ry]
	alu_or(m_dt, m_da[ry]);
	// 06e bclr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=14 c=2 m=.....  i=.l..... 8 a=4:m_da[ry] d=35:m_dcro
	alu_or(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bclr3;
	else
		goto bclr4;
bclr4:
	// 0cc bclr4
	// alu r=14 c=4 m=.....  i=.l..... 9 a=33:m_aluo d=35:m_dcro
	alu_eor(m_aluo, 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.l...i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bclr3:
	// 08c bclr3
	m_alub = high16(m_da[ry]);
	// alu r=14 c=2 m=.....  i=.l..... 8 a=18:m_da[ry] d=35:m_dcro
	alu_or(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0c8 bclr5
	// alu r=14 c=4 m=.....  i=.l..... 9 a=33:m_aluo d=35:m_dcro
	alu_eor(m_aluo, 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.l...i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_imm8_ais_dfm() // 0890 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_imm8_aips_dfm() // 0898 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_imm8_pais_dfm() // 08a0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_imm8_das_dfm() // 08a8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=bl..... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_imm8_dais_dfm() // 08b0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=bl..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_imm8_adr16_dfm() // 08b8 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bclr_imm8_adr32_dfm() // 08b9 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=bl..... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=bl..... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	m_dbin = m_edb;
	// 069 bclm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_ftu = m_sr;
	// alu r=14 c=2 m=.....  i=bl..... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	// 067 bclm2
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=4 m=.....  i=bl..... 9 a=33:m_aluo d=36:m_dcro8
	alu_eor8(m_aluo, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=bl...i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_imm8_ds_dfm() // 08c0 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=....... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 3ef bcsr1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = m_dt;
	m_au = m_da[ry];
	// alu r=14 c=0 m=.....  i=....... 8 a=9:m_dt d=4:m_da[ry]
	alu_or(m_dt, m_da[ry]);
	// 06a bcsr2
	m_t = m_dcr & 0x10;
	m_alub = m_da[ry];
	m_au = m_pc + 2;
	// alu r=14 c=2 m=.....  i=....... 8 a=4:m_da[ry] d=35:m_dcro
	alu_or(m_da[ry], 1 << (m_dcr & 15));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	if(m_t)
		goto bcsr3;
	else
		goto bcsr4;
bcsr4:
	// 0c4 bcsr4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
bcsr3:
	// 084 bcsr3
	m_alub = high16(m_da[ry]);
	// alu r=14 c=2 m=.....  i=....... 8 a=18:m_da[ry] d=35:m_dcro
	alu_or(high16(m_da[ry]), 1 << (m_dcr & 15));
	m_icount -= 2;
	// 0a1 bcsr5
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	// alu r=14 c=1 m=..z..  i=.....i. 1 a=alub d=35:m_dcro
	alu_and(m_alub, 1 << (m_dcr & 15));
	sr_z();
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_imm8_ais_dfm() // 08d0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_imm8_aips_dfm() // 08d8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_imm8_pais_dfm() // 08e0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=14 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_imm8_das_dfm() // 08e8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_imm8_dais_dfm() // 08f0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=14 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=14 c=0 m=.....  i=b...... 8 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=14 c=0 m=.....  i=b...... 8 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_imm8_adr16_dfm() // 08f8 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::bset_imm8_adr32_dfm() // 08f9 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=14 c=0 m=.....  i=b...... 8 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=14 c=0 m=.....  i=b...... 8 a=9:m_dt d=31:m_dbin
	alu_or8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=14 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	m_dbin = m_edb;
	// 081 bcsm1
	m_aob = m_au;
	m_ir = m_irc;
	m_alub = m_dbin;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=14 c=2 m=.....  i=b...... 8 a=31:m_dbin d=36:m_dcro8
	alu_or8(m_dbin, 1 << (m_dcr & 7));
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 082 bcsm2
	m_aob = m_at;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	// alu r=14 c=1 m=..z..  i=b....i. 1 a=alub d=36:m_dcro8
	alu_and8(m_alub, 1 << (m_dcr & 7));
	sr_z();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_b_imm8_ds_dfm() // 0a00 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=4:m_da[ry]
	alu_eor8(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_b_imm8_ais_dfm() // 0a10 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_b_imm8_aips_dfm() // 0a18 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_b_imm8_pais_dfm() // 0a20 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_b_imm8_das_dfm() // 0a28 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_b_imm8_dais_dfm() // 0a30 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_b_imm8_adr16_dfm() // 0a38 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_b_imm8_adr32_dfm() // 0a39 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=b...... 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=b....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor8(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_imm8_ccr_dfm() // 0a3c ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=13 c=2 m=.....  i=b...... 9 a=37:m_ftu d=9:m_dt
	alu_eor8(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=33:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = (m_ftu & SR_CCR) | (m_sr & SR_SR);
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=b...... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_w_imm16_ds_dfm() // 0a40 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 100 roaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=4:m_da[ry]
	alu_eor(m_dt, m_da[ry]);
	sr_nzvc();
	// 08b roaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16l(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_w_imm16_ais_dfm() // 0a50 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=13 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_w_imm16_aips_dfm() // 0a58 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_w_imm16_pais_dfm() // 0a60 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=13 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_w_imm16_das_dfm() // 0a68 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_w_imm16_dais_dfm() // 0a70 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=13 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=....... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_w_imm16_adr16_dfm() // 0a78 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_w_imm16_adr32_dfm() // 0a79 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=....... 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=13 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 299 morw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.....i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_i16u_sr_dfm() // 0a7c ffff
{
	if(!(m_sr & SR_S)) {
		m_inst_state = S_PRIVILEDGE;
		return;
	}
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1cc stiw1
	m_ftu = m_sr;
	m_au = m_pc - 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_icount -= 2;
	// 307 stiw2
	// alu r=13 c=2 m=.....  i=....... 9 a=37:m_ftu d=9:m_dt
	alu_eor(m_ftu, m_dt);
	m_icount -= 2;
	// 320 stiw3
	m_movemr = m_dbin;
	m_ftu = m_aluo;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=33:m_aluo d=none
	m_icount -= 2;
	// 321 stiw4
	m_sr = m_isr = m_ftu & (SR_CCR|SR_SR);
	update_user_super();
	update_interrupt();
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_icount -= 2;
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=13 c=0 m=.....  i=....... 9 a=none d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_l_imm32_ds_dfm() // 0a80 fff8
{
	int ry = m_irdi & 7;
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 10c roal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=4:m_da[ry]
	alu_eor(m_dt, m_da[ry]);
	sr_nzvc();
	// 259 roal2
	set_16l(m_da[ry], m_aluo);
	// alu r=13 c=0 m=.....  i=.l..... 9 a=33:m_aluo d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 25a roal3
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=18:m_da[ry]
	alu_eor(high16(m_dt), high16(m_da[ry]));
	sr_nzvc_u();
	m_icount -= 2;
	// 25b roal4
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[ry], m_aluo);
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=33:m_aluo d=none
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_l_imm32_ais_dfm() // 0a90 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_l_imm32_aips_dfm() // 0a98 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_l_imm32_pais_dfm() // 0aa0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_l_imm32_das_dfm() // 0aa8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_l_imm32_dais_dfm() // 0ab0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=13 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	// alu r=13 c=0 m=.....  i=.l..... 9 a=33:m_aluo d=none
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=5:m_da[map_sp(m_irc >> 12)]
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_l_imm32_adr16_dfm() // 0ab8 ffff
{
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	// alu r=13 c=0 m=.....  i=.l..... 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::eori_l_imm32_adr32_dfm() // 0ab9 ffff
{
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=31:m_dbin d=none
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=13 c=0 m=.....  i=.l..... 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=13 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=31:m_dbin
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29d morl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_at;
	// alu r=13 c=2 m=.nzvc  i=.l...i. 9 a=9:m_dt d=31:m_dbin
	alu_eor(m_dt, m_dbin);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34d morl2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=13 c=3 m=.nzvc  i=.l....f 9 a=23:m_dt d=29:m_alue
	alu_eor(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 15;
		} else
			m_inst_substate = 16;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 38d morw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_au = m_pc + 2;
	// alu r=13 c=0 m=.....  i=.l..... 9 a=none d=none
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 17;
		} else
			m_inst_substate = 18;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_b_imm8_ds_dfm() // 0c00 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 108 rcaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=4:m_da[ry]
	alu_sub8(m_dt, m_da[ry]);
	sr_nzvc();
	// 23a rcaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_b_imm8_ais_dfm() // 0c10 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=6 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_b_imm8_aips_dfm() // 0c18 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_b_imm8_pais_dfm() // 0c20 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=6 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_b_imm8_das_dfm() // 0c28 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=6 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_b_imm8_dais_dfm() // 0c30 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=6 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=6 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_b_imm8_adr16_dfm() // 0c38 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_b_imm8_adr32_dfm() // 0c39 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=b....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub8(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_w_imm16_ds_dfm() // 0c40 fff8
{
	int ry = m_irdi & 7;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 108 rcaw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=4:m_da[ry]
	alu_sub(m_dt, m_da[ry]);
	sr_nzvc();
	// 23a rcaw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_w_imm16_ais_dfm() // 0c50 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=6 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_w_imm16_aips_dfm() // 0c58 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_dt;
	m_at = m_da[ry];
	m_au = m_da[ry] + 2;
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_w_imm16_pais_dfm() // 0c60 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_dt;
	m_au = m_da[ry] - 2;
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=6 c=1 m=.....  i=....... 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_w_imm16_das_dfm() // 0c68 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=6 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_w_imm16_dais_dfm() // 0c70 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e3 aixl0
	// alu r=6 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=6 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_dt;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_w_imm16_adr16_dfm() // 0c78 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_w_imm16_adr32_dfm() // 0c79 ffff
{
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=6 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 087 cpdw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.....i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_l_imm32_ds_dfm() // 0c80 fff8
{
	int ry = m_irdi & 7;
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	if(!m_cmpild_instr_callback.isnull()) (m_cmpild_instr_callback)(ry, (m_dt & 0xffff0000) | m_dbin);
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 104 rcal1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=4:m_da[ry]
	alu_sub(m_dt, m_da[ry]);
	sr_nzvc();
	// 239 rcal2
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=18:m_da[ry]
	alu_subc(high16(m_dt), high16(m_da[ry]));
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 08d rcal3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_au = m_pc + 2;
	set_ftu_const();
	m_icount -= 2;
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_l_imm32_ais_dfm() // 0c90 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_l_imm32_aips_dfm() // 0c98 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_l_imm32_pais_dfm() // 0ca0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_l_imm32_das_dfm() // 0ca8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_l_imm32_dais_dfm() // 0cb0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e7 aixw0
	// alu r=6 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_l_imm32_adr16_dfm() // 0cb8 ffff
{
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::cmpi_l_imm32_adr32_dfm() // 0cb9 ffff
{
	// 3e0 o#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2b9 o#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_dt;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=6 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 08f cpdl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=6 c=2 m=.nzvc  i=.l...i. 2 a=9:m_dt d=31:m_dbin
	alu_sub(m_dt, m_dbin);
	sr_nzvc();
	// 171 cpdl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=6 c=3 m=.nzvc  i=.l....f 10 a=23:m_dt d=29:m_alue
	alu_subc(high16(m_dt), m_alue);
	sr_nzvc_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ds_dd_dfm() // 1000 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	// 121 rrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_da[ry];
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=4:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	// 27a rrgw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[rx], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ais_dd_dfm() // 1010 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_aips_dd_dfm() // 1018 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = m_da[rx];
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_pais_dd_dfm() // 1020 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_das_dd_dfm() // 1028 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dais_dd_dfm() // 1030 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr16_dd_dfm() // 1038 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr32_dd_dfm() // 1039 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpc_dd_dfm() // 103a f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpci_dd_dfm() // 103b f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = m_da[rx];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 29b mrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_8(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_imm8_dd_dfm() // 103c f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 121 rrgw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_dt;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=9:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	// 27a rrgw2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8(m_da[rx], m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ds_aid_dfm() // 1080 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	// 2fa rmrw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_da[ry]);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=4:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ais_aid_dfm() // 1090 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_aips_aid_dfm() // 1098 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_pais_aid_dfm() // 10a0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_das_aid_dfm() // 10a8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dais_aid_dfm() // 10b0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr16_aid_dfm() // 10b8 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr32_aid_dfm() // 10b9 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpc_aid_dfm() // 10ba f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpci_aid_dfm() // 10bb f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 3ab mmrw1
	m_aob = m_da[rx];
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_imm8_aid_dfm() // 10bc f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 2fa rmrw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dt);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=9:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ds_aipd_dfm() // 10c0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	// 2fe rmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_da[ry]);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=4:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ais_aipd_dfm() // 10d0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_aips_aipd_dfm() // 10d8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_pais_aipd_dfm() // 10e0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_das_aipd_dfm() // 10e8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dais_aipd_dfm() // 10f0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr16_aipd_dfm() // 10f8 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr32_aipd_dfm() // 10f9 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpc_aipd_dfm() // 10fa f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpci_aipd_dfm() // 10fb f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 3af mmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dbin);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_imm8_aipd_dfm() // 10fc f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 2fe rmiw1
	m_aob = m_da[rx];
	m_ir = m_irc;
	set_8xl(m_dbout, m_dt);
	m_pc = m_au;
	m_au = m_da[rx] + (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=9:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ds_paid_dfm() // 1100 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	// 2f8 rmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=4:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ais_paid_dfm() // 1110 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_aips_paid_dfm() // 1118 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_pais_paid_dfm() // 1120 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_das_paid_dfm() // 1128 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dais_paid_dfm() // 1130 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr16_paid_dfm() // 1138 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr32_paid_dfm() // 1139 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpc_paid_dfm() // 113a f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpci_paid_dfm() // 113b f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 38b mmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_imm8_paid_dfm() // 113c f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 2f8 rmmw1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - (rx < 15 ? 1 : 2);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=9:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ds_dad_dfm() // 1140 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	// 2da rmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_dbin) + m_da[rx];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 2db rmdw2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xl(m_dbout, m_da[ry]);
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=4:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ais_dad_dfm() // 1150 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_aips_dad_dfm() // 1158 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_pais_dad_dfm() // 1160 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_das_dad_dfm() // 1168 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dais_dad_dfm() // 1170 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr16_dad_dfm() // 1178 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr32_dad_dfm() // 1179 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpc_dad_dfm() // 117a f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpci_dad_dfm() // 117b f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 38a mmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo) + m_da[rx];
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_imm8_dad_dfm() // 117c f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 2da rmdw1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_dbin) + m_da[rx];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 2db rmdw2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xl(m_dbout, m_dt);
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=9:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ds_daid_dfm() // 1180 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	// 1eb rmxw0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 109 rmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto rmxw3;
	else
		goto rmxw2;
rmxw2:
	// 128 rmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto rmdw2;
rmxw3:
	// 1e8 rmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto rmdw2;
rmdw2:
	// 2db rmdw2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xl(m_dbout, m_da[ry]);
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=4:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ais_daid_dfm() // 1190 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=33:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_aips_daid_dfm() // 1198 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=33:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_pais_daid_dfm() // 11a0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=33:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_das_daid_dfm() // 11a8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=33:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dais_daid_dfm() // 11b0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=33:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr16_daid_dfm() // 11b8 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=33:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr32_daid_dfm() // 11b9 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=33:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpc_daid_dfm() // 11ba f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=33:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpci_daid_dfm() // 11bb f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=bl..... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 298 mmxw0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=33:m_aluo d=0
	alu_ext(m_aluo);
	m_icount -= 2;
	// 101 mmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto mmxw3;
	else
		goto mmxw2;
mmxw2:
	// 028 mmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
mmxw3:
	// 0e8 mmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	goto maww2;
maww2:
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_imm8_daid_dfm() // 11bc f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1eb rmxw0
	// alu r=2 c=5 m=.....  i=bl..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 109 rmxw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_pc = m_au;
	m_au = m_da[rx] + ext32(m_aluo);
	if(m_t)
		goto rmxw3;
	else
		goto rmxw2;
rmxw2:
	// 128 rmxw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto rmdw2;
rmxw3:
	// 1e8 rmxw3
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto rmdw2;
rmdw2:
	// 2db rmdw2
	m_aob = m_au;
	m_ir = m_irc;
	set_8xl(m_dbout, m_dt);
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.nzvc  i=bl...i. 1 a=9:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ds_adr16_dfm() // 11c0 fff8
{
	int ry = m_irdi & 7;
	// 2d9 raww1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_at, m_da[ry]);
	m_au = ext32(m_dbin);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=4:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ais_adr16_dfm() // 11d0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_aips_adr16_dfm() // 11d8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_pais_adr16_dfm() // 11e0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_das_adr16_dfm() // 11e8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dais_adr16_dfm() // 11f0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr16_adr16_dfm() // 11f8 ffff
{
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr32_adr16_dfm() // 11f9 ffff
{
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpc_adr16_dfm() // 11fa ffff
{
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpci_adr16_dfm() // 11fb ffff
{
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 388 maww1
	m_aob = m_au;
	m_pc = m_au;
	m_au = ext32(m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_imm8_adr16_dfm() // 11fc ffff
{
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 2d9 raww1
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_at, m_dt);
	m_au = ext32(m_dbin);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=9:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ds_adr32_dfm() // 13c0 fff8
{
	int ry = m_irdi & 7;
	// 1ea ralw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2bb ralw2
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_at, m_da[ry]);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=4:m_da[ry] d=-1
	alu_and8(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_ais_adr32_dfm() // 13d0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 006 adrw1
	m_aob = m_da[ry];
	m_at = m_da[ry];
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_aips_adr32_dfm() // 13d8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 21c pinw1
	m_aob = m_da[ry];
	m_alub = m_dbin;
	m_dcr = 0;
	m_at = m_da[ry];
	m_au = m_da[ry] + (ry < 15 ? 1 : 2);
	// 21d pinw2
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_pais_adr32_dfm() // 13e0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 103 pdcw1
	m_alub = m_dbin;
	m_pc = m_au;
	m_dcr = 0;
	m_au = m_da[ry] - (ry < 15 ? 1 : 2);
	m_icount -= 2;
	// 17b pdcw2
	m_aob = m_au;
	m_at = m_au;
	m_da[ry] = m_au;
	m_au = m_pc;
	// alu r=2 c=1 m=.....  i=b...... 1 a=alub d=-1
	alu_and8(m_alub, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_das_adr32_dfm() // 13e8 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dais_adr32_dfm() // 13f0 fff8
{
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr16_adr32_dfm() // 13f8 ffff
{
	// 00a abwl1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_adr32_adr32_dfm() // 13f9 ffff
{
	// 1e2 abll1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 009 abll2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 004 abll3
	m_aob = m_at;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpc_adr32_dfm() // 13fa ffff
{
	// 1c2 adsw1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_dpci_adr32_dfm() // 13fb ffff
{
	// 1e3 aixl0
	// alu r=2 c=5 m=.....  i=b...... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e2 aixl1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixl5;
	else
		goto aixl2;
aixl2:
	// 120 aixl2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
aixl5:
	// 1e0 aixl5
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsw2;
adsw2:
	// 02a adsw2
	m_aob = m_au;
	m_at = m_au;
	m_au = m_pc + 4;
	// alu r=2 c=1 m=.....  i=b...... 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	// 024 adrw2
	m_dcr = 0;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1, m_aob & 1 ? 0x00ff : 0xff00);
	if(!(m_aob & 1))
		m_edb >>= 8;
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	m_dbin = m_edb;
	// 32b malw1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_aluo);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=31:m_dbin d=-1
	alu_and8(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 32e malw2
	m_aob = merge_16_32(high16(m_at), m_dbin);
	m_ir = m_irc;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	// 1e1 malw3
	m_aob = m_au;
	m_movemr = m_dbin;
	m_pc = m_au;
	m_ftu = m_dbin;
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_b_imm8_adr32_dfm() // 13fc ffff
{
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 1ea ralw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 2bb ralw2
	m_aob = m_au;
	m_pc = m_au;
	set_16l(m_at, m_dt);
	m_au = merge_16_32(high16(m_at), m_dbin);
	// alu r=2 c=1 m=.nzvc  i=b....i. 1 a=9:m_dt d=-1
	alu_and8(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	// 389 maww2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_8xl(m_dbout, m_aluo);
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout, (m_aob & 1) ? 0x00ff : 0xff00);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	set_ftu_const();
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	// 363 b
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_au + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_ds_dd_dfm() // 2000 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = m_irdi & 7;
	// 129 rrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_da[ry];
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=4:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	sr_nzvc();
	// 278 rrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=18:m_da[ry] d=-1
	alu_and(high16(m_da[ry]), 0xffff);
	sr_nz_u();
	m_da[rx] = m_at;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_as_dd_dfm() // 2008 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 129 rrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_da[ry];
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=3:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	sr_nzvc();
	// 278 rrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_at;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=17:m_da[ry] d=-1
	alu_and(high16(m_da[ry]), 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_ais_dd_dfm() // 2010 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_aips_dd_dfm() // 2018 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_pais_dd_dfm() // 2020 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_das_dd_dfm() // 2028 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_dais_dd_dfm() // 2030 f1f8
{
	int rx = (m_irdi >> 9) & 7;
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e7 aixw0
	// alu r=2 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_adr16_dd_dfm() // 2038 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_adr32_dd_dfm() // 2039 f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = m_da[rx];
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_dpc_dd_dfm() // 203a f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_dpci_dd_dfm() // 203b f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 1e7 aixw0
	// alu r=2 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_imm32_dd_dfm() // 203c f1ff
{
	int rx = (m_irdi >> 9) & 7;
	// 0a7 e#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 129 rrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_dt;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=9:m_dt d=-1
	alu_and(m_dt, 0xffff);
	sr_nzvc();
	// 278 rrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_at;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=23:m_dt d=-1
	alu_and(high16(m_dt), 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movea_l_ds_ad_dfm() // 2040 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	// 129 rrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_da[ry];
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.....i. 1 a=4:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	// 278 rrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_at;
	// alu r=2 c=1 m=.....  i=......f 1 a=18:m_da[ry] d=-1
	alu_and(high16(m_da[ry]), 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movea_l_as_ad_dfm() // 2048 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 129 rrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_da[ry];
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.....i. 1 a=3:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	// 278 rrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	// alu r=2 c=1 m=.....  i=......f 1 a=17:m_da[ry] d=-1
	alu_and(high16(m_da[ry]), 0xffff);
	m_da[rx] = m_at;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movea_l_ais_ad_dfm() // 2050 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.....  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movea_l_aips_ad_dfm() // 2058 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.....  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movea_l_pais_ad_dfm() // 2060 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.....  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movea_l_das_ad_dfm() // 2068 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.....  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movea_l_dais_ad_dfm() // 2070 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e7 aixw0
	// alu r=2 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.....  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movea_l_adr16_ad_dfm() // 2078 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.....  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movea_l_adr32_ad_dfm() // 2079 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.....  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movea_l_dpc_ad_dfm() // 207a f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.....  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movea_l_dpci_ad_dfm() // 207b f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e7 aixw0
	// alu r=2 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 29f mrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	set_16l(m_da[rx], m_dbin);
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	// 36f mrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	set_16h(m_da[rx], m_alue);
	// alu r=2 c=1 m=.....  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::movea_l_imm32_ad_dfm() // 207c f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 0a7 e#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 129 rrgl1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_at = m_dt;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.....i. 1 a=9:m_dt d=-1
	alu_and(m_dt, 0xffff);
	// 278 rrgl2
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_at;
	// alu r=2 c=1 m=.....  i=......f 1 a=23:m_dt d=-1
	alu_and(high16(m_dt), 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_ds_aid_dfm() // 2080 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	// 2f9 rmrl1
	m_aob = m_da[rx];
	m_dbout = high16(m_da[ry]);
	m_alub = high16(m_da[ry]);
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 23f rmrl2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_da[ry];
	m_au = m_pc;
	// alu r=2 c=1 m=.nzvc  i=.l...i. 1 a=4:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 258 rmrl3
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=.l....f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_as_aid_dfm() // 2088 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 2f9 rmrl1
	m_aob = m_da[rx];
	m_dbout = high16(m_da[ry]);
	m_alub = high16(m_da[ry]);
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 23f rmrl2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_da[ry];
	m_au = m_pc;
	// alu r=2 c=1 m=.nzvc  i=.l...i. 1 a=3:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 258 rmrl3
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=.l....f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_ais_aid_dfm() // 2090 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3a9 mmrl1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.l...i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3aa mmrl2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=.l....f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_aips_aid_dfm() // 2098 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3a9 mmrl1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.l...i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3aa mmrl2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=.l....f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_pais_aid_dfm() // 20a0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3a9 mmrl1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.l...i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3aa mmrl2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=.l....f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_das_aid_dfm() // 20a8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3a9 mmrl1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.l...i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3aa mmrl2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=.l....f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_dais_aid_dfm() // 20b0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e7 aixw0
	// alu r=2 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3a9 mmrl1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.l...i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3aa mmrl2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=.l....f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_adr16_aid_dfm() // 20b8 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3a9 mmrl1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.l...i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3aa mmrl2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=.l....f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_adr32_aid_dfm() // 20b9 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3a9 mmrl1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.l...i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3aa mmrl2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=.l....f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_dpc_aid_dfm() // 20ba f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3a9 mmrl1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.l...i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3aa mmrl2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=.l....f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_dpci_aid_dfm() // 20bb f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e7 aixw0
	// alu r=2 c=5 m=.....  i=.l..... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=.l..... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3a9 mmrl1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.l...i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3aa mmrl2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=.l....f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 025 mmrw2
	m_aob = m_pc;
	m_ir = m_irc;
	m_au = m_pc + 2;
	// 34c mmrw3
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_imm32_aid_dfm() // 20bc f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 0a7 e#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 2f9 rmrl1
	m_aob = m_da[rx];
	m_dbout = high16(m_dt);
	m_alub = high16(m_dt);
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 23f rmrl2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_dt;
	m_au = m_pc;
	// alu r=2 c=1 m=.nzvc  i=.l...i. 1 a=9:m_dt d=-1
	alu_and(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 258 rmrl3
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_pc = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=.l....f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_ds_aipd_dfm() // 20c0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	// 2fd rmil1
	m_aob = m_da[rx];
	m_dbout = high16(m_da[ry]);
	m_alub = high16(m_da[ry]);
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 23c rmil2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_da[ry];
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=4:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 23d rmil3
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_as_aipd_dfm() // 20c8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 2fd rmil1
	m_aob = m_da[rx];
	m_dbout = high16(m_da[ry]);
	m_alub = high16(m_da[ry]);
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 23c rmil2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_da[ry];
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=3:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 23d rmil3
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_ais_aipd_dfm() // 20d0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3ad mmil1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3ae mmil2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_aips_aipd_dfm() // 20d8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3ad mmil1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3ae mmil2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_pais_aipd_dfm() // 20e0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 179 pdcl1
	m_au = m_da[ry] - 4;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_icount -= 2;
	// 17a pdcl2
	m_aob = m_au;
	m_da[ry] = m_au;
	m_au = m_au + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3ad mmil1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3ae mmil2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_das_aipd_dfm() // 20e8 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_da[ry];
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3ad mmil1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3ae mmil2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_dais_aipd_dfm() // 20f0 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 1e7 aixw0
	// alu r=2 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_da[ry] + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3ad mmil1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3ae mmil2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_adr16_aipd_dfm() // 20f8 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 00e abww1
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	m_at = ext32(m_dbin);
	m_au = ext32(m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3ad mmil1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3ae mmil2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_adr32_aipd_dfm() // 20f9 f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e6 ablw1
	m_aob = m_au;
	set_16h(m_at, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 00d ablw2
	m_aob = m_au;
	m_pc = m_au;
	m_dcr = 0;
	set_16l(m_at, m_dbin);
	m_au = merge_16_32(high16(m_at), m_dbin);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 008 ablw3
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3ad mmil1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3ae mmil2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_dpc_aipd_dfm() // 20fa f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1c6 adsl1
	m_aob = m_au;
	m_au = ext32(m_dbin) + m_pc;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3ad mmil1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3ae mmil2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_dpci_aipd_dfm() // 20fb f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 1e7 aixw0
	// alu r=2 c=5 m=.....  i=....... 5 a=31:m_dbin d=0
	alu_ext(m_dbin);
	m_icount -= 2;
	// 3e6 aixw1
	m_aob = m_au;
	m_t = m_irc & 0x0800;
	m_au = m_pc + ext32(m_aluo);
	if(m_t)
		goto aixw4;
	else
		goto aixw2;
aixw2:
	// 124 aixw2
	m_au = ext32(m_da[map_sp(m_irc >> 12)]) + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
aixw4:
	// 1e4 aixw4
	m_au = m_da[map_sp(m_irc >> 12)] + m_au;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 13;
		} else
			m_inst_substate = 14;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	step_movem();
	goto adsl2;
adsl2:
	// 00c adsl2
	m_aob = m_au;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 026 adsl3
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 4;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 3ad mmil1
	m_aob = m_da[rx];
	m_dbout = m_alue;
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 3ae mmil2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_aluo;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 349 mmiw2
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 11;
		} else
			m_inst_substate = 12;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_imm32_aipd_dfm() // 20fc f1ff
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	// 0a7 e#l1
	m_aob = m_au;
	set_16h(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 0ea e#w1
	m_aob = m_au;
	m_pc = m_au;
	set_16h(m_at, m_dbin);
	set_16l(m_dt, m_dbin);
	m_au = m_au + 2;
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 2fd rmil1
	m_aob = m_da[rx];
	m_dbout = high16(m_dt);
	m_alub = high16(m_dt);
	m_pc = m_au;
	m_au = m_da[rx] + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 23c rmil2
	m_aob = m_au;
	m_ir = m_irc;
	m_dbout = m_dt;
	m_au = m_au + 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=9:m_dt d=-1
	alu_and(m_dt, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 23d rmil3
	m_aob = m_pc;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_ds_paid_dfm() // 2100 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = m_irdi & 7;
	// 2fc rmml1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=4:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 23e rmml2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=18:m_da[ry] d=-1
	alu_and(high16(m_da[ry]), 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_as_paid_dfm() // 2108 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 2fc rmml1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=3:m_da[ry] d=-1
	alu_and(m_da[ry], 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 23e rmml2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=17:m_da[ry] d=-1
	alu_and(high16(m_da[ry]), 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_ais_paid_dfm() // 2110 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 00b adrl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 005 adrl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 38f mmml1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 5;
		} else
			m_inst_substate = 6;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_irc = m_edb;
	m_dbin = m_edb;
	// 34a mmml2
	m_aob = m_au;
	m_dbout = m_aluo;
	m_au = m_au - 2;
	// alu r=2 c=1 m=.nz..  i=......f 1 a=alub d=-1
	alu_and(m_alub, 0xffff);
	sr_nz_u();
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 7;
		} else
			m_inst_substate = 8;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	// 34b mmmw2
	m_aob = m_au;
	m_ird = m_ir;
	if(m_next_state != S_TRACE) m_next_state = m_int_next_state;
	m_dbout = m_aluo;
	m_da[rx] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA;
	m_program.write_interruptible(m_aob & ~1, m_dbout);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 9;
		} else
			m_inst_substate = 10;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	set_ftu_const();
	m_inst_state = m_next_state ? m_next_state : m_decode_table[m_ird];
	if(m_sr & SR_T)
		m_next_state = S_TRACE;
	return;
}

void m68000_mcu_device::move_l_aips_paid_dfm() // 2118 f1f8
{
	int rx = map_sp(((m_irdi >> 9) & 7) | 8);
	int ry = map_sp((m_irdi & 7) | 8);
	// 00f pinl1
	m_aob = m_da[ry];
	m_au = m_da[ry] + 2;
	// alu r=2 c=1 m=.....  i=....... 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 1;
		} else
			m_inst_substate = 2;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 21a pinl2
	m_aob = m_au;
	m_alub = m_dbin;
	m_alue = m_dbin;
	m_at = m_au;
	m_au = m_au + 2;
	// 21b pinl3
	m_da[ry] = m_au;
	m_au = m_pc + 2;
	m_base_ssw = SSW_DATA | SSW_R;
	m_edb = m_program.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
		if(access_to_be_redone()) {
			m_icount += 4;
			m_inst_substate = 3;
		} else
			m_inst_substate = 4;
		return;
	}
	if(m_aob & 1) {
		m_icount -= 4;
		m_inst_state = S_ADDRESS_ERROR;
		return;
	}
	m_dbin = m_edb;
	// 38f mmml1
	m_aob = m_au;
	m_ir = m_irc;
	m_pc = m_au;
	m_au = m_da[rx] - 2;
	// alu r=2 c=1 m=.nzvc  i=.....i. 1 a=31:m_dbin d=-1
	alu_and(m_dbin, 0xffff);
	sr_nzvc();
	m_base_ssw = SSW_PROGRAM | SSW_R;
	m_edb = m_opcodes.read_interruptible(m_aob & ~1);
	m_icount -= 4;
	if(m_icount <= m_bcount) {
