# Mixxx

[Mixxx] is Free DJ software that gives you everything you need to perform live
DJ mixes. Mixxx works on GNU/Linux, Windows, and Mac OS X.

## Quick Start

To get started with Mixxx:

1. For live use, [download the latest stable version][download].
2. For experimentation and testing, [download a development release][builds].
3. To live on the bleeding edge, clone the repo: `git clone https://github.com/mixxxdj/mixxx.git`

## Roadmap

The Mixxx team is hard at work on Mixxx 2.1. The best place to keep track of
2.1 development is the [2.1.0 milestone page on Launchpad][launchpad 2.1.0].

A more general roadmap can be found on [the wiki][wiki roadmap].

## Bug tracker

The Mixxx team uses [Launchpad] to manage Mixxx development.

Have a bug or feature request? [File a bug on Launchpad][fileabug].

Want to get involved in Mixxx development? Assign yourself a bug from the [easy
bug list][easybugs] and get started!

## Compiling

* Linux / MacOS [![Build Status](https://travis-ci.org/mixxxdj/mixxx.svg)](https://travis-ci.org/mixxxdj/mixxx)
* Windows [![Build status](https://ci.appveyor.com/api/projects/status/j460rficblcaopwx?svg=true)](https://ci.appveyor.com/project/mixxxdj/mixxx)

First, you must install all of Mixxx's dependencies. To compile Mixxx using
[SCons], run:

    $ scons

Please see our helpful guides on the [wiki] for more information:
- [Compiling on Linux]
- [Compiling on OS X]
- [Compiling on Windows]

## Documentation

For help using Mixxx, there are a variety of options:

- [Mixxx manual][manual]
- [Mixxx wiki][wiki]
- [Frequently Asked Questions][FAQ]
- [Hardware Compatibility]
- [Creating Skins]

## Translation

Help to spread Mixxx with translations into more languages, as well as to update and ensure the accuracy of existing translations.

- [Help translate content]
- [Mixxx i18n wiki]
- [Mixxx localization forum]
- [Mixxx glossary]

## Community

Mixxx is a vibrant community of hackers, DJs and artists. To keep track of
development and community news:

- Chat with us on [Zulip][zulip].
- Follow us on [Twitter], [Facebook], and [G+].
- Subscribe to the [Mixxx Development Blog][blog].
- Join the developer [mailing list].
- Post on the [Mixxx forums][forums].

## License

Mixxx is released under the GPLv2. See the LICENSE file for a full copy of the
license.

[mixxx]: http://www.mixxx.org
[download]: http://www.mixxx.org/download
[builds]: http://downloads.mixxx.org/builds/
[launchpad]: http://bugs.launchpad.net/mixxx
[fileabug]: http://bugs.launchpad.net/mixxx/+filebug
[twitter]: http://twitter.com/mixxxdj
[facebook]: https://www.facebook.com/pages/Mixxx-DJ-Software/21723485212
[g+]: https://plus.google.com/102441931224839455484/posts
[blog]: http://mixxxblog.blogspot.com
[manual]: http://www.mixxx.org/manual/latest/
[wiki]: http://www.mixxx.org/wiki/
[faq]: http://mixxx.org/wiki/doku.php/faq
[forums]: http://www.mixxx.org/forums/
[compiling on linux]: http://mixxx.org/wiki/doku.php/compiling_on_linux
[compiling on os x]: http://mixxx.org/wiki/doku.php/compiling_on_os_x
[compiling on windows]: http://mixxx.org/wiki/doku.php/compiling_on_windows
[mailing list]: https://lists.sourceforge.net/lists/listinfo/mixxx-devel
[irc channel]: http://mixxx.org/irc.php
[SCons]: http://www.scons.org/
[launchpad 2.1.0]: https://launchpad.net/mixxx/+milestone/2.1.0
[wiki roadmap]: http://mixxx.org/wiki/doku.php/development_roadmap
[easybugs]: https://bugs.launchpad.net/mixxx/+bugs?field.searchtext=&orderby=-importance&search=Search&field.status%3Alist=NEW&field.status%3Alist=CONFIRMED&field.status%3Alist=TRIAGED&field.status%3Alist=INPROGRESS&field.status%3Alist=INCOMPLETE_WITH_RESPONSE&field.status%3Alist=INCOMPLETE_WITHOUT_RESPONSE&assignee_option=any&field.assignee=&field.bug_reporter=&field.bug_commenter=&field.subscriber=&field.structural_subscriber=&field.tag=easy&field.tags_combinator=ANY&field.has_cve.used=&field.omit_dupes.used=&field.omit_dupes=on&field.affects_me.used=&field.has_patch.used=&field.has_branches.used=&field.has_branches=on&field.has_no_branches.used=&field.has_no_branches=on&field.has_blueprints.used=&field.has_blueprints=on&field.has_no_blueprints.used=&field.has_no_blueprints=on
[creating skins]: http://mixxx.org/wiki/doku.php/creating_skins
[help translate content]: https://www.transifex.com/projects/p/mixxxdj
[Mixxx i18n wiki]: http://mixxx.org/wiki/doku.php/internationalization
[Mixxx localization forum]: http://mixxx.org/forums/viewforum.php?f=10
[Mixxx glossary]: https://www.transifex.com/projects/p/mixxxdj/glossary/l/en/
[hardware compatibility]: http://mixxx.org/wiki/doku.php/hardware_compatibility
[zulip]: https://mixxx.zulipchat.com/
