def create_iso639_language_list_file
  iso639_2 = JSON.parse(IO.readlines("/usr/share/iso-codes/json/iso_639-2.json").join(''))
  rows     = iso639_2["639-2"].
    reject { |entry| %r{^qaa}.match(entry["alpha_3"]) }.
    map do |entry|
    [ '"' + entry["name"] + '"',
      '"' + (entry["bibliographic"] || entry["alpha_3"]) + '"',
      entry["alpha_2"] ? '"' + entry["alpha_2"] + '"' : 'std::string{}',
      entry["bibliographic"] ? '"' + entry["alpha_3"] + '"' : 'std::string{}',
    ]
  end

  rows += ("a".."d").map do |letter|
    [ %Q{"Reserved for local use: qa#{letter}"},
      %Q{"qa#{letter}"},
      'std::string{}',
      'std::string{}',
    ]
  end

  header = <<EOT
/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit http://www.gnu.org/copyleft/gpl.html

   ISO 639 language definitions, lookup functions

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

// -----------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iso639_list" rake target.
// -----------------------------------------------------------------------

#include "common/common_pch.h"

#include "common/iso639.h"

std::vector<iso639_language_t> const g_iso639_languages{
EOT

  footer = <<EOT
};
EOT

  content = header + format_table(rows.sort, :column_suffix => ',', :row_prefix => "  { ", :row_suffix => "  },").join("\n") + "\n" + footer

  IO.write("#{$source_dir}/src/common/iso639_language_list.cpp", content)
end
