#!/bin/bash

#
# fedora-24.x86_64.sh
# Creates a Docker image used to build Moon Phase on Fedora 24.
#


# Assume success.
ExitCode=0

# Include docker functions (also includes print functions).
which awisewhere.sh >/dev/null && . "$(awisewhere.sh)/docker.sh" && \
    which dib.sh >/dev/null
if [ $? -ne 0 ]; then
  echo "$0: error: unable to locate files needed by this script."
  echo "$0: error: verify awiseshell is installed and is in the path."
  ExitCode=1
fi

if [ $ExitCode -eq 0 ]; then

  # If called from shell with no parameters, start 'dib.sh'.
  if [ $# -eq 0 ]; then
    Parent=$(ps -o comm= $PPID)
    if [ "$Parent" == "bash" ]; then
      dib.sh "$0"
      exit
    fi
  fi

  case $1 in

    -b)
      if [ $# -lt 1 ]; then
        Print_MissingArgumentsError 1 "to '$1' option"
      elif [ $# -gt 1 ]; then
        Print_ExtraArgumentsError 1 "to '$1' option"
      fi
      echo "registry.gitlab.com/alanwise/awisetoolbox:fedora-24.x86_64-20170706"
      ExitCode=0
      ;;

    -c)
      if [ $# -lt 1 ]; then
        Print_MissingArgumentsError 1 "to '$1' option"
      elif [ $# -gt 1 ]; then
        Print_ExtraArgumentsError 1 "to '$1' option"
      fi
      echo "3"
      ExitCode=0
      ;;

    -r)
      if [ $# -lt 1 ]; then
        Print_MissingArgumentsError 1 "to '$1' option"
      elif [ $# -gt 1 ]; then
        Print_ExtraArgumentsError 1 "to '$1' option"
      fi
      echo "registry.gitlab.com/moonphase/moonphase"
      ExitCode=0
      ;;

    -0)
      if [ $# -lt 2 ]; then
        Print_MissingArgumentsError 1 "to '$1' option"
      elif [ $# -gt 2 ]; then
        Print_ExtraArgumentsError 1 "to '$1' option"
      fi
      Docker_ExecuteShellCommandInContainer "$2" "mock -r fedora-24-i386 --init"
      ExitCode=$?
      ;;

    -1)
      if [ $# -lt 2 ]; then
        Print_MissingArgumentsError 1 "to '$1' option"
      elif [ $# -gt 2 ]; then
        Print_ExtraArgumentsError 1 "to '$1' option"
      fi
      Docker_ExecuteShellCommandInContainer "$2" "mock -r fedora-24-x86_64 --init"
      ExitCode=$?
      ;;

    -2)
      if [ $# -lt 2 ]; then
        Print_MissingArgumentsError 1 "to '$1' option"
      elif [ $# -gt 2 ]; then
        Print_ExtraArgumentsError 1 "to '$1' option"
      fi
      Docker_ExecuteShellCommandInContainer \
          "$2" "mock -r fedora-24-i386 --install cmake qt4-devel rpmlint"
      if [ $? -eq 0 ]; then
        Docker_ExecuteShellCommandInContainer \
            "$2" "mock -r fedora-24-x86_64 --install cmake qt4-devel rpmlint"
      fi
      ;;

    *)
      echo "Usage: $0 [OPTION]"
      echo "Creates a Docker image used to build Moon Phase on Fedora 24."
      echo ""
      echo "  -b              Print base image name."
      echo "  -c              Print stage count."
      echo "  -r              Print image registry name."
      echo "  -0 containerid  Run stage 0 of the build."
      echo "  -1 containerid  Run stage 1 of the build."
      echo "  -2 containerid  Run stage 2 of the build."
      echo "  -3 containerid  Run stage 3 of the build."
      echo ""
      echo "Only one option may be specified per invocation."
      echo ""
      echo "The resulting image will be tagged with name of this script (minus any "
      echo "extension) plus the date (in \"YYYYMMDD\" format)."
      ;;

  esac
fi

exit $ExitCode


#
# fedora-24.x86_64.sh
#
