/**
*** \file settings.cpp
*** \brief settings.cpp implementation.
*** \details Implementation file for settings.cpp.
**/

/*
** This file is part of moonphase.
** Copyright (C) 2014-2018 by Alan Wise <awisesoftware@gmail.com>.
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/**
*** \brief settings.cpp identifier.
*** \details Identifier for settings.cpp.
**/
#define   SETTINGS_CPP


/****
*****
***** INCLUDES
*****
****/

#include  "settings.h"
#ifdef    DEBUG_SETTINGS_CPP
#ifndef   USE_DEBUGLOG
#define   USE_DEBUGLOG
#endif    /* USE_DEBUGLOG */
#endif    /* DEBUG_SETTINGS_CPP */
#include  "debuglog.h"
#include  "messagelog.h"


/****
*****
***** DEFINES
*****
****/

/**
*** \brief Allow multiple instances flag key.
*** \details Key to access allow multiple instances flag in configuration file.
**/
#define   APPLICATIONPREFERENCES_ALLOWMULTIPLEINSTANCESFLAG   \
              "AllowMultipleInstancesFlag"

/**
*** \brief Animation pathname key.
*** \details Key to access animation pathname in configuration file.
**/
#define   APPLICATIONPREFERENCES_ANIMATIONPATHNAME            \
              "AnimationPathname"

/**
*** \brief Background color key.
*** \details Key to access background color in configuration file.
**/
#define   APPLICATIONPREFERENCES_BACKGROUNDCOLOR              \
              "BackgroundColor"

/**
*** \brief Confirm discard changes flag key.
*** \details Key to access confirm discard changes flag in configuration file.
**/
#define   APPLICATIONPREFERENCES_CONFIRMDISCARDCHANGESFLAG    \
              "ConfirmDiscardChangesFlag"

/**
*** \brief Confirm quit flag key.
*** \details Key to access confirm quit flag in configuration file.
**/
#define   APPLICATIONPREFERENCES_CONFIRMQUITFLAG              \
              "ConfirmQuitFlag"

/**
*** \brief Remind once per session flag key.
*** \details Key to access remind once per session flag in configuration file.
**/
#define   APPLICATIONPREFERENCES_REMINDONCEPERSESSIONFLAG     \
              "RemindOncePerSessionFlag"

/**
*** \brief Still running reminder flag key.
*** \details Key to access still running reminder flag in configuration file.
**/
#define   APPLICATIONPREFERENCES_STILLRUNNINGREMINDERFLAG     \
              "StillRunningReminderFlag"

/**
*** \brief Update interval key.
*** \details Key to access update interval in configuration file.
**/
#define   APPLICATIONPREFERENCES_UPDATEINTERVAL               \
              "UpdateInterval"

/**
*** \brief Use opaque background flag key.
*** \details Key to access use opaque background flag in configuration file.
**/
#define   APPLICATIONPREFERENCES_USEOPAQUEBACKGROUNDFLAG      \
              "UseOpaqueBackgroundFlag"

/**
*** \brief Default to metric units key.
*** \details Key to access default to metric flag in configuration file.
**/
#define   INFORMATIONPREFERENCES_DEFAULTTOMETRICUNITSFLAG     \
              "DefaultToMetricUnitsFlag"

/**
*** \brief Latitude key.
*** \details Key to access latitude in configuration file.
**/
#define   INFORMATIONPREFERENCES_LATITUDE                     \
              "Latitude"

/**
*** \brief Longitude key.
*** \details Key to access Longitude in configuration file.
**/
#define   INFORMATIONPREFERENCES_LONGITUDE                    \
              "Longitude"


/****
*****
***** DATA TYPES
*****
****/


/****
*****
***** PROTOTYPES
*****
****/


/****
*****
***** DATA
*****
****/


/****
*****
***** VARIABLES
*****
****/


/****
*****
***** FUNCTIONS
*****
****/

SETTINGS_C::APPLICATIONPREFERENCES_C::APPLICATIONPREFERENCES_C(void)
    : QSettings()
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::APPLICATIONPREFERENCES_C()");
  DEBUGLOG_LogIn();

  m_AllowMultipleInstancesFlag=false;
  m_AnimationPathname="";
  m_BackgroundColor=QColor(0,0,0,255);
  m_ConfirmDiscardFlag=true;
  m_ConfirmQuitFlag=true;
  m_RemindOncePerSessionFlag=false;
  m_StillRunningReminderFlag=true;
  m_UpdateInterval=4;
  m_UseOpaqueBackgroundFlag=false;

  DEBUGLOG_LogOut();
  return;
}

SETTINGS_C::APPLICATIONPREFERENCES_C::APPLICATIONPREFERENCES_C(
    SETTINGS_C::APPLICATIONPREFERENCES_C const &Preferences) : QSettings()
{
  DEBUGLOG_Printf1("SETTINGS_C::operator=(SETTINGS_C:%p)",&Preferences);
  DEBUGLOG_LogIn();

  *this=Preferences;

  DEBUGLOG_LogOut();
  return;
}

SETTINGS_C::APPLICATIONPREFERENCES_C::~APPLICATIONPREFERENCES_C(void)
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::~APPLICATIONPREFERENCES_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}

SETTINGS_C::APPLICATIONPREFERENCES_C & SETTINGS_C::APPLICATIONPREFERENCES_C::
    operator=(APPLICATIONPREFERENCES_C const &Preferences)
{
  DEBUGLOG_Printf1("SETTINGS_C::APPLICATIONPREFERENCES_C::"
      "operator=(APPLICATIONPREFERENCES_C:%p)",&Preferences);
  DEBUGLOG_LogIn();

  m_AllowMultipleInstancesFlag=Preferences.m_AllowMultipleInstancesFlag;
  m_AnimationPathname=Preferences.m_AnimationPathname;
  m_BackgroundColor=Preferences.m_BackgroundColor;
  m_ConfirmDiscardFlag=Preferences.m_ConfirmDiscardFlag;
  m_ConfirmQuitFlag=Preferences.m_ConfirmQuitFlag;
  m_RemindOncePerSessionFlag=Preferences.m_RemindOncePerSessionFlag;
  m_StillRunningReminderFlag=Preferences.m_StillRunningReminderFlag;
  m_UpdateInterval=Preferences.m_UpdateInterval;
  m_UseOpaqueBackgroundFlag=Preferences.m_UseOpaqueBackgroundFlag;

  DEBUGLOG_LogOut();
  return(*this);
}

bool SETTINGS_C::APPLICATIONPREFERENCES_C::operator==(
    SETTINGS_C::APPLICATIONPREFERENCES_C const &RHS)
{
  bool EqualFlag;


  DEBUGLOG_Printf1("SETTINGS_C::APPLICATIONPREFERENCES_C::"
      "operator==(APPLICATIONPREFERENCES_C:%p)",&RHS);
  DEBUGLOG_LogIn();

  EqualFlag=(QString::localeAwareCompare(
      m_AnimationPathname,RHS.m_AnimationPathname)==0) &&
      (m_AllowMultipleInstancesFlag==RHS.m_AllowMultipleInstancesFlag) &&
      (m_BackgroundColor==RHS.m_BackgroundColor) &&
      (m_ConfirmDiscardFlag==RHS.m_ConfirmDiscardFlag) &&
      (m_ConfirmQuitFlag==RHS.m_ConfirmQuitFlag) &&
      (m_RemindOncePerSessionFlag==RHS.m_RemindOncePerSessionFlag) &&
      (m_StillRunningReminderFlag==RHS.m_StillRunningReminderFlag) &&
      (m_UpdateInterval==RHS.m_UpdateInterval) &&
      (m_UseOpaqueBackgroundFlag==RHS.m_UseOpaqueBackgroundFlag);

  DEBUGLOG_LogOut();
  return(EqualFlag);
}

bool SETTINGS_C::APPLICATIONPREFERENCES_C::operator!=(
    SETTINGS_C::APPLICATIONPREFERENCES_C const &RHS)
{
  bool EqualFlag;


  DEBUGLOG_Printf1("SETTINGS_C::APPLICATIONPREFERENCES_C::"
      "operator!=(APPLICATIONPREFERENCES_C:%p)",&RHS);
  DEBUGLOG_LogIn();

  EqualFlag=!((*this)==RHS);

  DEBUGLOG_LogOut();
  return(EqualFlag);
}

bool SETTINGS_C::APPLICATIONPREFERENCES_C::
    GetAllowMultipleInstancesFlag(void) const
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::GetAllowMultipleInstancesFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_AllowMultipleInstancesFlag);
}

QString SETTINGS_C::APPLICATIONPREFERENCES_C::GetAnimationPathname(void) const
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::GetAnimationPathname()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_AnimationPathname);
}

QColor SETTINGS_C::APPLICATIONPREFERENCES_C::GetBackgroundColor(void) const
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::GetBackgroundColor()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_BackgroundColor);
}

bool SETTINGS_C::APPLICATIONPREFERENCES_C::GetConfirmDiscardFlag(void) const
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::GetConfirmDiscardFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_ConfirmDiscardFlag);
}

bool SETTINGS_C::APPLICATIONPREFERENCES_C::GetConfirmQuitFlag(void) const
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::GetConfirmQuitFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_ConfirmQuitFlag);
}

bool SETTINGS_C::APPLICATIONPREFERENCES_C::
    GetRemindOncePerSessionFlag(void) const
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::GetRemindOncePerSessionFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_RemindOncePerSessionFlag);
}

bool SETTINGS_C::APPLICATIONPREFERENCES_C::
    GetStillRunningReminderFlag(void) const
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::GetStillRunningReminderFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_StillRunningReminderFlag);
}

unsigned int SETTINGS_C::APPLICATIONPREFERENCES_C::
    GetUpdateInterval(void) const
{
  DEBUGLOG_Printf0("SETTINGS_C::APPLICATIONPREFERENCES_C::GetUpdateInterval()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_UpdateInterval);
}

bool SETTINGS_C::APPLICATIONPREFERENCES_C::
    GetUseOpaqueBackgroundFlag(void) const
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::GetUseOpaqueBackgroundFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_UseOpaqueBackgroundFlag);
}

void SETTINGS_C::APPLICATIONPREFERENCES_C::Load(void)
{
  DEBUGLOG_Printf0("SETTINGS_C::APPLICATIONPREFERENCES_C::Load()");
  DEBUGLOG_LogIn();

  m_AllowMultipleInstancesFlag=
      value(APPLICATIONPREFERENCES_ALLOWMULTIPLEINSTANCESFLAG,
      m_AllowMultipleInstancesFlag).toBool();
  m_AnimationPathname=
      value(APPLICATIONPREFERENCES_ANIMATIONPATHNAME,
      m_AnimationPathname).toString();
  m_BackgroundColor=
      value(APPLICATIONPREFERENCES_BACKGROUNDCOLOR,
      m_BackgroundColor).value<QColor>();
  m_ConfirmDiscardFlag=
      value(APPLICATIONPREFERENCES_CONFIRMDISCARDCHANGESFLAG,
      m_ConfirmDiscardFlag).toBool();
  m_ConfirmQuitFlag=
      value(APPLICATIONPREFERENCES_CONFIRMQUITFLAG,
      m_ConfirmQuitFlag).toBool();
  m_RemindOncePerSessionFlag=
      value(APPLICATIONPREFERENCES_REMINDONCEPERSESSIONFLAG,
      m_RemindOncePerSessionFlag).toBool();
  m_StillRunningReminderFlag=
      value(APPLICATIONPREFERENCES_STILLRUNNINGREMINDERFLAG,
      m_StillRunningReminderFlag).toBool();
  m_UpdateInterval=
      value(APPLICATIONPREFERENCES_UPDATEINTERVAL,
      m_UpdateInterval).toUInt();
  m_UseOpaqueBackgroundFlag=
      value(APPLICATIONPREFERENCES_USEOPAQUEBACKGROUNDFLAG,
      m_UseOpaqueBackgroundFlag).toBool();

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::APPLICATIONPREFERENCES_C::Save(void)
{
  DEBUGLOG_Printf0("SETTINGS_C::Save()");
  DEBUGLOG_LogIn();

  setValue(APPLICATIONPREFERENCES_ALLOWMULTIPLEINSTANCESFLAG,
      m_AllowMultipleInstancesFlag);
  setValue(APPLICATIONPREFERENCES_ANIMATIONPATHNAME,m_AnimationPathname);
  setValue(APPLICATIONPREFERENCES_BACKGROUNDCOLOR,m_BackgroundColor);
  setValue(APPLICATIONPREFERENCES_CONFIRMDISCARDCHANGESFLAG,
      m_ConfirmDiscardFlag);
  setValue(APPLICATIONPREFERENCES_CONFIRMQUITFLAG,m_ConfirmQuitFlag);
  setValue(APPLICATIONPREFERENCES_REMINDONCEPERSESSIONFLAG,
      m_RemindOncePerSessionFlag);
  setValue(APPLICATIONPREFERENCES_STILLRUNNINGREMINDERFLAG,
      m_StillRunningReminderFlag);
  setValue(APPLICATIONPREFERENCES_UPDATEINTERVAL,m_UpdateInterval);
  setValue(APPLICATIONPREFERENCES_USEOPAQUEBACKGROUNDFLAG,
      m_UseOpaqueBackgroundFlag);

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::APPLICATIONPREFERENCES_C::
    SetAllowMultipleInstancesFlag(bool const AllowMultipleInstancesFlag)
{
  DEBUGLOG_Printf1(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::SetAllowMultipleInstancesFlag(%u)",
      AllowMultipleInstancesFlag);
  DEBUGLOG_LogIn();

  m_AllowMultipleInstancesFlag=AllowMultipleInstancesFlag;

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::APPLICATIONPREFERENCES_C::
    SetAnimationPathname(QString const Pathname)
{
  DEBUGLOG_Printf2(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::SetAnimationPathname(%p(%s))",
      &Pathname,qPrintable(Pathname));
  DEBUGLOG_LogIn();

  m_AnimationPathname=Pathname;

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::APPLICATIONPREFERENCES_C::
    SetBackgroundColor(QColor const BackgroundColor)
{
  DEBUGLOG_Printf1(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::SetBackgroundColor(%u)",
      BackgroundColor.value());
  DEBUGLOG_LogIn();

  m_BackgroundColor=BackgroundColor;

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::APPLICATIONPREFERENCES_C::
    SetConfirmDiscardFlag(bool const ConfirmDiscardFlag)
{
  DEBUGLOG_Printf1(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::SetConfirmDiscardFlag(%u)",
      ConfirmDiscardFlag);
  DEBUGLOG_LogIn();

  m_ConfirmDiscardFlag=ConfirmDiscardFlag;

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::APPLICATIONPREFERENCES_C::
    SetConfirmQuitFlag(bool const ConfirmQuitFlag)
{
  DEBUGLOG_Printf1(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::SetConfirmQuitFlag(%u)",
      ConfirmQuitFlag);
  DEBUGLOG_LogIn();

  m_ConfirmQuitFlag=ConfirmQuitFlag;

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::APPLICATIONPREFERENCES_C::
    SetRemindOncePerSessionFlag(bool const OnceFlag)
{
  DEBUGLOG_Printf1(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::SetRemindOncePerSessionFlag(%u)",
      OnceFlag);
  DEBUGLOG_LogIn();

  m_RemindOncePerSessionFlag=OnceFlag;

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::APPLICATIONPREFERENCES_C::
    SetStillRunningReminderFlag(bool const ReminderFlag)
{
  DEBUGLOG_Printf1(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::SetStillRunningReminderFlag(%u)",
      ReminderFlag);
  DEBUGLOG_LogIn();

  m_StillRunningReminderFlag=ReminderFlag;

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::APPLICATIONPREFERENCES_C::
    SetUpdateInterval(unsigned int const Interval)
{
  DEBUGLOG_Printf1(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::SetUpdateInterval(%u)",
      Interval);
  DEBUGLOG_LogIn();

  m_UpdateInterval=Interval;

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::APPLICATIONPREFERENCES_C::
    SetUseOpaqueBackgroundFlag(bool const UseFlag)
{
  DEBUGLOG_Printf1(
      "SETTINGS_C::APPLICATIONPREFERENCES_C::SetUseOpaqueBackgroundFlag(%u)",
      UseFlag);
  DEBUGLOG_LogIn();

  m_UseOpaqueBackgroundFlag=UseFlag;

  DEBUGLOG_LogOut();
  return;
}

SETTINGS_C::INFORMATIONSETTINGS_C::
    INFORMATIONPREFERENCES_C::INFORMATIONPREFERENCES_C(void) : QSettings()
{
  DEBUGLOG_Printf0("SETTINGS_C::INFORMATIONSETTINGS_C::"
    "INFORMATIONPREFERENCES_C::INFORMATIONPREFERENCES_C()");
  DEBUGLOG_LogIn();

  m_DefaultToMetricUnitsFlag=true;
  m_Latitude=0.0;
  m_Longitude=0.0;

  DEBUGLOG_LogOut();
  return;
}

SETTINGS_C::INFORMATIONSETTINGS_C::
    INFORMATIONPREFERENCES_C::~INFORMATIONPREFERENCES_C(void)
{
  DEBUGLOG_Printf0("SETTINGS_C::INFORMATIONSETTINGS_C::"
    "INFORMATIONPREFERENCES_C::~INFORMATIONPREFERENCES_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}

bool SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::operator==(
    SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C const &RHS)
    const
{
  bool EqualFlag;


  DEBUGLOG_Printf1(
      "SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::operator==("
      "SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C:%p)",&RHS);
  DEBUGLOG_LogIn();

  EqualFlag=
      (m_DefaultToMetricUnitsFlag==RHS.m_DefaultToMetricUnitsFlag) &&
      (m_Latitude==RHS.m_Latitude) && (m_Longitude==RHS.m_Longitude);

  DEBUGLOG_LogOut();
  return(EqualFlag);
}

bool SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::operator!=(
    SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C const &RHS)
    const
{
  DEBUGLOG_Printf1(
      "SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::operator!=("
      "SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C:%p)",&RHS);
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(!(*this==RHS));
}

bool SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::
    GetDefaultToMetricUnitsFlag(void) const
{
  DEBUGLOG_Printf0("SETTINGS_C::INFORMATIONSETTINGS_C::"
      "INFORMATIONPREFERENCES_C::GetDefaultToMetricUnitsFlag()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_DefaultToMetricUnitsFlag);
}

double SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::
    GetLatitude(void) const
{
  DEBUGLOG_Printf0("SETTINGS_C::INFORMATIONSETTINGS_C::"
      "INFORMATIONPREFERENCES_C::GetLatitude()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_Latitude);
}

double SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::
    GetLongitude(void) const
{
  DEBUGLOG_Printf0("SETTINGS_C::INFORMATIONSETTINGS_C::"
      "INFORMATIONPREFERENCES_C::GetLongitude()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(m_Longitude);
}

void SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::Load(void)
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::Load()");
  DEBUGLOG_LogIn();

  m_DefaultToMetricUnitsFlag=value(
      INFORMATIONPREFERENCES_DEFAULTTOMETRICUNITSFLAG,true).toBool();
  m_Latitude=value(INFORMATIONPREFERENCES_LATITUDE,0.0).toDouble();
  m_Longitude=value(INFORMATIONPREFERENCES_LONGITUDE,0.0).toDouble();

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::Save(void)
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::Save()");
  DEBUGLOG_LogIn();

  setValue(INFORMATIONPREFERENCES_DEFAULTTOMETRICUNITSFLAG,
      m_DefaultToMetricUnitsFlag);
  setValue(INFORMATIONPREFERENCES_LATITUDE,m_Latitude);
  setValue(INFORMATIONPREFERENCES_LONGITUDE,m_Longitude);

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::
    SetDefaultToMetricUnitsFlag(bool DefaultToMetricUnitsFlag)
{
  DEBUGLOG_Printf1("SETTINGS_C::INFORMATIONSETTINGS_C::"
      "INFORMATIONPREFERENCES_C::SetDefaultToMetricUnitsFlag(%u)",
      DefaultToMetricUnitsFlag);
  DEBUGLOG_LogIn();

  m_DefaultToMetricUnitsFlag=DefaultToMetricUnitsFlag;

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::
    SetLatitude(double Latitude)
{
  DEBUGLOG_Printf1("SETTINGS_C::INFORMATIONSETTINGS_C::"
      "INFORMATIONPREFERENCES_C::SetLatitude(%u)",Latitude);
  DEBUGLOG_LogIn();

  m_Latitude=Latitude;

  DEBUGLOG_LogOut();
  return;
}

void SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C::
    SetLongitude(double Longitude)
{
  DEBUGLOG_Printf1("SETTINGS_C::INFORMATIONSETTINGS_C::"
      "INFORMATIONPREFERENCES_C::SetLongitude(%u)",Longitude);
  DEBUGLOG_LogIn();

  m_Longitude=Longitude;

  DEBUGLOG_LogOut();
  return;
}

SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONSETTINGS_C(void)
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONSETTINGS_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}

SETTINGS_C::INFORMATIONSETTINGS_C::~INFORMATIONSETTINGS_C(void)
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::INFORMATIONSETTINGS_C::~INFORMATIONSETTINGS_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}

SETTINGS_C::INFORMATIONSETTINGS_C::INFORMATIONPREFERENCES_C *
    SETTINGS_C::INFORMATIONSETTINGS_C::GetInformationPreferencesPointer(void)
{
  DEBUGLOG_Printf0(
      "SETTINGS_C::INFORMATIONSETTINGS_C::GetInformationPreferencesPointer()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(&m_InformationPreferences);
}

void SETTINGS_C::INFORMATIONSETTINGS_C::Load(void)
{
  DEBUGLOG_Printf0("SETTINGS_C::Load()");
  DEBUGLOG_LogIn();

  m_InformationPreferences.Load();

  DEBUGLOG_LogOut();
  return;
}

SETTINGS_C::SETTINGS_C(void) : QSettings()
{
  DEBUGLOG_Printf0("SETTINGS_C::SETTINGS_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}

SETTINGS_C::~SETTINGS_C(void)
{
  DEBUGLOG_Printf0("SETTINGS_C::~SETTINGS_C()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return;
}

SETTINGS_C::APPLICATIONPREFERENCES_C *
    SETTINGS_C::GetApplicationPreferencesPointer(void)
{
  DEBUGLOG_Printf0("SETTINGS_C::GetApplicationPreferencesPointer()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(&m_ApplicationPreferences);
}

SETTINGS_C::INFORMATIONSETTINGS_C *
    SETTINGS_C::GetInformationSettingsPointer(void)
{
  DEBUGLOG_Printf0("SETTINGS_C::GetPreferencesSettings()");
  DEBUGLOG_LogIn();

  DEBUGLOG_LogOut();
  return(&m_InformationSettings);
}

void SETTINGS_C::Load(void)
{
  DEBUGLOG_Printf0("SETTINGS_C::Load()");
  DEBUGLOG_LogIn();

  m_ApplicationPreferences.Load();
  m_InformationSettings.Load();

  DEBUGLOG_LogOut();
  return;
}


#undef    SETTINGS_CPP


/**
*** settings.cpp
**/
