.TH MYSTUFF 1 2015-11-04 "Linux" "MyStuff man page"

.SH NAME
   MyStuff - Create a custom menu in a popup window.

.SH SYNOPSIS
   \fBmystuff\fR [ \fB-v\fR ]

.SH DESCRIPTION
   MyStuff is a popup window with menu items as icons and text. Click a menu 
   item to launch the corresponding application. Menu items can be created 
   using a GUI dialog or by dragging desktop files or data files into the 
   mystuff window. Arrange the layout by dragging menu items with the mouse.

.SH OPTIONS
   Command line options
      \fB-v\fR                print version and exit

.SH OVERVIEW

Initialization and Startup
   Create a desktop icon/launcher using the command mystuff. 
   An empty window is created when Mystuff is first started. 

Adding and Editing Menu Items
   To add a new menu item, right-click an empty space in the window and 
   fill-in the popup dialog with menu text, menu icon, and menu function. 
   A shell command with the function function will be issued when the menu 
   is clicked. If there is no function, the menu text and icon appear in 
   the window but do nothing. Use this for headings or other information. 
   The menu text can have multiple lines up to 1000 characters. Use '\\n' 
   to separate lines. If "close window" is checked, the mystuff window will 
   vanish when the menu item is selected. To change a menu, right-click and 
   edit the popup dialog containing the existing menu data. Delete a menu 
   with the dialog [delete] button.

Adding Menu Items by Drag & Drop Desktop Icons/Launchers
   A desktop launcher is a text file (appname.desktop) which appears on the 
   desktop as an icon which can be clicked to launch the application. These 
   icons can be dragged onto the mystuff window and will work the same way.

Adding Menu Items by Drag & Drop File Names
   A file can be dragged onto the MyStuff window to become a clickable menu 
   which starts the default application to open the file. Nautilus can be 
   used as a source to drag files. The initial menu name is the file base 
   name, which can be edited as described above. The icon is the application
   icon. For an image file, the icon is a thumbnail of the image. 

Icon Size
   The default size is 32 pixels wide, but the dialog allows this to be 
   changed to any value within 24-256 pixels. When the icon size is changed, 
   the new value becomes the default for the next menu entry added in the 
   same session. 

Arranging the Layout
   The menu items may be dragged around the window using the mouse. They will 
   register on 8-pixel boundaries to simplify alignment. Expand the window if 
   more space is needed, and this size will be retained when the window is 
   opened again.

Adding Multiple Pages
   The initial window may contain menu items which are links to additional 
   windows. For the menu function, use "mystuff name", where "name" is any
   name other than "menu.txt", which is the initial window name. Clicking on 
   this new menu item will bring up a new empty mystuff window which can be 
   populated with menu items like the initial window. The link menus can be
   used to build a circular list of windows with "next" and "back" links,
   or a hierarchy of windows. 

Exit Mystuff
   To close the menu window, click the [x] cancel button.

.SH AUTHORS
 Written by Michael Cornelison <kornelix@posteo.de>
 http://kornelix.net


