;; ----------------------------------------------------------------------------
;; combat-maps.scm - terrain combat maps
;;
;; Pre: terrain.scm, palette.scm
;; ----------------------------------------------------------------------------

(kern-mk-map 
 'm_forest_combat ;; tag
 19               ;; width
 19               ;; height;
 pal_expanded     ;; palette
 (list
    "tt tt tt .. .. tt tt tt .. .. .. .. .. .. .. tt || || ||";
    "tt tt .. .. .. .. tt .. .. .. .. .. .. .. .. tt bb || ||";
    "|| tt .. .. tt .. .. .. tt tt tt .. .. .. .. tt || || tt";
    "|| || tt .. .. tt .. .. .. tt .. .. tt .. .. tt || tt tt";
    "tt tt .. .. .. tt tt .. .. tt .. tt || tt .. .. tt .. tt";
    ".. .. .. tt .. .. .. .. .. .. .. tt || tt .. .. .. .. ..";
    ".. .. tt tt .. .. tt tt .. .. .. .. tt || tt .. .. .. ..";
    ".. .. tt .. .. tt || || tt .. .. .. tt || tt .. tt .. ..";
    ".. tt .. bb .. tt || || || tt .. tt || tt .. .. tt tt ..";
    ".. tt .. .. .. .. tt || tt .. .. bb tt .. .. .. .. tt ..";
    ".. .. .. .. tt .. .. tt .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. tt tt .. .. .. .. .. .. .. .. tt .. .. .. ..";
    ".. .. .. tt tt tt .. .. .. .. tt .. .. tt tt tt tt .. ..";
    "tt .. tt tt tt tt tt .. .. tt || tt .. tt || tt || tt ..";
    "tt tt tt || tt || tt tt .. .. tt .. .. .. tt || || tt tt";
    "|| tt || || tt tt tt .. .. .. .. .. .. .. tt || || || tt";
    "|| || || || tt .. .. .. .. tt .. .. tt .. .. tt || tt tt";
    "tt ~~ || || tt .. .. tt .. .. .. .. .. .. .. tt tt tt tt";
    "tt || || tt tt tt .. .. .. .. .. tt tt .. .. .. tt .. ..";
    ))

(kern-mk-map 
 'm_grass_combat  ;; tag
 19               ;; width
 19               ;; height;
 pal_expanded     ;; palette
 (list
    ".. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. .. ..";
    ".. .. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt bb tt .. .. tt .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt bb tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. tt .. .. .. .. .. .. .. .. tt .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. ..";
    ".. .. .. .. .. .. .. .. tt .. .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. .. .. tt .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. tt .. .. .. .. .. .. .. .. .. bb .. ..";
    ".. tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt .. .. .. .. .. .. .. .. tt .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. .. .. tt .. .. .. .. .. .. .. tt";
    ))

(kern-mk-map 
 'm_hill_combat   ;; tag
 19               ;; width
 19               ;; height;
 pal_expanded     ;; palette
 (list
    "^^ ^^ ^^ {{ .. .. .. .. .. .. .. .. .. {{ {{ {{ {{ ^^ ^^ ";
    "^^ ^^ {{ {{ .. .. .. .. .. .. .. .. {{ {{ ^^ {{ {{ {{ ^^ ";
    "^^ ^^ {{ {{ .. {{ {{ {{ {{ .. .. {{ {{ ^^ ^^ ^^ {{ {{ {{ ";
    "{{ ^^ ^^ {{ {{ {{ ^^ ^^ {{ .. {{ {{ {{ ^^ ^^ {{ {{ {{ {{ ";
    "{{ {{ {{ {{ {{ ^^ ^^ ^^ {{ .. {{ ^^ ^^ ^^ {{ {{ {{ ^^ ^^ ";
    ".. {{ {{ {{ ^^ ^^ ^^ {{ {{ .. ^^ ^^ ^^ ^^ {{ .. {{ {{ ^^ ";
    ".. .. {{ ^^ ^^ ^^ {{ {{ .. .. {{ ^^ ^^ ^^ {{ {{ .. {{ {{ ";
    ".. .. {{ ^^ ^^ {{ {{ .. .. .. {{ {{ ^^ ^^ ^^ {{ .. .. .. ";
    ".. .. {{ {{ {{ {{ .. .. .. .. .. {{ {{ {{ ^^ {{ .. .. .. ";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. {{ {{ {{ .. .. .. ";
    ".. .. .. .. .. .. .. {{ .. .. .. .. .. .. .. .. .. .. .. ";
    "{{ {{ .. {{ {{ {{ {{ {{ {{ .. .. {{ {{ {{ {{ {{ {{ {{ .. ";
    "^^ {{ {{ {{ ^^ ^^ ^^ ^^ {{ .. {{ {{ ^^ ^^ {{ {{ ^^ {{ .. ";
    "^^ ^^ ^^ {{ {{ ^^ ^^ {{ {{ .. {{ {{ {{ ^^ ^^ ^^ ^^ {{ .. ";
    "^^ {{ ^^ ^^ {{ {{ {{ {{ .. .. {{ {{ {{ ^^ ^^ {{ {{ {{ .. ";
    "{{ {{ {{ {{ {{ .. .. .. .. .. {{ {{ ^^ ^^ {{ {{ .. .. .. ";
    "{{ {{ .. .. .. .. .. .. .. .. .. {{ {{ {{ {{ .. .. {{ {{ ";
    "^^ {{ {{ .. .. .. .. .. .. .. .. .. .. .. .. .. {{ {{ ^^ ";
    "^^ ^^ {{ .. .. .. .. .. .. .. .. .. .. .. .. .. {{ ^^ ^^ ";
    ))

(kern-mk-map 
 'm_trail_0_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. .. ..";
    ".. .. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt bb tt .. .. tt .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt bb tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. tt .. .. .. .. .. .. .. .. tt .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. tt .. /f /f /f .. .. .. .. .. bb .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tt";
    ))

(kern-mk-map 
 'm_trail_1_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. .. ..";
    ".. .. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt bb tt .. .. tt .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt bb tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. tt .. .. .. .. .. .. .. .. tt .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. tt .. /f /f /f .. .. .. .. .. bb .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f tt .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tt";
    ))

(kern-mk-map 
 'm_trail_2_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. .. ..";
    ".. .. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt bb tt .. .. tt .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt bb tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. tt .. .. .. .. .. .. .. .. tt .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. tt .. /f /f /f .. .. .. .. .. bb .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f tt .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tt";
    ))

(kern-mk-map 
 'm_trail_3_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. .. ..";
    ".. .. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. tt .. /f /f /f .. .. .. .. .. bb .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f tt .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tt";
    ))

(kern-mk-map 
 'm_trail_4_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. tt .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. tt .. /f /f /f .. .. .. .. .. bb .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f tt .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tt";
    ))

(kern-mk-map 
 'm_trail_5_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. tt .. /f /f /f .. .. .. .. .. bb .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f tt .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tt";
    ))

(kern-mk-map 
 'm_trail_6_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. tt .. /f /f /f .. .. .. .. .. bb .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f tt .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tt";
    ))

(kern-mk-map 
 'm_trail_7_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. tt .. /f /f /f .. .. .. .. .. bb .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f tt .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tt";
    ))

(kern-mk-map 
 'm_trail_8_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. tt .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. .. .. .. .. .. /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. .. ..";
    ".. .. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt bb tt .. .. tt .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt bb tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. tt .. .. .. .. .. .. .. .. tt .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ))

(kern-mk-map 
 'm_trail_9_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. .. ..";
    ".. .. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt bb tt .. .. tt .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt bb tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. tt .. .. .. .. .. .. .. .. tt .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ))

(kern-mk-map 
 'm_trail_a_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. .. ..";
    ".. .. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt bb tt .. .. tt .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt bb tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. tt .. .. .. .. .. .. .. .. tt .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ))

(kern-mk-map 
 'm_trail_b_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    "tt .. .. .. .. .. .. .. /f /f /f .. .. .. .. tt .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. tt .. /f /f /f .. .. .. .. .. bb .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. ..";
    ".. tt tt .. .. .. .. .. /f /f /f tt .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. /f /f /f .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. .. ..";
    ".. .. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ))

(kern-mk-map 
 'm_trail_c_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. .. ..";
    ".. .. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt bb tt .. .. tt .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt bb tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. tt .. .. .. .. .. .. .. .. tt .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. .. /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. tt .. .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. tt tt tt .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. tt .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt tt";
    ))

(kern-mk-map 
 'm_trail_d_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. tt .. .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. tt tt tt .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. tt .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt tt";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. .. ..";
    ".. .. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt bb tt .. .. tt .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt bb tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. tt .. .. .. .. .. .. .. .. tt .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ))

(kern-mk-map 
 'm_trail_e_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. tt .. .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. tt tt tt .. .. .. .. .. .. .. .. ..";
    ".. .. .. .. .. .. .. .. tt .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt tt";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f .. .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f .. .. ..";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. tt .. .. .. .. ..";
    ".. .. .. tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. .. tt bb tt .. .. tt .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt tt tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ".. tt bb tt .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. tt .. .. .. .. .. .. .. .. tt .. .. .. .. .. tt tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. tt";
    ".. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. .. ..";
    ))

(kern-mk-map 
 'm_bridge_WE_combat  ;; tag
 19                 ;; width
 19                 ;; height;
 pal_expanded       ;; palette
 (list
    ".. .. tt ~~ ~~ -- -- -- __ __ __ -- -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- -- __ __ __ -- -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- -- __ __ __ -- -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- -- __ ~~ __ -- -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- -- ~~ .. ~~ -- -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- ~~ .. .. .. ~~ -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- ~~ .. bb .. ~~ -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- ~~ .. bb .. ~~ -- -- ~~ ~~ tt .. ..";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    "/f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f /f";
    ".. .. tt ~~ ~~ -- -- ~~ .. bb .. ~~ -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- ~~ .. bb .. ~~ -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- ~~ .. .. .. ~~ -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- ~~ ~~ .. ~~ ~~ -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- -- ~~ ~~ ~~ -- -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- -- __ ~~ __ -- -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- -- __ __ __ -- -- -- ~~ ~~ tt .. ..";
    ".. .. tt ~~ ~~ -- -- -- __ __ __ -- -- -- ~~ ~~ tt .. ..";
    ))

(kern-terrain-set-combat-map t_grass m_grass_combat)
(kern-terrain-set-combat-map t_forest m_forest_combat)
(kern-terrain-set-combat-map t_hills m_hill_combat)

(kern-terrain-set-combat-map t_trail_0 m_trail_0_combat)
(kern-terrain-set-combat-map t_trail_1 m_trail_1_combat)
(kern-terrain-set-combat-map t_trail_2 m_trail_2_combat)
(kern-terrain-set-combat-map t_trail_3 m_trail_3_combat)
(kern-terrain-set-combat-map t_trail_4 m_trail_4_combat)
(kern-terrain-set-combat-map t_trail_5 m_trail_5_combat)
(kern-terrain-set-combat-map t_trail_6 m_trail_6_combat)
(kern-terrain-set-combat-map t_trail_7 m_trail_7_combat)
(kern-terrain-set-combat-map t_trail_8 m_trail_8_combat)
(kern-terrain-set-combat-map t_trail_9 m_trail_9_combat)
(kern-terrain-set-combat-map t_trail_a m_trail_a_combat)
(kern-terrain-set-combat-map t_trail_b m_trail_b_combat)
(kern-terrain-set-combat-map t_trail_c m_trail_c_combat)
(kern-terrain-set-combat-map t_trail_d m_trail_d_combat)
(kern-terrain-set-combat-map t_trail_e m_trail_e_combat)

(kern-terrain-set-combat-map t_bridge_WE  m_bridge_WE_combat)

