;;----------------------------------------------------------------------------
;; Sprites
;;----------------------------------------------------------------------------
;; 's_some_sprite ss_some_sprite_set num_tiles tile_number wave_sprite facing_value
;; 
;; facing_value is the sum of all facings provided by this sprite.
;; The value is determined by adding:
;;    1 NorthWest
;;    2 North
;;    4 NorthEast
;;    8 West
;;   16 Here
;;   32 East
;;   64 SouthWest
;;  128 South
;;  256 SouthEast
;;  512 Up
;; 1024 Down
;; 
;; Common values include:
;;   0 Default facing (only 1 facing, used for all directions)
;;  40 WE facing
;; 170 NSEW facing
;;----------------------------------------------------------------------------

(kern-mk-sprite 's_deep          ss_u4 1  0 #t 0 )
(kern-mk-sprite 's_shallow       ss_u4 1  1 #t 0 )
(kern-mk-sprite 's_shoals        ss_u4 1  2 #t 0 )
(kern-mk-sprite 's_bog           ss_u4 1  3 #t 0 )
(kern-mk-sprite 's_grass         ss_u4 1  4 #f 0 )
(kern-mk-sprite 's_trees         ss_u4 1  5 #f 0 )
(kern-mk-sprite 's_forest        ss_u4 1  6 #f 0 )
(kern-mk-sprite 's_hills         ss_u4 1  7 #f 0 )
(kern-mk-sprite 's_mountains     ss_u4 1  8 #f 0 )
(kern-mk-sprite 's_dungeon       ss_u4 1  9 #f 0 )
(kern-mk-sprite 's_town          ss_u4 1 10 #f 0 )
(kern-mk-sprite 's_keep          ss_u4 1 11 #f 0 )
(kern-mk-sprite 's_hamlet        ss_u4 1 12 #f 0 )
(kern-mk-sprite 's_leftwing      ss_u4 1 13 #f 0 )
(kern-mk-sprite 's_castle        ss_u4 1 14 #f 0 )
(kern-mk-sprite 's_rightwing     ss_u4 1 15 #f 0 )
(kern-mk-sprite 's_cobblestone   ss_u4 1 22 #f 0 )
(kern-mk-sprite 's_ew_bridge     ss_u4 1 23 #f 0 )
(kern-mk-sprite 's_ballon        ss_u4 1 24 #f 0 )
(kern-mk-sprite 's_bridge_top    ss_u4 1 25 #f 0 )
(kern-mk-sprite 's_bridge_bottom ss_u4 1 26 #f 0 )
(kern-mk-sprite 's_ladder_up     ss_u4 1 27 #f 0 )
(kern-mk-sprite 's_ladder_down   ss_u4 1 28 #f 0 )
(kern-mk-sprite 's_ruin          ss_u4 1 29 #f 0 )
(kern-mk-sprite 's_shrine        ss_u4 1 30 #f 0 )

(kern-mk-sprite 's_avatar             ss_u4 1 31 #f 0 )
(kern-mk-sprite 's_companion_wizard   ss_u4 2 32 #f 0 )
(kern-mk-sprite 's_companion_bard     ss_u4 2 34 #f 0 )
(kern-mk-sprite 's_companion_fighter  ss_u4 2 36 #f 0 )
(kern-mk-sprite 's_companion_druid    ss_u4 2 38 #f 0 )
(kern-mk-sprite 's_companion_tinker   ss_u4 2 40 #f 0 )
(kern-mk-sprite 's_companion_paladin  ss_u4 2 42 #f 0 )
(kern-mk-sprite 's_companion_ranger   ss_u4 2 44 #f 0 )
(kern-mk-sprite 's_companion_shepherd ss_u4 2 46 #f 0 )


(kern-mk-sprite 's_pillar      ss_u4 1 48 #f 0 )
(kern-mk-sprite 's_wall_b      ss_u4 1 49 #f 0 )
(kern-mk-sprite 's_wall_a      ss_u4 1 50 #f 0 )
(kern-mk-sprite 's_wall_c      ss_u4 1 51 #f 0 )
(kern-mk-sprite 's_wall_d      ss_u4 1 52 #f 0 )
(kern-mk-sprite 's_mast        ss_u4 1 53 #f 0 )
(kern-mk-sprite 's_ships_wheel ss_u4 1 54 #f 0 )
(kern-mk-sprite 's_boulder     ss_u4 1 55 #f 0 )
(kern-mk-sprite 's_corpse      ss_u4 1 56 #f 0 )
(kern-mk-sprite 's_wall_rock   ss_u4 1 57 #f 0 )
(kern-mk-sprite 's_door_locked ss_u4 1 58 #f 0 )
(kern-mk-sprite 's_door        ss_u4 1 59 #f 0 )
(kern-mk-sprite 's_chest       ss_u4 1 60 #f 0 )
(kern-mk-sprite 's_ankh        ss_u4 1 61 #f 0 )
(kern-mk-sprite 's_flagstone   ss_u4 1 62 #f 0 )
(kern-mk-sprite 's_deck        ss_u4 1 63 #f 0 )

(kern-mk-sprite 's_moongate_quarter        ss_u4 1 64 #f 0 )
(kern-mk-sprite 's_moongate_half           ss_u4 1 65 #f 0 )
(kern-mk-sprite 's_moongate_three_quarters ss_u4 1 66 #f 0 )
(kern-mk-sprite 's_moongate_full           ss_u4 1 67 #f 0 )

(kern-mk-sprite 's_field_poison ss_u4 1 68 #t 0 )
(kern-mk-sprite 's_field_energy ss_u4 1 69 #t 0 )
(kern-mk-sprite 's_field_fire   ss_u4 1 70 #t 0 )
(kern-mk-sprite 's_field_sleep  ss_u4 1 71 #t 0 )
(kern-mk-sprite 's_wall         ss_u4 1 72 #f 0 )
(kern-mk-sprite 's_secret_door  ss_u4 1 73 #f 0 )
(kern-mk-sprite 's_altar        ss_u4 1 74 #f 0 )
(kern-mk-sprite 's_lava         ss_u4 1 76 #t 0 )
(kern-mk-sprite 's_projectile   ss_u4 1 77 #f 0 )
(kern-mk-sprite 's_magic        ss_u4 1 78 #f 0 )
(kern-mk-sprite 's_hit          ss_u4 1 79 #f 0 )
(kern-mk-sprite 's_guard        ss_u4 2 80 #f 0 )
(kern-mk-sprite 's_townsman     ss_u4 2 82 #f 0 )
(kern-mk-sprite 's_bard         ss_u4 2 84 #f 0 )
(kern-mk-sprite 's_jester       ss_u4 2 86 #f 0 )
(kern-mk-sprite 's_beggar       ss_u4 2 88 #f 0 )
(kern-mk-sprite 's_child        ss_u4 2 90 #f 0 )
(kern-mk-sprite 's_bull         ss_u4 2 92 #f 0 )
(kern-mk-sprite 's_aristocrat   ss_u4 2 94 #f 0 )

(kern-mk-sprite 's_A ss_u4 1  96 #f 0 )
(kern-mk-sprite 's_B ss_u4 1  97 #f 0 )
(kern-mk-sprite 's_C ss_u4 1  98 #f 0 )
(kern-mk-sprite 's_D ss_u4 1  99 #f 0 )
(kern-mk-sprite 's_E ss_u4 1 100 #f 0 )
(kern-mk-sprite 's_F ss_u4 1 101 #f 0 )
(kern-mk-sprite 's_G ss_u4 1 102 #f 0 )
(kern-mk-sprite 's_H ss_u4 1 103 #f 0 )
(kern-mk-sprite 's_I ss_u4 1 104 #f 0 )
(kern-mk-sprite 's_J ss_u4 1 105 #f 0 )
(kern-mk-sprite 's_K ss_u4 1 106 #f 0 )
(kern-mk-sprite 's_L ss_u4 1 107 #f 0 )
(kern-mk-sprite 's_M ss_u4 1 108 #f 0 )
(kern-mk-sprite 's_N ss_u4 1 109 #f 0 )
(kern-mk-sprite 's_O ss_u4 1 110 #f 0 )
(kern-mk-sprite 's_P ss_u4 1 111 #f 0 )
(kern-mk-sprite 's_Q ss_u4 1 112 #f 0 )
(kern-mk-sprite 's_R ss_u4 1 113 #f 0 )
(kern-mk-sprite 's_S ss_u4 1 114 #f 0 )
(kern-mk-sprite 's_T ss_u4 1 115 #f 0 )
(kern-mk-sprite 's_U ss_u4 1 116 #f 0 )
(kern-mk-sprite 's_V ss_u4 1 117 #f 0 )
(kern-mk-sprite 's_W ss_u4 1 118 #f 0 )
(kern-mk-sprite 's_X ss_u4 1 119 #f 0 )
(kern-mk-sprite 's_Y ss_u4 1 120 #f 0 )
(kern-mk-sprite 's_Z ss_u4 1 121 #f 0 )

(kern-mk-sprite 's_counter_2x1_c ss_u4 1 122 #f 0 )
(kern-mk-sprite 's_counter_2x1_e ss_u4 1 123 #f 0 )
(kern-mk-sprite 's_counter_2x1_w ss_u4 1 124 #f 0 )
(kern-mk-sprite 's_counter_1x1   ss_u4 1 125 #f 0 )

(kern-mk-sprite 's_blank          ss_u4 1 126 #f 0 )
(kern-mk-sprite 's_null           ss_u4 1 126 #f 0 )
(kern-mk-sprite 's_wall_stone     ss_u4 1 127 #f 0 )

0(kern-mk-sprite 's_pirate_left    ss_u4 1 128 #f 0 )
(kern-mk-sprite 's_pirate_front   ss_u4 1 129 #f 0 )
(kern-mk-sprite 's_pirate_right   ss_u4 1 130 #f 0 )
(kern-mk-sprite 's_pirate_back    ss_u4 1 131 #f 0 )

(kern-mk-sprite 's_nixie          ss_u4 2 132 #f 0 )
(kern-mk-sprite 's_kraken         ss_u4 2 134 #f 0 )
(kern-mk-sprite 's_sea_serpent    ss_u4 2 136 #f 0 )
(kern-mk-sprite 's_sea_horse      ss_u4 2 138 #f 0 )
(kern-mk-sprite 's_whirlpool      ss_u4 2 140 #f 0 )
(kern-mk-sprite 's_tornado        ss_u4 2 142 #f 0 )

(kern-mk-sprite 's_rat            ss_u4 4 144 #f 0 )
(kern-mk-sprite 's_bat            ss_u4 4 148 #f 0 )
(kern-mk-sprite 's_spider         ss_u4 4 152 #f 0 )
(kern-mk-sprite 's_ghost          ss_u4 4 156 #f 0 )
(kern-mk-sprite 's_slime          ss_u4 4 160 #f 0 )
(kern-mk-sprite 's_slime_asleep   ss_u4 1 160 #f 0 )
(kern-mk-sprite 's_troll          ss_u4 4 164 #f 0 )
(kern-mk-sprite 's_gremlin        ss_u4 4 168 #f 0 )
(kern-mk-sprite 's_mimic          ss_u4 4 172 #f 0 )
(kern-mk-sprite 's_reaper         ss_u4 4 176 #f 0 )
(kern-mk-sprite 's_insects        ss_u4 4 180 #f 0 )
(kern-mk-sprite 's_gazer          ss_u4 4 184 #f 0 )
(kern-mk-sprite 's_knight         ss_u4 4 188 #f 0 )
(kern-mk-sprite 's_orc            ss_u4 4 192 #f 0 )
(kern-mk-sprite 's_skeleton       ss_u4 4 196 #f 0 )
(kern-mk-sprite 's_brigand        ss_u4 4 200 #f 0 )
(kern-mk-sprite 's_snake          ss_u4 4 204 #f 0 )
(kern-mk-sprite 's_ettin          ss_u4 4 208 #f 0 )
(kern-mk-sprite 's_headless       ss_u4 4 212 #f 0 )
(kern-mk-sprite 's_cyclops        ss_u4 4 216 #f 0 )
(kern-mk-sprite 's_wisp           ss_u4 4 220 #f 0 )
(kern-mk-sprite 's_wizard         ss_u4 4 224 #f 0 )
(kern-mk-sprite 's_lich           ss_u4 4 228 #f 0 )
(kern-mk-sprite 's_drake          ss_u4 4 232 #f 0 )
(kern-mk-sprite 's_xorn           ss_u4 4 236 #f 0 )
(kern-mk-sprite 's_demon          ss_u4 4 240 #f 0 )
(kern-mk-sprite 's_hydra          ss_u4 4 244 #f 0 )
(kern-mk-sprite 's_dragon         ss_u4 4 248 #f 0 )
(kern-mk-sprite 's_balron         ss_u4 4 252 #f 0 )


(kern-mk-sprite 's_crosshair            ss_mine 1  0 #f   0 )
(kern-mk-sprite 's_arrow                ss_mine 1  1 #f 170 )
(kern-mk-sprite 's_horse                ss_mine 1  5 #f  40 )
(kern-mk-sprite 's_happy_monster_face   ss_mine 1  7 #f   0 )
(kern-mk-sprite 's_ship                 ss_mine 1  8 #f 170 )
(kern-mk-sprite 's_bolt                 ss_mine 1 12 #f 170 )

(kern-mk-sprite 's_hdoor                ss_mine 1 19 #f 0 )
(kern-mk-sprite 's_hdoor_locked         ss_mine 1 20 #f 0 )
(kern-mk-sprite 's_portcullis_down      ss_mine 1 21 #f 0 )
(kern-mk-sprite 's_portcullis_up        ss_mine 1 22 #f 0 )

(kern-mk-sprite 's_forest_yellow        ss_mine 1 23 #f 0 )
(kern-mk-sprite 's_L_lever_up           ss_mine 1 24 #f 0 )
(kern-mk-sprite 's_L_lever_down         ss_mine 1 25 #f 0 )
(kern-mk-sprite 's_R_lever_up           ss_mine 1 26 #f 0 )
(kern-mk-sprite 's_R_lever_down         ss_mine 1 27 #f 0 )
(kern-mk-sprite 's_floor_plate          ss_mine 1 28 #f 0 )

(kern-mk-sprite 's_ns_bridge            ss_mine 1 29 #f 0 )
(kern-mk-sprite 's_forest_purple        ss_mine 1 30 #f 0 )
(kern-mk-sprite 's_forest_red           ss_mine 1 31 #f 0 )
(kern-mk-sprite 's_trees_orange         ss_mine 1 32 #f 0 )
(kern-mk-sprite 's_trees_yellow         ss_mine 1 33 #f 0 )
(kern-mk-sprite 's_trees_purple         ss_mine 1 34 #f 0 )
(kern-mk-sprite 's_trees_red            ss_mine 1 35 #f 0 )
(kern-mk-sprite 's_bed                  ss_mine 1 36 #f 0 )
(kern-mk-sprite 's_fireplace            ss_mine 2 37 #f 0 )
(kern-mk-sprite 's_green_townsman       ss_mine 2 40 #f 0 )
(kern-mk-sprite 's_yellow_slime         ss_mine 4 42 #f 0 )
(kern-mk-sprite 's_yellow_slime_asleep  ss_mine 1 42 #f 0 )
(kern-mk-sprite 's_wall_torch           ss_mine 2 46 #f 0 )
(kern-mk-sprite 's_water_elemental      ss_mine 1 48 #t 0 )

(kern-mk-sprite 's_closed_solid_wood_door_in_stone            ss_mine 1 49 #f 0 )
(kern-mk-sprite 's_open_door_in_stone                         ss_mine 1 50 #f 0 )
(kern-mk-sprite 's_locked_solid_wood_door_in_stone            ss_mine 1 51 #f 0 )
(kern-mk-sprite 's_magically_locked_solid_wood_door_in_stone  ss_mine 3 52 #f 0 )
(kern-mk-sprite 's_scratched_shield                           ss_mine 1 55 #f 0 )
(kern-mk-sprite 's_closed_solid_wood_door_in_rock             ss_mine 1 56 #f 0 )
(kern-mk-sprite 's_open_door_in_rock                          ss_mine 1 57 #f 0 )
(kern-mk-sprite 's_locked_solid_wood_door_in_rock             ss_mine 1 58 #f 0 )
(kern-mk-sprite 's_magically_locked_solid_wood_door_in_rock   ss_mine 3 59 #f 0 )
(kern-mk-sprite 's_closed_windowed_wood_door_in_rock          ss_mine 1 68 #f 0 )
(kern-mk-sprite 's_locked_windowed_wood_door_in_rock          ss_mine 1 69 #f 0 )
(kern-mk-sprite 's_magically_locked_windowed_wood_door_in_rock ss_mine 3 76 #f 0 )

(kern-mk-sprite 's_arrow_slit       ss_mine 1 62 #f 0 )
(kern-mk-sprite 's_window_in_stone  ss_mine 1 63 #f 0 )

(kern-mk-sprite 's_trail_0  ss_mine 1 64 #f 0 )
(kern-mk-sprite 's_trail_1  ss_mine 1 65 #f 0 )
(kern-mk-sprite 's_trail_2  ss_mine 1 66 #f 0 )
(kern-mk-sprite 's_trail_3  ss_mine 1 67 #f 0 )
(kern-mk-sprite 's_trail_4  ss_mine 1 72 #f 0 )
(kern-mk-sprite 's_trail_5  ss_mine 1 73 #f 0 )
(kern-mk-sprite 's_trail_6  ss_mine 1 74 #f 0 )
(kern-mk-sprite 's_trail_7  ss_mine 1 75 #f 0 )
(kern-mk-sprite 's_trail_8  ss_mine 1 80 #f 0 )
(kern-mk-sprite 's_trail_9  ss_mine 1 81 #f 0 )
(kern-mk-sprite 's_trail_a  ss_mine 1 82 #f 0 )
(kern-mk-sprite 's_trail_b  ss_mine 1 83 #f 0 )
(kern-mk-sprite 's_trail_c  ss_mine 1 88 #f 0 )
(kern-mk-sprite 's_trail_d  ss_mine 1 89 #f 0 )
(kern-mk-sprite 's_trail_e  ss_mine 1 90 #f 0 )
(kern-mk-sprite 's_trail_f  ss_mine 1 91 #f 0 )

(kern-mk-sprite 's_frame_ulc   ss_frame_orig 1  0 #f 0 )
(kern-mk-sprite 's_frame_td    ss_frame_orig 1  1 #f 0 )
(kern-mk-sprite 's_frame_urc   ss_frame_orig 1  2 #f 0 )
(kern-mk-sprite 's_frame_endu  ss_frame_orig 1  3 #f 0 )  ; top of vertical bar, currently unused
(kern-mk-sprite 's_frame_tr    ss_frame_orig 1  4 #f 0 )
(kern-mk-sprite 's_frame_plus  ss_frame_orig 1  5 #f 0 )  ; center crosspiece, currently unused
(kern-mk-sprite 's_frame_tl    ss_frame_orig 1  6 #f 0 )
(kern-mk-sprite 's_frame_vert  ss_frame_orig 1  7 #f 0 )
(kern-mk-sprite 's_frame_llc   ss_frame_orig 1  8 #f 0 )
(kern-mk-sprite 's_frame_tu    ss_frame_orig 1  9 #f 0 )
(kern-mk-sprite 's_frame_lrc   ss_frame_orig 1 10 #f 0 )
(kern-mk-sprite 's_frame_endb  ss_frame_orig 1 11 #f 0 )  ; bottom of vertical bar, currently unused
(kern-mk-sprite 's_frame_endl  ss_frame_orig 1 12 #f 0 )
(kern-mk-sprite 's_frame_horz  ss_frame_orig 1 13 #f 0 )
(kern-mk-sprite 's_frame_endr  ss_frame_orig 1 14 #f 0 )
(kern-mk-sprite 's_frame_dot   ss_frame_orig 1 15 #f 0 )  ; disconnected disk, currently unused

(kern-mk-sprite 's_full_moon                ss_moons 1 0 #f 0 )
(kern-mk-sprite 's_wane_three_quarter_moon  ss_moons 1 1 #f 0 )
(kern-mk-sprite 's_wane_half_moon           ss_moons 1 2 #f 0 )
(kern-mk-sprite 's_wane_quarter_moon        ss_moons 1 3 #f 0 )
(kern-mk-sprite 's_new_moon                 ss_moons 1 4 #f 0 )
(kern-mk-sprite 's_wax_quarter_moon         ss_moons 1 5 #f 0 )
(kern-mk-sprite 's_wax_half_moon            ss_moons 1 6 #f 0 )
(kern-mk-sprite 's_wax_three_quarter_moon   ss_moons 1 7 #f 0 )
(kern-mk-sprite 's_sun                      ss_moons 1 8 #f 0 )

(kern-mk-sprite 's_left_lever_up      ss_mechanisms 1  0 #f 0 )
(kern-mk-sprite 's_left_lever_down    ss_mechanisms 1  1 #f 0 )
(kern-mk-sprite 's_top_lever_left     ss_mechanisms 1  2 #f 0 )
(kern-mk-sprite 's_top_lever_right    ss_mechanisms 1  3 #f 0 )
(kern-mk-sprite 's_right_lever_up     ss_mechanisms 1  4 #f 0 )
(kern-mk-sprite 's_right_lever_down   ss_mechanisms 1  5 #f 0 )
(kern-mk-sprite 's_bottom_lever_left  ss_mechanisms 1  6 #f 0 )
(kern-mk-sprite 's_bottom_lever_right ss_mechanisms 1  7 #f 0 )
(kern-mk-sprite 's_floor_plate        ss_mechanisms 1  8 #f 0 )
(kern-mk-sprite 's_floor_lever_left   ss_mechanisms 1 10 #f 0 )
(kern-mk-sprite 's_floor_lever_right  ss_mechanisms 1 11 #f 0 )

(kern-mk-sprite 'ls_ankh          ss_little_sprites 1  0 #f 0 )
(kern-mk-sprite 'ls_shield        ss_little_sprites 1  1 #f 0 )
(kern-mk-sprite 'ls_holey_wall    ss_little_sprites 1  2 #f 0 )
(kern-mk-sprite 'ls_wall          ss_little_sprites 1  3 #f 0 )
(kern-mk-sprite 'ls_updown_arrow  ss_little_sprites 1  4 #f 0 )
(kern-mk-sprite 'ls_down_arrow    ss_little_sprites 1  5 #f 0 )
(kern-mk-sprite 'ls_up_arrow      ss_little_sprites 1  6 #f 0 )
(kern-mk-sprite 'ls_holey_ankh    ss_little_sprites 1  7 #f 0 )
(kern-mk-sprite 'ls_white_ball    ss_little_sprites 1  8 #f 0 )
(kern-mk-sprite 'ls_copyright     ss_little_sprites 1  9 #f 0 )
(kern-mk-sprite 'ls_trademark     ss_little_sprites 1 10 #f 0 )
(kern-mk-sprite 'ls_male          ss_little_sprites 1 11 #f 0 )
(kern-mk-sprite 'ls_female        ss_little_sprites 1 12 #f 0 )
(kern-mk-sprite 'ls_hbar          ss_little_sprites 1 13 #f 0 )
(kern-mk-sprite 'ls_vbar          ss_little_sprites 1 13 #f 0 )
(kern-mk-sprite 'ls_square        ss_little_sprites 1 14 #f 0 )
(kern-mk-sprite 'ls_blue_ball     ss_little_sprites 1 15 #f 0 )
(kern-mk-sprite 'ls_hbar_right    ss_little_sprites 1 16 #f 0 )
(kern-mk-sprite 'ls_hbar_left     ss_little_sprites 1 17 #f 0 )
(kern-mk-sprite 'ls_vbar_top      ss_little_sprites 1 16 #f 0 )
(kern-mk-sprite 'ls_vbar_bottom   ss_little_sprites 1 17 #f 0 )
(kern-mk-sprite 'ls_blank_one     ss_little_sprites 1 18 #f 0 )
(kern-mk-sprite 'ls_dot_dot_dot   ss_little_sprites 1 19 #f 0 )
(kern-mk-sprite 'ls_whirlpool     ss_little_sprites 4 28 #f 0 )
(kern-mk-sprite 'ls_blank_three   ss_little_sprites 1 32 #f 0 )


(kern-mk-sprite 's_rune_A      ss_rune_font_32x32 1  0 #f 0 )
(kern-mk-sprite 's_rune_B      ss_rune_font_32x32 1  1 #f 0 )
(kern-mk-sprite 's_rune_C      ss_rune_font_32x32 1  2 #f 0 )
(kern-mk-sprite 's_rune_D      ss_rune_font_32x32 1  3 #f 0 )
(kern-mk-sprite 's_rune_E      ss_rune_font_32x32 1  4 #f 0 )
(kern-mk-sprite 's_rune_F      ss_rune_font_32x32 1  5 #f 0 )
(kern-mk-sprite 's_rune_G      ss_rune_font_32x32 1  6 #f 0 )
(kern-mk-sprite 's_rune_H      ss_rune_font_32x32 1  7 #f 0 )
(kern-mk-sprite 's_rune_I      ss_rune_font_32x32 1  8 #f 0 )
(kern-mk-sprite 's_rune_J      ss_rune_font_32x32 1  9 #f 0 )
(kern-mk-sprite 's_rune_K      ss_rune_font_32x32 1 10 #f 0 )
(kern-mk-sprite 's_rune_L      ss_rune_font_32x32 1 11 #f 0 )
(kern-mk-sprite 's_rune_M      ss_rune_font_32x32 1 12 #f 0 )
(kern-mk-sprite 's_rune_N      ss_rune_font_32x32 1 13 #f 0 )
(kern-mk-sprite 's_rune_O      ss_rune_font_32x32 1 14 #f 0 )
(kern-mk-sprite 's_rune_P      ss_rune_font_32x32 1 15 #f 0 )
(kern-mk-sprite 's_rune_Q      ss_rune_font_32x32 1 16 #f 0 )
(kern-mk-sprite 's_rune_R      ss_rune_font_32x32 1 17 #f 0 )
(kern-mk-sprite 's_rune_S      ss_rune_font_32x32 1 18 #f 0 )
(kern-mk-sprite 's_rune_T      ss_rune_font_32x32 1 19 #f 0 )
(kern-mk-sprite 's_rune_U      ss_rune_font_32x32 1 20 #f 0 )
(kern-mk-sprite 's_rune_V      ss_rune_font_32x32 1 21 #f 0 )
(kern-mk-sprite 's_rune_W      ss_rune_font_32x32 1 22 #f 0 )
(kern-mk-sprite 's_rune_X      ss_rune_font_32x32 1 23 #f 0 )
(kern-mk-sprite 's_rune_Y      ss_rune_font_32x32 1 24 #f 0 )
(kern-mk-sprite 's_rune_Z      ss_rune_font_32x32 1 25 #f 0 )
(kern-mk-sprite 's_rune_TH     ss_rune_font_32x32 1 26 #f 0 )
(kern-mk-sprite 's_rune_EE     ss_rune_font_32x32 1 27 #f 0 )
(kern-mk-sprite 's_rune_NG     ss_rune_font_32x32 1 28 #f 0 )
(kern-mk-sprite 's_rune_EA     ss_rune_font_32x32 1 29 #f 0 )
(kern-mk-sprite 's_rune_ST     ss_rune_font_32x32 1 30 #f 0 )
(kern-mk-sprite 's_rune_DOTSEP ss_rune_font_32x32 1 31 #f 0 )

(kern-mk-sprite 'ls_rune_A       ss_rune_font_8x16 1  0 #f 0 )
(kern-mk-sprite 'ls_rune_B       ss_rune_font_8x16 1  1 #f 0 )
(kern-mk-sprite 'ls_rune_C       ss_rune_font_8x16 1  2 #f 0 )
(kern-mk-sprite 'ls_rune_D       ss_rune_font_8x16 1  3 #f 0 )
(kern-mk-sprite 'ls_rune_E       ss_rune_font_8x16 1  4 #f 0 )
(kern-mk-sprite 'ls_rune_F       ss_rune_font_8x16 1  5 #f 0 )
(kern-mk-sprite 'ls_rune_G       ss_rune_font_8x16 1  6 #f 0 )
(kern-mk-sprite 'ls_rune_H       ss_rune_font_8x16 1  7 #f 0 )
(kern-mk-sprite 'ls_rune_I       ss_rune_font_8x16 1  8 #f 0 )
(kern-mk-sprite 'ls_rune_J       ss_rune_font_8x16 1  9 #f 0 )
(kern-mk-sprite 'ls_rune_K       ss_rune_font_8x16 1 10 #f 0 )
(kern-mk-sprite 'ls_rune_L       ss_rune_font_8x16 1 11 #f 0 )
(kern-mk-sprite 'ls_rune_M       ss_rune_font_8x16 1 12 #f 0 )
(kern-mk-sprite 'ls_rune_N       ss_rune_font_8x16 1 13 #f 0 )
(kern-mk-sprite 'ls_rune_O       ss_rune_font_8x16 1 14 #f 0 )
(kern-mk-sprite 'ls_rune_P       ss_rune_font_8x16 1 15 #f 0 )
(kern-mk-sprite 'ls_rune_Q       ss_rune_font_8x16 1 16 #f 0 )
(kern-mk-sprite 'ls_rune_R       ss_rune_font_8x16 1 17 #f 0 )
(kern-mk-sprite 'ls_rune_S       ss_rune_font_8x16 1 18 #f 0 )
(kern-mk-sprite 'ls_rune_T       ss_rune_font_8x16 1 19 #f 0 )
(kern-mk-sprite 'ls_rune_U       ss_rune_font_8x16 1 20 #f 0 )
(kern-mk-sprite 'ls_rune_V       ss_rune_font_8x16 1 21 #f 0 )
(kern-mk-sprite 'ls_rune_W       ss_rune_font_8x16 1 22 #f 0 )
(kern-mk-sprite 'ls_rune_X       ss_rune_font_8x16 1 23 #f 0 )
(kern-mk-sprite 'ls_rune_Y       ss_rune_font_8x16 1 24 #f 0 )
(kern-mk-sprite 'ls_rune_Z       ss_rune_font_8x16 1 25 #f 0 )
(kern-mk-sprite 'ls_rune_TH      ss_rune_font_8x16 1 26 #f 0 )
(kern-mk-sprite 'ls_rune_EE      ss_rune_font_8x16 1 27 #f 0 )
(kern-mk-sprite 'ls_rune_NG      ss_rune_font_8x16 1 28 #f 0 )
(kern-mk-sprite 'ls_rune_EA      ss_rune_font_8x16 1 29 #f 0 )
(kern-mk-sprite 'ls_rune_ST      ss_rune_font_8x16 1 30 #f 0 )
(kern-mk-sprite 'ls_rune_DOTSEP  ss_rune_font_8x16 1 31 #f 0 )


(kern-mk-sprite 's_dresser  ss_lost_dragon 1 0 #f 0 )
(kern-mk-sprite 's_chair    ss_lost_dragon 1 1 #f 0 )

(kern-mk-sprite 's_gold_explosion        ss_angband 1  61 #f 0 )
(kern-mk-sprite 's_brown_powder          ss_angband 1 113 #f 0 )
(kern-mk-sprite 's_silver_powder         ss_angband 1 114 #f 0 )
(kern-mk-sprite 's_gold_powder           ss_angband 1 115 #f 0 )
(kern-mk-sprite 's_bluish_white_powder   ss_angband 1 116 #f 0 )
(kern-mk-sprite 's_greenish_white_powder ss_angband 1 117 #f 0 )
(kern-mk-sprite 's_grayish_red_hunks     ss_angband 1 118 #f 0 )
(kern-mk-sprite 's_white_hunks           ss_angband 1 119 #f 0 )
(kern-mk-sprite 's_aquamarine_hunks      ss_angband 1 120 #f 0 )
(kern-mk-sprite 's_red_hunks             ss_angband 1 121 #f 0 )
(kern-mk-sprite 's_lightblue_hunks       ss_angband 1 122 #f 0 )
(kern-mk-sprite 's_green_hunks           ss_angband 1 123 #f 0 )

(kern-mk-sprite 's_scroll1 ss_angband 1 124 #f 0 )
(kern-mk-sprite 's_scroll2 ss_angband 1 125 #f 0 )
(kern-mk-sprite 's_scroll3 ss_angband 1 126 #f 0 )
(kern-mk-sprite 's_scroll4 ss_angband 1 127 #f 0 )

(kern-mk-sprite 's_ring1  ss_angband 1 128 #f 0 )
(kern-mk-sprite 's_ring2  ss_angband 1 129 #f 0 )
(kern-mk-sprite 's_ring3  ss_angband 1 130 #f 0 )
(kern-mk-sprite 's_ring4  ss_angband 1 131 #f 0 )
(kern-mk-sprite 's_ring5  ss_angband 1 132 #f 0 )
(kern-mk-sprite 's_ring6  ss_angband 1 133 #f 0 )
(kern-mk-sprite 's_ring7  ss_angband 1 134 #f 0 )
(kern-mk-sprite 's_ring8  ss_angband 1 135 #f 0 )
(kern-mk-sprite 's_ring9  ss_angband 1 136 #f 0 )
(kern-mk-sprite 's_ring10 ss_angband 1 137 #f 0 )
(kern-mk-sprite 's_ring11 ss_angband 1 138 #f 0 )
(kern-mk-sprite 's_ring12 ss_angband 1 139 #f 0 )
(kern-mk-sprite 's_ring13 ss_angband 1 140 #f 0 )
(kern-mk-sprite 's_ring14 ss_angband 1 141 #f 0 )
(kern-mk-sprite 's_ring15 ss_angband 1 142 #f 0 )
(kern-mk-sprite 's_ring16 ss_angband 1 143 #f 0 )
(kern-mk-sprite 's_ring17 ss_angband 1 145 #f 0 )
(kern-mk-sprite 's_ring18 ss_angband 1 146 #f 0 )
(kern-mk-sprite 's_ring19 ss_angband 1 147 #f 0 )
(kern-mk-sprite 's_ring20 ss_angband 1 148 #f 0 )
(kern-mk-sprite 's_ring21 ss_angband 1 149 #f 0 )

(kern-mk-sprite 's_necklace1 ss_angband 1 150 #f 0 )
(kern-mk-sprite 's_necklace2 ss_angband 1 151 #f 0 )
(kern-mk-sprite 's_necklace3 ss_angband 1 152 #f 0 )

(kern-mk-sprite 's_small_wooden_chest ss_angband 1 153 #f 0 )
(kern-mk-sprite 's_large_wooden_chest ss_angband 1 154 #f 0 )
(kern-mk-sprite 's_small_gray_chest   ss_angband 1 155 #f 0 )
(kern-mk-sprite 's_large_gray_chest   ss_angband 1 156 #f 0 )
(kern-mk-sprite 's_small_silver_chest ss_angband 1 157 #f 0 )
(kern-mk-sprite 's_large_silver_chest ss_angband 1 158 #f 0 )
(kern-mk-sprite 's_junk_pile          ss_angband 1 159 #f 0 )

(kern-mk-sprite 's_white_potion   ss_angband 1 160 #f 0 )
(kern-mk-sprite 's_black_potion   ss_angband 1 161 #f 0 )
(kern-mk-sprite 's_orange_potion  ss_angband 1 162 #f 0 )
(kern-mk-sprite 's_red_potion     ss_angband 1 163 #f 0 )
(kern-mk-sprite 's_green_potion   ss_angband 1 164 #f 0 )
(kern-mk-sprite 's_blue_potion    ss_angband 1 165 #f 0 )
(kern-mk-sprite 's_brown_potion   ss_angband 1 166 #f 0 )
(kern-mk-sprite 's_gray_potion    ss_angband 1 167 #f 0 )
(kern-mk-sprite 's_silver_potion  ss_angband 1 168 #f 0 )
(kern-mk-sprite 's_purple_potion  ss_angband 1 169 #f 0 )
(kern-mk-sprite 's_yellow_potion  ss_angband 1 170 #f 0 )
(kern-mk-sprite 's_ruby_potion    ss_angband 1 171 #f 0 )
(kern-mk-sprite 's_emerald_potion ss_angband 1 172 #f 0 )
(kern-mk-sprite 's_skyblue_potion ss_angband 1 173 #f 0 )
(kern-mk-sprite 's_golden_potion  ss_angband 1 174 #f 0 )

(kern-mk-sprite 's_silver_mushroom   ss_angband 1 176 #f 0 )
(kern-mk-sprite 's_charcoal_mushroom ss_angband 1 177 #f 0 )
(kern-mk-sprite 's_orange_mushroom   ss_angband 1 178 #f 0 )
(kern-mk-sprite 's_blood_mushroom    ss_angband 1 179 #f 0 )
(kern-mk-sprite 's_olive_mushroom    ss_angband 1 180 #f 0 )
(kern-mk-sprite 's_turqoise_mushroom ss_angband 1 181 #f 0 )
(kern-mk-sprite 's_brown_mushroom    ss_angband 1 182 #f 0 )
(kern-mk-sprite 's_black_mushroom    ss_angband 1 183 #f 0 )
(kern-mk-sprite 's_gray_mushroom     ss_angband 1 184 #f 0 )
(kern-mk-sprite 's_purple_mushroom   ss_angband 1 185 #f 0 )
(kern-mk-sprite 's_golden_mushroom   ss_angband 1 186 #f 0 )
(kern-mk-sprite 's_ruby_mushroom     ss_angband 1 187 #f 0 )
(kern-mk-sprite 's_verdant_mushroom  ss_angband 1 188 #f 0 )
(kern-mk-sprite 's_blue_mushroom     ss_angband 1 189 #f 0 )
(kern-mk-sprite 's_sandy_mushroom    ss_angband 1 190 #f 0 )

(kern-mk-sprite 's_leather_hood  ss_angband 1 248 #f 0 )
(kern-mk-sprite 's_chain_coif    ss_angband 1 249 #f 0 )
(kern-mk-sprite 's_helm3         ss_angband 1 250 #f 0 )
(kern-mk-sprite 's_helm4         ss_angband 1 251 #f 0 )
(kern-mk-sprite 's_helm5         ss_angband 1 252 #f 0 )
(kern-mk-sprite 's_helm6         ss_angband 1 253 #f 0 )
(kern-mk-sprite 's_helm7         ss_angband 1 254 #f 0 )
(kern-mk-sprite 's_spiked_helm   ss_angband 1 255 #f 0 )
(kern-mk-sprite 's_plate_helm    ss_angband 1 256 #f 0 )
(kern-mk-sprite 's_helm10        ss_angband 1 257 #f 0 )
(kern-mk-sprite 's_helm11        ss_angband 1 258 #f 0 )
(kern-mk-sprite 's_helm12        ss_angband 1 259 #f 0 )
(kern-mk-sprite 's_helm13        ss_angband 1 260 #f 0 )
(kern-mk-sprite 's_helm14        ss_angband 1 261 #f 0 )
(kern-mk-sprite 's_helm15        ss_angband 1 262 #f 0 )
(kern-mk-sprite 's_helm16        ss_angband 1 263 #f 0 )
(kern-mk-sprite 's_helm17        ss_angband 1 264 #f 0 )
(kern-mk-sprite 's_helm18        ss_angband 1 265 #f 0 )
(kern-mk-sprite 's_helm19        ss_angband 1 266 #f 0 )
(kern-mk-sprite 's_helm20        ss_angband 1 267 #f 0 )
(kern-mk-sprite 's_helm21        ss_angband 1 268 #f 0 )
(kern-mk-sprite 's_helm22        ss_angband 1 269 #f 0 )

(kern-mk-sprite 's_shoes             ss_angband 1 270 #f 0 )
(kern-mk-sprite 's_leather_boots     ss_angband 1 271 #f 0 )
(kern-mk-sprite 's_plate_boots       ss_angband 1 272 #f 0 )

(kern-mk-sprite 's_leather_gauntlets ss_angband 1 273 #f 0 )
(kern-mk-sprite 's_plate_gauntlets   ss_angband 1 274 #f 0 )
(kern-mk-sprite 's_black_gauntlets   ss_angband 1 275 #f 0 )

(kern-mk-sprite 's_small_shield  ss_angband 1 276 #f 0 )
(kern-mk-sprite 's_large_shield  ss_angband 1 277 #f 0 )
(kern-mk-sprite 's_shield3       ss_angband 1 278 #f 0 )
(kern-mk-sprite 's_shield4       ss_angband 1 279 #f 0 )
(kern-mk-sprite 's_shield5       ss_angband 1 280 #f 0 )
(kern-mk-sprite 's_spiked_shield ss_angband 1 281 #f 0 )
(kern-mk-sprite 's_shield7       ss_angband 1 282 #f 0 )
(kern-mk-sprite 's_shield8       ss_angband 1 283 #f 0 )
(kern-mk-sprite 's_shield9       ss_angband 1 284 #f 0 )
(kern-mk-sprite 's_shield10      ss_angband 1 285 #f 0 )
(kern-mk-sprite 's_shield11      ss_angband 1 286 #f 0 )
(kern-mk-sprite 's_shield12      ss_angband 1 287 #f 0 )
(kern-mk-sprite 's_shield13      ss_angband 1 288 #f 0 )
(kern-mk-sprite 's_shield14      ss_angband 1 289 #f 0 )
(kern-mk-sprite 's_shield15      ss_angband 1 290 #f 0 )
(kern-mk-sprite 's_shield16      ss_angband 1 291 #f 0 )
(kern-mk-sprite 's_shield17      ss_angband 1 292 #f 0 )
(kern-mk-sprite 's_shield18      ss_angband 1 293 #f 0 )
(kern-mk-sprite 's_shield19      ss_angband 1 294 #f 0 )
(kern-mk-sprite 's_shield20      ss_angband 1 295 #f 0 )

(kern-mk-sprite 's_dagger     ss_angband 1  334 #f 0 )
(kern-mk-sprite 's_sword      ss_angband 1  345 #f 0 )
(kern-mk-sprite 's_hand_axe   ss_angband 1  368 #f 0 )
(kern-mk-sprite 's_long_sword ss_angband 1 1708 #f 0 )
(kern-mk-sprite 's_2h_sword   ss_angband 1 1709 #f 0 )
(kern-mk-sprite 's_2h_hammer  ss_angband 1  352 #f 0 )
(kern-mk-sprite 's_mace       ss_angband 1  353 #f 0 )
(kern-mk-sprite 's_staff      ss_angband 1  354 #f 0 )
(kern-mk-sprite 's_iron_handled_morning_star ss_angband 1 355 #f 0 )
(kern-mk-sprite 's_wood_handled_morning_star ss_angband 1 356 #f 0 )
(kern-mk-sprite 's_fat_knife                 ss_angband 1 357 #f 0 )
(kern-mk-sprite 's_ball_and_chain            ss_angband 1 358 #f 0 )
(kern-mk-sprite 's_red_handled_morning_star  ss_angband 1 359 #f 0 )
(kern-mk-sprite 's_ruby_mace ss_angband 1 360 #f 0 )
(kern-mk-sprite 's_spear     ss_angband 1 361 #f 0 )
(kern-mk-sprite 's_lght_bow  ss_angband 1 376 #f 0 )
(kern-mk-sprite 's_hvy_bow   ss_angband 1 377 #f 0 )
(kern-mk-sprite 's_lght_xbow ss_angband 1 378 #f 0 )
(kern-mk-sprite 's_hvy_xbow  ss_angband 1 379 #f 0 )
(kern-mk-sprite 's_sling     ss_angband 1 380 #f 0 )

(kern-mk-sprite 's_hard_leather  ss_angband 1 305 #f 0 )
(kern-mk-sprite 's_ring_mail     ss_angband 1 309 #f 0 )
(kern-mk-sprite 's_plate_armor   ss_angband 1 316 #f 0 )

(kern-mk-sprite 's_torch         ss_angband 1 459 #f 0 )
(kern-mk-sprite 's_explosion     ss_angband 1 570 #f 0 )
(kern-mk-sprite 's_giant         ss_angband 2 652 #f 0 )

(kern-mk-sprite 's_red_magbolt    ss_angband 1 480 #f 170)
(kern-mk-sprite 's_blue_magbolt   ss_angband 1 484 #f 170)
(kern-mk-sprite 's_cyan_magbolt   ss_angband 1 488 #f 170)
(kern-mk-sprite 's_green_magbolt  ss_angband 1 492 #f 170)
(kern-mk-sprite 's_gray_magbolt   ss_angband 1 496 #f 170)
(kern-mk-sprite 's_purple_magbolt ss_angband 1 500 #f 170)
(kern-mk-sprite 's_gold_magbolt   ss_angband 1 504 #f 170)
(kern-mk-sprite 's_black_magbolt  ss_angband 1 508 #f 170)
(kern-mk-sprite 's_gold_explosion ss_angband 1 558 #f 0)

(kern-mk-sprite 's_stone_lantern_on  ss_features_1 2  0 #f 0)
(kern-mk-sprite 's_stone_lantern_off ss_features_1 1  2 #f 0)
(kern-mk-sprite 's_hut               ss_features_1 1  3 #f 0)
(kern-mk-sprite 's_mine_entrance     ss_features_1 1 11 #f 0)
(kern-mk-sprite 's_cave_entrance     ss_features_1 1 19 #f 0)

(kern-mk-sprite 's_blackgate_quarter        ss_features_2 1 4 #f 0 )
(kern-mk-sprite 's_blackgate_half           ss_features_2 1 5 #f 0 )
(kern-mk-sprite 's_blackgate_three_quarters ss_features_2 1 6 #f 0 )
(kern-mk-sprite 's_blackgate_full           ss_features_2 1 7 #f 0 )

(kern-mk-sprite 's_thrown_boulder       ss_features_2 1 11 #f 0)
(kern-mk-sprite 's_troll_corpse         ss_features_2 1 12 #f 0)
(kern-mk-sprite 's_spider_web           ss_features_2 1 13 #f 0)
(kern-mk-sprite 's_spider_web_fragment  ss_features_2 1 14 #f 0)
(kern-mk-sprite 's_golden_skeleton_key  ss_features_2 1 15 #f 0)

(kern-mk-sprite 's_queen_spider         ss_features_2 4 16 #f 0)
(kern-mk-sprite 's_dead_spider          ss_features_2 1 20 #f 0)
(kern-mk-sprite 's_dead_queen_spider    ss_features_2 1 21 #f 0)

(kern-mk-sprite 's_toy_horse            ss_features_2 1 22 #f 0)
(kern-mk-sprite 's_gray_robed_humanoid  ss_features_2 2 24 #f 0)
(kern-mk-sprite 's_colorful_bard        ss_features_2 2 26 #f 0)

(kern-mk-sprite 's_brazier              ss_features_2 3 28 #f 0)

; (kern-mk-sprite 's_counter_1x2_n   ss_features_1 1 4 #f 0)
; (kern-mk-sprite 's_counter_3x3_nw  ss_features_1 1 5 #f 0)
; (kern-mk-sprite 's_counter_3x3_n   ss_features_1 1 6 #f 0)
; (kern-mk-sprite 's_counter_3x3_ne  ss_features_1 1 7 #f 0)
; (kern-mk-sprite 's_counter_1x2_c   ss_features_1 1 12 #f 0)
; (kern-mk-sprite 's_counter_3x3_w   ss_features_1 1 13 #f 0)
; (kern-mk-sprite 's_counter_3x3_c   ss_features_1 1 14 #f 0)
; (kern-mk-sprite 's_counter_3x3_e   ss_features_1 1 15 #f 0)
; (kern-mk-sprite 's_counter_1x2_s   ss_features_1 1 20 #f 0)
; (kern-mk-sprite 's_counter_3x3_sw  ss_features_1 1 21 #f 0)
; (kern-mk-sprite 's_counter_3x3_s   ss_features_1 1 22 #f 0)
; (kern-mk-sprite 's_counter_3x3_se  ss_features_1 1 23 #f 0)
; (kern-mk-sprite 's_counter_2x1_w   ss_features_1 1 8 #f 0)
; (kern-mk-sprite 's_counter_2x1_c   ss_features_1 1 9 #f 0)
; (kern-mk-sprite 's_counter_2x1_e   ss_features_1 1 10 #f 0)
; (kern-mk-sprite 's_counter_1x1     ss_features_1 1 31 #f 0)

;; Kevin's new terrain sprites:
;;(kern-mk-sprite 's_grass            ss_kg_terrains 1  0 #f 0)
(kern-mk-sprite 's_desert           ss_kg_terrains 1  1 #f 0)
(kern-mk-sprite 's_desert_cactus    ss_kg_terrains 1  2 #f 0)
(kern-mk-sprite 's_deep             ss_kg_terrains 1  3 #t 0)
(kern-mk-sprite 's_shallow          ss_kg_terrains 1  4 #t 0)  ;; TODO: rename to s_deep_water -- not shallow
(kern-mk-sprite 's_shoals           ss_kg_terrains 1  5 #t 0)
(kern-mk-sprite 's_bog              ss_kg_terrains 1  6 #f 0)  ;; TODO: rename to s_marsh?

(kern-mk-sprite 's_orchards         ss_kg_terrains 1  8 #f 0)
(kern-mk-sprite 's_dead_trees       ss_kg_terrains 1  9 #f 0)
(kern-mk-sprite 's_tilled_earth     ss_kg_terrains 1 10 #f 0)
(kern-mk-sprite 's_flowering_crops  ss_kg_terrains 1 11 #f 0)
(kern-mk-sprite 's_forest           ss_kg_terrains 1 12 #f 0)
(kern-mk-sprite 's_trees            ss_kg_terrains 1 13 #f 0)
(kern-mk-sprite 's_trees_2          ss_kg_terrains 1 14 #f 0)

(kern-mk-sprite 's_mountain_peak    ss_kg_terrains 1 16 #f 0)
(kern-mk-sprite 's_mountains        ss_kg_terrains 1 17 #f 0)
(kern-mk-sprite 's_mountains_2      ss_kg_terrains 1 18 #f 0)
(kern-mk-sprite 's_hills            ss_kg_terrains 1 19 #f 0)

(kern-mk-sprite 's_fruit_tree       ss_kg_terrains 1 56 #f 0)
(kern-mk-sprite 's_dead_tree        ss_kg_terrains 1 57 #f 0)
(kern-mk-sprite 's_cactus           ss_kg_terrains 1 58 #f 0)
(kern-mk-sprite 's_boulder          ss_kg_terrains 1 59 #f 0)
(kern-mk-sprite 's_four_boulders    ss_kg_terrains 1 60 #f 0)

;; Kevin's various-colored road tiles:
(kern-mk-sprite 's_road_NW_corner_redbrown    ss_kg_roads 1  0 #f 0)
(kern-mk-sprite 's_road_N_T_inter_redbrown    ss_kg_roads 1  1 #f 0)
(kern-mk-sprite 's_road_NE_corner_redbrown    ss_kg_roads 1  2 #f 0)
(kern-mk-sprite 's_road_N_end_redbrown        ss_kg_roads 1  3 #f 0)
(kern-mk-sprite 's_road_W_T_inter_redbrown    ss_kg_roads 1  4 #f 0)
(kern-mk-sprite 's_road_crossroads_redbrown   ss_kg_roads 1  5 #f 0)
(kern-mk-sprite 's_road_E_T_inter_redbrown    ss_kg_roads 1  6 #f 0)
(kern-mk-sprite 's_road_NS_section_redbrown   ss_kg_roads 1  7 #f 0)
(kern-mk-sprite 's_road_SW_corner_redbrown    ss_kg_roads 1  8 #f 0)
(kern-mk-sprite 's_road_S_T_inter_redbrown    ss_kg_roads 1  9 #f 0)
(kern-mk-sprite 's_road_SE_corner_redbrown    ss_kg_roads 1 10 #f 0)
(kern-mk-sprite 's_road_S_end_redbrown        ss_kg_roads 1 11 #f 0)
(kern-mk-sprite 's_road_W_end_redbrown        ss_kg_roads 1 12 #f 0)
(kern-mk-sprite 's_road_WE_section_redbrown   ss_kg_roads 1 13 #f 0)
(kern-mk-sprite 's_road_E_end_redbrown        ss_kg_roads 1 14 #f 0)
; Tile 15 unused

;; Remove this block later (test of kg roads as nazghul-0.2.0 terrain)
;(kern-mk-sprite 's_trail_0  ss_kg_roads 1  0 #f 0)
;(kern-mk-sprite 's_trail_1  ss_kg_roads 1  1 #f 0)
;(kern-mk-sprite 's_trail_2  ss_kg_roads 1  2 #f 0)
;(kern-mk-sprite 's_trail_3  ss_kg_roads 1  3 #f 0)
;(kern-mk-sprite 's_trail_4  ss_kg_roads 1  4 #f 0)
;(kern-mk-sprite 's_trail_5  ss_kg_roads 1  5 #f 0)
;(kern-mk-sprite 's_trail_6  ss_kg_roads 1  6 #f 0)
;(kern-mk-sprite 's_trail_7  ss_kg_roads 1  7 #f 0)
;(kern-mk-sprite 's_trail_8  ss_kg_roads 1  8 #f 0)
;(kern-mk-sprite 's_trail_9  ss_kg_roads 1  9 #f 0)
;(kern-mk-sprite 's_trail_a  ss_kg_roads 1 10 #f 0)
;(kern-mk-sprite 's_trail_b  ss_kg_roads 1 11 #f 0)
;(kern-mk-sprite 's_trail_c  ss_kg_roads 1 12 #f 0)
;(kern-mk-sprite 's_trail_d  ss_kg_roads 1 13 #f 0)
;(kern-mk-sprite 's_trail_e  ss_kg_roads 1 14 #f 0)

(kern-mk-sprite 's_road_NW_corner_lightbrown    ss_kg_roads 1 16 #f 0)
(kern-mk-sprite 's_road_N_T_inter_lightbrown    ss_kg_roads 1 17 #f 0)
(kern-mk-sprite 's_road_NE_corner_lightbrown    ss_kg_roads 1 18 #f 0)
(kern-mk-sprite 's_road_N_end_lightbrown        ss_kg_roads 1 19 #f 0)
(kern-mk-sprite 's_road_W_T_inter_lightbrown    ss_kg_roads 1 20 #f 0)
(kern-mk-sprite 's_road_crossroads_lightbrown   ss_kg_roads 1 21 #f 0)
(kern-mk-sprite 's_road_E_T_inter_lightbrown    ss_kg_roads 1 22 #f 0)
(kern-mk-sprite 's_road_NS_section_lightbrown   ss_kg_roads 1 23 #f 0)
(kern-mk-sprite 's_road_SW_corner_lightbrown    ss_kg_roads 1 24 #f 0)
(kern-mk-sprite 's_road_S_T_inter_lightbrown    ss_kg_roads 1 25 #f 0)
(kern-mk-sprite 's_road_SE_corner_lightbrown    ss_kg_roads 1 26 #f 0)
(kern-mk-sprite 's_road_S_end_lightbrown        ss_kg_roads 1 27 #f 0)
(kern-mk-sprite 's_road_W_end_lightbrown        ss_kg_roads 1 28 #f 0)
(kern-mk-sprite 's_road_WE_section_lightbrown   ss_kg_roads 1 29 #f 0)
(kern-mk-sprite 's_road_E_end_lightbrown        ss_kg_roads 1 30 #f 0)
; Tile 31 unused

(kern-mk-sprite 's_road_NW_corner_light_soil    ss_kg_roads 1 32 #f 0)
(kern-mk-sprite 's_road_N_T_inter_light_soil    ss_kg_roads 1 33 #f 0)
(kern-mk-sprite 's_road_NE_corner_light_soil    ss_kg_roads 1 34 #f 0)
(kern-mk-sprite 's_road_N_end_light_soil        ss_kg_roads 1 35 #f 0)
(kern-mk-sprite 's_road_W_T_inter_light_soil    ss_kg_roads 1 36 #f 0)
(kern-mk-sprite 's_road_crossroads_light_soil   ss_kg_roads 1 37 #f 0)
(kern-mk-sprite 's_road_E_T_inter_light_soil    ss_kg_roads 1 38 #f 0)
(kern-mk-sprite 's_road_NS_section_light_soil   ss_kg_roads 1 39 #f 0)
(kern-mk-sprite 's_road_SW_corner_light_soil    ss_kg_roads 1 40 #f 0)
(kern-mk-sprite 's_road_S_T_inter_light_soil    ss_kg_roads 1 41 #f 0)
(kern-mk-sprite 's_road_SE_corner_light_soil    ss_kg_roads 1 42 #f 0)
(kern-mk-sprite 's_road_S_end_light_soil        ss_kg_roads 1 43 #f 0)
(kern-mk-sprite 's_road_W_end_light_soil        ss_kg_roads 1 44 #f 0)
(kern-mk-sprite 's_road_WE_section_light_soil   ss_kg_roads 1 45 #f 0)
(kern-mk-sprite 's_road_E_end_light_soil        ss_kg_roads 1 46 #f 0)
; Tile 47 unused

(kern-mk-sprite 's_road_NW_corner_light_yellow    ss_kg_roads 1 48 #f 0)
(kern-mk-sprite 's_road_N_T_inter_light_yellow    ss_kg_roads 1 49 #f 0)
(kern-mk-sprite 's_road_NE_corner_light_yellow    ss_kg_roads 1 50 #f 0)
(kern-mk-sprite 's_road_N_end_light_yellow        ss_kg_roads 1 51 #f 0)
(kern-mk-sprite 's_road_W_T_inter_light_yellow    ss_kg_roads 1 52 #f 0)
(kern-mk-sprite 's_road_crossroads_light_yellow   ss_kg_roads 1 53 #f 0)
(kern-mk-sprite 's_road_E_T_inter_light_yellow    ss_kg_roads 1 54 #f 0)
(kern-mk-sprite 's_road_NS_section_light_yellow   ss_kg_roads 1 55 #f 0)
(kern-mk-sprite 's_road_SW_corner_light_yellow    ss_kg_roads 1 56 #f 0)
(kern-mk-sprite 's_road_S_T_inter_light_yellow    ss_kg_roads 1 57 #f 0)
(kern-mk-sprite 's_road_SE_corner_light_yellow    ss_kg_roads 1 58 #f 0)
(kern-mk-sprite 's_road_S_end_light_yellow        ss_kg_roads 1 59 #f 0)
(kern-mk-sprite 's_road_W_end_light_yellow        ss_kg_roads 1 60 #f 0)
(kern-mk-sprite 's_road_WE_section_light_yellow   ss_kg_roads 1 61 #f 0)
(kern-mk-sprite 's_road_E_end_light_yellow        ss_kg_roads 1 62 #f 0)
; Tile 63 unused

(kern-mk-sprite 's_road_NW_corner_bright_yellow    ss_kg_roads 1 64 #f 0)
(kern-mk-sprite 's_road_N_T_inter_bright_yellow    ss_kg_roads 1 65 #f 0)
(kern-mk-sprite 's_road_NE_corner_bright_yellow    ss_kg_roads 1 66 #f 0)
(kern-mk-sprite 's_road_N_end_bright_yellow        ss_kg_roads 1 67 #f 0)
(kern-mk-sprite 's_road_W_T_inter_bright_yellow    ss_kg_roads 1 68 #f 0)
(kern-mk-sprite 's_road_crossroads_bright_yellow   ss_kg_roads 1 69 #f 0)
(kern-mk-sprite 's_road_E_T_inter_bright_yellow    ss_kg_roads 1 70 #f 0)
(kern-mk-sprite 's_road_NS_section_bright_yellow   ss_kg_roads 1 71 #f 0)
(kern-mk-sprite 's_road_SW_corner_bright_yellow    ss_kg_roads 1 72 #f 0)
(kern-mk-sprite 's_road_S_T_inter_bright_yellow    ss_kg_roads 1 73 #f 0)
(kern-mk-sprite 's_road_SE_corner_bright_yellow    ss_kg_roads 1 74 #f 0)
(kern-mk-sprite 's_road_S_end_bright_yellow        ss_kg_roads 1 75 #f 0)
(kern-mk-sprite 's_road_W_end_bright_yellow        ss_kg_roads 1 76 #f 0)
(kern-mk-sprite 's_road_WE_section_bright_yellow   ss_kg_roads 1 77 #f 0)
(kern-mk-sprite 's_road_E_end_bright_yellow        ss_kg_roads 1 78 #f 0)
; Tile 79 unused

(kern-mk-sprite 's_road_NW_corner_light_green    ss_kg_roads 1 128 #f 0)
(kern-mk-sprite 's_road_N_T_inter_light_green    ss_kg_roads 1 129 #f 0)
(kern-mk-sprite 's_road_NE_corner_light_green    ss_kg_roads 1 130 #f 0)
(kern-mk-sprite 's_road_N_end_light_green        ss_kg_roads 1 131 #f 0)
(kern-mk-sprite 's_road_W_T_inter_light_green    ss_kg_roads 1 132 #f 0)
(kern-mk-sprite 's_road_crossroads_light_green   ss_kg_roads 1 133 #f 0)
(kern-mk-sprite 's_road_E_T_inter_light_green    ss_kg_roads 1 134 #f 0)
(kern-mk-sprite 's_road_NS_section_light_green   ss_kg_roads 1 135 #f 0)
(kern-mk-sprite 's_road_SW_corner_light_green    ss_kg_roads 1 136 #f 0)
(kern-mk-sprite 's_road_S_T_inter_light_green    ss_kg_roads 1 137 #f 0)
(kern-mk-sprite 's_road_SE_corner_light_green    ss_kg_roads 1 138 #f 0)
(kern-mk-sprite 's_road_S_end_light_green        ss_kg_roads 1 139 #f 0)
(kern-mk-sprite 's_road_W_end_light_green        ss_kg_roads 1 140 #f 0)
(kern-mk-sprite 's_road_WE_section_light_green   ss_kg_roads 1 141 #f 0)
(kern-mk-sprite 's_road_E_end_light_green        ss_kg_roads 1 142 #f 0)
; Tile 143 unused


;; David Gervais' Wearable Items 
;; ss_dg_wearable (12 x 20)
;; (helmets, amulets, cloaks, robes, gloves, boots, shields, armour)
;; 
;; TODO: Make a second pass giving DESCRIPTIVE tags like s_amulet_red rather than s_amulet_99...

(kern-mk-sprite 's_helm_leather_1         ss_dg_wearable 1   0 #f 0)
(kern-mk-sprite 's_helm_leather_2         ss_dg_wearable 1   1 #f 0)
(kern-mk-sprite 's_helm_metal_1           ss_dg_wearable 1   2 #f 0)
(kern-mk-sprite 's_helm_metal_2           ss_dg_wearable 1   3 #f 0)
(kern-mk-sprite 's_helm_metal_3           ss_dg_wearable 1   4 #f 0)
(kern-mk-sprite 's_helm_gold_horned       ss_dg_wearable 1   5 #f 0)
(kern-mk-sprite 's_helm_metal_horned      ss_dg_wearable 1   6 #f 0)
(kern-mk-sprite 's_hat_green_feather      ss_dg_wearable 1   7 #f 0)
(kern-mk-sprite 's_crown_1                ss_dg_wearable 1   8 #f 0)
(kern-mk-sprite 's_crown_2                ss_dg_wearable 1   9 #f 0)
(kern-mk-sprite 's_crown_3                ss_dg_wearable 1  10 #f 0)
(kern-mk-sprite 's_crown_4                ss_dg_wearable 1  11 #f 0)

(kern-mk-sprite 's_amulet_1               ss_dg_wearable 1  12 #f 0)
(kern-mk-sprite 's_amulet_2               ss_dg_wearable 1  13 #f 0)
(kern-mk-sprite 's_amulet_3               ss_dg_wearable 1  14 #f 0)
(kern-mk-sprite 's_amulet_4               ss_dg_wearable 1  15 #f 0)
(kern-mk-sprite 's_amulet_5               ss_dg_wearable 1  16 #f 0)
(kern-mk-sprite 's_amulet_6               ss_dg_wearable 1  17 #f 0)
(kern-mk-sprite 's_amulet_7               ss_dg_wearable 1  18 #f 0)
(kern-mk-sprite 's_amulet_8               ss_dg_wearable 1  19 #f 0)
(kern-mk-sprite 's_amulet_9               ss_dg_wearable 1  20 #f 0)
(kern-mk-sprite 's_amulet_10              ss_dg_wearable 1  21 #f 0)

(kern-mk-sprite 's_amulet_11              ss_dg_wearable 1  24 #f 0)
(kern-mk-sprite 's_amulet_12              ss_dg_wearable 1  25 #f 0)
(kern-mk-sprite 's_amulet_13              ss_dg_wearable 1  26 #f 0)
(kern-mk-sprite 's_amulet_14              ss_dg_wearable 1  27 #f 0)
(kern-mk-sprite 's_amulet_15              ss_dg_wearable 1  28 #f 0)
(kern-mk-sprite 's_amulet_16              ss_dg_wearable 1  29 #f 0)

(kern-mk-sprite 's_ring_1                 ss_dg_wearable 1  36 #f 0)
(kern-mk-sprite 's_ring_2                 ss_dg_wearable 1  37 #f 0)
(kern-mk-sprite 's_ring_3                 ss_dg_wearable 1  38 #f 0)
(kern-mk-sprite 's_ring_4                 ss_dg_wearable 1  39 #f 0)
(kern-mk-sprite 's_ring_5                 ss_dg_wearable 1  40 #f 0)
(kern-mk-sprite 's_ring_6                 ss_dg_wearable 1  41 #f 0)
(kern-mk-sprite 's_ring_7                 ss_dg_wearable 1  42 #f 0)
(kern-mk-sprite 's_ring_8                 ss_dg_wearable 1  43 #f 0)
(kern-mk-sprite 's_ring_9                 ss_dg_wearable 1  44 #f 0)
(kern-mk-sprite 's_ring_10                ss_dg_wearable 1  45 #f 0)
(kern-mk-sprite 's_ring_11                ss_dg_wearable 1  46 #f 0)
(kern-mk-sprite 's_ring_12                ss_dg_wearable 1  47 #f 0)

(kern-mk-sprite 's_ring_13                ss_dg_wearable 1  48 #f 0)
(kern-mk-sprite 's_ring_14                ss_dg_wearable 1  49 #f 0)
(kern-mk-sprite 's_ring_15                ss_dg_wearable 1  50 #f 0)
(kern-mk-sprite 's_ring_16                ss_dg_wearable 1  51 #f 0)
(kern-mk-sprite 's_ring_17                ss_dg_wearable 1  52 #f 0)
(kern-mk-sprite 's_ring_18                ss_dg_wearable 1  53 #f 0)
(kern-mk-sprite 's_ring_19                ss_dg_wearable 1  54 #f 0)
(kern-mk-sprite 's_ring_20                ss_dg_wearable 1  55 #f 0)
(kern-mk-sprite 's_ring_21                ss_dg_wearable 1  56 #f 0)
(kern-mk-sprite 's_ring_22                ss_dg_wearable 1  57 #f 0)
(kern-mk-sprite 's_ring_23                ss_dg_wearable 1  58 #f 0)
(kern-mk-sprite 's_ring_24                ss_dg_wearable 1  59 #f 0)

(kern-mk-sprite 's_cloak_1                ss_dg_wearable 1  60 #f 0)
(kern-mk-sprite 's_cloak_2                ss_dg_wearable 1  61 #f 0)
(kern-mk-sprite 's_cloak_3                ss_dg_wearable 1  62 #f 0)
(kern-mk-sprite 's_cloak_4                ss_dg_wearable 1  63 #f 0)
(kern-mk-sprite 's_cloak_5                ss_dg_wearable 1  64 #f 0)
(kern-mk-sprite 's_cloak_6                ss_dg_wearable 1  65 #f 0)
(kern-mk-sprite 's_cloak_7                ss_dg_wearable 1  66 #f 0)
(kern-mk-sprite 's_cloak_8                ss_dg_wearable 1  67 #f 0)
(kern-mk-sprite 's_cloak_9                ss_dg_wearable 1  68 #f 0)

(kern-mk-sprite 's_robe_1                 ss_dg_wearable 1  72 #f 0)
(kern-mk-sprite 's_robe_2                 ss_dg_wearable 1  75 #f 0)
(kern-mk-sprite 's_robe_3                 ss_dg_wearable 1  77 #f 0)
(kern-mk-sprite 's_robe_4                 ss_dg_wearable 1  78 #f 0)
(kern-mk-sprite 's_robe_rags              ss_dg_wearable 1  83 #f 0)

(kern-mk-sprite 's_gloves_green           ss_dg_wearable 1  84 #f 0)
(kern-mk-sprite 's_gloves_tan             ss_dg_wearable 1  85 #f 0)
(kern-mk-sprite 's_gloves_brown           ss_dg_wearable 1  86 #f 0)
(kern-mk-sprite 's_gloves_grey            ss_dg_wearable 1  87 #f 0)
(kern-mk-sprite 's_gloves_yellow          ss_dg_wearable 1  88 #f 0)
(kern-mk-sprite 's_gloves_blue            ss_dg_wearable 1  89 #f 0)

(kern-mk-sprite 's_boots_green            ss_dg_wearable 1  96 #f 0)
(kern-mk-sprite 's_boots_tan              ss_dg_wearable 1  97 #f 0)
(kern-mk-sprite 's_boots_brown            ss_dg_wearable 1  98 #f 0)
(kern-mk-sprite 's_boots_metal            ss_dg_wearable 1  99 #f 0)
(kern-mk-sprite 's_boots_yellow           ss_dg_wearable 1 100 #f 0)

(kern-mk-sprite 's_shield_pattern_1       ss_dg_wearable 1 108 #f 0)
(kern-mk-sprite 's_shield_pattern_2       ss_dg_wearable 1 109 #f 0)
(kern-mk-sprite 's_shield_pattern_3       ss_dg_wearable 1 110 #f 0)
(kern-mk-sprite 's_shield_pattern_4       ss_dg_wearable 1 111 #f 0)
(kern-mk-sprite 's_shield_pattern_5       ss_dg_wearable 1 112 #f 0)
(kern-mk-sprite 's_shield_pattern_6       ss_dg_wearable 1 113 #f 0)
(kern-mk-sprite 's_shield_pattern_7       ss_dg_wearable 1 114 #f 0)
(kern-mk-sprite 's_shield_blank_gold      ss_dg_wearable 1 115 #f 0)

(kern-mk-sprite 's_shield_blank_wooden_1       ss_dg_wearable 1 120 #f 0)
(kern-mk-sprite 's_shield_blank_wooden_2       ss_dg_wearable 1 121 #f 0)
(kern-mk-sprite 's_shield_blank_round_1        ss_dg_wearable 1 122 #f 0)
(kern-mk-sprite 's_shield_blank_round_2        ss_dg_wearable 1 123 #f 0)
(kern-mk-sprite 's_shield_blank_round_3        ss_dg_wearable 1 124 #f 0)
(kern-mk-sprite 's_shield_blank_heater_1       ss_dg_wearable 1 125 #f 0)
(kern-mk-sprite 's_shield_blank_heater_2       ss_dg_wearable 1 126 #f 0)

(kern-mk-sprite 's_breastplate_dragon_1        ss_dg_wearable 1 132 #f 0)
(kern-mk-sprite 's_breastplate_dragon_2        ss_dg_wearable 1 133 #f 0)
(kern-mk-sprite 's_breastplate_dragon_3        ss_dg_wearable 1 134 #f 0)
(kern-mk-sprite 's_breastplate_dragon_4        ss_dg_wearable 1 135 #f 0)
(kern-mk-sprite 's_breastplate_dragon_5        ss_dg_wearable 1 136 #f 0)
(kern-mk-sprite 's_breastplate_dragon_6        ss_dg_wearable 1 137 #f 0)

(kern-mk-sprite 's_shield_symbol_crown         ss_dg_wearable 1 144 #f 0)
(kern-mk-sprite 's_shield_symbol_unicorn_1     ss_dg_wearable 1 145 #f 0)
(kern-mk-sprite 's_shield_symbol_unicorn_2     ss_dg_wearable 1 146 #f 0)
(kern-mk-sprite 's_shield_symbol_lion_rampant  ss_dg_wearable 1 147 #f 0)
(kern-mk-sprite 's_shield_symbol_skull         ss_dg_wearable 1 148 #f 0)

(kern-mk-sprite 's_armor_leather_1       ss_dg_wearable 1 156 #f 0)
(kern-mk-sprite 's_armor_leather_2       ss_dg_wearable 1 157 #f 0)
(kern-mk-sprite 's_armor_leather_3       ss_dg_wearable 1 158 #f 0)
(kern-mk-sprite 's_armor_leather_4       ss_dg_wearable 1 159 #f 0)
(kern-mk-sprite 's_armor_leather_5       ss_dg_wearable 1 160 #f 0)
; 161 blank
(kern-mk-sprite 's_armor_golden_1        ss_dg_wearable 1 162 #f 0)
(kern-mk-sprite 's_armor_green_1         ss_dg_wearable 1 163 #f 0)

(kern-mk-sprite 's_armor_chain_1         ss_dg_wearable 1 168 #f 0)
(kern-mk-sprite 's_armor_chain_2         ss_dg_wearable 1 169 #f 0)
(kern-mk-sprite 's_armor_chain_3         ss_dg_wearable 1 170 #f 0)
(kern-mk-sprite 's_armor_chain_4         ss_dg_wearable 1 171 #f 0)
(kern-mk-sprite 's_armor_chain_5         ss_dg_wearable 1 172 #f 0)
(kern-mk-sprite 's_armor_chain_6         ss_dg_wearable 1 173 #f 0)
(kern-mk-sprite 's_armor_chain_7         ss_dg_wearable 1 174 #f 0)
(kern-mk-sprite 's_armor_chain_8         ss_dg_wearable 1 175 #f 0)

(kern-mk-sprite 's_armor_plate_1         ss_dg_wearable 1 180 #f 0)
(kern-mk-sprite 's_armor_plate_2         ss_dg_wearable 1 181 #f 0)
(kern-mk-sprite 's_armor_plate_3         ss_dg_wearable 1 182 #f 0)
(kern-mk-sprite 's_armor_plate_4         ss_dg_wearable 1 183 #f 0)
(kern-mk-sprite 's_armor_plate_5         ss_dg_wearable 1 184 #f 0)

(kern-mk-sprite 's_armor_dragon_1        ss_dg_wearable 1 192 #f 0)
(kern-mk-sprite 's_armor_dragon_2        ss_dg_wearable 1 193 #f 0)
(kern-mk-sprite 's_armor_dragon_3        ss_dg_wearable 1 194 #f 0)
(kern-mk-sprite 's_armor_dragon_4        ss_dg_wearable 1 195 #f 0)
(kern-mk-sprite 's_armor_dragon_5        ss_dg_wearable 1 196 #f 0)
(kern-mk-sprite 's_armor_dragon_6        ss_dg_wearable 1 197 #f 0)
(kern-mk-sprite 's_armor_dragon_7        ss_dg_wearable 1 198 #f 0)
(kern-mk-sprite 's_armor_dragon_8        ss_dg_wearable 1 199 #f 0)

(kern-mk-sprite 's_armor_dragon_9        ss_dg_wearable 1 204 #f 0)
(kern-mk-sprite 's_armor_dragon_10       ss_dg_wearable 1 205 #f 0)
(kern-mk-sprite 's_armor_dragon_11       ss_dg_wearable 1 206 #f 0)
(kern-mk-sprite 's_armor_dragon_12       ss_dg_wearable 1 207 #f 0)
(kern-mk-sprite 's_armor_dragon_13       ss_dg_wearable 1 208 #f 0)
(kern-mk-sprite 's_armor_dragon_14       ss_dg_wearable 1 209 #f 0)
(kern-mk-sprite 's_armor_dragon_15       ss_dg_wearable 1 210 #f 0)
(kern-mk-sprite 's_armor_dragon_16       ss_dg_wearable 1 211 #f 0)


;; ss_dg_weapons          16 x 16
;; 
;; IDEA:  What about a notation for the index field like r1+0, r1+2, ...

(kern-mk-sprite 's_sword_broken_1       ss_dg_weapons 1   0 #f 0)
(kern-mk-sprite 's_sword_broken_2       ss_dg_weapons 1   1 #f 0)
(kern-mk-sprite 's_sword_broken_3       ss_dg_weapons 1   2 #f 0)
(kern-mk-sprite 's_sword_broken_4       ss_dg_weapons 1   3 #f 0)

(kern-mk-sprite 's_dagger_1             ss_dg_weapons 1   5 #f 0)
(kern-mk-sprite 's_dagger_2             ss_dg_weapons 1   6 #f 0)
(kern-mk-sprite 's_dagger_3             ss_dg_weapons 1   7 #f 0)

(kern-mk-sprite 's_sword_short_1        ss_dg_weapons 1   9 #f 0)
(kern-mk-sprite 's_sword_short_2        ss_dg_weapons 1  10 #f 0)
(kern-mk-sprite 's_sword_short_3        ss_dg_weapons 1  11 #f 0)

(kern-mk-sprite 's_rapier_1             ss_dg_weapons 1  16 #f 0)
(kern-mk-sprite 's_rapier_2             ss_dg_weapons 1  17 #f 0)
(kern-mk-sprite 's_saber_1              ss_dg_weapons 1  18 #f 0)
(kern-mk-sprite 's_saber_2              ss_dg_weapons 1  19 #f 0)
(kern-mk-sprite 's_cutlass_1            ss_dg_weapons 1  20 #f 0)
(kern-mk-sprite 's_cutlass_2            ss_dg_weapons 1  21 #f 0)
(kern-mk-sprite 's_falchion_1           ss_dg_weapons 1  22 #f 0)

(kern-mk-sprite 's_sword_long_1         ss_dg_weapons 1  32 #f 0)
(kern-mk-sprite 's_sword_long_2         ss_dg_weapons 1  33 #f 0)
(kern-mk-sprite 's_sword_long_3         ss_dg_weapons 1  34 #f 0)

(kern-mk-sprite 's_sword_bastard        ss_dg_weapons 1  36 #f 0)
(kern-mk-sprite 's_sword_katana         ss_dg_weapons 1  37 #f 0)

(kern-mk-sprite 's_sword_zweihander     ss_dg_weapons 1  39 #f 0)
(kern-mk-sprite 's_sword_vorpal         ss_dg_weapons 1  40 #f 0)

(kern-mk-sprite 's_sword_eldritch       ss_dg_weapons 2  42 #f 0)
(kern-mk-sprite 's_sword_mystic         ss_dg_weapons 2  44 #f 0)
(kern-mk-sprite 's_sword_flaming        ss_dg_weapons 2  46 #f 0)

(kern-mk-sprite 's_mace_1               ss_dg_weapons 1  64 #f 0)
(kern-mk-sprite 's_mace_2               ss_dg_weapons 1  65 #f 0)
(kern-mk-sprite 's_mace_3               ss_dg_weapons 1  66 #f 0)
(kern-mk-sprite 's_mace_4               ss_dg_weapons 1  67 #f 0)
(kern-mk-sprite 's_mace_magical         ss_dg_weapons 1  68 #f 0)  ;; TODO: needs an animation frame

(kern-mk-sprite 's_hammer_golden        ss_dg_weapons 1  72 #f 0)
(kern-mk-sprite 's_hammer_warhammer     ss_dg_weapons 1  73 #f 0)
(kern-mk-sprite 's_hammer_sledgehammer  ss_dg_weapons 1  74 #f 0)
(kern-mk-sprite 's_hammer_giant         ss_dg_weapons 1  75 #f 0)

(kern-mk-sprite 's_flail_1              ss_dg_weapons 1  80 #f 0)
(kern-mk-sprite 's_flail_2              ss_dg_weapons 1  81 #f 0)
(kern-mk-sprite 's_flail_3              ss_dg_weapons 1  82 #f 0)
(kern-mk-sprite 's_flail_4              ss_dg_weapons 1  83 #f 0)
(kern-mk-sprite 's_flail_5              ss_dg_weapons 1  84 #f 0)
(kern-mk-sprite 's_nunchaku_1           ss_dg_weapons 1  85 #f 0)
(kern-mk-sprite 's_nunchaku_2           ss_dg_weapons 1  86 #f 0)

(kern-mk-sprite 's_whip                 ss_dg_weapons 1  88 #f 0)

(kern-mk-sprite 's_axe_1                ss_dg_weapons 1  96 #f 0)
(kern-mk-sprite 's_axe_2                ss_dg_weapons 1  97 #f 0)
(kern-mk-sprite 's_axe_3                ss_dg_weapons 1  98 #f 0)
(kern-mk-sprite 's_axe_4                ss_dg_weapons 1  99 #f 0)
(kern-mk-sprite 's_axe_5                ss_dg_weapons 1 100 #f 0)

(kern-mk-sprite 's_scythe_1             ss_dg_weapons 1 104 #f 0)
(kern-mk-sprite 's_scythe_2             ss_dg_weapons 1 105 #f 0)

(kern-mk-sprite 's_spear_1              ss_dg_weapons 1 112 #f 0)
(kern-mk-sprite 's_spear_2              ss_dg_weapons 1 113 #f 0)
(kern-mk-sprite 's_spear_3              ss_dg_weapons 1 114 #f 0)
(kern-mk-sprite 's_trident_1            ss_dg_weapons 1 115 #f 0)
(kern-mk-sprite 's_trident_2            ss_dg_weapons 1 116 #f 0)
(kern-mk-sprite 's_trident_3            ss_dg_weapons 1 117 #f 0)
(kern-mk-sprite 's_lance                ss_dg_weapons 1 118 #f 0)

(kern-mk-sprite 's_quarterstaff_1       ss_dg_weapons 1 120 #f 0)
(kern-mk-sprite 's_quarterstaff_2       ss_dg_weapons 1 121 #f 0)

(kern-mk-sprite 's_halberd_1            ss_dg_weapons 1 128 #f 0)
(kern-mk-sprite 's_halberd_2            ss_dg_weapons 1 129 #f 0)
(kern-mk-sprite 's_halberd_3            ss_dg_weapons 1 130 #f 0)

(kern-mk-sprite 's_shortbow                   ss_dg_weapons 1 160 #f 0)
(kern-mk-sprite 's_longbow_1                  ss_dg_weapons 1 161 #f 0)
(kern-mk-sprite 's_longbow_2                  ss_dg_weapons 1 162 #f 0)
(kern-mk-sprite 's_crossbow_1                 ss_dg_weapons 1 163 #f 0)
(kern-mk-sprite 's_crossbow_2                 ss_dg_weapons 1 164 #f 0)
(kern-mk-sprite 's_crossbow_3                 ss_dg_weapons 1 165 #f 0)

(kern-mk-sprite 's_sling                      ss_dg_weapons 1 168 #f 0)
(kern-mk-sprite 's_sling_bullet               ss_dg_weapons 1 169 #f 0)
(kern-mk-sprite 's_sling_stones               ss_dg_weapons 1 170 #f 0)

(kern-mk-sprite 's_dart_red                   ss_dg_weapons 1 176 #f 0)
(kern-mk-sprite 's_dart_green_dripping        ss_dg_weapons 2 177 #f 0)
(kern-mk-sprite 's_dart_blue_dripping         ss_dg_weapons 2 179 #f 0)
(kern-mk-sprite 's_shuriken                   ss_dg_weapons 1 181 #f 0)
(kern-mk-sprite 's_shuriken_spinning          ss_dg_weapons 2 181 #f 0)

(kern-mk-sprite 's_arrow_wooden               ss_dg_weapons 1 192 #f 0)
(kern-mk-sprite 's_arrow_metal                ss_dg_weapons 1 193 #f 0)
(kern-mk-sprite 's_arrow_white                ss_dg_weapons 1 194 #f 0)
(kern-mk-sprite 's_arrow_gold                 ss_dg_weapons 1 195 #f 0)

(kern-mk-sprite 's_arrow_glowing_red          ss_dg_weapons 2 204 #f 0)
(kern-mk-sprite 's_arrow_glowing_green        ss_dg_weapons 2 206 #f 0)  ;; TODO: fix this sprite

(kern-mk-sprite 's_arrow_wooden_flaming       ss_dg_weapons 2 208 #f 0)
(kern-mk-sprite 's_arrow_metal_flaming        ss_dg_weapons 2 210 #f 0)
(kern-mk-sprite 's_arrow_wooden_acid          ss_dg_weapons 2 212 #f 0)
(kern-mk-sprite 's_arrow_metal_acid           ss_dg_weapons 2 214 #f 0)
(kern-mk-sprite 's_arrow_wooden_frost         ss_dg_weapons 2 216 #f 0)
(kern-mk-sprite 's_arrow_metal_frost          ss_dg_weapons 2 218 #f 0)

(kern-mk-sprite 's_arrow_glowing_blue         ss_dg_weapons 2 220 #f 0)
(kern-mk-sprite 's_arrow_glowing_purple       ss_dg_weapons 2 222 #f 0)

(kern-mk-sprite 's_bolt_wooden                ss_dg_weapons 1 224 #f 0)
(kern-mk-sprite 's_bolt_metal                 ss_dg_weapons 1 225 #f 0)
(kern-mk-sprite 's_bolt_white                 ss_dg_weapons 1 226 #f 0)
(kern-mk-sprite 's_bolt_gold                  ss_dg_weapons 1 227 #f 0)

(kern-mk-sprite 's_bolt_glowing_red           ss_dg_weapons 2 236 #f 0)
(kern-mk-sprite 's_bolt_glowing_green         ss_dg_weapons 2 238 #f 0)

(kern-mk-sprite 's_bolt_wooden_flaming        ss_dg_weapons 2 240 #f 0)
(kern-mk-sprite 's_bolt_metal_flaming         ss_dg_weapons 2 242 #f 0)
(kern-mk-sprite 's_bolt_wooden_acid           ss_dg_weapons 2 244 #f 0)
(kern-mk-sprite 's_bolt_metal_acid            ss_dg_weapons 2 246 #f 0)
(kern-mk-sprite 's_bolt_wooden_frost          ss_dg_weapons 2 248 #f 0)
(kern-mk-sprite 's_bolt_metal_frost           ss_dg_weapons 2 250 #f 0)

(kern-mk-sprite 's_bolt_glowing_blue          ss_dg_weapons 2 252 #f 0)  ;; TODO: fix this sprite
(kern-mk-sprite 's_bolt_glowing_purple        ss_dg_weapons 2 254 #f 0)  ;; TODO: fix this sprite


;; ss_dg_tools
(kern-mk-sprite 's_chest_small_wooden_closed   ss_dg_tools 1   0 #f 0)
(kern-mk-sprite 's_chest_large_wooden_closed   ss_dg_tools 1   1 #f 0)
(kern-mk-sprite 's_chest_small_metal_1_closed  ss_dg_tools 1   2 #f 0)
(kern-mk-sprite 's_chest_large_metal_1_closed  ss_dg_tools 1   3 #f 0)
(kern-mk-sprite 's_chest_small_metal_2_closed  ss_dg_tools 1   4 #f 0)
(kern-mk-sprite 's_chest_small_metal_2_closed  ss_dg_tools 1   5 #f 0)
(kern-mk-sprite 's_chest_wooden_broken         ss_dg_tools 1   6 #f 0)

(kern-mk-sprite 's_metal_spike       ss_dg_tools 1   7 #f 0)

(kern-mk-sprite 's_pickaxe_1         ss_dg_tools 1   8 #f 0)
(kern-mk-sprite 's_pickaxe_2         ss_dg_tools 1   9 #f 0)
(kern-mk-sprite 's_pickaxe_3         ss_dg_tools 1  10 #f 0)
(kern-mk-sprite 's_pickaxe_4         ss_dg_tools 1  11 #f 0)

(kern-mk-sprite 's_shovel_1          ss_dg_tools 1  12 #f 0)
(kern-mk-sprite 's_shovel_2          ss_dg_tools 1  13 #f 0)
(kern-mk-sprite 's_shovel_3          ss_dg_tools 1  14 #f 0)
(kern-mk-sprite 's_shovel_4          ss_dg_tools 1  15 #f 0)

(kern-mk-sprite 's_lamp_1_unlit      ss_dg_tools 1  16 #f 0)
(kern-mk-sprite 's_lamp_1_lit        ss_dg_tools 3  17 #f 0)
(kern-mk-sprite 's_lamp_2_unlit      ss_dg_tools 1  20 #f 0)
(kern-mk-sprite 's_lamp_2_lit        ss_dg_tools 2  21 #f 0)
(kern-mk-sprite 's_torch_unlit       ss_dg_tools 1  24 #f 0)
(kern-mk-sprite 's_torch_lit         ss_dg_tools 3  25 #f 0)

(kern-mk-sprite 's_rod_1             ss_dg_tools 1  48 #f 0)
(kern-mk-sprite 's_rod_2             ss_dg_tools 1  49 #f 0)
(kern-mk-sprite 's_rod_3             ss_dg_tools 1  50 #f 0)
(kern-mk-sprite 's_rod_4             ss_dg_tools 1  51 #f 0)
(kern-mk-sprite 's_rod_5             ss_dg_tools 1  52 #f 0)
(kern-mk-sprite 's_rod_6             ss_dg_tools 1  53 #f 0)
(kern-mk-sprite 's_rod_7             ss_dg_tools 1  54 #f 0)
(kern-mk-sprite 's_rod_8             ss_dg_tools 1  55 #f 0)
(kern-mk-sprite 's_rod_9             ss_dg_tools 1  56 #f 0)

(kern-mk-sprite 's_wand_1            ss_dg_tools 1  64 #f 0)
(kern-mk-sprite 's_wand_2            ss_dg_tools 1  65 #f 0)
(kern-mk-sprite 's_wand_3            ss_dg_tools 1  66 #f 0)
(kern-mk-sprite 's_wand_4            ss_dg_tools 1  67 #f 0)
(kern-mk-sprite 's_wand_5            ss_dg_tools 1  68 #f 0)
(kern-mk-sprite 's_wand_6            ss_dg_tools 1  69 #f 0)
(kern-mk-sprite 's_wand_7            ss_dg_tools 1  70 #f 0)
(kern-mk-sprite 's_wand_8            ss_dg_tools 1  71 #f 0)
(kern-mk-sprite 's_wand_9            ss_dg_tools 1  72 #f 0)

(kern-mk-sprite 's_staff_1           ss_dg_tools 1  80 #f 0)
(kern-mk-sprite 's_staff_2           ss_dg_tools 1  81 #f 0)
(kern-mk-sprite 's_staff_3           ss_dg_tools 1  82 #f 0)
(kern-mk-sprite 's_staff_4           ss_dg_tools 1  83 #f 0)
(kern-mk-sprite 's_staff_5           ss_dg_tools 1  84 #f 0)
(kern-mk-sprite 's_staff_6           ss_dg_tools 1  85 #f 0)
(kern-mk-sprite 's_staff_7           ss_dg_tools 1  86 #f 0)


;; ss_dg_readable (scrolls, books, maps, etc)
(kern-mk-sprite 's_scroll_magic_1            ss_dg_readable 1   0 #f 0)
(kern-mk-sprite 's_scroll_magic_2            ss_dg_readable 1   1 #f 0)
(kern-mk-sprite 's_scroll_magic_3            ss_dg_readable 1   2 #f 0)
(kern-mk-sprite 's_scroll_magic_4            ss_dg_readable 1   3 #f 0)
(kern-mk-sprite 's_scroll_magic_5            ss_dg_readable 1   4 #f 0)
(kern-mk-sprite 's_scroll_magic_6            ss_dg_readable 1   5 #f 0)
(kern-mk-sprite 's_scroll_magic_7            ss_dg_readable 1   6 #f 0)
(kern-mk-sprite 's_scroll_magic_8            ss_dg_readable 1   7 #f 0)

(kern-mk-sprite 's_scroll_spell_1            ss_dg_readable 1  16 #f 0)
(kern-mk-sprite 's_scroll_spell_2            ss_dg_readable 1  17 #f 0)
(kern-mk-sprite 's_scroll_spell_3            ss_dg_readable 1  18 #f 0)
(kern-mk-sprite 's_scroll_spell_4            ss_dg_readable 1  19 #f 0)
(kern-mk-sprite 's_scroll_spell_5            ss_dg_readable 1  20 #f 0)
(kern-mk-sprite 's_scroll_spell_6            ss_dg_readable 1  21 #f 0)
(kern-mk-sprite 's_scroll_spell_7            ss_dg_readable 1  22 #f 0)
(kern-mk-sprite 's_scroll_spell_8            ss_dg_readable 1  23 #f 0)
(kern-mk-sprite 's_scroll_spell_9            ss_dg_readable 1  24 #f 0)
(kern-mk-sprite 's_scroll_spell_10           ss_dg_readable 1  25 #f 0)
(kern-mk-sprite 's_scroll_spell_11           ss_dg_readable 1  26 #f 0)
(kern-mk-sprite 's_scroll_spell_12           ss_dg_readable 1  27 #f 0)
(kern-mk-sprite 's_scroll_spell_13           ss_dg_readable 1  28 #f 0)
(kern-mk-sprite 's_scroll_spell_14           ss_dg_readable 1  29 #f 0)
(kern-mk-sprite 's_scroll_spell_15           ss_dg_readable 1  30 #f 0)
(kern-mk-sprite 's_scroll_spell_16           ss_dg_readable 1  31 #f 0)

(kern-mk-sprite 's_scroll_spell_17           ss_dg_readable 1  32 #f 0)
(kern-mk-sprite 's_scroll_spell_18           ss_dg_readable 1  33 #f 0)
(kern-mk-sprite 's_scroll_spell_19           ss_dg_readable 1  34 #f 0)
(kern-mk-sprite 's_scroll_spell_20           ss_dg_readable 1  35 #f 0)
(kern-mk-sprite 's_scroll_spell_21           ss_dg_readable 1  36 #f 0)
(kern-mk-sprite 's_scroll_spell_22           ss_dg_readable 1  37 #f 0)
(kern-mk-sprite 's_scroll_spell_23           ss_dg_readable 1  38 #f 0)
(kern-mk-sprite 's_scroll_spell_24           ss_dg_readable 1  39 #f 0)
(kern-mk-sprite 's_scroll_spell_25           ss_dg_readable 1  40 #f 0)
(kern-mk-sprite 's_scroll_spell_26           ss_dg_readable 1  41 #f 0)
(kern-mk-sprite 's_scroll_spell_27           ss_dg_readable 1  42 #f 0)
(kern-mk-sprite 's_scroll_spell_28           ss_dg_readable 1  43 #f 0)
(kern-mk-sprite 's_scroll_spell_29           ss_dg_readable 1  44 #f 0)
(kern-mk-sprite 's_scroll_spell_30           ss_dg_readable 1  45 #f 0)
(kern-mk-sprite 's_scroll_spell_31           ss_dg_readable 1  46 #f 0)
(kern-mk-sprite 's_scroll_spell_32           ss_dg_readable 1  47 #f 0)

(kern-mk-sprite 's_scroll_spell_33           ss_dg_readable 1  48 #f 0)
(kern-mk-sprite 's_scroll_spell_34           ss_dg_readable 1  49 #f 0)
(kern-mk-sprite 's_scroll_spell_35           ss_dg_readable 1  50 #f 0)
(kern-mk-sprite 's_scroll_spell_36           ss_dg_readable 1  51 #f 0)
(kern-mk-sprite 's_scroll_spell_37           ss_dg_readable 1  52 #f 0)
(kern-mk-sprite 's_scroll_spell_38           ss_dg_readable 1  53 #f 0)
(kern-mk-sprite 's_scroll_spell_39           ss_dg_readable 1  54 #f 0)
(kern-mk-sprite 's_scroll_spell_40           ss_dg_readable 1  55 #f 0)
(kern-mk-sprite 's_scroll_spell_41           ss_dg_readable 1  56 #f 0)
(kern-mk-sprite 's_scroll_spell_42           ss_dg_readable 1  57 #f 0)

(kern-mk-sprite 's_book_red_1                ss_dg_readable 1  64 #f 0)
(kern-mk-sprite 's_book_red_2                ss_dg_readable 1  65 #f 0)
(kern-mk-sprite 's_book_red_3                ss_dg_readable 1  66 #f 0)
(kern-mk-sprite 's_book_red_4                ss_dg_readable 1  67 #f 0)

(kern-mk-sprite 's_book_red_glowing_1        ss_dg_readable 2  68 #f 0)
(kern-mk-sprite 's_book_red_glowing_2        ss_dg_readable 2  70 #f 0)
(kern-mk-sprite 's_book_red_glowing_3        ss_dg_readable 2  72 #f 0)
(kern-mk-sprite 's_book_red_glowing_4        ss_dg_readable 2  74 #f 0)
(kern-mk-sprite 's_book_red_glowing_5        ss_dg_readable 2  76 #f 0)

(kern-mk-sprite 's_book_grey_1               ss_dg_readable 1  80 #f 0)
(kern-mk-sprite 's_book_grey_2               ss_dg_readable 1  81 #f 0)
(kern-mk-sprite 's_book_grey_3               ss_dg_readable 1  82 #f 0)
(kern-mk-sprite 's_book_grey_4               ss_dg_readable 1  83 #f 0)

(kern-mk-sprite 's_book_grey_glowing_1       ss_dg_readable 2  84 #f 0)
(kern-mk-sprite 's_book_grey_glowing_2       ss_dg_readable 2  86 #f 0)
(kern-mk-sprite 's_book_grey_glowing_3       ss_dg_readable 2  88 #f 0)
(kern-mk-sprite 's_book_grey_glowing_4       ss_dg_readable 2  90 #f 0)
(kern-mk-sprite 's_book_grey_glowing_5       ss_dg_readable 2  92 #f 0)

(kern-mk-sprite 's_book_blue_1               ss_dg_readable 1  96 #f 0)
(kern-mk-sprite 's_book_blue_2               ss_dg_readable 1  97 #f 0)
(kern-mk-sprite 's_book_blue_3               ss_dg_readable 1  98 #f 0)
(kern-mk-sprite 's_book_blue_4               ss_dg_readable 1  99 #f 0)

(kern-mk-sprite 's_book_blue_glowing_1       ss_dg_readable 2 100 #f 0)
(kern-mk-sprite 's_book_blue_glowing_2       ss_dg_readable 2 102 #f 0)
(kern-mk-sprite 's_book_blue_glowing_3       ss_dg_readable 2 104 #f 0)
(kern-mk-sprite 's_book_blue_glowing_4       ss_dg_readable 2 106 #f 0)
(kern-mk-sprite 's_book_blue_glowing_5       ss_dg_readable 2 108 #f 0)

(kern-mk-sprite 's_book_green_1              ss_dg_readable 1 112 #f 0)
(kern-mk-sprite 's_book_green_2              ss_dg_readable 1 113 #f 0)
(kern-mk-sprite 's_book_green_3              ss_dg_readable 1 114 #f 0)
(kern-mk-sprite 's_book_green_4              ss_dg_readable 1 115 #f 0)

(kern-mk-sprite 's_book_green_glowing_1      ss_dg_readable 2 116 #f 0)
(kern-mk-sprite 's_book_green_glowing_2      ss_dg_readable 2 118 #f 0)
(kern-mk-sprite 's_book_green_glowing_3      ss_dg_readable 2 120 #f 0)
(kern-mk-sprite 's_book_green_glowing_4      ss_dg_readable 2 122 #f 0)
(kern-mk-sprite 's_book_green_glowing_5      ss_dg_readable 2 124 #f 0)

(kern-mk-sprite 's_book_orange_1             ss_dg_readable 1 128 #f 0)
(kern-mk-sprite 's_book_orange_2             ss_dg_readable 1 129 #f 0)
(kern-mk-sprite 's_book_orange_3             ss_dg_readable 1 130 #f 0)
(kern-mk-sprite 's_book_orange_4             ss_dg_readable 1 131 #f 0)

(kern-mk-sprite 's_book_orange_glowing_1     ss_dg_readable 2 132 #f 0)
(kern-mk-sprite 's_book_orange_glowing_2     ss_dg_readable 2 134 #f 0)
(kern-mk-sprite 's_book_orange_glowing_3     ss_dg_readable 2 136 #f 0)
(kern-mk-sprite 's_book_orange_glowing_4     ss_dg_readable 2 138 #f 0)
(kern-mk-sprite 's_book_orange_glowing_5     ss_dg_readable 2 140 #f 0)

(kern-mk-sprite 's_book_lite_blue_1          ss_dg_readable 1 144 #f 0)
(kern-mk-sprite 's_book_lite_blue_2          ss_dg_readable 1 145 #f 0)
(kern-mk-sprite 's_book_lite_blue_3          ss_dg_readable 1 146 #f 0)
(kern-mk-sprite 's_book_lite_blue_4          ss_dg_readable 1 147 #f 0)

(kern-mk-sprite 's_book_lite_blue_glowing_1  ss_dg_readable 2 148 #f 0)
(kern-mk-sprite 's_book_lite_blue_glowing_2  ss_dg_readable 2 150 #f 0)
(kern-mk-sprite 's_book_lite_blue_glowing_3  ss_dg_readable 2 152 #f 0)
(kern-mk-sprite 's_book_lite_blue_glowing_4  ss_dg_readable 2 154 #f 0)
(kern-mk-sprite 's_book_lite_blue_glowing_5  ss_dg_readable 2 156 #f 0)

(kern-mk-sprite 's_book_pink_1               ss_dg_readable 1 160 #f 0)
(kern-mk-sprite 's_book_pink_2               ss_dg_readable 1 161 #f 0)
(kern-mk-sprite 's_book_pink_3               ss_dg_readable 1 162 #f 0)
(kern-mk-sprite 's_book_pink_4               ss_dg_readable 1 163 #f 0)

(kern-mk-sprite 's_book_pink_glowing_1       ss_dg_readable 2 164 #f 0)
(kern-mk-sprite 's_book_pink_glowing_2       ss_dg_readable 2 166 #f 0)
(kern-mk-sprite 's_book_pink_glowing_3       ss_dg_readable 2 168 #f 0)
(kern-mk-sprite 's_book_pink_glowing_4       ss_dg_readable 2 170 #f 0)
(kern-mk-sprite 's_book_pink_glowing_5       ss_dg_readable 2 172 #f 0)


;; ss_dg_commodities
(kern-mk-sprite 's_dg_biscuit     ss_dg_commodities 1   0 #f 0)
(kern-mk-sprite 's_dg_bread       ss_dg_commodities 1   1 #f 0)
(kern-mk-sprite 's_dg_jerky       ss_dg_commodities 1   2 #f 0)
(kern-mk-sprite 's_dg_ham         ss_dg_commodities 1   3 #f 0)
(kern-mk-sprite 's_dg_chicken     ss_dg_commodities 1   4 #f 0)
(kern-mk-sprite 's_dg_moldy_meat  ss_dg_commodities 1   5 #f 0)

(kern-mk-sprite 's_dg_booze_jug   ss_dg_commodities 1  16 #f 0)
(kern-mk-sprite 's_dg_beer_mug    ss_dg_commodities 1  17 #f 0)
(kern-mk-sprite 's_dg_wine_flask  ss_dg_commodities 1  18 #f 0)

(kern-mk-sprite 's_dg_mushroom_black       ss_dg_commodities 1  32 #f 0)
(kern-mk-sprite 's_dg_mushroom_white       ss_dg_commodities 1  33 #f 0)
(kern-mk-sprite 's_dg_mushroom_grey        ss_dg_commodities 1  34 #f 0)
(kern-mk-sprite 's_dg_mushroom_orange      ss_dg_commodities 1  35 #f 0)
(kern-mk-sprite 's_dg_mushroom_red         ss_dg_commodities 1  36 #f 0)
(kern-mk-sprite 's_dg_mushroom_green       ss_dg_commodities 1  37 #f 0)
(kern-mk-sprite 's_dg_mushroom_blue        ss_dg_commodities 1  38 #f 0)
(kern-mk-sprite 's_dg_mushroom_brown       ss_dg_commodities 1  39 #f 0)
(kern-mk-sprite 's_dg_mushroom_grey_2      ss_dg_commodities 1  40 #f 0)
(kern-mk-sprite 's_dg_mushroom_white_2     ss_dg_commodities 1  41 #f 0)
(kern-mk-sprite 's_dg_mushroom_purple      ss_dg_commodities 1  42 #f 0)
(kern-mk-sprite 's_dg_mushroom_yellow_2    ss_dg_commodities 1  43 #f 0)
(kern-mk-sprite 's_dg_mushroom_red_2       ss_dg_commodities 1  44 #f 0)
(kern-mk-sprite 's_dg_mushroom_green_2     ss_dg_commodities 1  45 #f 0)
(kern-mk-sprite 's_dg_mushroom_light_blue  ss_dg_commodities 1  46 #f 0)
(kern-mk-sprite 's_dg_mushroom_tan         ss_dg_commodities 1  47 #f 0)

(kern-mk-sprite 's_dg_mushroom_bunch_grey           ss_dg_commodities 1  48 #f 0)
(kern-mk-sprite 's_dg_mushroom_bunch_green          ss_dg_commodities 1  49 #f 0)
(kern-mk-sprite 's_dg_mushroom_bunch_tan            ss_dg_commodities 1  50 #f 0)
(kern-mk-sprite 's_dg_mushroom_bunch_pink           ss_dg_commodities 1  51 #f 0)
(kern-mk-sprite 's_dg_mushroom_bunch_purple         ss_dg_commodities 1  52 #f 0)
(kern-mk-sprite 's_dg_mushroom_bunch_black          ss_dg_commodities 1  53 #f 0)
(kern-mk-sprite 's_dg_mushroom_bunch_glowing_green  ss_dg_commodities 3  54 #f 0)

(kern-mk-sprite 's_coins_copper     ss_dg_commodities 1 144 #f 0)
(kern-mk-sprite 's_coins_silver     ss_dg_commodities 1 145 #f 0)
(kern-mk-sprite 's_coins_gold       ss_dg_commodities 1 146 #f 0)
(kern-mk-sprite 's_coins_blue_1     ss_dg_commodities 1 147 #f 0)
(kern-mk-sprite 's_coins_blue_2     ss_dg_commodities 1 148 #f 0)
(kern-mk-sprite 's_crystals_green   ss_dg_commodities 1 149 #f 0)
(kern-mk-sprite 's_crystals_blue    ss_dg_commodities 1 150 #f 0)
(kern-mk-sprite 's_crystals_purple  ss_dg_commodities 1 151 #f 0)
(kern-mk-sprite 's_gems_red         ss_dg_commodities 1 152 #f 0)
(kern-mk-sprite 's_gems_blue        ss_dg_commodities 1 153 #f 0)
(kern-mk-sprite 's_gems_assorted    ss_dg_commodities 1 154 #f 0)


;; ss_kg_potions_1 (empty flasks, bubbling potions)
(kern-mk-sprite 's_kg_potion_empty_1          ss_kg_potions_1 1   0 #f 0)
(kern-mk-sprite 's_kg_potion_empty_2          ss_kg_potions_1 1   1 #f 0)
(kern-mk-sprite 's_kg_potion_empty_3          ss_kg_potions_1 1   2 #f 0)
(kern-mk-sprite 's_kg_potion_empty_4          ss_kg_potions_1 1   3 #f 0)
(kern-mk-sprite 's_kg_potion_empty_5          ss_kg_potions_1 1   4 #f 0)
(kern-mk-sprite 's_kg_potion_empty_6          ss_kg_potions_1 1   5 #f 0)

(kern-mk-sprite 's_kg_potion_bubbling_pink    ss_kg_potions_1 3  12 #f 0)
(kern-mk-sprite 's_kg_potion_bubbling_red     ss_kg_potions_1 3  18 #f 0)
(kern-mk-sprite 's_kg_potion_bubbling_purple  ss_kg_potions_1 3  24 #f 0)
(kern-mk-sprite 's_kg_potion_bubbling_yellow  ss_kg_potions_1 3  30 #f 0)
(kern-mk-sprite 's_kg_potion_bubbling_green   ss_kg_potions_1 3  36 #f 0)
(kern-mk-sprite 's_kg_potion_bubbling_blue    ss_kg_potions_1 3  42 #f 0)


;; ss_kg_potions_2 (6 shapes, 7 colors, fullness(3/3, 2/3, 1/3), plus dull colors)
; pink
(kern-mk-sprite 's_kg_potion_pink_f33_1    ss_kg_potions_2 1   0 #f 0)
(kern-mk-sprite 's_kg_potion_pink_f23_1    ss_kg_potions_2 1   1 #f 0)
(kern-mk-sprite 's_kg_potion_pink_f13_1    ss_kg_potions_2 1   2 #f 0)

(kern-mk-sprite 's_kg_potion_pink_f33_2    ss_kg_potions_2 1   3 #f 0)
(kern-mk-sprite 's_kg_potion_pink_f23_2    ss_kg_potions_2 1   4 #f 0)
(kern-mk-sprite 's_kg_potion_pink_f13_2    ss_kg_potions_2 1   5 #f 0)

(kern-mk-sprite 's_kg_potion_pink_f33_3    ss_kg_potions_2 1   6 #f 0)
(kern-mk-sprite 's_kg_potion_pink_f23_3    ss_kg_potions_2 1   7 #f 0)
(kern-mk-sprite 's_kg_potion_pink_f13_3    ss_kg_potions_2 1   8 #f 0)

(kern-mk-sprite 's_kg_potion_pink_f33_4    ss_kg_potions_2 1   9 #f 0)
(kern-mk-sprite 's_kg_potion_pink_f23_4    ss_kg_potions_2 1  10 #f 0)
(kern-mk-sprite 's_kg_potion_pink_f13_4    ss_kg_potions_2 1  11 #f 0)

(kern-mk-sprite 's_kg_potion_pink_f33_5    ss_kg_potions_2 1  12 #f 0)
(kern-mk-sprite 's_kg_potion_pink_f23_5    ss_kg_potions_2 1  13 #f 0)
(kern-mk-sprite 's_kg_potion_pink_f13_5    ss_kg_potions_2 1  14 #f 0)

(kern-mk-sprite 's_kg_potion_pink_f33_6    ss_kg_potions_2 1  15 #f 0)
(kern-mk-sprite 's_kg_potion_pink_f23_6    ss_kg_potions_2 1  16 #f 0)
(kern-mk-sprite 's_kg_potion_pink_f13_6    ss_kg_potions_2 1  17 #f 0)

; red
(kern-mk-sprite 's_kg_potion_red_f33_1     ss_kg_potions_2 1  18 #f 0)
(kern-mk-sprite 's_kg_potion_red_f23_1     ss_kg_potions_2 1  19 #f 0)
(kern-mk-sprite 's_kg_potion_red_f13_1     ss_kg_potions_2 1  20 #f 0)

(kern-mk-sprite 's_kg_potion_red_f33_2     ss_kg_potions_2 1  21 #f 0)
(kern-mk-sprite 's_kg_potion_red_f23_2     ss_kg_potions_2 1  22 #f 0)
(kern-mk-sprite 's_kg_potion_red_f13_2     ss_kg_potions_2 1  23 #f 0)

(kern-mk-sprite 's_kg_potion_red_f33_3     ss_kg_potions_2 1  24 #f 0)
(kern-mk-sprite 's_kg_potion_red_f23_3     ss_kg_potions_2 1  25 #f 0)
(kern-mk-sprite 's_kg_potion_red_f13_3     ss_kg_potions_2 1  26 #f 0)

(kern-mk-sprite 's_kg_potion_red_f33_4     ss_kg_potions_2 1  27 #f 0)
(kern-mk-sprite 's_kg_potion_red_f23_4     ss_kg_potions_2 1  28 #f 0)
(kern-mk-sprite 's_kg_potion_red_f13_4     ss_kg_potions_2 1  29 #f 0)

(kern-mk-sprite 's_kg_potion_red_f33_5     ss_kg_potions_2 1  30 #f 0)
(kern-mk-sprite 's_kg_potion_red_f23_5     ss_kg_potions_2 1  31 #f 0)
(kern-mk-sprite 's_kg_potion_red_f13_5     ss_kg_potions_2 1  32 #f 0)

(kern-mk-sprite 's_kg_potion_red_f33_6     ss_kg_potions_2 1  33 #f 0)
(kern-mk-sprite 's_kg_potion_red_f23_6     ss_kg_potions_2 1  34 #f 0)
(kern-mk-sprite 's_kg_potion_red_f13_6     ss_kg_potions_2 1  35 #f 0)

; green
(kern-mk-sprite 's_kg_potion_green_f33_1     ss_kg_potions_2 1  36 #f 0)
(kern-mk-sprite 's_kg_potion_green_f23_1     ss_kg_potions_2 1  37 #f 0)
(kern-mk-sprite 's_kg_potion_green_f13_1     ss_kg_potions_2 1  38 #f 0)

(kern-mk-sprite 's_kg_potion_green_f33_2     ss_kg_potions_2 1  39 #f 0)
(kern-mk-sprite 's_kg_potion_green_f23_2     ss_kg_potions_2 1  40 #f 0)
(kern-mk-sprite 's_kg_potion_green_f13_2     ss_kg_potions_2 1  41 #f 0)

(kern-mk-sprite 's_kg_potion_green_f33_3     ss_kg_potions_2 1  42 #f 0)
(kern-mk-sprite 's_kg_potion_green_f23_3     ss_kg_potions_2 1  43 #f 0)
(kern-mk-sprite 's_kg_potion_green_f13_3     ss_kg_potions_2 1  44 #f 0)

(kern-mk-sprite 's_kg_potion_green_f33_4     ss_kg_potions_2 1  45 #f 0)
(kern-mk-sprite 's_kg_potion_green_f23_4     ss_kg_potions_2 1  46 #f 0)
(kern-mk-sprite 's_kg_potion_green_f13_4     ss_kg_potions_2 1  47 #f 0)

(kern-mk-sprite 's_kg_potion_green_f33_5     ss_kg_potions_2 1  48 #f 0)
(kern-mk-sprite 's_kg_potion_green_f23_5     ss_kg_potions_2 1  49 #f 0)
(kern-mk-sprite 's_kg_potion_green_f13_5     ss_kg_potions_2 1  50 #f 0)

(kern-mk-sprite 's_kg_potion_green_f33_6     ss_kg_potions_2 1  51 #f 0)
(kern-mk-sprite 's_kg_potion_green_f23_6     ss_kg_potions_2 1  52 #f 0)
(kern-mk-sprite 's_kg_potion_green_f13_6     ss_kg_potions_2 1  53 #f 0)

; deep_blue
(kern-mk-sprite 's_kg_potion_deep_blue_f33_1     ss_kg_potions_2 1  54 #f 0)
(kern-mk-sprite 's_kg_potion_deep_blue_f23_1     ss_kg_potions_2 1  55 #f 0)
(kern-mk-sprite 's_kg_potion_deep_blue_f13_1     ss_kg_potions_2 1  56 #f 0)

(kern-mk-sprite 's_kg_potion_deep_blue_f33_2     ss_kg_potions_2 1  57 #f 0)
(kern-mk-sprite 's_kg_potion_deep_blue_f23_2     ss_kg_potions_2 1  58 #f 0)
(kern-mk-sprite 's_kg_potion_deep_blue_f13_2     ss_kg_potions_2 1  59 #f 0)

(kern-mk-sprite 's_kg_potion_deep_blue_f33_3     ss_kg_potions_2 1  60 #f 0)
(kern-mk-sprite 's_kg_potion_deep_blue_f23_3     ss_kg_potions_2 1  61 #f 0)
(kern-mk-sprite 's_kg_potion_deep_blue_f13_3     ss_kg_potions_2 1  62 #f 0)

(kern-mk-sprite 's_kg_potion_deep_blue_f33_4     ss_kg_potions_2 1  63 #f 0)
(kern-mk-sprite 's_kg_potion_deep_blue_f23_4     ss_kg_potions_2 1  64 #f 0)
(kern-mk-sprite 's_kg_potion_deep_blue_f13_4     ss_kg_potions_2 1  65 #f 0)

(kern-mk-sprite 's_kg_potion_deep_blue_f33_5     ss_kg_potions_2 1  66 #f 0)
(kern-mk-sprite 's_kg_potion_deep_blue_f23_5     ss_kg_potions_2 1  67 #f 0)
(kern-mk-sprite 's_kg_potion_deep_blue_f13_5     ss_kg_potions_2 1  68 #f 0)

(kern-mk-sprite 's_kg_potion_deep_blue_f33_6     ss_kg_potions_2 1  69 #f 0)
(kern-mk-sprite 's_kg_potion_deep_blue_f23_6     ss_kg_potions_2 1  70 #f 0)
(kern-mk-sprite 's_kg_potion_deep_blue_f13_6     ss_kg_potions_2 1  71 #f 0)

; light_blue
(kern-mk-sprite 's_kg_potion_light_blue_f33_1     ss_kg_potions_2 1  72 #f 0)
(kern-mk-sprite 's_kg_potion_light_blue_f23_1     ss_kg_potions_2 1  73 #f 0)
(kern-mk-sprite 's_kg_potion_light_blue_f13_1     ss_kg_potions_2 1  74 #f 0)

(kern-mk-sprite 's_kg_potion_light_blue_f33_2     ss_kg_potions_2 1  75 #f 0)
(kern-mk-sprite 's_kg_potion_light_blue_f23_2     ss_kg_potions_2 1  76 #f 0)
(kern-mk-sprite 's_kg_potion_light_blue_f13_2     ss_kg_potions_2 1  77 #f 0)

(kern-mk-sprite 's_kg_potion_light_blue_f33_3     ss_kg_potions_2 1  78 #f 0)
(kern-mk-sprite 's_kg_potion_light_blue_f23_3     ss_kg_potions_2 1  79 #f 0)
(kern-mk-sprite 's_kg_potion_light_blue_f13_3     ss_kg_potions_2 1  80 #f 0)

(kern-mk-sprite 's_kg_potion_light_blue_f33_4     ss_kg_potions_2 1  81 #f 0)
(kern-mk-sprite 's_kg_potion_light_blue_f23_4     ss_kg_potions_2 1  82 #f 0)
(kern-mk-sprite 's_kg_potion_light_blue_f13_4     ss_kg_potions_2 1  83 #f 0)

(kern-mk-sprite 's_kg_potion_light_blue_f33_5     ss_kg_potions_2 1  84 #f 0)
(kern-mk-sprite 's_kg_potion_light_blue_f23_5     ss_kg_potions_2 1  85 #f 0)
(kern-mk-sprite 's_kg_potion_light_blue_f13_5     ss_kg_potions_2 1  86 #f 0)

(kern-mk-sprite 's_kg_potion_light_blue_f33_6     ss_kg_potions_2 1  87 #f 0)
(kern-mk-sprite 's_kg_potion_light_blue_f23_6     ss_kg_potions_2 1  88 #f 0)
(kern-mk-sprite 's_kg_potion_light_blue_f13_6     ss_kg_potions_2 1  89 #f 0)

; yellow
(kern-mk-sprite 's_kg_potion_yellow_f33_1     ss_kg_potions_2 1  90 #f 0)
(kern-mk-sprite 's_kg_potion_yellow_f23_1     ss_kg_potions_2 1  91 #f 0)
(kern-mk-sprite 's_kg_potion_yellow_f13_1     ss_kg_potions_2 1  92 #f 0)

(kern-mk-sprite 's_kg_potion_yellow_f33_2     ss_kg_potions_2 1  93 #f 0)
(kern-mk-sprite 's_kg_potion_yellow_f23_2     ss_kg_potions_2 1  94 #f 0)
(kern-mk-sprite 's_kg_potion_yellow_f13_2     ss_kg_potions_2 1  95 #f 0)

(kern-mk-sprite 's_kg_potion_yellow_f33_3     ss_kg_potions_2 1  96 #f 0)
(kern-mk-sprite 's_kg_potion_yellow_f23_3     ss_kg_potions_2 1  97 #f 0)
(kern-mk-sprite 's_kg_potion_yellow_f13_3     ss_kg_potions_2 1  98 #f 0)

(kern-mk-sprite 's_kg_potion_yellow_f33_4     ss_kg_potions_2 1  99 #f 0)
(kern-mk-sprite 's_kg_potion_yellow_f23_4     ss_kg_potions_2 1 100 #f 0)
(kern-mk-sprite 's_kg_potion_yellow_f13_4     ss_kg_potions_2 1 101 #f 0)

(kern-mk-sprite 's_kg_potion_yellow_f33_5     ss_kg_potions_2 1 102 #f 0)
(kern-mk-sprite 's_kg_potion_yellow_f23_5     ss_kg_potions_2 1 103 #f 0)
(kern-mk-sprite 's_kg_potion_yellow_f13_5     ss_kg_potions_2 1 104 #f 0)

(kern-mk-sprite 's_kg_potion_yellow_f33_6     ss_kg_potions_2 1 105 #f 0)
(kern-mk-sprite 's_kg_potion_yellow_f23_6     ss_kg_potions_2 1 106 #f 0)
(kern-mk-sprite 's_kg_potion_yellow_f13_6     ss_kg_potions_2 1 107 #f 0)

; blue
(kern-mk-sprite 's_kg_potion_blue_f33_1     ss_kg_potions_2 1 108 #f 0)
(kern-mk-sprite 's_kg_potion_blue_f23_1     ss_kg_potions_2 1 109 #f 0)
(kern-mk-sprite 's_kg_potion_blue_f13_1     ss_kg_potions_2 1 110 #f 0)

(kern-mk-sprite 's_kg_potion_blue_f33_2     ss_kg_potions_2 1 111 #f 0)
(kern-mk-sprite 's_kg_potion_blue_f23_2     ss_kg_potions_2 1 112 #f 0)
(kern-mk-sprite 's_kg_potion_blue_f13_2     ss_kg_potions_2 1 113 #f 0)

(kern-mk-sprite 's_kg_potion_blue_f33_3     ss_kg_potions_2 1 114 #f 0)
(kern-mk-sprite 's_kg_potion_blue_f23_3     ss_kg_potions_2 1 115 #f 0)
(kern-mk-sprite 's_kg_potion_blue_f13_3     ss_kg_potions_2 1 116 #f 0)

(kern-mk-sprite 's_kg_potion_blue_f33_4     ss_kg_potions_2 1 117 #f 0)
(kern-mk-sprite 's_kg_potion_blue_f23_4     ss_kg_potions_2 1 118 #f 0)
(kern-mk-sprite 's_kg_potion_blue_f13_4     ss_kg_potions_2 1 119 #f 0)

(kern-mk-sprite 's_kg_potion_blue_f33_5     ss_kg_potions_2 1 120 #f 0)
(kern-mk-sprite 's_kg_potion_blue_f23_5     ss_kg_potions_2 1 121 #f 0)
(kern-mk-sprite 's_kg_potion_blue_f13_5     ss_kg_potions_2 1 122 #f 0)

(kern-mk-sprite 's_kg_potion_blue_f33_6     ss_kg_potions_2 1 123 #f 0)
(kern-mk-sprite 's_kg_potion_blue_f23_6     ss_kg_potions_2 1 124 #f 0)
(kern-mk-sprite 's_kg_potion_blue_f13_6     ss_kg_potions_2 1 125 #f 0)

; dull purple
(kern-mk-sprite 's_kg_potion_dull_purple_1      ss_kg_potions_2 1 126 #f 0)
(kern-mk-sprite 's_kg_potion_dull_purple_2      ss_kg_potions_2 1 129 #f 0)
(kern-mk-sprite 's_kg_potion_dull_purple_3      ss_kg_potions_2 1 132 #f 0)
(kern-mk-sprite 's_kg_potion_dull_purple_4      ss_kg_potions_2 1 135 #f 0)
(kern-mk-sprite 's_kg_potion_dull_purple_5      ss_kg_potions_2 1 138 #f 0)
(kern-mk-sprite 's_kg_potion_dull_purple_6      ss_kg_potions_2 1 141 #f 0)
; brown
(kern-mk-sprite 's_kg_potion_brown_1            ss_kg_potions_2 1 144 #f 0)
(kern-mk-sprite 's_kg_potion_brown_2            ss_kg_potions_2 1 147 #f 0)
(kern-mk-sprite 's_kg_potion_brown_3            ss_kg_potions_2 1 150 #f 0)
(kern-mk-sprite 's_kg_potion_brown_4            ss_kg_potions_2 1 153 #f 0)
(kern-mk-sprite 's_kg_potion_brown_5            ss_kg_potions_2 1 156 #f 0)
(kern-mk-sprite 's_kg_potion_brown_6            ss_kg_potions_2 1 159 #f 0)
; dull green
(kern-mk-sprite 's_kg_potion_dull_green_1       ss_kg_potions_2 1 162 #f 0)
(kern-mk-sprite 's_kg_potion_dull_green_2       ss_kg_potions_2 1 165 #f 0)
(kern-mk-sprite 's_kg_potion_dull_green_3       ss_kg_potions_2 1 168 #f 0)
(kern-mk-sprite 's_kg_potion_dull_green_4       ss_kg_potions_2 1 171 #f 0)
(kern-mk-sprite 's_kg_potion_dull_green_5       ss_kg_potions_2 1 174 #f 0)
(kern-mk-sprite 's_kg_potion_dull_green_6       ss_kg_potions_2 1 177 #f 0)
; dull dark_blue
(kern-mk-sprite 's_kg_potion_dull_dark_blue_1   ss_kg_potions_2 1 180 #f 0)
(kern-mk-sprite 's_kg_potion_dull_dark_blue_2   ss_kg_potions_2 1 183 #f 0)
(kern-mk-sprite 's_kg_potion_dull_dark_blue_3   ss_kg_potions_2 1 186 #f 0)
(kern-mk-sprite 's_kg_potion_dull_dark_blue_4   ss_kg_potions_2 1 189 #f 0)
(kern-mk-sprite 's_kg_potion_dull_dark_blue_5   ss_kg_potions_2 1 192 #f 0)
(kern-mk-sprite 's_kg_potion_dull_dark_blue_6   ss_kg_potions_2 1 195 #f 0)
; dull light_blue
(kern-mk-sprite 's_kg_potion_dull_light_blue_1  ss_kg_potions_2 1 198 #f 0)
(kern-mk-sprite 's_kg_potion_dull_light_blue_2  ss_kg_potions_2 1 201 #f 0)
(kern-mk-sprite 's_kg_potion_dull_light_blue_3  ss_kg_potions_2 1 204 #f 0)
(kern-mk-sprite 's_kg_potion_dull_light_blue_4  ss_kg_potions_2 1 207 #f 0)
(kern-mk-sprite 's_kg_potion_dull_light_blue_5  ss_kg_potions_2 1 210 #f 0)
(kern-mk-sprite 's_kg_potion_dull_light_blue_6  ss_kg_potions_2 1 213 #f 0)
; dull yellow
(kern-mk-sprite 's_kg_potion_dull_yellow_1      ss_kg_potions_2 1 216 #f 0)
(kern-mk-sprite 's_kg_potion_dull_yellow_2      ss_kg_potions_2 1 219 #f 0)
(kern-mk-sprite 's_kg_potion_dull_yellow_3      ss_kg_potions_2 1 222 #f 0)
(kern-mk-sprite 's_kg_potion_dull_yellow_4      ss_kg_potions_2 1 225 #f 0)
(kern-mk-sprite 's_kg_potion_dull_yellow_5      ss_kg_potions_2 1 228 #f 0)
(kern-mk-sprite 's_kg_potion_dull_yellow_6      ss_kg_potions_2 1 231 #f 0)
; dull blue
(kern-mk-sprite 's_kg_potion_dull_blue_1        ss_kg_potions_2 1 234 #f 0)
(kern-mk-sprite 's_kg_potion_dull_blue_2        ss_kg_potions_2 1 237 #f 0)
(kern-mk-sprite 's_kg_potion_dull_blue_3        ss_kg_potions_2 1 240 #f 0)
(kern-mk-sprite 's_kg_potion_dull_blue_4        ss_kg_potions_2 1 243 #f 0)
(kern-mk-sprite 's_kg_potion_dull_blue_5        ss_kg_potions_2 1 246 #f 0)
(kern-mk-sprite 's_kg_potion_dull_blue_6        ss_kg_potions_2 1 249 #f 0)



;; David Gervais' missile sprites
;; TODO: The facing code does not cover the layout needed by the bolts (first 3 rows)
;;   Frames (0,1,2,3) are (N,NE,E,SE), then again (S,SW,W,NW)
;;   Facing '511' means all 8, but wants 8 frames...

;; Lightning bolts:
(kern-mk-sprite 's_lightning_bolt_red         ss_dg_missiles 4   0 #f 0)  ;; change facing later...
(kern-mk-sprite 's_lightning_bolt_green       ss_dg_missiles 4   4 #f 0)
(kern-mk-sprite 's_lightning_bolt_blue        ss_dg_missiles 4   8 #f 0)
(kern-mk-sprite 's_lightning_bolt_cyan        ss_dg_missiles 4  12 #f 0)
(kern-mk-sprite 's_lightning_bolt_purple      ss_dg_missiles 4  16 #f 0)
(kern-mk-sprite 's_lightning_bolt_yellow      ss_dg_missiles 4  20 #f 0)
(kern-mk-sprite 's_lightning_bolt_brown       ss_dg_missiles 4  24 #f 0)
(kern-mk-sprite 's_lightning_bolt_orange      ss_dg_missiles 4  28 #f 0)
(kern-mk-sprite 's_lightning_bolt_white       ss_dg_missiles 4  32 #f 0)
(kern-mk-sprite 's_lightning_bolt_grey        ss_dg_missiles 4  36 #f 0)
(kern-mk-sprite 's_lightning_bolt_dark_grey   ss_dg_missiles 4  40 #f 0)
(kern-mk-sprite 's_lightning_bolt_chromatic   ss_dg_missiles 4  44 #f 0)
;; Magic ball (fireball core or similar):
(kern-mk-sprite 's_magic_ball_core_red        ss_dg_missiles 2  48 #f 0)
(kern-mk-sprite 's_magic_ball_core_green      ss_dg_missiles 2  50 #f 0)
(kern-mk-sprite 's_magic_ball_core_blue       ss_dg_missiles 2  52 #f 0)
(kern-mk-sprite 's_magic_ball_core_cyan       ss_dg_missiles 2  54 #f 0)
(kern-mk-sprite 's_magic_ball_core_purple     ss_dg_missiles 2  56 #f 0)
(kern-mk-sprite 's_magic_ball_core_yellow     ss_dg_missiles 2  58 #f 0)
(kern-mk-sprite 's_magic_ball_core_brown      ss_dg_missiles 2  60 #f 0)
(kern-mk-sprite 's_magic_ball_core_orange     ss_dg_missiles 2  62 #f 0)
(kern-mk-sprite 's_magic_ball_core_white      ss_dg_missiles 2  64 #f 0)
(kern-mk-sprite 's_magic_ball_core_grey       ss_dg_missiles 2  66 #f 0)
(kern-mk-sprite 's_magic_ball_core_dark_grey  ss_dg_missiles 2  68 #f 0)
(kern-mk-sprite 's_magic_ball_core_chromatic  ss_dg_missiles 2  70 #f 0)
                                        ; (Tiles 71..79 blank)
;; Magic burst/bloom/aura/field (5 ball lightnings in one tile):
(kern-mk-sprite 's_magic_field_red            ss_dg_missiles 2  80 #f 0)
(kern-mk-sprite 's_magic_field_green          ss_dg_missiles 2  82 #f 0)
(kern-mk-sprite 's_magic_field_blue           ss_dg_missiles 2  84 #f 0)
(kern-mk-sprite 's_magic_field_cyan           ss_dg_missiles 2  86 #f 0)
(kern-mk-sprite 's_magic_field_purple         ss_dg_missiles 2  88 #f 0)
(kern-mk-sprite 's_magic_field_yellow         ss_dg_missiles 2  90 #f 0)
(kern-mk-sprite 's_magic_field_brown          ss_dg_missiles 2  92 #f 0)
(kern-mk-sprite 's_magic_field_orange         ss_dg_missiles 2  94 #f 0)
(kern-mk-sprite 's_magic_field_white          ss_dg_missiles 2  96 #f 0)
(kern-mk-sprite 's_magic_field_grey           ss_dg_missiles 2  98 #f 0)
(kern-mk-sprite 's_magic_field_dark_grey      ss_dg_missiles 2 100 #f 0)
(kern-mk-sprite 's_magic_field_blue_2         ss_dg_missiles 2 102 #f 0)
(kern-mk-sprite 's_magic_field_red_pulsed     ss_dg_missiles 2 104 #f 0)
(kern-mk-sprite 's_magic_field_green_pulsed   ss_dg_missiles 2 106 #f 0)
(kern-mk-sprite 's_magic_field_blue_pulsed    ss_dg_missiles 2 108 #f 0)
(kern-mk-sprite 's_magic_field_white_pulsed   ss_dg_missiles 2 110 #f 0)
(kern-mk-sprite 's_magic_field_purple_pulsed  ss_dg_missiles 2 112 #f 0)
(kern-mk-sprite 's_magic_field_brown_pulsed   ss_dg_missiles 2 114 #f 0)
(kern-mk-sprite 's_magic_field_blue_2_pulsed  ss_dg_missiles 2 116 #f 0)
                                        ; (Tiles 118,119 blank)
;; Chromatic ball lightning (8 frames):
(kern-mk-sprite 's_magic_field_chromatic_pulsed  ss_dg_missiles 8 120 #f 0)
;; Lightning discharges:
(kern-mk-sprite 's_lightning_discharge_red       ss_dg_missiles 4 128 #f 0)
(kern-mk-sprite 's_lightning_discharge_green     ss_dg_missiles 4 132 #f 0)
(kern-mk-sprite 's_lightning_discharge_blue      ss_dg_missiles 4 136 #f 0)
(kern-mk-sprite 's_lightning_discharge_black     ss_dg_missiles 4 140 #f 0)
;; Lightning discharges in cloud:
(kern-mk-sprite 's_lightning_cloud_blue_red      ss_dg_missiles 4 144 #f 0)
(kern-mk-sprite 's_lightning_cloud_blue_green    ss_dg_missiles 4 148 #f 0)
(kern-mk-sprite 's_lightning_cloud_blue_blue     ss_dg_missiles 4 152 #f 0)
                                        ; (Tiles 156..159 blank)
(kern-mk-sprite 's_lightning_cloud_blue_purple   ss_dg_missiles 4 160 #f 0)
(kern-mk-sprite 's_lightning_cloud_blue_yellow   ss_dg_missiles 4 164 #f 0)
(kern-mk-sprite 's_lightning_cloud_blue_orange   ss_dg_missiles 4 168 #f 0)
                                        ; (Tiles 172..175 blank)
;; Magical spheres:
(kern-mk-sprite 's_magic_sphere_red              ss_dg_missiles 2 176 #f 0)
(kern-mk-sprite 's_magic_sphere_green            ss_dg_missiles 2 178 #f 0)
(kern-mk-sprite 's_magic_sphere_blue             ss_dg_missiles 2 180 #f 0)
(kern-mk-sprite 's_magic_sphere_yellow           ss_dg_missiles 2 182 #f 0)
(kern-mk-sprite 's_magic_sphere_purple           ss_dg_missiles 2 184 #f 0)
(kern-mk-sprite 's_magic_sphere_cyan             ss_dg_missiles 2 186 #f 0)
                                        ; (Tiles 188..191 blank)
;; Magical spheres with light rays:
(kern-mk-sprite 's_magic_sphere_rays_red         ss_dg_missiles 2 192 #f 0)
(kern-mk-sprite 's_magic_sphere_rays_green       ss_dg_missiles 2 194 #f 0)
(kern-mk-sprite 's_magic_sphere_rays_blue        ss_dg_missiles 2 196 #f 0)
(kern-mk-sprite 's_magic_sphere_rays_yellow      ss_dg_missiles 2 198 #f 0)
(kern-mk-sprite 's_magic_sphere_rays_purple      ss_dg_missiles 2 200 #f 0)
(kern-mk-sprite 's_magic_sphere_rays_cyan        ss_dg_missiles 2 202 #f 0)
                                        ; (Tiles 204..207 blank)
;; Arrows and Bolts and such in flight:
(kern-mk-sprite 's_arrow_wood_red                ss_dg_missiles 8 208 #f 0) ;; 511
(kern-mk-sprite 's_arrow_metal_red               ss_dg_missiles 8 216 #f 0)
(kern-mk-sprite 's_arrow_wood_green              ss_dg_missiles 8 224 #f 0)
(kern-mk-sprite 's_arrow_metal_green             ss_dg_missiles 8 232 #f 0)


;; ss_dg_tools            16 x 16


;; ss_dg_commodities (food, drink, mushrooms, coins, gems, ...)
(kern-mk-sprite 's_food_biscuit                  ss_dg_commodities 1 0 #f 0)
(kern-mk-sprite 's_food_bread                    ss_dg_commodities 1 1 #f 0)
(kern-mk-sprite 's_food_dried_meat               ss_dg_commodities 1 2 #f 0)
(kern-mk-sprite 's_food_ham                      ss_dg_commodities 1 3 #f 0)
(kern-mk-sprite 's_food_chicken_leg              ss_dg_commodities 1 4 #f 0)
(kern-mk-sprite 's_food_rancid_meat              ss_dg_commodities 1 5 #f 0)

(kern-mk-sprite 's_drink_jug_of_ale              ss_dg_commodities 1 16 #f 0)
(kern-mk-sprite 's_drink_glass_of_ale            ss_dg_commodities 1 17 #f 0)
(kern-mk-sprite 's_drink_bottle_red              ss_dg_commodities 1 18 #f 0)

(kern-mk-sprite 's_mushroom_black                ss_dg_commodities 1 32 #f 0)
(kern-mk-sprite 's_mushroom_white                ss_dg_commodities 1 33 #f 0)
(kern-mk-sprite 's_mushroom_grey                 ss_dg_commodities 1 34 #f 0)
(kern-mk-sprite 's_mushroom_orange               ss_dg_commodities 1 35 #f 0)
(kern-mk-sprite 's_mushroom_red                  ss_dg_commodities 1 36 #f 0)
(kern-mk-sprite 's_mushroom_green                ss_dg_commodities 1 37 #f 0)
(kern-mk-sprite 's_mushroom_blue                 ss_dg_commodities 1 38 #f 0)
(kern-mk-sprite 's_mushroom_brown                ss_dg_commodities 1 39 #f 0)
(kern-mk-sprite 's_mushroom_two_dark_grey        ss_dg_commodities 1 40 #f 0)
(kern-mk-sprite 's_mushroom_white_2              ss_dg_commodities 1 41 #f 0)
(kern-mk-sprite 's_mushroom_pink                 ss_dg_commodities 1 42 #f 0)
(kern-mk-sprite 's_mushroom_two_yellow           ss_dg_commodities 1 43 #f 0)
(kern-mk-sprite 's_mushroom_tan_orange           ss_dg_commodities 1 44 #f 0)
(kern-mk-sprite 's_mushroom_two_green            ss_dg_commodities 1 45 #f 0)
(kern-mk-sprite 's_mushroom_light_blue           ss_dg_commodities 1 46 #f 0)
(kern-mk-sprite 's_mushroom_light_brown          ss_dg_commodities 1 47 #f 0)

(kern-mk-sprite 's_mushroom_cluster_grey         ss_dg_commodities 1 48 #f 0)
(kern-mk-sprite 's_mushroom_cluster_green        ss_dg_commodities 1 49 #f 0)
(kern-mk-sprite 's_mushroom_cluster_yellow       ss_dg_commodities 1 50 #f 0)
(kern-mk-sprite 's_mushroom_cluster_polkadot     ss_dg_commodities 1 51 #f 0)
(kern-mk-sprite 's_mushroom_cluster_purple       ss_dg_commodities 1 52 #f 0)
(kern-mk-sprite 's_mushroom_cluster_dark_grey    ss_dg_commodities 1 53 #f 0)
(kern-mk-sprite 's_mushroom_cluster_green_glow   ss_dg_commodities 3 54 #f 0)

(kern-mk-sprite 's_coins_copper                  ss_dg_commodities 1 144 #f 0)
(kern-mk-sprite 's_coins_silver                  ss_dg_commodities 1 145 #f 0)
(kern-mk-sprite 's_coins_gold                    ss_dg_commodities 1 146 #f 0)
(kern-mk-sprite 's_coins_light_blue              ss_dg_commodities 1 147 #f 0)
(kern-mk-sprite 's_coins_blue_grey               ss_dg_commodities 1 148 #f 0)

(kern-mk-sprite 's_crystals_green                ss_dg_commodities 1 149 #f 0)
(kern-mk-sprite 's_crystals_blue                 ss_dg_commodities 1 150 #f 0)
(kern-mk-sprite 's_crystals_purple               ss_dg_commodities 1 151 #f 0)

(kern-mk-sprite 's_gems_red                      ss_dg_commodities 1 152 #f 0)
(kern-mk-sprite 's_gems_pale_blue                ss_dg_commodities 1 153 #f 0)
(kern-mk-sprite 's_gems_small_round              ss_dg_commodities 1 154 #f 0)

;; ss_dg_potions          16 x 7
;; ss_dg_readable         16 x 16

;; eof
